# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'CustomResourceColumnDefinition',
    'CustomResourceColumnDefinitionPatch',
    'CustomResourceConversion',
    'CustomResourceConversionPatch',
    'CustomResourceDefinition',
    'CustomResourceDefinitionCondition',
    'CustomResourceDefinitionConditionPatch',
    'CustomResourceDefinitionNames',
    'CustomResourceDefinitionNamesPatch',
    'CustomResourceDefinitionSpec',
    'CustomResourceDefinitionSpecPatch',
    'CustomResourceDefinitionStatus',
    'CustomResourceDefinitionStatusPatch',
    'CustomResourceDefinitionVersion',
    'CustomResourceDefinitionVersionPatch',
    'CustomResourceSubresourceScale',
    'CustomResourceSubresourceScalePatch',
    'CustomResourceSubresources',
    'CustomResourceSubresourcesPatch',
    'CustomResourceValidation',
    'CustomResourceValidationPatch',
    'ExternalDocumentation',
    'ExternalDocumentationPatch',
    'JSONSchemaProps',
    'JSONSchemaPropsPatch',
    'SelectableField',
    'SelectableFieldPatch',
    'ServiceReference',
    'ServiceReferencePatch',
    'ValidationRule',
    'ValidationRulePatch',
    'WebhookClientConfig',
    'WebhookClientConfigPatch',
    'WebhookConversion',
    'WebhookConversionPatch',
]

@pulumi.output_type
class CustomResourceColumnDefinition(dict):
    """
    CustomResourceColumnDefinition specifies a column for server side printing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceColumnDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceColumnDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceColumnDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_path: str,
                 name: str,
                 type: str,
                 description: Optional[str] = None,
                 format: Optional[str] = None,
                 priority: Optional[int] = None):
        """
        CustomResourceColumnDefinition specifies a column for server side printing.
        :param str json_path: jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
        :param str name: name is a human readable name for the column.
        :param str type: type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        :param str description: description is a human readable description of this column.
        :param str format: format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        :param int priority: priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.
        """
        pulumi.set(__self__, "json_path", json_path)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> str:
        """
        jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
        """
        return pulumi.get(self, "json_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name is a human readable name for the column.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        description is a human readable description of this column.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class CustomResourceColumnDefinitionPatch(dict):
    """
    CustomResourceColumnDefinition specifies a column for server side printing.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceColumnDefinitionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceColumnDefinitionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceColumnDefinitionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 format: Optional[str] = None,
                 json_path: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 type: Optional[str] = None):
        """
        CustomResourceColumnDefinition specifies a column for server side printing.
        :param str description: description is a human readable description of this column.
        :param str format: format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        :param str json_path: jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
        :param str name: name is a human readable name for the column.
        :param int priority: priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.
        :param str type: type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if json_path is not None:
            pulumi.set(__self__, "json_path", json_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        description is a human readable description of this column.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> Optional[str]:
        """
        jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.
        """
        return pulumi.get(self, "json_path")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name is a human readable name for the column.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomResourceConversion(dict):
    """
    CustomResourceConversion describes how to convert different versions of a CR.
    """
    def __init__(__self__, *,
                 strategy: str,
                 webhook: Optional['outputs.WebhookConversion'] = None):
        """
        CustomResourceConversion describes how to convert different versions of a CR.
        :param str strategy: strategy specifies how custom resources are converted between versions. Allowed values are: - `"None"`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `"Webhook"`: API Server will call to an external webhook to do the conversion. Additional information
                 is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.
        :param 'WebhookConversionArgs' webhook: webhook describes how to call the conversion webhook. Required when `strategy` is set to `"Webhook"`.
        """
        pulumi.set(__self__, "strategy", strategy)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter
    def strategy(self) -> str:
        """
        strategy specifies how custom resources are converted between versions. Allowed values are: - `"None"`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `"Webhook"`: API Server will call to an external webhook to do the conversion. Additional information
          is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def webhook(self) -> Optional['outputs.WebhookConversion']:
        """
        webhook describes how to call the conversion webhook. Required when `strategy` is set to `"Webhook"`.
        """
        return pulumi.get(self, "webhook")


@pulumi.output_type
class CustomResourceConversionPatch(dict):
    """
    CustomResourceConversion describes how to convert different versions of a CR.
    """
    def __init__(__self__, *,
                 strategy: Optional[str] = None,
                 webhook: Optional['outputs.WebhookConversionPatch'] = None):
        """
        CustomResourceConversion describes how to convert different versions of a CR.
        :param str strategy: strategy specifies how custom resources are converted between versions. Allowed values are: - `"None"`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `"Webhook"`: API Server will call to an external webhook to do the conversion. Additional information
                 is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.
        :param 'WebhookConversionPatchArgs' webhook: webhook describes how to call the conversion webhook. Required when `strategy` is set to `"Webhook"`.
        """
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[str]:
        """
        strategy specifies how custom resources are converted between versions. Allowed values are: - `"None"`: The converter only change the apiVersion and would not touch any other field in the custom resource. - `"Webhook"`: API Server will call to an external webhook to do the conversion. Additional information
          is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def webhook(self) -> Optional['outputs.WebhookConversionPatch']:
        """
        webhook describes how to call the conversion webhook. Required when `strategy` is set to `"Webhook"`.
        """
        return pulumi.get(self, "webhook")


@pulumi.output_type
class CustomResourceDefinition(dict):
    """
    CustomResourceDefinition represents a resource that should be exposed on the API server.  Its name MUST be in the format <.spec.name>.<.spec.group>.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.CustomResourceDefinitionSpec',
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 status: Optional['outputs.CustomResourceDefinitionStatus'] = None):
        """
        CustomResourceDefinition represents a resource that should be exposed on the API server.  Its name MUST be in the format <.spec.name>.<.spec.group>.
        :param 'CustomResourceDefinitionSpecArgs' spec: spec describes how the user wants the resources to appear
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'CustomResourceDefinitionStatusArgs' status: status indicates the actual state of the CustomResourceDefinition
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'apiextensions.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'CustomResourceDefinition')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.CustomResourceDefinitionSpec':
        """
        spec describes how the user wants the resources to appear
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.CustomResourceDefinitionStatus']:
        """
        status indicates the actual state of the CustomResourceDefinition
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class CustomResourceDefinitionCondition(dict):
    """
    CustomResourceDefinitionCondition contains details for the current condition of this pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: str,
                 type: str,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        CustomResourceDefinitionCondition contains details for the current condition of this pod.
        :param str status: status is the status of the condition. Can be True, False, Unknown.
        :param str type: type is the type of the condition. Types include Established, NamesAccepted and Terminating.
        :param str last_transition_time: lastTransitionTime last time the condition transitioned from one status to another.
        :param str message: message is a human-readable message indicating details about last transition.
        :param str reason: reason is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        status is the status of the condition. Can be True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        type is the type of the condition. Types include Established, NamesAccepted and Terminating.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        lastTransitionTime last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        message is a human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        reason is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class CustomResourceDefinitionConditionPatch(dict):
    """
    CustomResourceDefinitionCondition contains details for the current condition of this pod.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionConditionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionConditionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionConditionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: Optional[str] = None,
                 message: Optional[str] = None,
                 reason: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        CustomResourceDefinitionCondition contains details for the current condition of this pod.
        :param str last_transition_time: lastTransitionTime last time the condition transitioned from one status to another.
        :param str message: message is a human-readable message indicating details about last transition.
        :param str reason: reason is a unique, one-word, CamelCase reason for the condition's last transition.
        :param str status: status is the status of the condition. Can be True, False, Unknown.
        :param str type: type is the type of the condition. Types include Established, NamesAccepted and Terminating.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[str]:
        """
        lastTransitionTime last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        message is a human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        reason is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        status is the status of the condition. Can be True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        type is the type of the condition. Types include Established, NamesAccepted and Terminating.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class CustomResourceDefinitionNames(dict):
    """
    CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listKind":
            suggest = "list_kind"
        elif key == "shortNames":
            suggest = "short_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionNames. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionNames.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionNames.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 plural: str,
                 categories: Optional[Sequence[str]] = None,
                 list_kind: Optional[str] = None,
                 short_names: Optional[Sequence[str]] = None,
                 singular: Optional[str] = None):
        """
        CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
        :param str kind: kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
        :param str plural: plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
        :param Sequence[str] categories: categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
        :param str list_kind: listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
        :param Sequence[str] short_names: shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`. It must be all lowercase.
        :param str singular: singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "plural", plural)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if list_kind is not None:
            pulumi.set(__self__, "list_kind", list_kind)
        if short_names is not None:
            pulumi.set(__self__, "short_names", short_names)
        if singular is not None:
            pulumi.set(__self__, "singular", singular)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def plural(self) -> str:
        """
        plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
        """
        return pulumi.get(self, "plural")

    @property
    @pulumi.getter
    def categories(self) -> Optional[Sequence[str]]:
        """
        categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="listKind")
    def list_kind(self) -> Optional[str]:
        """
        listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
        """
        return pulumi.get(self, "list_kind")

    @property
    @pulumi.getter(name="shortNames")
    def short_names(self) -> Optional[Sequence[str]]:
        """
        shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`. It must be all lowercase.
        """
        return pulumi.get(self, "short_names")

    @property
    @pulumi.getter
    def singular(self) -> Optional[str]:
        """
        singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`.
        """
        return pulumi.get(self, "singular")


@pulumi.output_type
class CustomResourceDefinitionNamesPatch(dict):
    """
    CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listKind":
            suggest = "list_kind"
        elif key == "shortNames":
            suggest = "short_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionNamesPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionNamesPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionNamesPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categories: Optional[Sequence[str]] = None,
                 kind: Optional[str] = None,
                 list_kind: Optional[str] = None,
                 plural: Optional[str] = None,
                 short_names: Optional[Sequence[str]] = None,
                 singular: Optional[str] = None):
        """
        CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
        :param Sequence[str] categories: categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
        :param str kind: kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
        :param str list_kind: listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
        :param str plural: plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
        :param Sequence[str] short_names: shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`. It must be all lowercase.
        :param str singular: singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if list_kind is not None:
            pulumi.set(__self__, "list_kind", list_kind)
        if plural is not None:
            pulumi.set(__self__, "plural", plural)
        if short_names is not None:
            pulumi.set(__self__, "short_names", short_names)
        if singular is not None:
            pulumi.set(__self__, "singular", singular)

    @property
    @pulumi.getter
    def categories(self) -> Optional[Sequence[str]]:
        """
        categories is a list of grouped resources this custom resource belongs to (e.g. 'all'). This is published in API discovery documents, and used by clients to support invocations like `kubectl get all`.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        kind is the serialized kind of the resource. It is normally CamelCase and singular. Custom resource instances will use this value as the `kind` attribute in API calls.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="listKind")
    def list_kind(self) -> Optional[str]:
        """
        listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
        """
        return pulumi.get(self, "list_kind")

    @property
    @pulumi.getter
    def plural(self) -> Optional[str]:
        """
        plural is the plural name of the resource to serve. The custom resources are served under `/apis/<group>/<version>/.../<plural>`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`). Must be all lowercase.
        """
        return pulumi.get(self, "plural")

    @property
    @pulumi.getter(name="shortNames")
    def short_names(self) -> Optional[Sequence[str]]:
        """
        shortNames are short names for the resource, exposed in API discovery documents, and used by clients to support invocations like `kubectl get <shortname>`. It must be all lowercase.
        """
        return pulumi.get(self, "short_names")

    @property
    @pulumi.getter
    def singular(self) -> Optional[str]:
        """
        singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`.
        """
        return pulumi.get(self, "singular")


@pulumi.output_type
class CustomResourceDefinitionSpec(dict):
    """
    CustomResourceDefinitionSpec describes how a user wants their resource to appear
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preserveUnknownFields":
            suggest = "preserve_unknown_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group: str,
                 names: 'outputs.CustomResourceDefinitionNames',
                 scope: str,
                 versions: Sequence['outputs.CustomResourceDefinitionVersion'],
                 conversion: Optional['outputs.CustomResourceConversion'] = None,
                 preserve_unknown_fields: Optional[bool] = None):
        """
        CustomResourceDefinitionSpec describes how a user wants their resource to appear
        :param str group: group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
        :param 'CustomResourceDefinitionNamesArgs' names: names specify the resource and kind names for the custom resource.
        :param str scope: scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`.
        :param Sequence['CustomResourceDefinitionVersionArgs'] versions: versions is the list of all API versions of the defined custom resource. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        :param 'CustomResourceConversionArgs' conversion: conversion defines conversion settings for the CRD.
        :param bool preserve_unknown_fields: preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting `x-preserve-unknown-fields` to true in `spec.versions[*].schema.openAPIV3Schema`. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning for details.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "names", names)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "versions", versions)
        if conversion is not None:
            pulumi.set(__self__, "conversion", conversion)
        if preserve_unknown_fields is not None:
            pulumi.set(__self__, "preserve_unknown_fields", preserve_unknown_fields)

    @property
    @pulumi.getter
    def group(self) -> str:
        """
        group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def names(self) -> 'outputs.CustomResourceDefinitionNames':
        """
        names specify the resource and kind names for the custom resource.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.CustomResourceDefinitionVersion']:
        """
        versions is the list of all API versions of the defined custom resource. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        """
        return pulumi.get(self, "versions")

    @property
    @pulumi.getter
    def conversion(self) -> Optional['outputs.CustomResourceConversion']:
        """
        conversion defines conversion settings for the CRD.
        """
        return pulumi.get(self, "conversion")

    @property
    @pulumi.getter(name="preserveUnknownFields")
    def preserve_unknown_fields(self) -> Optional[bool]:
        """
        preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting `x-preserve-unknown-fields` to true in `spec.versions[*].schema.openAPIV3Schema`. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning for details.
        """
        return pulumi.get(self, "preserve_unknown_fields")


@pulumi.output_type
class CustomResourceDefinitionSpecPatch(dict):
    """
    CustomResourceDefinitionSpec describes how a user wants their resource to appear
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preserveUnknownFields":
            suggest = "preserve_unknown_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conversion: Optional['outputs.CustomResourceConversionPatch'] = None,
                 group: Optional[str] = None,
                 names: Optional['outputs.CustomResourceDefinitionNamesPatch'] = None,
                 preserve_unknown_fields: Optional[bool] = None,
                 scope: Optional[str] = None,
                 versions: Optional[Sequence['outputs.CustomResourceDefinitionVersionPatch']] = None):
        """
        CustomResourceDefinitionSpec describes how a user wants their resource to appear
        :param 'CustomResourceConversionPatchArgs' conversion: conversion defines conversion settings for the CRD.
        :param str group: group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
        :param 'CustomResourceDefinitionNamesPatchArgs' names: names specify the resource and kind names for the custom resource.
        :param bool preserve_unknown_fields: preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting `x-preserve-unknown-fields` to true in `spec.versions[*].schema.openAPIV3Schema`. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning for details.
        :param str scope: scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`.
        :param Sequence['CustomResourceDefinitionVersionPatchArgs'] versions: versions is the list of all API versions of the defined custom resource. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        """
        if conversion is not None:
            pulumi.set(__self__, "conversion", conversion)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if names is not None:
            pulumi.set(__self__, "names", names)
        if preserve_unknown_fields is not None:
            pulumi.set(__self__, "preserve_unknown_fields", preserve_unknown_fields)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter
    def conversion(self) -> Optional['outputs.CustomResourceConversionPatch']:
        """
        conversion defines conversion settings for the CRD.
        """
        return pulumi.get(self, "conversion")

    @property
    @pulumi.getter
    def group(self) -> Optional[str]:
        """
        group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def names(self) -> Optional['outputs.CustomResourceDefinitionNamesPatch']:
        """
        names specify the resource and kind names for the custom resource.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="preserveUnknownFields")
    def preserve_unknown_fields(self) -> Optional[bool]:
        """
        preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting `x-preserve-unknown-fields` to true in `spec.versions[*].schema.openAPIV3Schema`. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning for details.
        """
        return pulumi.get(self, "preserve_unknown_fields")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def versions(self) -> Optional[Sequence['outputs.CustomResourceDefinitionVersionPatch']]:
        """
        versions is the list of all API versions of the defined custom resource. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version), then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class CustomResourceDefinitionStatus(dict):
    """
    CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceptedNames":
            suggest = "accepted_names"
        elif key == "storedVersions":
            suggest = "stored_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accepted_names: 'outputs.CustomResourceDefinitionNames',
                 stored_versions: Sequence[str],
                 conditions: Optional[Sequence['outputs.CustomResourceDefinitionCondition']] = None):
        """
        CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
        :param 'CustomResourceDefinitionNamesArgs' accepted_names: acceptedNames are the names that are actually being used to serve discovery. They may be different than the names in spec.
        :param Sequence[str] stored_versions: storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions allows a migration path for stored versions in etcd. The field is mutable so a migration controller can finish a migration to another version (ensuring no old objects are left in storage), and then remove the rest of the versions from this list. Versions may not be removed from `spec.versions` while they exist in this list.
        :param Sequence['CustomResourceDefinitionConditionArgs'] conditions: conditions indicate state for particular aspects of a CustomResourceDefinition
        """
        pulumi.set(__self__, "accepted_names", accepted_names)
        pulumi.set(__self__, "stored_versions", stored_versions)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter(name="acceptedNames")
    def accepted_names(self) -> 'outputs.CustomResourceDefinitionNames':
        """
        acceptedNames are the names that are actually being used to serve discovery. They may be different than the names in spec.
        """
        return pulumi.get(self, "accepted_names")

    @property
    @pulumi.getter(name="storedVersions")
    def stored_versions(self) -> Sequence[str]:
        """
        storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions allows a migration path for stored versions in etcd. The field is mutable so a migration controller can finish a migration to another version (ensuring no old objects are left in storage), and then remove the rest of the versions from this list. Versions may not be removed from `spec.versions` while they exist in this list.
        """
        return pulumi.get(self, "stored_versions")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.CustomResourceDefinitionCondition']]:
        """
        conditions indicate state for particular aspects of a CustomResourceDefinition
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class CustomResourceDefinitionStatusPatch(dict):
    """
    CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceptedNames":
            suggest = "accepted_names"
        elif key == "storedVersions":
            suggest = "stored_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accepted_names: Optional['outputs.CustomResourceDefinitionNamesPatch'] = None,
                 conditions: Optional[Sequence['outputs.CustomResourceDefinitionConditionPatch']] = None,
                 stored_versions: Optional[Sequence[str]] = None):
        """
        CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
        :param 'CustomResourceDefinitionNamesPatchArgs' accepted_names: acceptedNames are the names that are actually being used to serve discovery. They may be different than the names in spec.
        :param Sequence['CustomResourceDefinitionConditionPatchArgs'] conditions: conditions indicate state for particular aspects of a CustomResourceDefinition
        :param Sequence[str] stored_versions: storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions allows a migration path for stored versions in etcd. The field is mutable so a migration controller can finish a migration to another version (ensuring no old objects are left in storage), and then remove the rest of the versions from this list. Versions may not be removed from `spec.versions` while they exist in this list.
        """
        if accepted_names is not None:
            pulumi.set(__self__, "accepted_names", accepted_names)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if stored_versions is not None:
            pulumi.set(__self__, "stored_versions", stored_versions)

    @property
    @pulumi.getter(name="acceptedNames")
    def accepted_names(self) -> Optional['outputs.CustomResourceDefinitionNamesPatch']:
        """
        acceptedNames are the names that are actually being used to serve discovery. They may be different than the names in spec.
        """
        return pulumi.get(self, "accepted_names")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['outputs.CustomResourceDefinitionConditionPatch']]:
        """
        conditions indicate state for particular aspects of a CustomResourceDefinition
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="storedVersions")
    def stored_versions(self) -> Optional[Sequence[str]]:
        """
        storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions allows a migration path for stored versions in etcd. The field is mutable so a migration controller can finish a migration to another version (ensuring no old objects are left in storage), and then remove the rest of the versions from this list. Versions may not be removed from `spec.versions` while they exist in this list.
        """
        return pulumi.get(self, "stored_versions")


@pulumi.output_type
class CustomResourceDefinitionVersion(dict):
    """
    CustomResourceDefinitionVersion describes a version for CRD.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalPrinterColumns":
            suggest = "additional_printer_columns"
        elif key == "deprecationWarning":
            suggest = "deprecation_warning"
        elif key == "selectableFields":
            suggest = "selectable_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 served: bool,
                 storage: bool,
                 additional_printer_columns: Optional[Sequence['outputs.CustomResourceColumnDefinition']] = None,
                 deprecated: Optional[bool] = None,
                 deprecation_warning: Optional[str] = None,
                 schema: Optional['outputs.CustomResourceValidation'] = None,
                 selectable_fields: Optional[Sequence['outputs.SelectableField']] = None,
                 subresources: Optional['outputs.CustomResourceSubresources'] = None):
        """
        CustomResourceDefinitionVersion describes a version for CRD.
        :param str name: name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
        :param bool served: served is a flag enabling/disabling this version from being served via REST APIs
        :param bool storage: storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
        :param Sequence['CustomResourceColumnDefinitionArgs'] additional_printer_columns: additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.
        :param bool deprecated: deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
        :param str deprecation_warning: deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
        :param 'CustomResourceValidationArgs' schema: schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.
        :param Sequence['SelectableFieldArgs'] selectable_fields: selectableFields specifies paths to fields that may be used as field selectors. A maximum of 8 selectable fields are allowed. See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors
        :param 'CustomResourceSubresourcesArgs' subresources: subresources specify what subresources this version of the defined custom resource have.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "served", served)
        pulumi.set(__self__, "storage", storage)
        if additional_printer_columns is not None:
            pulumi.set(__self__, "additional_printer_columns", additional_printer_columns)
        if deprecated is not None:
            pulumi.set(__self__, "deprecated", deprecated)
        if deprecation_warning is not None:
            pulumi.set(__self__, "deprecation_warning", deprecation_warning)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if selectable_fields is not None:
            pulumi.set(__self__, "selectable_fields", selectable_fields)
        if subresources is not None:
            pulumi.set(__self__, "subresources", subresources)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def served(self) -> bool:
        """
        served is a flag enabling/disabling this version from being served via REST APIs
        """
        return pulumi.get(self, "served")

    @property
    @pulumi.getter
    def storage(self) -> bool:
        """
        storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter(name="additionalPrinterColumns")
    def additional_printer_columns(self) -> Optional[Sequence['outputs.CustomResourceColumnDefinition']]:
        """
        additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.
        """
        return pulumi.get(self, "additional_printer_columns")

    @property
    @pulumi.getter
    def deprecated(self) -> Optional[bool]:
        """
        deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
        """
        return pulumi.get(self, "deprecated")

    @property
    @pulumi.getter(name="deprecationWarning")
    def deprecation_warning(self) -> Optional[str]:
        """
        deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
        """
        return pulumi.get(self, "deprecation_warning")

    @property
    @pulumi.getter
    def schema(self) -> Optional['outputs.CustomResourceValidation']:
        """
        schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="selectableFields")
    def selectable_fields(self) -> Optional[Sequence['outputs.SelectableField']]:
        """
        selectableFields specifies paths to fields that may be used as field selectors. A maximum of 8 selectable fields are allowed. See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors
        """
        return pulumi.get(self, "selectable_fields")

    @property
    @pulumi.getter
    def subresources(self) -> Optional['outputs.CustomResourceSubresources']:
        """
        subresources specify what subresources this version of the defined custom resource have.
        """
        return pulumi.get(self, "subresources")


@pulumi.output_type
class CustomResourceDefinitionVersionPatch(dict):
    """
    CustomResourceDefinitionVersion describes a version for CRD.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalPrinterColumns":
            suggest = "additional_printer_columns"
        elif key == "deprecationWarning":
            suggest = "deprecation_warning"
        elif key == "selectableFields":
            suggest = "selectable_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceDefinitionVersionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceDefinitionVersionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceDefinitionVersionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_printer_columns: Optional[Sequence['outputs.CustomResourceColumnDefinitionPatch']] = None,
                 deprecated: Optional[bool] = None,
                 deprecation_warning: Optional[str] = None,
                 name: Optional[str] = None,
                 schema: Optional['outputs.CustomResourceValidationPatch'] = None,
                 selectable_fields: Optional[Sequence['outputs.SelectableFieldPatch']] = None,
                 served: Optional[bool] = None,
                 storage: Optional[bool] = None,
                 subresources: Optional['outputs.CustomResourceSubresourcesPatch'] = None):
        """
        CustomResourceDefinitionVersion describes a version for CRD.
        :param Sequence['CustomResourceColumnDefinitionPatchArgs'] additional_printer_columns: additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.
        :param bool deprecated: deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
        :param str deprecation_warning: deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
        :param str name: name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
        :param 'CustomResourceValidationPatchArgs' schema: schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.
        :param Sequence['SelectableFieldPatchArgs'] selectable_fields: selectableFields specifies paths to fields that may be used as field selectors. A maximum of 8 selectable fields are allowed. See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors
        :param bool served: served is a flag enabling/disabling this version from being served via REST APIs
        :param bool storage: storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
        :param 'CustomResourceSubresourcesPatchArgs' subresources: subresources specify what subresources this version of the defined custom resource have.
        """
        if additional_printer_columns is not None:
            pulumi.set(__self__, "additional_printer_columns", additional_printer_columns)
        if deprecated is not None:
            pulumi.set(__self__, "deprecated", deprecated)
        if deprecation_warning is not None:
            pulumi.set(__self__, "deprecation_warning", deprecation_warning)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if selectable_fields is not None:
            pulumi.set(__self__, "selectable_fields", selectable_fields)
        if served is not None:
            pulumi.set(__self__, "served", served)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if subresources is not None:
            pulumi.set(__self__, "subresources", subresources)

    @property
    @pulumi.getter(name="additionalPrinterColumns")
    def additional_printer_columns(self) -> Optional[Sequence['outputs.CustomResourceColumnDefinitionPatch']]:
        """
        additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.
        """
        return pulumi.get(self, "additional_printer_columns")

    @property
    @pulumi.getter
    def deprecated(self) -> Optional[bool]:
        """
        deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.
        """
        return pulumi.get(self, "deprecated")

    @property
    @pulumi.getter(name="deprecationWarning")
    def deprecation_warning(self) -> Optional[str]:
        """
        deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.
        """
        return pulumi.get(self, "deprecation_warning")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name is the version name, e.g. “v1”, “v2beta1”, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> Optional['outputs.CustomResourceValidationPatch']:
        """
        schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="selectableFields")
    def selectable_fields(self) -> Optional[Sequence['outputs.SelectableFieldPatch']]:
        """
        selectableFields specifies paths to fields that may be used as field selectors. A maximum of 8 selectable fields are allowed. See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors
        """
        return pulumi.get(self, "selectable_fields")

    @property
    @pulumi.getter
    def served(self) -> Optional[bool]:
        """
        served is a flag enabling/disabling this version from being served via REST APIs
        """
        return pulumi.get(self, "served")

    @property
    @pulumi.getter
    def storage(self) -> Optional[bool]:
        """
        storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter
    def subresources(self) -> Optional['outputs.CustomResourceSubresourcesPatch']:
        """
        subresources specify what subresources this version of the defined custom resource have.
        """
        return pulumi.get(self, "subresources")


@pulumi.output_type
class CustomResourceSubresourceScale(dict):
    """
    CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "specReplicasPath":
            suggest = "spec_replicas_path"
        elif key == "statusReplicasPath":
            suggest = "status_replicas_path"
        elif key == "labelSelectorPath":
            suggest = "label_selector_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceSubresourceScale. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceSubresourceScale.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceSubresourceScale.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec_replicas_path: str,
                 status_replicas_path: str,
                 label_selector_path: Optional[str] = None):
        """
        CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
        :param str spec_replicas_path: specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
        :param str status_replicas_path: statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.
        :param str label_selector_path: labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.
        """
        pulumi.set(__self__, "spec_replicas_path", spec_replicas_path)
        pulumi.set(__self__, "status_replicas_path", status_replicas_path)
        if label_selector_path is not None:
            pulumi.set(__self__, "label_selector_path", label_selector_path)

    @property
    @pulumi.getter(name="specReplicasPath")
    def spec_replicas_path(self) -> str:
        """
        specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
        """
        return pulumi.get(self, "spec_replicas_path")

    @property
    @pulumi.getter(name="statusReplicasPath")
    def status_replicas_path(self) -> str:
        """
        statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.
        """
        return pulumi.get(self, "status_replicas_path")

    @property
    @pulumi.getter(name="labelSelectorPath")
    def label_selector_path(self) -> Optional[str]:
        """
        labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.
        """
        return pulumi.get(self, "label_selector_path")


@pulumi.output_type
class CustomResourceSubresourceScalePatch(dict):
    """
    CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelSelectorPath":
            suggest = "label_selector_path"
        elif key == "specReplicasPath":
            suggest = "spec_replicas_path"
        elif key == "statusReplicasPath":
            suggest = "status_replicas_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceSubresourceScalePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceSubresourceScalePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceSubresourceScalePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_selector_path: Optional[str] = None,
                 spec_replicas_path: Optional[str] = None,
                 status_replicas_path: Optional[str] = None):
        """
        CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
        :param str label_selector_path: labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.
        :param str spec_replicas_path: specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
        :param str status_replicas_path: statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.
        """
        if label_selector_path is not None:
            pulumi.set(__self__, "label_selector_path", label_selector_path)
        if spec_replicas_path is not None:
            pulumi.set(__self__, "spec_replicas_path", spec_replicas_path)
        if status_replicas_path is not None:
            pulumi.set(__self__, "status_replicas_path", status_replicas_path)

    @property
    @pulumi.getter(name="labelSelectorPath")
    def label_selector_path(self) -> Optional[str]:
        """
        labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.
        """
        return pulumi.get(self, "label_selector_path")

    @property
    @pulumi.getter(name="specReplicasPath")
    def spec_replicas_path(self) -> Optional[str]:
        """
        specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
        """
        return pulumi.get(self, "spec_replicas_path")

    @property
    @pulumi.getter(name="statusReplicasPath")
    def status_replicas_path(self) -> Optional[str]:
        """
        statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.
        """
        return pulumi.get(self, "status_replicas_path")


@pulumi.output_type
class CustomResourceSubresources(dict):
    """
    CustomResourceSubresources defines the status and scale subresources for CustomResources.
    """
    def __init__(__self__, *,
                 scale: Optional['outputs.CustomResourceSubresourceScale'] = None,
                 status: Optional[Any] = None):
        """
        CustomResourceSubresources defines the status and scale subresources for CustomResources.
        :param 'CustomResourceSubresourceScaleArgs' scale: scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
        :param Any status: status indicates the custom resource should serve a `/status` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
        """
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def scale(self) -> Optional['outputs.CustomResourceSubresourceScale']:
        """
        scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
        """
        return pulumi.get(self, "scale")

    @property
    @pulumi.getter
    def status(self) -> Optional[Any]:
        """
        status indicates the custom resource should serve a `/status` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class CustomResourceSubresourcesPatch(dict):
    """
    CustomResourceSubresources defines the status and scale subresources for CustomResources.
    """
    def __init__(__self__, *,
                 scale: Optional['outputs.CustomResourceSubresourceScalePatch'] = None,
                 status: Optional[Any] = None):
        """
        CustomResourceSubresources defines the status and scale subresources for CustomResources.
        :param 'CustomResourceSubresourceScalePatchArgs' scale: scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
        :param Any status: status indicates the custom resource should serve a `/status` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
        """
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def scale(self) -> Optional['outputs.CustomResourceSubresourceScalePatch']:
        """
        scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
        """
        return pulumi.get(self, "scale")

    @property
    @pulumi.getter
    def status(self) -> Optional[Any]:
        """
        status indicates the custom resource should serve a `/status` subresource. When enabled: 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object. 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class CustomResourceValidation(dict):
    """
    CustomResourceValidation is a list of validation methods for CustomResources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openAPIV3Schema":
            suggest = "open_apiv3_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceValidation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceValidation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceValidation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 open_apiv3_schema: Optional['outputs.JSONSchemaProps'] = None):
        """
        CustomResourceValidation is a list of validation methods for CustomResources.
        :param 'JSONSchemaPropsArgs' open_apiv3_schema: openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
        """
        if open_apiv3_schema is not None:
            pulumi.set(__self__, "open_apiv3_schema", open_apiv3_schema)

    @property
    @pulumi.getter(name="openAPIV3Schema")
    def open_apiv3_schema(self) -> Optional['outputs.JSONSchemaProps']:
        """
        openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
        """
        return pulumi.get(self, "open_apiv3_schema")


@pulumi.output_type
class CustomResourceValidationPatch(dict):
    """
    CustomResourceValidation is a list of validation methods for CustomResources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "openAPIV3Schema":
            suggest = "open_apiv3_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomResourceValidationPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomResourceValidationPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomResourceValidationPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 open_apiv3_schema: Optional['outputs.JSONSchemaPropsPatch'] = None):
        """
        CustomResourceValidation is a list of validation methods for CustomResources.
        :param 'JSONSchemaPropsPatchArgs' open_apiv3_schema: openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
        """
        if open_apiv3_schema is not None:
            pulumi.set(__self__, "open_apiv3_schema", open_apiv3_schema)

    @property
    @pulumi.getter(name="openAPIV3Schema")
    def open_apiv3_schema(self) -> Optional['outputs.JSONSchemaPropsPatch']:
        """
        openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
        """
        return pulumi.get(self, "open_apiv3_schema")


@pulumi.output_type
class ExternalDocumentation(dict):
    """
    ExternalDocumentation allows referencing an external resource for extended documentation.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 url: Optional[str] = None):
        """
        ExternalDocumentation allows referencing an external resource for extended documentation.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        return pulumi.get(self, "url")


@pulumi.output_type
class ExternalDocumentationPatch(dict):
    """
    ExternalDocumentation allows referencing an external resource for extended documentation.
    """
    def __init__(__self__, *,
                 description: Optional[str] = None,
                 url: Optional[str] = None):
        """
        ExternalDocumentation allows referencing an external resource for extended documentation.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        return pulumi.get(self, "url")


@pulumi.output_type
class JSONSchemaProps(dict):
    """
    JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "$ref":
            suggest = "_ref"
        elif key == "$schema":
            suggest = "_schema"
        elif key == "additionalItems":
            suggest = "additional_items"
        elif key == "additionalProperties":
            suggest = "additional_properties"
        elif key == "allOf":
            suggest = "all_of"
        elif key == "anyOf":
            suggest = "any_of"
        elif key == "exclusiveMaximum":
            suggest = "exclusive_maximum"
        elif key == "exclusiveMinimum":
            suggest = "exclusive_minimum"
        elif key == "externalDocs":
            suggest = "external_docs"
        elif key == "maxItems":
            suggest = "max_items"
        elif key == "maxLength":
            suggest = "max_length"
        elif key == "maxProperties":
            suggest = "max_properties"
        elif key == "minItems":
            suggest = "min_items"
        elif key == "minLength":
            suggest = "min_length"
        elif key == "minProperties":
            suggest = "min_properties"
        elif key == "multipleOf":
            suggest = "multiple_of"
        elif key == "not":
            suggest = "not_"
        elif key == "oneOf":
            suggest = "one_of"
        elif key == "patternProperties":
            suggest = "pattern_properties"
        elif key == "uniqueItems":
            suggest = "unique_items"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JSONSchemaProps. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JSONSchemaProps.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JSONSchemaProps.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 _ref: Optional[str] = None,
                 _schema: Optional[str] = None,
                 additional_items: Optional[Any] = None,
                 additional_properties: Optional[Any] = None,
                 all_of: Optional[Sequence['outputs.JSONSchemaProps']] = None,
                 any_of: Optional[Sequence['outputs.JSONSchemaProps']] = None,
                 default: Optional[Any] = None,
                 definitions: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 dependencies: Optional[Mapping[str, Any]] = None,
                 description: Optional[str] = None,
                 enum: Optional[Sequence[Any]] = None,
                 example: Optional[Any] = None,
                 exclusive_maximum: Optional[bool] = None,
                 exclusive_minimum: Optional[bool] = None,
                 external_docs: Optional['outputs.ExternalDocumentation'] = None,
                 format: Optional[str] = None,
                 id: Optional[str] = None,
                 items: Optional[Any] = None,
                 max_items: Optional[int] = None,
                 max_length: Optional[int] = None,
                 max_properties: Optional[int] = None,
                 maximum: Optional[float] = None,
                 min_items: Optional[int] = None,
                 min_length: Optional[int] = None,
                 min_properties: Optional[int] = None,
                 minimum: Optional[float] = None,
                 multiple_of: Optional[float] = None,
                 not_: Optional['outputs.JSONSchemaProps'] = None,
                 nullable: Optional[bool] = None,
                 one_of: Optional[Sequence['outputs.JSONSchemaProps']] = None,
                 pattern: Optional[str] = None,
                 pattern_properties: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 properties: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 required: Optional[Sequence[str]] = None,
                 title: Optional[str] = None,
                 type: Optional[str] = None,
                 unique_items: Optional[bool] = None,
                 x_kubernetes_embedded_resource: Optional[bool] = None,
                 x_kubernetes_int_or_string: Optional[bool] = None,
                 x_kubernetes_list_map_keys: Optional[Sequence[str]] = None,
                 x_kubernetes_list_type: Optional[str] = None,
                 x_kubernetes_map_type: Optional[str] = None,
                 x_kubernetes_preserve_unknown_fields: Optional[bool] = None,
                 x_kubernetes_validations: Optional[Sequence['outputs.ValidationRule']] = None):
        """
        JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
        :param Any default: default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.
        :param str format: format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:
               
               - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
        :param bool x_kubernetes_embedded_resource: x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
        :param bool x_kubernetes_int_or_string: x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:
               
               1) anyOf:
                  - type: integer
                  - type: string
               2) allOf:
                  - anyOf:
                    - type: integer
                    - type: string
                  - ... zero or more
        :param Sequence[str] x_kubernetes_list_map_keys: x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type `map` by specifying the keys used as the index of the map.
               
               This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).
               
               The properties specified must either be required or have a default value, to ensure those properties are present for all list items.
        :param str x_kubernetes_list_type: x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values:
               
               1) `atomic`: the list is treated as a single entity, like a scalar.
                    Atomic lists will be entirely replaced when updated. This extension
                    may be used on any type of list (struct, scalar, ...).
               2) `set`:
                    Sets are lists that must not have multiple items with the same value. Each
                    value must be a scalar, an object with x-kubernetes-map-type `atomic` or an
                    array with x-kubernetes-list-type `atomic`.
               3) `map`:
                    These lists are like maps in that their elements have a non-index key
                    used to identify them. Order is preserved upon merge. The map tag
                    must only be used on a list with elements of type object.
               Defaults to atomic for arrays.
        :param str x_kubernetes_map_type: x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values:
               
               1) `granular`:
                    These maps are actual maps (key-value pairs) and each fields are independent
                    from each other (they can each be manipulated by separate actors). This is
                    the default behaviour for all maps.
               2) `atomic`: the list is treated as a single entity, like a scalar.
                    Atomic maps will be entirely replaced when updated.
        :param bool x_kubernetes_preserve_unknown_fields: x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
        :param Sequence['ValidationRuleArgs'] x_kubernetes_validations: x-kubernetes-validations describes a list of validation rules written in the CEL expression language. This field is an alpha-level. Using this field requires the feature gate `CustomResourceValidationExpressions` to be enabled.
        """
        if _ref is not None:
            pulumi.set(__self__, "_ref", _ref)
        if _schema is not None:
            pulumi.set(__self__, "_schema", _schema)
        if additional_items is not None:
            pulumi.set(__self__, "additional_items", additional_items)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)
        if any_of is not None:
            pulumi.set(__self__, "any_of", any_of)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if definitions is not None:
            pulumi.set(__self__, "definitions", definitions)
        if dependencies is not None:
            pulumi.set(__self__, "dependencies", dependencies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum is not None:
            pulumi.set(__self__, "enum", enum)
        if example is not None:
            pulumi.set(__self__, "example", example)
        if exclusive_maximum is not None:
            pulumi.set(__self__, "exclusive_maximum", exclusive_maximum)
        if exclusive_minimum is not None:
            pulumi.set(__self__, "exclusive_minimum", exclusive_minimum)
        if external_docs is not None:
            pulumi.set(__self__, "external_docs", external_docs)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if max_items is not None:
            pulumi.set(__self__, "max_items", max_items)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_properties is not None:
            pulumi.set(__self__, "max_properties", max_properties)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_items is not None:
            pulumi.set(__self__, "min_items", min_items)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_properties is not None:
            pulumi.set(__self__, "min_properties", min_properties)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if multiple_of is not None:
            pulumi.set(__self__, "multiple_of", multiple_of)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if one_of is not None:
            pulumi.set(__self__, "one_of", one_of)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if pattern_properties is not None:
            pulumi.set(__self__, "pattern_properties", pattern_properties)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unique_items is not None:
            pulumi.set(__self__, "unique_items", unique_items)
        if x_kubernetes_embedded_resource is not None:
            pulumi.set(__self__, "x_kubernetes_embedded_resource", x_kubernetes_embedded_resource)
        if x_kubernetes_int_or_string is not None:
            pulumi.set(__self__, "x_kubernetes_int_or_string", x_kubernetes_int_or_string)
        if x_kubernetes_list_map_keys is not None:
            pulumi.set(__self__, "x_kubernetes_list_map_keys", x_kubernetes_list_map_keys)
        if x_kubernetes_list_type is not None:
            pulumi.set(__self__, "x_kubernetes_list_type", x_kubernetes_list_type)
        if x_kubernetes_map_type is not None:
            pulumi.set(__self__, "x_kubernetes_map_type", x_kubernetes_map_type)
        if x_kubernetes_preserve_unknown_fields is not None:
            pulumi.set(__self__, "x_kubernetes_preserve_unknown_fields", x_kubernetes_preserve_unknown_fields)
        if x_kubernetes_validations is not None:
            pulumi.set(__self__, "x_kubernetes_validations", x_kubernetes_validations)

    @property
    @pulumi.getter(name="$ref")
    def _ref(self) -> Optional[str]:
        return pulumi.get(self, "_ref")

    @property
    @pulumi.getter(name="$schema")
    def _schema(self) -> Optional[str]:
        return pulumi.get(self, "_schema")

    @property
    @pulumi.getter(name="additionalItems")
    def additional_items(self) -> Optional[Any]:
        return pulumi.get(self, "additional_items")

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[Any]:
        return pulumi.get(self, "additional_properties")

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[Sequence['outputs.JSONSchemaProps']]:
        return pulumi.get(self, "all_of")

    @property
    @pulumi.getter(name="anyOf")
    def any_of(self) -> Optional[Sequence['outputs.JSONSchemaProps']]:
        return pulumi.get(self, "any_of")

    @property
    @pulumi.getter
    def default(self) -> Optional[Any]:
        """
        default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def definitions(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "definitions")

    @property
    @pulumi.getter
    def dependencies(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "dependencies")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enum(self) -> Optional[Sequence[Any]]:
        return pulumi.get(self, "enum")

    @property
    @pulumi.getter
    def example(self) -> Optional[Any]:
        return pulumi.get(self, "example")

    @property
    @pulumi.getter(name="exclusiveMaximum")
    def exclusive_maximum(self) -> Optional[bool]:
        return pulumi.get(self, "exclusive_maximum")

    @property
    @pulumi.getter(name="exclusiveMinimum")
    def exclusive_minimum(self) -> Optional[bool]:
        return pulumi.get(self, "exclusive_minimum")

    @property
    @pulumi.getter(name="externalDocs")
    def external_docs(self) -> Optional['outputs.ExternalDocumentation']:
        return pulumi.get(self, "external_docs")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:

        - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Optional[Any]:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[int]:
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[int]:
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter(name="maxProperties")
    def max_properties(self) -> Optional[int]:
        return pulumi.get(self, "max_properties")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[float]:
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter(name="minItems")
    def min_items(self) -> Optional[int]:
        return pulumi.get(self, "min_items")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[int]:
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="minProperties")
    def min_properties(self) -> Optional[int]:
        return pulumi.get(self, "min_properties")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[float]:
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter(name="multipleOf")
    def multiple_of(self) -> Optional[float]:
        return pulumi.get(self, "multiple_of")

    @property
    @pulumi.getter(name="not")
    def not_(self) -> Optional['outputs.JSONSchemaProps']:
        return pulumi.get(self, "not_")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="oneOf")
    def one_of(self) -> Optional[Sequence['outputs.JSONSchemaProps']]:
        return pulumi.get(self, "one_of")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="patternProperties")
    def pattern_properties(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "pattern_properties")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def required(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uniqueItems")
    def unique_items(self) -> Optional[bool]:
        return pulumi.get(self, "unique_items")

    @property
    @pulumi.getter
    def x_kubernetes_embedded_resource(self) -> Optional[bool]:
        """
        x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
        """
        return pulumi.get(self, "x_kubernetes_embedded_resource")

    @property
    @pulumi.getter
    def x_kubernetes_int_or_string(self) -> Optional[bool]:
        """
        x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:

        1) anyOf:
           - type: integer
           - type: string
        2) allOf:
           - anyOf:
             - type: integer
             - type: string
           - ... zero or more
        """
        return pulumi.get(self, "x_kubernetes_int_or_string")

    @property
    @pulumi.getter
    def x_kubernetes_list_map_keys(self) -> Optional[Sequence[str]]:
        """
        x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type `map` by specifying the keys used as the index of the map.

        This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).

        The properties specified must either be required or have a default value, to ensure those properties are present for all list items.
        """
        return pulumi.get(self, "x_kubernetes_list_map_keys")

    @property
    @pulumi.getter
    def x_kubernetes_list_type(self) -> Optional[str]:
        """
        x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values:

        1) `atomic`: the list is treated as a single entity, like a scalar.
             Atomic lists will be entirely replaced when updated. This extension
             may be used on any type of list (struct, scalar, ...).
        2) `set`:
             Sets are lists that must not have multiple items with the same value. Each
             value must be a scalar, an object with x-kubernetes-map-type `atomic` or an
             array with x-kubernetes-list-type `atomic`.
        3) `map`:
             These lists are like maps in that their elements have a non-index key
             used to identify them. Order is preserved upon merge. The map tag
             must only be used on a list with elements of type object.
        Defaults to atomic for arrays.
        """
        return pulumi.get(self, "x_kubernetes_list_type")

    @property
    @pulumi.getter
    def x_kubernetes_map_type(self) -> Optional[str]:
        """
        x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values:

        1) `granular`:
             These maps are actual maps (key-value pairs) and each fields are independent
             from each other (they can each be manipulated by separate actors). This is
             the default behaviour for all maps.
        2) `atomic`: the list is treated as a single entity, like a scalar.
             Atomic maps will be entirely replaced when updated.
        """
        return pulumi.get(self, "x_kubernetes_map_type")

    @property
    @pulumi.getter
    def x_kubernetes_preserve_unknown_fields(self) -> Optional[bool]:
        """
        x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
        """
        return pulumi.get(self, "x_kubernetes_preserve_unknown_fields")

    @property
    @pulumi.getter
    def x_kubernetes_validations(self) -> Optional[Sequence['outputs.ValidationRule']]:
        """
        x-kubernetes-validations describes a list of validation rules written in the CEL expression language. This field is an alpha-level. Using this field requires the feature gate `CustomResourceValidationExpressions` to be enabled.
        """
        return pulumi.get(self, "x_kubernetes_validations")


@pulumi.output_type
class JSONSchemaPropsPatch(dict):
    """
    JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "$ref":
            suggest = "_ref"
        elif key == "$schema":
            suggest = "_schema"
        elif key == "additionalItems":
            suggest = "additional_items"
        elif key == "additionalProperties":
            suggest = "additional_properties"
        elif key == "allOf":
            suggest = "all_of"
        elif key == "anyOf":
            suggest = "any_of"
        elif key == "exclusiveMaximum":
            suggest = "exclusive_maximum"
        elif key == "exclusiveMinimum":
            suggest = "exclusive_minimum"
        elif key == "externalDocs":
            suggest = "external_docs"
        elif key == "maxItems":
            suggest = "max_items"
        elif key == "maxLength":
            suggest = "max_length"
        elif key == "maxProperties":
            suggest = "max_properties"
        elif key == "minItems":
            suggest = "min_items"
        elif key == "minLength":
            suggest = "min_length"
        elif key == "minProperties":
            suggest = "min_properties"
        elif key == "multipleOf":
            suggest = "multiple_of"
        elif key == "not":
            suggest = "not_"
        elif key == "oneOf":
            suggest = "one_of"
        elif key == "patternProperties":
            suggest = "pattern_properties"
        elif key == "uniqueItems":
            suggest = "unique_items"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JSONSchemaPropsPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JSONSchemaPropsPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JSONSchemaPropsPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 _ref: Optional[str] = None,
                 _schema: Optional[str] = None,
                 additional_items: Optional[Any] = None,
                 additional_properties: Optional[Any] = None,
                 all_of: Optional[Sequence['outputs.JSONSchemaPropsPatch']] = None,
                 any_of: Optional[Sequence['outputs.JSONSchemaPropsPatch']] = None,
                 default: Optional[Any] = None,
                 definitions: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 dependencies: Optional[Mapping[str, Any]] = None,
                 description: Optional[str] = None,
                 enum: Optional[Sequence[Any]] = None,
                 example: Optional[Any] = None,
                 exclusive_maximum: Optional[bool] = None,
                 exclusive_minimum: Optional[bool] = None,
                 external_docs: Optional['outputs.ExternalDocumentationPatch'] = None,
                 format: Optional[str] = None,
                 id: Optional[str] = None,
                 items: Optional[Any] = None,
                 max_items: Optional[int] = None,
                 max_length: Optional[int] = None,
                 max_properties: Optional[int] = None,
                 maximum: Optional[float] = None,
                 min_items: Optional[int] = None,
                 min_length: Optional[int] = None,
                 min_properties: Optional[int] = None,
                 minimum: Optional[float] = None,
                 multiple_of: Optional[float] = None,
                 not_: Optional['outputs.JSONSchemaPropsPatch'] = None,
                 nullable: Optional[bool] = None,
                 one_of: Optional[Sequence['outputs.JSONSchemaPropsPatch']] = None,
                 pattern: Optional[str] = None,
                 pattern_properties: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 properties: Optional[Mapping[str, 'outputs.JSONSchemaProps']] = None,
                 required: Optional[Sequence[str]] = None,
                 title: Optional[str] = None,
                 type: Optional[str] = None,
                 unique_items: Optional[bool] = None,
                 x_kubernetes_embedded_resource: Optional[bool] = None,
                 x_kubernetes_int_or_string: Optional[bool] = None,
                 x_kubernetes_list_map_keys: Optional[Sequence[str]] = None,
                 x_kubernetes_list_type: Optional[str] = None,
                 x_kubernetes_map_type: Optional[str] = None,
                 x_kubernetes_preserve_unknown_fields: Optional[bool] = None,
                 x_kubernetes_validations: Optional[Sequence['outputs.ValidationRulePatch']] = None):
        """
        JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
        :param Any default: default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.
        :param str format: format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:
               
               - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
        :param bool x_kubernetes_embedded_resource: x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
        :param bool x_kubernetes_int_or_string: x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:
               
               1) anyOf:
                  - type: integer
                  - type: string
               2) allOf:
                  - anyOf:
                    - type: integer
                    - type: string
                  - ... zero or more
        :param Sequence[str] x_kubernetes_list_map_keys: x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type `map` by specifying the keys used as the index of the map.
               
               This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).
               
               The properties specified must either be required or have a default value, to ensure those properties are present for all list items.
        :param str x_kubernetes_list_type: x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values:
               
               1) `atomic`: the list is treated as a single entity, like a scalar.
                    Atomic lists will be entirely replaced when updated. This extension
                    may be used on any type of list (struct, scalar, ...).
               2) `set`:
                    Sets are lists that must not have multiple items with the same value. Each
                    value must be a scalar, an object with x-kubernetes-map-type `atomic` or an
                    array with x-kubernetes-list-type `atomic`.
               3) `map`:
                    These lists are like maps in that their elements have a non-index key
                    used to identify them. Order is preserved upon merge. The map tag
                    must only be used on a list with elements of type object.
               Defaults to atomic for arrays.
        :param str x_kubernetes_map_type: x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values:
               
               1) `granular`:
                    These maps are actual maps (key-value pairs) and each fields are independent
                    from each other (they can each be manipulated by separate actors). This is
                    the default behaviour for all maps.
               2) `atomic`: the list is treated as a single entity, like a scalar.
                    Atomic maps will be entirely replaced when updated.
        :param bool x_kubernetes_preserve_unknown_fields: x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
        :param Sequence['ValidationRulePatchArgs'] x_kubernetes_validations: x-kubernetes-validations describes a list of validation rules written in the CEL expression language. This field is an alpha-level. Using this field requires the feature gate `CustomResourceValidationExpressions` to be enabled.
        """
        if _ref is not None:
            pulumi.set(__self__, "_ref", _ref)
        if _schema is not None:
            pulumi.set(__self__, "_schema", _schema)
        if additional_items is not None:
            pulumi.set(__self__, "additional_items", additional_items)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)
        if any_of is not None:
            pulumi.set(__self__, "any_of", any_of)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if definitions is not None:
            pulumi.set(__self__, "definitions", definitions)
        if dependencies is not None:
            pulumi.set(__self__, "dependencies", dependencies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enum is not None:
            pulumi.set(__self__, "enum", enum)
        if example is not None:
            pulumi.set(__self__, "example", example)
        if exclusive_maximum is not None:
            pulumi.set(__self__, "exclusive_maximum", exclusive_maximum)
        if exclusive_minimum is not None:
            pulumi.set(__self__, "exclusive_minimum", exclusive_minimum)
        if external_docs is not None:
            pulumi.set(__self__, "external_docs", external_docs)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if max_items is not None:
            pulumi.set(__self__, "max_items", max_items)
        if max_length is not None:
            pulumi.set(__self__, "max_length", max_length)
        if max_properties is not None:
            pulumi.set(__self__, "max_properties", max_properties)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if min_items is not None:
            pulumi.set(__self__, "min_items", min_items)
        if min_length is not None:
            pulumi.set(__self__, "min_length", min_length)
        if min_properties is not None:
            pulumi.set(__self__, "min_properties", min_properties)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if multiple_of is not None:
            pulumi.set(__self__, "multiple_of", multiple_of)
        if not_ is not None:
            pulumi.set(__self__, "not_", not_)
        if nullable is not None:
            pulumi.set(__self__, "nullable", nullable)
        if one_of is not None:
            pulumi.set(__self__, "one_of", one_of)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if pattern_properties is not None:
            pulumi.set(__self__, "pattern_properties", pattern_properties)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unique_items is not None:
            pulumi.set(__self__, "unique_items", unique_items)
        if x_kubernetes_embedded_resource is not None:
            pulumi.set(__self__, "x_kubernetes_embedded_resource", x_kubernetes_embedded_resource)
        if x_kubernetes_int_or_string is not None:
            pulumi.set(__self__, "x_kubernetes_int_or_string", x_kubernetes_int_or_string)
        if x_kubernetes_list_map_keys is not None:
            pulumi.set(__self__, "x_kubernetes_list_map_keys", x_kubernetes_list_map_keys)
        if x_kubernetes_list_type is not None:
            pulumi.set(__self__, "x_kubernetes_list_type", x_kubernetes_list_type)
        if x_kubernetes_map_type is not None:
            pulumi.set(__self__, "x_kubernetes_map_type", x_kubernetes_map_type)
        if x_kubernetes_preserve_unknown_fields is not None:
            pulumi.set(__self__, "x_kubernetes_preserve_unknown_fields", x_kubernetes_preserve_unknown_fields)
        if x_kubernetes_validations is not None:
            pulumi.set(__self__, "x_kubernetes_validations", x_kubernetes_validations)

    @property
    @pulumi.getter(name="$ref")
    def _ref(self) -> Optional[str]:
        return pulumi.get(self, "_ref")

    @property
    @pulumi.getter(name="$schema")
    def _schema(self) -> Optional[str]:
        return pulumi.get(self, "_schema")

    @property
    @pulumi.getter(name="additionalItems")
    def additional_items(self) -> Optional[Any]:
        return pulumi.get(self, "additional_items")

    @property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[Any]:
        return pulumi.get(self, "additional_properties")

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[Sequence['outputs.JSONSchemaPropsPatch']]:
        return pulumi.get(self, "all_of")

    @property
    @pulumi.getter(name="anyOf")
    def any_of(self) -> Optional[Sequence['outputs.JSONSchemaPropsPatch']]:
        return pulumi.get(self, "any_of")

    @property
    @pulumi.getter
    def default(self) -> Optional[Any]:
        """
        default is a default value for undefined object fields. Defaulting is a beta feature under the CustomResourceDefaulting feature gate. Defaulting requires spec.preserveUnknownFields to be false.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def definitions(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "definitions")

    @property
    @pulumi.getter
    def dependencies(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "dependencies")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enum(self) -> Optional[Sequence[Any]]:
        return pulumi.get(self, "enum")

    @property
    @pulumi.getter
    def example(self) -> Optional[Any]:
        return pulumi.get(self, "example")

    @property
    @pulumi.getter(name="exclusiveMaximum")
    def exclusive_maximum(self) -> Optional[bool]:
        return pulumi.get(self, "exclusive_maximum")

    @property
    @pulumi.getter(name="exclusiveMinimum")
    def exclusive_minimum(self) -> Optional[bool]:
        return pulumi.get(self, "exclusive_minimum")

    @property
    @pulumi.getter(name="externalDocs")
    def external_docs(self) -> Optional['outputs.ExternalDocumentationPatch']:
        return pulumi.get(self, "external_docs")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:

        - bsonobjectid: a bson object ID, i.e. a 24 characters hex string - uri: an URI as parsed by Golang net/url.ParseRequestURI - email: an email address as parsed by Golang net/mail.ParseAddress - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034]. - ipv4: an IPv4 IP as parsed by Golang net.ParseIP - ipv6: an IPv6 IP as parsed by Golang net.ParseIP - cidr: a CIDR as parsed by Golang net.ParseCIDR - mac: a MAC address as parsed by Golang net.ParseMAC - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$ - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$ - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041" - isbn10: an ISBN10 number string like "0321751043" - isbn13: an ISBN13 number string like "978-0321751041" - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$ - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$ - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559" - byte: base64 encoded binary data - password: any kind of string - date: a date string like "2006-01-02" as defined by full-date in RFC3339 - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Optional[Any]:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="maxItems")
    def max_items(self) -> Optional[int]:
        return pulumi.get(self, "max_items")

    @property
    @pulumi.getter(name="maxLength")
    def max_length(self) -> Optional[int]:
        return pulumi.get(self, "max_length")

    @property
    @pulumi.getter(name="maxProperties")
    def max_properties(self) -> Optional[int]:
        return pulumi.get(self, "max_properties")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[float]:
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter(name="minItems")
    def min_items(self) -> Optional[int]:
        return pulumi.get(self, "min_items")

    @property
    @pulumi.getter(name="minLength")
    def min_length(self) -> Optional[int]:
        return pulumi.get(self, "min_length")

    @property
    @pulumi.getter(name="minProperties")
    def min_properties(self) -> Optional[int]:
        return pulumi.get(self, "min_properties")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[float]:
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter(name="multipleOf")
    def multiple_of(self) -> Optional[float]:
        return pulumi.get(self, "multiple_of")

    @property
    @pulumi.getter(name="not")
    def not_(self) -> Optional['outputs.JSONSchemaPropsPatch']:
        return pulumi.get(self, "not_")

    @property
    @pulumi.getter
    def nullable(self) -> Optional[bool]:
        return pulumi.get(self, "nullable")

    @property
    @pulumi.getter(name="oneOf")
    def one_of(self) -> Optional[Sequence['outputs.JSONSchemaPropsPatch']]:
        return pulumi.get(self, "one_of")

    @property
    @pulumi.getter
    def pattern(self) -> Optional[str]:
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="patternProperties")
    def pattern_properties(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "pattern_properties")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, 'outputs.JSONSchemaProps']]:
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def required(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def title(self) -> Optional[str]:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="uniqueItems")
    def unique_items(self) -> Optional[bool]:
        return pulumi.get(self, "unique_items")

    @property
    @pulumi.getter
    def x_kubernetes_embedded_resource(self) -> Optional[bool]:
        """
        x-kubernetes-embedded-resource defines that the value is an embedded Kubernetes runtime.Object, with TypeMeta and ObjectMeta. The type must be object. It is allowed to further restrict the embedded object. kind, apiVersion and metadata are validated automatically. x-kubernetes-preserve-unknown-fields is allowed to be true, but does not have to be if the object is fully specified (up to kind, apiVersion, metadata).
        """
        return pulumi.get(self, "x_kubernetes_embedded_resource")

    @property
    @pulumi.getter
    def x_kubernetes_int_or_string(self) -> Optional[bool]:
        """
        x-kubernetes-int-or-string specifies that this value is either an integer or a string. If this is true, an empty type is allowed and type as child of anyOf is permitted if following one of the following patterns:

        1) anyOf:
           - type: integer
           - type: string
        2) allOf:
           - anyOf:
             - type: integer
             - type: string
           - ... zero or more
        """
        return pulumi.get(self, "x_kubernetes_int_or_string")

    @property
    @pulumi.getter
    def x_kubernetes_list_map_keys(self) -> Optional[Sequence[str]]:
        """
        x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type `map` by specifying the keys used as the index of the map.

        This tag MUST only be used on lists that have the "x-kubernetes-list-type" extension set to "map". Also, the values specified for this attribute must be a scalar typed field of the child structure (no nesting is supported).

        The properties specified must either be required or have a default value, to ensure those properties are present for all list items.
        """
        return pulumi.get(self, "x_kubernetes_list_map_keys")

    @property
    @pulumi.getter
    def x_kubernetes_list_type(self) -> Optional[str]:
        """
        x-kubernetes-list-type annotates an array to further describe its topology. This extension must only be used on lists and may have 3 possible values:

        1) `atomic`: the list is treated as a single entity, like a scalar.
             Atomic lists will be entirely replaced when updated. This extension
             may be used on any type of list (struct, scalar, ...).
        2) `set`:
             Sets are lists that must not have multiple items with the same value. Each
             value must be a scalar, an object with x-kubernetes-map-type `atomic` or an
             array with x-kubernetes-list-type `atomic`.
        3) `map`:
             These lists are like maps in that their elements have a non-index key
             used to identify them. Order is preserved upon merge. The map tag
             must only be used on a list with elements of type object.
        Defaults to atomic for arrays.
        """
        return pulumi.get(self, "x_kubernetes_list_type")

    @property
    @pulumi.getter
    def x_kubernetes_map_type(self) -> Optional[str]:
        """
        x-kubernetes-map-type annotates an object to further describe its topology. This extension must only be used when type is object and may have 2 possible values:

        1) `granular`:
             These maps are actual maps (key-value pairs) and each fields are independent
             from each other (they can each be manipulated by separate actors). This is
             the default behaviour for all maps.
        2) `atomic`: the list is treated as a single entity, like a scalar.
             Atomic maps will be entirely replaced when updated.
        """
        return pulumi.get(self, "x_kubernetes_map_type")

    @property
    @pulumi.getter
    def x_kubernetes_preserve_unknown_fields(self) -> Optional[bool]:
        """
        x-kubernetes-preserve-unknown-fields stops the API server decoding step from pruning fields which are not specified in the validation schema. This affects fields recursively, but switches back to normal pruning behaviour if nested properties or additionalProperties are specified in the schema. This can either be true or undefined. False is forbidden.
        """
        return pulumi.get(self, "x_kubernetes_preserve_unknown_fields")

    @property
    @pulumi.getter
    def x_kubernetes_validations(self) -> Optional[Sequence['outputs.ValidationRulePatch']]:
        """
        x-kubernetes-validations describes a list of validation rules written in the CEL expression language. This field is an alpha-level. Using this field requires the feature gate `CustomResourceValidationExpressions` to be enabled.
        """
        return pulumi.get(self, "x_kubernetes_validations")


@pulumi.output_type
class SelectableField(dict):
    """
    SelectableField specifies the JSON path of a field that may be used with field selectors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SelectableField. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SelectableField.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SelectableField.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_path: str):
        """
        SelectableField specifies the JSON path of a field that may be used with field selectors.
        :param str json_path: jsonPath is a simple JSON path which is evaluated against each custom resource to produce a field selector value. Only JSON paths without the array notation are allowed. Must point to a field of type string, boolean or integer. Types with enum values and strings with formats are allowed. If jsonPath refers to absent field in a resource, the jsonPath evaluates to an empty string. Must not point to metdata fields. Required.
        """
        pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> str:
        """
        jsonPath is a simple JSON path which is evaluated against each custom resource to produce a field selector value. Only JSON paths without the array notation are allowed. Must point to a field of type string, boolean or integer. Types with enum values and strings with formats are allowed. If jsonPath refers to absent field in a resource, the jsonPath evaluates to an empty string. Must not point to metdata fields. Required.
        """
        return pulumi.get(self, "json_path")


@pulumi.output_type
class SelectableFieldPatch(dict):
    """
    SelectableField specifies the JSON path of a field that may be used with field selectors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jsonPath":
            suggest = "json_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SelectableFieldPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SelectableFieldPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SelectableFieldPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 json_path: Optional[str] = None):
        """
        SelectableField specifies the JSON path of a field that may be used with field selectors.
        :param str json_path: jsonPath is a simple JSON path which is evaluated against each custom resource to produce a field selector value. Only JSON paths without the array notation are allowed. Must point to a field of type string, boolean or integer. Types with enum values and strings with formats are allowed. If jsonPath refers to absent field in a resource, the jsonPath evaluates to an empty string. Must not point to metdata fields. Required.
        """
        if json_path is not None:
            pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> Optional[str]:
        """
        jsonPath is a simple JSON path which is evaluated against each custom resource to produce a field selector value. Only JSON paths without the array notation are allowed. Must point to a field of type string, boolean or integer. Types with enum values and strings with formats are allowed. If jsonPath refers to absent field in a resource, the jsonPath evaluates to an empty string. Must not point to metdata fields. Required.
        """
        return pulumi.get(self, "json_path")


@pulumi.output_type
class ServiceReference(dict):
    """
    ServiceReference holds a reference to Service.legacy.k8s.io
    """
    def __init__(__self__, *,
                 name: str,
                 namespace: str,
                 path: Optional[str] = None,
                 port: Optional[int] = None):
        """
        ServiceReference holds a reference to Service.legacy.k8s.io
        :param str name: name is the name of the service. Required
        :param str namespace: namespace is the namespace of the service. Required
        :param str path: path is an optional URL path at which the webhook will be contacted.
        :param int port: port is an optional service port at which the webhook will be contacted. `port` should be a valid port number (1-65535, inclusive). Defaults to 443 for backward compatibility.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name is the name of the service. Required
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        namespace is the namespace of the service. Required
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        path is an optional URL path at which the webhook will be contacted.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        port is an optional service port at which the webhook will be contacted. `port` should be a valid port number (1-65535, inclusive). Defaults to 443 for backward compatibility.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceReferencePatch(dict):
    """
    ServiceReference holds a reference to Service.legacy.k8s.io
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None):
        """
        ServiceReference holds a reference to Service.legacy.k8s.io
        :param str name: name is the name of the service. Required
        :param str namespace: namespace is the namespace of the service. Required
        :param str path: path is an optional URL path at which the webhook will be contacted.
        :param int port: port is an optional service port at which the webhook will be contacted. `port` should be a valid port number (1-65535, inclusive). Defaults to 443 for backward compatibility.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        name is the name of the service. Required
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        namespace is the namespace of the service. Required
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        path is an optional URL path at which the webhook will be contacted.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        port is an optional service port at which the webhook will be contacted. `port` should be a valid port number (1-65535, inclusive). Defaults to 443 for backward compatibility.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ValidationRule(dict):
    """
    ValidationRule describes a validation rule written in the CEL expression language.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldPath":
            suggest = "field_path"
        elif key == "messageExpression":
            suggest = "message_expression"
        elif key == "optionalOldSelf":
            suggest = "optional_old_self"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rule: str,
                 field_path: Optional[str] = None,
                 message: Optional[str] = None,
                 message_expression: Optional[str] = None,
                 optional_old_self: Optional[bool] = None,
                 reason: Optional[str] = None):
        """
        ValidationRule describes a validation rule written in the CEL expression language.
        :param str rule: Rule represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec The Rule is scoped to the location of the x-kubernetes-validations extension in the schema. The `self` variable in the CEL expression is bound to the scoped value. Example: - Rule scoped to the root of a resource with a status subresource: {"rule": "self.status.actual <= self.spec.maxDesired"}
               
               If the Rule is scoped to an object with properties, the accessible properties of the object are field selectable via `self.field` and field presence can be checked via `has(self.field)`. Null valued fields are treated as absent fields in CEL expressions. If the Rule is scoped to an object with additionalProperties (i.e. a map) the value of the map are accessible via `self[mapKey]`, map containment can be checked via `mapKey in self` and all entries of the map are accessible via CEL macros and functions such as `self.all(...)`. If the Rule is scoped to an array, the elements of the array are accessible via `self[i]` and also by macros and functions. If the Rule is scoped to a scalar, `self` is bound to the scalar value. Examples: - Rule scoped to a map of objects: {"rule": "self.components['Widget'].priority < 10"} - Rule scoped to a list of integers: {"rule": "self.values.all(value, value >= 0 && value < 100)"} - Rule scoped to a string value: {"rule": "self.startsWith('kube')"}
               
               The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object and from any x-kubernetes-embedded-resource annotated objects. No other metadata properties are accessible.
               
               Unknown data preserved in custom resources via x-kubernetes-preserve-unknown-fields is not accessible in CEL expressions. This includes: - Unknown field values that are preserved by object schemas with x-kubernetes-preserve-unknown-fields. - Object properties where the property schema is of an "unknown type". An "unknown type" is recursively defined as:
                 - A schema with no type and x-kubernetes-preserve-unknown-fields set to true
                 - An array where the items schema is of an "unknown type"
                 - An object where the additionalProperties schema is of an "unknown type"
               
               Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
               	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
               	  "import", "let", "loop", "package", "namespace", "return".
               Examples:
                 - Rule accessing a property named "namespace": {"rule": "self.__namespace__ > 0"}
                 - Rule accessing a property named "x-prop": {"rule": "self.x__dash__prop > 0"}
                 - Rule accessing a property named "redact__d": {"rule": "self.redact__underscores__d > 0"}
               
               Equality on arrays with x-kubernetes-list-type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
                 - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
                   non-intersecting elements in `Y` are appended, retaining their partial order.
                 - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
                   are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
                   non-intersecting keys are appended, retaining their partial order.
               
               If `rule` makes use of the `oldSelf` variable it is implicitly a `transition rule`.
               
               By default, the `oldSelf` variable is the same type as `self`. When `optionalOldSelf` is true, the `oldSelf` variable is a CEL optional
                variable whose value() is the same type as `self`.
               See the documentation for the `optionalOldSelf` field for details.
               
               Transition rules by default are applied only on UPDATE requests and are skipped if an old value could not be found. You can opt a transition rule into unconditional evaluation by setting `optionalOldSelf` to true.
        :param str field_path: fieldPath represents the field path returned when the validation fails. It must be a relative JSON path (i.e. with array notation) scoped to the location of this x-kubernetes-validations extension in the schema and refer to an existing field. e.g. when validation checks if a specific attribute `foo` under a map `testMap`, the fieldPath could be set to `.testMap.foo` If the validation checks two lists must have unique attributes, the fieldPath could be set to either of the list: e.g. `.testList` It does not support list numeric index. It supports child operation to refer to an existing field currently. Refer to [JSONPath support in Kubernetes](https://kubernetes.io/docs/reference/kubectl/jsonpath/) for more info. Numeric index of array is not supported. For field name which contains special characters, use `['specialName']` to refer the field name. e.g. for attribute `foo.34$` appears in a list `testList`, the fieldPath could be set to `.testList['foo.34$']`
        :param str message: Message represents the message displayed when validation fails. The message is required if the Rule contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host"
        :param str message_expression: MessageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a rule, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the rule; the only difference is the return type. Example: "x must be less than max ("+string(self.max)+")"
        :param bool optional_old_self: optionalOldSelf is used to opt a transition rule into evaluation even when the object is first created, or if the old object is missing the value.
               
               When enabled `oldSelf` will be a CEL optional whose value will be `None` if there is no old value, or when the object is initially created.
               
               You may check for presence of oldSelf using `oldSelf.hasValue()` and unwrap it after checking using `oldSelf.value()`. Check the CEL documentation for Optional types for more information: https://pkg.go.dev/github.com/google/cel-go/cel#OptionalTypes
               
               May not be set unless `oldSelf` is used in `rule`.
        :param str reason: reason provides a machine-readable validation failure reason that is returned to the caller when a request fails this validation rule. The HTTP status code returned to the caller will match the reason of the reason of the first failed validation rule. The currently supported reasons are: "FieldValueInvalid", "FieldValueForbidden", "FieldValueRequired", "FieldValueDuplicate". If not set, default to use "FieldValueInvalid". All future added reasons must be accepted by clients when reading this value and unknown reasons should be treated as FieldValueInvalid.
        """
        pulumi.set(__self__, "rule", rule)
        if field_path is not None:
            pulumi.set(__self__, "field_path", field_path)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_expression is not None:
            pulumi.set(__self__, "message_expression", message_expression)
        if optional_old_self is not None:
            pulumi.set(__self__, "optional_old_self", optional_old_self)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def rule(self) -> str:
        """
        Rule represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec The Rule is scoped to the location of the x-kubernetes-validations extension in the schema. The `self` variable in the CEL expression is bound to the scoped value. Example: - Rule scoped to the root of a resource with a status subresource: {"rule": "self.status.actual <= self.spec.maxDesired"}

        If the Rule is scoped to an object with properties, the accessible properties of the object are field selectable via `self.field` and field presence can be checked via `has(self.field)`. Null valued fields are treated as absent fields in CEL expressions. If the Rule is scoped to an object with additionalProperties (i.e. a map) the value of the map are accessible via `self[mapKey]`, map containment can be checked via `mapKey in self` and all entries of the map are accessible via CEL macros and functions such as `self.all(...)`. If the Rule is scoped to an array, the elements of the array are accessible via `self[i]` and also by macros and functions. If the Rule is scoped to a scalar, `self` is bound to the scalar value. Examples: - Rule scoped to a map of objects: {"rule": "self.components['Widget'].priority < 10"} - Rule scoped to a list of integers: {"rule": "self.values.all(value, value >= 0 && value < 100)"} - Rule scoped to a string value: {"rule": "self.startsWith('kube')"}

        The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object and from any x-kubernetes-embedded-resource annotated objects. No other metadata properties are accessible.

        Unknown data preserved in custom resources via x-kubernetes-preserve-unknown-fields is not accessible in CEL expressions. This includes: - Unknown field values that are preserved by object schemas with x-kubernetes-preserve-unknown-fields. - Object properties where the property schema is of an "unknown type". An "unknown type" is recursively defined as:
          - A schema with no type and x-kubernetes-preserve-unknown-fields set to true
          - An array where the items schema is of an "unknown type"
          - An object where the additionalProperties schema is of an "unknown type"

        Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
        	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
        	  "import", "let", "loop", "package", "namespace", "return".
        Examples:
          - Rule accessing a property named "namespace": {"rule": "self.__namespace__ > 0"}
          - Rule accessing a property named "x-prop": {"rule": "self.x__dash__prop > 0"}
          - Rule accessing a property named "redact__d": {"rule": "self.redact__underscores__d > 0"}

        Equality on arrays with x-kubernetes-list-type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
          - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
            non-intersecting elements in `Y` are appended, retaining their partial order.
          - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
            are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
            non-intersecting keys are appended, retaining their partial order.

        If `rule` makes use of the `oldSelf` variable it is implicitly a `transition rule`.

        By default, the `oldSelf` variable is the same type as `self`. When `optionalOldSelf` is true, the `oldSelf` variable is a CEL optional
         variable whose value() is the same type as `self`.
        See the documentation for the `optionalOldSelf` field for details.

        Transition rules by default are applied only on UPDATE requests and are skipped if an old value could not be found. You can opt a transition rule into unconditional evaluation by setting `optionalOldSelf` to true.
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> Optional[str]:
        """
        fieldPath represents the field path returned when the validation fails. It must be a relative JSON path (i.e. with array notation) scoped to the location of this x-kubernetes-validations extension in the schema and refer to an existing field. e.g. when validation checks if a specific attribute `foo` under a map `testMap`, the fieldPath could be set to `.testMap.foo` If the validation checks two lists must have unique attributes, the fieldPath could be set to either of the list: e.g. `.testList` It does not support list numeric index. It supports child operation to refer to an existing field currently. Refer to [JSONPath support in Kubernetes](https://kubernetes.io/docs/reference/kubectl/jsonpath/) for more info. Numeric index of array is not supported. For field name which contains special characters, use `['specialName']` to refer the field name. e.g. for attribute `foo.34$` appears in a list `testList`, the fieldPath could be set to `.testList['foo.34$']`
        """
        return pulumi.get(self, "field_path")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Message represents the message displayed when validation fails. The message is required if the Rule contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host"
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="messageExpression")
    def message_expression(self) -> Optional[str]:
        """
        MessageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a rule, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the rule; the only difference is the return type. Example: "x must be less than max ("+string(self.max)+")"
        """
        return pulumi.get(self, "message_expression")

    @property
    @pulumi.getter(name="optionalOldSelf")
    def optional_old_self(self) -> Optional[bool]:
        """
        optionalOldSelf is used to opt a transition rule into evaluation even when the object is first created, or if the old object is missing the value.

        When enabled `oldSelf` will be a CEL optional whose value will be `None` if there is no old value, or when the object is initially created.

        You may check for presence of oldSelf using `oldSelf.hasValue()` and unwrap it after checking using `oldSelf.value()`. Check the CEL documentation for Optional types for more information: https://pkg.go.dev/github.com/google/cel-go/cel#OptionalTypes

        May not be set unless `oldSelf` is used in `rule`.
        """
        return pulumi.get(self, "optional_old_self")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        reason provides a machine-readable validation failure reason that is returned to the caller when a request fails this validation rule. The HTTP status code returned to the caller will match the reason of the reason of the first failed validation rule. The currently supported reasons are: "FieldValueInvalid", "FieldValueForbidden", "FieldValueRequired", "FieldValueDuplicate". If not set, default to use "FieldValueInvalid". All future added reasons must be accepted by clients when reading this value and unknown reasons should be treated as FieldValueInvalid.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class ValidationRulePatch(dict):
    """
    ValidationRule describes a validation rule written in the CEL expression language.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldPath":
            suggest = "field_path"
        elif key == "messageExpression":
            suggest = "message_expression"
        elif key == "optionalOldSelf":
            suggest = "optional_old_self"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidationRulePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidationRulePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidationRulePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_path: Optional[str] = None,
                 message: Optional[str] = None,
                 message_expression: Optional[str] = None,
                 optional_old_self: Optional[bool] = None,
                 reason: Optional[str] = None,
                 rule: Optional[str] = None):
        """
        ValidationRule describes a validation rule written in the CEL expression language.
        :param str field_path: fieldPath represents the field path returned when the validation fails. It must be a relative JSON path (i.e. with array notation) scoped to the location of this x-kubernetes-validations extension in the schema and refer to an existing field. e.g. when validation checks if a specific attribute `foo` under a map `testMap`, the fieldPath could be set to `.testMap.foo` If the validation checks two lists must have unique attributes, the fieldPath could be set to either of the list: e.g. `.testList` It does not support list numeric index. It supports child operation to refer to an existing field currently. Refer to [JSONPath support in Kubernetes](https://kubernetes.io/docs/reference/kubectl/jsonpath/) for more info. Numeric index of array is not supported. For field name which contains special characters, use `['specialName']` to refer the field name. e.g. for attribute `foo.34$` appears in a list `testList`, the fieldPath could be set to `.testList['foo.34$']`
        :param str message: Message represents the message displayed when validation fails. The message is required if the Rule contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host"
        :param str message_expression: MessageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a rule, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the rule; the only difference is the return type. Example: "x must be less than max ("+string(self.max)+")"
        :param bool optional_old_self: optionalOldSelf is used to opt a transition rule into evaluation even when the object is first created, or if the old object is missing the value.
               
               When enabled `oldSelf` will be a CEL optional whose value will be `None` if there is no old value, or when the object is initially created.
               
               You may check for presence of oldSelf using `oldSelf.hasValue()` and unwrap it after checking using `oldSelf.value()`. Check the CEL documentation for Optional types for more information: https://pkg.go.dev/github.com/google/cel-go/cel#OptionalTypes
               
               May not be set unless `oldSelf` is used in `rule`.
        :param str reason: reason provides a machine-readable validation failure reason that is returned to the caller when a request fails this validation rule. The HTTP status code returned to the caller will match the reason of the reason of the first failed validation rule. The currently supported reasons are: "FieldValueInvalid", "FieldValueForbidden", "FieldValueRequired", "FieldValueDuplicate". If not set, default to use "FieldValueInvalid". All future added reasons must be accepted by clients when reading this value and unknown reasons should be treated as FieldValueInvalid.
        :param str rule: Rule represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec The Rule is scoped to the location of the x-kubernetes-validations extension in the schema. The `self` variable in the CEL expression is bound to the scoped value. Example: - Rule scoped to the root of a resource with a status subresource: {"rule": "self.status.actual <= self.spec.maxDesired"}
               
               If the Rule is scoped to an object with properties, the accessible properties of the object are field selectable via `self.field` and field presence can be checked via `has(self.field)`. Null valued fields are treated as absent fields in CEL expressions. If the Rule is scoped to an object with additionalProperties (i.e. a map) the value of the map are accessible via `self[mapKey]`, map containment can be checked via `mapKey in self` and all entries of the map are accessible via CEL macros and functions such as `self.all(...)`. If the Rule is scoped to an array, the elements of the array are accessible via `self[i]` and also by macros and functions. If the Rule is scoped to a scalar, `self` is bound to the scalar value. Examples: - Rule scoped to a map of objects: {"rule": "self.components['Widget'].priority < 10"} - Rule scoped to a list of integers: {"rule": "self.values.all(value, value >= 0 && value < 100)"} - Rule scoped to a string value: {"rule": "self.startsWith('kube')"}
               
               The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object and from any x-kubernetes-embedded-resource annotated objects. No other metadata properties are accessible.
               
               Unknown data preserved in custom resources via x-kubernetes-preserve-unknown-fields is not accessible in CEL expressions. This includes: - Unknown field values that are preserved by object schemas with x-kubernetes-preserve-unknown-fields. - Object properties where the property schema is of an "unknown type". An "unknown type" is recursively defined as:
                 - A schema with no type and x-kubernetes-preserve-unknown-fields set to true
                 - An array where the items schema is of an "unknown type"
                 - An object where the additionalProperties schema is of an "unknown type"
               
               Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
               	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
               	  "import", "let", "loop", "package", "namespace", "return".
               Examples:
                 - Rule accessing a property named "namespace": {"rule": "self.__namespace__ > 0"}
                 - Rule accessing a property named "x-prop": {"rule": "self.x__dash__prop > 0"}
                 - Rule accessing a property named "redact__d": {"rule": "self.redact__underscores__d > 0"}
               
               Equality on arrays with x-kubernetes-list-type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
                 - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
                   non-intersecting elements in `Y` are appended, retaining their partial order.
                 - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
                   are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
                   non-intersecting keys are appended, retaining their partial order.
               
               If `rule` makes use of the `oldSelf` variable it is implicitly a `transition rule`.
               
               By default, the `oldSelf` variable is the same type as `self`. When `optionalOldSelf` is true, the `oldSelf` variable is a CEL optional
                variable whose value() is the same type as `self`.
               See the documentation for the `optionalOldSelf` field for details.
               
               Transition rules by default are applied only on UPDATE requests and are skipped if an old value could not be found. You can opt a transition rule into unconditional evaluation by setting `optionalOldSelf` to true.
        """
        if field_path is not None:
            pulumi.set(__self__, "field_path", field_path)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_expression is not None:
            pulumi.set(__self__, "message_expression", message_expression)
        if optional_old_self is not None:
            pulumi.set(__self__, "optional_old_self", optional_old_self)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter(name="fieldPath")
    def field_path(self) -> Optional[str]:
        """
        fieldPath represents the field path returned when the validation fails. It must be a relative JSON path (i.e. with array notation) scoped to the location of this x-kubernetes-validations extension in the schema and refer to an existing field. e.g. when validation checks if a specific attribute `foo` under a map `testMap`, the fieldPath could be set to `.testMap.foo` If the validation checks two lists must have unique attributes, the fieldPath could be set to either of the list: e.g. `.testList` It does not support list numeric index. It supports child operation to refer to an existing field currently. Refer to [JSONPath support in Kubernetes](https://kubernetes.io/docs/reference/kubectl/jsonpath/) for more info. Numeric index of array is not supported. For field name which contains special characters, use `['specialName']` to refer the field name. e.g. for attribute `foo.34$` appears in a list `testList`, the fieldPath could be set to `.testList['foo.34$']`
        """
        return pulumi.get(self, "field_path")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Message represents the message displayed when validation fails. The message is required if the Rule contains line breaks. The message must not contain line breaks. If unset, the message is "failed rule: {Rule}". e.g. "must be a URL with the host matching spec.host"
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="messageExpression")
    def message_expression(self) -> Optional[str]:
        """
        MessageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a rule, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the rule; the only difference is the return type. Example: "x must be less than max ("+string(self.max)+")"
        """
        return pulumi.get(self, "message_expression")

    @property
    @pulumi.getter(name="optionalOldSelf")
    def optional_old_self(self) -> Optional[bool]:
        """
        optionalOldSelf is used to opt a transition rule into evaluation even when the object is first created, or if the old object is missing the value.

        When enabled `oldSelf` will be a CEL optional whose value will be `None` if there is no old value, or when the object is initially created.

        You may check for presence of oldSelf using `oldSelf.hasValue()` and unwrap it after checking using `oldSelf.value()`. Check the CEL documentation for Optional types for more information: https://pkg.go.dev/github.com/google/cel-go/cel#OptionalTypes

        May not be set unless `oldSelf` is used in `rule`.
        """
        return pulumi.get(self, "optional_old_self")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        reason provides a machine-readable validation failure reason that is returned to the caller when a request fails this validation rule. The HTTP status code returned to the caller will match the reason of the reason of the first failed validation rule. The currently supported reasons are: "FieldValueInvalid", "FieldValueForbidden", "FieldValueRequired", "FieldValueDuplicate". If not set, default to use "FieldValueInvalid". All future added reasons must be accepted by clients when reading this value and unknown reasons should be treated as FieldValueInvalid.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def rule(self) -> Optional[str]:
        """
        Rule represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec The Rule is scoped to the location of the x-kubernetes-validations extension in the schema. The `self` variable in the CEL expression is bound to the scoped value. Example: - Rule scoped to the root of a resource with a status subresource: {"rule": "self.status.actual <= self.spec.maxDesired"}

        If the Rule is scoped to an object with properties, the accessible properties of the object are field selectable via `self.field` and field presence can be checked via `has(self.field)`. Null valued fields are treated as absent fields in CEL expressions. If the Rule is scoped to an object with additionalProperties (i.e. a map) the value of the map are accessible via `self[mapKey]`, map containment can be checked via `mapKey in self` and all entries of the map are accessible via CEL macros and functions such as `self.all(...)`. If the Rule is scoped to an array, the elements of the array are accessible via `self[i]` and also by macros and functions. If the Rule is scoped to a scalar, `self` is bound to the scalar value. Examples: - Rule scoped to a map of objects: {"rule": "self.components['Widget'].priority < 10"} - Rule scoped to a list of integers: {"rule": "self.values.all(value, value >= 0 && value < 100)"} - Rule scoped to a string value: {"rule": "self.startsWith('kube')"}

        The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object and from any x-kubernetes-embedded-resource annotated objects. No other metadata properties are accessible.

        Unknown data preserved in custom resources via x-kubernetes-preserve-unknown-fields is not accessible in CEL expressions. This includes: - Unknown field values that are preserved by object schemas with x-kubernetes-preserve-unknown-fields. - Object properties where the property schema is of an "unknown type". An "unknown type" is recursively defined as:
          - A schema with no type and x-kubernetes-preserve-unknown-fields set to true
          - An array where the items schema is of an "unknown type"
          - An object where the additionalProperties schema is of an "unknown type"

        Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
        	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
        	  "import", "let", "loop", "package", "namespace", "return".
        Examples:
          - Rule accessing a property named "namespace": {"rule": "self.__namespace__ > 0"}
          - Rule accessing a property named "x-prop": {"rule": "self.x__dash__prop > 0"}
          - Rule accessing a property named "redact__d": {"rule": "self.redact__underscores__d > 0"}

        Equality on arrays with x-kubernetes-list-type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
          - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
            non-intersecting elements in `Y` are appended, retaining their partial order.
          - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
            are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
            non-intersecting keys are appended, retaining their partial order.

        If `rule` makes use of the `oldSelf` variable it is implicitly a `transition rule`.

        By default, the `oldSelf` variable is the same type as `self`. When `optionalOldSelf` is true, the `oldSelf` variable is a CEL optional
         variable whose value() is the same type as `self`.
        See the documentation for the `optionalOldSelf` field for details.

        Transition rules by default are applied only on UPDATE requests and are skipped if an old value could not be found. You can opt a transition rule into unconditional evaluation by setting `optionalOldSelf` to true.
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class WebhookClientConfig(dict):
    """
    WebhookClientConfig contains the information to make a TLS connection with the webhook.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caBundle":
            suggest = "ca_bundle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookClientConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookClientConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookClientConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_bundle: Optional[str] = None,
                 service: Optional['outputs.ServiceReference'] = None,
                 url: Optional[str] = None):
        """
        WebhookClientConfig contains the information to make a TLS connection with the webhook.
        :param str ca_bundle: caBundle is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        :param 'ServiceReferenceArgs' service: service is a reference to the service for this webhook. Either service or url must be specified.
               
               If the webhook is running within the cluster, then you should use `service`.
        :param str url: url gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.
               
               The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.
               
               Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.
               
               The scheme must be "https"; the URL must begin with "https://".
               
               A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.
               
               Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        if ca_bundle is not None:
            pulumi.set(__self__, "ca_bundle", ca_bundle)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="caBundle")
    def ca_bundle(self) -> Optional[str]:
        """
        caBundle is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        """
        return pulumi.get(self, "ca_bundle")

    @property
    @pulumi.getter
    def service(self) -> Optional['outputs.ServiceReference']:
        """
        service is a reference to the service for this webhook. Either service or url must be specified.

        If the webhook is running within the cluster, then you should use `service`.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        url gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.

        The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.

        Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.

        The scheme must be "https"; the URL must begin with "https://".

        A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.

        Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class WebhookClientConfigPatch(dict):
    """
    WebhookClientConfig contains the information to make a TLS connection with the webhook.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caBundle":
            suggest = "ca_bundle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookClientConfigPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookClientConfigPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookClientConfigPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_bundle: Optional[str] = None,
                 service: Optional['outputs.ServiceReferencePatch'] = None,
                 url: Optional[str] = None):
        """
        WebhookClientConfig contains the information to make a TLS connection with the webhook.
        :param str ca_bundle: caBundle is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        :param 'ServiceReferencePatchArgs' service: service is a reference to the service for this webhook. Either service or url must be specified.
               
               If the webhook is running within the cluster, then you should use `service`.
        :param str url: url gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.
               
               The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.
               
               Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.
               
               The scheme must be "https"; the URL must begin with "https://".
               
               A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.
               
               Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        if ca_bundle is not None:
            pulumi.set(__self__, "ca_bundle", ca_bundle)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="caBundle")
    def ca_bundle(self) -> Optional[str]:
        """
        caBundle is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.
        """
        return pulumi.get(self, "ca_bundle")

    @property
    @pulumi.getter
    def service(self) -> Optional['outputs.ServiceReferencePatch']:
        """
        service is a reference to the service for this webhook. Either service or url must be specified.

        If the webhook is running within the cluster, then you should use `service`.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        url gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.

        The `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.

        Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.

        The scheme must be "https"; the URL must begin with "https://".

        A path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.

        Attempting to use a user or basic auth e.g. "user:password@" is not allowed. Fragments ("#...") and query parameters ("?...") are not allowed, either.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class WebhookConversion(dict):
    """
    WebhookConversion describes how to call a conversion webhook
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conversionReviewVersions":
            suggest = "conversion_review_versions"
        elif key == "clientConfig":
            suggest = "client_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookConversion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookConversion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookConversion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conversion_review_versions: Sequence[str],
                 client_config: Optional['outputs.WebhookClientConfig'] = None):
        """
        WebhookConversion describes how to call a conversion webhook
        :param Sequence[str] conversion_review_versions: conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.
        :param 'WebhookClientConfigArgs' client_config: clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
        """
        pulumi.set(__self__, "conversion_review_versions", conversion_review_versions)
        if client_config is not None:
            pulumi.set(__self__, "client_config", client_config)

    @property
    @pulumi.getter(name="conversionReviewVersions")
    def conversion_review_versions(self) -> Sequence[str]:
        """
        conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.
        """
        return pulumi.get(self, "conversion_review_versions")

    @property
    @pulumi.getter(name="clientConfig")
    def client_config(self) -> Optional['outputs.WebhookClientConfig']:
        """
        clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
        """
        return pulumi.get(self, "client_config")


@pulumi.output_type
class WebhookConversionPatch(dict):
    """
    WebhookConversion describes how to call a conversion webhook
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientConfig":
            suggest = "client_config"
        elif key == "conversionReviewVersions":
            suggest = "conversion_review_versions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookConversionPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookConversionPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookConversionPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_config: Optional['outputs.WebhookClientConfigPatch'] = None,
                 conversion_review_versions: Optional[Sequence[str]] = None):
        """
        WebhookConversion describes how to call a conversion webhook
        :param 'WebhookClientConfigPatchArgs' client_config: clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
        :param Sequence[str] conversion_review_versions: conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.
        """
        if client_config is not None:
            pulumi.set(__self__, "client_config", client_config)
        if conversion_review_versions is not None:
            pulumi.set(__self__, "conversion_review_versions", conversion_review_versions)

    @property
    @pulumi.getter(name="clientConfig")
    def client_config(self) -> Optional['outputs.WebhookClientConfigPatch']:
        """
        clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
        """
        return pulumi.get(self, "client_config")

    @property
    @pulumi.getter(name="conversionReviewVersions")
    def conversion_review_versions(self) -> Optional[Sequence[str]]:
        """
        conversionReviewVersions is an ordered list of preferred `ConversionReview` versions the Webhook expects. The API server will use the first version in the list which it supports. If none of the versions specified in this list are supported by API server, conversion will fail for the custom resource. If a persisted Webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail.
        """
        return pulumi.get(self, "conversion_review_versions")


