# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ... import meta as _meta

__all__ = [
    'ContainerResourceMetricSourcePatchArgs',
    'ContainerResourceMetricSourceArgs',
    'ContainerResourceMetricStatusArgs',
    'CrossVersionObjectReferencePatchArgs',
    'CrossVersionObjectReferenceArgs',
    'ExternalMetricSourcePatchArgs',
    'ExternalMetricSourceArgs',
    'ExternalMetricStatusArgs',
    'HPAScalingPolicyPatchArgs',
    'HPAScalingPolicyArgs',
    'HPAScalingRulesPatchArgs',
    'HPAScalingRulesArgs',
    'HorizontalPodAutoscalerBehaviorPatchArgs',
    'HorizontalPodAutoscalerBehaviorArgs',
    'HorizontalPodAutoscalerConditionArgs',
    'HorizontalPodAutoscalerSpecPatchArgs',
    'HorizontalPodAutoscalerSpecArgs',
    'HorizontalPodAutoscalerStatusArgs',
    'HorizontalPodAutoscalerArgs',
    'MetricIdentifierPatchArgs',
    'MetricIdentifierArgs',
    'MetricSpecPatchArgs',
    'MetricSpecArgs',
    'MetricStatusArgs',
    'MetricTargetPatchArgs',
    'MetricTargetArgs',
    'MetricValueStatusArgs',
    'ObjectMetricSourcePatchArgs',
    'ObjectMetricSourceArgs',
    'ObjectMetricStatusArgs',
    'PodsMetricSourcePatchArgs',
    'PodsMetricSourceArgs',
    'PodsMetricStatusArgs',
    'ResourceMetricSourcePatchArgs',
    'ResourceMetricSourceArgs',
    'ResourceMetricStatusArgs',
]

@pulumi.input_type
class ContainerResourceMetricSourcePatchArgs:
    def __init__(__self__, *,
                 container: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input['MetricTargetPatchArgs']] = None):
        """
        ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param pulumi.Input[str] container: container is the name of the container in the pods of the scaling target
        :param pulumi.Input[str] name: name is the name of the resource in question.
        :param pulumi.Input['MetricTargetPatchArgs'] target: target specifies the target value for the given metric
        """
        if container is not None:
            pulumi.set(__self__, "container", container)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input[str]]:
        """
        container is the name of the container in the pods of the scaling target
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['MetricTargetPatchArgs']]:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['MetricTargetPatchArgs']]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class ContainerResourceMetricSourceArgs:
    def __init__(__self__, *,
                 container: pulumi.Input[str],
                 name: pulumi.Input[str],
                 target: pulumi.Input['MetricTargetArgs']):
        """
        ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param pulumi.Input[str] container: container is the name of the container in the pods of the scaling target
        :param pulumi.Input[str] name: name is the name of the resource in question.
        :param pulumi.Input['MetricTargetArgs'] target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Input[str]:
        """
        container is the name of the container in the pods of the scaling target
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[str]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input['MetricTargetArgs']:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input['MetricTargetArgs']):
        pulumi.set(self, "target", value)


@pulumi.input_type
class ContainerResourceMetricStatusArgs:
    def __init__(__self__, *,
                 container: pulumi.Input[str],
                 current: pulumi.Input['MetricValueStatusArgs'],
                 name: pulumi.Input[str]):
        """
        ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param pulumi.Input[str] container: container is the name of the container in the pods of the scaling target
        :param pulumi.Input['MetricValueStatusArgs'] current: current contains the current value for the given metric
        :param pulumi.Input[str] name: name is the name of the resource in question.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def container(self) -> pulumi.Input[str]:
        """
        container is the name of the container in the pods of the scaling target
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: pulumi.Input[str]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def current(self) -> pulumi.Input['MetricValueStatusArgs']:
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @current.setter
    def current(self, value: pulumi.Input['MetricValueStatusArgs']):
        pulumi.set(self, "current", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class CrossVersionObjectReferencePatchArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        CrossVersionObjectReference contains enough information to let you identify the referred resource.
        :param pulumi.Input[str] api_version: apiVersion is the API version of the referent
        :param pulumi.Input[str] kind: kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[str] name: name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        apiVersion is the API version of the referent
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class CrossVersionObjectReferenceArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 name: pulumi.Input[str],
                 api_version: Optional[pulumi.Input[str]] = None):
        """
        CrossVersionObjectReference contains enough information to let you identify the referred resource.
        :param pulumi.Input[str] kind: kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input[str] name: name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[str] api_version: apiVersion is the API version of the referent
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        apiVersion is the API version of the referent
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)


@pulumi.input_type
class ExternalMetricSourcePatchArgs:
    def __init__(__self__, *,
                 metric: Optional[pulumi.Input['MetricIdentifierPatchArgs']] = None,
                 target: Optional[pulumi.Input['MetricTargetPatchArgs']] = None):
        """
        ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param pulumi.Input['MetricIdentifierPatchArgs'] metric: metric identifies the target metric by name and selector
        :param pulumi.Input['MetricTargetPatchArgs'] target: target specifies the target value for the given metric
        """
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input['MetricIdentifierPatchArgs']]:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input['MetricIdentifierPatchArgs']]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['MetricTargetPatchArgs']]:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['MetricTargetPatchArgs']]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class ExternalMetricSourceArgs:
    def __init__(__self__, *,
                 metric: pulumi.Input['MetricIdentifierArgs'],
                 target: pulumi.Input['MetricTargetArgs']):
        """
        ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param pulumi.Input['MetricIdentifierArgs'] metric: metric identifies the target metric by name and selector
        :param pulumi.Input['MetricTargetArgs'] target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['MetricIdentifierArgs']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['MetricIdentifierArgs']):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input['MetricTargetArgs']:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input['MetricTargetArgs']):
        pulumi.set(self, "target", value)


@pulumi.input_type
class ExternalMetricStatusArgs:
    def __init__(__self__, *,
                 current: pulumi.Input['MetricValueStatusArgs'],
                 metric: pulumi.Input['MetricIdentifierArgs']):
        """
        ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.
        :param pulumi.Input['MetricValueStatusArgs'] current: current contains the current value for the given metric
        :param pulumi.Input['MetricIdentifierArgs'] metric: metric identifies the target metric by name and selector
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "metric", metric)

    @property
    @pulumi.getter
    def current(self) -> pulumi.Input['MetricValueStatusArgs']:
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @current.setter
    def current(self, value: pulumi.Input['MetricValueStatusArgs']):
        pulumi.set(self, "current", value)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['MetricIdentifierArgs']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['MetricIdentifierArgs']):
        pulumi.set(self, "metric", value)


@pulumi.input_type
class HPAScalingPolicyPatchArgs:
    def __init__(__self__, *,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[int]] = None):
        """
        HPAScalingPolicy is a single policy which must hold true for a specified past interval.
        :param pulumi.Input[int] period_seconds: periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        :param pulumi.Input[str] type: type is used to specify the scaling policy.
        :param pulumi.Input[int] value: value contains the amount of change which is permitted by the policy. It must be greater than zero
        """
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        type is used to specify the scaling policy.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[int]]:
        """
        value contains the amount of change which is permitted by the policy. It must be greater than zero
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class HPAScalingPolicyArgs:
    def __init__(__self__, *,
                 period_seconds: pulumi.Input[int],
                 type: pulumi.Input[str],
                 value: pulumi.Input[int]):
        """
        HPAScalingPolicy is a single policy which must hold true for a specified past interval.
        :param pulumi.Input[int] period_seconds: periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        :param pulumi.Input[str] type: type is used to specify the scaling policy.
        :param pulumi.Input[int] value: value contains the amount of change which is permitted by the policy. It must be greater than zero
        """
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> pulumi.Input[int]:
        """
        periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        type is used to specify the scaling policy.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[int]:
        """
        value contains the amount of change which is permitted by the policy. It must be greater than zero
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[int]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class HPAScalingRulesPatchArgs:
    def __init__(__self__, *,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['HPAScalingPolicyPatchArgs']]]] = None,
                 select_policy: Optional[pulumi.Input[str]] = None,
                 stabilization_window_seconds: Optional[pulumi.Input[int]] = None):
        """
        HPAScalingRules configures the scaling behavior for one direction. These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.
        :param pulumi.Input[Sequence[pulumi.Input['HPAScalingPolicyPatchArgs']]] policies: policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
        :param pulumi.Input[str] select_policy: selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
        :param pulumi.Input[int] stabilization_window_seconds: stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
        """
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if select_policy is not None:
            pulumi.set(__self__, "select_policy", select_policy)
        if stabilization_window_seconds is not None:
            pulumi.set(__self__, "stabilization_window_seconds", stabilization_window_seconds)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HPAScalingPolicyPatchArgs']]]]:
        """
        policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HPAScalingPolicyPatchArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="selectPolicy")
    def select_policy(self) -> Optional[pulumi.Input[str]]:
        """
        selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
        """
        return pulumi.get(self, "select_policy")

    @select_policy.setter
    def select_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "select_policy", value)

    @property
    @pulumi.getter(name="stabilizationWindowSeconds")
    def stabilization_window_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
        """
        return pulumi.get(self, "stabilization_window_seconds")

    @stabilization_window_seconds.setter
    def stabilization_window_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stabilization_window_seconds", value)


@pulumi.input_type
class HPAScalingRulesArgs:
    def __init__(__self__, *,
                 policies: Optional[pulumi.Input[Sequence[pulumi.Input['HPAScalingPolicyArgs']]]] = None,
                 select_policy: Optional[pulumi.Input[str]] = None,
                 stabilization_window_seconds: Optional[pulumi.Input[int]] = None):
        """
        HPAScalingRules configures the scaling behavior for one direction. These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.
        :param pulumi.Input[Sequence[pulumi.Input['HPAScalingPolicyArgs']]] policies: policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
        :param pulumi.Input[str] select_policy: selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
        :param pulumi.Input[int] stabilization_window_seconds: stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
        """
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if select_policy is not None:
            pulumi.set(__self__, "select_policy", select_policy)
        if stabilization_window_seconds is not None:
            pulumi.set(__self__, "stabilization_window_seconds", stabilization_window_seconds)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HPAScalingPolicyArgs']]]]:
        """
        policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HPAScalingPolicyArgs']]]]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter(name="selectPolicy")
    def select_policy(self) -> Optional[pulumi.Input[str]]:
        """
        selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.
        """
        return pulumi.get(self, "select_policy")

    @select_policy.setter
    def select_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "select_policy", value)

    @property
    @pulumi.getter(name="stabilizationWindowSeconds")
    def stabilization_window_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
        """
        return pulumi.get(self, "stabilization_window_seconds")

    @stabilization_window_seconds.setter
    def stabilization_window_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stabilization_window_seconds", value)


@pulumi.input_type
class HorizontalPodAutoscalerBehaviorPatchArgs:
    def __init__(__self__, *,
                 scale_down: Optional[pulumi.Input['HPAScalingRulesPatchArgs']] = None,
                 scale_up: Optional[pulumi.Input['HPAScalingRulesPatchArgs']] = None):
        """
        HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).
        :param pulumi.Input['HPAScalingRulesPatchArgs'] scale_down: scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        :param pulumi.Input['HPAScalingRulesPatchArgs'] scale_up: scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
                 * increase no more than 4 pods per 60 seconds
                 * double the number of pods per 60 seconds
               No stabilization is used.
        """
        if scale_down is not None:
            pulumi.set(__self__, "scale_down", scale_down)
        if scale_up is not None:
            pulumi.set(__self__, "scale_up", scale_up)

    @property
    @pulumi.getter(name="scaleDown")
    def scale_down(self) -> Optional[pulumi.Input['HPAScalingRulesPatchArgs']]:
        """
        scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        """
        return pulumi.get(self, "scale_down")

    @scale_down.setter
    def scale_down(self, value: Optional[pulumi.Input['HPAScalingRulesPatchArgs']]):
        pulumi.set(self, "scale_down", value)

    @property
    @pulumi.getter(name="scaleUp")
    def scale_up(self) -> Optional[pulumi.Input['HPAScalingRulesPatchArgs']]:
        """
        scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
          * increase no more than 4 pods per 60 seconds
          * double the number of pods per 60 seconds
        No stabilization is used.
        """
        return pulumi.get(self, "scale_up")

    @scale_up.setter
    def scale_up(self, value: Optional[pulumi.Input['HPAScalingRulesPatchArgs']]):
        pulumi.set(self, "scale_up", value)


@pulumi.input_type
class HorizontalPodAutoscalerBehaviorArgs:
    def __init__(__self__, *,
                 scale_down: Optional[pulumi.Input['HPAScalingRulesArgs']] = None,
                 scale_up: Optional[pulumi.Input['HPAScalingRulesArgs']] = None):
        """
        HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).
        :param pulumi.Input['HPAScalingRulesArgs'] scale_down: scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        :param pulumi.Input['HPAScalingRulesArgs'] scale_up: scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
                 * increase no more than 4 pods per 60 seconds
                 * double the number of pods per 60 seconds
               No stabilization is used.
        """
        if scale_down is not None:
            pulumi.set(__self__, "scale_down", scale_down)
        if scale_up is not None:
            pulumi.set(__self__, "scale_up", scale_up)

    @property
    @pulumi.getter(name="scaleDown")
    def scale_down(self) -> Optional[pulumi.Input['HPAScalingRulesArgs']]:
        """
        scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).
        """
        return pulumi.get(self, "scale_down")

    @scale_down.setter
    def scale_down(self, value: Optional[pulumi.Input['HPAScalingRulesArgs']]):
        pulumi.set(self, "scale_down", value)

    @property
    @pulumi.getter(name="scaleUp")
    def scale_up(self) -> Optional[pulumi.Input['HPAScalingRulesArgs']]:
        """
        scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:
          * increase no more than 4 pods per 60 seconds
          * double the number of pods per 60 seconds
        No stabilization is used.
        """
        return pulumi.get(self, "scale_up")

    @scale_up.setter
    def scale_up(self, value: Optional[pulumi.Input['HPAScalingRulesArgs']]):
        pulumi.set(self, "scale_up", value)


@pulumi.input_type
class HorizontalPodAutoscalerConditionArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[str],
                 type: pulumi.Input[str],
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.
        :param pulumi.Input[str] status: status is the status of the condition (True, False, Unknown)
        :param pulumi.Input[str] type: type describes the current condition
        :param pulumi.Input[str] last_transition_time: lastTransitionTime is the last time the condition transitioned from one status to another
        :param pulumi.Input[str] message: message is a human-readable explanation containing details about the transition
        :param pulumi.Input[str] reason: reason is the reason for the condition's last transition.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        status is the status of the condition (True, False, Unknown)
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        type describes the current condition
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        lastTransitionTime is the last time the condition transitioned from one status to another
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        message is a human-readable explanation containing details about the transition
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        reason is the reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class HorizontalPodAutoscalerSpecPatchArgs:
    def __init__(__self__, *,
                 behavior: Optional[pulumi.Input['HorizontalPodAutoscalerBehaviorPatchArgs']] = None,
                 max_replicas: Optional[pulumi.Input[int]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['MetricSpecPatchArgs']]]] = None,
                 min_replicas: Optional[pulumi.Input[int]] = None,
                 scale_target_ref: Optional[pulumi.Input['CrossVersionObjectReferencePatchArgs']] = None):
        """
        HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
        :param pulumi.Input['HorizontalPodAutoscalerBehaviorPatchArgs'] behavior: behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        :param pulumi.Input[int] max_replicas: maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        :param pulumi.Input[Sequence[pulumi.Input['MetricSpecPatchArgs']]] metrics: metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        :param pulumi.Input[int] min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        :param pulumi.Input['CrossVersionObjectReferencePatchArgs'] scale_target_ref: scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        """
        if behavior is not None:
            pulumi.set(__self__, "behavior", behavior)
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)
        if scale_target_ref is not None:
            pulumi.set(__self__, "scale_target_ref", scale_target_ref)

    @property
    @pulumi.getter
    def behavior(self) -> Optional[pulumi.Input['HorizontalPodAutoscalerBehaviorPatchArgs']]:
        """
        behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        """
        return pulumi.get(self, "behavior")

    @behavior.setter
    def behavior(self, value: Optional[pulumi.Input['HorizontalPodAutoscalerBehaviorPatchArgs']]):
        pulumi.set(self, "behavior", value)

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        """
        return pulumi.get(self, "max_replicas")

    @max_replicas.setter
    def max_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_replicas", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricSpecPatchArgs']]]]:
        """
        metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricSpecPatchArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        """
        return pulumi.get(self, "min_replicas")

    @min_replicas.setter
    def min_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_replicas", value)

    @property
    @pulumi.getter(name="scaleTargetRef")
    def scale_target_ref(self) -> Optional[pulumi.Input['CrossVersionObjectReferencePatchArgs']]:
        """
        scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        """
        return pulumi.get(self, "scale_target_ref")

    @scale_target_ref.setter
    def scale_target_ref(self, value: Optional[pulumi.Input['CrossVersionObjectReferencePatchArgs']]):
        pulumi.set(self, "scale_target_ref", value)


@pulumi.input_type
class HorizontalPodAutoscalerSpecArgs:
    def __init__(__self__, *,
                 max_replicas: pulumi.Input[int],
                 scale_target_ref: pulumi.Input['CrossVersionObjectReferenceArgs'],
                 behavior: Optional[pulumi.Input['HorizontalPodAutoscalerBehaviorArgs']] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['MetricSpecArgs']]]] = None,
                 min_replicas: Optional[pulumi.Input[int]] = None):
        """
        HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.
        :param pulumi.Input[int] max_replicas: maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        :param pulumi.Input['CrossVersionObjectReferenceArgs'] scale_target_ref: scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        :param pulumi.Input['HorizontalPodAutoscalerBehaviorArgs'] behavior: behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        :param pulumi.Input[Sequence[pulumi.Input['MetricSpecArgs']]] metrics: metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        :param pulumi.Input[int] min_replicas: minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        """
        pulumi.set(__self__, "max_replicas", max_replicas)
        pulumi.set(__self__, "scale_target_ref", scale_target_ref)
        if behavior is not None:
            pulumi.set(__self__, "behavior", behavior)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> pulumi.Input[int]:
        """
        maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.
        """
        return pulumi.get(self, "max_replicas")

    @max_replicas.setter
    def max_replicas(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_replicas", value)

    @property
    @pulumi.getter(name="scaleTargetRef")
    def scale_target_ref(self) -> pulumi.Input['CrossVersionObjectReferenceArgs']:
        """
        scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.
        """
        return pulumi.get(self, "scale_target_ref")

    @scale_target_ref.setter
    def scale_target_ref(self, value: pulumi.Input['CrossVersionObjectReferenceArgs']):
        pulumi.set(self, "scale_target_ref", value)

    @property
    @pulumi.getter
    def behavior(self) -> Optional[pulumi.Input['HorizontalPodAutoscalerBehaviorArgs']]:
        """
        behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.
        """
        return pulumi.get(self, "behavior")

    @behavior.setter
    def behavior(self, value: Optional[pulumi.Input['HorizontalPodAutoscalerBehaviorArgs']]):
        pulumi.set(self, "behavior", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricSpecArgs']]]]:
        """
        metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricSpecArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.
        """
        return pulumi.get(self, "min_replicas")

    @min_replicas.setter
    def min_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_replicas", value)


@pulumi.input_type
class HorizontalPodAutoscalerStatusArgs:
    def __init__(__self__, *,
                 desired_replicas: pulumi.Input[int],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['HorizontalPodAutoscalerConditionArgs']]]] = None,
                 current_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['MetricStatusArgs']]]] = None,
                 current_replicas: Optional[pulumi.Input[int]] = None,
                 last_scale_time: Optional[pulumi.Input[str]] = None,
                 observed_generation: Optional[pulumi.Input[int]] = None):
        """
        HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.
        :param pulumi.Input[int] desired_replicas: desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input['HorizontalPodAutoscalerConditionArgs']]] conditions: conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
        :param pulumi.Input[Sequence[pulumi.Input['MetricStatusArgs']]] current_metrics: currentMetrics is the last read state of the metrics used by this autoscaler.
        :param pulumi.Input[int] current_replicas: currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
        :param pulumi.Input[str] last_scale_time: lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
        :param pulumi.Input[int] observed_generation: observedGeneration is the most recent generation observed by this autoscaler.
        """
        pulumi.set(__self__, "desired_replicas", desired_replicas)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_metrics is not None:
            pulumi.set(__self__, "current_metrics", current_metrics)
        if current_replicas is not None:
            pulumi.set(__self__, "current_replicas", current_replicas)
        if last_scale_time is not None:
            pulumi.set(__self__, "last_scale_time", last_scale_time)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)

    @property
    @pulumi.getter(name="desiredReplicas")
    def desired_replicas(self) -> pulumi.Input[int]:
        """
        desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.
        """
        return pulumi.get(self, "desired_replicas")

    @desired_replicas.setter
    def desired_replicas(self, value: pulumi.Input[int]):
        pulumi.set(self, "desired_replicas", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HorizontalPodAutoscalerConditionArgs']]]]:
        """
        conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HorizontalPodAutoscalerConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="currentMetrics")
    def current_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricStatusArgs']]]]:
        """
        currentMetrics is the last read state of the metrics used by this autoscaler.
        """
        return pulumi.get(self, "current_metrics")

    @current_metrics.setter
    def current_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricStatusArgs']]]]):
        pulumi.set(self, "current_metrics", value)

    @property
    @pulumi.getter(name="currentReplicas")
    def current_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.
        """
        return pulumi.get(self, "current_replicas")

    @current_replicas.setter
    def current_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "current_replicas", value)

    @property
    @pulumi.getter(name="lastScaleTime")
    def last_scale_time(self) -> Optional[pulumi.Input[str]]:
        """
        lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.
        """
        return pulumi.get(self, "last_scale_time")

    @last_scale_time.setter
    def last_scale_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_scale_time", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[int]]:
        """
        observedGeneration is the most recent generation observed by this autoscaler.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "observed_generation", value)


@pulumi.input_type
class HorizontalPodAutoscalerArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['HorizontalPodAutoscalerSpecArgs']] = None,
                 status: Optional[pulumi.Input['HorizontalPodAutoscalerStatusArgs']] = None):
        """
        HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['HorizontalPodAutoscalerSpecArgs'] spec: spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        :param pulumi.Input['HorizontalPodAutoscalerStatusArgs'] status: status is the current information about the autoscaler.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'autoscaling/v2')
        if kind is not None:
            pulumi.set(__self__, "kind", 'HorizontalPodAutoscaler')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['HorizontalPodAutoscalerSpecArgs']]:
        """
        spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['HorizontalPodAutoscalerSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['HorizontalPodAutoscalerStatusArgs']]:
        """
        status is the current information about the autoscaler.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['HorizontalPodAutoscalerStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class MetricIdentifierPatchArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 selector: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']] = None):
        """
        MetricIdentifier defines the name and optionally selector for a metric
        :param pulumi.Input[str] name: name is the name of the given metric
        :param pulumi.Input['_meta.v1.LabelSelectorPatchArgs'] selector: selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name is the name of the given metric
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]:
        """
        selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class MetricIdentifierArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None):
        """
        MetricIdentifier defines the name and optionally selector for a metric
        :param pulumi.Input[str] name: name is the name of the given metric
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] selector: selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        pulumi.set(__self__, "name", name)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the name of the given metric
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class MetricSpecPatchArgs:
    def __init__(__self__, *,
                 container_resource: Optional[pulumi.Input['ContainerResourceMetricSourcePatchArgs']] = None,
                 external: Optional[pulumi.Input['ExternalMetricSourcePatchArgs']] = None,
                 object: Optional[pulumi.Input['ObjectMetricSourcePatchArgs']] = None,
                 pods: Optional[pulumi.Input['PodsMetricSourcePatchArgs']] = None,
                 resource: Optional[pulumi.Input['ResourceMetricSourcePatchArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
        :param pulumi.Input['ContainerResourceMetricSourcePatchArgs'] container_resource: containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
        :param pulumi.Input['ExternalMetricSourcePatchArgs'] external: external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param pulumi.Input['ObjectMetricSourcePatchArgs'] object: object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        :param pulumi.Input['PodsMetricSourcePatchArgs'] pods: pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        :param pulumi.Input['ResourceMetricSourcePatchArgs'] resource: resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param pulumi.Input[str] type: type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        """
        if container_resource is not None:
            pulumi.set(__self__, "container_resource", container_resource)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if pods is not None:
            pulumi.set(__self__, "pods", pods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="containerResource")
    def container_resource(self) -> Optional[pulumi.Input['ContainerResourceMetricSourcePatchArgs']]:
        """
        containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
        """
        return pulumi.get(self, "container_resource")

    @container_resource.setter
    def container_resource(self, value: Optional[pulumi.Input['ContainerResourceMetricSourcePatchArgs']]):
        pulumi.set(self, "container_resource", value)

    @property
    @pulumi.getter
    def external(self) -> Optional[pulumi.Input['ExternalMetricSourcePatchArgs']]:
        """
        external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        """
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input['ExternalMetricSourcePatchArgs']]):
        pulumi.set(self, "external", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input['ObjectMetricSourcePatchArgs']]:
        """
        object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input['ObjectMetricSourcePatchArgs']]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def pods(self) -> Optional[pulumi.Input['PodsMetricSourcePatchArgs']]:
        """
        pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        """
        return pulumi.get(self, "pods")

    @pods.setter
    def pods(self, value: Optional[pulumi.Input['PodsMetricSourcePatchArgs']]):
        pulumi.set(self, "pods", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input['ResourceMetricSourcePatchArgs']]:
        """
        resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input['ResourceMetricSourcePatchArgs']]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MetricSpecArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 container_resource: Optional[pulumi.Input['ContainerResourceMetricSourceArgs']] = None,
                 external: Optional[pulumi.Input['ExternalMetricSourceArgs']] = None,
                 object: Optional[pulumi.Input['ObjectMetricSourceArgs']] = None,
                 pods: Optional[pulumi.Input['PodsMetricSourceArgs']] = None,
                 resource: Optional[pulumi.Input['ResourceMetricSourceArgs']] = None):
        """
        MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).
        :param pulumi.Input[str] type: type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        :param pulumi.Input['ContainerResourceMetricSourceArgs'] container_resource: containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
        :param pulumi.Input['ExternalMetricSourceArgs'] external: external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param pulumi.Input['ObjectMetricSourceArgs'] object: object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        :param pulumi.Input['PodsMetricSourceArgs'] pods: pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        :param pulumi.Input['ResourceMetricSourceArgs'] resource: resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        pulumi.set(__self__, "type", type)
        if container_resource is not None:
            pulumi.set(__self__, "container_resource", container_resource)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if pods is not None:
            pulumi.set(__self__, "pods", pods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        type is the type of metric source.  It should be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each mapping to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="containerResource")
    def container_resource(self) -> Optional[pulumi.Input['ContainerResourceMetricSourceArgs']]:
        """
        containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. This is an alpha feature and can be enabled by the HPAContainerMetrics feature flag.
        """
        return pulumi.get(self, "container_resource")

    @container_resource.setter
    def container_resource(self, value: Optional[pulumi.Input['ContainerResourceMetricSourceArgs']]):
        pulumi.set(self, "container_resource", value)

    @property
    @pulumi.getter
    def external(self) -> Optional[pulumi.Input['ExternalMetricSourceArgs']]:
        """
        external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        """
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input['ExternalMetricSourceArgs']]):
        pulumi.set(self, "external", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input['ObjectMetricSourceArgs']]:
        """
        object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input['ObjectMetricSourceArgs']]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def pods(self) -> Optional[pulumi.Input['PodsMetricSourceArgs']]:
        """
        pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        """
        return pulumi.get(self, "pods")

    @pods.setter
    def pods(self, value: Optional[pulumi.Input['PodsMetricSourceArgs']]):
        pulumi.set(self, "pods", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input['ResourceMetricSourceArgs']]:
        """
        resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input['ResourceMetricSourceArgs']]):
        pulumi.set(self, "resource", value)


@pulumi.input_type
class MetricStatusArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 container_resource: Optional[pulumi.Input['ContainerResourceMetricStatusArgs']] = None,
                 external: Optional[pulumi.Input['ExternalMetricStatusArgs']] = None,
                 object: Optional[pulumi.Input['ObjectMetricStatusArgs']] = None,
                 pods: Optional[pulumi.Input['PodsMetricStatusArgs']] = None,
                 resource: Optional[pulumi.Input['ResourceMetricStatusArgs']] = None):
        """
        MetricStatus describes the last-read state of a single metric.
        :param pulumi.Input[str] type: type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        :param pulumi.Input['ContainerResourceMetricStatusArgs'] container_resource: container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param pulumi.Input['ExternalMetricStatusArgs'] external: external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        :param pulumi.Input['ObjectMetricStatusArgs'] object: object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        :param pulumi.Input['PodsMetricStatusArgs'] pods: pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        :param pulumi.Input['ResourceMetricStatusArgs'] resource: resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        pulumi.set(__self__, "type", type)
        if container_resource is not None:
            pulumi.set(__self__, "container_resource", container_resource)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if pods is not None:
            pulumi.set(__self__, "pods", pods)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        type is the type of metric source.  It will be one of "ContainerResource", "External", "Object", "Pods" or "Resource", each corresponds to a matching field in the object. Note: "ContainerResource" type is available on when the feature-gate HPAContainerMetrics is enabled
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="containerResource")
    def container_resource(self) -> Optional[pulumi.Input['ContainerResourceMetricStatusArgs']]:
        """
        container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "container_resource")

    @container_resource.setter
    def container_resource(self, value: Optional[pulumi.Input['ContainerResourceMetricStatusArgs']]):
        pulumi.set(self, "container_resource", value)

    @property
    @pulumi.getter
    def external(self) -> Optional[pulumi.Input['ExternalMetricStatusArgs']]:
        """
        external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).
        """
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input['ExternalMetricStatusArgs']]):
        pulumi.set(self, "external", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input['ObjectMetricStatusArgs']]:
        """
        object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input['ObjectMetricStatusArgs']]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def pods(self) -> Optional[pulumi.Input['PodsMetricStatusArgs']]:
        """
        pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.
        """
        return pulumi.get(self, "pods")

    @pods.setter
    def pods(self, value: Optional[pulumi.Input['PodsMetricStatusArgs']]):
        pulumi.set(self, "pods", value)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input['ResourceMetricStatusArgs']]:
        """
        resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input['ResourceMetricStatusArgs']]):
        pulumi.set(self, "resource", value)


@pulumi.input_type
class MetricTargetPatchArgs:
    def __init__(__self__, *,
                 average_utilization: Optional[pulumi.Input[int]] = None,
                 average_value: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        MetricTarget defines the target value, average value, or average utilization of a specific metric
        :param pulumi.Input[int] average_utilization: averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
        :param pulumi.Input[str] average_value: averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        :param pulumi.Input[str] type: type represents whether the metric type is Utilization, Value, or AverageValue
        :param pulumi.Input[str] value: value is the target value of the metric (as a quantity).
        """
        if average_utilization is not None:
            pulumi.set(__self__, "average_utilization", average_utilization)
        if average_value is not None:
            pulumi.set(__self__, "average_value", average_value)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="averageUtilization")
    def average_utilization(self) -> Optional[pulumi.Input[int]]:
        """
        averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
        """
        return pulumi.get(self, "average_utilization")

    @average_utilization.setter
    def average_utilization(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "average_utilization", value)

    @property
    @pulumi.getter(name="averageValue")
    def average_value(self) -> Optional[pulumi.Input[str]]:
        """
        averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "average_value")

    @average_value.setter
    def average_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "average_value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        type represents whether the metric type is Utilization, Value, or AverageValue
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        value is the target value of the metric (as a quantity).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class MetricTargetArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 average_utilization: Optional[pulumi.Input[int]] = None,
                 average_value: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        MetricTarget defines the target value, average value, or average utilization of a specific metric
        :param pulumi.Input[str] type: type represents whether the metric type is Utilization, Value, or AverageValue
        :param pulumi.Input[int] average_utilization: averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
        :param pulumi.Input[str] average_value: averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        :param pulumi.Input[str] value: value is the target value of the metric (as a quantity).
        """
        pulumi.set(__self__, "type", type)
        if average_utilization is not None:
            pulumi.set(__self__, "average_utilization", average_utilization)
        if average_value is not None:
            pulumi.set(__self__, "average_value", average_value)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        type represents whether the metric type is Utilization, Value, or AverageValue
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="averageUtilization")
    def average_utilization(self) -> Optional[pulumi.Input[int]]:
        """
        averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type
        """
        return pulumi.get(self, "average_utilization")

    @average_utilization.setter
    def average_utilization(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "average_utilization", value)

    @property
    @pulumi.getter(name="averageValue")
    def average_value(self) -> Optional[pulumi.Input[str]]:
        """
        averageValue is the target value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "average_value")

    @average_value.setter
    def average_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "average_value", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        value is the target value of the metric (as a quantity).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class MetricValueStatusArgs:
    def __init__(__self__, *,
                 average_utilization: Optional[pulumi.Input[int]] = None,
                 average_value: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        MetricValueStatus holds the current value for a metric
        :param pulumi.Input[int] average_utilization: currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        :param pulumi.Input[str] average_value: averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        :param pulumi.Input[str] value: value is the current value of the metric (as a quantity).
        """
        if average_utilization is not None:
            pulumi.set(__self__, "average_utilization", average_utilization)
        if average_value is not None:
            pulumi.set(__self__, "average_value", average_value)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="averageUtilization")
    def average_utilization(self) -> Optional[pulumi.Input[int]]:
        """
        currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.
        """
        return pulumi.get(self, "average_utilization")

    @average_utilization.setter
    def average_utilization(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "average_utilization", value)

    @property
    @pulumi.getter(name="averageValue")
    def average_value(self) -> Optional[pulumi.Input[str]]:
        """
        averageValue is the current value of the average of the metric across all relevant pods (as a quantity)
        """
        return pulumi.get(self, "average_value")

    @average_value.setter
    def average_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "average_value", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        value is the current value of the metric (as a quantity).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ObjectMetricSourcePatchArgs:
    def __init__(__self__, *,
                 described_object: Optional[pulumi.Input['CrossVersionObjectReferencePatchArgs']] = None,
                 metric: Optional[pulumi.Input['MetricIdentifierPatchArgs']] = None,
                 target: Optional[pulumi.Input['MetricTargetPatchArgs']] = None):
        """
        ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
        :param pulumi.Input['CrossVersionObjectReferencePatchArgs'] described_object: describedObject specifies the descriptions of a object,such as kind,name apiVersion
        :param pulumi.Input['MetricIdentifierPatchArgs'] metric: metric identifies the target metric by name and selector
        :param pulumi.Input['MetricTargetPatchArgs'] target: target specifies the target value for the given metric
        """
        if described_object is not None:
            pulumi.set(__self__, "described_object", described_object)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="describedObject")
    def described_object(self) -> Optional[pulumi.Input['CrossVersionObjectReferencePatchArgs']]:
        """
        describedObject specifies the descriptions of a object,such as kind,name apiVersion
        """
        return pulumi.get(self, "described_object")

    @described_object.setter
    def described_object(self, value: Optional[pulumi.Input['CrossVersionObjectReferencePatchArgs']]):
        pulumi.set(self, "described_object", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input['MetricIdentifierPatchArgs']]:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input['MetricIdentifierPatchArgs']]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['MetricTargetPatchArgs']]:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['MetricTargetPatchArgs']]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class ObjectMetricSourceArgs:
    def __init__(__self__, *,
                 described_object: pulumi.Input['CrossVersionObjectReferenceArgs'],
                 metric: pulumi.Input['MetricIdentifierArgs'],
                 target: pulumi.Input['MetricTargetArgs']):
        """
        ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
        :param pulumi.Input['CrossVersionObjectReferenceArgs'] described_object: describedObject specifies the descriptions of a object,such as kind,name apiVersion
        :param pulumi.Input['MetricIdentifierArgs'] metric: metric identifies the target metric by name and selector
        :param pulumi.Input['MetricTargetArgs'] target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "described_object", described_object)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="describedObject")
    def described_object(self) -> pulumi.Input['CrossVersionObjectReferenceArgs']:
        """
        describedObject specifies the descriptions of a object,such as kind,name apiVersion
        """
        return pulumi.get(self, "described_object")

    @described_object.setter
    def described_object(self, value: pulumi.Input['CrossVersionObjectReferenceArgs']):
        pulumi.set(self, "described_object", value)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['MetricIdentifierArgs']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['MetricIdentifierArgs']):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input['MetricTargetArgs']:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input['MetricTargetArgs']):
        pulumi.set(self, "target", value)


@pulumi.input_type
class ObjectMetricStatusArgs:
    def __init__(__self__, *,
                 current: pulumi.Input['MetricValueStatusArgs'],
                 described_object: pulumi.Input['CrossVersionObjectReferenceArgs'],
                 metric: pulumi.Input['MetricIdentifierArgs']):
        """
        ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).
        :param pulumi.Input['MetricValueStatusArgs'] current: current contains the current value for the given metric
        :param pulumi.Input['CrossVersionObjectReferenceArgs'] described_object: DescribedObject specifies the descriptions of a object,such as kind,name apiVersion
        :param pulumi.Input['MetricIdentifierArgs'] metric: metric identifies the target metric by name and selector
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "described_object", described_object)
        pulumi.set(__self__, "metric", metric)

    @property
    @pulumi.getter
    def current(self) -> pulumi.Input['MetricValueStatusArgs']:
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @current.setter
    def current(self, value: pulumi.Input['MetricValueStatusArgs']):
        pulumi.set(self, "current", value)

    @property
    @pulumi.getter(name="describedObject")
    def described_object(self) -> pulumi.Input['CrossVersionObjectReferenceArgs']:
        """
        DescribedObject specifies the descriptions of a object,such as kind,name apiVersion
        """
        return pulumi.get(self, "described_object")

    @described_object.setter
    def described_object(self, value: pulumi.Input['CrossVersionObjectReferenceArgs']):
        pulumi.set(self, "described_object", value)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['MetricIdentifierArgs']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['MetricIdentifierArgs']):
        pulumi.set(self, "metric", value)


@pulumi.input_type
class PodsMetricSourcePatchArgs:
    def __init__(__self__, *,
                 metric: Optional[pulumi.Input['MetricIdentifierPatchArgs']] = None,
                 target: Optional[pulumi.Input['MetricTargetPatchArgs']] = None):
        """
        PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.
        :param pulumi.Input['MetricIdentifierPatchArgs'] metric: metric identifies the target metric by name and selector
        :param pulumi.Input['MetricTargetPatchArgs'] target: target specifies the target value for the given metric
        """
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input['MetricIdentifierPatchArgs']]:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input['MetricIdentifierPatchArgs']]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['MetricTargetPatchArgs']]:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['MetricTargetPatchArgs']]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class PodsMetricSourceArgs:
    def __init__(__self__, *,
                 metric: pulumi.Input['MetricIdentifierArgs'],
                 target: pulumi.Input['MetricTargetArgs']):
        """
        PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.
        :param pulumi.Input['MetricIdentifierArgs'] metric: metric identifies the target metric by name and selector
        :param pulumi.Input['MetricTargetArgs'] target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['MetricIdentifierArgs']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['MetricIdentifierArgs']):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input['MetricTargetArgs']:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input['MetricTargetArgs']):
        pulumi.set(self, "target", value)


@pulumi.input_type
class PodsMetricStatusArgs:
    def __init__(__self__, *,
                 current: pulumi.Input['MetricValueStatusArgs'],
                 metric: pulumi.Input['MetricIdentifierArgs']):
        """
        PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).
        :param pulumi.Input['MetricValueStatusArgs'] current: current contains the current value for the given metric
        :param pulumi.Input['MetricIdentifierArgs'] metric: metric identifies the target metric by name and selector
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "metric", metric)

    @property
    @pulumi.getter
    def current(self) -> pulumi.Input['MetricValueStatusArgs']:
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @current.setter
    def current(self, value: pulumi.Input['MetricValueStatusArgs']):
        pulumi.set(self, "current", value)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['MetricIdentifierArgs']:
        """
        metric identifies the target metric by name and selector
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['MetricIdentifierArgs']):
        pulumi.set(self, "metric", value)


@pulumi.input_type
class ResourceMetricSourcePatchArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input['MetricTargetPatchArgs']] = None):
        """
        ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param pulumi.Input[str] name: name is the name of the resource in question.
        :param pulumi.Input['MetricTargetPatchArgs'] target: target specifies the target value for the given metric
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input['MetricTargetPatchArgs']]:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input['MetricTargetPatchArgs']]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class ResourceMetricSourceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 target: pulumi.Input['MetricTargetArgs']):
        """
        ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set.
        :param pulumi.Input[str] name: name is the name of the resource in question.
        :param pulumi.Input['MetricTargetArgs'] target: target specifies the target value for the given metric
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input['MetricTargetArgs']:
        """
        target specifies the target value for the given metric
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input['MetricTargetArgs']):
        pulumi.set(self, "target", value)


@pulumi.input_type
class ResourceMetricStatusArgs:
    def __init__(__self__, *,
                 current: pulumi.Input['MetricValueStatusArgs'],
                 name: pulumi.Input[str]):
        """
        ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.
        :param pulumi.Input['MetricValueStatusArgs'] current: current contains the current value for the given metric
        :param pulumi.Input[str] name: name is the name of the resource in question.
        """
        pulumi.set(__self__, "current", current)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def current(self) -> pulumi.Input['MetricValueStatusArgs']:
        """
        current contains the current value for the given metric
        """
        return pulumi.get(self, "current")

    @current.setter
    def current(self, value: pulumi.Input['MetricValueStatusArgs']):
        pulumi.set(self, "current", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the name of the resource in question.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


