# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ... import meta as _meta

__all__ = [
    'ExemptPriorityLevelConfigurationPatchArgs',
    'ExemptPriorityLevelConfigurationArgs',
    'FlowDistinguisherMethodPatchArgs',
    'FlowDistinguisherMethodArgs',
    'FlowSchemaConditionArgs',
    'FlowSchemaSpecPatchArgs',
    'FlowSchemaSpecArgs',
    'FlowSchemaStatusArgs',
    'FlowSchemaArgs',
    'GroupSubjectPatchArgs',
    'GroupSubjectArgs',
    'LimitResponsePatchArgs',
    'LimitResponseArgs',
    'LimitedPriorityLevelConfigurationPatchArgs',
    'LimitedPriorityLevelConfigurationArgs',
    'NonResourcePolicyRulePatchArgs',
    'NonResourcePolicyRuleArgs',
    'PolicyRulesWithSubjectsPatchArgs',
    'PolicyRulesWithSubjectsArgs',
    'PriorityLevelConfigurationConditionArgs',
    'PriorityLevelConfigurationReferencePatchArgs',
    'PriorityLevelConfigurationReferenceArgs',
    'PriorityLevelConfigurationSpecPatchArgs',
    'PriorityLevelConfigurationSpecArgs',
    'PriorityLevelConfigurationStatusArgs',
    'PriorityLevelConfigurationArgs',
    'QueuingConfigurationPatchArgs',
    'QueuingConfigurationArgs',
    'ResourcePolicyRulePatchArgs',
    'ResourcePolicyRuleArgs',
    'ServiceAccountSubjectPatchArgs',
    'ServiceAccountSubjectArgs',
    'SubjectPatchArgs',
    'SubjectArgs',
    'UserSubjectPatchArgs',
    'UserSubjectArgs',
]

@pulumi.input_type
class ExemptPriorityLevelConfigurationPatchArgs:
    def __init__(__self__, *,
                 lendable_percent: Optional[pulumi.Input[int]] = None,
                 nominal_concurrency_shares: Optional[pulumi.Input[int]] = None):
        """
        ExemptPriorityLevelConfiguration describes the configurable aspects of the handling of exempt requests. In the mandatory exempt configuration object the values in the fields here can be modified by authorized users, unlike the rest of the `spec`.
        :param pulumi.Input[int] lendable_percent: `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.  This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.
               
               LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        :param pulumi.Input[int] nominal_concurrency_shares: `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:
               
               NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)
               
               Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.
        """
        if lendable_percent is not None:
            pulumi.set(__self__, "lendable_percent", lendable_percent)
        if nominal_concurrency_shares is not None:
            pulumi.set(__self__, "nominal_concurrency_shares", nominal_concurrency_shares)

    @property
    @pulumi.getter(name="lendablePercent")
    def lendable_percent(self) -> Optional[pulumi.Input[int]]:
        """
        `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.  This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

        LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        """
        return pulumi.get(self, "lendable_percent")

    @lendable_percent.setter
    def lendable_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lendable_percent", value)

    @property
    @pulumi.getter(name="nominalConcurrencyShares")
    def nominal_concurrency_shares(self) -> Optional[pulumi.Input[int]]:
        """
        `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:

        NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

        Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.
        """
        return pulumi.get(self, "nominal_concurrency_shares")

    @nominal_concurrency_shares.setter
    def nominal_concurrency_shares(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nominal_concurrency_shares", value)


@pulumi.input_type
class ExemptPriorityLevelConfigurationArgs:
    def __init__(__self__, *,
                 lendable_percent: Optional[pulumi.Input[int]] = None,
                 nominal_concurrency_shares: Optional[pulumi.Input[int]] = None):
        """
        ExemptPriorityLevelConfiguration describes the configurable aspects of the handling of exempt requests. In the mandatory exempt configuration object the values in the fields here can be modified by authorized users, unlike the rest of the `spec`.
        :param pulumi.Input[int] lendable_percent: `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.  This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.
               
               LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        :param pulumi.Input[int] nominal_concurrency_shares: `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:
               
               NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)
               
               Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.
        """
        if lendable_percent is not None:
            pulumi.set(__self__, "lendable_percent", lendable_percent)
        if nominal_concurrency_shares is not None:
            pulumi.set(__self__, "nominal_concurrency_shares", nominal_concurrency_shares)

    @property
    @pulumi.getter(name="lendablePercent")
    def lendable_percent(self) -> Optional[pulumi.Input[int]]:
        """
        `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels.  This value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

        LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        """
        return pulumi.get(self, "lendable_percent")

    @lendable_percent.setter
    def lendable_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lendable_percent", value)

    @property
    @pulumi.getter(name="nominalConcurrencyShares")
    def nominal_concurrency_shares(self) -> Optional[pulumi.Input[int]]:
        """
        `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats nominally reserved for this priority level. This DOES NOT limit the dispatching from this priority level but affects the other priority levels through the borrowing mechanism. The server's concurrency limit (ServerCL) is divided among all the priority levels in proportion to their NCS values:

        NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

        Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level. This field has a default value of zero.
        """
        return pulumi.get(self, "nominal_concurrency_shares")

    @nominal_concurrency_shares.setter
    def nominal_concurrency_shares(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nominal_concurrency_shares", value)


@pulumi.input_type
class FlowDistinguisherMethodPatchArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None):
        """
        FlowDistinguisherMethod specifies the method of a flow distinguisher.
        :param pulumi.Input[str] type: `type` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        `type` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class FlowDistinguisherMethodArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str]):
        """
        FlowDistinguisherMethod specifies the method of a flow distinguisher.
        :param pulumi.Input[str] type: `type` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        `type` is the type of flow distinguisher method The supported types are "ByUser" and "ByNamespace". Required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class FlowSchemaConditionArgs:
    def __init__(__self__, *,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        FlowSchemaCondition describes conditions for a FlowSchema.
        :param pulumi.Input[str] last_transition_time: `lastTransitionTime` is the last time the condition transitioned from one status to another.
        :param pulumi.Input[str] message: `message` is a human-readable message indicating details about last transition.
        :param pulumi.Input[str] reason: `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        :param pulumi.Input[str] status: `status` is the status of the condition. Can be True, False, Unknown. Required.
        :param pulumi.Input[str] type: `type` is the type of the condition. Required.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        `lastTransitionTime` is the last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        `message` is a human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        `status` is the status of the condition. Can be True, False, Unknown. Required.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        `type` is the type of the condition. Required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class FlowSchemaSpecPatchArgs:
    def __init__(__self__, *,
                 distinguisher_method: Optional[pulumi.Input['FlowDistinguisherMethodPatchArgs']] = None,
                 matching_precedence: Optional[pulumi.Input[int]] = None,
                 priority_level_configuration: Optional[pulumi.Input['PriorityLevelConfigurationReferencePatchArgs']] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRulesWithSubjectsPatchArgs']]]] = None):
        """
        FlowSchemaSpec describes how the FlowSchema's specification looks like.
        :param pulumi.Input['FlowDistinguisherMethodPatchArgs'] distinguisher_method: `distinguisherMethod` defines how to compute the flow distinguisher for requests that match this schema. `nil` specifies that the distinguisher is disabled and thus will always be the empty string.
        :param pulumi.Input[int] matching_precedence: `matchingPrecedence` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        :param pulumi.Input['PriorityLevelConfigurationReferencePatchArgs'] priority_level_configuration: `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyRulesWithSubjectsPatchArgs']]] rules: `rules` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
        """
        if distinguisher_method is not None:
            pulumi.set(__self__, "distinguisher_method", distinguisher_method)
        if matching_precedence is not None:
            pulumi.set(__self__, "matching_precedence", matching_precedence)
        if priority_level_configuration is not None:
            pulumi.set(__self__, "priority_level_configuration", priority_level_configuration)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="distinguisherMethod")
    def distinguisher_method(self) -> Optional[pulumi.Input['FlowDistinguisherMethodPatchArgs']]:
        """
        `distinguisherMethod` defines how to compute the flow distinguisher for requests that match this schema. `nil` specifies that the distinguisher is disabled and thus will always be the empty string.
        """
        return pulumi.get(self, "distinguisher_method")

    @distinguisher_method.setter
    def distinguisher_method(self, value: Optional[pulumi.Input['FlowDistinguisherMethodPatchArgs']]):
        pulumi.set(self, "distinguisher_method", value)

    @property
    @pulumi.getter(name="matchingPrecedence")
    def matching_precedence(self) -> Optional[pulumi.Input[int]]:
        """
        `matchingPrecedence` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        """
        return pulumi.get(self, "matching_precedence")

    @matching_precedence.setter
    def matching_precedence(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "matching_precedence", value)

    @property
    @pulumi.getter(name="priorityLevelConfiguration")
    def priority_level_configuration(self) -> Optional[pulumi.Input['PriorityLevelConfigurationReferencePatchArgs']]:
        """
        `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        """
        return pulumi.get(self, "priority_level_configuration")

    @priority_level_configuration.setter
    def priority_level_configuration(self, value: Optional[pulumi.Input['PriorityLevelConfigurationReferencePatchArgs']]):
        pulumi.set(self, "priority_level_configuration", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRulesWithSubjectsPatchArgs']]]]:
        """
        `rules` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRulesWithSubjectsPatchArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class FlowSchemaSpecArgs:
    def __init__(__self__, *,
                 priority_level_configuration: pulumi.Input['PriorityLevelConfigurationReferenceArgs'],
                 distinguisher_method: Optional[pulumi.Input['FlowDistinguisherMethodArgs']] = None,
                 matching_precedence: Optional[pulumi.Input[int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRulesWithSubjectsArgs']]]] = None):
        """
        FlowSchemaSpec describes how the FlowSchema's specification looks like.
        :param pulumi.Input['PriorityLevelConfigurationReferenceArgs'] priority_level_configuration: `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        :param pulumi.Input['FlowDistinguisherMethodArgs'] distinguisher_method: `distinguisherMethod` defines how to compute the flow distinguisher for requests that match this schema. `nil` specifies that the distinguisher is disabled and thus will always be the empty string.
        :param pulumi.Input[int] matching_precedence: `matchingPrecedence` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyRulesWithSubjectsArgs']]] rules: `rules` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
        """
        pulumi.set(__self__, "priority_level_configuration", priority_level_configuration)
        if distinguisher_method is not None:
            pulumi.set(__self__, "distinguisher_method", distinguisher_method)
        if matching_precedence is not None:
            pulumi.set(__self__, "matching_precedence", matching_precedence)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="priorityLevelConfiguration")
    def priority_level_configuration(self) -> pulumi.Input['PriorityLevelConfigurationReferenceArgs']:
        """
        `priorityLevelConfiguration` should reference a PriorityLevelConfiguration in the cluster. If the reference cannot be resolved, the FlowSchema will be ignored and marked as invalid in its status. Required.
        """
        return pulumi.get(self, "priority_level_configuration")

    @priority_level_configuration.setter
    def priority_level_configuration(self, value: pulumi.Input['PriorityLevelConfigurationReferenceArgs']):
        pulumi.set(self, "priority_level_configuration", value)

    @property
    @pulumi.getter(name="distinguisherMethod")
    def distinguisher_method(self) -> Optional[pulumi.Input['FlowDistinguisherMethodArgs']]:
        """
        `distinguisherMethod` defines how to compute the flow distinguisher for requests that match this schema. `nil` specifies that the distinguisher is disabled and thus will always be the empty string.
        """
        return pulumi.get(self, "distinguisher_method")

    @distinguisher_method.setter
    def distinguisher_method(self, value: Optional[pulumi.Input['FlowDistinguisherMethodArgs']]):
        pulumi.set(self, "distinguisher_method", value)

    @property
    @pulumi.getter(name="matchingPrecedence")
    def matching_precedence(self) -> Optional[pulumi.Input[int]]:
        """
        `matchingPrecedence` is used to choose among the FlowSchemas that match a given request. The chosen FlowSchema is among those with the numerically lowest (which we take to be logically highest) MatchingPrecedence.  Each MatchingPrecedence value must be ranged in [1,10000]. Note that if the precedence is not specified, it will be set to 1000 as default.
        """
        return pulumi.get(self, "matching_precedence")

    @matching_precedence.setter
    def matching_precedence(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "matching_precedence", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRulesWithSubjectsArgs']]]]:
        """
        `rules` describes which requests will match this flow schema. This FlowSchema matches a request if and only if at least one member of rules matches the request. if it is an empty slice, there will be no requests matching the FlowSchema.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyRulesWithSubjectsArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class FlowSchemaStatusArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['FlowSchemaConditionArgs']]]] = None):
        """
        FlowSchemaStatus represents the current state of a FlowSchema.
        :param pulumi.Input[Sequence[pulumi.Input['FlowSchemaConditionArgs']]] conditions: `conditions` is a list of the current states of FlowSchema.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlowSchemaConditionArgs']]]]:
        """
        `conditions` is a list of the current states of FlowSchema.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlowSchemaConditionArgs']]]]):
        pulumi.set(self, "conditions", value)


@pulumi.input_type
class FlowSchemaArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['FlowSchemaSpecArgs']] = None,
                 status: Optional[pulumi.Input['FlowSchemaStatusArgs']] = None):
        """
        FlowSchema defines the schema of a group of flows. Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher".
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['FlowSchemaSpecArgs'] spec: `spec` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param pulumi.Input['FlowSchemaStatusArgs'] status: `status` is the current status of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'flowcontrol.apiserver.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'FlowSchema')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['FlowSchemaSpecArgs']]:
        """
        `spec` is the specification of the desired behavior of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['FlowSchemaSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['FlowSchemaStatusArgs']]:
        """
        `status` is the current status of a FlowSchema. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['FlowSchemaStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class GroupSubjectPatchArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        GroupSubject holds detailed information for group-kind subject.
        :param pulumi.Input[str] name: name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class GroupSubjectArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        GroupSubject holds detailed information for group-kind subject.
        :param pulumi.Input[str] name: name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the user group that matches, or "*" to match all user groups. See https://github.com/kubernetes/apiserver/blob/master/pkg/authentication/user/user.go for some well-known group names. Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LimitResponsePatchArgs:
    def __init__(__self__, *,
                 queuing: Optional[pulumi.Input['QueuingConfigurationPatchArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        LimitResponse defines how to handle requests that can not be executed right now.
        :param pulumi.Input['QueuingConfigurationPatchArgs'] queuing: `queuing` holds the configuration parameters for queuing. This field may be non-empty only if `type` is `"Queue"`.
        :param pulumi.Input[str] type: `type` is "Queue" or "Reject". "Queue" means that requests that can not be executed upon arrival are held in a queue until they can be executed or a queuing limit is reached. "Reject" means that requests that can not be executed upon arrival are rejected. Required.
        """
        if queuing is not None:
            pulumi.set(__self__, "queuing", queuing)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def queuing(self) -> Optional[pulumi.Input['QueuingConfigurationPatchArgs']]:
        """
        `queuing` holds the configuration parameters for queuing. This field may be non-empty only if `type` is `"Queue"`.
        """
        return pulumi.get(self, "queuing")

    @queuing.setter
    def queuing(self, value: Optional[pulumi.Input['QueuingConfigurationPatchArgs']]):
        pulumi.set(self, "queuing", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        `type` is "Queue" or "Reject". "Queue" means that requests that can not be executed upon arrival are held in a queue until they can be executed or a queuing limit is reached. "Reject" means that requests that can not be executed upon arrival are rejected. Required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class LimitResponseArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 queuing: Optional[pulumi.Input['QueuingConfigurationArgs']] = None):
        """
        LimitResponse defines how to handle requests that can not be executed right now.
        :param pulumi.Input[str] type: `type` is "Queue" or "Reject". "Queue" means that requests that can not be executed upon arrival are held in a queue until they can be executed or a queuing limit is reached. "Reject" means that requests that can not be executed upon arrival are rejected. Required.
        :param pulumi.Input['QueuingConfigurationArgs'] queuing: `queuing` holds the configuration parameters for queuing. This field may be non-empty only if `type` is `"Queue"`.
        """
        pulumi.set(__self__, "type", type)
        if queuing is not None:
            pulumi.set(__self__, "queuing", queuing)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        `type` is "Queue" or "Reject". "Queue" means that requests that can not be executed upon arrival are held in a queue until they can be executed or a queuing limit is reached. "Reject" means that requests that can not be executed upon arrival are rejected. Required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def queuing(self) -> Optional[pulumi.Input['QueuingConfigurationArgs']]:
        """
        `queuing` holds the configuration parameters for queuing. This field may be non-empty only if `type` is `"Queue"`.
        """
        return pulumi.get(self, "queuing")

    @queuing.setter
    def queuing(self, value: Optional[pulumi.Input['QueuingConfigurationArgs']]):
        pulumi.set(self, "queuing", value)


@pulumi.input_type
class LimitedPriorityLevelConfigurationPatchArgs:
    def __init__(__self__, *,
                 borrowing_limit_percent: Optional[pulumi.Input[int]] = None,
                 lendable_percent: Optional[pulumi.Input[int]] = None,
                 limit_response: Optional[pulumi.Input['LimitResponsePatchArgs']] = None,
                 nominal_concurrency_shares: Optional[pulumi.Input[int]] = None):
        """
        LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:
          - How are requests for this priority level limited?
          - What should be done with requests that exceed the limit?
        :param pulumi.Input[int] borrowing_limit_percent: `borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.
               
               BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )
               
               The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.
        :param pulumi.Input[int] lendable_percent: `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.
               
               LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        :param pulumi.Input['LimitResponsePatchArgs'] limit_response: `limitResponse` indicates what to do with requests that can not be executed right now
        :param pulumi.Input[int] nominal_concurrency_shares: `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats available at this priority level. This is used both for requests dispatched from this priority level as well as requests dispatched from other priority levels borrowing seats from this level. The server's concurrency limit (ServerCL) is divided among the Limited priority levels in proportion to their NCS values:
               
               NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)
               
               Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level.
               
               If not specified, this field defaults to a value of 30.
               
               Setting this field to zero supports the construction of a "jail" for this priority level that is used to hold some request(s)
        """
        if borrowing_limit_percent is not None:
            pulumi.set(__self__, "borrowing_limit_percent", borrowing_limit_percent)
        if lendable_percent is not None:
            pulumi.set(__self__, "lendable_percent", lendable_percent)
        if limit_response is not None:
            pulumi.set(__self__, "limit_response", limit_response)
        if nominal_concurrency_shares is not None:
            pulumi.set(__self__, "nominal_concurrency_shares", nominal_concurrency_shares)

    @property
    @pulumi.getter(name="borrowingLimitPercent")
    def borrowing_limit_percent(self) -> Optional[pulumi.Input[int]]:
        """
        `borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.

        BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )

        The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.
        """
        return pulumi.get(self, "borrowing_limit_percent")

    @borrowing_limit_percent.setter
    def borrowing_limit_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "borrowing_limit_percent", value)

    @property
    @pulumi.getter(name="lendablePercent")
    def lendable_percent(self) -> Optional[pulumi.Input[int]]:
        """
        `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

        LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        """
        return pulumi.get(self, "lendable_percent")

    @lendable_percent.setter
    def lendable_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lendable_percent", value)

    @property
    @pulumi.getter(name="limitResponse")
    def limit_response(self) -> Optional[pulumi.Input['LimitResponsePatchArgs']]:
        """
        `limitResponse` indicates what to do with requests that can not be executed right now
        """
        return pulumi.get(self, "limit_response")

    @limit_response.setter
    def limit_response(self, value: Optional[pulumi.Input['LimitResponsePatchArgs']]):
        pulumi.set(self, "limit_response", value)

    @property
    @pulumi.getter(name="nominalConcurrencyShares")
    def nominal_concurrency_shares(self) -> Optional[pulumi.Input[int]]:
        """
        `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats available at this priority level. This is used both for requests dispatched from this priority level as well as requests dispatched from other priority levels borrowing seats from this level. The server's concurrency limit (ServerCL) is divided among the Limited priority levels in proportion to their NCS values:

        NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

        Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level.

        If not specified, this field defaults to a value of 30.

        Setting this field to zero supports the construction of a "jail" for this priority level that is used to hold some request(s)
        """
        return pulumi.get(self, "nominal_concurrency_shares")

    @nominal_concurrency_shares.setter
    def nominal_concurrency_shares(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nominal_concurrency_shares", value)


@pulumi.input_type
class LimitedPriorityLevelConfigurationArgs:
    def __init__(__self__, *,
                 borrowing_limit_percent: Optional[pulumi.Input[int]] = None,
                 lendable_percent: Optional[pulumi.Input[int]] = None,
                 limit_response: Optional[pulumi.Input['LimitResponseArgs']] = None,
                 nominal_concurrency_shares: Optional[pulumi.Input[int]] = None):
        """
        LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:
          - How are requests for this priority level limited?
          - What should be done with requests that exceed the limit?
        :param pulumi.Input[int] borrowing_limit_percent: `borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.
               
               BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )
               
               The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.
        :param pulumi.Input[int] lendable_percent: `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.
               
               LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        :param pulumi.Input['LimitResponseArgs'] limit_response: `limitResponse` indicates what to do with requests that can not be executed right now
        :param pulumi.Input[int] nominal_concurrency_shares: `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats available at this priority level. This is used both for requests dispatched from this priority level as well as requests dispatched from other priority levels borrowing seats from this level. The server's concurrency limit (ServerCL) is divided among the Limited priority levels in proportion to their NCS values:
               
               NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)
               
               Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level.
               
               If not specified, this field defaults to a value of 30.
               
               Setting this field to zero supports the construction of a "jail" for this priority level that is used to hold some request(s)
        """
        if borrowing_limit_percent is not None:
            pulumi.set(__self__, "borrowing_limit_percent", borrowing_limit_percent)
        if lendable_percent is not None:
            pulumi.set(__self__, "lendable_percent", lendable_percent)
        if limit_response is not None:
            pulumi.set(__self__, "limit_response", limit_response)
        if nominal_concurrency_shares is not None:
            pulumi.set(__self__, "nominal_concurrency_shares", nominal_concurrency_shares)

    @property
    @pulumi.getter(name="borrowingLimitPercent")
    def borrowing_limit_percent(self) -> Optional[pulumi.Input[int]]:
        """
        `borrowingLimitPercent`, if present, configures a limit on how many seats this priority level can borrow from other priority levels. The limit is known as this level's BorrowingConcurrencyLimit (BorrowingCL) and is a limit on the total number of seats that this level may borrow at any one time. This field holds the ratio of that limit to the level's nominal concurrency limit. When this field is non-nil, it must hold a non-negative integer and the limit is calculated as follows.

        BorrowingCL(i) = round( NominalCL(i) * borrowingLimitPercent(i)/100.0 )

        The value of this field can be more than 100, implying that this priority level can borrow a number of seats that is greater than its own nominal concurrency limit (NominalCL). When this field is left `nil`, the limit is effectively infinite.
        """
        return pulumi.get(self, "borrowing_limit_percent")

    @borrowing_limit_percent.setter
    def borrowing_limit_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "borrowing_limit_percent", value)

    @property
    @pulumi.getter(name="lendablePercent")
    def lendable_percent(self) -> Optional[pulumi.Input[int]]:
        """
        `lendablePercent` prescribes the fraction of the level's NominalCL that can be borrowed by other priority levels. The value of this field must be between 0 and 100, inclusive, and it defaults to 0. The number of seats that other levels can borrow from this level, known as this level's LendableConcurrencyLimit (LendableCL), is defined as follows.

        LendableCL(i) = round( NominalCL(i) * lendablePercent(i)/100.0 )
        """
        return pulumi.get(self, "lendable_percent")

    @lendable_percent.setter
    def lendable_percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lendable_percent", value)

    @property
    @pulumi.getter(name="limitResponse")
    def limit_response(self) -> Optional[pulumi.Input['LimitResponseArgs']]:
        """
        `limitResponse` indicates what to do with requests that can not be executed right now
        """
        return pulumi.get(self, "limit_response")

    @limit_response.setter
    def limit_response(self, value: Optional[pulumi.Input['LimitResponseArgs']]):
        pulumi.set(self, "limit_response", value)

    @property
    @pulumi.getter(name="nominalConcurrencyShares")
    def nominal_concurrency_shares(self) -> Optional[pulumi.Input[int]]:
        """
        `nominalConcurrencyShares` (NCS) contributes to the computation of the NominalConcurrencyLimit (NominalCL) of this level. This is the number of execution seats available at this priority level. This is used both for requests dispatched from this priority level as well as requests dispatched from other priority levels borrowing seats from this level. The server's concurrency limit (ServerCL) is divided among the Limited priority levels in proportion to their NCS values:

        NominalCL(i)  = ceil( ServerCL * NCS(i) / sum_ncs ) sum_ncs = sum[priority level k] NCS(k)

        Bigger numbers mean a larger nominal concurrency limit, at the expense of every other priority level.

        If not specified, this field defaults to a value of 30.

        Setting this field to zero supports the construction of a "jail" for this priority level that is used to hold some request(s)
        """
        return pulumi.get(self, "nominal_concurrency_shares")

    @nominal_concurrency_shares.setter
    def nominal_concurrency_shares(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nominal_concurrency_shares", value)


@pulumi.input_type
class NonResourcePolicyRulePatchArgs:
    def __init__(__self__, *,
                 non_resource_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 verbs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        NonResourcePolicyRule is a predicate that matches non-resource requests according to their verb and the target non-resource URL. A NonResourcePolicyRule matches a request if and only if both (a) at least one member of verbs matches the request and (b) at least one member of nonResourceURLs matches the request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] non_resource_urls: `nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:
                 - "/healthz" is legal
                 - "/hea*" is illegal
                 - "/hea" is legal but matches nothing
                 - "/hea/*" also matches nothing
                 - "/healthz/*" matches all per-component health checks.
               "*" matches all non-resource urls. if it is present, it must be the only entry. Required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] verbs: `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs. If it is present, it must be the only entry. Required.
        """
        if non_resource_urls is not None:
            pulumi.set(__self__, "non_resource_urls", non_resource_urls)
        if verbs is not None:
            pulumi.set(__self__, "verbs", verbs)

    @property
    @pulumi.getter(name="nonResourceURLs")
    def non_resource_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        `nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:
          - "/healthz" is legal
          - "/hea*" is illegal
          - "/hea" is legal but matches nothing
          - "/hea/*" also matches nothing
          - "/healthz/*" matches all per-component health checks.
        "*" matches all non-resource urls. if it is present, it must be the only entry. Required.
        """
        return pulumi.get(self, "non_resource_urls")

    @non_resource_urls.setter
    def non_resource_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "non_resource_urls", value)

    @property
    @pulumi.getter
    def verbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs. If it is present, it must be the only entry. Required.
        """
        return pulumi.get(self, "verbs")

    @verbs.setter
    def verbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "verbs", value)


@pulumi.input_type
class NonResourcePolicyRuleArgs:
    def __init__(__self__, *,
                 non_resource_urls: pulumi.Input[Sequence[pulumi.Input[str]]],
                 verbs: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        NonResourcePolicyRule is a predicate that matches non-resource requests according to their verb and the target non-resource URL. A NonResourcePolicyRule matches a request if and only if both (a) at least one member of verbs matches the request and (b) at least one member of nonResourceURLs matches the request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] non_resource_urls: `nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:
                 - "/healthz" is legal
                 - "/hea*" is illegal
                 - "/hea" is legal but matches nothing
                 - "/hea/*" also matches nothing
                 - "/healthz/*" matches all per-component health checks.
               "*" matches all non-resource urls. if it is present, it must be the only entry. Required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] verbs: `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs. If it is present, it must be the only entry. Required.
        """
        pulumi.set(__self__, "non_resource_urls", non_resource_urls)
        pulumi.set(__self__, "verbs", verbs)

    @property
    @pulumi.getter(name="nonResourceURLs")
    def non_resource_urls(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        `nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:
          - "/healthz" is legal
          - "/hea*" is illegal
          - "/hea" is legal but matches nothing
          - "/hea/*" also matches nothing
          - "/healthz/*" matches all per-component health checks.
        "*" matches all non-resource urls. if it is present, it must be the only entry. Required.
        """
        return pulumi.get(self, "non_resource_urls")

    @non_resource_urls.setter
    def non_resource_urls(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "non_resource_urls", value)

    @property
    @pulumi.getter
    def verbs(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs. If it is present, it must be the only entry. Required.
        """
        return pulumi.get(self, "verbs")

    @verbs.setter
    def verbs(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "verbs", value)


@pulumi.input_type
class PolicyRulesWithSubjectsPatchArgs:
    def __init__(__self__, *,
                 non_resource_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NonResourcePolicyRulePatchArgs']]]] = None,
                 resource_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ResourcePolicyRulePatchArgs']]]] = None,
                 subjects: Optional[pulumi.Input[Sequence[pulumi.Input['SubjectPatchArgs']]]] = None):
        """
        PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver. The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request.
        :param pulumi.Input[Sequence[pulumi.Input['NonResourcePolicyRulePatchArgs']]] non_resource_rules: `nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.
        :param pulumi.Input[Sequence[pulumi.Input['ResourcePolicyRulePatchArgs']]] resource_rules: `resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.
        :param pulumi.Input[Sequence[pulumi.Input['SubjectPatchArgs']]] subjects: subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.
        """
        if non_resource_rules is not None:
            pulumi.set(__self__, "non_resource_rules", non_resource_rules)
        if resource_rules is not None:
            pulumi.set(__self__, "resource_rules", resource_rules)
        if subjects is not None:
            pulumi.set(__self__, "subjects", subjects)

    @property
    @pulumi.getter(name="nonResourceRules")
    def non_resource_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NonResourcePolicyRulePatchArgs']]]]:
        """
        `nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.
        """
        return pulumi.get(self, "non_resource_rules")

    @non_resource_rules.setter
    def non_resource_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NonResourcePolicyRulePatchArgs']]]]):
        pulumi.set(self, "non_resource_rules", value)

    @property
    @pulumi.getter(name="resourceRules")
    def resource_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourcePolicyRulePatchArgs']]]]:
        """
        `resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.
        """
        return pulumi.get(self, "resource_rules")

    @resource_rules.setter
    def resource_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourcePolicyRulePatchArgs']]]]):
        pulumi.set(self, "resource_rules", value)

    @property
    @pulumi.getter
    def subjects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubjectPatchArgs']]]]:
        """
        subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.
        """
        return pulumi.get(self, "subjects")

    @subjects.setter
    def subjects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubjectPatchArgs']]]]):
        pulumi.set(self, "subjects", value)


@pulumi.input_type
class PolicyRulesWithSubjectsArgs:
    def __init__(__self__, *,
                 subjects: pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]],
                 non_resource_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NonResourcePolicyRuleArgs']]]] = None,
                 resource_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ResourcePolicyRuleArgs']]]] = None):
        """
        PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver. The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request.
        :param pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]] subjects: subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.
        :param pulumi.Input[Sequence[pulumi.Input['NonResourcePolicyRuleArgs']]] non_resource_rules: `nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.
        :param pulumi.Input[Sequence[pulumi.Input['ResourcePolicyRuleArgs']]] resource_rules: `resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.
        """
        pulumi.set(__self__, "subjects", subjects)
        if non_resource_rules is not None:
            pulumi.set(__self__, "non_resource_rules", non_resource_rules)
        if resource_rules is not None:
            pulumi.set(__self__, "resource_rules", resource_rules)

    @property
    @pulumi.getter
    def subjects(self) -> pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]]:
        """
        subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.
        """
        return pulumi.get(self, "subjects")

    @subjects.setter
    def subjects(self, value: pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]]):
        pulumi.set(self, "subjects", value)

    @property
    @pulumi.getter(name="nonResourceRules")
    def non_resource_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NonResourcePolicyRuleArgs']]]]:
        """
        `nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.
        """
        return pulumi.get(self, "non_resource_rules")

    @non_resource_rules.setter
    def non_resource_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NonResourcePolicyRuleArgs']]]]):
        pulumi.set(self, "non_resource_rules", value)

    @property
    @pulumi.getter(name="resourceRules")
    def resource_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourcePolicyRuleArgs']]]]:
        """
        `resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.
        """
        return pulumi.get(self, "resource_rules")

    @resource_rules.setter
    def resource_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourcePolicyRuleArgs']]]]):
        pulumi.set(self, "resource_rules", value)


@pulumi.input_type
class PriorityLevelConfigurationConditionArgs:
    def __init__(__self__, *,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        PriorityLevelConfigurationCondition defines the condition of priority level.
        :param pulumi.Input[str] last_transition_time: `lastTransitionTime` is the last time the condition transitioned from one status to another.
        :param pulumi.Input[str] message: `message` is a human-readable message indicating details about last transition.
        :param pulumi.Input[str] reason: `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        :param pulumi.Input[str] status: `status` is the status of the condition. Can be True, False, Unknown. Required.
        :param pulumi.Input[str] type: `type` is the type of the condition. Required.
        """
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        `lastTransitionTime` is the last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        `message` is a human-readable message indicating details about last transition.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        `reason` is a unique, one-word, CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        `status` is the status of the condition. Can be True, False, Unknown. Required.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        `type` is the type of the condition. Required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PriorityLevelConfigurationReferencePatchArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        PriorityLevelConfigurationReference contains information that points to the "request-priority" being used.
        :param pulumi.Input[str] name: `name` is the name of the priority level configuration being referenced Required.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        `name` is the name of the priority level configuration being referenced Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PriorityLevelConfigurationReferenceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        PriorityLevelConfigurationReference contains information that points to the "request-priority" being used.
        :param pulumi.Input[str] name: `name` is the name of the priority level configuration being referenced Required.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        `name` is the name of the priority level configuration being referenced Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PriorityLevelConfigurationSpecPatchArgs:
    def __init__(__self__, *,
                 exempt: Optional[pulumi.Input['ExemptPriorityLevelConfigurationPatchArgs']] = None,
                 limited: Optional[pulumi.Input['LimitedPriorityLevelConfigurationPatchArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        PriorityLevelConfigurationSpec specifies the configuration of a priority level.
        :param pulumi.Input['ExemptPriorityLevelConfigurationPatchArgs'] exempt: `exempt` specifies how requests are handled for an exempt priority level. This field MUST be empty if `type` is `"Limited"`. This field MAY be non-empty if `type` is `"Exempt"`. If empty and `type` is `"Exempt"` then the default values for `ExemptPriorityLevelConfiguration` apply.
        :param pulumi.Input['LimitedPriorityLevelConfigurationPatchArgs'] limited: `limited` specifies how requests are handled for a Limited priority level. This field must be non-empty if and only if `type` is `"Limited"`.
        :param pulumi.Input[str] type: `type` indicates whether this priority level is subject to limitation on request execution.  A value of `"Exempt"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `"Limited"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.
        """
        if exempt is not None:
            pulumi.set(__self__, "exempt", exempt)
        if limited is not None:
            pulumi.set(__self__, "limited", limited)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def exempt(self) -> Optional[pulumi.Input['ExemptPriorityLevelConfigurationPatchArgs']]:
        """
        `exempt` specifies how requests are handled for an exempt priority level. This field MUST be empty if `type` is `"Limited"`. This field MAY be non-empty if `type` is `"Exempt"`. If empty and `type` is `"Exempt"` then the default values for `ExemptPriorityLevelConfiguration` apply.
        """
        return pulumi.get(self, "exempt")

    @exempt.setter
    def exempt(self, value: Optional[pulumi.Input['ExemptPriorityLevelConfigurationPatchArgs']]):
        pulumi.set(self, "exempt", value)

    @property
    @pulumi.getter
    def limited(self) -> Optional[pulumi.Input['LimitedPriorityLevelConfigurationPatchArgs']]:
        """
        `limited` specifies how requests are handled for a Limited priority level. This field must be non-empty if and only if `type` is `"Limited"`.
        """
        return pulumi.get(self, "limited")

    @limited.setter
    def limited(self, value: Optional[pulumi.Input['LimitedPriorityLevelConfigurationPatchArgs']]):
        pulumi.set(self, "limited", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        `type` indicates whether this priority level is subject to limitation on request execution.  A value of `"Exempt"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `"Limited"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PriorityLevelConfigurationSpecArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 exempt: Optional[pulumi.Input['ExemptPriorityLevelConfigurationArgs']] = None,
                 limited: Optional[pulumi.Input['LimitedPriorityLevelConfigurationArgs']] = None):
        """
        PriorityLevelConfigurationSpec specifies the configuration of a priority level.
        :param pulumi.Input[str] type: `type` indicates whether this priority level is subject to limitation on request execution.  A value of `"Exempt"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `"Limited"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.
        :param pulumi.Input['ExemptPriorityLevelConfigurationArgs'] exempt: `exempt` specifies how requests are handled for an exempt priority level. This field MUST be empty if `type` is `"Limited"`. This field MAY be non-empty if `type` is `"Exempt"`. If empty and `type` is `"Exempt"` then the default values for `ExemptPriorityLevelConfiguration` apply.
        :param pulumi.Input['LimitedPriorityLevelConfigurationArgs'] limited: `limited` specifies how requests are handled for a Limited priority level. This field must be non-empty if and only if `type` is `"Limited"`.
        """
        pulumi.set(__self__, "type", type)
        if exempt is not None:
            pulumi.set(__self__, "exempt", exempt)
        if limited is not None:
            pulumi.set(__self__, "limited", limited)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        `type` indicates whether this priority level is subject to limitation on request execution.  A value of `"Exempt"` means that requests of this priority level are not subject to a limit (and thus are never queued) and do not detract from the capacity made available to other priority levels.  A value of `"Limited"` means that (a) requests of this priority level _are_ subject to limits and (b) some of the server's limited capacity is made available exclusively to this priority level. Required.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def exempt(self) -> Optional[pulumi.Input['ExemptPriorityLevelConfigurationArgs']]:
        """
        `exempt` specifies how requests are handled for an exempt priority level. This field MUST be empty if `type` is `"Limited"`. This field MAY be non-empty if `type` is `"Exempt"`. If empty and `type` is `"Exempt"` then the default values for `ExemptPriorityLevelConfiguration` apply.
        """
        return pulumi.get(self, "exempt")

    @exempt.setter
    def exempt(self, value: Optional[pulumi.Input['ExemptPriorityLevelConfigurationArgs']]):
        pulumi.set(self, "exempt", value)

    @property
    @pulumi.getter
    def limited(self) -> Optional[pulumi.Input['LimitedPriorityLevelConfigurationArgs']]:
        """
        `limited` specifies how requests are handled for a Limited priority level. This field must be non-empty if and only if `type` is `"Limited"`.
        """
        return pulumi.get(self, "limited")

    @limited.setter
    def limited(self, value: Optional[pulumi.Input['LimitedPriorityLevelConfigurationArgs']]):
        pulumi.set(self, "limited", value)


@pulumi.input_type
class PriorityLevelConfigurationStatusArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['PriorityLevelConfigurationConditionArgs']]]] = None):
        """
        PriorityLevelConfigurationStatus represents the current state of a "request-priority".
        :param pulumi.Input[Sequence[pulumi.Input['PriorityLevelConfigurationConditionArgs']]] conditions: `conditions` is the current state of "request-priority".
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PriorityLevelConfigurationConditionArgs']]]]:
        """
        `conditions` is the current state of "request-priority".
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PriorityLevelConfigurationConditionArgs']]]]):
        pulumi.set(self, "conditions", value)


@pulumi.input_type
class PriorityLevelConfigurationArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['PriorityLevelConfigurationSpecArgs']] = None,
                 status: Optional[pulumi.Input['PriorityLevelConfigurationStatusArgs']] = None):
        """
        PriorityLevelConfiguration represents the configuration of a priority level.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['PriorityLevelConfigurationSpecArgs'] spec: `spec` is the specification of the desired behavior of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param pulumi.Input['PriorityLevelConfigurationStatusArgs'] status: `status` is the current status of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'flowcontrol.apiserver.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PriorityLevelConfiguration')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        `metadata` is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['PriorityLevelConfigurationSpecArgs']]:
        """
        `spec` is the specification of the desired behavior of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['PriorityLevelConfigurationSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['PriorityLevelConfigurationStatusArgs']]:
        """
        `status` is the current status of a "request-priority". More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['PriorityLevelConfigurationStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class QueuingConfigurationPatchArgs:
    def __init__(__self__, *,
                 hand_size: Optional[pulumi.Input[int]] = None,
                 queue_length_limit: Optional[pulumi.Input[int]] = None,
                 queues: Optional[pulumi.Input[int]] = None):
        """
        QueuingConfiguration holds the configuration parameters for queuing
        :param pulumi.Input[int] hand_size: `handSize` is a small positive number that configures the shuffle sharding of requests into queues.  When enqueuing a request at this priority level the request's flow identifier (a string pair) is hashed and the hash value is used to shuffle the list of queues and deal a hand of the size specified here.  The request is put into one of the shortest queues in that hand. `handSize` must be no larger than `queues`, and should be significantly smaller (so that a few heavy flows do not saturate most of the queues).  See the user-facing documentation for more extensive guidance on setting this field.  This field has a default value of 8.
        :param pulumi.Input[int] queue_length_limit: `queueLengthLimit` is the maximum number of requests allowed to be waiting in a given queue of this priority level at a time; excess requests are rejected.  This value must be positive.  If not specified, it will be defaulted to 50.
        :param pulumi.Input[int] queues: `queues` is the number of queues for this priority level. The queues exist independently at each apiserver. The value must be positive.  Setting it to 1 effectively precludes shufflesharding and thus makes the distinguisher method of associated flow schemas irrelevant.  This field has a default value of 64.
        """
        if hand_size is not None:
            pulumi.set(__self__, "hand_size", hand_size)
        if queue_length_limit is not None:
            pulumi.set(__self__, "queue_length_limit", queue_length_limit)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)

    @property
    @pulumi.getter(name="handSize")
    def hand_size(self) -> Optional[pulumi.Input[int]]:
        """
        `handSize` is a small positive number that configures the shuffle sharding of requests into queues.  When enqueuing a request at this priority level the request's flow identifier (a string pair) is hashed and the hash value is used to shuffle the list of queues and deal a hand of the size specified here.  The request is put into one of the shortest queues in that hand. `handSize` must be no larger than `queues`, and should be significantly smaller (so that a few heavy flows do not saturate most of the queues).  See the user-facing documentation for more extensive guidance on setting this field.  This field has a default value of 8.
        """
        return pulumi.get(self, "hand_size")

    @hand_size.setter
    def hand_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hand_size", value)

    @property
    @pulumi.getter(name="queueLengthLimit")
    def queue_length_limit(self) -> Optional[pulumi.Input[int]]:
        """
        `queueLengthLimit` is the maximum number of requests allowed to be waiting in a given queue of this priority level at a time; excess requests are rejected.  This value must be positive.  If not specified, it will be defaulted to 50.
        """
        return pulumi.get(self, "queue_length_limit")

    @queue_length_limit.setter
    def queue_length_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_length_limit", value)

    @property
    @pulumi.getter
    def queues(self) -> Optional[pulumi.Input[int]]:
        """
        `queues` is the number of queues for this priority level. The queues exist independently at each apiserver. The value must be positive.  Setting it to 1 effectively precludes shufflesharding and thus makes the distinguisher method of associated flow schemas irrelevant.  This field has a default value of 64.
        """
        return pulumi.get(self, "queues")

    @queues.setter
    def queues(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queues", value)


@pulumi.input_type
class QueuingConfigurationArgs:
    def __init__(__self__, *,
                 hand_size: Optional[pulumi.Input[int]] = None,
                 queue_length_limit: Optional[pulumi.Input[int]] = None,
                 queues: Optional[pulumi.Input[int]] = None):
        """
        QueuingConfiguration holds the configuration parameters for queuing
        :param pulumi.Input[int] hand_size: `handSize` is a small positive number that configures the shuffle sharding of requests into queues.  When enqueuing a request at this priority level the request's flow identifier (a string pair) is hashed and the hash value is used to shuffle the list of queues and deal a hand of the size specified here.  The request is put into one of the shortest queues in that hand. `handSize` must be no larger than `queues`, and should be significantly smaller (so that a few heavy flows do not saturate most of the queues).  See the user-facing documentation for more extensive guidance on setting this field.  This field has a default value of 8.
        :param pulumi.Input[int] queue_length_limit: `queueLengthLimit` is the maximum number of requests allowed to be waiting in a given queue of this priority level at a time; excess requests are rejected.  This value must be positive.  If not specified, it will be defaulted to 50.
        :param pulumi.Input[int] queues: `queues` is the number of queues for this priority level. The queues exist independently at each apiserver. The value must be positive.  Setting it to 1 effectively precludes shufflesharding and thus makes the distinguisher method of associated flow schemas irrelevant.  This field has a default value of 64.
        """
        if hand_size is not None:
            pulumi.set(__self__, "hand_size", hand_size)
        if queue_length_limit is not None:
            pulumi.set(__self__, "queue_length_limit", queue_length_limit)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)

    @property
    @pulumi.getter(name="handSize")
    def hand_size(self) -> Optional[pulumi.Input[int]]:
        """
        `handSize` is a small positive number that configures the shuffle sharding of requests into queues.  When enqueuing a request at this priority level the request's flow identifier (a string pair) is hashed and the hash value is used to shuffle the list of queues and deal a hand of the size specified here.  The request is put into one of the shortest queues in that hand. `handSize` must be no larger than `queues`, and should be significantly smaller (so that a few heavy flows do not saturate most of the queues).  See the user-facing documentation for more extensive guidance on setting this field.  This field has a default value of 8.
        """
        return pulumi.get(self, "hand_size")

    @hand_size.setter
    def hand_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hand_size", value)

    @property
    @pulumi.getter(name="queueLengthLimit")
    def queue_length_limit(self) -> Optional[pulumi.Input[int]]:
        """
        `queueLengthLimit` is the maximum number of requests allowed to be waiting in a given queue of this priority level at a time; excess requests are rejected.  This value must be positive.  If not specified, it will be defaulted to 50.
        """
        return pulumi.get(self, "queue_length_limit")

    @queue_length_limit.setter
    def queue_length_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_length_limit", value)

    @property
    @pulumi.getter
    def queues(self) -> Optional[pulumi.Input[int]]:
        """
        `queues` is the number of queues for this priority level. The queues exist independently at each apiserver. The value must be positive.  Setting it to 1 effectively precludes shufflesharding and thus makes the distinguisher method of associated flow schemas irrelevant.  This field has a default value of 64.
        """
        return pulumi.get(self, "queues")

    @queues.setter
    def queues(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queues", value)


@pulumi.input_type
class ResourcePolicyRulePatchArgs:
    def __init__(__self__, *,
                 api_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cluster_scope: Optional[pulumi.Input[bool]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 verbs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ResourcePolicyRule is a predicate that matches some resource requests, testing the request's verb and the target resource. A ResourcePolicyRule matches a resource request if and only if: (a) at least one member of verbs matches the request, (b) at least one member of apiGroups matches the request, (c) at least one member of resources matches the request, and (d) either (d1) the request does not specify a namespace (i.e., `Namespace==""`) and clusterScope is true or (d2) the request specifies a namespace and least one member of namespaces matches the request's namespace.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] api_groups: `apiGroups` is a list of matching API groups and may not be empty. "*" matches all API groups and, if present, must be the only entry. Required.
        :param pulumi.Input[bool] cluster_scope: `clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: `namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "*".  Note that "*" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: `resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] verbs: `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs and, if present, must be the only entry. Required.
        """
        if api_groups is not None:
            pulumi.set(__self__, "api_groups", api_groups)
        if cluster_scope is not None:
            pulumi.set(__self__, "cluster_scope", cluster_scope)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if verbs is not None:
            pulumi.set(__self__, "verbs", verbs)

    @property
    @pulumi.getter(name="apiGroups")
    def api_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        `apiGroups` is a list of matching API groups and may not be empty. "*" matches all API groups and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "api_groups")

    @api_groups.setter
    def api_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "api_groups", value)

    @property
    @pulumi.getter(name="clusterScope")
    def cluster_scope(self) -> Optional[pulumi.Input[bool]]:
        """
        `clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.
        """
        return pulumi.get(self, "cluster_scope")

    @cluster_scope.setter
    def cluster_scope(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cluster_scope", value)

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        `namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "*".  Note that "*" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "namespaces", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        `resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def verbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "verbs")

    @verbs.setter
    def verbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "verbs", value)


@pulumi.input_type
class ResourcePolicyRuleArgs:
    def __init__(__self__, *,
                 api_groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 resources: pulumi.Input[Sequence[pulumi.Input[str]]],
                 verbs: pulumi.Input[Sequence[pulumi.Input[str]]],
                 cluster_scope: Optional[pulumi.Input[bool]] = None,
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        ResourcePolicyRule is a predicate that matches some resource requests, testing the request's verb and the target resource. A ResourcePolicyRule matches a resource request if and only if: (a) at least one member of verbs matches the request, (b) at least one member of apiGroups matches the request, (c) at least one member of resources matches the request, and (d) either (d1) the request does not specify a namespace (i.e., `Namespace==""`) and clusterScope is true or (d2) the request specifies a namespace and least one member of namespaces matches the request's namespace.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] api_groups: `apiGroups` is a list of matching API groups and may not be empty. "*" matches all API groups and, if present, must be the only entry. Required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: `resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] verbs: `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs and, if present, must be the only entry. Required.
        :param pulumi.Input[bool] cluster_scope: `clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: `namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "*".  Note that "*" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.
        """
        pulumi.set(__self__, "api_groups", api_groups)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "verbs", verbs)
        if cluster_scope is not None:
            pulumi.set(__self__, "cluster_scope", cluster_scope)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter(name="apiGroups")
    def api_groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        `apiGroups` is a list of matching API groups and may not be empty. "*" matches all API groups and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "api_groups")

    @api_groups.setter
    def api_groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "api_groups", value)

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        `resources` is a list of matching resources (i.e., lowercase and plural) with, if desired, subresource.  For example, [ "services", "nodes/status" ].  This list may not be empty. "*" matches all resources and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def verbs(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        `verbs` is a list of matching verbs and may not be empty. "*" matches all verbs and, if present, must be the only entry. Required.
        """
        return pulumi.get(self, "verbs")

    @verbs.setter
    def verbs(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "verbs", value)

    @property
    @pulumi.getter(name="clusterScope")
    def cluster_scope(self) -> Optional[pulumi.Input[bool]]:
        """
        `clusterScope` indicates whether to match requests that do not specify a namespace (which happens either because the resource is not namespaced or the request targets all namespaces). If this field is omitted or false then the `namespaces` field must contain a non-empty list.
        """
        return pulumi.get(self, "cluster_scope")

    @cluster_scope.setter
    def cluster_scope(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cluster_scope", value)

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        `namespaces` is a list of target namespaces that restricts matches.  A request that specifies a target namespace matches only if either (a) this list contains that target namespace or (b) this list contains "*".  Note that "*" matches any specified namespace but does not match a request that _does not specify_ a namespace (see the `clusterScope` field for that). This list may be empty, but only if `clusterScope` is true.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "namespaces", value)


@pulumi.input_type
class ServiceAccountSubjectPatchArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        ServiceAccountSubject holds detailed information for service-account-kind subject.
        :param pulumi.Input[str] name: `name` is the name of matching ServiceAccount objects, or "*" to match regardless of name. Required.
        :param pulumi.Input[str] namespace: `namespace` is the namespace of matching ServiceAccount objects. Required.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        `name` is the name of matching ServiceAccount objects, or "*" to match regardless of name. Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        `namespace` is the namespace of matching ServiceAccount objects. Required.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class ServiceAccountSubjectArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 namespace: pulumi.Input[str]):
        """
        ServiceAccountSubject holds detailed information for service-account-kind subject.
        :param pulumi.Input[str] name: `name` is the name of matching ServiceAccount objects, or "*" to match regardless of name. Required.
        :param pulumi.Input[str] namespace: `namespace` is the namespace of matching ServiceAccount objects. Required.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        `name` is the name of matching ServiceAccount objects, or "*" to match regardless of name. Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        `namespace` is the namespace of matching ServiceAccount objects. Required.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class SubjectPatchArgs:
    def __init__(__self__, *,
                 group: Optional[pulumi.Input['GroupSubjectPatchArgs']] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input['ServiceAccountSubjectPatchArgs']] = None,
                 user: Optional[pulumi.Input['UserSubjectPatchArgs']] = None):
        """
        Subject matches the originator of a request, as identified by the request authentication system. There are three ways of matching an originator; by user, group, or service account.
        :param pulumi.Input['GroupSubjectPatchArgs'] group: `group` matches based on user group name.
        :param pulumi.Input[str] kind: `kind` indicates which one of the other fields is non-empty. Required
        :param pulumi.Input['ServiceAccountSubjectPatchArgs'] service_account: `serviceAccount` matches ServiceAccounts.
        :param pulumi.Input['UserSubjectPatchArgs'] user: `user` matches based on username.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input['GroupSubjectPatchArgs']]:
        """
        `group` matches based on user group name.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input['GroupSubjectPatchArgs']]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        `kind` indicates which one of the other fields is non-empty. Required
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['ServiceAccountSubjectPatchArgs']]:
        """
        `serviceAccount` matches ServiceAccounts.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['ServiceAccountSubjectPatchArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['UserSubjectPatchArgs']]:
        """
        `user` matches based on username.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['UserSubjectPatchArgs']]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class SubjectArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 group: Optional[pulumi.Input['GroupSubjectArgs']] = None,
                 service_account: Optional[pulumi.Input['ServiceAccountSubjectArgs']] = None,
                 user: Optional[pulumi.Input['UserSubjectArgs']] = None):
        """
        Subject matches the originator of a request, as identified by the request authentication system. There are three ways of matching an originator; by user, group, or service account.
        :param pulumi.Input[str] kind: `kind` indicates which one of the other fields is non-empty. Required
        :param pulumi.Input['GroupSubjectArgs'] group: `group` matches based on user group name.
        :param pulumi.Input['ServiceAccountSubjectArgs'] service_account: `serviceAccount` matches ServiceAccounts.
        :param pulumi.Input['UserSubjectArgs'] user: `user` matches based on username.
        """
        pulumi.set(__self__, "kind", kind)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        `kind` indicates which one of the other fields is non-empty. Required
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input['GroupSubjectArgs']]:
        """
        `group` matches based on user group name.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input['GroupSubjectArgs']]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['ServiceAccountSubjectArgs']]:
        """
        `serviceAccount` matches ServiceAccounts.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['ServiceAccountSubjectArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input['UserSubjectArgs']]:
        """
        `user` matches based on username.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input['UserSubjectArgs']]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class UserSubjectPatchArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        UserSubject holds detailed information for user-kind subject.
        :param pulumi.Input[str] name: `name` is the username that matches, or "*" to match all usernames. Required.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        `name` is the username that matches, or "*" to match all usernames. Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class UserSubjectArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        UserSubject holds detailed information for user-kind subject.
        :param pulumi.Input[str] name: `name` is the username that matches, or "*" to match all usernames. Required.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        `name` is the username that matches, or "*" to match all usernames. Required.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


