# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'HTTPIngressPathPatchArgs',
    'HTTPIngressPathArgs',
    'HTTPIngressRuleValuePatchArgs',
    'HTTPIngressRuleValueArgs',
    'IPBlockPatchArgs',
    'IPBlockArgs',
    'IngressBackendPatchArgs',
    'IngressBackendArgs',
    'IngressClassParametersReferencePatchArgs',
    'IngressClassParametersReferenceArgs',
    'IngressClassSpecPatchArgs',
    'IngressClassSpecArgs',
    'IngressClassArgs',
    'IngressLoadBalancerIngressArgs',
    'IngressLoadBalancerStatusArgs',
    'IngressPortStatusArgs',
    'IngressRulePatchArgs',
    'IngressRuleArgs',
    'IngressServiceBackendPatchArgs',
    'IngressServiceBackendArgs',
    'IngressSpecPatchArgs',
    'IngressSpecArgs',
    'IngressStatusArgs',
    'IngressTLSPatchArgs',
    'IngressTLSArgs',
    'IngressArgs',
    'NetworkPolicyEgressRulePatchArgs',
    'NetworkPolicyEgressRuleArgs',
    'NetworkPolicyIngressRulePatchArgs',
    'NetworkPolicyIngressRuleArgs',
    'NetworkPolicyPeerPatchArgs',
    'NetworkPolicyPeerArgs',
    'NetworkPolicyPortPatchArgs',
    'NetworkPolicyPortArgs',
    'NetworkPolicySpecPatchArgs',
    'NetworkPolicySpecArgs',
    'NetworkPolicyStatusArgs',
    'NetworkPolicyArgs',
    'ServiceBackendPortPatchArgs',
    'ServiceBackendPortArgs',
]

@pulumi.input_type
class HTTPIngressPathPatchArgs:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input['IngressBackendPatchArgs']] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 path_type: Optional[pulumi.Input[str]] = None):
        """
        HTTPIngressPath associates a path with a backend. Incoming urls matching the path are forwarded to the backend.
        :param pulumi.Input['IngressBackendPatchArgs'] backend: backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param pulumi.Input[str] path: path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
        :param pulumi.Input[str] path_type: pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
                 done on a path element by element basis. A path element refers is the
                 list of labels in the path split by the '/' separator. A request is a
                 match for path p if every p is an element-wise prefix of p of the
                 request path. Note that if the last element of the path is a substring
                 of the last element in request path, it is not a match (e.g. /foo/bar
                 matches /foo/bar/baz, but does not match /foo/barbaz).
               * ImplementationSpecific: Interpretation of the Path matching is up to
                 the IngressClass. Implementations can treat this as a separate PathType
                 or treat it identically to Prefix or Exact path types.
               Implementations are required to support all path types.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if path_type is not None:
            pulumi.set(__self__, "path_type", path_type)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input['IngressBackendPatchArgs']]:
        """
        backend defines the referenced service endpoint to which the traffic will be forwarded to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input['IngressBackendPatchArgs']]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="pathType")
    def path_type(self) -> Optional[pulumi.Input[str]]:
        """
        pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
          done on a path element by element basis. A path element refers is the
          list of labels in the path split by the '/' separator. A request is a
          match for path p if every p is an element-wise prefix of p of the
          request path. Note that if the last element of the path is a substring
          of the last element in request path, it is not a match (e.g. /foo/bar
          matches /foo/bar/baz, but does not match /foo/barbaz).
        * ImplementationSpecific: Interpretation of the Path matching is up to
          the IngressClass. Implementations can treat this as a separate PathType
          or treat it identically to Prefix or Exact path types.
        Implementations are required to support all path types.
        """
        return pulumi.get(self, "path_type")

    @path_type.setter
    def path_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_type", value)


@pulumi.input_type
class HTTPIngressPathArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input['IngressBackendArgs'],
                 path_type: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None):
        """
        HTTPIngressPath associates a path with a backend. Incoming urls matching the path are forwarded to the backend.
        :param pulumi.Input['IngressBackendArgs'] backend: backend defines the referenced service endpoint to which the traffic will be forwarded to.
        :param pulumi.Input[str] path_type: pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
                 done on a path element by element basis. A path element refers is the
                 list of labels in the path split by the '/' separator. A request is a
                 match for path p if every p is an element-wise prefix of p of the
                 request path. Note that if the last element of the path is a substring
                 of the last element in request path, it is not a match (e.g. /foo/bar
                 matches /foo/bar/baz, but does not match /foo/barbaz).
               * ImplementationSpecific: Interpretation of the Path matching is up to
                 the IngressClass. Implementations can treat this as a separate PathType
                 or treat it identically to Prefix or Exact path types.
               Implementations are required to support all path types.
        :param pulumi.Input[str] path: path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "path_type", path_type)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input['IngressBackendArgs']:
        """
        backend defines the referenced service endpoint to which the traffic will be forwarded to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input['IngressBackendArgs']):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="pathType")
    def path_type(self) -> pulumi.Input[str]:
        """
        pathType determines the interpretation of the path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is
          done on a path element by element basis. A path element refers is the
          list of labels in the path split by the '/' separator. A request is a
          match for path p if every p is an element-wise prefix of p of the
          request path. Note that if the last element of the path is a substring
          of the last element in request path, it is not a match (e.g. /foo/bar
          matches /foo/bar/baz, but does not match /foo/barbaz).
        * ImplementationSpecific: Interpretation of the Path matching is up to
          the IngressClass. Implementations can treat this as a separate PathType
          or treat it identically to Prefix or Exact path types.
        Implementations are required to support all path types.
        """
        return pulumi.get(self, "path_type")

    @path_type.setter
    def path_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "path_type", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional "path" part of a URL as defined by RFC 3986. Paths must begin with a '/' and must be present when using PathType with value "Exact" or "Prefix".
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class HTTPIngressRuleValuePatchArgs:
    def __init__(__self__, *,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input['HTTPIngressPathPatchArgs']]]] = None):
        """
        HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
        :param pulumi.Input[Sequence[pulumi.Input['HTTPIngressPathPatchArgs']]] paths: paths is a collection of paths that map requests to backends.
        """
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HTTPIngressPathPatchArgs']]]]:
        """
        paths is a collection of paths that map requests to backends.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HTTPIngressPathPatchArgs']]]]):
        pulumi.set(self, "paths", value)


@pulumi.input_type
class HTTPIngressRuleValueArgs:
    def __init__(__self__, *,
                 paths: pulumi.Input[Sequence[pulumi.Input['HTTPIngressPathArgs']]]):
        """
        HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.
        :param pulumi.Input[Sequence[pulumi.Input['HTTPIngressPathArgs']]] paths: paths is a collection of paths that map requests to backends.
        """
        pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> pulumi.Input[Sequence[pulumi.Input['HTTPIngressPathArgs']]]:
        """
        paths is a collection of paths that map requests to backends.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: pulumi.Input[Sequence[pulumi.Input['HTTPIngressPathArgs']]]):
        pulumi.set(self, "paths", value)


@pulumi.input_type
class IPBlockPatchArgs:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[str]] = None,
                 except_: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        IPBlock describes a particular CIDR (Ex. "192.168.1.0/24","2001:db8::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
        :param pulumi.Input[str] cidr: cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64"
        :param pulumi.Input[Sequence[pulumi.Input[str]]] except_: except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if except_ is not None:
            pulumi.set(__self__, "except_", except_)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64"
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="except")
    def except_(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range
        """
        return pulumi.get(self, "except_")

    @except_.setter
    def except_(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "except_", value)


@pulumi.input_type
class IPBlockArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[str],
                 except_: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        IPBlock describes a particular CIDR (Ex. "192.168.1.0/24","2001:db8::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.
        :param pulumi.Input[str] cidr: cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64"
        :param pulumi.Input[Sequence[pulumi.Input[str]]] except_: except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range
        """
        pulumi.set(__self__, "cidr", cidr)
        if except_ is not None:
            pulumi.set(__self__, "except_", except_)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[str]:
        """
        cidr is a string representing the IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64"
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="except")
    def except_(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        except is a slice of CIDRs that should not be included within an IPBlock Valid examples are "192.168.1.0/24" or "2001:db8::/64" Except values will be rejected if they are outside the cidr range
        """
        return pulumi.get(self, "except_")

    @except_.setter
    def except_(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "except_", value)


@pulumi.input_type
class IngressBackendPatchArgs:
    def __init__(__self__, *,
                 resource: Optional[pulumi.Input['_core.v1.TypedLocalObjectReferencePatchArgs']] = None,
                 service: Optional[pulumi.Input['IngressServiceBackendPatchArgs']] = None):
        """
        IngressBackend describes all endpoints for a given service and port.
        :param pulumi.Input['_core.v1.TypedLocalObjectReferencePatchArgs'] resource: resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
        :param pulumi.Input['IngressServiceBackendPatchArgs'] service: service references a service as a backend. This is a mutually exclusive setting with "Resource".
        """
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input['_core.v1.TypedLocalObjectReferencePatchArgs']]:
        """
        resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input['_core.v1.TypedLocalObjectReferencePatchArgs']]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input['IngressServiceBackendPatchArgs']]:
        """
        service references a service as a backend. This is a mutually exclusive setting with "Resource".
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input['IngressServiceBackendPatchArgs']]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class IngressBackendArgs:
    def __init__(__self__, *,
                 resource: Optional[pulumi.Input['_core.v1.TypedLocalObjectReferenceArgs']] = None,
                 service: Optional[pulumi.Input['IngressServiceBackendArgs']] = None):
        """
        IngressBackend describes all endpoints for a given service and port.
        :param pulumi.Input['_core.v1.TypedLocalObjectReferenceArgs'] resource: resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
        :param pulumi.Input['IngressServiceBackendArgs'] service: service references a service as a backend. This is a mutually exclusive setting with "Resource".
        """
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def resource(self) -> Optional[pulumi.Input['_core.v1.TypedLocalObjectReferenceArgs']]:
        """
        resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, a service.Name and service.Port must not be specified. This is a mutually exclusive setting with "Service".
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: Optional[pulumi.Input['_core.v1.TypedLocalObjectReferenceArgs']]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input['IngressServiceBackendArgs']]:
        """
        service references a service as a backend. This is a mutually exclusive setting with "Resource".
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input['IngressServiceBackendArgs']]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class IngressClassParametersReferencePatchArgs:
    def __init__(__self__, *,
                 api_group: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        IngressClassParametersReference identifies an API object. This can be used to specify a cluster or namespace-scoped resource.
        :param pulumi.Input[str] api_group: apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        :param pulumi.Input[str] kind: kind is the type of resource being referenced.
        :param pulumi.Input[str] name: name is the name of resource being referenced.
        :param pulumi.Input[str] namespace: namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
        :param pulumi.Input[str] scope: scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[pulumi.Input[str]]:
        """
        apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        """
        return pulumi.get(self, "api_group")

    @api_group.setter
    def api_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_group", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        kind is the type of resource being referenced.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class IngressClassParametersReferenceArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str],
                 name: pulumi.Input[str],
                 api_group: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None):
        """
        IngressClassParametersReference identifies an API object. This can be used to specify a cluster or namespace-scoped resource.
        :param pulumi.Input[str] kind: kind is the type of resource being referenced.
        :param pulumi.Input[str] name: name is the name of resource being referenced.
        :param pulumi.Input[str] api_group: apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        :param pulumi.Input[str] namespace: namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
        :param pulumi.Input[str] scope: scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        kind is the type of resource being referenced.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[pulumi.Input[str]]:
        """
        apiGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
        """
        return pulumi.get(self, "api_group")

    @api_group.setter
    def api_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_group", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        namespace is the namespace of the resource being referenced. This field is required when scope is set to "Namespace" and must be unset when scope is set to "Cluster".
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        scope represents if this refers to a cluster or namespace scoped resource. This may be set to "Cluster" (default) or "Namespace".
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class IngressClassSpecPatchArgs:
    def __init__(__self__, *,
                 controller: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input['IngressClassParametersReferencePatchArgs']] = None):
        """
        IngressClassSpec provides information about the class of an Ingress.
        :param pulumi.Input[str] controller: controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
        :param pulumi.Input['IngressClassParametersReferencePatchArgs'] parameters: parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def controller(self) -> Optional[pulumi.Input[str]]:
        """
        controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
        """
        return pulumi.get(self, "controller")

    @controller.setter
    def controller(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input['IngressClassParametersReferencePatchArgs']]:
        """
        parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input['IngressClassParametersReferencePatchArgs']]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class IngressClassSpecArgs:
    def __init__(__self__, *,
                 controller: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input['IngressClassParametersReferenceArgs']] = None):
        """
        IngressClassSpec provides information about the class of an Ingress.
        :param pulumi.Input[str] controller: controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
        :param pulumi.Input['IngressClassParametersReferenceArgs'] parameters: parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def controller(self) -> Optional[pulumi.Input[str]]:
        """
        controller refers to the name of the controller that should handle this class. This allows for different "flavors" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. "acme.io/ingress-controller". This field is immutable.
        """
        return pulumi.get(self, "controller")

    @controller.setter
    def controller(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controller", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input['IngressClassParametersReferenceArgs']]:
        """
        parameters is a link to a custom resource containing additional configuration for the controller. This is optional if the controller does not require extra parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input['IngressClassParametersReferenceArgs']]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class IngressClassArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['IngressClassSpecArgs']] = None):
        """
        IngressClass represents the class of the Ingress, referenced by the Ingress Spec. The `ingressclass.kubernetes.io/is-default-class` annotation can be used to indicate that an IngressClass should be considered default. When a single IngressClass resource has this annotation set to true, new Ingress resources without a class specified will be assigned this default class.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['IngressClassSpecArgs'] spec: spec is the desired state of the IngressClass. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'networking.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'IngressClass')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['IngressClassSpecArgs']]:
        """
        spec is the desired state of the IngressClass. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['IngressClassSpecArgs']]):
        pulumi.set(self, "spec", value)


@pulumi.input_type
class IngressLoadBalancerIngressArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['IngressPortStatusArgs']]]] = None):
        """
        IngressLoadBalancerIngress represents the status of a load-balancer ingress point.
        :param pulumi.Input[str] hostname: hostname is set for load-balancer ingress points that are DNS based.
        :param pulumi.Input[str] ip: ip is set for load-balancer ingress points that are IP based.
        :param pulumi.Input[Sequence[pulumi.Input['IngressPortStatusArgs']]] ports: ports provides information about the ports exposed by this LoadBalancer.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        hostname is set for load-balancer ingress points that are DNS based.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        ip is set for load-balancer ingress points that are IP based.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IngressPortStatusArgs']]]]:
        """
        ports provides information about the ports exposed by this LoadBalancer.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IngressPortStatusArgs']]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class IngressLoadBalancerStatusArgs:
    def __init__(__self__, *,
                 ingress: Optional[pulumi.Input[Sequence[pulumi.Input['IngressLoadBalancerIngressArgs']]]] = None):
        """
        IngressLoadBalancerStatus represents the status of a load-balancer.
        :param pulumi.Input[Sequence[pulumi.Input['IngressLoadBalancerIngressArgs']]] ingress: ingress is a list containing ingress points for the load-balancer.
        """
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IngressLoadBalancerIngressArgs']]]]:
        """
        ingress is a list containing ingress points for the load-balancer.
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IngressLoadBalancerIngressArgs']]]]):
        pulumi.set(self, "ingress", value)


@pulumi.input_type
class IngressPortStatusArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 error: Optional[pulumi.Input[str]] = None):
        """
        IngressPortStatus represents the error condition of a service port
        :param pulumi.Input[int] port: port is the port number of the ingress port.
        :param pulumi.Input[str] protocol: protocol is the protocol of the ingress port. The supported values are: "TCP", "UDP", "SCTP"
        :param pulumi.Input[str] error: error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
                 CamelCase names
               - cloud provider specific error values must have names that comply with the
                 format foo.example.com/CamelCase.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        port is the port number of the ingress port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        protocol is the protocol of the ingress port. The supported values are: "TCP", "UDP", "SCTP"
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def error(self) -> Optional[pulumi.Input[str]]:
        """
        error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use
          CamelCase names
        - cloud provider specific error values must have names that comply with the
          format foo.example.com/CamelCase.
        """
        return pulumi.get(self, "error")

    @error.setter
    def error(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error", value)


@pulumi.input_type
class IngressRulePatchArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 http: Optional[pulumi.Input['HTTPIngressRuleValuePatchArgs']] = None):
        """
        IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
        :param pulumi.Input[str] host: host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
                  the IP in the Spec of the parent Ingress.
               2. The `:` delimiter is not respected because ports are not allowed.
               	  Currently the port of an Ingress is implicitly :80 for http and
               	  :443 for https.
               Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
               
               host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http is not None:
            pulumi.set(__self__, "http", http)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
           the IP in the Spec of the parent Ingress.
        2. The `:` delimiter is not respected because ports are not allowed.
        	  Currently the port of an Ingress is implicitly :80 for http and
        	  :443 for https.
        Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.

        host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def http(self) -> Optional[pulumi.Input['HTTPIngressRuleValuePatchArgs']]:
        return pulumi.get(self, "http")

    @http.setter
    def http(self, value: Optional[pulumi.Input['HTTPIngressRuleValuePatchArgs']]):
        pulumi.set(self, "http", value)


@pulumi.input_type
class IngressRuleArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 http: Optional[pulumi.Input['HTTPIngressRuleValueArgs']] = None):
        """
        IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.
        :param pulumi.Input[str] host: host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
                  the IP in the Spec of the parent Ingress.
               2. The `:` delimiter is not respected because ports are not allowed.
               	  Currently the port of an Ingress is implicitly :80 for http and
               	  :443 for https.
               Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.
               
               host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http is not None:
            pulumi.set(__self__, "http", http)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the "host" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
           the IP in the Spec of the parent Ingress.
        2. The `:` delimiter is not respected because ports are not allowed.
        	  Currently the port of an Ingress is implicitly :80 for http and
        	  :443 for https.
        Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.

        host can be "precise" which is a domain name without the terminating dot of a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name prefixed with a single wildcard label (e.g. "*.foo.com"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*"). Requests will be matched against the Host field in the following way: 1. If host is precise, the request matches this rule if the http host header is equal to Host. 2. If host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def http(self) -> Optional[pulumi.Input['HTTPIngressRuleValueArgs']]:
        return pulumi.get(self, "http")

    @http.setter
    def http(self, value: Optional[pulumi.Input['HTTPIngressRuleValueArgs']]):
        pulumi.set(self, "http", value)


@pulumi.input_type
class IngressServiceBackendPatchArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input['ServiceBackendPortPatchArgs']] = None):
        """
        IngressServiceBackend references a Kubernetes Service as a Backend.
        :param pulumi.Input[str] name: name is the referenced service. The service must exist in the same namespace as the Ingress object.
        :param pulumi.Input['ServiceBackendPortPatchArgs'] port: port of the referenced service. A port name or port number is required for a IngressServiceBackend.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name is the referenced service. The service must exist in the same namespace as the Ingress object.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input['ServiceBackendPortPatchArgs']]:
        """
        port of the referenced service. A port name or port number is required for a IngressServiceBackend.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input['ServiceBackendPortPatchArgs']]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class IngressServiceBackendArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 port: Optional[pulumi.Input['ServiceBackendPortArgs']] = None):
        """
        IngressServiceBackend references a Kubernetes Service as a Backend.
        :param pulumi.Input[str] name: name is the referenced service. The service must exist in the same namespace as the Ingress object.
        :param pulumi.Input['ServiceBackendPortArgs'] port: port of the referenced service. A port name or port number is required for a IngressServiceBackend.
        """
        pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        name is the referenced service. The service must exist in the same namespace as the Ingress object.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input['ServiceBackendPortArgs']]:
        """
        port of the referenced service. A port name or port number is required for a IngressServiceBackend.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input['ServiceBackendPortArgs']]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class IngressSpecPatchArgs:
    def __init__(__self__, *,
                 default_backend: Optional[pulumi.Input['IngressBackendPatchArgs']] = None,
                 ingress_class_name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['IngressRulePatchArgs']]]] = None,
                 tls: Optional[pulumi.Input[Sequence[pulumi.Input['IngressTLSPatchArgs']]]] = None):
        """
        IngressSpec describes the Ingress the user wishes to exist.
        :param pulumi.Input['IngressBackendPatchArgs'] default_backend: defaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
        :param pulumi.Input[str] ingress_class_name: ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
        :param pulumi.Input[Sequence[pulumi.Input['IngressRulePatchArgs']]] rules: rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        :param pulumi.Input[Sequence[pulumi.Input['IngressTLSPatchArgs']]] tls: tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        if default_backend is not None:
            pulumi.set(__self__, "default_backend", default_backend)
        if ingress_class_name is not None:
            pulumi.set(__self__, "ingress_class_name", ingress_class_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter(name="defaultBackend")
    def default_backend(self) -> Optional[pulumi.Input['IngressBackendPatchArgs']]:
        """
        defaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
        """
        return pulumi.get(self, "default_backend")

    @default_backend.setter
    def default_backend(self, value: Optional[pulumi.Input['IngressBackendPatchArgs']]):
        pulumi.set(self, "default_backend", value)

    @property
    @pulumi.getter(name="ingressClassName")
    def ingress_class_name(self) -> Optional[pulumi.Input[str]]:
        """
        ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
        """
        return pulumi.get(self, "ingress_class_name")

    @ingress_class_name.setter
    def ingress_class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_class_name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IngressRulePatchArgs']]]]:
        """
        rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IngressRulePatchArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IngressTLSPatchArgs']]]]:
        """
        tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IngressTLSPatchArgs']]]]):
        pulumi.set(self, "tls", value)


@pulumi.input_type
class IngressSpecArgs:
    def __init__(__self__, *,
                 default_backend: Optional[pulumi.Input['IngressBackendArgs']] = None,
                 ingress_class_name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]]] = None,
                 tls: Optional[pulumi.Input[Sequence[pulumi.Input['IngressTLSArgs']]]] = None):
        """
        IngressSpec describes the Ingress the user wishes to exist.
        :param pulumi.Input['IngressBackendArgs'] default_backend: defaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
        :param pulumi.Input[str] ingress_class_name: ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
        :param pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]] rules: rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        :param pulumi.Input[Sequence[pulumi.Input['IngressTLSArgs']]] tls: tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        if default_backend is not None:
            pulumi.set(__self__, "default_backend", default_backend)
        if ingress_class_name is not None:
            pulumi.set(__self__, "ingress_class_name", ingress_class_name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter(name="defaultBackend")
    def default_backend(self) -> Optional[pulumi.Input['IngressBackendArgs']]:
        """
        defaultBackend is the backend that should handle requests that don't match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
        """
        return pulumi.get(self, "default_backend")

    @default_backend.setter
    def default_backend(self, value: Optional[pulumi.Input['IngressBackendArgs']]):
        pulumi.set(self, "default_backend", value)

    @property
    @pulumi.getter(name="ingressClassName")
    def ingress_class_name(self) -> Optional[pulumi.Input[str]]:
        """
        ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -> IngressClass -> Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
        """
        return pulumi.get(self, "ingress_class_name")

    @ingress_class_name.setter
    def ingress_class_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_class_name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]]]:
        """
        rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IngressTLSArgs']]]]:
        """
        tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IngressTLSArgs']]]]):
        pulumi.set(self, "tls", value)


@pulumi.input_type
class IngressStatusArgs:
    def __init__(__self__, *,
                 load_balancer: Optional[pulumi.Input['IngressLoadBalancerStatusArgs']] = None):
        """
        IngressStatus describe the current state of the Ingress.
        :param pulumi.Input['IngressLoadBalancerStatusArgs'] load_balancer: loadBalancer contains the current status of the load-balancer.
        """
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['IngressLoadBalancerStatusArgs']]:
        """
        loadBalancer contains the current status of the load-balancer.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['IngressLoadBalancerStatusArgs']]):
        pulumi.set(self, "load_balancer", value)


@pulumi.input_type
class IngressTLSPatchArgs:
    def __init__(__self__, *,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None):
        """
        IngressTLS describes the transport layer security associated with an ingress.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        :param pulumi.Input[str] secret_name: secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.
        """
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_name", value)


@pulumi.input_type
class IngressTLSArgs:
    def __init__(__self__, *,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None):
        """
        IngressTLS describes the transport layer security associated with an ingress.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hosts: hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        :param pulumi.Input[str] secret_name: secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.
        """
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        hosts is a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[str]]:
        """
        secretName is the name of the secret used to terminate TLS traffic on port 443. Field is left optional to allow TLS routing based on SNI hostname alone. If the SNI host in a listener conflicts with the "Host" header field used by an IngressRule, the SNI host is used for termination and value of the "Host" header is used for routing.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_name", value)


@pulumi.input_type
class IngressArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['IngressSpecArgs']] = None,
                 status: Optional[pulumi.Input['IngressStatusArgs']] = None):
        """
        Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend. An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.

        This resource waits until its status is ready before registering success
        for create/update, and populating output properties from the current state of the resource.
        The following conditions are used to determine whether the resource creation has
        succeeded or failed:

        1.  Ingress object exists.
        2.  Endpoint objects exist with matching names for each Ingress path (except when Service
            type is ExternalName).
        3.  Ingress entry exists for '.status.loadBalancer.ingress'.

        If the Ingress has not reached a Ready state after 10 minutes, it will
        time out and mark the resource update as Failed. You can override the default timeout value
        by setting the 'customTimeouts' option on the resource.
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['IngressSpecArgs'] spec: spec is the desired state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        :param pulumi.Input['IngressStatusArgs'] status: status is the current state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'networking.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'Ingress')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['IngressSpecArgs']]:
        """
        spec is the desired state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['IngressSpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['IngressStatusArgs']]:
        """
        status is the current state of the Ingress. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['IngressStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class NetworkPolicyEgressRulePatchArgs:
    def __init__(__self__, *,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortPatchArgs']]]] = None,
                 to: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerPatchArgs']]]] = None):
        """
        NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortPatchArgs']]] ports: ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerPatchArgs']]] to: to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortPatchArgs']]]]:
        """
        ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortPatchArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def to(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerPatchArgs']]]]:
        """
        to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerPatchArgs']]]]):
        pulumi.set(self, "to", value)


@pulumi.input_type
class NetworkPolicyEgressRuleArgs:
    def __init__(__self__, *,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortArgs']]]] = None,
                 to: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerArgs']]]] = None):
        """
        NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortArgs']]] ports: ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerArgs']]] to: to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if to is not None:
            pulumi.set(__self__, "to", to)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortArgs']]]]:
        """
        ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def to(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerArgs']]]]:
        """
        to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.
        """
        return pulumi.get(self, "to")

    @to.setter
    def to(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerArgs']]]]):
        pulumi.set(self, "to", value)


@pulumi.input_type
class NetworkPolicyIngressRulePatchArgs:
    def __init__(__self__, *,
                 from_: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerPatchArgs']]]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortPatchArgs']]]] = None):
        """
        NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerPatchArgs']]] from_: from is a list of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortPatchArgs']]] ports: ports is a list of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerPatchArgs']]]]:
        """
        from is a list of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerPatchArgs']]]]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortPatchArgs']]]]:
        """
        ports is a list of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortPatchArgs']]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class NetworkPolicyIngressRuleArgs:
    def __init__(__self__, *,
                 from_: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerArgs']]]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortArgs']]]] = None):
        """
        NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerArgs']]] from_: from is a list of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortArgs']]] ports: ports is a list of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        if from_ is not None:
            pulumi.set(__self__, "from_", from_)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerArgs']]]]:
        """
        from is a list of sources which should be able to access the pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all sources (traffic not restricted by source). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the from list.
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPeerArgs']]]]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortArgs']]]]:
        """
        ports is a list of ports which should be made accessible on the pods selected for this rule. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyPortArgs']]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class NetworkPolicyPeerPatchArgs:
    def __init__(__self__, *,
                 ip_block: Optional[pulumi.Input['IPBlockPatchArgs']] = None,
                 namespace_selector: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']] = None,
                 pod_selector: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']] = None):
        """
        NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed
        :param pulumi.Input['IPBlockPatchArgs'] ip_block: ipBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        :param pulumi.Input['_meta.v1.LabelSelectorPatchArgs'] namespace_selector: namespaceSelector selects namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.
               
               If podSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the namespaces selected by namespaceSelector. Otherwise it selects all pods in the namespaces selected by namespaceSelector.
        :param pulumi.Input['_meta.v1.LabelSelectorPatchArgs'] pod_selector: podSelector is a label selector which selects pods. This field follows standard label selector semantics; if present but empty, it selects all pods.
               
               If namespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the pods matching podSelector in the policy's own namespace.
        """
        if ip_block is not None:
            pulumi.set(__self__, "ip_block", ip_block)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if pod_selector is not None:
            pulumi.set(__self__, "pod_selector", pod_selector)

    @property
    @pulumi.getter(name="ipBlock")
    def ip_block(self) -> Optional[pulumi.Input['IPBlockPatchArgs']]:
        """
        ipBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        """
        return pulumi.get(self, "ip_block")

    @ip_block.setter
    def ip_block(self, value: Optional[pulumi.Input['IPBlockPatchArgs']]):
        pulumi.set(self, "ip_block", value)

    @property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]:
        """
        namespaceSelector selects namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.

        If podSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the namespaces selected by namespaceSelector. Otherwise it selects all pods in the namespaces selected by namespaceSelector.
        """
        return pulumi.get(self, "namespace_selector")

    @namespace_selector.setter
    def namespace_selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]):
        pulumi.set(self, "namespace_selector", value)

    @property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]:
        """
        podSelector is a label selector which selects pods. This field follows standard label selector semantics; if present but empty, it selects all pods.

        If namespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the pods matching podSelector in the policy's own namespace.
        """
        return pulumi.get(self, "pod_selector")

    @pod_selector.setter
    def pod_selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]):
        pulumi.set(self, "pod_selector", value)


@pulumi.input_type
class NetworkPolicyPeerArgs:
    def __init__(__self__, *,
                 ip_block: Optional[pulumi.Input['IPBlockArgs']] = None,
                 namespace_selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None,
                 pod_selector: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']] = None):
        """
        NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed
        :param pulumi.Input['IPBlockArgs'] ip_block: ipBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] namespace_selector: namespaceSelector selects namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.
               
               If podSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the namespaces selected by namespaceSelector. Otherwise it selects all pods in the namespaces selected by namespaceSelector.
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] pod_selector: podSelector is a label selector which selects pods. This field follows standard label selector semantics; if present but empty, it selects all pods.
               
               If namespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the pods matching podSelector in the policy's own namespace.
        """
        if ip_block is not None:
            pulumi.set(__self__, "ip_block", ip_block)
        if namespace_selector is not None:
            pulumi.set(__self__, "namespace_selector", namespace_selector)
        if pod_selector is not None:
            pulumi.set(__self__, "pod_selector", pod_selector)

    @property
    @pulumi.getter(name="ipBlock")
    def ip_block(self) -> Optional[pulumi.Input['IPBlockArgs']]:
        """
        ipBlock defines policy on a particular IPBlock. If this field is set then neither of the other fields can be.
        """
        return pulumi.get(self, "ip_block")

    @ip_block.setter
    def ip_block(self, value: Optional[pulumi.Input['IPBlockArgs']]):
        pulumi.set(self, "ip_block", value)

    @property
    @pulumi.getter(name="namespaceSelector")
    def namespace_selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        namespaceSelector selects namespaces using cluster-scoped labels. This field follows standard label selector semantics; if present but empty, it selects all namespaces.

        If podSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the namespaces selected by namespaceSelector. Otherwise it selects all pods in the namespaces selected by namespaceSelector.
        """
        return pulumi.get(self, "namespace_selector")

    @namespace_selector.setter
    def namespace_selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "namespace_selector", value)

    @property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]:
        """
        podSelector is a label selector which selects pods. This field follows standard label selector semantics; if present but empty, it selects all pods.

        If namespaceSelector is also set, then the NetworkPolicyPeer as a whole selects the pods matching podSelector in the Namespaces selected by NamespaceSelector. Otherwise it selects the pods matching podSelector in the policy's own namespace.
        """
        return pulumi.get(self, "pod_selector")

    @pod_selector.setter
    def pod_selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorArgs']]):
        pulumi.set(self, "pod_selector", value)


@pulumi.input_type
class NetworkPolicyPortPatchArgs:
    def __init__(__self__, *,
                 end_port: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[Union[int, str]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        NetworkPolicyPort describes a port to allow traffic on
        :param pulumi.Input[int] end_port: endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port.
        :param pulumi.Input[Union[int, str]] port: port represents the port on the given protocol. This can either be a numerical or named port on a pod. If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        :param pulumi.Input[str] protocol: protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        if end_port is not None:
            pulumi.set(__self__, "end_port", end_port)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> Optional[pulumi.Input[int]]:
        """
        endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port.
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "end_port", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[Union[int, str]]]:
        """
        port represents the port on the given protocol. This can either be a numerical or named port on a pod. If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[Union[int, str]]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class NetworkPolicyPortArgs:
    def __init__(__self__, *,
                 end_port: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[Union[int, str]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        NetworkPolicyPort describes a port to allow traffic on
        :param pulumi.Input[int] end_port: endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port.
        :param pulumi.Input[Union[int, str]] port: port represents the port on the given protocol. This can either be a numerical or named port on a pod. If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        :param pulumi.Input[str] protocol: protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        if end_port is not None:
            pulumi.set(__self__, "end_port", end_port)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> Optional[pulumi.Input[int]]:
        """
        endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port.
        """
        return pulumi.get(self, "end_port")

    @end_port.setter
    def end_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "end_port", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[Union[int, str]]]:
        """
        port represents the port on the given protocol. This can either be a numerical or named port on a pod. If this field is not provided, this matches all port names and numbers. If present, only traffic on the specified protocol AND port will be matched.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[Union[int, str]]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class NetworkPolicySpecPatchArgs:
    def __init__(__self__, *,
                 egress: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyEgressRulePatchArgs']]]] = None,
                 ingress: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyIngressRulePatchArgs']]]] = None,
                 pod_selector: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']] = None,
                 policy_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        NetworkPolicySpec provides the specification of a NetworkPolicy
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyEgressRulePatchArgs']]] egress: egress is a list of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyIngressRulePatchArgs']]] ingress: ingress is a list of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)
        :param pulumi.Input['_meta.v1.LabelSelectorPatchArgs'] pod_selector: podSelector selects the pods to which this NetworkPolicy object applies. The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods. In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_types: policyTypes is a list of rule types that the NetworkPolicy relates to. Valid options are ["Ingress"], ["Egress"], or ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of ingress or egress rules; policies that contain an egress section are assumed to affect egress, and all policies (whether or not they contain an ingress section) are assumed to affect ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if pod_selector is not None:
            pulumi.set(__self__, "pod_selector", pod_selector)
        if policy_types is not None:
            pulumi.set(__self__, "policy_types", policy_types)

    @property
    @pulumi.getter
    def egress(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyEgressRulePatchArgs']]]]:
        """
        egress is a list of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        """
        return pulumi.get(self, "egress")

    @egress.setter
    def egress(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyEgressRulePatchArgs']]]]):
        pulumi.set(self, "egress", value)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyIngressRulePatchArgs']]]]:
        """
        ingress is a list of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyIngressRulePatchArgs']]]]):
        pulumi.set(self, "ingress", value)

    @property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]:
        """
        podSelector selects the pods to which this NetworkPolicy object applies. The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods. In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        """
        return pulumi.get(self, "pod_selector")

    @pod_selector.setter
    def pod_selector(self, value: Optional[pulumi.Input['_meta.v1.LabelSelectorPatchArgs']]):
        pulumi.set(self, "pod_selector", value)

    @property
    @pulumi.getter(name="policyTypes")
    def policy_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        policyTypes is a list of rule types that the NetworkPolicy relates to. Valid options are ["Ingress"], ["Egress"], or ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of ingress or egress rules; policies that contain an egress section are assumed to affect egress, and all policies (whether or not they contain an ingress section) are assumed to affect ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        return pulumi.get(self, "policy_types")

    @policy_types.setter
    def policy_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_types", value)


@pulumi.input_type
class NetworkPolicySpecArgs:
    def __init__(__self__, *,
                 pod_selector: pulumi.Input['_meta.v1.LabelSelectorArgs'],
                 egress: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyEgressRuleArgs']]]] = None,
                 ingress: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyIngressRuleArgs']]]] = None,
                 policy_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        NetworkPolicySpec provides the specification of a NetworkPolicy
        :param pulumi.Input['_meta.v1.LabelSelectorArgs'] pod_selector: podSelector selects the pods to which this NetworkPolicy object applies. The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods. In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyEgressRuleArgs']]] egress: egress is a list of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        :param pulumi.Input[Sequence[pulumi.Input['NetworkPolicyIngressRuleArgs']]] ingress: ingress is a list of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_types: policyTypes is a list of rule types that the NetworkPolicy relates to. Valid options are ["Ingress"], ["Egress"], or ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of ingress or egress rules; policies that contain an egress section are assumed to affect egress, and all policies (whether or not they contain an ingress section) are assumed to affect ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        pulumi.set(__self__, "pod_selector", pod_selector)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if policy_types is not None:
            pulumi.set(__self__, "policy_types", policy_types)

    @property
    @pulumi.getter(name="podSelector")
    def pod_selector(self) -> pulumi.Input['_meta.v1.LabelSelectorArgs']:
        """
        podSelector selects the pods to which this NetworkPolicy object applies. The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods. In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.
        """
        return pulumi.get(self, "pod_selector")

    @pod_selector.setter
    def pod_selector(self, value: pulumi.Input['_meta.v1.LabelSelectorArgs']):
        pulumi.set(self, "pod_selector", value)

    @property
    @pulumi.getter
    def egress(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyEgressRuleArgs']]]]:
        """
        egress is a list of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
        """
        return pulumi.get(self, "egress")

    @egress.setter
    def egress(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyEgressRuleArgs']]]]):
        pulumi.set(self, "egress", value)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyIngressRuleArgs']]]]:
        """
        ingress is a list of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkPolicyIngressRuleArgs']]]]):
        pulumi.set(self, "ingress", value)

    @property
    @pulumi.getter(name="policyTypes")
    def policy_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        policyTypes is a list of rule types that the NetworkPolicy relates to. Valid options are ["Ingress"], ["Egress"], or ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of ingress or egress rules; policies that contain an egress section are assumed to affect egress, and all policies (whether or not they contain an ingress section) are assumed to affect ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include "Egress" (since such a policy would not include an egress section and would otherwise default to just [ "Ingress" ]). This field is beta-level in 1.8
        """
        return pulumi.get(self, "policy_types")

    @policy_types.setter
    def policy_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_types", value)


@pulumi.input_type
class NetworkPolicyStatusArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]]] = None):
        """
        NetworkPolicyStatus describe the current state of the NetworkPolicy.
        :param pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]] conditions: Conditions holds an array of metav1.Condition that describe the state of the NetworkPolicy. Current service state
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]]]:
        """
        Conditions holds an array of metav1.Condition that describe the state of the NetworkPolicy. Current service state
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_meta.v1.ConditionArgs']]]]):
        pulumi.set(self, "conditions", value)


@pulumi.input_type
class NetworkPolicyArgs:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']] = None,
                 spec: Optional[pulumi.Input['NetworkPolicySpecArgs']] = None,
                 status: Optional[pulumi.Input['NetworkPolicyStatusArgs']] = None):
        """
        NetworkPolicy describes what network traffic is allowed for a set of Pods
        :param pulumi.Input[str] api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param pulumi.Input[str] kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param pulumi.Input['_meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param pulumi.Input['NetworkPolicySpecArgs'] spec: spec represents the specification of the desired behavior for this NetworkPolicy.
        :param pulumi.Input['NetworkPolicyStatusArgs'] status: Status is the current state of the NetworkPolicy. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'networking.k8s.io/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'NetworkPolicy')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[str]]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['_meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['NetworkPolicySpecArgs']]:
        """
        spec represents the specification of the desired behavior for this NetworkPolicy.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['NetworkPolicySpecArgs']]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['NetworkPolicyStatusArgs']]:
        """
        Status is the current state of the NetworkPolicy. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['NetworkPolicyStatusArgs']]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ServiceBackendPortPatchArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 number: Optional[pulumi.Input[int]] = None):
        """
        ServiceBackendPort is the service port being referenced.
        :param pulumi.Input[str] name: name is the name of the port on the Service. This is a mutually exclusive setting with "Number".
        :param pulumi.Input[int] number: number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with "Name".
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number is not None:
            pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name is the name of the port on the Service. This is a mutually exclusive setting with "Number".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[int]]:
        """
        number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with "Name".
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number", value)


@pulumi.input_type
class ServiceBackendPortArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 number: Optional[pulumi.Input[int]] = None):
        """
        ServiceBackendPort is the service port being referenced.
        :param pulumi.Input[str] name: name is the name of the port on the Service. This is a mutually exclusive setting with "Number".
        :param pulumi.Input[int] number: number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with "Name".
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number is not None:
            pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name is the name of the port on the Service. This is a mutually exclusive setting with "Number".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[int]]:
        """
        number is the numerical port number (e.g. 80) on the Service. This is a mutually exclusive setting with "Name".
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number", value)


