# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ... import meta as _meta

__all__ = [
    'PodDisruptionBudget',
    'PodDisruptionBudgetSpec',
    'PodDisruptionBudgetSpecPatch',
    'PodDisruptionBudgetStatus',
    'PodDisruptionBudgetStatusPatch',
]

@pulumi.output_type
class PodDisruptionBudget(dict):
    """
    PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodDisruptionBudget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodDisruptionBudget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodDisruptionBudget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 spec: Optional['outputs.PodDisruptionBudgetSpec'] = None,
                 status: Optional['outputs.PodDisruptionBudgetStatus'] = None):
        """
        PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        :param 'PodDisruptionBudgetSpecArgs' spec: Specification of the desired behavior of the PodDisruptionBudget.
        :param 'PodDisruptionBudgetStatusArgs' status: Most recently observed status of the PodDisruptionBudget.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'policy/v1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PodDisruptionBudget')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.PodDisruptionBudgetSpec']:
        """
        Specification of the desired behavior of the PodDisruptionBudget.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.PodDisruptionBudgetStatus']:
        """
        Most recently observed status of the PodDisruptionBudget.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PodDisruptionBudgetSpec(dict):
    """
    PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnavailable":
            suggest = "max_unavailable"
        elif key == "minAvailable":
            suggest = "min_available"
        elif key == "unhealthyPodEvictionPolicy":
            suggest = "unhealthy_pod_eviction_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodDisruptionBudgetSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodDisruptionBudgetSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodDisruptionBudgetSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unavailable: Optional[Any] = None,
                 min_available: Optional[Any] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelector'] = None,
                 unhealthy_pod_eviction_policy: Optional[str] = None):
        """
        PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.
        :param Union[int, str] max_unavailable: An eviction is allowed if at most "maxUnavailable" pods selected by "selector" are unavailable after the eviction, i.e. even in absence of the evicted pod. For example, one can prevent all voluntary evictions by specifying 0. This is a mutually exclusive setting with "minAvailable".
        :param Union[int, str] min_available: An eviction is allowed if at least "minAvailable" pods selected by "selector" will still be available after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent all voluntary evictions by specifying "100%".
        :param '_meta.v1.LabelSelectorArgs' selector: Label query over pods whose evictions are managed by the disruption budget. A null selector will match no pods, while an empty ({}) selector will select all pods within the namespace.
        :param str unhealthy_pod_eviction_policy: UnhealthyPodEvictionPolicy defines the criteria for when unhealthy pods should be considered for eviction. Current implementation considers healthy pods, as pods that have status.conditions item with type="Ready",status="True".
               
               Valid policies are IfHealthyBudget and AlwaysAllow. If no policy is specified, the default behavior will be used, which corresponds to the IfHealthyBudget policy.
               
               IfHealthyBudget policy means that running pods (status.phase="Running"), but not yet healthy can be evicted only if the guarded application is not disrupted (status.currentHealthy is at least equal to status.desiredHealthy). Healthy pods will be subject to the PDB for eviction.
               
               AlwaysAllow policy means that all running pods (status.phase="Running"), but not yet healthy are considered disrupted and can be evicted regardless of whether the criteria in a PDB is met. This means perspective running pods of a disrupted application might not get a chance to become healthy. Healthy pods will be subject to the PDB for eviction.
               
               Additional policies may be added in the future. Clients making eviction decisions should disallow eviction of unhealthy pods if they encounter an unrecognized policy in this field.
               
               This field is beta-level. The eviction API uses this field when the feature gate PDBUnhealthyPodEvictionPolicy is enabled (enabled by default).
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if min_available is not None:
            pulumi.set(__self__, "min_available", min_available)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if unhealthy_pod_eviction_policy is not None:
            pulumi.set(__self__, "unhealthy_pod_eviction_policy", unhealthy_pod_eviction_policy)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        An eviction is allowed if at most "maxUnavailable" pods selected by "selector" are unavailable after the eviction, i.e. even in absence of the evicted pod. For example, one can prevent all voluntary evictions by specifying 0. This is a mutually exclusive setting with "minAvailable".
        """
        return pulumi.get(self, "max_unavailable")

    @property
    @pulumi.getter(name="minAvailable")
    def min_available(self) -> Optional[Any]:
        """
        An eviction is allowed if at least "minAvailable" pods selected by "selector" will still be available after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent all voluntary evictions by specifying "100%".
        """
        return pulumi.get(self, "min_available")

    @property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelector']:
        """
        Label query over pods whose evictions are managed by the disruption budget. A null selector will match no pods, while an empty ({}) selector will select all pods within the namespace.
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="unhealthyPodEvictionPolicy")
    def unhealthy_pod_eviction_policy(self) -> Optional[str]:
        """
        UnhealthyPodEvictionPolicy defines the criteria for when unhealthy pods should be considered for eviction. Current implementation considers healthy pods, as pods that have status.conditions item with type="Ready",status="True".

        Valid policies are IfHealthyBudget and AlwaysAllow. If no policy is specified, the default behavior will be used, which corresponds to the IfHealthyBudget policy.

        IfHealthyBudget policy means that running pods (status.phase="Running"), but not yet healthy can be evicted only if the guarded application is not disrupted (status.currentHealthy is at least equal to status.desiredHealthy). Healthy pods will be subject to the PDB for eviction.

        AlwaysAllow policy means that all running pods (status.phase="Running"), but not yet healthy are considered disrupted and can be evicted regardless of whether the criteria in a PDB is met. This means perspective running pods of a disrupted application might not get a chance to become healthy. Healthy pods will be subject to the PDB for eviction.

        Additional policies may be added in the future. Clients making eviction decisions should disallow eviction of unhealthy pods if they encounter an unrecognized policy in this field.

        This field is beta-level. The eviction API uses this field when the feature gate PDBUnhealthyPodEvictionPolicy is enabled (enabled by default).
        """
        return pulumi.get(self, "unhealthy_pod_eviction_policy")


@pulumi.output_type
class PodDisruptionBudgetSpecPatch(dict):
    """
    PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnavailable":
            suggest = "max_unavailable"
        elif key == "minAvailable":
            suggest = "min_available"
        elif key == "unhealthyPodEvictionPolicy":
            suggest = "unhealthy_pod_eviction_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodDisruptionBudgetSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodDisruptionBudgetSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodDisruptionBudgetSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unavailable: Optional[Any] = None,
                 min_available: Optional[Any] = None,
                 selector: Optional['_meta.v1.outputs.LabelSelectorPatch'] = None,
                 unhealthy_pod_eviction_policy: Optional[str] = None):
        """
        PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.
        :param Union[int, str] max_unavailable: An eviction is allowed if at most "maxUnavailable" pods selected by "selector" are unavailable after the eviction, i.e. even in absence of the evicted pod. For example, one can prevent all voluntary evictions by specifying 0. This is a mutually exclusive setting with "minAvailable".
        :param Union[int, str] min_available: An eviction is allowed if at least "minAvailable" pods selected by "selector" will still be available after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent all voluntary evictions by specifying "100%".
        :param '_meta.v1.LabelSelectorPatchArgs' selector: Label query over pods whose evictions are managed by the disruption budget. A null selector will match no pods, while an empty ({}) selector will select all pods within the namespace.
        :param str unhealthy_pod_eviction_policy: UnhealthyPodEvictionPolicy defines the criteria for when unhealthy pods should be considered for eviction. Current implementation considers healthy pods, as pods that have status.conditions item with type="Ready",status="True".
               
               Valid policies are IfHealthyBudget and AlwaysAllow. If no policy is specified, the default behavior will be used, which corresponds to the IfHealthyBudget policy.
               
               IfHealthyBudget policy means that running pods (status.phase="Running"), but not yet healthy can be evicted only if the guarded application is not disrupted (status.currentHealthy is at least equal to status.desiredHealthy). Healthy pods will be subject to the PDB for eviction.
               
               AlwaysAllow policy means that all running pods (status.phase="Running"), but not yet healthy are considered disrupted and can be evicted regardless of whether the criteria in a PDB is met. This means perspective running pods of a disrupted application might not get a chance to become healthy. Healthy pods will be subject to the PDB for eviction.
               
               Additional policies may be added in the future. Clients making eviction decisions should disallow eviction of unhealthy pods if they encounter an unrecognized policy in this field.
               
               This field is beta-level. The eviction API uses this field when the feature gate PDBUnhealthyPodEvictionPolicy is enabled (enabled by default).
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if min_available is not None:
            pulumi.set(__self__, "min_available", min_available)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if unhealthy_pod_eviction_policy is not None:
            pulumi.set(__self__, "unhealthy_pod_eviction_policy", unhealthy_pod_eviction_policy)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[Any]:
        """
        An eviction is allowed if at most "maxUnavailable" pods selected by "selector" are unavailable after the eviction, i.e. even in absence of the evicted pod. For example, one can prevent all voluntary evictions by specifying 0. This is a mutually exclusive setting with "minAvailable".
        """
        return pulumi.get(self, "max_unavailable")

    @property
    @pulumi.getter(name="minAvailable")
    def min_available(self) -> Optional[Any]:
        """
        An eviction is allowed if at least "minAvailable" pods selected by "selector" will still be available after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent all voluntary evictions by specifying "100%".
        """
        return pulumi.get(self, "min_available")

    @property
    @pulumi.getter
    def selector(self) -> Optional['_meta.v1.outputs.LabelSelectorPatch']:
        """
        Label query over pods whose evictions are managed by the disruption budget. A null selector will match no pods, while an empty ({}) selector will select all pods within the namespace.
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="unhealthyPodEvictionPolicy")
    def unhealthy_pod_eviction_policy(self) -> Optional[str]:
        """
        UnhealthyPodEvictionPolicy defines the criteria for when unhealthy pods should be considered for eviction. Current implementation considers healthy pods, as pods that have status.conditions item with type="Ready",status="True".

        Valid policies are IfHealthyBudget and AlwaysAllow. If no policy is specified, the default behavior will be used, which corresponds to the IfHealthyBudget policy.

        IfHealthyBudget policy means that running pods (status.phase="Running"), but not yet healthy can be evicted only if the guarded application is not disrupted (status.currentHealthy is at least equal to status.desiredHealthy). Healthy pods will be subject to the PDB for eviction.

        AlwaysAllow policy means that all running pods (status.phase="Running"), but not yet healthy are considered disrupted and can be evicted regardless of whether the criteria in a PDB is met. This means perspective running pods of a disrupted application might not get a chance to become healthy. Healthy pods will be subject to the PDB for eviction.

        Additional policies may be added in the future. Clients making eviction decisions should disallow eviction of unhealthy pods if they encounter an unrecognized policy in this field.

        This field is beta-level. The eviction API uses this field when the feature gate PDBUnhealthyPodEvictionPolicy is enabled (enabled by default).
        """
        return pulumi.get(self, "unhealthy_pod_eviction_policy")


@pulumi.output_type
class PodDisruptionBudgetStatus(dict):
    """
    PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentHealthy":
            suggest = "current_healthy"
        elif key == "desiredHealthy":
            suggest = "desired_healthy"
        elif key == "disruptionsAllowed":
            suggest = "disruptions_allowed"
        elif key == "expectedPods":
            suggest = "expected_pods"
        elif key == "disruptedPods":
            suggest = "disrupted_pods"
        elif key == "observedGeneration":
            suggest = "observed_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodDisruptionBudgetStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodDisruptionBudgetStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodDisruptionBudgetStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_healthy: int,
                 desired_healthy: int,
                 disruptions_allowed: int,
                 expected_pods: int,
                 conditions: Optional[Sequence['_meta.v1.outputs.Condition']] = None,
                 disrupted_pods: Optional[Mapping[str, str]] = None,
                 observed_generation: Optional[int] = None):
        """
        PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system.
        :param int current_healthy: current number of healthy pods
        :param int desired_healthy: minimum desired number of healthy pods
        :param int disruptions_allowed: Number of pod disruptions that are currently allowed.
        :param int expected_pods: total number of pods counted by this disruption budget
        :param Sequence['_meta.v1.ConditionArgs'] conditions: Conditions contain conditions for PDB. The disruption controller sets the DisruptionAllowed condition. The following are known values for the reason field (additional reasons could be added in the future): - SyncFailed: The controller encountered an error and wasn't able to compute
                             the number of allowed disruptions. Therefore no disruptions are
                             allowed and the status of the condition will be False.
               - InsufficientPods: The number of pods are either at or below the number
                                   required by the PodDisruptionBudget. No disruptions are
                                   allowed and the status of the condition will be False.
               - SufficientPods: There are more pods than required by the PodDisruptionBudget.
                                 The condition will be True, and the number of allowed
                                 disruptions are provided by the disruptionsAllowed property.
        :param Mapping[str, str] disrupted_pods: DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn't occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.
        :param int observed_generation: Most recent generation observed when updating this PDB status. DisruptionsAllowed and other status information is valid only if observedGeneration equals to PDB's object generation.
        """
        pulumi.set(__self__, "current_healthy", current_healthy)
        pulumi.set(__self__, "desired_healthy", desired_healthy)
        pulumi.set(__self__, "disruptions_allowed", disruptions_allowed)
        pulumi.set(__self__, "expected_pods", expected_pods)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if disrupted_pods is not None:
            pulumi.set(__self__, "disrupted_pods", disrupted_pods)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)

    @property
    @pulumi.getter(name="currentHealthy")
    def current_healthy(self) -> int:
        """
        current number of healthy pods
        """
        return pulumi.get(self, "current_healthy")

    @property
    @pulumi.getter(name="desiredHealthy")
    def desired_healthy(self) -> int:
        """
        minimum desired number of healthy pods
        """
        return pulumi.get(self, "desired_healthy")

    @property
    @pulumi.getter(name="disruptionsAllowed")
    def disruptions_allowed(self) -> int:
        """
        Number of pod disruptions that are currently allowed.
        """
        return pulumi.get(self, "disruptions_allowed")

    @property
    @pulumi.getter(name="expectedPods")
    def expected_pods(self) -> int:
        """
        total number of pods counted by this disruption budget
        """
        return pulumi.get(self, "expected_pods")

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.Condition']]:
        """
        Conditions contain conditions for PDB. The disruption controller sets the DisruptionAllowed condition. The following are known values for the reason field (additional reasons could be added in the future): - SyncFailed: The controller encountered an error and wasn't able to compute
                      the number of allowed disruptions. Therefore no disruptions are
                      allowed and the status of the condition will be False.
        - InsufficientPods: The number of pods are either at or below the number
                            required by the PodDisruptionBudget. No disruptions are
                            allowed and the status of the condition will be False.
        - SufficientPods: There are more pods than required by the PodDisruptionBudget.
                          The condition will be True, and the number of allowed
                          disruptions are provided by the disruptionsAllowed property.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="disruptedPods")
    def disrupted_pods(self) -> Optional[Mapping[str, str]]:
        """
        DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn't occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.
        """
        return pulumi.get(self, "disrupted_pods")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[int]:
        """
        Most recent generation observed when updating this PDB status. DisruptionsAllowed and other status information is valid only if observedGeneration equals to PDB's object generation.
        """
        return pulumi.get(self, "observed_generation")


@pulumi.output_type
class PodDisruptionBudgetStatusPatch(dict):
    """
    PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentHealthy":
            suggest = "current_healthy"
        elif key == "desiredHealthy":
            suggest = "desired_healthy"
        elif key == "disruptedPods":
            suggest = "disrupted_pods"
        elif key == "disruptionsAllowed":
            suggest = "disruptions_allowed"
        elif key == "expectedPods":
            suggest = "expected_pods"
        elif key == "observedGeneration":
            suggest = "observed_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodDisruptionBudgetStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodDisruptionBudgetStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodDisruptionBudgetStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Optional[Sequence['_meta.v1.outputs.ConditionPatch']] = None,
                 current_healthy: Optional[int] = None,
                 desired_healthy: Optional[int] = None,
                 disrupted_pods: Optional[Mapping[str, str]] = None,
                 disruptions_allowed: Optional[int] = None,
                 expected_pods: Optional[int] = None,
                 observed_generation: Optional[int] = None):
        """
        PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system.
        :param Sequence['_meta.v1.ConditionPatchArgs'] conditions: Conditions contain conditions for PDB. The disruption controller sets the DisruptionAllowed condition. The following are known values for the reason field (additional reasons could be added in the future): - SyncFailed: The controller encountered an error and wasn't able to compute
                             the number of allowed disruptions. Therefore no disruptions are
                             allowed and the status of the condition will be False.
               - InsufficientPods: The number of pods are either at or below the number
                                   required by the PodDisruptionBudget. No disruptions are
                                   allowed and the status of the condition will be False.
               - SufficientPods: There are more pods than required by the PodDisruptionBudget.
                                 The condition will be True, and the number of allowed
                                 disruptions are provided by the disruptionsAllowed property.
        :param int current_healthy: current number of healthy pods
        :param int desired_healthy: minimum desired number of healthy pods
        :param Mapping[str, str] disrupted_pods: DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn't occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.
        :param int disruptions_allowed: Number of pod disruptions that are currently allowed.
        :param int expected_pods: total number of pods counted by this disruption budget
        :param int observed_generation: Most recent generation observed when updating this PDB status. DisruptionsAllowed and other status information is valid only if observedGeneration equals to PDB's object generation.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if current_healthy is not None:
            pulumi.set(__self__, "current_healthy", current_healthy)
        if desired_healthy is not None:
            pulumi.set(__self__, "desired_healthy", desired_healthy)
        if disrupted_pods is not None:
            pulumi.set(__self__, "disrupted_pods", disrupted_pods)
        if disruptions_allowed is not None:
            pulumi.set(__self__, "disruptions_allowed", disruptions_allowed)
        if expected_pods is not None:
            pulumi.set(__self__, "expected_pods", expected_pods)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[Sequence['_meta.v1.outputs.ConditionPatch']]:
        """
        Conditions contain conditions for PDB. The disruption controller sets the DisruptionAllowed condition. The following are known values for the reason field (additional reasons could be added in the future): - SyncFailed: The controller encountered an error and wasn't able to compute
                      the number of allowed disruptions. Therefore no disruptions are
                      allowed and the status of the condition will be False.
        - InsufficientPods: The number of pods are either at or below the number
                            required by the PodDisruptionBudget. No disruptions are
                            allowed and the status of the condition will be False.
        - SufficientPods: There are more pods than required by the PodDisruptionBudget.
                          The condition will be True, and the number of allowed
                          disruptions are provided by the disruptionsAllowed property.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="currentHealthy")
    def current_healthy(self) -> Optional[int]:
        """
        current number of healthy pods
        """
        return pulumi.get(self, "current_healthy")

    @property
    @pulumi.getter(name="desiredHealthy")
    def desired_healthy(self) -> Optional[int]:
        """
        minimum desired number of healthy pods
        """
        return pulumi.get(self, "desired_healthy")

    @property
    @pulumi.getter(name="disruptedPods")
    def disrupted_pods(self) -> Optional[Mapping[str, str]]:
        """
        DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn't occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.
        """
        return pulumi.get(self, "disrupted_pods")

    @property
    @pulumi.getter(name="disruptionsAllowed")
    def disruptions_allowed(self) -> Optional[int]:
        """
        Number of pod disruptions that are currently allowed.
        """
        return pulumi.get(self, "disruptions_allowed")

    @property
    @pulumi.getter(name="expectedPods")
    def expected_pods(self) -> Optional[int]:
        """
        total number of pods counted by this disruption budget
        """
        return pulumi.get(self, "expected_pods")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[int]:
        """
        Most recent generation observed when updating this PDB status. DisruptionsAllowed and other status information is valid only if observedGeneration equals to PDB's object generation.
        """
        return pulumi.get(self, "observed_generation")


