# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ... import core as _core
from ... import meta as _meta

__all__ = [
    'AllocationResult',
    'AllocationResultPatch',
    'PodScheduling',
    'PodSchedulingSpec',
    'PodSchedulingSpecPatch',
    'PodSchedulingStatus',
    'PodSchedulingStatusPatch',
    'ResourceClaim',
    'ResourceClaimConsumerReference',
    'ResourceClaimConsumerReferencePatch',
    'ResourceClaimParametersReference',
    'ResourceClaimParametersReferencePatch',
    'ResourceClaimSchedulingStatus',
    'ResourceClaimSchedulingStatusPatch',
    'ResourceClaimSpec',
    'ResourceClaimSpecPatch',
    'ResourceClaimStatus',
    'ResourceClaimStatusPatch',
    'ResourceClaimTemplate',
    'ResourceClaimTemplateSpec',
    'ResourceClaimTemplateSpecPatch',
    'ResourceClass',
    'ResourceClassParametersReference',
    'ResourceClassParametersReferencePatch',
]

@pulumi.output_type
class AllocationResult(dict):
    """
    AllocationResult contains attributed of an allocated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableOnNodes":
            suggest = "available_on_nodes"
        elif key == "resourceHandle":
            suggest = "resource_handle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_on_nodes: Optional['_core.v1.outputs.NodeSelector'] = None,
                 resource_handle: Optional[str] = None,
                 shareable: Optional[bool] = None):
        """
        AllocationResult contains attributed of an allocated resource.
        :param '_core.v1.NodeSelectorArgs' available_on_nodes: This field will get set by the resource driver after it has allocated the resource driver to inform the scheduler where it can schedule Pods using the ResourceClaim.
               
               Setting this field is optional. If null, the resource is available everywhere.
        :param str resource_handle: ResourceHandle contains arbitrary data returned by the driver after a successful allocation. This is opaque for Kubernetes. Driver documentation may explain to users how to interpret this data if needed.
               
               The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.
        :param bool shareable: Shareable determines whether the resource supports more than one consumer at a time.
        """
        if available_on_nodes is not None:
            pulumi.set(__self__, "available_on_nodes", available_on_nodes)
        if resource_handle is not None:
            pulumi.set(__self__, "resource_handle", resource_handle)
        if shareable is not None:
            pulumi.set(__self__, "shareable", shareable)

    @property
    @pulumi.getter(name="availableOnNodes")
    def available_on_nodes(self) -> Optional['_core.v1.outputs.NodeSelector']:
        """
        This field will get set by the resource driver after it has allocated the resource driver to inform the scheduler where it can schedule Pods using the ResourceClaim.

        Setting this field is optional. If null, the resource is available everywhere.
        """
        return pulumi.get(self, "available_on_nodes")

    @property
    @pulumi.getter(name="resourceHandle")
    def resource_handle(self) -> Optional[str]:
        """
        ResourceHandle contains arbitrary data returned by the driver after a successful allocation. This is opaque for Kubernetes. Driver documentation may explain to users how to interpret this data if needed.

        The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "resource_handle")

    @property
    @pulumi.getter
    def shareable(self) -> Optional[bool]:
        """
        Shareable determines whether the resource supports more than one consumer at a time.
        """
        return pulumi.get(self, "shareable")


@pulumi.output_type
class AllocationResultPatch(dict):
    """
    AllocationResult contains attributed of an allocated resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableOnNodes":
            suggest = "available_on_nodes"
        elif key == "resourceHandle":
            suggest = "resource_handle"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocationResultPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocationResultPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocationResultPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 available_on_nodes: Optional['_core.v1.outputs.NodeSelectorPatch'] = None,
                 resource_handle: Optional[str] = None,
                 shareable: Optional[bool] = None):
        """
        AllocationResult contains attributed of an allocated resource.
        :param '_core.v1.NodeSelectorPatchArgs' available_on_nodes: This field will get set by the resource driver after it has allocated the resource driver to inform the scheduler where it can schedule Pods using the ResourceClaim.
               
               Setting this field is optional. If null, the resource is available everywhere.
        :param str resource_handle: ResourceHandle contains arbitrary data returned by the driver after a successful allocation. This is opaque for Kubernetes. Driver documentation may explain to users how to interpret this data if needed.
               
               The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.
        :param bool shareable: Shareable determines whether the resource supports more than one consumer at a time.
        """
        if available_on_nodes is not None:
            pulumi.set(__self__, "available_on_nodes", available_on_nodes)
        if resource_handle is not None:
            pulumi.set(__self__, "resource_handle", resource_handle)
        if shareable is not None:
            pulumi.set(__self__, "shareable", shareable)

    @property
    @pulumi.getter(name="availableOnNodes")
    def available_on_nodes(self) -> Optional['_core.v1.outputs.NodeSelectorPatch']:
        """
        This field will get set by the resource driver after it has allocated the resource driver to inform the scheduler where it can schedule Pods using the ResourceClaim.

        Setting this field is optional. If null, the resource is available everywhere.
        """
        return pulumi.get(self, "available_on_nodes")

    @property
    @pulumi.getter(name="resourceHandle")
    def resource_handle(self) -> Optional[str]:
        """
        ResourceHandle contains arbitrary data returned by the driver after a successful allocation. This is opaque for Kubernetes. Driver documentation may explain to users how to interpret this data if needed.

        The maximum size of this field is 16KiB. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "resource_handle")

    @property
    @pulumi.getter
    def shareable(self) -> Optional[bool]:
        """
        Shareable determines whether the resource supports more than one consumer at a time.
        """
        return pulumi.get(self, "shareable")


@pulumi.output_type
class PodScheduling(dict):
    """
    PodScheduling objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodScheduling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodScheduling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodScheduling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.PodSchedulingSpec',
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 status: Optional['outputs.PodSchedulingStatus'] = None):
        """
        PodScheduling objects hold information that is needed to schedule a Pod with ResourceClaims that use "WaitForFirstConsumer" allocation mode.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param 'PodSchedulingSpecArgs' spec: Spec describes where resources for the Pod are needed.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param 'PodSchedulingStatusArgs' status: Status describes where resources for the Pod can be allocated.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'PodScheduling')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.PodSchedulingSpec':
        """
        Spec describes where resources for the Pod are needed.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.PodSchedulingStatus']:
        """
        Status describes where resources for the Pod can be allocated.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PodSchedulingSpec(dict):
    """
    PodSchedulingSpec describes where resources for the Pod are needed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "potentialNodes":
            suggest = "potential_nodes"
        elif key == "selectedNode":
            suggest = "selected_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 potential_nodes: Optional[Sequence[str]] = None,
                 selected_node: Optional[str] = None):
        """
        PodSchedulingSpec describes where resources for the Pod are needed.
        :param Sequence[str] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param str selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[Sequence[str]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[str]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")


@pulumi.output_type
class PodSchedulingSpecPatch(dict):
    """
    PodSchedulingSpec describes where resources for the Pod are needed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "potentialNodes":
            suggest = "potential_nodes"
        elif key == "selectedNode":
            suggest = "selected_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 potential_nodes: Optional[Sequence[str]] = None,
                 selected_node: Optional[str] = None):
        """
        PodSchedulingSpec describes where resources for the Pod are needed.
        :param Sequence[str] potential_nodes: PotentialNodes lists nodes where the Pod might be able to run.
               
               The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        :param str selected_node: SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        if potential_nodes is not None:
            pulumi.set(__self__, "potential_nodes", potential_nodes)
        if selected_node is not None:
            pulumi.set(__self__, "selected_node", selected_node)

    @property
    @pulumi.getter(name="potentialNodes")
    def potential_nodes(self) -> Optional[Sequence[str]]:
        """
        PotentialNodes lists nodes where the Pod might be able to run.

        The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "potential_nodes")

    @property
    @pulumi.getter(name="selectedNode")
    def selected_node(self) -> Optional[str]:
        """
        SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use "WaitForFirstConsumer" allocation is to be attempted.
        """
        return pulumi.get(self, "selected_node")


@pulumi.output_type
class PodSchedulingStatus(dict):
    """
    PodSchedulingStatus describes where resources for the Pod can be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClaims":
            suggest = "resource_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_claims: Optional[Sequence['outputs.ResourceClaimSchedulingStatus']] = None):
        """
        PodSchedulingStatus describes where resources for the Pod can be allocated.
        :param Sequence['ResourceClaimSchedulingStatusArgs'] resource_claims: ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        if resource_claims is not None:
            pulumi.set(__self__, "resource_claims", resource_claims)

    @property
    @pulumi.getter(name="resourceClaims")
    def resource_claims(self) -> Optional[Sequence['outputs.ResourceClaimSchedulingStatus']]:
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        return pulumi.get(self, "resource_claims")


@pulumi.output_type
class PodSchedulingStatusPatch(dict):
    """
    PodSchedulingStatus describes where resources for the Pod can be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClaims":
            suggest = "resource_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSchedulingStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSchedulingStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSchedulingStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_claims: Optional[Sequence['outputs.ResourceClaimSchedulingStatusPatch']] = None):
        """
        PodSchedulingStatus describes where resources for the Pod can be allocated.
        :param Sequence['ResourceClaimSchedulingStatusPatchArgs'] resource_claims: ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        if resource_claims is not None:
            pulumi.set(__self__, "resource_claims", resource_claims)

    @property
    @pulumi.getter(name="resourceClaims")
    def resource_claims(self) -> Optional[Sequence['outputs.ResourceClaimSchedulingStatusPatch']]:
        """
        ResourceClaims describes resource availability for each pod.spec.resourceClaim entry where the corresponding ResourceClaim uses "WaitForFirstConsumer" allocation mode.
        """
        return pulumi.get(self, "resource_claims")


@pulumi.output_type
class ResourceClaim(dict):
    """
    ResourceClaim describes which resources are needed by a resource consumer. Its status tracks whether the resource has been allocated and what the resulting attributes are.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaim. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaim.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaim.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimSpec',
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 status: Optional['outputs.ResourceClaimStatus'] = None):
        """
        ResourceClaim describes which resources are needed by a resource consumer. Its status tracks whether the resource has been allocated and what the resulting attributes are.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param 'ResourceClaimSpecArgs' spec: Spec describes the desired attributes of a resource that then needs to be allocated. It can only be set once when creating the ResourceClaim.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param 'ResourceClaimStatusArgs' status: Status describes whether the resource is available and with which attributes.
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaim')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimSpec':
        """
        Spec describes the desired attributes of a resource that then needs to be allocated. It can only be set once when creating the ResourceClaim.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def status(self) -> Optional['outputs.ResourceClaimStatus']:
        """
        Status describes whether the resource is available and with which attributes.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ResourceClaimConsumerReference(dict):
    """
    ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimConsumerReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimConsumerReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimConsumerReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 resource: str,
                 uid: str,
                 api_group: Optional[str] = None):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        :param str name: Name is the name of resource being referenced.
        :param str resource: Resource is the type of resource being referenced, for example "pods".
        :param str uid: UID identifies exactly one incarnation of the resource.
        :param str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "uid", uid)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        UID identifies exactly one incarnation of the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")


@pulumi.output_type
class ResourceClaimConsumerReferencePatch(dict):
    """
    ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimConsumerReferencePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimConsumerReferencePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimConsumerReferencePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_group: Optional[str] = None,
                 name: Optional[str] = None,
                 resource: Optional[str] = None,
                 uid: Optional[str] = None):
        """
        ResourceClaimConsumerReference contains enough information to let you locate the consumer of a ResourceClaim. The user must be a resource in the same namespace as the ResourceClaim.
        :param str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param str name: Name is the name of resource being referenced.
        :param str resource: Resource is the type of resource being referenced, for example "pods".
        :param str uid: UID identifies exactly one incarnation of the resource.
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resource(self) -> Optional[str]:
        """
        Resource is the type of resource being referenced, for example "pods".
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def uid(self) -> Optional[str]:
        """
        UID identifies exactly one incarnation of the resource.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ResourceClaimParametersReference(dict):
    """
    ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimParametersReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimParametersReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimParametersReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 name: str,
                 api_group: Optional[str] = None):
        """
        ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
        :param str kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        :param str name: Name is the name of resource being referenced.
        :param str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")


@pulumi.output_type
class ResourceClaimParametersReferencePatch(dict):
    """
    ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimParametersReferencePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimParametersReferencePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimParametersReferencePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_group: Optional[str] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None):
        """
        ResourceClaimParametersReference contains enough information to let you locate the parameters for a ResourceClaim. The object must be in the same namespace as the ResourceClaim.
        :param str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param str kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        :param str name: Name is the name of resource being referenced.
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata, for example "ConfigMap".
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ResourceClaimSchedulingStatus(dict):
    """
    ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unsuitableNodes":
            suggest = "unsuitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSchedulingStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSchedulingStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSchedulingStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 unsuitable_nodes: Optional[Sequence[str]] = None):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        :param str name: Name matches the pod.spec.resourceClaims[*].Name field.
        :param Sequence[str] unsuitable_nodes: UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.
               
               The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unsuitable_nodes is not None:
            pulumi.set(__self__, "unsuitable_nodes", unsuitable_nodes)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="unsuitableNodes")
    def unsuitable_nodes(self) -> Optional[Sequence[str]]:
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "unsuitable_nodes")


@pulumi.output_type
class ResourceClaimSchedulingStatusPatch(dict):
    """
    ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unsuitableNodes":
            suggest = "unsuitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSchedulingStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSchedulingStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSchedulingStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 unsuitable_nodes: Optional[Sequence[str]] = None):
        """
        ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with "WaitForFirstConsumer" allocation mode.
        :param str name: Name matches the pod.spec.resourceClaims[*].Name field.
        :param Sequence[str] unsuitable_nodes: UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.
               
               The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unsuitable_nodes is not None:
            pulumi.set(__self__, "unsuitable_nodes", unsuitable_nodes)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name matches the pod.spec.resourceClaims[*].Name field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="unsuitableNodes")
    def unsuitable_nodes(self) -> Optional[Sequence[str]]:
        """
        UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.

        The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "unsuitable_nodes")


@pulumi.output_type
class ResourceClaimSpec(dict):
    """
    ResourceClaimSpec defines how a resource is to be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceClassName":
            suggest = "resource_class_name"
        elif key == "allocationMode":
            suggest = "allocation_mode"
        elif key == "parametersRef":
            suggest = "parameters_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_class_name: str,
                 allocation_mode: Optional[str] = None,
                 parameters_ref: Optional['outputs.ResourceClaimParametersReference'] = None):
        """
        ResourceClaimSpec defines how a resource is to be allocated.
        :param str resource_class_name: ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        :param str allocation_mode: Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        :param 'ResourceClaimParametersReferenceArgs' parameters_ref: ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.
               
               The object must be in the same namespace as the ResourceClaim.
        """
        pulumi.set(__self__, "resource_class_name", resource_class_name)
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if parameters_ref is not None:
            pulumi.set(__self__, "parameters_ref", parameters_ref)

    @property
    @pulumi.getter(name="resourceClassName")
    def resource_class_name(self) -> str:
        """
        ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        """
        return pulumi.get(self, "resource_class_name")

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[str]:
        """
        Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        """
        return pulumi.get(self, "allocation_mode")

    @property
    @pulumi.getter(name="parametersRef")
    def parameters_ref(self) -> Optional['outputs.ResourceClaimParametersReference']:
        """
        ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.

        The object must be in the same namespace as the ResourceClaim.
        """
        return pulumi.get(self, "parameters_ref")


@pulumi.output_type
class ResourceClaimSpecPatch(dict):
    """
    ResourceClaimSpec defines how a resource is to be allocated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationMode":
            suggest = "allocation_mode"
        elif key == "parametersRef":
            suggest = "parameters_ref"
        elif key == "resourceClassName":
            suggest = "resource_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimSpecPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimSpecPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimSpecPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_mode: Optional[str] = None,
                 parameters_ref: Optional['outputs.ResourceClaimParametersReferencePatch'] = None,
                 resource_class_name: Optional[str] = None):
        """
        ResourceClaimSpec defines how a resource is to be allocated.
        :param str allocation_mode: Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        :param 'ResourceClaimParametersReferencePatchArgs' parameters_ref: ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.
               
               The object must be in the same namespace as the ResourceClaim.
        :param str resource_class_name: ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        """
        if allocation_mode is not None:
            pulumi.set(__self__, "allocation_mode", allocation_mode)
        if parameters_ref is not None:
            pulumi.set(__self__, "parameters_ref", parameters_ref)
        if resource_class_name is not None:
            pulumi.set(__self__, "resource_class_name", resource_class_name)

    @property
    @pulumi.getter(name="allocationMode")
    def allocation_mode(self) -> Optional[str]:
        """
        Allocation can start immediately or when a Pod wants to use the resource. "WaitForFirstConsumer" is the default.
        """
        return pulumi.get(self, "allocation_mode")

    @property
    @pulumi.getter(name="parametersRef")
    def parameters_ref(self) -> Optional['outputs.ResourceClaimParametersReferencePatch']:
        """
        ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.

        The object must be in the same namespace as the ResourceClaim.
        """
        return pulumi.get(self, "parameters_ref")

    @property
    @pulumi.getter(name="resourceClassName")
    def resource_class_name(self) -> Optional[str]:
        """
        ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
        """
        return pulumi.get(self, "resource_class_name")


@pulumi.output_type
class ResourceClaimStatus(dict):
    """
    ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deallocationRequested":
            suggest = "deallocation_requested"
        elif key == "driverName":
            suggest = "driver_name"
        elif key == "reservedFor":
            suggest = "reserved_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation: Optional['outputs.AllocationResult'] = None,
                 deallocation_requested: Optional[bool] = None,
                 driver_name: Optional[str] = None,
                 reserved_for: Optional[Sequence['outputs.ResourceClaimConsumerReference']] = None):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are.
        :param 'AllocationResultArgs' allocation: Allocation is set by the resource driver once a resource has been allocated successfully. If this is not specified, the resource is not yet allocated.
        :param bool deallocation_requested: DeallocationRequested indicates that a ResourceClaim is to be deallocated.
               
               The driver then must deallocate this claim and reset the field together with clearing the Allocation field.
               
               While DeallocationRequested is set, no new consumers may be added to ReservedFor.
        :param str driver_name: DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.
        :param Sequence['ResourceClaimConsumerReferenceArgs'] reserved_for: ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.
               
               There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        if allocation is not None:
            pulumi.set(__self__, "allocation", allocation)
        if deallocation_requested is not None:
            pulumi.set(__self__, "deallocation_requested", deallocation_requested)
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if reserved_for is not None:
            pulumi.set(__self__, "reserved_for", reserved_for)

    @property
    @pulumi.getter
    def allocation(self) -> Optional['outputs.AllocationResult']:
        """
        Allocation is set by the resource driver once a resource has been allocated successfully. If this is not specified, the resource is not yet allocated.
        """
        return pulumi.get(self, "allocation")

    @property
    @pulumi.getter(name="deallocationRequested")
    def deallocation_requested(self) -> Optional[bool]:
        """
        DeallocationRequested indicates that a ResourceClaim is to be deallocated.

        The driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        While DeallocationRequested is set, no new consumers may be added to ReservedFor.
        """
        return pulumi.get(self, "deallocation_requested")

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[str]:
        """
        DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="reservedFor")
    def reserved_for(self) -> Optional[Sequence['outputs.ResourceClaimConsumerReference']]:
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.

        There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "reserved_for")


@pulumi.output_type
class ResourceClaimStatusPatch(dict):
    """
    ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deallocationRequested":
            suggest = "deallocation_requested"
        elif key == "driverName":
            suggest = "driver_name"
        elif key == "reservedFor":
            suggest = "reserved_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimStatusPatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimStatusPatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimStatusPatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation: Optional['outputs.AllocationResultPatch'] = None,
                 deallocation_requested: Optional[bool] = None,
                 driver_name: Optional[str] = None,
                 reserved_for: Optional[Sequence['outputs.ResourceClaimConsumerReferencePatch']] = None):
        """
        ResourceClaimStatus tracks whether the resource has been allocated and what the resulting attributes are.
        :param 'AllocationResultPatchArgs' allocation: Allocation is set by the resource driver once a resource has been allocated successfully. If this is not specified, the resource is not yet allocated.
        :param bool deallocation_requested: DeallocationRequested indicates that a ResourceClaim is to be deallocated.
               
               The driver then must deallocate this claim and reset the field together with clearing the Allocation field.
               
               While DeallocationRequested is set, no new consumers may be added to ReservedFor.
        :param str driver_name: DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.
        :param Sequence['ResourceClaimConsumerReferencePatchArgs'] reserved_for: ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.
               
               There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        if allocation is not None:
            pulumi.set(__self__, "allocation", allocation)
        if deallocation_requested is not None:
            pulumi.set(__self__, "deallocation_requested", deallocation_requested)
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if reserved_for is not None:
            pulumi.set(__self__, "reserved_for", reserved_for)

    @property
    @pulumi.getter
    def allocation(self) -> Optional['outputs.AllocationResultPatch']:
        """
        Allocation is set by the resource driver once a resource has been allocated successfully. If this is not specified, the resource is not yet allocated.
        """
        return pulumi.get(self, "allocation")

    @property
    @pulumi.getter(name="deallocationRequested")
    def deallocation_requested(self) -> Optional[bool]:
        """
        DeallocationRequested indicates that a ResourceClaim is to be deallocated.

        The driver then must deallocate this claim and reset the field together with clearing the Allocation field.

        While DeallocationRequested is set, no new consumers may be added to ReservedFor.
        """
        return pulumi.get(self, "deallocation_requested")

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[str]:
        """
        DriverName is a copy of the driver name from the ResourceClass at the time when allocation started.
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="reservedFor")
    def reserved_for(self) -> Optional[Sequence['outputs.ResourceClaimConsumerReferencePatch']]:
        """
        ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started.

        There can be at most 32 such reservations. This may get increased in the future, but not reduced.
        """
        return pulumi.get(self, "reserved_for")


@pulumi.output_type
class ResourceClaimTemplate(dict):
    """
    ResourceClaimTemplate is used to produce ResourceClaim objects.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClaimTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClaimTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClaimTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimTemplateSpec',
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ResourceClaimTemplate is used to produce ResourceClaim objects.
        :param 'ResourceClaimTemplateSpecArgs' spec: Describes the ResourceClaim that is to be generated.
               
               This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        """
        pulumi.set(__self__, "spec", spec)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClaimTemplate')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimTemplateSpec':
        """
        Describes the ResourceClaim that is to be generated.

        This field is immutable. A ResourceClaim will get created by the control plane for a Pod when needed and then not get updated anymore.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ResourceClaimTemplateSpec(dict):
    """
    ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
    """
    def __init__(__self__, *,
                 spec: 'outputs.ResourceClaimSpec',
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param 'ResourceClaimSpecArgs' spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        :param '_meta.v1.ObjectMetaArgs' metadata: ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        pulumi.set(__self__, "spec", spec)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.ResourceClaimSpec':
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class ResourceClaimTemplateSpecPatch(dict):
    """
    ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
    """
    def __init__(__self__, *,
                 metadata: Optional['_meta.v1.outputs.ObjectMetaPatch'] = None,
                 spec: Optional['outputs.ResourceClaimSpecPatch'] = None):
        """
        ResourceClaimTemplateSpec contains the metadata and fields for a ResourceClaim.
        :param '_meta.v1.ObjectMetaPatchArgs' metadata: ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        :param 'ResourceClaimSpecPatchArgs' spec: Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMetaPatch']:
        """
        ObjectMeta may contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.ResourceClaimSpecPatch']:
        """
        Spec for the ResourceClaim. The entire content is copied unchanged into the ResourceClaim that gets created from this template. The same fields as in a ResourceClaim are also valid here.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class ResourceClass(dict):
    """
    ResourceClass is used by administrators to influence how resources are allocated.

    This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "apiVersion":
            suggest = "api_version"
        elif key == "parametersRef":
            suggest = "parameters_ref"
        elif key == "suitableNodes":
            suggest = "suitable_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClass. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClass.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClass.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: str,
                 api_version: Optional[str] = None,
                 kind: Optional[str] = None,
                 metadata: Optional['_meta.v1.outputs.ObjectMeta'] = None,
                 parameters_ref: Optional['outputs.ResourceClassParametersReference'] = None,
                 suitable_nodes: Optional['_core.v1.outputs.NodeSelector'] = None):
        """
        ResourceClass is used by administrators to influence how resources are allocated.

        This is an alpha type and requires enabling the DynamicResourceAllocation feature gate.
        :param str driver_name: DriverName defines the name of the dynamic resource driver that is used for allocation of a ResourceClaim that uses this class.
               
               Resource drivers have a unique name in forward domain order (acme.example.com).
        :param str api_version: APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        :param str kind: Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param '_meta.v1.ObjectMetaArgs' metadata: Standard object metadata
        :param 'ResourceClassParametersReferenceArgs' parameters_ref: ParametersRef references an arbitrary separate object that may hold parameters that will be used by the driver when allocating a resource that uses this class. A dynamic resource driver can distinguish between parameters stored here and and those stored in ResourceClaimSpec.
        :param '_core.v1.NodeSelectorArgs' suitable_nodes: Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a ResourceClaim that has not been allocated yet.
               
               Setting this field is optional. If null, all nodes are candidates.
        """
        pulumi.set(__self__, "driver_name", driver_name)
        if api_version is not None:
            pulumi.set(__self__, "api_version", 'resource.k8s.io/v1alpha1')
        if kind is not None:
            pulumi.set(__self__, "kind", 'ResourceClass')
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if parameters_ref is not None:
            pulumi.set(__self__, "parameters_ref", parameters_ref)
        if suitable_nodes is not None:
            pulumi.set(__self__, "suitable_nodes", suitable_nodes)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> str:
        """
        DriverName defines the name of the dynamic resource driver that is used for allocation of a ResourceClaim that uses this class.

        Resource drivers have a unique name in forward domain order (acme.example.com).
        """
        return pulumi.get(self, "driver_name")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['_meta.v1.outputs.ObjectMeta']:
        """
        Standard object metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="parametersRef")
    def parameters_ref(self) -> Optional['outputs.ResourceClassParametersReference']:
        """
        ParametersRef references an arbitrary separate object that may hold parameters that will be used by the driver when allocating a resource that uses this class. A dynamic resource driver can distinguish between parameters stored here and and those stored in ResourceClaimSpec.
        """
        return pulumi.get(self, "parameters_ref")

    @property
    @pulumi.getter(name="suitableNodes")
    def suitable_nodes(self) -> Optional['_core.v1.outputs.NodeSelector']:
        """
        Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a ResourceClaim that has not been allocated yet.

        Setting this field is optional. If null, all nodes are candidates.
        """
        return pulumi.get(self, "suitable_nodes")


@pulumi.output_type
class ResourceClassParametersReference(dict):
    """
    ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClassParametersReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClassParametersReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClassParametersReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kind: str,
                 name: str,
                 api_group: Optional[str] = None,
                 namespace: Optional[str] = None):
        """
        ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
        :param str kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        :param str name: Name is the name of resource being referenced.
        :param str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param str namespace: Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ResourceClassParametersReferencePatch(dict):
    """
    ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiGroup":
            suggest = "api_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceClassParametersReferencePatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceClassParametersReferencePatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceClassParametersReferencePatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_group: Optional[str] = None,
                 kind: Optional[str] = None,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None):
        """
        ResourceClassParametersReference contains enough information to let you locate the parameters for a ResourceClass.
        :param str api_group: APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        :param str kind: Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        :param str name: Name is the name of resource being referenced.
        :param str namespace: Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        if api_group is not None:
            pulumi.set(__self__, "api_group", api_group)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="apiGroup")
    def api_group(self) -> Optional[str]:
        """
        APIGroup is the group for the resource being referenced. It is empty for the core API. This matches the group in the APIVersion that is used when creating the resources.
        """
        return pulumi.get(self, "api_group")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind is the type of resource being referenced. This is the same value as in the parameter object's metadata.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name is the name of resource being referenced.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Namespace that contains the referenced resource. Must be empty for cluster-scoped resources and non-empty for namespaced resources.
        """
        return pulumi.get(self, "namespace")


