# generated by datamodel-codegen:
#   filename:  https://raw.githubusercontent.com/openai/openai-openapi/master/openapi.yaml
#   timestamp: 2025-06-05T16:10:02+00:00

from __future__ import annotations  # noqa: D401,F401

import warnings
from typing import Annotated, Any, Dict, List, Literal

from pydantic import AnyUrl, BaseModel, ConfigDict, Field, RootModel

# Filter out Pydantic alias warnings
warnings.filterwarnings(
    "ignore",
    message=".*`alias` specification on field.*must be set on outermost annotation.*",
    category=UserWarning,
    module="pydantic._internal._fields",
)

# Type aliases for special field names
bytes_aliased = Annotated[bytes, Field(alias="bytes")]
float_aliased = Annotated[float, Field(alias="float")]


class AddUploadPartRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    data: bytes_aliased
    """
    The chunk of bytes for this Part.

    """


class Owner(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: str | None = Field(None, examples=["user"])
    """
    Always `user`
    """
    object: str | None = Field(None, examples=["organization.user"])
    """
    The object type, which is always organization.user
    """
    id: str | None = Field(None, examples=["sa_456"])
    """
    The identifier, which can be referenced in API endpoints
    """
    name: str | None = Field(None, examples=["My Service Account"])
    """
    The name of the user
    """
    created_at: int | None = Field(None, examples=[1711471533])
    """
    The Unix timestamp (in seconds) of when the user was created
    """
    role: str | None = Field(None, examples=["owner"])
    """
    Always `owner`
    """


class AdminApiKey(BaseModel):
    """
    Represents an individual Admin API key in an org.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: str = Field(..., examples=["organization.admin_api_key"])
    """
    The object type, which is always `organization.admin_api_key`
    """
    id: str = Field(..., examples=["key_abc"])
    """
    The identifier, which can be referenced in API endpoints
    """
    name: str = Field(..., examples=["Administration Key"])
    """
    The name of the API key
    """
    redacted_value: str = Field(..., examples=["sk-admin...def"])
    """
    The redacted value of the API key
    """
    value: str | None = Field(None, examples=["sk-admin-1234abcd"])
    """
    The value of the API key. Only shown on create.
    """
    created_at: int = Field(..., examples=[1711471533])
    """
    The Unix timestamp (in seconds) of when the API key was created
    """
    last_used_at: int = Field(..., examples=[1711471534])
    """
    The Unix timestamp (in seconds) of when the API key was last used
    """
    owner: Owner


class ApiKeyList(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: str | None = Field(None, examples=["list"])
    data: list[AdminApiKey] | None = None
    has_more: bool | None = Field(None, examples=[False])
    first_id: str | None = Field(None, examples=["key_abc"])
    last_id: str | None = Field(None, examples=["key_xyz"])


class CodeInterpreter(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_ids: list[str] | None = Field([], max_length=20)
    """
    A list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter`` tool. There can be a maximum of 20 files associated with the tool.

    """


class FileSearch(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    vector_store_ids: list[str] | None = Field(None, max_length=1)
    """
    The ID of the [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.

    """


class ToolResources(BaseModel):
    """
    A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code_interpreter: CodeInterpreter | None = None
    file_search: FileSearch | None = None


class AssistantSupportedModels(
    RootModel[
        Literal[
            "gpt-4.1",
            "gpt-4.1-mini",
            "gpt-4.1-nano",
            "gpt-4.1-2025-04-14",
            "gpt-4.1-mini-2025-04-14",
            "gpt-4.1-nano-2025-04-14",
            "o3-mini",
            "o3-mini-2025-01-31",
            "o1",
            "o1-2024-12-17",
            "gpt-4o",
            "gpt-4o-2024-11-20",
            "gpt-4o-2024-08-06",
            "gpt-4o-2024-05-13",
            "gpt-4o-mini",
            "gpt-4o-mini-2024-07-18",
            "gpt-4.5-preview",
            "gpt-4.5-preview-2025-02-27",
            "gpt-4-turbo",
            "gpt-4-turbo-2024-04-09",
            "gpt-4-0125-preview",
            "gpt-4-turbo-preview",
            "gpt-4-1106-preview",
            "gpt-4-vision-preview",
            "gpt-4",
            "gpt-4-0314",
            "gpt-4-0613",
            "gpt-4-32k",
            "gpt-4-32k-0314",
            "gpt-4-32k-0613",
            "gpt-3.5-turbo",
            "gpt-3.5-turbo-16k",
            "gpt-3.5-turbo-0613",
            "gpt-3.5-turbo-1106",
            "gpt-3.5-turbo-0125",
            "gpt-3.5-turbo-16k-0613",
        ]
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal[
        "gpt-4.1",
        "gpt-4.1-mini",
        "gpt-4.1-nano",
        "gpt-4.1-2025-04-14",
        "gpt-4.1-mini-2025-04-14",
        "gpt-4.1-nano-2025-04-14",
        "o3-mini",
        "o3-mini-2025-01-31",
        "o1",
        "o1-2024-12-17",
        "gpt-4o",
        "gpt-4o-2024-11-20",
        "gpt-4o-2024-08-06",
        "gpt-4o-2024-05-13",
        "gpt-4o-mini",
        "gpt-4o-mini-2024-07-18",
        "gpt-4.5-preview",
        "gpt-4.5-preview-2025-02-27",
        "gpt-4-turbo",
        "gpt-4-turbo-2024-04-09",
        "gpt-4-0125-preview",
        "gpt-4-turbo-preview",
        "gpt-4-1106-preview",
        "gpt-4-vision-preview",
        "gpt-4",
        "gpt-4-0314",
        "gpt-4-0613",
        "gpt-4-32k",
        "gpt-4-32k-0314",
        "gpt-4-32k-0613",
        "gpt-3.5-turbo",
        "gpt-3.5-turbo-16k",
        "gpt-3.5-turbo-0613",
        "gpt-3.5-turbo-1106",
        "gpt-3.5-turbo-0125",
        "gpt-3.5-turbo-16k-0613",
    ]


class AssistantToolsCode(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["code_interpreter"] = "code_interpreter"
    """
    The type of tool being defined: `code_interpreter`
    """


class AssistantToolsFileSearchTypeOnly(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["file_search"] = "file_search"
    """
    The type of tool being defined: `file_search`
    """


class Function(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    """
    The name of the function to call.
    """


class AssistantsNamedToolChoice(BaseModel):
    """
    Specifies a tool the model should use. Use to force the model to call a specific tool.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["function", "code_interpreter", "file_search"]
    """
    The type of the tool. If type is `function`, the function name must be set
    """
    function: Function | None = None


class AudioResponseFormat(
    RootModel[Literal["json", "text", "srt", "verbose_json", "vtt"]]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal["json", "text", "srt", "verbose_json", "vtt"]
    """
    The format of the output, in one of these options: `json`, `text`, `srt`, `verbose_json`, or `vtt`. For `gpt-4o-transcribe` and `gpt-4o-mini-transcribe`, the only supported format is `json`.

    """


class Project(BaseModel):
    """
    The project that the action was scoped to. Absent for actions not scoped to projects.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The project ID.
    """
    name: str | None = None
    """
    The project title.
    """


class Data(BaseModel):
    """
    The payload used to create the API key.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    scopes: list[str] | None = None
    """
    A list of scopes allowed for the API key, e.g. `["api.model.request"]`
    """


class ApiKeyCreated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The tracking ID of the API key.
    """
    data: Data | None = None
    """
    The payload used to create the API key.
    """


class ChangesRequested(BaseModel):
    """
    The payload used to update the API key.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    scopes: list[str] | None = None
    """
    A list of scopes allowed for the API key, e.g. `["api.model.request"]`
    """


class ApiKeyUpdated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The tracking ID of the API key.
    """
    changes_requested: ChangesRequested | None = None
    """
    The payload used to update the API key.
    """


class ApiKeyDeleted(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The tracking ID of the API key.
    """


class Data1(BaseModel):
    """
    The payload used to create the checkpoint permission.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    project_id: str | None = None
    """
    The ID of the project that the checkpoint permission was created for.
    """
    fine_tuned_model_checkpoint: str | None = None
    """
    The ID of the fine-tuned model checkpoint.
    """


class CheckpointPermissionCreated(BaseModel):
    """
    The project and fine-tuned model checkpoint that the checkpoint permission was created for.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The ID of the checkpoint permission.
    """
    data: Data1 | None = None
    """
    The payload used to create the checkpoint permission.
    """


class CheckpointPermissionDeleted(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The ID of the checkpoint permission.
    """


class Data2(BaseModel):
    """
    The payload used to create the invite.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    email: str | None = None
    """
    The email invited to the organization.
    """
    role: str | None = None
    """
    The role the email was invited to be. Is either `owner` or `member`.
    """


class InviteSent(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The ID of the invite.
    """
    data: Data2 | None = None
    """
    The payload used to create the invite.
    """


class InviteAccepted(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The ID of the invite.
    """


class InviteDeleted(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The ID of the invite.
    """


class LoginFailed(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    error_code: str | None = None
    """
    The error code of the failure.
    """
    error_message: str | None = None
    """
    The error message of the failure.
    """


class LogoutFailed(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    error_code: str | None = None
    """
    The error code of the failure.
    """
    error_message: str | None = None
    """
    The error message of the failure.
    """


class Settings(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    threads_ui_visibility: str | None = None
    """
    Visibility of the threads page which shows messages created with the Assistants API and Playground. One of `ANY_ROLE`, `OWNERS`, or `NONE`.
    """
    usage_dashboard_visibility: str | None = None
    """
    Visibility of the usage dashboard which shows activity and costs for your organization. One of `ANY_ROLE` or `OWNERS`.
    """


class ChangesRequested1(BaseModel):
    """
    The payload used to update the organization settings.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    title: str | None = None
    """
    The organization title.
    """
    description: str | None = None
    """
    The organization description.
    """
    name: str | None = None
    """
    The organization name.
    """
    settings: Settings | None = None


class OrganizationUpdated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The organization ID.
    """
    changes_requested: ChangesRequested1 | None = None
    """
    The payload used to update the organization settings.
    """


class Data3(BaseModel):
    """
    The payload used to create the project.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str | None = None
    """
    The project name.
    """
    title: str | None = None
    """
    The title of the project as seen on the dashboard.
    """


class ProjectCreated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The project ID.
    """
    data: Data3 | None = None
    """
    The payload used to create the project.
    """


class ChangesRequested2(BaseModel):
    """
    The payload used to update the project.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    title: str | None = None
    """
    The title of the project as seen on the dashboard.
    """


class ProjectUpdated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The project ID.
    """
    changes_requested: ChangesRequested2 | None = None
    """
    The payload used to update the project.
    """


class ProjectArchived(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The project ID.
    """


class ChangesRequested3(BaseModel):
    """
    The payload used to update the rate limits.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    max_requests_per_1_minute: int | None = None
    """
    The maximum requests per minute.
    """
    max_tokens_per_1_minute: int | None = None
    """
    The maximum tokens per minute.
    """
    max_images_per_1_minute: int | None = None
    """
    The maximum images per minute. Only relevant for certain models.
    """
    max_audio_megabytes_per_1_minute: int | None = None
    """
    The maximum audio megabytes per minute. Only relevant for certain models.
    """
    max_requests_per_1_day: int | None = None
    """
    The maximum requests per day. Only relevant for certain models.
    """
    batch_1_day_max_input_tokens: int | None = None
    """
    The maximum batch input tokens per day. Only relevant for certain models.
    """


class RateLimitUpdated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The rate limit ID
    """
    changes_requested: ChangesRequested3 | None = None
    """
    The payload used to update the rate limits.
    """


class RateLimitDeleted(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The rate limit ID
    """


class Data4(BaseModel):
    """
    The payload used to create the service account.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: str | None = None
    """
    The role of the service account. Is either `owner` or `member`.
    """


class ServiceAccountCreated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The service account ID.
    """
    data: Data4 | None = None
    """
    The payload used to create the service account.
    """


class ChangesRequested4(BaseModel):
    """
    The payload used to updated the service account.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: str | None = None
    """
    The role of the service account. Is either `owner` or `member`.
    """


class ServiceAccountUpdated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The service account ID.
    """
    changes_requested: ChangesRequested4 | None = None
    """
    The payload used to updated the service account.
    """


class ServiceAccountDeleted(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The service account ID.
    """


class Data5(BaseModel):
    """
    The payload used to add the user to the project.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: str | None = None
    """
    The role of the user. Is either `owner` or `member`.
    """


class UserAdded(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The user ID.
    """
    data: Data5 | None = None
    """
    The payload used to add the user to the project.
    """


class ChangesRequested5(BaseModel):
    """
    The payload used to update the user.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: str | None = None
    """
    The role of the user. Is either `owner` or `member`.
    """


class UserUpdated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The project ID.
    """
    changes_requested: ChangesRequested5 | None = None
    """
    The payload used to update the user.
    """


class UserDeleted(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The user ID.
    """


class CertificateCreated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The certificate ID.
    """
    name: str | None = None
    """
    The name of the certificate.
    """


class CertificateUpdated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The certificate ID.
    """
    name: str | None = None
    """
    The name of the certificate.
    """


class CertificateDeleted(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The certificate ID.
    """
    name: str | None = None
    """
    The name of the certificate.
    """
    certificate: str | None = None
    """
    The certificate content in PEM format.
    """


class Certificate(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The certificate ID.
    """
    name: str | None = None
    """
    The name of the certificate.
    """


class CertificatesActivated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    certificates: list[Certificate] | None = None


class CertificatesDeactivated(BaseModel):
    """
    The details for events with this `type`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    certificates: list[Certificate] | None = None


class AuditLogActorServiceAccount(BaseModel):
    """
    The service account that performed the audit logged action.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The service account id.
    """


class AuditLogActorUser(BaseModel):
    """
    The user who performed the audit logged action.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The user id.
    """
    email: str | None = None
    """
    The user email.
    """


class AuditLogEventType(
    RootModel[
        Literal[
            "api_key.created",
            "api_key.updated",
            "api_key.deleted",
            "checkpoint_permission.created",
            "checkpoint_permission.deleted",
            "invite.sent",
            "invite.accepted",
            "invite.deleted",
            "login.succeeded",
            "login.failed",
            "logout.succeeded",
            "logout.failed",
            "organization.updated",
            "project.created",
            "project.updated",
            "project.archived",
            "service_account.created",
            "service_account.updated",
            "service_account.deleted",
            "rate_limit.updated",
            "rate_limit.deleted",
            "user.added",
            "user.updated",
            "user.deleted",
        ]
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal[
        "api_key.created",
        "api_key.updated",
        "api_key.deleted",
        "checkpoint_permission.created",
        "checkpoint_permission.deleted",
        "invite.sent",
        "invite.accepted",
        "invite.deleted",
        "login.succeeded",
        "login.failed",
        "logout.succeeded",
        "logout.failed",
        "organization.updated",
        "project.created",
        "project.updated",
        "project.archived",
        "service_account.created",
        "service_account.updated",
        "service_account.deleted",
        "rate_limit.updated",
        "rate_limit.deleted",
        "user.added",
        "user.updated",
        "user.deleted",
    ]
    """
    The event type.
    """


class AutoChunkingStrategyRequestParam(BaseModel):
    """
    The default strategy. This strategy currently uses a `max_chunk_size_tokens` of `800` and `chunk_overlap_tokens` of `400`.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["auto"] = "auto"
    """
    Always `auto`.
    """


class Datum(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    code: str | None = None
    """
    An error code identifying the error type.
    """
    message: str | None = None
    """
    A human-readable message providing more details about the error.
    """
    param: str | None = None
    """
    The name of the parameter that caused the error, if applicable.
    """
    line: int | None = None
    """
    The line number of the input file where the error occurred, if applicable.
    """


class Errors(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: str | None = None
    """
    The object type, which is always `list`.
    """
    data: list[Datum] | None = None


class RequestCounts(BaseModel):
    """
    The request counts for different statuses within the batch.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    total: int
    """
    Total number of requests in the batch.
    """
    completed: int
    """
    Number of requests that have been completed successfully.
    """
    failed: int
    """
    Number of requests that have failed.
    """


class BatchRequestInput(BaseModel):
    """
    The per-line object of the batch input file
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    custom_id: str | None = None
    """
    A developer-provided per-request id that will be used to match outputs to inputs. Must be unique for each request in a batch.
    """
    method: Literal["POST"] | None = None
    """
    The HTTP method to be used for the request. Currently only `POST` is supported.
    """
    url: str | None = None
    """
    The OpenAI API relative URL to be used for the request. Currently `/v1/chat/completions`, `/v1/embeddings`, and `/v1/completions` are supported.
    """


class Response(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    status_code: int | None = None
    """
    The HTTP status code of the response
    """
    request_id: str | None = None
    """
    An unique identifier for the OpenAI API request. Please include this request ID when contacting support.
    """
    body: dict[str, Any] | None = None
    """
    The JSON body of the response
    """


class Error(BaseModel):
    """
    For requests that failed with a non-HTTP error, this will contain more information on the cause of the failure.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code: str | None = None
    """
    A machine-readable error code.
    """
    message: str | None = None
    """
    A human-readable error message.
    """


class BatchRequestOutput(BaseModel):
    """
    The per-line object of the batch output and error files
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    custom_id: str | None = None
    """
    A developer-provided per-request id that will be used to match outputs to inputs.
    """
    response: Response | None = None
    error: Error | None = None
    """
    For requests that failed with a non-HTTP error, this will contain more information on the cause of the failure.
    """


class CertificateDetails(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    valid_at: int | None = None
    """
    The Unix timestamp (in seconds) of when the certificate becomes valid.
    """
    expires_at: int | None = None
    """
    The Unix timestamp (in seconds) of when the certificate expires.
    """
    content: str | None = None
    """
    The content of the certificate in PEM format.
    """


class Certificate2(BaseModel):
    """
    Represents an individual `certificate` uploaded to the organization.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal[
        "certificate",
        "organization.certificate",
        "organization.project.certificate",
    ]
    """
    The object type.

    - If creating, updating, or getting a specific certificate, the object type is `certificate`.
    - If listing, activating, or deactivating certificates for the organization, the object type is `organization.certificate`.
    - If listing, activating, or deactivating certificates for a project, the object type is `organization.project.certificate`.

    """
    id: str
    """
    The identifier, which can be referenced in API endpoints
    """
    name: str
    """
    The name of the certificate.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) of when the certificate was uploaded.
    """
    certificate_details: CertificateDetails
    active: bool | None = None
    """
    Whether the certificate is currently active at the specified scope. Not returned when getting details for a specific certificate.
    """


class ChatCompletionDeleted(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["chat.completion.deleted"] = "chat.completion.deleted"
    """
    The type of object being deleted.
    """
    id: str
    """
    The ID of the chat completion that was deleted.
    """
    deleted: bool
    """
    Whether the chat completion was deleted.
    """


class ChatCompletionFunctionCallOption(BaseModel):
    """
    Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    """
    The name of the function to call.
    """


class Function1(BaseModel):
    """
    The function that the model called.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    """
    The name of the function to call.
    """
    arguments: str
    """
    The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
    """


class ChatCompletionMessageToolCall(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The ID of the tool call.
    """
    type: Literal["function"] = "function"
    """
    The type of the tool. Currently, only `function` is supported.
    """
    function: Function1
    """
    The function that the model called.
    """


class Function2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str | None = None
    """
    The name of the function to call.
    """
    arguments: str | None = None
    """
    The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
    """


class ChatCompletionMessageToolCallChunk(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    id: str | None = None
    """
    The ID of the tool call.
    """
    type: Literal["function"] | None = None
    """
    The type of the tool. Currently, only `function` is supported.
    """
    function: Function2 | None = None


class ChatCompletionMessageToolCalls(
    RootModel[list[ChatCompletionMessageToolCall]]
):
    """
    The tool calls generated by the model, such as function calls.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[ChatCompletionMessageToolCall]
    """
    The tool calls generated by the model, such as function calls.
    """


class ChatCompletionModalities(
    RootModel[list[Literal["text", "audio"]] | None]
):
    """
    Output types that you would like the model to generate for this request.
    Most models are capable of generating text, which is the default:

    `["text"]`

    The `gpt-4o-audio-preview` model can also be used to [generate audio](/docs/guides/audio). To
    request that this model generate both text and audio responses, you can
    use:

    `["text", "audio"]`

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[Literal["text", "audio"]] | None = None
    """
    Output types that you would like the model to generate for this request.
    Most models are capable of generating text, which is the default:

    `["text"]`

    The `gpt-4o-audio-preview` model can also be used to [generate audio](/docs/guides/audio). To
    request that this model generate both text and audio responses, you can
    use:

    `["text", "audio"]`

    """


class Function3(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    """
    The name of the function to call.
    """


class ChatCompletionNamedToolChoice(BaseModel):
    """
    Specifies a tool the model should use. Use to force the model to call a specific function.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["function"] = "function"
    """
    The type of the tool. Currently, only `function` is supported.
    """
    function: Function3


class Audio(BaseModel):
    """
    Data about a previous audio response from the model.
    [Learn more](/docs/guides/audio).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    Unique identifier for a previous audio response from the model.

    """


class FunctionCall(BaseModel):
    """
    Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    arguments: str
    """
    The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
    """
    name: str
    """
    The name of the function to call.
    """


class ChatCompletionRequestFunctionMessage(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: Literal["function"] = "function"
    """
    The role of the messages author, in this case `function`.
    """
    content: str
    """
    The contents of the function message.
    """
    name: str
    """
    The name of the function to call.
    """


class InputAudio(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: str
    """
    Base64 encoded audio data.
    """
    format: Literal["wav", "mp3"]
    """
    The format of the encoded audio data. Currently supports "wav" and "mp3".

    """


class ChatCompletionRequestMessageContentPartAudio(BaseModel):
    """
    Learn about [audio inputs](/docs/guides/audio).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["input_audio"] = "input_audio"
    """
    The type of the content part. Always `input_audio`.
    """
    input_audio: InputAudio


class File(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    filename: str | None = None
    """
    The name of the file, used when passing the file to the model as a 
    string.

    """
    file_data: str | None = None
    """
    The base64 encoded file data, used when passing the file to the model 
    as a string.

    """
    file_id: str | None = None
    """
    The ID of an uploaded file to use as input.

    """


class ChatCompletionRequestMessageContentPartFile(BaseModel):
    """
    Learn about [file inputs](/docs/guides/text) for text generation.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["file"] = "file"
    """
    The type of the content part. Always `file`.
    """
    file: File


class ImageUrl(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    url: AnyUrl
    """
    Either a URL of the image or the base64 encoded image data.
    """
    detail: Literal["auto", "low", "high"] | None = "auto"
    """
    Specifies the detail level of the image. Learn more in the [Vision guide](/docs/guides/vision#low-or-high-fidelity-image-understanding).
    """


class ChatCompletionRequestMessageContentPartImage(BaseModel):
    """
    Learn about [image inputs](/docs/guides/vision).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["image_url"] = "image_url"
    """
    The type of the content part.
    """
    image_url: ImageUrl


class ChatCompletionRequestMessageContentPartRefusal(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["refusal"] = "refusal"
    """
    The type of the content part.
    """
    refusal: str
    """
    The refusal message generated by the model.
    """


class ChatCompletionRequestMessageContentPartText(BaseModel):
    """
    Learn about [text inputs](/docs/guides/text-generation).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["text"] = "text"
    """
    The type of the content part.
    """
    text: str
    """
    The text content.
    """


class ChatCompletionRequestSystemMessageContentPart(
    RootModel[ChatCompletionRequestMessageContentPartText]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: ChatCompletionRequestMessageContentPartText


class ChatCompletionRequestToolMessageContentPart(
    RootModel[ChatCompletionRequestMessageContentPartText]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: ChatCompletionRequestMessageContentPartText


class ChatCompletionRequestUserMessageContentPart(
    RootModel[
        ChatCompletionRequestMessageContentPartText
        | ChatCompletionRequestMessageContentPartImage
        | ChatCompletionRequestMessageContentPartAudio
        | ChatCompletionRequestMessageContentPartFile
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        ChatCompletionRequestMessageContentPartText
        | ChatCompletionRequestMessageContentPartImage
        | ChatCompletionRequestMessageContentPartAudio
        | ChatCompletionRequestMessageContentPartFile
    )


class UrlCitation(BaseModel):
    """
    A URL citation when using web search.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    end_index: int
    """
    The index of the last character of the URL citation in the message.
    """
    start_index: int
    """
    The index of the first character of the URL citation in the message.
    """
    url: str
    """
    The URL of the web resource.
    """
    title: str
    """
    The title of the web resource.
    """


class Annotation(BaseModel):
    """
    A URL citation when using web search.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["url_citation"] = "url_citation"
    """
    The type of the URL citation. Always `url_citation`.
    """
    url_citation: UrlCitation
    """
    A URL citation when using web search.
    """


class Audio1(BaseModel):
    """
    If the audio output modality is requested, this object contains data
    about the audio response from the model. [Learn more](/docs/guides/audio).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    Unique identifier for this audio response.
    """
    expires_at: int
    """
    The Unix timestamp (in seconds) for when this audio response will
    no longer be accessible on the server for use in multi-turn
    conversations.

    """
    data: str
    """
    Base64 encoded audio bytes generated by the model, in the format
    specified in the request.

    """
    transcript: str
    """
    Transcript of the audio generated by the model.
    """


class ChatCompletionResponseMessage(BaseModel):
    """
    A chat completion message generated by the model.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str
    """
    The contents of the message.
    """
    refusal: str
    """
    The refusal message generated by the model.
    """
    tool_calls: ChatCompletionMessageToolCalls | None = None
    annotations: list[Annotation] | None = None
    """
    Annotations for the message, when applicable, as when using the
    [web search tool](/docs/guides/tools-web-search?api-mode=chat).

    """
    role: Literal["assistant"] = "assistant"
    """
    The role of the author of this message.
    """
    function_call: FunctionCall | None = None
    """
    Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
    """
    audio: Audio1 | None = None
    """
    If the audio output modality is requested, this object contains data
    about the audio response from the model. [Learn more](/docs/guides/audio).

    """


class ChatCompletionRole(
    RootModel[
        Literal["developer", "system", "user", "assistant", "tool", "function"]
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal[
        "developer", "system", "user", "assistant", "tool", "function"
    ]
    """
    The role of the author of a message
    """


class ChatCompletionStreamOptions(BaseModel):
    """
    Options for streaming response. Only set this when you set `stream: true`.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    include_usage: bool | None = None
    """
    If set, an additional chunk will be streamed before the `data: [DONE]`
    message. The `usage` field on this chunk shows the token usage statistics
    for the entire request, and the `choices` field will always be an empty
    array. 

    All other chunks will also include a `usage` field, but with a null
    value. **NOTE:** If the stream is interrupted, you may not receive the
    final usage chunk which contains the total token usage for the request.

    """


class FunctionCall2(BaseModel):
    """
    Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    arguments: str | None = None
    """
    The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
    """
    name: str | None = None
    """
    The name of the function to call.
    """


class ChatCompletionStreamResponseDelta(BaseModel):
    """
    A chat completion delta generated by streamed model responses.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str | None = None
    """
    The contents of the chunk message.
    """
    function_call: FunctionCall2 | None = None
    """
    Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
    """
    tool_calls: list[ChatCompletionMessageToolCallChunk] | None = None
    role: (
        Literal["developer", "system", "user", "assistant", "tool"] | None
    ) = None
    """
    The role of the author of this message.
    """
    refusal: str | None = None
    """
    The refusal message generated by the model.
    """


class TopLogprob(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    token: str
    """
    The token.
    """
    logprob: float
    """
    The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value `-9999.0` is used to signify that the token is very unlikely.
    """
    bytes: list[int]
    """
    A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters are represented by multiple tokens and their byte representations must be combined to generate the correct text representation. Can be `null` if there is no bytes representation for the token.
    """


class ChatCompletionTokenLogprob(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    token: str
    """
    The token.
    """
    logprob: float
    """
    The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value `-9999.0` is used to signify that the token is very unlikely.
    """
    bytes: list[int]
    """
    A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters are represented by multiple tokens and their byte representations must be combined to generate the correct text representation. Can be `null` if there is no bytes representation for the token.
    """
    top_logprobs: list[TopLogprob]
    """
    List of the most likely tokens and their log probability, at this token position. In rare cases, there may be fewer than the number of requested `top_logprobs` returned.
    """


class ChatCompletionToolChoiceOption(
    RootModel[
        Literal["none", "auto", "required"] | ChatCompletionNamedToolChoice
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal["none", "auto", "required"] | ChatCompletionNamedToolChoice
    """
    Controls which (if any) tool is called by the model.
    `none` means the model will not call any tool and instead generates a message.
    `auto` means the model can pick between generating a message or calling one or more tools.
    `required` means the model must call one or more tools.
    Specifying a particular tool via `{"type": "function", "function": {"name": "my_function"}}` forces the model to call that tool.

    `none` is the default when no tools are present. `auto` is the default if tools are present.

    """


class Click(BaseModel):
    """
    A click action.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["click"] = "click"
    """
    Specifies the event type. For a click action, this property is 
    always set to `click`.

    """
    button: Literal["left", "right", "wheel", "back", "forward"]
    """
    Indicates which mouse button was pressed during the click. One of `left`, `right`, `wheel`, `back`, or `forward`.

    """
    x: int
    """
    The x-coordinate where the click occurred.

    """
    y: int
    """
    The y-coordinate where the click occurred.

    """


class File1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    mime_type: str
    """
    The MIME type of the file.

    """
    file_id: str
    """
    The ID of the file.

    """


class CodeInterpreterFileOutput(BaseModel):
    """
    The output of a code interpreter tool call that is a file.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["files"] = "files"
    """
    The type of the code interpreter file output. Always `files`.

    """
    files: list[File1]


class CodeInterpreterTextOutput(BaseModel):
    """
    The output of a code interpreter tool call that is text.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["logs"] = "logs"
    """
    The type of the code interpreter text output. Always `logs`.

    """
    logs: str
    """
    The logs of the code interpreter tool call.

    """


class CodeInterpreterToolOutput(
    RootModel[CodeInterpreterTextOutput | CodeInterpreterFileOutput]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: CodeInterpreterTextOutput | CodeInterpreterFileOutput


class ComparisonFilter(BaseModel):
    """
    A filter used to compare a specified attribute key to a given value using a defined comparison operation.

    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["eq", "ne", "gt", "gte", "lt", "lte"]
    """
    Specifies the comparison operator: `eq`, `ne`, `gt`, `gte`, `lt`, `lte`.
    - `eq`: equals
    - `ne`: not equal
    - `gt`: greater than
    - `gte`: greater than or equal
    - `lt`: less than
    - `lte`: less than or equal

    """
    key: str
    """
    The key to compare against the value.
    """
    value: str | float | bool
    """
    The value to compare against the attribute key; supports string, number, or boolean types.
    """


class CompleteUploadRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    part_ids: list[str]
    """
    The ordered list of Part IDs.

    """
    md5: str | None = None
    """
    The optional md5 checksum for the file contents to verify if the bytes uploaded matches what you expect.

    """


class CompletionTokensDetails(BaseModel):
    """
    Breakdown of tokens used in a completion.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    accepted_prediction_tokens: int | None = 0
    """
    When using Predicted Outputs, the number of tokens in the
    prediction that appeared in the completion.

    """
    audio_tokens: int | None = 0
    """
    Audio input tokens generated by the model.
    """
    reasoning_tokens: int | None = 0
    """
    Tokens generated by the model for reasoning.
    """
    rejected_prediction_tokens: int | None = 0
    """
    When using Predicted Outputs, the number of tokens in the
    prediction that did not appear in the completion. However, like
    reasoning tokens, these tokens are still counted in the total
    completion tokens for purposes of billing, output, and context window
    limits.

    """


class PromptTokensDetails(BaseModel):
    """
    Breakdown of tokens used in the prompt.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    audio_tokens: int | None = 0
    """
    Audio input tokens present in the prompt.
    """
    cached_tokens: int | None = 0
    """
    Cached tokens present in the prompt.
    """


class CompletionUsage(BaseModel):
    """
    Usage statistics for the completion request.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    completion_tokens: int
    """
    Number of tokens in the generated completion.
    """
    prompt_tokens: int
    """
    Number of tokens in the prompt.
    """
    total_tokens: int
    """
    Total number of tokens used in the request (prompt + completion).
    """
    completion_tokens_details: CompletionTokensDetails | None = None
    """
    Breakdown of tokens used in a completion.
    """
    prompt_tokens_details: PromptTokensDetails | None = None
    """
    Breakdown of tokens used in the prompt.
    """


class CompoundFilter(BaseModel):
    """
    Combine multiple filters using `and` or `or`.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["and", "or"]
    """
    Type of operation: `and` or `or`.
    """
    filters: list[ComparisonFilter | Any]
    """
    Array of filters to combine. Items can be `ComparisonFilter` or `CompoundFilter`.
    """


class ComputerScreenshotImage(BaseModel):
    """
    A computer screenshot image used with the computer use tool.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["computer_screenshot"] = "computer_screenshot"
    """
    Specifies the event type. For a computer screenshot, this property is 
    always set to `computer_screenshot`.

    """
    image_url: str | None = None
    """
    The URL of the screenshot image.
    """
    file_id: str | None = None
    """
    The identifier of an uploaded file that contains the screenshot.
    """


class ComputerToolCallSafetyCheck(BaseModel):
    """
    A pending safety check for the computer call.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The ID of the pending safety check.
    """
    code: str
    """
    The type of the pending safety check.
    """
    message: str
    """
    Details about the pending safety check.
    """


class Coordinate(BaseModel):
    """
    An x/y coordinate pair, e.g. `{ x: 100, y: 200 }`.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    x: int
    """
    The x-coordinate.

    """
    y: int
    """
    The y-coordinate.

    """


class Amount(BaseModel):
    """
    The monetary value in its associated currency.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    value: float | None = None
    """
    The numeric value of the cost.
    """
    currency: str | None = None
    """
    Lowercase ISO-4217 currency e.g. "usd"
    """


class CostsResult(BaseModel):
    """
    The aggregated costs details of the specific time bucket.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.costs.result"] = "organization.costs.result"
    amount: Amount | None = None
    """
    The monetary value in its associated currency.
    """
    line_item: str | None = None
    """
    When `group_by=line_item`, this field provides the line item of the grouped costs result.
    """
    project_id: str | None = None
    """
    When `group_by=project_id`, this field provides the project ID of the grouped costs result.
    """


class CodeInterpreter1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_ids: list[str] | None = Field([], max_length=20)
    """
    A list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files associated with the tool.

    """


class ChunkingStrategy(BaseModel):
    """
    The default strategy. This strategy currently uses a `max_chunk_size_tokens` of `800` and `chunk_overlap_tokens` of `400`.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["auto"] = "auto"
    """
    Always `auto`.
    """


class Static(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    max_chunk_size_tokens: int = Field(..., ge=100, le=4096)
    """
    The maximum number of tokens in each chunk. The default value is `800`. The minimum value is `100` and the maximum value is `4096`.
    """
    chunk_overlap_tokens: int
    """
    The number of tokens that overlap between chunks. The default value is `400`.

    Note that the overlap must not exceed half of `max_chunk_size_tokens`.

    """


class ChunkingStrategy1(BaseModel):
    """
    The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["static"] = "static"
    """
    Always `static`.
    """
    static: Static


class ChunkingStrategy2(BaseModel):
    """
    The default strategy. This strategy currently uses a `max_chunk_size_tokens` of `800` and `chunk_overlap_tokens` of `400`.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["auto"] = "auto"
    """
    Always `auto`.
    """


class ChunkingStrategy3(BaseModel):
    """
    The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["static"] = "static"
    """
    Always `static`.
    """
    static: Static


class Logprobs(BaseModel):
    """
    Log probability information for the choice.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: list[ChatCompletionTokenLogprob]
    """
    A list of message content tokens with log probability information.
    """
    refusal: list[ChatCompletionTokenLogprob]
    """
    A list of message refusal tokens with log probability information.
    """


class Choice(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    finish_reason: Literal[
        "stop", "length", "tool_calls", "content_filter", "function_call"
    ]
    """
    The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
    `length` if the maximum number of tokens specified in the request was reached,
    `content_filter` if content was omitted due to a flag from our content filters,
    `tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.

    """
    index: int
    """
    The index of the choice in the list of choices.
    """
    message: ChatCompletionResponseMessage
    logprobs: Logprobs
    """
    Log probability information for the choice.
    """


class Choice1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    delta: ChatCompletionStreamResponseDelta
    logprobs: Logprobs | None = None
    """
    Log probability information for the choice.
    """
    finish_reason: Literal[
        "stop", "length", "tool_calls", "content_filter", "function_call"
    ]
    """
    The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
    `length` if the maximum number of tokens specified in the request was reached,
    `content_filter` if content was omitted due to a flag from our content filters,
    `tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.

    """
    index: int
    """
    The index of the choice in the list of choices.
    """


class Prompt(RootModel[list[int] | None]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[int] | None = Field(
        "<|endoftext|>", examples=["[1212, 318, 257, 1332, 13]"], min_length=1
    )
    """
    The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays.

    Note that <|endoftext|> is the document separator that the model sees during training, so if a prompt is not specified the model will generate as if from the beginning of a new document.

    """


class Prompt1Item(RootModel[list[int]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[int] = Field(..., min_length=1)


class Prompt1(RootModel[list[Prompt1Item] | None]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[Prompt1Item] | None = Field(
        "<|endoftext|>",
        examples=["[[1212, 318, 257, 1332, 13]]"],
        min_length=1,
    )
    """
    The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays.

    Note that <|endoftext|> is the document separator that the model sees during training, so if a prompt is not specified the model will generate as if from the beginning of a new document.

    """


class Logprobs2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    text_offset: list[int] | None = None
    token_logprobs: list[float] | None = None
    tokens: list[str] | None = None
    top_logprobs: list[dict[str, float]] | None = None


class Choice2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    finish_reason: Literal["stop", "length", "content_filter"]
    """
    The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
    `length` if the maximum number of tokens specified in the request was reached,
    or `content_filter` if content was omitted due to a flag from our content filters.

    """
    index: int
    logprobs: Logprobs2
    text: str


class CreateCompletionResponse(BaseModel):
    """
    Represents a completion response from the API. Note: both the streamed and non-streamed response objects share the same shape (unlike the chat endpoint).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    A unique identifier for the completion.
    """
    choices: list[Choice2]
    """
    The list of completion choices the model generated for the input prompt.
    """
    created: int
    """
    The Unix timestamp (in seconds) of when the completion was created.
    """
    model: str
    """
    The model used for completion.
    """
    system_fingerprint: str | None = None
    """
    This fingerprint represents the backend configuration that the model runs with.

    Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.

    """
    object: Literal["text_completion"] = "text_completion"
    """
    The object type, which is always "text_completion"
    """
    usage: CompletionUsage | None = None


class Input(RootModel[list[str]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[str] = Field(
        ...,
        examples=["The quick brown fox jumped over the lazy dog"],
        max_length=2048,
        min_length=1,
        title="array",
    )
    """
    The array of strings that will be turned into an embedding.
    """


class Input1(RootModel[list[int]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[int] = Field(
        ...,
        examples=["[1212, 318, 257, 1332, 13]"],
        max_length=2048,
        min_length=1,
        title="array",
    )
    """
    The array of integers that will be turned into an embedding.
    """


class Input2Item(RootModel[list[int]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[int] = Field(..., min_length=1)


class Input2(RootModel[list[Input2Item]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[Input2Item] = Field(
        ...,
        examples=["[[1212, 318, 257, 1332, 13]]"],
        max_length=2048,
        min_length=1,
        title="array",
    )
    """
    The array of arrays containing integers that will be turned into an embedding.
    """


class CreateEmbeddingRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    input: str | Input | Input1 | Input2 = Field(
        ..., examples=["The quick brown fox jumped over the lazy dog"]
    )
    """
    Input text to embed, encoded as a string or array of tokens. To embed multiple inputs in a single request, pass an array of strings or array of token arrays. The input must not exceed the max input tokens for the model (8192 tokens for `text-embedding-ada-002`), cannot be an empty string, and any array must be 2048 dimensions or less. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens. Some models may also impose a limit on total number of tokens summed across inputs.

    """
    model: (
        str
        | Literal[
            "text-embedding-ada-002",
            "text-embedding-3-small",
            "text-embedding-3-large",
        ]
    ) = Field(..., examples=["text-embedding-3-small"])
    """
    ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models) for descriptions of them.

    """
    encoding_format: Literal["float", "base64"] | None = Field(
        "float", examples=["float"]
    )
    """
    The format to return the embeddings in. Can be either `float` or [`base64`](https://pypi.org/project/pybase64/).
    """
    dimensions: int | None = Field(None, ge=1)
    """
    The number of dimensions the resulting output embeddings should have. Only supported in `text-embedding-3` and later models.

    """
    user: str | None = Field(None, examples=["user-1234"])
    """
    A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices#end-user-ids).

    """


class Usage(BaseModel):
    """
    The usage information for the request.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    prompt_tokens: int
    """
    The number of tokens used by the prompt.
    """
    total_tokens: int
    """
    The total number of tokens used by the request.
    """


class InputMessages1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["item_reference"] = "item_reference"
    """
    The type of input messages. Always `item_reference`.
    """
    item_reference: str
    """
    A reference to a variable in the "item" namespace. Ie, "item.name"
    """


class SamplingParams(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    temperature: float | None = 1
    """
    A higher temperature increases randomness in the outputs.
    """
    max_completion_tokens: int | None = None
    """
    The maximum number of tokens in the generated output.
    """
    top_p: float | None = 1
    """
    An alternative to temperature for nucleus sampling; 1.0 includes all tokens.
    """
    seed: int | None = 42
    """
    A seed value to initialize the randomness, during sampling.
    """


class CreateEvalCustomDataSourceConfig(BaseModel):
    """
    A CustomDataSourceConfig object that defines the schema for the data source used for the evaluation runs.
    This schema is used to define the shape of the data that will be:
    - Used to define your testing criteria and
    - What data is required when creating a run

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["custom"] = "custom"
    """
    The type of data source. Always `custom`.
    """
    item_schema: dict[str, Any] = Field(
        ...,
        examples=[
            '{\n  "type": "object",\n  "properties": {\n    "name": {"type": "string"},\n    "age": {"type": "integer"}\n  },\n  "required": ["name", "age"]\n}\n'
        ],
    )
    """
    The json schema for each row in the data source.
    """
    include_sample_schema: bool | None = False
    """
    Whether the eval should expect you to populate the sample namespace (ie, by generating responses off of your data source)
    """


class CreateEvalItem1(BaseModel):
    """
    A chat message that makes up the prompt or context. May include variable references to the "item" namespace, ie {{item.name}}.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: str
    """
    The role of the message (e.g. "system", "assistant", "user").
    """
    content: str
    """
    The content of the message.
    """


class CreateEvalLogsDataSourceConfig(BaseModel):
    """
    A data source config which specifies the metadata property of your stored completions query.
    This is usually metadata like `usecase=chatbot` or `prompt-version=v2`, etc.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["logs"] = "logs"
    """
    The type of data source. Always `logs`.
    """
    metadata: dict[str, Any] | None = Field(
        None, examples=['{\n  "use_case": "customer_support_agent"\n}\n']
    )
    """
    Metadata filters for the logs data source.
    """


class Template(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: str
    """
    The role of the message (e.g. "system", "assistant", "user").
    """
    content: str
    """
    The content of the message.
    """


class CreateFileRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    file: bytes_aliased
    """
    The File object (not file name) to be uploaded.

    """
    purpose: Literal[
        "assistants", "batch", "fine-tune", "vision", "user_data", "evals"
    ]
    """
    The intended purpose of the uploaded file. One of: - `assistants`: Used in the Assistants API - `batch`: Used in the Batch API - `fine-tune`: Used for fine-tuning - `vision`: Images used for vision fine-tuning - `user_data`: Flexible file type for any purpose - `evals`: Used for eval data sets

    """


class CreateFineTuningCheckpointPermissionRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    project_ids: list[str]
    """
    The project identifiers to grant access to.
    """


class BatchSize(RootModel[int]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: int = Field(..., ge=1, le=256)
    """
    Number of examples in each batch. A larger batch size means that model parameters
    are updated less frequently, but with lower variance.

    """


class LearningRateMultiplier(RootModel[float]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: float = Field(..., gt=0.0)
    """
    Scaling factor for the learning rate. A smaller learning rate may be useful to avoid
    overfitting.

    """


class NEpochs(RootModel[int]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: int = Field(..., ge=1, le=50)
    """
    The number of epochs to train the model for. An epoch refers to one full cycle
    through the training dataset.

    """


class Hyperparameters(BaseModel):
    """
    The hyperparameters used for the fine-tuning job.
    This value is now deprecated in favor of `method`, and should be passed in under the `method` parameter.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    batch_size: Literal["auto"] | BatchSize | None = "auto"
    """
    Number of examples in each batch. A larger batch size means that model parameters
    are updated less frequently, but with lower variance.

    """
    learning_rate_multiplier: (
        Literal["auto"] | LearningRateMultiplier | None
    ) = "auto"
    """
    Scaling factor for the learning rate. A smaller learning rate may be useful to avoid
    overfitting.

    """
    n_epochs: Literal["auto"] | NEpochs | None = "auto"
    """
    The number of epochs to train the model for. An epoch refers to one full cycle
    through the training dataset.

    """


class Wandb(BaseModel):
    """
    The settings for your integration with Weights and Biases. This payload specifies the project that
    metrics will be sent to. Optionally, you can set an explicit display name for your run, add tags
    to your run, and set a default entity (team, username, etc) to be associated with your run.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    project: str = Field(..., examples=["my-wandb-project"])
    """
    The name of the project that the new run will be created under.

    """
    name: str | None = None
    """
    A display name to set for the run. If not set, we will use the Job ID as the name.

    """
    entity: str | None = None
    """
    The entity to use for the run. This allows you to set the team or username of the WandB user that you would
    like associated with the run. If not set, the default entity for the registered WandB API key is used.

    """
    tags: list[str] | None = None
    """
    A list of tags to be attached to the newly created run. These tags are passed through directly to WandB. Some
    default tags are generated by OpenAI: "openai/finetune", "openai/{base-model}", "openai/{ftjob-abcdef}".

    """


class Integration(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["wandb"]
    """
    The type of integration to enable. Currently, only "wandb" (Weights and Biases) is supported.

    """
    wandb: Wandb
    """
    The settings for your integration with Weights and Biases. This payload specifies the project that
    metrics will be sent to. Optionally, you can set an explicit display name for your run, add tags
    to your run, and set a default entity (team, username, etc) to be associated with your run.

    """


class Image(RootModel[list[bytes_aliased]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[bytes_aliased] = Field(..., max_length=16)
    """
    The image(s) to edit. Must be a supported image file or an array of images.

    For `gpt-image-1`, each image should be a `png`, `webp`, or `jpg` file less 
    than 25MB. You can provide up to 16 images.

    For `dall-e-2`, you can only provide one image, and it should be a square 
    `png` file less than 4MB.

    """


class CreateImageEditRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    image: bytes_aliased | Image
    """
    The image(s) to edit. Must be a supported image file or an array of images.

    For `gpt-image-1`, each image should be a `png`, `webp`, or `jpg` file less 
    than 25MB. You can provide up to 16 images.

    For `dall-e-2`, you can only provide one image, and it should be a square 
    `png` file less than 4MB.

    """
    prompt: str = Field(
        ..., examples=["A cute baby sea otter wearing a beret"]
    )
    """
    A text description of the desired image(s). The maximum length is 1000 characters for `dall-e-2`, and 32000 characters for `gpt-image-1`.
    """
    mask: bytes_aliased | None = None
    """
    An additional image whose fully transparent areas (e.g. where alpha is zero) indicate where `image` should be edited. If there are multiple images provided, the mask will be applied on the first image. Must be a valid PNG file, less than 4MB, and have the same dimensions as `image`.
    """
    model: str | Literal["dall-e-2", "gpt-image-1"] | None = Field(
        "dall-e-2", examples=["gpt-image-1"]
    )
    """
    The model to use for image generation. Only `dall-e-2` and `gpt-image-1` are supported. Defaults to `dall-e-2` unless a parameter specific to `gpt-image-1` is used.
    """
    n: int | None = Field(1, examples=[1], ge=1, le=10)
    """
    The number of images to generate. Must be between 1 and 10.
    """
    size: (
        Literal[
            "256x256", "512x512", "1024x1024", "1536x1024", "1024x1536", "auto"
        ]
        | None
    ) = Field("1024x1024", examples=["1024x1024"])
    """
    The size of the generated images. Must be one of `1024x1024`, `1536x1024` (landscape), `1024x1536` (portrait), or `auto` (default value) for `gpt-image-1`, and one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`.
    """
    response_format: Literal["url", "b64_json"] | None = Field(
        "url", examples=["url"]
    )
    """
    The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated. This parameter is only supported for `dall-e-2`, as `gpt-image-1` will always return base64-encoded images.
    """
    user: str | None = Field(None, examples=["user-1234"])
    """
    A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices#end-user-ids).

    """
    quality: Literal["standard", "low", "medium", "high", "auto"] | None = (
        Field("auto", examples=["high"])
    )
    """
    The quality of the image that will be generated. `high`, `medium` and `low` are only supported for `gpt-image-1`. `dall-e-2` only supports `standard` quality. Defaults to `auto`.

    """


class CreateImageRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    prompt: str = Field(..., examples=["A cute baby sea otter"])
    """
    A text description of the desired image(s). The maximum length is 32000 characters for `gpt-image-1`, 1000 characters for `dall-e-2` and 4000 characters for `dall-e-3`.
    """
    model: str | Literal["dall-e-2", "dall-e-3", "gpt-image-1"] | None = Field(
        "dall-e-2", examples=["gpt-image-1"]
    )
    """
    The model to use for image generation. One of `dall-e-2`, `dall-e-3`, or `gpt-image-1`. Defaults to `dall-e-2` unless a parameter specific to `gpt-image-1` is used.
    """
    n: int | None = Field(1, examples=[1], ge=1, le=10)
    """
    The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.
    """
    quality: (
        Literal["standard", "hd", "low", "medium", "high", "auto"] | None
    ) = Field("auto", examples=["medium"])
    """
    The quality of the image that will be generated. 

    - `auto` (default value) will automatically select the best quality for the given model.
    - `high`, `medium` and `low` are supported for `gpt-image-1`.
    - `hd` and `standard` are supported for `dall-e-3`.
    - `standard` is the only option for `dall-e-2`.

    """
    response_format: Literal["url", "b64_json"] | None = Field(
        "url", examples=["url"]
    )
    """
    The format in which generated images with `dall-e-2` and `dall-e-3` are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated. This parameter isn't supported for `gpt-image-1` which will always return base64-encoded images.
    """
    output_format: Literal["png", "jpeg", "webp"] | None = Field(
        "png", examples=["png"]
    )
    """
    The format in which the generated images are returned. This parameter is only supported for `gpt-image-1`. Must be one of `png`, `jpeg`, or `webp`.
    """
    output_compression: int | None = Field(100, examples=[100])
    """
    The compression level (0-100%) for the generated images. This parameter is only supported for `gpt-image-1` with the `webp` or `jpeg` output formats, and defaults to 100.
    """
    size: (
        Literal[
            "auto",
            "1024x1024",
            "1536x1024",
            "1024x1536",
            "256x256",
            "512x512",
            "1792x1024",
            "1024x1792",
        ]
        | None
    ) = Field("auto", examples=["1024x1024"])
    """
    The size of the generated images. Must be one of `1024x1024`, `1536x1024` (landscape), `1024x1536` (portrait), or `auto` (default value) for `gpt-image-1`, one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`, and one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3`.
    """
    moderation: Literal["low", "auto"] | None = Field("auto", examples=["low"])
    """
    Control the content-moderation level for images generated by `gpt-image-1`. Must be either `low` for less restrictive filtering or `auto` (default value).
    """
    background: Literal["transparent", "opaque", "auto"] | None = Field(
        "auto", examples=["transparent"]
    )
    """
    Allows to set transparency for the background of the generated image(s). 
    This parameter is only supported for `gpt-image-1`. Must be one of 
    `transparent`, `opaque` or `auto` (default value). When `auto` is used, the 
    model will automatically determine the best background for the image.

    If `transparent`, the output format needs to support transparency, so it 
    should be set to either `png` (default value) or `webp`.

    """
    style: Literal["vivid", "natural"] | None = Field(
        "vivid", examples=["vivid"]
    )
    """
    The style of the generated images. This parameter is only supported for `dall-e-3`. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images.
    """
    user: str | None = Field(None, examples=["user-1234"])
    """
    A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices#end-user-ids).

    """


class CreateImageVariationRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    image: bytes_aliased
    """
    The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.
    """
    model: str | Literal["dall-e-2"] | None = Field(
        "dall-e-2", examples=["dall-e-2"]
    )
    """
    The model to use for image generation. Only `dall-e-2` is supported at this time.
    """
    n: int | None = Field(1, examples=[1], ge=1, le=10)
    """
    The number of images to generate. Must be between 1 and 10.
    """
    response_format: Literal["url", "b64_json"] | None = Field(
        "url", examples=["url"]
    )
    """
    The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.
    """
    size: Literal["256x256", "512x512", "1024x1024"] | None = Field(
        "1024x1024", examples=["1024x1024"]
    )
    """
    The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024`.
    """
    user: str | None = Field(None, examples=["user-1234"])
    """
    A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices#end-user-ids).

    """


class Attachment(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_id: str | None = None
    """
    The ID of the file to attach to the message.
    """
    tools: (
        list[AssistantToolsCode | AssistantToolsFileSearchTypeOnly] | None
    ) = None
    """
    The tools to add this file to.
    """


class ImageUrl1(BaseModel):
    """
    Contains either an image URL or a data URL for a base64 encoded image.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    url: AnyUrl = Field(..., examples=["https://example.com/image.jpg"])
    """
    Either a URL of the image or the base64 encoded image data.
    """


class Input3(BaseModel):
    """
    An object describing an image to classify.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["image_url"] = "image_url"
    """
    Always `image_url`.
    """
    image_url: ImageUrl1
    """
    Contains either an image URL or a data URL for a base64 encoded image.
    """


class Input4(BaseModel):
    """
    An object describing text to classify.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["text"] = "text"
    """
    Always `text`.
    """
    text: str = Field(..., examples=["I want to kill them"])
    """
    A string of text to classify.
    """


class CreateModerationRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    input: str | list[str] | list[Input3 | Input4]
    """
    Input (or inputs) to classify. Can be a single string, an array of strings, or
    an array of multi-modal input objects similar to other models.

    """
    model: (
        str
        | Literal[
            "omni-moderation-latest",
            "omni-moderation-2024-09-26",
            "text-moderation-latest",
            "text-moderation-stable",
        ]
        | None
    ) = Field(
        "omni-moderation-latest", examples=["omni-moderation-2024-09-26"]
    )
    """
    The content moderation model you would like to use. Learn more in
    [the moderation guide](/docs/guides/moderation), and learn about
    available models [here](/docs/models#moderation).

    """


class Categories(BaseModel):
    """
    A list of the categories, and whether they are flagged or not.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    hate: bool
    """
    Content that expresses, incites, or promotes hate based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste. Hateful content aimed at non-protected groups (e.g., chess players) is harassment.
    """
    hate_threatening: bool
    """
    Hateful content that also includes violence or serious harm towards the targeted group based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste.
    """
    harassment: bool
    """
    Content that expresses, incites, or promotes harassing language towards any target.
    """
    harassment_threatening: bool
    """
    Harassment content that also includes violence or serious harm towards any target.
    """
    illicit: bool
    """
    Content that includes instructions or advice that facilitate the planning or execution of wrongdoing, or that gives advice or instruction on how to commit illicit acts. For example, "how to shoplift" would fit this category.
    """
    illicit_violent: bool
    """
    Content that includes instructions or advice that facilitate the planning or execution of wrongdoing that also includes violence, or that gives advice or instruction on the procurement of any weapon.
    """
    self_harm: bool
    """
    Content that promotes, encourages, or depicts acts of self-harm, such as suicide, cutting, and eating disorders.
    """
    self_harm_intent: bool
    """
    Content where the speaker expresses that they are engaging or intend to engage in acts of self-harm, such as suicide, cutting, and eating disorders.
    """
    self_harm_instructions: bool
    """
    Content that encourages performing acts of self-harm, such as suicide, cutting, and eating disorders, or that gives instructions or advice on how to commit such acts.
    """
    sexual: bool
    """
    Content meant to arouse sexual excitement, such as the description of sexual activity, or that promotes sexual services (excluding sex education and wellness).
    """
    sexual_minors: bool
    """
    Sexual content that includes an individual who is under 18 years old.
    """
    violence: bool
    """
    Content that depicts death, violence, or physical injury.
    """
    violence_graphic: bool
    """
    Content that depicts death, violence, or physical injury in graphic detail.
    """


class CategoryScores(BaseModel):
    """
    A list of the categories along with their scores as predicted by model.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    hate: float
    """
    The score for the category 'hate'.
    """
    hate_threatening: float
    """
    The score for the category 'hate/threatening'.
    """
    harassment: float
    """
    The score for the category 'harassment'.
    """
    harassment_threatening: float
    """
    The score for the category 'harassment/threatening'.
    """
    illicit: float
    """
    The score for the category 'illicit'.
    """
    illicit_violent: float
    """
    The score for the category 'illicit/violent'.
    """
    self_harm: float
    """
    The score for the category 'self-harm'.
    """
    self_harm_intent: float
    """
    The score for the category 'self-harm/intent'.
    """
    self_harm_instructions: float
    """
    The score for the category 'self-harm/instructions'.
    """
    sexual: float
    """
    The score for the category 'sexual'.
    """
    sexual_minors: float
    """
    The score for the category 'sexual/minors'.
    """
    violence: float
    """
    The score for the category 'violence'.
    """
    violence_graphic: float
    """
    The score for the category 'violence/graphic'.
    """


class CategoryAppliedInputTypes(BaseModel):
    """
    A list of the categories along with the input type(s) that the score applies to.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    hate: list[Literal["text"]]
    """
    The applied input type(s) for the category 'hate'.
    """
    hate_threatening: list[Literal["text"]]
    """
    The applied input type(s) for the category 'hate/threatening'.
    """
    harassment: list[Literal["text"]]
    """
    The applied input type(s) for the category 'harassment'.
    """
    harassment_threatening: list[Literal["text"]]
    """
    The applied input type(s) for the category 'harassment/threatening'.
    """
    illicit: list[Literal["text"]]
    """
    The applied input type(s) for the category 'illicit'.
    """
    illicit_violent: list[Literal["text"]]
    """
    The applied input type(s) for the category 'illicit/violent'.
    """
    self_harm: list[Literal["text", "image"]]
    """
    The applied input type(s) for the category 'self-harm'.
    """
    self_harm_intent: list[Literal["text", "image"]]
    """
    The applied input type(s) for the category 'self-harm/intent'.
    """
    self_harm_instructions: list[Literal["text", "image"]]
    """
    The applied input type(s) for the category 'self-harm/instructions'.
    """
    sexual: list[Literal["text", "image"]]
    """
    The applied input type(s) for the category 'sexual'.
    """
    sexual_minors: list[Literal["text"]]
    """
    The applied input type(s) for the category 'sexual/minors'.
    """
    violence: list[Literal["text", "image"]]
    """
    The applied input type(s) for the category 'violence'.
    """
    violence_graphic: list[Literal["text", "image"]]
    """
    The applied input type(s) for the category 'violence/graphic'.
    """


class Result(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    flagged: bool
    """
    Whether any of the below categories are flagged.
    """
    categories: Categories
    """
    A list of the categories, and whether they are flagged or not.
    """
    category_scores: CategoryScores
    """
    A list of the categories along with their scores as predicted by model.
    """
    category_applied_input_types: CategoryAppliedInputTypes
    """
    A list of the categories along with the input type(s) that the score applies to.
    """


class CreateModerationResponse(BaseModel):
    """
    Represents if a given text input is potentially harmful.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The unique identifier for the moderation request.
    """
    model: str
    """
    The model used to generate the moderation results.
    """
    results: list[Result]
    """
    A list of moderation objects.
    """


class ToolResources2(BaseModel):
    """
    A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code_interpreter: CodeInterpreter1 | None = None
    file_search: FileSearch | None = None


class ChunkingStrategy4(BaseModel):
    """
    The default strategy. This strategy currently uses a `max_chunk_size_tokens` of `800` and `chunk_overlap_tokens` of `400`.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["auto"] = "auto"
    """
    Always `auto`.
    """


class ChunkingStrategy5(BaseModel):
    """
    The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["static"] = "static"
    """
    Always `static`.
    """
    static: Static


class ChunkingStrategy6(BaseModel):
    """
    The default strategy. This strategy currently uses a `max_chunk_size_tokens` of `800` and `chunk_overlap_tokens` of `400`.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["auto"] = "auto"
    """
    Always `auto`.
    """


class ChunkingStrategy7(BaseModel):
    """
    The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["static"] = "static"
    """
    Always `static`.
    """
    static: Static


class Logprob(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    token: str | None = None
    """
    The token in the transcription.
    """
    logprob: float | None = None
    """
    The log probability of the token.
    """
    bytes: list[float] | None = None
    """
    The bytes of the token.
    """


class CreateTranscriptionResponseJson(BaseModel):
    """
    Represents a transcription response returned by model, based on the provided input.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    text: str
    """
    The transcribed text.
    """
    logprobs: list[Logprob] | None = None
    """
    The log probabilities of the tokens in the transcription. Only returned with the models `gpt-4o-transcribe` and `gpt-4o-mini-transcribe` if `logprobs` is added to the `include` array.

    """


class CreateTranslationRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    file: bytes_aliased
    """
    The audio file object (not file name) translate, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.

    """
    model: str | Literal["whisper-1"] = Field(..., examples=["whisper-1"])
    """
    ID of the model to use. Only `whisper-1` (which is powered by our open source Whisper V2 model) is currently available.

    """
    prompt: str | None = None
    """
    An optional text to guide the model's style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text#prompting) should be in English.

    """
    response_format: (
        Literal["json", "text", "srt", "verbose_json", "vtt"] | None
    ) = "json"
    """
    The format of the output, in one of these options: `json`, `text`, `srt`, `verbose_json`, or `vtt`.

    """
    temperature: float | None = 0
    """
    The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.

    """


class CreateTranslationResponseJson(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    text: str


class CreateUploadRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    filename: str
    """
    The name of the file to upload.

    """
    purpose: Literal["assistants", "batch", "fine-tune", "vision"]
    """
    The intended purpose of the uploaded file.

    See the [documentation on File purposes](/docs/api-reference/files/create#files-create-purpose).

    """
    bytes: int
    """
    The number of bytes in the file you are uploading.

    """
    mime_type: str
    """
    The MIME type of the file.

    This must fall within the supported MIME types for your file purpose. See the supported MIME types for assistants and vision.

    """


class DeleteAssistantResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    deleted: bool
    object: Literal["assistant.deleted"] = "assistant.deleted"


class DeleteCertificateResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["certificate.deleted"] = "certificate.deleted"
    """
    The object type, must be `certificate.deleted`.
    """
    id: str
    """
    The ID of the certificate that was deleted.
    """


class DeleteFileResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    object: Literal["file"] = "file"
    deleted: bool


class DeleteFineTuningCheckpointPermissionResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The ID of the fine-tuned model checkpoint permission that was deleted.
    """
    object: Literal["checkpoint.permission"] = "checkpoint.permission"
    """
    The object type, which is always "checkpoint.permission".
    """
    deleted: bool
    """
    Whether the fine-tuned model checkpoint permission was successfully deleted.
    """


class DeleteMessageResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    deleted: bool
    object: Literal["thread.message.deleted"] = "thread.message.deleted"


class DeleteModelResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    deleted: bool
    object: str


class DeleteThreadResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    deleted: bool
    object: Literal["thread.deleted"] = "thread.deleted"


class DeleteVectorStoreFileResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    deleted: bool
    object: Literal["vector_store.file.deleted"] = "vector_store.file.deleted"


class DeleteVectorStoreResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    deleted: bool
    object: Literal["vector_store.deleted"] = "vector_store.deleted"


class DoneEvent(BaseModel):
    """
    Occurs when a stream ends.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["done"] = "done"
    data: Literal["[DONE]"] = "[DONE]"


class DoubleClick(BaseModel):
    """
    A double click action.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["double_click"] = "double_click"
    """
    Specifies the event type. For a double click action, this property is 
    always set to `double_click`.

    """
    x: int
    """
    The x-coordinate where the double click occurred.

    """
    y: int
    """
    The y-coordinate where the double click occurred.

    """


class Drag(BaseModel):
    """
    A drag action.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["drag"] = "drag"
    """
    Specifies the event type. For a drag action, this property is 
    always set to `drag`.

    """
    path: list[Coordinate]
    """
    An array of coordinates representing the path of the drag action. Coordinates will appear as an array
    of objects, eg
    ```
    [
      { x: 100, y: 200 },
      { x: 200, y: 300 }
    ]
    ```

    """


class Embedding(BaseModel):
    """
    Represents an embedding vector returned by embedding endpoint.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the embedding in the list of embeddings.
    """
    embedding: list[float]
    """
    The embedding vector, which is a list of floats. The length of vector depends on the model as listed in the [embedding guide](/docs/guides/embeddings).

    """
    object: Literal["embedding"] = "embedding"
    """
    The object type, which is always "embedding".
    """


class Error1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    code: str
    message: str
    param: str
    type: str


class ErrorEvent(BaseModel):
    """
    Occurs when an [error](/docs/guides/error-codes#api-errors) occurs. This can happen due to an internal server error or a timeout.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["error"] = "error"
    data: Error1


class ErrorResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    error: Error1


class EvalApiError(BaseModel):
    """
    An object representing an error response from the Eval API.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code: str
    """
    The error code.
    """
    message: str
    """
    The error message.
    """


class EvalCustomDataSourceConfig(BaseModel):
    """
    A CustomDataSourceConfig which specifies the schema of your `item` and optionally `sample` namespaces.
    The response schema defines the shape of the data that will be:
    - Used to define your testing criteria and
    - What data is required when creating a run

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["custom"] = "custom"
    """
    The type of data source. Always `custom`.
    """
    schema_: dict[str, Any] = Field(
        ...,
        examples=[
            '{\n  "type": "object",\n  "properties": {\n    "item": {\n      "type": "object",\n      "properties": {\n        "label": {"type": "string"},\n      },\n      "required": ["label"]\n    }\n  },\n  "required": ["item"]\n}\n'
        ],
    )
    """
    The json schema for the run data source items.
    Learn how to build JSON schemas [here](https://json-schema.org/).

    """


class Content7(BaseModel):
    """
    A text output from the model.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["output_text"] = "output_text"
    """
    The type of the output text. Always `output_text`.

    """
    text: str
    """
    The text output from the model.

    """


class ContentItem(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    item: dict[str, Any]
    sample: dict[str, Any] | None = None


class EvalJsonlFileContentSource(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["file_content"] = "file_content"
    """
    The type of jsonl source. Always `file_content`.
    """
    content: list[ContentItem]
    """
    The content of the jsonl file.
    """


class EvalJsonlFileIdSource(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["file_id"] = "file_id"
    """
    The type of jsonl source. Always `file_id`.
    """
    id: str
    """
    The identifier of the file.
    """


class EvalPythonGrader(BaseModel):
    """
    A PythonGrader object that runs a python script on the input.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["python"] = "python"
    """
    The object type, which is always `python`.
    """
    name: str
    """
    The name of the grader.
    """
    source: str
    """
    The source code of the python script.
    """
    pass_threshold: float | None = None
    """
    The threshold for the score.
    """
    image_tag: str | None = None
    """
    The image tag to use for the python script.
    """


class ResultCounts(BaseModel):
    """
    Counters summarizing the outcomes of the evaluation run.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    total: int
    """
    Total number of executed output items.
    """
    errored: int
    """
    Number of output items that resulted in an error.
    """
    failed: int
    """
    Number of output items that failed to pass the evaluation.
    """
    passed: int
    """
    Number of output items that passed the evaluation.
    """


class PerModelUsageItem(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    model_name: str
    """
    The name of the model.
    """
    invocation_count: int
    """
    The number of invocations.
    """
    prompt_tokens: int
    """
    The number of prompt tokens used.
    """
    completion_tokens: int
    """
    The number of completion tokens generated.
    """
    total_tokens: int
    """
    The total number of tokens used.
    """
    cached_tokens: int
    """
    The number of tokens retrieved from cache.
    """


class PerTestingCriteriaResult(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    testing_criteria: str
    """
    A description of the testing criteria.
    """
    passed: int
    """
    Number of tests passed for this criteria.
    """
    failed: int
    """
    Number of tests failed for this criteria.
    """


class InputItem1(BaseModel):
    """
    An input message.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: str
    """
    The role of the message sender (e.g., system, user, developer).
    """
    content: str
    """
    The content of the message.
    """


class OutputItem(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: str | None = None
    """
    The role of the message (e.g. "system", "assistant", "user").
    """
    content: str | None = None
    """
    The content of the message.
    """


class Usage1(BaseModel):
    """
    Token usage details for the sample.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    total_tokens: int
    """
    The total number of tokens used.
    """
    completion_tokens: int
    """
    The number of completion tokens generated.
    """
    prompt_tokens: int
    """
    The number of prompt tokens used.
    """
    cached_tokens: int
    """
    The number of tokens retrieved from cache.
    """


class Sample(BaseModel):
    """
    A sample containing the input and output of the evaluation run.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    input: list[InputItem1]
    """
    An array of input messages.
    """
    output: list[OutputItem]
    """
    An array of output messages.
    """
    finish_reason: str
    """
    The reason why the sample generation was finished.
    """
    model: str
    """
    The model used for generating the sample.
    """
    usage: Usage1
    """
    Token usage details for the sample.
    """
    error: EvalApiError
    temperature: float
    """
    The sampling temperature used.
    """
    max_completion_tokens: int
    """
    The maximum number of tokens allowed for completion.
    """
    top_p: float
    """
    The top_p value used for sampling.
    """
    seed: int
    """
    The seed used for generating the sample.
    """


class EvalRunOutputItem(BaseModel):
    """
    A schema representing an evaluation run output item.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["eval.run.output_item"] = "eval.run.output_item"
    """
    The type of the object. Always "eval.run.output_item".
    """
    id: str
    """
    Unique identifier for the evaluation run output item.
    """
    run_id: str
    """
    The identifier of the evaluation run associated with this output item.
    """
    eval_id: str
    """
    The identifier of the evaluation group.
    """
    created_at: int
    """
    Unix timestamp (in seconds) when the evaluation run was created.
    """
    status: str
    """
    The status of the evaluation run.
    """
    datasource_item_id: int
    """
    The identifier for the data source item.
    """
    datasource_item: dict[str, Any]
    """
    Details of the input data source item.
    """
    results: list[dict[str, Any]]
    """
    A list of results from the evaluation run.
    """
    sample: Sample
    """
    A sample containing the input and output of the evaluation run.
    """


class EvalRunOutputItemList(BaseModel):
    """
    An object representing a list of output items for an evaluation run.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    """
    The type of this object. It is always set to "list".

    """
    data: list[EvalRunOutputItem]
    """
    An array of eval run output item objects.

    """
    first_id: str
    """
    The identifier of the first eval run output item in the data array.
    """
    last_id: str
    """
    The identifier of the last eval run output item in the data array.
    """
    has_more: bool
    """
    Indicates whether there are more eval run output items available.
    """


class EvalStringCheckGrader(BaseModel):
    """
    A StringCheckGrader object that performs a string comparison between input and reference using a specified operation.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["string_check"] = "string_check"
    """
    The object type, which is always `string_check`.
    """
    name: str
    """
    The name of the grader.
    """
    input: str
    """
    The input text. This may include template strings.
    """
    reference: str
    """
    The reference text. This may include template strings.
    """
    operation: Literal["eq", "ne", "like", "ilike"]
    """
    The string check operation to perform. One of `eq`, `ne`, `like`, or `ilike`.
    """


class EvalTextSimilarityGrader(BaseModel):
    """
    A TextSimilarityGrader object which grades text based on similarity metrics.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["text_similarity"] = "text_similarity"
    """
    The type of grader.
    """
    name: str | None = None
    """
    The name of the grader.
    """
    input: str
    """
    The text being graded.
    """
    reference: str
    """
    The text being graded against.
    """
    pass_threshold: float
    """
    A float score where a value greater than or equal indicates a passing grade.
    """
    evaluation_metric: Literal[
        "fuzzy_match",
        "bleu",
        "gleu",
        "meteor",
        "rouge_1",
        "rouge_2",
        "rouge_3",
        "rouge_4",
        "rouge_5",
        "rouge_l",
    ]
    """
    The evaluation metric to use. One of `fuzzy_match`, `bleu`, `gleu`, `meteor`, `rouge_1`, `rouge_2`, `rouge_3`, `rouge_4`, `rouge_5`, or `rouge_l`.
    """


class FilePath(BaseModel):
    """
    A path to a file.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["FilePath"] = "FilePath"
    """
    The type of the file path. Always `file_path`.

    """
    file_id: str
    """
    The ID of the file.

    """
    index: int
    """
    The index of the file in the list of files.

    """


class FileSearchRanker(RootModel[Literal["auto", "default_2024_08_21"]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal["auto", "default_2024_08_21"]
    """
    The ranker to use for the file search. If not specified will use the `auto` ranker.
    """


class FileSearchRankingOptions(BaseModel):
    """
    The ranking options for the file search. If not specified, the file search tool will use the `auto` ranker and a score_threshold of 0.

    See the [file search tool documentation](/docs/assistants/tools/file-search#customizing-file-search-settings) for more information.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    ranker: FileSearchRanker | None = None
    score_threshold: float = Field(..., ge=0.0, le=1.0)
    """
    The score threshold for the file search. All values must be a floating point number between 0 and 1.
    """


class FineTuneCompletionRequestInput(BaseModel):
    """
    The per-line training example of a fine-tuning input file for completions models
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    prompt: str | None = None
    """
    The input prompt for this training example.
    """
    completion: str | None = None
    """
    The desired completion for this training example.
    """


class Beta(RootModel[float]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: float = Field(..., gt=0.0, le=2.0)
    """
    The beta value for the DPO method. A higher beta value will increase the weight of the penalty between the policy and reference model.

    """


class BatchSize1(RootModel[int]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: int = Field(..., ge=1, le=256)
    """
    Number of examples in each batch. A larger batch size means that model parameters are updated less frequently, but with lower variance.

    """


class LearningRateMultiplier1(RootModel[float]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: float = Field(..., gt=0.0)
    """
    Scaling factor for the learning rate. A smaller learning rate may be useful to avoid overfitting.

    """


class NEpochs1(RootModel[int]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: int = Field(..., ge=1, le=50)
    """
    The number of epochs to train the model for. An epoch refers to one full cycle through the training dataset.

    """


class Hyperparameters1(BaseModel):
    """
    The hyperparameters used for the fine-tuning job.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    beta: Literal["auto"] | Beta | None = "auto"
    """
    The beta value for the DPO method. A higher beta value will increase the weight of the penalty between the policy and reference model.

    """
    batch_size: Literal["auto"] | BatchSize1 | None = "auto"
    """
    Number of examples in each batch. A larger batch size means that model parameters are updated less frequently, but with lower variance.

    """
    learning_rate_multiplier: (
        Literal["auto"] | LearningRateMultiplier1 | None
    ) = "auto"
    """
    Scaling factor for the learning rate. A smaller learning rate may be useful to avoid overfitting.

    """
    n_epochs: Literal["auto"] | NEpochs1 | None = "auto"
    """
    The number of epochs to train the model for. An epoch refers to one full cycle through the training dataset.

    """


class FineTuneDPOMethod(BaseModel):
    """
    Configuration for the DPO fine-tuning method.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    hyperparameters: Hyperparameters1 | None = None
    """
    The hyperparameters used for the fine-tuning job.
    """


class Hyperparameters2(BaseModel):
    """
    The hyperparameters used for the fine-tuning job.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    batch_size: Literal["auto"] | BatchSize1 | None = "auto"
    """
    Number of examples in each batch. A larger batch size means that model parameters are updated less frequently, but with lower variance.

    """
    learning_rate_multiplier: (
        Literal["auto"] | LearningRateMultiplier1 | None
    ) = "auto"
    """
    Scaling factor for the learning rate. A smaller learning rate may be useful to avoid overfitting.

    """
    n_epochs: Literal["auto"] | NEpochs1 | None = "auto"
    """
    The number of epochs to train the model for. An epoch refers to one full cycle through the training dataset.

    """


class FineTuneSupervisedMethod(BaseModel):
    """
    Configuration for the supervised fine-tuning method.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    hyperparameters: Hyperparameters2 | None = None
    """
    The hyperparameters used for the fine-tuning job.
    """


class FineTuningCheckpointPermission(BaseModel):
    """
    The `checkpoint.permission` object represents a permission for a fine-tuned model checkpoint.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The permission identifier, which can be referenced in the API endpoints.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the permission was created.
    """
    project_id: str
    """
    The project identifier that the permission is for.
    """
    object: Literal["checkpoint.permission"] = "checkpoint.permission"
    """
    The object type, which is always "checkpoint.permission".
    """


class FineTuningIntegration(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["wandb"] = "wandb"
    """
    The type of the integration being enabled for the fine-tuning job
    """
    wandb: Wandb
    """
    The settings for your integration with Weights and Biases. This payload specifies the project that
    metrics will be sent to. Optionally, you can set an explicit display name for your run, add tags
    to your run, and set a default entity (team, username, etc) to be associated with your run.

    """


class Error2(BaseModel):
    """
    For fine-tuning jobs that have `failed`, this will contain more information on the cause of the failure.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code: str
    """
    A machine-readable error code.
    """
    message: str
    """
    A human-readable error message.
    """
    param: str
    """
    The parameter that was invalid, usually `training_file` or `validation_file`. This field will be null if the failure was not parameter-specific.
    """


class BatchSize3(RootModel[int]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: int = Field(..., ge=1, le=256)
    """
    Number of examples in each batch. A larger batch size means that model parameters
    are updated less frequently, but with lower variance.

    """


class LearningRateMultiplier3(RootModel[float]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: float = Field(..., gt=0.0)
    """
    Scaling factor for the learning rate. A smaller learning rate may be useful to avoid
    overfitting.

    """


class NEpochs3(RootModel[int]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: int = Field(..., ge=1, le=50)
    """
    The number of epochs to train the model for. An epoch refers to one full cycle
    through the training dataset.

    """


class Hyperparameters3(BaseModel):
    """
    The hyperparameters used for the fine-tuning job. This value will only be returned when running `supervised` jobs.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    batch_size: Literal["auto"] | BatchSize3 | None = "auto"
    """
    Number of examples in each batch. A larger batch size means that model parameters
    are updated less frequently, but with lower variance.

    """
    learning_rate_multiplier: (
        Literal["auto"] | LearningRateMultiplier3 | None
    ) = "auto"
    """
    Scaling factor for the learning rate. A smaller learning rate may be useful to avoid
    overfitting.

    """
    n_epochs: Literal["auto"] | NEpochs3 | None = "auto"
    """
    The number of epochs to train the model for. An epoch refers to one full cycle
    through the training dataset.

    """


class Metrics(BaseModel):
    """
    Metrics at the step number during the fine-tuning job.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    step: float | None = None
    train_loss: float | None = None
    train_mean_token_accuracy: float | None = None
    valid_loss: float | None = None
    valid_mean_token_accuracy: float | None = None
    full_valid_loss: float | None = None
    full_valid_mean_token_accuracy: float | None = None


class FineTuningJobCheckpoint(BaseModel):
    """
    The `fine_tuning.job.checkpoint` object represents a model checkpoint for a fine-tuning job that is ready to use.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The checkpoint identifier, which can be referenced in the API endpoints.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the checkpoint was created.
    """
    fine_tuned_model_checkpoint: str
    """
    The name of the fine-tuned checkpoint model that is created.
    """
    step_number: int
    """
    The step number that the checkpoint was created at.
    """
    metrics: Metrics
    """
    Metrics at the step number during the fine-tuning job.
    """
    fine_tuning_job_id: str
    """
    The name of the fine-tuning job that this checkpoint was created from.
    """
    object: Literal["fine_tuning.job.checkpoint"] = (
        "fine_tuning.job.checkpoint"
    )
    """
    The object type, which is always "fine_tuning.job.checkpoint".
    """


class FineTuningJobEvent(BaseModel):
    """
    Fine-tuning job event object
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["fine_tuning.job.event"] = "fine_tuning.job.event"
    """
    The object type, which is always "fine_tuning.job.event".
    """
    id: str
    """
    The object identifier.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the fine-tuning job was created.
    """
    level: Literal["info", "warn", "error"]
    """
    The log level of the event.
    """
    message: str
    """
    The message of the event.
    """
    type: Literal["message", "metrics"] | None = None
    """
    The type of event.
    """
    data: dict[str, Any] | None = None
    """
    The data associated with the event.
    """


class FunctionParameters(BaseModel):
    """
    The parameters the functions accepts, described as a JSON Schema object. See the [guide](/docs/guides/function-calling) for examples, and the [JSON Schema reference](https://json-schema.org/understanding-json-schema/) for documentation about the format.

    Omitting `parameters` defines a function with an empty parameter list.
    """

    model_config = ConfigDict(
        extra="allow",
        populate_by_name=True,
    )


class FunctionToolCall(BaseModel):
    """
    A tool call to run a function. See the
    [function calling guide](/docs/guides/function-calling) for more information.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The unique ID of the function tool call.

    """
    type: Literal["FunctionToolCall"] = "FunctionToolCall"
    """
    The type of the function tool call. Always `function_call`.

    """
    call_id: str
    """
    The unique ID of the function tool call generated by the model.

    """
    name: str
    """
    The name of the function to run.

    """
    arguments: str
    """
    A JSON string of the arguments to pass to the function.

    """
    status: Literal["in_progress", "completed", "incomplete"] | None = None
    """
    The status of the item. One of `in_progress`, `completed`, or
    `incomplete`. Populated when items are returned via API.

    """


class FunctionToolCallOutput(BaseModel):
    """
    The output of a function tool call.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The unique ID of the function tool call output. Populated when this item
    is returned via API.

    """
    type: Literal["function_call_output"] = "function_call_output"
    """
    The type of the function tool call output. Always `function_call_output`.

    """
    call_id: str
    """
    The unique ID of the function tool call generated by the model.

    """
    output: str
    """
    A JSON string of the output of the function tool call.

    """
    status: Literal["in_progress", "completed", "incomplete"] | None = None
    """
    The status of the item. One of `in_progress`, `completed`, or
    `incomplete`. Populated when items are returned via API.

    """


class FunctionToolCallOutputResource(FunctionToolCallOutput):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The unique ID of the function call tool output.

    """
    type: Literal["FunctionToolCallOutputResource"] = (
        "FunctionToolCallOutputResource"
    )


class FunctionToolCallResource(FunctionToolCall):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The unique ID of the function tool call.

    """
    type: Literal["FunctionToolCallResource"] = "FunctionToolCallResource"


class Image1(BaseModel):
    """
    Represents the content or the URL of an image generated by the OpenAI API.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    b64_json: str | None = None
    """
    The base64-encoded JSON of the generated image. Default value for `gpt-image-1`, and only present if `response_format` is set to `b64_json` for `dall-e-2` and `dall-e-3`.
    """
    url: str | None = None
    """
    When using `dall-e-2` or `dall-e-3`, the URL of the generated image if `response_format` is set to `url` (default value). Unsupported for `gpt-image-1`.
    """
    revised_prompt: str | None = None
    """
    For `dall-e-3` only, the revised prompt that was used to generate the image.
    """


class InputTokensDetails(BaseModel):
    """
    The input tokens detailed information for the image generation.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    text_tokens: int
    """
    The number of text tokens in the input prompt.
    """
    image_tokens: int
    """
    The number of image tokens in the input prompt.
    """


class Usage2(BaseModel):
    """
    For `gpt-image-1` only, the token usage information for the image generation.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    total_tokens: int
    """
    The total number of tokens (images and text) used for the image generation.
    """
    input_tokens: int
    """
    The number of tokens (images and text) in the input prompt.
    """
    output_tokens: int
    """
    The number of image tokens in the output image.
    """
    input_tokens_details: InputTokensDetails
    """
    The input tokens detailed information for the image generation.
    """


class ImagesResponse(BaseModel):
    """
    The response from the image generation endpoint.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    created: int
    """
    The Unix timestamp (in seconds) of when the image was created.
    """
    data: list[Image1] | None = None
    """
    The list of generated images.
    """
    usage: Usage2 | None = None
    """
    For `gpt-image-1` only, the token usage information for the image generation.

    """


class Includable(
    RootModel[
        Literal[
            "file_search_call.results",
            "message.input_image.image_url",
            "computer_call_output.output.image_url",
        ]
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal[
        "file_search_call.results",
        "message.input_image.image_url",
        "computer_call_output.output.image_url",
    ]
    """
    Specify additional output data to include in the model response. Currently
    supported values are:
    - `file_search_call.results`: Include the search results of
      the file search tool call.
    - `message.input_image.image_url`: Include image urls from the input message.
    - `computer_call_output.output.image_url`: Include image urls from the computer call output.

    """


class InputAudio1(BaseModel):
    """
    An audio input to the model.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["input_audio"] = "input_audio"
    """
    The type of the input item. Always `input_audio`.

    """
    data: str
    """
    Base64-encoded audio data.

    """
    format: Literal["mp3", "wav"]
    """
    The format of the audio data. Currently supported formats are `mp3` and
    `wav`.

    """


class Project1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    Project's public ID
    """
    role: Literal["member", "owner"] | None = None
    """
    Project membership role
    """


class Invite(BaseModel):
    """
    Represents an individual `invite` to the organization.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.invite"] = "organization.invite"
    """
    The object type, which is always `organization.invite`
    """
    id: str
    """
    The identifier, which can be referenced in API endpoints
    """
    email: str
    """
    The email address of the individual to whom the invite was sent
    """
    role: Literal["owner", "reader"]
    """
    `owner` or `reader`
    """
    status: Literal["accepted", "expired", "pending"]
    """
    `accepted`,`expired`, or `pending`
    """
    invited_at: int
    """
    The Unix timestamp (in seconds) of when the invite was sent.
    """
    expires_at: int
    """
    The Unix timestamp (in seconds) of when the invite expires.
    """
    accepted_at: int | None = None
    """
    The Unix timestamp (in seconds) of when the invite was accepted.
    """
    projects: list[Project1] | None = None
    """
    The projects that were granted membership upon acceptance of the invite.
    """


class InviteDeleteResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.invite.deleted"] = (
        "organization.invite.deleted"
    )
    """
    The object type, which is always `organization.invite.deleted`
    """
    id: str
    deleted: bool


class InviteListResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    """
    The object type, which is always `list`
    """
    data: list[Invite]
    first_id: str | None = None
    """
    The first `invite_id` in the retrieved `list`
    """
    last_id: str | None = None
    """
    The last `invite_id` in the retrieved `list`
    """
    has_more: bool | None = None
    """
    The `has_more` property is used for pagination to indicate there are additional results.
    """


class Project2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    Project's public ID
    """
    role: Literal["member", "owner"]
    """
    Project membership role
    """


class InviteRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    email: str
    """
    Send an email to this address
    """
    role: Literal["reader", "owner"]
    """
    `owner` or `reader`
    """
    projects: list[Project2] | None = None
    """
    An array of projects to which membership is granted at the same time the org invite is accepted. If omitted, the user will be invited to the default project for compatibility with legacy behavior.
    """


class KeyPress(BaseModel):
    """
    A collection of keypresses the model would like to perform.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["keypress"] = "keypress"
    """
    Specifies the event type. For a keypress action, this property is 
    always set to `keypress`.

    """
    keys: list[str]
    """
    The combination of keys the model is requesting to be pressed. This is an
    array of strings, each representing a key.

    """


class ListCertificatesResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: list[Certificate2]
    first_id: str | None = Field(None, examples=["cert_abc"])
    last_id: str | None = Field(None, examples=["cert_abc"])
    has_more: bool
    object: Literal["list"] = "list"


class ListFineTuningCheckpointPermissionResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: list[FineTuningCheckpointPermission]
    object: Literal["list"] = "list"
    first_id: str | None = None
    last_id: str | None = None
    has_more: bool


class ListFineTuningJobCheckpointsResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: list[FineTuningJobCheckpoint]
    object: Literal["list"] = "list"
    first_id: str | None = None
    last_id: str | None = None
    has_more: bool


class ListFineTuningJobEventsResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: list[FineTuningJobEvent]
    object: Literal["list"] = "list"
    has_more: bool


class LogProbProperties(BaseModel):
    """
    A log probability object.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    token: str
    """
    The token that was used to generate the log probability.

    """
    logprob: float
    """
    The log probability of the token.

    """
    bytes: list[int]
    """
    The bytes that were used to generate the log probability.

    """


class ImageFile(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_id: str
    """
    The [File](/docs/api-reference/files) ID of the image in the message content. Set `purpose="vision"` when uploading the File if you need to later display the file content.
    """
    detail: Literal["auto", "low", "high"] | None = "auto"
    """
    Specifies the detail level of the image if specified by the user. `low` uses fewer tokens, you can opt in to high resolution using `high`.
    """


class MessageContentImageFileObject(BaseModel):
    """
    References an image [File](/docs/api-reference/files) in the content of a message.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["image_file"] = "image_file"
    """
    Always `image_file`.
    """
    image_file: ImageFile


class ImageUrl2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    url: AnyUrl
    """
    The external URL of the image, must be a supported image types: jpeg, jpg, png, gif, webp.
    """
    detail: Literal["auto", "low", "high"] | None = "auto"
    """
    Specifies the detail level of the image. `low` uses fewer tokens, you can opt in to high resolution using `high`. Default value is `auto`
    """


class MessageContentImageUrlObject(BaseModel):
    """
    References an image URL in the content of a message.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["image_url"] = "image_url"
    """
    The type of the content part.
    """
    image_url: ImageUrl2


class MessageContentRefusalObject(BaseModel):
    """
    The refusal content generated by the assistant.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["refusal"] = "refusal"
    """
    Always `refusal`.
    """
    refusal: str


class FileCitation(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_id: str
    """
    The ID of the specific File the citation is from.
    """


class MessageContentTextAnnotationsFileCitationObject(BaseModel):
    """
    A citation within the message that points to a specific quote from a specific File associated with the assistant or the message. Generated when the assistant uses the "file_search" tool to search files.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["file_citation"] = "file_citation"
    """
    Always `file_citation`.
    """
    text: str
    """
    The text in the message content that needs to be replaced.
    """
    file_citation: FileCitation
    start_index: int = Field(..., ge=0)
    end_index: int = Field(..., ge=0)


class FilePath1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_id: str
    """
    The ID of the file that was generated.
    """


class MessageContentTextAnnotationsFilePathObject(BaseModel):
    """
    A URL for the file that's generated when the assistant used the `code_interpreter` tool to generate a file.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["file_path"] = "file_path"
    """
    Always `file_path`.
    """
    text: str
    """
    The text in the message content that needs to be replaced.
    """
    file_path: FilePath1
    start_index: int = Field(..., ge=0)
    end_index: int = Field(..., ge=0)


class Text(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    value: str
    """
    The data that makes up the text.
    """
    annotations: list[
        MessageContentTextAnnotationsFileCitationObject
        | MessageContentTextAnnotationsFilePathObject
    ]


class MessageContentTextObject(BaseModel):
    """
    The text content that is part of a message.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["text"] = "text"
    """
    Always `text`.
    """
    text: Text


class ImageFile1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_id: str | None = None
    """
    The [File](/docs/api-reference/files) ID of the image in the message content. Set `purpose="vision"` when uploading the File if you need to later display the file content.
    """
    detail: Literal["auto", "low", "high"] | None = "auto"
    """
    Specifies the detail level of the image if specified by the user. `low` uses fewer tokens, you can opt in to high resolution using `high`.
    """


class MessageDeltaContentImageFileObject(BaseModel):
    """
    References an image [File](/docs/api-reference/files) in the content of a message.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the content part in the message.
    """
    type: Literal["image_file"] = "image_file"
    """
    Always `image_file`.
    """
    image_file: ImageFile1 | None = None


class ImageUrl3(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    url: str | None = None
    """
    The URL of the image, must be a supported image types: jpeg, jpg, png, gif, webp.
    """
    detail: Literal["auto", "low", "high"] | None = "auto"
    """
    Specifies the detail level of the image. `low` uses fewer tokens, you can opt in to high resolution using `high`.
    """


class MessageDeltaContentImageUrlObject(BaseModel):
    """
    References an image URL in the content of a message.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the content part in the message.
    """
    type: Literal["image_url"] = "image_url"
    """
    Always `image_url`.
    """
    image_url: ImageUrl3 | None = None


class MessageDeltaContentRefusalObject(BaseModel):
    """
    The refusal content that is part of a message.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the refusal part in the message.
    """
    type: Literal["refusal"] = "refusal"
    """
    Always `refusal`.
    """
    refusal: str | None = None


class FileCitation1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_id: str | None = None
    """
    The ID of the specific File the citation is from.
    """
    quote: str | None = None
    """
    The specific quote in the file.
    """


class MessageDeltaContentTextAnnotationsFileCitationObject(BaseModel):
    """
    A citation within the message that points to a specific quote from a specific File associated with the assistant or the message. Generated when the assistant uses the "file_search" tool to search files.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the annotation in the text content part.
    """
    type: Literal["file_citation"] = "file_citation"
    """
    Always `file_citation`.
    """
    text: str | None = None
    """
    The text in the message content that needs to be replaced.
    """
    file_citation: FileCitation1 | None = None
    start_index: int | None = Field(None, ge=0)
    end_index: int | None = Field(None, ge=0)


class FilePath2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_id: str | None = None
    """
    The ID of the file that was generated.
    """


class MessageDeltaContentTextAnnotationsFilePathObject(BaseModel):
    """
    A URL for the file that's generated when the assistant used the `code_interpreter` tool to generate a file.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the annotation in the text content part.
    """
    type: Literal["file_path"] = "file_path"
    """
    Always `file_path`.
    """
    text: str | None = None
    """
    The text in the message content that needs to be replaced.
    """
    file_path: FilePath2 | None = None
    start_index: int | None = Field(None, ge=0)
    end_index: int | None = Field(None, ge=0)


class Text1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    value: str | None = None
    """
    The data that makes up the text.
    """
    annotations: (
        list[
            MessageDeltaContentTextAnnotationsFileCitationObject
            | MessageDeltaContentTextAnnotationsFilePathObject
        ]
        | None
    ) = None


class MessageDeltaContentTextObject(BaseModel):
    """
    The text content that is part of a message.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the content part in the message.
    """
    type: Literal["text"] = "text"
    """
    Always `text`.
    """
    text: Text1 | None = None


class Delta(BaseModel):
    """
    The delta containing the fields that have changed on the Message.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: Literal["user", "assistant"] | None = None
    """
    The entity that produced the message. One of `user` or `assistant`.
    """
    content: (
        list[
            MessageDeltaContentImageFileObject
            | MessageDeltaContentTextObject
            | MessageDeltaContentRefusalObject
            | MessageDeltaContentImageUrlObject
        ]
        | None
    ) = None
    """
    The content of the message in array of text and/or images.
    """


class MessageDeltaObject(BaseModel):
    """
    Represents a message delta i.e. any changed fields on a message during streaming.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier of the message, which can be referenced in API endpoints.
    """
    object: Literal["thread.message.delta"] = "thread.message.delta"
    """
    The object type, which is always `thread.message.delta`.
    """
    delta: Delta
    """
    The delta containing the fields that have changed on the Message.
    """


class IncompleteDetails(BaseModel):
    """
    On an incomplete message, details about why the message is incomplete.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    reason: Literal[
        "content_filter",
        "max_tokens",
        "run_cancelled",
        "run_expired",
        "run_failed",
    ]
    """
    The reason the message is incomplete.
    """


class MessageRequestContentTextObject(BaseModel):
    """
    The text content that is part of a message.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["text"] = "text"
    """
    Always `text`.
    """
    text: str
    """
    Text content to be sent to the model
    """


class MessageStreamEvent3(BaseModel):
    """
    Occurs when parts of a [Message](/docs/api-reference/messages/object) are being streamed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.message.delta"] = "thread.message.delta"
    data: MessageDeltaObject


class Metadata(RootModel[dict[str, str] | None]):
    """
    Set of 16 key-value pairs that can be attached to an object. This can be
    useful for storing additional information about the object in a structured
    format, and querying for objects via API or the dashboard.

    Keys are strings with a maximum length of 64 characters. Values are strings
    with a maximum length of 512 characters.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: dict[str, str] | None = None


class Model(BaseModel):
    """
    Describes an OpenAI model offering that can be used with the API.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The model identifier, which can be referenced in the API endpoints.
    """
    created: int
    """
    The Unix timestamp (in seconds) when the model was created.
    """
    object: Literal["model"] = "model"
    """
    The object type, which is always "model".
    """
    owned_by: str
    """
    The organization that owns the model.
    """


class ModelIdsShared(
    RootModel[
        str
        | Literal[
            "gpt-4.1",
            "gpt-4.1-mini",
            "gpt-4.1-nano",
            "gpt-4.1-2025-04-14",
            "gpt-4.1-mini-2025-04-14",
            "gpt-4.1-nano-2025-04-14",
            "o4-mini",
            "o4-mini-2025-04-16",
            "o3",
            "o3-2025-04-16",
            "o3-mini",
            "o3-mini-2025-01-31",
            "o1",
            "o1-2024-12-17",
            "o1-preview",
            "o1-preview-2024-09-12",
            "o1-mini",
            "o1-mini-2024-09-12",
            "gpt-4o",
            "gpt-4o-2024-11-20",
            "gpt-4o-2024-08-06",
            "gpt-4o-2024-05-13",
            "gpt-4o-audio-preview",
            "gpt-4o-audio-preview-2024-10-01",
            "gpt-4o-audio-preview-2024-12-17",
            "gpt-4o-mini-audio-preview",
            "gpt-4o-mini-audio-preview-2024-12-17",
            "gpt-4o-search-preview",
            "gpt-4o-mini-search-preview",
            "gpt-4o-search-preview-2025-03-11",
            "gpt-4o-mini-search-preview-2025-03-11",
            "chatgpt-4o-latest",
            "gpt-4o-mini",
            "gpt-4o-mini-2024-07-18",
            "gpt-4-turbo",
            "gpt-4-turbo-2024-04-09",
            "gpt-4-0125-preview",
            "gpt-4-turbo-preview",
            "gpt-4-1106-preview",
            "gpt-4-vision-preview",
            "gpt-4",
            "gpt-4-0314",
            "gpt-4-0613",
            "gpt-4-32k",
            "gpt-4-32k-0314",
            "gpt-4-32k-0613",
            "gpt-3.5-turbo",
            "gpt-3.5-turbo-16k",
            "gpt-3.5-turbo-0301",
            "gpt-3.5-turbo-0613",
            "gpt-3.5-turbo-1106",
            "gpt-3.5-turbo-0125",
            "gpt-3.5-turbo-16k-0613",
        ]
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        str
        | Literal[
            "gpt-4.1",
            "gpt-4.1-mini",
            "gpt-4.1-nano",
            "gpt-4.1-2025-04-14",
            "gpt-4.1-mini-2025-04-14",
            "gpt-4.1-nano-2025-04-14",
            "o4-mini",
            "o4-mini-2025-04-16",
            "o3",
            "o3-2025-04-16",
            "o3-mini",
            "o3-mini-2025-01-31",
            "o1",
            "o1-2024-12-17",
            "o1-preview",
            "o1-preview-2024-09-12",
            "o1-mini",
            "o1-mini-2024-09-12",
            "gpt-4o",
            "gpt-4o-2024-11-20",
            "gpt-4o-2024-08-06",
            "gpt-4o-2024-05-13",
            "gpt-4o-audio-preview",
            "gpt-4o-audio-preview-2024-10-01",
            "gpt-4o-audio-preview-2024-12-17",
            "gpt-4o-mini-audio-preview",
            "gpt-4o-mini-audio-preview-2024-12-17",
            "gpt-4o-search-preview",
            "gpt-4o-mini-search-preview",
            "gpt-4o-search-preview-2025-03-11",
            "gpt-4o-mini-search-preview-2025-03-11",
            "chatgpt-4o-latest",
            "gpt-4o-mini",
            "gpt-4o-mini-2024-07-18",
            "gpt-4-turbo",
            "gpt-4-turbo-2024-04-09",
            "gpt-4-0125-preview",
            "gpt-4-turbo-preview",
            "gpt-4-1106-preview",
            "gpt-4-vision-preview",
            "gpt-4",
            "gpt-4-0314",
            "gpt-4-0613",
            "gpt-4-32k",
            "gpt-4-32k-0314",
            "gpt-4-32k-0613",
            "gpt-3.5-turbo",
            "gpt-3.5-turbo-16k",
            "gpt-3.5-turbo-0301",
            "gpt-3.5-turbo-0613",
            "gpt-3.5-turbo-1106",
            "gpt-3.5-turbo-0125",
            "gpt-3.5-turbo-16k-0613",
        ]
    ) = Field(..., examples=["gpt-4o"])


class CodeInterpreter4(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_ids: list[str] | None = Field([], max_length=20)
    """
    Overrides the list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files associated with the tool.

    """


class FileSearch7(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    vector_store_ids: list[str] | None = Field(None, max_length=1)
    """
    Overrides the [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.

    """


class ToolResources4(BaseModel):
    """
    A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code_interpreter: CodeInterpreter4 | None = None
    file_search: FileSearch7 | None = None


class ModifyCertificateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    """
    The updated name for the certificate
    """


class ModifyMessageRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    metadata: Metadata | None = None


class ModifyRunRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    metadata: Metadata | None = None


class CodeInterpreter5(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_ids: list[str] | None = Field([], max_length=20)
    """
    A list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files associated with the tool.

    """


class FileSearch8(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    vector_store_ids: list[str] | None = Field(None, max_length=1)
    """
    The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.

    """


class ToolResources5(BaseModel):
    """
    A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code_interpreter: CodeInterpreter5 | None = None
    file_search: FileSearch8 | None = None


class ModifyThreadRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    tool_resources: ToolResources5 | None = None
    """
    A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """
    metadata: Metadata | None = None


class Move(BaseModel):
    """
    A mouse move action.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["move"] = "move"
    """
    Specifies the event type. For a move action, this property is 
    always set to `move`.

    """
    x: int
    """
    The x-coordinate to move to.

    """
    y: int
    """
    The y-coordinate to move to.

    """


class OpenAIFile(BaseModel):
    """
    The `File` object represents a document that has been uploaded to OpenAI.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The file identifier, which can be referenced in the API endpoints.
    """
    bytes: int
    """
    The size of the file, in bytes.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the file was created.
    """
    expires_at: int | None = None
    """
    The Unix timestamp (in seconds) for when the file will expire.
    """
    filename: str
    """
    The name of the file.
    """
    object: Literal["file"] = "file"
    """
    The object type, which is always `file`.
    """
    purpose: Literal[
        "assistants",
        "assistants_output",
        "batch",
        "batch_output",
        "fine-tune",
        "fine-tune-results",
        "vision",
    ]
    """
    The intended purpose of the file. Supported values are `assistants`, `assistants_output`, `batch`, `batch_output`, `fine-tune`, `fine-tune-results` and `vision`.
    """
    status: Literal["uploaded", "processed", "error"]
    """
    Deprecated. The current status of the file, which can be either `uploaded`, `processed`, or `error`.
    """
    status_details: str | None = None
    """
    Deprecated. For details on why a fine-tuning training file failed validation, see the `error` field on `fine_tuning.job`.
    """


class OtherChunkingStrategyResponseParam(BaseModel):
    """
    This is returned when the chunking strategy is unknown. Typically, this is because the file was indexed before the `chunking_strategy` concept was introduced in the API.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["other"] = "other"
    """
    Always `other`.
    """


class OutputAudio(BaseModel):
    """
    An audio output from the model.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["output_audio"] = "output_audio"
    """
    The type of the output audio. Always `output_audio`.

    """
    data: str
    """
    Base64-encoded audio data from the model.

    """
    transcript: str
    """
    The transcript of the audio data from the model.

    """


class ParallelToolCalls(RootModel[bool]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: bool
    """
    Whether to enable [parallel function calling](/docs/guides/function-calling#configuring-parallel-function-calling) during tool use.
    """


class Content8(RootModel[list[ChatCompletionRequestMessageContentPartText]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[ChatCompletionRequestMessageContentPartText] = Field(
        ..., min_length=1, title="Array of content parts"
    )
    """
    An array of content parts with a defined type. Supported options differ based on the [model](/docs/models) being used to generate the response. Can contain text inputs.
    """


class PredictionContent(BaseModel):
    """
    Static predicted output content, such as the content of a text file that is
    being regenerated.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["content"] = "content"
    """
    The type of the predicted content you want to provide. This type is
    currently always `content`.

    """
    content: str | Content8
    """
    The content that should be matched when generating a model response.
    If generated tokens would match this content, the entire model response
    can be returned much more quickly.

    """


class Project3(BaseModel):
    """
    Represents an individual project.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier, which can be referenced in API endpoints
    """
    object: Literal["organization.project"] = "organization.project"
    """
    The object type, which is always `organization.project`
    """
    name: str
    """
    The name of the project. This appears in reporting.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) of when the project was created.
    """
    archived_at: int | None = None
    """
    The Unix timestamp (in seconds) of when the project was archived or `null`.
    """
    status: Literal["active", "archived"]
    """
    `active` or `archived`
    """


class ProjectApiKeyDeleteResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.project.api_key.deleted"] = (
        "organization.project.api_key.deleted"
    )
    id: str
    deleted: bool


class ProjectCreateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    """
    The friendly name of the project, this name appears in reports.
    """


class ProjectListResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    data: list[Project3]
    first_id: str
    last_id: str
    has_more: bool


class ProjectRateLimit(BaseModel):
    """
    Represents a project rate limit config.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["project.rate_limit"] = "project.rate_limit"
    """
    The object type, which is always `project.rate_limit`
    """
    id: str
    """
    The identifier, which can be referenced in API endpoints.
    """
    model: str
    """
    The model this rate limit applies to.
    """
    max_requests_per_1_minute: int
    """
    The maximum requests per minute.
    """
    max_tokens_per_1_minute: int
    """
    The maximum tokens per minute.
    """
    max_images_per_1_minute: int | None = None
    """
    The maximum images per minute. Only present for relevant models.
    """
    max_audio_megabytes_per_1_minute: int | None = None
    """
    The maximum audio megabytes per minute. Only present for relevant models.
    """
    max_requests_per_1_day: int | None = None
    """
    The maximum requests per day. Only present for relevant models.
    """
    batch_1_day_max_input_tokens: int | None = None
    """
    The maximum batch input tokens per day. Only present for relevant models.
    """


class ProjectRateLimitListResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    data: list[ProjectRateLimit]
    first_id: str
    last_id: str
    has_more: bool


class ProjectRateLimitUpdateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    max_requests_per_1_minute: int | None = None
    """
    The maximum requests per minute.
    """
    max_tokens_per_1_minute: int | None = None
    """
    The maximum tokens per minute.
    """
    max_images_per_1_minute: int | None = None
    """
    The maximum images per minute. Only relevant for certain models.
    """
    max_audio_megabytes_per_1_minute: int | None = None
    """
    The maximum audio megabytes per minute. Only relevant for certain models.
    """
    max_requests_per_1_day: int | None = None
    """
    The maximum requests per day. Only relevant for certain models.
    """
    batch_1_day_max_input_tokens: int | None = None
    """
    The maximum batch input tokens per day. Only relevant for certain models.
    """


class ProjectServiceAccount(BaseModel):
    """
    Represents an individual service account in a project.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.project.service_account"] = (
        "organization.project.service_account"
    )
    """
    The object type, which is always `organization.project.service_account`
    """
    id: str
    """
    The identifier, which can be referenced in API endpoints
    """
    name: str
    """
    The name of the service account
    """
    role: Literal["owner", "member"]
    """
    `owner` or `member`
    """
    created_at: int
    """
    The Unix timestamp (in seconds) of when the service account was created
    """


class ProjectServiceAccountApiKey(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.project.service_account.api_key"] = (
        "organization.project.service_account.api_key"
    )
    """
    The object type, which is always `organization.project.service_account.api_key`
    """
    value: str
    name: str
    created_at: int
    id: str


class ProjectServiceAccountCreateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    """
    The name of the service account being created.
    """


class ProjectServiceAccountCreateResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.project.service_account"] = (
        "organization.project.service_account"
    )
    id: str
    name: str
    role: Literal["member"] = "member"
    """
    Service accounts can only have one role of type `member`
    """
    created_at: int
    api_key: ProjectServiceAccountApiKey


class ProjectServiceAccountDeleteResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.project.service_account.deleted"] = (
        "organization.project.service_account.deleted"
    )
    id: str
    deleted: bool


class ProjectServiceAccountListResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    data: list[ProjectServiceAccount]
    first_id: str
    last_id: str
    has_more: bool


class ProjectUpdateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    """
    The updated name of the project, this name appears in reports.
    """


class ProjectUser(BaseModel):
    """
    Represents an individual user in a project.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.project.user"] = "organization.project.user"
    """
    The object type, which is always `organization.project.user`
    """
    id: str
    """
    The identifier, which can be referenced in API endpoints
    """
    name: str
    """
    The name of the user
    """
    email: str
    """
    The email address of the user
    """
    role: Literal["owner", "member"]
    """
    `owner` or `member`
    """
    added_at: int
    """
    The Unix timestamp (in seconds) of when the project was added.
    """


class ProjectUserCreateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    user_id: str
    """
    The ID of the user.
    """
    role: Literal["owner", "member"]
    """
    `owner` or `member`
    """


class ProjectUserDeleteResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.project.user.deleted"] = (
        "organization.project.user.deleted"
    )
    id: str
    deleted: bool


class ProjectUserListResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: str
    data: list[ProjectUser]
    first_id: str
    last_id: str
    has_more: bool


class ProjectUserUpdateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: Literal["owner", "member"]
    """
    `owner` or `member`
    """


class RealtimeClientEventConversationItemDelete(BaseModel):
    """
    Send this event when you want to remove any item from the conversation
    history. The server will respond with a `conversation.item.deleted` event,
    unless the item does not exist in the conversation history, in which case the
    server will respond with an error.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    Optional client-generated ID used to identify this event.
    """
    type: Literal["RealtimeClientEventConversationItemDelete"] = (
        "RealtimeClientEventConversationItemDelete"
    )
    """
    The event type, must be `conversation.item.delete`.
    """
    item_id: str
    """
    The ID of the item to delete.
    """


class RealtimeClientEventConversationItemRetrieve(BaseModel):
    """
    Send this event when you want to retrieve the server's representation of a specific item in the conversation history. This is useful, for example, to inspect user audio after noise cancellation and VAD.
    The server will respond with a `conversation.item.retrieved` event,
    unless the item does not exist in the conversation history, in which case the
    server will respond with an error.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    Optional client-generated ID used to identify this event.
    """
    type: Literal["RealtimeClientEventConversationItemRetrieve"] = (
        "RealtimeClientEventConversationItemRetrieve"
    )
    """
    The event type, must be `conversation.item.retrieve`.
    """
    item_id: str
    """
    The ID of the item to retrieve.
    """


class RealtimeClientEventConversationItemTruncate(BaseModel):
    """
    Send this event to truncate a previous assistant message’s audio. The server
    will produce audio faster than realtime, so this event is useful when the user
    interrupts to truncate audio that has already been sent to the client but not
    yet played. This will synchronize the server's understanding of the audio with
    the client's playback.

    Truncating audio will delete the server-side text transcript to ensure there
    is not text in the context that hasn't been heard by the user.

    If successful, the server will respond with a `conversation.item.truncated`
    event.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    Optional client-generated ID used to identify this event.
    """
    type: Literal["RealtimeClientEventConversationItemTruncate"] = (
        "RealtimeClientEventConversationItemTruncate"
    )
    """
    The event type, must be `conversation.item.truncate`.
    """
    item_id: str
    """
    The ID of the assistant message item to truncate. Only assistant message 
    items can be truncated.

    """
    content_index: int
    """
    The index of the content part to truncate. Set this to 0.
    """
    audio_end_ms: int
    """
    Inclusive duration up to which audio is truncated, in milliseconds. If 
    the audio_end_ms is greater than the actual audio duration, the server 
    will respond with an error.

    """


class RealtimeClientEventInputAudioBufferAppend(BaseModel):
    """
    Send this event to append audio bytes to the input audio buffer. The audio
    buffer is temporary storage you can write to and later commit. In Server VAD
    mode, the audio buffer is used to detect speech and the server will decide
    when to commit. When Server VAD is disabled, you must commit the audio buffer
    manually.

    The client may choose how much audio to place in each event up to a maximum
    of 15 MiB, for example streaming smaller chunks from the client may allow the
    VAD to be more responsive. Unlike made other client events, the server will
    not send a confirmation response to this event.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    Optional client-generated ID used to identify this event.
    """
    type: Literal["RealtimeClientEventInputAudioBufferAppend"] = (
        "RealtimeClientEventInputAudioBufferAppend"
    )
    """
    The event type, must be `input_audio_buffer.append`.
    """
    audio: str
    """
    Base64-encoded audio bytes. This must be in the format specified by the 
    `input_audio_format` field in the session configuration.

    """


class RealtimeClientEventInputAudioBufferClear(BaseModel):
    """
    Send this event to clear the audio bytes in the buffer. The server will
    respond with an `input_audio_buffer.cleared` event.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    Optional client-generated ID used to identify this event.
    """
    type: Literal["RealtimeClientEventInputAudioBufferClear"] = (
        "RealtimeClientEventInputAudioBufferClear"
    )
    """
    The event type, must be `input_audio_buffer.clear`.
    """


class RealtimeClientEventInputAudioBufferCommit(BaseModel):
    """
    Send this event to commit the user input audio buffer, which will create a
    new user message item in the conversation. This event will produce an error
    if the input audio buffer is empty. When in Server VAD mode, the client does
    not need to send this event, the server will commit the audio buffer
    automatically.

    Committing the input audio buffer will trigger input audio transcription
    (if enabled in session configuration), but it will not create a response
    from the model. The server will respond with an `input_audio_buffer.committed`
    event.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    Optional client-generated ID used to identify this event.
    """
    type: Literal["RealtimeClientEventInputAudioBufferCommit"] = (
        "RealtimeClientEventInputAudioBufferCommit"
    )
    """
    The event type, must be `input_audio_buffer.commit`.
    """


class RealtimeClientEventOutputAudioBufferClear(BaseModel):
    """
    **WebRTC Only:** Emit to cut off the current audio response. This will trigger the server to
    stop generating audio and emit a `output_audio_buffer.cleared` event. This
    event should be preceded by a `response.cancel` client event to stop the
    generation of the current response.
    [Learn more](/docs/guides/realtime-model-capabilities#client-and-server-events-for-audio-in-webrtc).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    The unique ID of the client event used for error handling.
    """
    type: Literal["RealtimeClientEventOutputAudioBufferClear"] = (
        "RealtimeClientEventOutputAudioBufferClear"
    )
    """
    The event type, must be `output_audio_buffer.clear`.
    """


class RealtimeClientEventResponseCancel(BaseModel):
    """
    Send this event to cancel an in-progress response. The server will respond
    with a `response.cancelled` event or an error if there is no response to
    cancel.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    Optional client-generated ID used to identify this event.
    """
    type: Literal["RealtimeClientEventResponseCancel"] = (
        "RealtimeClientEventResponseCancel"
    )
    """
    The event type, must be `response.cancel`.
    """
    response_id: str | None = None
    """
    A specific response ID to cancel - if not provided, will cancel an 
    in-progress response in the default conversation.

    """


class ContentItem1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: (
        Literal["input_audio", "input_text", "item_reference", "text"] | None
    ) = None
    """
    The content type (`input_text`, `input_audio`, `item_reference`, `text`).

    """
    text: str | None = None
    """
    The text content, used for `input_text` and `text` content types.

    """
    id: str | None = None
    """
    ID of a previous conversation item to reference (for `item_reference`
    content types in `response.create` events). These can reference both
    client and server created items.

    """
    audio: str | None = None
    """
    Base64-encoded audio bytes, used for `input_audio` content type.

    """
    transcript: str | None = None
    """
    The transcript of the audio, used for `input_audio` content type.

    """


class RealtimeConversationItem(BaseModel):
    """
    The item to add to the conversation.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The unique ID of the item, this can be generated by the client to help 
    manage server-side context, but is not required because the server will 
    generate one if not provided.

    """
    type: (
        Literal["message", "function_call", "function_call_output"] | None
    ) = None
    """
    The type of the item (`message`, `function_call`, `function_call_output`).

    """
    object: Literal["realtime.item"] | None = None
    """
    Identifier for the API object being returned - always `realtime.item`.

    """
    status: Literal["completed", "incomplete"] | None = None
    """
    The status of the item (`completed`, `incomplete`). These have no effect 
    on the conversation, but are accepted for consistency with the 
    `conversation.item.created` event.

    """
    role: Literal["user", "assistant", "system"] | None = None
    """
    The role of the message sender (`user`, `assistant`, `system`), only 
    applicable for `message` items.

    """
    content: list[ContentItem1] | None = None
    """
    The content of the message, applicable for `message` items. 
    - Message items of role `system` support only `input_text` content
    - Message items of role `user` support `input_text` and `input_audio` 
      content
    - Message items of role `assistant` support `text` content.

    """
    call_id: str | None = None
    """
    The ID of the function call (for `function_call` and 
    `function_call_output` items). If passed on a `function_call_output` 
    item, the server will check that a `function_call` item with the same 
    ID exists in the conversation history.

    """
    name: str | None = None
    """
    The name of the function being called (for `function_call` items).

    """
    arguments: str | None = None
    """
    The arguments of the function call (for `function_call` items).

    """
    output: str | None = None
    """
    The output of the function call (for `function_call_output` items).

    """


class RealtimeConversationItemWithReference(BaseModel):
    """
    The item to add to the conversation.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    For an item of type (`message` | `function_call` | `function_call_output`)
    this field allows the client to assign the unique ID of the item. It is
    not required because the server will generate one if not provided.

    For an item of type `item_reference`, this field is required and is a
    reference to any item that has previously existed in the conversation.

    """
    type: (
        Literal["message", "function_call", "function_call_output"] | None
    ) = None
    """
    The type of the item (`message`, `function_call`, `function_call_output`, `item_reference`).

    """
    object: Literal["realtime.item"] | None = None
    """
    Identifier for the API object being returned - always `realtime.item`.

    """
    status: Literal["completed", "incomplete"] | None = None
    """
    The status of the item (`completed`, `incomplete`). These have no effect 
    on the conversation, but are accepted for consistency with the 
    `conversation.item.created` event.

    """
    role: Literal["user", "assistant", "system"] | None = None
    """
    The role of the message sender (`user`, `assistant`, `system`), only 
    applicable for `message` items.

    """
    content: list[ContentItem1] | None = None
    """
    The content of the message, applicable for `message` items. 
    - Message items of role `system` support only `input_text` content
    - Message items of role `user` support `input_text` and `input_audio` 
      content
    - Message items of role `assistant` support `text` content.

    """
    call_id: str | None = None
    """
    The ID of the function call (for `function_call` and 
    `function_call_output` items). If passed on a `function_call_output` 
    item, the server will check that a `function_call` item with the same 
    ID exists in the conversation history.

    """
    name: str | None = None
    """
    The name of the function being called (for `function_call` items).

    """
    arguments: str | None = None
    """
    The arguments of the function call (for `function_call` items).

    """
    output: str | None = None
    """
    The output of the function call (for `function_call_output` items).

    """


class Error3(BaseModel):
    """
    A description of the error that caused the response to fail,
    populated when the `status` is `failed`.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: str | None = None
    """
    The type of error.
    """
    code: str | None = None
    """
    Error code, if any.
    """


class StatusDetails(BaseModel):
    """
    Additional details about the status.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["completed", "cancelled", "failed", "incomplete"] | None = (
        None
    )
    """
    The type of error that caused the response to fail, corresponding 
    with the `status` field (`completed`, `cancelled`, `incomplete`, 
    `failed`).

    """
    reason: (
        Literal[
            "turn_detected",
            "client_cancelled",
            "max_output_tokens",
            "content_filter",
        ]
        | None
    ) = None
    """
    The reason the Response did not complete. For a `cancelled` Response, 
    one of `turn_detected` (the server VAD detected a new start of speech) 
    or `client_cancelled` (the client sent a cancel event). For an 
    `incomplete` Response, one of `max_output_tokens` or `content_filter` 
    (the server-side safety filter activated and cut off the response).

    """
    error: Error3 | None = None
    """
    A description of the error that caused the response to fail, 
    populated when the `status` is `failed`.

    """


class InputTokenDetails(BaseModel):
    """
    Details about the input tokens used in the Response.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    cached_tokens: int | None = None
    """
    The number of cached tokens used in the Response.
    """
    text_tokens: int | None = None
    """
    The number of text tokens used in the Response.
    """
    audio_tokens: int | None = None
    """
    The number of audio tokens used in the Response.
    """


class OutputTokenDetails(BaseModel):
    """
    Details about the output tokens used in the Response.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    text_tokens: int | None = None
    """
    The number of text tokens used in the Response.
    """
    audio_tokens: int | None = None
    """
    The number of audio tokens used in the Response.
    """


class Usage3(BaseModel):
    """
    Usage statistics for the Response, this will correspond to billing. A
    Realtime API session will maintain a conversation context and append new
    Items to the Conversation, thus output from previous turns (text and
    audio tokens) will become the input for later turns.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    total_tokens: int | None = None
    """
    The total number of tokens in the Response including input and output 
    text and audio tokens.

    """
    input_tokens: int | None = None
    """
    The number of input tokens used in the Response, including text and 
    audio tokens.

    """
    output_tokens: int | None = None
    """
    The number of output tokens sent in the Response, including text and 
    audio tokens.

    """
    input_token_details: InputTokenDetails | None = None
    """
    Details about the input tokens used in the Response.
    """
    output_token_details: OutputTokenDetails | None = None
    """
    Details about the output tokens used in the Response.
    """


class Tool(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["function"] | None = None
    """
    The type of the tool, i.e. `function`.
    """
    name: str | None = None
    """
    The name of the function.
    """
    description: str | None = None
    """
    The description of the function, including guidance on when and how 
    to call it, and guidance about what to tell the user when calling 
    (if anything).

    """
    parameters: dict[str, Any] | None = None
    """
    Parameters of the function in JSON Schema.
    """


class Conversation(BaseModel):
    """
    The conversation resource.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The unique ID of the conversation.
    """
    object: str | None = None
    """
    The object type, must be `realtime.conversation`.
    """


class RealtimeServerEventConversationCreated(BaseModel):
    """
    Returned when a conversation is created. Emitted right after session creation.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventConversationCreated"] = (
        "RealtimeServerEventConversationCreated"
    )
    """
    The event type, must be `conversation.created`.
    """
    conversation: Conversation
    """
    The conversation resource.
    """


class RealtimeServerEventConversationItemCreated(BaseModel):
    """
    Returned when a conversation item is created. There are several scenarios that produce this event:
      - The server is generating a Response, which if successful will produce
        either one or two Items, which will be of type `message`
        (role `assistant`) or type `function_call`.
      - The input audio buffer has been committed, either by the client or the
        server (in `server_vad` mode). The server will take the content of the
        input audio buffer and add it to a new user message Item.
      - The client has sent a `conversation.item.create` event to add a new Item
        to the Conversation.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventConversationItemCreated"] = (
        "RealtimeServerEventConversationItemCreated"
    )
    """
    The event type, must be `conversation.item.created`.
    """
    previous_item_id: str
    """
    The ID of the preceding item in the Conversation context, allows the 
    client to understand the order of the conversation.

    """
    item: RealtimeConversationItem


class RealtimeServerEventConversationItemDeleted(BaseModel):
    """
    Returned when an item in the conversation is deleted by the client with a
    `conversation.item.delete` event. This event is used to synchronize the
    server's understanding of the conversation history with the client's view.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventConversationItemDeleted"] = (
        "RealtimeServerEventConversationItemDeleted"
    )
    """
    The event type, must be `conversation.item.deleted`.
    """
    item_id: str
    """
    The ID of the item that was deleted.
    """


class RealtimeServerEventConversationItemInputAudioTranscriptionCompleted(
    BaseModel
):
    """
    This event is the output of audio transcription for user audio written to the
    user audio buffer. Transcription begins when the input audio buffer is
    committed by the client or server (in `server_vad` mode). Transcription runs
    asynchronously with Response creation, so this event may come before or after
    the Response events.

    Realtime API models accept audio natively, and thus input transcription is a
    separate process run on a separate ASR (Automatic Speech Recognition) model,
    currently always `whisper-1`. Thus the transcript may diverge somewhat from
    the model's interpretation, and should be treated as a rough guide.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal[
        "RealtimeServerEventConversationItemInputAudioTranscriptionCompleted"
    ] = "RealtimeServerEventConversationItemInputAudioTranscriptionCompleted"
    """
    The event type, must be
    `conversation.item.input_audio_transcription.completed`.

    """
    item_id: str
    """
    The ID of the user message item containing the audio.
    """
    content_index: int
    """
    The index of the content part containing the audio.
    """
    transcript: str
    """
    The transcribed text.
    """
    logprobs: list[LogProbProperties] | None = None
    """
    The log probabilities of the transcription.
    """


class RealtimeServerEventConversationItemInputAudioTranscriptionDelta(
    BaseModel
):
    """
    Returned when the text value of an input audio transcription content part is updated.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal[
        "RealtimeServerEventConversationItemInputAudioTranscriptionDelta"
    ] = "RealtimeServerEventConversationItemInputAudioTranscriptionDelta"
    """
    The event type, must be `conversation.item.input_audio_transcription.delta`.
    """
    item_id: str
    """
    The ID of the item.
    """
    content_index: int | None = None
    """
    The index of the content part in the item's content array.
    """
    delta: str | None = None
    """
    The text delta.
    """
    logprobs: list[LogProbProperties] | None = None
    """
    The log probabilities of the transcription.
    """


class Error4(BaseModel):
    """
    Details of the transcription error.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: str | None = None
    """
    The type of error.
    """
    code: str | None = None
    """
    Error code, if any.
    """
    message: str | None = None
    """
    A human-readable error message.
    """
    param: str | None = None
    """
    Parameter related to the error, if any.
    """


class RealtimeServerEventConversationItemInputAudioTranscriptionFailed(
    BaseModel
):
    """
    Returned when input audio transcription is configured, and a transcription
    request for a user message failed. These events are separate from other
    `error` events so that the client can identify the related Item.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal[
        "RealtimeServerEventConversationItemInputAudioTranscriptionFailed"
    ] = "RealtimeServerEventConversationItemInputAudioTranscriptionFailed"
    """
    The event type, must be
    `conversation.item.input_audio_transcription.failed`.

    """
    item_id: str
    """
    The ID of the user message item.
    """
    content_index: int
    """
    The index of the content part containing the audio.
    """
    error: Error4
    """
    Details of the transcription error.
    """


class RealtimeServerEventConversationItemRetrieved(BaseModel):
    """
    Returned when a conversation item is retrieved with `conversation.item.retrieve`.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventConversationItemRetrieved"] = (
        "RealtimeServerEventConversationItemRetrieved"
    )
    """
    The event type, must be `conversation.item.retrieved`.
    """
    item: RealtimeConversationItem


class RealtimeServerEventConversationItemTruncated(BaseModel):
    """
    Returned when an earlier assistant audio message item is truncated by the
    client with a `conversation.item.truncate` event. This event is used to
    synchronize the server's understanding of the audio with the client's playback.

    This action will truncate the audio and remove the server-side text transcript
    to ensure there is no text in the context that hasn't been heard by the user.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventConversationItemTruncated"] = (
        "RealtimeServerEventConversationItemTruncated"
    )
    """
    The event type, must be `conversation.item.truncated`.
    """
    item_id: str
    """
    The ID of the assistant message item that was truncated.
    """
    content_index: int
    """
    The index of the content part that was truncated.
    """
    audio_end_ms: int
    """
    The duration up to which the audio was truncated, in milliseconds.

    """


class Error5(BaseModel):
    """
    Details of the error.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: str
    """
    The type of error (e.g., "invalid_request_error", "server_error").

    """
    code: str | None = None
    """
    Error code, if any.
    """
    message: str
    """
    A human-readable error message.
    """
    param: str | None = None
    """
    Parameter related to the error, if any.
    """
    event_id: str | None = None
    """
    The event_id of the client event that caused the error, if applicable.

    """


class RealtimeServerEventError(BaseModel):
    """
    Returned when an error occurs, which could be a client problem or a server
    problem. Most errors are recoverable and the session will stay open, we
    recommend to implementors to monitor and log error messages by default.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventError"] = "RealtimeServerEventError"
    """
    The event type, must be `error`.
    """
    error: Error5
    """
    Details of the error.
    """


class RealtimeServerEventInputAudioBufferCleared(BaseModel):
    """
    Returned when the input audio buffer is cleared by the client with a
    `input_audio_buffer.clear` event.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventInputAudioBufferCleared"] = (
        "RealtimeServerEventInputAudioBufferCleared"
    )
    """
    The event type, must be `input_audio_buffer.cleared`.
    """


class RealtimeServerEventInputAudioBufferCommitted(BaseModel):
    """
    Returned when an input audio buffer is committed, either by the client or
    automatically in server VAD mode. The `item_id` property is the ID of the user
    message item that will be created, thus a `conversation.item.created` event
    will also be sent to the client.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventInputAudioBufferCommitted"] = (
        "RealtimeServerEventInputAudioBufferCommitted"
    )
    """
    The event type, must be `input_audio_buffer.committed`.
    """
    previous_item_id: str
    """
    The ID of the preceding item after which the new item will be inserted.

    """
    item_id: str
    """
    The ID of the user message item that will be created.
    """


class RealtimeServerEventInputAudioBufferSpeechStarted(BaseModel):
    """
    Sent by the server when in `server_vad` mode to indicate that speech has been
    detected in the audio buffer. This can happen any time audio is added to the
    buffer (unless speech is already detected). The client may want to use this
    event to interrupt audio playback or provide visual feedback to the user.

    The client should expect to receive a `input_audio_buffer.speech_stopped` event
    when speech stops. The `item_id` property is the ID of the user message item
    that will be created when speech stops and will also be included in the
    `input_audio_buffer.speech_stopped` event (unless the client manually commits
    the audio buffer during VAD activation).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventInputAudioBufferSpeechStarted"] = (
        "RealtimeServerEventInputAudioBufferSpeechStarted"
    )
    """
    The event type, must be `input_audio_buffer.speech_started`.
    """
    audio_start_ms: int
    """
    Milliseconds from the start of all audio written to the buffer during the 
    session when speech was first detected. This will correspond to the 
    beginning of audio sent to the model, and thus includes the 
    `prefix_padding_ms` configured in the Session.

    """
    item_id: str
    """
    The ID of the user message item that will be created when speech stops.

    """


class RealtimeServerEventInputAudioBufferSpeechStopped(BaseModel):
    """
    Returned in `server_vad` mode when the server detects the end of speech in
    the audio buffer. The server will also send an `conversation.item.created`
    event with the user message item that is created from the audio buffer.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventInputAudioBufferSpeechStopped"] = (
        "RealtimeServerEventInputAudioBufferSpeechStopped"
    )
    """
    The event type, must be `input_audio_buffer.speech_stopped`.
    """
    audio_end_ms: int
    """
    Milliseconds since the session started when speech stopped. This will 
    correspond to the end of audio sent to the model, and thus includes the 
    `min_silence_duration_ms` configured in the Session.

    """
    item_id: str
    """
    The ID of the user message item that will be created.
    """


class RealtimeServerEventOutputAudioBufferCleared(BaseModel):
    """
    **WebRTC Only:** Emitted when the output audio buffer is cleared. This happens either in VAD
    mode when the user has interrupted (`input_audio_buffer.speech_started`),
    or when the client has emitted the `output_audio_buffer.clear` event to manually
    cut off the current audio response.
    [Learn more](/docs/guides/realtime-model-capabilities#client-and-server-events-for-audio-in-webrtc).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventOutputAudioBufferCleared"] = (
        "RealtimeServerEventOutputAudioBufferCleared"
    )
    """
    The event type, must be `output_audio_buffer.cleared`.
    """
    response_id: str
    """
    The unique ID of the response that produced the audio.
    """


class RealtimeServerEventOutputAudioBufferStarted(BaseModel):
    """
    **WebRTC Only:** Emitted when the server begins streaming audio to the client. This event is
    emitted after an audio content part has been added (`response.content_part.added`)
    to the response.
    [Learn more](/docs/guides/realtime-model-capabilities#client-and-server-events-for-audio-in-webrtc).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventOutputAudioBufferStarted"] = (
        "RealtimeServerEventOutputAudioBufferStarted"
    )
    """
    The event type, must be `output_audio_buffer.started`.
    """
    response_id: str
    """
    The unique ID of the response that produced the audio.
    """


class RealtimeServerEventOutputAudioBufferStopped(BaseModel):
    """
    **WebRTC Only:** Emitted when the output audio buffer has been completely drained on the server,
    and no more audio is forthcoming. This event is emitted after the full response
    data has been sent to the client (`response.done`).
    [Learn more](/docs/guides/realtime-model-capabilities#client-and-server-events-for-audio-in-webrtc).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventOutputAudioBufferStopped"] = (
        "RealtimeServerEventOutputAudioBufferStopped"
    )
    """
    The event type, must be `output_audio_buffer.stopped`.
    """
    response_id: str
    """
    The unique ID of the response that produced the audio.
    """


class RateLimit(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: Literal["requests", "tokens"] | None = None
    """
    The name of the rate limit (`requests`, `tokens`).

    """
    limit: int | None = None
    """
    The maximum allowed value for the rate limit.
    """
    remaining: int | None = None
    """
    The remaining value before the limit is reached.
    """
    reset_seconds: float | None = None
    """
    Seconds until the rate limit resets.
    """


class RealtimeServerEventRateLimitsUpdated(BaseModel):
    """
    Emitted at the beginning of a Response to indicate the updated rate limits.
    When a Response is created some tokens will be "reserved" for the output
    tokens, the rate limits shown here reflect that reservation, which is then
    adjusted accordingly once the Response is completed.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventRateLimitsUpdated"] = (
        "RealtimeServerEventRateLimitsUpdated"
    )
    """
    The event type, must be `rate_limits.updated`.
    """
    rate_limits: list[RateLimit]
    """
    List of rate limit information.
    """


class RealtimeServerEventResponseAudioDelta(BaseModel):
    """
    Returned when the model-generated audio is updated.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseAudioDelta"] = (
        "RealtimeServerEventResponseAudioDelta"
    )
    """
    The event type, must be `response.audio.delta`.
    """
    response_id: str
    """
    The ID of the response.
    """
    item_id: str
    """
    The ID of the item.
    """
    output_index: int
    """
    The index of the output item in the response.
    """
    content_index: int
    """
    The index of the content part in the item's content array.
    """
    delta: str
    """
    Base64-encoded audio data delta.
    """


class RealtimeServerEventResponseAudioDone(BaseModel):
    """
    Returned when the model-generated audio is done. Also emitted when a Response
    is interrupted, incomplete, or cancelled.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseAudioDone"] = (
        "RealtimeServerEventResponseAudioDone"
    )
    """
    The event type, must be `response.audio.done`.
    """
    response_id: str
    """
    The ID of the response.
    """
    item_id: str
    """
    The ID of the item.
    """
    output_index: int
    """
    The index of the output item in the response.
    """
    content_index: int
    """
    The index of the content part in the item's content array.
    """


class RealtimeServerEventResponseAudioTranscriptDelta(BaseModel):
    """
    Returned when the model-generated transcription of audio output is updated.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseAudioTranscriptDelta"] = (
        "RealtimeServerEventResponseAudioTranscriptDelta"
    )
    """
    The event type, must be `response.audio_transcript.delta`.
    """
    response_id: str
    """
    The ID of the response.
    """
    item_id: str
    """
    The ID of the item.
    """
    output_index: int
    """
    The index of the output item in the response.
    """
    content_index: int
    """
    The index of the content part in the item's content array.
    """
    delta: str
    """
    The transcript delta.
    """


class RealtimeServerEventResponseAudioTranscriptDone(BaseModel):
    """
    Returned when the model-generated transcription of audio output is done
    streaming. Also emitted when a Response is interrupted, incomplete, or
    cancelled.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseAudioTranscriptDone"] = (
        "RealtimeServerEventResponseAudioTranscriptDone"
    )
    """
    The event type, must be `response.audio_transcript.done`.
    """
    response_id: str
    """
    The ID of the response.
    """
    item_id: str
    """
    The ID of the item.
    """
    output_index: int
    """
    The index of the output item in the response.
    """
    content_index: int
    """
    The index of the content part in the item's content array.
    """
    transcript: str
    """
    The final transcript of the audio.
    """


class Part(BaseModel):
    """
    The content part that was added.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["audio", "text"] | None = None
    """
    The content type ("text", "audio").
    """
    text: str | None = None
    """
    The text content (if type is "text").
    """
    audio: str | None = None
    """
    Base64-encoded audio data (if type is "audio").
    """
    transcript: str | None = None
    """
    The transcript of the audio (if type is "audio").
    """


class RealtimeServerEventResponseContentPartAdded(BaseModel):
    """
    Returned when a new content part is added to an assistant message item during
    response generation.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseContentPartAdded"] = (
        "RealtimeServerEventResponseContentPartAdded"
    )
    """
    The event type, must be `response.content_part.added`.
    """
    response_id: str
    """
    The ID of the response.
    """
    item_id: str
    """
    The ID of the item to which the content part was added.
    """
    output_index: int
    """
    The index of the output item in the response.
    """
    content_index: int
    """
    The index of the content part in the item's content array.
    """
    part: Part
    """
    The content part that was added.
    """


class Part1(BaseModel):
    """
    The content part that is done.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["audio", "text"] | None = None
    """
    The content type ("text", "audio").
    """
    text: str | None = None
    """
    The text content (if type is "text").
    """
    audio: str | None = None
    """
    Base64-encoded audio data (if type is "audio").
    """
    transcript: str | None = None
    """
    The transcript of the audio (if type is "audio").
    """


class RealtimeServerEventResponseContentPartDone(BaseModel):
    """
    Returned when a content part is done streaming in an assistant message item.
    Also emitted when a Response is interrupted, incomplete, or cancelled.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseContentPartDone"] = (
        "RealtimeServerEventResponseContentPartDone"
    )
    """
    The event type, must be `response.content_part.done`.
    """
    response_id: str
    """
    The ID of the response.
    """
    item_id: str
    """
    The ID of the item.
    """
    output_index: int
    """
    The index of the output item in the response.
    """
    content_index: int
    """
    The index of the content part in the item's content array.
    """
    part: Part1
    """
    The content part that is done.
    """


class RealtimeServerEventResponseFunctionCallArgumentsDelta(BaseModel):
    """
    Returned when the model-generated function call arguments are updated.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseFunctionCallArgumentsDelta"] = (
        "RealtimeServerEventResponseFunctionCallArgumentsDelta"
    )
    """
    The event type, must be `response.function_call_arguments.delta`.

    """
    response_id: str
    """
    The ID of the response.
    """
    item_id: str
    """
    The ID of the function call item.
    """
    output_index: int
    """
    The index of the output item in the response.
    """
    call_id: str
    """
    The ID of the function call.
    """
    delta: str
    """
    The arguments delta as a JSON string.
    """


class RealtimeServerEventResponseFunctionCallArgumentsDone(BaseModel):
    """
    Returned when the model-generated function call arguments are done streaming.
    Also emitted when a Response is interrupted, incomplete, or cancelled.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseFunctionCallArgumentsDone"] = (
        "RealtimeServerEventResponseFunctionCallArgumentsDone"
    )
    """
    The event type, must be `response.function_call_arguments.done`.

    """
    response_id: str
    """
    The ID of the response.
    """
    item_id: str
    """
    The ID of the function call item.
    """
    output_index: int
    """
    The index of the output item in the response.
    """
    call_id: str
    """
    The ID of the function call.
    """
    arguments: str
    """
    The final arguments as a JSON string.
    """


class RealtimeServerEventResponseOutputItemAdded(BaseModel):
    """
    Returned when a new Item is created during Response generation.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseOutputItemAdded"] = (
        "RealtimeServerEventResponseOutputItemAdded"
    )
    """
    The event type, must be `response.output_item.added`.
    """
    response_id: str
    """
    The ID of the Response to which the item belongs.
    """
    output_index: int
    """
    The index of the output item in the Response.
    """
    item: RealtimeConversationItem


class RealtimeServerEventResponseOutputItemDone(BaseModel):
    """
    Returned when an Item is done streaming. Also emitted when a Response is
    interrupted, incomplete, or cancelled.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseOutputItemDone"] = (
        "RealtimeServerEventResponseOutputItemDone"
    )
    """
    The event type, must be `response.output_item.done`.
    """
    response_id: str
    """
    The ID of the Response to which the item belongs.
    """
    output_index: int
    """
    The index of the output item in the Response.
    """
    item: RealtimeConversationItem


class RealtimeServerEventResponseTextDelta(BaseModel):
    """
    Returned when the text value of a "text" content part is updated.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseTextDelta"] = (
        "RealtimeServerEventResponseTextDelta"
    )
    """
    The event type, must be `response.text.delta`.
    """
    response_id: str
    """
    The ID of the response.
    """
    item_id: str
    """
    The ID of the item.
    """
    output_index: int
    """
    The index of the output item in the response.
    """
    content_index: int
    """
    The index of the content part in the item's content array.
    """
    delta: str
    """
    The text delta.
    """


class RealtimeServerEventResponseTextDone(BaseModel):
    """
    Returned when the text value of a "text" content part is done streaming. Also
    emitted when a Response is interrupted, incomplete, or cancelled.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseTextDone"] = (
        "RealtimeServerEventResponseTextDone"
    )
    """
    The event type, must be `response.text.done`.
    """
    response_id: str
    """
    The ID of the response.
    """
    item_id: str
    """
    The ID of the item.
    """
    output_index: int
    """
    The index of the output item in the response.
    """
    content_index: int
    """
    The index of the content part in the item's content array.
    """
    text: str
    """
    The final text content.
    """


class InputAudioTranscription(BaseModel):
    """
    Configuration for input audio transcription, defaults to off and can be  set to `null` to turn off once on. Input audio transcription is not native to the model, since the model consumes audio directly. Transcription runs  asynchronously through [the /audio/transcriptions endpoint](https://platform.openai.com/docs/api-reference/audio/createTranscription) and should be treated as guidance of input audio content rather than precisely what the model heard. The client can optionally set the language and prompt for transcription, these offer additional guidance to the transcription service.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    model: str | None = None
    """
    The model to use for transcription, current options are `gpt-4o-transcribe`, `gpt-4o-mini-transcribe`, and `whisper-1`.

    """
    language: str | None = None
    """
    The language of the input audio. Supplying the input language in
    [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) (e.g. `en`) format
    will improve accuracy and latency.

    """
    prompt: str | None = None
    """
    An optional text to guide the model's style or continue a previous audio
    segment.
    For `whisper-1`, the [prompt is a list of keywords](/docs/guides/speech-to-text#prompting).
    For `gpt-4o-transcribe` models, the prompt is a free text string, for example "expect words related to technology".

    """


class TurnDetection(BaseModel):
    """
    Configuration for turn detection, ether Server VAD or Semantic VAD. This can be set to `null` to turn off, in which case the client must manually trigger model response.
    Server VAD means that the model will detect the start and end of speech based on audio volume and respond at the end of user speech.
    Semantic VAD is more advanced and uses a turn detection model (in conjuction with VAD) to semantically estimate whether the user has finished speaking, then dynamically sets a timeout based on this probability. For example, if user audio trails off with "uhhm", the model will score a low probability of turn end and wait longer for the user to continue speaking. This can be useful for more natural conversations, but may have a higher latency.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["server_vad", "semantic_vad"] | None = "server_vad"
    """
    Type of turn detection.

    """
    eagerness: Literal["low", "medium", "high", "auto"] | None = "auto"
    """
    Used only for `semantic_vad` mode. The eagerness of the model to respond. `low` will wait longer for the user to continue speaking, `high` will respond more quickly. `auto` is the default and is equivalent to `medium`.

    """
    threshold: float | None = None
    """
    Used only for `server_vad` mode. Activation threshold for VAD (0.0 to 1.0), this defaults to 0.5. A 
    higher threshold will require louder audio to activate the model, and 
    thus might perform better in noisy environments.

    """
    prefix_padding_ms: int | None = None
    """
    Used only for `server_vad` mode. Amount of audio to include before the VAD detected speech (in 
    milliseconds). Defaults to 300ms.

    """
    silence_duration_ms: int | None = None
    """
    Used only for `server_vad` mode. Duration of silence to detect speech stop (in milliseconds). Defaults 
    to 500ms. With shorter values the model will respond more quickly, 
    but may jump in on short pauses from the user.

    """
    create_response: bool | None = True
    """
    Whether or not to automatically generate a response when a VAD stop event occurs.

    """
    interrupt_response: bool | None = True
    """
    Whether or not to automatically interrupt any ongoing response with output to the default
    conversation (i.e. `conversation` of `auto`) when a VAD start event occurs.

    """


class InputAudioNoiseReduction(BaseModel):
    """
    Configuration for input audio noise reduction. This can be set to `null` to turn off.
    Noise reduction filters audio added to the input audio buffer before it is sent to VAD and the model.
    Filtering the audio can improve VAD and turn detection accuracy (reducing false positives) and model performance by improving perception of the input audio.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["near_field", "far_field"] | None = None
    """
    Type of noise reduction. `near_field` is for close-talking microphones such as headphones, `far_field` is for far-field microphones such as laptop or conference room microphones.

    """


class ClientSecret(BaseModel):
    """
    Ephemeral key returned by the API.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    value: str
    """
    Ephemeral key usable in client environments to authenticate connections
    to the Realtime API. Use this in client-side environments rather than
    a standard API token, which should only be used server-side.

    """
    expires_at: int
    """
    Timestamp for when the token expires. Currently, all tokens expire
    after one minute.

    """


class InputAudioTranscription2(BaseModel):
    """
    Configuration for input audio transcription, defaults to off and can be
    set to `null` to turn off once on. Input audio transcription is not native
    to the model, since the model consumes audio directly. Transcription runs
    asynchronously through Whisper and should be treated as rough guidance
    rather than the representation understood by the model.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    model: str | None = None
    """
    The model to use for transcription, `whisper-1` is the only currently 
    supported model.

    """


class TurnDetection2(BaseModel):
    """
    Configuration for turn detection. Can be set to `null` to turn off. Server
    VAD means that the model will detect the start and end of speech based on
    audio volume and respond at the end of user speech.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: str | None = None
    """
    Type of turn detection, only `server_vad` is currently supported.

    """
    threshold: float | None = None
    """
    Activation threshold for VAD (0.0 to 1.0), this defaults to 0.5. A 
    higher threshold will require louder audio to activate the model, and 
    thus might perform better in noisy environments.

    """
    prefix_padding_ms: int | None = None
    """
    Amount of audio to include before the VAD detected speech (in 
    milliseconds). Defaults to 300ms.

    """
    silence_duration_ms: int | None = None
    """
    Duration of silence to detect speech stop (in milliseconds). Defaults 
    to 500ms. With shorter values the model will respond more quickly, 
    but may jump in on short pauses from the user.

    """


class InputAudioTranscription3(BaseModel):
    """
    Configuration for input audio transcription. The client can optionally set the language and prompt for transcription, these offer additional guidance to the transcription service.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    model: (
        Literal["gpt-4o-transcribe", "gpt-4o-mini-transcribe", "whisper-1"]
        | None
    ) = None
    """
    The model to use for transcription, current options are `gpt-4o-transcribe`, `gpt-4o-mini-transcribe`, and `whisper-1`.

    """
    language: str | None = None
    """
    The language of the input audio. Supplying the input language in
    [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) (e.g. `en`) format
    will improve accuracy and latency.

    """
    prompt: str | None = None
    """
    An optional text to guide the model's style or continue a previous audio
    segment.
    For `whisper-1`, the [prompt is a list of keywords](/docs/guides/speech-to-text#prompting).
    For `gpt-4o-transcribe` models, the prompt is a free text string, for example "expect words related to technology".

    """


class TurnDetection3(BaseModel):
    """
    Configuration for turn detection, ether Server VAD or Semantic VAD. This can be set to `null` to turn off, in which case the client must manually trigger model response.
    Server VAD means that the model will detect the start and end of speech based on audio volume and respond at the end of user speech.
    Semantic VAD is more advanced and uses a turn detection model (in conjuction with VAD) to semantically estimate whether the user has finished speaking, then dynamically sets a timeout based on this probability. For example, if user audio trails off with "uhhm", the model will score a low probability of turn end and wait longer for the user to continue speaking. This can be useful for more natural conversations, but may have a higher latency.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["server_vad", "semantic_vad"] | None = "server_vad"
    """
    Type of turn detection.

    """
    eagerness: Literal["low", "medium", "high", "auto"] | None = "auto"
    """
    Used only for `semantic_vad` mode. The eagerness of the model to respond. `low` will wait longer for the user to continue speaking, `high` will respond more quickly. `auto` is the default and is equivalent to `medium`.

    """
    threshold: float | None = None
    """
    Used only for `server_vad` mode. Activation threshold for VAD (0.0 to 1.0), this defaults to 0.5. A 
    higher threshold will require louder audio to activate the model, and 
    thus might perform better in noisy environments.

    """
    prefix_padding_ms: int | None = None
    """
    Used only for `server_vad` mode. Amount of audio to include before the VAD detected speech (in 
    milliseconds). Defaults to 300ms.

    """
    silence_duration_ms: int | None = None
    """
    Used only for `server_vad` mode. Duration of silence to detect speech stop (in milliseconds). Defaults 
    to 500ms. With shorter values the model will respond more quickly, 
    but may jump in on short pauses from the user.

    """
    create_response: bool | None = True
    """
    Whether or not to automatically generate a response when a VAD stop event occurs. Not available for transcription sessions.

    """
    interrupt_response: bool | None = True
    """
    Whether or not to automatically interrupt any ongoing response with output to the default
    conversation (i.e. `conversation` of `auto`) when a VAD start event occurs. Not available for transcription sessions.

    """


class RealtimeTranscriptionSessionCreateRequest(BaseModel):
    """
    Realtime transcription session object configuration.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    modalities: list[Literal["text", "audio"]] | None = None
    """
    The set of modalities the model can respond with. To disable audio,
    set this to ["text"].

    """
    input_audio_format: Literal["pcm16", "g711_ulaw", "g711_alaw"] | None = (
        "pcm16"
    )
    """
    The format of input audio. Options are `pcm16`, `g711_ulaw`, or `g711_alaw`.
    For `pcm16`, input audio must be 16-bit PCM at a 24kHz sample rate, 
    single channel (mono), and little-endian byte order.

    """
    input_audio_transcription: InputAudioTranscription3 | None = None
    """
    Configuration for input audio transcription. The client can optionally set the language and prompt for transcription, these offer additional guidance to the transcription service.

    """
    turn_detection: TurnDetection3 | None = None
    """
    Configuration for turn detection, ether Server VAD or Semantic VAD. This can be set to `null` to turn off, in which case the client must manually trigger model response.
    Server VAD means that the model will detect the start and end of speech based on audio volume and respond at the end of user speech.
    Semantic VAD is more advanced and uses a turn detection model (in conjuction with VAD) to semantically estimate whether the user has finished speaking, then dynamically sets a timeout based on this probability. For example, if user audio trails off with "uhhm", the model will score a low probability of turn end and wait longer for the user to continue speaking. This can be useful for more natural conversations, but may have a higher latency.

    """
    input_audio_noise_reduction: InputAudioNoiseReduction | None = None
    """
    Configuration for input audio noise reduction. This can be set to `null` to turn off.
    Noise reduction filters audio added to the input audio buffer before it is sent to VAD and the model.
    Filtering the audio can improve VAD and turn detection accuracy (reducing false positives) and model performance by improving perception of the input audio.

    """
    include: list[str] | None = None
    """
    The set of items to include in the transcription. Current available items are:
    - `item.input_audio_transcription.logprobs`

    """


class ClientSecret1(BaseModel):
    """
    Ephemeral key returned by the API. Only present when the session is
    created on the server via REST API.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    value: str
    """
    Ephemeral key usable in client environments to authenticate connections
    to the Realtime API. Use this in client-side environments rather than
    a standard API token, which should only be used server-side.

    """
    expires_at: int
    """
    Timestamp for when the token expires. Currently, all tokens expire
    after one minute.

    """


class InputAudioTranscription4(BaseModel):
    """
    Configuration of the transcription model.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    model: (
        Literal["gpt-4o-transcribe", "gpt-4o-mini-transcribe", "whisper-1"]
        | None
    ) = None
    """
    The model to use for transcription. Can be `gpt-4o-transcribe`, `gpt-4o-mini-transcribe`, or `whisper-1`.

    """
    language: str | None = None
    """
    The language of the input audio. Supplying the input language in
    [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) (e.g. `en`) format
    will improve accuracy and latency.

    """
    prompt: str | None = None
    """
    An optional text to guide the model's style or continue a previous audio
    segment. The [prompt](/docs/guides/speech-to-text#prompting) should match
    the audio language.

    """


class TurnDetection4(BaseModel):
    """
    Configuration for turn detection. Can be set to `null` to turn off. Server
    VAD means that the model will detect the start and end of speech based on
    audio volume and respond at the end of user speech.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: str | None = None
    """
    Type of turn detection, only `server_vad` is currently supported.

    """
    threshold: float | None = None
    """
    Activation threshold for VAD (0.0 to 1.0), this defaults to 0.5. A 
    higher threshold will require louder audio to activate the model, and 
    thus might perform better in noisy environments.

    """
    prefix_padding_ms: int | None = None
    """
    Amount of audio to include before the VAD detected speech (in 
    milliseconds). Defaults to 300ms.

    """
    silence_duration_ms: int | None = None
    """
    Duration of silence to detect speech stop (in milliseconds). Defaults 
    to 500ms. With shorter values the model will respond more quickly, 
    but may jump in on short pauses from the user.

    """


class RealtimeTranscriptionSessionCreateResponse(BaseModel):
    """
    A new Realtime transcription session configuration.

    When a session is created on the server via REST API, the session object
    also contains an ephemeral key. Default TTL for keys is one minute. This
    property is not present when a session is updated via the WebSocket API.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    client_secret: ClientSecret1
    """
    Ephemeral key returned by the API. Only present when the session is
    created on the server via REST API.

    """
    modalities: list[Literal["text", "audio"]] | None = None
    """
    The set of modalities the model can respond with. To disable audio,
    set this to ["text"].

    """
    input_audio_format: str | None = None
    """
    The format of input audio. Options are `pcm16`, `g711_ulaw`, or `g711_alaw`.

    """
    input_audio_transcription: InputAudioTranscription4 | None = None
    """
    Configuration of the transcription model.

    """
    turn_detection: TurnDetection4 | None = None
    """
    Configuration for turn detection. Can be set to `null` to turn off. Server 
    VAD means that the model will detect the start and end of speech based on 
    audio volume and respond at the end of user speech.

    """


class ReasoningEffort(RootModel[Literal["low", "medium", "high"] | None]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal["low", "medium", "high"] | None = "medium"
    """
    **o-series models only** 

    Constrains effort on reasoning for 
    [reasoning models](https://platform.openai.com/docs/guides/reasoning).
    Currently supported values are `low`, `medium`, and `high`. Reducing
    reasoning effort can result in faster responses and fewer tokens used
    on reasoning in a response.

    """


class SummaryItem(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["summary_text"] = "summary_text"
    """
    The type of the object. Always `summary_text`.

    """
    text: str
    """
    A short summary of the reasoning used by the model when generating
    the response.

    """


class ReasoningItem(BaseModel):
    """
    A description of the chain of thought used by a reasoning model while generating
    a response.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ReasoningItem"] = "ReasoningItem"
    """
    The type of the object. Always `reasoning`.

    """
    id: str
    """
    The unique identifier of the reasoning content.

    """
    summary: list[SummaryItem]
    """
    Reasoning text contents.

    """
    status: Literal["in_progress", "completed", "incomplete"] | None = None
    """
    The status of the item. One of `in_progress`, `completed`, or
    `incomplete`. Populated when items are returned via API.

    """


class IncompleteDetails1(BaseModel):
    """
    Details about why the response is incomplete.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    reason: Literal["max_output_tokens", "content_filter"] | None = None
    """
    The reason why the response is incomplete.
    """


class ResponseAudioDeltaEvent(BaseModel):
    """
    Emitted when there is a partial audio response.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseAudioDeltaEvent"] = "ResponseAudioDeltaEvent"
    """
    The type of the event. Always `response.audio.delta`.

    """
    delta: str
    """
    A chunk of Base64 encoded response audio bytes.

    """


class ResponseAudioDoneEvent(BaseModel):
    """
    Emitted when the audio response is complete.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseAudioDoneEvent"] = "ResponseAudioDoneEvent"
    """
    The type of the event. Always `response.audio.done`.

    """


class ResponseAudioTranscriptDeltaEvent(BaseModel):
    """
    Emitted when there is a partial transcript of audio.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseAudioTranscriptDeltaEvent"] = (
        "ResponseAudioTranscriptDeltaEvent"
    )
    """
    The type of the event. Always `response.audio.transcript.delta`.

    """
    delta: str
    """
    The partial transcript of the audio response.

    """


class ResponseAudioTranscriptDoneEvent(BaseModel):
    """
    Emitted when the full audio transcript is completed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseAudioTranscriptDoneEvent"] = (
        "ResponseAudioTranscriptDoneEvent"
    )
    """
    The type of the event. Always `response.audio.transcript.done`.

    """


class ResponseCodeInterpreterCallCodeDeltaEvent(BaseModel):
    """
    Emitted when a partial code snippet is added by the code interpreter.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseCodeInterpreterCallCodeDeltaEvent"] = (
        "ResponseCodeInterpreterCallCodeDeltaEvent"
    )
    """
    The type of the event. Always `response.code_interpreter_call.code.delta`.

    """
    output_index: int
    """
    The index of the output item that the code interpreter call is in progress.

    """
    delta: str
    """
    The partial code snippet added by the code interpreter.

    """


class ResponseCodeInterpreterCallCodeDoneEvent(BaseModel):
    """
    Emitted when code snippet output is finalized by the code interpreter.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseCodeInterpreterCallCodeDoneEvent"] = (
        "ResponseCodeInterpreterCallCodeDoneEvent"
    )
    """
    The type of the event. Always `response.code_interpreter_call.code.done`.

    """
    output_index: int
    """
    The index of the output item that the code interpreter call is in progress.

    """
    code: str
    """
    The final code snippet output by the code interpreter.

    """


class ResponseErrorCode(
    RootModel[
        Literal[
            "server_error",
            "rate_limit_exceeded",
            "invalid_prompt",
            "vector_store_timeout",
            "invalid_image",
            "invalid_image_format",
            "invalid_base64_image",
            "invalid_image_url",
            "image_too_large",
            "image_too_small",
            "image_parse_error",
            "image_content_policy_violation",
            "invalid_image_mode",
            "image_file_too_large",
            "unsupported_image_media_type",
            "empty_image_file",
            "failed_to_download_image",
            "image_file_not_found",
        ]
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal[
        "server_error",
        "rate_limit_exceeded",
        "invalid_prompt",
        "vector_store_timeout",
        "invalid_image",
        "invalid_image_format",
        "invalid_base64_image",
        "invalid_image_url",
        "image_too_large",
        "image_too_small",
        "image_parse_error",
        "image_content_policy_violation",
        "invalid_image_mode",
        "image_file_too_large",
        "unsupported_image_media_type",
        "empty_image_file",
        "failed_to_download_image",
        "image_file_not_found",
    ]
    """
    The error code for the response.

    """


class ResponseErrorEvent(BaseModel):
    """
    Emitted when an error occurs.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseErrorEvent"] = "ResponseErrorEvent"
    """
    The type of the event. Always `error`.

    """
    code: str
    """
    The error code.

    """
    message: str
    """
    The error message.

    """
    param: str
    """
    The error parameter.

    """


class ResponseFileSearchCallCompletedEvent(BaseModel):
    """
    Emitted when a file search call is completed (results found).
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseFileSearchCallCompletedEvent"] = (
        "ResponseFileSearchCallCompletedEvent"
    )
    """
    The type of the event. Always `response.file_search_call.completed`.

    """
    output_index: int
    """
    The index of the output item that the file search call is initiated.

    """
    item_id: str
    """
    The ID of the output item that the file search call is initiated.

    """


class ResponseFileSearchCallInProgressEvent(BaseModel):
    """
    Emitted when a file search call is initiated.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseFileSearchCallInProgressEvent"] = (
        "ResponseFileSearchCallInProgressEvent"
    )
    """
    The type of the event. Always `response.file_search_call.in_progress`.

    """
    output_index: int
    """
    The index of the output item that the file search call is initiated.

    """
    item_id: str
    """
    The ID of the output item that the file search call is initiated.

    """


class ResponseFileSearchCallSearchingEvent(BaseModel):
    """
    Emitted when a file search is currently searching.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseFileSearchCallSearchingEvent"] = (
        "ResponseFileSearchCallSearchingEvent"
    )
    """
    The type of the event. Always `response.file_search_call.searching`.

    """
    output_index: int
    """
    The index of the output item that the file search call is searching.

    """
    item_id: str
    """
    The ID of the output item that the file search call is initiated.

    """


class ResponseFormatJsonObject(BaseModel):
    """
    JSON object response format. An older method of generating JSON responses.
    Using `json_schema` is recommended for models that support it. Note that the
    model will not generate JSON without a system or user message instructing it
    to do so.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["json_object"] = "json_object"
    """
    The type of response format being defined. Always `json_object`.
    """


class ResponseFormatJsonSchemaSchema(BaseModel):
    """
    The schema for the response format, described as a JSON Schema object.
    Learn how to build JSON schemas [here](https://json-schema.org/).

    """

    model_config = ConfigDict(
        extra="allow",
        populate_by_name=True,
    )


class ResponseFormatText(BaseModel):
    """
    Default response format. Used to generate text responses.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["text"] = "text"
    """
    The type of response format being defined. Always `text`.
    """


class ResponseFunctionCallArgumentsDeltaEvent(BaseModel):
    """
    Emitted when there is a partial function-call arguments delta.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseFunctionCallArgumentsDeltaEvent"] = (
        "ResponseFunctionCallArgumentsDeltaEvent"
    )
    """
    The type of the event. Always `response.function_call_arguments.delta`.

    """
    item_id: str
    """
    The ID of the output item that the function-call arguments delta is added to.

    """
    output_index: int
    """
    The index of the output item that the function-call arguments delta is added to.

    """
    delta: str
    """
    The function-call arguments delta that is added.

    """


class ResponseFunctionCallArgumentsDoneEvent(BaseModel):
    """
    Emitted when function-call arguments are finalized.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseFunctionCallArgumentsDoneEvent"] = (
        "ResponseFunctionCallArgumentsDoneEvent"
    )
    item_id: str
    """
    The ID of the item.
    """
    output_index: int
    """
    The index of the output item.
    """
    arguments: str
    """
    The function-call arguments.
    """


class ResponseModalities(RootModel[list[Literal["text", "audio"]] | None]):
    """
    Output types that you would like the model to generate.
    Most models are capable of generating text, which is the default:

    `["text"]`

    The `gpt-4o-audio-preview` model can also be used to
    [generate audio](/docs/guides/audio). To request that this model generate
    both text and audio responses, you can use:

    `["text", "audio"]`

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[Literal["text", "audio"]] | None = None
    """
    Output types that you would like the model to generate.
    Most models are capable of generating text, which is the default:

    `["text"]`

    The `gpt-4o-audio-preview` model can also be used to 
    [generate audio](/docs/guides/audio). To request that this model generate 
    both text and audio responses, you can use:

    `["text", "audio"]`

    """


class Part2(BaseModel):
    """
    The summary part that was added.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["summary_text"] = "summary_text"
    """
    The type of the summary part. Always `summary_text`.
    """
    text: str
    """
    The text of the summary part.
    """


class ResponseReasoningSummaryPartAddedEvent(BaseModel):
    """
    Emitted when a new reasoning summary part is added.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseReasoningSummaryPartAddedEvent"] = (
        "ResponseReasoningSummaryPartAddedEvent"
    )
    """
    The type of the event. Always `response.reasoning_summary_part.added`.

    """
    item_id: str
    """
    The ID of the item this summary part is associated with.

    """
    output_index: int
    """
    The index of the output item this summary part is associated with.

    """
    summary_index: int
    """
    The index of the summary part within the reasoning summary.

    """
    part: Part2
    """
    The summary part that was added.

    """


class Part3(BaseModel):
    """
    The completed summary part.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["summary_text"] = "summary_text"
    """
    The type of the summary part. Always `summary_text`.
    """
    text: str
    """
    The text of the summary part.
    """


class ResponseReasoningSummaryPartDoneEvent(BaseModel):
    """
    Emitted when a reasoning summary part is completed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseReasoningSummaryPartDoneEvent"] = (
        "ResponseReasoningSummaryPartDoneEvent"
    )
    """
    The type of the event. Always `response.reasoning_summary_part.done`.

    """
    item_id: str
    """
    The ID of the item this summary part is associated with.

    """
    output_index: int
    """
    The index of the output item this summary part is associated with.

    """
    summary_index: int
    """
    The index of the summary part within the reasoning summary.

    """
    part: Part3
    """
    The completed summary part.

    """


class ResponseReasoningSummaryTextDeltaEvent(BaseModel):
    """
    Emitted when a delta is added to a reasoning summary text.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseReasoningSummaryTextDeltaEvent"] = (
        "ResponseReasoningSummaryTextDeltaEvent"
    )
    """
    The type of the event. Always `response.reasoning_summary_text.delta`.

    """
    item_id: str
    """
    The ID of the item this summary text delta is associated with.

    """
    output_index: int
    """
    The index of the output item this summary text delta is associated with.

    """
    summary_index: int
    """
    The index of the summary part within the reasoning summary.

    """
    delta: str
    """
    The text delta that was added to the summary.

    """


class ResponseReasoningSummaryTextDoneEvent(BaseModel):
    """
    Emitted when a reasoning summary text is completed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseReasoningSummaryTextDoneEvent"] = (
        "ResponseReasoningSummaryTextDoneEvent"
    )
    """
    The type of the event. Always `response.reasoning_summary_text.done`.

    """
    item_id: str
    """
    The ID of the item this summary text is associated with.

    """
    output_index: int
    """
    The index of the output item this summary text is associated with.

    """
    summary_index: int
    """
    The index of the summary part within the reasoning summary.

    """
    text: str
    """
    The full text of the completed reasoning summary.

    """


class ResponseRefusalDeltaEvent(BaseModel):
    """
    Emitted when there is a partial refusal text.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseRefusalDeltaEvent"] = "ResponseRefusalDeltaEvent"
    """
    The type of the event. Always `response.refusal.delta`.

    """
    item_id: str
    """
    The ID of the output item that the refusal text is added to.

    """
    output_index: int
    """
    The index of the output item that the refusal text is added to.

    """
    content_index: int
    """
    The index of the content part that the refusal text is added to.

    """
    delta: str
    """
    The refusal text that is added.

    """


class ResponseRefusalDoneEvent(BaseModel):
    """
    Emitted when refusal text is finalized.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseRefusalDoneEvent"] = "ResponseRefusalDoneEvent"
    """
    The type of the event. Always `response.refusal.done`.

    """
    item_id: str
    """
    The ID of the output item that the refusal text is finalized.

    """
    output_index: int
    """
    The index of the output item that the refusal text is finalized.

    """
    content_index: int
    """
    The index of the content part that the refusal text is finalized.

    """
    refusal: str
    """
    The refusal text that is finalized.

    """


class ResponseTextDeltaEvent(BaseModel):
    """
    Emitted when there is an additional text delta.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseTextDeltaEvent"] = "ResponseTextDeltaEvent"
    """
    The type of the event. Always `response.output_text.delta`.

    """
    item_id: str
    """
    The ID of the output item that the text delta was added to.

    """
    output_index: int
    """
    The index of the output item that the text delta was added to.

    """
    content_index: int
    """
    The index of the content part that the text delta was added to.

    """
    delta: str
    """
    The text delta that was added.

    """


class ResponseTextDoneEvent(BaseModel):
    """
    Emitted when text content is finalized.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseTextDoneEvent"] = "ResponseTextDoneEvent"
    """
    The type of the event. Always `response.output_text.done`.

    """
    item_id: str
    """
    The ID of the output item that the text content is finalized.

    """
    output_index: int
    """
    The index of the output item that the text content is finalized.

    """
    content_index: int
    """
    The index of the content part that the text content is finalized.

    """
    text: str
    """
    The text content that is finalized.

    """


class InputTokensDetails1(BaseModel):
    """
    A detailed breakdown of the input tokens.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    cached_tokens: int
    """
    The number of tokens that were retrieved from the cache. 
    [More on prompt caching](/docs/guides/prompt-caching).

    """


class OutputTokensDetails(BaseModel):
    """
    A detailed breakdown of the output tokens.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    reasoning_tokens: int
    """
    The number of reasoning tokens.
    """


class ResponseUsage(BaseModel):
    """
    Represents token usage details including input tokens, output tokens,
    a breakdown of output tokens, and the total tokens used.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    input_tokens: int
    """
    The number of input tokens.
    """
    input_tokens_details: InputTokensDetails1
    """
    A detailed breakdown of the input tokens.
    """
    output_tokens: int
    """
    The number of output tokens.
    """
    output_tokens_details: OutputTokensDetails
    """
    A detailed breakdown of the output tokens.
    """
    total_tokens: int
    """
    The total number of tokens used.
    """


class ResponseWebSearchCallCompletedEvent(BaseModel):
    """
    Emitted when a web search call is completed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseWebSearchCallCompletedEvent"] = (
        "ResponseWebSearchCallCompletedEvent"
    )
    """
    The type of the event. Always `response.web_search_call.completed`.

    """
    output_index: int
    """
    The index of the output item that the web search call is associated with.

    """
    item_id: str
    """
    Unique ID for the output item associated with the web search call.

    """


class ResponseWebSearchCallInProgressEvent(BaseModel):
    """
    Emitted when a web search call is initiated.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseWebSearchCallInProgressEvent"] = (
        "ResponseWebSearchCallInProgressEvent"
    )
    """
    The type of the event. Always `response.web_search_call.in_progress`.

    """
    output_index: int
    """
    The index of the output item that the web search call is associated with.

    """
    item_id: str
    """
    Unique ID for the output item associated with the web search call.

    """


class ResponseWebSearchCallSearchingEvent(BaseModel):
    """
    Emitted when a web search call is executing.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseWebSearchCallSearchingEvent"] = (
        "ResponseWebSearchCallSearchingEvent"
    )
    """
    The type of the event. Always `response.web_search_call.searching`.

    """
    output_index: int
    """
    The index of the output item that the web search call is associated with.

    """
    item_id: str
    """
    Unique ID for the output item associated with the web search call.

    """


class RunCompletionUsage(BaseModel):
    """
    Usage statistics related to the run. This value will be `null` if the run is not in a terminal state (i.e. `in_progress`, `queued`, etc.).
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    completion_tokens: int
    """
    Number of completion tokens used over the course of the run.
    """
    prompt_tokens: int
    """
    Number of prompt tokens used over the course of the run.
    """
    total_tokens: int
    """
    Total number of tokens used (prompt + completion).
    """


class LastError(BaseModel):
    """
    The last error associated with this run. Will be `null` if there are no errors.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code: Literal["server_error", "rate_limit_exceeded", "invalid_prompt"]
    """
    One of `server_error`, `rate_limit_exceeded`, or `invalid_prompt`.
    """
    message: str
    """
    A human-readable description of the error.
    """


class IncompleteDetails2(BaseModel):
    """
    Details on why the run is incomplete. Will be `null` if the run is not incomplete.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    reason: Literal["max_completion_tokens", "max_prompt_tokens"] | None = None
    """
    The reason why the run is incomplete. This will point to which specific token limit was reached over the course of the run.
    """


class RunStepCompletionUsage(BaseModel):
    """
    Usage statistics related to the run step. This value will be `null` while the run step's status is `in_progress`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    completion_tokens: int
    """
    Number of completion tokens used over the course of the run step.
    """
    prompt_tokens: int
    """
    Number of prompt tokens used over the course of the run step.
    """
    total_tokens: int
    """
    Total number of tokens used (prompt + completion).
    """


class MessageCreation(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    message_id: str | None = None
    """
    The ID of the message that was created by this run step.
    """


class RunStepDeltaStepDetailsMessageCreationObject(BaseModel):
    """
    Details of the message creation by the run step.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["message_creation"] = "message_creation"
    """
    Always `message_creation`.
    """
    message_creation: MessageCreation | None = None


class Image2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_id: str | None = None
    """
    The [file](/docs/api-reference/files) ID of the image.
    """


class RunStepDeltaStepDetailsToolCallsCodeOutputImageObject(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the output in the outputs array.
    """
    type: Literal["image"] = "image"
    """
    Always `image`.
    """
    image: Image2 | None = None


class RunStepDeltaStepDetailsToolCallsCodeOutputLogsObject(BaseModel):
    """
    Text output from the Code Interpreter tool call as part of a run step.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the output in the outputs array.
    """
    type: Literal["logs"] = "logs"
    """
    Always `logs`.
    """
    logs: str | None = None
    """
    The text output from the Code Interpreter tool call.
    """


class RunStepDeltaStepDetailsToolCallsFileSearchObject(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the tool call in the tool calls array.
    """
    id: str | None = None
    """
    The ID of the tool call object.
    """
    type: Literal["file_search"] = "file_search"
    """
    The type of tool call. This is always going to be `file_search` for this type of tool call.
    """
    file_search: dict[str, Any]
    """
    For now, this is always going to be an empty object.
    """


class Function4(BaseModel):
    """
    The definition of the function that was called.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str | None = None
    """
    The name of the function.
    """
    arguments: str | None = None
    """
    The arguments passed to the function.
    """
    output: str | None = None
    """
    The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.
    """


class RunStepDeltaStepDetailsToolCallsFunctionObject(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the tool call in the tool calls array.
    """
    id: str | None = None
    """
    The ID of the tool call object.
    """
    type: Literal["function"] = "function"
    """
    The type of tool call. This is always going to be `function` for this type of tool call.
    """
    function: Function4 | None = None
    """
    The definition of the function that was called.
    """


class MessageCreation1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    message_id: str
    """
    The ID of the message that was created by this run step.
    """


class RunStepDetailsMessageCreationObject(BaseModel):
    """
    Details of the message creation by the run step.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["message_creation"] = "message_creation"
    """
    Always `message_creation`.
    """
    message_creation: MessageCreation1


class Image3(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_id: str
    """
    The [file](/docs/api-reference/files) ID of the image.
    """


class RunStepDetailsToolCallsCodeOutputImageObject(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["image"] = "image"
    """
    Always `image`.
    """
    image: Image3


class RunStepDetailsToolCallsCodeOutputLogsObject(BaseModel):
    """
    Text output from the Code Interpreter tool call as part of a run step.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["logs"] = "logs"
    """
    Always `logs`.
    """
    logs: str
    """
    The text output from the Code Interpreter tool call.
    """


class RunStepDetailsToolCallsFileSearchRankingOptionsObject(BaseModel):
    """
    The ranking options for the file search.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    ranker: FileSearchRanker
    score_threshold: float = Field(..., ge=0.0, le=1.0)
    """
    The score threshold for the file search. All values must be a floating point number between 0 and 1.
    """


class ContentItem3(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["text"] | None = None
    """
    The type of the content.
    """
    text: str | None = None
    """
    The text content of the file.
    """


class RunStepDetailsToolCallsFileSearchResultObject(BaseModel):
    """
    A result instance of the file search.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_id: str
    """
    The ID of the file that result was found in.
    """
    file_name: str
    """
    The name of the file that result was found in.
    """
    score: float = Field(..., ge=0.0, le=1.0)
    """
    The score of the result. All values must be a floating point number between 0 and 1.
    """
    content: list[ContentItem3] | None = None
    """
    The content of the result that was found. The content is only included if requested via the include query parameter.
    """


class Function5(BaseModel):
    """
    The definition of the function that was called.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    """
    The name of the function.
    """
    arguments: str
    """
    The arguments passed to the function.
    """
    output: str
    """
    The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.
    """


class RunStepDetailsToolCallsFunctionObject(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The ID of the tool call object.
    """
    type: Literal["function"] = "function"
    """
    The type of tool call. This is always going to be `function` for this type of tool call.
    """
    function: Function5
    """
    The definition of the function that was called.
    """


class LastError1(BaseModel):
    """
    The last error associated with this run step. Will be `null` if there are no errors.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code: Literal["server_error", "rate_limit_exceeded"]
    """
    One of `server_error` or `rate_limit_exceeded`.
    """
    message: str
    """
    A human-readable description of the error.
    """


class Function6(BaseModel):
    """
    The function definition.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str
    """
    The name of the function.
    """
    arguments: str
    """
    The arguments that the model expects you to pass to the function.
    """


class RunToolCallObject(BaseModel):
    """
    Tool call objects
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The ID of the tool call. This ID must be referenced when you submit the tool outputs in using the [Submit tool outputs to run](/docs/api-reference/runs/submitToolOutputs) endpoint.
    """
    type: Literal["function"] = "function"
    """
    The type of tool call the output is required for. For now, this is always `function`.
    """
    function: Function6
    """
    The function definition.
    """


class Screenshot(BaseModel):
    """
    A screenshot action.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["screenshot"] = "screenshot"
    """
    Specifies the event type. For a screenshot action, this property is 
    always set to `screenshot`.

    """


class Scroll(BaseModel):
    """
    A scroll action.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["scroll"] = "scroll"
    """
    Specifies the event type. For a scroll action, this property is 
    always set to `scroll`.

    """
    x: int
    """
    The x-coordinate where the scroll occurred.

    """
    y: int
    """
    The y-coordinate where the scroll occurred.

    """
    scroll_x: int
    """
    The horizontal scroll distance.

    """
    scroll_y: int
    """
    The vertical scroll distance.

    """


class ServiceTier(RootModel[Literal["auto", "default", "flex"] | None]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal["auto", "default", "flex"] | None = "auto"
    """
    Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service:
      - If set to 'auto', and the Project is Scale tier enabled, the system
        will utilize scale tier credits until they are exhausted.
      - If set to 'auto', and the Project is not Scale tier enabled, the request will be processed using the default service tier with a lower uptime SLA and no latency guarentee.
      - If set to 'default', the request will be processed using the default service tier with a lower uptime SLA and no latency guarentee.
      - If set to 'flex', the request will be processed with the Flex Processing service tier. [Learn more](/docs/guides/flex-processing).
      - When not set, the default behavior is 'auto'.

      When this parameter is set, the response body will include the `service_tier` utilized.

    """


class StaticChunkingStrategy(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    max_chunk_size_tokens: int = Field(..., ge=100, le=4096)
    """
    The maximum number of tokens in each chunk. The default value is `800`. The minimum value is `100` and the maximum value is `4096`.
    """
    chunk_overlap_tokens: int
    """
    The number of tokens that overlap between chunks. The default value is `400`.

    Note that the overlap must not exceed half of `max_chunk_size_tokens`.

    """


class StaticChunkingStrategyRequestParam(BaseModel):
    """
    Customize your own chunking strategy by setting chunk size and chunk overlap.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["static"] = "static"
    """
    Always `static`.
    """
    static: StaticChunkingStrategy


class StaticChunkingStrategyResponseParam(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["static"] = "static"
    """
    Always `static`.
    """
    static: StaticChunkingStrategy


class StopConfiguration1(RootModel[list[str] | None]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[str] | None = Field(None, max_length=4, min_length=1)
    """
    Not supported with latest reasoning models `o3` and `o4-mini`.

    Up to 4 sequences where the API will stop generating further tokens. The
    returned text will not contain the stop sequence.

    """


class StopConfiguration(RootModel[str | StopConfiguration1 | None]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str | StopConfiguration1 | None = None
    """
    Not supported with latest reasoning models `o3` and `o4-mini`.

    Up to 4 sequences where the API will stop generating further tokens. The
    returned text will not contain the stop sequence.

    """


class ToolOutput(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    tool_call_id: str | None = None
    """
    The ID of the tool call in the `required_action` object within the run object the output is being submitted for.
    """
    output: str | None = None
    """
    The output of the tool call to be submitted to continue the run.
    """


class SubmitToolOutputsRunRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    tool_outputs: list[ToolOutput]
    """
    A list of tools for which the outputs are being submitted.
    """
    stream: bool | None = None
    """
    If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.

    """


class TextResponseFormatJsonSchema(BaseModel):
    """
    JSON Schema response format. Used to generate structured JSON responses.
    Learn more about [Structured Outputs](/docs/guides/structured-outputs).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["json_schema"] = "json_schema"
    """
    The type of response format being defined. Always `json_schema`.
    """
    description: str | None = None
    """
    A description of what the response format is for, used by the model to
    determine how to respond in the format.

    """
    name: str
    """
    The name of the response format. Must be a-z, A-Z, 0-9, or contain
    underscores and dashes, with a maximum length of 64.

    """
    schema_: ResponseFormatJsonSchemaSchema
    strict: bool | None = False
    """
    Whether to enable strict schema adherence when generating the output.
    If set to true, the model will always follow the exact schema defined
    in the `schema` field. Only a subset of JSON Schema is supported when
    `strict` is `true`. To learn more, read the [Structured Outputs
    guide](/docs/guides/structured-outputs).

    """


class ToolResources6(BaseModel):
    """
    A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code_interpreter: CodeInterpreter5 | None = None
    file_search: FileSearch8 | None = None


class ThreadObject(BaseModel):
    """
    Represents a thread that contains [messages](/docs/api-reference/messages).
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier, which can be referenced in API endpoints.
    """
    object: Literal["thread"] = "thread"
    """
    The object type, which is always `thread`.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the thread was created.
    """
    tool_resources: ToolResources6
    """
    A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """
    metadata: Metadata


class ThreadStreamEvent1(BaseModel):
    """
    Occurs when a new [thread](/docs/api-reference/threads/object) is created.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    enabled: bool | None = None
    """
    Whether to enable input audio transcription.
    """
    event: Literal["thread.created"] = "thread.created"
    data: ThreadObject


class ThreadStreamEvent(RootModel[ThreadStreamEvent1]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: ThreadStreamEvent1


class ToggleCertificatesRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    certificate_ids: list[str] = Field(..., max_length=10, min_length=1)


class ToolChoiceFunction(BaseModel):
    """
    Use this option to force the model to call a specific function.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["function"] = "function"
    """
    For function calling, the type is always `function`.
    """
    name: str
    """
    The name of the function to call.
    """


class ToolChoiceOptions(RootModel[Literal["none", "auto", "required"]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal["none", "auto", "required"] = Field(
        ..., title="Tool choice mode"
    )
    """
    Controls which (if any) tool is called by the model.

    `none` means the model will not call any tool and instead generates a message.

    `auto` means the model can pick between generating a message or calling one or
    more tools.

    `required` means the model must call one or more tools.

    """


class ToolChoiceTypes(BaseModel):
    """
    Indicates that the model should use a built-in tool to generate a response.
    [Learn more about built-in tools](/docs/guides/tools).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal[
        "file_search",
        "web_search_preview",
        "computer_use_preview",
        "web_search_preview_2025_03_11",
    ]
    """
    The type of hosted tool the model should to use. Learn more about
    [built-in tools](/docs/guides/tools).

    Allowed values are:
    - `file_search`
    - `web_search_preview`
    - `computer_use_preview`

    """


class Logprob1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    token: str | None = None
    """
    The token that was used to generate the log probability.

    """
    logprob: float | None = None
    """
    The log probability of the token.

    """
    bytes: list | None = None
    """
    The bytes that were used to generate the log probability.

    """


class TranscriptTextDeltaEvent(BaseModel):
    """
    Emitted when there is an additional text delta. This is also the first event emitted when the transcription starts. Only emitted when you [create a transcription](/docs/api-reference/audio/create-transcription) with the `Stream` parameter set to `true`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["TranscriptTextDeltaEvent"] = "TranscriptTextDeltaEvent"
    """
    The type of the event. Always `transcript.text.delta`.

    """
    delta: str
    """
    The text delta that was additionally transcribed.

    """
    logprobs: list[Logprob1] | None = None
    """
    The log probabilities of the delta. Only included if you [create a transcription](/docs/api-reference/audio/create-transcription) with the `include[]` parameter set to `logprobs`.

    """


class TranscriptTextDoneEvent(BaseModel):
    """
    Emitted when the transcription is complete. Contains the complete transcription text. Only emitted when you [create a transcription](/docs/api-reference/audio/create-transcription) with the `Stream` parameter set to `true`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["TranscriptTextDoneEvent"] = "TranscriptTextDoneEvent"
    """
    The type of the event. Always `transcript.text.done`.

    """
    text: str
    """
    The text that was transcribed.

    """
    logprobs: list[Logprob1] | None = None
    """
    The log probabilities of the individual tokens in the transcription. Only included if you [create a transcription](/docs/api-reference/audio/create-transcription) with the `include[]` parameter set to `logprobs`.

    """


class TranscriptionInclude(RootModel[Literal["logprobs"]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal["logprobs"] = "logprobs"


class TranscriptionSegment(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: int
    """
    Unique identifier of the segment.
    """
    seek: int
    """
    Seek offset of the segment.
    """
    start: float
    """
    Start time of the segment in seconds.
    """
    end: float
    """
    End time of the segment in seconds.
    """
    text: str
    """
    Text content of the segment.
    """
    tokens: list[int]
    """
    Array of token IDs for the text content.
    """
    temperature: float
    """
    Temperature parameter used for generating the segment.
    """
    avg_logprob: float
    """
    Average logprob of the segment. If the value is lower than -1, consider the logprobs failed.
    """
    compression_ratio: float
    """
    Compression ratio of the segment. If the value is greater than 2.4, consider the compression failed.
    """
    no_speech_prob: float
    """
    Probability of no speech in the segment. If the value is higher than 1.0 and the `avg_logprob` is below -1, consider this segment silent.
    """


class TranscriptionWord(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    word: str
    """
    The text content of the word.
    """
    start: float
    """
    Start time of the word in seconds.
    """
    end: float
    """
    End time of the word in seconds.
    """


class TruncationObject(BaseModel):
    """
    Controls for how a thread will be truncated prior to the run. Use this to control the intial context window of the run.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["auto", "last_messages"]
    """
    The truncation strategy to use for the thread. The default is `auto`. If set to `last_messages`, the thread will be truncated to the n most recent messages in the thread. When set to `auto`, messages in the middle of the thread will be dropped to fit the context length of the model, `max_prompt_tokens`.
    """
    last_messages: int | None = Field(None, ge=1)
    """
    The number of most recent messages from the thread when constructing the context for the run.
    """


class Type(BaseModel):
    """
    An action to type in text.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["type"] = "type"
    """
    Specifies the event type. For a type action, this property is 
    always set to `type`.

    """
    text: str
    """
    The text to type.

    """


class Upload(BaseModel):
    """
    The Upload object can accept byte chunks in the form of Parts.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The Upload unique identifier, which can be referenced in API endpoints.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the Upload was created.
    """
    filename: str
    """
    The name of the file to be uploaded.
    """
    bytes: int
    """
    The intended number of bytes to be uploaded.
    """
    purpose: str
    """
    The intended purpose of the file. [Please refer here](/docs/api-reference/files/object#files/object-purpose) for acceptable values.
    """
    status: Literal["pending", "completed", "cancelled", "expired"]
    """
    The status of the Upload.
    """
    expires_at: int
    """
    The Unix timestamp (in seconds) for when the Upload will expire.
    """
    object: Literal["upload"] | None = None
    """
    The object type, which is always "upload".
    """
    file: OpenAIFile | None = None


class UploadCertificateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str | None = None
    """
    An optional name for the certificate
    """
    content: str
    """
    The certificate content in PEM format
    """


class UploadPart(BaseModel):
    """
    The upload Part represents a chunk of bytes we can add to an Upload object.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The upload Part unique identifier, which can be referenced in API endpoints.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the Part was created.
    """
    upload_id: str
    """
    The ID of the Upload object that this Part was added to.
    """
    object: Literal["upload.part"] = "upload.part"
    """
    The object type, which is always `upload.part`.
    """


class UsageAudioSpeechesResult(BaseModel):
    """
    The aggregated audio speeches usage details of the specific time bucket.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.usage.audio_speeches.result"] = (
        "organization.usage.audio_speeches.result"
    )
    characters: int
    """
    The number of characters processed.
    """
    num_model_requests: int
    """
    The count of requests made to the model.
    """
    project_id: str | None = None
    """
    When `group_by=project_id`, this field provides the project ID of the grouped usage result.
    """
    user_id: str | None = None
    """
    When `group_by=user_id`, this field provides the user ID of the grouped usage result.
    """
    api_key_id: str | None = None
    """
    When `group_by=api_key_id`, this field provides the API key ID of the grouped usage result.
    """
    model: str | None = None
    """
    When `group_by=model`, this field provides the model name of the grouped usage result.
    """


class UsageAudioTranscriptionsResult(BaseModel):
    """
    The aggregated audio transcriptions usage details of the specific time bucket.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.usage.audio_transcriptions.result"] = (
        "organization.usage.audio_transcriptions.result"
    )
    seconds: int
    """
    The number of seconds processed.
    """
    num_model_requests: int
    """
    The count of requests made to the model.
    """
    project_id: str | None = None
    """
    When `group_by=project_id`, this field provides the project ID of the grouped usage result.
    """
    user_id: str | None = None
    """
    When `group_by=user_id`, this field provides the user ID of the grouped usage result.
    """
    api_key_id: str | None = None
    """
    When `group_by=api_key_id`, this field provides the API key ID of the grouped usage result.
    """
    model: str | None = None
    """
    When `group_by=model`, this field provides the model name of the grouped usage result.
    """


class UsageCodeInterpreterSessionsResult(BaseModel):
    """
    The aggregated code interpreter sessions usage details of the specific time bucket.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.usage.code_interpreter_sessions.result"] = (
        "organization.usage.code_interpreter_sessions.result"
    )
    num_sessions: int | None = None
    """
    The number of code interpreter sessions.
    """
    project_id: str | None = None
    """
    When `group_by=project_id`, this field provides the project ID of the grouped usage result.
    """


class UsageCompletionsResult(BaseModel):
    """
    The aggregated completions usage details of the specific time bucket.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.usage.completions.result"] = (
        "organization.usage.completions.result"
    )
    input_tokens: int
    """
    The aggregated number of text input tokens used, including cached tokens. For customers subscribe to scale tier, this includes scale tier tokens.
    """
    input_cached_tokens: int | None = None
    """
    The aggregated number of text input tokens that has been cached from previous requests. For customers subscribe to scale tier, this includes scale tier tokens.
    """
    output_tokens: int
    """
    The aggregated number of text output tokens used. For customers subscribe to scale tier, this includes scale tier tokens.
    """
    input_audio_tokens: int | None = None
    """
    The aggregated number of audio input tokens used, including cached tokens.
    """
    output_audio_tokens: int | None = None
    """
    The aggregated number of audio output tokens used.
    """
    num_model_requests: int
    """
    The count of requests made to the model.
    """
    project_id: str | None = None
    """
    When `group_by=project_id`, this field provides the project ID of the grouped usage result.
    """
    user_id: str | None = None
    """
    When `group_by=user_id`, this field provides the user ID of the grouped usage result.
    """
    api_key_id: str | None = None
    """
    When `group_by=api_key_id`, this field provides the API key ID of the grouped usage result.
    """
    model: str | None = None
    """
    When `group_by=model`, this field provides the model name of the grouped usage result.
    """
    batch: bool | None = None
    """
    When `group_by=batch`, this field tells whether the grouped usage result is batch or not.
    """


class UsageEmbeddingsResult(BaseModel):
    """
    The aggregated embeddings usage details of the specific time bucket.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.usage.embeddings.result"] = (
        "organization.usage.embeddings.result"
    )
    input_tokens: int
    """
    The aggregated number of input tokens used.
    """
    num_model_requests: int
    """
    The count of requests made to the model.
    """
    project_id: str | None = None
    """
    When `group_by=project_id`, this field provides the project ID of the grouped usage result.
    """
    user_id: str | None = None
    """
    When `group_by=user_id`, this field provides the user ID of the grouped usage result.
    """
    api_key_id: str | None = None
    """
    When `group_by=api_key_id`, this field provides the API key ID of the grouped usage result.
    """
    model: str | None = None
    """
    When `group_by=model`, this field provides the model name of the grouped usage result.
    """


class UsageImagesResult(BaseModel):
    """
    The aggregated images usage details of the specific time bucket.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.usage.images.result"] = (
        "organization.usage.images.result"
    )
    images: int
    """
    The number of images processed.
    """
    num_model_requests: int
    """
    The count of requests made to the model.
    """
    source: str | None = None
    """
    When `group_by=source`, this field provides the source of the grouped usage result, possible values are `image.generation`, `image.edit`, `image.variation`.
    """
    size: str | None = None
    """
    When `group_by=size`, this field provides the image size of the grouped usage result.
    """
    project_id: str | None = None
    """
    When `group_by=project_id`, this field provides the project ID of the grouped usage result.
    """
    user_id: str | None = None
    """
    When `group_by=user_id`, this field provides the user ID of the grouped usage result.
    """
    api_key_id: str | None = None
    """
    When `group_by=api_key_id`, this field provides the API key ID of the grouped usage result.
    """
    model: str | None = None
    """
    When `group_by=model`, this field provides the model name of the grouped usage result.
    """


class UsageModerationsResult(BaseModel):
    """
    The aggregated moderations usage details of the specific time bucket.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.usage.moderations.result"] = (
        "organization.usage.moderations.result"
    )
    input_tokens: int
    """
    The aggregated number of input tokens used.
    """
    num_model_requests: int
    """
    The count of requests made to the model.
    """
    project_id: str | None = None
    """
    When `group_by=project_id`, this field provides the project ID of the grouped usage result.
    """
    user_id: str | None = None
    """
    When `group_by=user_id`, this field provides the user ID of the grouped usage result.
    """
    api_key_id: str | None = None
    """
    When `group_by=api_key_id`, this field provides the API key ID of the grouped usage result.
    """
    model: str | None = None
    """
    When `group_by=model`, this field provides the model name of the grouped usage result.
    """


class UsageVectorStoresResult(BaseModel):
    """
    The aggregated vector stores usage details of the specific time bucket.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.usage.vector_stores.result"] = (
        "organization.usage.vector_stores.result"
    )
    usage_bytes: int
    """
    The vector stores usage in bytes.
    """
    project_id: str | None = None
    """
    When `group_by=project_id`, this field provides the project ID of the grouped usage result.
    """


class User(BaseModel):
    """
    Represents an individual `user` within an organization.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.user"] = "organization.user"
    """
    The object type, which is always `organization.user`
    """
    id: str
    """
    The identifier, which can be referenced in API endpoints
    """
    name: str
    """
    The name of the user
    """
    email: str
    """
    The email address of the user
    """
    role: Literal["owner", "reader"]
    """
    `owner` or `reader`
    """
    added_at: int
    """
    The Unix timestamp (in seconds) of when the user was added.
    """


class UserDeleteResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.user.deleted"] = "organization.user.deleted"
    id: str
    deleted: bool


class UserListResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    data: list[User]
    first_id: str
    last_id: str
    has_more: bool


class UserRoleUpdateRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: Literal["owner", "reader"]
    """
    `owner` or `reader`
    """


class VectorStoreExpirationAfter(BaseModel):
    """
    The expiration policy for a vector store.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    anchor: Literal["last_active_at"] = "last_active_at"
    """
    Anchor timestamp after which the expiration policy applies. Supported anchors: `last_active_at`.
    """
    days: int = Field(..., ge=1, le=365)
    """
    The number of days after the anchor time that the vector store will expire.
    """


class VectorStoreFileAttributes1(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str = Field(..., max_length=512)


class VectorStoreFileAttributes(
    RootModel[dict[str, VectorStoreFileAttributes1 | float | bool] | None]
):
    """
    Set of 16 key-value pairs that can be attached to an object. This can be
    useful for storing additional information about the object in a structured
    format, and querying for objects via API or the dashboard. Keys are strings
    with a maximum length of 64 characters. Values are strings with a maximum
    length of 512 characters, booleans, or numbers.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: dict[str, VectorStoreFileAttributes1 | float | bool] | None = None


class FileCounts(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    in_progress: int
    """
    The number of files that are currently being processed.
    """
    completed: int
    """
    The number of files that have been processed.
    """
    failed: int
    """
    The number of files that have failed to process.
    """
    cancelled: int
    """
    The number of files that where cancelled.
    """
    total: int
    """
    The total number of files.
    """


class VectorStoreFileBatchObject(BaseModel):
    """
    A batch of files attached to a vector store.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier, which can be referenced in API endpoints.
    """
    object: Literal["vector_store.files_batch"] = "vector_store.files_batch"
    """
    The object type, which is always `vector_store.file_batch`.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the vector store files batch was created.
    """
    vector_store_id: str
    """
    The ID of the [vector store](/docs/api-reference/vector-stores/object) that the [File](/docs/api-reference/files) is attached to.
    """
    status: Literal["in_progress", "completed", "cancelled", "failed"]
    """
    The status of the vector store files batch, which can be either `in_progress`, `completed`, `cancelled` or `failed`.
    """
    file_counts: FileCounts


class Datum2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: str | None = None
    """
    The content type (currently only `"text"`)
    """
    text: str | None = None
    """
    The text content
    """


class VectorStoreFileContentResponse(BaseModel):
    """
    Represents the parsed content of a vector store file.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["vector_store.file_content.page"] = (
        "vector_store.file_content.page"
    )
    """
    The object type, which is always `vector_store.file_content.page`
    """
    data: list[Datum2]
    """
    Parsed content of the file.
    """
    has_more: bool
    """
    Indicates if there are more content pages to fetch.
    """
    next_page: str
    """
    The token for the next page, if any.
    """


class LastError2(BaseModel):
    """
    The last error associated with this vector store file. Will be `null` if there are no errors.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code: Literal["server_error", "unsupported_file", "invalid_file"]
    """
    One of `server_error` or `rate_limit_exceeded`.
    """
    message: str
    """
    A human-readable description of the error.
    """


class VectorStoreFileObject(BaseModel):
    """
    A list of files attached to a vector store.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier, which can be referenced in API endpoints.
    """
    object: Literal["vector_store.file"] = "vector_store.file"
    """
    The object type, which is always `vector_store.file`.
    """
    usage_bytes: int
    """
    The total vector store usage in bytes. Note that this may be different from the original file size.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the vector store file was created.
    """
    vector_store_id: str
    """
    The ID of the [vector store](/docs/api-reference/vector-stores/object) that the [File](/docs/api-reference/files) is attached to.
    """
    status: Literal["in_progress", "completed", "cancelled", "failed"]
    """
    The status of the vector store file, which can be either `in_progress`, `completed`, `cancelled`, or `failed`. The status `completed` indicates that the vector store file is ready for use.
    """
    last_error: LastError2
    """
    The last error associated with this vector store file. Will be `null` if there are no errors.
    """
    chunking_strategy: (
        StaticChunkingStrategyResponseParam
        | OtherChunkingStrategyResponseParam
        | None
    ) = None
    """
    The strategy used to chunk the file.
    """
    attributes: VectorStoreFileAttributes | None = None


class FileCounts1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    in_progress: int
    """
    The number of files that are currently being processed.
    """
    completed: int
    """
    The number of files that have been successfully processed.
    """
    failed: int
    """
    The number of files that have failed to process.
    """
    cancelled: int
    """
    The number of files that were cancelled.
    """
    total: int
    """
    The total number of files.
    """


class VectorStoreObject(BaseModel):
    """
    A vector store is a collection of processed files can be used by the `file_search` tool.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier, which can be referenced in API endpoints.
    """
    object: Literal["vector_store"] = "vector_store"
    """
    The object type, which is always `vector_store`.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the vector store was created.
    """
    name: str
    """
    The name of the vector store.
    """
    usage_bytes: int
    """
    The total number of bytes used by the files in the vector store.
    """
    file_counts: FileCounts1
    status: Literal["expired", "in_progress", "completed"]
    """
    The status of the vector store, which can be either `expired`, `in_progress`, or `completed`. A status of `completed` indicates that the vector store is ready for use.
    """
    expires_after: VectorStoreExpirationAfter | None = None
    expires_at: int | None = None
    """
    The Unix timestamp (in seconds) for when the vector store will expire.
    """
    last_active_at: int
    """
    The Unix timestamp (in seconds) for when the vector store was last active.
    """
    metadata: Metadata


class QueryItem(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str = Field(..., min_length=1)
    """
    A list of queries to search for.
    """


class RankingOptions(BaseModel):
    """
    Ranking options for search.
    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    ranker: Literal["auto", "default-2024-11-15"] | None = "auto"
    score_threshold: float | None = Field(0, ge=0.0, le=1.0)


class VectorStoreSearchRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    query: str | list[QueryItem]
    """
    A query string for a search
    """
    rewrite_query: bool | None = False
    """
    Whether to rewrite the natural language query for vector search.
    """
    max_num_results: int | None = Field(10, ge=1, le=50)
    """
    The maximum number of results to return. This number should be between 1 and 50 inclusive.
    """
    filters: ComparisonFilter | CompoundFilter | None = None
    """
    A filter to apply based on file attributes.
    """
    ranking_options: RankingOptions | None = None
    """
    Ranking options for search.
    """


class VectorStoreSearchResultContentObject(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    type: Literal["text"] = "text"
    """
    The type of content.
    """
    text: str
    """
    The text content returned from search.
    """


class VectorStoreSearchResultItem(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    file_id: str
    """
    The ID of the vector store file.
    """
    filename: str
    """
    The name of the vector store file.
    """
    score: float = Field(..., ge=0.0, le=1.0)
    """
    The similarity score for the result.
    """
    attributes: VectorStoreFileAttributes
    content: list[VectorStoreSearchResultContentObject]
    """
    Content chunks from the file.
    """


class SearchQueryItem(RootModel[str]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: str = Field(..., min_length=1)
    """
    The query used for this search.
    """


class VectorStoreSearchResultsPage(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    object: Literal["vector_store.search_results.page"] = (
        "vector_store.search_results.page"
    )
    """
    The object type, which is always `vector_store.search_results.page`
    """
    search_query: list[SearchQueryItem]
    data: list[VectorStoreSearchResultItem]
    """
    The list of search result items.
    """
    has_more: bool
    """
    Indicates if there are more results to fetch.
    """
    next_page: str
    """
    The token for the next page, if any.
    """


class VoiceIdsShared(
    RootModel[
        str
        | Literal[
            "alloy",
            "ash",
            "ballad",
            "coral",
            "echo",
            "fable",
            "onyx",
            "nova",
            "sage",
            "shimmer",
            "verse",
        ]
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        str
        | Literal[
            "alloy",
            "ash",
            "ballad",
            "coral",
            "echo",
            "fable",
            "onyx",
            "nova",
            "sage",
            "shimmer",
            "verse",
        ]
    ) = Field(..., examples=["ash"])


class Wait(BaseModel):
    """
    A wait action.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["wait"] = "wait"
    """
    Specifies the event type. For a wait action, this property is 
    always set to `wait`.

    """


class WebSearchContextSize(RootModel[Literal["low", "medium", "high"]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal["low", "medium", "high"]
    """
    High level guidance for the amount of context window space to use for the 
    search. One of `low`, `medium`, or `high`. `medium` is the default.

    """


class WebSearchLocation(BaseModel):
    """
    Approximate location parameters for the search.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    country: str | None = None
    """
    The two-letter 
    [ISO country code](https://en.wikipedia.org/wiki/ISO_3166-1) of the user,
    e.g. `US`.

    """
    region: str | None = None
    """
    Free text input for the region of the user, e.g. `California`.

    """
    city: str | None = None
    """
    Free text input for the city of the user, e.g. `San Francisco`.

    """
    timezone: str | None = None
    """
    The [IANA timezone](https://timeapi.io/documentation/iana-timezones) 
    of the user, e.g. `America/Los_Angeles`.

    """


class WebSearchToolCall(BaseModel):
    """
    The results of a web search tool call. See the
    [web search guide](/docs/guides/tools-web-search) for more information.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The unique ID of the web search tool call.

    """
    type: Literal["WebSearchToolCall"] = "WebSearchToolCall"
    """
    The type of the web search tool call. Always `web_search_call`.

    """
    status: Literal["in_progress", "searching", "completed", "failed"]
    """
    The status of the web search tool call.

    """


class InputTextContent(BaseModel):
    """
    A text input to the model.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["input_text"] = "input_text"
    """
    The type of the input item. Always `input_text`.
    """
    text: str
    """
    The text input to the model.
    """


class InputImageContent(BaseModel):
    """
    An image input to the model. Learn about [image inputs](/docs/guides/vision).
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["input_image"] = "input_image"
    """
    The type of the input item. Always `input_image`.
    """
    image_url: str | None = None
    file_id: str | None = None
    detail: Literal["low", "high", "auto"]
    """
    The detail level of the image to be sent to the model. One of `high`, `low`, or `auto`. Defaults to `auto`.
    """


class InputFileContent(BaseModel):
    """
    A file input to the model.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["input_file"] = "input_file"
    """
    The type of the input item. Always `input_file`.
    """
    file_id: str | None = None
    filename: str | None = None
    """
    The name of the file to be sent to the model.
    """
    file_data: str | None = None
    """
    The content of the file to be sent to the model.

    """


class RankingOptions1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    ranker: Literal["auto", "default-2024-11-15"] | None = None
    """
    The ranker to use for the file search.
    """
    score_threshold: float | None = None
    """
    The score threshold for the file search, a number between 0 and 1. Numbers closer to 1 will attempt to return only the most relevant results, but may return fewer results.
    """


class Filters(RootModel[ComparisonFilter | CompoundFilter]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: ComparisonFilter | CompoundFilter


class FileSearchTool(BaseModel):
    """
    A tool that searches for relevant content from uploaded files. Learn more about the [file search tool](https://platform.openai.com/docs/guides/tools-file-search).
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["FileSearchTool"] = "FileSearchTool"
    """
    The type of the file search tool. Always `file_search`.
    """
    vector_store_ids: list[str]
    """
    The IDs of the vector stores to search.
    """
    max_num_results: int | None = None
    """
    The maximum number of results to return. This number should be between 1 and 50 inclusive.
    """
    ranking_options: RankingOptions1 | None = None
    """
    Ranking options for search.
    """
    filters: Filters | None = None


class FunctionTool(BaseModel):
    """
    Defines a function in your own code the model can choose to call. Learn more about [function calling](https://platform.openai.com/docs/guides/function-calling).
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["FunctionTool"] = "FunctionTool"
    """
    The type of the function tool. Always `function`.
    """
    name: str
    """
    The name of the function to call.
    """
    description: str | None = None
    parameters: dict[str, Any] | None = None
    strict: bool | None = None


class ApproximateLocation(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["approximate"] = "approximate"
    """
    The type of location approximation. Always `approximate`.
    """
    country: str | None = None
    region: str | None = None
    city: str | None = None
    timezone: str | None = None


class WebSearchPreviewTool(BaseModel):
    """
    This tool searches the web for relevant results to use in a response. Learn more about the [web search tool](https://platform.openai.com/docs/guides/tools-web-search).
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["WebSearchPreviewTool"] = "WebSearchPreviewTool"
    """
    The type of the web search tool. One of `web_search_preview` or `web_search_preview_2025_03_11`.
    """
    user_location: ApproximateLocation | None = None
    search_context_size: Literal["low", "medium", "high"] | None = None
    """
    High level guidance for the amount of context window space to use for the search. One of `low`, `medium`, or `high`. `medium` is the default.
    """


class ComputerUsePreviewTool(BaseModel):
    """
    A tool that controls a virtual computer. Learn more about the [computer tool](https://platform.openai.com/docs/guides/tools-computer-use).
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ComputerUsePreviewTool"] = "ComputerUsePreviewTool"
    """
    The type of the computer use tool. Always `computer_use_preview`.
    """
    environment: Literal["windows", "mac", "linux", "ubuntu", "browser"]
    """
    The type of computer environment to control.
    """
    display_width: int
    """
    The width of the computer display.
    """
    display_height: int
    """
    The height of the computer display.
    """


class ToolModel(
    RootModel[
        FileSearchTool
        | FunctionTool
        | WebSearchPreviewTool
        | ComputerUsePreviewTool
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        FileSearchTool
        | FunctionTool
        | WebSearchPreviewTool
        | ComputerUsePreviewTool
    ) = Field(..., discriminator="type")


class FileCitationBody(BaseModel):
    """
    A citation to a file.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["FileCitationBody"] = "FileCitationBody"
    """
    The type of the file citation. Always `file_citation`.
    """
    file_id: str
    """
    The ID of the file.
    """
    index: int
    """
    The index of the file in the list of files.
    """


class UrlCitationBody(BaseModel):
    """
    A citation for a web resource used to generate a model response.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["UrlCitationBody"] = "UrlCitationBody"
    """
    The type of the URL citation. Always `url_citation`.
    """
    url: str
    """
    The URL of the web resource.
    """
    start_index: int
    """
    The index of the first character of the URL citation in the message.
    """
    end_index: int
    """
    The index of the last character of the URL citation in the message.
    """
    title: str
    """
    The title of the web resource.
    """


class AnnotationModel(
    RootModel[FileCitationBody | UrlCitationBody | FilePath]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: FileCitationBody | UrlCitationBody | FilePath = Field(
        ..., discriminator="type"
    )


class OutputTextContent(BaseModel):
    """
    A text output from the model.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["output_text"] = "output_text"
    """
    The type of the output text. Always `output_text`.
    """
    text: str
    """
    The text output from the model.
    """
    annotations: list[AnnotationModel]
    """
    The annotations of the text output.
    """


class RefusalContent(BaseModel):
    """
    A refusal from the model.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["refusal"] = "refusal"
    """
    The type of the refusal. Always `refusal`.
    """
    refusal: str
    """
    The refusal explanationfrom the model.
    """


class ComputerCallSafetyCheckParam(BaseModel):
    """
    A pending safety check for the computer call.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The ID of the pending safety check.
    """
    code: str | None = None
    message: str | None = None


class ComputerCallOutputItemParam(BaseModel):
    """
    The output of a computer tool call.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    call_id: str = Field(..., max_length=64, min_length=1)
    """
    The ID of the computer tool call that produced the output.
    """
    type: Literal["ComputerCallOutputItemParam"] = (
        "ComputerCallOutputItemParam"
    )
    """
    The type of the computer tool call output. Always `computer_call_output`.
    """
    output: ComputerScreenshotImage
    acknowledged_safety_checks: list[ComputerCallSafetyCheckParam] | None = (
        None
    )
    status: Literal["in_progress", "completed", "incomplete"] | None = None


class FunctionCallOutputItemParam(BaseModel):
    """
    The output of a function tool call.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    call_id: str = Field(..., max_length=64, min_length=1)
    """
    The unique ID of the function tool call generated by the model.
    """
    type: Literal["FunctionCallOutputItemParam"] = (
        "FunctionCallOutputItemParam"
    )
    """
    The type of the function tool call output. Always `function_call_output`.
    """
    output: str = Field(..., max_length=10485760)
    """
    A JSON string of the output of the function tool call.
    """
    status: Literal["in_progress", "completed", "incomplete"] | None = None


class ItemReferenceParam(BaseModel):
    """
    An internal identifier for an item to reference.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ItemReferenceParam"] = "ItemReferenceParam"
    id: str
    """
    The ID of the item to reference.
    """


class FileSearch1(BaseModel):
    """
    Overrides for the file search tool.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    max_num_results: int | None = Field(None, ge=1, le=50)
    """
    The maximum number of results the file search tool should output. The default is 20 for `gpt-4*` models and 5 for `gpt-3.5-turbo`. This number should be between 1 and 50 inclusive.

    Note that the file search tool may output fewer than `max_num_results` results. See the [file search tool documentation](/docs/assistants/tools/file-search#customizing-file-search-settings) for more information.

    """
    ranking_options: FileSearchRankingOptions | None = None


class AssistantToolsFileSearch(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["file_search"] = "file_search"
    """
    The type of tool being defined: `file_search`
    """
    file_search: FileSearch1 | None = None
    """
    Overrides for the file search tool.
    """


class AssistantsApiToolChoiceOption(
    RootModel[Literal["none", "auto", "required"] | AssistantsNamedToolChoice]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Literal["none", "auto", "required"] | AssistantsNamedToolChoice
    """
    Controls which (if any) tool is called by the model.
    `none` means the model will not call any tools and instead generates a message.
    `auto` is the default value and means the model can pick between generating a message or calling one or more tools.
    `required` means the model must call one or more tools before responding to the user.
    Specifying a particular tool like `{"type": "file_search"}` or `{"type": "function", "function": {"name": "my_function"}}` forces the model to call that tool.

    """


class AuditLogActorApiKey(BaseModel):
    """
    The API Key used to perform the audit logged action.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The tracking id of the API key.
    """
    type: Literal["user", "service_account"] | None = None
    """
    The type of API key. Can be either `user` or `service_account`.
    """
    user: AuditLogActorUser | None = None
    service_account: AuditLogActorServiceAccount | None = None


class AuditLogActorSession(BaseModel):
    """
    The session in which the audit logged action was performed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    user: AuditLogActorUser | None = None
    ip_address: str | None = None
    """
    The IP address from which the action was performed.
    """


class Batch(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    object: Literal["batch"] = "batch"
    """
    The object type, which is always `batch`.
    """
    endpoint: str
    """
    The OpenAI API endpoint used by the batch.
    """
    errors: Errors | None = None
    input_file_id: str
    """
    The ID of the input file for the batch.
    """
    completion_window: str
    """
    The time frame within which the batch should be processed.
    """
    status: Literal[
        "validating",
        "failed",
        "in_progress",
        "finalizing",
        "completed",
        "expired",
        "cancelling",
        "cancelled",
    ]
    """
    The current status of the batch.
    """
    output_file_id: str | None = None
    """
    The ID of the file containing the outputs of successfully executed requests.
    """
    error_file_id: str | None = None
    """
    The ID of the file containing the outputs of requests with errors.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the batch was created.
    """
    in_progress_at: int | None = None
    """
    The Unix timestamp (in seconds) for when the batch started processing.
    """
    expires_at: int | None = None
    """
    The Unix timestamp (in seconds) for when the batch will expire.
    """
    finalizing_at: int | None = None
    """
    The Unix timestamp (in seconds) for when the batch started finalizing.
    """
    completed_at: int | None = None
    """
    The Unix timestamp (in seconds) for when the batch was completed.
    """
    failed_at: int | None = None
    """
    The Unix timestamp (in seconds) for when the batch failed.
    """
    expired_at: int | None = None
    """
    The Unix timestamp (in seconds) for when the batch expired.
    """
    cancelling_at: int | None = None
    """
    The Unix timestamp (in seconds) for when the batch started cancelling.
    """
    cancelled_at: int | None = None
    """
    The Unix timestamp (in seconds) for when the batch was cancelled.
    """
    request_counts: RequestCounts | None = None
    """
    The request counts for different statuses within the batch.
    """
    metadata: Metadata | None = None


class ChatCompletionFunctions(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    description: str | None = None
    """
    A description of what the function does, used by the model to choose when and how to call the function.
    """
    name: str
    """
    The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.
    """
    parameters: FunctionParameters | None = None


class Datum1(ChatCompletionResponseMessage):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier of the chat message.
    """


class ChatCompletionMessageList(BaseModel):
    """
    An object representing a list of chat completion messages.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    """
    The type of this object. It is always set to "list".

    """
    data: list[Datum1]
    """
    An array of chat completion message objects.

    """
    first_id: str
    """
    The identifier of the first chat message in the data array.
    """
    last_id: str
    """
    The identifier of the last chat message in the data array.
    """
    has_more: bool
    """
    Indicates whether there are more chat messages available.
    """


class ChatCompletionRequestAssistantMessageContentPart(
    RootModel[
        ChatCompletionRequestMessageContentPartText
        | ChatCompletionRequestMessageContentPartRefusal
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        ChatCompletionRequestMessageContentPartText
        | ChatCompletionRequestMessageContentPartRefusal
    )


class Content1(RootModel[list[ChatCompletionRequestMessageContentPartText]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[ChatCompletionRequestMessageContentPartText] = Field(
        ..., min_length=1, title="Array of content parts"
    )
    """
    An array of content parts with a defined type. For developer messages, only type `text` is supported.
    """


class ChatCompletionRequestDeveloperMessage(BaseModel):
    """
    Developer-provided instructions that the model should follow, regardless of
    messages sent by the user. With o1 models and newer, `developer` messages
    replace the previous `system` messages.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str | Content1
    """
    The contents of the developer message.
    """
    role: Literal["developer"] = "developer"
    """
    The role of the messages author, in this case `developer`.
    """
    name: str | None = None
    """
    An optional name for the participant. Provides the model information to differentiate between participants of the same role.
    """


class Content2(RootModel[list[ChatCompletionRequestSystemMessageContentPart]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[ChatCompletionRequestSystemMessageContentPart] = Field(
        ..., min_length=1, title="Array of content parts"
    )
    """
    An array of content parts with a defined type. For system messages, only type `text` is supported.
    """


class ChatCompletionRequestSystemMessage(BaseModel):
    """
    Developer-provided instructions that the model should follow, regardless of
    messages sent by the user. With o1 models and newer, use `developer` messages
    for this purpose instead.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str | Content2
    """
    The contents of the system message.
    """
    role: Literal["system"] = "system"
    """
    The role of the messages author, in this case `system`.
    """
    name: str | None = None
    """
    An optional name for the participant. Provides the model information to differentiate between participants of the same role.
    """


class Content3(RootModel[list[ChatCompletionRequestToolMessageContentPart]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[ChatCompletionRequestToolMessageContentPart] = Field(
        ..., min_length=1, title="Array of content parts"
    )
    """
    An array of content parts with a defined type. For tool messages, only type `text` is supported.
    """


class ChatCompletionRequestToolMessage(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: Literal["tool"] = "tool"
    """
    The role of the messages author, in this case `tool`.
    """
    content: str | Content3
    """
    The contents of the tool message.
    """
    tool_call_id: str
    """
    Tool call that this message is responding to.
    """


class Content4(RootModel[list[ChatCompletionRequestUserMessageContentPart]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[ChatCompletionRequestUserMessageContentPart] = Field(
        ..., min_length=1, title="Array of content parts"
    )
    """
    An array of content parts with a defined type. Supported options differ based on the [model](/docs/models) being used to generate the response. Can contain text, image, or audio inputs.
    """


class ChatCompletionRequestUserMessage(BaseModel):
    """
    Messages sent by an end user, containing prompts or additional context
    information.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str | Content4
    """
    The contents of the user message.

    """
    role: Literal["user"] = "user"
    """
    The role of the messages author, in this case `user`.
    """
    name: str | None = None
    """
    An optional name for the participant. Provides the model information to differentiate between participants of the same role.
    """


class ChunkingStrategyRequestParam(
    RootModel[
        AutoChunkingStrategyRequestParam | StaticChunkingStrategyRequestParam
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: AutoChunkingStrategyRequestParam | StaticChunkingStrategyRequestParam
    """
    The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
    """


class CodeInterpreterToolCall(BaseModel):
    """
    A tool call to run code.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The unique ID of the code interpreter tool call.

    """
    type: Literal["code_interpreter_call"] = "code_interpreter_call"
    """
    The type of the code interpreter tool call. Always `code_interpreter_call`.

    """
    code: str
    """
    The code to run.

    """
    status: Literal["in_progress", "interpreting", "completed"]
    """
    The status of the code interpreter tool call.

    """
    results: list[CodeInterpreterToolOutput]
    """
    The results of the code interpreter tool call.

    """


class ComputerAction(
    RootModel[
        Click
        | DoubleClick
        | Drag
        | KeyPress
        | Move
        | Screenshot
        | Scroll
        | Type
        | Wait
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        Click
        | DoubleClick
        | Drag
        | KeyPress
        | Move
        | Screenshot
        | Scroll
        | Type
        | Wait
    )


class ComputerToolCall(BaseModel):
    """
    A tool call to a computer use tool. See the
    [computer use guide](/docs/guides/tools-computer-use) for more information.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ComputerToolCall"] = "ComputerToolCall"
    """
    The type of the computer call. Always `computer_call`.
    """
    id: str
    """
    The unique ID of the computer call.
    """
    call_id: str
    """
    An identifier used when responding to the tool call with output.

    """
    action: ComputerAction
    pending_safety_checks: list[ComputerToolCallSafetyCheck]
    """
    The pending safety checks for the computer call.

    """
    status: Literal["in_progress", "completed", "incomplete"]
    """
    The status of the item. One of `in_progress`, `completed`, or
    `incomplete`. Populated when items are returned via API.

    """


class ComputerToolCallOutput(BaseModel):
    """
    The output of a computer tool call.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["computer_call_output"] = "computer_call_output"
    """
    The type of the computer tool call output. Always `computer_call_output`.

    """
    id: str | None = None
    """
    The ID of the computer tool call output.

    """
    call_id: str
    """
    The ID of the computer tool call that produced the output.

    """
    acknowledged_safety_checks: list[ComputerToolCallSafetyCheck] | None = None
    """
    The safety checks reported by the API that have been acknowledged by the 
    developer.

    """
    output: ComputerScreenshotImage
    status: Literal["in_progress", "completed", "incomplete"] | None = None
    """
    The status of the message input. One of `in_progress`, `completed`, or
    `incomplete`. Populated when input items are returned via API.

    """


class ComputerToolCallOutputResource(ComputerToolCallOutput):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The unique ID of the computer call tool output.

    """
    type: Literal["ComputerToolCallOutputResource"] = (
        "ComputerToolCallOutputResource"
    )


class VectorStore(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_ids: list[str] | None = Field(None, max_length=10000)
    """
    A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.

    """
    chunking_strategy: ChunkingStrategy | ChunkingStrategy1 | None = None
    """
    The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
    """
    metadata: Metadata | None = None


class FileSearch2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    vector_store_ids: list[str] = Field(..., max_length=1)
    """
    The [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.

    """
    vector_stores: list[VectorStore] | None = Field(None, max_length=1)
    """
    A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this assistant. There can be a maximum of 1 vector store attached to the assistant.

    """


class VectorStore1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_ids: list[str] | None = Field(None, max_length=10000)
    """
    A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.

    """
    chunking_strategy: ChunkingStrategy2 | ChunkingStrategy3 | None = None
    """
    The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
    """
    metadata: Metadata | None = None


class FileSearch3(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    vector_store_ids: list[str] | None = Field(None, max_length=1)
    """
    The [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.

    """
    vector_stores: list[VectorStore1] = Field(..., max_length=1)
    """
    A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this assistant. There can be a maximum of 1 vector store attached to the assistant.

    """


class ToolResources1(BaseModel):
    """
    A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code_interpreter: CodeInterpreter1 | None = None
    file_search: FileSearch2 | FileSearch3 | None = None


class UserLocation(BaseModel):
    """
    Approximate location parameters for the search.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["approximate"] = "approximate"
    """
    The type of location approximation. Always `approximate`.

    """
    approximate: WebSearchLocation


class WebSearchOptions(BaseModel):
    """
    This tool searches the web for relevant results to use in a response.
    Learn more about the [web search tool](/docs/guides/tools-web-search?api-mode=chat).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    user_location: UserLocation | None = None
    """
    Approximate location parameters for the search.

    """
    search_context_size: WebSearchContextSize | None = Field(
        default_factory=lambda: WebSearchContextSize.model_validate("medium")
    )


class Audio2(BaseModel):
    """
    Parameters for audio output. Required when audio output is requested with
    `modalities: ["audio"]`. [Learn more](/docs/guides/audio).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    voice: VoiceIdsShared
    """
    The voice the model uses to respond. Supported voices are 
    `alloy`, `ash`, `ballad`, `coral`, `echo`, `fable`, `nova`, `onyx`, `sage`, and `shimmer`.

    """
    format: Literal["wav", "aac", "mp3", "flac", "opus", "pcm16"]
    """
    Specifies the output audio format. Must be one of `wav`, `mp3`, `flac`,
    `opus`, or `pcm16`.

    """


class CreateChatCompletionResponse(BaseModel):
    """
    Represents a chat completion response returned by model, based on the provided input.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    A unique identifier for the chat completion.
    """
    choices: list[Choice]
    """
    A list of chat completion choices. Can be more than one if `n` is greater than 1.
    """
    created: int
    """
    The Unix timestamp (in seconds) of when the chat completion was created.
    """
    model: str
    """
    The model used for the chat completion.
    """
    service_tier: ServiceTier | None = Field(
        default_factory=lambda: ServiceTier.model_validate("auto")
    )
    system_fingerprint: str | None = None
    """
    This fingerprint represents the backend configuration that the model runs with.

    Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.

    """
    object: Literal["chat.completion"] = "chat.completion"
    """
    The object type, which is always `chat.completion`.
    """
    usage: CompletionUsage | None = None


class CreateChatCompletionStreamResponse(BaseModel):
    """
    Represents a streamed chunk of a chat completion response returned
    by the model, based on the provided input.
    [Learn more](/docs/guides/streaming-responses).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    A unique identifier for the chat completion. Each chunk has the same ID.
    """
    choices: list[Choice1]
    """
    A list of chat completion choices. Can contain more than one elements if `n` is greater than 1. Can also be empty for the
    last chunk if you set `stream_options: {"include_usage": true}`.

    """
    created: int
    """
    The Unix timestamp (in seconds) of when the chat completion was created. Each chunk has the same timestamp.
    """
    model: str
    """
    The model to generate the completion.
    """
    service_tier: ServiceTier | None = Field(
        default_factory=lambda: ServiceTier.model_validate("auto")
    )
    system_fingerprint: str | None = None
    """
    This fingerprint represents the backend configuration that the model runs with.
    Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.

    """
    object: Literal["chat.completion.chunk"] = "chat.completion.chunk"
    """
    The object type, which is always `chat.completion.chunk`.
    """
    usage: CompletionUsage | None = None
    """
    An optional field that will only be present when you set
    `stream_options: {"include_usage": true}` in your request. When present, it
    contains a null value **except for the last chunk** which contains the
    token usage statistics for the entire request.

    **NOTE:** If the stream is interrupted or cancelled, you may not
    receive the final usage chunk which contains the total token usage for
    the request.

    """


class CreateCompletionRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    model: (
        str | Literal["gpt-3.5-turbo-instruct", "davinci-002", "babbage-002"]
    )
    """
    ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models) for descriptions of them.

    """
    prompt: str | list[str] | Prompt | Prompt1
    """
    The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays.

    Note that <|endoftext|> is the document separator that the model sees during training, so if a prompt is not specified the model will generate as if from the beginning of a new document.

    """
    best_of: int | None = Field(1, ge=0, le=20)
    """
    Generates `best_of` completions server-side and returns the "best" (the one with the highest log probability per token). Results cannot be streamed.

    When used with `n`, `best_of` controls the number of candidate completions and `n` specifies how many to return – `best_of` must be greater than `n`.

    **Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.

    """
    echo: bool | None = False
    """
    Echo back the prompt in addition to the completion

    """
    frequency_penalty: float | None = Field(0, ge=-2.0, le=2.0)
    """
    Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.

    [See more information about frequency and presence penalties.](/docs/guides/text-generation)

    """
    logit_bias: dict[str, int] | None = None
    """
    Modify the likelihood of specified tokens appearing in the completion.

    Accepts a JSON object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.

    As an example, you can pass `{"50256": -100}` to prevent the <|endoftext|> token from being generated.

    """
    logprobs: int | None = Field(None, ge=0, le=5)
    """
    Include the log probabilities on the `logprobs` most likely output tokens, as well the chosen tokens. For example, if `logprobs` is 5, the API will return a list of the 5 most likely tokens. The API will always return the `logprob` of the sampled token, so there may be up to `logprobs+1` elements in the response.

    The maximum value for `logprobs` is 5.

    """
    max_tokens: int | None = Field(16, examples=[16], ge=0)
    """
    The maximum number of [tokens](/tokenizer) that can be generated in the completion.

    The token count of your prompt plus `max_tokens` cannot exceed the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.

    """
    n: int | None = Field(1, examples=[1], ge=1, le=128)
    """
    How many completions to generate for each prompt.

    **Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.

    """
    presence_penalty: float | None = Field(0, ge=-2.0, le=2.0)
    """
    Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.

    [See more information about frequency and presence penalties.](/docs/guides/text-generation)

    """
    seed: int | None = None
    """
    If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.

    Determinism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.

    """
    stop: StopConfiguration | None = None
    stream: bool | None = False
    """
    Whether to stream back partial progress. If set, tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).

    """
    stream_options: ChatCompletionStreamOptions | None = None
    suffix: str | None = Field(None, examples=["test."])
    """
    The suffix that comes after a completion of inserted text.

    This parameter is only supported for `gpt-3.5-turbo-instruct`.

    """
    temperature: float | None = Field(1, examples=[1], ge=0.0, le=2.0)
    """
    What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.

    We generally recommend altering this or `top_p` but not both.

    """
    top_p: float | None = Field(1, examples=[1], ge=0.0, le=1.0)
    """
    An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.

    We generally recommend altering this or `temperature` but not both.

    """
    user: str | None = Field(None, examples=["user-1234"])
    """
    A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices#end-user-ids).

    """


class CreateEmbeddingResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: list[Embedding]
    """
    The list of embeddings generated by the model.
    """
    model: str
    """
    The name of the model used to generate the embedding.
    """
    object: Literal["list"] = "list"
    """
    The object type, which is always "list".
    """
    usage: Usage
    """
    The usage information for the request.
    """


class CreateEvalJsonlRunDataSource(BaseModel):
    """
    A JsonlRunDataSource object with that specifies a JSONL file that matches the eval

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["jsonl"] = "jsonl"
    """
    The type of data source. Always `jsonl`.
    """
    source: EvalJsonlFileContentSource | EvalJsonlFileIdSource


class Content6(
    RootModel[
        list[
            MessageContentImageFileObject
            | MessageContentImageUrlObject
            | MessageRequestContentTextObject
        ]
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[
        MessageContentImageFileObject
        | MessageContentImageUrlObject
        | MessageRequestContentTextObject
    ] = Field(..., min_length=1, title="Array of content parts")
    """
    An array of content parts with a defined type, each can be of type `text` or images can be passed with `image_url` or `image_file`. Image types are only supported on [Vision-compatible models](/docs/models).
    """


class CreateMessageRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    role: Literal["user", "assistant"]
    """
    The role of the entity that is creating the message. Allowed values include:
    - `user`: Indicates the message is sent by an actual user and should be used in most cases to represent user-generated messages.
    - `assistant`: Indicates the message is generated by the assistant. Use this value to insert messages from the assistant into the conversation.

    """
    content: str | Content6
    attachments: list[Attachment] | None = None
    """
    A list of files attached to the message, and the tools they should be added to.
    """
    metadata: Metadata | None = None


class CreateSpeechRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    model: str | Literal["tts-1", "tts-1-hd", "gpt-4o-mini-tts"]
    """
    One of the available [TTS models](/docs/models#tts): `tts-1`, `tts-1-hd` or `gpt-4o-mini-tts`.

    """
    input: str = Field(..., max_length=4096)
    """
    The text to generate audio for. The maximum length is 4096 characters.
    """
    instructions: str | None = Field(None, max_length=4096)
    """
    Control the voice of your generated audio with additional instructions. Does not work with `tts-1` or `tts-1-hd`.
    """
    voice: VoiceIdsShared
    """
    The voice to use when generating the audio. Supported voices are `alloy`, `ash`, `ballad`, `coral`, `echo`, `fable`, `onyx`, `nova`, `sage`, `shimmer`, and `verse`. Previews of the voices are available in the [Text to speech guide](/docs/guides/text-to-speech#voice-options).
    """
    response_format: (
        Literal["mp3", "opus", "aac", "flac", "wav", "pcm"] | None
    ) = "mp3"
    """
    The format to audio in. Supported formats are `mp3`, `opus`, `aac`, `flac`, `wav`, and `pcm`.
    """
    speed: float | None = Field(1, ge=0.25, le=4.0)
    """
    The speed of the generated audio. Select a value from `0.25` to `4.0`. `1.0` is the default.
    """


class VectorStore2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_ids: list[str] | None = Field(None, max_length=10000)
    """
    A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.

    """
    chunking_strategy: ChunkingStrategy4 | ChunkingStrategy5 | None = None
    """
    The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
    """
    metadata: Metadata | None = None


class FileSearch5(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    vector_store_ids: list[str] = Field(..., max_length=1)
    """
    The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.

    """
    vector_stores: list[VectorStore2] | None = Field(None, max_length=1)
    """
    A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this thread. There can be a maximum of 1 vector store attached to the thread.

    """


class VectorStore3(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_ids: list[str] | None = Field(None, max_length=10000)
    """
    A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.

    """
    chunking_strategy: ChunkingStrategy6 | ChunkingStrategy7 | None = None
    """
    The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.
    """
    metadata: Metadata | None = None


class FileSearch6(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    vector_store_ids: list[str] | None = Field(None, max_length=1)
    """
    The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.

    """
    vector_stores: list[VectorStore3] = Field(..., max_length=1)
    """
    A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this thread. There can be a maximum of 1 vector store attached to the thread.

    """


class ToolResources3(BaseModel):
    """
    A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code_interpreter: CodeInterpreter1 | None = None
    file_search: FileSearch5 | FileSearch6 | None = None


class CreateThreadRequest(BaseModel):
    """
    Options to create a new thread. If no thread is provided when running a
    request, an empty thread will be created.

    """

    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    messages: list[CreateMessageRequest] | None = None
    """
    A list of [messages](/docs/api-reference/messages) to start the thread with.
    """
    tool_resources: ToolResources3 | None = None
    """
    A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """
    metadata: Metadata | None = None


class CreateTranscriptionRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    file: bytes_aliased
    """
    The audio file object (not file name) to transcribe, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.

    """
    model: (
        str
        | Literal["whisper-1", "gpt-4o-transcribe", "gpt-4o-mini-transcribe"]
    ) = Field(..., examples=["gpt-4o-transcribe"])
    """
    ID of the model to use. The options are `gpt-4o-transcribe`, `gpt-4o-mini-transcribe`, and `whisper-1` (which is powered by our open source Whisper V2 model).

    """
    language: str | None = None
    """
    The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) (e.g. `en`) format will improve accuracy and latency.

    """
    prompt: str | None = None
    """
    An optional text to guide the model's style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text#prompting) should match the audio language.

    """
    response_format: AudioResponseFormat | None = Field(
        default_factory=lambda: AudioResponseFormat.model_validate("json")
    )
    temperature: float | None = 0
    """
    The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.

    """
    include__: list[TranscriptionInclude] | None = None
    """
    Additional information to include in the transcription response. 
    `logprobs` will return the log probabilities of the tokens in the 
    response to understand the model's confidence in the transcription. 
    `logprobs` only works with response_format set to `json` and only with 
    the models `gpt-4o-transcribe` and `gpt-4o-mini-transcribe`.

    """
    timestamp_granularities__: list[Literal["word", "segment"]] | None = [
        "segment"
    ]
    """
    The timestamp granularities to populate for this transcription. `response_format` must be set `verbose_json` to use timestamp granularities. Either or both of these options are supported: `word`, or `segment`. Note: There is no additional latency for segment timestamps, but generating word timestamps incurs additional latency.

    """
    stream: bool | None = False
    """
    If set to true, the model response data will be streamed to the client
    as it is generated using [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format). 
    See the [Streaming section of the Speech-to-Text guide](/docs/guides/speech-to-text?lang=curl#streaming-transcriptions)
    for more information.

    Note: Streaming is not supported for the `whisper-1` model and will be ignored.

    """


class CreateTranscriptionResponseStreamEvent(
    RootModel[TranscriptTextDeltaEvent | TranscriptTextDoneEvent]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: TranscriptTextDeltaEvent | TranscriptTextDoneEvent = Field(
        ..., discriminator="type"
    )


class CreateTranscriptionResponseVerboseJson(BaseModel):
    """
    Represents a verbose json transcription response returned by model, based on the provided input.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    language: str
    """
    The language of the input audio.
    """
    duration: float
    """
    The duration of the input audio.
    """
    text: str
    """
    The transcribed text.
    """
    words: list[TranscriptionWord] | None = None
    """
    Extracted words and their corresponding timestamps.
    """
    segments: list[TranscriptionSegment] | None = None
    """
    Segments of the transcribed text and their corresponding details.
    """


class CreateTranslationResponseVerboseJson(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    language: str
    """
    The language of the output translation (always `english`).
    """
    duration: float
    """
    The duration of the input audio.
    """
    text: str
    """
    The translated text.
    """
    segments: list[TranscriptionSegment] | None = None
    """
    Segments of the translated text and their corresponding details.
    """


class CreateVectorStoreFileBatchRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    file_ids: list[str] = Field(..., max_length=500, min_length=1)
    """
    A list of [File](/docs/api-reference/files) IDs that the vector store should use. Useful for tools like `file_search` that can access files.
    """
    chunking_strategy: ChunkingStrategyRequestParam | None = None
    attributes: VectorStoreFileAttributes | None = None


class CreateVectorStoreFileRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    file_id: str
    """
    A [File](/docs/api-reference/files) ID that the vector store should use. Useful for tools like `file_search` that can access files.
    """
    chunking_strategy: ChunkingStrategyRequestParam | None = None
    attributes: VectorStoreFileAttributes | None = None


class CreateVectorStoreRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    file_ids: list[str] | None = Field(None, max_length=500)
    """
    A list of [File](/docs/api-reference/files) IDs that the vector store should use. Useful for tools like `file_search` that can access files.
    """
    name: str | None = None
    """
    The name of the vector store.
    """
    expires_after: VectorStoreExpirationAfter | None = None
    chunking_strategy: (
        AutoChunkingStrategyRequestParam
        | StaticChunkingStrategyRequestParam
        | None
    ) = None
    """
    The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy. Only applicable if `file_ids` is non-empty.
    """
    metadata: Metadata | None = None


class EvalItem(BaseModel):
    """
    A message input to the model with a role indicating instruction following
    hierarchy. Instructions given with the `developer` or `system` role take
    precedence over instructions given with the `user` role. Messages with the
    `assistant` role are presumed to have been generated by the model in previous
    interactions.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: Literal["user", "assistant", "system", "developer"]
    """
    The role of the message input. One of `user`, `assistant`, `system`, or
    `developer`.

    """
    content: str | InputTextContent | Content7
    """
    Text inputs to the model - can contain template strings.

    """
    type: Literal["message"] | None = None
    """
    The type of the message input. Always `message`.

    """


class EvalLabelModelGrader(BaseModel):
    """
    A LabelModelGrader object which uses a model to assign labels to each item
    in the evaluation.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["label_model"] = "label_model"
    """
    The object type, which is always `label_model`.
    """
    name: str
    """
    The name of the grader.
    """
    model: str
    """
    The model to use for the evaluation. Must support structured outputs.
    """
    input: list[EvalItem]
    labels: list[str]
    """
    The labels to assign to each item in the evaluation.
    """
    passing_labels: list[str]
    """
    The labels that indicate a passing result. Must be a subset of labels.
    """


class EvalResponsesSource(BaseModel):
    """
    A EvalResponsesSource object describing a run data source configuration.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["responses"] = "responses"
    """
    The type of run data source. Always `responses`.
    """
    metadata: dict[str, Any] | None = None
    """
    Metadata filter for the responses. This is a query parameter used to select responses.
    """
    model: str | None = None
    """
    The name of the model to find responses for. This is a query parameter used to select responses.
    """
    instructions_search: str | None = None
    """
    Optional search string for instructions. This is a query parameter used to select responses.
    """
    created_after: int | None = Field(None, ge=0)
    """
    Only include items created after this timestamp (inclusive). This is a query parameter used to select responses.
    """
    created_before: int | None = Field(None, ge=0)
    """
    Only include items created before this timestamp (inclusive). This is a query parameter used to select responses.
    """
    has_tool_calls: bool | None = None
    """
    Whether the response has tool calls. This is a query parameter used to select responses.
    """
    reasoning_effort: ReasoningEffort | None = Field(
        default_factory=lambda: ReasoningEffort.model_validate("medium")
    )
    """
    Optional reasoning effort parameter. This is a query parameter used to select responses.
    """
    temperature: float | None = None
    """
    Sampling temperature. This is a query parameter used to select responses.
    """
    top_p: float | None = None
    """
    Nucleus sampling parameter. This is a query parameter used to select responses.
    """
    users: list[str] | None = None
    """
    List of user identifiers. This is a query parameter used to select responses.
    """
    allow_parallel_tool_calls: bool | None = None
    """
    Whether to allow parallel tool calls. This is a query parameter used to select responses.
    """


class EvalScoreModelGrader(BaseModel):
    """
    A ScoreModelGrader object that uses a model to assign a score to the input.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["score_model"] = "score_model"
    """
    The object type, which is always `score_model`.
    """
    name: str
    """
    The name of the grader.
    """
    model: str
    """
    The model to use for the evaluation.
    """
    sampling_params: dict[str, Any] | None = None
    """
    The sampling parameters for the model.
    """
    input: list[EvalItem]
    """
    The input text. This may include template strings.
    """
    pass_threshold: float | None = None
    """
    The threshold for the score.
    """
    range: list[float] | None = None
    """
    The range of the score. Defaults to `[0, 1]`.
    """


class EvalStoredCompletionsDataSourceConfig(BaseModel):
    """
    A StoredCompletionsDataSourceConfig which specifies the metadata property of your stored completions query.
    This is usually metadata like `usecase=chatbot` or `prompt-version=v2`, etc.
    The schema returned by this data source config is used to defined what variables are available in your evals.
    `item` and `sample` are both defined when using this data source config.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["stored_completions"] = "stored_completions"
    """
    The type of data source. Always `stored_completions`.
    """
    metadata: Metadata | None = None
    schema_: dict[str, Any]
    """
    The json schema for the run data source items.
    Learn how to build JSON schemas [here](https://json-schema.org/).

    """


class EvalStoredCompletionsSource(BaseModel):
    """
    A StoredCompletionsRunDataSource configuration describing a set of filters

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["stored_completions"] = "stored_completions"
    """
    The type of source. Always `stored_completions`.
    """
    metadata: Metadata | None = None
    model: str | None = None
    """
    An optional model to filter by (e.g., 'gpt-4o').
    """
    created_after: int | None = None
    """
    An optional Unix timestamp to filter items created after this time.
    """
    created_before: int | None = None
    """
    An optional Unix timestamp to filter items created before this time.
    """
    limit: int | None = None
    """
    An optional maximum number of items to return.
    """


class Result1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    file_id: str | None = None
    """
    The unique ID of the file.

    """
    text: str | None = None
    """
    The text that was retrieved from the file.

    """
    filename: str | None = None
    """
    The name of the file.

    """
    attributes: VectorStoreFileAttributes | None = None
    score: float | None = None
    """
    The relevance score of the file - a value between 0 and 1.

    """


class FileSearchToolCall(BaseModel):
    """
    The results of a file search tool call. See the
    [file search guide](/docs/guides/tools-file-search) for more information.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The unique ID of the file search tool call.

    """
    type: Literal["FileSearchToolCall"] = "FileSearchToolCall"
    """
    The type of the file search tool call. Always `file_search_call`.

    """
    status: Literal[
        "in_progress", "searching", "completed", "incomplete", "failed"
    ]
    """
    The status of the file search tool call. One of `in_progress`, 
    `searching`, `incomplete` or `failed`,

    """
    queries: list[str]
    """
    The queries used to search for files.

    """
    results: list[Result1] | None = None
    """
    The results of the file search tool call.

    """


class FineTuneMethod(BaseModel):
    """
    The method used for fine-tuning.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["supervised", "dpo"] | None = None
    """
    The type of method. Is either `supervised` or `dpo`.
    """
    supervised: FineTuneSupervisedMethod | None = None
    dpo: FineTuneDPOMethod | None = None


class FineTuningJob(BaseModel):
    """
    The `fine_tuning.job` object represents a fine-tuning job that has been created through the API.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The object identifier, which can be referenced in the API endpoints.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the fine-tuning job was created.
    """
    error: Error2
    """
    For fine-tuning jobs that have `failed`, this will contain more information on the cause of the failure.
    """
    fine_tuned_model: str
    """
    The name of the fine-tuned model that is being created. The value will be null if the fine-tuning job is still running.
    """
    finished_at: int
    """
    The Unix timestamp (in seconds) for when the fine-tuning job was finished. The value will be null if the fine-tuning job is still running.
    """
    hyperparameters: Hyperparameters3
    """
    The hyperparameters used for the fine-tuning job. This value will only be returned when running `supervised` jobs.
    """
    model: str
    """
    The base model that is being fine-tuned.
    """
    object: Literal["fine_tuning.job"] = "fine_tuning.job"
    """
    The object type, which is always "fine_tuning.job".
    """
    organization_id: str
    """
    The organization that owns the fine-tuning job.
    """
    result_files: list[str]
    """
    The compiled results file ID(s) for the fine-tuning job. You can retrieve the results with the [Files API](/docs/api-reference/files/retrieve-contents).
    """
    status: Literal[
        "validating_files",
        "queued",
        "running",
        "succeeded",
        "failed",
        "cancelled",
    ]
    """
    The current status of the fine-tuning job, which can be either `validating_files`, `queued`, `running`, `succeeded`, `failed`, or `cancelled`.
    """
    trained_tokens: int
    """
    The total number of billable tokens processed by this fine-tuning job. The value will be null if the fine-tuning job is still running.
    """
    training_file: str
    """
    The file ID used for training. You can retrieve the training data with the [Files API](/docs/api-reference/files/retrieve-contents).
    """
    validation_file: str
    """
    The file ID used for validation. You can retrieve the validation results with the [Files API](/docs/api-reference/files/retrieve-contents).
    """
    integrations: list[FineTuningIntegration] | None = Field(
        None, max_length=5
    )
    """
    A list of integrations to enable for this fine-tuning job.
    """
    seed: int
    """
    The seed used for the fine-tuning job.
    """
    estimated_finish: int | None = None
    """
    The Unix timestamp (in seconds) for when the fine-tuning job is estimated to finish. The value will be null if the fine-tuning job is not running.
    """
    method: FineTuneMethod | None = None
    metadata: Metadata | None = None


class FunctionObject(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    description: str | None = None
    """
    A description of what the function does, used by the model to choose when and how to call the function.
    """
    name: str
    """
    The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.
    """
    parameters: FunctionParameters | None = None
    strict: bool | None = False
    """
    Whether to enable strict schema adherence when generating the function call. If set to true, the model will follow the exact schema defined in the `parameters` field. Only a subset of JSON Schema is supported when `strict` is `true`. Learn more about Structured Outputs in the [function calling guide](docs/guides/function-calling).
    """


class InputContent(
    RootModel[InputTextContent | InputImageContent | InputFileContent]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: InputTextContent | InputImageContent | InputFileContent


class InputMessageContentList(RootModel[list[InputContent]]):
    """
    A list of one or many input items to the model, containing different content
    types.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[InputContent] = Field(..., title="Input item content list")
    """
    A list of one or many input items to the model, containing different content 
    types.

    """


class ListBatchesResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: list[Batch]
    first_id: str | None = Field(None, examples=["batch_abc123"])
    last_id: str | None = Field(None, examples=["batch_abc456"])
    has_more: bool
    object: Literal["list"] = "list"


class ListFilesResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: str = Field(..., examples=["list"])
    data: list[OpenAIFile]
    first_id: str = Field(..., examples=["file-abc123"])
    last_id: str = Field(..., examples=["file-abc456"])
    has_more: bool = Field(..., examples=[False])


class ListModelsResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    data: list[Model]


class ListPaginatedFineTuningJobsResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    data: list[FineTuningJob]
    has_more: bool
    object: Literal["list"] = "list"


class ListVectorStoreFilesResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: str = Field(..., examples=["list"])
    data: list[VectorStoreFileObject]
    first_id: str = Field(..., examples=["file-abc123"])
    last_id: str = Field(..., examples=["file-abc456"])
    has_more: bool = Field(..., examples=[False])


class ListVectorStoresResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: str = Field(..., examples=["list"])
    data: list[VectorStoreObject]
    first_id: str = Field(..., examples=["vs_abc123"])
    last_id: str = Field(..., examples=["vs_abc456"])
    has_more: bool = Field(..., examples=[False])


class MessageObject(BaseModel):
    """
    Represents a message within a [thread](/docs/api-reference/threads).
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier, which can be referenced in API endpoints.
    """
    object: Literal["thread.message"] = "thread.message"
    """
    The object type, which is always `thread.message`.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the message was created.
    """
    thread_id: str
    """
    The [thread](/docs/api-reference/threads) ID that this message belongs to.
    """
    status: Literal["in_progress", "incomplete", "completed"]
    """
    The status of the message, which can be either `in_progress`, `incomplete`, or `completed`.
    """
    incomplete_details: IncompleteDetails
    """
    On an incomplete message, details about why the message is incomplete.
    """
    completed_at: int
    """
    The Unix timestamp (in seconds) for when the message was completed.
    """
    incomplete_at: int
    """
    The Unix timestamp (in seconds) for when the message was marked as incomplete.
    """
    role: Literal["user", "assistant"]
    """
    The entity that produced the message. One of `user` or `assistant`.
    """
    content: list[
        MessageContentImageFileObject
        | MessageContentImageUrlObject
        | MessageContentTextObject
        | MessageContentRefusalObject
    ]
    """
    The content of the message in array of text and/or images.
    """
    assistant_id: str
    """
    If applicable, the ID of the [assistant](/docs/api-reference/assistants) that authored this message.
    """
    run_id: str
    """
    The ID of the [run](/docs/api-reference/runs) associated with the creation of this message. Value is `null` when messages are created manually using the create message or create thread endpoints.
    """
    attachments: list[Attachment]
    """
    A list of files attached to the message, and the tools they were added to.
    """
    metadata: Metadata


class MessageStreamEvent1(BaseModel):
    """
    Occurs when a [message](/docs/api-reference/messages/object) is created.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.message.created"] = "thread.message.created"
    data: MessageObject


class MessageStreamEvent2(BaseModel):
    """
    Occurs when a [message](/docs/api-reference/messages/object) moves to an `in_progress` state.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.message.in_progress"] = "thread.message.in_progress"
    data: MessageObject


class MessageStreamEvent4(BaseModel):
    """
    Occurs when a [message](/docs/api-reference/messages/object) is completed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.message.completed"] = "thread.message.completed"
    data: MessageObject


class MessageStreamEvent5(BaseModel):
    """
    Occurs when a [message](/docs/api-reference/messages/object) ends before it is completed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.message.incomplete"] = "thread.message.incomplete"
    data: MessageObject


class MessageStreamEvent(
    RootModel[
        MessageStreamEvent1
        | MessageStreamEvent2
        | MessageStreamEvent3
        | MessageStreamEvent4
        | MessageStreamEvent5
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        MessageStreamEvent1
        | MessageStreamEvent2
        | MessageStreamEvent3
        | MessageStreamEvent4
        | MessageStreamEvent5
    )


class ModelIdsResponses(
    RootModel[
        ModelIdsShared
        | Literal[
            "o1-pro",
            "o1-pro-2025-03-19",
            "computer-use-preview",
            "computer-use-preview-2025-03-11",
        ]
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        ModelIdsShared
        | Literal[
            "o1-pro",
            "o1-pro-2025-03-19",
            "computer-use-preview",
            "computer-use-preview-2025-03-11",
        ]
    ) = Field(..., examples=["gpt-4o"])


class ModelResponseProperties(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    metadata: Metadata | None = None
    temperature: float | None = Field(1, examples=[1], ge=0.0, le=2.0)
    """
    What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
    We generally recommend altering this or `top_p` but not both.

    """
    top_p: float | None = Field(1, examples=[1], ge=0.0, le=1.0)
    """
    An alternative to sampling with temperature, called nucleus sampling,
    where the model considers the results of the tokens with top_p probability
    mass. So 0.1 means only the tokens comprising the top 10% probability mass
    are considered.

    We generally recommend altering this or `temperature` but not both.

    """
    user: str | None = Field(None, examples=["user-1234"])
    """
    A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices#end-user-ids).

    """
    service_tier: ServiceTier | None = Field(
        default_factory=lambda: ServiceTier.model_validate("auto")
    )


class OutputContent(RootModel[OutputTextContent | RefusalContent]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: OutputTextContent | RefusalContent


class OutputMessage(BaseModel):
    """
    An output message from the model.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The unique ID of the output message.

    """
    type: Literal["OutputMessage"] = "OutputMessage"
    """
    The type of the output message. Always `message`.

    """
    role: Literal["assistant"] = "assistant"
    """
    The role of the output message. Always `assistant`.

    """
    content: list[OutputContent]
    """
    The content of the output message.

    """
    status: Literal["in_progress", "completed", "incomplete"]
    """
    The status of the message input. One of `in_progress`, `completed`, or
    `incomplete`. Populated when input items are returned via API.

    """


class Owner1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["user", "service_account"] | None = None
    """
    `user` or `service_account`
    """
    user: ProjectUser | None = None
    service_account: ProjectServiceAccount | None = None


class ProjectApiKey(BaseModel):
    """
    Represents an individual API key in a project.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["organization.project.api_key"] = (
        "organization.project.api_key"
    )
    """
    The object type, which is always `organization.project.api_key`
    """
    redacted_value: str
    """
    The redacted value of the API key
    """
    name: str
    """
    The name of the API key
    """
    created_at: int
    """
    The Unix timestamp (in seconds) of when the API key was created
    """
    last_used_at: int
    """
    The Unix timestamp (in seconds) of when the API key was last used.
    """
    id: str
    """
    The identifier, which can be referenced in API endpoints
    """
    owner: Owner1


class ProjectApiKeyListResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    data: list[ProjectApiKey]
    first_id: str
    last_id: str
    has_more: bool


class RealtimeClientEventConversationItemCreate(BaseModel):
    """
    Add a new Item to the Conversation's context, including messages, function
    calls, and function call responses. This event can be used both to populate a
    "history" of the conversation and to add new items mid-stream, but has the
    current limitation that it cannot populate assistant audio messages.

    If successful, the server will respond with a `conversation.item.created`
    event, otherwise an `error` event will be sent.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    Optional client-generated ID used to identify this event.
    """
    type: Literal["RealtimeClientEventConversationItemCreate"] = (
        "RealtimeClientEventConversationItemCreate"
    )
    """
    The event type, must be `conversation.item.create`.
    """
    previous_item_id: str | None = None
    """
    The ID of the preceding item after which the new item will be inserted. 
    If not set, the new item will be appended to the end of the conversation.
    If set to `root`, the new item will be added to the beginning of the conversation.
    If set to an existing ID, it allows an item to be inserted mid-conversation. If the
    ID cannot be found, an error will be returned and the item will not be added.

    """
    item: RealtimeConversationItem


class RealtimeClientEventTranscriptionSessionUpdate(BaseModel):
    """
    Send this event to update a transcription session.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    Optional client-generated ID used to identify this event.
    """
    type: Literal["RealtimeClientEventTranscriptionSessionUpdate"] = (
        "RealtimeClientEventTranscriptionSessionUpdate"
    )
    """
    The event type, must be `transcription_session.update`.
    """
    session: RealtimeTranscriptionSessionCreateRequest


class RealtimeResponse(BaseModel):
    """
    The response resource.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    The unique ID of the response.
    """
    object: Literal["realtime.response"] | None = None
    """
    The object type, must be `realtime.response`.
    """
    status: (
        Literal["completed", "cancelled", "failed", "incomplete"] | None
    ) = None
    """
    The final status of the response (`completed`, `cancelled`, `failed`, or 
    `incomplete`).

    """
    status_details: StatusDetails | None = None
    """
    Additional details about the status.
    """
    output: list[RealtimeConversationItem] | None = None
    """
    The list of output items generated by the response.
    """
    metadata: Metadata | None = None
    usage: Usage3 | None = None
    """
    Usage statistics for the Response, this will correspond to billing. A 
    Realtime API session will maintain a conversation context and append new 
    Items to the Conversation, thus output from previous turns (text and 
    audio tokens) will become the input for later turns.

    """
    conversation_id: str | None = None
    """
    Which conversation the response is added to, determined by the `conversation`
    field in the `response.create` event. If `auto`, the response will be added to
    the default conversation and the value of `conversation_id` will be an id like
    `conv_1234`. If `none`, the response will not be added to any conversation and
    the value of `conversation_id` will be `null`. If responses are being triggered
    by server VAD, the response will be added to the default conversation, thus
    the `conversation_id` will be an id like `conv_1234`.

    """
    voice: VoiceIdsShared | None = None
    """
    The voice the model used to respond.
    Current voice options are `alloy`, `ash`, `ballad`, `coral`, `echo`, `fable`,
    `onyx`, `nova`, `sage`, `shimmer`, and `verse`.

    """
    modalities: list[Literal["text", "audio"]] | None = None
    """
    The set of modalities the model used to respond. If there are multiple modalities,
    the model will pick one, for example if `modalities` is `["text", "audio"]`, the model
    could be responding in either text or audio.

    """
    output_audio_format: Literal["pcm16", "g711_ulaw", "g711_alaw"] | None = (
        None
    )
    """
    The format of output audio. Options are `pcm16`, `g711_ulaw`, or `g711_alaw`.

    """
    temperature: float | None = None
    """
    Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8.

    """
    max_output_tokens: int | Literal["inf"] | None = None
    """
    Maximum number of output tokens for a single assistant response,
    inclusive of tool calls, that was used in this response.

    """


class RealtimeResponseCreateParams(BaseModel):
    """
    Create a new Realtime response with these parameters
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    modalities: list[Literal["text", "audio"]] | None = None
    """
    The set of modalities the model can respond with. To disable audio,
    set this to ["text"].

    """
    instructions: str | None = None
    """
    The default system instructions (i.e. system message) prepended to model 
    calls. This field allows the client to guide the model on desired 
    responses. The model can be instructed on response content and format, 
    (e.g. "be extremely succinct", "act friendly", "here are examples of good 
    responses") and on audio behavior (e.g. "talk quickly", "inject emotion 
    into your voice", "laugh frequently"). The instructions are not guaranteed 
    to be followed by the model, but they provide guidance to the model on the 
    desired behavior.

    Note that the server sets default instructions which will be used if this 
    field is not set and are visible in the `session.created` event at the 
    start of the session.

    """
    voice: VoiceIdsShared | None = None
    """
    The voice the model uses to respond. Voice cannot be changed during the 
    session once the model has responded with audio at least once. Current 
    voice options are `alloy`, `ash`, `ballad`, `coral`, `echo`, `fable`,
    `onyx`, `nova`, `sage`, `shimmer`, and `verse`.

    """
    output_audio_format: Literal["pcm16", "g711_ulaw", "g711_alaw"] | None = (
        None
    )
    """
    The format of output audio. Options are `pcm16`, `g711_ulaw`, or `g711_alaw`.

    """
    tools: list[Tool] | None = None
    """
    Tools (functions) available to the model.
    """
    tool_choice: str | None = None
    """
    How the model chooses tools. Options are `auto`, `none`, `required`, or 
    specify a function, like `{"type": "function", "function": {"name": "my_function"}}`.

    """
    temperature: float | None = None
    """
    Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8.

    """
    max_response_output_tokens: int | Literal["inf"] | None = None
    """
    Maximum number of output tokens for a single assistant response,
    inclusive of tool calls. Provide an integer between 1 and 4096 to
    limit output tokens, or `inf` for the maximum available tokens for a
    given model. Defaults to `inf`.

    """
    conversation: str | Literal["auto", "none"] | None = None
    """
    Controls which conversation the response is added to. Currently supports
    `auto` and `none`, with `auto` as the default value. The `auto` value
    means that the contents of the response will be added to the default
    conversation. Set this to `none` to create an out-of-band response which 
    will not add items to default conversation.

    """
    metadata: Metadata | None = None
    input: list[RealtimeConversationItemWithReference] | None = None
    """
    Input items to include in the prompt for the model. Using this field
    creates a new context for this Response instead of using the default
    conversation. An empty array `[]` will clear the context for this Response.
    Note that this can include references to items from the default conversation.

    """


class RealtimeServerEventResponseCreated(BaseModel):
    """
    Returned when a new Response is created. The first event of response creation,
    where the response is in an initial state of `in_progress`.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseCreated"] = (
        "RealtimeServerEventResponseCreated"
    )
    """
    The event type, must be `response.created`.
    """
    response: RealtimeResponse


class RealtimeServerEventResponseDone(BaseModel):
    """
    Returned when a Response is done streaming. Always emitted, no matter the
    final state. The Response object included in the `response.done` event will
    include all output Items in the Response but will omit the raw audio data.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventResponseDone"] = (
        "RealtimeServerEventResponseDone"
    )
    """
    The event type, must be `response.done`.
    """
    response: RealtimeResponse


class RealtimeServerEventTranscriptionSessionUpdated(BaseModel):
    """
    Returned when a transcription session is updated with a `transcription_session.update` event, unless
    there is an error.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventTranscriptionSessionUpdated"] = (
        "RealtimeServerEventTranscriptionSessionUpdated"
    )
    """
    The event type, must be `transcription_session.updated`.
    """
    session: RealtimeTranscriptionSessionCreateResponse


class RealtimeSession(BaseModel):
    """
    Realtime session object configuration.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str | None = None
    """
    Unique identifier for the session that looks like `sess_1234567890abcdef`.

    """
    modalities: list[Literal["text", "audio"]] | None = None
    """
    The set of modalities the model can respond with. To disable audio,
    set this to ["text"].

    """
    model: (
        Literal[
            "gpt-4o-realtime-preview",
            "gpt-4o-realtime-preview-2024-10-01",
            "gpt-4o-realtime-preview-2024-12-17",
            "gpt-4o-mini-realtime-preview",
            "gpt-4o-mini-realtime-preview-2024-12-17",
        ]
        | None
    ) = None
    """
    The Realtime model used for this session.

    """
    instructions: str | None = None
    """
    The default system instructions (i.e. system message) prepended to model  calls. This field allows the client to guide the model on desired  responses. The model can be instructed on response content and format,  (e.g. "be extremely succinct", "act friendly", "here are examples of good  responses") and on audio behavior (e.g. "talk quickly", "inject emotion  into your voice", "laugh frequently"). The instructions are not guaranteed  to be followed by the model, but they provide guidance to the model on the desired behavior.

    Note that the server sets default instructions which will be used if this  field is not set and are visible in the `session.created` event at the  start of the session.

    """
    voice: VoiceIdsShared | None = None
    """
    The voice the model uses to respond. Voice cannot be changed during the 
    session once the model has responded with audio at least once. Current 
    voice options are `alloy`, `ash`, `ballad`, `coral`, `echo` `sage`, 
    `shimmer` and `verse`.

    """
    input_audio_format: Literal["pcm16", "g711_ulaw", "g711_alaw"] | None = (
        "pcm16"
    )
    """
    The format of input audio. Options are `pcm16`, `g711_ulaw`, or `g711_alaw`.
    For `pcm16`, input audio must be 16-bit PCM at a 24kHz sample rate, 
    single channel (mono), and little-endian byte order.

    """
    output_audio_format: Literal["pcm16", "g711_ulaw", "g711_alaw"] | None = (
        "pcm16"
    )
    """
    The format of output audio. Options are `pcm16`, `g711_ulaw`, or `g711_alaw`.
    For `pcm16`, output audio is sampled at a rate of 24kHz.

    """
    input_audio_transcription: InputAudioTranscription | None = None
    """
    Configuration for input audio transcription, defaults to off and can be  set to `null` to turn off once on. Input audio transcription is not native to the model, since the model consumes audio directly. Transcription runs  asynchronously through [the /audio/transcriptions endpoint](https://platform.openai.com/docs/api-reference/audio/createTranscription) and should be treated as guidance of input audio content rather than precisely what the model heard. The client can optionally set the language and prompt for transcription, these offer additional guidance to the transcription service.

    """
    turn_detection: TurnDetection | None = None
    """
    Configuration for turn detection, ether Server VAD or Semantic VAD. This can be set to `null` to turn off, in which case the client must manually trigger model response.
    Server VAD means that the model will detect the start and end of speech based on audio volume and respond at the end of user speech.
    Semantic VAD is more advanced and uses a turn detection model (in conjuction with VAD) to semantically estimate whether the user has finished speaking, then dynamically sets a timeout based on this probability. For example, if user audio trails off with "uhhm", the model will score a low probability of turn end and wait longer for the user to continue speaking. This can be useful for more natural conversations, but may have a higher latency.

    """
    input_audio_noise_reduction: InputAudioNoiseReduction | None = None
    """
    Configuration for input audio noise reduction. This can be set to `null` to turn off.
    Noise reduction filters audio added to the input audio buffer before it is sent to VAD and the model.
    Filtering the audio can improve VAD and turn detection accuracy (reducing false positives) and model performance by improving perception of the input audio.

    """
    tools: list[Tool] | None = None
    """
    Tools (functions) available to the model.
    """
    tool_choice: str | None = "auto"
    """
    How the model chooses tools. Options are `auto`, `none`, `required`, or 
    specify a function.

    """
    temperature: float | None = 0.8
    """
    Sampling temperature for the model, limited to [0.6, 1.2]. For audio models a temperature of 0.8 is highly recommended for best performance.

    """
    max_response_output_tokens: int | Literal["inf"] | None = None
    """
    Maximum number of output tokens for a single assistant response,
    inclusive of tool calls. Provide an integer between 1 and 4096 to
    limit output tokens, or `inf` for the maximum available tokens for a
    given model. Defaults to `inf`.

    """


class RealtimeSessionCreateRequest(BaseModel):
    """
    Realtime session object configuration.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    modalities: list[Literal["text", "audio"]] | None = None
    """
    The set of modalities the model can respond with. To disable audio,
    set this to ["text"].

    """
    model: (
        Literal[
            "gpt-4o-realtime-preview",
            "gpt-4o-realtime-preview-2024-10-01",
            "gpt-4o-realtime-preview-2024-12-17",
            "gpt-4o-mini-realtime-preview",
            "gpt-4o-mini-realtime-preview-2024-12-17",
        ]
        | None
    ) = None
    """
    The Realtime model used for this session.

    """
    instructions: str | None = None
    """
    The default system instructions (i.e. system message) prepended to model  calls. This field allows the client to guide the model on desired  responses. The model can be instructed on response content and format,  (e.g. "be extremely succinct", "act friendly", "here are examples of good  responses") and on audio behavior (e.g. "talk quickly", "inject emotion  into your voice", "laugh frequently"). The instructions are not guaranteed  to be followed by the model, but they provide guidance to the model on the desired behavior.

    Note that the server sets default instructions which will be used if this  field is not set and are visible in the `session.created` event at the  start of the session.

    """
    voice: VoiceIdsShared | None = None
    """
    The voice the model uses to respond. Voice cannot be changed during the 
    session once the model has responded with audio at least once. Current 
    voice options are `alloy`, `ash`, `ballad`, `coral`, `echo`, `fable`,
    `onyx`, `nova`, `sage`, `shimmer`, and `verse`.

    """
    input_audio_format: Literal["pcm16", "g711_ulaw", "g711_alaw"] | None = (
        "pcm16"
    )
    """
    The format of input audio. Options are `pcm16`, `g711_ulaw`, or `g711_alaw`.
    For `pcm16`, input audio must be 16-bit PCM at a 24kHz sample rate, 
    single channel (mono), and little-endian byte order.

    """
    output_audio_format: Literal["pcm16", "g711_ulaw", "g711_alaw"] | None = (
        "pcm16"
    )
    """
    The format of output audio. Options are `pcm16`, `g711_ulaw`, or `g711_alaw`.
    For `pcm16`, output audio is sampled at a rate of 24kHz.

    """
    input_audio_transcription: InputAudioTranscription | None = None
    """
    Configuration for input audio transcription, defaults to off and can be  set to `null` to turn off once on. Input audio transcription is not native to the model, since the model consumes audio directly. Transcription runs  asynchronously through [the /audio/transcriptions endpoint](https://platform.openai.com/docs/api-reference/audio/createTranscription) and should be treated as guidance of input audio content rather than precisely what the model heard. The client can optionally set the language and prompt for transcription, these offer additional guidance to the transcription service.

    """
    turn_detection: TurnDetection | None = None
    """
    Configuration for turn detection, ether Server VAD or Semantic VAD. This can be set to `null` to turn off, in which case the client must manually trigger model response.
    Server VAD means that the model will detect the start and end of speech based on audio volume and respond at the end of user speech.
    Semantic VAD is more advanced and uses a turn detection model (in conjuction with VAD) to semantically estimate whether the user has finished speaking, then dynamically sets a timeout based on this probability. For example, if user audio trails off with "uhhm", the model will score a low probability of turn end and wait longer for the user to continue speaking. This can be useful for more natural conversations, but may have a higher latency.

    """
    input_audio_noise_reduction: InputAudioNoiseReduction | None = None
    """
    Configuration for input audio noise reduction. This can be set to `null` to turn off.
    Noise reduction filters audio added to the input audio buffer before it is sent to VAD and the model.
    Filtering the audio can improve VAD and turn detection accuracy (reducing false positives) and model performance by improving perception of the input audio.

    """
    tools: list[Tool] | None = None
    """
    Tools (functions) available to the model.
    """
    tool_choice: str | None = "auto"
    """
    How the model chooses tools. Options are `auto`, `none`, `required`, or 
    specify a function.

    """
    temperature: float | None = 0.8
    """
    Sampling temperature for the model, limited to [0.6, 1.2]. For audio models a temperature of 0.8 is highly recommended for best performance.

    """
    max_response_output_tokens: int | Literal["inf"] | None = None
    """
    Maximum number of output tokens for a single assistant response,
    inclusive of tool calls. Provide an integer between 1 and 4096 to
    limit output tokens, or `inf` for the maximum available tokens for a
    given model. Defaults to `inf`.

    """


class RealtimeSessionCreateResponse(BaseModel):
    """
    A new Realtime session configuration, with an ephermeral key. Default TTL
    for keys is one minute.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    client_secret: ClientSecret
    """
    Ephemeral key returned by the API.
    """
    modalities: list[Literal["text", "audio"]] | None = None
    """
    The set of modalities the model can respond with. To disable audio,
    set this to ["text"].

    """
    instructions: str | None = None
    """
    The default system instructions (i.e. system message) prepended to model 
    calls. This field allows the client to guide the model on desired 
    responses. The model can be instructed on response content and format, 
    (e.g. "be extremely succinct", "act friendly", "here are examples of good 
    responses") and on audio behavior (e.g. "talk quickly", "inject emotion 
    into your voice", "laugh frequently"). The instructions are not guaranteed 
    to be followed by the model, but they provide guidance to the model on the 
    desired behavior.

    Note that the server sets default instructions which will be used if this 
    field is not set and are visible in the `session.created` event at the 
    start of the session.

    """
    voice: VoiceIdsShared | None = None
    """
    The voice the model uses to respond. Voice cannot be changed during the 
    session once the model has responded with audio at least once. Current 
    voice options are `alloy`, `ash`, `ballad`, `coral`, `echo` `sage`, 
    `shimmer` and `verse`.

    """
    input_audio_format: str | None = None
    """
    The format of input audio. Options are `pcm16`, `g711_ulaw`, or `g711_alaw`.

    """
    output_audio_format: str | None = None
    """
    The format of output audio. Options are `pcm16`, `g711_ulaw`, or `g711_alaw`.

    """
    input_audio_transcription: InputAudioTranscription2 | None = None
    """
    Configuration for input audio transcription, defaults to off and can be 
    set to `null` to turn off once on. Input audio transcription is not native 
    to the model, since the model consumes audio directly. Transcription runs 
    asynchronously through Whisper and should be treated as rough guidance 
    rather than the representation understood by the model.

    """
    turn_detection: TurnDetection2 | None = None
    """
    Configuration for turn detection. Can be set to `null` to turn off. Server 
    VAD means that the model will detect the start and end of speech based on 
    audio volume and respond at the end of user speech.

    """
    tools: list[Tool] | None = None
    """
    Tools (functions) available to the model.
    """
    tool_choice: str | None = None
    """
    How the model chooses tools. Options are `auto`, `none`, `required`, or 
    specify a function.

    """
    temperature: float | None = None
    """
    Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8.

    """
    max_response_output_tokens: int | Literal["inf"] | None = None
    """
    Maximum number of output tokens for a single assistant response,
    inclusive of tool calls. Provide an integer between 1 and 4096 to
    limit output tokens, or `inf` for the maximum available tokens for a
    given model. Defaults to `inf`.

    """


class Reasoning(BaseModel):
    """
    **o-series models only**

    Configuration options for
    [reasoning models](https://platform.openai.com/docs/guides/reasoning).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    effort: ReasoningEffort | None = Field(
        default_factory=lambda: ReasoningEffort.model_validate("medium")
    )
    summary: Literal["auto", "concise", "detailed"] | None = None
    """
    A summary of the reasoning performed by the model. This can be
    useful for debugging and understanding the model's reasoning process.
    One of `auto`, `concise`, or `detailed`.

    """
    generate_summary: Literal["auto", "concise", "detailed"] | None = None
    """
    **Deprecated:** use `summary` instead.

    A summary of the reasoning performed by the model. This can be
    useful for debugging and understanding the model's reasoning process.
    One of `auto`, `concise`, or `detailed`.

    """


class ResponseCodeInterpreterCallCompletedEvent(BaseModel):
    """
    Emitted when the code interpreter call is completed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseCodeInterpreterCallCompletedEvent"] = (
        "ResponseCodeInterpreterCallCompletedEvent"
    )
    """
    The type of the event. Always `response.code_interpreter_call.completed`.

    """
    output_index: int
    """
    The index of the output item that the code interpreter call is in progress.

    """
    code_interpreter_call: CodeInterpreterToolCall


class ResponseCodeInterpreterCallInProgressEvent(BaseModel):
    """
    Emitted when a code interpreter call is in progress.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseCodeInterpreterCallInProgressEvent"] = (
        "ResponseCodeInterpreterCallInProgressEvent"
    )
    """
    The type of the event. Always `response.code_interpreter_call.in_progress`.

    """
    output_index: int
    """
    The index of the output item that the code interpreter call is in progress.

    """
    code_interpreter_call: CodeInterpreterToolCall


class ResponseCodeInterpreterCallInterpretingEvent(BaseModel):
    """
    Emitted when the code interpreter is actively interpreting the code snippet.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseCodeInterpreterCallInterpretingEvent"] = (
        "ResponseCodeInterpreterCallInterpretingEvent"
    )
    """
    The type of the event. Always `response.code_interpreter_call.interpreting`.

    """
    output_index: int
    """
    The index of the output item that the code interpreter call is in progress.

    """
    code_interpreter_call: CodeInterpreterToolCall


class ResponseContentPartAddedEvent(BaseModel):
    """
    Emitted when a new content part is added.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseContentPartAddedEvent"] = (
        "ResponseContentPartAddedEvent"
    )
    """
    The type of the event. Always `response.content_part.added`.

    """
    item_id: str
    """
    The ID of the output item that the content part was added to.

    """
    output_index: int
    """
    The index of the output item that the content part was added to.

    """
    content_index: int
    """
    The index of the content part that was added.

    """
    part: OutputContent
    """
    The content part that was added.

    """


class ResponseContentPartDoneEvent(BaseModel):
    """
    Emitted when a content part is done.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseContentPartDoneEvent"] = (
        "ResponseContentPartDoneEvent"
    )
    """
    The type of the event. Always `response.content_part.done`.

    """
    item_id: str
    """
    The ID of the output item that the content part was added to.

    """
    output_index: int
    """
    The index of the output item that the content part was added to.

    """
    content_index: int
    """
    The index of the content part that is done.

    """
    part: OutputContent
    """
    The content part that is done.

    """


class ResponseError(BaseModel):
    """
    An error object returned when the model fails to generate a Response.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    code: ResponseErrorCode
    message: str
    """
    A human-readable description of the error.

    """


class JsonSchema(BaseModel):
    """
    Structured Outputs configuration options, including a JSON Schema.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    description: str | None = None
    """
    A description of what the response format is for, used by the model to
    determine how to respond in the format.

    """
    name: str
    """
    The name of the response format. Must be a-z, A-Z, 0-9, or contain
    underscores and dashes, with a maximum length of 64.

    """
    schema_: ResponseFormatJsonSchemaSchema | None = None
    strict: bool | None = False
    """
    Whether to enable strict schema adherence when generating the output.
    If set to true, the model will always follow the exact schema defined
    in the `schema` field. Only a subset of JSON Schema is supported when
    `strict` is `true`. To learn more, read the [Structured Outputs
    guide](/docs/guides/structured-outputs).

    """


class ResponseFormatJsonSchema(BaseModel):
    """
    JSON Schema response format. Used to generate structured JSON responses.
    Learn more about [Structured Outputs](/docs/guides/structured-outputs).

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["json_schema"] = "json_schema"
    """
    The type of response format being defined. Always `json_schema`.
    """
    json_schema: JsonSchema = Field(..., title="JSON schema")
    """
    Structured Outputs configuration options, including a JSON Schema.

    """


class ResponseTextAnnotationDeltaEvent(BaseModel):
    """
    Emitted when a text annotation is added.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseTextAnnotationDeltaEvent"] = (
        "ResponseTextAnnotationDeltaEvent"
    )
    """
    The type of the event. Always `response.output_text.annotation.added`.

    """
    item_id: str
    """
    The ID of the output item that the text annotation was added to.

    """
    output_index: int
    """
    The index of the output item that the text annotation was added to.

    """
    content_index: int
    """
    The index of the content part that the text annotation was added to.

    """
    annotation_index: int
    """
    The index of the annotation that was added.

    """
    annotation: AnnotationModel


class SubmitToolOutputs(BaseModel):
    """
    Details on the tool outputs needed for this run to continue.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    tool_calls: list[RunToolCallObject]
    """
    A list of the relevant tool calls.
    """


class RequiredAction(BaseModel):
    """
    Details on the action required to continue the run. Will be `null` if no action is required.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["submit_tool_outputs"] = "submit_tool_outputs"
    """
    For now, this is always `submit_tool_outputs`.
    """
    submit_tool_outputs: SubmitToolOutputs
    """
    Details on the tool outputs needed for this run to continue.
    """


class CodeInterpreter6(BaseModel):
    """
    The Code Interpreter tool call definition.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    input: str | None = None
    """
    The input to the Code Interpreter tool call.
    """
    outputs: (
        list[
            RunStepDeltaStepDetailsToolCallsCodeOutputLogsObject
            | RunStepDeltaStepDetailsToolCallsCodeOutputImageObject
        ]
        | None
    ) = None
    """
    The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.
    """


class RunStepDeltaStepDetailsToolCallsCodeObject(BaseModel):
    """
    Details of the Code Interpreter tool call the run step was involved in.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    index: int
    """
    The index of the tool call in the tool calls array.
    """
    id: str | None = None
    """
    The ID of the tool call.
    """
    type: Literal["code_interpreter"] = "code_interpreter"
    """
    The type of tool call. This is always going to be `code_interpreter` for this type of tool call.
    """
    code_interpreter: CodeInterpreter6 | None = None
    """
    The Code Interpreter tool call definition.
    """


class RunStepDeltaStepDetailsToolCallsObject(BaseModel):
    """
    Details of the tool call.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["tool_calls"] = "tool_calls"
    """
    Always `tool_calls`.
    """
    tool_calls: (
        list[
            RunStepDeltaStepDetailsToolCallsCodeObject
            | RunStepDeltaStepDetailsToolCallsFileSearchObject
            | RunStepDeltaStepDetailsToolCallsFunctionObject
        ]
        | None
    ) = None
    """
    An array of tool calls the run step was involved in. These can be associated with one of three types of tools: `code_interpreter`, `file_search`, or `function`.

    """


class CodeInterpreter7(BaseModel):
    """
    The Code Interpreter tool call definition.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    input: str
    """
    The input to the Code Interpreter tool call.
    """
    outputs: list[
        RunStepDetailsToolCallsCodeOutputLogsObject
        | RunStepDetailsToolCallsCodeOutputImageObject
    ]
    """
    The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.
    """


class RunStepDetailsToolCallsCodeObject(BaseModel):
    """
    Details of the Code Interpreter tool call the run step was involved in.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The ID of the tool call.
    """
    type: Literal["code_interpreter"] = "code_interpreter"
    """
    The type of tool call. This is always going to be `code_interpreter` for this type of tool call.
    """
    code_interpreter: CodeInterpreter7
    """
    The Code Interpreter tool call definition.
    """


class FileSearch9(BaseModel):
    """
    For now, this is always going to be an empty object.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    ranking_options: (
        RunStepDetailsToolCallsFileSearchRankingOptionsObject | None
    ) = None
    results: list[RunStepDetailsToolCallsFileSearchResultObject] | None = None
    """
    The results of the file search.
    """


class RunStepDetailsToolCallsFileSearchObject(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The ID of the tool call object.
    """
    type: Literal["file_search"] = "file_search"
    """
    The type of tool call. This is always going to be `file_search` for this type of tool call.
    """
    file_search: FileSearch9
    """
    For now, this is always going to be an empty object.
    """


class RunStepDetailsToolCallsObject(BaseModel):
    """
    Details of the tool call.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["tool_calls"] = "tool_calls"
    """
    Always `tool_calls`.
    """
    tool_calls: list[
        RunStepDetailsToolCallsCodeObject
        | RunStepDetailsToolCallsFileSearchObject
        | RunStepDetailsToolCallsFunctionObject
    ]
    """
    An array of tool calls the run step was involved in. These can be associated with one of three types of tools: `code_interpreter`, `file_search`, or `function`.

    """


class RunStepObject(BaseModel):
    """
    Represents a step in execution of a run.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier of the run step, which can be referenced in API endpoints.
    """
    object: Literal["thread.run.step"] = "thread.run.step"
    """
    The object type, which is always `thread.run.step`.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the run step was created.
    """
    assistant_id: str
    """
    The ID of the [assistant](/docs/api-reference/assistants) associated with the run step.
    """
    thread_id: str
    """
    The ID of the [thread](/docs/api-reference/threads) that was run.
    """
    run_id: str
    """
    The ID of the [run](/docs/api-reference/runs) that this run step is a part of.
    """
    type: Literal["message_creation", "tool_calls"]
    """
    The type of run step, which can be either `message_creation` or `tool_calls`.
    """
    status: Literal[
        "in_progress", "cancelled", "failed", "completed", "expired"
    ]
    """
    The status of the run step, which can be either `in_progress`, `cancelled`, `failed`, `completed`, or `expired`.
    """
    step_details: (
        RunStepDetailsMessageCreationObject | RunStepDetailsToolCallsObject
    )
    """
    The details of the run step.
    """
    last_error: LastError1
    """
    The last error associated with this run step. Will be `null` if there are no errors.
    """
    expired_at: int
    """
    The Unix timestamp (in seconds) for when the run step expired. A step is considered expired if the parent run is expired.
    """
    cancelled_at: int
    """
    The Unix timestamp (in seconds) for when the run step was cancelled.
    """
    failed_at: int
    """
    The Unix timestamp (in seconds) for when the run step failed.
    """
    completed_at: int
    """
    The Unix timestamp (in seconds) for when the run step completed.
    """
    metadata: Metadata
    usage: RunStepCompletionUsage


class RunStepStreamEvent1(BaseModel):
    """
    Occurs when a [run step](/docs/api-reference/run-steps/step-object) is created.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.step.created"] = "thread.run.step.created"
    data: RunStepObject


class RunStepStreamEvent2(BaseModel):
    """
    Occurs when a [run step](/docs/api-reference/run-steps/step-object) moves to an `in_progress` state.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.step.in_progress"] = (
        "thread.run.step.in_progress"
    )
    data: RunStepObject


class RunStepStreamEvent4(BaseModel):
    """
    Occurs when a [run step](/docs/api-reference/run-steps/step-object) is completed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.step.completed"] = "thread.run.step.completed"
    data: RunStepObject


class RunStepStreamEvent5(BaseModel):
    """
    Occurs when a [run step](/docs/api-reference/run-steps/step-object) fails.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.step.failed"] = "thread.run.step.failed"
    data: RunStepObject


class RunStepStreamEvent6(BaseModel):
    """
    Occurs when a [run step](/docs/api-reference/run-steps/step-object) is cancelled.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.step.cancelled"] = "thread.run.step.cancelled"
    data: RunStepObject


class RunStepStreamEvent7(BaseModel):
    """
    Occurs when a [run step](/docs/api-reference/run-steps/step-object) expires.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.step.expired"] = "thread.run.step.expired"
    data: RunStepObject


class TextResponseFormatConfiguration(
    RootModel[
        ResponseFormatText
        | TextResponseFormatJsonSchema
        | ResponseFormatJsonObject
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        ResponseFormatText
        | TextResponseFormatJsonSchema
        | ResponseFormatJsonObject
    )
    """
    An object specifying the format that the model must output.

    Configuring `{ "type": "json_schema" }` enables Structured Outputs, 
    which ensures the model will match your supplied JSON schema. Learn more in the 
    [Structured Outputs guide](/docs/guides/structured-outputs).

    The default format is `{ "type": "text" }` with no additional options.

    **Not recommended for gpt-4o and newer models:**

    Setting to `{ "type": "json_object" }` enables the older JSON mode, which
    ensures the message the model generates is valid JSON. Using `json_schema`
    is preferred for models that support it.

    """


class UpdateVectorStoreFileAttributesRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    attributes: VectorStoreFileAttributes


class UpdateVectorStoreRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    name: str | None = None
    """
    The name of the vector store.
    """
    expires_after: VectorStoreExpirationAfter | None = None
    metadata: Metadata | None = None


class UsageTimeBucket(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["bucket"] = "bucket"
    start_time: int
    end_time: int
    result: list[
        UsageCompletionsResult
        | UsageEmbeddingsResult
        | UsageModerationsResult
        | UsageImagesResult
        | UsageAudioSpeechesResult
        | UsageAudioTranscriptionsResult
        | UsageVectorStoresResult
        | UsageCodeInterpreterSessionsResult
        | CostsResult
    ]


class AssistantToolsFunction(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["function"] = "function"
    """
    The type of tool being defined: `function`
    """
    function: FunctionObject


class AssistantsApiResponseFormatOption(
    RootModel[
        Literal["auto"]
        | ResponseFormatText
        | ResponseFormatJsonObject
        | ResponseFormatJsonSchema
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        Literal["auto"]
        | ResponseFormatText
        | ResponseFormatJsonObject
        | ResponseFormatJsonSchema
    )
    """
    Specifies the format that the model must output. Compatible with [GPT-4o](/docs/models#gpt-4o), [GPT-4 Turbo](/docs/models#gpt-4-turbo-and-gpt-4), and all GPT-3.5 Turbo models since `gpt-3.5-turbo-1106`.

    Setting to `{ "type": "json_schema", "json_schema": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema. Learn more in the [Structured Outputs guide](/docs/guides/structured-outputs).

    Setting to `{ "type": "json_object" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    **Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly "stuck" request. Also note that the message content may be partially cut off if `finish_reason="length"`, which indicates the generation exceeded `max_tokens` or the conversation exceeded the max context length.

    """


class AuditLogActor(BaseModel):
    """
    The actor who performed the audit logged action.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["session", "api_key"] | None = None
    """
    The type of actor. Is either `session` or `api_key`.
    """
    session: AuditLogActorSession | None = None
    api_key: AuditLogActorApiKey | None = None


class ChatCompletionList(BaseModel):
    """
    An object representing a list of Chat Completions.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    """
    The type of this object. It is always set to "list".

    """
    data: list[CreateChatCompletionResponse]
    """
    An array of chat completion objects.

    """
    first_id: str
    """
    The identifier of the first chat completion in the data array.
    """
    last_id: str
    """
    The identifier of the last chat completion in the data array.
    """
    has_more: bool
    """
    Indicates whether there are more Chat Completions available.
    """


class Content(
    RootModel[list[ChatCompletionRequestAssistantMessageContentPart] | None]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: list[ChatCompletionRequestAssistantMessageContentPart] | None = (
        Field(None, min_length=1, title="Array of content parts")
    )
    """
    An array of content parts with a defined type. Can be one or more of type `text`, or exactly one of type `refusal`.
    """


class ChatCompletionRequestAssistantMessage(BaseModel):
    """
    Messages sent by the model in response to user messages.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str | Content | None = None
    """
    The contents of the assistant message. Required unless `tool_calls` or `function_call` is specified.

    """
    refusal: str | None = None
    """
    The refusal message by the assistant.
    """
    role: Literal["assistant"] = "assistant"
    """
    The role of the messages author, in this case `assistant`.
    """
    name: str | None = None
    """
    An optional name for the participant. Provides the model information to differentiate between participants of the same role.
    """
    audio: Audio | None = None
    """
    Data about a previous audio response from the model. 
    [Learn more](/docs/guides/audio).

    """
    tool_calls: ChatCompletionMessageToolCalls | None = None
    function_call: FunctionCall | None = None
    """
    Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
    """


class ChatCompletionRequestMessage(
    RootModel[
        ChatCompletionRequestDeveloperMessage
        | ChatCompletionRequestSystemMessage
        | ChatCompletionRequestUserMessage
        | ChatCompletionRequestAssistantMessage
        | ChatCompletionRequestToolMessage
        | ChatCompletionRequestFunctionMessage
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        ChatCompletionRequestDeveloperMessage
        | ChatCompletionRequestSystemMessage
        | ChatCompletionRequestUserMessage
        | ChatCompletionRequestAssistantMessage
        | ChatCompletionRequestToolMessage
        | ChatCompletionRequestFunctionMessage
    )


class ChatCompletionTool(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["function"] = "function"
    """
    The type of the tool. Currently, only `function` is supported.
    """
    function: FunctionObject


class Content5(RootModel[InputContent | OutputContent]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: InputContent | OutputContent
    """
    Multi-modal input and output contents.

    """


class CreateAssistantRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    model: str | AssistantSupportedModels = Field(..., examples=["gpt-4o"])
    """
    ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models) for descriptions of them.

    """
    name: str | None = Field(None, max_length=256)
    """
    The name of the assistant. The maximum length is 256 characters.

    """
    description: str | None = Field(None, max_length=512)
    """
    The description of the assistant. The maximum length is 512 characters.

    """
    instructions: str | None = Field(None, max_length=256000)
    """
    The system instructions that the assistant uses. The maximum length is 256,000 characters.

    """
    reasoning_effort: ReasoningEffort | None = Field(
        default_factory=lambda: ReasoningEffort.model_validate("medium")
    )
    tools: (
        list[
            AssistantToolsCode
            | AssistantToolsFileSearch
            | AssistantToolsFunction
        ]
        | None
    ) = Field([], max_length=128)
    """
    A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `file_search`, or `function`.

    """
    tool_resources: ToolResources1 | None = None
    """
    A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """
    metadata: Metadata | None = None
    temperature: float | None = Field(1, examples=[1], ge=0.0, le=2.0)
    """
    What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.

    """
    top_p: float | None = Field(1, examples=[1], ge=0.0, le=1.0)
    """
    An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.

    We generally recommend altering this or temperature but not both.

    """
    response_format: AssistantsApiResponseFormatOption | None = None


class CreateEvalItem(RootModel[CreateEvalItem1 | EvalItem]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: CreateEvalItem1 | EvalItem = Field(..., title="CreateEvalItem")
    """
    A chat message that makes up the prompt or context. May include variable references to the "item" namespace, ie {{item.name}}.
    """


class CreateEvalLabelModelGrader(BaseModel):
    """
    A LabelModelGrader object which uses a model to assign labels to each item
    in the evaluation.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["label_model"] = "label_model"
    """
    The object type, which is always `label_model`.
    """
    name: str
    """
    The name of the grader.
    """
    model: str
    """
    The model to use for the evaluation. Must support structured outputs.
    """
    input: list[CreateEvalItem]
    """
    A list of chat messages forming the prompt or context. May include variable references to the "item" namespace, ie {{item.name}}.
    """
    labels: list[str]
    """
    The labels to classify to each item in the evaluation.
    """
    passing_labels: list[str]
    """
    The labels that indicate a passing result. Must be a subset of labels.
    """


class CreateEvalRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str | None = None
    """
    The name of the evaluation.
    """
    metadata: Metadata | None = None
    data_source_config: (
        CreateEvalCustomDataSourceConfig | CreateEvalLogsDataSourceConfig
    )
    """
    The configuration for the data source used for the evaluation runs.
    """
    testing_criteria: list[
        CreateEvalLabelModelGrader
        | EvalStringCheckGrader
        | EvalTextSimilarityGrader
        | EvalPythonGrader
        | EvalScoreModelGrader
    ]
    """
    A list of graders for all eval runs in this group.
    """


class InputMessages2(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["template"] = "template"
    """
    The type of input messages. Always `template`.
    """
    template: list[Template | EvalItem]
    """
    A list of chat messages forming the prompt or context. May include variable references to the "item" namespace, ie {{item.name}}.
    """


class CreateEvalResponsesRunDataSource(BaseModel):
    """
    A ResponsesRunDataSource object describing a model sampling configuration.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["completions"] = "completions"
    """
    The type of run data source. Always `completions`.
    """
    input_messages: InputMessages2 | InputMessages1 | None = None
    sampling_params: SamplingParams | None = None
    model: str | None = None
    """
    The name of the model to use for generating completions (e.g. "o3-mini").
    """
    source: (
        EvalJsonlFileContentSource
        | EvalJsonlFileIdSource
        | EvalResponsesSource
    )


class CreateFineTuningJobRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    model: (
        str
        | Literal["babbage-002", "davinci-002", "gpt-3.5-turbo", "gpt-4o-mini"]
    ) = Field(..., examples=["gpt-4o-mini"])
    """
    The name of the model to fine-tune. You can select one of the
    [supported models](/docs/guides/fine-tuning#which-models-can-be-fine-tuned).

    """
    training_file: str = Field(..., examples=["file-abc123"])
    """
    The ID of an uploaded file that contains training data.

    See [upload file](/docs/api-reference/files/create) for how to upload a file.

    Your dataset must be formatted as a JSONL file. Additionally, you must upload your file with the purpose `fine-tune`.

    The contents of the file should differ depending on if the model uses the [chat](/docs/api-reference/fine-tuning/chat-input), [completions](/docs/api-reference/fine-tuning/completions-input) format, or if the fine-tuning method uses the [preference](/docs/api-reference/fine-tuning/preference-input) format.

    See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.

    """
    hyperparameters: Hyperparameters | None = None
    """
    The hyperparameters used for the fine-tuning job.
    This value is now deprecated in favor of `method`, and should be passed in under the `method` parameter.

    """
    suffix: str | None = Field(None, max_length=64, min_length=1)
    """
    A string of up to 64 characters that will be added to your fine-tuned model name.

    For example, a `suffix` of "custom-model-name" would produce a model name like `ft:gpt-4o-mini:openai:custom-model-name:7p4lURel`.

    """
    validation_file: str | None = Field(None, examples=["file-abc123"])
    """
    The ID of an uploaded file that contains validation data.

    If you provide this file, the data is used to generate validation
    metrics periodically during fine-tuning. These metrics can be viewed in
    the fine-tuning results file.
    The same data should not be present in both train and validation files.

    Your dataset must be formatted as a JSONL file. You must upload your file with the purpose `fine-tune`.

    See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.

    """
    integrations: list[Integration] | None = None
    """
    A list of integrations to enable for your fine-tuning job.
    """
    seed: int | None = Field(None, examples=[42], ge=0, le=2147483647)
    """
    The seed controls the reproducibility of the job. Passing in the same seed and job parameters should produce the same results, but may differ in rare cases.
    If a seed is not specified, one will be generated for you.

    """
    method: FineTuneMethod | None = None
    metadata: Metadata | None = None


class CreateModelResponseProperties(ModelResponseProperties):
    pass
    model_config = ConfigDict(
        populate_by_name=True,
    )


class CreateRunRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    assistant_id: str
    """
    The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.
    """
    model: str | AssistantSupportedModels | None = Field(
        None, examples=["gpt-4o"]
    )
    """
    The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.
    """
    reasoning_effort: ReasoningEffort | None = Field(
        default_factory=lambda: ReasoningEffort.model_validate("medium")
    )
    instructions: str | None = None
    """
    Overrides the [instructions](/docs/api-reference/assistants/createAssistant) of the assistant. This is useful for modifying the behavior on a per-run basis.
    """
    additional_instructions: str | None = None
    """
    Appends additional instructions at the end of the instructions for the run. This is useful for modifying the behavior on a per-run basis without overriding other instructions.
    """
    additional_messages: list[CreateMessageRequest] | None = None
    """
    Adds additional messages to the thread before creating the run.
    """
    tools: (
        list[
            AssistantToolsCode
            | AssistantToolsFileSearch
            | AssistantToolsFunction
        ]
        | None
    ) = Field(None, max_length=20)
    """
    Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.
    """
    metadata: Metadata | None = None
    temperature: float | None = Field(1, examples=[1], ge=0.0, le=2.0)
    """
    What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.

    """
    top_p: float | None = Field(1, examples=[1], ge=0.0, le=1.0)
    """
    An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.

    We generally recommend altering this or temperature but not both.

    """
    stream: bool | None = None
    """
    If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.

    """
    max_prompt_tokens: int | None = Field(None, ge=256)
    """
    The maximum number of prompt tokens that may be used over the course of the run. The run will make a best effort to use only the number of prompt tokens specified, across multiple turns of the run. If the run exceeds the number of prompt tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.

    """
    max_completion_tokens: int | None = Field(None, ge=256)
    """
    The maximum number of completion tokens that may be used over the course of the run. The run will make a best effort to use only the number of completion tokens specified, across multiple turns of the run. If the run exceeds the number of completion tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.

    """
    truncation_strategy: TruncationObject | None = None
    tool_choice: AssistantsApiToolChoiceOption | None = None
    parallel_tool_calls: ParallelToolCalls | None = Field(
        default_factory=lambda: ParallelToolCalls.model_validate(True)
    )
    response_format: AssistantsApiResponseFormatOption | None = None


class CreateThreadAndRunRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    assistant_id: str
    """
    The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.
    """
    thread: CreateThreadRequest | None = None
    model: (
        str
        | Literal[
            "gpt-4.1",
            "gpt-4.1-mini",
            "gpt-4.1-nano",
            "gpt-4.1-2025-04-14",
            "gpt-4.1-mini-2025-04-14",
            "gpt-4.1-nano-2025-04-14",
            "gpt-4o",
            "gpt-4o-2024-11-20",
            "gpt-4o-2024-08-06",
            "gpt-4o-2024-05-13",
            "gpt-4o-mini",
            "gpt-4o-mini-2024-07-18",
            "gpt-4.5-preview",
            "gpt-4.5-preview-2025-02-27",
            "gpt-4-turbo",
            "gpt-4-turbo-2024-04-09",
            "gpt-4-0125-preview",
            "gpt-4-turbo-preview",
            "gpt-4-1106-preview",
            "gpt-4-vision-preview",
            "gpt-4",
            "gpt-4-0314",
            "gpt-4-0613",
            "gpt-4-32k",
            "gpt-4-32k-0314",
            "gpt-4-32k-0613",
            "gpt-3.5-turbo",
            "gpt-3.5-turbo-16k",
            "gpt-3.5-turbo-0613",
            "gpt-3.5-turbo-1106",
            "gpt-3.5-turbo-0125",
            "gpt-3.5-turbo-16k-0613",
        ]
        | None
    ) = Field(None, examples=["gpt-4o"])
    """
    The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.
    """
    instructions: str | None = None
    """
    Override the default system message of the assistant. This is useful for modifying the behavior on a per-run basis.
    """
    tools: (
        list[
            AssistantToolsCode
            | AssistantToolsFileSearch
            | AssistantToolsFunction
        ]
        | None
    ) = Field(None, max_length=20)
    """
    Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.
    """
    tool_resources: ToolResources2 | None = None
    """
    A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """
    metadata: Metadata | None = None
    temperature: float | None = Field(1, examples=[1], ge=0.0, le=2.0)
    """
    What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.

    """
    top_p: float | None = Field(1, examples=[1], ge=0.0, le=1.0)
    """
    An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.

    We generally recommend altering this or temperature but not both.

    """
    stream: bool | None = None
    """
    If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.

    """
    max_prompt_tokens: int | None = Field(None, ge=256)
    """
    The maximum number of prompt tokens that may be used over the course of the run. The run will make a best effort to use only the number of prompt tokens specified, across multiple turns of the run. If the run exceeds the number of prompt tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.

    """
    max_completion_tokens: int | None = Field(None, ge=256)
    """
    The maximum number of completion tokens that may be used over the course of the run. The run will make a best effort to use only the number of completion tokens specified, across multiple turns of the run. If the run exceeds the number of completion tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.

    """
    truncation_strategy: TruncationObject | None = None
    tool_choice: AssistantsApiToolChoiceOption | None = None
    parallel_tool_calls: ParallelToolCalls | None = Field(
        default_factory=lambda: ParallelToolCalls.model_validate(True)
    )
    response_format: AssistantsApiResponseFormatOption | None = None


class EasyInputMessage(BaseModel):
    """
    A message input to the model with a role indicating instruction following
    hierarchy. Instructions given with the `developer` or `system` role take
    precedence over instructions given with the `user` role. Messages with the
    `assistant` role are presumed to have been generated by the model in previous
    interactions.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    role: Literal["user", "assistant", "system", "developer"]
    """
    The role of the message input. One of `user`, `assistant`, `system`, or
    `developer`.

    """
    content: str | InputMessageContentList
    """
    Text, image, or audio input to the model, used to generate a response.
    Can also contain previous assistant responses.

    """
    type: Literal["EasyInputMessage"] = "EasyInputMessage"
    """
    The type of the message input. Always `message`.

    """


class Eval(BaseModel):
    """
    An Eval object with a data source config and testing criteria.
    An Eval represents a task to be done for your LLM integration.
    Like:
     - Improve the quality of my chatbot
     - See how well my chatbot handles customer support
     - Check if o3-mini is better at my usecase than gpt-4o

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["eval"] = "eval"
    """
    The object type.
    """
    id: str
    """
    Unique identifier for the evaluation.
    """
    name: str = Field(..., examples=["Chatbot effectiveness Evaluation"])
    """
    The name of the evaluation.
    """
    data_source_config: (
        EvalCustomDataSourceConfig | EvalStoredCompletionsDataSourceConfig
    )
    """
    Configuration of data sources used in runs of the evaluation.
    """
    testing_criteria: list[
        EvalLabelModelGrader
        | EvalStringCheckGrader
        | EvalTextSimilarityGrader
        | EvalPythonGrader
        | EvalScoreModelGrader
    ]
    """
    A list of testing criteria.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the eval was created.
    """
    metadata: Metadata


class EvalList(BaseModel):
    """
    An object representing a list of evals.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    """
    The type of this object. It is always set to "list".

    """
    data: list[Eval]
    """
    An array of eval objects.

    """
    first_id: str
    """
    The identifier of the first eval in the data array.
    """
    last_id: str
    """
    The identifier of the last eval in the data array.
    """
    has_more: bool
    """
    Indicates whether there are more evals available.
    """


class FineTuneChatCompletionRequestAssistantMessage(
    ChatCompletionRequestAssistantMessage
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    weight: Literal[0, 1] | None = None
    """
    Controls whether the assistant message is trained against (0 or 1)
    """
    role: Literal["assistant"] = "assistant"
    """
    The role of the messages author, in this case `assistant`.
    """


class FineTuneChatRequestInput(BaseModel):
    """
    The per-line training example of a fine-tuning input file for chat models using the supervised method.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    messages: (
        list[
            ChatCompletionRequestSystemMessage
            | ChatCompletionRequestUserMessage
            | FineTuneChatCompletionRequestAssistantMessage
            | ChatCompletionRequestToolMessage
            | ChatCompletionRequestFunctionMessage
        ]
        | None
    ) = Field(None, min_length=1)
    tools: list[ChatCompletionTool] | None = None
    """
    A list of tools the model may generate JSON inputs for.
    """
    parallel_tool_calls: ParallelToolCalls | None = Field(
        default_factory=lambda: ParallelToolCalls.model_validate(True)
    )
    functions: list[ChatCompletionFunctions] | None = Field(
        None, max_length=128, min_length=1
    )
    """
    A list of functions the model may generate JSON inputs for.
    """


class Input5(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    messages: (
        list[
            ChatCompletionRequestSystemMessage
            | ChatCompletionRequestUserMessage
            | FineTuneChatCompletionRequestAssistantMessage
            | ChatCompletionRequestToolMessage
            | ChatCompletionRequestFunctionMessage
        ]
        | None
    ) = Field(None, min_length=1)
    tools: list[ChatCompletionTool] | None = None
    """
    A list of tools the model may generate JSON inputs for.
    """
    parallel_tool_calls: ParallelToolCalls | None = Field(
        default_factory=lambda: ParallelToolCalls.model_validate(True)
    )


class FineTunePreferenceRequestInput(BaseModel):
    """
    The per-line training example of a fine-tuning input file for chat models using the dpo method.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    input: Input5 | None = None
    preferred_completion: (
        list[ChatCompletionRequestAssistantMessage] | None
    ) = Field(None, max_length=1)
    """
    The preferred completion message for the output.
    """
    non_preferred_completion: (
        list[ChatCompletionRequestAssistantMessage] | None
    ) = Field(None, max_length=1)
    """
    The non-preferred completion message for the output.
    """


class InputMessage(BaseModel):
    """
    A message input to the model with a role indicating instruction following
    hierarchy. Instructions given with the `developer` or `system` role take
    precedence over instructions given with the `user` role.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["InputMessage"] = "InputMessage"
    """
    The type of the message input. Always set to `message`.

    """
    role: Literal["user", "system", "developer"]
    """
    The role of the message input. One of `user`, `system`, or `developer`.

    """
    status: Literal["in_progress", "completed", "incomplete"] | None = None
    """
    The status of item. One of `in_progress`, `completed`, or
    `incomplete`. Populated when items are returned via API.

    """
    content: InputMessageContentList


class InputMessageResource(InputMessage):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The unique ID of the message input.

    """
    type: Literal["InputMessageResource"] = "InputMessageResource"


class Item(
    RootModel[
        InputMessage
        | OutputMessage
        | FileSearchToolCall
        | ComputerToolCall
        | ComputerCallOutputItemParam
        | WebSearchToolCall
        | FunctionToolCall
        | FunctionCallOutputItemParam
        | ReasoningItem
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        InputMessage
        | OutputMessage
        | FileSearchToolCall
        | ComputerToolCall
        | ComputerCallOutputItemParam
        | WebSearchToolCall
        | FunctionToolCall
        | FunctionCallOutputItemParam
        | ReasoningItem
    ) = Field(..., discriminator="type")
    """
    Content item used to generate a response.

    """


class ItemResource(
    RootModel[
        InputMessageResource
        | OutputMessage
        | FileSearchToolCall
        | ComputerToolCall
        | ComputerToolCallOutputResource
        | WebSearchToolCall
        | FunctionToolCallResource
        | FunctionToolCallOutputResource
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        InputMessageResource
        | OutputMessage
        | FileSearchToolCall
        | ComputerToolCall
        | ComputerToolCallOutputResource
        | WebSearchToolCall
        | FunctionToolCallResource
        | FunctionToolCallOutputResource
    ) = Field(..., discriminator="type")
    """
    Content item used to generate a response.

    """


class ListMessagesResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: str = Field(..., examples=["list"])
    data: list[MessageObject]
    first_id: str = Field(..., examples=["msg_abc123"])
    last_id: str = Field(..., examples=["msg_abc123"])
    has_more: bool = Field(..., examples=[False])


class ListRunStepsResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: str = Field(..., examples=["list"])
    data: list[RunStepObject]
    first_id: str = Field(..., examples=["step_abc123"])
    last_id: str = Field(..., examples=["step_abc456"])
    has_more: bool = Field(..., examples=[False])


class ModelIds(RootModel[ModelIdsShared | ModelIdsResponses]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: ModelIdsShared | ModelIdsResponses


class ModifyAssistantRequest(BaseModel):
    model_config = ConfigDict(
        extra="forbid",
        populate_by_name=True,
    )
    model: str | AssistantSupportedModels | None = None
    """
    ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models) for descriptions of them.

    """
    reasoning_effort: ReasoningEffort | None = Field(
        default_factory=lambda: ReasoningEffort.model_validate("medium")
    )
    name: str | None = Field(None, max_length=256)
    """
    The name of the assistant. The maximum length is 256 characters.

    """
    description: str | None = Field(None, max_length=512)
    """
    The description of the assistant. The maximum length is 512 characters.

    """
    instructions: str | None = Field(None, max_length=256000)
    """
    The system instructions that the assistant uses. The maximum length is 256,000 characters.

    """
    tools: (
        list[
            AssistantToolsCode
            | AssistantToolsFileSearch
            | AssistantToolsFunction
        ]
        | None
    ) = Field([], max_length=128)
    """
    A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `file_search`, or `function`.

    """
    tool_resources: ToolResources4 | None = None
    """
    A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """
    metadata: Metadata | None = None
    temperature: float | None = Field(1, examples=[1], ge=0.0, le=2.0)
    """
    What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.

    """
    top_p: float | None = Field(1, examples=[1], ge=0.0, le=1.0)
    """
    An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.

    We generally recommend altering this or temperature but not both.

    """
    response_format: AssistantsApiResponseFormatOption | None = None


class OutputItem1(
    RootModel[
        OutputMessage
        | FileSearchToolCall
        | FunctionToolCall
        | WebSearchToolCall
        | ComputerToolCall
        | ReasoningItem
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        OutputMessage
        | FileSearchToolCall
        | FunctionToolCall
        | WebSearchToolCall
        | ComputerToolCall
        | ReasoningItem
    ) = Field(..., discriminator="type")


class RealtimeClientEventResponseCreate(BaseModel):
    """
    This event instructs the server to create a Response, which means triggering
    model inference. When in Server VAD mode, the server will create Responses
    automatically.

    A Response will include at least one Item, and may have two, in which case
    the second will be a function call. These Items will be appended to the
    conversation history.

    The server will respond with a `response.created` event, events for Items
    and content created, and finally a `response.done` event to indicate the
    Response is complete.

    The `response.create` event includes inference configuration like
    `instructions`, and `temperature`. These fields will override the Session's
    configuration for this Response only.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    Optional client-generated ID used to identify this event.
    """
    type: Literal["RealtimeClientEventResponseCreate"] = (
        "RealtimeClientEventResponseCreate"
    )
    """
    The event type, must be `response.create`.
    """
    response: RealtimeResponseCreateParams | None = None


class RealtimeClientEventSessionUpdate(BaseModel):
    """
    Send this event to update the session’s default configuration.
    The client may send this event at any time to update any field,
    except for `voice`. However, note that once a session has been
    initialized with a particular `model`, it can’t be changed to
    another model using `session.update`.

    When the server receives a `session.update`, it will respond
    with a `session.updated` event showing the full, effective configuration.
    Only the fields that are present are updated. To clear a field like
    `instructions`, pass an empty string.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str | None = None
    """
    Optional client-generated ID used to identify this event.
    """
    type: Literal["RealtimeClientEventSessionUpdate"] = (
        "RealtimeClientEventSessionUpdate"
    )
    """
    The event type, must be `session.update`.
    """
    session: RealtimeSessionCreateRequest


class RealtimeServerEventSessionCreated(BaseModel):
    """
    Returned when a Session is created. Emitted automatically when a new
    connection is established as the first server event. This event will contain
    the default Session configuration.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventSessionCreated"] = (
        "RealtimeServerEventSessionCreated"
    )
    """
    The event type, must be `session.created`.
    """
    session: RealtimeSession


class RealtimeServerEventSessionUpdated(BaseModel):
    """
    Returned when a session is updated with a `session.update` event, unless
    there is an error.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event_id: str
    """
    The unique ID of the server event.
    """
    type: Literal["RealtimeServerEventSessionUpdated"] = (
        "RealtimeServerEventSessionUpdated"
    )
    """
    The event type, must be `session.updated`.
    """
    session: RealtimeSession


class ResponseItemList(BaseModel):
    """
    A list of Response items.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    """
    The type of object returned, must be `list`.
    """
    data: list[ItemResource]
    """
    A list of items used to generate this response.
    """
    has_more: bool
    """
    Whether there are more items available.
    """
    first_id: str
    """
    The ID of the first item in the list.
    """
    last_id: str
    """
    The ID of the last item in the list.
    """


class ResponseOutputItemAddedEvent(BaseModel):
    """
    Emitted when a new output item is added.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseOutputItemAddedEvent"] = (
        "ResponseOutputItemAddedEvent"
    )
    """
    The type of the event. Always `response.output_item.added`.

    """
    output_index: int
    """
    The index of the output item that was added.

    """
    item: OutputItem1
    """
    The output item that was added.

    """


class ResponseOutputItemDoneEvent(BaseModel):
    """
    Emitted when an output item is marked done.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseOutputItemDoneEvent"] = (
        "ResponseOutputItemDoneEvent"
    )
    """
    The type of the event. Always `response.output_item.done`.

    """
    output_index: int
    """
    The index of the output item that was marked done.

    """
    item: OutputItem1
    """
    The output item that was marked done.

    """


class Text2(BaseModel):
    """
    Configuration options for a text response from the model. Can be plain
    text or structured JSON data. Learn more:
    - [Text inputs and outputs](/docs/guides/text)
    - [Structured Outputs](/docs/guides/structured-outputs)

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    format: TextResponseFormatConfiguration | None = None


class ResponseProperties(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    previous_response_id: str | None = None
    """
    The unique ID of the previous response to the model. Use this to
    create multi-turn conversations. Learn more about 
    [conversation state](/docs/guides/conversation-state).

    """
    model: ModelIdsResponses | None = None
    """
    Model ID used to generate the response, like `gpt-4o` or `o3`. OpenAI
    offers a wide range of models with different capabilities, performance
    characteristics, and price points. Refer to the [model guide](/docs/models)
    to browse and compare available models.

    """
    reasoning: Reasoning | None = None
    max_output_tokens: int | None = None
    """
    An upper bound for the number of tokens that can be generated for a response, including visible output tokens and [reasoning tokens](/docs/guides/reasoning).

    """
    instructions: str | None = None
    """
    Inserts a system (or developer) message as the first item in the model's context.

    When using along with `previous_response_id`, the instructions from a previous
    response will not be carried over to the next response. This makes it simple
    to swap out system (or developer) messages in new responses.

    """
    text: Text2 | None = None
    """
    Configuration options for a text response from the model. Can be plain
    text or structured JSON data. Learn more:
    - [Text inputs and outputs](/docs/guides/text)
    - [Structured Outputs](/docs/guides/structured-outputs)

    """
    tools: list[ToolModel] | None = None
    """
    An array of tools the model may call while generating a response. You 
    can specify which tool to use by setting the `tool_choice` parameter.

    The two categories of tools you can provide the model are:

    - **Built-in tools**: Tools that are provided by OpenAI that extend the
      model's capabilities, like [web search](/docs/guides/tools-web-search)
      or [file search](/docs/guides/tools-file-search). Learn more about
      [built-in tools](/docs/guides/tools).
    - **Function calls (custom tools)**: Functions that are defined by you,
      enabling the model to call your own code. Learn more about
      [function calling](/docs/guides/function-calling).

    """
    tool_choice: (
        ToolChoiceOptions | ToolChoiceTypes | ToolChoiceFunction | None
    ) = None
    """
    How the model should select which tool (or tools) to use when generating
    a response. See the `tools` parameter to see how to specify which tools
    the model can call.

    """
    truncation: Literal["auto", "disabled"] | None = "disabled"
    """
    The truncation strategy to use for the model response.
    - `auto`: If the context of this response and previous ones exceeds
      the model's context window size, the model will truncate the 
      response to fit the context window by dropping input items in the
      middle of the conversation. 
    - `disabled` (default): If a model response will exceed the context window 
      size for a model, the request will fail with a 400 error.

    """


class RunObject(BaseModel):
    """
    Represents an execution run on a [thread](/docs/api-reference/threads).
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier, which can be referenced in API endpoints.
    """
    object: Literal["thread.run"] = "thread.run"
    """
    The object type, which is always `thread.run`.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the run was created.
    """
    thread_id: str
    """
    The ID of the [thread](/docs/api-reference/threads) that was executed on as a part of this run.
    """
    assistant_id: str
    """
    The ID of the [assistant](/docs/api-reference/assistants) used for execution of this run.
    """
    status: Literal[
        "queued",
        "in_progress",
        "requires_action",
        "cancelling",
        "cancelled",
        "failed",
        "completed",
        "incomplete",
        "expired",
    ]
    """
    The status of the run, which can be either `queued`, `in_progress`, `requires_action`, `cancelling`, `cancelled`, `failed`, `completed`, `incomplete`, or `expired`.
    """
    required_action: RequiredAction
    """
    Details on the action required to continue the run. Will be `null` if no action is required.
    """
    last_error: LastError
    """
    The last error associated with this run. Will be `null` if there are no errors.
    """
    expires_at: int
    """
    The Unix timestamp (in seconds) for when the run will expire.
    """
    started_at: int
    """
    The Unix timestamp (in seconds) for when the run was started.
    """
    cancelled_at: int
    """
    The Unix timestamp (in seconds) for when the run was cancelled.
    """
    failed_at: int
    """
    The Unix timestamp (in seconds) for when the run failed.
    """
    completed_at: int
    """
    The Unix timestamp (in seconds) for when the run was completed.
    """
    incomplete_details: IncompleteDetails2
    """
    Details on why the run is incomplete. Will be `null` if the run is not incomplete.
    """
    model: str
    """
    The model that the [assistant](/docs/api-reference/assistants) used for this run.
    """
    instructions: str
    """
    The instructions that the [assistant](/docs/api-reference/assistants) used for this run.
    """
    tools: list[
        AssistantToolsCode | AssistantToolsFileSearch | AssistantToolsFunction
    ] = Field(..., max_length=20)
    """
    The list of tools that the [assistant](/docs/api-reference/assistants) used for this run.
    """
    metadata: Metadata
    usage: RunCompletionUsage
    temperature: float | None = None
    """
    The sampling temperature used for this run. If not set, defaults to 1.
    """
    top_p: float | None = None
    """
    The nucleus sampling value used for this run. If not set, defaults to 1.
    """
    max_prompt_tokens: int = Field(..., ge=256)
    """
    The maximum number of prompt tokens specified to have been used over the course of the run.

    """
    max_completion_tokens: int = Field(..., ge=256)
    """
    The maximum number of completion tokens specified to have been used over the course of the run.

    """
    truncation_strategy: TruncationObject
    tool_choice: AssistantsApiToolChoiceOption
    parallel_tool_calls: ParallelToolCalls
    response_format: AssistantsApiResponseFormatOption


class Delta1(BaseModel):
    """
    The delta containing the fields that have changed on the run step.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    step_details: (
        RunStepDeltaStepDetailsMessageCreationObject
        | RunStepDeltaStepDetailsToolCallsObject
        | None
    ) = None
    """
    The details of the run step.
    """


class RunStepDeltaObject(BaseModel):
    """
    Represents a run step delta i.e. any changed fields on a run step during streaming.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier of the run step, which can be referenced in API endpoints.
    """
    object: Literal["thread.run.step.delta"] = "thread.run.step.delta"
    """
    The object type, which is always `thread.run.step.delta`.
    """
    delta: Delta1
    """
    The delta containing the fields that have changed on the run step.
    """


class RunStepStreamEvent3(BaseModel):
    """
    Occurs when parts of a [run step](/docs/api-reference/run-steps/step-object) are being streamed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.step.delta"] = "thread.run.step.delta"
    data: RunStepDeltaObject


class RunStepStreamEvent(
    RootModel[
        RunStepStreamEvent1
        | RunStepStreamEvent2
        | RunStepStreamEvent3
        | RunStepStreamEvent4
        | RunStepStreamEvent5
        | RunStepStreamEvent6
        | RunStepStreamEvent7
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        RunStepStreamEvent1
        | RunStepStreamEvent2
        | RunStepStreamEvent3
        | RunStepStreamEvent4
        | RunStepStreamEvent5
        | RunStepStreamEvent6
        | RunStepStreamEvent7
    )


class RunStreamEvent1(BaseModel):
    """
    Occurs when a new [run](/docs/api-reference/runs/object) is created.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.created"] = "thread.run.created"
    data: RunObject


class RunStreamEvent2(BaseModel):
    """
    Occurs when a [run](/docs/api-reference/runs/object) moves to a `queued` status.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.queued"] = "thread.run.queued"
    data: RunObject


class RunStreamEvent3(BaseModel):
    """
    Occurs when a [run](/docs/api-reference/runs/object) moves to an `in_progress` status.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.in_progress"] = "thread.run.in_progress"
    data: RunObject


class RunStreamEvent4(BaseModel):
    """
    Occurs when a [run](/docs/api-reference/runs/object) moves to a `requires_action` status.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.requires_action"] = "thread.run.requires_action"
    data: RunObject


class RunStreamEvent5(BaseModel):
    """
    Occurs when a [run](/docs/api-reference/runs/object) is completed.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.completed"] = "thread.run.completed"
    data: RunObject


class RunStreamEvent6(BaseModel):
    """
    Occurs when a [run](/docs/api-reference/runs/object) ends with status `incomplete`.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.incomplete"] = "thread.run.incomplete"
    data: RunObject


class RunStreamEvent7(BaseModel):
    """
    Occurs when a [run](/docs/api-reference/runs/object) fails.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.failed"] = "thread.run.failed"
    data: RunObject


class RunStreamEvent8(BaseModel):
    """
    Occurs when a [run](/docs/api-reference/runs/object) moves to a `cancelling` status.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.cancelling"] = "thread.run.cancelling"
    data: RunObject


class RunStreamEvent9(BaseModel):
    """
    Occurs when a [run](/docs/api-reference/runs/object) is cancelled.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.cancelled"] = "thread.run.cancelled"
    data: RunObject


class RunStreamEvent10(BaseModel):
    """
    Occurs when a [run](/docs/api-reference/runs/object) expires.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    event: Literal["thread.run.expired"] = "thread.run.expired"
    data: RunObject


class RunStreamEvent(
    RootModel[
        RunStreamEvent1
        | RunStreamEvent2
        | RunStreamEvent3
        | RunStreamEvent4
        | RunStreamEvent5
        | RunStreamEvent6
        | RunStreamEvent7
        | RunStreamEvent8
        | RunStreamEvent9
        | RunStreamEvent10
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        RunStreamEvent1
        | RunStreamEvent2
        | RunStreamEvent3
        | RunStreamEvent4
        | RunStreamEvent5
        | RunStreamEvent6
        | RunStreamEvent7
        | RunStreamEvent8
        | RunStreamEvent9
        | RunStreamEvent10
    )


class UsageResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["page"] = "page"
    data: list[UsageTimeBucket]
    has_more: bool
    next_page: str


class AssistantObject(BaseModel):
    """
    Represents an `assistant` that can call the model and use tools.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The identifier, which can be referenced in API endpoints.
    """
    object: Literal["assistant"] = "assistant"
    """
    The object type, which is always `assistant`.
    """
    created_at: int
    """
    The Unix timestamp (in seconds) for when the assistant was created.
    """
    name: str = Field(..., max_length=256)
    """
    The name of the assistant. The maximum length is 256 characters.

    """
    description: str = Field(..., max_length=512)
    """
    The description of the assistant. The maximum length is 512 characters.

    """
    model: str
    """
    ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models) for descriptions of them.

    """
    instructions: str = Field(..., max_length=256000)
    """
    The system instructions that the assistant uses. The maximum length is 256,000 characters.

    """
    tools: list[
        AssistantToolsCode | AssistantToolsFileSearch | AssistantToolsFunction
    ] = Field(..., max_length=128)
    """
    A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `file_search`, or `function`.

    """
    tool_resources: ToolResources | None = None
    """
    A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.

    """
    metadata: Metadata
    temperature: float | None = Field(1, examples=[1], ge=0.0, le=2.0)
    """
    What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.

    """
    top_p: float | None = Field(1, examples=[1], ge=0.0, le=1.0)
    """
    An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.

    We generally recommend altering this or temperature but not both.

    """
    response_format: AssistantsApiResponseFormatOption | None = None


class AssistantStreamEvent(
    RootModel[
        ThreadStreamEvent
        | RunStreamEvent
        | RunStepStreamEvent
        | MessageStreamEvent
        | ErrorEvent
        | DoneEvent
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        ThreadStreamEvent
        | RunStreamEvent
        | RunStepStreamEvent
        | MessageStreamEvent
        | ErrorEvent
        | DoneEvent
    )
    """
    Represents an event emitted when streaming a Run.

    Each event in a server-sent events stream has an `event` and `data` property:

    ```
    event: thread.created
    data: {"id": "thread_123", "object": "thread", ...}
    ```

    We emit events whenever a new object is created, transitions to a new state, or is being
    streamed in parts (deltas). For example, we emit `thread.run.created` when a new run
    is created, `thread.run.completed` when a run completes, and so on. When an Assistant chooses
    to create a message during a run, we emit a `thread.message.created event`, a
    `thread.message.in_progress` event, many `thread.message.delta` events, and finally a
    `thread.message.completed` event.

    We may add additional events over time, so we recommend handling unknown events gracefully
    in your code. See the [Assistants API quickstart](/docs/assistants/overview) to learn how to
    integrate the Assistants API with streaming.

    """


class AuditLog(BaseModel):
    """
    A log of a user action or configuration change within this organization.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    The ID of this log.
    """
    type: AuditLogEventType
    effective_at: int
    """
    The Unix timestamp (in seconds) of the event.
    """
    project: Project | None = None
    """
    The project that the action was scoped to. Absent for actions not scoped to projects.
    """
    actor: AuditLogActor
    api_key_created: ApiKeyCreated | None = None
    """
    The details for events with this `type`.
    """
    api_key_updated: ApiKeyUpdated | None = None
    """
    The details for events with this `type`.
    """
    api_key_deleted: ApiKeyDeleted | None = None
    """
    The details for events with this `type`.
    """
    checkpoint_permission_created: CheckpointPermissionCreated | None = None
    """
    The project and fine-tuned model checkpoint that the checkpoint permission was created for.
    """
    checkpoint_permission_deleted: CheckpointPermissionDeleted | None = None
    """
    The details for events with this `type`.
    """
    invite_sent: InviteSent | None = None
    """
    The details for events with this `type`.
    """
    invite_accepted: InviteAccepted | None = None
    """
    The details for events with this `type`.
    """
    invite_deleted: InviteDeleted | None = None
    """
    The details for events with this `type`.
    """
    login_failed: LoginFailed | None = None
    """
    The details for events with this `type`.
    """
    logout_failed: LogoutFailed | None = None
    """
    The details for events with this `type`.
    """
    organization_updated: OrganizationUpdated | None = None
    """
    The details for events with this `type`.
    """
    project_created: ProjectCreated | None = None
    """
    The details for events with this `type`.
    """
    project_updated: ProjectUpdated | None = None
    """
    The details for events with this `type`.
    """
    project_archived: ProjectArchived | None = None
    """
    The details for events with this `type`.
    """
    rate_limit_updated: RateLimitUpdated | None = None
    """
    The details for events with this `type`.
    """
    rate_limit_deleted: RateLimitDeleted | None = None
    """
    The details for events with this `type`.
    """
    service_account_created: ServiceAccountCreated | None = None
    """
    The details for events with this `type`.
    """
    service_account_updated: ServiceAccountUpdated | None = None
    """
    The details for events with this `type`.
    """
    service_account_deleted: ServiceAccountDeleted | None = None
    """
    The details for events with this `type`.
    """
    user_added: UserAdded | None = None
    """
    The details for events with this `type`.
    """
    user_updated: UserUpdated | None = None
    """
    The details for events with this `type`.
    """
    user_deleted: UserDeleted | None = None
    """
    The details for events with this `type`.
    """
    certificate_created: CertificateCreated | None = None
    """
    The details for events with this `type`.
    """
    certificate_updated: CertificateUpdated | None = None
    """
    The details for events with this `type`.
    """
    certificate_deleted: CertificateDeleted | None = None
    """
    The details for events with this `type`.
    """
    certificates_activated: CertificatesActivated | None = None
    """
    The details for events with this `type`.
    """
    certificates_deactivated: CertificatesDeactivated | None = None
    """
    The details for events with this `type`.
    """


class CreateChatCompletionRequest(CreateModelResponseProperties):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    messages: list[ChatCompletionRequestMessage] = Field(..., min_length=1)
    """
    A list of messages comprising the conversation so far. Depending on the
    [model](/docs/models) you use, different message types (modalities) are
    supported, like [text](/docs/guides/text-generation),
    [images](/docs/guides/vision), and [audio](/docs/guides/audio).

    """
    model: ModelIdsShared
    """
    Model ID used to generate the response, like `gpt-4o` or `o3`. OpenAI
    offers a wide range of models with different capabilities, performance
    characteristics, and price points. Refer to the [model guide](/docs/models)
    to browse and compare available models.

    """
    modalities: ResponseModalities | None = None
    reasoning_effort: ReasoningEffort | None = Field(
        default_factory=lambda: ReasoningEffort.model_validate("medium")
    )
    max_completion_tokens: int | None = None
    """
    An upper bound for the number of tokens that can be generated for a completion, including visible output tokens and [reasoning tokens](/docs/guides/reasoning).

    """
    frequency_penalty: float | None = Field(0, ge=-2.0, le=2.0)
    """
    Number between -2.0 and 2.0. Positive values penalize new tokens based on
    their existing frequency in the text so far, decreasing the model's
    likelihood to repeat the same line verbatim.

    """
    presence_penalty: float | None = Field(0, ge=-2.0, le=2.0)
    """
    Number between -2.0 and 2.0. Positive values penalize new tokens based on
    whether they appear in the text so far, increasing the model's likelihood
    to talk about new topics.

    """
    web_search_options: WebSearchOptions | None = Field(
        None, title="Web search"
    )
    """
    This tool searches the web for relevant results to use in a response.
    Learn more about the [web search tool](/docs/guides/tools-web-search?api-mode=chat).

    """
    top_logprobs: int | None = Field(None, ge=0, le=20)
    """
    An integer between 0 and 20 specifying the number of most likely tokens to
    return at each token position, each with an associated log probability.
    `logprobs` must be set to `true` if this parameter is used.

    """
    response_format: (
        ResponseFormatText
        | ResponseFormatJsonSchema
        | ResponseFormatJsonObject
        | None
    ) = None
    """
    An object specifying the format that the model must output.

    Setting to `{ "type": "json_schema", "json_schema": {...} }` enables
    Structured Outputs which ensures the model will match your supplied JSON
    schema. Learn more in the [Structured Outputs
    guide](/docs/guides/structured-outputs).

    Setting to `{ "type": "json_object" }` enables the older JSON mode, which
    ensures the message the model generates is valid JSON. Using `json_schema`
    is preferred for models that support it.

    """
    audio: Audio2 | None = None
    """
    Parameters for audio output. Required when audio output is requested with
    `modalities: ["audio"]`. [Learn more](/docs/guides/audio).

    """
    store: bool | None = False
    """
    Whether or not to store the output of this chat completion request for 
    use in our [model distillation](/docs/guides/distillation) or
    [evals](/docs/guides/evals) products.

    """
    stream: bool | None = False
    """
    If set to true, the model response data will be streamed to the client
    as it is generated using [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format).
    See the [Streaming section below](/docs/api-reference/chat/streaming)
    for more information, along with the [streaming responses](/docs/guides/streaming-responses)
    guide for more information on how to handle the streaming events.

    """
    stop: StopConfiguration | None = None
    logit_bias: dict[str, int] | None = None
    """
    Modify the likelihood of specified tokens appearing in the completion.

    Accepts a JSON object that maps tokens (specified by their token ID in the
    tokenizer) to an associated bias value from -100 to 100. Mathematically,
    the bias is added to the logits generated by the model prior to sampling.
    The exact effect will vary per model, but values between -1 and 1 should
    decrease or increase likelihood of selection; values like -100 or 100
    should result in a ban or exclusive selection of the relevant token.

    """
    logprobs: bool | None = False
    """
    Whether to return log probabilities of the output tokens or not. If true,
    returns the log probabilities of each output token returned in the
    `content` of `message`.

    """
    max_tokens: int | None = None
    """
    The maximum number of [tokens](/tokenizer) that can be generated in the
    chat completion. This value can be used to control
    [costs](https://openai.com/api/pricing/) for text generated via API.

    This value is now deprecated in favor of `max_completion_tokens`, and is
    not compatible with [o-series models](/docs/guides/reasoning).

    """
    n: int | None = Field(1, examples=[1], ge=1, le=128)
    """
    How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep `n` as `1` to minimize costs.
    """
    prediction: PredictionContent | None = None
    """
    Configuration for a [Predicted Output](/docs/guides/predicted-outputs),
    which can greatly improve response times when large parts of the model
    response are known ahead of time. This is most common when you are
    regenerating a file with only minor changes to most of the content.

    """
    seed: int | None = Field(
        None, ge=-9223372036854776000, le=9223372036854776000
    )
    """
    This feature is in Beta.
    If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.
    Determinism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.

    """
    stream_options: ChatCompletionStreamOptions | None = None
    tools: list[ChatCompletionTool] | None = None
    """
    A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported.

    """
    tool_choice: ChatCompletionToolChoiceOption | None = None
    parallel_tool_calls: ParallelToolCalls | None = Field(
        default_factory=lambda: ParallelToolCalls.model_validate(True)
    )
    function_call: (
        Literal["none", "auto"] | ChatCompletionFunctionCallOption | None
    ) = None
    """
    Deprecated in favor of `tool_choice`.

    Controls which (if any) function is called by the model.

    `none` means the model will not call a function and instead generates a
    message.

    `auto` means the model can pick between generating a message or calling a
    function.

    Specifying a particular function via `{"name": "my_function"}` forces the
    model to call that function.

    `none` is the default when no functions are present. `auto` is the default
    if functions are present.

    """
    functions: list[ChatCompletionFunctions] | None = Field(
        None, max_length=128, min_length=1
    )
    """
    Deprecated in favor of `tools`.

    A list of functions the model may generate JSON inputs for.

    """


class InputMessages(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["template"] = "template"
    """
    The type of input messages. Always `template`.
    """
    template: list[EasyInputMessage | EvalItem]
    """
    A list of chat messages forming the prompt or context. May include variable references to the "item" namespace, ie {{item.name}}.
    """


class CreateEvalCompletionsRunDataSource(BaseModel):
    """
    A CompletionsRunDataSource object describing a model sampling configuration.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["completions"] = "completions"
    """
    The type of run data source. Always `completions`.
    """
    input_messages: InputMessages | InputMessages1 | None = None
    sampling_params: SamplingParams | None = None
    model: str | None = None
    """
    The name of the model to use for generating completions (e.g. "o3-mini").
    """
    source: (
        EvalJsonlFileContentSource
        | EvalJsonlFileIdSource
        | EvalStoredCompletionsSource
    )


class CreateEvalRunRequest(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    name: str | None = None
    """
    The name of the run.
    """
    metadata: Metadata | None = None
    data_source: (
        CreateEvalJsonlRunDataSource
        | CreateEvalCompletionsRunDataSource
        | CreateEvalResponsesRunDataSource
    )
    """
    Details about the run's data source.
    """


class EvalRun(BaseModel):
    """
    A schema representing an evaluation run.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["eval.run"] = "eval.run"
    """
    The type of the object. Always "eval.run".
    """
    id: str
    """
    Unique identifier for the evaluation run.
    """
    eval_id: str
    """
    The identifier of the associated evaluation.
    """
    status: str
    """
    The status of the evaluation run.
    """
    model: str
    """
    The model that is evaluated, if applicable.
    """
    name: str
    """
    The name of the evaluation run.
    """
    created_at: int
    """
    Unix timestamp (in seconds) when the evaluation run was created.
    """
    report_url: str
    """
    The URL to the rendered evaluation run report on the UI dashboard.
    """
    result_counts: ResultCounts
    """
    Counters summarizing the outcomes of the evaluation run.
    """
    per_model_usage: list[PerModelUsageItem]
    """
    Usage statistics for each model during the evaluation run.
    """
    per_testing_criteria_results: list[PerTestingCriteriaResult]
    """
    Results per testing criteria applied during the evaluation run.
    """
    data_source: (
        CreateEvalJsonlRunDataSource
        | CreateEvalCompletionsRunDataSource
        | CreateEvalResponsesRunDataSource
    )
    """
    Information about the run's data source.
    """
    metadata: Metadata
    error: EvalApiError


class EvalRunList(BaseModel):
    """
    An object representing a list of runs for an evaluation.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    """
    The type of this object. It is always set to "list".

    """
    data: list[EvalRun]
    """
    An array of eval run objects.

    """
    first_id: str
    """
    The identifier of the first eval run in the data array.
    """
    last_id: str
    """
    The identifier of the last eval run in the data array.
    """
    has_more: bool
    """
    Indicates whether there are more evals available.
    """


class InputItem(RootModel[EasyInputMessage | Item | ItemReferenceParam]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: EasyInputMessage | Item | ItemReferenceParam = Field(
        ..., discriminator="type"
    )


class ListAssistantsResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: str = Field(..., examples=["list"])
    data: list[AssistantObject]
    first_id: str = Field(..., examples=["asst_abc123"])
    last_id: str = Field(..., examples=["asst_abc456"])
    has_more: bool = Field(..., examples=[False])


class ListAuditLogsResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: Literal["list"] = "list"
    data: list[AuditLog]
    first_id: str = Field(..., examples=["audit_log-defb456h8dks"])
    last_id: str = Field(..., examples=["audit_log-hnbkd8s93s"])
    has_more: bool


class ListRunsResponse(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    object: str = Field(..., examples=["list"])
    data: list[RunObject]
    first_id: str = Field(..., examples=["run_abc123"])
    last_id: str = Field(..., examples=["run_abc456"])
    has_more: bool = Field(..., examples=[False])


class RealtimeClientEvent(
    RootModel[
        RealtimeClientEventConversationItemCreate
        | RealtimeClientEventConversationItemDelete
        | RealtimeClientEventConversationItemRetrieve
        | RealtimeClientEventConversationItemTruncate
        | RealtimeClientEventInputAudioBufferAppend
        | RealtimeClientEventInputAudioBufferClear
        | RealtimeClientEventOutputAudioBufferClear
        | RealtimeClientEventInputAudioBufferCommit
        | RealtimeClientEventResponseCancel
        | RealtimeClientEventResponseCreate
        | RealtimeClientEventSessionUpdate
        | RealtimeClientEventTranscriptionSessionUpdate
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        RealtimeClientEventConversationItemCreate
        | RealtimeClientEventConversationItemDelete
        | RealtimeClientEventConversationItemRetrieve
        | RealtimeClientEventConversationItemTruncate
        | RealtimeClientEventInputAudioBufferAppend
        | RealtimeClientEventInputAudioBufferClear
        | RealtimeClientEventOutputAudioBufferClear
        | RealtimeClientEventInputAudioBufferCommit
        | RealtimeClientEventResponseCancel
        | RealtimeClientEventResponseCreate
        | RealtimeClientEventSessionUpdate
        | RealtimeClientEventTranscriptionSessionUpdate
    ) = Field(..., discriminator="type")
    """
    A realtime client event.

    """


class RealtimeServerEvent(
    RootModel[
        RealtimeServerEventConversationCreated
        | RealtimeServerEventConversationItemCreated
        | RealtimeServerEventConversationItemDeleted
        | RealtimeServerEventConversationItemInputAudioTranscriptionCompleted
        | RealtimeServerEventConversationItemInputAudioTranscriptionDelta
        | RealtimeServerEventConversationItemInputAudioTranscriptionFailed
        | RealtimeServerEventConversationItemRetrieved
        | RealtimeServerEventConversationItemTruncated
        | RealtimeServerEventError
        | RealtimeServerEventInputAudioBufferCleared
        | RealtimeServerEventInputAudioBufferCommitted
        | RealtimeServerEventInputAudioBufferSpeechStarted
        | RealtimeServerEventInputAudioBufferSpeechStopped
        | RealtimeServerEventRateLimitsUpdated
        | RealtimeServerEventResponseAudioDelta
        | RealtimeServerEventResponseAudioDone
        | RealtimeServerEventResponseAudioTranscriptDelta
        | RealtimeServerEventResponseAudioTranscriptDone
        | RealtimeServerEventResponseContentPartAdded
        | RealtimeServerEventResponseContentPartDone
        | RealtimeServerEventResponseCreated
        | RealtimeServerEventResponseDone
        | RealtimeServerEventResponseFunctionCallArgumentsDelta
        | RealtimeServerEventResponseFunctionCallArgumentsDone
        | RealtimeServerEventResponseOutputItemAdded
        | RealtimeServerEventResponseOutputItemDone
        | RealtimeServerEventResponseTextDelta
        | RealtimeServerEventResponseTextDone
        | RealtimeServerEventSessionCreated
        | RealtimeServerEventSessionUpdated
        | RealtimeServerEventTranscriptionSessionUpdated
        | RealtimeServerEventOutputAudioBufferStarted
        | RealtimeServerEventOutputAudioBufferStopped
        | RealtimeServerEventOutputAudioBufferCleared
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        RealtimeServerEventConversationCreated
        | RealtimeServerEventConversationItemCreated
        | RealtimeServerEventConversationItemDeleted
        | RealtimeServerEventConversationItemInputAudioTranscriptionCompleted
        | RealtimeServerEventConversationItemInputAudioTranscriptionDelta
        | RealtimeServerEventConversationItemInputAudioTranscriptionFailed
        | RealtimeServerEventConversationItemRetrieved
        | RealtimeServerEventConversationItemTruncated
        | RealtimeServerEventError
        | RealtimeServerEventInputAudioBufferCleared
        | RealtimeServerEventInputAudioBufferCommitted
        | RealtimeServerEventInputAudioBufferSpeechStarted
        | RealtimeServerEventInputAudioBufferSpeechStopped
        | RealtimeServerEventRateLimitsUpdated
        | RealtimeServerEventResponseAudioDelta
        | RealtimeServerEventResponseAudioDone
        | RealtimeServerEventResponseAudioTranscriptDelta
        | RealtimeServerEventResponseAudioTranscriptDone
        | RealtimeServerEventResponseContentPartAdded
        | RealtimeServerEventResponseContentPartDone
        | RealtimeServerEventResponseCreated
        | RealtimeServerEventResponseDone
        | RealtimeServerEventResponseFunctionCallArgumentsDelta
        | RealtimeServerEventResponseFunctionCallArgumentsDone
        | RealtimeServerEventResponseOutputItemAdded
        | RealtimeServerEventResponseOutputItemDone
        | RealtimeServerEventResponseTextDelta
        | RealtimeServerEventResponseTextDone
        | RealtimeServerEventSessionCreated
        | RealtimeServerEventSessionUpdated
        | RealtimeServerEventTranscriptionSessionUpdated
        | RealtimeServerEventOutputAudioBufferStarted
        | RealtimeServerEventOutputAudioBufferStopped
        | RealtimeServerEventOutputAudioBufferCleared
    ) = Field(..., discriminator="type")
    """
    A realtime server event.

    """


class Response1(ModelResponseProperties, ResponseProperties):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: str
    """
    Unique identifier for this Response.

    """
    object: Literal["response"] = "response"
    """
    The object type of this resource - always set to `response`.

    """
    status: (
        Literal["completed", "failed", "in_progress", "incomplete"] | None
    ) = None
    """
    The status of the response generation. One of `completed`, `failed`, 
    `in_progress`, or `incomplete`.

    """
    created_at: float
    """
    Unix timestamp (in seconds) of when this Response was created.

    """
    error: ResponseError
    incomplete_details: IncompleteDetails1
    """
    Details about why the response is incomplete.

    """
    output: list[OutputItem1]
    """
    An array of content items generated by the model.

    - The length and order of items in the `output` array is dependent
      on the model's response.
    - Rather than accessing the first item in the `output` array and 
      assuming it's an `assistant` message with the content generated by
      the model, you might consider using the `output_text` property where
      supported in SDKs.

    """
    output_text: str | None = None
    """
    SDK-only convenience property that contains the aggregated text output 
    from all `output_text` items in the `output` array, if any are present. 
    Supported in the Python and JavaScript SDKs.

    """
    usage: ResponseUsage | None = None
    parallel_tool_calls: bool
    """
    Whether to allow the model to run tool calls in parallel.

    """


class ResponseCompletedEvent(BaseModel):
    """
    Emitted when the model response is complete.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseCompletedEvent"] = "ResponseCompletedEvent"
    """
    The type of the event. Always `response.completed`.

    """
    response: Response1
    """
    Properties of the completed response.

    """


class ResponseCreatedEvent(BaseModel):
    """
    An event that is emitted when a response is created.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseCreatedEvent"] = "ResponseCreatedEvent"
    """
    The type of the event. Always `response.created`.

    """
    response: Response1
    """
    The response that was created.

    """


class ResponseFailedEvent(BaseModel):
    """
    An event that is emitted when a response fails.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseFailedEvent"] = "ResponseFailedEvent"
    """
    The type of the event. Always `response.failed`.

    """
    response: Response1
    """
    The response that failed.

    """


class ResponseInProgressEvent(BaseModel):
    """
    Emitted when the response is in progress.
    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseInProgressEvent"] = "ResponseInProgressEvent"
    """
    The type of the event. Always `response.in_progress`.

    """
    response: Response1
    """
    The response that is in progress.

    """


class ResponseIncompleteEvent(BaseModel):
    """
    An event that is emitted when a response finishes as incomplete.

    """

    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Literal["ResponseIncompleteEvent"] = "ResponseIncompleteEvent"
    """
    The type of the event. Always `response.incomplete`.

    """
    response: Response1
    """
    The response that was incomplete.

    """


class ResponseStreamEvent(
    RootModel[
        ResponseAudioDeltaEvent
        | ResponseAudioDoneEvent
        | ResponseAudioTranscriptDeltaEvent
        | ResponseAudioTranscriptDoneEvent
        | ResponseCodeInterpreterCallCodeDeltaEvent
        | ResponseCodeInterpreterCallCodeDoneEvent
        | ResponseCodeInterpreterCallCompletedEvent
        | ResponseCodeInterpreterCallInProgressEvent
        | ResponseCodeInterpreterCallInterpretingEvent
        | ResponseCompletedEvent
        | ResponseContentPartAddedEvent
        | ResponseContentPartDoneEvent
        | ResponseCreatedEvent
        | ResponseErrorEvent
        | ResponseFileSearchCallCompletedEvent
        | ResponseFileSearchCallInProgressEvent
        | ResponseFileSearchCallSearchingEvent
        | ResponseFunctionCallArgumentsDeltaEvent
        | ResponseFunctionCallArgumentsDoneEvent
        | ResponseInProgressEvent
        | ResponseFailedEvent
        | ResponseIncompleteEvent
        | ResponseOutputItemAddedEvent
        | ResponseOutputItemDoneEvent
        | ResponseReasoningSummaryPartAddedEvent
        | ResponseReasoningSummaryPartDoneEvent
        | ResponseReasoningSummaryTextDeltaEvent
        | ResponseReasoningSummaryTextDoneEvent
        | ResponseRefusalDeltaEvent
        | ResponseRefusalDoneEvent
        | ResponseTextAnnotationDeltaEvent
        | ResponseTextDeltaEvent
        | ResponseTextDoneEvent
        | ResponseWebSearchCallCompletedEvent
        | ResponseWebSearchCallInProgressEvent
        | ResponseWebSearchCallSearchingEvent
    ]
):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: (
        ResponseAudioDeltaEvent
        | ResponseAudioDoneEvent
        | ResponseAudioTranscriptDeltaEvent
        | ResponseAudioTranscriptDoneEvent
        | ResponseCodeInterpreterCallCodeDeltaEvent
        | ResponseCodeInterpreterCallCodeDoneEvent
        | ResponseCodeInterpreterCallCompletedEvent
        | ResponseCodeInterpreterCallInProgressEvent
        | ResponseCodeInterpreterCallInterpretingEvent
        | ResponseCompletedEvent
        | ResponseContentPartAddedEvent
        | ResponseContentPartDoneEvent
        | ResponseCreatedEvent
        | ResponseErrorEvent
        | ResponseFileSearchCallCompletedEvent
        | ResponseFileSearchCallInProgressEvent
        | ResponseFileSearchCallSearchingEvent
        | ResponseFunctionCallArgumentsDeltaEvent
        | ResponseFunctionCallArgumentsDoneEvent
        | ResponseInProgressEvent
        | ResponseFailedEvent
        | ResponseIncompleteEvent
        | ResponseOutputItemAddedEvent
        | ResponseOutputItemDoneEvent
        | ResponseReasoningSummaryPartAddedEvent
        | ResponseReasoningSummaryPartDoneEvent
        | ResponseReasoningSummaryTextDeltaEvent
        | ResponseReasoningSummaryTextDoneEvent
        | ResponseRefusalDeltaEvent
        | ResponseRefusalDoneEvent
        | ResponseTextAnnotationDeltaEvent
        | ResponseTextDeltaEvent
        | ResponseTextDoneEvent
        | ResponseWebSearchCallCompletedEvent
        | ResponseWebSearchCallInProgressEvent
        | ResponseWebSearchCallSearchingEvent
    ) = Field(..., discriminator="type")


class CreateResponse(CreateModelResponseProperties, ResponseProperties):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    input: str | list[InputItem]
    """
    Text, image, or file inputs to the model, used to generate a response.

    Learn more:
    - [Text inputs and outputs](/docs/guides/text)
    - [Image inputs](/docs/guides/images)
    - [File inputs](/docs/guides/pdf-files)
    - [Conversation state](/docs/guides/conversation-state)
    - [Function calling](/docs/guides/function-calling)

    """
    include: list[Includable] | None = None
    """
    Specify additional output data to include in the model response. Currently
    supported values are:
    - `file_search_call.results`: Include the search results of
      the file search tool call.
    - `message.input_image.image_url`: Include image urls from the input message.
    - `computer_call_output.output.image_url`: Include image urls from the computer call output.

    """
    parallel_tool_calls: bool | None = True
    """
    Whether to allow the model to run tool calls in parallel.

    """
    store: bool | None = True
    """
    Whether to store the generated model response for later retrieval via
    API.

    """
    stream: bool | None = False
    """
    If set to true, the model response data will be streamed to the client
    as it is generated using [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format).
    See the [Streaming section below](/docs/api-reference/responses-streaming)
    for more information.

    """
