"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
const r53 = require("@aws-cdk/aws-route53");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const _1 = require(".");
const devEnv = {
    account: process.env.CDK_DEFAULT_ACCOUNT,
    region: process.env.CDK_DEFAULT_REGION,
};
const app = new cdk.App();
const stack = new cdk.Stack(app, 'lambda-certbot-dev', { env: devEnv });
new _1.CertbotDnsRoute53Job(stack, 'Demo', {
    certbotOptions: {
        domainName: (_a = stack.node.tryGetContext('DOMAIN')) !== null && _a !== void 0 ? _a : '*.example.com',
        email: (_b = stack.node.tryGetContext('EMAIL')) !== null && _b !== void 0 ? _b : 'user@example.com',
        customPrefixDirectory: '/',
    },
    zone: r53.HostedZone.fromHostedZoneAttributes(stack, 'myZone', {
        zoneName: (_c = stack.node.tryGetContext('ZONENAME')) !== null && _c !== void 0 ? _c : 'example.com',
        hostedZoneId: (_d = stack.node.tryGetContext('HOSTZONEID')) !== null && _d !== void 0 ? _d : 'mockId',
    }),
    destinationBucket: s3.Bucket.fromBucketName(stack, 'myBucket', (_e = stack.node.tryGetContext('BUCKETNAME')) !== null && _e !== void 0 ? _e : 'mybucket'),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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