"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BashExecFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
class BashExecFunction extends core_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const dockerDirPath = path.join(__dirname, '../docker.d');
        const scriptPath = props.script;
        // copy the user script to the docker.d directory as main.sh so we can bundle it up into a new docker image
        const mainFile = path.join(dockerDirPath, '/main.sh');
        fs.copyFileSync(scriptPath, mainFile);
        this.handler = new lambda.DockerImageFunction(this, 'BashExecFunction', {
            code: lambda.DockerImageCode.fromImageAsset(dockerDirPath, {}),
            timeout: (_b = props.timeout) !== null && _b !== void 0 ? _b : core_1.Duration.seconds(60),
            logRetention: logs.RetentionDays.ONE_DAY,
            environment: props.environment,
            role: props.role,
        });
        new core_1.CfnOutput(this, 'LogGroup', { value: this.handler.logGroup.logGroupName });
    }
}
exports.BashExecFunction = BashExecFunction;
_a = JSII_RTTI_SYMBOL_1;
BashExecFunction[_a] = { fqn: "cdk-certbot-dns-route53.BashExecFunction", version: "1.0.73" };
//# sourceMappingURL=data:application/json;base64,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