import * as events from '@aws-cdk/aws-events';
import * as r53 from '@aws-cdk/aws-route53';
import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
export interface CertbotOptions {
    /**
     * the domain must host on route53 like example.com.
     *
     * @example - `*.example.com` or `a.example.com` .
     */
    readonly domainName: string;
    /**
     * Email address for important account notifications.
     */
    readonly email: string;
    /**
     * Custom prefix directory on s3 bucket object path.
     * @default - `s3://YOUR_BUCKET_NAME/2021-01-01/your.domain.name/`
     *
     * @example - customPrefixDirectory: '/' -> `s3://YOUR_BUCKET_NAME/your.domain.name/`
     *
     * @example - customPrefixDirectory: 'abc' -> `s3://YOUR_BUCKET_NAME/abc/your.domain.name/`
     */
    readonly customPrefixDirectory?: string;
}
export interface CertbotDnsRoute53JobProps {
    /**
     * run the Job with defined schedule
     * @default - no shedule
     */
    readonly schedule?: events.Schedule;
    /**
     * The S3 bucket to store certificate.
     */
    readonly destinationBucket: s3.IBucket;
    /**
     * The HostZone on route53 to dns-01 challenge.
     */
    readonly zone: r53.IHostedZone;
    /**
     * certbot cmd options.
     */
    readonly certbotOptions: CertbotOptions;
}
export declare class CertbotDnsRoute53Job extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, props: CertbotDnsRoute53JobProps);
}
