"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertbotDnsRoute53Job = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const events = require("@aws-cdk/aws-events");
const target = require("@aws-cdk/aws-events-targets");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const lambda_bash_1 = require("./lambda-bash");
class CertbotDnsRoute53Job extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const certOptions = {
            BUCKET_NAME: props.destinationBucket.bucketName,
            EMAIL: props.certbotOptions.email,
            DOMAIN_NAME: props.certbotOptions.domainName,
            CUSTOM_PREFIX_DIRECTORY: props.certbotOptions.customPrefixDirectory,
        };
        const lambdaFun = new lambda_bash_1.BashExecFunction(this, 'certbotDnsRoute53JobLambda', {
            script: path.join(__dirname, '../docker.d/entrypoint.sh'),
            timeout: cdk.Duration.minutes(5),
            environment: {
                ...certOptions,
            },
        });
        props.destinationBucket.grantReadWrite(lambdaFun.handler.role);
        const route53PolicyJsonList = [{
                Effect: 'Allow',
                Action: [
                    'route53:ListHostedZones',
                    'route53:GetChange',
                ],
                Resource: [
                    '*',
                ],
            },
            {
                Effect: 'Allow',
                Action: [
                    'route53:ChangeResourceRecordSets',
                ],
                Resource: [
                    `arn:aws:route53:::hostedzone/${props.zone.hostedZoneId}`,
                ],
            }];
        route53PolicyJsonList.forEach(e => {
            lambdaFun.handler.role.addToPrincipalPolicy(iam.PolicyStatement.fromJson(e));
        });
        if (props.schedule) {
            new events.Rule(this, 'ScheduleRule', {
                schedule: props.schedule,
                targets: [
                    new target.LambdaFunction(lambdaFun.handler),
                ],
            });
        }
    }
}
exports.CertbotDnsRoute53Job = CertbotDnsRoute53Job;
_a = JSII_RTTI_SYMBOL_1;
CertbotDnsRoute53Job[_a] = { fqn: "cdk-certbot-dns-route53.CertbotDnsRoute53Job", version: "1.0.73" };
//# sourceMappingURL=data:application/json;base64,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