"""Reexports core types and functions that are available without an explicit import."""

from guppylang.std.array import ArrayIter, FrozenarrayIter, array, frozenarray
from guppylang.std.bool import bool
from guppylang.std.iter import Range, SizedIter, range
from guppylang.std.lang import comptime, owned, py
from guppylang.std.list import list
from guppylang.std.mem import mem_swap
from guppylang.std.num import (
    abs,
    bytecast_float_to_nat,
    bytecast_nat_to_float,
    divmod,
    float,
    int,
    len,
    nat,
    pow,
    round,
)
from guppylang.std.option import Option, nothing, some
from guppylang.std.platform import barrier, exit, panic, result
from guppylang.std.quantum import qubit
from guppylang.std.reflection import callable
from guppylang.std.string import str
from guppylang.std.unsupported import (
    __import__,
    aiter,
    all,
    anext,
    any,
    bin,
    breakpoint,
    bytearray,
    bytes,
    chr,
    classmethod,
    compile,
    complex,
    delattr,
    dict,
    dir,
    enumerate,
    eval,
    exec,
    filter,
    format,
    frozenset,
    getattr,
    globals,
    hasattr,
    hash,
    help,
    hex,
    id,
    input,
    isinstance,
    issubclass,
    iter,
    locals,
    map,
    max,
    memoryview,
    min,
    next,
    object,
    oct,
    open,
    ord,
    print,
    property,
    repr,
    reversed,
    set,
    setattr,
    slice,
    sorted,
    staticmethod,
    sum,
    super,
    type,
    vars,
    zip,
)

__all__ = (
    "__import__",
    "abs",
    "aiter",
    "all",
    "anext",
    "any",
    "array",
    "bin",
    "bool",
    "breakpoint",
    "bytearray",
    "bytes",
    "callable",
    "chr",
    "classmethod",
    "compile",
    "complex",
    "comptime",
    "delattr",
    "dict",
    "dir",
    "divmod",
    "enumerate",
    "eval",
    "exec",
    "exit",
    "filter",
    "float",
    "format",
    "frozenarray",
    "frozenset",
    "getattr",
    "globals",
    "hasattr",
    "hash",
    "help",
    "hex",
    "id",
    "input",
    "int",
    "isinstance",
    "issubclass",
    "iter",
    "len",
    "list",
    "locals",
    "map",
    "max",
    "memoryview",
    "min",
    "nat",
    "next",
    "nothing",
    "object",
    "oct",
    "open",
    "Option",
    "ord",
    "owned",
    "panic",
    "pow",
    "print",
    "property",
    "py",
    "qubit",
    "range",
    "repr",
    "result",
    "reversed",
    "round",
    "set",
    "setattr",
    "SizedIter",
    "slice",
    "some",
    "sorted",
    "staticmethod",
    "str",
    "sum",
    "super",
    "type",
    "vars",
    "zip",
    # TODO: Remove the following from prelude
    "ArrayIter",  # Deprecated reexport
    "barrier",  # Deprecated reexport
    "bytecast_float_to_nat",  # Deprecated reexport
    "bytecast_nat_to_float",  # Deprecated reexport
    "FrozenarrayIter",  # Deprecated reexport
    "mem_swap",  # Deprecated reexport
    "Range",  # Deprecated reexport
)
