/**
 * If this is set, multiple stacks can use the same stack name (e.g. deployed to
 * different environments). This means that the name of the synthesized template
 * file will be based on the construct path and not on the defined `stackName`
 * of the stack.
 *
 * This is a "future flag": the feature is disabled by default for backwards
 * compatibility, but new projects created using `cdk init` will have this
 * enabled through the generated `cdk.json`.
 */
export declare const ENABLE_STACK_NAME_DUPLICATES_CONTEXT = "@aws-cdk/core:enableStackNameDuplicates";
/**
 * IF this is set, `cdk diff` will always exit with 0.
 *
 * Use `cdk diff --fail` to exit with 1 if there's a diff.
 */
export declare const ENABLE_DIFF_NO_FAIL_CONTEXT = "aws-cdk:enableDiffNoFail";
/** @deprecated use `ENABLE_DIFF_NO_FAIL_CONTEXT` */
export declare const ENABLE_DIFF_NO_FAIL = "aws-cdk:enableDiffNoFail";
/**
 * Switch to new stack synthesis method which enable CI/CD
 */
export declare const NEW_STYLE_STACK_SYNTHESIS_CONTEXT = "@aws-cdk/core:newStyleStackSynthesis";
/**
 * Name exports based on the construct paths relative to the stack, rather than the global construct path
 *
 * Combined with the stack name this relative construct path is good enough to
 * ensure uniqueness, and makes the export names robust against refactoring
 * the location of the stack in the construct tree (specifically, moving the Stack
 * into a Stage).
 */
export declare const STACK_RELATIVE_EXPORTS_CONTEXT = "@aws-cdk/core:stackRelativeExports";
/**
 * DockerImageAsset properly supports `.dockerignore` files by default
 *
 * If this flag is not set, the default behavior for `DockerImageAsset` is to use
 * glob semantics for `.dockerignore` files. If this flag is set, the default behavior
 * is standard Docker ignore semantics.
 *
 * This is a feature flag as the old behavior was technically incorrect but
 * users may have come to depend on it.
 */
export declare const DOCKER_IGNORE_SUPPORT = "@aws-cdk/aws-ecr-assets:dockerIgnoreSupport";
/**
 * Secret.secretName for an "owned" secret will attempt to parse the secretName from the ARN,
 * rather than the default full resource name, which includes the SecretsManager suffix.
 *
 * If this flag is not set, Secret.secretName will include the SecretsManager suffix, which cannot be directly
 * used by SecretsManager.DescribeSecret, and must be parsed by the user first (e.g., Fn:Join, Fn:Select, Fn:Split).
 */
export declare const SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = "@aws-cdk/aws-secretsmanager:parseOwnedSecretName";
/**
 * KMS Keys start with a default key policy that grants the account access to administer the key,
 * mirroring the behavior of the KMS SDK/CLI/Console experience. Users may override the default key
 * policy by specifying their own.
 *
 * If this flag is not set, the default key policy depends on the setting of the `trustAccountIdentities`
 * flag. If false (the default, for backwards-compatibility reasons), the default key policy somewhat
 * resemebles the default admin key policy, but with the addition of 'GenerateDataKey' permissions. If
 * true, the policy matches what happens when this feature flag is set.
 *
 * Additionally, if this flag is not set and the user supplies a custom key policy, this will be appended
 * to the key's default policy (rather than replacing it).
 */
export declare const KMS_DEFAULT_KEY_POLICIES = "@aws-cdk/aws-kms:defaultKeyPolicies";
/**
 * Change the old 's3:PutObject*' permission to 's3:PutObject' on Bucket,
 * as the former includes 's3:PutObjectAcl',
 * which allows changing the visibility of an object written to the Bucket.
 * Use a feature flag to make sure existing customers who might be relying
 * on the overly-broad permissions are not broken.
 */
export declare const S3_GRANT_WRITE_WITHOUT_ACL = "@aws-cdk/aws-s3:grantWriteWithoutAcl";
/**
 * This map includes context keys and values for feature flags that enable
 * capabilities "from the future", which we could not introduce as the default
 * behavior due to backwards compatibility for existing projects.
 *
 * New projects generated through `cdk init` will include these flags in their
 * generated `cdk.json` file.
 *
 * When we release the next major version of the CDK, we will flip the logic of
 * these features and clean up the `cdk.json` generated by `cdk init`.
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
export declare const FUTURE_FLAGS: {
    "@aws-cdk/core:enableStackNameDuplicates": string;
    "aws-cdk:enableDiffNoFail": string;
    "@aws-cdk/core:stackRelativeExports": string;
    "@aws-cdk/aws-ecr-assets:dockerIgnoreSupport": boolean;
    "@aws-cdk/aws-secretsmanager:parseOwnedSecretName": boolean;
    "@aws-cdk/aws-kms:defaultKeyPolicies": boolean;
    "@aws-cdk/aws-s3:grantWriteWithoutAcl": boolean;
};
export declare function futureFlagDefault(flag: string): boolean;
