/* Code generated by cmd/cgo; DO NOT EDIT. */

/* package github.com/emendir/py_ipfs_node/libkubo */


#line 1 "cgo-builtin-export-prolog"

#include <stddef.h>

#ifndef GO_CGO_EXPORT_PROLOGUE_H
#define GO_CGO_EXPORT_PROLOGUE_H

#ifndef GO_CGO_GOSTRING_TYPEDEF
typedef struct { const char *p; ptrdiff_t n; } _GoString_;
#endif

#endif

/* Start of preamble from import "C" comments.  */


#line 3 "files.go"
 #include <stdlib.h>
 #include <stdbool.h>

#line 1 "cgo-generated-wrapper"

#line 3 "p2p.go"

#include <stdlib.h>
#include <stdbool.h>

#line 1 "cgo-generated-wrapper"

#line 3 "peers.go"
 #include <stdlib.h>

#line 1 "cgo-generated-wrapper"

#line 3 "pubsub.go"
 #include <stdlib.h>

#line 1 "cgo-generated-wrapper"

#line 3 "repo.go"
 #include <stdlib.h>

#line 1 "cgo-generated-wrapper"


/* End of preamble from import "C" comments.  */


/* Start of boilerplate cgo prologue.  */
#line 1 "cgo-gcc-export-header-prolog"

#ifndef GO_CGO_PROLOGUE_H
#define GO_CGO_PROLOGUE_H

typedef signed char GoInt8;
typedef unsigned char GoUint8;
typedef short GoInt16;
typedef unsigned short GoUint16;
typedef int GoInt32;
typedef unsigned int GoUint32;
typedef long long GoInt64;
typedef unsigned long long GoUint64;
typedef GoInt64 GoInt;
typedef GoUint64 GoUint;
typedef size_t GoUintptr;
typedef float GoFloat32;
typedef double GoFloat64;
#ifdef _MSC_VER
#include <complex.h>
typedef _Fcomplex GoComplex64;
typedef _Dcomplex GoComplex128;
#else
typedef float _Complex GoComplex64;
typedef double _Complex GoComplex128;
#endif

/*
  static assertion to make sure the file is being used on architecture
  at least with matching size of GoInt.
*/
typedef char _check_for_64_bit_pointer_matching_GoInt[sizeof(void*)==64/8 ? 1:-1];

#ifndef GO_CGO_GOSTRING_TYPEDEF
typedef _GoString_ GoString;
#endif
typedef void *GoMap;
typedef void *GoChan;
typedef struct { void *t; void *v; } GoInterface;
typedef struct { void *data; GoInt len; GoInt cap; } GoSlice;

#endif

/* End of boilerplate cgo prologue.  */

#ifdef __cplusplus
extern "C" {
#endif


// AddFile adds a file to IPFS
//
extern char* AddFile(char* repoPath, char* filePath, _Bool onlyHash);

// FreeString is a no-op for now - we'll let Go's garbage collection handle the memory
//
extern void FreeString(char* str);

// Download retrieves a file or directory from IPFS
//
extern int Download(char* repoPath, char* cidStr, char* destPath);

// PinCID pins a CID to the IPFS node
//
extern int PinCID(char* repoPath, char* cidStr);

// UnpinCID unpins a CID from the IPFS node
//
extern int UnpinCID(char* repoPath, char* cidStr);

// ListPins returns a list of pinned CIDs
//
extern char* ListPins(char* repoPath);

// RemoveCID removes a pinned CID from IPFS (alias for UnpinCID for clarity)
//
extern int RemoveCID(char* repoPath, char* cidStr);

// P2PForward creates a libp2p stream mounting forwarding connection
//
extern int P2PForward(char* repoPath, char* proto, char* listenAddr, char* targetPeerID);

// P2PListen creates a libp2p service that listens for connections on the given protocol
//
extern int P2PListen(char* repoPath, char* proto, char* targetAddr);

// P2PClose closes p2p listener or stream
//
extern int P2PClose(char* repoPath, char* proto, char* listenAddr, char* targetAddr, _Bool _all, _Bool listeners, _Bool forwarders);

// P2PListListeners lists active p2p listeners
//
extern char* P2PListListeners(char* repoPath);

// P2PEnable ensures p2p functionality is enabled in the config
//
extern int P2PEnable(char* repoPath);

// P2PListForwards lists active p2p forwarding connections
//
extern char* P2PListForwards(char* repoPath);

// P2PCloseAllListeners closes all p2p listeners
//
extern int P2PCloseAllListeners(char* repoPath);

// P2PCloseAllForwards closes all p2p forwards
//
extern int P2PCloseAllForwards(char* repoPath);

// ConnectToPeer connects to a peer
//
extern int ConnectToPeer(char* repoPath, char* peerAddr);

// ListPeers connects to a peer
//
extern char* ListPeers(char* repoPath);

// ListPeers connects to a peer
//
extern char* ListPeersIDs(char* repoPath);

// FindPeer connects to a peer
//
extern char* FindPeer(char* repoPath, char* peerAddr, int timeOut);

// PubSubListTopics lists the topics the node is subscribed to
//
extern char* PubSubListTopics(char* repoPath);

// PubSubPublish publishes a message to a topic
//
extern int PubSubPublish(char* repoPath, char* topic, void* data, int dataLen);

// PubSubSubscribe subscribes to a topic
//
extern long long PubSubSubscribe(char* repoPath, char* topic);

// PubSubNextMessage gets the next message from a subscription
//
extern char* PubSubNextMessage(long long subID);

// PubSubUnsubscribe unsubscribes from a topic
//
extern int PubSubUnsubscribe(long long subID);

// PubSubPeers lists peers participating in a topic
//
extern char* PubSubPeers(char* repoPath, char* topic);

// PubSubCloseRepoSubscriptions closes all active pubsub subscriptions for a specific repository
//
extern int PubSubCloseRepoSubscriptions(char* repoPath);

// PubSubCloseAllSubscriptions closes all active pubsub subscriptions across all repositories
//
extern int PubSubCloseAllSubscriptions();

// CreateRepo initializes a new IPFS repository
//
extern int CreateRepo(char* repoPath);
extern int RunNode(char* repoPath);

// PubSubEnable enables pubsub on an IPFS node configuration
//
extern int PubSubEnable(char* repoPath);
extern char* TestGetString();

// GetNodeID gets the ID of the IPFS node
//
extern char* GetNodeID(char* repoPath);

// GetNodeMultiAddrs gets the ID of the IPFS node
//
extern char* GetNodeMultiAddrs(char* repoPath);

// CleanupNode explicitly releases a node by path
//
extern int CleanupNode(char* repoPath);

#ifdef __cplusplus
}
#endif
