import pytest
import scipy.integrate as integrate
import numpy as np
from classy_sz import Class as Class_sz
import os 
import time
import matplotlib
import matplotlib.pyplot as plt


common_settings = {
                   # LambdaCDM parameters
                   'H0':67.556,
                   'omega_b':0.022032,
                   'omega_cdm':0.12038,
                   'ln10^{10}A_s': 3.047,
                   'n_s': 0.9665,
                   'tau_reio':0.0925,
}



## new hod from https://arxiv.org/abs/2303.08121
HOD_blue = {
'sigma_log10M_HOD': 0.02,
'alpha_s_HOD':    1.06,
'M1_prime_HOD': 10**12.61, # Msun/h
'M_min_HOD': 10**11.69, # Msun/h
'M0_HOD' :0,
'x_out_truncated_nfw_profile_satellite_galaxies':  1.80,
'f_cen_HOD' : 1., 
'full_path_to_dndz_gal': os.environ['PATH_TO_CLASS_SZ_DATA'] + '/class_sz/class-sz/class_sz_auxiliary_files/includes/normalised_dndz_cosmos_0.txt',
}

nl_tab_terms = 30


unWISE_common = {
'galaxy_sample': 'custom',
'M0_equal_M_min_HOD': 'no',
'x_out_truncated_nfw_profile': 1.0,
    
    
'z_min': 0.005,
'z_max': 3.,
'M_min': 1e10,
'M_max': 3.5e15,

'nfw_profile_epsabs' : 1e-33,
'nfw_profile_epsrel' : 0.001,
    
    
    
'x_min_gas_density_fftw' : 1e-5,
'x_max_gas_density_fftw' : 1e4,
    
    
'redshift_epsabs': 1.0e-40,
'redshift_epsrel': 0.001,
'mass_epsabs': 1.0e-40,
'mass_epsrel': 0.001,



'hm_consistency': 1,


'delta_for_galaxies': "200c",
'delta_for_matter_density': "200c",
'mass_function': 'T08M200c',
'concentration_parameter': 'B13' ,
    

}

other_params = {

    
'non_linear':'hmcode',

'k_min_for_pk_class_sz' : 0.001,
'k_max_for_pk_class_sz' : 50.0,
'k_per_decade_class_sz' : 50,
'P_k_max_h/Mpc' : 50.0,




'ndim_masses' : 80,
'ndim_redshifts' : 30,


'k_per_decade_for_pk' : 50,
'z_max_pk' : 3.0,
    

    
# fast:
'n_z_psi_b1g' : nl_tab_terms,
'n_l_psi_b1g' : nl_tab_terms,

'n_z_psi_b2g' : nl_tab_terms,
'n_l_psi_b2g' : nl_tab_terms,

'n_z_psi_b2kg' : nl_tab_terms,
'n_l_psi_b2kg' : nl_tab_terms,

'n_z_psi_b1kg' : nl_tab_terms,
'n_l_psi_b1kg' : nl_tab_terms,

'n_z_psi_b1kgg' : nl_tab_terms,
'n_l_psi_b1kgg' : nl_tab_terms,

# 'N_samp_fftw' : 2048, # fast: 800 ;  slow: 2000
# 'l_min_samp_fftw' : 1e-9,
# 'l_max_samp_fftw' : 1e9,
    
}



M = Class_sz()
M.set(common_settings)
M.set(HOD_blue)
M.set(unWISE_common)
M.set(other_params)
M.set({
'output':'gal_gal_1h,gal_gal_2h,gal_lens_1h,gal_lens_2h,gal_gal_lens fft (1h),gal_gal_lens fft (2h),gal_gal_lens fft (3h)',    
# 'lensing':'yes',
    
# for effective approach calculation of kSZ2g, i.e.,kSZ_kSZ_gal_hf also set:
# 'N_kSZ2_gal_multipole_grid' :  70,
# 'N_kSZ2_gal_theta_grid' :  70,
# 'ell_min_kSZ2_gal_multipole_grid' : 2.,
# 'ell_max_kSZ2_gal_multipole_grid' : 2e5,

'projected_field_filter_file' : os.environ['PATH_TO_CLASS_SZ_DATA'] + '/class_sz/class-sz/class_sz_auxiliary_files/includes/wl_data_blue_50_300.txt',           

'dlogell' : 0.2,
'ell_max' : 10000.0,
'ell_min' : 10.0,

# 'gas profile' : 'B16', # set NFW profile
# 'gas profile mode' : 'agn',
# 'normalize_gas_density_profile' : 0,
# 'use_xout_in_density_profile_from_enclosed_mass' : 1,
    
# 'use_fft_for_profiles_transform' : 1,    

# 'use_bg_at_z_in_ksz2g_eff' : 1,
'non_linear' : 'halofit',
    
'N_samp_fftw' : 800, # fast: 800 ;  slow: 2000
'l_min_samp_fftw' : 1e-8,
'l_max_samp_fftw' : 1e8,
      })

M.compute_class_szfast()


cl_ggk = M.cl_gal_gal_kcmb()

print(cl_ggk)
# this...
# should be: 
#{'ell': [10.000000000000002, 11.051709180756479, 12.214027581601703, 13.498588075760031, 14.918246976412705, 16.487212707001284, 18.221188003905095, 20.137527074704774, 22.255409284924678, 24.5960311115695, 27.182818284590457, 30.041660239464342, 33.20116922736549, 36.69296667619246, 40.551999668446754, 44.81689070338066, 49.53032424395116, 54.73947391727202, 60.496474644129464, 66.85894442279273, 73.89056098930652, 81.66169912567656, 90.25013499434124, 99.7418245481472, 110.23176380641608, 121.82493960703476, 134.637380350017, 148.7973172487284, 164.4464677109705, 181.7414536944307, 200.85536923187672, 221.9795128144165, 245.32530197109358, 271.1263892065789, 299.6410004739703, 331.1545195869232, 365.9823444367801, 404.4730436006741, 447.01184493300826, 494.024491055302, 545.9815003314425, 603.4028759736201, 666.8633104092517, 736.997936995958, 814.5086866496816, 900.1713130052183, 994.8431564193388, 1099.4717245212355, 1215.1041751873488, 1342.8977968493557, 1484.1315910257663, 1640.2190729990186, 1812.7224187515126, 2003.3680997479187, 2214.0641620418724, 2446.9193226422044, 2704.264074261528, 2988.6740096706035, 3302.995599096487, 3650.3746786532865, 4034.2879349273558, 4458.5777008251725, 4927.490410932564, 5445.71910125929, 6018.450378720819, 6651.416330443626, 7350.951892419735, 8124.058251675434, 8978.472916504177, 9922.747156050273], '1h': [1.376292912833712e-10, 1.3731081766270114e-10, 1.3696539918021836e-10, 1.365763966054539e-10, 1.3612573762411983e-10, 1.3560432109119026e-10, 1.350171476241603e-10, 1.3438121072472175e-10, 1.3370388633422106e-10, 1.3296007447538962e-10, 1.3211030607741995e-10, 1.3115010356995052e-10, 1.3011279595221705e-10, 1.2897212021849072e-10, 1.2767486004635153e-10, 1.262578990900222e-10, 1.2469097015506717e-10, 1.2293609392862201e-10, 1.2102239814556098e-10, 1.1888263034504706e-10, 1.1654693829446945e-10, 1.1397912277207347e-10, 1.1116785303283823e-10, 1.0818790552332839e-10, 1.0502814222643741e-10, 1.0151115596952923e-10, 9.760079611560167e-11, 9.324886582880394e-11, 8.841582183676512e-11, 8.305095188035358e-11, 7.714039427438338e-11, 7.064693643535887e-11, 6.359848595265926e-11, 5.717916129240823e-11, 5.160703837198636e-11, 4.558793091104537e-11, 3.732506248971375e-11, 2.797582897780241e-11, 1.8889465437945376e-11, 1.057442319075657e-11, 3.742635328132015e-12, 4.457391595576536e-15, -2.6193796069987946e-16, 4.833142389794487e-17, 3.125085611775118e-17, -1.5831252319953924e-18, -5.434884386440855e-18, -1.082010899316995e-19, 9.980417085640246e-19, -7.928024908179998e-20, 5.625525202072359e-20, -2.4800099617443408e-20, -2.0508569595703538e-19, 4.2567917687421677e-19, -5.01366463780449e-20, 8.43492850422719e-20, -7.863367358847302e-20, 1.3013670755914574e-19, -3.8661532641332795e-20, 5.8242808462886034e-21, -1.0675905349691451e-19, 4.5038536372983437e-20, 4.4566555142620856e-20, -3.513320659936649e-21, 3.206359492358113e-20, -2.525188539750025e-22, 1.0174199797099429e-20, 1.436990589567369e-20, -1.6338971506953976e-20, -1.7588208217636262e-20], '2h': [3.1669124352476603e-09, 3.1847690635239514e-09, 3.1846170950277264e-09, 3.165025738676005e-09, 3.1249495417561885e-09, 3.064177941532682e-09, 2.983470531652776e-09, 2.884893993643404e-09, 2.769668520720777e-09, 2.6408549331841378e-09, 2.5014498583906565e-09, 2.35408077492473e-09, 2.2032587467405317e-09, 2.051876494019463e-09, 1.902053126121047e-09, 1.7564015293655327e-09, 1.6161121626111307e-09, 1.4807135531976795e-09, 1.3535307011748769e-09, 1.231969643313134e-09, 1.1177566988881703e-09, 1.0113367524596519e-09, 9.133076658097703e-10, 8.250961249127286e-10, 7.463823880538238e-10, 6.748473963340476e-10, 6.07934231280496e-10, 5.468441381259638e-10, 4.902885837234938e-10, 4.372803069459752e-10, 3.8655908084775114e-10, 3.3610996477005464e-10, 2.833953070347069e-10, 2.35477057675265e-10, 1.960555912278877e-10, 1.5758789043619618e-10, 1.106351854751417e-10, 6.956406963443378e-11, 3.982327023396422e-11, 1.9145773199339457e-11, 5.884032458128438e-12, 6.078759797672796e-15, -3.4208599147817204e-16, 5.872634319023992e-17, 3.8488517188424483e-17, -2.027188632492755e-18, -1.196170314207294e-17, -1.4384735434778062e-19, 5.469168495242903e-19, -1.3799510569066602e-18, 1.7202207012272358e-18, 1.5167470828697764e-18, -7.907853663486288e-19, 2.267107543401649e-19, -3.0228500795049164e-20, -5.206004719096738e-19, -2.9453094218983395e-19, 8.401941594423498e-19, 2.527188314834261e-19, -3.332478264500511e-19, -5.3583583182543185e-19, 1.9733089506862482e-19, 2.99975898133342e-19, -1.860709728808784e-20, -1.6475765936552657e-20, -5.103613922393021e-21, 2.579777625514216e-20, 1.8963305746188005e-20, -1.6601092984215972e-20, -2.3451305071130415e-21], '3h': [1.2743307737517084e-08, 1.3190804601509346e-08, 1.35779463143117e-08, 1.3888113798136686e-08, 1.4110549423652785e-08, 1.4228402872702364e-08, 1.424152647451249e-08, 1.4139160369923359e-08, 1.391755549008421e-08, 1.3578877274670037e-08, 1.3125980258706543e-08, 1.257288476941789e-08, 1.1932770979286959e-08, 1.1226111246209902e-08, 1.0471537940901961e-08, 9.691807608428936e-09, 8.906194118727756e-09, 8.130367552675952e-09, 7.379319125777738e-09, 6.660653190715253e-09, 5.984230435206847e-09, 5.354207306052701e-09, 4.778288376147891e-09, 4.273061198656414e-09, 3.8373201196939836e-09, 3.424839923895788e-09, 3.028089393370558e-09, 2.647621755399306e-09, 2.2884580203637176e-09, 1.949285074795627e-09, 1.6364222883622135e-09, 1.3439592876484173e-09, 1.0662003333650205e-09, 8.597446424743658e-10, 7.249832390946083e-10, 5.983445779722997e-10, 4.21154008949964e-10, 2.553735786141252e-10, 1.3965608012854573e-10, 6.371415761059796e-11, 1.8753584514757792e-11, 1.9078044448189015e-14, -8.64198073950923e-16, 2.94253148104963e-16, -1.3585112240480015e-15, 1.6342259034520048e-16, 8.971889684805685e-15, -3.826714286847569e-17, 4.85267018655861e-15, 1.1370648679803239e-14, -2.297046411024743e-14, -2.9766936112479434e-14, 1.2960185640555032e-14, -1.8859519959800373e-14, -4.600848583391938e-16, 2.22180765975425e-13, 7.219144725533863e-14, -4.143341717157534e-13, -2.8905170164069536e-13, 4.465788081035635e-13, 5.710887041308445e-13, -2.6666316607701256e-13, -3.8845864828169345e-13, 6.594595556178716e-14, -1.337712138965473e-12, -7.086705945975274e-13, 4.161143241499227e-12, 4.163545801313431e-12, -7.297801194431154e-12, -1.4797605581671662e-11]}


l_d,cl_d,dcl_d =np.loadtxt(os.environ['PATH_TO_CLASS_SZ_DATA'] + '/class_sz/class-sz/class_sz_auxiliary_files/includes/ggk_blue_lmax=300.dat',unpack=True)


label_size = 17
title_size = 18
legend_size = 13
handle_length = 1.5
fig, (ax1) = plt.subplots(1,1,figsize=(7,4))
ax = ax1
ax.tick_params(axis = 'x',which='both',length=5,direction='in', pad=10)
ax.tick_params(axis = 'y',which='both',length=5,direction='in', pad=5)
ax.xaxis.set_ticks_position('both')
ax.yaxis.set_ticks_position('both')
plt.setp(ax.get_yticklabels(), rotation='horizontal', fontsize=label_size)
plt.setp(ax.get_xticklabels(), fontsize=label_size)
ax.grid( visible=True, which="both", alpha=0.2, linestyle='--')

ax.set_xscale('log')
ax.set_yscale('log')
ax.set_ylim(1e-11,3e-8)
ax.set_xlim(30,500)

fac = 1.#(2.726e6)**2*np.asarray(cl_ggk['ell'])*(np.asarray(cl_ggk['ell'])+1.)/2./np.pi

ax.plot(cl_ggk['ell'],fac*np.asarray(cl_ggk['1h']),label = r'$1\mathrm{h}$',c='k',ls=':',lw=0.3)
ax.plot(cl_ggk['ell'],fac*np.asarray(cl_ggk['2h']),label = r'$2\mathrm{h}$',c='b',ls='-.',lw=0.3)
ax.plot(cl_ggk['ell'],fac*np.asarray(cl_ggk['3h']),label = r'$3\mathrm{h}$',c='orange',ls='--',lw=0.3)
ax.plot(cl_ggk['ell'],fac*(np.asarray(cl_ggk['1h'])+np.asarray(cl_ggk['2h'])+np.asarray(cl_ggk['3h'])),
        label = r'$\mathrm{Total}$',c='k',ls='-',lw=1.)

plt.errorbar(l_d,cl_d,yerr=dcl_d,marker='o')
ax.legend(loc=3,ncol = 1,frameon=False,fontsize=14)
ax.set_xlabel(r"$\ell$",size=title_size)
ax.set_ylabel(r"$C_\ell^{\mathrm{g^2k}}$",size=title_size)
fig.tight_layout()
# fig.suptitle('Projected-field kSZ$^2$-Galaxy',fontsize=16)
fig.tight_layout()
plt.show()
# plt.savefig('class_sz_blue_g2kappa_lmax300_newhod_test.pdf')