"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoIngressCommonWebPortsAspect = exports.NoPublicIngressCommonWebPortsAspect = exports.NoIngressCommonRelationalDBPortsAspect = exports.NoPublicIngressCommonRelationalDBPortsAspect = exports.NoIngressCommonManagementPortsAspect = exports.NoPublicIngressCommonManagementPortsAspect = exports.AWSRestrictedCommonPortsAspect = exports.CISAwsFoundationBenchmark4Dot2Aspect = exports.NoPublicIngressRDPAspect = exports.CISAwsFoundationBenchmark4Dot1Aspect = exports.NoPublicIngressSSHAspect = exports.NoPublicIngressAspect = exports.NoPublicIngressAspectBase = exports.SecurityGroupAspectBase = exports.checkRules = exports.annotate = exports.anyInRange = exports.AnnotationType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The supported annotation types. Only error will stop deployment of restricted resources.
 */
var AnnotationType;
(function (AnnotationType) {
    AnnotationType["WARNING"] = "warning";
    AnnotationType["ERROR"] = "error";
    AnnotationType["INFO"] = "info";
})(AnnotationType = exports.AnnotationType || (exports.AnnotationType = {}));
;
/**
 * @function anyInRange
 * Function to check if a number is in a range.
 *
 * Useful for determining if a port number in a security group is in part of a range since rules take a to and from port.
 *
 * @param num The number to check.
 * @param from The starting number of the range.
 * @param to The ending number of the range.
 */
function anyInRange(num, from, to) {
    for (const n of num) {
        if (n >= from && n <= to) {
            return true;
        }
    }
    return false;
}
exports.anyInRange = anyInRange;
/**
 * @function annotate
 * Function to annotate a construct node based on a defined annotation type.
 *
 * @param {IConstruct} node The construct node to annotate.
 * @param {string} annotationText The annotation text to use for the annotation.
 * @param {AnnotationType} annotationType The annotation type to use for the annotation.
 */
function annotate(node, annotationText, annotationType) {
    annotationText = annotationText || 'A security group rule was blocked by an aspect applied to this stack.';
    annotationType = annotationType || AnnotationType.ERROR;
    switch (annotationType) {
        case 'error':
            aws_cdk_lib_1.Annotations.of(node).addError(annotationText);
            break;
        case 'warning':
            aws_cdk_lib_1.Annotations.of(node).addWarning(annotationText);
            break;
        case 'info':
            aws_cdk_lib_1.Annotations.of(node).addInfo(annotationText);
            break;
    }
}
exports.annotate = annotate;
/**
 * @function checkRules
 *
 * @param {IRuleCheckArgs} args The arguments for the checkRules function.
 *
 * Function to check a node for security group rules and determine if they breaks the rules of a given aspect.
 */
function checkRules(args) {
    if (args.node instanceof aws_cdk_lib_1.aws_ec2.CfnSecurityGroup) {
        checkInlineRules(aws_cdk_lib_1.Stack.of(args.node).resolve(args.node.securityGroupIngress));
    }
    else if (args.node instanceof aws_cdk_lib_1.aws_ec2.CfnSecurityGroupIngress) {
        checkRule(args.node);
    }
    function checkInlineRules(rules) {
        if (rules) {
            for (const rule of rules.values()) {
                checkRule(rule);
            }
        }
    }
    function checkRule(rule) {
        if (!aws_cdk_lib_1.Tokenization.isResolvable(rule)) {
            let matchingSource = false;
            let matchingPort = false;
            let shouldAnnotate = false;
            if (args.ports === undefined) {
                matchingPort = true;
            }
            else if (args.ports && rule.fromPort && rule.toPort && anyInRange(args.ports, rule.fromPort, rule.toPort)) {
                matchingPort = true;
            }
            if (rule.cidrIp) {
                if (args.anySource) {
                    matchingSource = true;
                }
                if (args.anySource == false && args.restrictedCidrs !== undefined && args.restrictedCidrs.includes(rule.cidrIp)) {
                    matchingSource = true;
                }
                if (matchingSource && matchingPort) {
                    shouldAnnotate = true;
                }
            }
            if (rule.sourceSecurityGroupId) {
                if (args.anySource) {
                    matchingSource = true;
                }
                if (args.anySource == false && args.restrictedSGs !== undefined && args.restrictedSGs.includes(rule.sourceSecurityGroupId)) {
                    matchingSource = true;
                }
                if (matchingSource && matchingPort) {
                    shouldAnnotate = true;
                }
            }
            if (shouldAnnotate) {
                annotate(args.node, args.annotationText, args.annotationType);
            }
        }
    }
}
exports.checkRules = checkRules;
/**
 * The base class for all security group aspects in the library.
 *
 * By default this will not restrict anything.
 */
class SecurityGroupAspectBase {
    constructor(props) {
        this.annotationType = props?.annotationType ?? AnnotationType.ERROR;
        this.annotationText = props?.annotationText ?? 'A security group rule was blocked by an aspect applied to this stack.';
        this.ports = props?.ports;
        this.restrictedCidrs = props?.restrictedCidrs;
        this.restrictedSGs = props?.restrictedSGs;
        this.anySource = props?.anySource ?? false;
    }
    visit(node) {
        checkRules({
            node,
            annotationText: this.annotationText,
            annotationType: this.annotationType,
            ports: this.ports,
            restrictedCidrs: this.restrictedCidrs,
            restrictedSGs: this.restrictedSGs,
            anySource: this.anySource,
        });
    }
}
exports.SecurityGroupAspectBase = SecurityGroupAspectBase;
_a = JSII_RTTI_SYMBOL_1;
SecurityGroupAspectBase[_a] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.SecurityGroupAspectBase", version: "2.0.219" };
/**
 * The base aspect to determine if a security group allows inbound traffic from the public internet to any port.
 *
 * This inherits everything from the base SecurityGroupAspectBase class and sets a default set of CIDRS that match allowing all IPs on AWS.
 */
class NoPublicIngressAspectBase extends SecurityGroupAspectBase {
    constructor(props) {
        super(props);
        this.restrictedCidrs = ['0.0.0.0/0', '::/0'];
    }
}
exports.NoPublicIngressAspectBase = NoPublicIngressAspectBase;
_b = JSII_RTTI_SYMBOL_1;
NoPublicIngressAspectBase[_b] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressAspectBase", version: "2.0.219" };
/**
 * The same as the base NoPublicIngressAspectBase but with a more descriptive annotation.
 *
 * Blocks the ANY port from the public internet.
 */
class NoPublicIngressAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        super(props);
        this.annotationText = props?.annotationText ?? 'NoPublicIngressAspect: A security group rule allows public access to a restricted port: All ports restricted).';
    }
}
exports.NoPublicIngressAspect = NoPublicIngressAspect;
_c = JSII_RTTI_SYMBOL_1;
NoPublicIngressAspect[_c] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressAspect", version: "2.0.219" };
/**
 * Aspect to determine if a security group allows inbound traffic from the public internet to the SSH port.
 */
class NoPublicIngressSSHAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        super(props);
        this.annotationText = props?.annotationText ?? 'NoPublicIngressSSHAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 22 (SSH)';
        this.ports = [22];
    }
}
exports.NoPublicIngressSSHAspect = NoPublicIngressSSHAspect;
_d = JSII_RTTI_SYMBOL_1;
NoPublicIngressSSHAspect[_d] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressSSHAspect", version: "2.0.219" };
/**
 * CIS AWS Foundations Benchmark 4.1
 *
 * CIS recommends that no security group allow unrestricted ingress access to port 22. Removing unfettered connectivity to remote console services, such as SSH, reduces a server's exposure to risk.
 *
 * This aspect uses the NoPublicIngressSSHAspect with an alternate annotation text.
 */
class CISAwsFoundationBenchmark4Dot1Aspect extends NoPublicIngressSSHAspect {
    constructor(props) {
        super(props);
        this.annotationText = 'CIS AWS Foundations Benchmark 4.1: Ensure no security groups allow ingress from 0.0.0.0/0 to port 22';
    }
}
exports.CISAwsFoundationBenchmark4Dot1Aspect = CISAwsFoundationBenchmark4Dot1Aspect;
_e = JSII_RTTI_SYMBOL_1;
CISAwsFoundationBenchmark4Dot1Aspect[_e] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.CISAwsFoundationBenchmark4Dot1Aspect", version: "2.0.219" };
/**
 * Aspect to determine if a security group allows inbound traffic from the public internet to the RDP port.
 */
class NoPublicIngressRDPAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        super(props);
        this.annotationText = props?.annotationText ?? 'NoPublicIngressRDPAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 3389 (RDP)';
        this.ports = [3389];
    }
}
exports.NoPublicIngressRDPAspect = NoPublicIngressRDPAspect;
_f = JSII_RTTI_SYMBOL_1;
NoPublicIngressRDPAspect[_f] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressRDPAspect", version: "2.0.219" };
/**
 * CIS AWS Foundations Benchmark 4.2
 *
 * CIS recommends that no security group allow unrestricted ingress access to port 3389. Removing unfettered connectivity to remote console services, such as RDP, reduces a server's exposure to risk.
 *
 * This aspect uses the NoPublicIngressRDPAspect with an alternate annotation text.
 */
class CISAwsFoundationBenchmark4Dot2Aspect extends NoPublicIngressRDPAspect {
    constructor(props) {
        super(props);
        this.annotationText = 'CIS AWS Foundations Benchmark 4.2: Ensure no security groups allow ingress from 0.0.0.0/0 to port 3389';
    }
}
exports.CISAwsFoundationBenchmark4Dot2Aspect = CISAwsFoundationBenchmark4Dot2Aspect;
_g = JSII_RTTI_SYMBOL_1;
CISAwsFoundationBenchmark4Dot2Aspect[_g] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.CISAwsFoundationBenchmark4Dot2Aspect", version: "2.0.219" };
/**
 * Restricted common ports based on AWS Config rule https://docs.aws.amazon.com/config/latest/developerguide/restricted-common-ports.html
 */
class AWSRestrictedCommonPortsAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        super(props);
        this.ports = [
            20,
            21,
            3389,
            3306,
            4333,
        ];
        this.annotationText = props?.annotationText ?? 'AWSRestrictedCommonPortsAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 20, 21, 3389, 3306, 4333';
    }
}
exports.AWSRestrictedCommonPortsAspect = AWSRestrictedCommonPortsAspect;
_h = JSII_RTTI_SYMBOL_1;
AWSRestrictedCommonPortsAspect[_h] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.AWSRestrictedCommonPortsAspect", version: "2.0.219" };
/**
 * Aspect to restrict public access to common management ports.
 *
 * 22 - SSH
 * 3389 - RDP
 * 5985 - WinRM
 * 5986 - WinRM HTTPS
 */
class NoPublicIngressCommonManagementPortsAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        super(props);
        this.ports = [
            22,
            3389,
            5985,
            5986,
        ];
        this.annotationText = props?.annotationText ?? 'NoPublicIngressCommonManagementPortsAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 22, 3389, 5985, 5986';
    }
}
exports.NoPublicIngressCommonManagementPortsAspect = NoPublicIngressCommonManagementPortsAspect;
_j = JSII_RTTI_SYMBOL_1;
NoPublicIngressCommonManagementPortsAspect[_j] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressCommonManagementPortsAspect", version: "2.0.219" };
/**
 * Aspect to restrict any access to common management ports.
 *
 * 22 - SSH
 * 3389 - RDP
 * 5985 - WinRM
 * 5986 - WinRM HTTPS
 */
class NoIngressCommonManagementPortsAspect extends SecurityGroupAspectBase {
    constructor(props) {
        super(props);
        this.ports = [
            22,
            3389,
            5985,
            5986,
        ];
        this.annotationText = props?.annotationText ?? 'NoIngressCommonManagementPortsAspect: A security group rule allows access to a restricted port: 22, 3389, 5985, 5986';
        this.anySource = true;
    }
}
exports.NoIngressCommonManagementPortsAspect = NoIngressCommonManagementPortsAspect;
_k = JSII_RTTI_SYMBOL_1;
NoIngressCommonManagementPortsAspect[_k] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoIngressCommonManagementPortsAspect", version: "2.0.219" };
/**
 * Aspect to restrict public access to common relational DB ports.
 *
 * 3306 - MySQL
 * 5432 - PostgreSQL
 * 1521 - Oracle
 * 1433 - SQL Server
 */
class NoPublicIngressCommonRelationalDBPortsAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        super(props);
        this.ports = [
            3306,
            5432,
            1521,
            1433,
        ];
        this.annotationText = props?.annotationText ?? 'NoPublicIngressCommonRelationalDBPortsAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 3306, 5432, 1521, 1433';
    }
}
exports.NoPublicIngressCommonRelationalDBPortsAspect = NoPublicIngressCommonRelationalDBPortsAspect;
_l = JSII_RTTI_SYMBOL_1;
NoPublicIngressCommonRelationalDBPortsAspect[_l] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressCommonRelationalDBPortsAspect", version: "2.0.219" };
/**
 * Aspect to restrict any access to common relational DB ports.
 *
 * 3306 - MySQL
 * 5432 - PostgreSQL
 * 1521 - Oracle
 * 1433 - SQL Server
 */
class NoIngressCommonRelationalDBPortsAspect extends SecurityGroupAspectBase {
    constructor(props) {
        super(props);
        this.ports = [
            3306,
            5432,
            1521,
            1433,
        ];
        this.annotationText = props?.annotationText ?? 'NoIngressCommonRelationalDBPortsAspect: A security group rule allows access to a restricted port: 3306, 5432, 1521, 1433';
        this.anySource = true;
    }
}
exports.NoIngressCommonRelationalDBPortsAspect = NoIngressCommonRelationalDBPortsAspect;
_m = JSII_RTTI_SYMBOL_1;
NoIngressCommonRelationalDBPortsAspect[_m] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoIngressCommonRelationalDBPortsAspect", version: "2.0.219" };
/**
 * Aspect to restrict public access to common web ports.
 *
 * 80 - HTTP
 * 443 - HTTPS
 * 8080 - HTTP
 * 8443 - HTTPS
 */
class NoPublicIngressCommonWebPortsAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        super(props);
        this.ports = [
            80,
            443,
            8080,
            8443,
        ];
        this.annotationText = props?.annotationText ?? 'NoPublicIngressCommonWebPortsAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 80, 443, 8080, 8443';
    }
}
exports.NoPublicIngressCommonWebPortsAspect = NoPublicIngressCommonWebPortsAspect;
_o = JSII_RTTI_SYMBOL_1;
NoPublicIngressCommonWebPortsAspect[_o] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressCommonWebPortsAspect", version: "2.0.219" };
/**
 * Aspect to restrict any access to common web ports.
 *
 * 80 - HTTP
 * 443 - HTTPS
 * 8080 - HTTP
 * 8443 - HTTPS
 */
class NoIngressCommonWebPortsAspect extends SecurityGroupAspectBase {
    constructor(props) {
        super(props);
        this.ports = [
            80,
            443,
            8080,
            8443,
        ];
        this.annotationText = props?.annotationText ?? 'NoIngressCommonWebPortsAspect: A security group rule allows access to a restricted port: 80, 443, 8080, 8443';
        this.anySource = true;
    }
}
exports.NoIngressCommonWebPortsAspect = NoIngressCommonWebPortsAspect;
_p = JSII_RTTI_SYMBOL_1;
NoIngressCommonWebPortsAspect[_p] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoIngressCommonWebPortsAspect", version: "2.0.219" };
//# sourceMappingURL=data:application/json;base64,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