"Main interface for devicefarm type defs"
from __future__ import annotations

from datetime import datetime
from typing import Dict, List
from typing_extensions import TypedDict


__all__ = (
    "ClientCreateDevicePoolResponsedevicePoolrulesTypeDef",
    "ClientCreateDevicePoolResponsedevicePoolTypeDef",
    "ClientCreateDevicePoolResponseTypeDef",
    "ClientCreateDevicePoolrulesTypeDef",
    "ClientCreateInstanceProfileResponseinstanceProfileTypeDef",
    "ClientCreateInstanceProfileResponseTypeDef",
    "ClientCreateNetworkProfileResponsenetworkProfileTypeDef",
    "ClientCreateNetworkProfileResponseTypeDef",
    "ClientCreateProjectResponseprojectTypeDef",
    "ClientCreateProjectResponseTypeDef",
    "ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef",
    "ClientCreateRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef",
    "ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef",
    "ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef",
    "ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef",
    "ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef",
    "ClientCreateRemoteAccessSessionResponseremoteAccessSessionTypeDef",
    "ClientCreateRemoteAccessSessionResponseTypeDef",
    "ClientCreateRemoteAccessSessionconfigurationTypeDef",
    "ClientCreateUploadResponseuploadTypeDef",
    "ClientCreateUploadResponseTypeDef",
    "ClientCreateVpceConfigurationResponsevpceConfigurationTypeDef",
    "ClientCreateVpceConfigurationResponseTypeDef",
    "ClientGetAccountSettingsResponseaccountSettingstrialMinutesTypeDef",
    "ClientGetAccountSettingsResponseaccountSettingsTypeDef",
    "ClientGetAccountSettingsResponseTypeDef",
    "ClientGetDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef",
    "ClientGetDeviceInstanceResponsedeviceInstanceTypeDef",
    "ClientGetDeviceInstanceResponseTypeDef",
    "ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdevicecpuTypeDef",
    "ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesinstanceProfileTypeDef",
    "ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesTypeDef",
    "ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceresolutionTypeDef",
    "ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceTypeDef",
    "ClientGetDevicePoolCompatibilityResponsecompatibleDevicesincompatibilityMessagesTypeDef",
    "ClientGetDevicePoolCompatibilityResponsecompatibleDevicesTypeDef",
    "ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdevicecpuTypeDef",
    "ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesinstanceProfileTypeDef",
    "ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesTypeDef",
    "ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceresolutionTypeDef",
    "ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceTypeDef",
    "ClientGetDevicePoolCompatibilityResponseincompatibleDevicesincompatibilityMessagesTypeDef",
    "ClientGetDevicePoolCompatibilityResponseincompatibleDevicesTypeDef",
    "ClientGetDevicePoolCompatibilityResponseTypeDef",
    "ClientGetDevicePoolCompatibilityconfigurationcustomerArtifactPathsTypeDef",
    "ClientGetDevicePoolCompatibilityconfigurationlocationTypeDef",
    "ClientGetDevicePoolCompatibilityconfigurationradiosTypeDef",
    "ClientGetDevicePoolCompatibilityconfigurationTypeDef",
    "ClientGetDevicePoolCompatibilitytestTypeDef",
    "ClientGetDevicePoolResponsedevicePoolrulesTypeDef",
    "ClientGetDevicePoolResponsedevicePoolTypeDef",
    "ClientGetDevicePoolResponseTypeDef",
    "ClientGetDeviceResponsedevicecpuTypeDef",
    "ClientGetDeviceResponsedeviceinstancesinstanceProfileTypeDef",
    "ClientGetDeviceResponsedeviceinstancesTypeDef",
    "ClientGetDeviceResponsedeviceresolutionTypeDef",
    "ClientGetDeviceResponsedeviceTypeDef",
    "ClientGetDeviceResponseTypeDef",
    "ClientGetInstanceProfileResponseinstanceProfileTypeDef",
    "ClientGetInstanceProfileResponseTypeDef",
    "ClientGetJobResponsejobcountersTypeDef",
    "ClientGetJobResponsejobdeviceMinutesTypeDef",
    "ClientGetJobResponsejobdevicecpuTypeDef",
    "ClientGetJobResponsejobdeviceinstancesinstanceProfileTypeDef",
    "ClientGetJobResponsejobdeviceinstancesTypeDef",
    "ClientGetJobResponsejobdeviceresolutionTypeDef",
    "ClientGetJobResponsejobdeviceTypeDef",
    "ClientGetJobResponsejobTypeDef",
    "ClientGetJobResponseTypeDef",
    "ClientGetNetworkProfileResponsenetworkProfileTypeDef",
    "ClientGetNetworkProfileResponseTypeDef",
    "ClientGetOfferingStatusResponsecurrentofferingrecurringChargescostTypeDef",
    "ClientGetOfferingStatusResponsecurrentofferingrecurringChargesTypeDef",
    "ClientGetOfferingStatusResponsecurrentofferingTypeDef",
    "ClientGetOfferingStatusResponsecurrentTypeDef",
    "ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargescostTypeDef",
    "ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargesTypeDef",
    "ClientGetOfferingStatusResponsenextPeriodofferingTypeDef",
    "ClientGetOfferingStatusResponsenextPeriodTypeDef",
    "ClientGetOfferingStatusResponseTypeDef",
    "ClientGetProjectResponseprojectTypeDef",
    "ClientGetProjectResponseTypeDef",
    "ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef",
    "ClientGetRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef",
    "ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef",
    "ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef",
    "ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef",
    "ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef",
    "ClientGetRemoteAccessSessionResponseremoteAccessSessionTypeDef",
    "ClientGetRemoteAccessSessionResponseTypeDef",
    "ClientGetRunResponseruncountersTypeDef",
    "ClientGetRunResponseruncustomerArtifactPathsTypeDef",
    "ClientGetRunResponserundeviceMinutesTypeDef",
    "ClientGetRunResponserundeviceSelectionResultfiltersTypeDef",
    "ClientGetRunResponserundeviceSelectionResultTypeDef",
    "ClientGetRunResponserunlocationTypeDef",
    "ClientGetRunResponserunnetworkProfileTypeDef",
    "ClientGetRunResponserunradiosTypeDef",
    "ClientGetRunResponserunTypeDef",
    "ClientGetRunResponseTypeDef",
    "ClientGetSuiteResponsesuitecountersTypeDef",
    "ClientGetSuiteResponsesuitedeviceMinutesTypeDef",
    "ClientGetSuiteResponsesuiteTypeDef",
    "ClientGetSuiteResponseTypeDef",
    "ClientGetTestResponsetestcountersTypeDef",
    "ClientGetTestResponsetestdeviceMinutesTypeDef",
    "ClientGetTestResponsetestTypeDef",
    "ClientGetTestResponseTypeDef",
    "ClientGetUploadResponseuploadTypeDef",
    "ClientGetUploadResponseTypeDef",
    "ClientGetVpceConfigurationResponsevpceConfigurationTypeDef",
    "ClientGetVpceConfigurationResponseTypeDef",
    "ClientInstallToRemoteAccessSessionResponseappUploadTypeDef",
    "ClientInstallToRemoteAccessSessionResponseTypeDef",
    "ClientListArtifactsResponseartifactsTypeDef",
    "ClientListArtifactsResponseTypeDef",
    "ClientListDeviceInstancesResponsedeviceInstancesinstanceProfileTypeDef",
    "ClientListDeviceInstancesResponsedeviceInstancesTypeDef",
    "ClientListDeviceInstancesResponseTypeDef",
    "ClientListDevicePoolsResponsedevicePoolsrulesTypeDef",
    "ClientListDevicePoolsResponsedevicePoolsTypeDef",
    "ClientListDevicePoolsResponseTypeDef",
    "ClientListDevicesResponsedevicescpuTypeDef",
    "ClientListDevicesResponsedevicesinstancesinstanceProfileTypeDef",
    "ClientListDevicesResponsedevicesinstancesTypeDef",
    "ClientListDevicesResponsedevicesresolutionTypeDef",
    "ClientListDevicesResponsedevicesTypeDef",
    "ClientListDevicesResponseTypeDef",
    "ClientListDevicesfiltersTypeDef",
    "ClientListInstanceProfilesResponseinstanceProfilesTypeDef",
    "ClientListInstanceProfilesResponseTypeDef",
    "ClientListJobsResponsejobscountersTypeDef",
    "ClientListJobsResponsejobsdeviceMinutesTypeDef",
    "ClientListJobsResponsejobsdevicecpuTypeDef",
    "ClientListJobsResponsejobsdeviceinstancesinstanceProfileTypeDef",
    "ClientListJobsResponsejobsdeviceinstancesTypeDef",
    "ClientListJobsResponsejobsdeviceresolutionTypeDef",
    "ClientListJobsResponsejobsdeviceTypeDef",
    "ClientListJobsResponsejobsTypeDef",
    "ClientListJobsResponseTypeDef",
    "ClientListNetworkProfilesResponsenetworkProfilesTypeDef",
    "ClientListNetworkProfilesResponseTypeDef",
    "ClientListOfferingPromotionsResponseofferingPromotionsTypeDef",
    "ClientListOfferingPromotionsResponseTypeDef",
    "ClientListOfferingTransactionsResponseofferingTransactionscostTypeDef",
    "ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef",
    "ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef",
    "ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingTypeDef",
    "ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusTypeDef",
    "ClientListOfferingTransactionsResponseofferingTransactionsTypeDef",
    "ClientListOfferingTransactionsResponseTypeDef",
    "ClientListOfferingsResponseofferingsrecurringChargescostTypeDef",
    "ClientListOfferingsResponseofferingsrecurringChargesTypeDef",
    "ClientListOfferingsResponseofferingsTypeDef",
    "ClientListOfferingsResponseTypeDef",
    "ClientListProjectsResponseprojectsTypeDef",
    "ClientListProjectsResponseTypeDef",
    "ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceMinutesTypeDef",
    "ClientListRemoteAccessSessionsResponseremoteAccessSessionsdevicecpuTypeDef",
    "ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesinstanceProfileTypeDef",
    "ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesTypeDef",
    "ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceresolutionTypeDef",
    "ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceTypeDef",
    "ClientListRemoteAccessSessionsResponseremoteAccessSessionsTypeDef",
    "ClientListRemoteAccessSessionsResponseTypeDef",
    "ClientListRunsResponserunscountersTypeDef",
    "ClientListRunsResponserunscustomerArtifactPathsTypeDef",
    "ClientListRunsResponserunsdeviceMinutesTypeDef",
    "ClientListRunsResponserunsdeviceSelectionResultfiltersTypeDef",
    "ClientListRunsResponserunsdeviceSelectionResultTypeDef",
    "ClientListRunsResponserunslocationTypeDef",
    "ClientListRunsResponserunsnetworkProfileTypeDef",
    "ClientListRunsResponserunsradiosTypeDef",
    "ClientListRunsResponserunsTypeDef",
    "ClientListRunsResponseTypeDef",
    "ClientListSamplesResponsesamplesTypeDef",
    "ClientListSamplesResponseTypeDef",
    "ClientListSuitesResponsesuitescountersTypeDef",
    "ClientListSuitesResponsesuitesdeviceMinutesTypeDef",
    "ClientListSuitesResponsesuitesTypeDef",
    "ClientListSuitesResponseTypeDef",
    "ClientListTagsForResourceResponseTagsTypeDef",
    "ClientListTagsForResourceResponseTypeDef",
    "ClientListTestsResponsetestscountersTypeDef",
    "ClientListTestsResponsetestsdeviceMinutesTypeDef",
    "ClientListTestsResponsetestsTypeDef",
    "ClientListTestsResponseTypeDef",
    "ClientListUniqueProblemsResponseuniqueProblemsproblemsdevicecpuTypeDef",
    "ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesinstanceProfileTypeDef",
    "ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesTypeDef",
    "ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceresolutionTypeDef",
    "ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceTypeDef",
    "ClientListUniqueProblemsResponseuniqueProblemsproblemsjobTypeDef",
    "ClientListUniqueProblemsResponseuniqueProblemsproblemsrunTypeDef",
    "ClientListUniqueProblemsResponseuniqueProblemsproblemssuiteTypeDef",
    "ClientListUniqueProblemsResponseuniqueProblemsproblemstestTypeDef",
    "ClientListUniqueProblemsResponseuniqueProblemsproblemsTypeDef",
    "ClientListUniqueProblemsResponseuniqueProblemsTypeDef",
    "ClientListUniqueProblemsResponseTypeDef",
    "ClientListUploadsResponseuploadsTypeDef",
    "ClientListUploadsResponseTypeDef",
    "ClientListVpceConfigurationsResponsevpceConfigurationsTypeDef",
    "ClientListVpceConfigurationsResponseTypeDef",
    "ClientPurchaseOfferingResponseofferingTransactioncostTypeDef",
    "ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef",
    "ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef",
    "ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingTypeDef",
    "ClientPurchaseOfferingResponseofferingTransactionofferingStatusTypeDef",
    "ClientPurchaseOfferingResponseofferingTransactionTypeDef",
    "ClientPurchaseOfferingResponseTypeDef",
    "ClientRenewOfferingResponseofferingTransactioncostTypeDef",
    "ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef",
    "ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef",
    "ClientRenewOfferingResponseofferingTransactionofferingStatusofferingTypeDef",
    "ClientRenewOfferingResponseofferingTransactionofferingStatusTypeDef",
    "ClientRenewOfferingResponseofferingTransactionTypeDef",
    "ClientRenewOfferingResponseTypeDef",
    "ClientScheduleRunResponseruncountersTypeDef",
    "ClientScheduleRunResponseruncustomerArtifactPathsTypeDef",
    "ClientScheduleRunResponserundeviceMinutesTypeDef",
    "ClientScheduleRunResponserundeviceSelectionResultfiltersTypeDef",
    "ClientScheduleRunResponserundeviceSelectionResultTypeDef",
    "ClientScheduleRunResponserunlocationTypeDef",
    "ClientScheduleRunResponserunnetworkProfileTypeDef",
    "ClientScheduleRunResponserunradiosTypeDef",
    "ClientScheduleRunResponserunTypeDef",
    "ClientScheduleRunResponseTypeDef",
    "ClientScheduleRunconfigurationcustomerArtifactPathsTypeDef",
    "ClientScheduleRunconfigurationlocationTypeDef",
    "ClientScheduleRunconfigurationradiosTypeDef",
    "ClientScheduleRunconfigurationTypeDef",
    "ClientScheduleRundeviceSelectionConfigurationfiltersTypeDef",
    "ClientScheduleRundeviceSelectionConfigurationTypeDef",
    "ClientScheduleRunexecutionConfigurationTypeDef",
    "ClientScheduleRuntestTypeDef",
    "ClientStopJobResponsejobcountersTypeDef",
    "ClientStopJobResponsejobdeviceMinutesTypeDef",
    "ClientStopJobResponsejobdevicecpuTypeDef",
    "ClientStopJobResponsejobdeviceinstancesinstanceProfileTypeDef",
    "ClientStopJobResponsejobdeviceinstancesTypeDef",
    "ClientStopJobResponsejobdeviceresolutionTypeDef",
    "ClientStopJobResponsejobdeviceTypeDef",
    "ClientStopJobResponsejobTypeDef",
    "ClientStopJobResponseTypeDef",
    "ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef",
    "ClientStopRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef",
    "ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef",
    "ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef",
    "ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef",
    "ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef",
    "ClientStopRemoteAccessSessionResponseremoteAccessSessionTypeDef",
    "ClientStopRemoteAccessSessionResponseTypeDef",
    "ClientStopRunResponseruncountersTypeDef",
    "ClientStopRunResponseruncustomerArtifactPathsTypeDef",
    "ClientStopRunResponserundeviceMinutesTypeDef",
    "ClientStopRunResponserundeviceSelectionResultfiltersTypeDef",
    "ClientStopRunResponserundeviceSelectionResultTypeDef",
    "ClientStopRunResponserunlocationTypeDef",
    "ClientStopRunResponserunnetworkProfileTypeDef",
    "ClientStopRunResponserunradiosTypeDef",
    "ClientStopRunResponserunTypeDef",
    "ClientStopRunResponseTypeDef",
    "ClientTagResourceTagsTypeDef",
    "ClientUpdateDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef",
    "ClientUpdateDeviceInstanceResponsedeviceInstanceTypeDef",
    "ClientUpdateDeviceInstanceResponseTypeDef",
    "ClientUpdateDevicePoolResponsedevicePoolrulesTypeDef",
    "ClientUpdateDevicePoolResponsedevicePoolTypeDef",
    "ClientUpdateDevicePoolResponseTypeDef",
    "ClientUpdateDevicePoolrulesTypeDef",
    "ClientUpdateInstanceProfileResponseinstanceProfileTypeDef",
    "ClientUpdateInstanceProfileResponseTypeDef",
    "ClientUpdateNetworkProfileResponsenetworkProfileTypeDef",
    "ClientUpdateNetworkProfileResponseTypeDef",
    "ClientUpdateProjectResponseprojectTypeDef",
    "ClientUpdateProjectResponseTypeDef",
    "ClientUpdateUploadResponseuploadTypeDef",
    "ClientUpdateUploadResponseTypeDef",
    "ClientUpdateVpceConfigurationResponsevpceConfigurationTypeDef",
    "ClientUpdateVpceConfigurationResponseTypeDef",
    "GetOfferingStatusPaginatePaginationConfigTypeDef",
    "GetOfferingStatusPaginateResponsecurrentofferingrecurringChargescostTypeDef",
    "GetOfferingStatusPaginateResponsecurrentofferingrecurringChargesTypeDef",
    "GetOfferingStatusPaginateResponsecurrentofferingTypeDef",
    "GetOfferingStatusPaginateResponsecurrentTypeDef",
    "GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargescostTypeDef",
    "GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargesTypeDef",
    "GetOfferingStatusPaginateResponsenextPeriodofferingTypeDef",
    "GetOfferingStatusPaginateResponsenextPeriodTypeDef",
    "GetOfferingStatusPaginateResponseTypeDef",
    "ListArtifactsPaginatePaginationConfigTypeDef",
    "ListArtifactsPaginateResponseartifactsTypeDef",
    "ListArtifactsPaginateResponseTypeDef",
    "ListDeviceInstancesPaginatePaginationConfigTypeDef",
    "ListDeviceInstancesPaginateResponsedeviceInstancesinstanceProfileTypeDef",
    "ListDeviceInstancesPaginateResponsedeviceInstancesTypeDef",
    "ListDeviceInstancesPaginateResponseTypeDef",
    "ListDevicePoolsPaginatePaginationConfigTypeDef",
    "ListDevicePoolsPaginateResponsedevicePoolsrulesTypeDef",
    "ListDevicePoolsPaginateResponsedevicePoolsTypeDef",
    "ListDevicePoolsPaginateResponseTypeDef",
    "ListDevicesPaginatePaginationConfigTypeDef",
    "ListDevicesPaginateResponsedevicescpuTypeDef",
    "ListDevicesPaginateResponsedevicesinstancesinstanceProfileTypeDef",
    "ListDevicesPaginateResponsedevicesinstancesTypeDef",
    "ListDevicesPaginateResponsedevicesresolutionTypeDef",
    "ListDevicesPaginateResponsedevicesTypeDef",
    "ListDevicesPaginateResponseTypeDef",
    "ListDevicesPaginatefiltersTypeDef",
    "ListInstanceProfilesPaginatePaginationConfigTypeDef",
    "ListInstanceProfilesPaginateResponseinstanceProfilesTypeDef",
    "ListInstanceProfilesPaginateResponseTypeDef",
    "ListJobsPaginatePaginationConfigTypeDef",
    "ListJobsPaginateResponsejobscountersTypeDef",
    "ListJobsPaginateResponsejobsdeviceMinutesTypeDef",
    "ListJobsPaginateResponsejobsdevicecpuTypeDef",
    "ListJobsPaginateResponsejobsdeviceinstancesinstanceProfileTypeDef",
    "ListJobsPaginateResponsejobsdeviceinstancesTypeDef",
    "ListJobsPaginateResponsejobsdeviceresolutionTypeDef",
    "ListJobsPaginateResponsejobsdeviceTypeDef",
    "ListJobsPaginateResponsejobsTypeDef",
    "ListJobsPaginateResponseTypeDef",
    "ListNetworkProfilesPaginatePaginationConfigTypeDef",
    "ListNetworkProfilesPaginateResponsenetworkProfilesTypeDef",
    "ListNetworkProfilesPaginateResponseTypeDef",
    "ListOfferingPromotionsPaginatePaginationConfigTypeDef",
    "ListOfferingPromotionsPaginateResponseofferingPromotionsTypeDef",
    "ListOfferingPromotionsPaginateResponseTypeDef",
    "ListOfferingTransactionsPaginatePaginationConfigTypeDef",
    "ListOfferingTransactionsPaginateResponseofferingTransactionscostTypeDef",
    "ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef",
    "ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef",
    "ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingTypeDef",
    "ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusTypeDef",
    "ListOfferingTransactionsPaginateResponseofferingTransactionsTypeDef",
    "ListOfferingTransactionsPaginateResponseTypeDef",
    "ListOfferingsPaginatePaginationConfigTypeDef",
    "ListOfferingsPaginateResponseofferingsrecurringChargescostTypeDef",
    "ListOfferingsPaginateResponseofferingsrecurringChargesTypeDef",
    "ListOfferingsPaginateResponseofferingsTypeDef",
    "ListOfferingsPaginateResponseTypeDef",
    "ListProjectsPaginatePaginationConfigTypeDef",
    "ListProjectsPaginateResponseprojectsTypeDef",
    "ListProjectsPaginateResponseTypeDef",
    "ListRemoteAccessSessionsPaginatePaginationConfigTypeDef",
    "ListRemoteAccessSessionsPaginateResponseremoteAccessSessionsdeviceMinutesTypeDef",
    "ListRemoteAccessSessionsPaginateResponseremoteAccessSessionsdevicecpuTypeDef",
    "ListRemoteAccessSessionsPaginateResponseremoteAccessSessionsdeviceinstancesinstanceProfileTypeDef",
    "ListRemoteAccessSessionsPaginateResponseremoteAccessSessionsdeviceinstancesTypeDef",
    "ListRemoteAccessSessionsPaginateResponseremoteAccessSessionsdeviceresolutionTypeDef",
    "ListRemoteAccessSessionsPaginateResponseremoteAccessSessionsdeviceTypeDef",
    "ListRemoteAccessSessionsPaginateResponseremoteAccessSessionsTypeDef",
    "ListRemoteAccessSessionsPaginateResponseTypeDef",
    "ListRunsPaginatePaginationConfigTypeDef",
    "ListRunsPaginateResponserunscountersTypeDef",
    "ListRunsPaginateResponserunscustomerArtifactPathsTypeDef",
    "ListRunsPaginateResponserunsdeviceMinutesTypeDef",
    "ListRunsPaginateResponserunsdeviceSelectionResultfiltersTypeDef",
    "ListRunsPaginateResponserunsdeviceSelectionResultTypeDef",
    "ListRunsPaginateResponserunslocationTypeDef",
    "ListRunsPaginateResponserunsnetworkProfileTypeDef",
    "ListRunsPaginateResponserunsradiosTypeDef",
    "ListRunsPaginateResponserunsTypeDef",
    "ListRunsPaginateResponseTypeDef",
    "ListSamplesPaginatePaginationConfigTypeDef",
    "ListSamplesPaginateResponsesamplesTypeDef",
    "ListSamplesPaginateResponseTypeDef",
    "ListSuitesPaginatePaginationConfigTypeDef",
    "ListSuitesPaginateResponsesuitescountersTypeDef",
    "ListSuitesPaginateResponsesuitesdeviceMinutesTypeDef",
    "ListSuitesPaginateResponsesuitesTypeDef",
    "ListSuitesPaginateResponseTypeDef",
    "ListTestsPaginatePaginationConfigTypeDef",
    "ListTestsPaginateResponsetestscountersTypeDef",
    "ListTestsPaginateResponsetestsdeviceMinutesTypeDef",
    "ListTestsPaginateResponsetestsTypeDef",
    "ListTestsPaginateResponseTypeDef",
    "ListUniqueProblemsPaginatePaginationConfigTypeDef",
    "ListUniqueProblemsPaginateResponseuniqueProblemsproblemsdevicecpuTypeDef",
    "ListUniqueProblemsPaginateResponseuniqueProblemsproblemsdeviceinstancesinstanceProfileTypeDef",
    "ListUniqueProblemsPaginateResponseuniqueProblemsproblemsdeviceinstancesTypeDef",
    "ListUniqueProblemsPaginateResponseuniqueProblemsproblemsdeviceresolutionTypeDef",
    "ListUniqueProblemsPaginateResponseuniqueProblemsproblemsdeviceTypeDef",
    "ListUniqueProblemsPaginateResponseuniqueProblemsproblemsjobTypeDef",
    "ListUniqueProblemsPaginateResponseuniqueProblemsproblemsrunTypeDef",
    "ListUniqueProblemsPaginateResponseuniqueProblemsproblemssuiteTypeDef",
    "ListUniqueProblemsPaginateResponseuniqueProblemsproblemstestTypeDef",
    "ListUniqueProblemsPaginateResponseuniqueProblemsproblemsTypeDef",
    "ListUniqueProblemsPaginateResponseuniqueProblemsTypeDef",
    "ListUniqueProblemsPaginateResponseTypeDef",
    "ListUploadsPaginatePaginationConfigTypeDef",
    "ListUploadsPaginateResponseuploadsTypeDef",
    "ListUploadsPaginateResponseTypeDef",
    "ListVPCEConfigurationsPaginatePaginationConfigTypeDef",
    "ListVPCEConfigurationsPaginateResponsevpceConfigurationsTypeDef",
    "ListVPCEConfigurationsPaginateResponseTypeDef",
)


_ClientCreateDevicePoolResponsedevicePoolrulesTypeDef = TypedDict(
    "_ClientCreateDevicePoolResponsedevicePoolrulesTypeDef",
    {"attribute": str, "operator": str, "value": str},
    total=False,
)


class ClientCreateDevicePoolResponsedevicePoolrulesTypeDef(
    _ClientCreateDevicePoolResponsedevicePoolrulesTypeDef
):
    """
    Type definition for `ClientCreateDevicePoolResponsedevicePool` `rules`

    Represents a condition for a device pool.

    - **attribute** *(string) --*

      The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

      The supported operators for each attribute are provided in the following list.

        APPIUM_VERSION

      The Appium version for the test.

       *Supported operators* : ``CONTAINS``

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE",
      "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        MODEL

      The device model, such as "Apple iPad Air 2" or "Google Pixel".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
       ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

      Whether the device is enabled for remote debugging. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **operator** *(string) --*

      Specifies how Device Farm compares the rule's attribute to the value. For the operators
      that are supported by each attribute, see the attribute descriptions.

    - **value** *(string) --*

      The rule's value.
    """


_ClientCreateDevicePoolResponsedevicePoolTypeDef = TypedDict(
    "_ClientCreateDevicePoolResponsedevicePoolTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "rules": List[ClientCreateDevicePoolResponsedevicePoolrulesTypeDef],
        "maxDevices": int,
    },
    total=False,
)


class ClientCreateDevicePoolResponsedevicePoolTypeDef(
    _ClientCreateDevicePoolResponsedevicePoolTypeDef
):
    """
    Type definition for `ClientCreateDevicePoolResponse` `devicePool`

    The newly created device pool.

    - **arn** *(string) --*

      The device pool's ARN.

    - **name** *(string) --*

      The device pool's name.

    - **description** *(string) --*

      The device pool's description.

    - **type** *(string) --*

      The device pool's type.

      Allowed values include:

      * CURATED: A device pool that is created and managed by AWS Device Farm.

      * PRIVATE: A device pool that is created and managed by the device pool developer.

    - **rules** *(list) --*

      Information about the device pool's rules.

      - *(dict) --*

        Represents a condition for a device pool.

        - **attribute** *(string) --*

          The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

          The supported operators for each attribute are provided in the following list.

            APPIUM_VERSION

          The Appium version for the test.

           *Supported operators* : ``CONTAINS``

            ARN

          The Amazon Resource Name (ARN) of the device. For example,
          "arn:aws:devicefarm:us-west-2::device:12345Example".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            AVAILABILITY

          The current availability of the device. Valid values are "AVAILABLE",
          "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

           *Supported operators* : ``EQUALS``

            FLEET_TYPE

          The fleet type. Valid values are "PUBLIC" or "PRIVATE".

           *Supported operators* : ``EQUALS``

            FORM_FACTOR

          The device form factor. Valid values are "PHONE" or "TABLET".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            INSTANCE_ARN

          The Amazon Resource Name (ARN) of the device instance.

           *Supported operators* : ``IN`` , ``NOT_IN``

            INSTANCE_LABELS

          The label of the device instance.

           *Supported operators* : ``CONTAINS``

            MANUFACTURER

          The device manufacturer. For example, "Apple".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            MODEL

          The device model, such as "Apple iPad Air 2" or "Google Pixel".

           *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

            OS_VERSION

          The operating system version. For example, "10.3.2".

           *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
           ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

            PLATFORM

          The device platform. Valid values are "ANDROID" or "IOS".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            REMOTE_ACCESS_ENABLED

          Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

            REMOTE_DEBUG_ENABLED

          Whether the device is enabled for remote debugging. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

           *This filter will be ignored, as remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **operator** *(string) --*

          Specifies how Device Farm compares the rule's attribute to the value. For the operators
          that are supported by each attribute, see the attribute descriptions.

        - **value** *(string) --*

          The rule's value.

    - **maxDevices** *(integer) --*

      The number of devices that Device Farm can add to your device pool. Device Farm adds
      devices that are available and that meet the criteria that you assign for the ``rules``
      parameter. Depending on how many devices meet these constraints, your device pool might
      contain fewer devices than the value for this parameter.

      By specifying the maximum number of devices, you can control the costs that you incur by
      running tests.
    """


_ClientCreateDevicePoolResponseTypeDef = TypedDict(
    "_ClientCreateDevicePoolResponseTypeDef",
    {"devicePool": ClientCreateDevicePoolResponsedevicePoolTypeDef},
    total=False,
)


class ClientCreateDevicePoolResponseTypeDef(_ClientCreateDevicePoolResponseTypeDef):
    """
    Type definition for `ClientCreateDevicePool` `Response`

    Represents the result of a create device pool request.

    - **devicePool** *(dict) --*

      The newly created device pool.

      - **arn** *(string) --*

        The device pool's ARN.

      - **name** *(string) --*

        The device pool's name.

      - **description** *(string) --*

        The device pool's description.

      - **type** *(string) --*

        The device pool's type.

        Allowed values include:

        * CURATED: A device pool that is created and managed by AWS Device Farm.

        * PRIVATE: A device pool that is created and managed by the device pool developer.

      - **rules** *(list) --*

        Information about the device pool's rules.

        - *(dict) --*

          Represents a condition for a device pool.

          - **attribute** *(string) --*

            The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

            The supported operators for each attribute are provided in the following list.

              APPIUM_VERSION

            The Appium version for the test.

             *Supported operators* : ``CONTAINS``

              ARN

            The Amazon Resource Name (ARN) of the device. For example,
            "arn:aws:devicefarm:us-west-2::device:12345Example".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              AVAILABILITY

            The current availability of the device. Valid values are "AVAILABLE",
            "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

             *Supported operators* : ``EQUALS``

              FLEET_TYPE

            The fleet type. Valid values are "PUBLIC" or "PRIVATE".

             *Supported operators* : ``EQUALS``

              FORM_FACTOR

            The device form factor. Valid values are "PHONE" or "TABLET".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              INSTANCE_ARN

            The Amazon Resource Name (ARN) of the device instance.

             *Supported operators* : ``IN`` , ``NOT_IN``

              INSTANCE_LABELS

            The label of the device instance.

             *Supported operators* : ``CONTAINS``

              MANUFACTURER

            The device manufacturer. For example, "Apple".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              MODEL

            The device model, such as "Apple iPad Air 2" or "Google Pixel".

             *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

              OS_VERSION

            The operating system version. For example, "10.3.2".

             *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
             ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

              PLATFORM

            The device platform. Valid values are "ANDROID" or "IOS".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              REMOTE_ACCESS_ENABLED

            Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

              REMOTE_DEBUG_ENABLED

            Whether the device is enabled for remote debugging. Valid values are "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

             *This filter will be ignored, as remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

          - **operator** *(string) --*

            Specifies how Device Farm compares the rule's attribute to the value. For the operators
            that are supported by each attribute, see the attribute descriptions.

          - **value** *(string) --*

            The rule's value.

      - **maxDevices** *(integer) --*

        The number of devices that Device Farm can add to your device pool. Device Farm adds
        devices that are available and that meet the criteria that you assign for the ``rules``
        parameter. Depending on how many devices meet these constraints, your device pool might
        contain fewer devices than the value for this parameter.

        By specifying the maximum number of devices, you can control the costs that you incur by
        running tests.
    """


_ClientCreateDevicePoolrulesTypeDef = TypedDict(
    "_ClientCreateDevicePoolrulesTypeDef",
    {"attribute": str, "operator": str, "value": str},
    total=False,
)


class ClientCreateDevicePoolrulesTypeDef(_ClientCreateDevicePoolrulesTypeDef):
    """
    Type definition for `ClientCreateDevicePool` `rules`

    Represents a condition for a device pool.

    - **attribute** *(string) --*

      The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

      The supported operators for each attribute are provided in the following list.

        APPIUM_VERSION

      The Appium version for the test.

       *Supported operators* : ``CONTAINS``

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE", "HIGHLY_AVAILABLE",
      "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        MODEL

      The device model, such as "Apple iPad Air 2" or "Google Pixel".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` , ``IN``
       , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

      Whether the device is enabled for remote debugging. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **operator** *(string) --*

      Specifies how Device Farm compares the rule's attribute to the value. For the operators that
      are supported by each attribute, see the attribute descriptions.

    - **value** *(string) --*

      The rule's value.
    """


_ClientCreateInstanceProfileResponseinstanceProfileTypeDef = TypedDict(
    "_ClientCreateInstanceProfileResponseinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientCreateInstanceProfileResponseinstanceProfileTypeDef(
    _ClientCreateInstanceProfileResponseinstanceProfileTypeDef
):
    """
    Type definition for `ClientCreateInstanceProfileResponse` `instanceProfile`

    An object containing information about your instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The default
      value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned up from
      the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The default
      value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientCreateInstanceProfileResponseTypeDef = TypedDict(
    "_ClientCreateInstanceProfileResponseTypeDef",
    {"instanceProfile": ClientCreateInstanceProfileResponseinstanceProfileTypeDef},
    total=False,
)


class ClientCreateInstanceProfileResponseTypeDef(
    _ClientCreateInstanceProfileResponseTypeDef
):
    """
    Type definition for `ClientCreateInstanceProfile` `Response`

    - **instanceProfile** *(dict) --*

      An object containing information about your instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The default
        value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned up from
        the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The default
        value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientCreateNetworkProfileResponsenetworkProfileTypeDef = TypedDict(
    "_ClientCreateNetworkProfileResponsenetworkProfileTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "uplinkBandwidthBits": int,
        "downlinkBandwidthBits": int,
        "uplinkDelayMs": int,
        "downlinkDelayMs": int,
        "uplinkJitterMs": int,
        "downlinkJitterMs": int,
        "uplinkLossPercent": int,
        "downlinkLossPercent": int,
    },
    total=False,
)


class ClientCreateNetworkProfileResponsenetworkProfileTypeDef(
    _ClientCreateNetworkProfileResponsenetworkProfileTypeDef
):
    """
    Type definition for `ClientCreateNetworkProfileResponse` `networkProfile`

    The network profile that is returned by the create network profile request.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the network profile.

    - **name** *(string) --*

      The name of the network profile.

    - **description** *(string) --*

      The description of the network profile.

    - **type** *(string) --*

      The type of network profile. Valid values are listed below.

    - **uplinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **downlinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **uplinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **downlinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **uplinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **downlinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **uplinkLossPercent** *(integer) --*

      Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

    - **downlinkLossPercent** *(integer) --*

      Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ClientCreateNetworkProfileResponseTypeDef = TypedDict(
    "_ClientCreateNetworkProfileResponseTypeDef",
    {"networkProfile": ClientCreateNetworkProfileResponsenetworkProfileTypeDef},
    total=False,
)


class ClientCreateNetworkProfileResponseTypeDef(
    _ClientCreateNetworkProfileResponseTypeDef
):
    """
    Type definition for `ClientCreateNetworkProfile` `Response`

    - **networkProfile** *(dict) --*

      The network profile that is returned by the create network profile request.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the network profile.

      - **name** *(string) --*

        The name of the network profile.

      - **description** *(string) --*

        The description of the network profile.

      - **type** *(string) --*

        The type of network profile. Valid values are listed below.

      - **uplinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **downlinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **uplinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **downlinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **uplinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **downlinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **uplinkLossPercent** *(integer) --*

        Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

      - **downlinkLossPercent** *(integer) --*

        Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ClientCreateProjectResponseprojectTypeDef = TypedDict(
    "_ClientCreateProjectResponseprojectTypeDef",
    {"arn": str, "name": str, "defaultJobTimeoutMinutes": int, "created": datetime},
    total=False,
)


class ClientCreateProjectResponseprojectTypeDef(
    _ClientCreateProjectResponseprojectTypeDef
):
    """
    Type definition for `ClientCreateProjectResponse` `project`

    The newly created project.

    - **arn** *(string) --*

      The project's ARN.

    - **name** *(string) --*

      The project's name.

    - **defaultJobTimeoutMinutes** *(integer) --*

      The default number of minutes (at the project level) a test run will execute before it
      times out. The default value is 150 minutes.

    - **created** *(datetime) --*

      When the project was created.
    """


_ClientCreateProjectResponseTypeDef = TypedDict(
    "_ClientCreateProjectResponseTypeDef",
    {"project": ClientCreateProjectResponseprojectTypeDef},
    total=False,
)


class ClientCreateProjectResponseTypeDef(_ClientCreateProjectResponseTypeDef):
    """
    Type definition for `ClientCreateProject` `Response`

    Represents the result of a create project request.

    - **project** *(dict) --*

      The newly created project.

      - **arn** *(string) --*

        The project's ARN.

      - **name** *(string) --*

        The project's name.

      - **defaultJobTimeoutMinutes** *(integer) --*

        The default number of minutes (at the project level) a test run will execute before it
        times out. The default value is 150 minutes.

      - **created** *(datetime) --*

        When the project was created.
    """


_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef = TypedDict(
    "_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef(
    _ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef
):
    """
    Type definition for `ClientCreateRemoteAccessSessionResponseremoteAccessSession` `deviceMinutes`

    The number of minutes a device is used in a remote access session (including setup and
    teardown minutes).

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to run
      tests.
    """


_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef = TypedDict(
    "_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientCreateRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef(
    _ClientCreateRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef
):
    """
    Type definition for `ClientCreateRemoteAccessSessionResponseremoteAccessSessiondevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef(
    _ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned
      up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef = TypedDict(
    "_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef(
    _ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef
):
    """
    Type definition for `ClientCreateRemoteAccessSessionResponseremoteAccessSessiondevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned
        up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef = TypedDict(
    "_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef(
    _ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef
):
    """
    Type definition for `ClientCreateRemoteAccessSessionResponseremoteAccessSessiondevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef = TypedDict(
    "_ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientCreateRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef,
        "resolution": ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[
            ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef
        ],
        "availability": str,
    },
    total=False,
)


class ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef(
    _ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef
):
    """
    Type definition for `ClientCreateRemoteAccessSessionResponseremoteAccessSession` `device`

    The device (phone or tablet) used in the remote access session.

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be cleaned
            up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently available
      in the ListDevices and GetDevice API methods.
    """


_ClientCreateRemoteAccessSessionResponseremoteAccessSessionTypeDef = TypedDict(
    "_ClientCreateRemoteAccessSessionResponseremoteAccessSessionTypeDef",
    {
        "arn": str,
        "name": str,
        "created": datetime,
        "status": str,
        "result": str,
        "message": str,
        "started": datetime,
        "stopped": datetime,
        "device": ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef,
        "instanceArn": str,
        "remoteDebugEnabled": bool,
        "remoteRecordEnabled": bool,
        "remoteRecordAppArn": str,
        "hostAddress": str,
        "clientId": str,
        "billingMethod": str,
        "deviceMinutes": ClientCreateRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef,
        "endpoint": str,
        "deviceUdid": str,
        "interactionMode": str,
        "skipAppResign": bool,
    },
    total=False,
)


class ClientCreateRemoteAccessSessionResponseremoteAccessSessionTypeDef(
    _ClientCreateRemoteAccessSessionResponseremoteAccessSessionTypeDef
):
    """
    Type definition for `ClientCreateRemoteAccessSessionResponse` `remoteAccessSession`

    A container that describes the remote access session when the request to create a remote
    access session is sent.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the remote access session.

    - **name** *(string) --*

      The name of the remote access session.

    - **created** *(datetime) --*

      The date and time the remote access session was created.

    - **status** *(string) --*

      The status of the remote access session. Can be any of the following:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The result of the remote access session. Can be any of the following:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **message** *(string) --*

      A message about the remote access session.

    - **started** *(datetime) --*

      The date and time the remote access session was started.

    - **stopped** *(datetime) --*

      The date and time the remote access session was stopped.

    - **device** *(dict) --*

      The device (phone or tablet) used in the remote access session.

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
          CPU is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type are
        PRIVATE and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test run. The
              default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not be cleaned
              up from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test run. The
              default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently available
        in the ListDevices and GetDevice API methods.

    - **instanceArn** *(string) --*

      The Amazon Resource Name (ARN) of the instance.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **remoteRecordEnabled** *(boolean) --*

      This flag is set to ``true`` if remote recording is enabled for the remote access session.

    - **remoteRecordAppArn** *(string) --*

      The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.

    - **hostAddress** *(string) --*

      IP address of the EC2 host where you need to connect to remotely debug devices. Only
      returned if remote debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **clientId** *(string) --*

      Unique identifier of your client for the remote access session. Only returned if remote
      debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **billingMethod** *(string) --*

      The billing method of the remote access session. Possible values include ``METERED`` or
      ``UNMETERED`` . For more information about metered devices, see `AWS Device Farm
      terminology
      <https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology>`__
      ."

    - **deviceMinutes** *(dict) --*

      The number of minutes a device is used in a remote access session (including setup and
      teardown minutes).

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to run
        tests.

    - **endpoint** *(string) --*

      The endpoint for the remote access sesssion.

    - **deviceUdid** *(string) --*

      Unique device identifier for the remote device. Only returned if remote debugging is
      enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **interactionMode** *(string) --*

      The interaction mode of the remote access session. Valid values are:

      * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the
      screen. You **cannot** run XCUITest framework-based tests in this mode.

      * NO_VIDEO: You are connected to the device but cannot interact with it or view the screen.
      This mode has the fastest test execution speed. You **can** run XCUITest framework-based
      tests in this mode.

      * VIDEO_ONLY: You can view the screen but cannot touch or rotate it. You **can** run
      XCUITest framework-based tests and watch the screen in this mode.

    - **skipAppResign** *(boolean) --*

      When set to ``true`` , for private devices, Device Farm will not sign your app again. For
      public devices, Device Farm always signs your apps again and this parameter has no effect.

      For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
      <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .
    """


_ClientCreateRemoteAccessSessionResponseTypeDef = TypedDict(
    "_ClientCreateRemoteAccessSessionResponseTypeDef",
    {
        "remoteAccessSession": ClientCreateRemoteAccessSessionResponseremoteAccessSessionTypeDef
    },
    total=False,
)


class ClientCreateRemoteAccessSessionResponseTypeDef(
    _ClientCreateRemoteAccessSessionResponseTypeDef
):
    """
    Type definition for `ClientCreateRemoteAccessSession` `Response`

    Represents the server response from a request to create a remote access session.

    - **remoteAccessSession** *(dict) --*

      A container that describes the remote access session when the request to create a remote
      access session is sent.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the remote access session.

      - **name** *(string) --*

        The name of the remote access session.

      - **created** *(datetime) --*

        The date and time the remote access session was created.

      - **status** *(string) --*

        The status of the remote access session. Can be any of the following:

        * PENDING: A pending status.

        * PENDING_CONCURRENCY: A pending concurrency status.

        * PENDING_DEVICE: A pending device status.

        * PROCESSING: A processing status.

        * SCHEDULING: A scheduling status.

        * PREPARING: A preparing status.

        * RUNNING: A running status.

        * COMPLETED: A completed status.

        * STOPPING: A stopping status.

      - **result** *(string) --*

        The result of the remote access session. Can be any of the following:

        * PENDING: A pending condition.

        * PASSED: A passing condition.

        * WARNED: A warning condition.

        * FAILED: A failed condition.

        * SKIPPED: A skipped condition.

        * ERRORED: An error condition.

        * STOPPED: A stopped condition.

      - **message** *(string) --*

        A message about the remote access session.

      - **started** *(datetime) --*

        The date and time the remote access session was started.

      - **stopped** *(datetime) --*

        The date and time the remote access session was stopped.

      - **device** *(dict) --*

        The device (phone or tablet) used in the remote access session.

        - **arn** *(string) --*

          The device's ARN.

        - **name** *(string) --*

          The device's display name.

        - **manufacturer** *(string) --*

          The device's manufacturer name.

        - **model** *(string) --*

          The device's model name.

        - **modelId** *(string) --*

          The device's model ID.

        - **formFactor** *(string) --*

          The device's form factor.

          Allowed values include:

          * PHONE: The phone form factor.

          * TABLET: The tablet form factor.

        - **platform** *(string) --*

          The device's platform.

          Allowed values include:

          * ANDROID: The Android platform.

          * IOS: The iOS platform.

        - **os** *(string) --*

          The device's operating system type.

        - **cpu** *(dict) --*

          Information about the device's CPU.

          - **frequency** *(string) --*

            The CPU's frequency.

          - **architecture** *(string) --*

            The CPU's architecture, for example x86 or ARM.

          - **clock** *(float) --*

            The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
            CPU is expressed as 1200000000.

        - **resolution** *(dict) --*

          The resolution of the device.

          - **width** *(integer) --*

            The screen resolution's width, expressed in pixels.

          - **height** *(integer) --*

            The screen resolution's height, expressed in pixels.

        - **heapSize** *(integer) --*

          The device's heap size, expressed in bytes.

        - **memory** *(integer) --*

          The device's total memory size, expressed in bytes.

        - **image** *(string) --*

          The device's image name.

        - **carrier** *(string) --*

          The device's carrier.

        - **radio** *(string) --*

          The device's radio.

        - **remoteAccessEnabled** *(boolean) --*

          Specifies whether remote access has been enabled for the specified device.

        - **remoteDebugEnabled** *(boolean) --*

          This flag is set to ``true`` if remote debugging is enabled for the device.

           *Remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **fleetType** *(string) --*

          The type of fleet to which this device belongs. Possible values for fleet type are
          PRIVATE and PUBLIC.

        - **fleetName** *(string) --*

          The name of the fleet to which this device belongs.

        - **instances** *(list) --*

          The instances belonging to this device.

          - *(dict) --*

            Represents the device instance.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the device instance.

            - **deviceArn** *(string) --*

              The Amazon Resource Name (ARN) of the device.

            - **labels** *(list) --*

              An array of strings describing the device instance.

              - *(string) --*

            - **status** *(string) --*

              The status of the device instance. Valid values are listed below.

            - **udid** *(string) --*

              Unique device identifier for the device instance.

            - **instanceProfile** *(dict) --*

              A object containing information about the instance profile.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the instance profile.

              - **packageCleanup** *(boolean) --*

                When set to ``true`` , Device Farm will remove app packages after a test run. The
                default value is ``false`` for private devices.

              - **excludeAppPackagesFromCleanup** *(list) --*

                An array of strings specifying the list of app packages that should not be cleaned
                up from the device after a test run is over.

                The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

                - *(string) --*

              - **rebootAfterUse** *(boolean) --*

                When set to ``true`` , Device Farm will reboot the instance after a test run. The
                default value is ``true`` .

              - **name** *(string) --*

                The name of the instance profile.

              - **description** *(string) --*

                The description of the instance profile.

        - **availability** *(string) --*

          Reflects how likely a device will be available for a test run. It is currently available
          in the ListDevices and GetDevice API methods.

      - **instanceArn** *(string) --*

        The Amazon Resource Name (ARN) of the instance.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **remoteRecordEnabled** *(boolean) --*

        This flag is set to ``true`` if remote recording is enabled for the remote access session.

      - **remoteRecordAppArn** *(string) --*

        The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.

      - **hostAddress** *(string) --*

        IP address of the EC2 host where you need to connect to remotely debug devices. Only
        returned if remote debugging is enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **clientId** *(string) --*

        Unique identifier of your client for the remote access session. Only returned if remote
        debugging is enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **billingMethod** *(string) --*

        The billing method of the remote access session. Possible values include ``METERED`` or
        ``UNMETERED`` . For more information about metered devices, see `AWS Device Farm
        terminology
        <https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology>`__
        ."

      - **deviceMinutes** *(dict) --*

        The number of minutes a device is used in a remote access session (including setup and
        teardown minutes).

        - **total** *(float) --*

          When specified, represents the total minutes used by the resource to run tests.

        - **metered** *(float) --*

          When specified, represents only the sum of metered minutes used by the resource to run
          tests.

        - **unmetered** *(float) --*

          When specified, represents only the sum of unmetered minutes used by the resource to run
          tests.

      - **endpoint** *(string) --*

        The endpoint for the remote access sesssion.

      - **deviceUdid** *(string) --*

        Unique device identifier for the remote device. Only returned if remote debugging is
        enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **interactionMode** *(string) --*

        The interaction mode of the remote access session. Valid values are:

        * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the
        screen. You **cannot** run XCUITest framework-based tests in this mode.

        * NO_VIDEO: You are connected to the device but cannot interact with it or view the screen.
        This mode has the fastest test execution speed. You **can** run XCUITest framework-based
        tests in this mode.

        * VIDEO_ONLY: You can view the screen but cannot touch or rotate it. You **can** run
        XCUITest framework-based tests and watch the screen in this mode.

      - **skipAppResign** *(boolean) --*

        When set to ``true`` , for private devices, Device Farm will not sign your app again. For
        public devices, Device Farm always signs your apps again and this parameter has no effect.

        For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
        <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .
    """


_ClientCreateRemoteAccessSessionconfigurationTypeDef = TypedDict(
    "_ClientCreateRemoteAccessSessionconfigurationTypeDef",
    {"billingMethod": str, "vpceConfigurationArns": List[str]},
    total=False,
)


class ClientCreateRemoteAccessSessionconfigurationTypeDef(
    _ClientCreateRemoteAccessSessionconfigurationTypeDef
):
    """
    Type definition for `ClientCreateRemoteAccessSession` `configuration`

    The configuration information for the remote access session request.

    - **billingMethod** *(string) --*

      The billing method for the remote access session.

    - **vpceConfigurationArns** *(list) --*

      An array of Amazon Resource Names (ARNs) included in the VPC endpoint configuration.

      - *(string) --*
    """


_ClientCreateUploadResponseuploadTypeDef = TypedDict(
    "_ClientCreateUploadResponseuploadTypeDef",
    {
        "arn": str,
        "name": str,
        "created": datetime,
        "type": str,
        "status": str,
        "url": str,
        "metadata": str,
        "contentType": str,
        "message": str,
        "category": str,
    },
    total=False,
)


class ClientCreateUploadResponseuploadTypeDef(_ClientCreateUploadResponseuploadTypeDef):
    """
    Type definition for `ClientCreateUploadResponse` `upload`

    The newly created upload.

    - **arn** *(string) --*

      The upload's ARN.

    - **name** *(string) --*

      The upload's file name.

    - **created** *(datetime) --*

      When the upload was created.

    - **type** *(string) --*

      The upload's type.

      Must be one of the following values:

      * ANDROID_APP: An Android upload.

      * IOS_APP: An iOS upload.

      * WEB_APP: A web application upload.

      * EXTERNAL_DATA: An external data upload.

      * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.

      * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.

      * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.

      * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.

      * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.

      * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for web apps.

      * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for web
      apps.

      * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for web apps.

      * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for web apps.

      * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for web apps.

      * CALABASH_TEST_PACKAGE: A Calabash test package upload.

      * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.

      * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.

      * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.

      * XCTEST_TEST_PACKAGE: An Xcode test package upload.

      * XCTEST_UI_TEST_PACKAGE: An Xcode UI test package upload.

      * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.

      * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.

      * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.

      * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.

      * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.

      * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.

      * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.

      * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.

      * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.

      * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.

      * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.

      * XCTEST_UI_TEST_SPEC: An Xcode UI test spec upload.

    - **status** *(string) --*

      The upload's status.

      Must be one of the following values:

      * FAILED: A failed status.

      * INITIALIZED: An initialized status.

      * PROCESSING: A processing status.

      * SUCCEEDED: A succeeded status.

    - **url** *(string) --*

      The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT
      request.

    - **metadata** *(string) --*

      The upload's metadata. For example, for Android, this contains information that is parsed
      from the manifest and is displayed in the AWS Device Farm console after the associated app
      is uploaded.

    - **contentType** *(string) --*

      The upload's content type (for example, "application/octet-stream").

    - **message** *(string) --*

      A message about the upload's result.

    - **category** *(string) --*

      The upload's category. Allowed values include:

      * CURATED: An upload managed by AWS Device Farm.

      * PRIVATE: An upload managed by the AWS Device Farm customer.
    """


_ClientCreateUploadResponseTypeDef = TypedDict(
    "_ClientCreateUploadResponseTypeDef",
    {"upload": ClientCreateUploadResponseuploadTypeDef},
    total=False,
)


class ClientCreateUploadResponseTypeDef(_ClientCreateUploadResponseTypeDef):
    """
    Type definition for `ClientCreateUpload` `Response`

    Represents the result of a create upload request.

    - **upload** *(dict) --*

      The newly created upload.

      - **arn** *(string) --*

        The upload's ARN.

      - **name** *(string) --*

        The upload's file name.

      - **created** *(datetime) --*

        When the upload was created.

      - **type** *(string) --*

        The upload's type.

        Must be one of the following values:

        * ANDROID_APP: An Android upload.

        * IOS_APP: An iOS upload.

        * WEB_APP: A web application upload.

        * EXTERNAL_DATA: An external data upload.

        * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.

        * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.

        * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.

        * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.

        * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.

        * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for web apps.

        * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for web
        apps.

        * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for web apps.

        * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for web apps.

        * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for web apps.

        * CALABASH_TEST_PACKAGE: A Calabash test package upload.

        * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.

        * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.

        * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.

        * XCTEST_TEST_PACKAGE: An Xcode test package upload.

        * XCTEST_UI_TEST_PACKAGE: An Xcode UI test package upload.

        * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.

        * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.

        * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.

        * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.

        * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.

        * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.

        * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.

        * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.

        * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.

        * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.

        * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.

        * XCTEST_UI_TEST_SPEC: An Xcode UI test spec upload.

      - **status** *(string) --*

        The upload's status.

        Must be one of the following values:

        * FAILED: A failed status.

        * INITIALIZED: An initialized status.

        * PROCESSING: A processing status.

        * SUCCEEDED: A succeeded status.

      - **url** *(string) --*

        The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT
        request.

      - **metadata** *(string) --*

        The upload's metadata. For example, for Android, this contains information that is parsed
        from the manifest and is displayed in the AWS Device Farm console after the associated app
        is uploaded.

      - **contentType** *(string) --*

        The upload's content type (for example, "application/octet-stream").

      - **message** *(string) --*

        A message about the upload's result.

      - **category** *(string) --*

        The upload's category. Allowed values include:

        * CURATED: An upload managed by AWS Device Farm.

        * PRIVATE: An upload managed by the AWS Device Farm customer.
    """


_ClientCreateVpceConfigurationResponsevpceConfigurationTypeDef = TypedDict(
    "_ClientCreateVpceConfigurationResponsevpceConfigurationTypeDef",
    {
        "arn": str,
        "vpceConfigurationName": str,
        "vpceServiceName": str,
        "serviceDnsName": str,
        "vpceConfigurationDescription": str,
    },
    total=False,
)


class ClientCreateVpceConfigurationResponsevpceConfigurationTypeDef(
    _ClientCreateVpceConfigurationResponsevpceConfigurationTypeDef
):
    """
    Type definition for `ClientCreateVpceConfigurationResponse` `vpceConfiguration`

    An object containing information about your VPC endpoint configuration.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the VPC endpoint configuration.

    - **vpceConfigurationName** *(string) --*

      The friendly name you give to your VPC endpoint configuration, to manage your
      configurations more easily.

    - **vpceServiceName** *(string) --*

      The name of the VPC endpoint service running inside your AWS account that you want Device
      Farm to test.

    - **serviceDnsName** *(string) --*

      The DNS name that maps to the private IP address of the service you want to access.

    - **vpceConfigurationDescription** *(string) --*

      An optional description, providing more details about your VPC endpoint configuration.
    """


_ClientCreateVpceConfigurationResponseTypeDef = TypedDict(
    "_ClientCreateVpceConfigurationResponseTypeDef",
    {
        "vpceConfiguration": ClientCreateVpceConfigurationResponsevpceConfigurationTypeDef
    },
    total=False,
)


class ClientCreateVpceConfigurationResponseTypeDef(
    _ClientCreateVpceConfigurationResponseTypeDef
):
    """
    Type definition for `ClientCreateVpceConfiguration` `Response`

    - **vpceConfiguration** *(dict) --*

      An object containing information about your VPC endpoint configuration.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the VPC endpoint configuration.

      - **vpceConfigurationName** *(string) --*

        The friendly name you give to your VPC endpoint configuration, to manage your
        configurations more easily.

      - **vpceServiceName** *(string) --*

        The name of the VPC endpoint service running inside your AWS account that you want Device
        Farm to test.

      - **serviceDnsName** *(string) --*

        The DNS name that maps to the private IP address of the service you want to access.

      - **vpceConfigurationDescription** *(string) --*

        An optional description, providing more details about your VPC endpoint configuration.
    """


_ClientGetAccountSettingsResponseaccountSettingstrialMinutesTypeDef = TypedDict(
    "_ClientGetAccountSettingsResponseaccountSettingstrialMinutesTypeDef",
    {"total": float, "remaining": float},
    total=False,
)


class ClientGetAccountSettingsResponseaccountSettingstrialMinutesTypeDef(
    _ClientGetAccountSettingsResponseaccountSettingstrialMinutesTypeDef
):
    """
    Type definition for `ClientGetAccountSettingsResponseaccountSettings` `trialMinutes`

    Information about an AWS account's usage of free trial device minutes.

    - **total** *(float) --*

      The total number of free trial minutes that the account started with.

    - **remaining** *(float) --*

      The number of free trial minutes remaining in the account.
    """


_ClientGetAccountSettingsResponseaccountSettingsTypeDef = TypedDict(
    "_ClientGetAccountSettingsResponseaccountSettingsTypeDef",
    {
        "awsAccountNumber": str,
        "unmeteredDevices": Dict[str, int],
        "unmeteredRemoteAccessDevices": Dict[str, int],
        "maxJobTimeoutMinutes": int,
        "trialMinutes": ClientGetAccountSettingsResponseaccountSettingstrialMinutesTypeDef,
        "maxSlots": Dict[str, int],
        "defaultJobTimeoutMinutes": int,
        "skipAppResign": bool,
    },
    total=False,
)


class ClientGetAccountSettingsResponseaccountSettingsTypeDef(
    _ClientGetAccountSettingsResponseaccountSettingsTypeDef
):
    """
    Type definition for `ClientGetAccountSettingsResponse` `accountSettings`

    The account settings.

    - **awsAccountNumber** *(string) --*

      The AWS account number specified in the ``AccountSettings`` container.

    - **unmeteredDevices** *(dict) --*

      Returns the unmetered devices you have purchased or want to purchase.

      - *(string) --*

        - *(integer) --*

    - **unmeteredRemoteAccessDevices** *(dict) --*

      Returns the unmetered remote access devices you have purchased or want to purchase.

      - *(string) --*

        - *(integer) --*

    - **maxJobTimeoutMinutes** *(integer) --*

      The maximum number of minutes a test run will execute before it times out.

    - **trialMinutes** *(dict) --*

      Information about an AWS account's usage of free trial device minutes.

      - **total** *(float) --*

        The total number of free trial minutes that the account started with.

      - **remaining** *(float) --*

        The number of free trial minutes remaining in the account.

    - **maxSlots** *(dict) --*

      The maximum number of device slots that the AWS account can purchase. Each maximum is
      expressed as an ``offering-id:number`` pair, where the ``offering-id`` represents one of
      the IDs returned by the ``ListOfferings`` command.

      - *(string) --*

        - *(integer) --*

    - **defaultJobTimeoutMinutes** *(integer) --*

      The default number of minutes (at the account level) a test run will execute before it
      times out. The default value is 150 minutes.

    - **skipAppResign** *(boolean) --*

      When set to ``true`` , for private devices, Device Farm will not sign your app again. For
      public devices, Device Farm always signs your apps again and this parameter has no effect.

      For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
      <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .
    """


_ClientGetAccountSettingsResponseTypeDef = TypedDict(
    "_ClientGetAccountSettingsResponseTypeDef",
    {"accountSettings": ClientGetAccountSettingsResponseaccountSettingsTypeDef},
    total=False,
)


class ClientGetAccountSettingsResponseTypeDef(_ClientGetAccountSettingsResponseTypeDef):
    """
    Type definition for `ClientGetAccountSettings` `Response`

    Represents the account settings return values from the ``GetAccountSettings`` request.

    - **accountSettings** *(dict) --*

      The account settings.

      - **awsAccountNumber** *(string) --*

        The AWS account number specified in the ``AccountSettings`` container.

      - **unmeteredDevices** *(dict) --*

        Returns the unmetered devices you have purchased or want to purchase.

        - *(string) --*

          - *(integer) --*

      - **unmeteredRemoteAccessDevices** *(dict) --*

        Returns the unmetered remote access devices you have purchased or want to purchase.

        - *(string) --*

          - *(integer) --*

      - **maxJobTimeoutMinutes** *(integer) --*

        The maximum number of minutes a test run will execute before it times out.

      - **trialMinutes** *(dict) --*

        Information about an AWS account's usage of free trial device minutes.

        - **total** *(float) --*

          The total number of free trial minutes that the account started with.

        - **remaining** *(float) --*

          The number of free trial minutes remaining in the account.

      - **maxSlots** *(dict) --*

        The maximum number of device slots that the AWS account can purchase. Each maximum is
        expressed as an ``offering-id:number`` pair, where the ``offering-id`` represents one of
        the IDs returned by the ``ListOfferings`` command.

        - *(string) --*

          - *(integer) --*

      - **defaultJobTimeoutMinutes** *(integer) --*

        The default number of minutes (at the account level) a test run will execute before it
        times out. The default value is 150 minutes.

      - **skipAppResign** *(boolean) --*

        When set to ``true`` , for private devices, Device Farm will not sign your app again. For
        public devices, Device Farm always signs your apps again and this parameter has no effect.

        For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
        <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .
    """


_ClientGetDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef = TypedDict(
    "_ClientGetDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientGetDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef(
    _ClientGetDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef
):
    """
    Type definition for `ClientGetDeviceInstanceResponsedeviceInstance` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The default
      value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned up
      from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The default
      value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientGetDeviceInstanceResponsedeviceInstanceTypeDef = TypedDict(
    "_ClientGetDeviceInstanceResponsedeviceInstanceTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientGetDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef,
    },
    total=False,
)


class ClientGetDeviceInstanceResponsedeviceInstanceTypeDef(
    _ClientGetDeviceInstanceResponsedeviceInstanceTypeDef
):
    """
    Type definition for `ClientGetDeviceInstanceResponse` `deviceInstance`

    An object containing information about your device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The default
        value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned up
        from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The default
        value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientGetDeviceInstanceResponseTypeDef = TypedDict(
    "_ClientGetDeviceInstanceResponseTypeDef",
    {"deviceInstance": ClientGetDeviceInstanceResponsedeviceInstanceTypeDef},
    total=False,
)


class ClientGetDeviceInstanceResponseTypeDef(_ClientGetDeviceInstanceResponseTypeDef):
    """
    Type definition for `ClientGetDeviceInstance` `Response`

    - **deviceInstance** *(dict) --*

      An object containing information about your device instance.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the device instance.

      - **deviceArn** *(string) --*

        The Amazon Resource Name (ARN) of the device.

      - **labels** *(list) --*

        An array of strings describing the device instance.

        - *(string) --*

      - **status** *(string) --*

        The status of the device instance. Valid values are listed below.

      - **udid** *(string) --*

        Unique device identifier for the device instance.

      - **instanceProfile** *(dict) --*

        A object containing information about the instance profile.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the instance profile.

        - **packageCleanup** *(boolean) --*

          When set to ``true`` , Device Farm will remove app packages after a test run. The default
          value is ``false`` for private devices.

        - **excludeAppPackagesFromCleanup** *(list) --*

          An array of strings specifying the list of app packages that should not be cleaned up
          from the device after a test run is over.

          The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

          - *(string) --*

        - **rebootAfterUse** *(boolean) --*

          When set to ``true`` , Device Farm will reboot the instance after a test run. The default
          value is ``true`` .

        - **name** *(string) --*

          The name of the instance profile.

        - **description** *(string) --*

          The description of the instance profile.
    """


_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdevicecpuTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdevicecpuTypeDef(
    _ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdevicecpuTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesinstanceProfileTypeDef(
    _ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be
      cleaned up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true``
      .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesTypeDef(
    _ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be
        cleaned up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true``
        .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceresolutionTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceresolutionTypeDef(
    _ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceresolutionTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdevicecpuTypeDef,
        "resolution": ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[
            ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceinstancesTypeDef
        ],
        "availability": str,
    },
    total=False,
)


class ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceTypeDef(
    _ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponsecompatibleDevices` `device`

    The device (phone or tablet) that you wish to return information about.

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be
            cleaned up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true``
            .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently
      available in the ListDevices and GetDevice API methods.
    """


_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesincompatibilityMessagesTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesincompatibilityMessagesTypeDef",
    {"message": str, "type": str},
    total=False,
)


class ClientGetDevicePoolCompatibilityResponsecompatibleDevicesincompatibilityMessagesTypeDef(
    _ClientGetDevicePoolCompatibilityResponsecompatibleDevicesincompatibilityMessagesTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponsecompatibleDevices` `incompatibilityMessages`

    Represents information about incompatibility.

    - **message** *(string) --*

      A message about the incompatibility.

    - **type** *(string) --*

      The type of incompatibility.

      Allowed values include:

      * ARN: The ARN.

      * FORM_FACTOR: The form factor (for example, phone or tablet).

      * MANUFACTURER: The manufacturer.

      * PLATFORM: The platform (for example, Android or iOS).

      * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.

      * APPIUM_VERSION: The Appium version for the test.
    """


_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponsecompatibleDevicesTypeDef",
    {
        "device": ClientGetDevicePoolCompatibilityResponsecompatibleDevicesdeviceTypeDef,
        "compatible": bool,
        "incompatibilityMessages": List[
            ClientGetDevicePoolCompatibilityResponsecompatibleDevicesincompatibilityMessagesTypeDef
        ],
    },
    total=False,
)


class ClientGetDevicePoolCompatibilityResponsecompatibleDevicesTypeDef(
    _ClientGetDevicePoolCompatibilityResponsecompatibleDevicesTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponse` `compatibleDevices`

    Represents a device pool compatibility result.

    - **device** *(dict) --*

      The device (phone or tablet) that you wish to return information about.

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
          CPU is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type are
        PRIVATE and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test run. The
              default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not be
              cleaned up from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to ``true``
              .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test run. The
              default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently
        available in the ListDevices and GetDevice API methods.

    - **compatible** *(boolean) --*

      Whether the result was compatible with the device pool.

    - **incompatibilityMessages** *(list) --*

      Information about the compatibility.

      - *(dict) --*

        Represents information about incompatibility.

        - **message** *(string) --*

          A message about the incompatibility.

        - **type** *(string) --*

          The type of incompatibility.

          Allowed values include:

          * ARN: The ARN.

          * FORM_FACTOR: The form factor (for example, phone or tablet).

          * MANUFACTURER: The manufacturer.

          * PLATFORM: The platform (for example, Android or iOS).

          * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.

          * APPIUM_VERSION: The Appium version for the test.
    """


_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdevicecpuTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdevicecpuTypeDef(
    _ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdevicecpuTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesinstanceProfileTypeDef(
    _ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be
      cleaned up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true``
      .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesTypeDef(
    _ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be
        cleaned up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true``
        .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceresolutionTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceresolutionTypeDef(
    _ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceresolutionTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdevicecpuTypeDef,
        "resolution": ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[
            ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceinstancesTypeDef
        ],
        "availability": str,
    },
    total=False,
)


class ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceTypeDef(
    _ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponseincompatibleDevices` `device`

    The device (phone or tablet) that you wish to return information about.

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be
            cleaned up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true``
            .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently
      available in the ListDevices and GetDevice API methods.
    """


_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesincompatibilityMessagesTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesincompatibilityMessagesTypeDef",
    {"message": str, "type": str},
    total=False,
)


class ClientGetDevicePoolCompatibilityResponseincompatibleDevicesincompatibilityMessagesTypeDef(
    _ClientGetDevicePoolCompatibilityResponseincompatibleDevicesincompatibilityMessagesTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponseincompatibleDevices` `incompatibilityMessages`

    Represents information about incompatibility.

    - **message** *(string) --*

      A message about the incompatibility.

    - **type** *(string) --*

      The type of incompatibility.

      Allowed values include:

      * ARN: The ARN.

      * FORM_FACTOR: The form factor (for example, phone or tablet).

      * MANUFACTURER: The manufacturer.

      * PLATFORM: The platform (for example, Android or iOS).

      * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.

      * APPIUM_VERSION: The Appium version for the test.
    """


_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponseincompatibleDevicesTypeDef",
    {
        "device": ClientGetDevicePoolCompatibilityResponseincompatibleDevicesdeviceTypeDef,
        "compatible": bool,
        "incompatibilityMessages": List[
            ClientGetDevicePoolCompatibilityResponseincompatibleDevicesincompatibilityMessagesTypeDef
        ],
    },
    total=False,
)


class ClientGetDevicePoolCompatibilityResponseincompatibleDevicesTypeDef(
    _ClientGetDevicePoolCompatibilityResponseincompatibleDevicesTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityResponse` `incompatibleDevices`

    Represents a device pool compatibility result.

    - **device** *(dict) --*

      The device (phone or tablet) that you wish to return information about.

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
          CPU is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type are
        PRIVATE and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test run. The
              default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not be
              cleaned up from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to ``true``
              .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test run. The
              default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently
        available in the ListDevices and GetDevice API methods.

    - **compatible** *(boolean) --*

      Whether the result was compatible with the device pool.

    - **incompatibilityMessages** *(list) --*

      Information about the compatibility.

      - *(dict) --*

        Represents information about incompatibility.

        - **message** *(string) --*

          A message about the incompatibility.

        - **type** *(string) --*

          The type of incompatibility.

          Allowed values include:

          * ARN: The ARN.

          * FORM_FACTOR: The form factor (for example, phone or tablet).

          * MANUFACTURER: The manufacturer.

          * PLATFORM: The platform (for example, Android or iOS).

          * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.

          * APPIUM_VERSION: The Appium version for the test.
    """


_ClientGetDevicePoolCompatibilityResponseTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityResponseTypeDef",
    {
        "compatibleDevices": List[
            ClientGetDevicePoolCompatibilityResponsecompatibleDevicesTypeDef
        ],
        "incompatibleDevices": List[
            ClientGetDevicePoolCompatibilityResponseincompatibleDevicesTypeDef
        ],
    },
    total=False,
)


class ClientGetDevicePoolCompatibilityResponseTypeDef(
    _ClientGetDevicePoolCompatibilityResponseTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibility` `Response`

    Represents the result of describe device pool compatibility request.

    - **compatibleDevices** *(list) --*

      Information about compatible devices.

      - *(dict) --*

        Represents a device pool compatibility result.

        - **device** *(dict) --*

          The device (phone or tablet) that you wish to return information about.

          - **arn** *(string) --*

            The device's ARN.

          - **name** *(string) --*

            The device's display name.

          - **manufacturer** *(string) --*

            The device's manufacturer name.

          - **model** *(string) --*

            The device's model name.

          - **modelId** *(string) --*

            The device's model ID.

          - **formFactor** *(string) --*

            The device's form factor.

            Allowed values include:

            * PHONE: The phone form factor.

            * TABLET: The tablet form factor.

          - **platform** *(string) --*

            The device's platform.

            Allowed values include:

            * ANDROID: The Android platform.

            * IOS: The iOS platform.

          - **os** *(string) --*

            The device's operating system type.

          - **cpu** *(dict) --*

            Information about the device's CPU.

            - **frequency** *(string) --*

              The CPU's frequency.

            - **architecture** *(string) --*

              The CPU's architecture, for example x86 or ARM.

            - **clock** *(float) --*

              The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
              CPU is expressed as 1200000000.

          - **resolution** *(dict) --*

            The resolution of the device.

            - **width** *(integer) --*

              The screen resolution's width, expressed in pixels.

            - **height** *(integer) --*

              The screen resolution's height, expressed in pixels.

          - **heapSize** *(integer) --*

            The device's heap size, expressed in bytes.

          - **memory** *(integer) --*

            The device's total memory size, expressed in bytes.

          - **image** *(string) --*

            The device's image name.

          - **carrier** *(string) --*

            The device's carrier.

          - **radio** *(string) --*

            The device's radio.

          - **remoteAccessEnabled** *(boolean) --*

            Specifies whether remote access has been enabled for the specified device.

          - **remoteDebugEnabled** *(boolean) --*

            This flag is set to ``true`` if remote debugging is enabled for the device.

             *Remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

          - **fleetType** *(string) --*

            The type of fleet to which this device belongs. Possible values for fleet type are
            PRIVATE and PUBLIC.

          - **fleetName** *(string) --*

            The name of the fleet to which this device belongs.

          - **instances** *(list) --*

            The instances belonging to this device.

            - *(dict) --*

              Represents the device instance.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the device instance.

              - **deviceArn** *(string) --*

                The Amazon Resource Name (ARN) of the device.

              - **labels** *(list) --*

                An array of strings describing the device instance.

                - *(string) --*

              - **status** *(string) --*

                The status of the device instance. Valid values are listed below.

              - **udid** *(string) --*

                Unique device identifier for the device instance.

              - **instanceProfile** *(dict) --*

                A object containing information about the instance profile.

                - **arn** *(string) --*

                  The Amazon Resource Name (ARN) of the instance profile.

                - **packageCleanup** *(boolean) --*

                  When set to ``true`` , Device Farm will remove app packages after a test run. The
                  default value is ``false`` for private devices.

                - **excludeAppPackagesFromCleanup** *(list) --*

                  An array of strings specifying the list of app packages that should not be
                  cleaned up from the device after a test run is over.

                  The list of packages is only considered if you set ``packageCleanup`` to ``true``
                  .

                  - *(string) --*

                - **rebootAfterUse** *(boolean) --*

                  When set to ``true`` , Device Farm will reboot the instance after a test run. The
                  default value is ``true`` .

                - **name** *(string) --*

                  The name of the instance profile.

                - **description** *(string) --*

                  The description of the instance profile.

          - **availability** *(string) --*

            Reflects how likely a device will be available for a test run. It is currently
            available in the ListDevices and GetDevice API methods.

        - **compatible** *(boolean) --*

          Whether the result was compatible with the device pool.

        - **incompatibilityMessages** *(list) --*

          Information about the compatibility.

          - *(dict) --*

            Represents information about incompatibility.

            - **message** *(string) --*

              A message about the incompatibility.

            - **type** *(string) --*

              The type of incompatibility.

              Allowed values include:

              * ARN: The ARN.

              * FORM_FACTOR: The form factor (for example, phone or tablet).

              * MANUFACTURER: The manufacturer.

              * PLATFORM: The platform (for example, Android or iOS).

              * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.

              * APPIUM_VERSION: The Appium version for the test.

    - **incompatibleDevices** *(list) --*

      Information about incompatible devices.

      - *(dict) --*

        Represents a device pool compatibility result.

        - **device** *(dict) --*

          The device (phone or tablet) that you wish to return information about.

          - **arn** *(string) --*

            The device's ARN.

          - **name** *(string) --*

            The device's display name.

          - **manufacturer** *(string) --*

            The device's manufacturer name.

          - **model** *(string) --*

            The device's model name.

          - **modelId** *(string) --*

            The device's model ID.

          - **formFactor** *(string) --*

            The device's form factor.

            Allowed values include:

            * PHONE: The phone form factor.

            * TABLET: The tablet form factor.

          - **platform** *(string) --*

            The device's platform.

            Allowed values include:

            * ANDROID: The Android platform.

            * IOS: The iOS platform.

          - **os** *(string) --*

            The device's operating system type.

          - **cpu** *(dict) --*

            Information about the device's CPU.

            - **frequency** *(string) --*

              The CPU's frequency.

            - **architecture** *(string) --*

              The CPU's architecture, for example x86 or ARM.

            - **clock** *(float) --*

              The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
              CPU is expressed as 1200000000.

          - **resolution** *(dict) --*

            The resolution of the device.

            - **width** *(integer) --*

              The screen resolution's width, expressed in pixels.

            - **height** *(integer) --*

              The screen resolution's height, expressed in pixels.

          - **heapSize** *(integer) --*

            The device's heap size, expressed in bytes.

          - **memory** *(integer) --*

            The device's total memory size, expressed in bytes.

          - **image** *(string) --*

            The device's image name.

          - **carrier** *(string) --*

            The device's carrier.

          - **radio** *(string) --*

            The device's radio.

          - **remoteAccessEnabled** *(boolean) --*

            Specifies whether remote access has been enabled for the specified device.

          - **remoteDebugEnabled** *(boolean) --*

            This flag is set to ``true`` if remote debugging is enabled for the device.

             *Remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

          - **fleetType** *(string) --*

            The type of fleet to which this device belongs. Possible values for fleet type are
            PRIVATE and PUBLIC.

          - **fleetName** *(string) --*

            The name of the fleet to which this device belongs.

          - **instances** *(list) --*

            The instances belonging to this device.

            - *(dict) --*

              Represents the device instance.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the device instance.

              - **deviceArn** *(string) --*

                The Amazon Resource Name (ARN) of the device.

              - **labels** *(list) --*

                An array of strings describing the device instance.

                - *(string) --*

              - **status** *(string) --*

                The status of the device instance. Valid values are listed below.

              - **udid** *(string) --*

                Unique device identifier for the device instance.

              - **instanceProfile** *(dict) --*

                A object containing information about the instance profile.

                - **arn** *(string) --*

                  The Amazon Resource Name (ARN) of the instance profile.

                - **packageCleanup** *(boolean) --*

                  When set to ``true`` , Device Farm will remove app packages after a test run. The
                  default value is ``false`` for private devices.

                - **excludeAppPackagesFromCleanup** *(list) --*

                  An array of strings specifying the list of app packages that should not be
                  cleaned up from the device after a test run is over.

                  The list of packages is only considered if you set ``packageCleanup`` to ``true``
                  .

                  - *(string) --*

                - **rebootAfterUse** *(boolean) --*

                  When set to ``true`` , Device Farm will reboot the instance after a test run. The
                  default value is ``true`` .

                - **name** *(string) --*

                  The name of the instance profile.

                - **description** *(string) --*

                  The description of the instance profile.

          - **availability** *(string) --*

            Reflects how likely a device will be available for a test run. It is currently
            available in the ListDevices and GetDevice API methods.

        - **compatible** *(boolean) --*

          Whether the result was compatible with the device pool.

        - **incompatibilityMessages** *(list) --*

          Information about the compatibility.

          - *(dict) --*

            Represents information about incompatibility.

            - **message** *(string) --*

              A message about the incompatibility.

            - **type** *(string) --*

              The type of incompatibility.

              Allowed values include:

              * ARN: The ARN.

              * FORM_FACTOR: The form factor (for example, phone or tablet).

              * MANUFACTURER: The manufacturer.

              * PLATFORM: The platform (for example, Android or iOS).

              * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access.

              * APPIUM_VERSION: The Appium version for the test.
    """


_ClientGetDevicePoolCompatibilityconfigurationcustomerArtifactPathsTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityconfigurationcustomerArtifactPathsTypeDef",
    {"iosPaths": List[str], "androidPaths": List[str], "deviceHostPaths": List[str]},
    total=False,
)


class ClientGetDevicePoolCompatibilityconfigurationcustomerArtifactPathsTypeDef(
    _ClientGetDevicePoolCompatibilityconfigurationcustomerArtifactPathsTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityconfiguration` `customerArtifactPaths`

    Input ``CustomerArtifactPaths`` object for the scheduled run configuration.

    - **iosPaths** *(list) --*

      Comma-separated list of paths on the iOS device where the artifacts generated by the
      customer's tests will be pulled from.

      - *(string) --*

    - **androidPaths** *(list) --*

      Comma-separated list of paths on the Android device where the artifacts generated by the
      customer's tests will be pulled from.

      - *(string) --*

    - **deviceHostPaths** *(list) --*

      Comma-separated list of paths in the test execution environment where the artifacts generated
      by the customer's tests will be pulled from.

      - *(string) --*
    """


_ClientGetDevicePoolCompatibilityconfigurationlocationTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityconfigurationlocationTypeDef",
    {"latitude": float, "longitude": float},
)


class ClientGetDevicePoolCompatibilityconfigurationlocationTypeDef(
    _ClientGetDevicePoolCompatibilityconfigurationlocationTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityconfiguration` `location`

    Information about the location that is used for the run.

    - **latitude** *(float) --* **[REQUIRED]**

      The latitude.

    - **longitude** *(float) --* **[REQUIRED]**

      The longitude.
    """


_ClientGetDevicePoolCompatibilityconfigurationradiosTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityconfigurationradiosTypeDef",
    {"wifi": bool, "bluetooth": bool, "nfc": bool, "gps": bool},
    total=False,
)


class ClientGetDevicePoolCompatibilityconfigurationradiosTypeDef(
    _ClientGetDevicePoolCompatibilityconfigurationradiosTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibilityconfiguration` `radios`

    Information about the radio states for the run.

    - **wifi** *(boolean) --*

      True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

    - **bluetooth** *(boolean) --*

      True if Bluetooth is enabled at the beginning of the test; otherwise, false.

    - **nfc** *(boolean) --*

      True if NFC is enabled at the beginning of the test; otherwise, false.

    - **gps** *(boolean) --*

      True if GPS is enabled at the beginning of the test; otherwise, false.
    """


_ClientGetDevicePoolCompatibilityconfigurationTypeDef = TypedDict(
    "_ClientGetDevicePoolCompatibilityconfigurationTypeDef",
    {
        "extraDataPackageArn": str,
        "networkProfileArn": str,
        "locale": str,
        "location": ClientGetDevicePoolCompatibilityconfigurationlocationTypeDef,
        "vpceConfigurationArns": List[str],
        "customerArtifactPaths": ClientGetDevicePoolCompatibilityconfigurationcustomerArtifactPathsTypeDef,
        "radios": ClientGetDevicePoolCompatibilityconfigurationradiosTypeDef,
        "auxiliaryApps": List[str],
        "billingMethod": str,
    },
    total=False,
)


class ClientGetDevicePoolCompatibilityconfigurationTypeDef(
    _ClientGetDevicePoolCompatibilityconfigurationTypeDef
):
    """
    Type definition for `ClientGetDevicePoolCompatibility` `configuration`

    An object containing information about the settings for a run.

    - **extraDataPackageArn** *(string) --*

      The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will
      extract to external data for Android or the app's sandbox for iOS.

    - **networkProfileArn** *(string) --*

      Reserved for internal use.

    - **locale** *(string) --*

      Information about the locale that is used for the run.

    - **location** *(dict) --*

      Information about the location that is used for the run.

      - **latitude** *(float) --* **[REQUIRED]**

        The latitude.

      - **longitude** *(float) --* **[REQUIRED]**

        The longitude.

    - **vpceConfigurationArns** *(list) --*

      An array of Amazon Resource Names (ARNs) for your VPC endpoint configurations.

      - *(string) --*

    - **customerArtifactPaths** *(dict) --*

      Input ``CustomerArtifactPaths`` object for the scheduled run configuration.

      - **iosPaths** *(list) --*

        Comma-separated list of paths on the iOS device where the artifacts generated by the
        customer's tests will be pulled from.

        - *(string) --*

      - **androidPaths** *(list) --*

        Comma-separated list of paths on the Android device where the artifacts generated by the
        customer's tests will be pulled from.

        - *(string) --*

      - **deviceHostPaths** *(list) --*

        Comma-separated list of paths in the test execution environment where the artifacts generated
        by the customer's tests will be pulled from.

        - *(string) --*

    - **radios** *(dict) --*

      Information about the radio states for the run.

      - **wifi** *(boolean) --*

        True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

      - **bluetooth** *(boolean) --*

        True if Bluetooth is enabled at the beginning of the test; otherwise, false.

      - **nfc** *(boolean) --*

        True if NFC is enabled at the beginning of the test; otherwise, false.

      - **gps** *(boolean) --*

        True if GPS is enabled at the beginning of the test; otherwise, false.

    - **auxiliaryApps** *(list) --*

      A list of Upload ARNs for app packages that will be installed alongside your app.

      - *(string) --*

    - **billingMethod** *(string) --*

      Specifies the billing method for a test run: ``metered`` or ``unmetered`` . If the parameter is
      not specified, the default value is ``metered`` .
    """


_RequiredClientGetDevicePoolCompatibilitytestTypeDef = TypedDict(
    "_RequiredClientGetDevicePoolCompatibilitytestTypeDef", {"type": str}
)
_OptionalClientGetDevicePoolCompatibilitytestTypeDef = TypedDict(
    "_OptionalClientGetDevicePoolCompatibilitytestTypeDef",
    {
        "testPackageArn": str,
        "testSpecArn": str,
        "filter": str,
        "parameters": Dict[str, str],
    },
    total=False,
)


class ClientGetDevicePoolCompatibilitytestTypeDef(
    _RequiredClientGetDevicePoolCompatibilitytestTypeDef,
    _OptionalClientGetDevicePoolCompatibilitytestTypeDef,
):
    """
    Type definition for `ClientGetDevicePoolCompatibility` `test`

    Information about the uploaded test to be run against the device pool.

    - **type** *(string) --* **[REQUIRED]**

      The test's type.

      Must be one of the following values:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting
      with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **testPackageArn** *(string) --*

      The ARN of the uploaded test that will be run.

    - **testSpecArn** *(string) --*

      The ARN of the YAML-formatted test specification.

    - **filter** *(string) --*

      The test's filter.

    - **parameters** *(dict) --*

      The test's parameters, such as test framework parameters and fixture settings. Parameters are
      represented by name-value pairs of strings.

      For all tests:

      * app_performance_monitoring: Performance monitoring is enabled by default. Set this parameter
      to "false" to disable it.

      For Calabash tests:

      * profile: A cucumber profile, for example, "my_profile_name".

      * tags: You can limit execution to features or scenarios that have (or don't have) certain
      tags, for example, "@smoke" or "@smoke,~@wip".

      For Appium tests (all types):

      * appium_version: The Appium version. Currently supported values are "1.6.5" (and higher),
      "latest", and "default".

        * “latest” will run the latest Appium version supported by Device Farm (1.9.1).

        * For “default”, Device Farm will choose a compatible version of Appium for the device. The
        current behavior is to run 1.7.2 on Android devices and iOS 9 and earlier, 1.7.2 for iOS 10
        and later.

        * This behavior is subject to change.

      For Fuzz tests (Android only):

      * event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.

      * throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between
      events.

      * seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests
      ensures identical event sequences.

      For Explorer tests:

      * username: A username to use if the Explorer encounters a login form. If not supplied, no
      username will be inserted.

      * password: A password to use if the Explorer encounters a login form. If not supplied, no
      password will be inserted.

      For Instrumentation:

      * filter: A test filter string. Examples:

        * Running a single test case: "com.android.abc.Test1"

        * Running a single test: "com.android.abc.Test1#smoke"

        * Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"

      For XCTest and XCTestUI:

      * filter: A test filter string. Examples:

        * Running a single test class: "LoginTests"

        * Running a multiple test classes: "LoginTests,SmokeTests"

        * Running a single test: "LoginTests/testValid"

        * Running multiple tests: "LoginTests/testValid,LoginTests/testInvalid"

      For UIAutomator:

      * filter: A test filter string. Examples:

        * Running a single test case: "com.android.abc.Test1"

        * Running a single test: "com.android.abc.Test1#smoke"

        * Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"

      - *(string) --*

        - *(string) --*
    """


_ClientGetDevicePoolResponsedevicePoolrulesTypeDef = TypedDict(
    "_ClientGetDevicePoolResponsedevicePoolrulesTypeDef",
    {"attribute": str, "operator": str, "value": str},
    total=False,
)


class ClientGetDevicePoolResponsedevicePoolrulesTypeDef(
    _ClientGetDevicePoolResponsedevicePoolrulesTypeDef
):
    """
    Type definition for `ClientGetDevicePoolResponsedevicePool` `rules`

    Represents a condition for a device pool.

    - **attribute** *(string) --*

      The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

      The supported operators for each attribute are provided in the following list.

        APPIUM_VERSION

      The Appium version for the test.

       *Supported operators* : ``CONTAINS``

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE",
      "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        MODEL

      The device model, such as "Apple iPad Air 2" or "Google Pixel".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
       ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

      Whether the device is enabled for remote debugging. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **operator** *(string) --*

      Specifies how Device Farm compares the rule's attribute to the value. For the operators
      that are supported by each attribute, see the attribute descriptions.

    - **value** *(string) --*

      The rule's value.
    """


_ClientGetDevicePoolResponsedevicePoolTypeDef = TypedDict(
    "_ClientGetDevicePoolResponsedevicePoolTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "rules": List[ClientGetDevicePoolResponsedevicePoolrulesTypeDef],
        "maxDevices": int,
    },
    total=False,
)


class ClientGetDevicePoolResponsedevicePoolTypeDef(
    _ClientGetDevicePoolResponsedevicePoolTypeDef
):
    """
    Type definition for `ClientGetDevicePoolResponse` `devicePool`

    An object containing information about the requested device pool.

    - **arn** *(string) --*

      The device pool's ARN.

    - **name** *(string) --*

      The device pool's name.

    - **description** *(string) --*

      The device pool's description.

    - **type** *(string) --*

      The device pool's type.

      Allowed values include:

      * CURATED: A device pool that is created and managed by AWS Device Farm.

      * PRIVATE: A device pool that is created and managed by the device pool developer.

    - **rules** *(list) --*

      Information about the device pool's rules.

      - *(dict) --*

        Represents a condition for a device pool.

        - **attribute** *(string) --*

          The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

          The supported operators for each attribute are provided in the following list.

            APPIUM_VERSION

          The Appium version for the test.

           *Supported operators* : ``CONTAINS``

            ARN

          The Amazon Resource Name (ARN) of the device. For example,
          "arn:aws:devicefarm:us-west-2::device:12345Example".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            AVAILABILITY

          The current availability of the device. Valid values are "AVAILABLE",
          "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

           *Supported operators* : ``EQUALS``

            FLEET_TYPE

          The fleet type. Valid values are "PUBLIC" or "PRIVATE".

           *Supported operators* : ``EQUALS``

            FORM_FACTOR

          The device form factor. Valid values are "PHONE" or "TABLET".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            INSTANCE_ARN

          The Amazon Resource Name (ARN) of the device instance.

           *Supported operators* : ``IN`` , ``NOT_IN``

            INSTANCE_LABELS

          The label of the device instance.

           *Supported operators* : ``CONTAINS``

            MANUFACTURER

          The device manufacturer. For example, "Apple".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            MODEL

          The device model, such as "Apple iPad Air 2" or "Google Pixel".

           *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

            OS_VERSION

          The operating system version. For example, "10.3.2".

           *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
           ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

            PLATFORM

          The device platform. Valid values are "ANDROID" or "IOS".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            REMOTE_ACCESS_ENABLED

          Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

            REMOTE_DEBUG_ENABLED

          Whether the device is enabled for remote debugging. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

           *This filter will be ignored, as remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **operator** *(string) --*

          Specifies how Device Farm compares the rule's attribute to the value. For the operators
          that are supported by each attribute, see the attribute descriptions.

        - **value** *(string) --*

          The rule's value.

    - **maxDevices** *(integer) --*

      The number of devices that Device Farm can add to your device pool. Device Farm adds
      devices that are available and that meet the criteria that you assign for the ``rules``
      parameter. Depending on how many devices meet these constraints, your device pool might
      contain fewer devices than the value for this parameter.

      By specifying the maximum number of devices, you can control the costs that you incur by
      running tests.
    """


_ClientGetDevicePoolResponseTypeDef = TypedDict(
    "_ClientGetDevicePoolResponseTypeDef",
    {"devicePool": ClientGetDevicePoolResponsedevicePoolTypeDef},
    total=False,
)


class ClientGetDevicePoolResponseTypeDef(_ClientGetDevicePoolResponseTypeDef):
    """
    Type definition for `ClientGetDevicePool` `Response`

    Represents the result of a get device pool request.

    - **devicePool** *(dict) --*

      An object containing information about the requested device pool.

      - **arn** *(string) --*

        The device pool's ARN.

      - **name** *(string) --*

        The device pool's name.

      - **description** *(string) --*

        The device pool's description.

      - **type** *(string) --*

        The device pool's type.

        Allowed values include:

        * CURATED: A device pool that is created and managed by AWS Device Farm.

        * PRIVATE: A device pool that is created and managed by the device pool developer.

      - **rules** *(list) --*

        Information about the device pool's rules.

        - *(dict) --*

          Represents a condition for a device pool.

          - **attribute** *(string) --*

            The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

            The supported operators for each attribute are provided in the following list.

              APPIUM_VERSION

            The Appium version for the test.

             *Supported operators* : ``CONTAINS``

              ARN

            The Amazon Resource Name (ARN) of the device. For example,
            "arn:aws:devicefarm:us-west-2::device:12345Example".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              AVAILABILITY

            The current availability of the device. Valid values are "AVAILABLE",
            "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

             *Supported operators* : ``EQUALS``

              FLEET_TYPE

            The fleet type. Valid values are "PUBLIC" or "PRIVATE".

             *Supported operators* : ``EQUALS``

              FORM_FACTOR

            The device form factor. Valid values are "PHONE" or "TABLET".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              INSTANCE_ARN

            The Amazon Resource Name (ARN) of the device instance.

             *Supported operators* : ``IN`` , ``NOT_IN``

              INSTANCE_LABELS

            The label of the device instance.

             *Supported operators* : ``CONTAINS``

              MANUFACTURER

            The device manufacturer. For example, "Apple".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              MODEL

            The device model, such as "Apple iPad Air 2" or "Google Pixel".

             *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

              OS_VERSION

            The operating system version. For example, "10.3.2".

             *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
             ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

              PLATFORM

            The device platform. Valid values are "ANDROID" or "IOS".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              REMOTE_ACCESS_ENABLED

            Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

              REMOTE_DEBUG_ENABLED

            Whether the device is enabled for remote debugging. Valid values are "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

             *This filter will be ignored, as remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

          - **operator** *(string) --*

            Specifies how Device Farm compares the rule's attribute to the value. For the operators
            that are supported by each attribute, see the attribute descriptions.

          - **value** *(string) --*

            The rule's value.

      - **maxDevices** *(integer) --*

        The number of devices that Device Farm can add to your device pool. Device Farm adds
        devices that are available and that meet the criteria that you assign for the ``rules``
        parameter. Depending on how many devices meet these constraints, your device pool might
        contain fewer devices than the value for this parameter.

        By specifying the maximum number of devices, you can control the costs that you incur by
        running tests.
    """


_ClientGetDeviceResponsedevicecpuTypeDef = TypedDict(
    "_ClientGetDeviceResponsedevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientGetDeviceResponsedevicecpuTypeDef(_ClientGetDeviceResponsedevicecpuTypeDef):
    """
    Type definition for `ClientGetDeviceResponsedevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU
      is expressed as 1200000000.
    """


_ClientGetDeviceResponsedeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientGetDeviceResponsedeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientGetDeviceResponsedeviceinstancesinstanceProfileTypeDef(
    _ClientGetDeviceResponsedeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientGetDeviceResponsedeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned up
      from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientGetDeviceResponsedeviceinstancesTypeDef = TypedDict(
    "_ClientGetDeviceResponsedeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientGetDeviceResponsedeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientGetDeviceResponsedeviceinstancesTypeDef(
    _ClientGetDeviceResponsedeviceinstancesTypeDef
):
    """
    Type definition for `ClientGetDeviceResponsedevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned up
        from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientGetDeviceResponsedeviceresolutionTypeDef = TypedDict(
    "_ClientGetDeviceResponsedeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientGetDeviceResponsedeviceresolutionTypeDef(
    _ClientGetDeviceResponsedeviceresolutionTypeDef
):
    """
    Type definition for `ClientGetDeviceResponsedevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientGetDeviceResponsedeviceTypeDef = TypedDict(
    "_ClientGetDeviceResponsedeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientGetDeviceResponsedevicecpuTypeDef,
        "resolution": ClientGetDeviceResponsedeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[ClientGetDeviceResponsedeviceinstancesTypeDef],
        "availability": str,
    },
    total=False,
)


class ClientGetDeviceResponsedeviceTypeDef(_ClientGetDeviceResponsedeviceTypeDef):
    """
    Type definition for `ClientGetDeviceResponse` `device`

    An object containing information about the requested device.

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU
        is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are PRIVATE
      and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be cleaned up
            from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently available in
      the ListDevices and GetDevice API methods.
    """


_ClientGetDeviceResponseTypeDef = TypedDict(
    "_ClientGetDeviceResponseTypeDef",
    {"device": ClientGetDeviceResponsedeviceTypeDef},
    total=False,
)


class ClientGetDeviceResponseTypeDef(_ClientGetDeviceResponseTypeDef):
    """
    Type definition for `ClientGetDevice` `Response`

    Represents the result of a get device request.

    - **device** *(dict) --*

      An object containing information about the requested device.

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz CPU
          is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type are PRIVATE
        and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test run. The
              default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not be cleaned up
              from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test run. The
              default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently available in
        the ListDevices and GetDevice API methods.
    """


_ClientGetInstanceProfileResponseinstanceProfileTypeDef = TypedDict(
    "_ClientGetInstanceProfileResponseinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientGetInstanceProfileResponseinstanceProfileTypeDef(
    _ClientGetInstanceProfileResponseinstanceProfileTypeDef
):
    """
    Type definition for `ClientGetInstanceProfileResponse` `instanceProfile`

    An object containing information about your instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The default
      value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned up from
      the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The default
      value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientGetInstanceProfileResponseTypeDef = TypedDict(
    "_ClientGetInstanceProfileResponseTypeDef",
    {"instanceProfile": ClientGetInstanceProfileResponseinstanceProfileTypeDef},
    total=False,
)


class ClientGetInstanceProfileResponseTypeDef(_ClientGetInstanceProfileResponseTypeDef):
    """
    Type definition for `ClientGetInstanceProfile` `Response`

    - **instanceProfile** *(dict) --*

      An object containing information about your instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The default
        value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned up from
        the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The default
        value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientGetJobResponsejobcountersTypeDef = TypedDict(
    "_ClientGetJobResponsejobcountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ClientGetJobResponsejobcountersTypeDef(_ClientGetJobResponsejobcountersTypeDef):
    """
    Type definition for `ClientGetJobResponsejob` `counters`

    The job's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ClientGetJobResponsejobdeviceMinutesTypeDef = TypedDict(
    "_ClientGetJobResponsejobdeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientGetJobResponsejobdeviceMinutesTypeDef(
    _ClientGetJobResponsejobdeviceMinutesTypeDef
):
    """
    Type definition for `ClientGetJobResponsejob` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the job.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to run
      tests.
    """


_ClientGetJobResponsejobdevicecpuTypeDef = TypedDict(
    "_ClientGetJobResponsejobdevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientGetJobResponsejobdevicecpuTypeDef(_ClientGetJobResponsejobdevicecpuTypeDef):
    """
    Type definition for `ClientGetJobResponsejobdevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ClientGetJobResponsejobdeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientGetJobResponsejobdeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientGetJobResponsejobdeviceinstancesinstanceProfileTypeDef(
    _ClientGetJobResponsejobdeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientGetJobResponsejobdeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned
      up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientGetJobResponsejobdeviceinstancesTypeDef = TypedDict(
    "_ClientGetJobResponsejobdeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientGetJobResponsejobdeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientGetJobResponsejobdeviceinstancesTypeDef(
    _ClientGetJobResponsejobdeviceinstancesTypeDef
):
    """
    Type definition for `ClientGetJobResponsejobdevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned
        up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientGetJobResponsejobdeviceresolutionTypeDef = TypedDict(
    "_ClientGetJobResponsejobdeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientGetJobResponsejobdeviceresolutionTypeDef(
    _ClientGetJobResponsejobdeviceresolutionTypeDef
):
    """
    Type definition for `ClientGetJobResponsejobdevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientGetJobResponsejobdeviceTypeDef = TypedDict(
    "_ClientGetJobResponsejobdeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientGetJobResponsejobdevicecpuTypeDef,
        "resolution": ClientGetJobResponsejobdeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[ClientGetJobResponsejobdeviceinstancesTypeDef],
        "availability": str,
    },
    total=False,
)


class ClientGetJobResponsejobdeviceTypeDef(_ClientGetJobResponsejobdeviceTypeDef):
    """
    Type definition for `ClientGetJobResponsejob` `device`

    The device (phone or tablet).

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be cleaned
            up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently available
      in the ListDevices and GetDevice API methods.
    """


_ClientGetJobResponsejobTypeDef = TypedDict(
    "_ClientGetJobResponsejobTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ClientGetJobResponsejobcountersTypeDef,
        "message": str,
        "device": ClientGetJobResponsejobdeviceTypeDef,
        "instanceArn": str,
        "deviceMinutes": ClientGetJobResponsejobdeviceMinutesTypeDef,
        "videoEndpoint": str,
        "videoCapture": bool,
    },
    total=False,
)


class ClientGetJobResponsejobTypeDef(_ClientGetJobResponsejobTypeDef):
    """
    Type definition for `ClientGetJobResponse` `job`

    An object containing information about the requested job.

    - **arn** *(string) --*

      The job's ARN.

    - **name** *(string) --*

      The job's name.

    - **type** *(string) --*

      The job's type.

      Allowed values include the following:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby test type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **created** *(datetime) --*

      When the job was created.

    - **status** *(string) --*

      The job's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The job's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The job's start time.

    - **stopped** *(datetime) --*

      The job's stop time.

    - **counters** *(dict) --*

      The job's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the job's result.

    - **device** *(dict) --*

      The device (phone or tablet).

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
          CPU is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type are
        PRIVATE and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test run. The
              default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not be cleaned
              up from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test run. The
              default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently available
        in the ListDevices and GetDevice API methods.

    - **instanceArn** *(string) --*

      The Amazon Resource Name (ARN) of the instance.

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the job.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to run
        tests.

    - **videoEndpoint** *(string) --*

      The endpoint for streaming device video.

    - **videoCapture** *(boolean) --*

      This value is set to true if video capture is enabled; otherwise, it is set to false.
    """


_ClientGetJobResponseTypeDef = TypedDict(
    "_ClientGetJobResponseTypeDef", {"job": ClientGetJobResponsejobTypeDef}, total=False
)


class ClientGetJobResponseTypeDef(_ClientGetJobResponseTypeDef):
    """
    Type definition for `ClientGetJob` `Response`

    Represents the result of a get job request.

    - **job** *(dict) --*

      An object containing information about the requested job.

      - **arn** *(string) --*

        The job's ARN.

      - **name** *(string) --*

        The job's name.

      - **type** *(string) --*

        The job's type.

        Allowed values include the following:

        * BUILTIN_FUZZ: The built-in fuzz type.

        * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
        interacting with it and capturing screenshots at the same time.

        * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

        * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

        * APPIUM_PYTHON: The Appium Python type.

        * APPIUM_NODE: The Appium Node.js type.

        * APPIUM_RUBY: The Appium Ruby type.

        * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

        * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

        * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

        * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

        * APPIUM_WEB_RUBY: The Appium Ruby test type for web apps.

        * CALABASH: The Calabash type.

        * INSTRUMENTATION: The Instrumentation type.

        * UIAUTOMATION: The uiautomation type.

        * UIAUTOMATOR: The uiautomator type.

        * XCTEST: The Xcode test type.

        * XCTEST_UI: The Xcode UI test type.

      - **created** *(datetime) --*

        When the job was created.

      - **status** *(string) --*

        The job's status.

        Allowed values include:

        * PENDING: A pending status.

        * PENDING_CONCURRENCY: A pending concurrency status.

        * PENDING_DEVICE: A pending device status.

        * PROCESSING: A processing status.

        * SCHEDULING: A scheduling status.

        * PREPARING: A preparing status.

        * RUNNING: A running status.

        * COMPLETED: A completed status.

        * STOPPING: A stopping status.

      - **result** *(string) --*

        The job's result.

        Allowed values include:

        * PENDING: A pending condition.

        * PASSED: A passing condition.

        * WARNED: A warning condition.

        * FAILED: A failed condition.

        * SKIPPED: A skipped condition.

        * ERRORED: An error condition.

        * STOPPED: A stopped condition.

      - **started** *(datetime) --*

        The job's start time.

      - **stopped** *(datetime) --*

        The job's stop time.

      - **counters** *(dict) --*

        The job's result counters.

        - **total** *(integer) --*

          The total number of entities.

        - **passed** *(integer) --*

          The number of passed entities.

        - **failed** *(integer) --*

          The number of failed entities.

        - **warned** *(integer) --*

          The number of warned entities.

        - **errored** *(integer) --*

          The number of errored entities.

        - **stopped** *(integer) --*

          The number of stopped entities.

        - **skipped** *(integer) --*

          The number of skipped entities.

      - **message** *(string) --*

        A message about the job's result.

      - **device** *(dict) --*

        The device (phone or tablet).

        - **arn** *(string) --*

          The device's ARN.

        - **name** *(string) --*

          The device's display name.

        - **manufacturer** *(string) --*

          The device's manufacturer name.

        - **model** *(string) --*

          The device's model name.

        - **modelId** *(string) --*

          The device's model ID.

        - **formFactor** *(string) --*

          The device's form factor.

          Allowed values include:

          * PHONE: The phone form factor.

          * TABLET: The tablet form factor.

        - **platform** *(string) --*

          The device's platform.

          Allowed values include:

          * ANDROID: The Android platform.

          * IOS: The iOS platform.

        - **os** *(string) --*

          The device's operating system type.

        - **cpu** *(dict) --*

          Information about the device's CPU.

          - **frequency** *(string) --*

            The CPU's frequency.

          - **architecture** *(string) --*

            The CPU's architecture, for example x86 or ARM.

          - **clock** *(float) --*

            The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
            CPU is expressed as 1200000000.

        - **resolution** *(dict) --*

          The resolution of the device.

          - **width** *(integer) --*

            The screen resolution's width, expressed in pixels.

          - **height** *(integer) --*

            The screen resolution's height, expressed in pixels.

        - **heapSize** *(integer) --*

          The device's heap size, expressed in bytes.

        - **memory** *(integer) --*

          The device's total memory size, expressed in bytes.

        - **image** *(string) --*

          The device's image name.

        - **carrier** *(string) --*

          The device's carrier.

        - **radio** *(string) --*

          The device's radio.

        - **remoteAccessEnabled** *(boolean) --*

          Specifies whether remote access has been enabled for the specified device.

        - **remoteDebugEnabled** *(boolean) --*

          This flag is set to ``true`` if remote debugging is enabled for the device.

           *Remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **fleetType** *(string) --*

          The type of fleet to which this device belongs. Possible values for fleet type are
          PRIVATE and PUBLIC.

        - **fleetName** *(string) --*

          The name of the fleet to which this device belongs.

        - **instances** *(list) --*

          The instances belonging to this device.

          - *(dict) --*

            Represents the device instance.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the device instance.

            - **deviceArn** *(string) --*

              The Amazon Resource Name (ARN) of the device.

            - **labels** *(list) --*

              An array of strings describing the device instance.

              - *(string) --*

            - **status** *(string) --*

              The status of the device instance. Valid values are listed below.

            - **udid** *(string) --*

              Unique device identifier for the device instance.

            - **instanceProfile** *(dict) --*

              A object containing information about the instance profile.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the instance profile.

              - **packageCleanup** *(boolean) --*

                When set to ``true`` , Device Farm will remove app packages after a test run. The
                default value is ``false`` for private devices.

              - **excludeAppPackagesFromCleanup** *(list) --*

                An array of strings specifying the list of app packages that should not be cleaned
                up from the device after a test run is over.

                The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

                - *(string) --*

              - **rebootAfterUse** *(boolean) --*

                When set to ``true`` , Device Farm will reboot the instance after a test run. The
                default value is ``true`` .

              - **name** *(string) --*

                The name of the instance profile.

              - **description** *(string) --*

                The description of the instance profile.

        - **availability** *(string) --*

          Reflects how likely a device will be available for a test run. It is currently available
          in the ListDevices and GetDevice API methods.

      - **instanceArn** *(string) --*

        The Amazon Resource Name (ARN) of the instance.

      - **deviceMinutes** *(dict) --*

        Represents the total (metered or unmetered) minutes used by the job.

        - **total** *(float) --*

          When specified, represents the total minutes used by the resource to run tests.

        - **metered** *(float) --*

          When specified, represents only the sum of metered minutes used by the resource to run
          tests.

        - **unmetered** *(float) --*

          When specified, represents only the sum of unmetered minutes used by the resource to run
          tests.

      - **videoEndpoint** *(string) --*

        The endpoint for streaming device video.

      - **videoCapture** *(boolean) --*

        This value is set to true if video capture is enabled; otherwise, it is set to false.
    """


_ClientGetNetworkProfileResponsenetworkProfileTypeDef = TypedDict(
    "_ClientGetNetworkProfileResponsenetworkProfileTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "uplinkBandwidthBits": int,
        "downlinkBandwidthBits": int,
        "uplinkDelayMs": int,
        "downlinkDelayMs": int,
        "uplinkJitterMs": int,
        "downlinkJitterMs": int,
        "uplinkLossPercent": int,
        "downlinkLossPercent": int,
    },
    total=False,
)


class ClientGetNetworkProfileResponsenetworkProfileTypeDef(
    _ClientGetNetworkProfileResponsenetworkProfileTypeDef
):
    """
    Type definition for `ClientGetNetworkProfileResponse` `networkProfile`

    The network profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the network profile.

    - **name** *(string) --*

      The name of the network profile.

    - **description** *(string) --*

      The description of the network profile.

    - **type** *(string) --*

      The type of network profile. Valid values are listed below.

    - **uplinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **downlinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **uplinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **downlinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **uplinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **downlinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **uplinkLossPercent** *(integer) --*

      Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

    - **downlinkLossPercent** *(integer) --*

      Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ClientGetNetworkProfileResponseTypeDef = TypedDict(
    "_ClientGetNetworkProfileResponseTypeDef",
    {"networkProfile": ClientGetNetworkProfileResponsenetworkProfileTypeDef},
    total=False,
)


class ClientGetNetworkProfileResponseTypeDef(_ClientGetNetworkProfileResponseTypeDef):
    """
    Type definition for `ClientGetNetworkProfile` `Response`

    - **networkProfile** *(dict) --*

      The network profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the network profile.

      - **name** *(string) --*

        The name of the network profile.

      - **description** *(string) --*

        The description of the network profile.

      - **type** *(string) --*

        The type of network profile. Valid values are listed below.

      - **uplinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **downlinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **uplinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **downlinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **uplinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **downlinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **uplinkLossPercent** *(integer) --*

        Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

      - **downlinkLossPercent** *(integer) --*

        Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ClientGetOfferingStatusResponsecurrentofferingrecurringChargescostTypeDef = TypedDict(
    "_ClientGetOfferingStatusResponsecurrentofferingrecurringChargescostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class ClientGetOfferingStatusResponsecurrentofferingrecurringChargescostTypeDef(
    _ClientGetOfferingStatusResponsecurrentofferingrecurringChargescostTypeDef
):
    """
    Type definition for `ClientGetOfferingStatusResponsecurrentofferingrecurringCharges` `cost`

    The cost of the recurring charge.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S.
      dollars."
    """


_ClientGetOfferingStatusResponsecurrentofferingrecurringChargesTypeDef = TypedDict(
    "_ClientGetOfferingStatusResponsecurrentofferingrecurringChargesTypeDef",
    {
        "cost": ClientGetOfferingStatusResponsecurrentofferingrecurringChargescostTypeDef,
        "frequency": str,
    },
    total=False,
)


class ClientGetOfferingStatusResponsecurrentofferingrecurringChargesTypeDef(
    _ClientGetOfferingStatusResponsecurrentofferingrecurringChargesTypeDef
):
    """
    Type definition for `ClientGetOfferingStatusResponsecurrentoffering` `recurringCharges`

    Specifies whether charges for devices will be recurring.

    - **cost** *(dict) --*

      The cost of the recurring charge.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S.
        dollars."

    - **frequency** *(string) --*

      The frequency in which charges will recur.
    """


_ClientGetOfferingStatusResponsecurrentofferingTypeDef = TypedDict(
    "_ClientGetOfferingStatusResponsecurrentofferingTypeDef",
    {
        "id": str,
        "description": str,
        "type": str,
        "platform": str,
        "recurringCharges": List[
            ClientGetOfferingStatusResponsecurrentofferingrecurringChargesTypeDef
        ],
    },
    total=False,
)


class ClientGetOfferingStatusResponsecurrentofferingTypeDef(
    _ClientGetOfferingStatusResponsecurrentofferingTypeDef
):
    """
    Type definition for `ClientGetOfferingStatusResponsecurrent` `offering`

    Represents the metadata of an offering status.

    - **id** *(string) --*

      The ID that corresponds to a device offering.

    - **description** *(string) --*

      A string describing the offering.

    - **type** *(string) --*

      The type of offering (e.g., "RECURRING") for a device.

    - **platform** *(string) --*

      The platform of the device (e.g., ANDROID or IOS).

    - **recurringCharges** *(list) --*

      Specifies whether there are recurring charges for the offering.

      - *(dict) --*

        Specifies whether charges for devices will be recurring.

        - **cost** *(dict) --*

          The cost of the recurring charge.

          - **amount** *(float) --*

            The numerical amount of an offering or transaction.

          - **currencyCode** *(string) --*

            The currency code of a monetary amount. For example, ``USD`` means "U.S.
            dollars."

        - **frequency** *(string) --*

          The frequency in which charges will recur.
    """


_ClientGetOfferingStatusResponsecurrentTypeDef = TypedDict(
    "_ClientGetOfferingStatusResponsecurrentTypeDef",
    {
        "type": str,
        "offering": ClientGetOfferingStatusResponsecurrentofferingTypeDef,
        "quantity": int,
        "effectiveOn": datetime,
    },
    total=False,
)


class ClientGetOfferingStatusResponsecurrentTypeDef(
    _ClientGetOfferingStatusResponsecurrentTypeDef
):
    """
    Type definition for `ClientGetOfferingStatusResponse` `current`

    The status of the offering.

    - **type** *(string) --*

      The type specified for the offering status.

    - **offering** *(dict) --*

      Represents the metadata of an offering status.

      - **id** *(string) --*

        The ID that corresponds to a device offering.

      - **description** *(string) --*

        A string describing the offering.

      - **type** *(string) --*

        The type of offering (e.g., "RECURRING") for a device.

      - **platform** *(string) --*

        The platform of the device (e.g., ANDROID or IOS).

      - **recurringCharges** *(list) --*

        Specifies whether there are recurring charges for the offering.

        - *(dict) --*

          Specifies whether charges for devices will be recurring.

          - **cost** *(dict) --*

            The cost of the recurring charge.

            - **amount** *(float) --*

              The numerical amount of an offering or transaction.

            - **currencyCode** *(string) --*

              The currency code of a monetary amount. For example, ``USD`` means "U.S.
              dollars."

          - **frequency** *(string) --*

            The frequency in which charges will recur.

    - **quantity** *(integer) --*

      The number of available devices in the offering.

    - **effectiveOn** *(datetime) --*

      The date on which the offering is effective.
    """


_ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargescostTypeDef = TypedDict(
    "_ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargescostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargescostTypeDef(
    _ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargescostTypeDef
):
    """
    Type definition for `ClientGetOfferingStatusResponsenextPeriodofferingrecurringCharges` `cost`

    The cost of the recurring charge.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S.
      dollars."
    """


_ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargesTypeDef = TypedDict(
    "_ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargesTypeDef",
    {
        "cost": ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargescostTypeDef,
        "frequency": str,
    },
    total=False,
)


class ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargesTypeDef(
    _ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargesTypeDef
):
    """
    Type definition for `ClientGetOfferingStatusResponsenextPeriodoffering` `recurringCharges`

    Specifies whether charges for devices will be recurring.

    - **cost** *(dict) --*

      The cost of the recurring charge.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S.
        dollars."

    - **frequency** *(string) --*

      The frequency in which charges will recur.
    """


_ClientGetOfferingStatusResponsenextPeriodofferingTypeDef = TypedDict(
    "_ClientGetOfferingStatusResponsenextPeriodofferingTypeDef",
    {
        "id": str,
        "description": str,
        "type": str,
        "platform": str,
        "recurringCharges": List[
            ClientGetOfferingStatusResponsenextPeriodofferingrecurringChargesTypeDef
        ],
    },
    total=False,
)


class ClientGetOfferingStatusResponsenextPeriodofferingTypeDef(
    _ClientGetOfferingStatusResponsenextPeriodofferingTypeDef
):
    """
    Type definition for `ClientGetOfferingStatusResponsenextPeriod` `offering`

    Represents the metadata of an offering status.

    - **id** *(string) --*

      The ID that corresponds to a device offering.

    - **description** *(string) --*

      A string describing the offering.

    - **type** *(string) --*

      The type of offering (e.g., "RECURRING") for a device.

    - **platform** *(string) --*

      The platform of the device (e.g., ANDROID or IOS).

    - **recurringCharges** *(list) --*

      Specifies whether there are recurring charges for the offering.

      - *(dict) --*

        Specifies whether charges for devices will be recurring.

        - **cost** *(dict) --*

          The cost of the recurring charge.

          - **amount** *(float) --*

            The numerical amount of an offering or transaction.

          - **currencyCode** *(string) --*

            The currency code of a monetary amount. For example, ``USD`` means "U.S.
            dollars."

        - **frequency** *(string) --*

          The frequency in which charges will recur.
    """


_ClientGetOfferingStatusResponsenextPeriodTypeDef = TypedDict(
    "_ClientGetOfferingStatusResponsenextPeriodTypeDef",
    {
        "type": str,
        "offering": ClientGetOfferingStatusResponsenextPeriodofferingTypeDef,
        "quantity": int,
        "effectiveOn": datetime,
    },
    total=False,
)


class ClientGetOfferingStatusResponsenextPeriodTypeDef(
    _ClientGetOfferingStatusResponsenextPeriodTypeDef
):
    """
    Type definition for `ClientGetOfferingStatusResponse` `nextPeriod`

    The status of the offering.

    - **type** *(string) --*

      The type specified for the offering status.

    - **offering** *(dict) --*

      Represents the metadata of an offering status.

      - **id** *(string) --*

        The ID that corresponds to a device offering.

      - **description** *(string) --*

        A string describing the offering.

      - **type** *(string) --*

        The type of offering (e.g., "RECURRING") for a device.

      - **platform** *(string) --*

        The platform of the device (e.g., ANDROID or IOS).

      - **recurringCharges** *(list) --*

        Specifies whether there are recurring charges for the offering.

        - *(dict) --*

          Specifies whether charges for devices will be recurring.

          - **cost** *(dict) --*

            The cost of the recurring charge.

            - **amount** *(float) --*

              The numerical amount of an offering or transaction.

            - **currencyCode** *(string) --*

              The currency code of a monetary amount. For example, ``USD`` means "U.S.
              dollars."

          - **frequency** *(string) --*

            The frequency in which charges will recur.

    - **quantity** *(integer) --*

      The number of available devices in the offering.

    - **effectiveOn** *(datetime) --*

      The date on which the offering is effective.
    """


_ClientGetOfferingStatusResponseTypeDef = TypedDict(
    "_ClientGetOfferingStatusResponseTypeDef",
    {
        "current": Dict[str, ClientGetOfferingStatusResponsecurrentTypeDef],
        "nextPeriod": Dict[str, ClientGetOfferingStatusResponsenextPeriodTypeDef],
        "nextToken": str,
    },
    total=False,
)


class ClientGetOfferingStatusResponseTypeDef(_ClientGetOfferingStatusResponseTypeDef):
    """
    Type definition for `ClientGetOfferingStatus` `Response`

    Returns the status result for a device offering.

    - **current** *(dict) --*

      When specified, gets the offering status for the current period.

      - *(string) --*

        - *(dict) --*

          The status of the offering.

          - **type** *(string) --*

            The type specified for the offering status.

          - **offering** *(dict) --*

            Represents the metadata of an offering status.

            - **id** *(string) --*

              The ID that corresponds to a device offering.

            - **description** *(string) --*

              A string describing the offering.

            - **type** *(string) --*

              The type of offering (e.g., "RECURRING") for a device.

            - **platform** *(string) --*

              The platform of the device (e.g., ANDROID or IOS).

            - **recurringCharges** *(list) --*

              Specifies whether there are recurring charges for the offering.

              - *(dict) --*

                Specifies whether charges for devices will be recurring.

                - **cost** *(dict) --*

                  The cost of the recurring charge.

                  - **amount** *(float) --*

                    The numerical amount of an offering or transaction.

                  - **currencyCode** *(string) --*

                    The currency code of a monetary amount. For example, ``USD`` means "U.S.
                    dollars."

                - **frequency** *(string) --*

                  The frequency in which charges will recur.

          - **quantity** *(integer) --*

            The number of available devices in the offering.

          - **effectiveOn** *(datetime) --*

            The date on which the offering is effective.

    - **nextPeriod** *(dict) --*

      When specified, gets the offering status for the next period.

      - *(string) --*

        - *(dict) --*

          The status of the offering.

          - **type** *(string) --*

            The type specified for the offering status.

          - **offering** *(dict) --*

            Represents the metadata of an offering status.

            - **id** *(string) --*

              The ID that corresponds to a device offering.

            - **description** *(string) --*

              A string describing the offering.

            - **type** *(string) --*

              The type of offering (e.g., "RECURRING") for a device.

            - **platform** *(string) --*

              The platform of the device (e.g., ANDROID or IOS).

            - **recurringCharges** *(list) --*

              Specifies whether there are recurring charges for the offering.

              - *(dict) --*

                Specifies whether charges for devices will be recurring.

                - **cost** *(dict) --*

                  The cost of the recurring charge.

                  - **amount** *(float) --*

                    The numerical amount of an offering or transaction.

                  - **currencyCode** *(string) --*

                    The currency code of a monetary amount. For example, ``USD`` means "U.S.
                    dollars."

                - **frequency** *(string) --*

                  The frequency in which charges will recur.

          - **quantity** *(integer) --*

            The number of available devices in the offering.

          - **effectiveOn** *(datetime) --*

            The date on which the offering is effective.

    - **nextToken** *(string) --*

      An identifier that was returned from the previous call to this operation, which can be used
      to return the next set of items in the list.
    """


_ClientGetProjectResponseprojectTypeDef = TypedDict(
    "_ClientGetProjectResponseprojectTypeDef",
    {"arn": str, "name": str, "defaultJobTimeoutMinutes": int, "created": datetime},
    total=False,
)


class ClientGetProjectResponseprojectTypeDef(_ClientGetProjectResponseprojectTypeDef):
    """
    Type definition for `ClientGetProjectResponse` `project`

    The project you wish to get information about.

    - **arn** *(string) --*

      The project's ARN.

    - **name** *(string) --*

      The project's name.

    - **defaultJobTimeoutMinutes** *(integer) --*

      The default number of minutes (at the project level) a test run will execute before it
      times out. The default value is 150 minutes.

    - **created** *(datetime) --*

      When the project was created.
    """


_ClientGetProjectResponseTypeDef = TypedDict(
    "_ClientGetProjectResponseTypeDef",
    {"project": ClientGetProjectResponseprojectTypeDef},
    total=False,
)


class ClientGetProjectResponseTypeDef(_ClientGetProjectResponseTypeDef):
    """
    Type definition for `ClientGetProject` `Response`

    Represents the result of a get project request.

    - **project** *(dict) --*

      The project you wish to get information about.

      - **arn** *(string) --*

        The project's ARN.

      - **name** *(string) --*

        The project's name.

      - **defaultJobTimeoutMinutes** *(integer) --*

        The default number of minutes (at the project level) a test run will execute before it
        times out. The default value is 150 minutes.

      - **created** *(datetime) --*

        When the project was created.
    """


_ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef = TypedDict(
    "_ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef(
    _ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef
):
    """
    Type definition for `ClientGetRemoteAccessSessionResponseremoteAccessSession` `deviceMinutes`

    The number of minutes a device is used in a remote access session (including setup and
    teardown minutes).

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to run
      tests.
    """


_ClientGetRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef = TypedDict(
    "_ClientGetRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientGetRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef(
    _ClientGetRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef
):
    """
    Type definition for `ClientGetRemoteAccessSessionResponseremoteAccessSessiondevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef(
    _ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned
      up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef = TypedDict(
    "_ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef(
    _ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef
):
    """
    Type definition for `ClientGetRemoteAccessSessionResponseremoteAccessSessiondevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned
        up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef = TypedDict(
    "_ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef(
    _ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef
):
    """
    Type definition for `ClientGetRemoteAccessSessionResponseremoteAccessSessiondevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef = TypedDict(
    "_ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientGetRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef,
        "resolution": ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[
            ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef
        ],
        "availability": str,
    },
    total=False,
)


class ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef(
    _ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef
):
    """
    Type definition for `ClientGetRemoteAccessSessionResponseremoteAccessSession` `device`

    The device (phone or tablet) used in the remote access session.

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be cleaned
            up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently available
      in the ListDevices and GetDevice API methods.
    """


_ClientGetRemoteAccessSessionResponseremoteAccessSessionTypeDef = TypedDict(
    "_ClientGetRemoteAccessSessionResponseremoteAccessSessionTypeDef",
    {
        "arn": str,
        "name": str,
        "created": datetime,
        "status": str,
        "result": str,
        "message": str,
        "started": datetime,
        "stopped": datetime,
        "device": ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef,
        "instanceArn": str,
        "remoteDebugEnabled": bool,
        "remoteRecordEnabled": bool,
        "remoteRecordAppArn": str,
        "hostAddress": str,
        "clientId": str,
        "billingMethod": str,
        "deviceMinutes": ClientGetRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef,
        "endpoint": str,
        "deviceUdid": str,
        "interactionMode": str,
        "skipAppResign": bool,
    },
    total=False,
)


class ClientGetRemoteAccessSessionResponseremoteAccessSessionTypeDef(
    _ClientGetRemoteAccessSessionResponseremoteAccessSessionTypeDef
):
    """
    Type definition for `ClientGetRemoteAccessSessionResponse` `remoteAccessSession`

    A container that lists detailed information about the remote access session.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the remote access session.

    - **name** *(string) --*

      The name of the remote access session.

    - **created** *(datetime) --*

      The date and time the remote access session was created.

    - **status** *(string) --*

      The status of the remote access session. Can be any of the following:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The result of the remote access session. Can be any of the following:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **message** *(string) --*

      A message about the remote access session.

    - **started** *(datetime) --*

      The date and time the remote access session was started.

    - **stopped** *(datetime) --*

      The date and time the remote access session was stopped.

    - **device** *(dict) --*

      The device (phone or tablet) used in the remote access session.

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
          CPU is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type are
        PRIVATE and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test run. The
              default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not be cleaned
              up from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test run. The
              default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently available
        in the ListDevices and GetDevice API methods.

    - **instanceArn** *(string) --*

      The Amazon Resource Name (ARN) of the instance.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **remoteRecordEnabled** *(boolean) --*

      This flag is set to ``true`` if remote recording is enabled for the remote access session.

    - **remoteRecordAppArn** *(string) --*

      The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.

    - **hostAddress** *(string) --*

      IP address of the EC2 host where you need to connect to remotely debug devices. Only
      returned if remote debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **clientId** *(string) --*

      Unique identifier of your client for the remote access session. Only returned if remote
      debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **billingMethod** *(string) --*

      The billing method of the remote access session. Possible values include ``METERED`` or
      ``UNMETERED`` . For more information about metered devices, see `AWS Device Farm
      terminology
      <https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology>`__
      ."

    - **deviceMinutes** *(dict) --*

      The number of minutes a device is used in a remote access session (including setup and
      teardown minutes).

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to run
        tests.

    - **endpoint** *(string) --*

      The endpoint for the remote access sesssion.

    - **deviceUdid** *(string) --*

      Unique device identifier for the remote device. Only returned if remote debugging is
      enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **interactionMode** *(string) --*

      The interaction mode of the remote access session. Valid values are:

      * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the
      screen. You **cannot** run XCUITest framework-based tests in this mode.

      * NO_VIDEO: You are connected to the device but cannot interact with it or view the screen.
      This mode has the fastest test execution speed. You **can** run XCUITest framework-based
      tests in this mode.

      * VIDEO_ONLY: You can view the screen but cannot touch or rotate it. You **can** run
      XCUITest framework-based tests and watch the screen in this mode.

    - **skipAppResign** *(boolean) --*

      When set to ``true`` , for private devices, Device Farm will not sign your app again. For
      public devices, Device Farm always signs your apps again and this parameter has no effect.

      For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
      <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .
    """


_ClientGetRemoteAccessSessionResponseTypeDef = TypedDict(
    "_ClientGetRemoteAccessSessionResponseTypeDef",
    {
        "remoteAccessSession": ClientGetRemoteAccessSessionResponseremoteAccessSessionTypeDef
    },
    total=False,
)


class ClientGetRemoteAccessSessionResponseTypeDef(
    _ClientGetRemoteAccessSessionResponseTypeDef
):
    """
    Type definition for `ClientGetRemoteAccessSession` `Response`

    Represents the response from the server that lists detailed information about the remote access
    session.

    - **remoteAccessSession** *(dict) --*

      A container that lists detailed information about the remote access session.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the remote access session.

      - **name** *(string) --*

        The name of the remote access session.

      - **created** *(datetime) --*

        The date and time the remote access session was created.

      - **status** *(string) --*

        The status of the remote access session. Can be any of the following:

        * PENDING: A pending status.

        * PENDING_CONCURRENCY: A pending concurrency status.

        * PENDING_DEVICE: A pending device status.

        * PROCESSING: A processing status.

        * SCHEDULING: A scheduling status.

        * PREPARING: A preparing status.

        * RUNNING: A running status.

        * COMPLETED: A completed status.

        * STOPPING: A stopping status.

      - **result** *(string) --*

        The result of the remote access session. Can be any of the following:

        * PENDING: A pending condition.

        * PASSED: A passing condition.

        * WARNED: A warning condition.

        * FAILED: A failed condition.

        * SKIPPED: A skipped condition.

        * ERRORED: An error condition.

        * STOPPED: A stopped condition.

      - **message** *(string) --*

        A message about the remote access session.

      - **started** *(datetime) --*

        The date and time the remote access session was started.

      - **stopped** *(datetime) --*

        The date and time the remote access session was stopped.

      - **device** *(dict) --*

        The device (phone or tablet) used in the remote access session.

        - **arn** *(string) --*

          The device's ARN.

        - **name** *(string) --*

          The device's display name.

        - **manufacturer** *(string) --*

          The device's manufacturer name.

        - **model** *(string) --*

          The device's model name.

        - **modelId** *(string) --*

          The device's model ID.

        - **formFactor** *(string) --*

          The device's form factor.

          Allowed values include:

          * PHONE: The phone form factor.

          * TABLET: The tablet form factor.

        - **platform** *(string) --*

          The device's platform.

          Allowed values include:

          * ANDROID: The Android platform.

          * IOS: The iOS platform.

        - **os** *(string) --*

          The device's operating system type.

        - **cpu** *(dict) --*

          Information about the device's CPU.

          - **frequency** *(string) --*

            The CPU's frequency.

          - **architecture** *(string) --*

            The CPU's architecture, for example x86 or ARM.

          - **clock** *(float) --*

            The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
            CPU is expressed as 1200000000.

        - **resolution** *(dict) --*

          The resolution of the device.

          - **width** *(integer) --*

            The screen resolution's width, expressed in pixels.

          - **height** *(integer) --*

            The screen resolution's height, expressed in pixels.

        - **heapSize** *(integer) --*

          The device's heap size, expressed in bytes.

        - **memory** *(integer) --*

          The device's total memory size, expressed in bytes.

        - **image** *(string) --*

          The device's image name.

        - **carrier** *(string) --*

          The device's carrier.

        - **radio** *(string) --*

          The device's radio.

        - **remoteAccessEnabled** *(boolean) --*

          Specifies whether remote access has been enabled for the specified device.

        - **remoteDebugEnabled** *(boolean) --*

          This flag is set to ``true`` if remote debugging is enabled for the device.

           *Remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **fleetType** *(string) --*

          The type of fleet to which this device belongs. Possible values for fleet type are
          PRIVATE and PUBLIC.

        - **fleetName** *(string) --*

          The name of the fleet to which this device belongs.

        - **instances** *(list) --*

          The instances belonging to this device.

          - *(dict) --*

            Represents the device instance.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the device instance.

            - **deviceArn** *(string) --*

              The Amazon Resource Name (ARN) of the device.

            - **labels** *(list) --*

              An array of strings describing the device instance.

              - *(string) --*

            - **status** *(string) --*

              The status of the device instance. Valid values are listed below.

            - **udid** *(string) --*

              Unique device identifier for the device instance.

            - **instanceProfile** *(dict) --*

              A object containing information about the instance profile.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the instance profile.

              - **packageCleanup** *(boolean) --*

                When set to ``true`` , Device Farm will remove app packages after a test run. The
                default value is ``false`` for private devices.

              - **excludeAppPackagesFromCleanup** *(list) --*

                An array of strings specifying the list of app packages that should not be cleaned
                up from the device after a test run is over.

                The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

                - *(string) --*

              - **rebootAfterUse** *(boolean) --*

                When set to ``true`` , Device Farm will reboot the instance after a test run. The
                default value is ``true`` .

              - **name** *(string) --*

                The name of the instance profile.

              - **description** *(string) --*

                The description of the instance profile.

        - **availability** *(string) --*

          Reflects how likely a device will be available for a test run. It is currently available
          in the ListDevices and GetDevice API methods.

      - **instanceArn** *(string) --*

        The Amazon Resource Name (ARN) of the instance.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **remoteRecordEnabled** *(boolean) --*

        This flag is set to ``true`` if remote recording is enabled for the remote access session.

      - **remoteRecordAppArn** *(string) --*

        The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.

      - **hostAddress** *(string) --*

        IP address of the EC2 host where you need to connect to remotely debug devices. Only
        returned if remote debugging is enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **clientId** *(string) --*

        Unique identifier of your client for the remote access session. Only returned if remote
        debugging is enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **billingMethod** *(string) --*

        The billing method of the remote access session. Possible values include ``METERED`` or
        ``UNMETERED`` . For more information about metered devices, see `AWS Device Farm
        terminology
        <https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology>`__
        ."

      - **deviceMinutes** *(dict) --*

        The number of minutes a device is used in a remote access session (including setup and
        teardown minutes).

        - **total** *(float) --*

          When specified, represents the total minutes used by the resource to run tests.

        - **metered** *(float) --*

          When specified, represents only the sum of metered minutes used by the resource to run
          tests.

        - **unmetered** *(float) --*

          When specified, represents only the sum of unmetered minutes used by the resource to run
          tests.

      - **endpoint** *(string) --*

        The endpoint for the remote access sesssion.

      - **deviceUdid** *(string) --*

        Unique device identifier for the remote device. Only returned if remote debugging is
        enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **interactionMode** *(string) --*

        The interaction mode of the remote access session. Valid values are:

        * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the
        screen. You **cannot** run XCUITest framework-based tests in this mode.

        * NO_VIDEO: You are connected to the device but cannot interact with it or view the screen.
        This mode has the fastest test execution speed. You **can** run XCUITest framework-based
        tests in this mode.

        * VIDEO_ONLY: You can view the screen but cannot touch or rotate it. You **can** run
        XCUITest framework-based tests and watch the screen in this mode.

      - **skipAppResign** *(boolean) --*

        When set to ``true`` , for private devices, Device Farm will not sign your app again. For
        public devices, Device Farm always signs your apps again and this parameter has no effect.

        For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
        <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .
    """


_ClientGetRunResponseruncountersTypeDef = TypedDict(
    "_ClientGetRunResponseruncountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ClientGetRunResponseruncountersTypeDef(_ClientGetRunResponseruncountersTypeDef):
    """
    Type definition for `ClientGetRunResponserun` `counters`

    The run's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ClientGetRunResponseruncustomerArtifactPathsTypeDef = TypedDict(
    "_ClientGetRunResponseruncustomerArtifactPathsTypeDef",
    {"iosPaths": List[str], "androidPaths": List[str], "deviceHostPaths": List[str]},
    total=False,
)


class ClientGetRunResponseruncustomerArtifactPathsTypeDef(
    _ClientGetRunResponseruncustomerArtifactPathsTypeDef
):
    """
    Type definition for `ClientGetRunResponserun` `customerArtifactPaths`

    Output ``CustomerArtifactPaths`` object for the test run.

    - **iosPaths** *(list) --*

      Comma-separated list of paths on the iOS device where the artifacts generated by the
      customer's tests will be pulled from.

      - *(string) --*

    - **androidPaths** *(list) --*

      Comma-separated list of paths on the Android device where the artifacts generated by the
      customer's tests will be pulled from.

      - *(string) --*

    - **deviceHostPaths** *(list) --*

      Comma-separated list of paths in the test execution environment where the artifacts
      generated by the customer's tests will be pulled from.

      - *(string) --*
    """


_ClientGetRunResponserundeviceMinutesTypeDef = TypedDict(
    "_ClientGetRunResponserundeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientGetRunResponserundeviceMinutesTypeDef(
    _ClientGetRunResponserundeviceMinutesTypeDef
):
    """
    Type definition for `ClientGetRunResponserun` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the test run.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to run
      tests.
    """


_ClientGetRunResponserundeviceSelectionResultfiltersTypeDef = TypedDict(
    "_ClientGetRunResponserundeviceSelectionResultfiltersTypeDef",
    {"attribute": str, "operator": str, "values": List[str]},
    total=False,
)


class ClientGetRunResponserundeviceSelectionResultfiltersTypeDef(
    _ClientGetRunResponserundeviceSelectionResultfiltersTypeDef
):
    """
    Type definition for `ClientGetRunResponserundeviceSelectionResult` `filters`

    Represents a device filter used to select a set of devices to be included in a test
    run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
    to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

    It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
    JSON request syntax, see  ListDevices .

    - **attribute** *(string) --*

      The aspect of a device such as platform or model used as the selection criteria in a
      device filter.

      The supported operators for each attribute are provided in the following list.

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
       ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        MODEL

      The device model. For example, "iPad 5th Gen".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE",
      "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

       *Ignored.* Whether the device is enabled for remote debugging. Valid values are
       "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

    - **operator** *(string) --*

      Specifies how Device Farm compares the filter's attribute to the value. For the
      operators that are supported by each attribute, see the attribute descriptions.

    - **values** *(list) --*

      An array of one or more filter values used in a device filter.

       **Operator Values**

      * The IN and NOT_IN operators can take a values array that has more than one element.

      * The other operators require an array with a single element.

       **Attribute Values**

      * The PLATFORM attribute can be set to "ANDROID" or "IOS".

      * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
      or "TEMPORARY_NOT_AVAILABLE".

      * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

      * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

      - *(string) --*
    """


_ClientGetRunResponserundeviceSelectionResultTypeDef = TypedDict(
    "_ClientGetRunResponserundeviceSelectionResultTypeDef",
    {
        "filters": List[ClientGetRunResponserundeviceSelectionResultfiltersTypeDef],
        "matchedDevicesCount": int,
        "maxDevices": int,
    },
    total=False,
)


class ClientGetRunResponserundeviceSelectionResultTypeDef(
    _ClientGetRunResponserundeviceSelectionResultTypeDef
):
    """
    Type definition for `ClientGetRunResponserun` `deviceSelectionResult`

    The results of a device filter used to select the devices for a test run.

    - **filters** *(list) --*

      The filters in a device selection result.

      - *(dict) --*

        Represents a device filter used to select a set of devices to be included in a test
        run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
        to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

        It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
        JSON request syntax, see  ListDevices .

        - **attribute** *(string) --*

          The aspect of a device such as platform or model used as the selection criteria in a
          device filter.

          The supported operators for each attribute are provided in the following list.

            ARN

          The Amazon Resource Name (ARN) of the device. For example,
          "arn:aws:devicefarm:us-west-2::device:12345Example".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            PLATFORM

          The device platform. Valid values are "ANDROID" or "IOS".

           *Supported operators* : ``EQUALS``

            OS_VERSION

          The operating system version. For example, "10.3.2".

           *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
           ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

            MODEL

          The device model. For example, "iPad 5th Gen".

           *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

            AVAILABILITY

          The current availability of the device. Valid values are "AVAILABLE",
          "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

           *Supported operators* : ``EQUALS``

            FORM_FACTOR

          The device form factor. Valid values are "PHONE" or "TABLET".

           *Supported operators* : ``EQUALS``

            MANUFACTURER

          The device manufacturer. For example, "Apple".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            REMOTE_ACCESS_ENABLED

          Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

            REMOTE_DEBUG_ENABLED

           *Ignored.* Whether the device is enabled for remote debugging. Valid values are
           "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

           *This filter will be ignored, as remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

            INSTANCE_ARN

          The Amazon Resource Name (ARN) of the device instance.

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            INSTANCE_LABELS

          The label of the device instance.

           *Supported operators* : ``CONTAINS``

            FLEET_TYPE

          The fleet type. Valid values are "PUBLIC" or "PRIVATE".

           *Supported operators* : ``EQUALS``

        - **operator** *(string) --*

          Specifies how Device Farm compares the filter's attribute to the value. For the
          operators that are supported by each attribute, see the attribute descriptions.

        - **values** *(list) --*

          An array of one or more filter values used in a device filter.

           **Operator Values**

          * The IN and NOT_IN operators can take a values array that has more than one element.

          * The other operators require an array with a single element.

           **Attribute Values**

          * The PLATFORM attribute can be set to "ANDROID" or "IOS".

          * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
          or "TEMPORARY_NOT_AVAILABLE".

          * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

          * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

          - *(string) --*

    - **matchedDevicesCount** *(integer) --*

      The number of devices that matched the device filter selection criteria.

    - **maxDevices** *(integer) --*

      The maximum number of devices to be selected by a device filter and included in a test
      run.
    """


_ClientGetRunResponserunlocationTypeDef = TypedDict(
    "_ClientGetRunResponserunlocationTypeDef",
    {"latitude": float, "longitude": float},
    total=False,
)


class ClientGetRunResponserunlocationTypeDef(_ClientGetRunResponserunlocationTypeDef):
    """
    Type definition for `ClientGetRunResponserun` `location`

    Information about the location that is used for the run.

    - **latitude** *(float) --*

      The latitude.

    - **longitude** *(float) --*

      The longitude.
    """


_ClientGetRunResponserunnetworkProfileTypeDef = TypedDict(
    "_ClientGetRunResponserunnetworkProfileTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "uplinkBandwidthBits": int,
        "downlinkBandwidthBits": int,
        "uplinkDelayMs": int,
        "downlinkDelayMs": int,
        "uplinkJitterMs": int,
        "downlinkJitterMs": int,
        "uplinkLossPercent": int,
        "downlinkLossPercent": int,
    },
    total=False,
)


class ClientGetRunResponserunnetworkProfileTypeDef(
    _ClientGetRunResponserunnetworkProfileTypeDef
):
    """
    Type definition for `ClientGetRunResponserun` `networkProfile`

    The network profile being used for a test run.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the network profile.

    - **name** *(string) --*

      The name of the network profile.

    - **description** *(string) --*

      The description of the network profile.

    - **type** *(string) --*

      The type of network profile. Valid values are listed below.

    - **uplinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **downlinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **uplinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **downlinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **uplinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **downlinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **uplinkLossPercent** *(integer) --*

      Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

    - **downlinkLossPercent** *(integer) --*

      Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ClientGetRunResponserunradiosTypeDef = TypedDict(
    "_ClientGetRunResponserunradiosTypeDef",
    {"wifi": bool, "bluetooth": bool, "nfc": bool, "gps": bool},
    total=False,
)


class ClientGetRunResponserunradiosTypeDef(_ClientGetRunResponserunradiosTypeDef):
    """
    Type definition for `ClientGetRunResponserun` `radios`

    Information about the radio states for the run.

    - **wifi** *(boolean) --*

      True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

    - **bluetooth** *(boolean) --*

      True if Bluetooth is enabled at the beginning of the test; otherwise, false.

    - **nfc** *(boolean) --*

      True if NFC is enabled at the beginning of the test; otherwise, false.

    - **gps** *(boolean) --*

      True if GPS is enabled at the beginning of the test; otherwise, false.
    """


_ClientGetRunResponserunTypeDef = TypedDict(
    "_ClientGetRunResponserunTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "platform": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ClientGetRunResponseruncountersTypeDef,
        "message": str,
        "totalJobs": int,
        "completedJobs": int,
        "billingMethod": str,
        "deviceMinutes": ClientGetRunResponserundeviceMinutesTypeDef,
        "networkProfile": ClientGetRunResponserunnetworkProfileTypeDef,
        "parsingResultUrl": str,
        "resultCode": str,
        "seed": int,
        "appUpload": str,
        "eventCount": int,
        "jobTimeoutMinutes": int,
        "devicePoolArn": str,
        "locale": str,
        "radios": ClientGetRunResponserunradiosTypeDef,
        "location": ClientGetRunResponserunlocationTypeDef,
        "customerArtifactPaths": ClientGetRunResponseruncustomerArtifactPathsTypeDef,
        "webUrl": str,
        "skipAppResign": bool,
        "testSpecArn": str,
        "deviceSelectionResult": ClientGetRunResponserundeviceSelectionResultTypeDef,
    },
    total=False,
)


class ClientGetRunResponserunTypeDef(_ClientGetRunResponserunTypeDef):
    """
    Type definition for `ClientGetRunResponse` `run`

    The run you wish to get results from.

    - **arn** *(string) --*

      The run's ARN.

    - **name** *(string) --*

      The run's name.

    - **type** *(string) --*

      The run's type.

      Must be one of the following values:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **platform** *(string) --*

      The run's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **created** *(datetime) --*

      When the run was created.

    - **status** *(string) --*

      The run's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The run's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The run's start time.

    - **stopped** *(datetime) --*

      The run's stop time.

    - **counters** *(dict) --*

      The run's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the run's result.

    - **totalJobs** *(integer) --*

      The total number of jobs for the run.

    - **completedJobs** *(integer) --*

      The total number of completed jobs.

    - **billingMethod** *(string) --*

      Specifies the billing method for a test run: ``metered`` or ``unmetered`` . If the
      parameter is not specified, the default value is ``metered`` .

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the test run.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to run
        tests.

    - **networkProfile** *(dict) --*

      The network profile being used for a test run.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the network profile.

      - **name** *(string) --*

        The name of the network profile.

      - **description** *(string) --*

        The description of the network profile.

      - **type** *(string) --*

        The type of network profile. Valid values are listed below.

      - **uplinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **downlinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **uplinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **downlinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **uplinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **downlinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **uplinkLossPercent** *(integer) --*

        Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

      - **downlinkLossPercent** *(integer) --*

        Proportion of received packets that fail to arrive from 0 to 100 percent.

    - **parsingResultUrl** *(string) --*

      Read-only URL for an object in S3 bucket where you can get the parsing results of the test
      package. If the test package doesn't parse, the reason why it doesn't parse appears in the
      file that this URL points to.

    - **resultCode** *(string) --*

      Supporting field for the result field. Set only if ``result`` is ``SKIPPED`` .
      ``PARSING_FAILED`` if the result is skipped because of test package parsing failure.

    - **seed** *(integer) --*

      For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same seed
      value between tests ensures identical event sequences.

    - **appUpload** *(string) --*

      An app to upload or that has been uploaded.

    - **eventCount** *(integer) --*

      For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz test
      should perform.

    - **jobTimeoutMinutes** *(integer) --*

      The number of minutes the job will execute before it times out.

    - **devicePoolArn** *(string) --*

      The ARN of the device pool for the run.

    - **locale** *(string) --*

      Information about the locale that is used for the run.

    - **radios** *(dict) --*

      Information about the radio states for the run.

      - **wifi** *(boolean) --*

        True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

      - **bluetooth** *(boolean) --*

        True if Bluetooth is enabled at the beginning of the test; otherwise, false.

      - **nfc** *(boolean) --*

        True if NFC is enabled at the beginning of the test; otherwise, false.

      - **gps** *(boolean) --*

        True if GPS is enabled at the beginning of the test; otherwise, false.

    - **location** *(dict) --*

      Information about the location that is used for the run.

      - **latitude** *(float) --*

        The latitude.

      - **longitude** *(float) --*

        The longitude.

    - **customerArtifactPaths** *(dict) --*

      Output ``CustomerArtifactPaths`` object for the test run.

      - **iosPaths** *(list) --*

        Comma-separated list of paths on the iOS device where the artifacts generated by the
        customer's tests will be pulled from.

        - *(string) --*

      - **androidPaths** *(list) --*

        Comma-separated list of paths on the Android device where the artifacts generated by the
        customer's tests will be pulled from.

        - *(string) --*

      - **deviceHostPaths** *(list) --*

        Comma-separated list of paths in the test execution environment where the artifacts
        generated by the customer's tests will be pulled from.

        - *(string) --*

    - **webUrl** *(string) --*

      The Device Farm console URL for the recording of the run.

    - **skipAppResign** *(boolean) --*

      When set to ``true`` , for private devices, Device Farm will not sign your app again. For
      public devices, Device Farm always signs your apps again and this parameter has no effect.

      For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
      <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .

    - **testSpecArn** *(string) --*

      The ARN of the YAML-formatted test specification for the run.

    - **deviceSelectionResult** *(dict) --*

      The results of a device filter used to select the devices for a test run.

      - **filters** *(list) --*

        The filters in a device selection result.

        - *(dict) --*

          Represents a device filter used to select a set of devices to be included in a test
          run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
          to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

          It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
          JSON request syntax, see  ListDevices .

          - **attribute** *(string) --*

            The aspect of a device such as platform or model used as the selection criteria in a
            device filter.

            The supported operators for each attribute are provided in the following list.

              ARN

            The Amazon Resource Name (ARN) of the device. For example,
            "arn:aws:devicefarm:us-west-2::device:12345Example".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              PLATFORM

            The device platform. Valid values are "ANDROID" or "IOS".

             *Supported operators* : ``EQUALS``

              OS_VERSION

            The operating system version. For example, "10.3.2".

             *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
             ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

              MODEL

            The device model. For example, "iPad 5th Gen".

             *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

              AVAILABILITY

            The current availability of the device. Valid values are "AVAILABLE",
            "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

             *Supported operators* : ``EQUALS``

              FORM_FACTOR

            The device form factor. Valid values are "PHONE" or "TABLET".

             *Supported operators* : ``EQUALS``

              MANUFACTURER

            The device manufacturer. For example, "Apple".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              REMOTE_ACCESS_ENABLED

            Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

              REMOTE_DEBUG_ENABLED

             *Ignored.* Whether the device is enabled for remote debugging. Valid values are
             "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

             *This filter will be ignored, as remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

              INSTANCE_ARN

            The Amazon Resource Name (ARN) of the device instance.

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              INSTANCE_LABELS

            The label of the device instance.

             *Supported operators* : ``CONTAINS``

              FLEET_TYPE

            The fleet type. Valid values are "PUBLIC" or "PRIVATE".

             *Supported operators* : ``EQUALS``

          - **operator** *(string) --*

            Specifies how Device Farm compares the filter's attribute to the value. For the
            operators that are supported by each attribute, see the attribute descriptions.

          - **values** *(list) --*

            An array of one or more filter values used in a device filter.

             **Operator Values**

            * The IN and NOT_IN operators can take a values array that has more than one element.

            * The other operators require an array with a single element.

             **Attribute Values**

            * The PLATFORM attribute can be set to "ANDROID" or "IOS".

            * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
            or "TEMPORARY_NOT_AVAILABLE".

            * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

            * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

            - *(string) --*

      - **matchedDevicesCount** *(integer) --*

        The number of devices that matched the device filter selection criteria.

      - **maxDevices** *(integer) --*

        The maximum number of devices to be selected by a device filter and included in a test
        run.
    """


_ClientGetRunResponseTypeDef = TypedDict(
    "_ClientGetRunResponseTypeDef", {"run": ClientGetRunResponserunTypeDef}, total=False
)


class ClientGetRunResponseTypeDef(_ClientGetRunResponseTypeDef):
    """
    Type definition for `ClientGetRun` `Response`

    Represents the result of a get run request.

    - **run** *(dict) --*

      The run you wish to get results from.

      - **arn** *(string) --*

        The run's ARN.

      - **name** *(string) --*

        The run's name.

      - **type** *(string) --*

        The run's type.

        Must be one of the following values:

        * BUILTIN_FUZZ: The built-in fuzz type.

        * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
        interacting with it and capturing screenshots at the same time.

        * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

        * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

        * APPIUM_PYTHON: The Appium Python type.

        * APPIUM_NODE: The Appium Node.js type.

        * APPIUM_RUBY: The Appium Ruby type.

        * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

        * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

        * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

        * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

        * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

        * CALABASH: The Calabash type.

        * INSTRUMENTATION: The Instrumentation type.

        * UIAUTOMATION: The uiautomation type.

        * UIAUTOMATOR: The uiautomator type.

        * XCTEST: The Xcode test type.

        * XCTEST_UI: The Xcode UI test type.

      - **platform** *(string) --*

        The run's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **created** *(datetime) --*

        When the run was created.

      - **status** *(string) --*

        The run's status.

        Allowed values include:

        * PENDING: A pending status.

        * PENDING_CONCURRENCY: A pending concurrency status.

        * PENDING_DEVICE: A pending device status.

        * PROCESSING: A processing status.

        * SCHEDULING: A scheduling status.

        * PREPARING: A preparing status.

        * RUNNING: A running status.

        * COMPLETED: A completed status.

        * STOPPING: A stopping status.

      - **result** *(string) --*

        The run's result.

        Allowed values include:

        * PENDING: A pending condition.

        * PASSED: A passing condition.

        * WARNED: A warning condition.

        * FAILED: A failed condition.

        * SKIPPED: A skipped condition.

        * ERRORED: An error condition.

        * STOPPED: A stopped condition.

      - **started** *(datetime) --*

        The run's start time.

      - **stopped** *(datetime) --*

        The run's stop time.

      - **counters** *(dict) --*

        The run's result counters.

        - **total** *(integer) --*

          The total number of entities.

        - **passed** *(integer) --*

          The number of passed entities.

        - **failed** *(integer) --*

          The number of failed entities.

        - **warned** *(integer) --*

          The number of warned entities.

        - **errored** *(integer) --*

          The number of errored entities.

        - **stopped** *(integer) --*

          The number of stopped entities.

        - **skipped** *(integer) --*

          The number of skipped entities.

      - **message** *(string) --*

        A message about the run's result.

      - **totalJobs** *(integer) --*

        The total number of jobs for the run.

      - **completedJobs** *(integer) --*

        The total number of completed jobs.

      - **billingMethod** *(string) --*

        Specifies the billing method for a test run: ``metered`` or ``unmetered`` . If the
        parameter is not specified, the default value is ``metered`` .

      - **deviceMinutes** *(dict) --*

        Represents the total (metered or unmetered) minutes used by the test run.

        - **total** *(float) --*

          When specified, represents the total minutes used by the resource to run tests.

        - **metered** *(float) --*

          When specified, represents only the sum of metered minutes used by the resource to run
          tests.

        - **unmetered** *(float) --*

          When specified, represents only the sum of unmetered minutes used by the resource to run
          tests.

      - **networkProfile** *(dict) --*

        The network profile being used for a test run.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the network profile.

        - **name** *(string) --*

          The name of the network profile.

        - **description** *(string) --*

          The description of the network profile.

        - **type** *(string) --*

          The type of network profile. Valid values are listed below.

        - **uplinkBandwidthBits** *(integer) --*

          The data throughput rate in bits per second, as an integer from 0 to 104857600.

        - **downlinkBandwidthBits** *(integer) --*

          The data throughput rate in bits per second, as an integer from 0 to 104857600.

        - **uplinkDelayMs** *(integer) --*

          Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

        - **downlinkDelayMs** *(integer) --*

          Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

        - **uplinkJitterMs** *(integer) --*

          Time variation in the delay of received packets in milliseconds as an integer from 0 to
          2000.

        - **downlinkJitterMs** *(integer) --*

          Time variation in the delay of received packets in milliseconds as an integer from 0 to
          2000.

        - **uplinkLossPercent** *(integer) --*

          Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

        - **downlinkLossPercent** *(integer) --*

          Proportion of received packets that fail to arrive from 0 to 100 percent.

      - **parsingResultUrl** *(string) --*

        Read-only URL for an object in S3 bucket where you can get the parsing results of the test
        package. If the test package doesn't parse, the reason why it doesn't parse appears in the
        file that this URL points to.

      - **resultCode** *(string) --*

        Supporting field for the result field. Set only if ``result`` is ``SKIPPED`` .
        ``PARSING_FAILED`` if the result is skipped because of test package parsing failure.

      - **seed** *(integer) --*

        For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same seed
        value between tests ensures identical event sequences.

      - **appUpload** *(string) --*

        An app to upload or that has been uploaded.

      - **eventCount** *(integer) --*

        For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz test
        should perform.

      - **jobTimeoutMinutes** *(integer) --*

        The number of minutes the job will execute before it times out.

      - **devicePoolArn** *(string) --*

        The ARN of the device pool for the run.

      - **locale** *(string) --*

        Information about the locale that is used for the run.

      - **radios** *(dict) --*

        Information about the radio states for the run.

        - **wifi** *(boolean) --*

          True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

        - **bluetooth** *(boolean) --*

          True if Bluetooth is enabled at the beginning of the test; otherwise, false.

        - **nfc** *(boolean) --*

          True if NFC is enabled at the beginning of the test; otherwise, false.

        - **gps** *(boolean) --*

          True if GPS is enabled at the beginning of the test; otherwise, false.

      - **location** *(dict) --*

        Information about the location that is used for the run.

        - **latitude** *(float) --*

          The latitude.

        - **longitude** *(float) --*

          The longitude.

      - **customerArtifactPaths** *(dict) --*

        Output ``CustomerArtifactPaths`` object for the test run.

        - **iosPaths** *(list) --*

          Comma-separated list of paths on the iOS device where the artifacts generated by the
          customer's tests will be pulled from.

          - *(string) --*

        - **androidPaths** *(list) --*

          Comma-separated list of paths on the Android device where the artifacts generated by the
          customer's tests will be pulled from.

          - *(string) --*

        - **deviceHostPaths** *(list) --*

          Comma-separated list of paths in the test execution environment where the artifacts
          generated by the customer's tests will be pulled from.

          - *(string) --*

      - **webUrl** *(string) --*

        The Device Farm console URL for the recording of the run.

      - **skipAppResign** *(boolean) --*

        When set to ``true`` , for private devices, Device Farm will not sign your app again. For
        public devices, Device Farm always signs your apps again and this parameter has no effect.

        For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
        <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .

      - **testSpecArn** *(string) --*

        The ARN of the YAML-formatted test specification for the run.

      - **deviceSelectionResult** *(dict) --*

        The results of a device filter used to select the devices for a test run.

        - **filters** *(list) --*

          The filters in a device selection result.

          - *(dict) --*

            Represents a device filter used to select a set of devices to be included in a test
            run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
            to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

            It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
            JSON request syntax, see  ListDevices .

            - **attribute** *(string) --*

              The aspect of a device such as platform or model used as the selection criteria in a
              device filter.

              The supported operators for each attribute are provided in the following list.

                ARN

              The Amazon Resource Name (ARN) of the device. For example,
              "arn:aws:devicefarm:us-west-2::device:12345Example".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                PLATFORM

              The device platform. Valid values are "ANDROID" or "IOS".

               *Supported operators* : ``EQUALS``

                OS_VERSION

              The operating system version. For example, "10.3.2".

               *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
               ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

                MODEL

              The device model. For example, "iPad 5th Gen".

               *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

                AVAILABILITY

              The current availability of the device. Valid values are "AVAILABLE",
              "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

               *Supported operators* : ``EQUALS``

                FORM_FACTOR

              The device form factor. Valid values are "PHONE" or "TABLET".

               *Supported operators* : ``EQUALS``

                MANUFACTURER

              The device manufacturer. For example, "Apple".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                REMOTE_ACCESS_ENABLED

              Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

               *Supported operators* : ``EQUALS``

                REMOTE_DEBUG_ENABLED

               *Ignored.* Whether the device is enabled for remote debugging. Valid values are
               "TRUE" or "FALSE".

               *Supported operators* : ``EQUALS``

               *This filter will be ignored, as remote debugging is `no longer supported
               <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

                INSTANCE_ARN

              The Amazon Resource Name (ARN) of the device instance.

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                INSTANCE_LABELS

              The label of the device instance.

               *Supported operators* : ``CONTAINS``

                FLEET_TYPE

              The fleet type. Valid values are "PUBLIC" or "PRIVATE".

               *Supported operators* : ``EQUALS``

            - **operator** *(string) --*

              Specifies how Device Farm compares the filter's attribute to the value. For the
              operators that are supported by each attribute, see the attribute descriptions.

            - **values** *(list) --*

              An array of one or more filter values used in a device filter.

               **Operator Values**

              * The IN and NOT_IN operators can take a values array that has more than one element.

              * The other operators require an array with a single element.

               **Attribute Values**

              * The PLATFORM attribute can be set to "ANDROID" or "IOS".

              * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
              or "TEMPORARY_NOT_AVAILABLE".

              * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

              * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

              - *(string) --*

        - **matchedDevicesCount** *(integer) --*

          The number of devices that matched the device filter selection criteria.

        - **maxDevices** *(integer) --*

          The maximum number of devices to be selected by a device filter and included in a test
          run.
    """


_ClientGetSuiteResponsesuitecountersTypeDef = TypedDict(
    "_ClientGetSuiteResponsesuitecountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ClientGetSuiteResponsesuitecountersTypeDef(
    _ClientGetSuiteResponsesuitecountersTypeDef
):
    """
    Type definition for `ClientGetSuiteResponsesuite` `counters`

    The suite's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ClientGetSuiteResponsesuitedeviceMinutesTypeDef = TypedDict(
    "_ClientGetSuiteResponsesuitedeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientGetSuiteResponsesuitedeviceMinutesTypeDef(
    _ClientGetSuiteResponsesuitedeviceMinutesTypeDef
):
    """
    Type definition for `ClientGetSuiteResponsesuite` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the test suite.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to run
      tests.
    """


_ClientGetSuiteResponsesuiteTypeDef = TypedDict(
    "_ClientGetSuiteResponsesuiteTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ClientGetSuiteResponsesuitecountersTypeDef,
        "message": str,
        "deviceMinutes": ClientGetSuiteResponsesuitedeviceMinutesTypeDef,
    },
    total=False,
)


class ClientGetSuiteResponsesuiteTypeDef(_ClientGetSuiteResponsesuiteTypeDef):
    """
    Type definition for `ClientGetSuiteResponse` `suite`

    A collection of one or more tests.

    - **arn** *(string) --*

      The suite's ARN.

    - **name** *(string) --*

      The suite's name.

    - **type** *(string) --*

      The suite's type.

      Must be one of the following values:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **created** *(datetime) --*

      When the suite was created.

    - **status** *(string) --*

      The suite's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The suite's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The suite's start time.

    - **stopped** *(datetime) --*

      The suite's stop time.

    - **counters** *(dict) --*

      The suite's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the suite's result.

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the test suite.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to run
        tests.
    """


_ClientGetSuiteResponseTypeDef = TypedDict(
    "_ClientGetSuiteResponseTypeDef",
    {"suite": ClientGetSuiteResponsesuiteTypeDef},
    total=False,
)


class ClientGetSuiteResponseTypeDef(_ClientGetSuiteResponseTypeDef):
    """
    Type definition for `ClientGetSuite` `Response`

    Represents the result of a get suite request.

    - **suite** *(dict) --*

      A collection of one or more tests.

      - **arn** *(string) --*

        The suite's ARN.

      - **name** *(string) --*

        The suite's name.

      - **type** *(string) --*

        The suite's type.

        Must be one of the following values:

        * BUILTIN_FUZZ: The built-in fuzz type.

        * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
        interacting with it and capturing screenshots at the same time.

        * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

        * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

        * APPIUM_PYTHON: The Appium Python type.

        * APPIUM_NODE: The Appium Node.js type.

        * APPIUM_RUBY: The Appium Ruby type.

        * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

        * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

        * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

        * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

        * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

        * CALABASH: The Calabash type.

        * INSTRUMENTATION: The Instrumentation type.

        * UIAUTOMATION: The uiautomation type.

        * UIAUTOMATOR: The uiautomator type.

        * XCTEST: The Xcode test type.

        * XCTEST_UI: The Xcode UI test type.

      - **created** *(datetime) --*

        When the suite was created.

      - **status** *(string) --*

        The suite's status.

        Allowed values include:

        * PENDING: A pending status.

        * PENDING_CONCURRENCY: A pending concurrency status.

        * PENDING_DEVICE: A pending device status.

        * PROCESSING: A processing status.

        * SCHEDULING: A scheduling status.

        * PREPARING: A preparing status.

        * RUNNING: A running status.

        * COMPLETED: A completed status.

        * STOPPING: A stopping status.

      - **result** *(string) --*

        The suite's result.

        Allowed values include:

        * PENDING: A pending condition.

        * PASSED: A passing condition.

        * WARNED: A warning condition.

        * FAILED: A failed condition.

        * SKIPPED: A skipped condition.

        * ERRORED: An error condition.

        * STOPPED: A stopped condition.

      - **started** *(datetime) --*

        The suite's start time.

      - **stopped** *(datetime) --*

        The suite's stop time.

      - **counters** *(dict) --*

        The suite's result counters.

        - **total** *(integer) --*

          The total number of entities.

        - **passed** *(integer) --*

          The number of passed entities.

        - **failed** *(integer) --*

          The number of failed entities.

        - **warned** *(integer) --*

          The number of warned entities.

        - **errored** *(integer) --*

          The number of errored entities.

        - **stopped** *(integer) --*

          The number of stopped entities.

        - **skipped** *(integer) --*

          The number of skipped entities.

      - **message** *(string) --*

        A message about the suite's result.

      - **deviceMinutes** *(dict) --*

        Represents the total (metered or unmetered) minutes used by the test suite.

        - **total** *(float) --*

          When specified, represents the total minutes used by the resource to run tests.

        - **metered** *(float) --*

          When specified, represents only the sum of metered minutes used by the resource to run
          tests.

        - **unmetered** *(float) --*

          When specified, represents only the sum of unmetered minutes used by the resource to run
          tests.
    """


_ClientGetTestResponsetestcountersTypeDef = TypedDict(
    "_ClientGetTestResponsetestcountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ClientGetTestResponsetestcountersTypeDef(
    _ClientGetTestResponsetestcountersTypeDef
):
    """
    Type definition for `ClientGetTestResponsetest` `counters`

    The test's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ClientGetTestResponsetestdeviceMinutesTypeDef = TypedDict(
    "_ClientGetTestResponsetestdeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientGetTestResponsetestdeviceMinutesTypeDef(
    _ClientGetTestResponsetestdeviceMinutesTypeDef
):
    """
    Type definition for `ClientGetTestResponsetest` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the test.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to run
      tests.
    """


_ClientGetTestResponsetestTypeDef = TypedDict(
    "_ClientGetTestResponsetestTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ClientGetTestResponsetestcountersTypeDef,
        "message": str,
        "deviceMinutes": ClientGetTestResponsetestdeviceMinutesTypeDef,
    },
    total=False,
)


class ClientGetTestResponsetestTypeDef(_ClientGetTestResponsetestTypeDef):
    """
    Type definition for `ClientGetTestResponse` `test`

    A test condition that is evaluated.

    - **arn** *(string) --*

      The test's ARN.

    - **name** *(string) --*

      The test's name.

    - **type** *(string) --*

      The test's type.

      Must be one of the following values:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **created** *(datetime) --*

      When the test was created.

    - **status** *(string) --*

      The test's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The test's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The test's start time.

    - **stopped** *(datetime) --*

      The test's stop time.

    - **counters** *(dict) --*

      The test's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the test's result.

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the test.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to run
        tests.
    """


_ClientGetTestResponseTypeDef = TypedDict(
    "_ClientGetTestResponseTypeDef",
    {"test": ClientGetTestResponsetestTypeDef},
    total=False,
)


class ClientGetTestResponseTypeDef(_ClientGetTestResponseTypeDef):
    """
    Type definition for `ClientGetTest` `Response`

    Represents the result of a get test request.

    - **test** *(dict) --*

      A test condition that is evaluated.

      - **arn** *(string) --*

        The test's ARN.

      - **name** *(string) --*

        The test's name.

      - **type** *(string) --*

        The test's type.

        Must be one of the following values:

        * BUILTIN_FUZZ: The built-in fuzz type.

        * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
        interacting with it and capturing screenshots at the same time.

        * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

        * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

        * APPIUM_PYTHON: The Appium Python type.

        * APPIUM_NODE: The Appium Node.js type.

        * APPIUM_RUBY: The Appium Ruby type.

        * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

        * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

        * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

        * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

        * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

        * CALABASH: The Calabash type.

        * INSTRUMENTATION: The Instrumentation type.

        * UIAUTOMATION: The uiautomation type.

        * UIAUTOMATOR: The uiautomator type.

        * XCTEST: The Xcode test type.

        * XCTEST_UI: The Xcode UI test type.

      - **created** *(datetime) --*

        When the test was created.

      - **status** *(string) --*

        The test's status.

        Allowed values include:

        * PENDING: A pending status.

        * PENDING_CONCURRENCY: A pending concurrency status.

        * PENDING_DEVICE: A pending device status.

        * PROCESSING: A processing status.

        * SCHEDULING: A scheduling status.

        * PREPARING: A preparing status.

        * RUNNING: A running status.

        * COMPLETED: A completed status.

        * STOPPING: A stopping status.

      - **result** *(string) --*

        The test's result.

        Allowed values include:

        * PENDING: A pending condition.

        * PASSED: A passing condition.

        * WARNED: A warning condition.

        * FAILED: A failed condition.

        * SKIPPED: A skipped condition.

        * ERRORED: An error condition.

        * STOPPED: A stopped condition.

      - **started** *(datetime) --*

        The test's start time.

      - **stopped** *(datetime) --*

        The test's stop time.

      - **counters** *(dict) --*

        The test's result counters.

        - **total** *(integer) --*

          The total number of entities.

        - **passed** *(integer) --*

          The number of passed entities.

        - **failed** *(integer) --*

          The number of failed entities.

        - **warned** *(integer) --*

          The number of warned entities.

        - **errored** *(integer) --*

          The number of errored entities.

        - **stopped** *(integer) --*

          The number of stopped entities.

        - **skipped** *(integer) --*

          The number of skipped entities.

      - **message** *(string) --*

        A message about the test's result.

      - **deviceMinutes** *(dict) --*

        Represents the total (metered or unmetered) minutes used by the test.

        - **total** *(float) --*

          When specified, represents the total minutes used by the resource to run tests.

        - **metered** *(float) --*

          When specified, represents only the sum of metered minutes used by the resource to run
          tests.

        - **unmetered** *(float) --*

          When specified, represents only the sum of unmetered minutes used by the resource to run
          tests.
    """


_ClientGetUploadResponseuploadTypeDef = TypedDict(
    "_ClientGetUploadResponseuploadTypeDef",
    {
        "arn": str,
        "name": str,
        "created": datetime,
        "type": str,
        "status": str,
        "url": str,
        "metadata": str,
        "contentType": str,
        "message": str,
        "category": str,
    },
    total=False,
)


class ClientGetUploadResponseuploadTypeDef(_ClientGetUploadResponseuploadTypeDef):
    """
    Type definition for `ClientGetUploadResponse` `upload`

    An app or a set of one or more tests to upload or that have been uploaded.

    - **arn** *(string) --*

      The upload's ARN.

    - **name** *(string) --*

      The upload's file name.

    - **created** *(datetime) --*

      When the upload was created.

    - **type** *(string) --*

      The upload's type.

      Must be one of the following values:

      * ANDROID_APP: An Android upload.

      * IOS_APP: An iOS upload.

      * WEB_APP: A web application upload.

      * EXTERNAL_DATA: An external data upload.

      * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.

      * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.

      * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.

      * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.

      * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.

      * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for web apps.

      * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for web
      apps.

      * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for web apps.

      * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for web apps.

      * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for web apps.

      * CALABASH_TEST_PACKAGE: A Calabash test package upload.

      * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.

      * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.

      * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.

      * XCTEST_TEST_PACKAGE: An Xcode test package upload.

      * XCTEST_UI_TEST_PACKAGE: An Xcode UI test package upload.

      * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.

      * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.

      * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.

      * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.

      * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.

      * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.

      * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.

      * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.

      * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.

      * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.

      * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.

      * XCTEST_UI_TEST_SPEC: An Xcode UI test spec upload.

    - **status** *(string) --*

      The upload's status.

      Must be one of the following values:

      * FAILED: A failed status.

      * INITIALIZED: An initialized status.

      * PROCESSING: A processing status.

      * SUCCEEDED: A succeeded status.

    - **url** *(string) --*

      The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT
      request.

    - **metadata** *(string) --*

      The upload's metadata. For example, for Android, this contains information that is parsed
      from the manifest and is displayed in the AWS Device Farm console after the associated app
      is uploaded.

    - **contentType** *(string) --*

      The upload's content type (for example, "application/octet-stream").

    - **message** *(string) --*

      A message about the upload's result.

    - **category** *(string) --*

      The upload's category. Allowed values include:

      * CURATED: An upload managed by AWS Device Farm.

      * PRIVATE: An upload managed by the AWS Device Farm customer.
    """


_ClientGetUploadResponseTypeDef = TypedDict(
    "_ClientGetUploadResponseTypeDef",
    {"upload": ClientGetUploadResponseuploadTypeDef},
    total=False,
)


class ClientGetUploadResponseTypeDef(_ClientGetUploadResponseTypeDef):
    """
    Type definition for `ClientGetUpload` `Response`

    Represents the result of a get upload request.

    - **upload** *(dict) --*

      An app or a set of one or more tests to upload or that have been uploaded.

      - **arn** *(string) --*

        The upload's ARN.

      - **name** *(string) --*

        The upload's file name.

      - **created** *(datetime) --*

        When the upload was created.

      - **type** *(string) --*

        The upload's type.

        Must be one of the following values:

        * ANDROID_APP: An Android upload.

        * IOS_APP: An iOS upload.

        * WEB_APP: A web application upload.

        * EXTERNAL_DATA: An external data upload.

        * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.

        * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.

        * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.

        * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.

        * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.

        * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for web apps.

        * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for web
        apps.

        * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for web apps.

        * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for web apps.

        * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for web apps.

        * CALABASH_TEST_PACKAGE: A Calabash test package upload.

        * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.

        * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.

        * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.

        * XCTEST_TEST_PACKAGE: An Xcode test package upload.

        * XCTEST_UI_TEST_PACKAGE: An Xcode UI test package upload.

        * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.

        * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.

        * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.

        * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.

        * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.

        * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.

        * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.

        * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.

        * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.

        * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.

        * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.

        * XCTEST_UI_TEST_SPEC: An Xcode UI test spec upload.

      - **status** *(string) --*

        The upload's status.

        Must be one of the following values:

        * FAILED: A failed status.

        * INITIALIZED: An initialized status.

        * PROCESSING: A processing status.

        * SUCCEEDED: A succeeded status.

      - **url** *(string) --*

        The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT
        request.

      - **metadata** *(string) --*

        The upload's metadata. For example, for Android, this contains information that is parsed
        from the manifest and is displayed in the AWS Device Farm console after the associated app
        is uploaded.

      - **contentType** *(string) --*

        The upload's content type (for example, "application/octet-stream").

      - **message** *(string) --*

        A message about the upload's result.

      - **category** *(string) --*

        The upload's category. Allowed values include:

        * CURATED: An upload managed by AWS Device Farm.

        * PRIVATE: An upload managed by the AWS Device Farm customer.
    """


_ClientGetVpceConfigurationResponsevpceConfigurationTypeDef = TypedDict(
    "_ClientGetVpceConfigurationResponsevpceConfigurationTypeDef",
    {
        "arn": str,
        "vpceConfigurationName": str,
        "vpceServiceName": str,
        "serviceDnsName": str,
        "vpceConfigurationDescription": str,
    },
    total=False,
)


class ClientGetVpceConfigurationResponsevpceConfigurationTypeDef(
    _ClientGetVpceConfigurationResponsevpceConfigurationTypeDef
):
    """
    Type definition for `ClientGetVpceConfigurationResponse` `vpceConfiguration`

    An object containing information about your VPC endpoint configuration.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the VPC endpoint configuration.

    - **vpceConfigurationName** *(string) --*

      The friendly name you give to your VPC endpoint configuration, to manage your
      configurations more easily.

    - **vpceServiceName** *(string) --*

      The name of the VPC endpoint service running inside your AWS account that you want Device
      Farm to test.

    - **serviceDnsName** *(string) --*

      The DNS name that maps to the private IP address of the service you want to access.

    - **vpceConfigurationDescription** *(string) --*

      An optional description, providing more details about your VPC endpoint configuration.
    """


_ClientGetVpceConfigurationResponseTypeDef = TypedDict(
    "_ClientGetVpceConfigurationResponseTypeDef",
    {"vpceConfiguration": ClientGetVpceConfigurationResponsevpceConfigurationTypeDef},
    total=False,
)


class ClientGetVpceConfigurationResponseTypeDef(
    _ClientGetVpceConfigurationResponseTypeDef
):
    """
    Type definition for `ClientGetVpceConfiguration` `Response`

    - **vpceConfiguration** *(dict) --*

      An object containing information about your VPC endpoint configuration.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the VPC endpoint configuration.

      - **vpceConfigurationName** *(string) --*

        The friendly name you give to your VPC endpoint configuration, to manage your
        configurations more easily.

      - **vpceServiceName** *(string) --*

        The name of the VPC endpoint service running inside your AWS account that you want Device
        Farm to test.

      - **serviceDnsName** *(string) --*

        The DNS name that maps to the private IP address of the service you want to access.

      - **vpceConfigurationDescription** *(string) --*

        An optional description, providing more details about your VPC endpoint configuration.
    """


_ClientInstallToRemoteAccessSessionResponseappUploadTypeDef = TypedDict(
    "_ClientInstallToRemoteAccessSessionResponseappUploadTypeDef",
    {
        "arn": str,
        "name": str,
        "created": datetime,
        "type": str,
        "status": str,
        "url": str,
        "metadata": str,
        "contentType": str,
        "message": str,
        "category": str,
    },
    total=False,
)


class ClientInstallToRemoteAccessSessionResponseappUploadTypeDef(
    _ClientInstallToRemoteAccessSessionResponseappUploadTypeDef
):
    """
    Type definition for `ClientInstallToRemoteAccessSessionResponse` `appUpload`

    An app to upload or that has been uploaded.

    - **arn** *(string) --*

      The upload's ARN.

    - **name** *(string) --*

      The upload's file name.

    - **created** *(datetime) --*

      When the upload was created.

    - **type** *(string) --*

      The upload's type.

      Must be one of the following values:

      * ANDROID_APP: An Android upload.

      * IOS_APP: An iOS upload.

      * WEB_APP: A web application upload.

      * EXTERNAL_DATA: An external data upload.

      * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.

      * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.

      * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.

      * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.

      * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.

      * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for web apps.

      * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for web
      apps.

      * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for web apps.

      * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for web apps.

      * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for web apps.

      * CALABASH_TEST_PACKAGE: A Calabash test package upload.

      * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.

      * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.

      * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.

      * XCTEST_TEST_PACKAGE: An Xcode test package upload.

      * XCTEST_UI_TEST_PACKAGE: An Xcode UI test package upload.

      * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.

      * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.

      * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.

      * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.

      * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.

      * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.

      * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.

      * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.

      * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.

      * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.

      * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.

      * XCTEST_UI_TEST_SPEC: An Xcode UI test spec upload.

    - **status** *(string) --*

      The upload's status.

      Must be one of the following values:

      * FAILED: A failed status.

      * INITIALIZED: An initialized status.

      * PROCESSING: A processing status.

      * SUCCEEDED: A succeeded status.

    - **url** *(string) --*

      The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT
      request.

    - **metadata** *(string) --*

      The upload's metadata. For example, for Android, this contains information that is parsed
      from the manifest and is displayed in the AWS Device Farm console after the associated app
      is uploaded.

    - **contentType** *(string) --*

      The upload's content type (for example, "application/octet-stream").

    - **message** *(string) --*

      A message about the upload's result.

    - **category** *(string) --*

      The upload's category. Allowed values include:

      * CURATED: An upload managed by AWS Device Farm.

      * PRIVATE: An upload managed by the AWS Device Farm customer.
    """


_ClientInstallToRemoteAccessSessionResponseTypeDef = TypedDict(
    "_ClientInstallToRemoteAccessSessionResponseTypeDef",
    {"appUpload": ClientInstallToRemoteAccessSessionResponseappUploadTypeDef},
    total=False,
)


class ClientInstallToRemoteAccessSessionResponseTypeDef(
    _ClientInstallToRemoteAccessSessionResponseTypeDef
):
    """
    Type definition for `ClientInstallToRemoteAccessSession` `Response`

    Represents the response from the server after AWS Device Farm makes a request to install to a
    remote access session.

    - **appUpload** *(dict) --*

      An app to upload or that has been uploaded.

      - **arn** *(string) --*

        The upload's ARN.

      - **name** *(string) --*

        The upload's file name.

      - **created** *(datetime) --*

        When the upload was created.

      - **type** *(string) --*

        The upload's type.

        Must be one of the following values:

        * ANDROID_APP: An Android upload.

        * IOS_APP: An iOS upload.

        * WEB_APP: A web application upload.

        * EXTERNAL_DATA: An external data upload.

        * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.

        * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.

        * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.

        * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.

        * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.

        * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for web apps.

        * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for web
        apps.

        * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for web apps.

        * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for web apps.

        * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for web apps.

        * CALABASH_TEST_PACKAGE: A Calabash test package upload.

        * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.

        * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.

        * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.

        * XCTEST_TEST_PACKAGE: An Xcode test package upload.

        * XCTEST_UI_TEST_PACKAGE: An Xcode UI test package upload.

        * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.

        * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.

        * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.

        * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.

        * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.

        * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.

        * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.

        * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.

        * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.

        * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.

        * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.

        * XCTEST_UI_TEST_SPEC: An Xcode UI test spec upload.

      - **status** *(string) --*

        The upload's status.

        Must be one of the following values:

        * FAILED: A failed status.

        * INITIALIZED: An initialized status.

        * PROCESSING: A processing status.

        * SUCCEEDED: A succeeded status.

      - **url** *(string) --*

        The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT
        request.

      - **metadata** *(string) --*

        The upload's metadata. For example, for Android, this contains information that is parsed
        from the manifest and is displayed in the AWS Device Farm console after the associated app
        is uploaded.

      - **contentType** *(string) --*

        The upload's content type (for example, "application/octet-stream").

      - **message** *(string) --*

        A message about the upload's result.

      - **category** *(string) --*

        The upload's category. Allowed values include:

        * CURATED: An upload managed by AWS Device Farm.

        * PRIVATE: An upload managed by the AWS Device Farm customer.
    """


_ClientListArtifactsResponseartifactsTypeDef = TypedDict(
    "_ClientListArtifactsResponseartifactsTypeDef",
    {"arn": str, "name": str, "type": str, "extension": str, "url": str},
    total=False,
)


class ClientListArtifactsResponseartifactsTypeDef(
    _ClientListArtifactsResponseartifactsTypeDef
):
    """
    Type definition for `ClientListArtifactsResponse` `artifacts`

    Represents the output of a test. Examples of artifacts include logs and screenshots.

    - **arn** *(string) --*

      The artifact's ARN.

    - **name** *(string) --*

      The artifact's name.

    - **type** *(string) --*

      The artifact's type.

      Allowed values include the following:

      * UNKNOWN: An unknown type.

      * SCREENSHOT: The screenshot type.

      * DEVICE_LOG: The device log type.

      * MESSAGE_LOG: The message log type.

      * VIDEO_LOG: The video log type.

      * RESULT_LOG: The result log type.

      * SERVICE_LOG: The service log type.

      * WEBKIT_LOG: The web kit log type.

      * INSTRUMENTATION_OUTPUT: The instrumentation type.

      * EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz
      test.

      * CALABASH_JSON_OUTPUT: The Calabash JSON output type.

      * CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.

      * CALABASH_STANDARD_OUTPUT: The Calabash standard output type.

      * CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.

      * AUTOMATION_OUTPUT: The automation output type.

      * APPIUM_SERVER_OUTPUT: The Appium server output type.

      * APPIUM_JAVA_OUTPUT: The Appium Java output type.

      * APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.

      * APPIUM_PYTHON_OUTPUT: The Appium Python output type.

      * APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.

      * EXPLORER_EVENT_LOG: The Explorer event log output type.

      * EXPLORER_SUMMARY_LOG: The Explorer summary log output type.

      * APPLICATION_CRASH_REPORT: The application crash report output type.

      * XCTEST_LOG: The Xcode test output type.

      * VIDEO: The Video output type.

      * CUSTOMER_ARTIFACT:The Customer Artifact output type.

      * CUSTOMER_ARTIFACT_LOG: The Customer Artifact Log output type.

      * TESTSPEC_OUTPUT: The Test Spec Output type.

    - **extension** *(string) --*

      The artifact's file extension.

    - **url** *(string) --*

      The pre-signed Amazon S3 URL that can be used with a corresponding GET request to
      download the artifact's file.
    """


_ClientListArtifactsResponseTypeDef = TypedDict(
    "_ClientListArtifactsResponseTypeDef",
    {"artifacts": List[ClientListArtifactsResponseartifactsTypeDef], "nextToken": str},
    total=False,
)


class ClientListArtifactsResponseTypeDef(_ClientListArtifactsResponseTypeDef):
    """
    Type definition for `ClientListArtifacts` `Response`

    Represents the result of a list artifacts operation.

    - **artifacts** *(list) --*

      Information about the artifacts.

      - *(dict) --*

        Represents the output of a test. Examples of artifacts include logs and screenshots.

        - **arn** *(string) --*

          The artifact's ARN.

        - **name** *(string) --*

          The artifact's name.

        - **type** *(string) --*

          The artifact's type.

          Allowed values include the following:

          * UNKNOWN: An unknown type.

          * SCREENSHOT: The screenshot type.

          * DEVICE_LOG: The device log type.

          * MESSAGE_LOG: The message log type.

          * VIDEO_LOG: The video log type.

          * RESULT_LOG: The result log type.

          * SERVICE_LOG: The service log type.

          * WEBKIT_LOG: The web kit log type.

          * INSTRUMENTATION_OUTPUT: The instrumentation type.

          * EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz
          test.

          * CALABASH_JSON_OUTPUT: The Calabash JSON output type.

          * CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.

          * CALABASH_STANDARD_OUTPUT: The Calabash standard output type.

          * CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.

          * AUTOMATION_OUTPUT: The automation output type.

          * APPIUM_SERVER_OUTPUT: The Appium server output type.

          * APPIUM_JAVA_OUTPUT: The Appium Java output type.

          * APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.

          * APPIUM_PYTHON_OUTPUT: The Appium Python output type.

          * APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.

          * EXPLORER_EVENT_LOG: The Explorer event log output type.

          * EXPLORER_SUMMARY_LOG: The Explorer summary log output type.

          * APPLICATION_CRASH_REPORT: The application crash report output type.

          * XCTEST_LOG: The Xcode test output type.

          * VIDEO: The Video output type.

          * CUSTOMER_ARTIFACT:The Customer Artifact output type.

          * CUSTOMER_ARTIFACT_LOG: The Customer Artifact Log output type.

          * TESTSPEC_OUTPUT: The Test Spec Output type.

        - **extension** *(string) --*

          The artifact's file extension.

        - **url** *(string) --*

          The pre-signed Amazon S3 URL that can be used with a corresponding GET request to
          download the artifact's file.

    - **nextToken** *(string) --*

      If the number of items that are returned is significantly large, this is an identifier that
      is also returned, which can be used in a subsequent call to this operation to return the next
      set of items in the list.
    """


_ClientListDeviceInstancesResponsedeviceInstancesinstanceProfileTypeDef = TypedDict(
    "_ClientListDeviceInstancesResponsedeviceInstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientListDeviceInstancesResponsedeviceInstancesinstanceProfileTypeDef(
    _ClientListDeviceInstancesResponsedeviceInstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientListDeviceInstancesResponsedeviceInstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned up
      from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientListDeviceInstancesResponsedeviceInstancesTypeDef = TypedDict(
    "_ClientListDeviceInstancesResponsedeviceInstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientListDeviceInstancesResponsedeviceInstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientListDeviceInstancesResponsedeviceInstancesTypeDef(
    _ClientListDeviceInstancesResponsedeviceInstancesTypeDef
):
    """
    Type definition for `ClientListDeviceInstancesResponse` `deviceInstances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned up
        from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientListDeviceInstancesResponseTypeDef = TypedDict(
    "_ClientListDeviceInstancesResponseTypeDef",
    {
        "deviceInstances": List[
            ClientListDeviceInstancesResponsedeviceInstancesTypeDef
        ],
        "nextToken": str,
    },
    total=False,
)


class ClientListDeviceInstancesResponseTypeDef(
    _ClientListDeviceInstancesResponseTypeDef
):
    """
    Type definition for `ClientListDeviceInstances` `Response`

    - **deviceInstances** *(list) --*

      An object containing information about your device instances.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be cleaned up
            from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **nextToken** *(string) --*

      An identifier that can be used in the next call to this operation to return the next set of
      items in the list.
    """


_ClientListDevicePoolsResponsedevicePoolsrulesTypeDef = TypedDict(
    "_ClientListDevicePoolsResponsedevicePoolsrulesTypeDef",
    {"attribute": str, "operator": str, "value": str},
    total=False,
)


class ClientListDevicePoolsResponsedevicePoolsrulesTypeDef(
    _ClientListDevicePoolsResponsedevicePoolsrulesTypeDef
):
    """
    Type definition for `ClientListDevicePoolsResponsedevicePools` `rules`

    Represents a condition for a device pool.

    - **attribute** *(string) --*

      The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

      The supported operators for each attribute are provided in the following list.

        APPIUM_VERSION

      The Appium version for the test.

       *Supported operators* : ``CONTAINS``

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE",
      "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        MODEL

      The device model, such as "Apple iPad Air 2" or "Google Pixel".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
       ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

      Whether the device is enabled for remote debugging. Valid values are "TRUE" or
      "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **operator** *(string) --*

      Specifies how Device Farm compares the rule's attribute to the value. For the
      operators that are supported by each attribute, see the attribute descriptions.

    - **value** *(string) --*

      The rule's value.
    """


_ClientListDevicePoolsResponsedevicePoolsTypeDef = TypedDict(
    "_ClientListDevicePoolsResponsedevicePoolsTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "rules": List[ClientListDevicePoolsResponsedevicePoolsrulesTypeDef],
        "maxDevices": int,
    },
    total=False,
)


class ClientListDevicePoolsResponsedevicePoolsTypeDef(
    _ClientListDevicePoolsResponsedevicePoolsTypeDef
):
    """
    Type definition for `ClientListDevicePoolsResponse` `devicePools`

    Represents a collection of device types.

    - **arn** *(string) --*

      The device pool's ARN.

    - **name** *(string) --*

      The device pool's name.

    - **description** *(string) --*

      The device pool's description.

    - **type** *(string) --*

      The device pool's type.

      Allowed values include:

      * CURATED: A device pool that is created and managed by AWS Device Farm.

      * PRIVATE: A device pool that is created and managed by the device pool developer.

    - **rules** *(list) --*

      Information about the device pool's rules.

      - *(dict) --*

        Represents a condition for a device pool.

        - **attribute** *(string) --*

          The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

          The supported operators for each attribute are provided in the following list.

            APPIUM_VERSION

          The Appium version for the test.

           *Supported operators* : ``CONTAINS``

            ARN

          The Amazon Resource Name (ARN) of the device. For example,
          "arn:aws:devicefarm:us-west-2::device:12345Example".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            AVAILABILITY

          The current availability of the device. Valid values are "AVAILABLE",
          "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

           *Supported operators* : ``EQUALS``

            FLEET_TYPE

          The fleet type. Valid values are "PUBLIC" or "PRIVATE".

           *Supported operators* : ``EQUALS``

            FORM_FACTOR

          The device form factor. Valid values are "PHONE" or "TABLET".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            INSTANCE_ARN

          The Amazon Resource Name (ARN) of the device instance.

           *Supported operators* : ``IN`` , ``NOT_IN``

            INSTANCE_LABELS

          The label of the device instance.

           *Supported operators* : ``CONTAINS``

            MANUFACTURER

          The device manufacturer. For example, "Apple".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            MODEL

          The device model, such as "Apple iPad Air 2" or "Google Pixel".

           *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

            OS_VERSION

          The operating system version. For example, "10.3.2".

           *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
           ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

            PLATFORM

          The device platform. Valid values are "ANDROID" or "IOS".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            REMOTE_ACCESS_ENABLED

          Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

            REMOTE_DEBUG_ENABLED

          Whether the device is enabled for remote debugging. Valid values are "TRUE" or
          "FALSE".

           *Supported operators* : ``EQUALS``

           *This filter will be ignored, as remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **operator** *(string) --*

          Specifies how Device Farm compares the rule's attribute to the value. For the
          operators that are supported by each attribute, see the attribute descriptions.

        - **value** *(string) --*

          The rule's value.

    - **maxDevices** *(integer) --*

      The number of devices that Device Farm can add to your device pool. Device Farm adds
      devices that are available and that meet the criteria that you assign for the ``rules``
      parameter. Depending on how many devices meet these constraints, your device pool might
      contain fewer devices than the value for this parameter.

      By specifying the maximum number of devices, you can control the costs that you incur by
      running tests.
    """


_ClientListDevicePoolsResponseTypeDef = TypedDict(
    "_ClientListDevicePoolsResponseTypeDef",
    {
        "devicePools": List[ClientListDevicePoolsResponsedevicePoolsTypeDef],
        "nextToken": str,
    },
    total=False,
)


class ClientListDevicePoolsResponseTypeDef(_ClientListDevicePoolsResponseTypeDef):
    """
    Type definition for `ClientListDevicePools` `Response`

    Represents the result of a list device pools request.

    - **devicePools** *(list) --*

      Information about the device pools.

      - *(dict) --*

        Represents a collection of device types.

        - **arn** *(string) --*

          The device pool's ARN.

        - **name** *(string) --*

          The device pool's name.

        - **description** *(string) --*

          The device pool's description.

        - **type** *(string) --*

          The device pool's type.

          Allowed values include:

          * CURATED: A device pool that is created and managed by AWS Device Farm.

          * PRIVATE: A device pool that is created and managed by the device pool developer.

        - **rules** *(list) --*

          Information about the device pool's rules.

          - *(dict) --*

            Represents a condition for a device pool.

            - **attribute** *(string) --*

              The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

              The supported operators for each attribute are provided in the following list.

                APPIUM_VERSION

              The Appium version for the test.

               *Supported operators* : ``CONTAINS``

                ARN

              The Amazon Resource Name (ARN) of the device. For example,
              "arn:aws:devicefarm:us-west-2::device:12345Example".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                AVAILABILITY

              The current availability of the device. Valid values are "AVAILABLE",
              "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

               *Supported operators* : ``EQUALS``

                FLEET_TYPE

              The fleet type. Valid values are "PUBLIC" or "PRIVATE".

               *Supported operators* : ``EQUALS``

                FORM_FACTOR

              The device form factor. Valid values are "PHONE" or "TABLET".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                INSTANCE_ARN

              The Amazon Resource Name (ARN) of the device instance.

               *Supported operators* : ``IN`` , ``NOT_IN``

                INSTANCE_LABELS

              The label of the device instance.

               *Supported operators* : ``CONTAINS``

                MANUFACTURER

              The device manufacturer. For example, "Apple".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                MODEL

              The device model, such as "Apple iPad Air 2" or "Google Pixel".

               *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

                OS_VERSION

              The operating system version. For example, "10.3.2".

               *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
               ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

                PLATFORM

              The device platform. Valid values are "ANDROID" or "IOS".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                REMOTE_ACCESS_ENABLED

              Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

               *Supported operators* : ``EQUALS``

                REMOTE_DEBUG_ENABLED

              Whether the device is enabled for remote debugging. Valid values are "TRUE" or
              "FALSE".

               *Supported operators* : ``EQUALS``

               *This filter will be ignored, as remote debugging is `no longer supported
               <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

            - **operator** *(string) --*

              Specifies how Device Farm compares the rule's attribute to the value. For the
              operators that are supported by each attribute, see the attribute descriptions.

            - **value** *(string) --*

              The rule's value.

        - **maxDevices** *(integer) --*

          The number of devices that Device Farm can add to your device pool. Device Farm adds
          devices that are available and that meet the criteria that you assign for the ``rules``
          parameter. Depending on how many devices meet these constraints, your device pool might
          contain fewer devices than the value for this parameter.

          By specifying the maximum number of devices, you can control the costs that you incur by
          running tests.

    - **nextToken** *(string) --*

      If the number of items that are returned is significantly large, this is an identifier that
      is also returned, which can be used in a subsequent call to this operation to return the next
      set of items in the list.
    """


_ClientListDevicesResponsedevicescpuTypeDef = TypedDict(
    "_ClientListDevicesResponsedevicescpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientListDevicesResponsedevicescpuTypeDef(
    _ClientListDevicesResponsedevicescpuTypeDef
):
    """
    Type definition for `ClientListDevicesResponsedevices` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ClientListDevicesResponsedevicesinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientListDevicesResponsedevicesinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientListDevicesResponsedevicesinstancesinstanceProfileTypeDef(
    _ClientListDevicesResponsedevicesinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientListDevicesResponsedevicesinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned
      up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientListDevicesResponsedevicesinstancesTypeDef = TypedDict(
    "_ClientListDevicesResponsedevicesinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientListDevicesResponsedevicesinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientListDevicesResponsedevicesinstancesTypeDef(
    _ClientListDevicesResponsedevicesinstancesTypeDef
):
    """
    Type definition for `ClientListDevicesResponsedevices` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned
        up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientListDevicesResponsedevicesresolutionTypeDef = TypedDict(
    "_ClientListDevicesResponsedevicesresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientListDevicesResponsedevicesresolutionTypeDef(
    _ClientListDevicesResponsedevicesresolutionTypeDef
):
    """
    Type definition for `ClientListDevicesResponsedevices` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientListDevicesResponsedevicesTypeDef = TypedDict(
    "_ClientListDevicesResponsedevicesTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientListDevicesResponsedevicescpuTypeDef,
        "resolution": ClientListDevicesResponsedevicesresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[ClientListDevicesResponsedevicesinstancesTypeDef],
        "availability": str,
    },
    total=False,
)


class ClientListDevicesResponsedevicesTypeDef(_ClientListDevicesResponsedevicesTypeDef):
    """
    Type definition for `ClientListDevicesResponse` `devices`

    Represents a device type that an app is tested against.

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be cleaned
            up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently available
      in the ListDevices and GetDevice API methods.
    """


_ClientListDevicesResponseTypeDef = TypedDict(
    "_ClientListDevicesResponseTypeDef",
    {"devices": List[ClientListDevicesResponsedevicesTypeDef], "nextToken": str},
    total=False,
)


class ClientListDevicesResponseTypeDef(_ClientListDevicesResponseTypeDef):
    """
    Type definition for `ClientListDevices` `Response`

    Represents the result of a list devices operation.

    - **devices** *(list) --*

      Information about the devices.

      - *(dict) --*

        Represents a device type that an app is tested against.

        - **arn** *(string) --*

          The device's ARN.

        - **name** *(string) --*

          The device's display name.

        - **manufacturer** *(string) --*

          The device's manufacturer name.

        - **model** *(string) --*

          The device's model name.

        - **modelId** *(string) --*

          The device's model ID.

        - **formFactor** *(string) --*

          The device's form factor.

          Allowed values include:

          * PHONE: The phone form factor.

          * TABLET: The tablet form factor.

        - **platform** *(string) --*

          The device's platform.

          Allowed values include:

          * ANDROID: The Android platform.

          * IOS: The iOS platform.

        - **os** *(string) --*

          The device's operating system type.

        - **cpu** *(dict) --*

          Information about the device's CPU.

          - **frequency** *(string) --*

            The CPU's frequency.

          - **architecture** *(string) --*

            The CPU's architecture, for example x86 or ARM.

          - **clock** *(float) --*

            The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
            CPU is expressed as 1200000000.

        - **resolution** *(dict) --*

          The resolution of the device.

          - **width** *(integer) --*

            The screen resolution's width, expressed in pixels.

          - **height** *(integer) --*

            The screen resolution's height, expressed in pixels.

        - **heapSize** *(integer) --*

          The device's heap size, expressed in bytes.

        - **memory** *(integer) --*

          The device's total memory size, expressed in bytes.

        - **image** *(string) --*

          The device's image name.

        - **carrier** *(string) --*

          The device's carrier.

        - **radio** *(string) --*

          The device's radio.

        - **remoteAccessEnabled** *(boolean) --*

          Specifies whether remote access has been enabled for the specified device.

        - **remoteDebugEnabled** *(boolean) --*

          This flag is set to ``true`` if remote debugging is enabled for the device.

           *Remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **fleetType** *(string) --*

          The type of fleet to which this device belongs. Possible values for fleet type are
          PRIVATE and PUBLIC.

        - **fleetName** *(string) --*

          The name of the fleet to which this device belongs.

        - **instances** *(list) --*

          The instances belonging to this device.

          - *(dict) --*

            Represents the device instance.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the device instance.

            - **deviceArn** *(string) --*

              The Amazon Resource Name (ARN) of the device.

            - **labels** *(list) --*

              An array of strings describing the device instance.

              - *(string) --*

            - **status** *(string) --*

              The status of the device instance. Valid values are listed below.

            - **udid** *(string) --*

              Unique device identifier for the device instance.

            - **instanceProfile** *(dict) --*

              A object containing information about the instance profile.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the instance profile.

              - **packageCleanup** *(boolean) --*

                When set to ``true`` , Device Farm will remove app packages after a test run. The
                default value is ``false`` for private devices.

              - **excludeAppPackagesFromCleanup** *(list) --*

                An array of strings specifying the list of app packages that should not be cleaned
                up from the device after a test run is over.

                The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

                - *(string) --*

              - **rebootAfterUse** *(boolean) --*

                When set to ``true`` , Device Farm will reboot the instance after a test run. The
                default value is ``true`` .

              - **name** *(string) --*

                The name of the instance profile.

              - **description** *(string) --*

                The description of the instance profile.

        - **availability** *(string) --*

          Reflects how likely a device will be available for a test run. It is currently available
          in the ListDevices and GetDevice API methods.

    - **nextToken** *(string) --*

      If the number of items that are returned is significantly large, this is an identifier that
      is also returned, which can be used in a subsequent call to this operation to return the next
      set of items in the list.
    """


_ClientListDevicesfiltersTypeDef = TypedDict(
    "_ClientListDevicesfiltersTypeDef",
    {"attribute": str, "operator": str, "values": List[str]},
    total=False,
)


class ClientListDevicesfiltersTypeDef(_ClientListDevicesfiltersTypeDef):
    """
    Type definition for `ClientListDevices` `filters`

    Represents a device filter used to select a set of devices to be included in a test run. This
    data structure is passed in as the ``deviceSelectionConfiguration`` parameter to ScheduleRun.
    For an example of the JSON request syntax, see  ScheduleRun .

    It is also passed in as the ``filters`` parameter to ListDevices. For an example of the JSON
    request syntax, see  ListDevices .

    - **attribute** *(string) --*

      The aspect of a device such as platform or model used as the selection criteria in a device
      filter.

      The supported operators for each attribute are provided in the following list.

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` , ``IN``
       , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        MODEL

      The device model. For example, "iPad 5th Gen".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE", "HIGHLY_AVAILABLE",
      "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

       *Ignored.* Whether the device is enabled for remote debugging. Valid values are "TRUE" or
       "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

    - **operator** *(string) --*

      Specifies how Device Farm compares the filter's attribute to the value. For the operators
      that are supported by each attribute, see the attribute descriptions.

    - **values** *(list) --*

      An array of one or more filter values used in a device filter.

       **Operator Values**

      * The IN and NOT_IN operators can take a values array that has more than one element.

      * The other operators require an array with a single element.

       **Attribute Values**

      * The PLATFORM attribute can be set to "ANDROID" or "IOS".

      * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY", or
      "TEMPORARY_NOT_AVAILABLE".

      * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

      * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

      - *(string) --*
    """


_ClientListInstanceProfilesResponseinstanceProfilesTypeDef = TypedDict(
    "_ClientListInstanceProfilesResponseinstanceProfilesTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientListInstanceProfilesResponseinstanceProfilesTypeDef(
    _ClientListInstanceProfilesResponseinstanceProfilesTypeDef
):
    """
    Type definition for `ClientListInstanceProfilesResponse` `instanceProfiles`

    Represents the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The default
      value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned up
      from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The default
      value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientListInstanceProfilesResponseTypeDef = TypedDict(
    "_ClientListInstanceProfilesResponseTypeDef",
    {
        "instanceProfiles": List[
            ClientListInstanceProfilesResponseinstanceProfilesTypeDef
        ],
        "nextToken": str,
    },
    total=False,
)


class ClientListInstanceProfilesResponseTypeDef(
    _ClientListInstanceProfilesResponseTypeDef
):
    """
    Type definition for `ClientListInstanceProfiles` `Response`

    - **instanceProfiles** *(list) --*

      An object containing information about your instance profiles.

      - *(dict) --*

        Represents the instance profile.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the instance profile.

        - **packageCleanup** *(boolean) --*

          When set to ``true`` , Device Farm will remove app packages after a test run. The default
          value is ``false`` for private devices.

        - **excludeAppPackagesFromCleanup** *(list) --*

          An array of strings specifying the list of app packages that should not be cleaned up
          from the device after a test run is over.

          The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

          - *(string) --*

        - **rebootAfterUse** *(boolean) --*

          When set to ``true`` , Device Farm will reboot the instance after a test run. The default
          value is ``true`` .

        - **name** *(string) --*

          The name of the instance profile.

        - **description** *(string) --*

          The description of the instance profile.

    - **nextToken** *(string) --*

      An identifier that can be used in the next call to this operation to return the next set of
      items in the list.
    """


_ClientListJobsResponsejobscountersTypeDef = TypedDict(
    "_ClientListJobsResponsejobscountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ClientListJobsResponsejobscountersTypeDef(
    _ClientListJobsResponsejobscountersTypeDef
):
    """
    Type definition for `ClientListJobsResponsejobs` `counters`

    The job's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ClientListJobsResponsejobsdeviceMinutesTypeDef = TypedDict(
    "_ClientListJobsResponsejobsdeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientListJobsResponsejobsdeviceMinutesTypeDef(
    _ClientListJobsResponsejobsdeviceMinutesTypeDef
):
    """
    Type definition for `ClientListJobsResponsejobs` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the job.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to
      run tests.
    """


_ClientListJobsResponsejobsdevicecpuTypeDef = TypedDict(
    "_ClientListJobsResponsejobsdevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientListJobsResponsejobsdevicecpuTypeDef(
    _ClientListJobsResponsejobsdevicecpuTypeDef
):
    """
    Type definition for `ClientListJobsResponsejobsdevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ClientListJobsResponsejobsdeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientListJobsResponsejobsdeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientListJobsResponsejobsdeviceinstancesinstanceProfileTypeDef(
    _ClientListJobsResponsejobsdeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientListJobsResponsejobsdeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be
      cleaned up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true``
      .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientListJobsResponsejobsdeviceinstancesTypeDef = TypedDict(
    "_ClientListJobsResponsejobsdeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientListJobsResponsejobsdeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientListJobsResponsejobsdeviceinstancesTypeDef(
    _ClientListJobsResponsejobsdeviceinstancesTypeDef
):
    """
    Type definition for `ClientListJobsResponsejobsdevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be
        cleaned up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true``
        .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientListJobsResponsejobsdeviceresolutionTypeDef = TypedDict(
    "_ClientListJobsResponsejobsdeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientListJobsResponsejobsdeviceresolutionTypeDef(
    _ClientListJobsResponsejobsdeviceresolutionTypeDef
):
    """
    Type definition for `ClientListJobsResponsejobsdevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientListJobsResponsejobsdeviceTypeDef = TypedDict(
    "_ClientListJobsResponsejobsdeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientListJobsResponsejobsdevicecpuTypeDef,
        "resolution": ClientListJobsResponsejobsdeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[ClientListJobsResponsejobsdeviceinstancesTypeDef],
        "availability": str,
    },
    total=False,
)


class ClientListJobsResponsejobsdeviceTypeDef(_ClientListJobsResponsejobsdeviceTypeDef):
    """
    Type definition for `ClientListJobsResponsejobs` `device`

    The device (phone or tablet).

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be
            cleaned up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true``
            .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently
      available in the ListDevices and GetDevice API methods.
    """


_ClientListJobsResponsejobsTypeDef = TypedDict(
    "_ClientListJobsResponsejobsTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ClientListJobsResponsejobscountersTypeDef,
        "message": str,
        "device": ClientListJobsResponsejobsdeviceTypeDef,
        "instanceArn": str,
        "deviceMinutes": ClientListJobsResponsejobsdeviceMinutesTypeDef,
        "videoEndpoint": str,
        "videoCapture": bool,
    },
    total=False,
)


class ClientListJobsResponsejobsTypeDef(_ClientListJobsResponsejobsTypeDef):
    """
    Type definition for `ClientListJobsResponse` `jobs`

    Represents a device.

    - **arn** *(string) --*

      The job's ARN.

    - **name** *(string) --*

      The job's name.

    - **type** *(string) --*

      The job's type.

      Allowed values include the following:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby test type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **created** *(datetime) --*

      When the job was created.

    - **status** *(string) --*

      The job's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The job's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The job's start time.

    - **stopped** *(datetime) --*

      The job's stop time.

    - **counters** *(dict) --*

      The job's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the job's result.

    - **device** *(dict) --*

      The device (phone or tablet).

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
          CPU is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type are
        PRIVATE and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test run. The
              default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not be
              cleaned up from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to ``true``
              .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test run. The
              default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently
        available in the ListDevices and GetDevice API methods.

    - **instanceArn** *(string) --*

      The Amazon Resource Name (ARN) of the instance.

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the job.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to
        run tests.

    - **videoEndpoint** *(string) --*

      The endpoint for streaming device video.

    - **videoCapture** *(boolean) --*

      This value is set to true if video capture is enabled; otherwise, it is set to false.
    """


_ClientListJobsResponseTypeDef = TypedDict(
    "_ClientListJobsResponseTypeDef",
    {"jobs": List[ClientListJobsResponsejobsTypeDef], "nextToken": str},
    total=False,
)


class ClientListJobsResponseTypeDef(_ClientListJobsResponseTypeDef):
    """
    Type definition for `ClientListJobs` `Response`

    Represents the result of a list jobs request.

    - **jobs** *(list) --*

      Information about the jobs.

      - *(dict) --*

        Represents a device.

        - **arn** *(string) --*

          The job's ARN.

        - **name** *(string) --*

          The job's name.

        - **type** *(string) --*

          The job's type.

          Allowed values include the following:

          * BUILTIN_FUZZ: The built-in fuzz type.

          * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
          interacting with it and capturing screenshots at the same time.

          * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

          * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

          * APPIUM_PYTHON: The Appium Python type.

          * APPIUM_NODE: The Appium Node.js type.

          * APPIUM_RUBY: The Appium Ruby type.

          * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

          * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

          * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

          * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

          * APPIUM_WEB_RUBY: The Appium Ruby test type for web apps.

          * CALABASH: The Calabash type.

          * INSTRUMENTATION: The Instrumentation type.

          * UIAUTOMATION: The uiautomation type.

          * UIAUTOMATOR: The uiautomator type.

          * XCTEST: The Xcode test type.

          * XCTEST_UI: The Xcode UI test type.

        - **created** *(datetime) --*

          When the job was created.

        - **status** *(string) --*

          The job's status.

          Allowed values include:

          * PENDING: A pending status.

          * PENDING_CONCURRENCY: A pending concurrency status.

          * PENDING_DEVICE: A pending device status.

          * PROCESSING: A processing status.

          * SCHEDULING: A scheduling status.

          * PREPARING: A preparing status.

          * RUNNING: A running status.

          * COMPLETED: A completed status.

          * STOPPING: A stopping status.

        - **result** *(string) --*

          The job's result.

          Allowed values include:

          * PENDING: A pending condition.

          * PASSED: A passing condition.

          * WARNED: A warning condition.

          * FAILED: A failed condition.

          * SKIPPED: A skipped condition.

          * ERRORED: An error condition.

          * STOPPED: A stopped condition.

        - **started** *(datetime) --*

          The job's start time.

        - **stopped** *(datetime) --*

          The job's stop time.

        - **counters** *(dict) --*

          The job's result counters.

          - **total** *(integer) --*

            The total number of entities.

          - **passed** *(integer) --*

            The number of passed entities.

          - **failed** *(integer) --*

            The number of failed entities.

          - **warned** *(integer) --*

            The number of warned entities.

          - **errored** *(integer) --*

            The number of errored entities.

          - **stopped** *(integer) --*

            The number of stopped entities.

          - **skipped** *(integer) --*

            The number of skipped entities.

        - **message** *(string) --*

          A message about the job's result.

        - **device** *(dict) --*

          The device (phone or tablet).

          - **arn** *(string) --*

            The device's ARN.

          - **name** *(string) --*

            The device's display name.

          - **manufacturer** *(string) --*

            The device's manufacturer name.

          - **model** *(string) --*

            The device's model name.

          - **modelId** *(string) --*

            The device's model ID.

          - **formFactor** *(string) --*

            The device's form factor.

            Allowed values include:

            * PHONE: The phone form factor.

            * TABLET: The tablet form factor.

          - **platform** *(string) --*

            The device's platform.

            Allowed values include:

            * ANDROID: The Android platform.

            * IOS: The iOS platform.

          - **os** *(string) --*

            The device's operating system type.

          - **cpu** *(dict) --*

            Information about the device's CPU.

            - **frequency** *(string) --*

              The CPU's frequency.

            - **architecture** *(string) --*

              The CPU's architecture, for example x86 or ARM.

            - **clock** *(float) --*

              The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
              CPU is expressed as 1200000000.

          - **resolution** *(dict) --*

            The resolution of the device.

            - **width** *(integer) --*

              The screen resolution's width, expressed in pixels.

            - **height** *(integer) --*

              The screen resolution's height, expressed in pixels.

          - **heapSize** *(integer) --*

            The device's heap size, expressed in bytes.

          - **memory** *(integer) --*

            The device's total memory size, expressed in bytes.

          - **image** *(string) --*

            The device's image name.

          - **carrier** *(string) --*

            The device's carrier.

          - **radio** *(string) --*

            The device's radio.

          - **remoteAccessEnabled** *(boolean) --*

            Specifies whether remote access has been enabled for the specified device.

          - **remoteDebugEnabled** *(boolean) --*

            This flag is set to ``true`` if remote debugging is enabled for the device.

             *Remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

          - **fleetType** *(string) --*

            The type of fleet to which this device belongs. Possible values for fleet type are
            PRIVATE and PUBLIC.

          - **fleetName** *(string) --*

            The name of the fleet to which this device belongs.

          - **instances** *(list) --*

            The instances belonging to this device.

            - *(dict) --*

              Represents the device instance.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the device instance.

              - **deviceArn** *(string) --*

                The Amazon Resource Name (ARN) of the device.

              - **labels** *(list) --*

                An array of strings describing the device instance.

                - *(string) --*

              - **status** *(string) --*

                The status of the device instance. Valid values are listed below.

              - **udid** *(string) --*

                Unique device identifier for the device instance.

              - **instanceProfile** *(dict) --*

                A object containing information about the instance profile.

                - **arn** *(string) --*

                  The Amazon Resource Name (ARN) of the instance profile.

                - **packageCleanup** *(boolean) --*

                  When set to ``true`` , Device Farm will remove app packages after a test run. The
                  default value is ``false`` for private devices.

                - **excludeAppPackagesFromCleanup** *(list) --*

                  An array of strings specifying the list of app packages that should not be
                  cleaned up from the device after a test run is over.

                  The list of packages is only considered if you set ``packageCleanup`` to ``true``
                  .

                  - *(string) --*

                - **rebootAfterUse** *(boolean) --*

                  When set to ``true`` , Device Farm will reboot the instance after a test run. The
                  default value is ``true`` .

                - **name** *(string) --*

                  The name of the instance profile.

                - **description** *(string) --*

                  The description of the instance profile.

          - **availability** *(string) --*

            Reflects how likely a device will be available for a test run. It is currently
            available in the ListDevices and GetDevice API methods.

        - **instanceArn** *(string) --*

          The Amazon Resource Name (ARN) of the instance.

        - **deviceMinutes** *(dict) --*

          Represents the total (metered or unmetered) minutes used by the job.

          - **total** *(float) --*

            When specified, represents the total minutes used by the resource to run tests.

          - **metered** *(float) --*

            When specified, represents only the sum of metered minutes used by the resource to run
            tests.

          - **unmetered** *(float) --*

            When specified, represents only the sum of unmetered minutes used by the resource to
            run tests.

        - **videoEndpoint** *(string) --*

          The endpoint for streaming device video.

        - **videoCapture** *(boolean) --*

          This value is set to true if video capture is enabled; otherwise, it is set to false.

    - **nextToken** *(string) --*

      If the number of items that are returned is significantly large, this is an identifier that
      is also returned, which can be used in a subsequent call to this operation to return the next
      set of items in the list.
    """


_ClientListNetworkProfilesResponsenetworkProfilesTypeDef = TypedDict(
    "_ClientListNetworkProfilesResponsenetworkProfilesTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "uplinkBandwidthBits": int,
        "downlinkBandwidthBits": int,
        "uplinkDelayMs": int,
        "downlinkDelayMs": int,
        "uplinkJitterMs": int,
        "downlinkJitterMs": int,
        "uplinkLossPercent": int,
        "downlinkLossPercent": int,
    },
    total=False,
)


class ClientListNetworkProfilesResponsenetworkProfilesTypeDef(
    _ClientListNetworkProfilesResponsenetworkProfilesTypeDef
):
    """
    Type definition for `ClientListNetworkProfilesResponse` `networkProfiles`

    An array of settings that describes characteristics of a network profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the network profile.

    - **name** *(string) --*

      The name of the network profile.

    - **description** *(string) --*

      The description of the network profile.

    - **type** *(string) --*

      The type of network profile. Valid values are listed below.

    - **uplinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **downlinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **uplinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **downlinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **uplinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **downlinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **uplinkLossPercent** *(integer) --*

      Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

    - **downlinkLossPercent** *(integer) --*

      Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ClientListNetworkProfilesResponseTypeDef = TypedDict(
    "_ClientListNetworkProfilesResponseTypeDef",
    {
        "networkProfiles": List[
            ClientListNetworkProfilesResponsenetworkProfilesTypeDef
        ],
        "nextToken": str,
    },
    total=False,
)


class ClientListNetworkProfilesResponseTypeDef(
    _ClientListNetworkProfilesResponseTypeDef
):
    """
    Type definition for `ClientListNetworkProfiles` `Response`

    - **networkProfiles** *(list) --*

      A list of the available network profiles.

      - *(dict) --*

        An array of settings that describes characteristics of a network profile.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the network profile.

        - **name** *(string) --*

          The name of the network profile.

        - **description** *(string) --*

          The description of the network profile.

        - **type** *(string) --*

          The type of network profile. Valid values are listed below.

        - **uplinkBandwidthBits** *(integer) --*

          The data throughput rate in bits per second, as an integer from 0 to 104857600.

        - **downlinkBandwidthBits** *(integer) --*

          The data throughput rate in bits per second, as an integer from 0 to 104857600.

        - **uplinkDelayMs** *(integer) --*

          Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

        - **downlinkDelayMs** *(integer) --*

          Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

        - **uplinkJitterMs** *(integer) --*

          Time variation in the delay of received packets in milliseconds as an integer from 0 to
          2000.

        - **downlinkJitterMs** *(integer) --*

          Time variation in the delay of received packets in milliseconds as an integer from 0 to
          2000.

        - **uplinkLossPercent** *(integer) --*

          Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

        - **downlinkLossPercent** *(integer) --*

          Proportion of received packets that fail to arrive from 0 to 100 percent.

    - **nextToken** *(string) --*

      An identifier that was returned from the previous call to this operation, which can be used
      to return the next set of items in the list.
    """


_ClientListOfferingPromotionsResponseofferingPromotionsTypeDef = TypedDict(
    "_ClientListOfferingPromotionsResponseofferingPromotionsTypeDef",
    {"id": str, "description": str},
    total=False,
)


class ClientListOfferingPromotionsResponseofferingPromotionsTypeDef(
    _ClientListOfferingPromotionsResponseofferingPromotionsTypeDef
):
    """
    Type definition for `ClientListOfferingPromotionsResponse` `offeringPromotions`

    Represents information about an offering promotion.

    - **id** *(string) --*

      The ID of the offering promotion.

    - **description** *(string) --*

      A string describing the offering promotion.
    """


_ClientListOfferingPromotionsResponseTypeDef = TypedDict(
    "_ClientListOfferingPromotionsResponseTypeDef",
    {
        "offeringPromotions": List[
            ClientListOfferingPromotionsResponseofferingPromotionsTypeDef
        ],
        "nextToken": str,
    },
    total=False,
)


class ClientListOfferingPromotionsResponseTypeDef(
    _ClientListOfferingPromotionsResponseTypeDef
):
    """
    Type definition for `ClientListOfferingPromotions` `Response`

    - **offeringPromotions** *(list) --*

      Information about the offering promotions.

      - *(dict) --*

        Represents information about an offering promotion.

        - **id** *(string) --*

          The ID of the offering promotion.

        - **description** *(string) --*

          A string describing the offering promotion.

    - **nextToken** *(string) --*

      An identifier to be used in the next call to this operation, to return the next set of items
      in the list.
    """


_ClientListOfferingTransactionsResponseofferingTransactionscostTypeDef = TypedDict(
    "_ClientListOfferingTransactionsResponseofferingTransactionscostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class ClientListOfferingTransactionsResponseofferingTransactionscostTypeDef(
    _ClientListOfferingTransactionsResponseofferingTransactionscostTypeDef
):
    """
    Type definition for `ClientListOfferingTransactionsResponseofferingTransactions` `cost`

    The cost of an offering transaction.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef = TypedDict(
    "_ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef(
    _ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef
):
    """
    Type definition for `ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringCharges` `cost`

    The cost of the recurring charge.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S.
      dollars."
    """


_ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef = TypedDict(
    "_ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef",
    {
        "cost": ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef,
        "frequency": str,
    },
    total=False,
)


class ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef(
    _ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef
):
    """
    Type definition for `ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusoffering` `recurringCharges`

    Specifies whether charges for devices will be recurring.

    - **cost** *(dict) --*

      The cost of the recurring charge.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S.
        dollars."

    - **frequency** *(string) --*

      The frequency in which charges will recur.
    """


_ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingTypeDef = TypedDict(
    "_ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingTypeDef",
    {
        "id": str,
        "description": str,
        "type": str,
        "platform": str,
        "recurringCharges": List[
            ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef
        ],
    },
    total=False,
)


class ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingTypeDef(
    _ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingTypeDef
):
    """
    Type definition for `ClientListOfferingTransactionsResponseofferingTransactionsofferingStatus` `offering`

    Represents the metadata of an offering status.

    - **id** *(string) --*

      The ID that corresponds to a device offering.

    - **description** *(string) --*

      A string describing the offering.

    - **type** *(string) --*

      The type of offering (e.g., "RECURRING") for a device.

    - **platform** *(string) --*

      The platform of the device (e.g., ANDROID or IOS).

    - **recurringCharges** *(list) --*

      Specifies whether there are recurring charges for the offering.

      - *(dict) --*

        Specifies whether charges for devices will be recurring.

        - **cost** *(dict) --*

          The cost of the recurring charge.

          - **amount** *(float) --*

            The numerical amount of an offering or transaction.

          - **currencyCode** *(string) --*

            The currency code of a monetary amount. For example, ``USD`` means "U.S.
            dollars."

        - **frequency** *(string) --*

          The frequency in which charges will recur.
    """


_ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusTypeDef = TypedDict(
    "_ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusTypeDef",
    {
        "type": str,
        "offering": ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusofferingTypeDef,
        "quantity": int,
        "effectiveOn": datetime,
    },
    total=False,
)


class ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusTypeDef(
    _ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusTypeDef
):
    """
    Type definition for `ClientListOfferingTransactionsResponseofferingTransactions` `offeringStatus`

    The status of an offering transaction.

    - **type** *(string) --*

      The type specified for the offering status.

    - **offering** *(dict) --*

      Represents the metadata of an offering status.

      - **id** *(string) --*

        The ID that corresponds to a device offering.

      - **description** *(string) --*

        A string describing the offering.

      - **type** *(string) --*

        The type of offering (e.g., "RECURRING") for a device.

      - **platform** *(string) --*

        The platform of the device (e.g., ANDROID or IOS).

      - **recurringCharges** *(list) --*

        Specifies whether there are recurring charges for the offering.

        - *(dict) --*

          Specifies whether charges for devices will be recurring.

          - **cost** *(dict) --*

            The cost of the recurring charge.

            - **amount** *(float) --*

              The numerical amount of an offering or transaction.

            - **currencyCode** *(string) --*

              The currency code of a monetary amount. For example, ``USD`` means "U.S.
              dollars."

          - **frequency** *(string) --*

            The frequency in which charges will recur.

    - **quantity** *(integer) --*

      The number of available devices in the offering.

    - **effectiveOn** *(datetime) --*

      The date on which the offering is effective.
    """


_ClientListOfferingTransactionsResponseofferingTransactionsTypeDef = TypedDict(
    "_ClientListOfferingTransactionsResponseofferingTransactionsTypeDef",
    {
        "offeringStatus": ClientListOfferingTransactionsResponseofferingTransactionsofferingStatusTypeDef,
        "transactionId": str,
        "offeringPromotionId": str,
        "createdOn": datetime,
        "cost": ClientListOfferingTransactionsResponseofferingTransactionscostTypeDef,
    },
    total=False,
)


class ClientListOfferingTransactionsResponseofferingTransactionsTypeDef(
    _ClientListOfferingTransactionsResponseofferingTransactionsTypeDef
):
    """
    Type definition for `ClientListOfferingTransactionsResponse` `offeringTransactions`

    Represents the metadata of an offering transaction.

    - **offeringStatus** *(dict) --*

      The status of an offering transaction.

      - **type** *(string) --*

        The type specified for the offering status.

      - **offering** *(dict) --*

        Represents the metadata of an offering status.

        - **id** *(string) --*

          The ID that corresponds to a device offering.

        - **description** *(string) --*

          A string describing the offering.

        - **type** *(string) --*

          The type of offering (e.g., "RECURRING") for a device.

        - **platform** *(string) --*

          The platform of the device (e.g., ANDROID or IOS).

        - **recurringCharges** *(list) --*

          Specifies whether there are recurring charges for the offering.

          - *(dict) --*

            Specifies whether charges for devices will be recurring.

            - **cost** *(dict) --*

              The cost of the recurring charge.

              - **amount** *(float) --*

                The numerical amount of an offering or transaction.

              - **currencyCode** *(string) --*

                The currency code of a monetary amount. For example, ``USD`` means "U.S.
                dollars."

            - **frequency** *(string) --*

              The frequency in which charges will recur.

      - **quantity** *(integer) --*

        The number of available devices in the offering.

      - **effectiveOn** *(datetime) --*

        The date on which the offering is effective.

    - **transactionId** *(string) --*

      The transaction ID of the offering transaction.

    - **offeringPromotionId** *(string) --*

      The ID that corresponds to a device offering promotion.

    - **createdOn** *(datetime) --*

      The date on which an offering transaction was created.

    - **cost** *(dict) --*

      The cost of an offering transaction.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ClientListOfferingTransactionsResponseTypeDef = TypedDict(
    "_ClientListOfferingTransactionsResponseTypeDef",
    {
        "offeringTransactions": List[
            ClientListOfferingTransactionsResponseofferingTransactionsTypeDef
        ],
        "nextToken": str,
    },
    total=False,
)


class ClientListOfferingTransactionsResponseTypeDef(
    _ClientListOfferingTransactionsResponseTypeDef
):
    """
    Type definition for `ClientListOfferingTransactions` `Response`

    Returns the transaction log of the specified offerings.

    - **offeringTransactions** *(list) --*

      The audit log of subscriptions you have purchased and modified through AWS Device Farm.

      - *(dict) --*

        Represents the metadata of an offering transaction.

        - **offeringStatus** *(dict) --*

          The status of an offering transaction.

          - **type** *(string) --*

            The type specified for the offering status.

          - **offering** *(dict) --*

            Represents the metadata of an offering status.

            - **id** *(string) --*

              The ID that corresponds to a device offering.

            - **description** *(string) --*

              A string describing the offering.

            - **type** *(string) --*

              The type of offering (e.g., "RECURRING") for a device.

            - **platform** *(string) --*

              The platform of the device (e.g., ANDROID or IOS).

            - **recurringCharges** *(list) --*

              Specifies whether there are recurring charges for the offering.

              - *(dict) --*

                Specifies whether charges for devices will be recurring.

                - **cost** *(dict) --*

                  The cost of the recurring charge.

                  - **amount** *(float) --*

                    The numerical amount of an offering or transaction.

                  - **currencyCode** *(string) --*

                    The currency code of a monetary amount. For example, ``USD`` means "U.S.
                    dollars."

                - **frequency** *(string) --*

                  The frequency in which charges will recur.

          - **quantity** *(integer) --*

            The number of available devices in the offering.

          - **effectiveOn** *(datetime) --*

            The date on which the offering is effective.

        - **transactionId** *(string) --*

          The transaction ID of the offering transaction.

        - **offeringPromotionId** *(string) --*

          The ID that corresponds to a device offering promotion.

        - **createdOn** *(datetime) --*

          The date on which an offering transaction was created.

        - **cost** *(dict) --*

          The cost of an offering transaction.

          - **amount** *(float) --*

            The numerical amount of an offering or transaction.

          - **currencyCode** *(string) --*

            The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

    - **nextToken** *(string) --*

      An identifier that was returned from the previous call to this operation, which can be used
      to return the next set of items in the list.
    """


_ClientListOfferingsResponseofferingsrecurringChargescostTypeDef = TypedDict(
    "_ClientListOfferingsResponseofferingsrecurringChargescostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class ClientListOfferingsResponseofferingsrecurringChargescostTypeDef(
    _ClientListOfferingsResponseofferingsrecurringChargescostTypeDef
):
    """
    Type definition for `ClientListOfferingsResponseofferingsrecurringCharges` `cost`

    The cost of the recurring charge.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ClientListOfferingsResponseofferingsrecurringChargesTypeDef = TypedDict(
    "_ClientListOfferingsResponseofferingsrecurringChargesTypeDef",
    {
        "cost": ClientListOfferingsResponseofferingsrecurringChargescostTypeDef,
        "frequency": str,
    },
    total=False,
)


class ClientListOfferingsResponseofferingsrecurringChargesTypeDef(
    _ClientListOfferingsResponseofferingsrecurringChargesTypeDef
):
    """
    Type definition for `ClientListOfferingsResponseofferings` `recurringCharges`

    Specifies whether charges for devices will be recurring.

    - **cost** *(dict) --*

      The cost of the recurring charge.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

    - **frequency** *(string) --*

      The frequency in which charges will recur.
    """


_ClientListOfferingsResponseofferingsTypeDef = TypedDict(
    "_ClientListOfferingsResponseofferingsTypeDef",
    {
        "id": str,
        "description": str,
        "type": str,
        "platform": str,
        "recurringCharges": List[
            ClientListOfferingsResponseofferingsrecurringChargesTypeDef
        ],
    },
    total=False,
)


class ClientListOfferingsResponseofferingsTypeDef(
    _ClientListOfferingsResponseofferingsTypeDef
):
    """
    Type definition for `ClientListOfferingsResponse` `offerings`

    Represents the metadata of a device offering.

    - **id** *(string) --*

      The ID that corresponds to a device offering.

    - **description** *(string) --*

      A string describing the offering.

    - **type** *(string) --*

      The type of offering (e.g., "RECURRING") for a device.

    - **platform** *(string) --*

      The platform of the device (e.g., ANDROID or IOS).

    - **recurringCharges** *(list) --*

      Specifies whether there are recurring charges for the offering.

      - *(dict) --*

        Specifies whether charges for devices will be recurring.

        - **cost** *(dict) --*

          The cost of the recurring charge.

          - **amount** *(float) --*

            The numerical amount of an offering or transaction.

          - **currencyCode** *(string) --*

            The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

        - **frequency** *(string) --*

          The frequency in which charges will recur.
    """


_ClientListOfferingsResponseTypeDef = TypedDict(
    "_ClientListOfferingsResponseTypeDef",
    {"offerings": List[ClientListOfferingsResponseofferingsTypeDef], "nextToken": str},
    total=False,
)


class ClientListOfferingsResponseTypeDef(_ClientListOfferingsResponseTypeDef):
    """
    Type definition for `ClientListOfferings` `Response`

    Represents the return values of the list of offerings.

    - **offerings** *(list) --*

      A value representing the list offering results.

      - *(dict) --*

        Represents the metadata of a device offering.

        - **id** *(string) --*

          The ID that corresponds to a device offering.

        - **description** *(string) --*

          A string describing the offering.

        - **type** *(string) --*

          The type of offering (e.g., "RECURRING") for a device.

        - **platform** *(string) --*

          The platform of the device (e.g., ANDROID or IOS).

        - **recurringCharges** *(list) --*

          Specifies whether there are recurring charges for the offering.

          - *(dict) --*

            Specifies whether charges for devices will be recurring.

            - **cost** *(dict) --*

              The cost of the recurring charge.

              - **amount** *(float) --*

                The numerical amount of an offering or transaction.

              - **currencyCode** *(string) --*

                The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

            - **frequency** *(string) --*

              The frequency in which charges will recur.

    - **nextToken** *(string) --*

      An identifier that was returned from the previous call to this operation, which can be used
      to return the next set of items in the list.
    """


_ClientListProjectsResponseprojectsTypeDef = TypedDict(
    "_ClientListProjectsResponseprojectsTypeDef",
    {"arn": str, "name": str, "defaultJobTimeoutMinutes": int, "created": datetime},
    total=False,
)


class ClientListProjectsResponseprojectsTypeDef(
    _ClientListProjectsResponseprojectsTypeDef
):
    """
    Type definition for `ClientListProjectsResponse` `projects`

    Represents an operating-system neutral workspace for running and managing tests.

    - **arn** *(string) --*

      The project's ARN.

    - **name** *(string) --*

      The project's name.

    - **defaultJobTimeoutMinutes** *(integer) --*

      The default number of minutes (at the project level) a test run will execute before it
      times out. The default value is 150 minutes.

    - **created** *(datetime) --*

      When the project was created.
    """


_ClientListProjectsResponseTypeDef = TypedDict(
    "_ClientListProjectsResponseTypeDef",
    {"projects": List[ClientListProjectsResponseprojectsTypeDef], "nextToken": str},
    total=False,
)


class ClientListProjectsResponseTypeDef(_ClientListProjectsResponseTypeDef):
    """
    Type definition for `ClientListProjects` `Response`

    Represents the result of a list projects request.

    - **projects** *(list) --*

      Information about the projects.

      - *(dict) --*

        Represents an operating-system neutral workspace for running and managing tests.

        - **arn** *(string) --*

          The project's ARN.

        - **name** *(string) --*

          The project's name.

        - **defaultJobTimeoutMinutes** *(integer) --*

          The default number of minutes (at the project level) a test run will execute before it
          times out. The default value is 150 minutes.

        - **created** *(datetime) --*

          When the project was created.

    - **nextToken** *(string) --*

      If the number of items that are returned is significantly large, this is an identifier that
      is also returned, which can be used in a subsequent call to this operation to return the next
      set of items in the list.
    """


_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceMinutesTypeDef = TypedDict(
    "_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceMinutesTypeDef(
    _ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceMinutesTypeDef
):
    """
    Type definition for `ClientListRemoteAccessSessionsResponseremoteAccessSessions` `deviceMinutes`

    The number of minutes a device is used in a remote access session (including setup and
    teardown minutes).

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to
      run tests.
    """


_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdevicecpuTypeDef = TypedDict(
    "_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientListRemoteAccessSessionsResponseremoteAccessSessionsdevicecpuTypeDef(
    _ClientListRemoteAccessSessionsResponseremoteAccessSessionsdevicecpuTypeDef
):
    """
    Type definition for `ClientListRemoteAccessSessionsResponseremoteAccessSessionsdevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesinstanceProfileTypeDef(
    _ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be
      cleaned up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true``
      .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesTypeDef = TypedDict(
    "_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesTypeDef(
    _ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesTypeDef
):
    """
    Type definition for `ClientListRemoteAccessSessionsResponseremoteAccessSessionsdevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be
        cleaned up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true``
        .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceresolutionTypeDef = TypedDict(
    "_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceresolutionTypeDef(
    _ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceresolutionTypeDef
):
    """
    Type definition for `ClientListRemoteAccessSessionsResponseremoteAccessSessionsdevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceTypeDef = TypedDict(
    "_ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientListRemoteAccessSessionsResponseremoteAccessSessionsdevicecpuTypeDef,
        "resolution": ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[
            ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceinstancesTypeDef
        ],
        "availability": str,
    },
    total=False,
)


class ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceTypeDef(
    _ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceTypeDef
):
    """
    Type definition for `ClientListRemoteAccessSessionsResponseremoteAccessSessions` `device`

    The device (phone or tablet) used in the remote access session.

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be
            cleaned up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true``
            .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently
      available in the ListDevices and GetDevice API methods.
    """


_ClientListRemoteAccessSessionsResponseremoteAccessSessionsTypeDef = TypedDict(
    "_ClientListRemoteAccessSessionsResponseremoteAccessSessionsTypeDef",
    {
        "arn": str,
        "name": str,
        "created": datetime,
        "status": str,
        "result": str,
        "message": str,
        "started": datetime,
        "stopped": datetime,
        "device": ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceTypeDef,
        "instanceArn": str,
        "remoteDebugEnabled": bool,
        "remoteRecordEnabled": bool,
        "remoteRecordAppArn": str,
        "hostAddress": str,
        "clientId": str,
        "billingMethod": str,
        "deviceMinutes": ClientListRemoteAccessSessionsResponseremoteAccessSessionsdeviceMinutesTypeDef,
        "endpoint": str,
        "deviceUdid": str,
        "interactionMode": str,
        "skipAppResign": bool,
    },
    total=False,
)


class ClientListRemoteAccessSessionsResponseremoteAccessSessionsTypeDef(
    _ClientListRemoteAccessSessionsResponseremoteAccessSessionsTypeDef
):
    """
    Type definition for `ClientListRemoteAccessSessionsResponse` `remoteAccessSessions`

    Represents information about the remote access session.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the remote access session.

    - **name** *(string) --*

      The name of the remote access session.

    - **created** *(datetime) --*

      The date and time the remote access session was created.

    - **status** *(string) --*

      The status of the remote access session. Can be any of the following:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The result of the remote access session. Can be any of the following:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **message** *(string) --*

      A message about the remote access session.

    - **started** *(datetime) --*

      The date and time the remote access session was started.

    - **stopped** *(datetime) --*

      The date and time the remote access session was stopped.

    - **device** *(dict) --*

      The device (phone or tablet) used in the remote access session.

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
          CPU is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type are
        PRIVATE and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test run. The
              default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not be
              cleaned up from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to ``true``
              .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test run. The
              default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently
        available in the ListDevices and GetDevice API methods.

    - **instanceArn** *(string) --*

      The Amazon Resource Name (ARN) of the instance.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **remoteRecordEnabled** *(boolean) --*

      This flag is set to ``true`` if remote recording is enabled for the remote access session.

    - **remoteRecordAppArn** *(string) --*

      The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.

    - **hostAddress** *(string) --*

      IP address of the EC2 host where you need to connect to remotely debug devices. Only
      returned if remote debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **clientId** *(string) --*

      Unique identifier of your client for the remote access session. Only returned if remote
      debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **billingMethod** *(string) --*

      The billing method of the remote access session. Possible values include ``METERED`` or
      ``UNMETERED`` . For more information about metered devices, see `AWS Device Farm
      terminology
      <https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology>`__
      ."

    - **deviceMinutes** *(dict) --*

      The number of minutes a device is used in a remote access session (including setup and
      teardown minutes).

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to
        run tests.

    - **endpoint** *(string) --*

      The endpoint for the remote access sesssion.

    - **deviceUdid** *(string) --*

      Unique device identifier for the remote device. Only returned if remote debugging is
      enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **interactionMode** *(string) --*

      The interaction mode of the remote access session. Valid values are:

      * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating
      the screen. You **cannot** run XCUITest framework-based tests in this mode.

      * NO_VIDEO: You are connected to the device but cannot interact with it or view the
      screen. This mode has the fastest test execution speed. You **can** run XCUITest
      framework-based tests in this mode.

      * VIDEO_ONLY: You can view the screen but cannot touch or rotate it. You **can** run
      XCUITest framework-based tests and watch the screen in this mode.

    - **skipAppResign** *(boolean) --*

      When set to ``true`` , for private devices, Device Farm will not sign your app again. For
      public devices, Device Farm always signs your apps again and this parameter has no effect.

      For more information about how Device Farm re-signs your app(s), see `Do you modify my
      app? <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .
    """


_ClientListRemoteAccessSessionsResponseTypeDef = TypedDict(
    "_ClientListRemoteAccessSessionsResponseTypeDef",
    {
        "remoteAccessSessions": List[
            ClientListRemoteAccessSessionsResponseremoteAccessSessionsTypeDef
        ],
        "nextToken": str,
    },
    total=False,
)


class ClientListRemoteAccessSessionsResponseTypeDef(
    _ClientListRemoteAccessSessionsResponseTypeDef
):
    """
    Type definition for `ClientListRemoteAccessSessions` `Response`

    Represents the response from the server after AWS Device Farm makes a request to return
    information about the remote access session.

    - **remoteAccessSessions** *(list) --*

      A container representing the metadata from the service about each remote access session you
      are requesting.

      - *(dict) --*

        Represents information about the remote access session.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the remote access session.

        - **name** *(string) --*

          The name of the remote access session.

        - **created** *(datetime) --*

          The date and time the remote access session was created.

        - **status** *(string) --*

          The status of the remote access session. Can be any of the following:

          * PENDING: A pending status.

          * PENDING_CONCURRENCY: A pending concurrency status.

          * PENDING_DEVICE: A pending device status.

          * PROCESSING: A processing status.

          * SCHEDULING: A scheduling status.

          * PREPARING: A preparing status.

          * RUNNING: A running status.

          * COMPLETED: A completed status.

          * STOPPING: A stopping status.

        - **result** *(string) --*

          The result of the remote access session. Can be any of the following:

          * PENDING: A pending condition.

          * PASSED: A passing condition.

          * WARNED: A warning condition.

          * FAILED: A failed condition.

          * SKIPPED: A skipped condition.

          * ERRORED: An error condition.

          * STOPPED: A stopped condition.

        - **message** *(string) --*

          A message about the remote access session.

        - **started** *(datetime) --*

          The date and time the remote access session was started.

        - **stopped** *(datetime) --*

          The date and time the remote access session was stopped.

        - **device** *(dict) --*

          The device (phone or tablet) used in the remote access session.

          - **arn** *(string) --*

            The device's ARN.

          - **name** *(string) --*

            The device's display name.

          - **manufacturer** *(string) --*

            The device's manufacturer name.

          - **model** *(string) --*

            The device's model name.

          - **modelId** *(string) --*

            The device's model ID.

          - **formFactor** *(string) --*

            The device's form factor.

            Allowed values include:

            * PHONE: The phone form factor.

            * TABLET: The tablet form factor.

          - **platform** *(string) --*

            The device's platform.

            Allowed values include:

            * ANDROID: The Android platform.

            * IOS: The iOS platform.

          - **os** *(string) --*

            The device's operating system type.

          - **cpu** *(dict) --*

            Information about the device's CPU.

            - **frequency** *(string) --*

              The CPU's frequency.

            - **architecture** *(string) --*

              The CPU's architecture, for example x86 or ARM.

            - **clock** *(float) --*

              The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
              CPU is expressed as 1200000000.

          - **resolution** *(dict) --*

            The resolution of the device.

            - **width** *(integer) --*

              The screen resolution's width, expressed in pixels.

            - **height** *(integer) --*

              The screen resolution's height, expressed in pixels.

          - **heapSize** *(integer) --*

            The device's heap size, expressed in bytes.

          - **memory** *(integer) --*

            The device's total memory size, expressed in bytes.

          - **image** *(string) --*

            The device's image name.

          - **carrier** *(string) --*

            The device's carrier.

          - **radio** *(string) --*

            The device's radio.

          - **remoteAccessEnabled** *(boolean) --*

            Specifies whether remote access has been enabled for the specified device.

          - **remoteDebugEnabled** *(boolean) --*

            This flag is set to ``true`` if remote debugging is enabled for the device.

             *Remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

          - **fleetType** *(string) --*

            The type of fleet to which this device belongs. Possible values for fleet type are
            PRIVATE and PUBLIC.

          - **fleetName** *(string) --*

            The name of the fleet to which this device belongs.

          - **instances** *(list) --*

            The instances belonging to this device.

            - *(dict) --*

              Represents the device instance.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the device instance.

              - **deviceArn** *(string) --*

                The Amazon Resource Name (ARN) of the device.

              - **labels** *(list) --*

                An array of strings describing the device instance.

                - *(string) --*

              - **status** *(string) --*

                The status of the device instance. Valid values are listed below.

              - **udid** *(string) --*

                Unique device identifier for the device instance.

              - **instanceProfile** *(dict) --*

                A object containing information about the instance profile.

                - **arn** *(string) --*

                  The Amazon Resource Name (ARN) of the instance profile.

                - **packageCleanup** *(boolean) --*

                  When set to ``true`` , Device Farm will remove app packages after a test run. The
                  default value is ``false`` for private devices.

                - **excludeAppPackagesFromCleanup** *(list) --*

                  An array of strings specifying the list of app packages that should not be
                  cleaned up from the device after a test run is over.

                  The list of packages is only considered if you set ``packageCleanup`` to ``true``
                  .

                  - *(string) --*

                - **rebootAfterUse** *(boolean) --*

                  When set to ``true`` , Device Farm will reboot the instance after a test run. The
                  default value is ``true`` .

                - **name** *(string) --*

                  The name of the instance profile.

                - **description** *(string) --*

                  The description of the instance profile.

          - **availability** *(string) --*

            Reflects how likely a device will be available for a test run. It is currently
            available in the ListDevices and GetDevice API methods.

        - **instanceArn** *(string) --*

          The Amazon Resource Name (ARN) of the instance.

        - **remoteDebugEnabled** *(boolean) --*

          This flag is set to ``true`` if remote debugging is enabled for the remote access session.

           *Remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **remoteRecordEnabled** *(boolean) --*

          This flag is set to ``true`` if remote recording is enabled for the remote access session.

        - **remoteRecordAppArn** *(string) --*

          The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.

        - **hostAddress** *(string) --*

          IP address of the EC2 host where you need to connect to remotely debug devices. Only
          returned if remote debugging is enabled for the remote access session.

           *Remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **clientId** *(string) --*

          Unique identifier of your client for the remote access session. Only returned if remote
          debugging is enabled for the remote access session.

           *Remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **billingMethod** *(string) --*

          The billing method of the remote access session. Possible values include ``METERED`` or
          ``UNMETERED`` . For more information about metered devices, see `AWS Device Farm
          terminology
          <https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology>`__
          ."

        - **deviceMinutes** *(dict) --*

          The number of minutes a device is used in a remote access session (including setup and
          teardown minutes).

          - **total** *(float) --*

            When specified, represents the total minutes used by the resource to run tests.

          - **metered** *(float) --*

            When specified, represents only the sum of metered minutes used by the resource to run
            tests.

          - **unmetered** *(float) --*

            When specified, represents only the sum of unmetered minutes used by the resource to
            run tests.

        - **endpoint** *(string) --*

          The endpoint for the remote access sesssion.

        - **deviceUdid** *(string) --*

          Unique device identifier for the remote device. Only returned if remote debugging is
          enabled for the remote access session.

           *Remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **interactionMode** *(string) --*

          The interaction mode of the remote access session. Valid values are:

          * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating
          the screen. You **cannot** run XCUITest framework-based tests in this mode.

          * NO_VIDEO: You are connected to the device but cannot interact with it or view the
          screen. This mode has the fastest test execution speed. You **can** run XCUITest
          framework-based tests in this mode.

          * VIDEO_ONLY: You can view the screen but cannot touch or rotate it. You **can** run
          XCUITest framework-based tests and watch the screen in this mode.

        - **skipAppResign** *(boolean) --*

          When set to ``true`` , for private devices, Device Farm will not sign your app again. For
          public devices, Device Farm always signs your apps again and this parameter has no effect.

          For more information about how Device Farm re-signs your app(s), see `Do you modify my
          app? <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .

    - **nextToken** *(string) --*

      An identifier that was returned from the previous call to this operation, which can be used
      to return the next set of items in the list.
    """


_ClientListRunsResponserunscountersTypeDef = TypedDict(
    "_ClientListRunsResponserunscountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ClientListRunsResponserunscountersTypeDef(
    _ClientListRunsResponserunscountersTypeDef
):
    """
    Type definition for `ClientListRunsResponseruns` `counters`

    The run's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ClientListRunsResponserunscustomerArtifactPathsTypeDef = TypedDict(
    "_ClientListRunsResponserunscustomerArtifactPathsTypeDef",
    {"iosPaths": List[str], "androidPaths": List[str], "deviceHostPaths": List[str]},
    total=False,
)


class ClientListRunsResponserunscustomerArtifactPathsTypeDef(
    _ClientListRunsResponserunscustomerArtifactPathsTypeDef
):
    """
    Type definition for `ClientListRunsResponseruns` `customerArtifactPaths`

    Output ``CustomerArtifactPaths`` object for the test run.

    - **iosPaths** *(list) --*

      Comma-separated list of paths on the iOS device where the artifacts generated by the
      customer's tests will be pulled from.

      - *(string) --*

    - **androidPaths** *(list) --*

      Comma-separated list of paths on the Android device where the artifacts generated by
      the customer's tests will be pulled from.

      - *(string) --*

    - **deviceHostPaths** *(list) --*

      Comma-separated list of paths in the test execution environment where the artifacts
      generated by the customer's tests will be pulled from.

      - *(string) --*
    """


_ClientListRunsResponserunsdeviceMinutesTypeDef = TypedDict(
    "_ClientListRunsResponserunsdeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientListRunsResponserunsdeviceMinutesTypeDef(
    _ClientListRunsResponserunsdeviceMinutesTypeDef
):
    """
    Type definition for `ClientListRunsResponseruns` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the test run.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to
      run tests.
    """


_ClientListRunsResponserunsdeviceSelectionResultfiltersTypeDef = TypedDict(
    "_ClientListRunsResponserunsdeviceSelectionResultfiltersTypeDef",
    {"attribute": str, "operator": str, "values": List[str]},
    total=False,
)


class ClientListRunsResponserunsdeviceSelectionResultfiltersTypeDef(
    _ClientListRunsResponserunsdeviceSelectionResultfiltersTypeDef
):
    """
    Type definition for `ClientListRunsResponserunsdeviceSelectionResult` `filters`

    Represents a device filter used to select a set of devices to be included in a test
    run. This data structure is passed in as the ``deviceSelectionConfiguration``
    parameter to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun
    .

    It is also passed in as the ``filters`` parameter to ListDevices. For an example of
    the JSON request syntax, see  ListDevices .

    - **attribute** *(string) --*

      The aspect of a device such as platform or model used as the selection criteria in
      a device filter.

      The supported operators for each attribute are provided in the following list.

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS``
       , ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        MODEL

      The device model. For example, "iPad 5th Gen".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE",
      "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

       *Ignored.* Whether the device is enabled for remote debugging. Valid values are
       "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

    - **operator** *(string) --*

      Specifies how Device Farm compares the filter's attribute to the value. For the
      operators that are supported by each attribute, see the attribute descriptions.

    - **values** *(list) --*

      An array of one or more filter values used in a device filter.

       **Operator Values**

      * The IN and NOT_IN operators can take a values array that has more than one
      element.

      * The other operators require an array with a single element.

       **Attribute Values**

      * The PLATFORM attribute can be set to "ANDROID" or "IOS".

      * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
      or "TEMPORARY_NOT_AVAILABLE".

      * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

      * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

      - *(string) --*
    """


_ClientListRunsResponserunsdeviceSelectionResultTypeDef = TypedDict(
    "_ClientListRunsResponserunsdeviceSelectionResultTypeDef",
    {
        "filters": List[ClientListRunsResponserunsdeviceSelectionResultfiltersTypeDef],
        "matchedDevicesCount": int,
        "maxDevices": int,
    },
    total=False,
)


class ClientListRunsResponserunsdeviceSelectionResultTypeDef(
    _ClientListRunsResponserunsdeviceSelectionResultTypeDef
):
    """
    Type definition for `ClientListRunsResponseruns` `deviceSelectionResult`

    The results of a device filter used to select the devices for a test run.

    - **filters** *(list) --*

      The filters in a device selection result.

      - *(dict) --*

        Represents a device filter used to select a set of devices to be included in a test
        run. This data structure is passed in as the ``deviceSelectionConfiguration``
        parameter to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun
        .

        It is also passed in as the ``filters`` parameter to ListDevices. For an example of
        the JSON request syntax, see  ListDevices .

        - **attribute** *(string) --*

          The aspect of a device such as platform or model used as the selection criteria in
          a device filter.

          The supported operators for each attribute are provided in the following list.

            ARN

          The Amazon Resource Name (ARN) of the device. For example,
          "arn:aws:devicefarm:us-west-2::device:12345Example".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            PLATFORM

          The device platform. Valid values are "ANDROID" or "IOS".

           *Supported operators* : ``EQUALS``

            OS_VERSION

          The operating system version. For example, "10.3.2".

           *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS``
           , ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

            MODEL

          The device model. For example, "iPad 5th Gen".

           *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

            AVAILABILITY

          The current availability of the device. Valid values are "AVAILABLE",
          "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

           *Supported operators* : ``EQUALS``

            FORM_FACTOR

          The device form factor. Valid values are "PHONE" or "TABLET".

           *Supported operators* : ``EQUALS``

            MANUFACTURER

          The device manufacturer. For example, "Apple".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            REMOTE_ACCESS_ENABLED

          Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

            REMOTE_DEBUG_ENABLED

           *Ignored.* Whether the device is enabled for remote debugging. Valid values are
           "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

           *This filter will be ignored, as remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

            INSTANCE_ARN

          The Amazon Resource Name (ARN) of the device instance.

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            INSTANCE_LABELS

          The label of the device instance.

           *Supported operators* : ``CONTAINS``

            FLEET_TYPE

          The fleet type. Valid values are "PUBLIC" or "PRIVATE".

           *Supported operators* : ``EQUALS``

        - **operator** *(string) --*

          Specifies how Device Farm compares the filter's attribute to the value. For the
          operators that are supported by each attribute, see the attribute descriptions.

        - **values** *(list) --*

          An array of one or more filter values used in a device filter.

           **Operator Values**

          * The IN and NOT_IN operators can take a values array that has more than one
          element.

          * The other operators require an array with a single element.

           **Attribute Values**

          * The PLATFORM attribute can be set to "ANDROID" or "IOS".

          * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
          or "TEMPORARY_NOT_AVAILABLE".

          * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

          * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

          - *(string) --*

    - **matchedDevicesCount** *(integer) --*

      The number of devices that matched the device filter selection criteria.

    - **maxDevices** *(integer) --*

      The maximum number of devices to be selected by a device filter and included in a test
      run.
    """


_ClientListRunsResponserunslocationTypeDef = TypedDict(
    "_ClientListRunsResponserunslocationTypeDef",
    {"latitude": float, "longitude": float},
    total=False,
)


class ClientListRunsResponserunslocationTypeDef(
    _ClientListRunsResponserunslocationTypeDef
):
    """
    Type definition for `ClientListRunsResponseruns` `location`

    Information about the location that is used for the run.

    - **latitude** *(float) --*

      The latitude.

    - **longitude** *(float) --*

      The longitude.
    """


_ClientListRunsResponserunsnetworkProfileTypeDef = TypedDict(
    "_ClientListRunsResponserunsnetworkProfileTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "uplinkBandwidthBits": int,
        "downlinkBandwidthBits": int,
        "uplinkDelayMs": int,
        "downlinkDelayMs": int,
        "uplinkJitterMs": int,
        "downlinkJitterMs": int,
        "uplinkLossPercent": int,
        "downlinkLossPercent": int,
    },
    total=False,
)


class ClientListRunsResponserunsnetworkProfileTypeDef(
    _ClientListRunsResponserunsnetworkProfileTypeDef
):
    """
    Type definition for `ClientListRunsResponseruns` `networkProfile`

    The network profile being used for a test run.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the network profile.

    - **name** *(string) --*

      The name of the network profile.

    - **description** *(string) --*

      The description of the network profile.

    - **type** *(string) --*

      The type of network profile. Valid values are listed below.

    - **uplinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **downlinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **uplinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **downlinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **uplinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **downlinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **uplinkLossPercent** *(integer) --*

      Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

    - **downlinkLossPercent** *(integer) --*

      Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ClientListRunsResponserunsradiosTypeDef = TypedDict(
    "_ClientListRunsResponserunsradiosTypeDef",
    {"wifi": bool, "bluetooth": bool, "nfc": bool, "gps": bool},
    total=False,
)


class ClientListRunsResponserunsradiosTypeDef(_ClientListRunsResponserunsradiosTypeDef):
    """
    Type definition for `ClientListRunsResponseruns` `radios`

    Information about the radio states for the run.

    - **wifi** *(boolean) --*

      True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

    - **bluetooth** *(boolean) --*

      True if Bluetooth is enabled at the beginning of the test; otherwise, false.

    - **nfc** *(boolean) --*

      True if NFC is enabled at the beginning of the test; otherwise, false.

    - **gps** *(boolean) --*

      True if GPS is enabled at the beginning of the test; otherwise, false.
    """


_ClientListRunsResponserunsTypeDef = TypedDict(
    "_ClientListRunsResponserunsTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "platform": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ClientListRunsResponserunscountersTypeDef,
        "message": str,
        "totalJobs": int,
        "completedJobs": int,
        "billingMethod": str,
        "deviceMinutes": ClientListRunsResponserunsdeviceMinutesTypeDef,
        "networkProfile": ClientListRunsResponserunsnetworkProfileTypeDef,
        "parsingResultUrl": str,
        "resultCode": str,
        "seed": int,
        "appUpload": str,
        "eventCount": int,
        "jobTimeoutMinutes": int,
        "devicePoolArn": str,
        "locale": str,
        "radios": ClientListRunsResponserunsradiosTypeDef,
        "location": ClientListRunsResponserunslocationTypeDef,
        "customerArtifactPaths": ClientListRunsResponserunscustomerArtifactPathsTypeDef,
        "webUrl": str,
        "skipAppResign": bool,
        "testSpecArn": str,
        "deviceSelectionResult": ClientListRunsResponserunsdeviceSelectionResultTypeDef,
    },
    total=False,
)


class ClientListRunsResponserunsTypeDef(_ClientListRunsResponserunsTypeDef):
    """
    Type definition for `ClientListRunsResponse` `runs`

    Represents a test run on a set of devices with a given app package, test parameters, etc.

    - **arn** *(string) --*

      The run's ARN.

    - **name** *(string) --*

      The run's name.

    - **type** *(string) --*

      The run's type.

      Must be one of the following values:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **platform** *(string) --*

      The run's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **created** *(datetime) --*

      When the run was created.

    - **status** *(string) --*

      The run's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The run's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The run's start time.

    - **stopped** *(datetime) --*

      The run's stop time.

    - **counters** *(dict) --*

      The run's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the run's result.

    - **totalJobs** *(integer) --*

      The total number of jobs for the run.

    - **completedJobs** *(integer) --*

      The total number of completed jobs.

    - **billingMethod** *(string) --*

      Specifies the billing method for a test run: ``metered`` or ``unmetered`` . If the
      parameter is not specified, the default value is ``metered`` .

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the test run.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to
        run tests.

    - **networkProfile** *(dict) --*

      The network profile being used for a test run.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the network profile.

      - **name** *(string) --*

        The name of the network profile.

      - **description** *(string) --*

        The description of the network profile.

      - **type** *(string) --*

        The type of network profile. Valid values are listed below.

      - **uplinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **downlinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **uplinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **downlinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **uplinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **downlinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **uplinkLossPercent** *(integer) --*

        Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

      - **downlinkLossPercent** *(integer) --*

        Proportion of received packets that fail to arrive from 0 to 100 percent.

    - **parsingResultUrl** *(string) --*

      Read-only URL for an object in S3 bucket where you can get the parsing results of the
      test package. If the test package doesn't parse, the reason why it doesn't parse appears
      in the file that this URL points to.

    - **resultCode** *(string) --*

      Supporting field for the result field. Set only if ``result`` is ``SKIPPED`` .
      ``PARSING_FAILED`` if the result is skipped because of test package parsing failure.

    - **seed** *(integer) --*

      For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same
      seed value between tests ensures identical event sequences.

    - **appUpload** *(string) --*

      An app to upload or that has been uploaded.

    - **eventCount** *(integer) --*

      For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz test
      should perform.

    - **jobTimeoutMinutes** *(integer) --*

      The number of minutes the job will execute before it times out.

    - **devicePoolArn** *(string) --*

      The ARN of the device pool for the run.

    - **locale** *(string) --*

      Information about the locale that is used for the run.

    - **radios** *(dict) --*

      Information about the radio states for the run.

      - **wifi** *(boolean) --*

        True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

      - **bluetooth** *(boolean) --*

        True if Bluetooth is enabled at the beginning of the test; otherwise, false.

      - **nfc** *(boolean) --*

        True if NFC is enabled at the beginning of the test; otherwise, false.

      - **gps** *(boolean) --*

        True if GPS is enabled at the beginning of the test; otherwise, false.

    - **location** *(dict) --*

      Information about the location that is used for the run.

      - **latitude** *(float) --*

        The latitude.

      - **longitude** *(float) --*

        The longitude.

    - **customerArtifactPaths** *(dict) --*

      Output ``CustomerArtifactPaths`` object for the test run.

      - **iosPaths** *(list) --*

        Comma-separated list of paths on the iOS device where the artifacts generated by the
        customer's tests will be pulled from.

        - *(string) --*

      - **androidPaths** *(list) --*

        Comma-separated list of paths on the Android device where the artifacts generated by
        the customer's tests will be pulled from.

        - *(string) --*

      - **deviceHostPaths** *(list) --*

        Comma-separated list of paths in the test execution environment where the artifacts
        generated by the customer's tests will be pulled from.

        - *(string) --*

    - **webUrl** *(string) --*

      The Device Farm console URL for the recording of the run.

    - **skipAppResign** *(boolean) --*

      When set to ``true`` , for private devices, Device Farm will not sign your app again. For
      public devices, Device Farm always signs your apps again and this parameter has no effect.

      For more information about how Device Farm re-signs your app(s), see `Do you modify my
      app? <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .

    - **testSpecArn** *(string) --*

      The ARN of the YAML-formatted test specification for the run.

    - **deviceSelectionResult** *(dict) --*

      The results of a device filter used to select the devices for a test run.

      - **filters** *(list) --*

        The filters in a device selection result.

        - *(dict) --*

          Represents a device filter used to select a set of devices to be included in a test
          run. This data structure is passed in as the ``deviceSelectionConfiguration``
          parameter to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun
          .

          It is also passed in as the ``filters`` parameter to ListDevices. For an example of
          the JSON request syntax, see  ListDevices .

          - **attribute** *(string) --*

            The aspect of a device such as platform or model used as the selection criteria in
            a device filter.

            The supported operators for each attribute are provided in the following list.

              ARN

            The Amazon Resource Name (ARN) of the device. For example,
            "arn:aws:devicefarm:us-west-2::device:12345Example".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              PLATFORM

            The device platform. Valid values are "ANDROID" or "IOS".

             *Supported operators* : ``EQUALS``

              OS_VERSION

            The operating system version. For example, "10.3.2".

             *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS``
             , ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

              MODEL

            The device model. For example, "iPad 5th Gen".

             *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

              AVAILABILITY

            The current availability of the device. Valid values are "AVAILABLE",
            "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

             *Supported operators* : ``EQUALS``

              FORM_FACTOR

            The device form factor. Valid values are "PHONE" or "TABLET".

             *Supported operators* : ``EQUALS``

              MANUFACTURER

            The device manufacturer. For example, "Apple".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              REMOTE_ACCESS_ENABLED

            Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

              REMOTE_DEBUG_ENABLED

             *Ignored.* Whether the device is enabled for remote debugging. Valid values are
             "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

             *This filter will be ignored, as remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

              INSTANCE_ARN

            The Amazon Resource Name (ARN) of the device instance.

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              INSTANCE_LABELS

            The label of the device instance.

             *Supported operators* : ``CONTAINS``

              FLEET_TYPE

            The fleet type. Valid values are "PUBLIC" or "PRIVATE".

             *Supported operators* : ``EQUALS``

          - **operator** *(string) --*

            Specifies how Device Farm compares the filter's attribute to the value. For the
            operators that are supported by each attribute, see the attribute descriptions.

          - **values** *(list) --*

            An array of one or more filter values used in a device filter.

             **Operator Values**

            * The IN and NOT_IN operators can take a values array that has more than one
            element.

            * The other operators require an array with a single element.

             **Attribute Values**

            * The PLATFORM attribute can be set to "ANDROID" or "IOS".

            * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
            or "TEMPORARY_NOT_AVAILABLE".

            * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

            * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

            - *(string) --*

      - **matchedDevicesCount** *(integer) --*

        The number of devices that matched the device filter selection criteria.

      - **maxDevices** *(integer) --*

        The maximum number of devices to be selected by a device filter and included in a test
        run.
    """


_ClientListRunsResponseTypeDef = TypedDict(
    "_ClientListRunsResponseTypeDef",
    {"runs": List[ClientListRunsResponserunsTypeDef], "nextToken": str},
    total=False,
)


class ClientListRunsResponseTypeDef(_ClientListRunsResponseTypeDef):
    """
    Type definition for `ClientListRuns` `Response`

    Represents the result of a list runs request.

    - **runs** *(list) --*

      Information about the runs.

      - *(dict) --*

        Represents a test run on a set of devices with a given app package, test parameters, etc.

        - **arn** *(string) --*

          The run's ARN.

        - **name** *(string) --*

          The run's name.

        - **type** *(string) --*

          The run's type.

          Must be one of the following values:

          * BUILTIN_FUZZ: The built-in fuzz type.

          * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
          interacting with it and capturing screenshots at the same time.

          * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

          * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

          * APPIUM_PYTHON: The Appium Python type.

          * APPIUM_NODE: The Appium Node.js type.

          * APPIUM_RUBY: The Appium Ruby type.

          * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

          * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

          * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

          * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

          * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

          * CALABASH: The Calabash type.

          * INSTRUMENTATION: The Instrumentation type.

          * UIAUTOMATION: The uiautomation type.

          * UIAUTOMATOR: The uiautomator type.

          * XCTEST: The Xcode test type.

          * XCTEST_UI: The Xcode UI test type.

        - **platform** *(string) --*

          The run's platform.

          Allowed values include:

          * ANDROID: The Android platform.

          * IOS: The iOS platform.

        - **created** *(datetime) --*

          When the run was created.

        - **status** *(string) --*

          The run's status.

          Allowed values include:

          * PENDING: A pending status.

          * PENDING_CONCURRENCY: A pending concurrency status.

          * PENDING_DEVICE: A pending device status.

          * PROCESSING: A processing status.

          * SCHEDULING: A scheduling status.

          * PREPARING: A preparing status.

          * RUNNING: A running status.

          * COMPLETED: A completed status.

          * STOPPING: A stopping status.

        - **result** *(string) --*

          The run's result.

          Allowed values include:

          * PENDING: A pending condition.

          * PASSED: A passing condition.

          * WARNED: A warning condition.

          * FAILED: A failed condition.

          * SKIPPED: A skipped condition.

          * ERRORED: An error condition.

          * STOPPED: A stopped condition.

        - **started** *(datetime) --*

          The run's start time.

        - **stopped** *(datetime) --*

          The run's stop time.

        - **counters** *(dict) --*

          The run's result counters.

          - **total** *(integer) --*

            The total number of entities.

          - **passed** *(integer) --*

            The number of passed entities.

          - **failed** *(integer) --*

            The number of failed entities.

          - **warned** *(integer) --*

            The number of warned entities.

          - **errored** *(integer) --*

            The number of errored entities.

          - **stopped** *(integer) --*

            The number of stopped entities.

          - **skipped** *(integer) --*

            The number of skipped entities.

        - **message** *(string) --*

          A message about the run's result.

        - **totalJobs** *(integer) --*

          The total number of jobs for the run.

        - **completedJobs** *(integer) --*

          The total number of completed jobs.

        - **billingMethod** *(string) --*

          Specifies the billing method for a test run: ``metered`` or ``unmetered`` . If the
          parameter is not specified, the default value is ``metered`` .

        - **deviceMinutes** *(dict) --*

          Represents the total (metered or unmetered) minutes used by the test run.

          - **total** *(float) --*

            When specified, represents the total minutes used by the resource to run tests.

          - **metered** *(float) --*

            When specified, represents only the sum of metered minutes used by the resource to run
            tests.

          - **unmetered** *(float) --*

            When specified, represents only the sum of unmetered minutes used by the resource to
            run tests.

        - **networkProfile** *(dict) --*

          The network profile being used for a test run.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the network profile.

          - **name** *(string) --*

            The name of the network profile.

          - **description** *(string) --*

            The description of the network profile.

          - **type** *(string) --*

            The type of network profile. Valid values are listed below.

          - **uplinkBandwidthBits** *(integer) --*

            The data throughput rate in bits per second, as an integer from 0 to 104857600.

          - **downlinkBandwidthBits** *(integer) --*

            The data throughput rate in bits per second, as an integer from 0 to 104857600.

          - **uplinkDelayMs** *(integer) --*

            Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

          - **downlinkDelayMs** *(integer) --*

            Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

          - **uplinkJitterMs** *(integer) --*

            Time variation in the delay of received packets in milliseconds as an integer from 0 to
            2000.

          - **downlinkJitterMs** *(integer) --*

            Time variation in the delay of received packets in milliseconds as an integer from 0 to
            2000.

          - **uplinkLossPercent** *(integer) --*

            Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

          - **downlinkLossPercent** *(integer) --*

            Proportion of received packets that fail to arrive from 0 to 100 percent.

        - **parsingResultUrl** *(string) --*

          Read-only URL for an object in S3 bucket where you can get the parsing results of the
          test package. If the test package doesn't parse, the reason why it doesn't parse appears
          in the file that this URL points to.

        - **resultCode** *(string) --*

          Supporting field for the result field. Set only if ``result`` is ``SKIPPED`` .
          ``PARSING_FAILED`` if the result is skipped because of test package parsing failure.

        - **seed** *(integer) --*

          For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same
          seed value between tests ensures identical event sequences.

        - **appUpload** *(string) --*

          An app to upload or that has been uploaded.

        - **eventCount** *(integer) --*

          For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz test
          should perform.

        - **jobTimeoutMinutes** *(integer) --*

          The number of minutes the job will execute before it times out.

        - **devicePoolArn** *(string) --*

          The ARN of the device pool for the run.

        - **locale** *(string) --*

          Information about the locale that is used for the run.

        - **radios** *(dict) --*

          Information about the radio states for the run.

          - **wifi** *(boolean) --*

            True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

          - **bluetooth** *(boolean) --*

            True if Bluetooth is enabled at the beginning of the test; otherwise, false.

          - **nfc** *(boolean) --*

            True if NFC is enabled at the beginning of the test; otherwise, false.

          - **gps** *(boolean) --*

            True if GPS is enabled at the beginning of the test; otherwise, false.

        - **location** *(dict) --*

          Information about the location that is used for the run.

          - **latitude** *(float) --*

            The latitude.

          - **longitude** *(float) --*

            The longitude.

        - **customerArtifactPaths** *(dict) --*

          Output ``CustomerArtifactPaths`` object for the test run.

          - **iosPaths** *(list) --*

            Comma-separated list of paths on the iOS device where the artifacts generated by the
            customer's tests will be pulled from.

            - *(string) --*

          - **androidPaths** *(list) --*

            Comma-separated list of paths on the Android device where the artifacts generated by
            the customer's tests will be pulled from.

            - *(string) --*

          - **deviceHostPaths** *(list) --*

            Comma-separated list of paths in the test execution environment where the artifacts
            generated by the customer's tests will be pulled from.

            - *(string) --*

        - **webUrl** *(string) --*

          The Device Farm console URL for the recording of the run.

        - **skipAppResign** *(boolean) --*

          When set to ``true`` , for private devices, Device Farm will not sign your app again. For
          public devices, Device Farm always signs your apps again and this parameter has no effect.

          For more information about how Device Farm re-signs your app(s), see `Do you modify my
          app? <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .

        - **testSpecArn** *(string) --*

          The ARN of the YAML-formatted test specification for the run.

        - **deviceSelectionResult** *(dict) --*

          The results of a device filter used to select the devices for a test run.

          - **filters** *(list) --*

            The filters in a device selection result.

            - *(dict) --*

              Represents a device filter used to select a set of devices to be included in a test
              run. This data structure is passed in as the ``deviceSelectionConfiguration``
              parameter to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun
              .

              It is also passed in as the ``filters`` parameter to ListDevices. For an example of
              the JSON request syntax, see  ListDevices .

              - **attribute** *(string) --*

                The aspect of a device such as platform or model used as the selection criteria in
                a device filter.

                The supported operators for each attribute are provided in the following list.

                  ARN

                The Amazon Resource Name (ARN) of the device. For example,
                "arn:aws:devicefarm:us-west-2::device:12345Example".

                 *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                  PLATFORM

                The device platform. Valid values are "ANDROID" or "IOS".

                 *Supported operators* : ``EQUALS``

                  OS_VERSION

                The operating system version. For example, "10.3.2".

                 *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS``
                 , ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

                  MODEL

                The device model. For example, "iPad 5th Gen".

                 *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

                  AVAILABILITY

                The current availability of the device. Valid values are "AVAILABLE",
                "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

                 *Supported operators* : ``EQUALS``

                  FORM_FACTOR

                The device form factor. Valid values are "PHONE" or "TABLET".

                 *Supported operators* : ``EQUALS``

                  MANUFACTURER

                The device manufacturer. For example, "Apple".

                 *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                  REMOTE_ACCESS_ENABLED

                Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

                 *Supported operators* : ``EQUALS``

                  REMOTE_DEBUG_ENABLED

                 *Ignored.* Whether the device is enabled for remote debugging. Valid values are
                 "TRUE" or "FALSE".

                 *Supported operators* : ``EQUALS``

                 *This filter will be ignored, as remote debugging is `no longer supported
                 <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

                  INSTANCE_ARN

                The Amazon Resource Name (ARN) of the device instance.

                 *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                  INSTANCE_LABELS

                The label of the device instance.

                 *Supported operators* : ``CONTAINS``

                  FLEET_TYPE

                The fleet type. Valid values are "PUBLIC" or "PRIVATE".

                 *Supported operators* : ``EQUALS``

              - **operator** *(string) --*

                Specifies how Device Farm compares the filter's attribute to the value. For the
                operators that are supported by each attribute, see the attribute descriptions.

              - **values** *(list) --*

                An array of one or more filter values used in a device filter.

                 **Operator Values**

                * The IN and NOT_IN operators can take a values array that has more than one
                element.

                * The other operators require an array with a single element.

                 **Attribute Values**

                * The PLATFORM attribute can be set to "ANDROID" or "IOS".

                * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
                or "TEMPORARY_NOT_AVAILABLE".

                * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

                * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

                - *(string) --*

          - **matchedDevicesCount** *(integer) --*

            The number of devices that matched the device filter selection criteria.

          - **maxDevices** *(integer) --*

            The maximum number of devices to be selected by a device filter and included in a test
            run.

    - **nextToken** *(string) --*

      If the number of items that are returned is significantly large, this is an identifier that
      is also returned, which can be used in a subsequent call to this operation to return the next
      set of items in the list.
    """


_ClientListSamplesResponsesamplesTypeDef = TypedDict(
    "_ClientListSamplesResponsesamplesTypeDef",
    {"arn": str, "type": str, "url": str},
    total=False,
)


class ClientListSamplesResponsesamplesTypeDef(_ClientListSamplesResponsesamplesTypeDef):
    """
    Type definition for `ClientListSamplesResponse` `samples`

    Represents a sample of performance data.

    - **arn** *(string) --*

      The sample's ARN.

    - **type** *(string) --*

      The sample's type.

      Must be one of the following values:

      * CPU: A CPU sample type. This is expressed as the app processing CPU time (including
      child processes) as reported by process, as a percentage.

      * MEMORY: A memory usage sample type. This is expressed as the total proportional set
      size of an app process, in kilobytes.

      * NATIVE_AVG_DRAWTIME

      * NATIVE_FPS

      * NATIVE_FRAMES

      * NATIVE_MAX_DRAWTIME

      * NATIVE_MIN_DRAWTIME

      * OPENGL_AVG_DRAWTIME

      * OPENGL_FPS

      * OPENGL_FRAMES

      * OPENGL_MAX_DRAWTIME

      * OPENGL_MIN_DRAWTIME

      * RX

      * RX_RATE: The total number of bytes per second (TCP and UDP) that are sent, by app
      process.

      * THREADS: A threads sample type. This is expressed as the total number of threads per
      app process.

      * TX

      * TX_RATE: The total number of bytes per second (TCP and UDP) that are received, by app
      process.

    - **url** *(string) --*

      The pre-signed Amazon S3 URL that can be used with a corresponding GET request to
      download the sample's file.
    """


_ClientListSamplesResponseTypeDef = TypedDict(
    "_ClientListSamplesResponseTypeDef",
    {"samples": List[ClientListSamplesResponsesamplesTypeDef], "nextToken": str},
    total=False,
)


class ClientListSamplesResponseTypeDef(_ClientListSamplesResponseTypeDef):
    """
    Type definition for `ClientListSamples` `Response`

    Represents the result of a list samples request.

    - **samples** *(list) --*

      Information about the samples.

      - *(dict) --*

        Represents a sample of performance data.

        - **arn** *(string) --*

          The sample's ARN.

        - **type** *(string) --*

          The sample's type.

          Must be one of the following values:

          * CPU: A CPU sample type. This is expressed as the app processing CPU time (including
          child processes) as reported by process, as a percentage.

          * MEMORY: A memory usage sample type. This is expressed as the total proportional set
          size of an app process, in kilobytes.

          * NATIVE_AVG_DRAWTIME

          * NATIVE_FPS

          * NATIVE_FRAMES

          * NATIVE_MAX_DRAWTIME

          * NATIVE_MIN_DRAWTIME

          * OPENGL_AVG_DRAWTIME

          * OPENGL_FPS

          * OPENGL_FRAMES

          * OPENGL_MAX_DRAWTIME

          * OPENGL_MIN_DRAWTIME

          * RX

          * RX_RATE: The total number of bytes per second (TCP and UDP) that are sent, by app
          process.

          * THREADS: A threads sample type. This is expressed as the total number of threads per
          app process.

          * TX

          * TX_RATE: The total number of bytes per second (TCP and UDP) that are received, by app
          process.

        - **url** *(string) --*

          The pre-signed Amazon S3 URL that can be used with a corresponding GET request to
          download the sample's file.

    - **nextToken** *(string) --*

      If the number of items that are returned is significantly large, this is an identifier that
      is also returned, which can be used in a subsequent call to this operation to return the next
      set of items in the list.
    """


_ClientListSuitesResponsesuitescountersTypeDef = TypedDict(
    "_ClientListSuitesResponsesuitescountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ClientListSuitesResponsesuitescountersTypeDef(
    _ClientListSuitesResponsesuitescountersTypeDef
):
    """
    Type definition for `ClientListSuitesResponsesuites` `counters`

    The suite's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ClientListSuitesResponsesuitesdeviceMinutesTypeDef = TypedDict(
    "_ClientListSuitesResponsesuitesdeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientListSuitesResponsesuitesdeviceMinutesTypeDef(
    _ClientListSuitesResponsesuitesdeviceMinutesTypeDef
):
    """
    Type definition for `ClientListSuitesResponsesuites` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the test suite.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to
      run tests.
    """


_ClientListSuitesResponsesuitesTypeDef = TypedDict(
    "_ClientListSuitesResponsesuitesTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ClientListSuitesResponsesuitescountersTypeDef,
        "message": str,
        "deviceMinutes": ClientListSuitesResponsesuitesdeviceMinutesTypeDef,
    },
    total=False,
)


class ClientListSuitesResponsesuitesTypeDef(_ClientListSuitesResponsesuitesTypeDef):
    """
    Type definition for `ClientListSuitesResponse` `suites`

    Represents a collection of one or more tests.

    - **arn** *(string) --*

      The suite's ARN.

    - **name** *(string) --*

      The suite's name.

    - **type** *(string) --*

      The suite's type.

      Must be one of the following values:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **created** *(datetime) --*

      When the suite was created.

    - **status** *(string) --*

      The suite's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The suite's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The suite's start time.

    - **stopped** *(datetime) --*

      The suite's stop time.

    - **counters** *(dict) --*

      The suite's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the suite's result.

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the test suite.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to
        run tests.
    """


_ClientListSuitesResponseTypeDef = TypedDict(
    "_ClientListSuitesResponseTypeDef",
    {"suites": List[ClientListSuitesResponsesuitesTypeDef], "nextToken": str},
    total=False,
)


class ClientListSuitesResponseTypeDef(_ClientListSuitesResponseTypeDef):
    """
    Type definition for `ClientListSuites` `Response`

    Represents the result of a list suites request.

    - **suites** *(list) --*

      Information about the suites.

      - *(dict) --*

        Represents a collection of one or more tests.

        - **arn** *(string) --*

          The suite's ARN.

        - **name** *(string) --*

          The suite's name.

        - **type** *(string) --*

          The suite's type.

          Must be one of the following values:

          * BUILTIN_FUZZ: The built-in fuzz type.

          * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
          interacting with it and capturing screenshots at the same time.

          * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

          * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

          * APPIUM_PYTHON: The Appium Python type.

          * APPIUM_NODE: The Appium Node.js type.

          * APPIUM_RUBY: The Appium Ruby type.

          * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

          * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

          * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

          * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

          * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

          * CALABASH: The Calabash type.

          * INSTRUMENTATION: The Instrumentation type.

          * UIAUTOMATION: The uiautomation type.

          * UIAUTOMATOR: The uiautomator type.

          * XCTEST: The Xcode test type.

          * XCTEST_UI: The Xcode UI test type.

        - **created** *(datetime) --*

          When the suite was created.

        - **status** *(string) --*

          The suite's status.

          Allowed values include:

          * PENDING: A pending status.

          * PENDING_CONCURRENCY: A pending concurrency status.

          * PENDING_DEVICE: A pending device status.

          * PROCESSING: A processing status.

          * SCHEDULING: A scheduling status.

          * PREPARING: A preparing status.

          * RUNNING: A running status.

          * COMPLETED: A completed status.

          * STOPPING: A stopping status.

        - **result** *(string) --*

          The suite's result.

          Allowed values include:

          * PENDING: A pending condition.

          * PASSED: A passing condition.

          * WARNED: A warning condition.

          * FAILED: A failed condition.

          * SKIPPED: A skipped condition.

          * ERRORED: An error condition.

          * STOPPED: A stopped condition.

        - **started** *(datetime) --*

          The suite's start time.

        - **stopped** *(datetime) --*

          The suite's stop time.

        - **counters** *(dict) --*

          The suite's result counters.

          - **total** *(integer) --*

            The total number of entities.

          - **passed** *(integer) --*

            The number of passed entities.

          - **failed** *(integer) --*

            The number of failed entities.

          - **warned** *(integer) --*

            The number of warned entities.

          - **errored** *(integer) --*

            The number of errored entities.

          - **stopped** *(integer) --*

            The number of stopped entities.

          - **skipped** *(integer) --*

            The number of skipped entities.

        - **message** *(string) --*

          A message about the suite's result.

        - **deviceMinutes** *(dict) --*

          Represents the total (metered or unmetered) minutes used by the test suite.

          - **total** *(float) --*

            When specified, represents the total minutes used by the resource to run tests.

          - **metered** *(float) --*

            When specified, represents only the sum of metered minutes used by the resource to run
            tests.

          - **unmetered** *(float) --*

            When specified, represents only the sum of unmetered minutes used by the resource to
            run tests.

    - **nextToken** *(string) --*

      If the number of items that are returned is significantly large, this is an identifier that
      is also returned, which can be used in a subsequent call to this operation to return the next
      set of items in the list.
    """


_ClientListTagsForResourceResponseTagsTypeDef = TypedDict(
    "_ClientListTagsForResourceResponseTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)


class ClientListTagsForResourceResponseTagsTypeDef(
    _ClientListTagsForResourceResponseTagsTypeDef
):
    """
    Type definition for `ClientListTagsForResourceResponse` `Tags`

    The metadata that you apply to a resource to help you categorize and organize it. Each tag
    consists of a key and an optional value, both of which you define. Tag keys can have a
    maximum character length of 128 characters, and tag values can have a maximum length of 256
    characters.

    - **Key** *(string) --*

      One part of a key-value pair that make up a tag. A ``key`` is a general label that acts
      like a category for more specific tag values.

    - **Value** *(string) --*

      The optional part of a key-value pair that make up a tag. A ``value`` acts as a
      descriptor within a tag category (key).
    """


_ClientListTagsForResourceResponseTypeDef = TypedDict(
    "_ClientListTagsForResourceResponseTypeDef",
    {"Tags": List[ClientListTagsForResourceResponseTagsTypeDef]},
    total=False,
)


class ClientListTagsForResourceResponseTypeDef(
    _ClientListTagsForResourceResponseTypeDef
):
    """
    Type definition for `ClientListTagsForResource` `Response`

    - **Tags** *(list) --*

      The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a
      maximum character length of 128 characters, and tag values can have a maximum length of 256
      characters.

      - *(dict) --*

        The metadata that you apply to a resource to help you categorize and organize it. Each tag
        consists of a key and an optional value, both of which you define. Tag keys can have a
        maximum character length of 128 characters, and tag values can have a maximum length of 256
        characters.

        - **Key** *(string) --*

          One part of a key-value pair that make up a tag. A ``key`` is a general label that acts
          like a category for more specific tag values.

        - **Value** *(string) --*

          The optional part of a key-value pair that make up a tag. A ``value`` acts as a
          descriptor within a tag category (key).
    """


_ClientListTestsResponsetestscountersTypeDef = TypedDict(
    "_ClientListTestsResponsetestscountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ClientListTestsResponsetestscountersTypeDef(
    _ClientListTestsResponsetestscountersTypeDef
):
    """
    Type definition for `ClientListTestsResponsetests` `counters`

    The test's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ClientListTestsResponsetestsdeviceMinutesTypeDef = TypedDict(
    "_ClientListTestsResponsetestsdeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientListTestsResponsetestsdeviceMinutesTypeDef(
    _ClientListTestsResponsetestsdeviceMinutesTypeDef
):
    """
    Type definition for `ClientListTestsResponsetests` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the test.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to
      run tests.
    """


_ClientListTestsResponsetestsTypeDef = TypedDict(
    "_ClientListTestsResponsetestsTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ClientListTestsResponsetestscountersTypeDef,
        "message": str,
        "deviceMinutes": ClientListTestsResponsetestsdeviceMinutesTypeDef,
    },
    total=False,
)


class ClientListTestsResponsetestsTypeDef(_ClientListTestsResponsetestsTypeDef):
    """
    Type definition for `ClientListTestsResponse` `tests`

    Represents a condition that is evaluated.

    - **arn** *(string) --*

      The test's ARN.

    - **name** *(string) --*

      The test's name.

    - **type** *(string) --*

      The test's type.

      Must be one of the following values:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **created** *(datetime) --*

      When the test was created.

    - **status** *(string) --*

      The test's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The test's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The test's start time.

    - **stopped** *(datetime) --*

      The test's stop time.

    - **counters** *(dict) --*

      The test's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the test's result.

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the test.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to
        run tests.
    """


_ClientListTestsResponseTypeDef = TypedDict(
    "_ClientListTestsResponseTypeDef",
    {"tests": List[ClientListTestsResponsetestsTypeDef], "nextToken": str},
    total=False,
)


class ClientListTestsResponseTypeDef(_ClientListTestsResponseTypeDef):
    """
    Type definition for `ClientListTests` `Response`

    Represents the result of a list tests request.

    - **tests** *(list) --*

      Information about the tests.

      - *(dict) --*

        Represents a condition that is evaluated.

        - **arn** *(string) --*

          The test's ARN.

        - **name** *(string) --*

          The test's name.

        - **type** *(string) --*

          The test's type.

          Must be one of the following values:

          * BUILTIN_FUZZ: The built-in fuzz type.

          * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
          interacting with it and capturing screenshots at the same time.

          * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

          * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

          * APPIUM_PYTHON: The Appium Python type.

          * APPIUM_NODE: The Appium Node.js type.

          * APPIUM_RUBY: The Appium Ruby type.

          * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

          * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

          * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

          * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

          * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

          * CALABASH: The Calabash type.

          * INSTRUMENTATION: The Instrumentation type.

          * UIAUTOMATION: The uiautomation type.

          * UIAUTOMATOR: The uiautomator type.

          * XCTEST: The Xcode test type.

          * XCTEST_UI: The Xcode UI test type.

        - **created** *(datetime) --*

          When the test was created.

        - **status** *(string) --*

          The test's status.

          Allowed values include:

          * PENDING: A pending status.

          * PENDING_CONCURRENCY: A pending concurrency status.

          * PENDING_DEVICE: A pending device status.

          * PROCESSING: A processing status.

          * SCHEDULING: A scheduling status.

          * PREPARING: A preparing status.

          * RUNNING: A running status.

          * COMPLETED: A completed status.

          * STOPPING: A stopping status.

        - **result** *(string) --*

          The test's result.

          Allowed values include:

          * PENDING: A pending condition.

          * PASSED: A passing condition.

          * WARNED: A warning condition.

          * FAILED: A failed condition.

          * SKIPPED: A skipped condition.

          * ERRORED: An error condition.

          * STOPPED: A stopped condition.

        - **started** *(datetime) --*

          The test's start time.

        - **stopped** *(datetime) --*

          The test's stop time.

        - **counters** *(dict) --*

          The test's result counters.

          - **total** *(integer) --*

            The total number of entities.

          - **passed** *(integer) --*

            The number of passed entities.

          - **failed** *(integer) --*

            The number of failed entities.

          - **warned** *(integer) --*

            The number of warned entities.

          - **errored** *(integer) --*

            The number of errored entities.

          - **stopped** *(integer) --*

            The number of stopped entities.

          - **skipped** *(integer) --*

            The number of skipped entities.

        - **message** *(string) --*

          A message about the test's result.

        - **deviceMinutes** *(dict) --*

          Represents the total (metered or unmetered) minutes used by the test.

          - **total** *(float) --*

            When specified, represents the total minutes used by the resource to run tests.

          - **metered** *(float) --*

            When specified, represents only the sum of metered minutes used by the resource to run
            tests.

          - **unmetered** *(float) --*

            When specified, represents only the sum of unmetered minutes used by the resource to
            run tests.

    - **nextToken** *(string) --*

      If the number of items that are returned is significantly large, this is an identifier that
      is also returned, which can be used in a subsequent call to this operation to return the next
      set of items in the list.
    """


_ClientListUniqueProblemsResponseuniqueProblemsproblemsdevicecpuTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseuniqueProblemsproblemsdevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientListUniqueProblemsResponseuniqueProblemsproblemsdevicecpuTypeDef(
    _ClientListUniqueProblemsResponseuniqueProblemsproblemsdevicecpuTypeDef
):
    """
    Type definition for `ClientListUniqueProblemsResponseuniqueProblemsproblemsdevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a
      1.2 GHz CPU is expressed as 1200000000.
    """


_ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesinstanceProfileTypeDef(
    _ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test
      run. The default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not
      be cleaned up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to
      ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test
      run. The default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesTypeDef(
    _ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesTypeDef
):
    """
    Type definition for `ClientListUniqueProblemsResponseuniqueProblemsproblemsdevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test
        run. The default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not
        be cleaned up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to
        ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test
        run. The default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceresolutionTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceresolutionTypeDef(
    _ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceresolutionTypeDef
):
    """
    Type definition for `ClientListUniqueProblemsResponseuniqueProblemsproblemsdevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientListUniqueProblemsResponseuniqueProblemsproblemsdevicecpuTypeDef,
        "resolution": ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[
            ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceinstancesTypeDef
        ],
        "availability": str,
    },
    total=False,
)


class ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceTypeDef(
    _ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceTypeDef
):
    """
    Type definition for `ClientListUniqueProblemsResponseuniqueProblemsproblems` `device`

    Information about the associated device.

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a
        1.2 GHz CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__
       .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type
      are PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test
            run. The default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not
            be cleaned up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to
            ``true`` .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test
            run. The default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently
      available in the ListDevices and GetDevice API methods.
    """


_ClientListUniqueProblemsResponseuniqueProblemsproblemsjobTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseuniqueProblemsproblemsjobTypeDef",
    {"arn": str, "name": str},
    total=False,
)


class ClientListUniqueProblemsResponseuniqueProblemsproblemsjobTypeDef(
    _ClientListUniqueProblemsResponseuniqueProblemsproblemsjobTypeDef
):
    """
    Type definition for `ClientListUniqueProblemsResponseuniqueProblemsproblems` `job`

    Information about the associated job.

    - **arn** *(string) --*

      The problem detail's ARN.

    - **name** *(string) --*

      The problem detail's name.
    """


_ClientListUniqueProblemsResponseuniqueProblemsproblemsrunTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseuniqueProblemsproblemsrunTypeDef",
    {"arn": str, "name": str},
    total=False,
)


class ClientListUniqueProblemsResponseuniqueProblemsproblemsrunTypeDef(
    _ClientListUniqueProblemsResponseuniqueProblemsproblemsrunTypeDef
):
    """
    Type definition for `ClientListUniqueProblemsResponseuniqueProblemsproblems` `run`

    Information about the associated run.

    - **arn** *(string) --*

      The problem detail's ARN.

    - **name** *(string) --*

      The problem detail's name.
    """


_ClientListUniqueProblemsResponseuniqueProblemsproblemssuiteTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseuniqueProblemsproblemssuiteTypeDef",
    {"arn": str, "name": str},
    total=False,
)


class ClientListUniqueProblemsResponseuniqueProblemsproblemssuiteTypeDef(
    _ClientListUniqueProblemsResponseuniqueProblemsproblemssuiteTypeDef
):
    """
    Type definition for `ClientListUniqueProblemsResponseuniqueProblemsproblems` `suite`

    Information about the associated suite.

    - **arn** *(string) --*

      The problem detail's ARN.

    - **name** *(string) --*

      The problem detail's name.
    """


_ClientListUniqueProblemsResponseuniqueProblemsproblemstestTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseuniqueProblemsproblemstestTypeDef",
    {"arn": str, "name": str},
    total=False,
)


class ClientListUniqueProblemsResponseuniqueProblemsproblemstestTypeDef(
    _ClientListUniqueProblemsResponseuniqueProblemsproblemstestTypeDef
):
    """
    Type definition for `ClientListUniqueProblemsResponseuniqueProblemsproblems` `test`

    Information about the associated test.

    - **arn** *(string) --*

      The problem detail's ARN.

    - **name** *(string) --*

      The problem detail's name.
    """


_ClientListUniqueProblemsResponseuniqueProblemsproblemsTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseuniqueProblemsproblemsTypeDef",
    {
        "run": ClientListUniqueProblemsResponseuniqueProblemsproblemsrunTypeDef,
        "job": ClientListUniqueProblemsResponseuniqueProblemsproblemsjobTypeDef,
        "suite": ClientListUniqueProblemsResponseuniqueProblemsproblemssuiteTypeDef,
        "test": ClientListUniqueProblemsResponseuniqueProblemsproblemstestTypeDef,
        "device": ClientListUniqueProblemsResponseuniqueProblemsproblemsdeviceTypeDef,
        "result": str,
        "message": str,
    },
    total=False,
)


class ClientListUniqueProblemsResponseuniqueProblemsproblemsTypeDef(
    _ClientListUniqueProblemsResponseuniqueProblemsproblemsTypeDef
):
    """
    Type definition for `ClientListUniqueProblemsResponseuniqueProblems` `problems`

    Represents a specific warning or failure.

    - **run** *(dict) --*

      Information about the associated run.

      - **arn** *(string) --*

        The problem detail's ARN.

      - **name** *(string) --*

        The problem detail's name.

    - **job** *(dict) --*

      Information about the associated job.

      - **arn** *(string) --*

        The problem detail's ARN.

      - **name** *(string) --*

        The problem detail's name.

    - **suite** *(dict) --*

      Information about the associated suite.

      - **arn** *(string) --*

        The problem detail's ARN.

      - **name** *(string) --*

        The problem detail's name.

    - **test** *(dict) --*

      Information about the associated test.

      - **arn** *(string) --*

        The problem detail's ARN.

      - **name** *(string) --*

        The problem detail's name.

    - **device** *(dict) --*

      Information about the associated device.

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a
          1.2 GHz CPU is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__
         .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type
        are PRIVATE and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test
              run. The default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not
              be cleaned up from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to
              ``true`` .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test
              run. The default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently
        available in the ListDevices and GetDevice API methods.

    - **result** *(string) --*

      The problem's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **message** *(string) --*

      A message about the problem's result.
    """


_ClientListUniqueProblemsResponseuniqueProblemsTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseuniqueProblemsTypeDef",
    {
        "message": str,
        "problems": List[ClientListUniqueProblemsResponseuniqueProblemsproblemsTypeDef],
    },
    total=False,
)


class ClientListUniqueProblemsResponseuniqueProblemsTypeDef(
    _ClientListUniqueProblemsResponseuniqueProblemsTypeDef
):
    """
    Type definition for `ClientListUniqueProblemsResponse` `uniqueProblems`

    A collection of one or more problems, grouped by their result.

    - **message** *(string) --*

      A message about the unique problems' result.

    - **problems** *(list) --*

      Information about the problems.

      - *(dict) --*

        Represents a specific warning or failure.

        - **run** *(dict) --*

          Information about the associated run.

          - **arn** *(string) --*

            The problem detail's ARN.

          - **name** *(string) --*

            The problem detail's name.

        - **job** *(dict) --*

          Information about the associated job.

          - **arn** *(string) --*

            The problem detail's ARN.

          - **name** *(string) --*

            The problem detail's name.

        - **suite** *(dict) --*

          Information about the associated suite.

          - **arn** *(string) --*

            The problem detail's ARN.

          - **name** *(string) --*

            The problem detail's name.

        - **test** *(dict) --*

          Information about the associated test.

          - **arn** *(string) --*

            The problem detail's ARN.

          - **name** *(string) --*

            The problem detail's name.

        - **device** *(dict) --*

          Information about the associated device.

          - **arn** *(string) --*

            The device's ARN.

          - **name** *(string) --*

            The device's display name.

          - **manufacturer** *(string) --*

            The device's manufacturer name.

          - **model** *(string) --*

            The device's model name.

          - **modelId** *(string) --*

            The device's model ID.

          - **formFactor** *(string) --*

            The device's form factor.

            Allowed values include:

            * PHONE: The phone form factor.

            * TABLET: The tablet form factor.

          - **platform** *(string) --*

            The device's platform.

            Allowed values include:

            * ANDROID: The Android platform.

            * IOS: The iOS platform.

          - **os** *(string) --*

            The device's operating system type.

          - **cpu** *(dict) --*

            Information about the device's CPU.

            - **frequency** *(string) --*

              The CPU's frequency.

            - **architecture** *(string) --*

              The CPU's architecture, for example x86 or ARM.

            - **clock** *(float) --*

              The clock speed of the device's CPU, expressed in hertz (Hz). For example, a
              1.2 GHz CPU is expressed as 1200000000.

          - **resolution** *(dict) --*

            The resolution of the device.

            - **width** *(integer) --*

              The screen resolution's width, expressed in pixels.

            - **height** *(integer) --*

              The screen resolution's height, expressed in pixels.

          - **heapSize** *(integer) --*

            The device's heap size, expressed in bytes.

          - **memory** *(integer) --*

            The device's total memory size, expressed in bytes.

          - **image** *(string) --*

            The device's image name.

          - **carrier** *(string) --*

            The device's carrier.

          - **radio** *(string) --*

            The device's radio.

          - **remoteAccessEnabled** *(boolean) --*

            Specifies whether remote access has been enabled for the specified device.

          - **remoteDebugEnabled** *(boolean) --*

            This flag is set to ``true`` if remote debugging is enabled for the device.

             *Remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__
             .*

          - **fleetType** *(string) --*

            The type of fleet to which this device belongs. Possible values for fleet type
            are PRIVATE and PUBLIC.

          - **fleetName** *(string) --*

            The name of the fleet to which this device belongs.

          - **instances** *(list) --*

            The instances belonging to this device.

            - *(dict) --*

              Represents the device instance.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the device instance.

              - **deviceArn** *(string) --*

                The Amazon Resource Name (ARN) of the device.

              - **labels** *(list) --*

                An array of strings describing the device instance.

                - *(string) --*

              - **status** *(string) --*

                The status of the device instance. Valid values are listed below.

              - **udid** *(string) --*

                Unique device identifier for the device instance.

              - **instanceProfile** *(dict) --*

                A object containing information about the instance profile.

                - **arn** *(string) --*

                  The Amazon Resource Name (ARN) of the instance profile.

                - **packageCleanup** *(boolean) --*

                  When set to ``true`` , Device Farm will remove app packages after a test
                  run. The default value is ``false`` for private devices.

                - **excludeAppPackagesFromCleanup** *(list) --*

                  An array of strings specifying the list of app packages that should not
                  be cleaned up from the device after a test run is over.

                  The list of packages is only considered if you set ``packageCleanup`` to
                  ``true`` .

                  - *(string) --*

                - **rebootAfterUse** *(boolean) --*

                  When set to ``true`` , Device Farm will reboot the instance after a test
                  run. The default value is ``true`` .

                - **name** *(string) --*

                  The name of the instance profile.

                - **description** *(string) --*

                  The description of the instance profile.

          - **availability** *(string) --*

            Reflects how likely a device will be available for a test run. It is currently
            available in the ListDevices and GetDevice API methods.

        - **result** *(string) --*

          The problem's result.

          Allowed values include:

          * PENDING: A pending condition.

          * PASSED: A passing condition.

          * WARNED: A warning condition.

          * FAILED: A failed condition.

          * SKIPPED: A skipped condition.

          * ERRORED: An error condition.

          * STOPPED: A stopped condition.

        - **message** *(string) --*

          A message about the problem's result.
    """


_ClientListUniqueProblemsResponseTypeDef = TypedDict(
    "_ClientListUniqueProblemsResponseTypeDef",
    {
        "uniqueProblems": Dict[
            str, List[ClientListUniqueProblemsResponseuniqueProblemsTypeDef]
        ],
        "nextToken": str,
    },
    total=False,
)


class ClientListUniqueProblemsResponseTypeDef(_ClientListUniqueProblemsResponseTypeDef):
    """
    Type definition for `ClientListUniqueProblems` `Response`

    Represents the result of a list unique problems request.

    - **uniqueProblems** *(dict) --*

      Information about the unique problems.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

      - *(string) --*

        - *(list) --*

          - *(dict) --*

            A collection of one or more problems, grouped by their result.

            - **message** *(string) --*

              A message about the unique problems' result.

            - **problems** *(list) --*

              Information about the problems.

              - *(dict) --*

                Represents a specific warning or failure.

                - **run** *(dict) --*

                  Information about the associated run.

                  - **arn** *(string) --*

                    The problem detail's ARN.

                  - **name** *(string) --*

                    The problem detail's name.

                - **job** *(dict) --*

                  Information about the associated job.

                  - **arn** *(string) --*

                    The problem detail's ARN.

                  - **name** *(string) --*

                    The problem detail's name.

                - **suite** *(dict) --*

                  Information about the associated suite.

                  - **arn** *(string) --*

                    The problem detail's ARN.

                  - **name** *(string) --*

                    The problem detail's name.

                - **test** *(dict) --*

                  Information about the associated test.

                  - **arn** *(string) --*

                    The problem detail's ARN.

                  - **name** *(string) --*

                    The problem detail's name.

                - **device** *(dict) --*

                  Information about the associated device.

                  - **arn** *(string) --*

                    The device's ARN.

                  - **name** *(string) --*

                    The device's display name.

                  - **manufacturer** *(string) --*

                    The device's manufacturer name.

                  - **model** *(string) --*

                    The device's model name.

                  - **modelId** *(string) --*

                    The device's model ID.

                  - **formFactor** *(string) --*

                    The device's form factor.

                    Allowed values include:

                    * PHONE: The phone form factor.

                    * TABLET: The tablet form factor.

                  - **platform** *(string) --*

                    The device's platform.

                    Allowed values include:

                    * ANDROID: The Android platform.

                    * IOS: The iOS platform.

                  - **os** *(string) --*

                    The device's operating system type.

                  - **cpu** *(dict) --*

                    Information about the device's CPU.

                    - **frequency** *(string) --*

                      The CPU's frequency.

                    - **architecture** *(string) --*

                      The CPU's architecture, for example x86 or ARM.

                    - **clock** *(float) --*

                      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a
                      1.2 GHz CPU is expressed as 1200000000.

                  - **resolution** *(dict) --*

                    The resolution of the device.

                    - **width** *(integer) --*

                      The screen resolution's width, expressed in pixels.

                    - **height** *(integer) --*

                      The screen resolution's height, expressed in pixels.

                  - **heapSize** *(integer) --*

                    The device's heap size, expressed in bytes.

                  - **memory** *(integer) --*

                    The device's total memory size, expressed in bytes.

                  - **image** *(string) --*

                    The device's image name.

                  - **carrier** *(string) --*

                    The device's carrier.

                  - **radio** *(string) --*

                    The device's radio.

                  - **remoteAccessEnabled** *(boolean) --*

                    Specifies whether remote access has been enabled for the specified device.

                  - **remoteDebugEnabled** *(boolean) --*

                    This flag is set to ``true`` if remote debugging is enabled for the device.

                     *Remote debugging is `no longer supported
                     <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__
                     .*

                  - **fleetType** *(string) --*

                    The type of fleet to which this device belongs. Possible values for fleet type
                    are PRIVATE and PUBLIC.

                  - **fleetName** *(string) --*

                    The name of the fleet to which this device belongs.

                  - **instances** *(list) --*

                    The instances belonging to this device.

                    - *(dict) --*

                      Represents the device instance.

                      - **arn** *(string) --*

                        The Amazon Resource Name (ARN) of the device instance.

                      - **deviceArn** *(string) --*

                        The Amazon Resource Name (ARN) of the device.

                      - **labels** *(list) --*

                        An array of strings describing the device instance.

                        - *(string) --*

                      - **status** *(string) --*

                        The status of the device instance. Valid values are listed below.

                      - **udid** *(string) --*

                        Unique device identifier for the device instance.

                      - **instanceProfile** *(dict) --*

                        A object containing information about the instance profile.

                        - **arn** *(string) --*

                          The Amazon Resource Name (ARN) of the instance profile.

                        - **packageCleanup** *(boolean) --*

                          When set to ``true`` , Device Farm will remove app packages after a test
                          run. The default value is ``false`` for private devices.

                        - **excludeAppPackagesFromCleanup** *(list) --*

                          An array of strings specifying the list of app packages that should not
                          be cleaned up from the device after a test run is over.

                          The list of packages is only considered if you set ``packageCleanup`` to
                          ``true`` .

                          - *(string) --*

                        - **rebootAfterUse** *(boolean) --*

                          When set to ``true`` , Device Farm will reboot the instance after a test
                          run. The default value is ``true`` .

                        - **name** *(string) --*

                          The name of the instance profile.

                        - **description** *(string) --*

                          The description of the instance profile.

                  - **availability** *(string) --*

                    Reflects how likely a device will be available for a test run. It is currently
                    available in the ListDevices and GetDevice API methods.

                - **result** *(string) --*

                  The problem's result.

                  Allowed values include:

                  * PENDING: A pending condition.

                  * PASSED: A passing condition.

                  * WARNED: A warning condition.

                  * FAILED: A failed condition.

                  * SKIPPED: A skipped condition.

                  * ERRORED: An error condition.

                  * STOPPED: A stopped condition.

                - **message** *(string) --*

                  A message about the problem's result.

    - **nextToken** *(string) --*

      If the number of items that are returned is significantly large, this is an identifier that
      is also returned, which can be used in a subsequent call to this operation to return the next
      set of items in the list.
    """


_ClientListUploadsResponseuploadsTypeDef = TypedDict(
    "_ClientListUploadsResponseuploadsTypeDef",
    {
        "arn": str,
        "name": str,
        "created": datetime,
        "type": str,
        "status": str,
        "url": str,
        "metadata": str,
        "contentType": str,
        "message": str,
        "category": str,
    },
    total=False,
)


class ClientListUploadsResponseuploadsTypeDef(_ClientListUploadsResponseuploadsTypeDef):
    """
    Type definition for `ClientListUploadsResponse` `uploads`

    An app or a set of one or more tests to upload or that have been uploaded.

    - **arn** *(string) --*

      The upload's ARN.

    - **name** *(string) --*

      The upload's file name.

    - **created** *(datetime) --*

      When the upload was created.

    - **type** *(string) --*

      The upload's type.

      Must be one of the following values:

      * ANDROID_APP: An Android upload.

      * IOS_APP: An iOS upload.

      * WEB_APP: A web application upload.

      * EXTERNAL_DATA: An external data upload.

      * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.

      * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.

      * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.

      * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.

      * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.

      * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for web
      apps.

      * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for web
      apps.

      * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for web apps.

      * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for web apps.

      * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for web apps.

      * CALABASH_TEST_PACKAGE: A Calabash test package upload.

      * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.

      * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.

      * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.

      * XCTEST_TEST_PACKAGE: An Xcode test package upload.

      * XCTEST_UI_TEST_PACKAGE: An Xcode UI test package upload.

      * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.

      * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.

      * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.

      * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.

      * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.

      * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.

      * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.

      * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.

      * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.

      * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.

      * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.

      * XCTEST_UI_TEST_SPEC: An Xcode UI test spec upload.

    - **status** *(string) --*

      The upload's status.

      Must be one of the following values:

      * FAILED: A failed status.

      * INITIALIZED: An initialized status.

      * PROCESSING: A processing status.

      * SUCCEEDED: A succeeded status.

    - **url** *(string) --*

      The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT
      request.

    - **metadata** *(string) --*

      The upload's metadata. For example, for Android, this contains information that is parsed
      from the manifest and is displayed in the AWS Device Farm console after the associated
      app is uploaded.

    - **contentType** *(string) --*

      The upload's content type (for example, "application/octet-stream").

    - **message** *(string) --*

      A message about the upload's result.

    - **category** *(string) --*

      The upload's category. Allowed values include:

      * CURATED: An upload managed by AWS Device Farm.

      * PRIVATE: An upload managed by the AWS Device Farm customer.
    """


_ClientListUploadsResponseTypeDef = TypedDict(
    "_ClientListUploadsResponseTypeDef",
    {"uploads": List[ClientListUploadsResponseuploadsTypeDef], "nextToken": str},
    total=False,
)


class ClientListUploadsResponseTypeDef(_ClientListUploadsResponseTypeDef):
    """
    Type definition for `ClientListUploads` `Response`

    Represents the result of a list uploads request.

    - **uploads** *(list) --*

      Information about the uploads.

      - *(dict) --*

        An app or a set of one or more tests to upload or that have been uploaded.

        - **arn** *(string) --*

          The upload's ARN.

        - **name** *(string) --*

          The upload's file name.

        - **created** *(datetime) --*

          When the upload was created.

        - **type** *(string) --*

          The upload's type.

          Must be one of the following values:

          * ANDROID_APP: An Android upload.

          * IOS_APP: An iOS upload.

          * WEB_APP: A web application upload.

          * EXTERNAL_DATA: An external data upload.

          * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.

          * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.

          * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.

          * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.

          * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.

          * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for web
          apps.

          * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for web
          apps.

          * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for web apps.

          * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for web apps.

          * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for web apps.

          * CALABASH_TEST_PACKAGE: A Calabash test package upload.

          * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.

          * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.

          * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.

          * XCTEST_TEST_PACKAGE: An Xcode test package upload.

          * XCTEST_UI_TEST_PACKAGE: An Xcode UI test package upload.

          * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.

          * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.

          * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.

          * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.

          * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.

          * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.

          * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.

          * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.

          * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.

          * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.

          * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.

          * XCTEST_UI_TEST_SPEC: An Xcode UI test spec upload.

        - **status** *(string) --*

          The upload's status.

          Must be one of the following values:

          * FAILED: A failed status.

          * INITIALIZED: An initialized status.

          * PROCESSING: A processing status.

          * SUCCEEDED: A succeeded status.

        - **url** *(string) --*

          The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT
          request.

        - **metadata** *(string) --*

          The upload's metadata. For example, for Android, this contains information that is parsed
          from the manifest and is displayed in the AWS Device Farm console after the associated
          app is uploaded.

        - **contentType** *(string) --*

          The upload's content type (for example, "application/octet-stream").

        - **message** *(string) --*

          A message about the upload's result.

        - **category** *(string) --*

          The upload's category. Allowed values include:

          * CURATED: An upload managed by AWS Device Farm.

          * PRIVATE: An upload managed by the AWS Device Farm customer.

    - **nextToken** *(string) --*

      If the number of items that are returned is significantly large, this is an identifier that
      is also returned, which can be used in a subsequent call to this operation to return the next
      set of items in the list.
    """


_ClientListVpceConfigurationsResponsevpceConfigurationsTypeDef = TypedDict(
    "_ClientListVpceConfigurationsResponsevpceConfigurationsTypeDef",
    {
        "arn": str,
        "vpceConfigurationName": str,
        "vpceServiceName": str,
        "serviceDnsName": str,
        "vpceConfigurationDescription": str,
    },
    total=False,
)


class ClientListVpceConfigurationsResponsevpceConfigurationsTypeDef(
    _ClientListVpceConfigurationsResponsevpceConfigurationsTypeDef
):
    """
    Type definition for `ClientListVpceConfigurationsResponse` `vpceConfigurations`

    Represents an Amazon Virtual Private Cloud (VPC) endpoint configuration.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the VPC endpoint configuration.

    - **vpceConfigurationName** *(string) --*

      The friendly name you give to your VPC endpoint configuration, to manage your
      configurations more easily.

    - **vpceServiceName** *(string) --*

      The name of the VPC endpoint service running inside your AWS account that you want Device
      Farm to test.

    - **serviceDnsName** *(string) --*

      The DNS name that maps to the private IP address of the service you want to access.

    - **vpceConfigurationDescription** *(string) --*

      An optional description, providing more details about your VPC endpoint configuration.
    """


_ClientListVpceConfigurationsResponseTypeDef = TypedDict(
    "_ClientListVpceConfigurationsResponseTypeDef",
    {
        "vpceConfigurations": List[
            ClientListVpceConfigurationsResponsevpceConfigurationsTypeDef
        ],
        "nextToken": str,
    },
    total=False,
)


class ClientListVpceConfigurationsResponseTypeDef(
    _ClientListVpceConfigurationsResponseTypeDef
):
    """
    Type definition for `ClientListVpceConfigurations` `Response`

    - **vpceConfigurations** *(list) --*

      An array of ``VPCEConfiguration`` objects containing information about your VPC endpoint
      configuration.

      - *(dict) --*

        Represents an Amazon Virtual Private Cloud (VPC) endpoint configuration.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the VPC endpoint configuration.

        - **vpceConfigurationName** *(string) --*

          The friendly name you give to your VPC endpoint configuration, to manage your
          configurations more easily.

        - **vpceServiceName** *(string) --*

          The name of the VPC endpoint service running inside your AWS account that you want Device
          Farm to test.

        - **serviceDnsName** *(string) --*

          The DNS name that maps to the private IP address of the service you want to access.

        - **vpceConfigurationDescription** *(string) --*

          An optional description, providing more details about your VPC endpoint configuration.

    - **nextToken** *(string) --*

      An identifier that was returned from the previous call to this operation, which can be used
      to return the next set of items in the list.
    """


_ClientPurchaseOfferingResponseofferingTransactioncostTypeDef = TypedDict(
    "_ClientPurchaseOfferingResponseofferingTransactioncostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class ClientPurchaseOfferingResponseofferingTransactioncostTypeDef(
    _ClientPurchaseOfferingResponseofferingTransactioncostTypeDef
):
    """
    Type definition for `ClientPurchaseOfferingResponseofferingTransaction` `cost`

    The cost of an offering transaction.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef = TypedDict(
    "_ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef(
    _ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef
):
    """
    Type definition for `ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringCharges` `cost`

    The cost of the recurring charge.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef = TypedDict(
    "_ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef",
    {
        "cost": ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef,
        "frequency": str,
    },
    total=False,
)


class ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef(
    _ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef
):
    """
    Type definition for `ClientPurchaseOfferingResponseofferingTransactionofferingStatusoffering` `recurringCharges`

    Specifies whether charges for devices will be recurring.

    - **cost** *(dict) --*

      The cost of the recurring charge.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

    - **frequency** *(string) --*

      The frequency in which charges will recur.
    """


_ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingTypeDef = TypedDict(
    "_ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingTypeDef",
    {
        "id": str,
        "description": str,
        "type": str,
        "platform": str,
        "recurringCharges": List[
            ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef
        ],
    },
    total=False,
)


class ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingTypeDef(
    _ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingTypeDef
):
    """
    Type definition for `ClientPurchaseOfferingResponseofferingTransactionofferingStatus` `offering`

    Represents the metadata of an offering status.

    - **id** *(string) --*

      The ID that corresponds to a device offering.

    - **description** *(string) --*

      A string describing the offering.

    - **type** *(string) --*

      The type of offering (e.g., "RECURRING") for a device.

    - **platform** *(string) --*

      The platform of the device (e.g., ANDROID or IOS).

    - **recurringCharges** *(list) --*

      Specifies whether there are recurring charges for the offering.

      - *(dict) --*

        Specifies whether charges for devices will be recurring.

        - **cost** *(dict) --*

          The cost of the recurring charge.

          - **amount** *(float) --*

            The numerical amount of an offering or transaction.

          - **currencyCode** *(string) --*

            The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

        - **frequency** *(string) --*

          The frequency in which charges will recur.
    """


_ClientPurchaseOfferingResponseofferingTransactionofferingStatusTypeDef = TypedDict(
    "_ClientPurchaseOfferingResponseofferingTransactionofferingStatusTypeDef",
    {
        "type": str,
        "offering": ClientPurchaseOfferingResponseofferingTransactionofferingStatusofferingTypeDef,
        "quantity": int,
        "effectiveOn": datetime,
    },
    total=False,
)


class ClientPurchaseOfferingResponseofferingTransactionofferingStatusTypeDef(
    _ClientPurchaseOfferingResponseofferingTransactionofferingStatusTypeDef
):
    """
    Type definition for `ClientPurchaseOfferingResponseofferingTransaction` `offeringStatus`

    The status of an offering transaction.

    - **type** *(string) --*

      The type specified for the offering status.

    - **offering** *(dict) --*

      Represents the metadata of an offering status.

      - **id** *(string) --*

        The ID that corresponds to a device offering.

      - **description** *(string) --*

        A string describing the offering.

      - **type** *(string) --*

        The type of offering (e.g., "RECURRING") for a device.

      - **platform** *(string) --*

        The platform of the device (e.g., ANDROID or IOS).

      - **recurringCharges** *(list) --*

        Specifies whether there are recurring charges for the offering.

        - *(dict) --*

          Specifies whether charges for devices will be recurring.

          - **cost** *(dict) --*

            The cost of the recurring charge.

            - **amount** *(float) --*

              The numerical amount of an offering or transaction.

            - **currencyCode** *(string) --*

              The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

          - **frequency** *(string) --*

            The frequency in which charges will recur.

    - **quantity** *(integer) --*

      The number of available devices in the offering.

    - **effectiveOn** *(datetime) --*

      The date on which the offering is effective.
    """


_ClientPurchaseOfferingResponseofferingTransactionTypeDef = TypedDict(
    "_ClientPurchaseOfferingResponseofferingTransactionTypeDef",
    {
        "offeringStatus": ClientPurchaseOfferingResponseofferingTransactionofferingStatusTypeDef,
        "transactionId": str,
        "offeringPromotionId": str,
        "createdOn": datetime,
        "cost": ClientPurchaseOfferingResponseofferingTransactioncostTypeDef,
    },
    total=False,
)


class ClientPurchaseOfferingResponseofferingTransactionTypeDef(
    _ClientPurchaseOfferingResponseofferingTransactionTypeDef
):
    """
    Type definition for `ClientPurchaseOfferingResponse` `offeringTransaction`

    Represents the offering transaction for the purchase result.

    - **offeringStatus** *(dict) --*

      The status of an offering transaction.

      - **type** *(string) --*

        The type specified for the offering status.

      - **offering** *(dict) --*

        Represents the metadata of an offering status.

        - **id** *(string) --*

          The ID that corresponds to a device offering.

        - **description** *(string) --*

          A string describing the offering.

        - **type** *(string) --*

          The type of offering (e.g., "RECURRING") for a device.

        - **platform** *(string) --*

          The platform of the device (e.g., ANDROID or IOS).

        - **recurringCharges** *(list) --*

          Specifies whether there are recurring charges for the offering.

          - *(dict) --*

            Specifies whether charges for devices will be recurring.

            - **cost** *(dict) --*

              The cost of the recurring charge.

              - **amount** *(float) --*

                The numerical amount of an offering or transaction.

              - **currencyCode** *(string) --*

                The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

            - **frequency** *(string) --*

              The frequency in which charges will recur.

      - **quantity** *(integer) --*

        The number of available devices in the offering.

      - **effectiveOn** *(datetime) --*

        The date on which the offering is effective.

    - **transactionId** *(string) --*

      The transaction ID of the offering transaction.

    - **offeringPromotionId** *(string) --*

      The ID that corresponds to a device offering promotion.

    - **createdOn** *(datetime) --*

      The date on which an offering transaction was created.

    - **cost** *(dict) --*

      The cost of an offering transaction.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ClientPurchaseOfferingResponseTypeDef = TypedDict(
    "_ClientPurchaseOfferingResponseTypeDef",
    {"offeringTransaction": ClientPurchaseOfferingResponseofferingTransactionTypeDef},
    total=False,
)


class ClientPurchaseOfferingResponseTypeDef(_ClientPurchaseOfferingResponseTypeDef):
    """
    Type definition for `ClientPurchaseOffering` `Response`

    The result of the purchase offering (e.g., success or failure).

    - **offeringTransaction** *(dict) --*

      Represents the offering transaction for the purchase result.

      - **offeringStatus** *(dict) --*

        The status of an offering transaction.

        - **type** *(string) --*

          The type specified for the offering status.

        - **offering** *(dict) --*

          Represents the metadata of an offering status.

          - **id** *(string) --*

            The ID that corresponds to a device offering.

          - **description** *(string) --*

            A string describing the offering.

          - **type** *(string) --*

            The type of offering (e.g., "RECURRING") for a device.

          - **platform** *(string) --*

            The platform of the device (e.g., ANDROID or IOS).

          - **recurringCharges** *(list) --*

            Specifies whether there are recurring charges for the offering.

            - *(dict) --*

              Specifies whether charges for devices will be recurring.

              - **cost** *(dict) --*

                The cost of the recurring charge.

                - **amount** *(float) --*

                  The numerical amount of an offering or transaction.

                - **currencyCode** *(string) --*

                  The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

              - **frequency** *(string) --*

                The frequency in which charges will recur.

        - **quantity** *(integer) --*

          The number of available devices in the offering.

        - **effectiveOn** *(datetime) --*

          The date on which the offering is effective.

      - **transactionId** *(string) --*

        The transaction ID of the offering transaction.

      - **offeringPromotionId** *(string) --*

        The ID that corresponds to a device offering promotion.

      - **createdOn** *(datetime) --*

        The date on which an offering transaction was created.

      - **cost** *(dict) --*

        The cost of an offering transaction.

        - **amount** *(float) --*

          The numerical amount of an offering or transaction.

        - **currencyCode** *(string) --*

          The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ClientRenewOfferingResponseofferingTransactioncostTypeDef = TypedDict(
    "_ClientRenewOfferingResponseofferingTransactioncostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class ClientRenewOfferingResponseofferingTransactioncostTypeDef(
    _ClientRenewOfferingResponseofferingTransactioncostTypeDef
):
    """
    Type definition for `ClientRenewOfferingResponseofferingTransaction` `cost`

    The cost of an offering transaction.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef = TypedDict(
    "_ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef(
    _ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef
):
    """
    Type definition for `ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringCharges` `cost`

    The cost of the recurring charge.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef = TypedDict(
    "_ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef",
    {
        "cost": ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargescostTypeDef,
        "frequency": str,
    },
    total=False,
)


class ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef(
    _ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef
):
    """
    Type definition for `ClientRenewOfferingResponseofferingTransactionofferingStatusoffering` `recurringCharges`

    Specifies whether charges for devices will be recurring.

    - **cost** *(dict) --*

      The cost of the recurring charge.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

    - **frequency** *(string) --*

      The frequency in which charges will recur.
    """


_ClientRenewOfferingResponseofferingTransactionofferingStatusofferingTypeDef = TypedDict(
    "_ClientRenewOfferingResponseofferingTransactionofferingStatusofferingTypeDef",
    {
        "id": str,
        "description": str,
        "type": str,
        "platform": str,
        "recurringCharges": List[
            ClientRenewOfferingResponseofferingTransactionofferingStatusofferingrecurringChargesTypeDef
        ],
    },
    total=False,
)


class ClientRenewOfferingResponseofferingTransactionofferingStatusofferingTypeDef(
    _ClientRenewOfferingResponseofferingTransactionofferingStatusofferingTypeDef
):
    """
    Type definition for `ClientRenewOfferingResponseofferingTransactionofferingStatus` `offering`

    Represents the metadata of an offering status.

    - **id** *(string) --*

      The ID that corresponds to a device offering.

    - **description** *(string) --*

      A string describing the offering.

    - **type** *(string) --*

      The type of offering (e.g., "RECURRING") for a device.

    - **platform** *(string) --*

      The platform of the device (e.g., ANDROID or IOS).

    - **recurringCharges** *(list) --*

      Specifies whether there are recurring charges for the offering.

      - *(dict) --*

        Specifies whether charges for devices will be recurring.

        - **cost** *(dict) --*

          The cost of the recurring charge.

          - **amount** *(float) --*

            The numerical amount of an offering or transaction.

          - **currencyCode** *(string) --*

            The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

        - **frequency** *(string) --*

          The frequency in which charges will recur.
    """


_ClientRenewOfferingResponseofferingTransactionofferingStatusTypeDef = TypedDict(
    "_ClientRenewOfferingResponseofferingTransactionofferingStatusTypeDef",
    {
        "type": str,
        "offering": ClientRenewOfferingResponseofferingTransactionofferingStatusofferingTypeDef,
        "quantity": int,
        "effectiveOn": datetime,
    },
    total=False,
)


class ClientRenewOfferingResponseofferingTransactionofferingStatusTypeDef(
    _ClientRenewOfferingResponseofferingTransactionofferingStatusTypeDef
):
    """
    Type definition for `ClientRenewOfferingResponseofferingTransaction` `offeringStatus`

    The status of an offering transaction.

    - **type** *(string) --*

      The type specified for the offering status.

    - **offering** *(dict) --*

      Represents the metadata of an offering status.

      - **id** *(string) --*

        The ID that corresponds to a device offering.

      - **description** *(string) --*

        A string describing the offering.

      - **type** *(string) --*

        The type of offering (e.g., "RECURRING") for a device.

      - **platform** *(string) --*

        The platform of the device (e.g., ANDROID or IOS).

      - **recurringCharges** *(list) --*

        Specifies whether there are recurring charges for the offering.

        - *(dict) --*

          Specifies whether charges for devices will be recurring.

          - **cost** *(dict) --*

            The cost of the recurring charge.

            - **amount** *(float) --*

              The numerical amount of an offering or transaction.

            - **currencyCode** *(string) --*

              The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

          - **frequency** *(string) --*

            The frequency in which charges will recur.

    - **quantity** *(integer) --*

      The number of available devices in the offering.

    - **effectiveOn** *(datetime) --*

      The date on which the offering is effective.
    """


_ClientRenewOfferingResponseofferingTransactionTypeDef = TypedDict(
    "_ClientRenewOfferingResponseofferingTransactionTypeDef",
    {
        "offeringStatus": ClientRenewOfferingResponseofferingTransactionofferingStatusTypeDef,
        "transactionId": str,
        "offeringPromotionId": str,
        "createdOn": datetime,
        "cost": ClientRenewOfferingResponseofferingTransactioncostTypeDef,
    },
    total=False,
)


class ClientRenewOfferingResponseofferingTransactionTypeDef(
    _ClientRenewOfferingResponseofferingTransactionTypeDef
):
    """
    Type definition for `ClientRenewOfferingResponse` `offeringTransaction`

    Represents the status of the offering transaction for the renewal.

    - **offeringStatus** *(dict) --*

      The status of an offering transaction.

      - **type** *(string) --*

        The type specified for the offering status.

      - **offering** *(dict) --*

        Represents the metadata of an offering status.

        - **id** *(string) --*

          The ID that corresponds to a device offering.

        - **description** *(string) --*

          A string describing the offering.

        - **type** *(string) --*

          The type of offering (e.g., "RECURRING") for a device.

        - **platform** *(string) --*

          The platform of the device (e.g., ANDROID or IOS).

        - **recurringCharges** *(list) --*

          Specifies whether there are recurring charges for the offering.

          - *(dict) --*

            Specifies whether charges for devices will be recurring.

            - **cost** *(dict) --*

              The cost of the recurring charge.

              - **amount** *(float) --*

                The numerical amount of an offering or transaction.

              - **currencyCode** *(string) --*

                The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

            - **frequency** *(string) --*

              The frequency in which charges will recur.

      - **quantity** *(integer) --*

        The number of available devices in the offering.

      - **effectiveOn** *(datetime) --*

        The date on which the offering is effective.

    - **transactionId** *(string) --*

      The transaction ID of the offering transaction.

    - **offeringPromotionId** *(string) --*

      The ID that corresponds to a device offering promotion.

    - **createdOn** *(datetime) --*

      The date on which an offering transaction was created.

    - **cost** *(dict) --*

      The cost of an offering transaction.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ClientRenewOfferingResponseTypeDef = TypedDict(
    "_ClientRenewOfferingResponseTypeDef",
    {"offeringTransaction": ClientRenewOfferingResponseofferingTransactionTypeDef},
    total=False,
)


class ClientRenewOfferingResponseTypeDef(_ClientRenewOfferingResponseTypeDef):
    """
    Type definition for `ClientRenewOffering` `Response`

    The result of a renewal offering.

    - **offeringTransaction** *(dict) --*

      Represents the status of the offering transaction for the renewal.

      - **offeringStatus** *(dict) --*

        The status of an offering transaction.

        - **type** *(string) --*

          The type specified for the offering status.

        - **offering** *(dict) --*

          Represents the metadata of an offering status.

          - **id** *(string) --*

            The ID that corresponds to a device offering.

          - **description** *(string) --*

            A string describing the offering.

          - **type** *(string) --*

            The type of offering (e.g., "RECURRING") for a device.

          - **platform** *(string) --*

            The platform of the device (e.g., ANDROID or IOS).

          - **recurringCharges** *(list) --*

            Specifies whether there are recurring charges for the offering.

            - *(dict) --*

              Specifies whether charges for devices will be recurring.

              - **cost** *(dict) --*

                The cost of the recurring charge.

                - **amount** *(float) --*

                  The numerical amount of an offering or transaction.

                - **currencyCode** *(string) --*

                  The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."

              - **frequency** *(string) --*

                The frequency in which charges will recur.

        - **quantity** *(integer) --*

          The number of available devices in the offering.

        - **effectiveOn** *(datetime) --*

          The date on which the offering is effective.

      - **transactionId** *(string) --*

        The transaction ID of the offering transaction.

      - **offeringPromotionId** *(string) --*

        The ID that corresponds to a device offering promotion.

      - **createdOn** *(datetime) --*

        The date on which an offering transaction was created.

      - **cost** *(dict) --*

        The cost of an offering transaction.

        - **amount** *(float) --*

          The numerical amount of an offering or transaction.

        - **currencyCode** *(string) --*

          The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ClientScheduleRunResponseruncountersTypeDef = TypedDict(
    "_ClientScheduleRunResponseruncountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ClientScheduleRunResponseruncountersTypeDef(
    _ClientScheduleRunResponseruncountersTypeDef
):
    """
    Type definition for `ClientScheduleRunResponserun` `counters`

    The run's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ClientScheduleRunResponseruncustomerArtifactPathsTypeDef = TypedDict(
    "_ClientScheduleRunResponseruncustomerArtifactPathsTypeDef",
    {"iosPaths": List[str], "androidPaths": List[str], "deviceHostPaths": List[str]},
    total=False,
)


class ClientScheduleRunResponseruncustomerArtifactPathsTypeDef(
    _ClientScheduleRunResponseruncustomerArtifactPathsTypeDef
):
    """
    Type definition for `ClientScheduleRunResponserun` `customerArtifactPaths`

    Output ``CustomerArtifactPaths`` object for the test run.

    - **iosPaths** *(list) --*

      Comma-separated list of paths on the iOS device where the artifacts generated by the
      customer's tests will be pulled from.

      - *(string) --*

    - **androidPaths** *(list) --*

      Comma-separated list of paths on the Android device where the artifacts generated by the
      customer's tests will be pulled from.

      - *(string) --*

    - **deviceHostPaths** *(list) --*

      Comma-separated list of paths in the test execution environment where the artifacts
      generated by the customer's tests will be pulled from.

      - *(string) --*
    """


_ClientScheduleRunResponserundeviceMinutesTypeDef = TypedDict(
    "_ClientScheduleRunResponserundeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientScheduleRunResponserundeviceMinutesTypeDef(
    _ClientScheduleRunResponserundeviceMinutesTypeDef
):
    """
    Type definition for `ClientScheduleRunResponserun` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the test run.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to run
      tests.
    """


_ClientScheduleRunResponserundeviceSelectionResultfiltersTypeDef = TypedDict(
    "_ClientScheduleRunResponserundeviceSelectionResultfiltersTypeDef",
    {"attribute": str, "operator": str, "values": List[str]},
    total=False,
)


class ClientScheduleRunResponserundeviceSelectionResultfiltersTypeDef(
    _ClientScheduleRunResponserundeviceSelectionResultfiltersTypeDef
):
    """
    Type definition for `ClientScheduleRunResponserundeviceSelectionResult` `filters`

    Represents a device filter used to select a set of devices to be included in a test
    run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
    to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

    It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
    JSON request syntax, see  ListDevices .

    - **attribute** *(string) --*

      The aspect of a device such as platform or model used as the selection criteria in a
      device filter.

      The supported operators for each attribute are provided in the following list.

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
       ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        MODEL

      The device model. For example, "iPad 5th Gen".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE",
      "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

       *Ignored.* Whether the device is enabled for remote debugging. Valid values are
       "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

    - **operator** *(string) --*

      Specifies how Device Farm compares the filter's attribute to the value. For the
      operators that are supported by each attribute, see the attribute descriptions.

    - **values** *(list) --*

      An array of one or more filter values used in a device filter.

       **Operator Values**

      * The IN and NOT_IN operators can take a values array that has more than one element.

      * The other operators require an array with a single element.

       **Attribute Values**

      * The PLATFORM attribute can be set to "ANDROID" or "IOS".

      * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
      or "TEMPORARY_NOT_AVAILABLE".

      * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

      * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

      - *(string) --*
    """


_ClientScheduleRunResponserundeviceSelectionResultTypeDef = TypedDict(
    "_ClientScheduleRunResponserundeviceSelectionResultTypeDef",
    {
        "filters": List[
            ClientScheduleRunResponserundeviceSelectionResultfiltersTypeDef
        ],
        "matchedDevicesCount": int,
        "maxDevices": int,
    },
    total=False,
)


class ClientScheduleRunResponserundeviceSelectionResultTypeDef(
    _ClientScheduleRunResponserundeviceSelectionResultTypeDef
):
    """
    Type definition for `ClientScheduleRunResponserun` `deviceSelectionResult`

    The results of a device filter used to select the devices for a test run.

    - **filters** *(list) --*

      The filters in a device selection result.

      - *(dict) --*

        Represents a device filter used to select a set of devices to be included in a test
        run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
        to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

        It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
        JSON request syntax, see  ListDevices .

        - **attribute** *(string) --*

          The aspect of a device such as platform or model used as the selection criteria in a
          device filter.

          The supported operators for each attribute are provided in the following list.

            ARN

          The Amazon Resource Name (ARN) of the device. For example,
          "arn:aws:devicefarm:us-west-2::device:12345Example".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            PLATFORM

          The device platform. Valid values are "ANDROID" or "IOS".

           *Supported operators* : ``EQUALS``

            OS_VERSION

          The operating system version. For example, "10.3.2".

           *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
           ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

            MODEL

          The device model. For example, "iPad 5th Gen".

           *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

            AVAILABILITY

          The current availability of the device. Valid values are "AVAILABLE",
          "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

           *Supported operators* : ``EQUALS``

            FORM_FACTOR

          The device form factor. Valid values are "PHONE" or "TABLET".

           *Supported operators* : ``EQUALS``

            MANUFACTURER

          The device manufacturer. For example, "Apple".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            REMOTE_ACCESS_ENABLED

          Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

            REMOTE_DEBUG_ENABLED

           *Ignored.* Whether the device is enabled for remote debugging. Valid values are
           "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

           *This filter will be ignored, as remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

            INSTANCE_ARN

          The Amazon Resource Name (ARN) of the device instance.

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            INSTANCE_LABELS

          The label of the device instance.

           *Supported operators* : ``CONTAINS``

            FLEET_TYPE

          The fleet type. Valid values are "PUBLIC" or "PRIVATE".

           *Supported operators* : ``EQUALS``

        - **operator** *(string) --*

          Specifies how Device Farm compares the filter's attribute to the value. For the
          operators that are supported by each attribute, see the attribute descriptions.

        - **values** *(list) --*

          An array of one or more filter values used in a device filter.

           **Operator Values**

          * The IN and NOT_IN operators can take a values array that has more than one element.

          * The other operators require an array with a single element.

           **Attribute Values**

          * The PLATFORM attribute can be set to "ANDROID" or "IOS".

          * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
          or "TEMPORARY_NOT_AVAILABLE".

          * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

          * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

          - *(string) --*

    - **matchedDevicesCount** *(integer) --*

      The number of devices that matched the device filter selection criteria.

    - **maxDevices** *(integer) --*

      The maximum number of devices to be selected by a device filter and included in a test
      run.
    """


_ClientScheduleRunResponserunlocationTypeDef = TypedDict(
    "_ClientScheduleRunResponserunlocationTypeDef",
    {"latitude": float, "longitude": float},
    total=False,
)


class ClientScheduleRunResponserunlocationTypeDef(
    _ClientScheduleRunResponserunlocationTypeDef
):
    """
    Type definition for `ClientScheduleRunResponserun` `location`

    Information about the location that is used for the run.

    - **latitude** *(float) --*

      The latitude.

    - **longitude** *(float) --*

      The longitude.
    """


_ClientScheduleRunResponserunnetworkProfileTypeDef = TypedDict(
    "_ClientScheduleRunResponserunnetworkProfileTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "uplinkBandwidthBits": int,
        "downlinkBandwidthBits": int,
        "uplinkDelayMs": int,
        "downlinkDelayMs": int,
        "uplinkJitterMs": int,
        "downlinkJitterMs": int,
        "uplinkLossPercent": int,
        "downlinkLossPercent": int,
    },
    total=False,
)


class ClientScheduleRunResponserunnetworkProfileTypeDef(
    _ClientScheduleRunResponserunnetworkProfileTypeDef
):
    """
    Type definition for `ClientScheduleRunResponserun` `networkProfile`

    The network profile being used for a test run.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the network profile.

    - **name** *(string) --*

      The name of the network profile.

    - **description** *(string) --*

      The description of the network profile.

    - **type** *(string) --*

      The type of network profile. Valid values are listed below.

    - **uplinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **downlinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **uplinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **downlinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **uplinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **downlinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **uplinkLossPercent** *(integer) --*

      Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

    - **downlinkLossPercent** *(integer) --*

      Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ClientScheduleRunResponserunradiosTypeDef = TypedDict(
    "_ClientScheduleRunResponserunradiosTypeDef",
    {"wifi": bool, "bluetooth": bool, "nfc": bool, "gps": bool},
    total=False,
)


class ClientScheduleRunResponserunradiosTypeDef(
    _ClientScheduleRunResponserunradiosTypeDef
):
    """
    Type definition for `ClientScheduleRunResponserun` `radios`

    Information about the radio states for the run.

    - **wifi** *(boolean) --*

      True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

    - **bluetooth** *(boolean) --*

      True if Bluetooth is enabled at the beginning of the test; otherwise, false.

    - **nfc** *(boolean) --*

      True if NFC is enabled at the beginning of the test; otherwise, false.

    - **gps** *(boolean) --*

      True if GPS is enabled at the beginning of the test; otherwise, false.
    """


_ClientScheduleRunResponserunTypeDef = TypedDict(
    "_ClientScheduleRunResponserunTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "platform": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ClientScheduleRunResponseruncountersTypeDef,
        "message": str,
        "totalJobs": int,
        "completedJobs": int,
        "billingMethod": str,
        "deviceMinutes": ClientScheduleRunResponserundeviceMinutesTypeDef,
        "networkProfile": ClientScheduleRunResponserunnetworkProfileTypeDef,
        "parsingResultUrl": str,
        "resultCode": str,
        "seed": int,
        "appUpload": str,
        "eventCount": int,
        "jobTimeoutMinutes": int,
        "devicePoolArn": str,
        "locale": str,
        "radios": ClientScheduleRunResponserunradiosTypeDef,
        "location": ClientScheduleRunResponserunlocationTypeDef,
        "customerArtifactPaths": ClientScheduleRunResponseruncustomerArtifactPathsTypeDef,
        "webUrl": str,
        "skipAppResign": bool,
        "testSpecArn": str,
        "deviceSelectionResult": ClientScheduleRunResponserundeviceSelectionResultTypeDef,
    },
    total=False,
)


class ClientScheduleRunResponserunTypeDef(_ClientScheduleRunResponserunTypeDef):
    """
    Type definition for `ClientScheduleRunResponse` `run`

    Information about the scheduled run.

    - **arn** *(string) --*

      The run's ARN.

    - **name** *(string) --*

      The run's name.

    - **type** *(string) --*

      The run's type.

      Must be one of the following values:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **platform** *(string) --*

      The run's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **created** *(datetime) --*

      When the run was created.

    - **status** *(string) --*

      The run's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The run's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The run's start time.

    - **stopped** *(datetime) --*

      The run's stop time.

    - **counters** *(dict) --*

      The run's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the run's result.

    - **totalJobs** *(integer) --*

      The total number of jobs for the run.

    - **completedJobs** *(integer) --*

      The total number of completed jobs.

    - **billingMethod** *(string) --*

      Specifies the billing method for a test run: ``metered`` or ``unmetered`` . If the
      parameter is not specified, the default value is ``metered`` .

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the test run.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to run
        tests.

    - **networkProfile** *(dict) --*

      The network profile being used for a test run.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the network profile.

      - **name** *(string) --*

        The name of the network profile.

      - **description** *(string) --*

        The description of the network profile.

      - **type** *(string) --*

        The type of network profile. Valid values are listed below.

      - **uplinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **downlinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **uplinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **downlinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **uplinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **downlinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **uplinkLossPercent** *(integer) --*

        Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

      - **downlinkLossPercent** *(integer) --*

        Proportion of received packets that fail to arrive from 0 to 100 percent.

    - **parsingResultUrl** *(string) --*

      Read-only URL for an object in S3 bucket where you can get the parsing results of the test
      package. If the test package doesn't parse, the reason why it doesn't parse appears in the
      file that this URL points to.

    - **resultCode** *(string) --*

      Supporting field for the result field. Set only if ``result`` is ``SKIPPED`` .
      ``PARSING_FAILED`` if the result is skipped because of test package parsing failure.

    - **seed** *(integer) --*

      For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same seed
      value between tests ensures identical event sequences.

    - **appUpload** *(string) --*

      An app to upload or that has been uploaded.

    - **eventCount** *(integer) --*

      For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz test
      should perform.

    - **jobTimeoutMinutes** *(integer) --*

      The number of minutes the job will execute before it times out.

    - **devicePoolArn** *(string) --*

      The ARN of the device pool for the run.

    - **locale** *(string) --*

      Information about the locale that is used for the run.

    - **radios** *(dict) --*

      Information about the radio states for the run.

      - **wifi** *(boolean) --*

        True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

      - **bluetooth** *(boolean) --*

        True if Bluetooth is enabled at the beginning of the test; otherwise, false.

      - **nfc** *(boolean) --*

        True if NFC is enabled at the beginning of the test; otherwise, false.

      - **gps** *(boolean) --*

        True if GPS is enabled at the beginning of the test; otherwise, false.

    - **location** *(dict) --*

      Information about the location that is used for the run.

      - **latitude** *(float) --*

        The latitude.

      - **longitude** *(float) --*

        The longitude.

    - **customerArtifactPaths** *(dict) --*

      Output ``CustomerArtifactPaths`` object for the test run.

      - **iosPaths** *(list) --*

        Comma-separated list of paths on the iOS device where the artifacts generated by the
        customer's tests will be pulled from.

        - *(string) --*

      - **androidPaths** *(list) --*

        Comma-separated list of paths on the Android device where the artifacts generated by the
        customer's tests will be pulled from.

        - *(string) --*

      - **deviceHostPaths** *(list) --*

        Comma-separated list of paths in the test execution environment where the artifacts
        generated by the customer's tests will be pulled from.

        - *(string) --*

    - **webUrl** *(string) --*

      The Device Farm console URL for the recording of the run.

    - **skipAppResign** *(boolean) --*

      When set to ``true`` , for private devices, Device Farm will not sign your app again. For
      public devices, Device Farm always signs your apps again and this parameter has no effect.

      For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
      <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .

    - **testSpecArn** *(string) --*

      The ARN of the YAML-formatted test specification for the run.

    - **deviceSelectionResult** *(dict) --*

      The results of a device filter used to select the devices for a test run.

      - **filters** *(list) --*

        The filters in a device selection result.

        - *(dict) --*

          Represents a device filter used to select a set of devices to be included in a test
          run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
          to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

          It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
          JSON request syntax, see  ListDevices .

          - **attribute** *(string) --*

            The aspect of a device such as platform or model used as the selection criteria in a
            device filter.

            The supported operators for each attribute are provided in the following list.

              ARN

            The Amazon Resource Name (ARN) of the device. For example,
            "arn:aws:devicefarm:us-west-2::device:12345Example".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              PLATFORM

            The device platform. Valid values are "ANDROID" or "IOS".

             *Supported operators* : ``EQUALS``

              OS_VERSION

            The operating system version. For example, "10.3.2".

             *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
             ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

              MODEL

            The device model. For example, "iPad 5th Gen".

             *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

              AVAILABILITY

            The current availability of the device. Valid values are "AVAILABLE",
            "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

             *Supported operators* : ``EQUALS``

              FORM_FACTOR

            The device form factor. Valid values are "PHONE" or "TABLET".

             *Supported operators* : ``EQUALS``

              MANUFACTURER

            The device manufacturer. For example, "Apple".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              REMOTE_ACCESS_ENABLED

            Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

              REMOTE_DEBUG_ENABLED

             *Ignored.* Whether the device is enabled for remote debugging. Valid values are
             "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

             *This filter will be ignored, as remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

              INSTANCE_ARN

            The Amazon Resource Name (ARN) of the device instance.

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              INSTANCE_LABELS

            The label of the device instance.

             *Supported operators* : ``CONTAINS``

              FLEET_TYPE

            The fleet type. Valid values are "PUBLIC" or "PRIVATE".

             *Supported operators* : ``EQUALS``

          - **operator** *(string) --*

            Specifies how Device Farm compares the filter's attribute to the value. For the
            operators that are supported by each attribute, see the attribute descriptions.

          - **values** *(list) --*

            An array of one or more filter values used in a device filter.

             **Operator Values**

            * The IN and NOT_IN operators can take a values array that has more than one element.

            * The other operators require an array with a single element.

             **Attribute Values**

            * The PLATFORM attribute can be set to "ANDROID" or "IOS".

            * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
            or "TEMPORARY_NOT_AVAILABLE".

            * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

            * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

            - *(string) --*

      - **matchedDevicesCount** *(integer) --*

        The number of devices that matched the device filter selection criteria.

      - **maxDevices** *(integer) --*

        The maximum number of devices to be selected by a device filter and included in a test
        run.
    """


_ClientScheduleRunResponseTypeDef = TypedDict(
    "_ClientScheduleRunResponseTypeDef",
    {"run": ClientScheduleRunResponserunTypeDef},
    total=False,
)


class ClientScheduleRunResponseTypeDef(_ClientScheduleRunResponseTypeDef):
    """
    Type definition for `ClientScheduleRun` `Response`

    Represents the result of a schedule run request.

    - **run** *(dict) --*

      Information about the scheduled run.

      - **arn** *(string) --*

        The run's ARN.

      - **name** *(string) --*

        The run's name.

      - **type** *(string) --*

        The run's type.

        Must be one of the following values:

        * BUILTIN_FUZZ: The built-in fuzz type.

        * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
        interacting with it and capturing screenshots at the same time.

        * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

        * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

        * APPIUM_PYTHON: The Appium Python type.

        * APPIUM_NODE: The Appium Node.js type.

        * APPIUM_RUBY: The Appium Ruby type.

        * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

        * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

        * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

        * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

        * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

        * CALABASH: The Calabash type.

        * INSTRUMENTATION: The Instrumentation type.

        * UIAUTOMATION: The uiautomation type.

        * UIAUTOMATOR: The uiautomator type.

        * XCTEST: The Xcode test type.

        * XCTEST_UI: The Xcode UI test type.

      - **platform** *(string) --*

        The run's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **created** *(datetime) --*

        When the run was created.

      - **status** *(string) --*

        The run's status.

        Allowed values include:

        * PENDING: A pending status.

        * PENDING_CONCURRENCY: A pending concurrency status.

        * PENDING_DEVICE: A pending device status.

        * PROCESSING: A processing status.

        * SCHEDULING: A scheduling status.

        * PREPARING: A preparing status.

        * RUNNING: A running status.

        * COMPLETED: A completed status.

        * STOPPING: A stopping status.

      - **result** *(string) --*

        The run's result.

        Allowed values include:

        * PENDING: A pending condition.

        * PASSED: A passing condition.

        * WARNED: A warning condition.

        * FAILED: A failed condition.

        * SKIPPED: A skipped condition.

        * ERRORED: An error condition.

        * STOPPED: A stopped condition.

      - **started** *(datetime) --*

        The run's start time.

      - **stopped** *(datetime) --*

        The run's stop time.

      - **counters** *(dict) --*

        The run's result counters.

        - **total** *(integer) --*

          The total number of entities.

        - **passed** *(integer) --*

          The number of passed entities.

        - **failed** *(integer) --*

          The number of failed entities.

        - **warned** *(integer) --*

          The number of warned entities.

        - **errored** *(integer) --*

          The number of errored entities.

        - **stopped** *(integer) --*

          The number of stopped entities.

        - **skipped** *(integer) --*

          The number of skipped entities.

      - **message** *(string) --*

        A message about the run's result.

      - **totalJobs** *(integer) --*

        The total number of jobs for the run.

      - **completedJobs** *(integer) --*

        The total number of completed jobs.

      - **billingMethod** *(string) --*

        Specifies the billing method for a test run: ``metered`` or ``unmetered`` . If the
        parameter is not specified, the default value is ``metered`` .

      - **deviceMinutes** *(dict) --*

        Represents the total (metered or unmetered) minutes used by the test run.

        - **total** *(float) --*

          When specified, represents the total minutes used by the resource to run tests.

        - **metered** *(float) --*

          When specified, represents only the sum of metered minutes used by the resource to run
          tests.

        - **unmetered** *(float) --*

          When specified, represents only the sum of unmetered minutes used by the resource to run
          tests.

      - **networkProfile** *(dict) --*

        The network profile being used for a test run.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the network profile.

        - **name** *(string) --*

          The name of the network profile.

        - **description** *(string) --*

          The description of the network profile.

        - **type** *(string) --*

          The type of network profile. Valid values are listed below.

        - **uplinkBandwidthBits** *(integer) --*

          The data throughput rate in bits per second, as an integer from 0 to 104857600.

        - **downlinkBandwidthBits** *(integer) --*

          The data throughput rate in bits per second, as an integer from 0 to 104857600.

        - **uplinkDelayMs** *(integer) --*

          Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

        - **downlinkDelayMs** *(integer) --*

          Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

        - **uplinkJitterMs** *(integer) --*

          Time variation in the delay of received packets in milliseconds as an integer from 0 to
          2000.

        - **downlinkJitterMs** *(integer) --*

          Time variation in the delay of received packets in milliseconds as an integer from 0 to
          2000.

        - **uplinkLossPercent** *(integer) --*

          Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

        - **downlinkLossPercent** *(integer) --*

          Proportion of received packets that fail to arrive from 0 to 100 percent.

      - **parsingResultUrl** *(string) --*

        Read-only URL for an object in S3 bucket where you can get the parsing results of the test
        package. If the test package doesn't parse, the reason why it doesn't parse appears in the
        file that this URL points to.

      - **resultCode** *(string) --*

        Supporting field for the result field. Set only if ``result`` is ``SKIPPED`` .
        ``PARSING_FAILED`` if the result is skipped because of test package parsing failure.

      - **seed** *(integer) --*

        For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same seed
        value between tests ensures identical event sequences.

      - **appUpload** *(string) --*

        An app to upload or that has been uploaded.

      - **eventCount** *(integer) --*

        For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz test
        should perform.

      - **jobTimeoutMinutes** *(integer) --*

        The number of minutes the job will execute before it times out.

      - **devicePoolArn** *(string) --*

        The ARN of the device pool for the run.

      - **locale** *(string) --*

        Information about the locale that is used for the run.

      - **radios** *(dict) --*

        Information about the radio states for the run.

        - **wifi** *(boolean) --*

          True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

        - **bluetooth** *(boolean) --*

          True if Bluetooth is enabled at the beginning of the test; otherwise, false.

        - **nfc** *(boolean) --*

          True if NFC is enabled at the beginning of the test; otherwise, false.

        - **gps** *(boolean) --*

          True if GPS is enabled at the beginning of the test; otherwise, false.

      - **location** *(dict) --*

        Information about the location that is used for the run.

        - **latitude** *(float) --*

          The latitude.

        - **longitude** *(float) --*

          The longitude.

      - **customerArtifactPaths** *(dict) --*

        Output ``CustomerArtifactPaths`` object for the test run.

        - **iosPaths** *(list) --*

          Comma-separated list of paths on the iOS device where the artifacts generated by the
          customer's tests will be pulled from.

          - *(string) --*

        - **androidPaths** *(list) --*

          Comma-separated list of paths on the Android device where the artifacts generated by the
          customer's tests will be pulled from.

          - *(string) --*

        - **deviceHostPaths** *(list) --*

          Comma-separated list of paths in the test execution environment where the artifacts
          generated by the customer's tests will be pulled from.

          - *(string) --*

      - **webUrl** *(string) --*

        The Device Farm console URL for the recording of the run.

      - **skipAppResign** *(boolean) --*

        When set to ``true`` , for private devices, Device Farm will not sign your app again. For
        public devices, Device Farm always signs your apps again and this parameter has no effect.

        For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
        <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .

      - **testSpecArn** *(string) --*

        The ARN of the YAML-formatted test specification for the run.

      - **deviceSelectionResult** *(dict) --*

        The results of a device filter used to select the devices for a test run.

        - **filters** *(list) --*

          The filters in a device selection result.

          - *(dict) --*

            Represents a device filter used to select a set of devices to be included in a test
            run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
            to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

            It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
            JSON request syntax, see  ListDevices .

            - **attribute** *(string) --*

              The aspect of a device such as platform or model used as the selection criteria in a
              device filter.

              The supported operators for each attribute are provided in the following list.

                ARN

              The Amazon Resource Name (ARN) of the device. For example,
              "arn:aws:devicefarm:us-west-2::device:12345Example".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                PLATFORM

              The device platform. Valid values are "ANDROID" or "IOS".

               *Supported operators* : ``EQUALS``

                OS_VERSION

              The operating system version. For example, "10.3.2".

               *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
               ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

                MODEL

              The device model. For example, "iPad 5th Gen".

               *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

                AVAILABILITY

              The current availability of the device. Valid values are "AVAILABLE",
              "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

               *Supported operators* : ``EQUALS``

                FORM_FACTOR

              The device form factor. Valid values are "PHONE" or "TABLET".

               *Supported operators* : ``EQUALS``

                MANUFACTURER

              The device manufacturer. For example, "Apple".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                REMOTE_ACCESS_ENABLED

              Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

               *Supported operators* : ``EQUALS``

                REMOTE_DEBUG_ENABLED

               *Ignored.* Whether the device is enabled for remote debugging. Valid values are
               "TRUE" or "FALSE".

               *Supported operators* : ``EQUALS``

               *This filter will be ignored, as remote debugging is `no longer supported
               <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

                INSTANCE_ARN

              The Amazon Resource Name (ARN) of the device instance.

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                INSTANCE_LABELS

              The label of the device instance.

               *Supported operators* : ``CONTAINS``

                FLEET_TYPE

              The fleet type. Valid values are "PUBLIC" or "PRIVATE".

               *Supported operators* : ``EQUALS``

            - **operator** *(string) --*

              Specifies how Device Farm compares the filter's attribute to the value. For the
              operators that are supported by each attribute, see the attribute descriptions.

            - **values** *(list) --*

              An array of one or more filter values used in a device filter.

               **Operator Values**

              * The IN and NOT_IN operators can take a values array that has more than one element.

              * The other operators require an array with a single element.

               **Attribute Values**

              * The PLATFORM attribute can be set to "ANDROID" or "IOS".

              * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
              or "TEMPORARY_NOT_AVAILABLE".

              * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

              * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

              - *(string) --*

        - **matchedDevicesCount** *(integer) --*

          The number of devices that matched the device filter selection criteria.

        - **maxDevices** *(integer) --*

          The maximum number of devices to be selected by a device filter and included in a test
          run.
    """


_ClientScheduleRunconfigurationcustomerArtifactPathsTypeDef = TypedDict(
    "_ClientScheduleRunconfigurationcustomerArtifactPathsTypeDef",
    {"iosPaths": List[str], "androidPaths": List[str], "deviceHostPaths": List[str]},
    total=False,
)


class ClientScheduleRunconfigurationcustomerArtifactPathsTypeDef(
    _ClientScheduleRunconfigurationcustomerArtifactPathsTypeDef
):
    """
    Type definition for `ClientScheduleRunconfiguration` `customerArtifactPaths`

    Input ``CustomerArtifactPaths`` object for the scheduled run configuration.

    - **iosPaths** *(list) --*

      Comma-separated list of paths on the iOS device where the artifacts generated by the
      customer's tests will be pulled from.

      - *(string) --*

    - **androidPaths** *(list) --*

      Comma-separated list of paths on the Android device where the artifacts generated by the
      customer's tests will be pulled from.

      - *(string) --*

    - **deviceHostPaths** *(list) --*

      Comma-separated list of paths in the test execution environment where the artifacts generated
      by the customer's tests will be pulled from.

      - *(string) --*
    """


_ClientScheduleRunconfigurationlocationTypeDef = TypedDict(
    "_ClientScheduleRunconfigurationlocationTypeDef",
    {"latitude": float, "longitude": float},
)


class ClientScheduleRunconfigurationlocationTypeDef(
    _ClientScheduleRunconfigurationlocationTypeDef
):
    """
    Type definition for `ClientScheduleRunconfiguration` `location`

    Information about the location that is used for the run.

    - **latitude** *(float) --* **[REQUIRED]**

      The latitude.

    - **longitude** *(float) --* **[REQUIRED]**

      The longitude.
    """


_ClientScheduleRunconfigurationradiosTypeDef = TypedDict(
    "_ClientScheduleRunconfigurationradiosTypeDef",
    {"wifi": bool, "bluetooth": bool, "nfc": bool, "gps": bool},
    total=False,
)


class ClientScheduleRunconfigurationradiosTypeDef(
    _ClientScheduleRunconfigurationradiosTypeDef
):
    """
    Type definition for `ClientScheduleRunconfiguration` `radios`

    Information about the radio states for the run.

    - **wifi** *(boolean) --*

      True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

    - **bluetooth** *(boolean) --*

      True if Bluetooth is enabled at the beginning of the test; otherwise, false.

    - **nfc** *(boolean) --*

      True if NFC is enabled at the beginning of the test; otherwise, false.

    - **gps** *(boolean) --*

      True if GPS is enabled at the beginning of the test; otherwise, false.
    """


_ClientScheduleRunconfigurationTypeDef = TypedDict(
    "_ClientScheduleRunconfigurationTypeDef",
    {
        "extraDataPackageArn": str,
        "networkProfileArn": str,
        "locale": str,
        "location": ClientScheduleRunconfigurationlocationTypeDef,
        "vpceConfigurationArns": List[str],
        "customerArtifactPaths": ClientScheduleRunconfigurationcustomerArtifactPathsTypeDef,
        "radios": ClientScheduleRunconfigurationradiosTypeDef,
        "auxiliaryApps": List[str],
        "billingMethod": str,
    },
    total=False,
)


class ClientScheduleRunconfigurationTypeDef(_ClientScheduleRunconfigurationTypeDef):
    """
    Type definition for `ClientScheduleRun` `configuration`

    Information about the settings for the run to be scheduled.

    - **extraDataPackageArn** *(string) --*

      The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm will
      extract to external data for Android or the app's sandbox for iOS.

    - **networkProfileArn** *(string) --*

      Reserved for internal use.

    - **locale** *(string) --*

      Information about the locale that is used for the run.

    - **location** *(dict) --*

      Information about the location that is used for the run.

      - **latitude** *(float) --* **[REQUIRED]**

        The latitude.

      - **longitude** *(float) --* **[REQUIRED]**

        The longitude.

    - **vpceConfigurationArns** *(list) --*

      An array of Amazon Resource Names (ARNs) for your VPC endpoint configurations.

      - *(string) --*

    - **customerArtifactPaths** *(dict) --*

      Input ``CustomerArtifactPaths`` object for the scheduled run configuration.

      - **iosPaths** *(list) --*

        Comma-separated list of paths on the iOS device where the artifacts generated by the
        customer's tests will be pulled from.

        - *(string) --*

      - **androidPaths** *(list) --*

        Comma-separated list of paths on the Android device where the artifacts generated by the
        customer's tests will be pulled from.

        - *(string) --*

      - **deviceHostPaths** *(list) --*

        Comma-separated list of paths in the test execution environment where the artifacts generated
        by the customer's tests will be pulled from.

        - *(string) --*

    - **radios** *(dict) --*

      Information about the radio states for the run.

      - **wifi** *(boolean) --*

        True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

      - **bluetooth** *(boolean) --*

        True if Bluetooth is enabled at the beginning of the test; otherwise, false.

      - **nfc** *(boolean) --*

        True if NFC is enabled at the beginning of the test; otherwise, false.

      - **gps** *(boolean) --*

        True if GPS is enabled at the beginning of the test; otherwise, false.

    - **auxiliaryApps** *(list) --*

      A list of Upload ARNs for app packages that will be installed alongside your app.

      - *(string) --*

    - **billingMethod** *(string) --*

      Specifies the billing method for a test run: ``metered`` or ``unmetered`` . If the parameter is
      not specified, the default value is ``metered`` .
    """


_ClientScheduleRundeviceSelectionConfigurationfiltersTypeDef = TypedDict(
    "_ClientScheduleRundeviceSelectionConfigurationfiltersTypeDef",
    {"attribute": str, "operator": str, "values": List[str]},
    total=False,
)


class ClientScheduleRundeviceSelectionConfigurationfiltersTypeDef(
    _ClientScheduleRundeviceSelectionConfigurationfiltersTypeDef
):
    """
    Type definition for `ClientScheduleRundeviceSelectionConfiguration` `filters`

    Represents a device filter used to select a set of devices to be included in a test run. This
    data structure is passed in as the ``deviceSelectionConfiguration`` parameter to ScheduleRun.
    For an example of the JSON request syntax, see  ScheduleRun .

    It is also passed in as the ``filters`` parameter to ListDevices. For an example of the JSON
    request syntax, see  ListDevices .

    - **attribute** *(string) --*

      The aspect of a device such as platform or model used as the selection criteria in a device
      filter.

      The supported operators for each attribute are provided in the following list.

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
       ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        MODEL

      The device model. For example, "iPad 5th Gen".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE", "HIGHLY_AVAILABLE",
      "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

       *Ignored.* Whether the device is enabled for remote debugging. Valid values are "TRUE" or
       "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

    - **operator** *(string) --*

      Specifies how Device Farm compares the filter's attribute to the value. For the operators
      that are supported by each attribute, see the attribute descriptions.

    - **values** *(list) --*

      An array of one or more filter values used in a device filter.

       **Operator Values**

      * The IN and NOT_IN operators can take a values array that has more than one element.

      * The other operators require an array with a single element.

       **Attribute Values**

      * The PLATFORM attribute can be set to "ANDROID" or "IOS".

      * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY", or
      "TEMPORARY_NOT_AVAILABLE".

      * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

      * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

      - *(string) --*
    """


_ClientScheduleRundeviceSelectionConfigurationTypeDef = TypedDict(
    "_ClientScheduleRundeviceSelectionConfigurationTypeDef",
    {
        "filters": List[ClientScheduleRundeviceSelectionConfigurationfiltersTypeDef],
        "maxDevices": int,
    },
)


class ClientScheduleRundeviceSelectionConfigurationTypeDef(
    _ClientScheduleRundeviceSelectionConfigurationTypeDef
):
    """
    Type definition for `ClientScheduleRun` `deviceSelectionConfiguration`

    The filter criteria used to dynamically select a set of devices for a test run, as well as the
    maximum number of devices to be included in the run.

    Either ** ``devicePoolArn`` ** or ** ``deviceSelectionConfiguration`` ** is required in a request.

    - **filters** *(list) --* **[REQUIRED]**

      Used to dynamically select a set of devices for a test run. A filter is made up of an
      attribute, an operator, and one or more values.

      * **Attribute**   The aspect of a device such as platform or model used as the selection
      criteria in a device filter. Allowed values include:

        * ARN: The Amazon Resource Name (ARN) of the device. For example,
        "arn:aws:devicefarm:us-west-2::device:12345Example".

        * PLATFORM: The device platform. Valid values are "ANDROID" or "IOS".

        * OS_VERSION: The operating system version. For example, "10.3.2".

        * MODEL: The device model. For example, "iPad 5th Gen".

        * AVAILABILITY: The current availability of the device. Valid values are "AVAILABLE",
        "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

        * FORM_FACTOR: The device form factor. Valid values are "PHONE" or "TABLET".

        * MANUFACTURER: The device manufacturer. For example, "Apple".

        * REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are
        "TRUE" or "FALSE".

        * REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are
        "TRUE" or "FALSE". *This filter will be ignored, as remote debugging is `no longer supported
        <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        * INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.

        * INSTANCE_LABELS: The label of the device instance.

        * FLEET_TYPE: The fleet type. Valid values are "PUBLIC" or "PRIVATE".

      * **Operator**   The filter operator.

        * The EQUALS operator is available for every attribute except INSTANCE_LABELS.

        * The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.

        * The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and
        INSTANCE_ARN attributes.

        * The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are
        also available for the OS_VERSION attribute.

      * **Values**   An array of one or more filter values.  **Operator Values**

        * The IN and NOT_IN operators can take a values array that has more than one element.

        * The other operators require an array with a single element.

       **Attribute Values**

        * The PLATFORM attribute can be set to "ANDROID" or "IOS".

        * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY", or
        "TEMPORARY_NOT_AVAILABLE".

        * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

        * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

      - *(dict) --*

        Represents a device filter used to select a set of devices to be included in a test run. This
        data structure is passed in as the ``deviceSelectionConfiguration`` parameter to ScheduleRun.
        For an example of the JSON request syntax, see  ScheduleRun .

        It is also passed in as the ``filters`` parameter to ListDevices. For an example of the JSON
        request syntax, see  ListDevices .

        - **attribute** *(string) --*

          The aspect of a device such as platform or model used as the selection criteria in a device
          filter.

          The supported operators for each attribute are provided in the following list.

            ARN

          The Amazon Resource Name (ARN) of the device. For example,
          "arn:aws:devicefarm:us-west-2::device:12345Example".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            PLATFORM

          The device platform. Valid values are "ANDROID" or "IOS".

           *Supported operators* : ``EQUALS``

            OS_VERSION

          The operating system version. For example, "10.3.2".

           *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
           ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

            MODEL

          The device model. For example, "iPad 5th Gen".

           *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

            AVAILABILITY

          The current availability of the device. Valid values are "AVAILABLE", "HIGHLY_AVAILABLE",
          "BUSY", or "TEMPORARY_NOT_AVAILABLE".

           *Supported operators* : ``EQUALS``

            FORM_FACTOR

          The device form factor. Valid values are "PHONE" or "TABLET".

           *Supported operators* : ``EQUALS``

            MANUFACTURER

          The device manufacturer. For example, "Apple".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            REMOTE_ACCESS_ENABLED

          Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

            REMOTE_DEBUG_ENABLED

           *Ignored.* Whether the device is enabled for remote debugging. Valid values are "TRUE" or
           "FALSE".

           *Supported operators* : ``EQUALS``

           *This filter will be ignored, as remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

            INSTANCE_ARN

          The Amazon Resource Name (ARN) of the device instance.

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            INSTANCE_LABELS

          The label of the device instance.

           *Supported operators* : ``CONTAINS``

            FLEET_TYPE

          The fleet type. Valid values are "PUBLIC" or "PRIVATE".

           *Supported operators* : ``EQUALS``

        - **operator** *(string) --*

          Specifies how Device Farm compares the filter's attribute to the value. For the operators
          that are supported by each attribute, see the attribute descriptions.

        - **values** *(list) --*

          An array of one or more filter values used in a device filter.

           **Operator Values**

          * The IN and NOT_IN operators can take a values array that has more than one element.

          * The other operators require an array with a single element.

           **Attribute Values**

          * The PLATFORM attribute can be set to "ANDROID" or "IOS".

          * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY", or
          "TEMPORARY_NOT_AVAILABLE".

          * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

          * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

          - *(string) --*

    - **maxDevices** *(integer) --* **[REQUIRED]**

      The maximum number of devices to be included in a test run.
    """


_ClientScheduleRunexecutionConfigurationTypeDef = TypedDict(
    "_ClientScheduleRunexecutionConfigurationTypeDef",
    {
        "jobTimeoutMinutes": int,
        "accountsCleanup": bool,
        "appPackagesCleanup": bool,
        "videoCapture": bool,
        "skipAppResign": bool,
    },
    total=False,
)


class ClientScheduleRunexecutionConfigurationTypeDef(
    _ClientScheduleRunexecutionConfigurationTypeDef
):
    """
    Type definition for `ClientScheduleRun` `executionConfiguration`

    Specifies configuration information about a test run, such as the execution timeout (in minutes).

    - **jobTimeoutMinutes** *(integer) --*

      The number of minutes a test run will execute before it times out.

    - **accountsCleanup** *(boolean) --*

      True if account cleanup is enabled at the beginning of the test; otherwise, false.

    - **appPackagesCleanup** *(boolean) --*

      True if app package cleanup is enabled at the beginning of the test; otherwise, false.

    - **videoCapture** *(boolean) --*

      Set to true to enable video capture; otherwise, set to false. The default is true.

    - **skipAppResign** *(boolean) --*

      When set to ``true`` , for private devices, Device Farm will not sign your app again. For
      public devices, Device Farm always signs your apps again and this parameter has no effect.

      For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
      <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .
    """


_RequiredClientScheduleRuntestTypeDef = TypedDict(
    "_RequiredClientScheduleRuntestTypeDef", {"type": str}
)
_OptionalClientScheduleRuntestTypeDef = TypedDict(
    "_OptionalClientScheduleRuntestTypeDef",
    {
        "testPackageArn": str,
        "testSpecArn": str,
        "filter": str,
        "parameters": Dict[str, str],
    },
    total=False,
)


class ClientScheduleRuntestTypeDef(
    _RequiredClientScheduleRuntestTypeDef, _OptionalClientScheduleRuntestTypeDef
):
    """
    Type definition for `ClientScheduleRun` `test`

    Information about the test for the run to be scheduled.

    - **type** *(string) --* **[REQUIRED]**

      The test's type.

      Must be one of the following values:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app, interacting
      with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **testPackageArn** *(string) --*

      The ARN of the uploaded test that will be run.

    - **testSpecArn** *(string) --*

      The ARN of the YAML-formatted test specification.

    - **filter** *(string) --*

      The test's filter.

    - **parameters** *(dict) --*

      The test's parameters, such as test framework parameters and fixture settings. Parameters are
      represented by name-value pairs of strings.

      For all tests:

      * app_performance_monitoring: Performance monitoring is enabled by default. Set this parameter
      to "false" to disable it.

      For Calabash tests:

      * profile: A cucumber profile, for example, "my_profile_name".

      * tags: You can limit execution to features or scenarios that have (or don't have) certain
      tags, for example, "@smoke" or "@smoke,~@wip".

      For Appium tests (all types):

      * appium_version: The Appium version. Currently supported values are "1.6.5" (and higher),
      "latest", and "default".

        * “latest” will run the latest Appium version supported by Device Farm (1.9.1).

        * For “default”, Device Farm will choose a compatible version of Appium for the device. The
        current behavior is to run 1.7.2 on Android devices and iOS 9 and earlier, 1.7.2 for iOS 10
        and later.

        * This behavior is subject to change.

      For Fuzz tests (Android only):

      * event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.

      * throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between
      events.

      * seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests
      ensures identical event sequences.

      For Explorer tests:

      * username: A username to use if the Explorer encounters a login form. If not supplied, no
      username will be inserted.

      * password: A password to use if the Explorer encounters a login form. If not supplied, no
      password will be inserted.

      For Instrumentation:

      * filter: A test filter string. Examples:

        * Running a single test case: "com.android.abc.Test1"

        * Running a single test: "com.android.abc.Test1#smoke"

        * Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"

      For XCTest and XCTestUI:

      * filter: A test filter string. Examples:

        * Running a single test class: "LoginTests"

        * Running a multiple test classes: "LoginTests,SmokeTests"

        * Running a single test: "LoginTests/testValid"

        * Running multiple tests: "LoginTests/testValid,LoginTests/testInvalid"

      For UIAutomator:

      * filter: A test filter string. Examples:

        * Running a single test case: "com.android.abc.Test1"

        * Running a single test: "com.android.abc.Test1#smoke"

        * Running multiple tests: "com.android.abc.Test1,com.android.abc.Test2"

      - *(string) --*

        - *(string) --*
    """


_ClientStopJobResponsejobcountersTypeDef = TypedDict(
    "_ClientStopJobResponsejobcountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ClientStopJobResponsejobcountersTypeDef(_ClientStopJobResponsejobcountersTypeDef):
    """
    Type definition for `ClientStopJobResponsejob` `counters`

    The job's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ClientStopJobResponsejobdeviceMinutesTypeDef = TypedDict(
    "_ClientStopJobResponsejobdeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientStopJobResponsejobdeviceMinutesTypeDef(
    _ClientStopJobResponsejobdeviceMinutesTypeDef
):
    """
    Type definition for `ClientStopJobResponsejob` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the job.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to run
      tests.
    """


_ClientStopJobResponsejobdevicecpuTypeDef = TypedDict(
    "_ClientStopJobResponsejobdevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientStopJobResponsejobdevicecpuTypeDef(
    _ClientStopJobResponsejobdevicecpuTypeDef
):
    """
    Type definition for `ClientStopJobResponsejobdevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ClientStopJobResponsejobdeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientStopJobResponsejobdeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientStopJobResponsejobdeviceinstancesinstanceProfileTypeDef(
    _ClientStopJobResponsejobdeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientStopJobResponsejobdeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned
      up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientStopJobResponsejobdeviceinstancesTypeDef = TypedDict(
    "_ClientStopJobResponsejobdeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientStopJobResponsejobdeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientStopJobResponsejobdeviceinstancesTypeDef(
    _ClientStopJobResponsejobdeviceinstancesTypeDef
):
    """
    Type definition for `ClientStopJobResponsejobdevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned
        up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientStopJobResponsejobdeviceresolutionTypeDef = TypedDict(
    "_ClientStopJobResponsejobdeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientStopJobResponsejobdeviceresolutionTypeDef(
    _ClientStopJobResponsejobdeviceresolutionTypeDef
):
    """
    Type definition for `ClientStopJobResponsejobdevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientStopJobResponsejobdeviceTypeDef = TypedDict(
    "_ClientStopJobResponsejobdeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientStopJobResponsejobdevicecpuTypeDef,
        "resolution": ClientStopJobResponsejobdeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[ClientStopJobResponsejobdeviceinstancesTypeDef],
        "availability": str,
    },
    total=False,
)


class ClientStopJobResponsejobdeviceTypeDef(_ClientStopJobResponsejobdeviceTypeDef):
    """
    Type definition for `ClientStopJobResponsejob` `device`

    The device (phone or tablet).

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be cleaned
            up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently available
      in the ListDevices and GetDevice API methods.
    """


_ClientStopJobResponsejobTypeDef = TypedDict(
    "_ClientStopJobResponsejobTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ClientStopJobResponsejobcountersTypeDef,
        "message": str,
        "device": ClientStopJobResponsejobdeviceTypeDef,
        "instanceArn": str,
        "deviceMinutes": ClientStopJobResponsejobdeviceMinutesTypeDef,
        "videoEndpoint": str,
        "videoCapture": bool,
    },
    total=False,
)


class ClientStopJobResponsejobTypeDef(_ClientStopJobResponsejobTypeDef):
    """
    Type definition for `ClientStopJobResponse` `job`

    The job that was stopped.

    - **arn** *(string) --*

      The job's ARN.

    - **name** *(string) --*

      The job's name.

    - **type** *(string) --*

      The job's type.

      Allowed values include the following:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby test type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **created** *(datetime) --*

      When the job was created.

    - **status** *(string) --*

      The job's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The job's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The job's start time.

    - **stopped** *(datetime) --*

      The job's stop time.

    - **counters** *(dict) --*

      The job's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the job's result.

    - **device** *(dict) --*

      The device (phone or tablet).

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
          CPU is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type are
        PRIVATE and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test run. The
              default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not be cleaned
              up from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test run. The
              default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently available
        in the ListDevices and GetDevice API methods.

    - **instanceArn** *(string) --*

      The Amazon Resource Name (ARN) of the instance.

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the job.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to run
        tests.

    - **videoEndpoint** *(string) --*

      The endpoint for streaming device video.

    - **videoCapture** *(boolean) --*

      This value is set to true if video capture is enabled; otherwise, it is set to false.
    """


_ClientStopJobResponseTypeDef = TypedDict(
    "_ClientStopJobResponseTypeDef",
    {"job": ClientStopJobResponsejobTypeDef},
    total=False,
)


class ClientStopJobResponseTypeDef(_ClientStopJobResponseTypeDef):
    """
    Type definition for `ClientStopJob` `Response`

    - **job** *(dict) --*

      The job that was stopped.

      - **arn** *(string) --*

        The job's ARN.

      - **name** *(string) --*

        The job's name.

      - **type** *(string) --*

        The job's type.

        Allowed values include the following:

        * BUILTIN_FUZZ: The built-in fuzz type.

        * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
        interacting with it and capturing screenshots at the same time.

        * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

        * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

        * APPIUM_PYTHON: The Appium Python type.

        * APPIUM_NODE: The Appium Node.js type.

        * APPIUM_RUBY: The Appium Ruby type.

        * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

        * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

        * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

        * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

        * APPIUM_WEB_RUBY: The Appium Ruby test type for web apps.

        * CALABASH: The Calabash type.

        * INSTRUMENTATION: The Instrumentation type.

        * UIAUTOMATION: The uiautomation type.

        * UIAUTOMATOR: The uiautomator type.

        * XCTEST: The Xcode test type.

        * XCTEST_UI: The Xcode UI test type.

      - **created** *(datetime) --*

        When the job was created.

      - **status** *(string) --*

        The job's status.

        Allowed values include:

        * PENDING: A pending status.

        * PENDING_CONCURRENCY: A pending concurrency status.

        * PENDING_DEVICE: A pending device status.

        * PROCESSING: A processing status.

        * SCHEDULING: A scheduling status.

        * PREPARING: A preparing status.

        * RUNNING: A running status.

        * COMPLETED: A completed status.

        * STOPPING: A stopping status.

      - **result** *(string) --*

        The job's result.

        Allowed values include:

        * PENDING: A pending condition.

        * PASSED: A passing condition.

        * WARNED: A warning condition.

        * FAILED: A failed condition.

        * SKIPPED: A skipped condition.

        * ERRORED: An error condition.

        * STOPPED: A stopped condition.

      - **started** *(datetime) --*

        The job's start time.

      - **stopped** *(datetime) --*

        The job's stop time.

      - **counters** *(dict) --*

        The job's result counters.

        - **total** *(integer) --*

          The total number of entities.

        - **passed** *(integer) --*

          The number of passed entities.

        - **failed** *(integer) --*

          The number of failed entities.

        - **warned** *(integer) --*

          The number of warned entities.

        - **errored** *(integer) --*

          The number of errored entities.

        - **stopped** *(integer) --*

          The number of stopped entities.

        - **skipped** *(integer) --*

          The number of skipped entities.

      - **message** *(string) --*

        A message about the job's result.

      - **device** *(dict) --*

        The device (phone or tablet).

        - **arn** *(string) --*

          The device's ARN.

        - **name** *(string) --*

          The device's display name.

        - **manufacturer** *(string) --*

          The device's manufacturer name.

        - **model** *(string) --*

          The device's model name.

        - **modelId** *(string) --*

          The device's model ID.

        - **formFactor** *(string) --*

          The device's form factor.

          Allowed values include:

          * PHONE: The phone form factor.

          * TABLET: The tablet form factor.

        - **platform** *(string) --*

          The device's platform.

          Allowed values include:

          * ANDROID: The Android platform.

          * IOS: The iOS platform.

        - **os** *(string) --*

          The device's operating system type.

        - **cpu** *(dict) --*

          Information about the device's CPU.

          - **frequency** *(string) --*

            The CPU's frequency.

          - **architecture** *(string) --*

            The CPU's architecture, for example x86 or ARM.

          - **clock** *(float) --*

            The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
            CPU is expressed as 1200000000.

        - **resolution** *(dict) --*

          The resolution of the device.

          - **width** *(integer) --*

            The screen resolution's width, expressed in pixels.

          - **height** *(integer) --*

            The screen resolution's height, expressed in pixels.

        - **heapSize** *(integer) --*

          The device's heap size, expressed in bytes.

        - **memory** *(integer) --*

          The device's total memory size, expressed in bytes.

        - **image** *(string) --*

          The device's image name.

        - **carrier** *(string) --*

          The device's carrier.

        - **radio** *(string) --*

          The device's radio.

        - **remoteAccessEnabled** *(boolean) --*

          Specifies whether remote access has been enabled for the specified device.

        - **remoteDebugEnabled** *(boolean) --*

          This flag is set to ``true`` if remote debugging is enabled for the device.

           *Remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **fleetType** *(string) --*

          The type of fleet to which this device belongs. Possible values for fleet type are
          PRIVATE and PUBLIC.

        - **fleetName** *(string) --*

          The name of the fleet to which this device belongs.

        - **instances** *(list) --*

          The instances belonging to this device.

          - *(dict) --*

            Represents the device instance.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the device instance.

            - **deviceArn** *(string) --*

              The Amazon Resource Name (ARN) of the device.

            - **labels** *(list) --*

              An array of strings describing the device instance.

              - *(string) --*

            - **status** *(string) --*

              The status of the device instance. Valid values are listed below.

            - **udid** *(string) --*

              Unique device identifier for the device instance.

            - **instanceProfile** *(dict) --*

              A object containing information about the instance profile.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the instance profile.

              - **packageCleanup** *(boolean) --*

                When set to ``true`` , Device Farm will remove app packages after a test run. The
                default value is ``false`` for private devices.

              - **excludeAppPackagesFromCleanup** *(list) --*

                An array of strings specifying the list of app packages that should not be cleaned
                up from the device after a test run is over.

                The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

                - *(string) --*

              - **rebootAfterUse** *(boolean) --*

                When set to ``true`` , Device Farm will reboot the instance after a test run. The
                default value is ``true`` .

              - **name** *(string) --*

                The name of the instance profile.

              - **description** *(string) --*

                The description of the instance profile.

        - **availability** *(string) --*

          Reflects how likely a device will be available for a test run. It is currently available
          in the ListDevices and GetDevice API methods.

      - **instanceArn** *(string) --*

        The Amazon Resource Name (ARN) of the instance.

      - **deviceMinutes** *(dict) --*

        Represents the total (metered or unmetered) minutes used by the job.

        - **total** *(float) --*

          When specified, represents the total minutes used by the resource to run tests.

        - **metered** *(float) --*

          When specified, represents only the sum of metered minutes used by the resource to run
          tests.

        - **unmetered** *(float) --*

          When specified, represents only the sum of unmetered minutes used by the resource to run
          tests.

      - **videoEndpoint** *(string) --*

        The endpoint for streaming device video.

      - **videoCapture** *(boolean) --*

        This value is set to true if video capture is enabled; otherwise, it is set to false.
    """


_ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef = TypedDict(
    "_ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef(
    _ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef
):
    """
    Type definition for `ClientStopRemoteAccessSessionResponseremoteAccessSession` `deviceMinutes`

    The number of minutes a device is used in a remote access session (including setup and
    teardown minutes).

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to run
      tests.
    """


_ClientStopRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef = TypedDict(
    "_ClientStopRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ClientStopRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef(
    _ClientStopRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef
):
    """
    Type definition for `ClientStopRemoteAccessSessionResponseremoteAccessSessiondevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef(
    _ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned
      up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef = TypedDict(
    "_ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef(
    _ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef
):
    """
    Type definition for `ClientStopRemoteAccessSessionResponseremoteAccessSessiondevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned
        up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef = TypedDict(
    "_ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef(
    _ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef
):
    """
    Type definition for `ClientStopRemoteAccessSessionResponseremoteAccessSessiondevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef = TypedDict(
    "_ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ClientStopRemoteAccessSessionResponseremoteAccessSessiondevicecpuTypeDef,
        "resolution": ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[
            ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceinstancesTypeDef
        ],
        "availability": str,
    },
    total=False,
)


class ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef(
    _ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef
):
    """
    Type definition for `ClientStopRemoteAccessSessionResponseremoteAccessSession` `device`

    The device (phone or tablet) used in the remote access session.

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be cleaned
            up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently available
      in the ListDevices and GetDevice API methods.
    """


_ClientStopRemoteAccessSessionResponseremoteAccessSessionTypeDef = TypedDict(
    "_ClientStopRemoteAccessSessionResponseremoteAccessSessionTypeDef",
    {
        "arn": str,
        "name": str,
        "created": datetime,
        "status": str,
        "result": str,
        "message": str,
        "started": datetime,
        "stopped": datetime,
        "device": ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceTypeDef,
        "instanceArn": str,
        "remoteDebugEnabled": bool,
        "remoteRecordEnabled": bool,
        "remoteRecordAppArn": str,
        "hostAddress": str,
        "clientId": str,
        "billingMethod": str,
        "deviceMinutes": ClientStopRemoteAccessSessionResponseremoteAccessSessiondeviceMinutesTypeDef,
        "endpoint": str,
        "deviceUdid": str,
        "interactionMode": str,
        "skipAppResign": bool,
    },
    total=False,
)


class ClientStopRemoteAccessSessionResponseremoteAccessSessionTypeDef(
    _ClientStopRemoteAccessSessionResponseremoteAccessSessionTypeDef
):
    """
    Type definition for `ClientStopRemoteAccessSessionResponse` `remoteAccessSession`

    A container representing the metadata from the service about the remote access session you
    are stopping.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the remote access session.

    - **name** *(string) --*

      The name of the remote access session.

    - **created** *(datetime) --*

      The date and time the remote access session was created.

    - **status** *(string) --*

      The status of the remote access session. Can be any of the following:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The result of the remote access session. Can be any of the following:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **message** *(string) --*

      A message about the remote access session.

    - **started** *(datetime) --*

      The date and time the remote access session was started.

    - **stopped** *(datetime) --*

      The date and time the remote access session was stopped.

    - **device** *(dict) --*

      The device (phone or tablet) used in the remote access session.

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
          CPU is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type are
        PRIVATE and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test run. The
              default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not be cleaned
              up from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test run. The
              default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently available
        in the ListDevices and GetDevice API methods.

    - **instanceArn** *(string) --*

      The Amazon Resource Name (ARN) of the instance.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **remoteRecordEnabled** *(boolean) --*

      This flag is set to ``true`` if remote recording is enabled for the remote access session.

    - **remoteRecordAppArn** *(string) --*

      The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.

    - **hostAddress** *(string) --*

      IP address of the EC2 host where you need to connect to remotely debug devices. Only
      returned if remote debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **clientId** *(string) --*

      Unique identifier of your client for the remote access session. Only returned if remote
      debugging is enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **billingMethod** *(string) --*

      The billing method of the remote access session. Possible values include ``METERED`` or
      ``UNMETERED`` . For more information about metered devices, see `AWS Device Farm
      terminology
      <https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology>`__
      ."

    - **deviceMinutes** *(dict) --*

      The number of minutes a device is used in a remote access session (including setup and
      teardown minutes).

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to run
        tests.

    - **endpoint** *(string) --*

      The endpoint for the remote access sesssion.

    - **deviceUdid** *(string) --*

      Unique device identifier for the remote device. Only returned if remote debugging is
      enabled for the remote access session.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **interactionMode** *(string) --*

      The interaction mode of the remote access session. Valid values are:

      * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the
      screen. You **cannot** run XCUITest framework-based tests in this mode.

      * NO_VIDEO: You are connected to the device but cannot interact with it or view the screen.
      This mode has the fastest test execution speed. You **can** run XCUITest framework-based
      tests in this mode.

      * VIDEO_ONLY: You can view the screen but cannot touch or rotate it. You **can** run
      XCUITest framework-based tests and watch the screen in this mode.

    - **skipAppResign** *(boolean) --*

      When set to ``true`` , for private devices, Device Farm will not sign your app again. For
      public devices, Device Farm always signs your apps again and this parameter has no effect.

      For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
      <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .
    """


_ClientStopRemoteAccessSessionResponseTypeDef = TypedDict(
    "_ClientStopRemoteAccessSessionResponseTypeDef",
    {
        "remoteAccessSession": ClientStopRemoteAccessSessionResponseremoteAccessSessionTypeDef
    },
    total=False,
)


class ClientStopRemoteAccessSessionResponseTypeDef(
    _ClientStopRemoteAccessSessionResponseTypeDef
):
    """
    Type definition for `ClientStopRemoteAccessSession` `Response`

    Represents the response from the server that describes the remote access session when AWS
    Device Farm stops the session.

    - **remoteAccessSession** *(dict) --*

      A container representing the metadata from the service about the remote access session you
      are stopping.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the remote access session.

      - **name** *(string) --*

        The name of the remote access session.

      - **created** *(datetime) --*

        The date and time the remote access session was created.

      - **status** *(string) --*

        The status of the remote access session. Can be any of the following:

        * PENDING: A pending status.

        * PENDING_CONCURRENCY: A pending concurrency status.

        * PENDING_DEVICE: A pending device status.

        * PROCESSING: A processing status.

        * SCHEDULING: A scheduling status.

        * PREPARING: A preparing status.

        * RUNNING: A running status.

        * COMPLETED: A completed status.

        * STOPPING: A stopping status.

      - **result** *(string) --*

        The result of the remote access session. Can be any of the following:

        * PENDING: A pending condition.

        * PASSED: A passing condition.

        * WARNED: A warning condition.

        * FAILED: A failed condition.

        * SKIPPED: A skipped condition.

        * ERRORED: An error condition.

        * STOPPED: A stopped condition.

      - **message** *(string) --*

        A message about the remote access session.

      - **started** *(datetime) --*

        The date and time the remote access session was started.

      - **stopped** *(datetime) --*

        The date and time the remote access session was stopped.

      - **device** *(dict) --*

        The device (phone or tablet) used in the remote access session.

        - **arn** *(string) --*

          The device's ARN.

        - **name** *(string) --*

          The device's display name.

        - **manufacturer** *(string) --*

          The device's manufacturer name.

        - **model** *(string) --*

          The device's model name.

        - **modelId** *(string) --*

          The device's model ID.

        - **formFactor** *(string) --*

          The device's form factor.

          Allowed values include:

          * PHONE: The phone form factor.

          * TABLET: The tablet form factor.

        - **platform** *(string) --*

          The device's platform.

          Allowed values include:

          * ANDROID: The Android platform.

          * IOS: The iOS platform.

        - **os** *(string) --*

          The device's operating system type.

        - **cpu** *(dict) --*

          Information about the device's CPU.

          - **frequency** *(string) --*

            The CPU's frequency.

          - **architecture** *(string) --*

            The CPU's architecture, for example x86 or ARM.

          - **clock** *(float) --*

            The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
            CPU is expressed as 1200000000.

        - **resolution** *(dict) --*

          The resolution of the device.

          - **width** *(integer) --*

            The screen resolution's width, expressed in pixels.

          - **height** *(integer) --*

            The screen resolution's height, expressed in pixels.

        - **heapSize** *(integer) --*

          The device's heap size, expressed in bytes.

        - **memory** *(integer) --*

          The device's total memory size, expressed in bytes.

        - **image** *(string) --*

          The device's image name.

        - **carrier** *(string) --*

          The device's carrier.

        - **radio** *(string) --*

          The device's radio.

        - **remoteAccessEnabled** *(boolean) --*

          Specifies whether remote access has been enabled for the specified device.

        - **remoteDebugEnabled** *(boolean) --*

          This flag is set to ``true`` if remote debugging is enabled for the device.

           *Remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **fleetType** *(string) --*

          The type of fleet to which this device belongs. Possible values for fleet type are
          PRIVATE and PUBLIC.

        - **fleetName** *(string) --*

          The name of the fleet to which this device belongs.

        - **instances** *(list) --*

          The instances belonging to this device.

          - *(dict) --*

            Represents the device instance.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the device instance.

            - **deviceArn** *(string) --*

              The Amazon Resource Name (ARN) of the device.

            - **labels** *(list) --*

              An array of strings describing the device instance.

              - *(string) --*

            - **status** *(string) --*

              The status of the device instance. Valid values are listed below.

            - **udid** *(string) --*

              Unique device identifier for the device instance.

            - **instanceProfile** *(dict) --*

              A object containing information about the instance profile.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the instance profile.

              - **packageCleanup** *(boolean) --*

                When set to ``true`` , Device Farm will remove app packages after a test run. The
                default value is ``false`` for private devices.

              - **excludeAppPackagesFromCleanup** *(list) --*

                An array of strings specifying the list of app packages that should not be cleaned
                up from the device after a test run is over.

                The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

                - *(string) --*

              - **rebootAfterUse** *(boolean) --*

                When set to ``true`` , Device Farm will reboot the instance after a test run. The
                default value is ``true`` .

              - **name** *(string) --*

                The name of the instance profile.

              - **description** *(string) --*

                The description of the instance profile.

        - **availability** *(string) --*

          Reflects how likely a device will be available for a test run. It is currently available
          in the ListDevices and GetDevice API methods.

      - **instanceArn** *(string) --*

        The Amazon Resource Name (ARN) of the instance.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **remoteRecordEnabled** *(boolean) --*

        This flag is set to ``true`` if remote recording is enabled for the remote access session.

      - **remoteRecordAppArn** *(string) --*

        The Amazon Resource Name (ARN) for the app to be recorded in the remote access session.

      - **hostAddress** *(string) --*

        IP address of the EC2 host where you need to connect to remotely debug devices. Only
        returned if remote debugging is enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **clientId** *(string) --*

        Unique identifier of your client for the remote access session. Only returned if remote
        debugging is enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **billingMethod** *(string) --*

        The billing method of the remote access session. Possible values include ``METERED`` or
        ``UNMETERED`` . For more information about metered devices, see `AWS Device Farm
        terminology
        <https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology>`__
        ."

      - **deviceMinutes** *(dict) --*

        The number of minutes a device is used in a remote access session (including setup and
        teardown minutes).

        - **total** *(float) --*

          When specified, represents the total minutes used by the resource to run tests.

        - **metered** *(float) --*

          When specified, represents only the sum of metered minutes used by the resource to run
          tests.

        - **unmetered** *(float) --*

          When specified, represents only the sum of unmetered minutes used by the resource to run
          tests.

      - **endpoint** *(string) --*

        The endpoint for the remote access sesssion.

      - **deviceUdid** *(string) --*

        Unique device identifier for the remote device. Only returned if remote debugging is
        enabled for the remote access session.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **interactionMode** *(string) --*

        The interaction mode of the remote access session. Valid values are:

        * INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the
        screen. You **cannot** run XCUITest framework-based tests in this mode.

        * NO_VIDEO: You are connected to the device but cannot interact with it or view the screen.
        This mode has the fastest test execution speed. You **can** run XCUITest framework-based
        tests in this mode.

        * VIDEO_ONLY: You can view the screen but cannot touch or rotate it. You **can** run
        XCUITest framework-based tests and watch the screen in this mode.

      - **skipAppResign** *(boolean) --*

        When set to ``true`` , for private devices, Device Farm will not sign your app again. For
        public devices, Device Farm always signs your apps again and this parameter has no effect.

        For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
        <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .
    """


_ClientStopRunResponseruncountersTypeDef = TypedDict(
    "_ClientStopRunResponseruncountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ClientStopRunResponseruncountersTypeDef(_ClientStopRunResponseruncountersTypeDef):
    """
    Type definition for `ClientStopRunResponserun` `counters`

    The run's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ClientStopRunResponseruncustomerArtifactPathsTypeDef = TypedDict(
    "_ClientStopRunResponseruncustomerArtifactPathsTypeDef",
    {"iosPaths": List[str], "androidPaths": List[str], "deviceHostPaths": List[str]},
    total=False,
)


class ClientStopRunResponseruncustomerArtifactPathsTypeDef(
    _ClientStopRunResponseruncustomerArtifactPathsTypeDef
):
    """
    Type definition for `ClientStopRunResponserun` `customerArtifactPaths`

    Output ``CustomerArtifactPaths`` object for the test run.

    - **iosPaths** *(list) --*

      Comma-separated list of paths on the iOS device where the artifacts generated by the
      customer's tests will be pulled from.

      - *(string) --*

    - **androidPaths** *(list) --*

      Comma-separated list of paths on the Android device where the artifacts generated by the
      customer's tests will be pulled from.

      - *(string) --*

    - **deviceHostPaths** *(list) --*

      Comma-separated list of paths in the test execution environment where the artifacts
      generated by the customer's tests will be pulled from.

      - *(string) --*
    """


_ClientStopRunResponserundeviceMinutesTypeDef = TypedDict(
    "_ClientStopRunResponserundeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ClientStopRunResponserundeviceMinutesTypeDef(
    _ClientStopRunResponserundeviceMinutesTypeDef
):
    """
    Type definition for `ClientStopRunResponserun` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the test run.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to run
      tests.
    """


_ClientStopRunResponserundeviceSelectionResultfiltersTypeDef = TypedDict(
    "_ClientStopRunResponserundeviceSelectionResultfiltersTypeDef",
    {"attribute": str, "operator": str, "values": List[str]},
    total=False,
)


class ClientStopRunResponserundeviceSelectionResultfiltersTypeDef(
    _ClientStopRunResponserundeviceSelectionResultfiltersTypeDef
):
    """
    Type definition for `ClientStopRunResponserundeviceSelectionResult` `filters`

    Represents a device filter used to select a set of devices to be included in a test
    run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
    to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

    It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
    JSON request syntax, see  ListDevices .

    - **attribute** *(string) --*

      The aspect of a device such as platform or model used as the selection criteria in a
      device filter.

      The supported operators for each attribute are provided in the following list.

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
       ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        MODEL

      The device model. For example, "iPad 5th Gen".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE",
      "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

       *Ignored.* Whether the device is enabled for remote debugging. Valid values are
       "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

    - **operator** *(string) --*

      Specifies how Device Farm compares the filter's attribute to the value. For the
      operators that are supported by each attribute, see the attribute descriptions.

    - **values** *(list) --*

      An array of one or more filter values used in a device filter.

       **Operator Values**

      * The IN and NOT_IN operators can take a values array that has more than one element.

      * The other operators require an array with a single element.

       **Attribute Values**

      * The PLATFORM attribute can be set to "ANDROID" or "IOS".

      * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
      or "TEMPORARY_NOT_AVAILABLE".

      * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

      * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

      - *(string) --*
    """


_ClientStopRunResponserundeviceSelectionResultTypeDef = TypedDict(
    "_ClientStopRunResponserundeviceSelectionResultTypeDef",
    {
        "filters": List[ClientStopRunResponserundeviceSelectionResultfiltersTypeDef],
        "matchedDevicesCount": int,
        "maxDevices": int,
    },
    total=False,
)


class ClientStopRunResponserundeviceSelectionResultTypeDef(
    _ClientStopRunResponserundeviceSelectionResultTypeDef
):
    """
    Type definition for `ClientStopRunResponserun` `deviceSelectionResult`

    The results of a device filter used to select the devices for a test run.

    - **filters** *(list) --*

      The filters in a device selection result.

      - *(dict) --*

        Represents a device filter used to select a set of devices to be included in a test
        run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
        to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

        It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
        JSON request syntax, see  ListDevices .

        - **attribute** *(string) --*

          The aspect of a device such as platform or model used as the selection criteria in a
          device filter.

          The supported operators for each attribute are provided in the following list.

            ARN

          The Amazon Resource Name (ARN) of the device. For example,
          "arn:aws:devicefarm:us-west-2::device:12345Example".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            PLATFORM

          The device platform. Valid values are "ANDROID" or "IOS".

           *Supported operators* : ``EQUALS``

            OS_VERSION

          The operating system version. For example, "10.3.2".

           *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
           ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

            MODEL

          The device model. For example, "iPad 5th Gen".

           *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

            AVAILABILITY

          The current availability of the device. Valid values are "AVAILABLE",
          "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

           *Supported operators* : ``EQUALS``

            FORM_FACTOR

          The device form factor. Valid values are "PHONE" or "TABLET".

           *Supported operators* : ``EQUALS``

            MANUFACTURER

          The device manufacturer. For example, "Apple".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            REMOTE_ACCESS_ENABLED

          Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

            REMOTE_DEBUG_ENABLED

           *Ignored.* Whether the device is enabled for remote debugging. Valid values are
           "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

           *This filter will be ignored, as remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

            INSTANCE_ARN

          The Amazon Resource Name (ARN) of the device instance.

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            INSTANCE_LABELS

          The label of the device instance.

           *Supported operators* : ``CONTAINS``

            FLEET_TYPE

          The fleet type. Valid values are "PUBLIC" or "PRIVATE".

           *Supported operators* : ``EQUALS``

        - **operator** *(string) --*

          Specifies how Device Farm compares the filter's attribute to the value. For the
          operators that are supported by each attribute, see the attribute descriptions.

        - **values** *(list) --*

          An array of one or more filter values used in a device filter.

           **Operator Values**

          * The IN and NOT_IN operators can take a values array that has more than one element.

          * The other operators require an array with a single element.

           **Attribute Values**

          * The PLATFORM attribute can be set to "ANDROID" or "IOS".

          * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
          or "TEMPORARY_NOT_AVAILABLE".

          * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

          * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

          - *(string) --*

    - **matchedDevicesCount** *(integer) --*

      The number of devices that matched the device filter selection criteria.

    - **maxDevices** *(integer) --*

      The maximum number of devices to be selected by a device filter and included in a test
      run.
    """


_ClientStopRunResponserunlocationTypeDef = TypedDict(
    "_ClientStopRunResponserunlocationTypeDef",
    {"latitude": float, "longitude": float},
    total=False,
)


class ClientStopRunResponserunlocationTypeDef(_ClientStopRunResponserunlocationTypeDef):
    """
    Type definition for `ClientStopRunResponserun` `location`

    Information about the location that is used for the run.

    - **latitude** *(float) --*

      The latitude.

    - **longitude** *(float) --*

      The longitude.
    """


_ClientStopRunResponserunnetworkProfileTypeDef = TypedDict(
    "_ClientStopRunResponserunnetworkProfileTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "uplinkBandwidthBits": int,
        "downlinkBandwidthBits": int,
        "uplinkDelayMs": int,
        "downlinkDelayMs": int,
        "uplinkJitterMs": int,
        "downlinkJitterMs": int,
        "uplinkLossPercent": int,
        "downlinkLossPercent": int,
    },
    total=False,
)


class ClientStopRunResponserunnetworkProfileTypeDef(
    _ClientStopRunResponserunnetworkProfileTypeDef
):
    """
    Type definition for `ClientStopRunResponserun` `networkProfile`

    The network profile being used for a test run.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the network profile.

    - **name** *(string) --*

      The name of the network profile.

    - **description** *(string) --*

      The description of the network profile.

    - **type** *(string) --*

      The type of network profile. Valid values are listed below.

    - **uplinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **downlinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **uplinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **downlinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **uplinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **downlinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **uplinkLossPercent** *(integer) --*

      Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

    - **downlinkLossPercent** *(integer) --*

      Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ClientStopRunResponserunradiosTypeDef = TypedDict(
    "_ClientStopRunResponserunradiosTypeDef",
    {"wifi": bool, "bluetooth": bool, "nfc": bool, "gps": bool},
    total=False,
)


class ClientStopRunResponserunradiosTypeDef(_ClientStopRunResponserunradiosTypeDef):
    """
    Type definition for `ClientStopRunResponserun` `radios`

    Information about the radio states for the run.

    - **wifi** *(boolean) --*

      True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

    - **bluetooth** *(boolean) --*

      True if Bluetooth is enabled at the beginning of the test; otherwise, false.

    - **nfc** *(boolean) --*

      True if NFC is enabled at the beginning of the test; otherwise, false.

    - **gps** *(boolean) --*

      True if GPS is enabled at the beginning of the test; otherwise, false.
    """


_ClientStopRunResponserunTypeDef = TypedDict(
    "_ClientStopRunResponserunTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "platform": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ClientStopRunResponseruncountersTypeDef,
        "message": str,
        "totalJobs": int,
        "completedJobs": int,
        "billingMethod": str,
        "deviceMinutes": ClientStopRunResponserundeviceMinutesTypeDef,
        "networkProfile": ClientStopRunResponserunnetworkProfileTypeDef,
        "parsingResultUrl": str,
        "resultCode": str,
        "seed": int,
        "appUpload": str,
        "eventCount": int,
        "jobTimeoutMinutes": int,
        "devicePoolArn": str,
        "locale": str,
        "radios": ClientStopRunResponserunradiosTypeDef,
        "location": ClientStopRunResponserunlocationTypeDef,
        "customerArtifactPaths": ClientStopRunResponseruncustomerArtifactPathsTypeDef,
        "webUrl": str,
        "skipAppResign": bool,
        "testSpecArn": str,
        "deviceSelectionResult": ClientStopRunResponserundeviceSelectionResultTypeDef,
    },
    total=False,
)


class ClientStopRunResponserunTypeDef(_ClientStopRunResponserunTypeDef):
    """
    Type definition for `ClientStopRunResponse` `run`

    The run that was stopped.

    - **arn** *(string) --*

      The run's ARN.

    - **name** *(string) --*

      The run's name.

    - **type** *(string) --*

      The run's type.

      Must be one of the following values:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **platform** *(string) --*

      The run's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **created** *(datetime) --*

      When the run was created.

    - **status** *(string) --*

      The run's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The run's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The run's start time.

    - **stopped** *(datetime) --*

      The run's stop time.

    - **counters** *(dict) --*

      The run's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the run's result.

    - **totalJobs** *(integer) --*

      The total number of jobs for the run.

    - **completedJobs** *(integer) --*

      The total number of completed jobs.

    - **billingMethod** *(string) --*

      Specifies the billing method for a test run: ``metered`` or ``unmetered`` . If the
      parameter is not specified, the default value is ``metered`` .

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the test run.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to run
        tests.

    - **networkProfile** *(dict) --*

      The network profile being used for a test run.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the network profile.

      - **name** *(string) --*

        The name of the network profile.

      - **description** *(string) --*

        The description of the network profile.

      - **type** *(string) --*

        The type of network profile. Valid values are listed below.

      - **uplinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **downlinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **uplinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **downlinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **uplinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **downlinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **uplinkLossPercent** *(integer) --*

        Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

      - **downlinkLossPercent** *(integer) --*

        Proportion of received packets that fail to arrive from 0 to 100 percent.

    - **parsingResultUrl** *(string) --*

      Read-only URL for an object in S3 bucket where you can get the parsing results of the test
      package. If the test package doesn't parse, the reason why it doesn't parse appears in the
      file that this URL points to.

    - **resultCode** *(string) --*

      Supporting field for the result field. Set only if ``result`` is ``SKIPPED`` .
      ``PARSING_FAILED`` if the result is skipped because of test package parsing failure.

    - **seed** *(integer) --*

      For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same seed
      value between tests ensures identical event sequences.

    - **appUpload** *(string) --*

      An app to upload or that has been uploaded.

    - **eventCount** *(integer) --*

      For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz test
      should perform.

    - **jobTimeoutMinutes** *(integer) --*

      The number of minutes the job will execute before it times out.

    - **devicePoolArn** *(string) --*

      The ARN of the device pool for the run.

    - **locale** *(string) --*

      Information about the locale that is used for the run.

    - **radios** *(dict) --*

      Information about the radio states for the run.

      - **wifi** *(boolean) --*

        True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

      - **bluetooth** *(boolean) --*

        True if Bluetooth is enabled at the beginning of the test; otherwise, false.

      - **nfc** *(boolean) --*

        True if NFC is enabled at the beginning of the test; otherwise, false.

      - **gps** *(boolean) --*

        True if GPS is enabled at the beginning of the test; otherwise, false.

    - **location** *(dict) --*

      Information about the location that is used for the run.

      - **latitude** *(float) --*

        The latitude.

      - **longitude** *(float) --*

        The longitude.

    - **customerArtifactPaths** *(dict) --*

      Output ``CustomerArtifactPaths`` object for the test run.

      - **iosPaths** *(list) --*

        Comma-separated list of paths on the iOS device where the artifacts generated by the
        customer's tests will be pulled from.

        - *(string) --*

      - **androidPaths** *(list) --*

        Comma-separated list of paths on the Android device where the artifacts generated by the
        customer's tests will be pulled from.

        - *(string) --*

      - **deviceHostPaths** *(list) --*

        Comma-separated list of paths in the test execution environment where the artifacts
        generated by the customer's tests will be pulled from.

        - *(string) --*

    - **webUrl** *(string) --*

      The Device Farm console URL for the recording of the run.

    - **skipAppResign** *(boolean) --*

      When set to ``true`` , for private devices, Device Farm will not sign your app again. For
      public devices, Device Farm always signs your apps again and this parameter has no effect.

      For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
      <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .

    - **testSpecArn** *(string) --*

      The ARN of the YAML-formatted test specification for the run.

    - **deviceSelectionResult** *(dict) --*

      The results of a device filter used to select the devices for a test run.

      - **filters** *(list) --*

        The filters in a device selection result.

        - *(dict) --*

          Represents a device filter used to select a set of devices to be included in a test
          run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
          to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

          It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
          JSON request syntax, see  ListDevices .

          - **attribute** *(string) --*

            The aspect of a device such as platform or model used as the selection criteria in a
            device filter.

            The supported operators for each attribute are provided in the following list.

              ARN

            The Amazon Resource Name (ARN) of the device. For example,
            "arn:aws:devicefarm:us-west-2::device:12345Example".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              PLATFORM

            The device platform. Valid values are "ANDROID" or "IOS".

             *Supported operators* : ``EQUALS``

              OS_VERSION

            The operating system version. For example, "10.3.2".

             *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
             ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

              MODEL

            The device model. For example, "iPad 5th Gen".

             *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

              AVAILABILITY

            The current availability of the device. Valid values are "AVAILABLE",
            "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

             *Supported operators* : ``EQUALS``

              FORM_FACTOR

            The device form factor. Valid values are "PHONE" or "TABLET".

             *Supported operators* : ``EQUALS``

              MANUFACTURER

            The device manufacturer. For example, "Apple".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              REMOTE_ACCESS_ENABLED

            Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

              REMOTE_DEBUG_ENABLED

             *Ignored.* Whether the device is enabled for remote debugging. Valid values are
             "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

             *This filter will be ignored, as remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

              INSTANCE_ARN

            The Amazon Resource Name (ARN) of the device instance.

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              INSTANCE_LABELS

            The label of the device instance.

             *Supported operators* : ``CONTAINS``

              FLEET_TYPE

            The fleet type. Valid values are "PUBLIC" or "PRIVATE".

             *Supported operators* : ``EQUALS``

          - **operator** *(string) --*

            Specifies how Device Farm compares the filter's attribute to the value. For the
            operators that are supported by each attribute, see the attribute descriptions.

          - **values** *(list) --*

            An array of one or more filter values used in a device filter.

             **Operator Values**

            * The IN and NOT_IN operators can take a values array that has more than one element.

            * The other operators require an array with a single element.

             **Attribute Values**

            * The PLATFORM attribute can be set to "ANDROID" or "IOS".

            * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
            or "TEMPORARY_NOT_AVAILABLE".

            * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

            * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

            - *(string) --*

      - **matchedDevicesCount** *(integer) --*

        The number of devices that matched the device filter selection criteria.

      - **maxDevices** *(integer) --*

        The maximum number of devices to be selected by a device filter and included in a test
        run.
    """


_ClientStopRunResponseTypeDef = TypedDict(
    "_ClientStopRunResponseTypeDef",
    {"run": ClientStopRunResponserunTypeDef},
    total=False,
)


class ClientStopRunResponseTypeDef(_ClientStopRunResponseTypeDef):
    """
    Type definition for `ClientStopRun` `Response`

    Represents the results of your stop run attempt.

    - **run** *(dict) --*

      The run that was stopped.

      - **arn** *(string) --*

        The run's ARN.

      - **name** *(string) --*

        The run's name.

      - **type** *(string) --*

        The run's type.

        Must be one of the following values:

        * BUILTIN_FUZZ: The built-in fuzz type.

        * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
        interacting with it and capturing screenshots at the same time.

        * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

        * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

        * APPIUM_PYTHON: The Appium Python type.

        * APPIUM_NODE: The Appium Node.js type.

        * APPIUM_RUBY: The Appium Ruby type.

        * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

        * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

        * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

        * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

        * APPIUM_WEB_RUBY: The Appium Ruby type for web apps.

        * CALABASH: The Calabash type.

        * INSTRUMENTATION: The Instrumentation type.

        * UIAUTOMATION: The uiautomation type.

        * UIAUTOMATOR: The uiautomator type.

        * XCTEST: The Xcode test type.

        * XCTEST_UI: The Xcode UI test type.

      - **platform** *(string) --*

        The run's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **created** *(datetime) --*

        When the run was created.

      - **status** *(string) --*

        The run's status.

        Allowed values include:

        * PENDING: A pending status.

        * PENDING_CONCURRENCY: A pending concurrency status.

        * PENDING_DEVICE: A pending device status.

        * PROCESSING: A processing status.

        * SCHEDULING: A scheduling status.

        * PREPARING: A preparing status.

        * RUNNING: A running status.

        * COMPLETED: A completed status.

        * STOPPING: A stopping status.

      - **result** *(string) --*

        The run's result.

        Allowed values include:

        * PENDING: A pending condition.

        * PASSED: A passing condition.

        * WARNED: A warning condition.

        * FAILED: A failed condition.

        * SKIPPED: A skipped condition.

        * ERRORED: An error condition.

        * STOPPED: A stopped condition.

      - **started** *(datetime) --*

        The run's start time.

      - **stopped** *(datetime) --*

        The run's stop time.

      - **counters** *(dict) --*

        The run's result counters.

        - **total** *(integer) --*

          The total number of entities.

        - **passed** *(integer) --*

          The number of passed entities.

        - **failed** *(integer) --*

          The number of failed entities.

        - **warned** *(integer) --*

          The number of warned entities.

        - **errored** *(integer) --*

          The number of errored entities.

        - **stopped** *(integer) --*

          The number of stopped entities.

        - **skipped** *(integer) --*

          The number of skipped entities.

      - **message** *(string) --*

        A message about the run's result.

      - **totalJobs** *(integer) --*

        The total number of jobs for the run.

      - **completedJobs** *(integer) --*

        The total number of completed jobs.

      - **billingMethod** *(string) --*

        Specifies the billing method for a test run: ``metered`` or ``unmetered`` . If the
        parameter is not specified, the default value is ``metered`` .

      - **deviceMinutes** *(dict) --*

        Represents the total (metered or unmetered) minutes used by the test run.

        - **total** *(float) --*

          When specified, represents the total minutes used by the resource to run tests.

        - **metered** *(float) --*

          When specified, represents only the sum of metered minutes used by the resource to run
          tests.

        - **unmetered** *(float) --*

          When specified, represents only the sum of unmetered minutes used by the resource to run
          tests.

      - **networkProfile** *(dict) --*

        The network profile being used for a test run.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the network profile.

        - **name** *(string) --*

          The name of the network profile.

        - **description** *(string) --*

          The description of the network profile.

        - **type** *(string) --*

          The type of network profile. Valid values are listed below.

        - **uplinkBandwidthBits** *(integer) --*

          The data throughput rate in bits per second, as an integer from 0 to 104857600.

        - **downlinkBandwidthBits** *(integer) --*

          The data throughput rate in bits per second, as an integer from 0 to 104857600.

        - **uplinkDelayMs** *(integer) --*

          Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

        - **downlinkDelayMs** *(integer) --*

          Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

        - **uplinkJitterMs** *(integer) --*

          Time variation in the delay of received packets in milliseconds as an integer from 0 to
          2000.

        - **downlinkJitterMs** *(integer) --*

          Time variation in the delay of received packets in milliseconds as an integer from 0 to
          2000.

        - **uplinkLossPercent** *(integer) --*

          Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

        - **downlinkLossPercent** *(integer) --*

          Proportion of received packets that fail to arrive from 0 to 100 percent.

      - **parsingResultUrl** *(string) --*

        Read-only URL for an object in S3 bucket where you can get the parsing results of the test
        package. If the test package doesn't parse, the reason why it doesn't parse appears in the
        file that this URL points to.

      - **resultCode** *(string) --*

        Supporting field for the result field. Set only if ``result`` is ``SKIPPED`` .
        ``PARSING_FAILED`` if the result is skipped because of test package parsing failure.

      - **seed** *(integer) --*

        For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same seed
        value between tests ensures identical event sequences.

      - **appUpload** *(string) --*

        An app to upload or that has been uploaded.

      - **eventCount** *(integer) --*

        For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz test
        should perform.

      - **jobTimeoutMinutes** *(integer) --*

        The number of minutes the job will execute before it times out.

      - **devicePoolArn** *(string) --*

        The ARN of the device pool for the run.

      - **locale** *(string) --*

        Information about the locale that is used for the run.

      - **radios** *(dict) --*

        Information about the radio states for the run.

        - **wifi** *(boolean) --*

          True if Wi-Fi is enabled at the beginning of the test; otherwise, false.

        - **bluetooth** *(boolean) --*

          True if Bluetooth is enabled at the beginning of the test; otherwise, false.

        - **nfc** *(boolean) --*

          True if NFC is enabled at the beginning of the test; otherwise, false.

        - **gps** *(boolean) --*

          True if GPS is enabled at the beginning of the test; otherwise, false.

      - **location** *(dict) --*

        Information about the location that is used for the run.

        - **latitude** *(float) --*

          The latitude.

        - **longitude** *(float) --*

          The longitude.

      - **customerArtifactPaths** *(dict) --*

        Output ``CustomerArtifactPaths`` object for the test run.

        - **iosPaths** *(list) --*

          Comma-separated list of paths on the iOS device where the artifacts generated by the
          customer's tests will be pulled from.

          - *(string) --*

        - **androidPaths** *(list) --*

          Comma-separated list of paths on the Android device where the artifacts generated by the
          customer's tests will be pulled from.

          - *(string) --*

        - **deviceHostPaths** *(list) --*

          Comma-separated list of paths in the test execution environment where the artifacts
          generated by the customer's tests will be pulled from.

          - *(string) --*

      - **webUrl** *(string) --*

        The Device Farm console URL for the recording of the run.

      - **skipAppResign** *(boolean) --*

        When set to ``true`` , for private devices, Device Farm will not sign your app again. For
        public devices, Device Farm always signs your apps again and this parameter has no effect.

        For more information about how Device Farm re-signs your app(s), see `Do you modify my app?
        <https://aws.amazon.com/device-farm/faq/>`__ in the *AWS Device Farm FAQs* .

      - **testSpecArn** *(string) --*

        The ARN of the YAML-formatted test specification for the run.

      - **deviceSelectionResult** *(dict) --*

        The results of a device filter used to select the devices for a test run.

        - **filters** *(list) --*

          The filters in a device selection result.

          - *(dict) --*

            Represents a device filter used to select a set of devices to be included in a test
            run. This data structure is passed in as the ``deviceSelectionConfiguration`` parameter
            to ScheduleRun. For an example of the JSON request syntax, see  ScheduleRun .

            It is also passed in as the ``filters`` parameter to ListDevices. For an example of the
            JSON request syntax, see  ListDevices .

            - **attribute** *(string) --*

              The aspect of a device such as platform or model used as the selection criteria in a
              device filter.

              The supported operators for each attribute are provided in the following list.

                ARN

              The Amazon Resource Name (ARN) of the device. For example,
              "arn:aws:devicefarm:us-west-2::device:12345Example".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                PLATFORM

              The device platform. Valid values are "ANDROID" or "IOS".

               *Supported operators* : ``EQUALS``

                OS_VERSION

              The operating system version. For example, "10.3.2".

               *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
               ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

                MODEL

              The device model. For example, "iPad 5th Gen".

               *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

                AVAILABILITY

              The current availability of the device. Valid values are "AVAILABLE",
              "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

               *Supported operators* : ``EQUALS``

                FORM_FACTOR

              The device form factor. Valid values are "PHONE" or "TABLET".

               *Supported operators* : ``EQUALS``

                MANUFACTURER

              The device manufacturer. For example, "Apple".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                REMOTE_ACCESS_ENABLED

              Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

               *Supported operators* : ``EQUALS``

                REMOTE_DEBUG_ENABLED

               *Ignored.* Whether the device is enabled for remote debugging. Valid values are
               "TRUE" or "FALSE".

               *Supported operators* : ``EQUALS``

               *This filter will be ignored, as remote debugging is `no longer supported
               <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

                INSTANCE_ARN

              The Amazon Resource Name (ARN) of the device instance.

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                INSTANCE_LABELS

              The label of the device instance.

               *Supported operators* : ``CONTAINS``

                FLEET_TYPE

              The fleet type. Valid values are "PUBLIC" or "PRIVATE".

               *Supported operators* : ``EQUALS``

            - **operator** *(string) --*

              Specifies how Device Farm compares the filter's attribute to the value. For the
              operators that are supported by each attribute, see the attribute descriptions.

            - **values** *(list) --*

              An array of one or more filter values used in a device filter.

               **Operator Values**

              * The IN and NOT_IN operators can take a values array that has more than one element.

              * The other operators require an array with a single element.

               **Attribute Values**

              * The PLATFORM attribute can be set to "ANDROID" or "IOS".

              * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY",
              or "TEMPORARY_NOT_AVAILABLE".

              * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

              * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

              - *(string) --*

        - **matchedDevicesCount** *(integer) --*

          The number of devices that matched the device filter selection criteria.

        - **maxDevices** *(integer) --*

          The maximum number of devices to be selected by a device filter and included in a test
          run.
    """


_ClientTagResourceTagsTypeDef = TypedDict(
    "_ClientTagResourceTagsTypeDef", {"Key": str, "Value": str}
)


class ClientTagResourceTagsTypeDef(_ClientTagResourceTagsTypeDef):
    """
    Type definition for `ClientTagResource` `Tags`

    The metadata that you apply to a resource to help you categorize and organize it. Each tag
    consists of a key and an optional value, both of which you define. Tag keys can have a maximum
    character length of 128 characters, and tag values can have a maximum length of 256 characters.

    - **Key** *(string) --* **[REQUIRED]**

      One part of a key-value pair that make up a tag. A ``key`` is a general label that acts like
      a category for more specific tag values.

    - **Value** *(string) --* **[REQUIRED]**

      The optional part of a key-value pair that make up a tag. A ``value`` acts as a descriptor
      within a tag category (key).
    """


_ClientUpdateDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef = TypedDict(
    "_ClientUpdateDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientUpdateDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef(
    _ClientUpdateDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef
):
    """
    Type definition for `ClientUpdateDeviceInstanceResponsedeviceInstance` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The default
      value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned up
      from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The default
      value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientUpdateDeviceInstanceResponsedeviceInstanceTypeDef = TypedDict(
    "_ClientUpdateDeviceInstanceResponsedeviceInstanceTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ClientUpdateDeviceInstanceResponsedeviceInstanceinstanceProfileTypeDef,
    },
    total=False,
)


class ClientUpdateDeviceInstanceResponsedeviceInstanceTypeDef(
    _ClientUpdateDeviceInstanceResponsedeviceInstanceTypeDef
):
    """
    Type definition for `ClientUpdateDeviceInstanceResponse` `deviceInstance`

    An object containing information about your device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The default
        value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned up
        from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The default
        value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientUpdateDeviceInstanceResponseTypeDef = TypedDict(
    "_ClientUpdateDeviceInstanceResponseTypeDef",
    {"deviceInstance": ClientUpdateDeviceInstanceResponsedeviceInstanceTypeDef},
    total=False,
)


class ClientUpdateDeviceInstanceResponseTypeDef(
    _ClientUpdateDeviceInstanceResponseTypeDef
):
    """
    Type definition for `ClientUpdateDeviceInstance` `Response`

    - **deviceInstance** *(dict) --*

      An object containing information about your device instance.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the device instance.

      - **deviceArn** *(string) --*

        The Amazon Resource Name (ARN) of the device.

      - **labels** *(list) --*

        An array of strings describing the device instance.

        - *(string) --*

      - **status** *(string) --*

        The status of the device instance. Valid values are listed below.

      - **udid** *(string) --*

        Unique device identifier for the device instance.

      - **instanceProfile** *(dict) --*

        A object containing information about the instance profile.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the instance profile.

        - **packageCleanup** *(boolean) --*

          When set to ``true`` , Device Farm will remove app packages after a test run. The default
          value is ``false`` for private devices.

        - **excludeAppPackagesFromCleanup** *(list) --*

          An array of strings specifying the list of app packages that should not be cleaned up
          from the device after a test run is over.

          The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

          - *(string) --*

        - **rebootAfterUse** *(boolean) --*

          When set to ``true`` , Device Farm will reboot the instance after a test run. The default
          value is ``true`` .

        - **name** *(string) --*

          The name of the instance profile.

        - **description** *(string) --*

          The description of the instance profile.
    """


_ClientUpdateDevicePoolResponsedevicePoolrulesTypeDef = TypedDict(
    "_ClientUpdateDevicePoolResponsedevicePoolrulesTypeDef",
    {"attribute": str, "operator": str, "value": str},
    total=False,
)


class ClientUpdateDevicePoolResponsedevicePoolrulesTypeDef(
    _ClientUpdateDevicePoolResponsedevicePoolrulesTypeDef
):
    """
    Type definition for `ClientUpdateDevicePoolResponsedevicePool` `rules`

    Represents a condition for a device pool.

    - **attribute** *(string) --*

      The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

      The supported operators for each attribute are provided in the following list.

        APPIUM_VERSION

      The Appium version for the test.

       *Supported operators* : ``CONTAINS``

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE",
      "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        MODEL

      The device model, such as "Apple iPad Air 2" or "Google Pixel".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
       ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

      Whether the device is enabled for remote debugging. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **operator** *(string) --*

      Specifies how Device Farm compares the rule's attribute to the value. For the operators
      that are supported by each attribute, see the attribute descriptions.

    - **value** *(string) --*

      The rule's value.
    """


_ClientUpdateDevicePoolResponsedevicePoolTypeDef = TypedDict(
    "_ClientUpdateDevicePoolResponsedevicePoolTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "rules": List[ClientUpdateDevicePoolResponsedevicePoolrulesTypeDef],
        "maxDevices": int,
    },
    total=False,
)


class ClientUpdateDevicePoolResponsedevicePoolTypeDef(
    _ClientUpdateDevicePoolResponsedevicePoolTypeDef
):
    """
    Type definition for `ClientUpdateDevicePoolResponse` `devicePool`

    The device pool you just updated.

    - **arn** *(string) --*

      The device pool's ARN.

    - **name** *(string) --*

      The device pool's name.

    - **description** *(string) --*

      The device pool's description.

    - **type** *(string) --*

      The device pool's type.

      Allowed values include:

      * CURATED: A device pool that is created and managed by AWS Device Farm.

      * PRIVATE: A device pool that is created and managed by the device pool developer.

    - **rules** *(list) --*

      Information about the device pool's rules.

      - *(dict) --*

        Represents a condition for a device pool.

        - **attribute** *(string) --*

          The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

          The supported operators for each attribute are provided in the following list.

            APPIUM_VERSION

          The Appium version for the test.

           *Supported operators* : ``CONTAINS``

            ARN

          The Amazon Resource Name (ARN) of the device. For example,
          "arn:aws:devicefarm:us-west-2::device:12345Example".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            AVAILABILITY

          The current availability of the device. Valid values are "AVAILABLE",
          "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

           *Supported operators* : ``EQUALS``

            FLEET_TYPE

          The fleet type. Valid values are "PUBLIC" or "PRIVATE".

           *Supported operators* : ``EQUALS``

            FORM_FACTOR

          The device form factor. Valid values are "PHONE" or "TABLET".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            INSTANCE_ARN

          The Amazon Resource Name (ARN) of the device instance.

           *Supported operators* : ``IN`` , ``NOT_IN``

            INSTANCE_LABELS

          The label of the device instance.

           *Supported operators* : ``CONTAINS``

            MANUFACTURER

          The device manufacturer. For example, "Apple".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            MODEL

          The device model, such as "Apple iPad Air 2" or "Google Pixel".

           *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

            OS_VERSION

          The operating system version. For example, "10.3.2".

           *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
           ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

            PLATFORM

          The device platform. Valid values are "ANDROID" or "IOS".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            REMOTE_ACCESS_ENABLED

          Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

            REMOTE_DEBUG_ENABLED

          Whether the device is enabled for remote debugging. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

           *This filter will be ignored, as remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **operator** *(string) --*

          Specifies how Device Farm compares the rule's attribute to the value. For the operators
          that are supported by each attribute, see the attribute descriptions.

        - **value** *(string) --*

          The rule's value.

    - **maxDevices** *(integer) --*

      The number of devices that Device Farm can add to your device pool. Device Farm adds
      devices that are available and that meet the criteria that you assign for the ``rules``
      parameter. Depending on how many devices meet these constraints, your device pool might
      contain fewer devices than the value for this parameter.

      By specifying the maximum number of devices, you can control the costs that you incur by
      running tests.
    """


_ClientUpdateDevicePoolResponseTypeDef = TypedDict(
    "_ClientUpdateDevicePoolResponseTypeDef",
    {"devicePool": ClientUpdateDevicePoolResponsedevicePoolTypeDef},
    total=False,
)


class ClientUpdateDevicePoolResponseTypeDef(_ClientUpdateDevicePoolResponseTypeDef):
    """
    Type definition for `ClientUpdateDevicePool` `Response`

    Represents the result of an update device pool request.

    - **devicePool** *(dict) --*

      The device pool you just updated.

      - **arn** *(string) --*

        The device pool's ARN.

      - **name** *(string) --*

        The device pool's name.

      - **description** *(string) --*

        The device pool's description.

      - **type** *(string) --*

        The device pool's type.

        Allowed values include:

        * CURATED: A device pool that is created and managed by AWS Device Farm.

        * PRIVATE: A device pool that is created and managed by the device pool developer.

      - **rules** *(list) --*

        Information about the device pool's rules.

        - *(dict) --*

          Represents a condition for a device pool.

          - **attribute** *(string) --*

            The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

            The supported operators for each attribute are provided in the following list.

              APPIUM_VERSION

            The Appium version for the test.

             *Supported operators* : ``CONTAINS``

              ARN

            The Amazon Resource Name (ARN) of the device. For example,
            "arn:aws:devicefarm:us-west-2::device:12345Example".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              AVAILABILITY

            The current availability of the device. Valid values are "AVAILABLE",
            "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

             *Supported operators* : ``EQUALS``

              FLEET_TYPE

            The fleet type. Valid values are "PUBLIC" or "PRIVATE".

             *Supported operators* : ``EQUALS``

              FORM_FACTOR

            The device form factor. Valid values are "PHONE" or "TABLET".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              INSTANCE_ARN

            The Amazon Resource Name (ARN) of the device instance.

             *Supported operators* : ``IN`` , ``NOT_IN``

              INSTANCE_LABELS

            The label of the device instance.

             *Supported operators* : ``CONTAINS``

              MANUFACTURER

            The device manufacturer. For example, "Apple".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              MODEL

            The device model, such as "Apple iPad Air 2" or "Google Pixel".

             *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

              OS_VERSION

            The operating system version. For example, "10.3.2".

             *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
             ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

              PLATFORM

            The device platform. Valid values are "ANDROID" or "IOS".

             *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

              REMOTE_ACCESS_ENABLED

            Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

              REMOTE_DEBUG_ENABLED

            Whether the device is enabled for remote debugging. Valid values are "TRUE" or "FALSE".

             *Supported operators* : ``EQUALS``

             *This filter will be ignored, as remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

          - **operator** *(string) --*

            Specifies how Device Farm compares the rule's attribute to the value. For the operators
            that are supported by each attribute, see the attribute descriptions.

          - **value** *(string) --*

            The rule's value.

      - **maxDevices** *(integer) --*

        The number of devices that Device Farm can add to your device pool. Device Farm adds
        devices that are available and that meet the criteria that you assign for the ``rules``
        parameter. Depending on how many devices meet these constraints, your device pool might
        contain fewer devices than the value for this parameter.

        By specifying the maximum number of devices, you can control the costs that you incur by
        running tests.
    """


_ClientUpdateDevicePoolrulesTypeDef = TypedDict(
    "_ClientUpdateDevicePoolrulesTypeDef",
    {"attribute": str, "operator": str, "value": str},
    total=False,
)


class ClientUpdateDevicePoolrulesTypeDef(_ClientUpdateDevicePoolrulesTypeDef):
    """
    Type definition for `ClientUpdateDevicePool` `rules`

    Represents a condition for a device pool.

    - **attribute** *(string) --*

      The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

      The supported operators for each attribute are provided in the following list.

        APPIUM_VERSION

      The Appium version for the test.

       *Supported operators* : ``CONTAINS``

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE", "HIGHLY_AVAILABLE",
      "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        MODEL

      The device model, such as "Apple iPad Air 2" or "Google Pixel".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` , ``IN``
       , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

      Whether the device is enabled for remote debugging. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **operator** *(string) --*

      Specifies how Device Farm compares the rule's attribute to the value. For the operators that
      are supported by each attribute, see the attribute descriptions.

    - **value** *(string) --*

      The rule's value.
    """


_ClientUpdateInstanceProfileResponseinstanceProfileTypeDef = TypedDict(
    "_ClientUpdateInstanceProfileResponseinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ClientUpdateInstanceProfileResponseinstanceProfileTypeDef(
    _ClientUpdateInstanceProfileResponseinstanceProfileTypeDef
):
    """
    Type definition for `ClientUpdateInstanceProfileResponse` `instanceProfile`

    An object containing information about your instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The default
      value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned up from
      the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The default
      value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ClientUpdateInstanceProfileResponseTypeDef = TypedDict(
    "_ClientUpdateInstanceProfileResponseTypeDef",
    {"instanceProfile": ClientUpdateInstanceProfileResponseinstanceProfileTypeDef},
    total=False,
)


class ClientUpdateInstanceProfileResponseTypeDef(
    _ClientUpdateInstanceProfileResponseTypeDef
):
    """
    Type definition for `ClientUpdateInstanceProfile` `Response`

    - **instanceProfile** *(dict) --*

      An object containing information about your instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The default
        value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned up from
        the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The default
        value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ClientUpdateNetworkProfileResponsenetworkProfileTypeDef = TypedDict(
    "_ClientUpdateNetworkProfileResponsenetworkProfileTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "uplinkBandwidthBits": int,
        "downlinkBandwidthBits": int,
        "uplinkDelayMs": int,
        "downlinkDelayMs": int,
        "uplinkJitterMs": int,
        "downlinkJitterMs": int,
        "uplinkLossPercent": int,
        "downlinkLossPercent": int,
    },
    total=False,
)


class ClientUpdateNetworkProfileResponsenetworkProfileTypeDef(
    _ClientUpdateNetworkProfileResponsenetworkProfileTypeDef
):
    """
    Type definition for `ClientUpdateNetworkProfileResponse` `networkProfile`

    A list of the available network profiles.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the network profile.

    - **name** *(string) --*

      The name of the network profile.

    - **description** *(string) --*

      The description of the network profile.

    - **type** *(string) --*

      The type of network profile. Valid values are listed below.

    - **uplinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **downlinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **uplinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **downlinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **uplinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **downlinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **uplinkLossPercent** *(integer) --*

      Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

    - **downlinkLossPercent** *(integer) --*

      Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ClientUpdateNetworkProfileResponseTypeDef = TypedDict(
    "_ClientUpdateNetworkProfileResponseTypeDef",
    {"networkProfile": ClientUpdateNetworkProfileResponsenetworkProfileTypeDef},
    total=False,
)


class ClientUpdateNetworkProfileResponseTypeDef(
    _ClientUpdateNetworkProfileResponseTypeDef
):
    """
    Type definition for `ClientUpdateNetworkProfile` `Response`

    - **networkProfile** *(dict) --*

      A list of the available network profiles.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the network profile.

      - **name** *(string) --*

        The name of the network profile.

      - **description** *(string) --*

        The description of the network profile.

      - **type** *(string) --*

        The type of network profile. Valid values are listed below.

      - **uplinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **downlinkBandwidthBits** *(integer) --*

        The data throughput rate in bits per second, as an integer from 0 to 104857600.

      - **uplinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **downlinkDelayMs** *(integer) --*

        Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

      - **uplinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **downlinkJitterMs** *(integer) --*

        Time variation in the delay of received packets in milliseconds as an integer from 0 to
        2000.

      - **uplinkLossPercent** *(integer) --*

        Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

      - **downlinkLossPercent** *(integer) --*

        Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ClientUpdateProjectResponseprojectTypeDef = TypedDict(
    "_ClientUpdateProjectResponseprojectTypeDef",
    {"arn": str, "name": str, "defaultJobTimeoutMinutes": int, "created": datetime},
    total=False,
)


class ClientUpdateProjectResponseprojectTypeDef(
    _ClientUpdateProjectResponseprojectTypeDef
):
    """
    Type definition for `ClientUpdateProjectResponse` `project`

    The project you wish to update.

    - **arn** *(string) --*

      The project's ARN.

    - **name** *(string) --*

      The project's name.

    - **defaultJobTimeoutMinutes** *(integer) --*

      The default number of minutes (at the project level) a test run will execute before it
      times out. The default value is 150 minutes.

    - **created** *(datetime) --*

      When the project was created.
    """


_ClientUpdateProjectResponseTypeDef = TypedDict(
    "_ClientUpdateProjectResponseTypeDef",
    {"project": ClientUpdateProjectResponseprojectTypeDef},
    total=False,
)


class ClientUpdateProjectResponseTypeDef(_ClientUpdateProjectResponseTypeDef):
    """
    Type definition for `ClientUpdateProject` `Response`

    Represents the result of an update project request.

    - **project** *(dict) --*

      The project you wish to update.

      - **arn** *(string) --*

        The project's ARN.

      - **name** *(string) --*

        The project's name.

      - **defaultJobTimeoutMinutes** *(integer) --*

        The default number of minutes (at the project level) a test run will execute before it
        times out. The default value is 150 minutes.

      - **created** *(datetime) --*

        When the project was created.
    """


_ClientUpdateUploadResponseuploadTypeDef = TypedDict(
    "_ClientUpdateUploadResponseuploadTypeDef",
    {
        "arn": str,
        "name": str,
        "created": datetime,
        "type": str,
        "status": str,
        "url": str,
        "metadata": str,
        "contentType": str,
        "message": str,
        "category": str,
    },
    total=False,
)


class ClientUpdateUploadResponseuploadTypeDef(_ClientUpdateUploadResponseuploadTypeDef):
    """
    Type definition for `ClientUpdateUploadResponse` `upload`

    A test spec uploaded to Device Farm.

    - **arn** *(string) --*

      The upload's ARN.

    - **name** *(string) --*

      The upload's file name.

    - **created** *(datetime) --*

      When the upload was created.

    - **type** *(string) --*

      The upload's type.

      Must be one of the following values:

      * ANDROID_APP: An Android upload.

      * IOS_APP: An iOS upload.

      * WEB_APP: A web application upload.

      * EXTERNAL_DATA: An external data upload.

      * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.

      * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.

      * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.

      * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.

      * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.

      * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for web apps.

      * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for web
      apps.

      * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for web apps.

      * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for web apps.

      * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for web apps.

      * CALABASH_TEST_PACKAGE: A Calabash test package upload.

      * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.

      * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.

      * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.

      * XCTEST_TEST_PACKAGE: An Xcode test package upload.

      * XCTEST_UI_TEST_PACKAGE: An Xcode UI test package upload.

      * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.

      * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.

      * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.

      * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.

      * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.

      * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.

      * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.

      * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.

      * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.

      * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.

      * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.

      * XCTEST_UI_TEST_SPEC: An Xcode UI test spec upload.

    - **status** *(string) --*

      The upload's status.

      Must be one of the following values:

      * FAILED: A failed status.

      * INITIALIZED: An initialized status.

      * PROCESSING: A processing status.

      * SUCCEEDED: A succeeded status.

    - **url** *(string) --*

      The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT
      request.

    - **metadata** *(string) --*

      The upload's metadata. For example, for Android, this contains information that is parsed
      from the manifest and is displayed in the AWS Device Farm console after the associated app
      is uploaded.

    - **contentType** *(string) --*

      The upload's content type (for example, "application/octet-stream").

    - **message** *(string) --*

      A message about the upload's result.

    - **category** *(string) --*

      The upload's category. Allowed values include:

      * CURATED: An upload managed by AWS Device Farm.

      * PRIVATE: An upload managed by the AWS Device Farm customer.
    """


_ClientUpdateUploadResponseTypeDef = TypedDict(
    "_ClientUpdateUploadResponseTypeDef",
    {"upload": ClientUpdateUploadResponseuploadTypeDef},
    total=False,
)


class ClientUpdateUploadResponseTypeDef(_ClientUpdateUploadResponseTypeDef):
    """
    Type definition for `ClientUpdateUpload` `Response`

    - **upload** *(dict) --*

      A test spec uploaded to Device Farm.

      - **arn** *(string) --*

        The upload's ARN.

      - **name** *(string) --*

        The upload's file name.

      - **created** *(datetime) --*

        When the upload was created.

      - **type** *(string) --*

        The upload's type.

        Must be one of the following values:

        * ANDROID_APP: An Android upload.

        * IOS_APP: An iOS upload.

        * WEB_APP: A web application upload.

        * EXTERNAL_DATA: An external data upload.

        * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.

        * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.

        * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.

        * APPIUM_NODE_TEST_PACKAGE: An Appium Node.js test package upload.

        * APPIUM_RUBY_TEST_PACKAGE: An Appium Ruby test package upload.

        * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload for web apps.

        * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload for web
        apps.

        * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload for web apps.

        * APPIUM_WEB_NODE_TEST_PACKAGE: An Appium Node.js test package upload for web apps.

        * APPIUM_WEB_RUBY_TEST_PACKAGE: An Appium Ruby test package upload for web apps.

        * CALABASH_TEST_PACKAGE: A Calabash test package upload.

        * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.

        * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.

        * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.

        * XCTEST_TEST_PACKAGE: An Xcode test package upload.

        * XCTEST_UI_TEST_PACKAGE: An Xcode UI test package upload.

        * APPIUM_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload.

        * APPIUM_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload.

        * APPIUM_PYTHON_TEST_SPEC: An Appium Python test spec upload.

        * APPIUM_NODE_TEST_SPEC: An Appium Node.js test spec upload.

        * APPIUM_RUBY_TEST_SPEC: An Appium Ruby test spec upload.

        * APPIUM_WEB_JAVA_JUNIT_TEST_SPEC: An Appium Java JUnit test spec upload for a web app.

        * APPIUM_WEB_JAVA_TESTNG_TEST_SPEC: An Appium Java TestNG test spec upload for a web app.

        * APPIUM_WEB_PYTHON_TEST_SPEC: An Appium Python test spec upload for a web app.

        * APPIUM_WEB_NODE_TEST_SPEC: An Appium Node.js test spec upload for a web app.

        * APPIUM_WEB_RUBY_TEST_SPEC: An Appium Ruby test spec upload for a web app.

        * INSTRUMENTATION_TEST_SPEC: An instrumentation test spec upload.

        * XCTEST_UI_TEST_SPEC: An Xcode UI test spec upload.

      - **status** *(string) --*

        The upload's status.

        Must be one of the following values:

        * FAILED: A failed status.

        * INITIALIZED: An initialized status.

        * PROCESSING: A processing status.

        * SUCCEEDED: A succeeded status.

      - **url** *(string) --*

        The pre-signed Amazon S3 URL that was used to store a file through a corresponding PUT
        request.

      - **metadata** *(string) --*

        The upload's metadata. For example, for Android, this contains information that is parsed
        from the manifest and is displayed in the AWS Device Farm console after the associated app
        is uploaded.

      - **contentType** *(string) --*

        The upload's content type (for example, "application/octet-stream").

      - **message** *(string) --*

        A message about the upload's result.

      - **category** *(string) --*

        The upload's category. Allowed values include:

        * CURATED: An upload managed by AWS Device Farm.

        * PRIVATE: An upload managed by the AWS Device Farm customer.
    """


_ClientUpdateVpceConfigurationResponsevpceConfigurationTypeDef = TypedDict(
    "_ClientUpdateVpceConfigurationResponsevpceConfigurationTypeDef",
    {
        "arn": str,
        "vpceConfigurationName": str,
        "vpceServiceName": str,
        "serviceDnsName": str,
        "vpceConfigurationDescription": str,
    },
    total=False,
)


class ClientUpdateVpceConfigurationResponsevpceConfigurationTypeDef(
    _ClientUpdateVpceConfigurationResponsevpceConfigurationTypeDef
):
    """
    Type definition for `ClientUpdateVpceConfigurationResponse` `vpceConfiguration`

    An object containing information about your VPC endpoint configuration.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the VPC endpoint configuration.

    - **vpceConfigurationName** *(string) --*

      The friendly name you give to your VPC endpoint configuration, to manage your
      configurations more easily.

    - **vpceServiceName** *(string) --*

      The name of the VPC endpoint service running inside your AWS account that you want Device
      Farm to test.

    - **serviceDnsName** *(string) --*

      The DNS name that maps to the private IP address of the service you want to access.

    - **vpceConfigurationDescription** *(string) --*

      An optional description, providing more details about your VPC endpoint configuration.
    """


_ClientUpdateVpceConfigurationResponseTypeDef = TypedDict(
    "_ClientUpdateVpceConfigurationResponseTypeDef",
    {
        "vpceConfiguration": ClientUpdateVpceConfigurationResponsevpceConfigurationTypeDef
    },
    total=False,
)


class ClientUpdateVpceConfigurationResponseTypeDef(
    _ClientUpdateVpceConfigurationResponseTypeDef
):
    """
    Type definition for `ClientUpdateVpceConfiguration` `Response`

    - **vpceConfiguration** *(dict) --*

      An object containing information about your VPC endpoint configuration.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the VPC endpoint configuration.

      - **vpceConfigurationName** *(string) --*

        The friendly name you give to your VPC endpoint configuration, to manage your
        configurations more easily.

      - **vpceServiceName** *(string) --*

        The name of the VPC endpoint service running inside your AWS account that you want Device
        Farm to test.

      - **serviceDnsName** *(string) --*

        The DNS name that maps to the private IP address of the service you want to access.

      - **vpceConfigurationDescription** *(string) --*

        An optional description, providing more details about your VPC endpoint configuration.
    """


_GetOfferingStatusPaginatePaginationConfigTypeDef = TypedDict(
    "_GetOfferingStatusPaginatePaginationConfigTypeDef",
    {"MaxItems": int, "StartingToken": str},
    total=False,
)


class GetOfferingStatusPaginatePaginationConfigTypeDef(
    _GetOfferingStatusPaginatePaginationConfigTypeDef
):
    """
    Type definition for `GetOfferingStatusPaginate` `PaginationConfig`

    A dictionary that provides parameters to control pagination.

    - **MaxItems** *(integer) --*

      The total number of items to return. If the total number of items available is more than the
      value specified in max-items then a ``NextToken`` will be provided in the output that you can
      use to resume pagination.

    - **StartingToken** *(string) --*

      A token to specify where to start paginating. This is the ``NextToken`` from a previous
      response.
    """


_GetOfferingStatusPaginateResponsecurrentofferingrecurringChargescostTypeDef = TypedDict(
    "_GetOfferingStatusPaginateResponsecurrentofferingrecurringChargescostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class GetOfferingStatusPaginateResponsecurrentofferingrecurringChargescostTypeDef(
    _GetOfferingStatusPaginateResponsecurrentofferingrecurringChargescostTypeDef
):
    """
    Type definition for `GetOfferingStatusPaginateResponsecurrentofferingrecurringCharges` `cost`

    The cost of the recurring charge.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S.
      dollars."
    """


_GetOfferingStatusPaginateResponsecurrentofferingrecurringChargesTypeDef = TypedDict(
    "_GetOfferingStatusPaginateResponsecurrentofferingrecurringChargesTypeDef",
    {
        "cost": GetOfferingStatusPaginateResponsecurrentofferingrecurringChargescostTypeDef,
        "frequency": str,
    },
    total=False,
)


class GetOfferingStatusPaginateResponsecurrentofferingrecurringChargesTypeDef(
    _GetOfferingStatusPaginateResponsecurrentofferingrecurringChargesTypeDef
):
    """
    Type definition for `GetOfferingStatusPaginateResponsecurrentoffering` `recurringCharges`

    Specifies whether charges for devices will be recurring.

    - **cost** *(dict) --*

      The cost of the recurring charge.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S.
        dollars."

    - **frequency** *(string) --*

      The frequency in which charges will recur.
    """


_GetOfferingStatusPaginateResponsecurrentofferingTypeDef = TypedDict(
    "_GetOfferingStatusPaginateResponsecurrentofferingTypeDef",
    {
        "id": str,
        "description": str,
        "type": str,
        "platform": str,
        "recurringCharges": List[
            GetOfferingStatusPaginateResponsecurrentofferingrecurringChargesTypeDef
        ],
    },
    total=False,
)


class GetOfferingStatusPaginateResponsecurrentofferingTypeDef(
    _GetOfferingStatusPaginateResponsecurrentofferingTypeDef
):
    """
    Type definition for `GetOfferingStatusPaginateResponsecurrent` `offering`

    Represents the metadata of an offering status.

    - **id** *(string) --*

      The ID that corresponds to a device offering.

    - **description** *(string) --*

      A string describing the offering.

    - **type** *(string) --*

      The type of offering (e.g., "RECURRING") for a device.

    - **platform** *(string) --*

      The platform of the device (e.g., ANDROID or IOS).

    - **recurringCharges** *(list) --*

      Specifies whether there are recurring charges for the offering.

      - *(dict) --*

        Specifies whether charges for devices will be recurring.

        - **cost** *(dict) --*

          The cost of the recurring charge.

          - **amount** *(float) --*

            The numerical amount of an offering or transaction.

          - **currencyCode** *(string) --*

            The currency code of a monetary amount. For example, ``USD`` means "U.S.
            dollars."

        - **frequency** *(string) --*

          The frequency in which charges will recur.
    """


_GetOfferingStatusPaginateResponsecurrentTypeDef = TypedDict(
    "_GetOfferingStatusPaginateResponsecurrentTypeDef",
    {
        "type": str,
        "offering": GetOfferingStatusPaginateResponsecurrentofferingTypeDef,
        "quantity": int,
        "effectiveOn": datetime,
    },
    total=False,
)


class GetOfferingStatusPaginateResponsecurrentTypeDef(
    _GetOfferingStatusPaginateResponsecurrentTypeDef
):
    """
    Type definition for `GetOfferingStatusPaginateResponse` `current`

    The status of the offering.

    - **type** *(string) --*

      The type specified for the offering status.

    - **offering** *(dict) --*

      Represents the metadata of an offering status.

      - **id** *(string) --*

        The ID that corresponds to a device offering.

      - **description** *(string) --*

        A string describing the offering.

      - **type** *(string) --*

        The type of offering (e.g., "RECURRING") for a device.

      - **platform** *(string) --*

        The platform of the device (e.g., ANDROID or IOS).

      - **recurringCharges** *(list) --*

        Specifies whether there are recurring charges for the offering.

        - *(dict) --*

          Specifies whether charges for devices will be recurring.

          - **cost** *(dict) --*

            The cost of the recurring charge.

            - **amount** *(float) --*

              The numerical amount of an offering or transaction.

            - **currencyCode** *(string) --*

              The currency code of a monetary amount. For example, ``USD`` means "U.S.
              dollars."

          - **frequency** *(string) --*

            The frequency in which charges will recur.

    - **quantity** *(integer) --*

      The number of available devices in the offering.

    - **effectiveOn** *(datetime) --*

      The date on which the offering is effective.
    """


_GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargescostTypeDef = TypedDict(
    "_GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargescostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargescostTypeDef(
    _GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargescostTypeDef
):
    """
    Type definition for `GetOfferingStatusPaginateResponsenextPeriodofferingrecurringCharges` `cost`

    The cost of the recurring charge.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S.
      dollars."
    """


_GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargesTypeDef = TypedDict(
    "_GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargesTypeDef",
    {
        "cost": GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargescostTypeDef,
        "frequency": str,
    },
    total=False,
)


class GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargesTypeDef(
    _GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargesTypeDef
):
    """
    Type definition for `GetOfferingStatusPaginateResponsenextPeriodoffering` `recurringCharges`

    Specifies whether charges for devices will be recurring.

    - **cost** *(dict) --*

      The cost of the recurring charge.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S.
        dollars."

    - **frequency** *(string) --*

      The frequency in which charges will recur.
    """


_GetOfferingStatusPaginateResponsenextPeriodofferingTypeDef = TypedDict(
    "_GetOfferingStatusPaginateResponsenextPeriodofferingTypeDef",
    {
        "id": str,
        "description": str,
        "type": str,
        "platform": str,
        "recurringCharges": List[
            GetOfferingStatusPaginateResponsenextPeriodofferingrecurringChargesTypeDef
        ],
    },
    total=False,
)


class GetOfferingStatusPaginateResponsenextPeriodofferingTypeDef(
    _GetOfferingStatusPaginateResponsenextPeriodofferingTypeDef
):
    """
    Type definition for `GetOfferingStatusPaginateResponsenextPeriod` `offering`

    Represents the metadata of an offering status.

    - **id** *(string) --*

      The ID that corresponds to a device offering.

    - **description** *(string) --*

      A string describing the offering.

    - **type** *(string) --*

      The type of offering (e.g., "RECURRING") for a device.

    - **platform** *(string) --*

      The platform of the device (e.g., ANDROID or IOS).

    - **recurringCharges** *(list) --*

      Specifies whether there are recurring charges for the offering.

      - *(dict) --*

        Specifies whether charges for devices will be recurring.

        - **cost** *(dict) --*

          The cost of the recurring charge.

          - **amount** *(float) --*

            The numerical amount of an offering or transaction.

          - **currencyCode** *(string) --*

            The currency code of a monetary amount. For example, ``USD`` means "U.S.
            dollars."

        - **frequency** *(string) --*

          The frequency in which charges will recur.
    """


_GetOfferingStatusPaginateResponsenextPeriodTypeDef = TypedDict(
    "_GetOfferingStatusPaginateResponsenextPeriodTypeDef",
    {
        "type": str,
        "offering": GetOfferingStatusPaginateResponsenextPeriodofferingTypeDef,
        "quantity": int,
        "effectiveOn": datetime,
    },
    total=False,
)


class GetOfferingStatusPaginateResponsenextPeriodTypeDef(
    _GetOfferingStatusPaginateResponsenextPeriodTypeDef
):
    """
    Type definition for `GetOfferingStatusPaginateResponse` `nextPeriod`

    The status of the offering.

    - **type** *(string) --*

      The type specified for the offering status.

    - **offering** *(dict) --*

      Represents the metadata of an offering status.

      - **id** *(string) --*

        The ID that corresponds to a device offering.

      - **description** *(string) --*

        A string describing the offering.

      - **type** *(string) --*

        The type of offering (e.g., "RECURRING") for a device.

      - **platform** *(string) --*

        The platform of the device (e.g., ANDROID or IOS).

      - **recurringCharges** *(list) --*

        Specifies whether there are recurring charges for the offering.

        - *(dict) --*

          Specifies whether charges for devices will be recurring.

          - **cost** *(dict) --*

            The cost of the recurring charge.

            - **amount** *(float) --*

              The numerical amount of an offering or transaction.

            - **currencyCode** *(string) --*

              The currency code of a monetary amount. For example, ``USD`` means "U.S.
              dollars."

          - **frequency** *(string) --*

            The frequency in which charges will recur.

    - **quantity** *(integer) --*

      The number of available devices in the offering.

    - **effectiveOn** *(datetime) --*

      The date on which the offering is effective.
    """


_GetOfferingStatusPaginateResponseTypeDef = TypedDict(
    "_GetOfferingStatusPaginateResponseTypeDef",
    {
        "current": Dict[str, GetOfferingStatusPaginateResponsecurrentTypeDef],
        "nextPeriod": Dict[str, GetOfferingStatusPaginateResponsenextPeriodTypeDef],
        "NextToken": str,
    },
    total=False,
)


class GetOfferingStatusPaginateResponseTypeDef(
    _GetOfferingStatusPaginateResponseTypeDef
):
    """
    Type definition for `GetOfferingStatusPaginate` `Response`

    Returns the status result for a device offering.

    - **current** *(dict) --*

      When specified, gets the offering status for the current period.

      - *(string) --*

        - *(dict) --*

          The status of the offering.

          - **type** *(string) --*

            The type specified for the offering status.

          - **offering** *(dict) --*

            Represents the metadata of an offering status.

            - **id** *(string) --*

              The ID that corresponds to a device offering.

            - **description** *(string) --*

              A string describing the offering.

            - **type** *(string) --*

              The type of offering (e.g., "RECURRING") for a device.

            - **platform** *(string) --*

              The platform of the device (e.g., ANDROID or IOS).

            - **recurringCharges** *(list) --*

              Specifies whether there are recurring charges for the offering.

              - *(dict) --*

                Specifies whether charges for devices will be recurring.

                - **cost** *(dict) --*

                  The cost of the recurring charge.

                  - **amount** *(float) --*

                    The numerical amount of an offering or transaction.

                  - **currencyCode** *(string) --*

                    The currency code of a monetary amount. For example, ``USD`` means "U.S.
                    dollars."

                - **frequency** *(string) --*

                  The frequency in which charges will recur.

          - **quantity** *(integer) --*

            The number of available devices in the offering.

          - **effectiveOn** *(datetime) --*

            The date on which the offering is effective.

    - **nextPeriod** *(dict) --*

      When specified, gets the offering status for the next period.

      - *(string) --*

        - *(dict) --*

          The status of the offering.

          - **type** *(string) --*

            The type specified for the offering status.

          - **offering** *(dict) --*

            Represents the metadata of an offering status.

            - **id** *(string) --*

              The ID that corresponds to a device offering.

            - **description** *(string) --*

              A string describing the offering.

            - **type** *(string) --*

              The type of offering (e.g., "RECURRING") for a device.

            - **platform** *(string) --*

              The platform of the device (e.g., ANDROID or IOS).

            - **recurringCharges** *(list) --*

              Specifies whether there are recurring charges for the offering.

              - *(dict) --*

                Specifies whether charges for devices will be recurring.

                - **cost** *(dict) --*

                  The cost of the recurring charge.

                  - **amount** *(float) --*

                    The numerical amount of an offering or transaction.

                  - **currencyCode** *(string) --*

                    The currency code of a monetary amount. For example, ``USD`` means "U.S.
                    dollars."

                - **frequency** *(string) --*

                  The frequency in which charges will recur.

          - **quantity** *(integer) --*

            The number of available devices in the offering.

          - **effectiveOn** *(datetime) --*

            The date on which the offering is effective.

    - **NextToken** *(string) --*

      A token to resume pagination.
    """


_ListArtifactsPaginatePaginationConfigTypeDef = TypedDict(
    "_ListArtifactsPaginatePaginationConfigTypeDef",
    {"MaxItems": int, "StartingToken": str},
    total=False,
)


class ListArtifactsPaginatePaginationConfigTypeDef(
    _ListArtifactsPaginatePaginationConfigTypeDef
):
    """
    Type definition for `ListArtifactsPaginate` `PaginationConfig`

    A dictionary that provides parameters to control pagination.

    - **MaxItems** *(integer) --*

      The total number of items to return. If the total number of items available is more than the
      value specified in max-items then a ``NextToken`` will be provided in the output that you can
      use to resume pagination.

    - **StartingToken** *(string) --*

      A token to specify where to start paginating. This is the ``NextToken`` from a previous
      response.
    """


_ListArtifactsPaginateResponseartifactsTypeDef = TypedDict(
    "_ListArtifactsPaginateResponseartifactsTypeDef",
    {"arn": str, "name": str, "type": str, "extension": str, "url": str},
    total=False,
)


class ListArtifactsPaginateResponseartifactsTypeDef(
    _ListArtifactsPaginateResponseartifactsTypeDef
):
    """
    Type definition for `ListArtifactsPaginateResponse` `artifacts`

    Represents the output of a test. Examples of artifacts include logs and screenshots.

    - **arn** *(string) --*

      The artifact's ARN.

    - **name** *(string) --*

      The artifact's name.

    - **type** *(string) --*

      The artifact's type.

      Allowed values include the following:

      * UNKNOWN: An unknown type.

      * SCREENSHOT: The screenshot type.

      * DEVICE_LOG: The device log type.

      * MESSAGE_LOG: The message log type.

      * VIDEO_LOG: The video log type.

      * RESULT_LOG: The result log type.

      * SERVICE_LOG: The service log type.

      * WEBKIT_LOG: The web kit log type.

      * INSTRUMENTATION_OUTPUT: The instrumentation type.

      * EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz
      test.

      * CALABASH_JSON_OUTPUT: The Calabash JSON output type.

      * CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.

      * CALABASH_STANDARD_OUTPUT: The Calabash standard output type.

      * CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.

      * AUTOMATION_OUTPUT: The automation output type.

      * APPIUM_SERVER_OUTPUT: The Appium server output type.

      * APPIUM_JAVA_OUTPUT: The Appium Java output type.

      * APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.

      * APPIUM_PYTHON_OUTPUT: The Appium Python output type.

      * APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.

      * EXPLORER_EVENT_LOG: The Explorer event log output type.

      * EXPLORER_SUMMARY_LOG: The Explorer summary log output type.

      * APPLICATION_CRASH_REPORT: The application crash report output type.

      * XCTEST_LOG: The Xcode test output type.

      * VIDEO: The Video output type.

      * CUSTOMER_ARTIFACT:The Customer Artifact output type.

      * CUSTOMER_ARTIFACT_LOG: The Customer Artifact Log output type.

      * TESTSPEC_OUTPUT: The Test Spec Output type.

    - **extension** *(string) --*

      The artifact's file extension.

    - **url** *(string) --*

      The pre-signed Amazon S3 URL that can be used with a corresponding GET request to
      download the artifact's file.
    """


_ListArtifactsPaginateResponseTypeDef = TypedDict(
    "_ListArtifactsPaginateResponseTypeDef",
    {
        "artifacts": List[ListArtifactsPaginateResponseartifactsTypeDef],
        "NextToken": str,
    },
    total=False,
)


class ListArtifactsPaginateResponseTypeDef(_ListArtifactsPaginateResponseTypeDef):
    """
    Type definition for `ListArtifactsPaginate` `Response`

    Represents the result of a list artifacts operation.

    - **artifacts** *(list) --*

      Information about the artifacts.

      - *(dict) --*

        Represents the output of a test. Examples of artifacts include logs and screenshots.

        - **arn** *(string) --*

          The artifact's ARN.

        - **name** *(string) --*

          The artifact's name.

        - **type** *(string) --*

          The artifact's type.

          Allowed values include the following:

          * UNKNOWN: An unknown type.

          * SCREENSHOT: The screenshot type.

          * DEVICE_LOG: The device log type.

          * MESSAGE_LOG: The message log type.

          * VIDEO_LOG: The video log type.

          * RESULT_LOG: The result log type.

          * SERVICE_LOG: The service log type.

          * WEBKIT_LOG: The web kit log type.

          * INSTRUMENTATION_OUTPUT: The instrumentation type.

          * EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an Android fuzz
          test.

          * CALABASH_JSON_OUTPUT: The Calabash JSON output type.

          * CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.

          * CALABASH_STANDARD_OUTPUT: The Calabash standard output type.

          * CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.

          * AUTOMATION_OUTPUT: The automation output type.

          * APPIUM_SERVER_OUTPUT: The Appium server output type.

          * APPIUM_JAVA_OUTPUT: The Appium Java output type.

          * APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.

          * APPIUM_PYTHON_OUTPUT: The Appium Python output type.

          * APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.

          * EXPLORER_EVENT_LOG: The Explorer event log output type.

          * EXPLORER_SUMMARY_LOG: The Explorer summary log output type.

          * APPLICATION_CRASH_REPORT: The application crash report output type.

          * XCTEST_LOG: The Xcode test output type.

          * VIDEO: The Video output type.

          * CUSTOMER_ARTIFACT:The Customer Artifact output type.

          * CUSTOMER_ARTIFACT_LOG: The Customer Artifact Log output type.

          * TESTSPEC_OUTPUT: The Test Spec Output type.

        - **extension** *(string) --*

          The artifact's file extension.

        - **url** *(string) --*

          The pre-signed Amazon S3 URL that can be used with a corresponding GET request to
          download the artifact's file.

    - **NextToken** *(string) --*

      A token to resume pagination.
    """


_ListDeviceInstancesPaginatePaginationConfigTypeDef = TypedDict(
    "_ListDeviceInstancesPaginatePaginationConfigTypeDef",
    {"MaxItems": int, "PageSize": int, "StartingToken": str},
    total=False,
)


class ListDeviceInstancesPaginatePaginationConfigTypeDef(
    _ListDeviceInstancesPaginatePaginationConfigTypeDef
):
    """
    Type definition for `ListDeviceInstancesPaginate` `PaginationConfig`

    A dictionary that provides parameters to control pagination.

    - **MaxItems** *(integer) --*

      The total number of items to return. If the total number of items available is more than the
      value specified in max-items then a ``NextToken`` will be provided in the output that you can
      use to resume pagination.

    - **PageSize** *(integer) --*

      The size of each page.

    - **StartingToken** *(string) --*

      A token to specify where to start paginating. This is the ``NextToken`` from a previous
      response.
    """


_ListDeviceInstancesPaginateResponsedeviceInstancesinstanceProfileTypeDef = TypedDict(
    "_ListDeviceInstancesPaginateResponsedeviceInstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ListDeviceInstancesPaginateResponsedeviceInstancesinstanceProfileTypeDef(
    _ListDeviceInstancesPaginateResponsedeviceInstancesinstanceProfileTypeDef
):
    """
    Type definition for `ListDeviceInstancesPaginateResponsedeviceInstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned up
      from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ListDeviceInstancesPaginateResponsedeviceInstancesTypeDef = TypedDict(
    "_ListDeviceInstancesPaginateResponsedeviceInstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ListDeviceInstancesPaginateResponsedeviceInstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ListDeviceInstancesPaginateResponsedeviceInstancesTypeDef(
    _ListDeviceInstancesPaginateResponsedeviceInstancesTypeDef
):
    """
    Type definition for `ListDeviceInstancesPaginateResponse` `deviceInstances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned up
        from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ListDeviceInstancesPaginateResponseTypeDef = TypedDict(
    "_ListDeviceInstancesPaginateResponseTypeDef",
    {
        "deviceInstances": List[
            ListDeviceInstancesPaginateResponsedeviceInstancesTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)


class ListDeviceInstancesPaginateResponseTypeDef(
    _ListDeviceInstancesPaginateResponseTypeDef
):
    """
    Type definition for `ListDeviceInstancesPaginate` `Response`

    - **deviceInstances** *(list) --*

      An object containing information about your device instances.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be cleaned up
            from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **NextToken** *(string) --*

      A token to resume pagination.
    """


_ListDevicePoolsPaginatePaginationConfigTypeDef = TypedDict(
    "_ListDevicePoolsPaginatePaginationConfigTypeDef",
    {"MaxItems": int, "StartingToken": str},
    total=False,
)


class ListDevicePoolsPaginatePaginationConfigTypeDef(
    _ListDevicePoolsPaginatePaginationConfigTypeDef
):
    """
    Type definition for `ListDevicePoolsPaginate` `PaginationConfig`

    A dictionary that provides parameters to control pagination.

    - **MaxItems** *(integer) --*

      The total number of items to return. If the total number of items available is more than the
      value specified in max-items then a ``NextToken`` will be provided in the output that you can
      use to resume pagination.

    - **StartingToken** *(string) --*

      A token to specify where to start paginating. This is the ``NextToken`` from a previous
      response.
    """


_ListDevicePoolsPaginateResponsedevicePoolsrulesTypeDef = TypedDict(
    "_ListDevicePoolsPaginateResponsedevicePoolsrulesTypeDef",
    {"attribute": str, "operator": str, "value": str},
    total=False,
)


class ListDevicePoolsPaginateResponsedevicePoolsrulesTypeDef(
    _ListDevicePoolsPaginateResponsedevicePoolsrulesTypeDef
):
    """
    Type definition for `ListDevicePoolsPaginateResponsedevicePools` `rules`

    Represents a condition for a device pool.

    - **attribute** *(string) --*

      The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

      The supported operators for each attribute are provided in the following list.

        APPIUM_VERSION

      The Appium version for the test.

       *Supported operators* : ``CONTAINS``

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE",
      "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        MODEL

      The device model, such as "Apple iPad Air 2" or "Google Pixel".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
       ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

      Whether the device is enabled for remote debugging. Valid values are "TRUE" or
      "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **operator** *(string) --*

      Specifies how Device Farm compares the rule's attribute to the value. For the
      operators that are supported by each attribute, see the attribute descriptions.

    - **value** *(string) --*

      The rule's value.
    """


_ListDevicePoolsPaginateResponsedevicePoolsTypeDef = TypedDict(
    "_ListDevicePoolsPaginateResponsedevicePoolsTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "rules": List[ListDevicePoolsPaginateResponsedevicePoolsrulesTypeDef],
        "maxDevices": int,
    },
    total=False,
)


class ListDevicePoolsPaginateResponsedevicePoolsTypeDef(
    _ListDevicePoolsPaginateResponsedevicePoolsTypeDef
):
    """
    Type definition for `ListDevicePoolsPaginateResponse` `devicePools`

    Represents a collection of device types.

    - **arn** *(string) --*

      The device pool's ARN.

    - **name** *(string) --*

      The device pool's name.

    - **description** *(string) --*

      The device pool's description.

    - **type** *(string) --*

      The device pool's type.

      Allowed values include:

      * CURATED: A device pool that is created and managed by AWS Device Farm.

      * PRIVATE: A device pool that is created and managed by the device pool developer.

    - **rules** *(list) --*

      Information about the device pool's rules.

      - *(dict) --*

        Represents a condition for a device pool.

        - **attribute** *(string) --*

          The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

          The supported operators for each attribute are provided in the following list.

            APPIUM_VERSION

          The Appium version for the test.

           *Supported operators* : ``CONTAINS``

            ARN

          The Amazon Resource Name (ARN) of the device. For example,
          "arn:aws:devicefarm:us-west-2::device:12345Example".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            AVAILABILITY

          The current availability of the device. Valid values are "AVAILABLE",
          "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

           *Supported operators* : ``EQUALS``

            FLEET_TYPE

          The fleet type. Valid values are "PUBLIC" or "PRIVATE".

           *Supported operators* : ``EQUALS``

            FORM_FACTOR

          The device form factor. Valid values are "PHONE" or "TABLET".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            INSTANCE_ARN

          The Amazon Resource Name (ARN) of the device instance.

           *Supported operators* : ``IN`` , ``NOT_IN``

            INSTANCE_LABELS

          The label of the device instance.

           *Supported operators* : ``CONTAINS``

            MANUFACTURER

          The device manufacturer. For example, "Apple".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            MODEL

          The device model, such as "Apple iPad Air 2" or "Google Pixel".

           *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

            OS_VERSION

          The operating system version. For example, "10.3.2".

           *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
           ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

            PLATFORM

          The device platform. Valid values are "ANDROID" or "IOS".

           *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

            REMOTE_ACCESS_ENABLED

          Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

           *Supported operators* : ``EQUALS``

            REMOTE_DEBUG_ENABLED

          Whether the device is enabled for remote debugging. Valid values are "TRUE" or
          "FALSE".

           *Supported operators* : ``EQUALS``

           *This filter will be ignored, as remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **operator** *(string) --*

          Specifies how Device Farm compares the rule's attribute to the value. For the
          operators that are supported by each attribute, see the attribute descriptions.

        - **value** *(string) --*

          The rule's value.

    - **maxDevices** *(integer) --*

      The number of devices that Device Farm can add to your device pool. Device Farm adds
      devices that are available and that meet the criteria that you assign for the ``rules``
      parameter. Depending on how many devices meet these constraints, your device pool might
      contain fewer devices than the value for this parameter.

      By specifying the maximum number of devices, you can control the costs that you incur by
      running tests.
    """


_ListDevicePoolsPaginateResponseTypeDef = TypedDict(
    "_ListDevicePoolsPaginateResponseTypeDef",
    {
        "devicePools": List[ListDevicePoolsPaginateResponsedevicePoolsTypeDef],
        "NextToken": str,
    },
    total=False,
)


class ListDevicePoolsPaginateResponseTypeDef(_ListDevicePoolsPaginateResponseTypeDef):
    """
    Type definition for `ListDevicePoolsPaginate` `Response`

    Represents the result of a list device pools request.

    - **devicePools** *(list) --*

      Information about the device pools.

      - *(dict) --*

        Represents a collection of device types.

        - **arn** *(string) --*

          The device pool's ARN.

        - **name** *(string) --*

          The device pool's name.

        - **description** *(string) --*

          The device pool's description.

        - **type** *(string) --*

          The device pool's type.

          Allowed values include:

          * CURATED: A device pool that is created and managed by AWS Device Farm.

          * PRIVATE: A device pool that is created and managed by the device pool developer.

        - **rules** *(list) --*

          Information about the device pool's rules.

          - *(dict) --*

            Represents a condition for a device pool.

            - **attribute** *(string) --*

              The rule's stringified attribute. For example, specify the value as ``"\\"abc\\""`` .

              The supported operators for each attribute are provided in the following list.

                APPIUM_VERSION

              The Appium version for the test.

               *Supported operators* : ``CONTAINS``

                ARN

              The Amazon Resource Name (ARN) of the device. For example,
              "arn:aws:devicefarm:us-west-2::device:12345Example".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                AVAILABILITY

              The current availability of the device. Valid values are "AVAILABLE",
              "HIGHLY_AVAILABLE", "BUSY", or "TEMPORARY_NOT_AVAILABLE".

               *Supported operators* : ``EQUALS``

                FLEET_TYPE

              The fleet type. Valid values are "PUBLIC" or "PRIVATE".

               *Supported operators* : ``EQUALS``

                FORM_FACTOR

              The device form factor. Valid values are "PHONE" or "TABLET".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                INSTANCE_ARN

              The Amazon Resource Name (ARN) of the device instance.

               *Supported operators* : ``IN`` , ``NOT_IN``

                INSTANCE_LABELS

              The label of the device instance.

               *Supported operators* : ``CONTAINS``

                MANUFACTURER

              The device manufacturer. For example, "Apple".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                MODEL

              The device model, such as "Apple iPad Air 2" or "Google Pixel".

               *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

                OS_VERSION

              The operating system version. For example, "10.3.2".

               *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` ,
               ``IN`` , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

                PLATFORM

              The device platform. Valid values are "ANDROID" or "IOS".

               *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

                REMOTE_ACCESS_ENABLED

              Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

               *Supported operators* : ``EQUALS``

                REMOTE_DEBUG_ENABLED

              Whether the device is enabled for remote debugging. Valid values are "TRUE" or
              "FALSE".

               *Supported operators* : ``EQUALS``

               *This filter will be ignored, as remote debugging is `no longer supported
               <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

            - **operator** *(string) --*

              Specifies how Device Farm compares the rule's attribute to the value. For the
              operators that are supported by each attribute, see the attribute descriptions.

            - **value** *(string) --*

              The rule's value.

        - **maxDevices** *(integer) --*

          The number of devices that Device Farm can add to your device pool. Device Farm adds
          devices that are available and that meet the criteria that you assign for the ``rules``
          parameter. Depending on how many devices meet these constraints, your device pool might
          contain fewer devices than the value for this parameter.

          By specifying the maximum number of devices, you can control the costs that you incur by
          running tests.

    - **NextToken** *(string) --*

      A token to resume pagination.
    """


_ListDevicesPaginatePaginationConfigTypeDef = TypedDict(
    "_ListDevicesPaginatePaginationConfigTypeDef",
    {"MaxItems": int, "StartingToken": str},
    total=False,
)


class ListDevicesPaginatePaginationConfigTypeDef(
    _ListDevicesPaginatePaginationConfigTypeDef
):
    """
    Type definition for `ListDevicesPaginate` `PaginationConfig`

    A dictionary that provides parameters to control pagination.

    - **MaxItems** *(integer) --*

      The total number of items to return. If the total number of items available is more than the
      value specified in max-items then a ``NextToken`` will be provided in the output that you can
      use to resume pagination.

    - **StartingToken** *(string) --*

      A token to specify where to start paginating. This is the ``NextToken`` from a previous
      response.
    """


_ListDevicesPaginateResponsedevicescpuTypeDef = TypedDict(
    "_ListDevicesPaginateResponsedevicescpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ListDevicesPaginateResponsedevicescpuTypeDef(
    _ListDevicesPaginateResponsedevicescpuTypeDef
):
    """
    Type definition for `ListDevicesPaginateResponsedevices` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ListDevicesPaginateResponsedevicesinstancesinstanceProfileTypeDef = TypedDict(
    "_ListDevicesPaginateResponsedevicesinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ListDevicesPaginateResponsedevicesinstancesinstanceProfileTypeDef(
    _ListDevicesPaginateResponsedevicesinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ListDevicesPaginateResponsedevicesinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned
      up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ListDevicesPaginateResponsedevicesinstancesTypeDef = TypedDict(
    "_ListDevicesPaginateResponsedevicesinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ListDevicesPaginateResponsedevicesinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ListDevicesPaginateResponsedevicesinstancesTypeDef(
    _ListDevicesPaginateResponsedevicesinstancesTypeDef
):
    """
    Type definition for `ListDevicesPaginateResponsedevices` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be cleaned
        up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ListDevicesPaginateResponsedevicesresolutionTypeDef = TypedDict(
    "_ListDevicesPaginateResponsedevicesresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ListDevicesPaginateResponsedevicesresolutionTypeDef(
    _ListDevicesPaginateResponsedevicesresolutionTypeDef
):
    """
    Type definition for `ListDevicesPaginateResponsedevices` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ListDevicesPaginateResponsedevicesTypeDef = TypedDict(
    "_ListDevicesPaginateResponsedevicesTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ListDevicesPaginateResponsedevicescpuTypeDef,
        "resolution": ListDevicesPaginateResponsedevicesresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[ListDevicesPaginateResponsedevicesinstancesTypeDef],
        "availability": str,
    },
    total=False,
)


class ListDevicesPaginateResponsedevicesTypeDef(
    _ListDevicesPaginateResponsedevicesTypeDef
):
    """
    Type definition for `ListDevicesPaginateResponse` `devices`

    Represents a device type that an app is tested against.

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be cleaned
            up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently available
      in the ListDevices and GetDevice API methods.
    """


_ListDevicesPaginateResponseTypeDef = TypedDict(
    "_ListDevicesPaginateResponseTypeDef",
    {"devices": List[ListDevicesPaginateResponsedevicesTypeDef], "NextToken": str},
    total=False,
)


class ListDevicesPaginateResponseTypeDef(_ListDevicesPaginateResponseTypeDef):
    """
    Type definition for `ListDevicesPaginate` `Response`

    Represents the result of a list devices operation.

    - **devices** *(list) --*

      Information about the devices.

      - *(dict) --*

        Represents a device type that an app is tested against.

        - **arn** *(string) --*

          The device's ARN.

        - **name** *(string) --*

          The device's display name.

        - **manufacturer** *(string) --*

          The device's manufacturer name.

        - **model** *(string) --*

          The device's model name.

        - **modelId** *(string) --*

          The device's model ID.

        - **formFactor** *(string) --*

          The device's form factor.

          Allowed values include:

          * PHONE: The phone form factor.

          * TABLET: The tablet form factor.

        - **platform** *(string) --*

          The device's platform.

          Allowed values include:

          * ANDROID: The Android platform.

          * IOS: The iOS platform.

        - **os** *(string) --*

          The device's operating system type.

        - **cpu** *(dict) --*

          Information about the device's CPU.

          - **frequency** *(string) --*

            The CPU's frequency.

          - **architecture** *(string) --*

            The CPU's architecture, for example x86 or ARM.

          - **clock** *(float) --*

            The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
            CPU is expressed as 1200000000.

        - **resolution** *(dict) --*

          The resolution of the device.

          - **width** *(integer) --*

            The screen resolution's width, expressed in pixels.

          - **height** *(integer) --*

            The screen resolution's height, expressed in pixels.

        - **heapSize** *(integer) --*

          The device's heap size, expressed in bytes.

        - **memory** *(integer) --*

          The device's total memory size, expressed in bytes.

        - **image** *(string) --*

          The device's image name.

        - **carrier** *(string) --*

          The device's carrier.

        - **radio** *(string) --*

          The device's radio.

        - **remoteAccessEnabled** *(boolean) --*

          Specifies whether remote access has been enabled for the specified device.

        - **remoteDebugEnabled** *(boolean) --*

          This flag is set to ``true`` if remote debugging is enabled for the device.

           *Remote debugging is `no longer supported
           <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        - **fleetType** *(string) --*

          The type of fleet to which this device belongs. Possible values for fleet type are
          PRIVATE and PUBLIC.

        - **fleetName** *(string) --*

          The name of the fleet to which this device belongs.

        - **instances** *(list) --*

          The instances belonging to this device.

          - *(dict) --*

            Represents the device instance.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the device instance.

            - **deviceArn** *(string) --*

              The Amazon Resource Name (ARN) of the device.

            - **labels** *(list) --*

              An array of strings describing the device instance.

              - *(string) --*

            - **status** *(string) --*

              The status of the device instance. Valid values are listed below.

            - **udid** *(string) --*

              Unique device identifier for the device instance.

            - **instanceProfile** *(dict) --*

              A object containing information about the instance profile.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the instance profile.

              - **packageCleanup** *(boolean) --*

                When set to ``true`` , Device Farm will remove app packages after a test run. The
                default value is ``false`` for private devices.

              - **excludeAppPackagesFromCleanup** *(list) --*

                An array of strings specifying the list of app packages that should not be cleaned
                up from the device after a test run is over.

                The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

                - *(string) --*

              - **rebootAfterUse** *(boolean) --*

                When set to ``true`` , Device Farm will reboot the instance after a test run. The
                default value is ``true`` .

              - **name** *(string) --*

                The name of the instance profile.

              - **description** *(string) --*

                The description of the instance profile.

        - **availability** *(string) --*

          Reflects how likely a device will be available for a test run. It is currently available
          in the ListDevices and GetDevice API methods.

    - **NextToken** *(string) --*

      A token to resume pagination.
    """


_ListDevicesPaginatefiltersTypeDef = TypedDict(
    "_ListDevicesPaginatefiltersTypeDef",
    {"attribute": str, "operator": str, "values": List[str]},
    total=False,
)


class ListDevicesPaginatefiltersTypeDef(_ListDevicesPaginatefiltersTypeDef):
    """
    Type definition for `ListDevicesPaginate` `filters`

    Represents a device filter used to select a set of devices to be included in a test run. This
    data structure is passed in as the ``deviceSelectionConfiguration`` parameter to ScheduleRun.
    For an example of the JSON request syntax, see  ScheduleRun .

    It is also passed in as the ``filters`` parameter to ListDevices. For an example of the JSON
    request syntax, see  ListDevices .

    - **attribute** *(string) --*

      The aspect of a device such as platform or model used as the selection criteria in a device
      filter.

      The supported operators for each attribute are provided in the following list.

        ARN

      The Amazon Resource Name (ARN) of the device. For example,
      "arn:aws:devicefarm:us-west-2::device:12345Example".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        PLATFORM

      The device platform. Valid values are "ANDROID" or "IOS".

       *Supported operators* : ``EQUALS``

        OS_VERSION

      The operating system version. For example, "10.3.2".

       *Supported operators* : ``EQUALS`` , ``GREATER_THAN`` , ``GREATER_THAN_OR_EQUALS`` , ``IN``
       , ``LESS_THAN`` , ``LESS_THAN_OR_EQUALS`` , ``NOT_IN``

        MODEL

      The device model. For example, "iPad 5th Gen".

       *Supported operators* : ``CONTAINS`` , ``EQUALS`` , ``IN`` , ``NOT_IN``

        AVAILABILITY

      The current availability of the device. Valid values are "AVAILABLE", "HIGHLY_AVAILABLE",
      "BUSY", or "TEMPORARY_NOT_AVAILABLE".

       *Supported operators* : ``EQUALS``

        FORM_FACTOR

      The device form factor. Valid values are "PHONE" or "TABLET".

       *Supported operators* : ``EQUALS``

        MANUFACTURER

      The device manufacturer. For example, "Apple".

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        REMOTE_ACCESS_ENABLED

      Whether the device is enabled for remote access. Valid values are "TRUE" or "FALSE".

       *Supported operators* : ``EQUALS``

        REMOTE_DEBUG_ENABLED

       *Ignored.* Whether the device is enabled for remote debugging. Valid values are "TRUE" or
       "FALSE".

       *Supported operators* : ``EQUALS``

       *This filter will be ignored, as remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

        INSTANCE_ARN

      The Amazon Resource Name (ARN) of the device instance.

       *Supported operators* : ``EQUALS`` , ``IN`` , ``NOT_IN``

        INSTANCE_LABELS

      The label of the device instance.

       *Supported operators* : ``CONTAINS``

        FLEET_TYPE

      The fleet type. Valid values are "PUBLIC" or "PRIVATE".

       *Supported operators* : ``EQUALS``

    - **operator** *(string) --*

      Specifies how Device Farm compares the filter's attribute to the value. For the operators
      that are supported by each attribute, see the attribute descriptions.

    - **values** *(list) --*

      An array of one or more filter values used in a device filter.

       **Operator Values**

      * The IN and NOT_IN operators can take a values array that has more than one element.

      * The other operators require an array with a single element.

       **Attribute Values**

      * The PLATFORM attribute can be set to "ANDROID" or "IOS".

      * The AVAILABILITY attribute can be set to "AVAILABLE", "HIGHLY_AVAILABLE", "BUSY", or
      "TEMPORARY_NOT_AVAILABLE".

      * The FORM_FACTOR attribute can be set to "PHONE" or "TABLET".

      * The FLEET_TYPE attribute can be set to "PUBLIC" or "PRIVATE".

      - *(string) --*
    """


_ListInstanceProfilesPaginatePaginationConfigTypeDef = TypedDict(
    "_ListInstanceProfilesPaginatePaginationConfigTypeDef",
    {"MaxItems": int, "PageSize": int, "StartingToken": str},
    total=False,
)


class ListInstanceProfilesPaginatePaginationConfigTypeDef(
    _ListInstanceProfilesPaginatePaginationConfigTypeDef
):
    """
    Type definition for `ListInstanceProfilesPaginate` `PaginationConfig`

    A dictionary that provides parameters to control pagination.

    - **MaxItems** *(integer) --*

      The total number of items to return. If the total number of items available is more than the
      value specified in max-items then a ``NextToken`` will be provided in the output that you can
      use to resume pagination.

    - **PageSize** *(integer) --*

      The size of each page.

    - **StartingToken** *(string) --*

      A token to specify where to start paginating. This is the ``NextToken`` from a previous
      response.
    """


_ListInstanceProfilesPaginateResponseinstanceProfilesTypeDef = TypedDict(
    "_ListInstanceProfilesPaginateResponseinstanceProfilesTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ListInstanceProfilesPaginateResponseinstanceProfilesTypeDef(
    _ListInstanceProfilesPaginateResponseinstanceProfilesTypeDef
):
    """
    Type definition for `ListInstanceProfilesPaginateResponse` `instanceProfiles`

    Represents the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The default
      value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be cleaned up
      from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The default
      value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ListInstanceProfilesPaginateResponseTypeDef = TypedDict(
    "_ListInstanceProfilesPaginateResponseTypeDef",
    {
        "instanceProfiles": List[
            ListInstanceProfilesPaginateResponseinstanceProfilesTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)


class ListInstanceProfilesPaginateResponseTypeDef(
    _ListInstanceProfilesPaginateResponseTypeDef
):
    """
    Type definition for `ListInstanceProfilesPaginate` `Response`

    - **instanceProfiles** *(list) --*

      An object containing information about your instance profiles.

      - *(dict) --*

        Represents the instance profile.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the instance profile.

        - **packageCleanup** *(boolean) --*

          When set to ``true`` , Device Farm will remove app packages after a test run. The default
          value is ``false`` for private devices.

        - **excludeAppPackagesFromCleanup** *(list) --*

          An array of strings specifying the list of app packages that should not be cleaned up
          from the device after a test run is over.

          The list of packages is only considered if you set ``packageCleanup`` to ``true`` .

          - *(string) --*

        - **rebootAfterUse** *(boolean) --*

          When set to ``true`` , Device Farm will reboot the instance after a test run. The default
          value is ``true`` .

        - **name** *(string) --*

          The name of the instance profile.

        - **description** *(string) --*

          The description of the instance profile.

    - **NextToken** *(string) --*

      A token to resume pagination.
    """


_ListJobsPaginatePaginationConfigTypeDef = TypedDict(
    "_ListJobsPaginatePaginationConfigTypeDef",
    {"MaxItems": int, "StartingToken": str},
    total=False,
)


class ListJobsPaginatePaginationConfigTypeDef(_ListJobsPaginatePaginationConfigTypeDef):
    """
    Type definition for `ListJobsPaginate` `PaginationConfig`

    A dictionary that provides parameters to control pagination.

    - **MaxItems** *(integer) --*

      The total number of items to return. If the total number of items available is more than the
      value specified in max-items then a ``NextToken`` will be provided in the output that you can
      use to resume pagination.

    - **StartingToken** *(string) --*

      A token to specify where to start paginating. This is the ``NextToken`` from a previous
      response.
    """


_ListJobsPaginateResponsejobscountersTypeDef = TypedDict(
    "_ListJobsPaginateResponsejobscountersTypeDef",
    {
        "total": int,
        "passed": int,
        "failed": int,
        "warned": int,
        "errored": int,
        "stopped": int,
        "skipped": int,
    },
    total=False,
)


class ListJobsPaginateResponsejobscountersTypeDef(
    _ListJobsPaginateResponsejobscountersTypeDef
):
    """
    Type definition for `ListJobsPaginateResponsejobs` `counters`

    The job's result counters.

    - **total** *(integer) --*

      The total number of entities.

    - **passed** *(integer) --*

      The number of passed entities.

    - **failed** *(integer) --*

      The number of failed entities.

    - **warned** *(integer) --*

      The number of warned entities.

    - **errored** *(integer) --*

      The number of errored entities.

    - **stopped** *(integer) --*

      The number of stopped entities.

    - **skipped** *(integer) --*

      The number of skipped entities.
    """


_ListJobsPaginateResponsejobsdeviceMinutesTypeDef = TypedDict(
    "_ListJobsPaginateResponsejobsdeviceMinutesTypeDef",
    {"total": float, "metered": float, "unmetered": float},
    total=False,
)


class ListJobsPaginateResponsejobsdeviceMinutesTypeDef(
    _ListJobsPaginateResponsejobsdeviceMinutesTypeDef
):
    """
    Type definition for `ListJobsPaginateResponsejobs` `deviceMinutes`

    Represents the total (metered or unmetered) minutes used by the job.

    - **total** *(float) --*

      When specified, represents the total minutes used by the resource to run tests.

    - **metered** *(float) --*

      When specified, represents only the sum of metered minutes used by the resource to run
      tests.

    - **unmetered** *(float) --*

      When specified, represents only the sum of unmetered minutes used by the resource to
      run tests.
    """


_ListJobsPaginateResponsejobsdevicecpuTypeDef = TypedDict(
    "_ListJobsPaginateResponsejobsdevicecpuTypeDef",
    {"frequency": str, "architecture": str, "clock": float},
    total=False,
)


class ListJobsPaginateResponsejobsdevicecpuTypeDef(
    _ListJobsPaginateResponsejobsdevicecpuTypeDef
):
    """
    Type definition for `ListJobsPaginateResponsejobsdevice` `cpu`

    Information about the device's CPU.

    - **frequency** *(string) --*

      The CPU's frequency.

    - **architecture** *(string) --*

      The CPU's architecture, for example x86 or ARM.

    - **clock** *(float) --*

      The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
      CPU is expressed as 1200000000.
    """


_ListJobsPaginateResponsejobsdeviceinstancesinstanceProfileTypeDef = TypedDict(
    "_ListJobsPaginateResponsejobsdeviceinstancesinstanceProfileTypeDef",
    {
        "arn": str,
        "packageCleanup": bool,
        "excludeAppPackagesFromCleanup": List[str],
        "rebootAfterUse": bool,
        "name": str,
        "description": str,
    },
    total=False,
)


class ListJobsPaginateResponsejobsdeviceinstancesinstanceProfileTypeDef(
    _ListJobsPaginateResponsejobsdeviceinstancesinstanceProfileTypeDef
):
    """
    Type definition for `ListJobsPaginateResponsejobsdeviceinstances` `instanceProfile`

    A object containing information about the instance profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the instance profile.

    - **packageCleanup** *(boolean) --*

      When set to ``true`` , Device Farm will remove app packages after a test run. The
      default value is ``false`` for private devices.

    - **excludeAppPackagesFromCleanup** *(list) --*

      An array of strings specifying the list of app packages that should not be
      cleaned up from the device after a test run is over.

      The list of packages is only considered if you set ``packageCleanup`` to ``true``
      .

      - *(string) --*

    - **rebootAfterUse** *(boolean) --*

      When set to ``true`` , Device Farm will reboot the instance after a test run. The
      default value is ``true`` .

    - **name** *(string) --*

      The name of the instance profile.

    - **description** *(string) --*

      The description of the instance profile.
    """


_ListJobsPaginateResponsejobsdeviceinstancesTypeDef = TypedDict(
    "_ListJobsPaginateResponsejobsdeviceinstancesTypeDef",
    {
        "arn": str,
        "deviceArn": str,
        "labels": List[str],
        "status": str,
        "udid": str,
        "instanceProfile": ListJobsPaginateResponsejobsdeviceinstancesinstanceProfileTypeDef,
    },
    total=False,
)


class ListJobsPaginateResponsejobsdeviceinstancesTypeDef(
    _ListJobsPaginateResponsejobsdeviceinstancesTypeDef
):
    """
    Type definition for `ListJobsPaginateResponsejobsdevice` `instances`

    Represents the device instance.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the device instance.

    - **deviceArn** *(string) --*

      The Amazon Resource Name (ARN) of the device.

    - **labels** *(list) --*

      An array of strings describing the device instance.

      - *(string) --*

    - **status** *(string) --*

      The status of the device instance. Valid values are listed below.

    - **udid** *(string) --*

      Unique device identifier for the device instance.

    - **instanceProfile** *(dict) --*

      A object containing information about the instance profile.

      - **arn** *(string) --*

        The Amazon Resource Name (ARN) of the instance profile.

      - **packageCleanup** *(boolean) --*

        When set to ``true`` , Device Farm will remove app packages after a test run. The
        default value is ``false`` for private devices.

      - **excludeAppPackagesFromCleanup** *(list) --*

        An array of strings specifying the list of app packages that should not be
        cleaned up from the device after a test run is over.

        The list of packages is only considered if you set ``packageCleanup`` to ``true``
        .

        - *(string) --*

      - **rebootAfterUse** *(boolean) --*

        When set to ``true`` , Device Farm will reboot the instance after a test run. The
        default value is ``true`` .

      - **name** *(string) --*

        The name of the instance profile.

      - **description** *(string) --*

        The description of the instance profile.
    """


_ListJobsPaginateResponsejobsdeviceresolutionTypeDef = TypedDict(
    "_ListJobsPaginateResponsejobsdeviceresolutionTypeDef",
    {"width": int, "height": int},
    total=False,
)


class ListJobsPaginateResponsejobsdeviceresolutionTypeDef(
    _ListJobsPaginateResponsejobsdeviceresolutionTypeDef
):
    """
    Type definition for `ListJobsPaginateResponsejobsdevice` `resolution`

    The resolution of the device.

    - **width** *(integer) --*

      The screen resolution's width, expressed in pixels.

    - **height** *(integer) --*

      The screen resolution's height, expressed in pixels.
    """


_ListJobsPaginateResponsejobsdeviceTypeDef = TypedDict(
    "_ListJobsPaginateResponsejobsdeviceTypeDef",
    {
        "arn": str,
        "name": str,
        "manufacturer": str,
        "model": str,
        "modelId": str,
        "formFactor": str,
        "platform": str,
        "os": str,
        "cpu": ListJobsPaginateResponsejobsdevicecpuTypeDef,
        "resolution": ListJobsPaginateResponsejobsdeviceresolutionTypeDef,
        "heapSize": int,
        "memory": int,
        "image": str,
        "carrier": str,
        "radio": str,
        "remoteAccessEnabled": bool,
        "remoteDebugEnabled": bool,
        "fleetType": str,
        "fleetName": str,
        "instances": List[ListJobsPaginateResponsejobsdeviceinstancesTypeDef],
        "availability": str,
    },
    total=False,
)


class ListJobsPaginateResponsejobsdeviceTypeDef(
    _ListJobsPaginateResponsejobsdeviceTypeDef
):
    """
    Type definition for `ListJobsPaginateResponsejobs` `device`

    The device (phone or tablet).

    - **arn** *(string) --*

      The device's ARN.

    - **name** *(string) --*

      The device's display name.

    - **manufacturer** *(string) --*

      The device's manufacturer name.

    - **model** *(string) --*

      The device's model name.

    - **modelId** *(string) --*

      The device's model ID.

    - **formFactor** *(string) --*

      The device's form factor.

      Allowed values include:

      * PHONE: The phone form factor.

      * TABLET: The tablet form factor.

    - **platform** *(string) --*

      The device's platform.

      Allowed values include:

      * ANDROID: The Android platform.

      * IOS: The iOS platform.

    - **os** *(string) --*

      The device's operating system type.

    - **cpu** *(dict) --*

      Information about the device's CPU.

      - **frequency** *(string) --*

        The CPU's frequency.

      - **architecture** *(string) --*

        The CPU's architecture, for example x86 or ARM.

      - **clock** *(float) --*

        The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
        CPU is expressed as 1200000000.

    - **resolution** *(dict) --*

      The resolution of the device.

      - **width** *(integer) --*

        The screen resolution's width, expressed in pixels.

      - **height** *(integer) --*

        The screen resolution's height, expressed in pixels.

    - **heapSize** *(integer) --*

      The device's heap size, expressed in bytes.

    - **memory** *(integer) --*

      The device's total memory size, expressed in bytes.

    - **image** *(string) --*

      The device's image name.

    - **carrier** *(string) --*

      The device's carrier.

    - **radio** *(string) --*

      The device's radio.

    - **remoteAccessEnabled** *(boolean) --*

      Specifies whether remote access has been enabled for the specified device.

    - **remoteDebugEnabled** *(boolean) --*

      This flag is set to ``true`` if remote debugging is enabled for the device.

       *Remote debugging is `no longer supported
       <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

    - **fleetType** *(string) --*

      The type of fleet to which this device belongs. Possible values for fleet type are
      PRIVATE and PUBLIC.

    - **fleetName** *(string) --*

      The name of the fleet to which this device belongs.

    - **instances** *(list) --*

      The instances belonging to this device.

      - *(dict) --*

        Represents the device instance.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the device instance.

        - **deviceArn** *(string) --*

          The Amazon Resource Name (ARN) of the device.

        - **labels** *(list) --*

          An array of strings describing the device instance.

          - *(string) --*

        - **status** *(string) --*

          The status of the device instance. Valid values are listed below.

        - **udid** *(string) --*

          Unique device identifier for the device instance.

        - **instanceProfile** *(dict) --*

          A object containing information about the instance profile.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the instance profile.

          - **packageCleanup** *(boolean) --*

            When set to ``true`` , Device Farm will remove app packages after a test run. The
            default value is ``false`` for private devices.

          - **excludeAppPackagesFromCleanup** *(list) --*

            An array of strings specifying the list of app packages that should not be
            cleaned up from the device after a test run is over.

            The list of packages is only considered if you set ``packageCleanup`` to ``true``
            .

            - *(string) --*

          - **rebootAfterUse** *(boolean) --*

            When set to ``true`` , Device Farm will reboot the instance after a test run. The
            default value is ``true`` .

          - **name** *(string) --*

            The name of the instance profile.

          - **description** *(string) --*

            The description of the instance profile.

    - **availability** *(string) --*

      Reflects how likely a device will be available for a test run. It is currently
      available in the ListDevices and GetDevice API methods.
    """


_ListJobsPaginateResponsejobsTypeDef = TypedDict(
    "_ListJobsPaginateResponsejobsTypeDef",
    {
        "arn": str,
        "name": str,
        "type": str,
        "created": datetime,
        "status": str,
        "result": str,
        "started": datetime,
        "stopped": datetime,
        "counters": ListJobsPaginateResponsejobscountersTypeDef,
        "message": str,
        "device": ListJobsPaginateResponsejobsdeviceTypeDef,
        "instanceArn": str,
        "deviceMinutes": ListJobsPaginateResponsejobsdeviceMinutesTypeDef,
        "videoEndpoint": str,
        "videoCapture": bool,
    },
    total=False,
)


class ListJobsPaginateResponsejobsTypeDef(_ListJobsPaginateResponsejobsTypeDef):
    """
    Type definition for `ListJobsPaginateResponse` `jobs`

    Represents a device.

    - **arn** *(string) --*

      The job's ARN.

    - **name** *(string) --*

      The job's name.

    - **type** *(string) --*

      The job's type.

      Allowed values include the following:

      * BUILTIN_FUZZ: The built-in fuzz type.

      * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
      interacting with it and capturing screenshots at the same time.

      * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

      * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

      * APPIUM_PYTHON: The Appium Python type.

      * APPIUM_NODE: The Appium Node.js type.

      * APPIUM_RUBY: The Appium Ruby type.

      * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

      * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

      * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

      * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

      * APPIUM_WEB_RUBY: The Appium Ruby test type for web apps.

      * CALABASH: The Calabash type.

      * INSTRUMENTATION: The Instrumentation type.

      * UIAUTOMATION: The uiautomation type.

      * UIAUTOMATOR: The uiautomator type.

      * XCTEST: The Xcode test type.

      * XCTEST_UI: The Xcode UI test type.

    - **created** *(datetime) --*

      When the job was created.

    - **status** *(string) --*

      The job's status.

      Allowed values include:

      * PENDING: A pending status.

      * PENDING_CONCURRENCY: A pending concurrency status.

      * PENDING_DEVICE: A pending device status.

      * PROCESSING: A processing status.

      * SCHEDULING: A scheduling status.

      * PREPARING: A preparing status.

      * RUNNING: A running status.

      * COMPLETED: A completed status.

      * STOPPING: A stopping status.

    - **result** *(string) --*

      The job's result.

      Allowed values include:

      * PENDING: A pending condition.

      * PASSED: A passing condition.

      * WARNED: A warning condition.

      * FAILED: A failed condition.

      * SKIPPED: A skipped condition.

      * ERRORED: An error condition.

      * STOPPED: A stopped condition.

    - **started** *(datetime) --*

      The job's start time.

    - **stopped** *(datetime) --*

      The job's stop time.

    - **counters** *(dict) --*

      The job's result counters.

      - **total** *(integer) --*

        The total number of entities.

      - **passed** *(integer) --*

        The number of passed entities.

      - **failed** *(integer) --*

        The number of failed entities.

      - **warned** *(integer) --*

        The number of warned entities.

      - **errored** *(integer) --*

        The number of errored entities.

      - **stopped** *(integer) --*

        The number of stopped entities.

      - **skipped** *(integer) --*

        The number of skipped entities.

    - **message** *(string) --*

      A message about the job's result.

    - **device** *(dict) --*

      The device (phone or tablet).

      - **arn** *(string) --*

        The device's ARN.

      - **name** *(string) --*

        The device's display name.

      - **manufacturer** *(string) --*

        The device's manufacturer name.

      - **model** *(string) --*

        The device's model name.

      - **modelId** *(string) --*

        The device's model ID.

      - **formFactor** *(string) --*

        The device's form factor.

        Allowed values include:

        * PHONE: The phone form factor.

        * TABLET: The tablet form factor.

      - **platform** *(string) --*

        The device's platform.

        Allowed values include:

        * ANDROID: The Android platform.

        * IOS: The iOS platform.

      - **os** *(string) --*

        The device's operating system type.

      - **cpu** *(dict) --*

        Information about the device's CPU.

        - **frequency** *(string) --*

          The CPU's frequency.

        - **architecture** *(string) --*

          The CPU's architecture, for example x86 or ARM.

        - **clock** *(float) --*

          The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
          CPU is expressed as 1200000000.

      - **resolution** *(dict) --*

        The resolution of the device.

        - **width** *(integer) --*

          The screen resolution's width, expressed in pixels.

        - **height** *(integer) --*

          The screen resolution's height, expressed in pixels.

      - **heapSize** *(integer) --*

        The device's heap size, expressed in bytes.

      - **memory** *(integer) --*

        The device's total memory size, expressed in bytes.

      - **image** *(string) --*

        The device's image name.

      - **carrier** *(string) --*

        The device's carrier.

      - **radio** *(string) --*

        The device's radio.

      - **remoteAccessEnabled** *(boolean) --*

        Specifies whether remote access has been enabled for the specified device.

      - **remoteDebugEnabled** *(boolean) --*

        This flag is set to ``true`` if remote debugging is enabled for the device.

         *Remote debugging is `no longer supported
         <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

      - **fleetType** *(string) --*

        The type of fleet to which this device belongs. Possible values for fleet type are
        PRIVATE and PUBLIC.

      - **fleetName** *(string) --*

        The name of the fleet to which this device belongs.

      - **instances** *(list) --*

        The instances belonging to this device.

        - *(dict) --*

          Represents the device instance.

          - **arn** *(string) --*

            The Amazon Resource Name (ARN) of the device instance.

          - **deviceArn** *(string) --*

            The Amazon Resource Name (ARN) of the device.

          - **labels** *(list) --*

            An array of strings describing the device instance.

            - *(string) --*

          - **status** *(string) --*

            The status of the device instance. Valid values are listed below.

          - **udid** *(string) --*

            Unique device identifier for the device instance.

          - **instanceProfile** *(dict) --*

            A object containing information about the instance profile.

            - **arn** *(string) --*

              The Amazon Resource Name (ARN) of the instance profile.

            - **packageCleanup** *(boolean) --*

              When set to ``true`` , Device Farm will remove app packages after a test run. The
              default value is ``false`` for private devices.

            - **excludeAppPackagesFromCleanup** *(list) --*

              An array of strings specifying the list of app packages that should not be
              cleaned up from the device after a test run is over.

              The list of packages is only considered if you set ``packageCleanup`` to ``true``
              .

              - *(string) --*

            - **rebootAfterUse** *(boolean) --*

              When set to ``true`` , Device Farm will reboot the instance after a test run. The
              default value is ``true`` .

            - **name** *(string) --*

              The name of the instance profile.

            - **description** *(string) --*

              The description of the instance profile.

      - **availability** *(string) --*

        Reflects how likely a device will be available for a test run. It is currently
        available in the ListDevices and GetDevice API methods.

    - **instanceArn** *(string) --*

      The Amazon Resource Name (ARN) of the instance.

    - **deviceMinutes** *(dict) --*

      Represents the total (metered or unmetered) minutes used by the job.

      - **total** *(float) --*

        When specified, represents the total minutes used by the resource to run tests.

      - **metered** *(float) --*

        When specified, represents only the sum of metered minutes used by the resource to run
        tests.

      - **unmetered** *(float) --*

        When specified, represents only the sum of unmetered minutes used by the resource to
        run tests.

    - **videoEndpoint** *(string) --*

      The endpoint for streaming device video.

    - **videoCapture** *(boolean) --*

      This value is set to true if video capture is enabled; otherwise, it is set to false.
    """


_ListJobsPaginateResponseTypeDef = TypedDict(
    "_ListJobsPaginateResponseTypeDef",
    {"jobs": List[ListJobsPaginateResponsejobsTypeDef], "NextToken": str},
    total=False,
)


class ListJobsPaginateResponseTypeDef(_ListJobsPaginateResponseTypeDef):
    """
    Type definition for `ListJobsPaginate` `Response`

    Represents the result of a list jobs request.

    - **jobs** *(list) --*

      Information about the jobs.

      - *(dict) --*

        Represents a device.

        - **arn** *(string) --*

          The job's ARN.

        - **name** *(string) --*

          The job's name.

        - **type** *(string) --*

          The job's type.

          Allowed values include the following:

          * BUILTIN_FUZZ: The built-in fuzz type.

          * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android app,
          interacting with it and capturing screenshots at the same time.

          * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.

          * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.

          * APPIUM_PYTHON: The Appium Python type.

          * APPIUM_NODE: The Appium Node.js type.

          * APPIUM_RUBY: The Appium Ruby type.

          * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for web apps.

          * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for web apps.

          * APPIUM_WEB_PYTHON: The Appium Python type for web apps.

          * APPIUM_WEB_NODE: The Appium Node.js type for web apps.

          * APPIUM_WEB_RUBY: The Appium Ruby test type for web apps.

          * CALABASH: The Calabash type.

          * INSTRUMENTATION: The Instrumentation type.

          * UIAUTOMATION: The uiautomation type.

          * UIAUTOMATOR: The uiautomator type.

          * XCTEST: The Xcode test type.

          * XCTEST_UI: The Xcode UI test type.

        - **created** *(datetime) --*

          When the job was created.

        - **status** *(string) --*

          The job's status.

          Allowed values include:

          * PENDING: A pending status.

          * PENDING_CONCURRENCY: A pending concurrency status.

          * PENDING_DEVICE: A pending device status.

          * PROCESSING: A processing status.

          * SCHEDULING: A scheduling status.

          * PREPARING: A preparing status.

          * RUNNING: A running status.

          * COMPLETED: A completed status.

          * STOPPING: A stopping status.

        - **result** *(string) --*

          The job's result.

          Allowed values include:

          * PENDING: A pending condition.

          * PASSED: A passing condition.

          * WARNED: A warning condition.

          * FAILED: A failed condition.

          * SKIPPED: A skipped condition.

          * ERRORED: An error condition.

          * STOPPED: A stopped condition.

        - **started** *(datetime) --*

          The job's start time.

        - **stopped** *(datetime) --*

          The job's stop time.

        - **counters** *(dict) --*

          The job's result counters.

          - **total** *(integer) --*

            The total number of entities.

          - **passed** *(integer) --*

            The number of passed entities.

          - **failed** *(integer) --*

            The number of failed entities.

          - **warned** *(integer) --*

            The number of warned entities.

          - **errored** *(integer) --*

            The number of errored entities.

          - **stopped** *(integer) --*

            The number of stopped entities.

          - **skipped** *(integer) --*

            The number of skipped entities.

        - **message** *(string) --*

          A message about the job's result.

        - **device** *(dict) --*

          The device (phone or tablet).

          - **arn** *(string) --*

            The device's ARN.

          - **name** *(string) --*

            The device's display name.

          - **manufacturer** *(string) --*

            The device's manufacturer name.

          - **model** *(string) --*

            The device's model name.

          - **modelId** *(string) --*

            The device's model ID.

          - **formFactor** *(string) --*

            The device's form factor.

            Allowed values include:

            * PHONE: The phone form factor.

            * TABLET: The tablet form factor.

          - **platform** *(string) --*

            The device's platform.

            Allowed values include:

            * ANDROID: The Android platform.

            * IOS: The iOS platform.

          - **os** *(string) --*

            The device's operating system type.

          - **cpu** *(dict) --*

            Information about the device's CPU.

            - **frequency** *(string) --*

              The CPU's frequency.

            - **architecture** *(string) --*

              The CPU's architecture, for example x86 or ARM.

            - **clock** *(float) --*

              The clock speed of the device's CPU, expressed in hertz (Hz). For example, a 1.2 GHz
              CPU is expressed as 1200000000.

          - **resolution** *(dict) --*

            The resolution of the device.

            - **width** *(integer) --*

              The screen resolution's width, expressed in pixels.

            - **height** *(integer) --*

              The screen resolution's height, expressed in pixels.

          - **heapSize** *(integer) --*

            The device's heap size, expressed in bytes.

          - **memory** *(integer) --*

            The device's total memory size, expressed in bytes.

          - **image** *(string) --*

            The device's image name.

          - **carrier** *(string) --*

            The device's carrier.

          - **radio** *(string) --*

            The device's radio.

          - **remoteAccessEnabled** *(boolean) --*

            Specifies whether remote access has been enabled for the specified device.

          - **remoteDebugEnabled** *(boolean) --*

            This flag is set to ``true`` if remote debugging is enabled for the device.

             *Remote debugging is `no longer supported
             <https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html>`__ .*

          - **fleetType** *(string) --*

            The type of fleet to which this device belongs. Possible values for fleet type are
            PRIVATE and PUBLIC.

          - **fleetName** *(string) --*

            The name of the fleet to which this device belongs.

          - **instances** *(list) --*

            The instances belonging to this device.

            - *(dict) --*

              Represents the device instance.

              - **arn** *(string) --*

                The Amazon Resource Name (ARN) of the device instance.

              - **deviceArn** *(string) --*

                The Amazon Resource Name (ARN) of the device.

              - **labels** *(list) --*

                An array of strings describing the device instance.

                - *(string) --*

              - **status** *(string) --*

                The status of the device instance. Valid values are listed below.

              - **udid** *(string) --*

                Unique device identifier for the device instance.

              - **instanceProfile** *(dict) --*

                A object containing information about the instance profile.

                - **arn** *(string) --*

                  The Amazon Resource Name (ARN) of the instance profile.

                - **packageCleanup** *(boolean) --*

                  When set to ``true`` , Device Farm will remove app packages after a test run. The
                  default value is ``false`` for private devices.

                - **excludeAppPackagesFromCleanup** *(list) --*

                  An array of strings specifying the list of app packages that should not be
                  cleaned up from the device after a test run is over.

                  The list of packages is only considered if you set ``packageCleanup`` to ``true``
                  .

                  - *(string) --*

                - **rebootAfterUse** *(boolean) --*

                  When set to ``true`` , Device Farm will reboot the instance after a test run. The
                  default value is ``true`` .

                - **name** *(string) --*

                  The name of the instance profile.

                - **description** *(string) --*

                  The description of the instance profile.

          - **availability** *(string) --*

            Reflects how likely a device will be available for a test run. It is currently
            available in the ListDevices and GetDevice API methods.

        - **instanceArn** *(string) --*

          The Amazon Resource Name (ARN) of the instance.

        - **deviceMinutes** *(dict) --*

          Represents the total (metered or unmetered) minutes used by the job.

          - **total** *(float) --*

            When specified, represents the total minutes used by the resource to run tests.

          - **metered** *(float) --*

            When specified, represents only the sum of metered minutes used by the resource to run
            tests.

          - **unmetered** *(float) --*

            When specified, represents only the sum of unmetered minutes used by the resource to
            run tests.

        - **videoEndpoint** *(string) --*

          The endpoint for streaming device video.

        - **videoCapture** *(boolean) --*

          This value is set to true if video capture is enabled; otherwise, it is set to false.

    - **NextToken** *(string) --*

      A token to resume pagination.
    """


_ListNetworkProfilesPaginatePaginationConfigTypeDef = TypedDict(
    "_ListNetworkProfilesPaginatePaginationConfigTypeDef",
    {"MaxItems": int, "StartingToken": str},
    total=False,
)


class ListNetworkProfilesPaginatePaginationConfigTypeDef(
    _ListNetworkProfilesPaginatePaginationConfigTypeDef
):
    """
    Type definition for `ListNetworkProfilesPaginate` `PaginationConfig`

    A dictionary that provides parameters to control pagination.

    - **MaxItems** *(integer) --*

      The total number of items to return. If the total number of items available is more than the
      value specified in max-items then a ``NextToken`` will be provided in the output that you can
      use to resume pagination.

    - **StartingToken** *(string) --*

      A token to specify where to start paginating. This is the ``NextToken`` from a previous
      response.
    """


_ListNetworkProfilesPaginateResponsenetworkProfilesTypeDef = TypedDict(
    "_ListNetworkProfilesPaginateResponsenetworkProfilesTypeDef",
    {
        "arn": str,
        "name": str,
        "description": str,
        "type": str,
        "uplinkBandwidthBits": int,
        "downlinkBandwidthBits": int,
        "uplinkDelayMs": int,
        "downlinkDelayMs": int,
        "uplinkJitterMs": int,
        "downlinkJitterMs": int,
        "uplinkLossPercent": int,
        "downlinkLossPercent": int,
    },
    total=False,
)


class ListNetworkProfilesPaginateResponsenetworkProfilesTypeDef(
    _ListNetworkProfilesPaginateResponsenetworkProfilesTypeDef
):
    """
    Type definition for `ListNetworkProfilesPaginateResponse` `networkProfiles`

    An array of settings that describes characteristics of a network profile.

    - **arn** *(string) --*

      The Amazon Resource Name (ARN) of the network profile.

    - **name** *(string) --*

      The name of the network profile.

    - **description** *(string) --*

      The description of the network profile.

    - **type** *(string) --*

      The type of network profile. Valid values are listed below.

    - **uplinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **downlinkBandwidthBits** *(integer) --*

      The data throughput rate in bits per second, as an integer from 0 to 104857600.

    - **uplinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **downlinkDelayMs** *(integer) --*

      Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

    - **uplinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **downlinkJitterMs** *(integer) --*

      Time variation in the delay of received packets in milliseconds as an integer from 0 to
      2000.

    - **uplinkLossPercent** *(integer) --*

      Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

    - **downlinkLossPercent** *(integer) --*

      Proportion of received packets that fail to arrive from 0 to 100 percent.
    """


_ListNetworkProfilesPaginateResponseTypeDef = TypedDict(
    "_ListNetworkProfilesPaginateResponseTypeDef",
    {
        "networkProfiles": List[
            ListNetworkProfilesPaginateResponsenetworkProfilesTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)


class ListNetworkProfilesPaginateResponseTypeDef(
    _ListNetworkProfilesPaginateResponseTypeDef
):
    """
    Type definition for `ListNetworkProfilesPaginate` `Response`

    - **networkProfiles** *(list) --*

      A list of the available network profiles.

      - *(dict) --*

        An array of settings that describes characteristics of a network profile.

        - **arn** *(string) --*

          The Amazon Resource Name (ARN) of the network profile.

        - **name** *(string) --*

          The name of the network profile.

        - **description** *(string) --*

          The description of the network profile.

        - **type** *(string) --*

          The type of network profile. Valid values are listed below.

        - **uplinkBandwidthBits** *(integer) --*

          The data throughput rate in bits per second, as an integer from 0 to 104857600.

        - **downlinkBandwidthBits** *(integer) --*

          The data throughput rate in bits per second, as an integer from 0 to 104857600.

        - **uplinkDelayMs** *(integer) --*

          Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

        - **downlinkDelayMs** *(integer) --*

          Delay time for all packets to destination in milliseconds as an integer from 0 to 2000.

        - **uplinkJitterMs** *(integer) --*

          Time variation in the delay of received packets in milliseconds as an integer from 0 to
          2000.

        - **downlinkJitterMs** *(integer) --*

          Time variation in the delay of received packets in milliseconds as an integer from 0 to
          2000.

        - **uplinkLossPercent** *(integer) --*

          Proportion of transmitted packets that fail to arrive from 0 to 100 percent.

        - **downlinkLossPercent** *(integer) --*

          Proportion of received packets that fail to arrive from 0 to 100 percent.

    - **NextToken** *(string) --*

      A token to resume pagination.
    """


_ListOfferingPromotionsPaginatePaginationConfigTypeDef = TypedDict(
    "_ListOfferingPromotionsPaginatePaginationConfigTypeDef",
    {"MaxItems": int, "StartingToken": str},
    total=False,
)


class ListOfferingPromotionsPaginatePaginationConfigTypeDef(
    _ListOfferingPromotionsPaginatePaginationConfigTypeDef
):
    """
    Type definition for `ListOfferingPromotionsPaginate` `PaginationConfig`

    A dictionary that provides parameters to control pagination.

    - **MaxItems** *(integer) --*

      The total number of items to return. If the total number of items available is more than the
      value specified in max-items then a ``NextToken`` will be provided in the output that you can
      use to resume pagination.

    - **StartingToken** *(string) --*

      A token to specify where to start paginating. This is the ``NextToken`` from a previous
      response.
    """


_ListOfferingPromotionsPaginateResponseofferingPromotionsTypeDef = TypedDict(
    "_ListOfferingPromotionsPaginateResponseofferingPromotionsTypeDef",
    {"id": str, "description": str},
    total=False,
)


class ListOfferingPromotionsPaginateResponseofferingPromotionsTypeDef(
    _ListOfferingPromotionsPaginateResponseofferingPromotionsTypeDef
):
    """
    Type definition for `ListOfferingPromotionsPaginateResponse` `offeringPromotions`

    Represents information about an offering promotion.

    - **id** *(string) --*

      The ID of the offering promotion.

    - **description** *(string) --*

      A string describing the offering promotion.
    """


_ListOfferingPromotionsPaginateResponseTypeDef = TypedDict(
    "_ListOfferingPromotionsPaginateResponseTypeDef",
    {
        "offeringPromotions": List[
            ListOfferingPromotionsPaginateResponseofferingPromotionsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)


class ListOfferingPromotionsPaginateResponseTypeDef(
    _ListOfferingPromotionsPaginateResponseTypeDef
):
    """
    Type definition for `ListOfferingPromotionsPaginate` `Response`

    - **offeringPromotions** *(list) --*

      Information about the offering promotions.

      - *(dict) --*

        Represents information about an offering promotion.

        - **id** *(string) --*

          The ID of the offering promotion.

        - **description** *(string) --*

          A string describing the offering promotion.

    - **NextToken** *(string) --*

      A token to resume pagination.
    """


_ListOfferingTransactionsPaginatePaginationConfigTypeDef = TypedDict(
    "_ListOfferingTransactionsPaginatePaginationConfigTypeDef",
    {"MaxItems": int, "StartingToken": str},
    total=False,
)


class ListOfferingTransactionsPaginatePaginationConfigTypeDef(
    _ListOfferingTransactionsPaginatePaginationConfigTypeDef
):
    """
    Type definition for `ListOfferingTransactionsPaginate` `PaginationConfig`

    A dictionary that provides parameters to control pagination.

    - **MaxItems** *(integer) --*

      The total number of items to return. If the total number of items available is more than the
      value specified in max-items then a ``NextToken`` will be provided in the output that you can
      use to resume pagination.

    - **StartingToken** *(string) --*

      A token to specify where to start paginating. This is the ``NextToken`` from a previous
      response.
    """


_ListOfferingTransactionsPaginateResponseofferingTransactionscostTypeDef = TypedDict(
    "_ListOfferingTransactionsPaginateResponseofferingTransactionscostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class ListOfferingTransactionsPaginateResponseofferingTransactionscostTypeDef(
    _ListOfferingTransactionsPaginateResponseofferingTransactionscostTypeDef
):
    """
    Type definition for `ListOfferingTransactionsPaginateResponseofferingTransactions` `cost`

    The cost of an offering transaction.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef = TypedDict(
    "_ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef",
    {"amount": float, "currencyCode": str},
    total=False,
)


class ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef(
    _ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef
):
    """
    Type definition for `ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringCharges` `cost`

    The cost of the recurring charge.

    - **amount** *(float) --*

      The numerical amount of an offering or transaction.

    - **currencyCode** *(string) --*

      The currency code of a monetary amount. For example, ``USD`` means "U.S.
      dollars."
    """


_ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef = TypedDict(
    "_ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef",
    {
        "cost": ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargescostTypeDef,
        "frequency": str,
    },
    total=False,
)


class ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef(
    _ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef
):
    """
    Type definition for `ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusoffering` `recurringCharges`

    Specifies whether charges for devices will be recurring.

    - **cost** *(dict) --*

      The cost of the recurring charge.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S.
        dollars."

    - **frequency** *(string) --*

      The frequency in which charges will recur.
    """


_ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingTypeDef = TypedDict(
    "_ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingTypeDef",
    {
        "id": str,
        "description": str,
        "type": str,
        "platform": str,
        "recurringCharges": List[
            ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingrecurringChargesTypeDef
        ],
    },
    total=False,
)


class ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingTypeDef(
    _ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingTypeDef
):
    """
    Type definition for `ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatus` `offering`

    Represents the metadata of an offering status.

    - **id** *(string) --*

      The ID that corresponds to a device offering.

    - **description** *(string) --*

      A string describing the offering.

    - **type** *(string) --*

      The type of offering (e.g., "RECURRING") for a device.

    - **platform** *(string) --*

      The platform of the device (e.g., ANDROID or IOS).

    - **recurringCharges** *(list) --*

      Specifies whether there are recurring charges for the offering.

      - *(dict) --*

        Specifies whether charges for devices will be recurring.

        - **cost** *(dict) --*

          The cost of the recurring charge.

          - **amount** *(float) --*

            The numerical amount of an offering or transaction.

          - **currencyCode** *(string) --*

            The currency code of a monetary amount. For example, ``USD`` means "U.S.
            dollars."

        - **frequency** *(string) --*

          The frequency in which charges will recur.
    """


_ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusTypeDef = TypedDict(
    "_ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusTypeDef",
    {
        "type": str,
        "offering": ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusofferingTypeDef,
        "quantity": int,
        "effectiveOn": datetime,
    },
    total=False,
)


class ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusTypeDef(
    _ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusTypeDef
):
    """
    Type definition for `ListOfferingTransactionsPaginateResponseofferingTransactions` `offeringStatus`

    The status of an offering transaction.

    - **type** *(string) --*

      The type specified for the offering status.

    - **offering** *(dict) --*

      Represents the metadata of an offering status.

      - **id** *(string) --*

        The ID that corresponds to a device offering.

      - **description** *(string) --*

        A string describing the offering.

      - **type** *(string) --*

        The type of offering (e.g., "RECURRING") for a device.

      - **platform** *(string) --*

        The platform of the device (e.g., ANDROID or IOS).

      - **recurringCharges** *(list) --*

        Specifies whether there are recurring charges for the offering.

        - *(dict) --*

          Specifies whether charges for devices will be recurring.

          - **cost** *(dict) --*

            The cost of the recurring charge.

            - **amount** *(float) --*

              The numerical amount of an offering or transaction.

            - **currencyCode** *(string) --*

              The currency code of a monetary amount. For example, ``USD`` means "U.S.
              dollars."

          - **frequency** *(string) --*

            The frequency in which charges will recur.

    - **quantity** *(integer) --*

      The number of available devices in the offering.

    - **effectiveOn** *(datetime) --*

      The date on which the offering is effective.
    """


_ListOfferingTransactionsPaginateResponseofferingTransactionsTypeDef = TypedDict(
    "_ListOfferingTransactionsPaginateResponseofferingTransactionsTypeDef",
    {
        "offeringStatus": ListOfferingTransactionsPaginateResponseofferingTransactionsofferingStatusTypeDef,
        "transactionId": str,
        "offeringPromotionId": str,
        "createdOn": datetime,
        "cost": ListOfferingTransactionsPaginateResponseofferingTransactionscostTypeDef,
    },
    total=False,
)


class ListOfferingTransactionsPaginateResponseofferingTransactionsTypeDef(
    _ListOfferingTransactionsPaginateResponseofferingTransactionsTypeDef
):
    """
    Type definition for `ListOfferingTransactionsPaginateResponse` `offeringTransactions`

    Represents the metadata of an offering transaction.

    - **offeringStatus** *(dict) --*

      The status of an offering transaction.

      - **type** *(string) --*

        The type specified for the offering status.

      - **offering** *(dict) --*

        Represents the metadata of an offering status.

        - **id** *(string) --*

          The ID that corresponds to a device offering.

        - **description** *(string) --*

          A string describing the offering.

        - **type** *(string) --*

          The type of offering (e.g., "RECURRING") for a device.

        - **platform** *(string) --*

          The platform of the device (e.g., ANDROID or IOS).

        - **recurringCharges** *(list) --*

          Specifies whether there are recurring charges for the offering.

          - *(dict) --*

            Specifies whether charges for devices will be recurring.

            - **cost** *(dict) --*

              The cost of the recurring charge.

              - **amount** *(float) --*

                The numerical amount of an offering or transaction.

              - **currencyCode** *(string) --*

                The currency code of a monetary amount. For example, ``USD`` means "U.S.
                dollars."

            - **frequency** *(string) --*

              The frequency in which charges will recur.

      - **quantity** *(integer) --*

        The number of available devices in the offering.

      - **effectiveOn** *(datetime) --*

        The date on which the offering is effective.

    - **transactionId** *(string) --*

      The transaction ID of the offering transaction.

    - **offeringPromotionId** *(string) --*

      The ID that corresponds to a device offering promotion.

    - **createdOn** *(datetime) --*

      The date on which an offering transaction was created.

    - **cost** *(dict) --*

      The cost of an offering transaction.

      - **amount** *(float) --*

        The numerical amount of an offering or transaction.

      - **currencyCode** *(string) --*

        The currency code of a monetary amount. For example, ``USD`` means "U.S. dollars."
    """


_ListOfferingTransactionsPaginateResponseTypeDef = TypedDict(
    "_ListOfferingTransactionsPaginateResponseTypeDef",
    {
        "offeringTransactions": List[
            ListOfferingTransactionsPaginateResponseofferingTransactionsTypeDef
        ],
        "NextToken": str,
    },
    total=False,
)


class ListOfferingTransactionsPaginateResponseTypeDef(
    _ListOfferingTransactionsPaginateResponseTypeDef
):
    """
    Type definition for `ListOfferingTransactionsPaginate` `Response`

    Returns the transaction log of the specified offerings.

    - **offeringTransactions** *(list) --*

      The audit log of subscriptions you have purchased and modified through AWS Device Farm.

      - *(dict) --*

        Represents the metadata of an offering transaction.

        - **offeringStatus** *(dict) --*

          The status of an offering transaction.

          - **type** *(string) --*

            The type specified for the offering status.

          - **offering** *(dict) --*

            Represents the metadata of an offering status.

            - **id** *(string) --*

              The ID that corresponds to a device offering.

            - **description** *(string) --*

              A string describing the offering.

            - **type** *(string) --*

              The type of offering (e.g., "RECURRING") for a device.

            - **platform** *(string) --*

              The platform of the device (e.g., ANDROID or IOS).

            - **recurringCharges** *(list) --*

              Specifies whether there are recurring charges for the offering.

              - *(dict) --*

                Specifies whether charges for devices will be recurring.

                - **cost** *(dict) --*

                  The cost of the recurring charge.

     