<a id="mypy-boto3-ses"></a>

# mypy-boto3-ses

[![PyPI - mypy-boto3-ses](https://img.shields.io/pypi/v/mypy-boto3-ses.svg?color=blue)](https://pypi.org/project/mypy-boto3-ses)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ses.svg?color=blue)](https://pypi.org/project/mypy-boto3-ses)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-ses?color=blue)](https://pypistats.org/packages/mypy-boto3-ses)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SES 1.17.103](https://boto3.amazonaws.com/v1/documentation/api/1.17.103/reference/services/ses.html#SES)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.22.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ses docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ses/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ses](#mypy-boto3-ses)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `SES` service.

```bash
python -m pip install boto3-stubs[ses]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ses]` in your environment:
  `python -m pip install 'boto3-stubs[ses]'`

Both type checking and auto-complete should work for `SES` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[ses]` in your environment:
  `python -m pip install 'boto3-stubs[ses]'`

Both type checking and auto-complete should work for `SES` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ses]` in your environment:
  `python -m pip install 'boto3-stubs[ses]'`
- Run `mypy` as usual

Type checking should work for `SES` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ses]` in your environment:
  `python -m pip install 'boto3-stubs[ses]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SES` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`SESClient` provides annotations for `boto3.client("ses")`.

```python
import boto3

from mypy_boto3_ses import SESClient

client: SESClient = boto3.client("ses")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SESClient = session.client("ses")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_ses.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_ses import SESClient
from mypy_boto3_ses.paginator import (
    ListConfigurationSetsPaginator,
    ListCustomVerificationEmailTemplatesPaginator,
    ListIdentitiesPaginator,
    ListReceiptRuleSetsPaginator,
    ListTemplatesPaginator,
)

client: SESClient = boto3.client("ses")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_configuration_sets_paginator: ListConfigurationSetsPaginator = client.get_paginator("list_configuration_sets")
list_custom_verification_email_templates_paginator: ListCustomVerificationEmailTemplatesPaginator = client.get_paginator("list_custom_verification_email_templates")
list_identities_paginator: ListIdentitiesPaginator = client.get_paginator("list_identities")
list_receipt_rule_sets_paginator: ListReceiptRuleSetsPaginator = client.get_paginator("list_receipt_rule_sets")
list_templates_paginator: ListTemplatesPaginator = client.get_paginator("list_templates")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_ses.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_ses import SESClient
from mypy_boto3_ses.waiter import (
    IdentityExistsWaiter,
)

client: SESClient = boto3.client("ses")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
identity_exists_waiter: IdentityExistsWaiter = client.get_waiter("identity_exists")
```

<a id="literals"></a>

### Literals

`mypy_boto3_ses.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_ses.literals import (
    BehaviorOnMXFailureType,
    BounceTypeType,
    BulkEmailStatusType,
    ConfigurationSetAttributeType,
    CustomMailFromStatusType,
    DimensionValueSourceType,
    DsnActionType,
    EventTypeType,
    IdentityExistsWaiterName,
    IdentityTypeType,
    InvocationTypeType,
    ListConfigurationSetsPaginatorName,
    ListCustomVerificationEmailTemplatesPaginatorName,
    ListIdentitiesPaginatorName,
    ListReceiptRuleSetsPaginatorName,
    ListTemplatesPaginatorName,
    NotificationTypeType,
    ReceiptFilterPolicyType,
    SNSActionEncodingType,
    StopScopeType,
    TlsPolicyType,
    VerificationStatusType,
)

def check_value(value: BehaviorOnMXFailureType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_ses.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_ses.type_defs import (
    AddHeaderActionTypeDef,
    BodyTypeDef,
    BounceActionTypeDef,
    BouncedRecipientInfoTypeDef,
    BulkEmailDestinationStatusTypeDef,
    BulkEmailDestinationTypeDef,
    CloneReceiptRuleSetRequestRequestTypeDef,
    CloudWatchDestinationTypeDef,
    CloudWatchDimensionConfigurationTypeDef,
    ConfigurationSetTypeDef,
    ContentTypeDef,
    CreateConfigurationSetEventDestinationRequestRequestTypeDef,
    CreateConfigurationSetRequestRequestTypeDef,
    CreateConfigurationSetTrackingOptionsRequestRequestTypeDef,
    CreateCustomVerificationEmailTemplateRequestRequestTypeDef,
    CreateReceiptFilterRequestRequestTypeDef,
    CreateReceiptRuleRequestRequestTypeDef,
    CreateReceiptRuleSetRequestRequestTypeDef,
    CreateTemplateRequestRequestTypeDef,
    CustomVerificationEmailTemplateTypeDef,
    DeleteConfigurationSetEventDestinationRequestRequestTypeDef,
    DeleteConfigurationSetRequestRequestTypeDef,
    DeleteConfigurationSetTrackingOptionsRequestRequestTypeDef,
    DeleteCustomVerificationEmailTemplateRequestRequestTypeDef,
    DeleteIdentityPolicyRequestRequestTypeDef,
    DeleteIdentityRequestRequestTypeDef,
    DeleteReceiptFilterRequestRequestTypeDef,
    DeleteReceiptRuleRequestRequestTypeDef,
    DeleteReceiptRuleSetRequestRequestTypeDef,
    DeleteTemplateRequestRequestTypeDef,
    DeleteVerifiedEmailAddressRequestRequestTypeDef,
    DeliveryOptionsTypeDef,
    DescribeActiveReceiptRuleSetResponseTypeDef,
    DescribeConfigurationSetRequestRequestTypeDef,
    DescribeConfigurationSetResponseTypeDef,
    DescribeReceiptRuleRequestRequestTypeDef,
    DescribeReceiptRuleResponseTypeDef,
    DescribeReceiptRuleSetRequestRequestTypeDef,
    DescribeReceiptRuleSetResponseTypeDef,
    DestinationTypeDef,
    EventDestinationTypeDef,
    ExtensionFieldTypeDef,
    GetAccountSendingEnabledResponseTypeDef,
    GetCustomVerificationEmailTemplateRequestRequestTypeDef,
    GetCustomVerificationEmailTemplateResponseTypeDef,
    GetIdentityDkimAttributesRequestRequestTypeDef,
    GetIdentityDkimAttributesResponseTypeDef,
    GetIdentityMailFromDomainAttributesRequestRequestTypeDef,
    GetIdentityMailFromDomainAttributesResponseTypeDef,
    GetIdentityNotificationAttributesRequestRequestTypeDef,
    GetIdentityNotificationAttributesResponseTypeDef,
    GetIdentityPoliciesRequestRequestTypeDef,
    GetIdentityPoliciesResponseTypeDef,
    GetIdentityVerificationAttributesRequestRequestTypeDef,
    GetIdentityVerificationAttributesResponseTypeDef,
    GetSendQuotaResponseTypeDef,
    GetSendStatisticsResponseTypeDef,
    GetTemplateRequestRequestTypeDef,
    GetTemplateResponseTypeDef,
    IdentityDkimAttributesTypeDef,
    IdentityMailFromDomainAttributesTypeDef,
    IdentityNotificationAttributesTypeDef,
    IdentityVerificationAttributesTypeDef,
    KinesisFirehoseDestinationTypeDef,
    LambdaActionTypeDef,
    ListConfigurationSetsRequestRequestTypeDef,
    ListConfigurationSetsResponseTypeDef,
    ListCustomVerificationEmailTemplatesRequestRequestTypeDef,
    ListCustomVerificationEmailTemplatesResponseTypeDef,
    ListIdentitiesRequestRequestTypeDef,
    ListIdentitiesResponseTypeDef,
    ListIdentityPoliciesRequestRequestTypeDef,
    ListIdentityPoliciesResponseTypeDef,
    ListReceiptFiltersResponseTypeDef,
    ListReceiptRuleSetsRequestRequestTypeDef,
    ListReceiptRuleSetsResponseTypeDef,
    ListTemplatesRequestRequestTypeDef,
    ListTemplatesResponseTypeDef,
    ListVerifiedEmailAddressesResponseTypeDef,
    MessageDsnTypeDef,
    MessageTagTypeDef,
    MessageTypeDef,
    PaginatorConfigTypeDef,
    PutConfigurationSetDeliveryOptionsRequestRequestTypeDef,
    PutIdentityPolicyRequestRequestTypeDef,
    RawMessageTypeDef,
    ReceiptActionTypeDef,
    ReceiptFilterTypeDef,
    ReceiptIpFilterTypeDef,
    ReceiptRuleSetMetadataTypeDef,
    ReceiptRuleTypeDef,
    RecipientDsnFieldsTypeDef,
    ReorderReceiptRuleSetRequestRequestTypeDef,
    ReputationOptionsTypeDef,
    ResponseMetadataTypeDef,
    S3ActionTypeDef,
    SNSActionTypeDef,
    SNSDestinationTypeDef,
    SendBounceRequestRequestTypeDef,
    SendBounceResponseTypeDef,
    SendBulkTemplatedEmailRequestRequestTypeDef,
    SendBulkTemplatedEmailResponseTypeDef,
    SendCustomVerificationEmailRequestRequestTypeDef,
    SendCustomVerificationEmailResponseTypeDef,
    SendDataPointTypeDef,
    SendEmailRequestRequestTypeDef,
    SendEmailResponseTypeDef,
    SendRawEmailRequestRequestTypeDef,
    SendRawEmailResponseTypeDef,
    SendTemplatedEmailRequestRequestTypeDef,
    SendTemplatedEmailResponseTypeDef,
    SetActiveReceiptRuleSetRequestRequestTypeDef,
    SetIdentityDkimEnabledRequestRequestTypeDef,
    SetIdentityFeedbackForwardingEnabledRequestRequestTypeDef,
    SetIdentityHeadersInNotificationsEnabledRequestRequestTypeDef,
    SetIdentityMailFromDomainRequestRequestTypeDef,
    SetIdentityNotificationTopicRequestRequestTypeDef,
    SetReceiptRulePositionRequestRequestTypeDef,
    StopActionTypeDef,
    TemplateMetadataTypeDef,
    TemplateTypeDef,
    TestRenderTemplateRequestRequestTypeDef,
    TestRenderTemplateResponseTypeDef,
    TrackingOptionsTypeDef,
    UpdateAccountSendingEnabledRequestRequestTypeDef,
    UpdateConfigurationSetEventDestinationRequestRequestTypeDef,
    UpdateConfigurationSetReputationMetricsEnabledRequestRequestTypeDef,
    UpdateConfigurationSetSendingEnabledRequestRequestTypeDef,
    UpdateConfigurationSetTrackingOptionsRequestRequestTypeDef,
    UpdateCustomVerificationEmailTemplateRequestRequestTypeDef,
    UpdateReceiptRuleRequestRequestTypeDef,
    UpdateTemplateRequestRequestTypeDef,
    VerifyDomainDkimRequestRequestTypeDef,
    VerifyDomainDkimResponseTypeDef,
    VerifyDomainIdentityRequestRequestTypeDef,
    VerifyDomainIdentityResponseTypeDef,
    VerifyEmailAddressRequestRequestTypeDef,
    VerifyEmailIdentityRequestRequestTypeDef,
    WaiterConfigTypeDef,
    WorkmailActionTypeDef,
)

def get_structure() -> AddHeaderActionTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-ses` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-ses docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ses/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
