window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"picopyn": {"fullname": "picopyn", "modulename": "picopyn", "kind": "module", "doc": "<p></p>\n"}, "picopyn.Client": {"fullname": "picopyn.Client", "modulename": "picopyn", "qualname": "Client", "kind": "class", "doc": "<p>Async client for managing connections to a picodata cluster using a connection pool.</p>\n\n<p>This client handles connection pooling, automatic node discovery (if enabled),\nand supports load balancing strategies for query distribution.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>dsn (str): The data source name (e.g., \"postgresql://user:pass@host</strong>: port\") for the cluster.</li>\n<li><strong>balance_strategy (callable, optional)</strong>:  A custom strategy function to select a connection\nfrom the pool. If None, round-robin strategy is used.</li>\n<li><strong>connect_kwargs</strong>:  Additional keyword arguments passed to each connection.</li>\n</ul>\n\n<p>Example:</p>\n\n<blockquote>\n  <blockquote>\n    <blockquote>\n      <p>def random_strategy(connections):\n          ...     import random\n          ...     return random.choice(connections)</p>\n\n<pre><code>&gt;&gt;&gt; client = Client(\n...     dsn=\"postgresql://admin:pass@localhost:5432\",\n...     balance_strategy=random_strategy\n... )\n</code></pre>\n    </blockquote>\n  </blockquote>\n</blockquote>\n"}, "picopyn.Client.__init__": {"fullname": "picopyn.Client.__init__", "modulename": "picopyn", "qualname": "Client.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">dsn</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">pool_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">balance_strategy</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">picopyn</span><span class=\"o\">.</span><span class=\"n\">connection</span><span class=\"o\">.</span><span class=\"n\">Connection</span><span class=\"p\">]],</span> <span class=\"n\">picopyn</span><span class=\"o\">.</span><span class=\"n\">connection</span><span class=\"o\">.</span><span class=\"n\">Connection</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">connect_kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span>)</span>"}, "picopyn.Client.connect": {"fullname": "picopyn.Client.connect", "modulename": "picopyn", "qualname": "Client.connect", "kind": "function", "doc": "<p>Prepares the client by connection connection pool.</p>\n\n<p>This should be called before using the client to ensure connections are available.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "async def"}, "picopyn.Client.execute": {"fullname": "picopyn.Client.execute", "modulename": "picopyn", "qualname": "Client.execute", "kind": "function", "doc": "<p>Executes a query that does not return rows (e.g. INSERT, UPDATE, DELETE).</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query</strong>:  The SQL query string.</li>\n<li><strong>args</strong>:  Optional parameters for the SQL query.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>The result of the query execution.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, "picopyn.Client.fetch": {"fullname": "picopyn.Client.fetch", "modulename": "picopyn", "qualname": "Client.fetch", "kind": "function", "doc": "<p>Executes a query and fetches all resulting rows.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query</strong>:  The SQL query string.</li>\n<li><strong>args</strong>:  Optional parameters for the SQL query.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>A list of rows returned by the query.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">asyncpg</span><span class=\"o\">.</span><span class=\"n\">Record</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, "picopyn.Client.fetchrow": {"fullname": "picopyn.Client.fetchrow", "modulename": "picopyn", "qualname": "Client.fetchrow", "kind": "function", "doc": "<p>Executes a query and fetches a single row (first row).</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query</strong>:  The SQL query string.</li>\n<li><strong>args</strong>:  Optional parameters for the SQL query.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>A single row returned by the query.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">asyncpg</span><span class=\"o\">.</span><span class=\"n\">Record</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>:</span></span>", "funcdef": "async def"}, "picopyn.Client.close": {"fullname": "picopyn.Client.close", "modulename": "picopyn", "qualname": "Client.close", "kind": "function", "doc": "<p>Closes all connections in the pool.</p>\n\n<p>This should be called during application shutdown to clean up resources.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "async def"}, "picopyn.Connection": {"fullname": "picopyn.Connection", "modulename": "picopyn", "qualname": "Connection", "kind": "class", "doc": "<p>A representation of a database session.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>dsn (str):  The data source name (e.g., \"postgresql://user:pass@host</strong>: port\") for the picodata node.</li>\n</ul>\n"}, "picopyn.Connection.__init__": {"fullname": "picopyn.Connection.__init__", "modulename": "picopyn", "qualname": "Connection.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">dsn</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span>)</span>"}, "picopyn.Connection.dsn": {"fullname": "picopyn.Connection.dsn", "modulename": "picopyn", "qualname": "Connection.dsn", "kind": "variable", "doc": "<p></p>\n"}, "picopyn.Connection.conn": {"fullname": "picopyn.Connection.conn", "modulename": "picopyn", "qualname": "Connection.conn", "kind": "variable", "doc": "<p></p>\n"}, "picopyn.Connection.connect": {"fullname": "picopyn.Connection.connect", "modulename": "picopyn", "qualname": "Connection.connect", "kind": "function", "doc": "<p>Create new connection to Picodata</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "async def"}, "picopyn.Connection.execute": {"fullname": "picopyn.Connection.execute", "modulename": "picopyn", "qualname": "Connection.execute", "kind": "function", "doc": "<p>Execute an SQL command</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, "picopyn.Connection.fetchrow": {"fullname": "picopyn.Connection.fetchrow", "modulename": "picopyn", "qualname": "Connection.fetchrow", "kind": "function", "doc": "<p>Run a query and return the first row.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">asyncpg</span><span class=\"o\">.</span><span class=\"n\">Record</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>:</span></span>", "funcdef": "async def"}, "picopyn.Connection.fetch": {"fullname": "picopyn.Connection.fetch", "modulename": "picopyn", "qualname": "Connection.fetch", "kind": "function", "doc": "<p>Run a query and return the results as a list.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">asyncpg</span><span class=\"o\">.</span><span class=\"n\">Record</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, "picopyn.Connection.close": {"fullname": "picopyn.Connection.close", "modulename": "picopyn", "qualname": "Connection.close", "kind": "function", "doc": "<p>Close the connection gracefully.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "async def"}, "picopyn.Pool": {"fullname": "picopyn.Pool", "modulename": "picopyn", "qualname": "Pool", "kind": "class", "doc": "<p>A connection pool.</p>\n\n<p>Connection pool can be used to manage a set of connections to the database.\nConnections are first acquired from the pool, then used, and then released\nback to the pool</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>dsn (str):  The data source name (e.g., \"postgresql://user:pass@host</strong>: port\") for the cluster.</li>\n<li><strong>balance_strategy (callable, optional)</strong>:  A custom strategy function to select a connection\nfrom the pool. If None, round-robin strategy is used.</li>\n<li><strong>max_size (int)</strong>:  Maximum number of connections in the pool. Must be at least 1.</li>\n<li><strong>enable_discovery (bool)</strong>:  If True, the pool will automatically discover available\npicodata instances. If False, only the given <code>dsn</code> will be used.</li>\n<li><strong>balance_strategy (callable, optional)</strong>:  A function that selects a connection from the pool.\nIf None, a default round-robin strategy will be used.</li>\n</ul>\n"}, "picopyn.Pool.__init__": {"fullname": "picopyn.Pool.__init__", "modulename": "picopyn", "qualname": "Pool.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">dsn</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">max_size</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">enable_discovery</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">balance_strategy</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[</span><span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">picopyn</span><span class=\"o\">.</span><span class=\"n\">connection</span><span class=\"o\">.</span><span class=\"n\">Connection</span><span class=\"p\">]],</span> <span class=\"n\">picopyn</span><span class=\"o\">.</span><span class=\"n\">connection</span><span class=\"o\">.</span><span class=\"n\">Connection</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"o\">**</span><span class=\"n\">connect_kwargs</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span>)</span>"}, "picopyn.Pool.enable_discovery": {"fullname": "picopyn.Pool.enable_discovery", "modulename": "picopyn", "qualname": "Pool.enable_discovery", "kind": "variable", "doc": "<p></p>\n"}, "picopyn.Pool.connect": {"fullname": "picopyn.Pool.connect", "modulename": "picopyn", "qualname": "Pool.connect", "kind": "function", "doc": "<p>Prepares the pool by opening up to <code>max_size</code> connections.</p>\n\n<p>This should be called before using the pool to ensure connections are available.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "async def"}, "picopyn.Pool.acquire": {"fullname": "picopyn.Pool.acquire", "modulename": "picopyn", "qualname": "Pool.acquire", "kind": "function", "doc": "<p>Acquire a connection from the pool.</p>\n\n<p>If no connections are available, this method will wait until one is released.</p>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>A database connection.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">timeout</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">picopyn</span><span class=\"o\">.</span><span class=\"n\">connection</span><span class=\"o\">.</span><span class=\"n\">Connection</span>:</span></span>", "funcdef": "async def"}, "picopyn.Pool.release": {"fullname": "picopyn.Pool.release", "modulename": "picopyn", "qualname": "Pool.release", "kind": "function", "doc": "<p>Release a previously acquired connection back to the pool.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>conn</strong>:  The connection to release.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">conn</span><span class=\"p\">:</span> <span class=\"n\">picopyn</span><span class=\"o\">.</span><span class=\"n\">connection</span><span class=\"o\">.</span><span class=\"n\">Connection</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "async def"}, "picopyn.Pool.close": {"fullname": "picopyn.Pool.close", "modulename": "picopyn", "qualname": "Pool.close", "kind": "function", "doc": "<p>Closes all connections in the pool.</p>\n\n<p>This should be called during application shutdown to clean up resources.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"kc\">None</span>:</span></span>", "funcdef": "async def"}, "picopyn.Pool.execute": {"fullname": "picopyn.Pool.execute", "modulename": "picopyn", "qualname": "Pool.execute", "kind": "function", "doc": "<p>Executes a query that does not return rows (e.g. INSERT, UPDATE, DELETE).</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query</strong>:  The SQL query string.</li>\n<li><strong>args</strong>:  Optional parameters for the SQL query.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>The result of the query execution.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "async def"}, "picopyn.Pool.fetch": {"fullname": "picopyn.Pool.fetch", "modulename": "picopyn", "qualname": "Pool.fetch", "kind": "function", "doc": "<p>Executes a query and fetches all resulting rows.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query</strong>:  The SQL query string.</li>\n<li><strong>args</strong>:  Optional parameters for the SQL query.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>A list of rows returned by the query.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">asyncpg</span><span class=\"o\">.</span><span class=\"n\">Record</span><span class=\"p\">]</span>:</span></span>", "funcdef": "async def"}, "picopyn.Pool.fetchrow": {"fullname": "picopyn.Pool.fetchrow", "modulename": "picopyn", "qualname": "Pool.fetchrow", "kind": "function", "doc": "<p>Executes a query and fetches a single row (first row).</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>query</strong>:  The SQL query string.</li>\n<li><strong>args</strong>:  Optional parameters for the SQL query.</li>\n</ul>\n\n<h6 id=\"returns\">Returns</h6>\n\n<blockquote>\n  <p>A single row returned by the query.</p>\n</blockquote>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span></span><span class=\"return-annotation\">) -> <span class=\"n\">asyncpg</span><span class=\"o\">.</span><span class=\"n\">Record</span> <span class=\"o\">|</span> <span class=\"kc\">None</span>:</span></span>", "funcdef": "async def"}}, "docInfo": {"picopyn": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "picopyn.Client": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 151}, "picopyn.Client.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 115, "bases": 0, "doc": 3}, "picopyn.Client.connect": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 26}, "picopyn.Client.execute": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 61}, "picopyn.Client.fetch": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 58}, "picopyn.Client.fetchrow": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 59}, "picopyn.Client.close": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 23}, "picopyn.Connection": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 36}, "picopyn.Connection.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 3}, "picopyn.Connection.dsn": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "picopyn.Connection.conn": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "picopyn.Connection.connect": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 7}, "picopyn.Connection.execute": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 38, "bases": 0, "doc": 6}, "picopyn.Connection.fetchrow": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 11}, "picopyn.Connection.fetch": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 49, "bases": 0, "doc": 13}, "picopyn.Connection.close": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 38, "bases": 0, "doc": 7}, "picopyn.Pool": {"qualname": 1, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 172}, "picopyn.Pool.__init__": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 128, "bases": 0, "doc": 3}, "picopyn.Pool.enable_discovery": {"qualname": 3, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "picopyn.Pool.connect": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 31}, "picopyn.Pool.acquire": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 38}, "picopyn.Pool.release": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 34, "bases": 0, "doc": 29}, "picopyn.Pool.close": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 23}, "picopyn.Pool.execute": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 36, "bases": 0, "doc": 61}, "picopyn.Pool.fetch": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 58}, "picopyn.Pool.fetchrow": {"qualname": 2, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 47, "bases": 0, "doc": 59}}, "length": 27, "save": true}, "index": {"qualname": {"root": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Connection.__init__": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 3, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Client.__init__": {"tf": 1}, "picopyn.Client.connect": {"tf": 1}, "picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Client.close": {"tf": 1}}, "df": 7}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.close": {"tf": 1}, "picopyn.Connection.close": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 3}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Connection.conn": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Connection.connect": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Connection": {"tf": 1}, "picopyn.Connection.__init__": {"tf": 1}, "picopyn.Connection.dsn": {"tf": 1}, "picopyn.Connection.conn": {"tf": 1}, "picopyn.Connection.connect": {"tf": 1}, "picopyn.Connection.execute": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Connection.close": {"tf": 1}}, "df": 9}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Connection.__init__": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Connection.execute": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 3}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool.enable_discovery": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"picopyn.Client.fetch": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}}, "df": 3, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 3}}}}}}}}, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Connection.dsn": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"picopyn.Pool.enable_discovery": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Pool": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}, "picopyn.Pool.enable_discovery": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1}, "picopyn.Pool.release": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 10}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool.acquire": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool.release": {"tf": 1}}, "df": 1}}}}}}}}}, "fullname": {"root": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Connection.__init__": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 3, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {"picopyn": {"tf": 1}, "picopyn.Client": {"tf": 1}, "picopyn.Client.__init__": {"tf": 1}, "picopyn.Client.connect": {"tf": 1}, "picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Client.close": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Connection.__init__": {"tf": 1}, "picopyn.Connection.dsn": {"tf": 1}, "picopyn.Connection.conn": {"tf": 1}, "picopyn.Connection.connect": {"tf": 1}, "picopyn.Connection.execute": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Connection.close": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}, "picopyn.Pool.enable_discovery": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1}, "picopyn.Pool.release": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 27}}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Pool": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}, "picopyn.Pool.enable_discovery": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1}, "picopyn.Pool.release": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 10}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Client.__init__": {"tf": 1}, "picopyn.Client.connect": {"tf": 1}, "picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Client.close": {"tf": 1}}, "df": 7}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.close": {"tf": 1}, "picopyn.Connection.close": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 3}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Connection.conn": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Connection.connect": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Connection": {"tf": 1}, "picopyn.Connection.__init__": {"tf": 1}, "picopyn.Connection.dsn": {"tf": 1}, "picopyn.Connection.conn": {"tf": 1}, "picopyn.Connection.connect": {"tf": 1}, "picopyn.Connection.execute": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Connection.close": {"tf": 1}}, "df": 9}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Connection.__init__": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Connection.execute": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 3}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool.enable_discovery": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"picopyn.Client.fetch": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}}, "df": 3, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 3}}}}}}}}, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Connection.dsn": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"picopyn.Pool.enable_discovery": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool.acquire": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool.release": {"tf": 1}}, "df": 1}}}}}}}}}, "annotation": {"root": {"docs": {}, "df": 0}}, "default_value": {"root": {"docs": {}, "df": 0}}, "signature": {"root": {"1": {"0": {"docs": {"picopyn.Pool.__init__": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"picopyn.Client.__init__": {"tf": 9.643650760992955}, "picopyn.Client.connect": {"tf": 3.4641016151377544}, "picopyn.Client.execute": {"tf": 5.477225575051661}, "picopyn.Client.fetch": {"tf": 6.244997998398398}, "picopyn.Client.fetchrow": {"tf": 6.244997998398398}, "picopyn.Client.close": {"tf": 3.4641016151377544}, "picopyn.Connection.__init__": {"tf": 3.4641016151377544}, "picopyn.Connection.connect": {"tf": 3.4641016151377544}, "picopyn.Connection.execute": {"tf": 5.656854249492381}, "picopyn.Connection.fetchrow": {"tf": 6.4031242374328485}, "picopyn.Connection.fetch": {"tf": 6.4031242374328485}, "picopyn.Connection.close": {"tf": 5.656854249492381}, "picopyn.Pool.__init__": {"tf": 10.14889156509222}, "picopyn.Pool.connect": {"tf": 3.4641016151377544}, "picopyn.Pool.acquire": {"tf": 6.244997998398398}, "picopyn.Pool.release": {"tf": 5.291502622129181}, "picopyn.Pool.close": {"tf": 3.4641016151377544}, "picopyn.Pool.execute": {"tf": 5.477225575051661}, "picopyn.Pool.fetch": {"tf": 6.244997998398398}, "picopyn.Pool.fetchrow": {"tf": 6.244997998398398}}, "df": 20, "d": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Connection.__init__": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"picopyn.Pool.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Client.execute": {"tf": 1.4142135623730951}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Connection.__init__": {"tf": 1}, "picopyn.Connection.execute": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1.4142135623730951}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 10, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "y": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Client.close": {"tf": 1}, "picopyn.Connection.connect": {"tf": 1}, "picopyn.Connection.execute": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Connection.close": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1}, "picopyn.Pool.release": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 17}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Client.__init__": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client.__init__": {"tf": 1.4142135623730951}, "picopyn.Pool.__init__": {"tf": 1.4142135623730951}, "picopyn.Pool.acquire": {"tf": 1}, "picopyn.Pool.release": {"tf": 1}}, "df": 4}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 2}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.__init__": {"tf": 2}, "picopyn.Client.connect": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Client.close": {"tf": 1}, "picopyn.Connection.connect": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.close": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1.4142135623730951}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1.4142135623730951}, "picopyn.Pool.release": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 13}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Pool.__init__": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 2}}}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Pool.release": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client.__init__": {"tf": 2}, "picopyn.Pool.__init__": {"tf": 2}, "picopyn.Pool.acquire": {"tf": 1.4142135623730951}, "picopyn.Pool.release": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}}, "df": 5}}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Connection.execute": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Connection.close": {"tf": 1}, "picopyn.Pool.__init__": {"tf": 1}}, "df": 6}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"picopyn.Client.__init__": {"tf": 1}, "picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Connection.execute": {"tf": 1.4142135623730951}, "picopyn.Connection.fetchrow": {"tf": 1.4142135623730951}, "picopyn.Connection.fetch": {"tf": 1.4142135623730951}, "picopyn.Connection.close": {"tf": 1.4142135623730951}, "picopyn.Pool.__init__": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 12}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Connection.execute": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Connection.close": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 10}}}, "s": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "g": {"docs": {"picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 6}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 6}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 6}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"picopyn.Pool.__init__": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool.__init__": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool.__init__": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Pool.acquire": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Pool.acquire": {"tf": 1}}, "df": 1}}}}}}}}}, "bases": {"root": {"docs": {}, "df": 0}}, "doc": {"root": {"1": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}, "docs": {"picopyn": {"tf": 1.7320508075688772}, "picopyn.Client": {"tf": 7.280109889280518}, "picopyn.Client.__init__": {"tf": 1.7320508075688772}, "picopyn.Client.connect": {"tf": 2.449489742783178}, "picopyn.Client.execute": {"tf": 5.291502622129181}, "picopyn.Client.fetch": {"tf": 5.291502622129181}, "picopyn.Client.fetchrow": {"tf": 5.291502622129181}, "picopyn.Client.close": {"tf": 2.449489742783178}, "picopyn.Connection": {"tf": 3.872983346207417}, "picopyn.Connection.__init__": {"tf": 1.7320508075688772}, "picopyn.Connection.dsn": {"tf": 1.7320508075688772}, "picopyn.Connection.conn": {"tf": 1.7320508075688772}, "picopyn.Connection.connect": {"tf": 1.4142135623730951}, "picopyn.Connection.execute": {"tf": 1.4142135623730951}, "picopyn.Connection.fetchrow": {"tf": 1.7320508075688772}, "picopyn.Connection.fetch": {"tf": 1.7320508075688772}, "picopyn.Connection.close": {"tf": 1.7320508075688772}, "picopyn.Pool": {"tf": 6.557438524302}, "picopyn.Pool.__init__": {"tf": 1.7320508075688772}, "picopyn.Pool.enable_discovery": {"tf": 1.7320508075688772}, "picopyn.Pool.connect": {"tf": 2.8284271247461903}, "picopyn.Pool.acquire": {"tf": 3.872983346207417}, "picopyn.Pool.release": {"tf": 3.7416573867739413}, "picopyn.Pool.close": {"tf": 2.449489742783178}, "picopyn.Pool.execute": {"tf": 5.291502622129181}, "picopyn.Pool.fetch": {"tf": 5.291502622129181}, "picopyn.Pool.fetchrow": {"tf": 5.291502622129181}}, "df": 27, "a": {"docs": {"picopyn.Client": {"tf": 2}, "picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1.4142135623730951}, "picopyn.Client.fetchrow": {"tf": 1.7320508075688772}, "picopyn.Connection": {"tf": 1.4142135623730951}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1.4142135623730951}, "picopyn.Pool": {"tf": 2.6457513110645907}, "picopyn.Pool.acquire": {"tf": 1.4142135623730951}, "picopyn.Pool.release": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1.4142135623730951}, "picopyn.Pool.fetchrow": {"tf": 1.7320508075688772}}, "df": 13, "s": {"docs": {"picopyn.Connection.fetch": {"tf": 1}}, "df": 1, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "n": {"docs": {"picopyn.Connection.execute": {"tf": 1}}, "df": 1, "d": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 8}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 6}}, "e": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1}}, "df": 4}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1}}, "df": 4}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.close": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}}, "df": 4}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client.close": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 2}}}}}}}}}}, "c": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool.acquire": {"tf": 1}}, "df": 1, "d": {"docs": {"picopyn.Pool": {"tf": 1}, "picopyn.Pool.release": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client": {"tf": 2}, "picopyn.Client.connect": {"tf": 1.4142135623730951}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"picopyn.Client": {"tf": 1.4142135623730951}, "picopyn.Pool": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Connection.close": {"tf": 1}}, "df": 1, "s": {"docs": {"picopyn.Client.close": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client.close": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Pool.release": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client": {"tf": 2}, "picopyn.Client.connect": {"tf": 1.4142135623730951}, "picopyn.Connection.connect": {"tf": 1}, "picopyn.Connection.close": {"tf": 1}, "picopyn.Pool": {"tf": 2}, "picopyn.Pool.acquire": {"tf": 1.4142135623730951}, "picopyn.Pool.release": {"tf": 1.4142135623730951}}, "df": 7, "s": {"docs": {"picopyn.Client": {"tf": 1.7320508075688772}, "picopyn.Client.connect": {"tf": 1}, "picopyn.Client.close": {"tf": 1}, "picopyn.Pool": {"tf": 1.7320508075688772}, "picopyn.Pool.connect": {"tf": 1.4142135623730951}, "picopyn.Pool.acquire": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 7}}}}}}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"picopyn.Connection.execute": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Pool": {"tf": 1.4142135623730951}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Client.close": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 4}}}}, "n": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Pool": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Connection.connect": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"picopyn.Client": {"tf": 1.7320508075688772}, "picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 9}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Pool": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Pool": {"tf": 1.7320508075688772}, "picopyn.Pool.acquire": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 4}}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}, "x": {"docs": {"picopyn.Pool": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"picopyn.Pool.acquire": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {"picopyn.Client": {"tf": 1.7320508075688772}, "picopyn.Client.connect": {"tf": 1}, "picopyn.Client.close": {"tf": 1}, "picopyn.Connection.connect": {"tf": 1}, "picopyn.Pool": {"tf": 2}, "picopyn.Pool.connect": {"tf": 1.4142135623730951}, "picopyn.Pool.release": {"tf": 1.4142135623730951}, "picopyn.Pool.close": {"tf": 1}}, "df": 8}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Client.connect": {"tf": 1}, "picopyn.Client.close": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 6}}, "e": {"docs": {"picopyn.Client": {"tf": 1.7320508075688772}, "picopyn.Client.connect": {"tf": 1.4142135623730951}, "picopyn.Client.execute": {"tf": 2}, "picopyn.Client.fetch": {"tf": 1.7320508075688772}, "picopyn.Client.fetchrow": {"tf": 1.7320508075688772}, "picopyn.Client.close": {"tf": 1}, "picopyn.Connection": {"tf": 1.4142135623730951}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Connection.close": {"tf": 1}, "picopyn.Pool": {"tf": 3.1622776601683795}, "picopyn.Pool.connect": {"tf": 1.4142135623730951}, "picopyn.Pool.acquire": {"tf": 1}, "picopyn.Pool.release": {"tf": 1.4142135623730951}, "picopyn.Pool.close": {"tf": 1}, "picopyn.Pool.execute": {"tf": 2}, "picopyn.Pool.fetch": {"tf": 1.7320508075688772}, "picopyn.Pool.fetchrow": {"tf": 1.7320508075688772}}, "df": 18, "n": {"docs": {"picopyn.Pool": {"tf": 1.4142135623730951}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Connection.connect": {"tf": 1}, "picopyn.Pool": {"tf": 1}}, "df": 4}}}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Client": {"tf": 1.4142135623730951}, "picopyn.Client.connect": {"tf": 1}, "picopyn.Client.close": {"tf": 1}, "picopyn.Pool": {"tf": 2.8284271247461903}, "picopyn.Pool.connect": {"tf": 1.4142135623730951}, "picopyn.Pool.acquire": {"tf": 1}, "picopyn.Pool.release": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 8, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "@": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1}}, "df": 3}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "@": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, ":": {"5": {"4": {"3": {"2": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Client.execute": {"tf": 1.4142135623730951}, "picopyn.Client.fetch": {"tf": 1.4142135623730951}, "picopyn.Client.fetchrow": {"tf": 1.4142135623730951}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.release": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1.4142135623730951}, "picopyn.Pool.fetch": {"tf": 1.4142135623730951}, "picopyn.Pool.fetchrow": {"tf": 1.4142135623730951}}, "df": 10}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"picopyn.Pool.release": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Client.connect": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Pool": {"tf": 2.23606797749979}}, "df": 2}}}, "p": {"docs": {"picopyn.Client.close": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 3, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Pool.acquire": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {"picopyn.Pool.acquire": {"tf": 1}}, "df": 1, "d": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Connection": {"tf": 1}}, "df": 2}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Pool": {"tf": 1.4142135623730951}}, "df": 2}}, "t": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"picopyn.Connection.connect": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1, "y": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Pool": {"tf": 1}}, "df": 2}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client": {"tf": 1.4142135623730951}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1.4142135623730951}}, "df": 3}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1}}, "df": 3, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1}}, "df": 3}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"picopyn.Client.close": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {"picopyn.Client": {"tf": 1.4142135623730951}, "picopyn.Pool": {"tf": 2}, "picopyn.Pool.acquire": {"tf": 1}}, "df": 3}, "s": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1}}, "df": 3}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {"picopyn.Client.close": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 3, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Client.execute": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 5, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1, "d": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Connection.execute": {"tf": 1}}, "df": 1, "s": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 6}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 2}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"picopyn.Client": {"tf": 2.449489742783178}, "picopyn.Pool": {"tf": 2.23606797749979}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 6}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Pool": {"tf": 1}}, "df": 2, "s": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Connection": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Client.close": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 4}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client.close": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 2}}}}}}}, "q": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Client.execute": {"tf": 1.4142135623730951}, "picopyn.Client.fetch": {"tf": 1.4142135623730951}, "picopyn.Client.fetchrow": {"tf": 1.4142135623730951}, "picopyn.Connection.execute": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1.4142135623730951}, "picopyn.Pool.fetch": {"tf": 1.4142135623730951}, "picopyn.Pool.fetchrow": {"tf": 1.4142135623730951}}, "df": 7}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.fetchrow": {"tf": 1.4142135623730951}, "picopyn.Pool.fetchrow": {"tf": 1.4142135623730951}}, "df": 2}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.fetch": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"picopyn.Client": {"tf": 1.4142135623730951}, "picopyn.Pool": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"picopyn.Pool": {"tf": 1}, "picopyn.Pool.release": {"tf": 1}}, "df": 2}}}, "y": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 6}, "e": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Client.close": {"tf": 1}, "picopyn.Pool": {"tf": 2}, "picopyn.Pool.connect": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 5, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Client.connect": {"tf": 1}, "picopyn.Pool.connect": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Client.execute": {"tf": 2.23606797749979}, "picopyn.Client.fetch": {"tf": 2.23606797749979}, "picopyn.Client.fetchrow": {"tf": 2.23606797749979}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Pool.execute": {"tf": 2.23606797749979}, "picopyn.Pool.fetch": {"tf": 2.23606797749979}, "picopyn.Pool.fetchrow": {"tf": 2.23606797749979}}, "df": 9}}}}}, "g": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Client.execute": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 5, "t": {"docs": {"picopyn.Client": {"tf": 1.7320508075688772}}, "df": 1}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"picopyn.Connection.close": {"tf": 1}}, "df": 1}}}}}}}}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Pool": {"tf": 1.4142135623730951}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 8}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"picopyn.Pool.connect": {"tf": 1}}, "df": 1}}}}}}, "f": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Connection": {"tf": 1}, "picopyn.Pool": {"tf": 1.4142135623730951}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}}, "df": 6}, "n": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"picopyn.Pool": {"tf": 1}}, "df": 1}}, "e": {"docs": {"picopyn.Pool.acquire": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Pool": {"tf": 1.4142135623730951}}, "df": 2}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Pool": {"tf": 1.4142135623730951}}, "df": 2}}}, "w": {"docs": {"picopyn.Client.fetchrow": {"tf": 1.7320508075688772}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1.7320508075688772}}, "df": 3, "s": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1.4142135623730951}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1.4142135623730951}}, "df": 4}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"picopyn.Client": {"tf": 2}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Client": {"tf": 1}, "picopyn.Client.execute": {"tf": 1}, "picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 5, "s": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 7}, "e": {"docs": {}, "df": 0, "d": {"docs": {"picopyn.Client.fetch": {"tf": 1}, "picopyn.Client.fetchrow": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}, "picopyn.Pool.fetchrow": {"tf": 1}}, "df": 4}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Client.execute": {"tf": 1}, "picopyn.Pool.execute": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"picopyn.Client.fetch": {"tf": 1}, "picopyn.Pool.fetch": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"picopyn.Connection.fetch": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client.close": {"tf": 1}, "picopyn.Pool.close": {"tf": 1}}, "df": 2}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Connection": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"picopyn.Pool.release": {"tf": 1.4142135623730951}}, "df": 1, "d": {"docs": {"picopyn.Pool": {"tf": 1}, "picopyn.Pool.acquire": {"tf": 1}}, "df": 2}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"picopyn.Connection.fetchrow": {"tf": 1}, "picopyn.Connection.fetch": {"tf": 1}}, "df": 2}}}, "k": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"picopyn.Client": {"tf": 1}}, "df": 1}}}}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"picopyn.Pool": {"tf": 1.7320508075688772}, "picopyn.Pool.acquire": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"picopyn.Pool.acquire": {"tf": 1}}, "df": 1}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();