# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, Any


class AccessTokenRequest(TeaModel):
    def __init__(
        self,
        app_key: str = None,
        app_secret: str = None,
    ):
        self.app_key = app_key
        self.app_secret = app_secret

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key is not None:
            result['app_key'] = self.app_key
        if self.app_secret is not None:
            result['app_secret'] = self.app_secret
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_key') is not None:
            self.app_key = m.get('app_key')
        if m.get('app_secret') is not None:
            self.app_secret = m.get('app_secret')
        return self


class AccessTokenResponseBodyData(TeaModel):
    def __init__(
        self,
        expire: int = None,
        token: str = None,
    ):
        self.expire = expire
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class AccessTokenResponseBodyModule(TeaModel):
    def __init__(
        self,
        expire: int = None,
        start: int = None,
        token: str = None,
    ):
        self.expire = expire
        self.start = start
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.start is not None:
            result['start'] = self.start
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class AccessTokenResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AccessTokenResponseBodyData = None,
        message: str = None,
        module: AccessTokenResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = AccessTokenResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AccessTokenResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AccessTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AccessTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AccessTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddInvoiceEntityHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class AddInvoiceEntityRequestEntities(TeaModel):
    def __init__(
        self,
        entity_id: str = None,
        entity_name: str = None,
        entity_type: str = None,
    ):
        self.entity_id = entity_id
        self.entity_name = entity_name
        self.entity_type = entity_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_name is not None:
            result['entity_name'] = self.entity_name
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_name') is not None:
            self.entity_name = m.get('entity_name')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        return self


class AddInvoiceEntityRequest(TeaModel):
    def __init__(
        self,
        entities: List[AddInvoiceEntityRequestEntities] = None,
        third_part_id: str = None,
    ):
        self.entities = entities
        self.third_part_id = third_part_id

    def validate(self):
        if self.entities:
            for k in self.entities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['entities'] = []
        if self.entities is not None:
            for k in self.entities:
                result['entities'].append(k.to_map() if k else None)
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.entities = []
        if m.get('entities') is not None:
            for k in m.get('entities'):
                temp_model = AddInvoiceEntityRequestEntities()
                self.entities.append(temp_model.from_map(k))
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        return self


class AddInvoiceEntityShrinkRequest(TeaModel):
    def __init__(
        self,
        entities_shrink: str = None,
        third_part_id: str = None,
    ):
        self.entities_shrink = entities_shrink
        self.third_part_id = third_part_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entities_shrink is not None:
            result['entities'] = self.entities_shrink
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entities') is not None:
            self.entities_shrink = m.get('entities')
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        return self


class AddInvoiceEntityResponseBodyModule(TeaModel):
    def __init__(
        self,
        add_num: int = None,
        selected_user_num: int = None,
    ):
        self.add_num = add_num
        self.selected_user_num = selected_user_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_num is not None:
            result['add_num'] = self.add_num
        if self.selected_user_num is not None:
            result['selected_user_num'] = self.selected_user_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('add_num') is not None:
            self.add_num = m.get('add_num')
        if m.get('selected_user_num') is not None:
            self.selected_user_num = m.get('selected_user_num')
        return self


class AddInvoiceEntityResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: AddInvoiceEntityResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AddInvoiceEntityResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AddInvoiceEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddInvoiceEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddInvoiceEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddressGetHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class AddressGetRequest(TeaModel):
    def __init__(
        self,
        action_type: int = None,
        itinerary_id: str = None,
        phone: str = None,
        sub_corp_id: str = None,
        type: int = None,
        user_id: str = None,
    ):
        self.action_type = action_type
        self.itinerary_id = itinerary_id
        self.phone = phone
        self.sub_corp_id = sub_corp_id
        self.type = type
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_type is not None:
            result['action_type'] = self.action_type
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.phone is not None:
            result['phone'] = self.phone
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        if self.type is not None:
            result['type'] = self.type
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('action_type') is not None:
            self.action_type = m.get('action_type')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class AddressGetResponseBodyModule(TeaModel):
    def __init__(
        self,
        url: str = None,
    ):
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.url is not None:
            result['url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('url') is not None:
            self.url = m.get('url')
        return self


class AddressGetResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: AddressGetResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AddressGetResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AddressGetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddressGetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddressGetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AirportSearchHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class AirportSearchRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        type: int = None,
    ):
        self.keyword = keyword
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['keyword'] = self.keyword
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class AirportSearchResponseBodyModuleCities(TeaModel):
    def __init__(
        self,
        code: str = None,
        distance: int = None,
        name: str = None,
        travel_name: str = None,
    ):
        self.code = code
        self.distance = distance
        self.name = name
        self.travel_name = travel_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.distance is not None:
            result['distance'] = self.distance
        if self.name is not None:
            result['name'] = self.name
        if self.travel_name is not None:
            result['travel_name'] = self.travel_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('distance') is not None:
            self.distance = m.get('distance')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('travel_name') is not None:
            self.travel_name = m.get('travel_name')
        return self


class AirportSearchResponseBodyModule(TeaModel):
    def __init__(
        self,
        cities: List[AirportSearchResponseBodyModuleCities] = None,
        nearby: bool = None,
    ):
        self.cities = cities
        self.nearby = nearby

    def validate(self):
        if self.cities:
            for k in self.cities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cities'] = []
        if self.cities is not None:
            for k in self.cities:
                result['cities'].append(k.to_map() if k else None)
        if self.nearby is not None:
            result['nearby'] = self.nearby
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cities = []
        if m.get('cities') is not None:
            for k in m.get('cities'):
                temp_model = AirportSearchResponseBodyModuleCities()
                self.cities.append(temp_model.from_map(k))
        if m.get('nearby') is not None:
            self.nearby = m.get('nearby')
        return self


class AirportSearchResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: AirportSearchResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AirportSearchResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AirportSearchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AirportSearchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AirportSearchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllBaseCityInfoQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_access_token = x_acs_btrip_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_access_token is not None:
            result['x-acs-btrip-access-token'] = self.x_acs_btrip_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-access-token') is not None:
            self.x_acs_btrip_access_token = m.get('x-acs-btrip-access-token')
        return self


class AllBaseCityInfoQueryResponseBodyModuleAllCityBaseInfoList(TeaModel):
    def __init__(
        self,
        adcode: str = None,
        city_code: str = None,
        city_level: str = None,
        city_name: str = None,
        cn_name_tree: str = None,
        id: int = None,
        other_name_list: List[str] = None,
    ):
        self.adcode = adcode
        self.city_code = city_code
        self.city_level = city_level
        self.city_name = city_name
        self.cn_name_tree = cn_name_tree
        self.id = id
        self.other_name_list = other_name_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adcode is not None:
            result['adcode'] = self.adcode
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_level is not None:
            result['city_level'] = self.city_level
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.cn_name_tree is not None:
            result['cn_name_tree'] = self.cn_name_tree
        if self.id is not None:
            result['id'] = self.id
        if self.other_name_list is not None:
            result['other_name_list'] = self.other_name_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('adcode') is not None:
            self.adcode = m.get('adcode')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_level') is not None:
            self.city_level = m.get('city_level')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('cn_name_tree') is not None:
            self.cn_name_tree = m.get('cn_name_tree')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('other_name_list') is not None:
            self.other_name_list = m.get('other_name_list')
        return self


class AllBaseCityInfoQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        all_city_base_info_list: List[AllBaseCityInfoQueryResponseBodyModuleAllCityBaseInfoList] = None,
    ):
        self.all_city_base_info_list = all_city_base_info_list

    def validate(self):
        if self.all_city_base_info_list:
            for k in self.all_city_base_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['all_city_base_info_list'] = []
        if self.all_city_base_info_list is not None:
            for k in self.all_city_base_info_list:
                result['all_city_base_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.all_city_base_info_list = []
        if m.get('all_city_base_info_list') is not None:
            for k in m.get('all_city_base_info_list'):
                temp_model = AllBaseCityInfoQueryResponseBodyModuleAllCityBaseInfoList()
                self.all_city_base_info_list.append(temp_model.from_map(k))
        return self


class AllBaseCityInfoQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: AllBaseCityInfoQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = AllBaseCityInfoQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class AllBaseCityInfoQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AllBaseCityInfoQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllBaseCityInfoQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyAddHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyAddRequestExternalTravelerList(TeaModel):
    def __init__(
        self,
        user_name: str = None,
    ):
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyAddRequestExternalTravelerStandardHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyAddRequestExternalTravelerStandard(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        hotel_citys: List[ApplyAddRequestExternalTravelerStandardHotelCitys] = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_seats: str = None,
    ):
        self.business_discount = business_discount
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.hotel_citys = hotel_citys
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_seats = train_seats

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyAddRequestExternalTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        return self


class ApplyAddRequestHotelShare(TeaModel):
    def __init__(
        self,
        param: str = None,
        type: str = None,
    ):
        self.param = param
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param is not None:
            result['param'] = self.param
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('param') is not None:
            self.param = m.get('param')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyAddRequestItineraryList(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_city_code: str = None,
        arr_date: str = None,
        cost_center_id: int = None,
        dep_city: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
        invoice_id: int = None,
        itinerary_id: str = None,
        need_hotel: bool = None,
        need_traffic: bool = None,
        project_code: str = None,
        project_title: str = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        traffic_type: int = None,
        trip_way: int = None,
    ):
        self.arr_city = arr_city
        self.arr_city_code = arr_city_code
        self.arr_date = arr_date
        self.cost_center_id = cost_center_id
        self.dep_city = dep_city
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date
        self.invoice_id = invoice_id
        self.itinerary_id = itinerary_id
        self.need_hotel = need_hotel
        self.need_traffic = need_traffic
        self.project_code = project_code
        self.project_title = project_title
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.traffic_type = traffic_type
        self.trip_way = trip_way

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.need_hotel is not None:
            result['need_hotel'] = self.need_hotel
        if self.need_traffic is not None:
            result['need_traffic'] = self.need_traffic
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('need_hotel') is not None:
            self.need_hotel = m.get('need_hotel')
        if m.get('need_traffic') is not None:
            self.need_traffic = m.get('need_traffic')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyAddRequestItinerarySetList(TeaModel):
    def __init__(
        self,
        arr_date: str = None,
        city_code_set: str = None,
        city_set: str = None,
        cost_center_id: int = None,
        dep_date: str = None,
        invoice_id: int = None,
        itinerary_id: str = None,
        project_code: str = None,
        project_title: str = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        traffic_type: int = None,
    ):
        self.arr_date = arr_date
        self.city_code_set = city_code_set
        self.city_set = city_set
        self.cost_center_id = cost_center_id
        self.dep_date = dep_date
        self.invoice_id = invoice_id
        self.itinerary_id = itinerary_id
        self.project_code = project_code
        self.project_title = project_title
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.traffic_type = traffic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyAddRequestTravelerList(TeaModel):
    def __init__(
        self,
        user_id: str = None,
        user_name: str = None,
    ):
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyAddRequestTravelerStandardHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyAddRequestTravelerStandard(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        hotel_citys: List[ApplyAddRequestTravelerStandardHotelCitys] = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_seats: str = None,
        user_id: str = None,
    ):
        self.business_discount = business_discount
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.hotel_citys = hotel_citys
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_seats = train_seats
        self.user_id = user_id

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyAddRequestTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ApplyAddRequest(TeaModel):
    def __init__(
        self,
        budget: int = None,
        budget_merge: int = None,
        corp_name: str = None,
        depart_id: str = None,
        depart_name: str = None,
        extend_field: str = None,
        external_traveler_list: List[ApplyAddRequestExternalTravelerList] = None,
        external_traveler_standard: ApplyAddRequestExternalTravelerStandard = None,
        flight_budget: int = None,
        hotel_budget: int = None,
        hotel_share: ApplyAddRequestHotelShare = None,
        international_flight_cabins: str = None,
        itinerary_list: List[ApplyAddRequestItineraryList] = None,
        itinerary_rule: int = None,
        itinerary_set_list: List[ApplyAddRequestItinerarySetList] = None,
        limit_traveler: int = None,
        status: int = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
        thirdpart_depart_id: str = None,
        together_book_rule: int = None,
        train_budget: int = None,
        traveler_list: List[ApplyAddRequestTravelerList] = None,
        traveler_standard: List[ApplyAddRequestTravelerStandard] = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        type: int = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
        vehicle_budget: int = None,
    ):
        self.budget = budget
        self.budget_merge = budget_merge
        self.corp_name = corp_name
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.extend_field = extend_field
        self.external_traveler_list = external_traveler_list
        self.external_traveler_standard = external_traveler_standard
        self.flight_budget = flight_budget
        self.hotel_budget = hotel_budget
        self.hotel_share = hotel_share
        self.international_flight_cabins = international_flight_cabins
        self.itinerary_list = itinerary_list
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list = itinerary_set_list
        self.limit_traveler = limit_traveler
        self.status = status
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.together_book_rule = together_book_rule
        self.train_budget = train_budget
        self.traveler_list = traveler_list
        self.traveler_standard = traveler_standard
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        self.trip_title = trip_title
        self.type = type
        self.union_no = union_no
        self.user_id = user_id
        self.user_name = user_name
        self.vehicle_budget = vehicle_budget

    def validate(self):
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.external_traveler_standard:
            self.external_traveler_standard.validate()
        if self.hotel_share:
            self.hotel_share.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()
        if self.traveler_standard:
            for k in self.traveler_standard:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.extend_field is not None:
            result['extend_field'] = self.extend_field
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.external_traveler_standard is not None:
            result['external_traveler_standard'] = self.external_traveler_standard.to_map()
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share is not None:
            result['hotel_share'] = self.hotel_share.to_map()
        if self.international_flight_cabins is not None:
            result['international_flight_cabins'] = self.international_flight_cabins
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.status is not None:
            result['status'] = self.status
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        result['traveler_standard'] = []
        if self.traveler_standard is not None:
            for k in self.traveler_standard:
                result['traveler_standard'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('extend_field') is not None:
            self.extend_field = m.get('extend_field')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyAddRequestExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('external_traveler_standard') is not None:
            temp_model = ApplyAddRequestExternalTravelerStandard()
            self.external_traveler_standard = temp_model.from_map(m['external_traveler_standard'])
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            temp_model = ApplyAddRequestHotelShare()
            self.hotel_share = temp_model.from_map(m['hotel_share'])
        if m.get('international_flight_cabins') is not None:
            self.international_flight_cabins = m.get('international_flight_cabins')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyAddRequestItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyAddRequestItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyAddRequestTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        self.traveler_standard = []
        if m.get('traveler_standard') is not None:
            for k in m.get('traveler_standard'):
                temp_model = ApplyAddRequestTravelerStandard()
                self.traveler_standard.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyAddShrinkRequest(TeaModel):
    def __init__(
        self,
        budget: int = None,
        budget_merge: int = None,
        corp_name: str = None,
        depart_id: str = None,
        depart_name: str = None,
        extend_field: str = None,
        external_traveler_list_shrink: str = None,
        external_traveler_standard_shrink: str = None,
        flight_budget: int = None,
        hotel_budget: int = None,
        hotel_share_shrink: str = None,
        international_flight_cabins: str = None,
        itinerary_list_shrink: str = None,
        itinerary_rule: int = None,
        itinerary_set_list_shrink: str = None,
        limit_traveler: int = None,
        status: int = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
        thirdpart_depart_id: str = None,
        together_book_rule: int = None,
        train_budget: int = None,
        traveler_list_shrink: str = None,
        traveler_standard_shrink: str = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        type: int = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
        vehicle_budget: int = None,
    ):
        self.budget = budget
        self.budget_merge = budget_merge
        self.corp_name = corp_name
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.extend_field = extend_field
        self.external_traveler_list_shrink = external_traveler_list_shrink
        self.external_traveler_standard_shrink = external_traveler_standard_shrink
        self.flight_budget = flight_budget
        self.hotel_budget = hotel_budget
        self.hotel_share_shrink = hotel_share_shrink
        self.international_flight_cabins = international_flight_cabins
        self.itinerary_list_shrink = itinerary_list_shrink
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list_shrink = itinerary_set_list_shrink
        self.limit_traveler = limit_traveler
        self.status = status
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.together_book_rule = together_book_rule
        self.train_budget = train_budget
        self.traveler_list_shrink = traveler_list_shrink
        self.traveler_standard_shrink = traveler_standard_shrink
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        self.trip_title = trip_title
        self.type = type
        self.union_no = union_no
        self.user_id = user_id
        self.user_name = user_name
        self.vehicle_budget = vehicle_budget

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.extend_field is not None:
            result['extend_field'] = self.extend_field
        if self.external_traveler_list_shrink is not None:
            result['external_traveler_list'] = self.external_traveler_list_shrink
        if self.external_traveler_standard_shrink is not None:
            result['external_traveler_standard'] = self.external_traveler_standard_shrink
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share_shrink is not None:
            result['hotel_share'] = self.hotel_share_shrink
        if self.international_flight_cabins is not None:
            result['international_flight_cabins'] = self.international_flight_cabins
        if self.itinerary_list_shrink is not None:
            result['itinerary_list'] = self.itinerary_list_shrink
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        if self.itinerary_set_list_shrink is not None:
            result['itinerary_set_list'] = self.itinerary_set_list_shrink
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.status is not None:
            result['status'] = self.status
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        if self.traveler_list_shrink is not None:
            result['traveler_list'] = self.traveler_list_shrink
        if self.traveler_standard_shrink is not None:
            result['traveler_standard'] = self.traveler_standard_shrink
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('extend_field') is not None:
            self.extend_field = m.get('extend_field')
        if m.get('external_traveler_list') is not None:
            self.external_traveler_list_shrink = m.get('external_traveler_list')
        if m.get('external_traveler_standard') is not None:
            self.external_traveler_standard_shrink = m.get('external_traveler_standard')
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            self.hotel_share_shrink = m.get('hotel_share')
        if m.get('international_flight_cabins') is not None:
            self.international_flight_cabins = m.get('international_flight_cabins')
        if m.get('itinerary_list') is not None:
            self.itinerary_list_shrink = m.get('itinerary_list')
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        if m.get('itinerary_set_list') is not None:
            self.itinerary_set_list_shrink = m.get('itinerary_set_list')
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        if m.get('traveler_list') is not None:
            self.traveler_list_shrink = m.get('traveler_list')
        if m.get('traveler_standard') is not None:
            self.traveler_standard_shrink = m.get('traveler_standard')
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyAddResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
    ):
        self.apply_id = apply_id
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        return self


class ApplyAddResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: ApplyAddResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = ApplyAddResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyAddResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyAddResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyAddResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyApproveHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyApproveRequest(TeaModel):
    def __init__(
        self,
        apply_id: str = None,
        note: str = None,
        operate_time: str = None,
        status: int = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.apply_id = apply_id
        self.note = note
        self.operate_time = operate_time
        self.status = status
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.status is not None:
            result['status'] = self.status
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyApproveResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyApproveResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyApproveResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyApproveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyInvoiceTaskHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyInvoiceTaskRequestInvoiceTaskList(TeaModel):
    def __init__(
        self,
        contact: str = None,
        email: str = None,
        flight_invoice_fee: str = None,
        fu_point_invoice_fee: str = None,
        hotel_normal_invoice_fee: str = None,
        hotel_special_invoice_fee: str = None,
        international_flight_invoice_fee: str = None,
        invoice_third_part_id: str = None,
        mail_address: str = None,
        mail_city: str = None,
        mail_full_address: str = None,
        mail_province: str = None,
        penalty_fee: str = None,
        remark: str = None,
        service_fee: str = None,
        telephone: str = None,
        train_invoice_fee: str = None,
        vehicle_invoice_fee: str = None,
    ):
        self.contact = contact
        self.email = email
        self.flight_invoice_fee = flight_invoice_fee
        self.fu_point_invoice_fee = fu_point_invoice_fee
        self.hotel_normal_invoice_fee = hotel_normal_invoice_fee
        self.hotel_special_invoice_fee = hotel_special_invoice_fee
        self.international_flight_invoice_fee = international_flight_invoice_fee
        self.invoice_third_part_id = invoice_third_part_id
        self.mail_address = mail_address
        self.mail_city = mail_city
        self.mail_full_address = mail_full_address
        self.mail_province = mail_province
        self.penalty_fee = penalty_fee
        self.remark = remark
        self.service_fee = service_fee
        self.telephone = telephone
        self.train_invoice_fee = train_invoice_fee
        self.vehicle_invoice_fee = vehicle_invoice_fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact is not None:
            result['contact'] = self.contact
        if self.email is not None:
            result['email'] = self.email
        if self.flight_invoice_fee is not None:
            result['flight_invoice_fee'] = self.flight_invoice_fee
        if self.fu_point_invoice_fee is not None:
            result['fu_point_invoice_fee'] = self.fu_point_invoice_fee
        if self.hotel_normal_invoice_fee is not None:
            result['hotel_normal_invoice_fee'] = self.hotel_normal_invoice_fee
        if self.hotel_special_invoice_fee is not None:
            result['hotel_special_invoice_fee'] = self.hotel_special_invoice_fee
        if self.international_flight_invoice_fee is not None:
            result['international_flight_invoice_fee'] = self.international_flight_invoice_fee
        if self.invoice_third_part_id is not None:
            result['invoice_third_part_id'] = self.invoice_third_part_id
        if self.mail_address is not None:
            result['mail_address'] = self.mail_address
        if self.mail_city is not None:
            result['mail_city'] = self.mail_city
        if self.mail_full_address is not None:
            result['mail_full_address'] = self.mail_full_address
        if self.mail_province is not None:
            result['mail_province'] = self.mail_province
        if self.penalty_fee is not None:
            result['penalty_fee'] = self.penalty_fee
        if self.remark is not None:
            result['remark'] = self.remark
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.telephone is not None:
            result['telephone'] = self.telephone
        if self.train_invoice_fee is not None:
            result['train_invoice_fee'] = self.train_invoice_fee
        if self.vehicle_invoice_fee is not None:
            result['vehicle_invoice_fee'] = self.vehicle_invoice_fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('contact') is not None:
            self.contact = m.get('contact')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('flight_invoice_fee') is not None:
            self.flight_invoice_fee = m.get('flight_invoice_fee')
        if m.get('fu_point_invoice_fee') is not None:
            self.fu_point_invoice_fee = m.get('fu_point_invoice_fee')
        if m.get('hotel_normal_invoice_fee') is not None:
            self.hotel_normal_invoice_fee = m.get('hotel_normal_invoice_fee')
        if m.get('hotel_special_invoice_fee') is not None:
            self.hotel_special_invoice_fee = m.get('hotel_special_invoice_fee')
        if m.get('international_flight_invoice_fee') is not None:
            self.international_flight_invoice_fee = m.get('international_flight_invoice_fee')
        if m.get('invoice_third_part_id') is not None:
            self.invoice_third_part_id = m.get('invoice_third_part_id')
        if m.get('mail_address') is not None:
            self.mail_address = m.get('mail_address')
        if m.get('mail_city') is not None:
            self.mail_city = m.get('mail_city')
        if m.get('mail_full_address') is not None:
            self.mail_full_address = m.get('mail_full_address')
        if m.get('mail_province') is not None:
            self.mail_province = m.get('mail_province')
        if m.get('penalty_fee') is not None:
            self.penalty_fee = m.get('penalty_fee')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('telephone') is not None:
            self.telephone = m.get('telephone')
        if m.get('train_invoice_fee') is not None:
            self.train_invoice_fee = m.get('train_invoice_fee')
        if m.get('vehicle_invoice_fee') is not None:
            self.vehicle_invoice_fee = m.get('vehicle_invoice_fee')
        return self


class ApplyInvoiceTaskRequest(TeaModel):
    def __init__(
        self,
        bill_date: str = None,
        invoice_task_list: List[ApplyInvoiceTaskRequestInvoiceTaskList] = None,
    ):
        self.bill_date = bill_date
        self.invoice_task_list = invoice_task_list

    def validate(self):
        if self.invoice_task_list:
            for k in self.invoice_task_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_date is not None:
            result['bill_date'] = self.bill_date
        result['invoice_task_list'] = []
        if self.invoice_task_list is not None:
            for k in self.invoice_task_list:
                result['invoice_task_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bill_date') is not None:
            self.bill_date = m.get('bill_date')
        self.invoice_task_list = []
        if m.get('invoice_task_list') is not None:
            for k in m.get('invoice_task_list'):
                temp_model = ApplyInvoiceTaskRequestInvoiceTaskList()
                self.invoice_task_list.append(temp_model.from_map(k))
        return self


class ApplyInvoiceTaskShrinkRequest(TeaModel):
    def __init__(
        self,
        bill_date: str = None,
        invoice_task_list_shrink: str = None,
    ):
        self.bill_date = bill_date
        self.invoice_task_list_shrink = invoice_task_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_date is not None:
            result['bill_date'] = self.bill_date
        if self.invoice_task_list_shrink is not None:
            result['invoice_task_list'] = self.invoice_task_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bill_date') is not None:
            self.bill_date = m.get('bill_date')
        if m.get('invoice_task_list') is not None:
            self.invoice_task_list_shrink = m.get('invoice_task_list')
        return self


class ApplyInvoiceTaskResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # requestId
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyInvoiceTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyInvoiceTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyInvoiceTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyListQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyListQueryRequest(TeaModel):
    def __init__(
        self,
        all_apply: bool = None,
        depart_id: str = None,
        end_time: str = None,
        gmt_modified: str = None,
        only_shang_lv_apply: bool = None,
        page: int = None,
        page_size: int = None,
        start_time: str = None,
        type: int = None,
        union_no: str = None,
        user_id: str = None,
    ):
        self.all_apply = all_apply
        self.depart_id = depart_id
        self.end_time = end_time
        self.gmt_modified = gmt_modified
        self.only_shang_lv_apply = only_shang_lv_apply
        self.page = page
        self.page_size = page_size
        self.start_time = start_time
        self.type = type
        self.union_no = union_no
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_apply is not None:
            result['all_apply'] = self.all_apply
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.only_shang_lv_apply is not None:
            result['only_shang_lv_apply'] = self.only_shang_lv_apply
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('all_apply') is not None:
            self.all_apply = m.get('all_apply')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('only_shang_lv_apply') is not None:
            self.only_shang_lv_apply = m.get('only_shang_lv_apply')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ApplyListQueryResponseBodyModuleListApproverList(TeaModel):
    def __init__(
        self,
        note: str = None,
        operate_time: str = None,
        order: int = None,
        status: int = None,
        status_desc: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.note = note
        self.operate_time = operate_time
        self.order = order
        self.status = status
        self.status_desc = status_desc
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.order is not None:
            result['order'] = self.order
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBodyModuleListExternalTravelerList(TeaModel):
    def __init__(
        self,
        user_name: str = None,
    ):
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBodyModuleListItineraryList(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_date: str = None,
        cost_center_name: str = None,
        dep_city: str = None,
        dep_date: str = None,
        invoice_name: str = None,
        itinerary_id: str = None,
        project_code: str = None,
        project_title: str = None,
        traffic_type: int = None,
        trip_way: int = None,
    ):
        self.arr_city = arr_city
        self.arr_date = arr_date
        self.cost_center_name = cost_center_name
        self.dep_city = dep_city
        self.dep_date = dep_date
        self.invoice_name = invoice_name
        self.itinerary_id = itinerary_id
        self.project_code = project_code
        self.project_title = project_title
        self.traffic_type = traffic_type
        self.trip_way = trip_way

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyListQueryResponseBodyModuleListItinerarySetList(TeaModel):
    def __init__(
        self,
        arr_date: str = None,
        city_code_set: str = None,
        city_set: str = None,
        cost_center_name: str = None,
        dep_date: str = None,
        invoice_name: str = None,
        itinerary_id: str = None,
        project_code: str = None,
        project_title: str = None,
        traffic_type: int = None,
    ):
        self.arr_date = arr_date
        self.city_code_set = city_code_set
        self.city_set = city_set
        self.cost_center_name = cost_center_name
        self.dep_date = dep_date
        self.invoice_name = invoice_name
        self.itinerary_id = itinerary_id
        self.project_code = project_code
        self.project_title = project_title
        self.traffic_type = traffic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyListQueryResponseBodyModuleListTravelerList(TeaModel):
    def __init__(
        self,
        user_id: str = None,
        user_name: str = None,
    ):
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBodyModuleList(TeaModel):
    def __init__(
        self,
        apply_show_id: str = None,
        approver_list: List[ApplyListQueryResponseBodyModuleListApproverList] = None,
        corp_id: str = None,
        corp_name: str = None,
        depart_id: str = None,
        depart_name: str = None,
        external_traveler_list: List[ApplyListQueryResponseBodyModuleListExternalTravelerList] = None,
        flow_code: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        itinerary_list: List[ApplyListQueryResponseBodyModuleListItineraryList] = None,
        itinerary_rule: int = None,
        itinerary_set_list: List[ApplyListQueryResponseBodyModuleListItinerarySetList] = None,
        status: int = None,
        status_desc: str = None,
        thirdpart_business_id: str = None,
        thirdpart_id: str = None,
        traveler_list: List[ApplyListQueryResponseBodyModuleListTravelerList] = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        type: int = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.apply_show_id = apply_show_id
        self.approver_list = approver_list
        self.corp_id = corp_id
        self.corp_name = corp_name
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.external_traveler_list = external_traveler_list
        self.flow_code = flow_code
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.itinerary_list = itinerary_list
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list = itinerary_set_list
        self.status = status
        self.status_desc = status_desc
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_id = thirdpart_id
        self.traveler_list = traveler_list
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        self.trip_title = trip_title
        self.type = type
        self.union_no = union_no
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        if self.approver_list:
            for k in self.approver_list:
                if k:
                    k.validate()
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        result['approver_list'] = []
        if self.approver_list is not None:
            for k in self.approver_list:
                result['approver_list'].append(k.to_map() if k else None)
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.flow_code is not None:
            result['flow_code'] = self.flow_code
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        self.approver_list = []
        if m.get('approver_list') is not None:
            for k in m.get('approver_list'):
                temp_model = ApplyListQueryResponseBodyModuleListApproverList()
                self.approver_list.append(temp_model.from_map(k))
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyListQueryResponseBodyModuleListExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('flow_code') is not None:
            self.flow_code = m.get('flow_code')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyListQueryResponseBodyModuleListItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyListQueryResponseBodyModuleListItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyListQueryResponseBodyModuleListTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyListQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module_list: List[ApplyListQueryResponseBodyModuleList] = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module_list = module_list
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module_list:
            for k in self.module_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module_list'] = []
        if self.module_list is not None:
            for k in self.module_list:
                result['module_list'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module_list = []
        if m.get('module_list') is not None:
            for k in m.get('module_list'):
                temp_model = ApplyListQueryResponseBodyModuleList()
                self.module_list.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyListQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyListQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyListQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyModifyHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyModifyRequestExternalTravelerList(TeaModel):
    def __init__(
        self,
        user_name: str = None,
    ):
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyModifyRequestExternalTravelerStandardHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyModifyRequestExternalTravelerStandard(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        hotel_citys: List[ApplyModifyRequestExternalTravelerStandardHotelCitys] = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_seats: str = None,
    ):
        self.business_discount = business_discount
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.hotel_citys = hotel_citys
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_seats = train_seats

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyModifyRequestExternalTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        return self


class ApplyModifyRequestHotelShare(TeaModel):
    def __init__(
        self,
        param: str = None,
        type: str = None,
    ):
        self.param = param
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param is not None:
            result['param'] = self.param
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('param') is not None:
            self.param = m.get('param')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyModifyRequestItineraryList(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_city_code: str = None,
        arr_date: str = None,
        cost_center_id: int = None,
        dep_city: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
        invoice_id: int = None,
        itinerary_id: str = None,
        need_hotel: bool = None,
        need_traffic: bool = None,
        project_code: str = None,
        project_title: str = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        traffic_type: int = None,
        trip_way: int = None,
    ):
        self.arr_city = arr_city
        self.arr_city_code = arr_city_code
        self.arr_date = arr_date
        self.cost_center_id = cost_center_id
        self.dep_city = dep_city
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date
        self.invoice_id = invoice_id
        self.itinerary_id = itinerary_id
        self.need_hotel = need_hotel
        self.need_traffic = need_traffic
        self.project_code = project_code
        self.project_title = project_title
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.traffic_type = traffic_type
        self.trip_way = trip_way

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.need_hotel is not None:
            result['need_hotel'] = self.need_hotel
        if self.need_traffic is not None:
            result['need_traffic'] = self.need_traffic
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('need_hotel') is not None:
            self.need_hotel = m.get('need_hotel')
        if m.get('need_traffic') is not None:
            self.need_traffic = m.get('need_traffic')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyModifyRequestItinerarySetList(TeaModel):
    def __init__(
        self,
        arr_date: str = None,
        city_code_set: str = None,
        city_set: str = None,
        cost_center_id: int = None,
        dep_date: str = None,
        invoice_id: int = None,
        itinerary_id: str = None,
        project_code: str = None,
        project_title: str = None,
        third_part_invoice_id: str = None,
        thirdpart_cost_center_id: str = None,
        traffic_type: int = None,
    ):
        self.arr_date = arr_date
        self.city_code_set = city_code_set
        self.city_set = city_set
        self.cost_center_id = cost_center_id
        self.dep_date = dep_date
        self.invoice_id = invoice_id
        self.itinerary_id = itinerary_id
        self.project_code = project_code
        self.project_title = project_title
        self.third_part_invoice_id = third_part_invoice_id
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.traffic_type = traffic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyModifyRequestTravelerList(TeaModel):
    def __init__(
        self,
        user_id: str = None,
        user_name: str = None,
    ):
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyModifyRequestTravelerStandardHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyModifyRequestTravelerStandard(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        hotel_citys: List[ApplyModifyRequestTravelerStandardHotelCitys] = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_seats: str = None,
        user_id: str = None,
    ):
        self.business_discount = business_discount
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.hotel_citys = hotel_citys
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_seats = train_seats
        self.user_id = user_id

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyModifyRequestTravelerStandardHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ApplyModifyRequest(TeaModel):
    def __init__(
        self,
        budget: int = None,
        budget_merge: int = None,
        corp_name: str = None,
        depart_id: str = None,
        depart_name: str = None,
        extend_field: str = None,
        external_traveler_list: List[ApplyModifyRequestExternalTravelerList] = None,
        external_traveler_standard: ApplyModifyRequestExternalTravelerStandard = None,
        flight_budget: int = None,
        hotel_budget: int = None,
        hotel_share: ApplyModifyRequestHotelShare = None,
        itinerary_list: List[ApplyModifyRequestItineraryList] = None,
        itinerary_rule: int = None,
        itinerary_set_list: List[ApplyModifyRequestItinerarySetList] = None,
        limit_traveler: int = None,
        status: int = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
        thirdpart_depart_id: str = None,
        together_book_rule: int = None,
        train_budget: int = None,
        traveler_list: List[ApplyModifyRequestTravelerList] = None,
        traveler_standard: List[ApplyModifyRequestTravelerStandard] = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
        vehicle_budget: int = None,
    ):
        self.budget = budget
        self.budget_merge = budget_merge
        self.corp_name = corp_name
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.extend_field = extend_field
        self.external_traveler_list = external_traveler_list
        self.external_traveler_standard = external_traveler_standard
        self.flight_budget = flight_budget
        self.hotel_budget = hotel_budget
        self.hotel_share = hotel_share
        self.itinerary_list = itinerary_list
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list = itinerary_set_list
        self.limit_traveler = limit_traveler
        self.status = status
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.together_book_rule = together_book_rule
        self.train_budget = train_budget
        self.traveler_list = traveler_list
        self.traveler_standard = traveler_standard
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        self.trip_title = trip_title
        self.union_no = union_no
        self.user_id = user_id
        self.user_name = user_name
        self.vehicle_budget = vehicle_budget

    def validate(self):
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.external_traveler_standard:
            self.external_traveler_standard.validate()
        if self.hotel_share:
            self.hotel_share.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()
        if self.traveler_standard:
            for k in self.traveler_standard:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.extend_field is not None:
            result['extend_field'] = self.extend_field
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.external_traveler_standard is not None:
            result['external_traveler_standard'] = self.external_traveler_standard.to_map()
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share is not None:
            result['hotel_share'] = self.hotel_share.to_map()
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.status is not None:
            result['status'] = self.status
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        result['traveler_standard'] = []
        if self.traveler_standard is not None:
            for k in self.traveler_standard:
                result['traveler_standard'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('extend_field') is not None:
            self.extend_field = m.get('extend_field')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyModifyRequestExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('external_traveler_standard') is not None:
            temp_model = ApplyModifyRequestExternalTravelerStandard()
            self.external_traveler_standard = temp_model.from_map(m['external_traveler_standard'])
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            temp_model = ApplyModifyRequestHotelShare()
            self.hotel_share = temp_model.from_map(m['hotel_share'])
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyModifyRequestItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyModifyRequestItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyModifyRequestTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        self.traveler_standard = []
        if m.get('traveler_standard') is not None:
            for k in m.get('traveler_standard'):
                temp_model = ApplyModifyRequestTravelerStandard()
                self.traveler_standard.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyModifyShrinkRequest(TeaModel):
    def __init__(
        self,
        budget: int = None,
        budget_merge: int = None,
        corp_name: str = None,
        depart_id: str = None,
        depart_name: str = None,
        extend_field: str = None,
        external_traveler_list_shrink: str = None,
        external_traveler_standard_shrink: str = None,
        flight_budget: int = None,
        hotel_budget: int = None,
        hotel_share_shrink: str = None,
        itinerary_list_shrink: str = None,
        itinerary_rule: int = None,
        itinerary_set_list_shrink: str = None,
        limit_traveler: int = None,
        status: int = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
        thirdpart_depart_id: str = None,
        together_book_rule: int = None,
        train_budget: int = None,
        traveler_list_shrink: str = None,
        traveler_standard_shrink: str = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
        vehicle_budget: int = None,
    ):
        self.budget = budget
        self.budget_merge = budget_merge
        self.corp_name = corp_name
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.extend_field = extend_field
        self.external_traveler_list_shrink = external_traveler_list_shrink
        self.external_traveler_standard_shrink = external_traveler_standard_shrink
        self.flight_budget = flight_budget
        self.hotel_budget = hotel_budget
        self.hotel_share_shrink = hotel_share_shrink
        self.itinerary_list_shrink = itinerary_list_shrink
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list_shrink = itinerary_set_list_shrink
        self.limit_traveler = limit_traveler
        self.status = status
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_depart_id = thirdpart_depart_id
        self.together_book_rule = together_book_rule
        self.train_budget = train_budget
        self.traveler_list_shrink = traveler_list_shrink
        self.traveler_standard_shrink = traveler_standard_shrink
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        self.trip_title = trip_title
        self.union_no = union_no
        self.user_id = user_id
        self.user_name = user_name
        self.vehicle_budget = vehicle_budget

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.extend_field is not None:
            result['extend_field'] = self.extend_field
        if self.external_traveler_list_shrink is not None:
            result['external_traveler_list'] = self.external_traveler_list_shrink
        if self.external_traveler_standard_shrink is not None:
            result['external_traveler_standard'] = self.external_traveler_standard_shrink
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share_shrink is not None:
            result['hotel_share'] = self.hotel_share_shrink
        if self.itinerary_list_shrink is not None:
            result['itinerary_list'] = self.itinerary_list_shrink
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        if self.itinerary_set_list_shrink is not None:
            result['itinerary_set_list'] = self.itinerary_set_list_shrink
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.status is not None:
            result['status'] = self.status
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_depart_id is not None:
            result['thirdpart_depart_id'] = self.thirdpart_depart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        if self.traveler_list_shrink is not None:
            result['traveler_list'] = self.traveler_list_shrink
        if self.traveler_standard_shrink is not None:
            result['traveler_standard'] = self.traveler_standard_shrink
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('extend_field') is not None:
            self.extend_field = m.get('extend_field')
        if m.get('external_traveler_list') is not None:
            self.external_traveler_list_shrink = m.get('external_traveler_list')
        if m.get('external_traveler_standard') is not None:
            self.external_traveler_standard_shrink = m.get('external_traveler_standard')
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            self.hotel_share_shrink = m.get('hotel_share')
        if m.get('itinerary_list') is not None:
            self.itinerary_list_shrink = m.get('itinerary_list')
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        if m.get('itinerary_set_list') is not None:
            self.itinerary_set_list_shrink = m.get('itinerary_set_list')
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_depart_id') is not None:
            self.thirdpart_depart_id = m.get('thirdpart_depart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        if m.get('traveler_list') is not None:
            self.traveler_list_shrink = m.get('traveler_list')
        if m.get('traveler_standard') is not None:
            self.traveler_standard_shrink = m.get('traveler_standard')
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyModifyResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        thirdpart_apply_id: str = None,
        thirdpart_business_id: str = None,
    ):
        self.apply_id = apply_id
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_business_id = thirdpart_business_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        return self


class ApplyModifyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: ApplyModifyResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = ApplyModifyResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyModifyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyModifyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ApplyQueryRequest(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        apply_show_id: str = None,
        thirdpart_apply_id: str = None,
        type: int = None,
    ):
        self.apply_id = apply_id
        self.apply_show_id = apply_show_id
        self.thirdpart_apply_id = thirdpart_apply_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyQueryResponseBodyModuleApproverList(TeaModel):
    def __init__(
        self,
        note: str = None,
        operate_time: str = None,
        order: int = None,
        status: int = None,
        status_desc: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.note = note
        self.operate_time = operate_time
        self.order = order
        self.status = status
        self.status_desc = status_desc
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.order is not None:
            result['order'] = self.order
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyQueryResponseBodyModuleExternalTravelerListHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyQueryResponseBodyModuleExternalTravelerList(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        hotel_citys: List[ApplyQueryResponseBodyModuleExternalTravelerListHotelCitys] = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_seats: str = None,
        user_name: str = None,
    ):
        self.business_discount = business_discount
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.hotel_citys = hotel_citys
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_seats = train_seats
        self.user_name = user_name

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyQueryResponseBodyModuleExternalTravelerListHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyQueryResponseBodyModuleHotelShare(TeaModel):
    def __init__(
        self,
        param: str = None,
        type: str = None,
    ):
        self.param = param
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.param is not None:
            result['param'] = self.param
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('param') is not None:
            self.param = m.get('param')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ApplyQueryResponseBodyModuleItineraryList(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_city_code: str = None,
        arr_date: str = None,
        cost_center_name: str = None,
        dep_city: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
        invoice_name: str = None,
        itinerary_id: str = None,
        project_code: str = None,
        project_title: str = None,
        traffic_type: int = None,
        trip_way: int = None,
    ):
        self.arr_city = arr_city
        self.arr_city_code = arr_city_code
        self.arr_date = arr_date
        self.cost_center_name = cost_center_name
        self.dep_city = dep_city
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date
        self.invoice_name = invoice_name
        self.itinerary_id = itinerary_id
        self.project_code = project_code
        self.project_title = project_title
        self.traffic_type = traffic_type
        self.trip_way = trip_way

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        if self.trip_way is not None:
            result['trip_way'] = self.trip_way
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        if m.get('trip_way') is not None:
            self.trip_way = m.get('trip_way')
        return self


class ApplyQueryResponseBodyModuleItinerarySetList(TeaModel):
    def __init__(
        self,
        arr_date: str = None,
        city_code_set: str = None,
        city_set: str = None,
        cost_center_name: str = None,
        dep_date: str = None,
        invoice_name: str = None,
        itinerary_id: str = None,
        project_code: str = None,
        project_title: str = None,
        traffic_type: int = None,
    ):
        self.arr_date = arr_date
        self.city_code_set = city_code_set
        self.city_set = city_set
        self.cost_center_name = cost_center_name
        self.dep_date = dep_date
        self.invoice_name = invoice_name
        self.itinerary_id = itinerary_id
        self.project_code = project_code
        self.project_title = project_title
        self.traffic_type = traffic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.city_code_set is not None:
            result['city_code_set'] = self.city_code_set
        if self.city_set is not None:
            result['city_set'] = self.city_set
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('city_code_set') is not None:
            self.city_code_set = m.get('city_code_set')
        if m.get('city_set') is not None:
            self.city_set = m.get('city_set')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class ApplyQueryResponseBodyModuleTravelerListHotelCitys(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        fee: int = None,
    ):
        self.city_code = city_code
        self.city_name = city_name
        self.fee = fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.fee is not None:
            result['fee'] = self.fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        return self


class ApplyQueryResponseBodyModuleTravelerList(TeaModel):
    def __init__(
        self,
        business_discount: int = None,
        economy_discount: int = None,
        first_discount: int = None,
        flight_cabins: str = None,
        hotel_citys: List[ApplyQueryResponseBodyModuleTravelerListHotelCitys] = None,
        premium_economy_discount: int = None,
        reserve_type: int = None,
        train_seats: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.business_discount = business_discount
        self.economy_discount = economy_discount
        self.first_discount = first_discount
        self.flight_cabins = flight_cabins
        self.hotel_citys = hotel_citys
        self.premium_economy_discount = premium_economy_discount
        self.reserve_type = reserve_type
        self.train_seats = train_seats
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        if self.hotel_citys:
            for k in self.hotel_citys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_discount is not None:
            result['business_discount'] = self.business_discount
        if self.economy_discount is not None:
            result['economy_discount'] = self.economy_discount
        if self.first_discount is not None:
            result['first_discount'] = self.first_discount
        if self.flight_cabins is not None:
            result['flight_cabins'] = self.flight_cabins
        result['hotel_citys'] = []
        if self.hotel_citys is not None:
            for k in self.hotel_citys:
                result['hotel_citys'].append(k.to_map() if k else None)
        if self.premium_economy_discount is not None:
            result['premium_economy_discount'] = self.premium_economy_discount
        if self.reserve_type is not None:
            result['reserve_type'] = self.reserve_type
        if self.train_seats is not None:
            result['train_seats'] = self.train_seats
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_discount') is not None:
            self.business_discount = m.get('business_discount')
        if m.get('economy_discount') is not None:
            self.economy_discount = m.get('economy_discount')
        if m.get('first_discount') is not None:
            self.first_discount = m.get('first_discount')
        if m.get('flight_cabins') is not None:
            self.flight_cabins = m.get('flight_cabins')
        self.hotel_citys = []
        if m.get('hotel_citys') is not None:
            for k in m.get('hotel_citys'):
                temp_model = ApplyQueryResponseBodyModuleTravelerListHotelCitys()
                self.hotel_citys.append(temp_model.from_map(k))
        if m.get('premium_economy_discount') is not None:
            self.premium_economy_discount = m.get('premium_economy_discount')
        if m.get('reserve_type') is not None:
            self.reserve_type = m.get('reserve_type')
        if m.get('train_seats') is not None:
            self.train_seats = m.get('train_seats')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class ApplyQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_show_id: str = None,
        approver_list: List[ApplyQueryResponseBodyModuleApproverList] = None,
        budget: int = None,
        budget_merge: int = None,
        corp_id: str = None,
        corp_name: str = None,
        depart_id: str = None,
        depart_name: str = None,
        extend_field: str = None,
        external_traveler_list: List[ApplyQueryResponseBodyModuleExternalTravelerList] = None,
        flight_budget: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        hotel_budget: int = None,
        hotel_share: ApplyQueryResponseBodyModuleHotelShare = None,
        id: int = None,
        itinerary_list: List[ApplyQueryResponseBodyModuleItineraryList] = None,
        itinerary_rule: int = None,
        itinerary_set_list: List[ApplyQueryResponseBodyModuleItinerarySetList] = None,
        limit_traveler: int = None,
        status: int = None,
        status_desc: str = None,
        thirdpart_business_id: str = None,
        thirdpart_id: str = None,
        together_book_rule: int = None,
        train_budget: int = None,
        traveler_list: List[ApplyQueryResponseBodyModuleTravelerList] = None,
        trip_cause: str = None,
        trip_day: int = None,
        trip_title: str = None,
        type: int = None,
        union_no: str = None,
        user_id: str = None,
        user_name: str = None,
        vehicle_budget: int = None,
    ):
        self.apply_show_id = apply_show_id
        self.approver_list = approver_list
        self.budget = budget
        self.budget_merge = budget_merge
        self.corp_id = corp_id
        self.corp_name = corp_name
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.extend_field = extend_field
        self.external_traveler_list = external_traveler_list
        self.flight_budget = flight_budget
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.hotel_budget = hotel_budget
        self.hotel_share = hotel_share
        self.id = id
        self.itinerary_list = itinerary_list
        self.itinerary_rule = itinerary_rule
        self.itinerary_set_list = itinerary_set_list
        self.limit_traveler = limit_traveler
        self.status = status
        self.status_desc = status_desc
        self.thirdpart_business_id = thirdpart_business_id
        self.thirdpart_id = thirdpart_id
        self.together_book_rule = together_book_rule
        self.train_budget = train_budget
        self.traveler_list = traveler_list
        self.trip_cause = trip_cause
        self.trip_day = trip_day
        self.trip_title = trip_title
        self.type = type
        self.union_no = union_no
        self.user_id = user_id
        self.user_name = user_name
        self.vehicle_budget = vehicle_budget

    def validate(self):
        if self.approver_list:
            for k in self.approver_list:
                if k:
                    k.validate()
        if self.external_traveler_list:
            for k in self.external_traveler_list:
                if k:
                    k.validate()
        if self.hotel_share:
            self.hotel_share.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()
        if self.itinerary_set_list:
            for k in self.itinerary_set_list:
                if k:
                    k.validate()
        if self.traveler_list:
            for k in self.traveler_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        result['approver_list'] = []
        if self.approver_list is not None:
            for k in self.approver_list:
                result['approver_list'].append(k.to_map() if k else None)
        if self.budget is not None:
            result['budget'] = self.budget
        if self.budget_merge is not None:
            result['budget_merge'] = self.budget_merge
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.extend_field is not None:
            result['extend_field'] = self.extend_field
        result['external_traveler_list'] = []
        if self.external_traveler_list is not None:
            for k in self.external_traveler_list:
                result['external_traveler_list'].append(k.to_map() if k else None)
        if self.flight_budget is not None:
            result['flight_budget'] = self.flight_budget
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.hotel_budget is not None:
            result['hotel_budget'] = self.hotel_budget
        if self.hotel_share is not None:
            result['hotel_share'] = self.hotel_share.to_map()
        if self.id is not None:
            result['id'] = self.id
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.itinerary_rule is not None:
            result['itinerary_rule'] = self.itinerary_rule
        result['itinerary_set_list'] = []
        if self.itinerary_set_list is not None:
            for k in self.itinerary_set_list:
                result['itinerary_set_list'].append(k.to_map() if k else None)
        if self.limit_traveler is not None:
            result['limit_traveler'] = self.limit_traveler
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.thirdpart_business_id is not None:
            result['thirdpart_business_id'] = self.thirdpart_business_id
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.together_book_rule is not None:
            result['together_book_rule'] = self.together_book_rule
        if self.train_budget is not None:
            result['train_budget'] = self.train_budget
        result['traveler_list'] = []
        if self.traveler_list is not None:
            for k in self.traveler_list:
                result['traveler_list'].append(k.to_map() if k else None)
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_day is not None:
            result['trip_day'] = self.trip_day
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.type is not None:
            result['type'] = self.type
        if self.union_no is not None:
            result['union_no'] = self.union_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.vehicle_budget is not None:
            result['vehicle_budget'] = self.vehicle_budget
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        self.approver_list = []
        if m.get('approver_list') is not None:
            for k in m.get('approver_list'):
                temp_model = ApplyQueryResponseBodyModuleApproverList()
                self.approver_list.append(temp_model.from_map(k))
        if m.get('budget') is not None:
            self.budget = m.get('budget')
        if m.get('budget_merge') is not None:
            self.budget_merge = m.get('budget_merge')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('extend_field') is not None:
            self.extend_field = m.get('extend_field')
        self.external_traveler_list = []
        if m.get('external_traveler_list') is not None:
            for k in m.get('external_traveler_list'):
                temp_model = ApplyQueryResponseBodyModuleExternalTravelerList()
                self.external_traveler_list.append(temp_model.from_map(k))
        if m.get('flight_budget') is not None:
            self.flight_budget = m.get('flight_budget')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('hotel_budget') is not None:
            self.hotel_budget = m.get('hotel_budget')
        if m.get('hotel_share') is not None:
            temp_model = ApplyQueryResponseBodyModuleHotelShare()
            self.hotel_share = temp_model.from_map(m['hotel_share'])
        if m.get('id') is not None:
            self.id = m.get('id')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = ApplyQueryResponseBodyModuleItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('itinerary_rule') is not None:
            self.itinerary_rule = m.get('itinerary_rule')
        self.itinerary_set_list = []
        if m.get('itinerary_set_list') is not None:
            for k in m.get('itinerary_set_list'):
                temp_model = ApplyQueryResponseBodyModuleItinerarySetList()
                self.itinerary_set_list.append(temp_model.from_map(k))
        if m.get('limit_traveler') is not None:
            self.limit_traveler = m.get('limit_traveler')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('thirdpart_business_id') is not None:
            self.thirdpart_business_id = m.get('thirdpart_business_id')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('together_book_rule') is not None:
            self.together_book_rule = m.get('together_book_rule')
        if m.get('train_budget') is not None:
            self.train_budget = m.get('train_budget')
        self.traveler_list = []
        if m.get('traveler_list') is not None:
            for k in m.get('traveler_list'):
                temp_model = ApplyQueryResponseBodyModuleTravelerList()
                self.traveler_list.append(temp_model.from_map(k))
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_day') is not None:
            self.trip_day = m.get('trip_day')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('union_no') is not None:
            self.union_no = m.get('union_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('vehicle_budget') is not None:
            self.vehicle_budget = m.get('vehicle_budget')
        return self


class ApplyQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: ApplyQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = ApplyQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ApplyQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BtripBillInfoAdjustHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class BtripBillInfoAdjustRequest(TeaModel):
    def __init__(
        self,
        primary_id: int = None,
        third_part_cost_center_id: str = None,
        third_part_department_id: str = None,
        third_part_invoice_id: str = None,
        third_part_project_id: str = None,
        user_id: str = None,
    ):
        self.primary_id = primary_id
        self.third_part_cost_center_id = third_part_cost_center_id
        self.third_part_department_id = third_part_department_id
        self.third_part_invoice_id = third_part_invoice_id
        self.third_part_project_id = third_part_project_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.third_part_cost_center_id is not None:
            result['third_part_cost_center_id'] = self.third_part_cost_center_id
        if self.third_part_department_id is not None:
            result['third_part_department_id'] = self.third_part_department_id
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.third_part_project_id is not None:
            result['third_part_project_id'] = self.third_part_project_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('third_part_cost_center_id') is not None:
            self.third_part_cost_center_id = m.get('third_part_cost_center_id')
        if m.get('third_part_department_id') is not None:
            self.third_part_department_id = m.get('third_part_department_id')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('third_part_project_id') is not None:
            self.third_part_project_id = m.get('third_part_project_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class BtripBillInfoAdjustResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class BtripBillInfoAdjustResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BtripBillInfoAdjustResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BtripBillInfoAdjustResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarApplyAddHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarApplyAddRequest(TeaModel):
    def __init__(
        self,
        cause: str = None,
        city: str = None,
        date: str = None,
        finished_date: str = None,
        project_code: str = None,
        project_name: str = None,
        status: int = None,
        third_part_apply_id: str = None,
        third_part_cost_center_id: str = None,
        third_part_invoice_id: str = None,
        times_total: int = None,
        times_type: int = None,
        times_used: int = None,
        title: str = None,
        user_id: str = None,
    ):
        self.cause = cause
        self.city = city
        self.date = date
        self.finished_date = finished_date
        self.project_code = project_code
        self.project_name = project_name
        self.status = status
        self.third_part_apply_id = third_part_apply_id
        self.third_part_cost_center_id = third_part_cost_center_id
        self.third_part_invoice_id = third_part_invoice_id
        self.times_total = times_total
        self.times_type = times_type
        self.times_used = times_used
        self.title = title
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cause is not None:
            result['cause'] = self.cause
        if self.city is not None:
            result['city'] = self.city
        if self.date is not None:
            result['date'] = self.date
        if self.finished_date is not None:
            result['finished_date'] = self.finished_date
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.status is not None:
            result['status'] = self.status
        if self.third_part_apply_id is not None:
            result['third_part_apply_id'] = self.third_part_apply_id
        if self.third_part_cost_center_id is not None:
            result['third_part_cost_center_id'] = self.third_part_cost_center_id
        if self.third_part_invoice_id is not None:
            result['third_part_invoice_id'] = self.third_part_invoice_id
        if self.times_total is not None:
            result['times_total'] = self.times_total
        if self.times_type is not None:
            result['times_type'] = self.times_type
        if self.times_used is not None:
            result['times_used'] = self.times_used
        if self.title is not None:
            result['title'] = self.title
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cause') is not None:
            self.cause = m.get('cause')
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('finished_date') is not None:
            self.finished_date = m.get('finished_date')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_part_apply_id') is not None:
            self.third_part_apply_id = m.get('third_part_apply_id')
        if m.get('third_part_cost_center_id') is not None:
            self.third_part_cost_center_id = m.get('third_part_cost_center_id')
        if m.get('third_part_invoice_id') is not None:
            self.third_part_invoice_id = m.get('third_part_invoice_id')
        if m.get('times_total') is not None:
            self.times_total = m.get('times_total')
        if m.get('times_type') is not None:
            self.times_type = m.get('times_type')
        if m.get('times_used') is not None:
            self.times_used = m.get('times_used')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyAddResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: int = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarApplyAddResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarApplyAddResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarApplyAddResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarApplyModifyHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarApplyModifyRequest(TeaModel):
    def __init__(
        self,
        operate_time: str = None,
        remark: str = None,
        status: int = None,
        third_part_apply_id: str = None,
        user_id: str = None,
    ):
        self.operate_time = operate_time
        self.remark = remark
        self.status = status
        self.third_part_apply_id = third_part_apply_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.third_part_apply_id is not None:
            result['third_part_apply_id'] = self.third_part_apply_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_part_apply_id') is not None:
            self.third_part_apply_id = m.get('third_part_apply_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyModifyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: bool = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarApplyModifyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarApplyModifyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarApplyModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarApplyQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarApplyQueryRequest(TeaModel):
    def __init__(
        self,
        created_end_at: str = None,
        created_start_at: str = None,
        page_number: int = None,
        page_size: int = None,
        third_part_apply_id: str = None,
        user_id: str = None,
    ):
        self.created_end_at = created_end_at
        self.created_start_at = created_start_at
        self.page_number = page_number
        self.page_size = page_size
        self.third_part_apply_id = third_part_apply_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_end_at is not None:
            result['created_end_at'] = self.created_end_at
        if self.created_start_at is not None:
            result['created_start_at'] = self.created_start_at
        if self.page_number is not None:
            result['page_number'] = self.page_number
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.third_part_apply_id is not None:
            result['third_part_apply_id'] = self.third_part_apply_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('created_end_at') is not None:
            self.created_end_at = m.get('created_end_at')
        if m.get('created_start_at') is not None:
            self.created_start_at = m.get('created_start_at')
        if m.get('page_number') is not None:
            self.page_number = m.get('page_number')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('third_part_apply_id') is not None:
            self.third_part_apply_id = m.get('third_part_apply_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarApplyQueryResponseBodyApplyListApproverList(TeaModel):
    def __init__(
        self,
        note: str = None,
        operate_time: str = None,
        order: int = None,
        status: int = None,
        status_desc: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.note = note
        self.operate_time = operate_time
        self.order = order
        self.status = status
        self.status_desc = status_desc
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['note'] = self.note
        if self.operate_time is not None:
            result['operate_time'] = self.operate_time
        if self.order is not None:
            result['order'] = self.order
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('note') is not None:
            self.note = m.get('note')
        if m.get('operate_time') is not None:
            self.operate_time = m.get('operate_time')
        if m.get('order') is not None:
            self.order = m.get('order')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarApplyQueryResponseBodyApplyListItineraryList(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_city_code: str = None,
        arr_date: str = None,
        cost_center_id: int = None,
        cost_center_name: str = None,
        dep_city: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
        invoice_id: int = None,
        invoice_name: str = None,
        itinerary_id: str = None,
        project_code: str = None,
        project_title: str = None,
        traffic_type: int = None,
    ):
        self.arr_city = arr_city
        self.arr_city_code = arr_city_code
        self.arr_date = arr_date
        self.cost_center_id = cost_center_id
        self.cost_center_name = cost_center_name
        self.dep_city = dep_city
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date
        self.invoice_id = invoice_id
        self.invoice_name = invoice_name
        self.itinerary_id = itinerary_id
        self.project_code = project_code
        self.project_title = project_title
        self.traffic_type = traffic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.invoice_name is not None:
            result['invoice_name'] = self.invoice_name
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.traffic_type is not None:
            result['traffic_type'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('invoice_name') is not None:
            self.invoice_name = m.get('invoice_name')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('traffic_type') is not None:
            self.traffic_type = m.get('traffic_type')
        return self


class CarApplyQueryResponseBodyApplyList(TeaModel):
    def __init__(
        self,
        approver_list: List[CarApplyQueryResponseBodyApplyListApproverList] = None,
        depart_id: str = None,
        depart_name: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        itinerary_list: List[CarApplyQueryResponseBodyApplyListItineraryList] = None,
        status: int = None,
        status_desc: str = None,
        thirdpart_id: str = None,
        trip_cause: str = None,
        trip_title: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.approver_list = approver_list
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.itinerary_list = itinerary_list
        self.status = status
        self.status_desc = status_desc
        self.thirdpart_id = thirdpart_id
        self.trip_cause = trip_cause
        self.trip_title = trip_title
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        if self.approver_list:
            for k in self.approver_list:
                if k:
                    k.validate()
        if self.itinerary_list:
            for k in self.itinerary_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['approver_list'] = []
        if self.approver_list is not None:
            for k in self.approver_list:
                result['approver_list'].append(k.to_map() if k else None)
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        result['itinerary_list'] = []
        if self.itinerary_list is not None:
            for k in self.itinerary_list:
                result['itinerary_list'].append(k.to_map() if k else None)
        if self.status is not None:
            result['status'] = self.status
        if self.status_desc is not None:
            result['status_desc'] = self.status_desc
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.trip_title is not None:
            result['trip_title'] = self.trip_title
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.approver_list = []
        if m.get('approver_list') is not None:
            for k in m.get('approver_list'):
                temp_model = CarApplyQueryResponseBodyApplyListApproverList()
                self.approver_list.append(temp_model.from_map(k))
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        self.itinerary_list = []
        if m.get('itinerary_list') is not None:
            for k in m.get('itinerary_list'):
                temp_model = CarApplyQueryResponseBodyApplyListItineraryList()
                self.itinerary_list.append(temp_model.from_map(k))
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('status_desc') is not None:
            self.status_desc = m.get('status_desc')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('trip_title') is not None:
            self.trip_title = m.get('trip_title')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarApplyQueryResponseBody(TeaModel):
    def __init__(
        self,
        apply_list: List[CarApplyQueryResponseBodyApplyList] = None,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
        trace_id: str = None,
    ):
        self.apply_list = apply_list
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.total = total
        self.trace_id = trace_id

    def validate(self):
        if self.apply_list:
            for k in self.apply_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['apply_list'] = []
        if self.apply_list is not None:
            for k in self.apply_list:
                result['apply_list'].append(k.to_map() if k else None)
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.total is not None:
            result['total'] = self.total
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.apply_list = []
        if m.get('apply_list') is not None:
            for k in m.get('apply_list'):
                temp_model = CarApplyQueryResponseBodyApplyList()
                self.apply_list.append(temp_model.from_map(k))
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarApplyQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarApplyQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarBillSettlementQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarBillSettlementQueryRequest(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        period_end: str = None,
        period_start: str = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.period_end = period_end
        self.period_start = period_start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        return self


class CarBillSettlementQueryResponseBodyModuleDataList(TeaModel):
    def __init__(
        self,
        alipay_trade_no: str = None,
        apply_id: str = None,
        arr_city: str = None,
        arr_date: str = None,
        arr_location: str = None,
        arr_time: str = None,
        bill_record_time: str = None,
        book_time: str = None,
        booker_id: str = None,
        booker_job_no: str = None,
        booker_name: str = None,
        business_category: str = None,
        capital_direction: str = None,
        car_level: str = None,
        cascade_department: str = None,
        cost_center: str = None,
        cost_center_number: str = None,
        coupon: float = None,
        coupon_price: float = None,
        department: str = None,
        department_id: str = None,
        dept_city: str = None,
        dept_date: str = None,
        dept_location: str = None,
        dept_time: str = None,
        estimate_drive_distance: str = None,
        estimate_price: float = None,
        fee_type: str = None,
        index: str = None,
        invoice_title: str = None,
        memo: str = None,
        order_id: str = None,
        order_price: float = None,
        over_apply_id: str = None,
        person_settle_fee: float = None,
        primary_id: int = None,
        project_code: str = None,
        project_name: str = None,
        provider_name: str = None,
        real_drive_distance: str = None,
        real_from_addr: str = None,
        real_to_addr: str = None,
        remark: str = None,
        service_fee: float = None,
        settlement_fee: float = None,
        settlement_grant_fee: float = None,
        settlement_time: str = None,
        settlement_type: str = None,
        special_order: str = None,
        special_reason: str = None,
        status: int = None,
        sub_order_id: str = None,
        traveler_id: str = None,
        traveler_job_no: str = None,
        traveler_name: str = None,
        user_confirm_desc: str = None,
        voucher_type: int = None,
    ):
        self.alipay_trade_no = alipay_trade_no
        self.apply_id = apply_id
        self.arr_city = arr_city
        self.arr_date = arr_date
        self.arr_location = arr_location
        self.arr_time = arr_time
        self.bill_record_time = bill_record_time
        self.book_time = book_time
        self.booker_id = booker_id
        self.booker_job_no = booker_job_no
        self.booker_name = booker_name
        self.business_category = business_category
        self.capital_direction = capital_direction
        self.car_level = car_level
        self.cascade_department = cascade_department
        self.cost_center = cost_center
        self.cost_center_number = cost_center_number
        self.coupon = coupon
        self.coupon_price = coupon_price
        self.department = department
        self.department_id = department_id
        self.dept_city = dept_city
        self.dept_date = dept_date
        self.dept_location = dept_location
        self.dept_time = dept_time
        self.estimate_drive_distance = estimate_drive_distance
        self.estimate_price = estimate_price
        self.fee_type = fee_type
        self.index = index
        self.invoice_title = invoice_title
        self.memo = memo
        self.order_id = order_id
        self.order_price = order_price
        self.over_apply_id = over_apply_id
        self.person_settle_fee = person_settle_fee
        self.primary_id = primary_id
        self.project_code = project_code
        self.project_name = project_name
        self.provider_name = provider_name
        self.real_drive_distance = real_drive_distance
        self.real_from_addr = real_from_addr
        self.real_to_addr = real_to_addr
        self.remark = remark
        self.service_fee = service_fee
        self.settlement_fee = settlement_fee
        self.settlement_grant_fee = settlement_grant_fee
        self.settlement_time = settlement_time
        self.settlement_type = settlement_type
        self.special_order = special_order
        self.special_reason = special_reason
        self.status = status
        self.sub_order_id = sub_order_id
        self.traveler_id = traveler_id
        self.traveler_job_no = traveler_job_no
        self.traveler_name = traveler_name
        self.user_confirm_desc = user_confirm_desc
        self.voucher_type = voucher_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.arr_location is not None:
            result['arr_location'] = self.arr_location
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.bill_record_time is not None:
            result['bill_record_time'] = self.bill_record_time
        if self.book_time is not None:
            result['book_time'] = self.book_time
        if self.booker_id is not None:
            result['booker_id'] = self.booker_id
        if self.booker_job_no is not None:
            result['booker_job_no'] = self.booker_job_no
        if self.booker_name is not None:
            result['booker_name'] = self.booker_name
        if self.business_category is not None:
            result['business_category'] = self.business_category
        if self.capital_direction is not None:
            result['capital_direction'] = self.capital_direction
        if self.car_level is not None:
            result['car_level'] = self.car_level
        if self.cascade_department is not None:
            result['cascade_department'] = self.cascade_department
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.coupon is not None:
            result['coupon'] = self.coupon
        if self.coupon_price is not None:
            result['coupon_price'] = self.coupon_price
        if self.department is not None:
            result['department'] = self.department
        if self.department_id is not None:
            result['department_id'] = self.department_id
        if self.dept_city is not None:
            result['dept_city'] = self.dept_city
        if self.dept_date is not None:
            result['dept_date'] = self.dept_date
        if self.dept_location is not None:
            result['dept_location'] = self.dept_location
        if self.dept_time is not None:
            result['dept_time'] = self.dept_time
        if self.estimate_drive_distance is not None:
            result['estimate_drive_distance'] = self.estimate_drive_distance
        if self.estimate_price is not None:
            result['estimate_price'] = self.estimate_price
        if self.fee_type is not None:
            result['fee_type'] = self.fee_type
        if self.index is not None:
            result['index'] = self.index
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.memo is not None:
            result['memo'] = self.memo
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_price is not None:
            result['order_price'] = self.order_price
        if self.over_apply_id is not None:
            result['over_apply_id'] = self.over_apply_id
        if self.person_settle_fee is not None:
            result['person_settle_fee'] = self.person_settle_fee
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.provider_name is not None:
            result['provider_name'] = self.provider_name
        if self.real_drive_distance is not None:
            result['real_drive_distance'] = self.real_drive_distance
        if self.real_from_addr is not None:
            result['real_from_addr'] = self.real_from_addr
        if self.real_to_addr is not None:
            result['real_to_addr'] = self.real_to_addr
        if self.remark is not None:
            result['remark'] = self.remark
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.settlement_fee is not None:
            result['settlement_fee'] = self.settlement_fee
        if self.settlement_grant_fee is not None:
            result['settlement_grant_fee'] = self.settlement_grant_fee
        if self.settlement_time is not None:
            result['settlement_time'] = self.settlement_time
        if self.settlement_type is not None:
            result['settlement_type'] = self.settlement_type
        if self.special_order is not None:
            result['special_order'] = self.special_order
        if self.special_reason is not None:
            result['special_reason'] = self.special_reason
        if self.status is not None:
            result['status'] = self.status
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        if self.traveler_id is not None:
            result['traveler_id'] = self.traveler_id
        if self.traveler_job_no is not None:
            result['traveler_job_no'] = self.traveler_job_no
        if self.traveler_name is not None:
            result['traveler_name'] = self.traveler_name
        if self.user_confirm_desc is not None:
            result['user_confirm_desc'] = self.user_confirm_desc
        if self.voucher_type is not None:
            result['voucher_type'] = self.voucher_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('arr_location') is not None:
            self.arr_location = m.get('arr_location')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('bill_record_time') is not None:
            self.bill_record_time = m.get('bill_record_time')
        if m.get('book_time') is not None:
            self.book_time = m.get('book_time')
        if m.get('booker_id') is not None:
            self.booker_id = m.get('booker_id')
        if m.get('booker_job_no') is not None:
            self.booker_job_no = m.get('booker_job_no')
        if m.get('booker_name') is not None:
            self.booker_name = m.get('booker_name')
        if m.get('business_category') is not None:
            self.business_category = m.get('business_category')
        if m.get('capital_direction') is not None:
            self.capital_direction = m.get('capital_direction')
        if m.get('car_level') is not None:
            self.car_level = m.get('car_level')
        if m.get('cascade_department') is not None:
            self.cascade_department = m.get('cascade_department')
        if m.get('cost_center') is not None:
            self.cost_center = m.get('cost_center')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('coupon') is not None:
            self.coupon = m.get('coupon')
        if m.get('coupon_price') is not None:
            self.coupon_price = m.get('coupon_price')
        if m.get('department') is not None:
            self.department = m.get('department')
        if m.get('department_id') is not None:
            self.department_id = m.get('department_id')
        if m.get('dept_city') is not None:
            self.dept_city = m.get('dept_city')
        if m.get('dept_date') is not None:
            self.dept_date = m.get('dept_date')
        if m.get('dept_location') is not None:
            self.dept_location = m.get('dept_location')
        if m.get('dept_time') is not None:
            self.dept_time = m.get('dept_time')
        if m.get('estimate_drive_distance') is not None:
            self.estimate_drive_distance = m.get('estimate_drive_distance')
        if m.get('estimate_price') is not None:
            self.estimate_price = m.get('estimate_price')
        if m.get('fee_type') is not None:
            self.fee_type = m.get('fee_type')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_price') is not None:
            self.order_price = m.get('order_price')
        if m.get('over_apply_id') is not None:
            self.over_apply_id = m.get('over_apply_id')
        if m.get('person_settle_fee') is not None:
            self.person_settle_fee = m.get('person_settle_fee')
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('provider_name') is not None:
            self.provider_name = m.get('provider_name')
        if m.get('real_drive_distance') is not None:
            self.real_drive_distance = m.get('real_drive_distance')
        if m.get('real_from_addr') is not None:
            self.real_from_addr = m.get('real_from_addr')
        if m.get('real_to_addr') is not None:
            self.real_to_addr = m.get('real_to_addr')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('settlement_fee') is not None:
            self.settlement_fee = m.get('settlement_fee')
        if m.get('settlement_grant_fee') is not None:
            self.settlement_grant_fee = m.get('settlement_grant_fee')
        if m.get('settlement_time') is not None:
            self.settlement_time = m.get('settlement_time')
        if m.get('settlement_type') is not None:
            self.settlement_type = m.get('settlement_type')
        if m.get('special_order') is not None:
            self.special_order = m.get('special_order')
        if m.get('special_reason') is not None:
            self.special_reason = m.get('special_reason')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        if m.get('traveler_id') is not None:
            self.traveler_id = m.get('traveler_id')
        if m.get('traveler_job_no') is not None:
            self.traveler_job_no = m.get('traveler_job_no')
        if m.get('traveler_name') is not None:
            self.traveler_name = m.get('traveler_name')
        if m.get('user_confirm_desc') is not None:
            self.user_confirm_desc = m.get('user_confirm_desc')
        if m.get('voucher_type') is not None:
            self.voucher_type = m.get('voucher_type')
        return self


class CarBillSettlementQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        category: int = None,
        corp_id: str = None,
        data_list: List[CarBillSettlementQueryResponseBodyModuleDataList] = None,
        period_end: str = None,
        period_start: str = None,
        total_num: int = None,
    ):
        self.category = category
        self.corp_id = corp_id
        self.data_list = data_list
        self.period_end = period_end
        self.period_start = period_start
        self.total_num = total_num

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        result['data_list'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['data_list'].append(k.to_map() if k else None)
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.total_num is not None:
            result['total_num'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        self.data_list = []
        if m.get('data_list') is not None:
            for k in m.get('data_list'):
                temp_model = CarBillSettlementQueryResponseBodyModuleDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('total_num') is not None:
            self.total_num = m.get('total_num')
        return self


class CarBillSettlementQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CarBillSettlementQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CarBillSettlementQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarBillSettlementQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarBillSettlementQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarBillSettlementQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarOrderListQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarOrderListQueryRequest(TeaModel):
    def __init__(
        self,
        all_apply: bool = None,
        apply_id: int = None,
        depart_id: str = None,
        end_time: str = None,
        page: int = None,
        page_size: int = None,
        start_time: str = None,
        thirdpart_apply_id: str = None,
        update_end_time: str = None,
        update_start_time: str = None,
        user_id: str = None,
    ):
        self.all_apply = all_apply
        self.apply_id = apply_id
        self.depart_id = depart_id
        self.end_time = end_time
        self.page = page
        self.page_size = page_size
        self.start_time = start_time
        self.thirdpart_apply_id = thirdpart_apply_id
        self.update_end_time = update_end_time
        self.update_start_time = update_start_time
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_apply is not None:
            result['all_apply'] = self.all_apply
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.update_end_time is not None:
            result['update_end_time'] = self.update_end_time
        if self.update_start_time is not None:
            result['update_start_time'] = self.update_start_time
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('all_apply') is not None:
            self.all_apply = m.get('all_apply')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('update_end_time') is not None:
            self.update_end_time = m.get('update_end_time')
        if m.get('update_start_time') is not None:
            self.update_start_time = m.get('update_start_time')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CarOrderListQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(
        self,
        category_code: int = None,
        category_type: int = None,
        gmt_create: str = None,
        passenger_name: str = None,
        pay_type: int = None,
        person_price: float = None,
        price: float = None,
        trade_id: str = None,
        type: int = None,
    ):
        self.category_code = category_code
        self.category_type = category_type
        self.gmt_create = gmt_create
        self.passenger_name = passenger_name
        self.pay_type = pay_type
        self.person_price = person_price
        self.price = price
        self.trade_id = trade_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.category_type is not None:
            result['category_type'] = self.category_type
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.person_price is not None:
            result['person_price'] = self.person_price
        if self.price is not None:
            result['price'] = self.price
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('category_type') is not None:
            self.category_type = m.get('category_type')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('person_price') is not None:
            self.person_price = m.get('person_price')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CarOrderListQueryResponseBodyModuleUserAffiliateList(TeaModel):
    def __init__(
        self,
        user_id: str = None,
        user_name: str = None,
    ):
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarOrderListQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        apply_show_id: str = None,
        btrip_title: str = None,
        business_category: str = None,
        cancel_time: str = None,
        car_info: str = None,
        car_level: int = None,
        corp_id: str = None,
        corp_name: str = None,
        cost_center_id: int = None,
        cost_center_name: str = None,
        cost_center_number: str = None,
        dept_id: int = None,
        dept_name: str = None,
        driver_confirm_time: str = None,
        estimate_price: float = None,
        from_address: str = None,
        from_city_name: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        invoice_id: int = None,
        invoice_title: str = None,
        is_special: bool = None,
        memo: str = None,
        order_status: int = None,
        passenger_name: str = None,
        pay_time: str = None,
        price_info_list: List[CarOrderListQueryResponseBodyModulePriceInfoList] = None,
        project_code: str = None,
        project_id: int = None,
        project_title: str = None,
        provider: int = None,
        publish_time: str = None,
        real_from_address: str = None,
        real_from_city_name: str = None,
        real_to_address: str = None,
        real_to_city_name: str = None,
        service_type: int = None,
        special_types: List[str] = None,
        taken_time: str = None,
        thirdpart_apply_id: str = None,
        thirdpart_itinerary_id: str = None,
        to_address: str = None,
        to_city_name: str = None,
        travel_distance: float = None,
        user_affiliate_list: List[CarOrderListQueryResponseBodyModuleUserAffiliateList] = None,
        user_confirm: int = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.apply_id = apply_id
        self.apply_show_id = apply_show_id
        self.btrip_title = btrip_title
        self.business_category = business_category
        self.cancel_time = cancel_time
        self.car_info = car_info
        self.car_level = car_level
        self.corp_id = corp_id
        self.corp_name = corp_name
        self.cost_center_id = cost_center_id
        self.cost_center_name = cost_center_name
        self.cost_center_number = cost_center_number
        self.dept_id = dept_id
        self.dept_name = dept_name
        self.driver_confirm_time = driver_confirm_time
        self.estimate_price = estimate_price
        self.from_address = from_address
        self.from_city_name = from_city_name
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.invoice_id = invoice_id
        self.invoice_title = invoice_title
        self.is_special = is_special
        self.memo = memo
        self.order_status = order_status
        self.passenger_name = passenger_name
        self.pay_time = pay_time
        self.price_info_list = price_info_list
        self.project_code = project_code
        self.project_id = project_id
        self.project_title = project_title
        self.provider = provider
        self.publish_time = publish_time
        self.real_from_address = real_from_address
        self.real_from_city_name = real_from_city_name
        self.real_to_address = real_to_address
        self.real_to_city_name = real_to_city_name
        self.service_type = service_type
        self.special_types = special_types
        self.taken_time = taken_time
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_itinerary_id = thirdpart_itinerary_id
        self.to_address = to_address
        self.to_city_name = to_city_name
        self.travel_distance = travel_distance
        self.user_affiliate_list = user_affiliate_list
        self.user_confirm = user_confirm
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()
        if self.user_affiliate_list:
            for k in self.user_affiliate_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.apply_show_id is not None:
            result['apply_show_id'] = self.apply_show_id
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.business_category is not None:
            result['business_category'] = self.business_category
        if self.cancel_time is not None:
            result['cancel_time'] = self.cancel_time
        if self.car_info is not None:
            result['car_info'] = self.car_info
        if self.car_level is not None:
            result['car_level'] = self.car_level
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.dept_id is not None:
            result['dept_id'] = self.dept_id
        if self.dept_name is not None:
            result['dept_name'] = self.dept_name
        if self.driver_confirm_time is not None:
            result['driver_confirm_time'] = self.driver_confirm_time
        if self.estimate_price is not None:
            result['estimate_price'] = self.estimate_price
        if self.from_address is not None:
            result['from_address'] = self.from_address
        if self.from_city_name is not None:
            result['from_city_name'] = self.from_city_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        if self.invoice_id is not None:
            result['invoice_id'] = self.invoice_id
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.is_special is not None:
            result['is_special'] = self.is_special
        if self.memo is not None:
            result['memo'] = self.memo
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.provider is not None:
            result['provider'] = self.provider
        if self.publish_time is not None:
            result['publish_time'] = self.publish_time
        if self.real_from_address is not None:
            result['real_from_address'] = self.real_from_address
        if self.real_from_city_name is not None:
            result['real_from_city_name'] = self.real_from_city_name
        if self.real_to_address is not None:
            result['real_to_address'] = self.real_to_address
        if self.real_to_city_name is not None:
            result['real_to_city_name'] = self.real_to_city_name
        if self.service_type is not None:
            result['service_type'] = self.service_type
        if self.special_types is not None:
            result['special_types'] = self.special_types
        if self.taken_time is not None:
            result['taken_time'] = self.taken_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.to_address is not None:
            result['to_address'] = self.to_address
        if self.to_city_name is not None:
            result['to_city_name'] = self.to_city_name
        if self.travel_distance is not None:
            result['travel_distance'] = self.travel_distance
        result['user_affiliate_list'] = []
        if self.user_affiliate_list is not None:
            for k in self.user_affiliate_list:
                result['user_affiliate_list'].append(k.to_map() if k else None)
        if self.user_confirm is not None:
            result['user_confirm'] = self.user_confirm
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('apply_show_id') is not None:
            self.apply_show_id = m.get('apply_show_id')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('business_category') is not None:
            self.business_category = m.get('business_category')
        if m.get('cancel_time') is not None:
            self.cancel_time = m.get('cancel_time')
        if m.get('car_info') is not None:
            self.car_info = m.get('car_info')
        if m.get('car_level') is not None:
            self.car_level = m.get('car_level')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('dept_id') is not None:
            self.dept_id = m.get('dept_id')
        if m.get('dept_name') is not None:
            self.dept_name = m.get('dept_name')
        if m.get('driver_confirm_time') is not None:
            self.driver_confirm_time = m.get('driver_confirm_time')
        if m.get('estimate_price') is not None:
            self.estimate_price = m.get('estimate_price')
        if m.get('from_address') is not None:
            self.from_address = m.get('from_address')
        if m.get('from_city_name') is not None:
            self.from_city_name = m.get('from_city_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('invoice_id') is not None:
            self.invoice_id = m.get('invoice_id')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('is_special') is not None:
            self.is_special = m.get('is_special')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = CarOrderListQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('provider') is not None:
            self.provider = m.get('provider')
        if m.get('publish_time') is not None:
            self.publish_time = m.get('publish_time')
        if m.get('real_from_address') is not None:
            self.real_from_address = m.get('real_from_address')
        if m.get('real_from_city_name') is not None:
            self.real_from_city_name = m.get('real_from_city_name')
        if m.get('real_to_address') is not None:
            self.real_to_address = m.get('real_to_address')
        if m.get('real_to_city_name') is not None:
            self.real_to_city_name = m.get('real_to_city_name')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        if m.get('special_types') is not None:
            self.special_types = m.get('special_types')
        if m.get('taken_time') is not None:
            self.taken_time = m.get('taken_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('to_address') is not None:
            self.to_address = m.get('to_address')
        if m.get('to_city_name') is not None:
            self.to_city_name = m.get('to_city_name')
        if m.get('travel_distance') is not None:
            self.travel_distance = m.get('travel_distance')
        self.user_affiliate_list = []
        if m.get('user_affiliate_list') is not None:
            for k in m.get('user_affiliate_list'):
                temp_model = CarOrderListQueryResponseBodyModuleUserAffiliateList()
                self.user_affiliate_list.append(temp_model.from_map(k))
        if m.get('user_confirm') is not None:
            self.user_confirm = m.get('user_confirm')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarOrderListQueryResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        page: int = None,
        page_size: int = None,
        total_number: int = None,
    ):
        self.page = page
        self.page_size = page_size
        self.total_number = total_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_number is not None:
            result['total_number'] = self.total_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_number') is not None:
            self.total_number = m.get('total_number')
        return self


class CarOrderListQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: List[CarOrderListQueryResponseBodyModule] = None,
        page_info: CarOrderListQueryResponseBodyPageInfo = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.page_info = page_info
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['page_info'] = self.page_info.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = CarOrderListQueryResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('page_info') is not None:
            temp_model = CarOrderListQueryResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['page_info'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarOrderListQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarOrderListQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarOrderListQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CarOrderQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CarOrderQueryRequest(TeaModel):
    def __init__(
        self,
        order_id: int = None,
        sub_order_id: int = None,
    ):
        self.order_id = order_id
        self.sub_order_id = sub_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        return self


class CarOrderQueryResponseBodyModuleCarInfo(TeaModel):
    def __init__(
        self,
        business_category: str = None,
        cancel_time: int = None,
        car_info: str = None,
        car_level: int = None,
        driver_confirm_time: int = None,
        estimate_price: int = None,
        from_address: str = None,
        from_city_name: str = None,
        is_special: bool = None,
        memo: str = None,
        pay_time: int = None,
        publish_time: int = None,
        real_from_address: str = None,
        real_from_city_name: str = None,
        real_to_address: str = None,
        real_to_city_name: str = None,
        service_type: int = None,
        special_types: str = None,
        taken_time: int = None,
        to_address: str = None,
        to_city_name: str = None,
        travel_distance: str = None,
    ):
        self.business_category = business_category
        self.cancel_time = cancel_time
        self.car_info = car_info
        self.car_level = car_level
        self.driver_confirm_time = driver_confirm_time
        self.estimate_price = estimate_price
        self.from_address = from_address
        self.from_city_name = from_city_name
        self.is_special = is_special
        self.memo = memo
        self.pay_time = pay_time
        self.publish_time = publish_time
        self.real_from_address = real_from_address
        self.real_from_city_name = real_from_city_name
        self.real_to_address = real_to_address
        self.real_to_city_name = real_to_city_name
        self.service_type = service_type
        self.special_types = special_types
        self.taken_time = taken_time
        self.to_address = to_address
        self.to_city_name = to_city_name
        self.travel_distance = travel_distance

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_category is not None:
            result['business_category'] = self.business_category
        if self.cancel_time is not None:
            result['cancel_time'] = self.cancel_time
        if self.car_info is not None:
            result['car_info'] = self.car_info
        if self.car_level is not None:
            result['car_level'] = self.car_level
        if self.driver_confirm_time is not None:
            result['driver_confirm_time'] = self.driver_confirm_time
        if self.estimate_price is not None:
            result['estimate_price'] = self.estimate_price
        if self.from_address is not None:
            result['from_address'] = self.from_address
        if self.from_city_name is not None:
            result['from_city_name'] = self.from_city_name
        if self.is_special is not None:
            result['is_special'] = self.is_special
        if self.memo is not None:
            result['memo'] = self.memo
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        if self.publish_time is not None:
            result['publish_time'] = self.publish_time
        if self.real_from_address is not None:
            result['real_from_address'] = self.real_from_address
        if self.real_from_city_name is not None:
            result['real_from_city_name'] = self.real_from_city_name
        if self.real_to_address is not None:
            result['real_to_address'] = self.real_to_address
        if self.real_to_city_name is not None:
            result['real_to_city_name'] = self.real_to_city_name
        if self.service_type is not None:
            result['service_type'] = self.service_type
        if self.special_types is not None:
            result['special_types'] = self.special_types
        if self.taken_time is not None:
            result['taken_time'] = self.taken_time
        if self.to_address is not None:
            result['to_address'] = self.to_address
        if self.to_city_name is not None:
            result['to_city_name'] = self.to_city_name
        if self.travel_distance is not None:
            result['travel_distance'] = self.travel_distance
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('business_category') is not None:
            self.business_category = m.get('business_category')
        if m.get('cancel_time') is not None:
            self.cancel_time = m.get('cancel_time')
        if m.get('car_info') is not None:
            self.car_info = m.get('car_info')
        if m.get('car_level') is not None:
            self.car_level = m.get('car_level')
        if m.get('driver_confirm_time') is not None:
            self.driver_confirm_time = m.get('driver_confirm_time')
        if m.get('estimate_price') is not None:
            self.estimate_price = m.get('estimate_price')
        if m.get('from_address') is not None:
            self.from_address = m.get('from_address')
        if m.get('from_city_name') is not None:
            self.from_city_name = m.get('from_city_name')
        if m.get('is_special') is not None:
            self.is_special = m.get('is_special')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        if m.get('publish_time') is not None:
            self.publish_time = m.get('publish_time')
        if m.get('real_from_address') is not None:
            self.real_from_address = m.get('real_from_address')
        if m.get('real_from_city_name') is not None:
            self.real_from_city_name = m.get('real_from_city_name')
        if m.get('real_to_address') is not None:
            self.real_to_address = m.get('real_to_address')
        if m.get('real_to_city_name') is not None:
            self.real_to_city_name = m.get('real_to_city_name')
        if m.get('service_type') is not None:
            self.service_type = m.get('service_type')
        if m.get('special_types') is not None:
            self.special_types = m.get('special_types')
        if m.get('taken_time') is not None:
            self.taken_time = m.get('taken_time')
        if m.get('to_address') is not None:
            self.to_address = m.get('to_address')
        if m.get('to_city_name') is not None:
            self.to_city_name = m.get('to_city_name')
        if m.get('travel_distance') is not None:
            self.travel_distance = m.get('travel_distance')
        return self


class CarOrderQueryResponseBodyModuleInvoiceInfo(TeaModel):
    def __init__(
        self,
        id: int = None,
        title: str = None,
    ):
        self.id = id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CarOrderQueryResponseBodyModuleOrderBaseInfo(TeaModel):
    def __init__(
        self,
        apply_id: str = None,
        btrip_cause: str = None,
        btrip_title: str = None,
        corp_id: str = None,
        corp_name: str = None,
        depart_id: str = None,
        depart_name: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        itinerary_id: str = None,
        order_id: int = None,
        order_status: int = None,
        sub_order_id: int = None,
        third_depart_id: str = None,
        thirdpart_apply_id: str = None,
        thirdpart_itinerary_id: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.apply_id = apply_id
        self.btrip_cause = btrip_cause
        self.btrip_title = btrip_title
        self.corp_id = corp_id
        self.corp_name = corp_name
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.itinerary_id = itinerary_id
        self.order_id = order_id
        self.order_status = order_status
        self.sub_order_id = sub_order_id
        self.third_depart_id = third_depart_id
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_itinerary_id = thirdpart_itinerary_id
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.btrip_cause is not None:
            result['btrip_cause'] = self.btrip_cause
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.sub_order_id is not None:
            result['sub_order_id'] = self.sub_order_id
        if self.third_depart_id is not None:
            result['third_depart_id'] = self.third_depart_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('btrip_cause') is not None:
            self.btrip_cause = m.get('btrip_cause')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('sub_order_id') is not None:
            self.sub_order_id = m.get('sub_order_id')
        if m.get('third_depart_id') is not None:
            self.third_depart_id = m.get('third_depart_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class CarOrderQueryResponseBodyModulePassengerList(TeaModel):
    def __init__(
        self,
        cost_center_id: int = None,
        cost_center_name: str = None,
        cost_center_number: str = None,
        project_code: str = None,
        project_id: int = None,
        project_title: str = None,
        thirdpart_cost_center_id: str = None,
        thirdpart_project_id: str = None,
        user_id: str = None,
        user_name: str = None,
        user_type: int = None,
    ):
        self.cost_center_id = cost_center_id
        self.cost_center_name = cost_center_name
        self.cost_center_number = cost_center_number
        self.project_code = project_code
        self.project_id = project_id
        self.project_title = project_title
        self.thirdpart_cost_center_id = thirdpart_cost_center_id
        self.thirdpart_project_id = thirdpart_project_id
        self.user_id = user_id
        self.user_name = user_name
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_cost_center_id is not None:
            result['thirdpart_cost_center_id'] = self.thirdpart_cost_center_id
        if self.thirdpart_project_id is not None:
            result['thirdpart_project_id'] = self.thirdpart_project_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.user_type is not None:
            result['user_type'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_cost_center_id') is not None:
            self.thirdpart_cost_center_id = m.get('thirdpart_cost_center_id')
        if m.get('thirdpart_project_id') is not None:
            self.thirdpart_project_id = m.get('thirdpart_project_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        return self


class CarOrderQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(
        self,
        category_code: int = None,
        gmt_create: int = None,
        pay_type: int = None,
        person_price: int = None,
        price: int = None,
        trade_id: str = None,
        type: int = None,
    ):
        self.category_code = category_code
        self.gmt_create = gmt_create
        self.pay_type = pay_type
        self.person_price = person_price
        self.price = price
        self.trade_id = trade_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.person_price is not None:
            result['person_price'] = self.person_price
        if self.price is not None:
            result['price'] = self.price
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('person_price') is not None:
            self.person_price = m.get('person_price')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CarOrderQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        car_info: CarOrderQueryResponseBodyModuleCarInfo = None,
        invoice_info: CarOrderQueryResponseBodyModuleInvoiceInfo = None,
        order_base_info: CarOrderQueryResponseBodyModuleOrderBaseInfo = None,
        passenger_list: List[CarOrderQueryResponseBodyModulePassengerList] = None,
        price_info_list: List[CarOrderQueryResponseBodyModulePriceInfoList] = None,
    ):
        self.car_info = car_info
        self.invoice_info = invoice_info
        self.order_base_info = order_base_info
        self.passenger_list = passenger_list
        self.price_info_list = price_info_list

    def validate(self):
        if self.car_info:
            self.car_info.validate()
        if self.invoice_info:
            self.invoice_info.validate()
        if self.order_base_info:
            self.order_base_info.validate()
        if self.passenger_list:
            for k in self.passenger_list:
                if k:
                    k.validate()
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.car_info is not None:
            result['car_info'] = self.car_info.to_map()
        if self.invoice_info is not None:
            result['invoice_info'] = self.invoice_info.to_map()
        if self.order_base_info is not None:
            result['order_base_info'] = self.order_base_info.to_map()
        result['passenger_list'] = []
        if self.passenger_list is not None:
            for k in self.passenger_list:
                result['passenger_list'].append(k.to_map() if k else None)
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('car_info') is not None:
            temp_model = CarOrderQueryResponseBodyModuleCarInfo()
            self.car_info = temp_model.from_map(m['car_info'])
        if m.get('invoice_info') is not None:
            temp_model = CarOrderQueryResponseBodyModuleInvoiceInfo()
            self.invoice_info = temp_model.from_map(m['invoice_info'])
        if m.get('order_base_info') is not None:
            temp_model = CarOrderQueryResponseBodyModuleOrderBaseInfo()
            self.order_base_info = temp_model.from_map(m['order_base_info'])
        self.passenger_list = []
        if m.get('passenger_list') is not None:
            for k in m.get('passenger_list'):
                temp_model = CarOrderQueryResponseBodyModulePassengerList()
                self.passenger_list.append(temp_model.from_map(k))
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = CarOrderQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        return self


class CarOrderQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CarOrderQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        # requestId
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CarOrderQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CarOrderQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CarOrderQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CarOrderQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CitySearchHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CitySearchRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
    ):
        self.keyword = keyword

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['keyword'] = self.keyword
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('keyword') is not None:
            self.keyword = m.get('keyword')
        return self


class CitySearchResponseBodyModuleCities(TeaModel):
    def __init__(
        self,
        code: str = None,
        name: str = None,
        region: int = None,
    ):
        self.code = code
        self.name = name
        self.region = region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.name is not None:
            result['name'] = self.name
        if self.region is not None:
            result['region'] = self.region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('region') is not None:
            self.region = m.get('region')
        return self


class CitySearchResponseBodyModule(TeaModel):
    def __init__(
        self,
        cities: List[CitySearchResponseBodyModuleCities] = None,
    ):
        self.cities = cities

    def validate(self):
        if self.cities:
            for k in self.cities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['cities'] = []
        if self.cities is not None:
            for k in self.cities:
                result['cities'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cities = []
        if m.get('cities') is not None:
            for k in m.get('cities'):
                temp_model = CitySearchResponseBodyModuleCities()
                self.cities.append(temp_model.from_map(k))
        return self


class CitySearchResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CitySearchResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CitySearchResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CitySearchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CitySearchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CitySearchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommonApplyQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CommonApplyQueryRequest(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        biz_category: int = None,
        user_id: str = None,
    ):
        self.apply_id = apply_id
        self.biz_category = biz_category
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.biz_category is not None:
            result['biz_category'] = self.biz_category
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('biz_category') is not None:
            self.biz_category = m.get('biz_category')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CommonApplyQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        biz_category: int = None,
        cause: str = None,
        corp_id: str = None,
        extend_value: str = None,
        gmt_create: str = None,
        status: int = None,
        thirdpart_corp_id: str = None,
        thirdpart_id: str = None,
        trip_cause: str = None,
        user_id: str = None,
    ):
        self.apply_id = apply_id
        self.biz_category = biz_category
        self.cause = cause
        self.corp_id = corp_id
        self.extend_value = extend_value
        self.gmt_create = gmt_create
        self.status = status
        self.thirdpart_corp_id = thirdpart_corp_id
        self.thirdpart_id = thirdpart_id
        self.trip_cause = trip_cause
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.biz_category is not None:
            result['biz_category'] = self.biz_category
        if self.cause is not None:
            result['cause'] = self.cause
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.extend_value is not None:
            result['extend_value'] = self.extend_value
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.status is not None:
            result['status'] = self.status
        if self.thirdpart_corp_id is not None:
            result['thirdpart_corp_id'] = self.thirdpart_corp_id
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.trip_cause is not None:
            result['trip_cause'] = self.trip_cause
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('biz_category') is not None:
            self.biz_category = m.get('biz_category')
        if m.get('cause') is not None:
            self.cause = m.get('cause')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('extend_value') is not None:
            self.extend_value = m.get('extend_value')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdpart_corp_id') is not None:
            self.thirdpart_corp_id = m.get('thirdpart_corp_id')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('trip_cause') is not None:
            self.trip_cause = m.get('trip_cause')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CommonApplyQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CommonApplyQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CommonApplyQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CommonApplyQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CommonApplyQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CommonApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommonApplySyncHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CommonApplySyncRequest(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        biz_category: int = None,
        remark: str = None,
        status: int = None,
        thirdparty_flow_id: str = None,
        user_id: str = None,
    ):
        self.apply_id = apply_id
        self.biz_category = biz_category
        self.remark = remark
        self.status = status
        self.thirdparty_flow_id = thirdparty_flow_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.biz_category is not None:
            result['biz_category'] = self.biz_category
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.thirdparty_flow_id is not None:
            result['thirdparty_flow_id'] = self.thirdparty_flow_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('biz_category') is not None:
            self.biz_category = m.get('biz_category')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdparty_flow_id') is not None:
            self.thirdparty_flow_id = m.get('thirdparty_flow_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CommonApplySyncResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: bool = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CommonApplySyncResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CommonApplySyncResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CommonApplySyncResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CorpAuthLinkInfoQueryResponseBodyModuleLinkCorps(TeaModel):
    def __init__(
        self,
        corp_name: str = None,
        open_corp_id: str = None,
        true_corp_id: str = None,
    ):
        self.corp_name = corp_name
        self.open_corp_id = open_corp_id
        self.true_corp_id = true_corp_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.open_corp_id is not None:
            result['open_corp_id'] = self.open_corp_id
        if self.true_corp_id is not None:
            result['true_corp_id'] = self.true_corp_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('open_corp_id') is not None:
            self.open_corp_id = m.get('open_corp_id')
        if m.get('true_corp_id') is not None:
            self.true_corp_id = m.get('true_corp_id')
        return self


class CorpAuthLinkInfoQueryResponseBodyModuleOrgCorp(TeaModel):
    def __init__(
        self,
        corp_name: str = None,
        open_corp_id: str = None,
        true_corp_id: str = None,
    ):
        self.corp_name = corp_name
        self.open_corp_id = open_corp_id
        self.true_corp_id = true_corp_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.open_corp_id is not None:
            result['open_corp_id'] = self.open_corp_id
        if self.true_corp_id is not None:
            result['true_corp_id'] = self.true_corp_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('open_corp_id') is not None:
            self.open_corp_id = m.get('open_corp_id')
        if m.get('true_corp_id') is not None:
            self.true_corp_id = m.get('true_corp_id')
        return self


class CorpAuthLinkInfoQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        link_corps: List[CorpAuthLinkInfoQueryResponseBodyModuleLinkCorps] = None,
        org_corp: CorpAuthLinkInfoQueryResponseBodyModuleOrgCorp = None,
    ):
        self.link_corps = link_corps
        self.org_corp = org_corp

    def validate(self):
        if self.link_corps:
            for k in self.link_corps:
                if k:
                    k.validate()
        if self.org_corp:
            self.org_corp.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['link_corps'] = []
        if self.link_corps is not None:
            for k in self.link_corps:
                result['link_corps'].append(k.to_map() if k else None)
        if self.org_corp is not None:
            result['org_corp'] = self.org_corp.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.link_corps = []
        if m.get('link_corps') is not None:
            for k in m.get('link_corps'):
                temp_model = CorpAuthLinkInfoQueryResponseBodyModuleLinkCorps()
                self.link_corps.append(temp_model.from_map(k))
        if m.get('org_corp') is not None:
            temp_model = CorpAuthLinkInfoQueryResponseBodyModuleOrgCorp()
            self.org_corp = temp_model.from_map(m['org_corp'])
        return self


class CorpAuthLinkInfoQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CorpAuthLinkInfoQueryResponseBodyModule = None,
        request_id: str = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CorpAuthLinkInfoQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CorpAuthLinkInfoQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CorpAuthLinkInfoQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CorpAuthLinkInfoQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CorpTokenHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_access_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_access_token = x_acs_btrip_access_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_access_token is not None:
            result['x-acs-btrip-access-token'] = self.x_acs_btrip_access_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-access-token') is not None:
            self.x_acs_btrip_access_token = m.get('x-acs-btrip-access-token')
        return self


class CorpTokenRequest(TeaModel):
    def __init__(
        self,
        app_secret: str = None,
        corp_id: str = None,
        type: int = None,
    ):
        self.app_secret = app_secret
        self.corp_id = corp_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_secret is not None:
            result['app_secret'] = self.app_secret
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('app_secret') is not None:
            self.app_secret = m.get('app_secret')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class CorpTokenResponseBodyData(TeaModel):
    def __init__(
        self,
        expire: int = None,
        token: str = None,
    ):
        self.expire = expire
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class CorpTokenResponseBodyModule(TeaModel):
    def __init__(
        self,
        expire: int = None,
        start: int = None,
        token: str = None,
    ):
        self.expire = expire
        self.start = start
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire is not None:
            result['expire'] = self.expire
        if self.start is not None:
            result['start'] = self.start
        if self.token is not None:
            result['token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('expire') is not None:
            self.expire = m.get('expire')
        if m.get('start') is not None:
            self.start = m.get('start')
        if m.get('token') is not None:
            self.token = m.get('token')
        return self


class CorpTokenResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CorpTokenResponseBodyData = None,
        message: str = None,
        module: CorpTokenResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('data') is not None:
            temp_model = CorpTokenResponseBodyData()
            self.data = temp_model.from_map(m['data'])
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CorpTokenResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CorpTokenResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CorpTokenResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CorpTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterDeleteHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterDeleteRequest(TeaModel):
    def __init__(
        self,
        thirdpart_id: str = None,
    ):
        self.thirdpart_id = thirdpart_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class CostCenterDeleteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterDeleteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CostCenterDeleteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterDeleteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterModifyHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterModifyRequest(TeaModel):
    def __init__(
        self,
        alipay_no: str = None,
        number: str = None,
        scope: int = None,
        thirdpart_id: str = None,
        title: str = None,
    ):
        self.alipay_no = alipay_no
        self.number = number
        self.scope = scope
        self.thirdpart_id = thirdpart_id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_no is not None:
            result['alipay_no'] = self.alipay_no
        if self.number is not None:
            result['number'] = self.number
        if self.scope is not None:
            result['scope'] = self.scope
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipay_no') is not None:
            self.alipay_no = m.get('alipay_no')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CostCenterModifyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterModifyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CostCenterModifyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterQueryRequest(TeaModel):
    def __init__(
        self,
        need_org_entity: bool = None,
        thirdpart_id: str = None,
        title: str = None,
        user_id: str = None,
    ):
        self.need_org_entity = need_org_entity
        self.thirdpart_id = thirdpart_id
        self.title = title
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.need_org_entity is not None:
            result['need_org_entity'] = self.need_org_entity
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('need_org_entity') is not None:
            self.need_org_entity = m.get('need_org_entity')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class CostCenterQueryResponseBodyModuleEntityDOS(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        entity_id: str = None,
        entity_type: str = None,
        name: str = None,
        user_num: int = None,
    ):
        self.corp_id = corp_id
        self.entity_id = entity_id
        self.entity_type = entity_type
        self.name = name
        self.user_num = user_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        if self.name is not None:
            result['name'] = self.name
        if self.user_num is not None:
            result['user_num'] = self.user_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('user_num') is not None:
            self.user_num = m.get('user_num')
        return self


class CostCenterQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        alipay_no: str = None,
        corp_id: str = None,
        entity_dos: List[CostCenterQueryResponseBodyModuleEntityDOS] = None,
        id: int = None,
        number: str = None,
        rule_code: int = None,
        scope: int = None,
        thirdpart_id: str = None,
        title: str = None,
    ):
        self.alipay_no = alipay_no
        self.corp_id = corp_id
        self.entity_dos = entity_dos
        self.id = id
        self.number = number
        # rule code
        self.rule_code = rule_code
        self.scope = scope
        self.thirdpart_id = thirdpart_id
        self.title = title

    def validate(self):
        if self.entity_dos:
            for k in self.entity_dos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_no is not None:
            result['alipay_no'] = self.alipay_no
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        result['entity_d_o_s'] = []
        if self.entity_dos is not None:
            for k in self.entity_dos:
                result['entity_d_o_s'].append(k.to_map() if k else None)
        if self.id is not None:
            result['id'] = self.id
        if self.number is not None:
            result['number'] = self.number
        if self.rule_code is not None:
            result['rule_code'] = self.rule_code
        if self.scope is not None:
            result['scope'] = self.scope
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipay_no') is not None:
            self.alipay_no = m.get('alipay_no')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        self.entity_dos = []
        if m.get('entity_d_o_s') is not None:
            for k in m.get('entity_d_o_s'):
                temp_model = CostCenterQueryResponseBodyModuleEntityDOS()
                self.entity_dos.append(temp_model.from_map(k))
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('rule_code') is not None:
            self.rule_code = m.get('rule_code')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CostCenterQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: List[CostCenterQueryResponseBodyModule] = None,
        more_page: bool = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.more_page = more_page
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.more_page is not None:
            result['more_page'] = self.more_page
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = CostCenterQueryResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('more_page') is not None:
            self.more_page = m.get('more_page')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CostCenterQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CostCenterSaveHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class CostCenterSaveRequest(TeaModel):
    def __init__(
        self,
        alipay_no: str = None,
        number: str = None,
        scope: int = None,
        thirdpart_id: str = None,
        title: str = None,
    ):
        self.alipay_no = alipay_no
        self.number = number
        self.scope = scope
        self.thirdpart_id = thirdpart_id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_no is not None:
            result['alipay_no'] = self.alipay_no
        if self.number is not None:
            result['number'] = self.number
        if self.scope is not None:
            result['scope'] = self.scope
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipay_no') is not None:
            self.alipay_no = m.get('alipay_no')
        if m.get('number') is not None:
            self.number = m.get('number')
        if m.get('scope') is not None:
            self.scope = m.get('scope')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class CostCenterSaveResponseBodyModule(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        return self


class CostCenterSaveResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: CostCenterSaveResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = CostCenterSaveResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class CostCenterSaveResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CostCenterSaveResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CostCenterSaveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInvoiceEntityHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class DeleteInvoiceEntityRequestEntities(TeaModel):
    def __init__(
        self,
        entity_id: str = None,
        entity_type: str = None,
    ):
        self.entity_id = entity_id
        self.entity_type = entity_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        return self


class DeleteInvoiceEntityRequest(TeaModel):
    def __init__(
        self,
        del_all: bool = None,
        entities: List[DeleteInvoiceEntityRequestEntities] = None,
        third_part_id: str = None,
    ):
        self.del_all = del_all
        self.entities = entities
        self.third_part_id = third_part_id

    def validate(self):
        if self.entities:
            for k in self.entities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.del_all is not None:
            result['del_all'] = self.del_all
        result['entities'] = []
        if self.entities is not None:
            for k in self.entities:
                result['entities'].append(k.to_map() if k else None)
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('del_all') is not None:
            self.del_all = m.get('del_all')
        self.entities = []
        if m.get('entities') is not None:
            for k in m.get('entities'):
                temp_model = DeleteInvoiceEntityRequestEntities()
                self.entities.append(temp_model.from_map(k))
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        return self


class DeleteInvoiceEntityShrinkRequest(TeaModel):
    def __init__(
        self,
        del_all: bool = None,
        entities_shrink: str = None,
        third_part_id: str = None,
    ):
        self.del_all = del_all
        self.entities_shrink = entities_shrink
        self.third_part_id = third_part_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.del_all is not None:
            result['del_all'] = self.del_all
        if self.entities_shrink is not None:
            result['entities'] = self.entities_shrink
        if self.third_part_id is not None:
            result['third_part_id'] = self.third_part_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('del_all') is not None:
            self.del_all = m.get('del_all')
        if m.get('entities') is not None:
            self.entities_shrink = m.get('entities')
        if m.get('third_part_id') is not None:
            self.third_part_id = m.get('third_part_id')
        return self


class DeleteInvoiceEntityResponseBodyModule(TeaModel):
    def __init__(
        self,
        remove_num: int = None,
        selected_user_num: int = None,
    ):
        self.remove_num = remove_num
        self.selected_user_num = selected_user_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remove_num is not None:
            result['remove_num'] = self.remove_num
        if self.selected_user_num is not None:
            result['selected_user_num'] = self.selected_user_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('remove_num') is not None:
            self.remove_num = m.get('remove_num')
        if m.get('selected_user_num') is not None:
            self.selected_user_num = m.get('selected_user_num')
        return self


class DeleteInvoiceEntityResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: DeleteInvoiceEntityResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = DeleteInvoiceEntityResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class DeleteInvoiceEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInvoiceEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInvoiceEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DepartmentSaveHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class DepartmentSaveRequestDepartList(TeaModel):
    def __init__(
        self,
        depart_id: int = None,
        depart_name: str = None,
        depart_pid: int = None,
        manager_ids: str = None,
        status: int = None,
        third_depart_id: str = None,
        third_depart_pid: str = None,
    ):
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.depart_pid = depart_pid
        self.manager_ids = manager_ids
        self.status = status
        self.third_depart_id = third_depart_id
        self.third_depart_pid = third_depart_pid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.depart_pid is not None:
            result['depart_pid'] = self.depart_pid
        if self.manager_ids is not None:
            result['manager_ids'] = self.manager_ids
        if self.status is not None:
            result['status'] = self.status
        if self.third_depart_id is not None:
            result['third_depart_id'] = self.third_depart_id
        if self.third_depart_pid is not None:
            result['third_depart_pid'] = self.third_depart_pid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('depart_pid') is not None:
            self.depart_pid = m.get('depart_pid')
        if m.get('manager_ids') is not None:
            self.manager_ids = m.get('manager_ids')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_depart_id') is not None:
            self.third_depart_id = m.get('third_depart_id')
        if m.get('third_depart_pid') is not None:
            self.third_depart_pid = m.get('third_depart_pid')
        return self


class DepartmentSaveRequest(TeaModel):
    def __init__(
        self,
        depart_list: List[DepartmentSaveRequestDepartList] = None,
    ):
        self.depart_list = depart_list

    def validate(self):
        if self.depart_list:
            for k in self.depart_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['depart_list'] = []
        if self.depart_list is not None:
            for k in self.depart_list:
                result['depart_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.depart_list = []
        if m.get('depart_list') is not None:
            for k in m.get('depart_list'):
                temp_model = DepartmentSaveRequestDepartList()
                self.depart_list.append(temp_model.from_map(k))
        return self


class DepartmentSaveShrinkRequest(TeaModel):
    def __init__(
        self,
        depart_list_shrink: str = None,
    ):
        self.depart_list_shrink = depart_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.depart_list_shrink is not None:
            result['depart_list'] = self.depart_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('depart_list') is not None:
            self.depart_list_shrink = m.get('depart_list')
        return self


class DepartmentSaveResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class DepartmentSaveResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DepartmentSaveResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DepartmentSaveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EntityAddHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class EntityAddRequestEntityDOList(TeaModel):
    def __init__(
        self,
        entity_id: str = None,
        entity_type: str = None,
    ):
        self.entity_id = entity_id
        self.entity_type = entity_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        return self


class EntityAddRequest(TeaModel):
    def __init__(
        self,
        entity_dolist: List[EntityAddRequestEntityDOList] = None,
        thirdpart_id: str = None,
    ):
        self.entity_dolist = entity_dolist
        self.thirdpart_id = thirdpart_id

    def validate(self):
        if self.entity_dolist:
            for k in self.entity_dolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['entity_d_o_list'] = []
        if self.entity_dolist is not None:
            for k in self.entity_dolist:
                result['entity_d_o_list'].append(k.to_map() if k else None)
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.entity_dolist = []
        if m.get('entity_d_o_list') is not None:
            for k in m.get('entity_d_o_list'):
                temp_model = EntityAddRequestEntityDOList()
                self.entity_dolist.append(temp_model.from_map(k))
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntityAddShrinkRequest(TeaModel):
    def __init__(
        self,
        entity_dolist_shrink: str = None,
        thirdpart_id: str = None,
    ):
        self.entity_dolist_shrink = entity_dolist_shrink
        self.thirdpart_id = thirdpart_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_dolist_shrink is not None:
            result['entity_d_o_list'] = self.entity_dolist_shrink
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entity_d_o_list') is not None:
            self.entity_dolist_shrink = m.get('entity_d_o_list')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntityAddResponseBodyModule(TeaModel):
    def __init__(
        self,
        add_num: int = None,
        selected_user_num: int = None,
    ):
        self.add_num = add_num
        self.selected_user_num = selected_user_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_num is not None:
            result['add_num'] = self.add_num
        if self.selected_user_num is not None:
            result['selected_user_num'] = self.selected_user_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('add_num') is not None:
            self.add_num = m.get('add_num')
        if m.get('selected_user_num') is not None:
            self.selected_user_num = m.get('selected_user_num')
        return self


class EntityAddResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: EntityAddResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = EntityAddResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class EntityAddResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EntityAddResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EntityAddResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EntityDeleteHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class EntityDeleteRequestEntityDOList(TeaModel):
    def __init__(
        self,
        entity_id: str = None,
        entity_type: str = None,
    ):
        self.entity_id = entity_id
        self.entity_type = entity_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        return self


class EntityDeleteRequest(TeaModel):
    def __init__(
        self,
        del_all: bool = None,
        entity_dolist: List[EntityDeleteRequestEntityDOList] = None,
        thirdpart_id: str = None,
    ):
        self.del_all = del_all
        self.entity_dolist = entity_dolist
        self.thirdpart_id = thirdpart_id

    def validate(self):
        if self.entity_dolist:
            for k in self.entity_dolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.del_all is not None:
            result['del_all'] = self.del_all
        result['entity_d_o_list'] = []
        if self.entity_dolist is not None:
            for k in self.entity_dolist:
                result['entity_d_o_list'].append(k.to_map() if k else None)
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('del_all') is not None:
            self.del_all = m.get('del_all')
        self.entity_dolist = []
        if m.get('entity_d_o_list') is not None:
            for k in m.get('entity_d_o_list'):
                temp_model = EntityDeleteRequestEntityDOList()
                self.entity_dolist.append(temp_model.from_map(k))
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntityDeleteShrinkRequest(TeaModel):
    def __init__(
        self,
        del_all: bool = None,
        entity_dolist_shrink: str = None,
        thirdpart_id: str = None,
    ):
        self.del_all = del_all
        self.entity_dolist_shrink = entity_dolist_shrink
        self.thirdpart_id = thirdpart_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.del_all is not None:
            result['del_all'] = self.del_all
        if self.entity_dolist_shrink is not None:
            result['entity_d_o_list'] = self.entity_dolist_shrink
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('del_all') is not None:
            self.del_all = m.get('del_all')
        if m.get('entity_d_o_list') is not None:
            self.entity_dolist_shrink = m.get('entity_d_o_list')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntityDeleteResponseBodyModule(TeaModel):
    def __init__(
        self,
        remove_num: int = None,
        selected_user_num: int = None,
    ):
        self.remove_num = remove_num
        self.selected_user_num = selected_user_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remove_num is not None:
            result['remove_num'] = self.remove_num
        if self.selected_user_num is not None:
            result['selected_user_num'] = self.selected_user_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('remove_num') is not None:
            self.remove_num = m.get('remove_num')
        if m.get('selected_user_num') is not None:
            self.selected_user_num = m.get('selected_user_num')
        return self


class EntityDeleteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: EntityDeleteResponseBodyModule = None,
        more_page: bool = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.more_page = more_page
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.more_page is not None:
            result['more_page'] = self.more_page
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = EntityDeleteResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('more_page') is not None:
            self.more_page = m.get('more_page')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class EntityDeleteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EntityDeleteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EntityDeleteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EntitySetHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class EntitySetRequestEntityDOList(TeaModel):
    def __init__(
        self,
        entity_id: str = None,
        entity_type: str = None,
    ):
        self.entity_id = entity_id
        self.entity_type = entity_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_id is not None:
            result['entity_id'] = self.entity_id
        if self.entity_type is not None:
            result['entity_type'] = self.entity_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entity_id') is not None:
            self.entity_id = m.get('entity_id')
        if m.get('entity_type') is not None:
            self.entity_type = m.get('entity_type')
        return self


class EntitySetRequest(TeaModel):
    def __init__(
        self,
        entity_dolist: List[EntitySetRequestEntityDOList] = None,
        thirdpart_id: str = None,
    ):
        self.entity_dolist = entity_dolist
        self.thirdpart_id = thirdpart_id

    def validate(self):
        if self.entity_dolist:
            for k in self.entity_dolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['entity_d_o_list'] = []
        if self.entity_dolist is not None:
            for k in self.entity_dolist:
                result['entity_d_o_list'].append(k.to_map() if k else None)
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.entity_dolist = []
        if m.get('entity_d_o_list') is not None:
            for k in m.get('entity_d_o_list'):
                temp_model = EntitySetRequestEntityDOList()
                self.entity_dolist.append(temp_model.from_map(k))
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntitySetShrinkRequest(TeaModel):
    def __init__(
        self,
        entity_dolist_shrink: str = None,
        thirdpart_id: str = None,
    ):
        self.entity_dolist_shrink = entity_dolist_shrink
        self.thirdpart_id = thirdpart_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entity_dolist_shrink is not None:
            result['entity_d_o_list'] = self.entity_dolist_shrink
        if self.thirdpart_id is not None:
            result['thirdpart_id'] = self.thirdpart_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entity_d_o_list') is not None:
            self.entity_dolist_shrink = m.get('entity_d_o_list')
        if m.get('thirdpart_id') is not None:
            self.thirdpart_id = m.get('thirdpart_id')
        return self


class EntitySetResponseBodyModule(TeaModel):
    def __init__(
        self,
        add_num: int = None,
        remove_num: int = None,
        selected_user_num: int = None,
    ):
        self.add_num = add_num
        self.remove_num = remove_num
        self.selected_user_num = selected_user_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_num is not None:
            result['add_num'] = self.add_num
        if self.remove_num is not None:
            result['remove_num'] = self.remove_num
        if self.selected_user_num is not None:
            result['selected_user_num'] = self.selected_user_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('add_num') is not None:
            self.add_num = m.get('add_num')
        if m.get('remove_num') is not None:
            self.remove_num = m.get('remove_num')
        if m.get('selected_user_num') is not None:
            self.selected_user_num = m.get('selected_user_num')
        return self


class EntitySetResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: EntitySetResponseBodyModule = None,
        more_page: bool = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.more_page = more_page
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.more_page is not None:
            result['more_page'] = self.more_page
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = EntitySetResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('more_page') is not None:
            self.more_page = m.get('more_page')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class EntitySetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EntitySetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EntitySetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EstimatedPriceQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class EstimatedPriceQueryRequest(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        category: str = None,
        dep_city: str = None,
        end_time: int = None,
        itinerary_id: str = None,
        start_time: int = None,
        sub_corp_id: str = None,
        user_id: str = None,
    ):
        self.arr_city = arr_city
        self.category = category
        self.dep_city = dep_city
        self.end_time = end_time
        self.itinerary_id = itinerary_id
        self.start_time = start_time
        self.sub_corp_id = sub_corp_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.category is not None:
            result['category'] = self.category
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.sub_corp_id is not None:
            result['sub_corp_id'] = self.sub_corp_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('sub_corp_id') is not None:
            self.sub_corp_id = m.get('sub_corp_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class EstimatedPriceQueryResponseBodyModuleHotelFeeDetail(TeaModel):
    def __init__(
        self,
        city: str = None,
        criterion: int = None,
        itinerary_id: str = None,
        total: int = None,
        trip_days: int = None,
    ):
        self.city = city
        self.criterion = criterion
        self.itinerary_id = itinerary_id
        self.total = total
        self.trip_days = trip_days

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city is not None:
            result['city'] = self.city
        if self.criterion is not None:
            result['criterion'] = self.criterion
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.total is not None:
            result['total'] = self.total
        if self.trip_days is not None:
            result['trip_days'] = self.trip_days
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('city') is not None:
            self.city = m.get('city')
        if m.get('criterion') is not None:
            self.criterion = m.get('criterion')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('total') is not None:
            self.total = m.get('total')
        if m.get('trip_days') is not None:
            self.trip_days = m.get('trip_days')
        return self


class EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesCheapest(TeaModel):
    def __init__(
        self,
        arr_time: str = None,
        dep_time: str = None,
        fee: int = None,
        seat_grade: str = None,
        vehicle_no: str = None,
    ):
        self.arr_time = arr_time
        self.dep_time = dep_time
        self.fee = fee
        self.seat_grade = seat_grade
        self.vehicle_no = vehicle_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.fee is not None:
            result['fee'] = self.fee
        if self.seat_grade is not None:
            result['seat_grade'] = self.seat_grade
        if self.vehicle_no is not None:
            result['vehicle_no'] = self.vehicle_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        if m.get('seat_grade') is not None:
            self.seat_grade = m.get('seat_grade')
        if m.get('vehicle_no') is not None:
            self.vehicle_no = m.get('vehicle_no')
        return self


class EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesMostExpensive(TeaModel):
    def __init__(
        self,
        arr_time: str = None,
        dep_time: str = None,
        fee: int = None,
        seat_grade: str = None,
        vehicle_no: str = None,
    ):
        self.arr_time = arr_time
        self.dep_time = dep_time
        self.fee = fee
        self.seat_grade = seat_grade
        self.vehicle_no = vehicle_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.fee is not None:
            result['fee'] = self.fee
        if self.seat_grade is not None:
            result['seat_grade'] = self.seat_grade
        if self.vehicle_no is not None:
            result['vehicle_no'] = self.vehicle_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('fee') is not None:
            self.fee = m.get('fee')
        if m.get('seat_grade') is not None:
            self.seat_grade = m.get('seat_grade')
        if m.get('vehicle_no') is not None:
            self.vehicle_no = m.get('vehicle_no')
        return self


class EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutes(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_date: int = None,
        cheapest: EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesCheapest = None,
        dep_city: str = None,
        dep_date: int = None,
        err_msg: str = None,
        itinerary_id: str = None,
        most_expensive: EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesMostExpensive = None,
        success: bool = None,
    ):
        self.arr_city = arr_city
        self.arr_date = arr_date
        # cheapest
        self.cheapest = cheapest
        self.dep_city = dep_city
        self.dep_date = dep_date
        self.err_msg = err_msg
        self.itinerary_id = itinerary_id
        self.most_expensive = most_expensive
        self.success = success

    def validate(self):
        if self.cheapest:
            self.cheapest.validate()
        if self.most_expensive:
            self.most_expensive.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cheapest is not None:
            result['cheapest'] = self.cheapest.to_map()
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.err_msg is not None:
            result['err_msg'] = self.err_msg
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.most_expensive is not None:
            result['most_expensive'] = self.most_expensive.to_map()
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cheapest') is not None:
            temp_model = EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesCheapest()
            self.cheapest = temp_model.from_map(m['cheapest'])
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('err_msg') is not None:
            self.err_msg = m.get('err_msg')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('most_expensive') is not None:
            temp_model = EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutesMostExpensive()
            self.most_expensive = temp_model.from_map(m['most_expensive'])
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class EstimatedPriceQueryResponseBodyModuleTrafficFee(TeaModel):
    def __init__(
        self,
        btrip_routes: List[EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutes] = None,
        err_msg: str = None,
        max_fee: int = None,
        min_fee: int = None,
        success: bool = None,
    ):
        self.btrip_routes = btrip_routes
        self.err_msg = err_msg
        self.max_fee = max_fee
        self.min_fee = min_fee
        self.success = success

    def validate(self):
        if self.btrip_routes:
            for k in self.btrip_routes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['btrip_routes'] = []
        if self.btrip_routes is not None:
            for k in self.btrip_routes:
                result['btrip_routes'].append(k.to_map() if k else None)
        if self.err_msg is not None:
            result['err_msg'] = self.err_msg
        if self.max_fee is not None:
            result['max_fee'] = self.max_fee
        if self.min_fee is not None:
            result['min_fee'] = self.min_fee
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.btrip_routes = []
        if m.get('btrip_routes') is not None:
            for k in m.get('btrip_routes'):
                temp_model = EstimatedPriceQueryResponseBodyModuleTrafficFeeBtripRoutes()
                self.btrip_routes.append(temp_model.from_map(k))
        if m.get('err_msg') is not None:
            self.err_msg = m.get('err_msg')
        if m.get('max_fee') is not None:
            self.max_fee = m.get('max_fee')
        if m.get('min_fee') is not None:
            self.min_fee = m.get('min_fee')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class EstimatedPriceQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        hotel_fee_detail: List[EstimatedPriceQueryResponseBodyModuleHotelFeeDetail] = None,
        total_hotel_fee: int = None,
        traffic_fee: EstimatedPriceQueryResponseBodyModuleTrafficFee = None,
    ):
        self.hotel_fee_detail = hotel_fee_detail
        self.total_hotel_fee = total_hotel_fee
        self.traffic_fee = traffic_fee

    def validate(self):
        if self.hotel_fee_detail:
            for k in self.hotel_fee_detail:
                if k:
                    k.validate()
        if self.traffic_fee:
            self.traffic_fee.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['hotel_fee_detail'] = []
        if self.hotel_fee_detail is not None:
            for k in self.hotel_fee_detail:
                result['hotel_fee_detail'].append(k.to_map() if k else None)
        if self.total_hotel_fee is not None:
            result['total_hotel_fee'] = self.total_hotel_fee
        if self.traffic_fee is not None:
            result['traffic_fee'] = self.traffic_fee.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.hotel_fee_detail = []
        if m.get('hotel_fee_detail') is not None:
            for k in m.get('hotel_fee_detail'):
                temp_model = EstimatedPriceQueryResponseBodyModuleHotelFeeDetail()
                self.hotel_fee_detail.append(temp_model.from_map(k))
        if m.get('total_hotel_fee') is not None:
            self.total_hotel_fee = m.get('total_hotel_fee')
        if m.get('traffic_fee') is not None:
            temp_model = EstimatedPriceQueryResponseBodyModuleTrafficFee()
            self.traffic_fee = temp_model.from_map(m['traffic_fee'])
        return self


class EstimatedPriceQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        module: EstimatedPriceQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = EstimatedPriceQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class EstimatedPriceQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EstimatedPriceQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EstimatedPriceQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExceedApplySyncHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class ExceedApplySyncRequest(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        biz_category: int = None,
        remark: str = None,
        status: int = None,
        thirdparty_flow_id: str = None,
        user_id: str = None,
    ):
        self.apply_id = apply_id
        self.biz_category = biz_category
        self.remark = remark
        self.status = status
        self.thirdparty_flow_id = thirdparty_flow_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.biz_category is not None:
            result['biz_category'] = self.biz_category
        if self.remark is not None:
            result['remark'] = self.remark
        if self.status is not None:
            result['status'] = self.status
        if self.thirdparty_flow_id is not None:
            result['thirdparty_flow_id'] = self.thirdparty_flow_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('biz_category') is not None:
            self.biz_category = m.get('biz_category')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('thirdparty_flow_id') is not None:
            self.thirdparty_flow_id = m.get('thirdparty_flow_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class ExceedApplySyncResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: bool = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module。
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            self.module = m.get('module')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class ExceedApplySyncResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExceedApplySyncResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExceedApplySyncResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightBillSettlementQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class FlightBillSettlementQueryRequest(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        period_end: str = None,
        period_start: str = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.period_end = period_end
        self.period_start = period_start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        return self


class FlightBillSettlementQueryResponseBodyModuleDataList(TeaModel):
    def __init__(
        self,
        advance_day: int = None,
        airline_corp_code: str = None,
        airline_corp_name: str = None,
        alipay_trade_no: str = None,
        apply_id: str = None,
        arr_airport_code: str = None,
        arr_city: str = None,
        arr_date: str = None,
        arr_station: str = None,
        arr_time: str = None,
        bill_record_time: str = None,
        book_time: str = None,
        booker_id: str = None,
        booker_job_no: str = None,
        booker_name: str = None,
        btrip_coupon_fee: float = None,
        build_fee: float = None,
        cabin: str = None,
        cabin_class: str = None,
        capital_direction: str = None,
        cascade_department: str = None,
        change_fee: float = None,
        corp_pay_order_fee: float = None,
        cost_center: str = None,
        cost_center_number: str = None,
        coupon: float = None,
        dep_airport_code: str = None,
        department: str = None,
        department_id: str = None,
        dept_city: str = None,
        dept_date: str = None,
        dept_station: str = None,
        dept_time: str = None,
        discount: str = None,
        fee_type: str = None,
        flight_no: str = None,
        index: str = None,
        insurance_fee: float = None,
        invoice_title: str = None,
        itinerary_num: str = None,
        itinerary_price: float = None,
        most_difference_dept_time: str = None,
        most_difference_discount: str = None,
        most_difference_flight_no: str = None,
        most_difference_price: float = None,
        most_difference_reason: str = None,
        most_price: float = None,
        negotiation_coupon_fee: float = None,
        oil_fee: float = None,
        order_id: str = None,
        over_apply_id: str = None,
        primary_id: int = None,
        project_code: str = None,
        project_name: str = None,
        refund_fee: float = None,
        refund_upgrade_cost: float = None,
        remark: str = None,
        repeat_refund: str = None,
        seal_price: float = None,
        service_fee: float = None,
        settlement_fee: float = None,
        settlement_grant_fee: float = None,
        settlement_time: str = None,
        settlement_type: str = None,
        status: int = None,
        ticket_id: str = None,
        traveler_id: str = None,
        traveler_job_no: str = None,
        traveler_name: str = None,
        upgrade_cost: float = None,
        voucher_type: int = None,
    ):
        self.advance_day = advance_day
        self.airline_corp_code = airline_corp_code
        self.airline_corp_name = airline_corp_name
        self.alipay_trade_no = alipay_trade_no
        self.apply_id = apply_id
        self.arr_airport_code = arr_airport_code
        self.arr_city = arr_city
        self.arr_date = arr_date
        self.arr_station = arr_station
        self.arr_time = arr_time
        self.bill_record_time = bill_record_time
        self.book_time = book_time
        self.booker_id = booker_id
        self.booker_job_no = booker_job_no
        self.booker_name = booker_name
        self.btrip_coupon_fee = btrip_coupon_fee
        self.build_fee = build_fee
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.capital_direction = capital_direction
        self.cascade_department = cascade_department
        self.change_fee = change_fee
        self.corp_pay_order_fee = corp_pay_order_fee
        self.cost_center = cost_center
        self.cost_center_number = cost_center_number
        self.coupon = coupon
        self.dep_airport_code = dep_airport_code
        self.department = department
        self.department_id = department_id
        self.dept_city = dept_city
        self.dept_date = dept_date
        self.dept_station = dept_station
        self.dept_time = dept_time
        self.discount = discount
        self.fee_type = fee_type
        self.flight_no = flight_no
        self.index = index
        self.insurance_fee = insurance_fee
        self.invoice_title = invoice_title
        self.itinerary_num = itinerary_num
        self.itinerary_price = itinerary_price
        self.most_difference_dept_time = most_difference_dept_time
        self.most_difference_discount = most_difference_discount
        self.most_difference_flight_no = most_difference_flight_no
        self.most_difference_price = most_difference_price
        self.most_difference_reason = most_difference_reason
        self.most_price = most_price
        self.negotiation_coupon_fee = negotiation_coupon_fee
        self.oil_fee = oil_fee
        self.order_id = order_id
        self.over_apply_id = over_apply_id
        self.primary_id = primary_id
        self.project_code = project_code
        self.project_name = project_name
        self.refund_fee = refund_fee
        self.refund_upgrade_cost = refund_upgrade_cost
        self.remark = remark
        self.repeat_refund = repeat_refund
        self.seal_price = seal_price
        self.service_fee = service_fee
        self.settlement_fee = settlement_fee
        self.settlement_grant_fee = settlement_grant_fee
        self.settlement_time = settlement_time
        self.settlement_type = settlement_type
        self.status = status
        self.ticket_id = ticket_id
        self.traveler_id = traveler_id
        self.traveler_job_no = traveler_job_no
        self.traveler_name = traveler_name
        self.upgrade_cost = upgrade_cost
        self.voucher_type = voucher_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advance_day is not None:
            result['advance_day'] = self.advance_day
        if self.airline_corp_code is not None:
            result['airline_corp_code'] = self.airline_corp_code
        if self.airline_corp_name is not None:
            result['airline_corp_name'] = self.airline_corp_name
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.arr_station is not None:
            result['arr_station'] = self.arr_station
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.bill_record_time is not None:
            result['bill_record_time'] = self.bill_record_time
        if self.book_time is not None:
            result['book_time'] = self.book_time
        if self.booker_id is not None:
            result['booker_id'] = self.booker_id
        if self.booker_job_no is not None:
            result['booker_job_no'] = self.booker_job_no
        if self.booker_name is not None:
            result['booker_name'] = self.booker_name
        if self.btrip_coupon_fee is not None:
            result['btrip_coupon_fee'] = self.btrip_coupon_fee
        if self.build_fee is not None:
            result['build_fee'] = self.build_fee
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.capital_direction is not None:
            result['capital_direction'] = self.capital_direction
        if self.cascade_department is not None:
            result['cascade_department'] = self.cascade_department
        if self.change_fee is not None:
            result['change_fee'] = self.change_fee
        if self.corp_pay_order_fee is not None:
            result['corp_pay_order_fee'] = self.corp_pay_order_fee
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.coupon is not None:
            result['coupon'] = self.coupon
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.department is not None:
            result['department'] = self.department
        if self.department_id is not None:
            result['department_id'] = self.department_id
        if self.dept_city is not None:
            result['dept_city'] = self.dept_city
        if self.dept_date is not None:
            result['dept_date'] = self.dept_date
        if self.dept_station is not None:
            result['dept_station'] = self.dept_station
        if self.dept_time is not None:
            result['dept_time'] = self.dept_time
        if self.discount is not None:
            result['discount'] = self.discount
        if self.fee_type is not None:
            result['fee_type'] = self.fee_type
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.index is not None:
            result['index'] = self.index
        if self.insurance_fee is not None:
            result['insurance_fee'] = self.insurance_fee
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.itinerary_num is not None:
            result['itinerary_num'] = self.itinerary_num
        if self.itinerary_price is not None:
            result['itinerary_price'] = self.itinerary_price
        if self.most_difference_dept_time is not None:
            result['most_difference_dept_time'] = self.most_difference_dept_time
        if self.most_difference_discount is not None:
            result['most_difference_discount'] = self.most_difference_discount
        if self.most_difference_flight_no is not None:
            result['most_difference_flight_no'] = self.most_difference_flight_no
        if self.most_difference_price is not None:
            result['most_difference_price'] = self.most_difference_price
        if self.most_difference_reason is not None:
            result['most_difference_reason'] = self.most_difference_reason
        if self.most_price is not None:
            result['most_price'] = self.most_price
        if self.negotiation_coupon_fee is not None:
            result['negotiation_coupon_fee'] = self.negotiation_coupon_fee
        if self.oil_fee is not None:
            result['oil_fee'] = self.oil_fee
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.over_apply_id is not None:
            result['over_apply_id'] = self.over_apply_id
        if self.primary_id is not None:
            result['primary_id'] = self.primary_id
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_name is not None:
            result['project_name'] = self.project_name
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        if self.refund_upgrade_cost is not None:
            result['refund_upgrade_cost'] = self.refund_upgrade_cost
        if self.remark is not None:
            result['remark'] = self.remark
        if self.repeat_refund is not None:
            result['repeat_refund'] = self.repeat_refund
        if self.seal_price is not None:
            result['seal_price'] = self.seal_price
        if self.service_fee is not None:
            result['service_fee'] = self.service_fee
        if self.settlement_fee is not None:
            result['settlement_fee'] = self.settlement_fee
        if self.settlement_grant_fee is not None:
            result['settlement_grant_fee'] = self.settlement_grant_fee
        if self.settlement_time is not None:
            result['settlement_time'] = self.settlement_time
        if self.settlement_type is not None:
            result['settlement_type'] = self.settlement_type
        if self.status is not None:
            result['status'] = self.status
        if self.ticket_id is not None:
            result['ticket_id'] = self.ticket_id
        if self.traveler_id is not None:
            result['traveler_id'] = self.traveler_id
        if self.traveler_job_no is not None:
            result['traveler_job_no'] = self.traveler_job_no
        if self.traveler_name is not None:
            result['traveler_name'] = self.traveler_name
        if self.upgrade_cost is not None:
            result['upgrade_cost'] = self.upgrade_cost
        if self.voucher_type is not None:
            result['voucher_type'] = self.voucher_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('advance_day') is not None:
            self.advance_day = m.get('advance_day')
        if m.get('airline_corp_code') is not None:
            self.airline_corp_code = m.get('airline_corp_code')
        if m.get('airline_corp_name') is not None:
            self.airline_corp_name = m.get('airline_corp_name')
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('arr_station') is not None:
            self.arr_station = m.get('arr_station')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('bill_record_time') is not None:
            self.bill_record_time = m.get('bill_record_time')
        if m.get('book_time') is not None:
            self.book_time = m.get('book_time')
        if m.get('booker_id') is not None:
            self.booker_id = m.get('booker_id')
        if m.get('booker_job_no') is not None:
            self.booker_job_no = m.get('booker_job_no')
        if m.get('booker_name') is not None:
            self.booker_name = m.get('booker_name')
        if m.get('btrip_coupon_fee') is not None:
            self.btrip_coupon_fee = m.get('btrip_coupon_fee')
        if m.get('build_fee') is not None:
            self.build_fee = m.get('build_fee')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('capital_direction') is not None:
            self.capital_direction = m.get('capital_direction')
        if m.get('cascade_department') is not None:
            self.cascade_department = m.get('cascade_department')
        if m.get('change_fee') is not None:
            self.change_fee = m.get('change_fee')
        if m.get('corp_pay_order_fee') is not None:
            self.corp_pay_order_fee = m.get('corp_pay_order_fee')
        if m.get('cost_center') is not None:
            self.cost_center = m.get('cost_center')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('coupon') is not None:
            self.coupon = m.get('coupon')
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('department') is not None:
            self.department = m.get('department')
        if m.get('department_id') is not None:
            self.department_id = m.get('department_id')
        if m.get('dept_city') is not None:
            self.dept_city = m.get('dept_city')
        if m.get('dept_date') is not None:
            self.dept_date = m.get('dept_date')
        if m.get('dept_station') is not None:
            self.dept_station = m.get('dept_station')
        if m.get('dept_time') is not None:
            self.dept_time = m.get('dept_time')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('fee_type') is not None:
            self.fee_type = m.get('fee_type')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('insurance_fee') is not None:
            self.insurance_fee = m.get('insurance_fee')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('itinerary_num') is not None:
            self.itinerary_num = m.get('itinerary_num')
        if m.get('itinerary_price') is not None:
            self.itinerary_price = m.get('itinerary_price')
        if m.get('most_difference_dept_time') is not None:
            self.most_difference_dept_time = m.get('most_difference_dept_time')
        if m.get('most_difference_discount') is not None:
            self.most_difference_discount = m.get('most_difference_discount')
        if m.get('most_difference_flight_no') is not None:
            self.most_difference_flight_no = m.get('most_difference_flight_no')
        if m.get('most_difference_price') is not None:
            self.most_difference_price = m.get('most_difference_price')
        if m.get('most_difference_reason') is not None:
            self.most_difference_reason = m.get('most_difference_reason')
        if m.get('most_price') is not None:
            self.most_price = m.get('most_price')
        if m.get('negotiation_coupon_fee') is not None:
            self.negotiation_coupon_fee = m.get('negotiation_coupon_fee')
        if m.get('oil_fee') is not None:
            self.oil_fee = m.get('oil_fee')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('over_apply_id') is not None:
            self.over_apply_id = m.get('over_apply_id')
        if m.get('primary_id') is not None:
            self.primary_id = m.get('primary_id')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_name') is not None:
            self.project_name = m.get('project_name')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        if m.get('refund_upgrade_cost') is not None:
            self.refund_upgrade_cost = m.get('refund_upgrade_cost')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('repeat_refund') is not None:
            self.repeat_refund = m.get('repeat_refund')
        if m.get('seal_price') is not None:
            self.seal_price = m.get('seal_price')
        if m.get('service_fee') is not None:
            self.service_fee = m.get('service_fee')
        if m.get('settlement_fee') is not None:
            self.settlement_fee = m.get('settlement_fee')
        if m.get('settlement_grant_fee') is not None:
            self.settlement_grant_fee = m.get('settlement_grant_fee')
        if m.get('settlement_time') is not None:
            self.settlement_time = m.get('settlement_time')
        if m.get('settlement_type') is not None:
            self.settlement_type = m.get('settlement_type')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('ticket_id') is not None:
            self.ticket_id = m.get('ticket_id')
        if m.get('traveler_id') is not None:
            self.traveler_id = m.get('traveler_id')
        if m.get('traveler_job_no') is not None:
            self.traveler_job_no = m.get('traveler_job_no')
        if m.get('traveler_name') is not None:
            self.traveler_name = m.get('traveler_name')
        if m.get('upgrade_cost') is not None:
            self.upgrade_cost = m.get('upgrade_cost')
        if m.get('voucher_type') is not None:
            self.voucher_type = m.get('voucher_type')
        return self


class FlightBillSettlementQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        category: int = None,
        corp_id: str = None,
        data_list: List[FlightBillSettlementQueryResponseBodyModuleDataList] = None,
        period_end: str = None,
        period_start: str = None,
        total_num: int = None,
    ):
        self.category = category
        self.corp_id = corp_id
        self.data_list = data_list
        self.period_end = period_end
        self.period_start = period_start
        self.total_num = total_num

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['category'] = self.category
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        result['data_list'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['data_list'].append(k.to_map() if k else None)
        if self.period_end is not None:
            result['period_end'] = self.period_end
        if self.period_start is not None:
            result['period_start'] = self.period_start
        if self.total_num is not None:
            result['total_num'] = self.total_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category') is not None:
            self.category = m.get('category')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        self.data_list = []
        if m.get('data_list') is not None:
            for k in m.get('data_list'):
                temp_model = FlightBillSettlementQueryResponseBodyModuleDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('period_end') is not None:
            self.period_end = m.get('period_end')
        if m.get('period_start') is not None:
            self.period_start = m.get('period_start')
        if m.get('total_num') is not None:
            self.total_num = m.get('total_num')
        return self


class FlightBillSettlementQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightBillSettlementQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightBillSettlementQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightBillSettlementQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightBillSettlementQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightBillSettlementQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightCancelOrderHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightCancelOrderRequest(TeaModel):
    def __init__(
        self,
        dis_order_id: str = None,
    ):
        self.dis_order_id = dis_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        return self


class FlightCancelOrderResponseBodyModule(TeaModel):
    def __init__(
        self,
        cancel_time: str = None,
        fail_code: str = None,
        fail_reason: str = None,
        order_status: str = None,
    ):
        self.cancel_time = cancel_time
        self.fail_code = fail_code
        self.fail_reason = fail_reason
        self.order_status = order_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cancel_time is not None:
            result['cancel_time'] = self.cancel_time
        if self.fail_code is not None:
            result['fail_code'] = self.fail_code
        if self.fail_reason is not None:
            result['fail_reason'] = self.fail_reason
        if self.order_status is not None:
            result['order_status'] = self.order_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cancel_time') is not None:
            self.cancel_time = m.get('cancel_time')
        if m.get('fail_code') is not None:
            self.fail_code = m.get('fail_code')
        if m.get('fail_reason') is not None:
            self.fail_reason = m.get('fail_reason')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        return self


class FlightCancelOrderResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightCancelOrderResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightCancelOrderResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightCancelOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightCancelOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightCancelOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightCreateOrderHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightCreateOrderRequestContactInfo(TeaModel):
    def __init__(
        self,
        contact_email: str = None,
        contact_name: str = None,
        contact_phone: str = None,
    ):
        self.contact_email = contact_email
        self.contact_name = contact_name
        self.contact_phone = contact_phone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contact_email is not None:
            result['contact_email'] = self.contact_email
        if self.contact_name is not None:
            result['contact_name'] = self.contact_name
        if self.contact_phone is not None:
            result['contact_phone'] = self.contact_phone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('contact_email') is not None:
            self.contact_email = m.get('contact_email')
        if m.get('contact_name') is not None:
            self.contact_name = m.get('contact_name')
        if m.get('contact_phone') is not None:
            self.contact_phone = m.get('contact_phone')
        return self


class FlightCreateOrderRequestTravelerInfoList(TeaModel):
    def __init__(
        self,
        birthday: str = None,
        cert_nation: str = None,
        cert_no: str = None,
        cert_type: str = None,
        cert_valid_date: str = None,
        name: str = None,
        nationality: str = None,
        nationality_code: str = None,
        out_user_id: str = None,
        phone: str = None,
        sex: int = None,
        type: str = None,
    ):
        self.birthday = birthday
        self.cert_nation = cert_nation
        self.cert_no = cert_no
        self.cert_type = cert_type
        self.cert_valid_date = cert_valid_date
        self.name = name
        self.nationality = nationality
        self.nationality_code = nationality_code
        self.out_user_id = out_user_id
        self.phone = phone
        self.sex = sex
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.birthday is not None:
            result['birthday'] = self.birthday
        if self.cert_nation is not None:
            result['cert_nation'] = self.cert_nation
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        if self.cert_valid_date is not None:
            result['cert_valid_date'] = self.cert_valid_date
        if self.name is not None:
            result['name'] = self.name
        if self.nationality is not None:
            result['nationality'] = self.nationality
        if self.nationality_code is not None:
            result['nationality_code'] = self.nationality_code
        if self.out_user_id is not None:
            result['out_user_id'] = self.out_user_id
        if self.phone is not None:
            result['phone'] = self.phone
        if self.sex is not None:
            result['sex'] = self.sex
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('birthday') is not None:
            self.birthday = m.get('birthday')
        if m.get('cert_nation') is not None:
            self.cert_nation = m.get('cert_nation')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        if m.get('cert_valid_date') is not None:
            self.cert_valid_date = m.get('cert_valid_date')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nationality') is not None:
            self.nationality = m.get('nationality')
        if m.get('nationality_code') is not None:
            self.nationality_code = m.get('nationality_code')
        if m.get('out_user_id') is not None:
            self.out_user_id = m.get('out_user_id')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('sex') is not None:
            self.sex = m.get('sex')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightCreateOrderRequest(TeaModel):
    def __init__(
        self,
        arr_airport_code: str = None,
        arr_city_code: str = None,
        auto_pay: int = None,
        buyer_name: str = None,
        buyer_unique_key: str = None,
        contact_info: FlightCreateOrderRequestContactInfo = None,
        dep_airport_code: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
        dis_order_id: str = None,
        order_attr: Dict[str, Any] = None,
        order_params: str = None,
        ota_item_id: str = None,
        price: int = None,
        receipt_address: str = None,
        receipt_target: int = None,
        receipt_title: str = None,
        traveler_info_list: List[FlightCreateOrderRequestTravelerInfoList] = None,
        trip_type: int = None,
    ):
        self.arr_airport_code = arr_airport_code
        self.arr_city_code = arr_city_code
        self.auto_pay = auto_pay
        self.buyer_name = buyer_name
        self.buyer_unique_key = buyer_unique_key
        self.contact_info = contact_info
        self.dep_airport_code = dep_airport_code
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date
        self.dis_order_id = dis_order_id
        self.order_attr = order_attr
        self.order_params = order_params
        self.ota_item_id = ota_item_id
        self.price = price
        self.receipt_address = receipt_address
        self.receipt_target = receipt_target
        self.receipt_title = receipt_title
        self.traveler_info_list = traveler_info_list
        self.trip_type = trip_type

    def validate(self):
        if self.contact_info:
            self.contact_info.validate()
        if self.traveler_info_list:
            for k in self.traveler_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.auto_pay is not None:
            result['auto_pay'] = self.auto_pay
        if self.buyer_name is not None:
            result['buyer_name'] = self.buyer_name
        if self.buyer_unique_key is not None:
            result['buyer_unique_key'] = self.buyer_unique_key
        if self.contact_info is not None:
            result['contact_info'] = self.contact_info.to_map()
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.order_attr is not None:
            result['order_attr'] = self.order_attr
        if self.order_params is not None:
            result['order_params'] = self.order_params
        if self.ota_item_id is not None:
            result['ota_item_id'] = self.ota_item_id
        if self.price is not None:
            result['price'] = self.price
        if self.receipt_address is not None:
            result['receipt_address'] = self.receipt_address
        if self.receipt_target is not None:
            result['receipt_target'] = self.receipt_target
        if self.receipt_title is not None:
            result['receipt_title'] = self.receipt_title
        result['traveler_info_list'] = []
        if self.traveler_info_list is not None:
            for k in self.traveler_info_list:
                result['traveler_info_list'].append(k.to_map() if k else None)
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('auto_pay') is not None:
            self.auto_pay = m.get('auto_pay')
        if m.get('buyer_name') is not None:
            self.buyer_name = m.get('buyer_name')
        if m.get('buyer_unique_key') is not None:
            self.buyer_unique_key = m.get('buyer_unique_key')
        if m.get('contact_info') is not None:
            temp_model = FlightCreateOrderRequestContactInfo()
            self.contact_info = temp_model.from_map(m['contact_info'])
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('order_attr') is not None:
            self.order_attr = m.get('order_attr')
        if m.get('order_params') is not None:
            self.order_params = m.get('order_params')
        if m.get('ota_item_id') is not None:
            self.ota_item_id = m.get('ota_item_id')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('receipt_address') is not None:
            self.receipt_address = m.get('receipt_address')
        if m.get('receipt_target') is not None:
            self.receipt_target = m.get('receipt_target')
        if m.get('receipt_title') is not None:
            self.receipt_title = m.get('receipt_title')
        self.traveler_info_list = []
        if m.get('traveler_info_list') is not None:
            for k in m.get('traveler_info_list'):
                temp_model = FlightCreateOrderRequestTravelerInfoList()
                self.traveler_info_list.append(temp_model.from_map(k))
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        return self


class FlightCreateOrderShrinkRequest(TeaModel):
    def __init__(
        self,
        arr_airport_code: str = None,
        arr_city_code: str = None,
        auto_pay: int = None,
        buyer_name: str = None,
        buyer_unique_key: str = None,
        contact_info_shrink: str = None,
        dep_airport_code: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
        dis_order_id: str = None,
        order_attr_shrink: str = None,
        order_params: str = None,
        ota_item_id: str = None,
        price: int = None,
        receipt_address: str = None,
        receipt_target: int = None,
        receipt_title: str = None,
        traveler_info_list_shrink: str = None,
        trip_type: int = None,
    ):
        self.arr_airport_code = arr_airport_code
        self.arr_city_code = arr_city_code
        self.auto_pay = auto_pay
        self.buyer_name = buyer_name
        self.buyer_unique_key = buyer_unique_key
        self.contact_info_shrink = contact_info_shrink
        self.dep_airport_code = dep_airport_code
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date
        self.dis_order_id = dis_order_id
        self.order_attr_shrink = order_attr_shrink
        self.order_params = order_params
        self.ota_item_id = ota_item_id
        self.price = price
        self.receipt_address = receipt_address
        self.receipt_target = receipt_target
        self.receipt_title = receipt_title
        self.traveler_info_list_shrink = traveler_info_list_shrink
        self.trip_type = trip_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.auto_pay is not None:
            result['auto_pay'] = self.auto_pay
        if self.buyer_name is not None:
            result['buyer_name'] = self.buyer_name
        if self.buyer_unique_key is not None:
            result['buyer_unique_key'] = self.buyer_unique_key
        if self.contact_info_shrink is not None:
            result['contact_info'] = self.contact_info_shrink
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.order_attr_shrink is not None:
            result['order_attr'] = self.order_attr_shrink
        if self.order_params is not None:
            result['order_params'] = self.order_params
        if self.ota_item_id is not None:
            result['ota_item_id'] = self.ota_item_id
        if self.price is not None:
            result['price'] = self.price
        if self.receipt_address is not None:
            result['receipt_address'] = self.receipt_address
        if self.receipt_target is not None:
            result['receipt_target'] = self.receipt_target
        if self.receipt_title is not None:
            result['receipt_title'] = self.receipt_title
        if self.traveler_info_list_shrink is not None:
            result['traveler_info_list'] = self.traveler_info_list_shrink
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('auto_pay') is not None:
            self.auto_pay = m.get('auto_pay')
        if m.get('buyer_name') is not None:
            self.buyer_name = m.get('buyer_name')
        if m.get('buyer_unique_key') is not None:
            self.buyer_unique_key = m.get('buyer_unique_key')
        if m.get('contact_info') is not None:
            self.contact_info_shrink = m.get('contact_info')
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('order_attr') is not None:
            self.order_attr_shrink = m.get('order_attr')
        if m.get('order_params') is not None:
            self.order_params = m.get('order_params')
        if m.get('ota_item_id') is not None:
            self.ota_item_id = m.get('ota_item_id')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('receipt_address') is not None:
            self.receipt_address = m.get('receipt_address')
        if m.get('receipt_target') is not None:
            self.receipt_target = m.get('receipt_target')
        if m.get('receipt_title') is not None:
            self.receipt_title = m.get('receipt_title')
        if m.get('traveler_info_list') is not None:
            self.traveler_info_list_shrink = m.get('traveler_info_list')
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        return self


class FlightCreateOrderResponseBodyModule(TeaModel):
    def __init__(
        self,
        alipay_trade_no: str = None,
        btrip_order_id: int = None,
        dis_order_id: str = None,
        last_pay_time: str = None,
        order_status: int = None,
        pay_status: int = None,
        payment_price: int = None,
        total_price: int = None,
    ):
        self.alipay_trade_no = alipay_trade_no
        self.btrip_order_id = btrip_order_id
        self.dis_order_id = dis_order_id
        self.last_pay_time = last_pay_time
        self.order_status = order_status
        self.pay_status = pay_status
        self.payment_price = payment_price
        self.total_price = total_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.btrip_order_id is not None:
            result['btrip_order_id'] = self.btrip_order_id
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.last_pay_time is not None:
            result['last_pay_time'] = self.last_pay_time
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.pay_status is not None:
            result['pay_status'] = self.pay_status
        if self.payment_price is not None:
            result['payment_price'] = self.payment_price
        if self.total_price is not None:
            result['total_price'] = self.total_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('btrip_order_id') is not None:
            self.btrip_order_id = m.get('btrip_order_id')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('last_pay_time') is not None:
            self.last_pay_time = m.get('last_pay_time')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('pay_status') is not None:
            self.pay_status = m.get('pay_status')
        if m.get('payment_price') is not None:
            self.payment_price = m.get('payment_price')
        if m.get('total_price') is not None:
            self.total_price = m.get('total_price')
        return self


class FlightCreateOrderResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightCreateOrderResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightCreateOrderResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightCreateOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightCreateOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightCreateOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightExceedApplyQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class FlightExceedApplyQueryRequest(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
    ):
        self.apply_id = apply_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        return self


class FlightExceedApplyQueryResponseBodyModuleApplyIntentionInfoDo(TeaModel):
    def __init__(
        self,
        arr_city: str = None,
        arr_city_name: str = None,
        arr_time: str = None,
        cabin: str = None,
        cabin_class: int = None,
        cabin_class_str: str = None,
        dep_city: str = None,
        dep_city_name: str = None,
        dep_time: str = None,
        discount: str = None,
        flight_no: str = None,
        price: int = None,
        type: int = None,
    ):
        self.arr_city = arr_city
        self.arr_city_name = arr_city_name
        self.arr_time = arr_time
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_str = cabin_class_str
        self.dep_city = dep_city
        self.dep_city_name = dep_city_name
        self.dep_time = dep_time
        self.discount = discount
        self.flight_no = flight_no
        self.price = price
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_name is not None:
            result['arr_city_name'] = self.arr_city_name
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_str is not None:
            result['cabin_class_str'] = self.cabin_class_str
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_name is not None:
            result['dep_city_name'] = self.dep_city_name
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.discount is not None:
            result['discount'] = self.discount
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.price is not None:
            result['price'] = self.price
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_name') is not None:
            self.arr_city_name = m.get('arr_city_name')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_str') is not None:
            self.cabin_class_str = m.get('cabin_class_str')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_name') is not None:
            self.dep_city_name = m.get('dep_city_name')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightExceedApplyQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        apply_intention_info_do: FlightExceedApplyQueryResponseBodyModuleApplyIntentionInfoDo = None,
        btrip_cause: str = None,
        corp_id: str = None,
        exceed_reason: str = None,
        exceed_type: int = None,
        origin_standard: str = None,
        status: int = None,
        submit_time: str = None,
        thirdpart_apply_id: str = None,
        thirdpart_corp_id: str = None,
        user_id: str = None,
    ):
        self.apply_id = apply_id
        self.apply_intention_info_do = apply_intention_info_do
        self.btrip_cause = btrip_cause
        self.corp_id = corp_id
        self.exceed_reason = exceed_reason
        self.exceed_type = exceed_type
        self.origin_standard = origin_standard
        self.status = status
        self.submit_time = submit_time
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_corp_id = thirdpart_corp_id
        self.user_id = user_id

    def validate(self):
        if self.apply_intention_info_do:
            self.apply_intention_info_do.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.apply_intention_info_do is not None:
            result['apply_intention_info_do'] = self.apply_intention_info_do.to_map()
        if self.btrip_cause is not None:
            result['btrip_cause'] = self.btrip_cause
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.exceed_reason is not None:
            result['exceed_reason'] = self.exceed_reason
        if self.exceed_type is not None:
            result['exceed_type'] = self.exceed_type
        if self.origin_standard is not None:
            result['origin_standard'] = self.origin_standard
        if self.status is not None:
            result['status'] = self.status
        if self.submit_time is not None:
            result['submit_time'] = self.submit_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_corp_id is not None:
            result['thirdpart_corp_id'] = self.thirdpart_corp_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('apply_intention_info_do') is not None:
            temp_model = FlightExceedApplyQueryResponseBodyModuleApplyIntentionInfoDo()
            self.apply_intention_info_do = temp_model.from_map(m['apply_intention_info_do'])
        if m.get('btrip_cause') is not None:
            self.btrip_cause = m.get('btrip_cause')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('exceed_reason') is not None:
            self.exceed_reason = m.get('exceed_reason')
        if m.get('exceed_type') is not None:
            self.exceed_type = m.get('exceed_type')
        if m.get('origin_standard') is not None:
            self.origin_standard = m.get('origin_standard')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('submit_time') is not None:
            self.submit_time = m.get('submit_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_corp_id') is not None:
            self.thirdpart_corp_id = m.get('thirdpart_corp_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightExceedApplyQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightExceedApplyQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightExceedApplyQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightExceedApplyQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightExceedApplyQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightExceedApplyQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightItineraryScanQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class FlightItineraryScanQueryRequest(TeaModel):
    def __init__(
        self,
        bill_date: str = None,
        bill_id: int = None,
        invoice_sub_task_id: int = None,
        page_no: int = None,
        page_size: int = None,
    ):
        self.bill_date = bill_date
        self.bill_id = bill_id
        self.invoice_sub_task_id = invoice_sub_task_id
        self.page_no = page_no
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_date is not None:
            result['bill_date'] = self.bill_date
        if self.bill_id is not None:
            result['bill_id'] = self.bill_id
        if self.invoice_sub_task_id is not None:
            result['invoice_sub_task_id'] = self.invoice_sub_task_id
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bill_date') is not None:
            self.bill_date = m.get('bill_date')
        if m.get('bill_id') is not None:
            self.bill_id = m.get('bill_id')
        if m.get('invoice_sub_task_id') is not None:
            self.invoice_sub_task_id = m.get('invoice_sub_task_id')
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        return self


class FlightItineraryScanQueryResponseBodyModuleItems(TeaModel):
    def __init__(
        self,
        bill_date: str = None,
        build: str = None,
        cost_center: str = None,
        department: str = None,
        fuel_surcharge: str = None,
        insurance: str = None,
        invoice_title: str = None,
        itinerary_num: str = None,
        order_id: int = None,
        oss_url: str = None,
        passenger_name: str = None,
        project: str = None,
        tax_amount: str = None,
        tax_rate: str = None,
        ticket_no: str = None,
        ticket_price: str = None,
        total_price: str = None,
    ):
        self.bill_date = bill_date
        self.build = build
        self.cost_center = cost_center
        self.department = department
        self.fuel_surcharge = fuel_surcharge
        self.insurance = insurance
        self.invoice_title = invoice_title
        self.itinerary_num = itinerary_num
        self.order_id = order_id
        self.oss_url = oss_url
        self.passenger_name = passenger_name
        self.project = project
        self.tax_amount = tax_amount
        self.tax_rate = tax_rate
        self.ticket_no = ticket_no
        self.ticket_price = ticket_price
        self.total_price = total_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_date is not None:
            result['bill_date'] = self.bill_date
        if self.build is not None:
            result['build'] = self.build
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center
        if self.department is not None:
            result['department'] = self.department
        if self.fuel_surcharge is not None:
            result['fuel_surcharge'] = self.fuel_surcharge
        if self.insurance is not None:
            result['insurance'] = self.insurance
        if self.invoice_title is not None:
            result['invoice_title'] = self.invoice_title
        if self.itinerary_num is not None:
            result['itinerary_num'] = self.itinerary_num
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.oss_url is not None:
            result['oss_url'] = self.oss_url
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.project is not None:
            result['project'] = self.project
        if self.tax_amount is not None:
            result['tax_amount'] = self.tax_amount
        if self.tax_rate is not None:
            result['tax_rate'] = self.tax_rate
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.total_price is not None:
            result['total_price'] = self.total_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bill_date') is not None:
            self.bill_date = m.get('bill_date')
        if m.get('build') is not None:
            self.build = m.get('build')
        if m.get('cost_center') is not None:
            self.cost_center = m.get('cost_center')
        if m.get('department') is not None:
            self.department = m.get('department')
        if m.get('fuel_surcharge') is not None:
            self.fuel_surcharge = m.get('fuel_surcharge')
        if m.get('insurance') is not None:
            self.insurance = m.get('insurance')
        if m.get('invoice_title') is not None:
            self.invoice_title = m.get('invoice_title')
        if m.get('itinerary_num') is not None:
            self.itinerary_num = m.get('itinerary_num')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('oss_url') is not None:
            self.oss_url = m.get('oss_url')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('project') is not None:
            self.project = m.get('project')
        if m.get('tax_amount') is not None:
            self.tax_amount = m.get('tax_amount')
        if m.get('tax_rate') is not None:
            self.tax_rate = m.get('tax_rate')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('total_price') is not None:
            self.total_price = m.get('total_price')
        return self


class FlightItineraryScanQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        items: List[FlightItineraryScanQueryResponseBodyModuleItems] = None,
        page_no: int = None,
        page_size: int = None,
        total_page: int = None,
        total_size: int = None,
    ):
        self.items = items
        self.page_no = page_no
        self.page_size = page_size
        self.total_page = total_page
        self.total_size = total_size

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['page_no'] = self.page_no
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_page is not None:
            result['total_page'] = self.total_page
        if self.total_size is not None:
            result['total_size'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = FlightItineraryScanQueryResponseBodyModuleItems()
                self.items.append(temp_model.from_map(k))
        if m.get('page_no') is not None:
            self.page_no = m.get('page_no')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_page') is not None:
            self.total_page = m.get('total_page')
        if m.get('total_size') is not None:
            self.total_size = m.get('total_size')
        return self


class FlightItineraryScanQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightItineraryScanQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        # requestId
        self.request_id = request_id
        self.success = success
        # traceId
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightItineraryScanQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightItineraryScanQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightItineraryScanQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightItineraryScanQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightListingSearchHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightListingSearchRequest(TeaModel):
    def __init__(
        self,
        airline_code: str = None,
        arr_city_code: str = None,
        cabin_class: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
    ):
        self.airline_code = airline_code
        self.arr_city_code = arr_city_code
        self.cabin_class = cabin_class
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        return self


class FlightListingSearchResponseBodyModuleFlightListAirlineInfo(TeaModel):
    def __init__(
        self,
        airline_code: str = None,
        airline_name: str = None,
        airline_simple_name: str = None,
    ):
        self.airline_code = airline_code
        self.airline_name = airline_name
        self.airline_simple_name = airline_simple_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.airline_name is not None:
            result['airline_name'] = self.airline_name
        if self.airline_simple_name is not None:
            result['airline_simple_name'] = self.airline_simple_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('airline_name') is not None:
            self.airline_name = m.get('airline_name')
        if m.get('airline_simple_name') is not None:
            self.airline_simple_name = m.get('airline_simple_name')
        return self


class FlightListingSearchResponseBodyModuleFlightListArrAirportInfo(TeaModel):
    def __init__(
        self,
        airport_code: str = None,
        airport_name: str = None,
        city_code: str = None,
        city_name: str = None,
        terminal: str = None,
    ):
        self.airport_code = airport_code
        self.airport_name = airport_name
        self.city_code = city_code
        self.city_name = city_name
        self.terminal = terminal

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightListingSearchResponseBodyModuleFlightListDepAirportInfo(TeaModel):
    def __init__(
        self,
        airport_code: str = None,
        airport_name: str = None,
        city_code: str = None,
        city_name: str = None,
        terminal: str = None,
    ):
        self.airport_code = airport_code
        self.airport_name = airport_name
        self.city_code = city_code
        self.city_name = city_name
        self.terminal = terminal

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription(TeaModel):
    def __init__(
        self,
        desc: str = None,
        icon: str = None,
        image: str = None,
        title: str = None,
    ):
        self.desc = desc
        self.icon = icon
        self.image = image
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['desc'] = self.desc
        if self.icon is not None:
            result['icon'] = self.icon
        if self.image is not None:
            result['image'] = self.image
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO(TeaModel):
    def __init__(
        self,
        image: str = None,
        largest: str = None,
        middle: str = None,
        smallest: str = None,
    ):
        self.image = image
        self.largest = largest
        self.middle = middle
        self.smallest = smallest

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image is not None:
            result['image'] = self.image
        if self.largest is not None:
            result['largest'] = self.largest
        if self.middle is not None:
            result['middle'] = self.middle
        if self.smallest is not None:
            result['smallest'] = self.smallest
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('largest') is not None:
            self.largest = m.get('largest')
        if m.get('middle') is not None:
            self.middle = m.get('middle')
        if m.get('smallest') is not None:
            self.smallest = m.get('smallest')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes(TeaModel):
    def __init__(
        self,
        baggage_desc: List[str] = None,
        baggage_sub_content_type: int = None,
        description: FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription = None,
        image_do: FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO = None,
        is_highlight: bool = None,
        sub_title: str = None,
    ):
        self.baggage_desc = baggage_desc
        self.baggage_sub_content_type = baggage_sub_content_type
        self.description = description
        self.image_do = image_do
        self.is_highlight = is_highlight
        self.sub_title = sub_title

    def validate(self):
        if self.description:
            self.description.validate()
        if self.image_do:
            self.image_do.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        if self.baggage_sub_content_type is not None:
            result['baggage_sub_content_type'] = self.baggage_sub_content_type
        if self.description is not None:
            result['description'] = self.description.to_map()
        if self.image_do is not None:
            result['image_d_o'] = self.image_do.to_map()
        if self.is_highlight is not None:
            result['is_highlight'] = self.is_highlight
        if self.sub_title is not None:
            result['sub_title'] = self.sub_title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        if m.get('baggage_sub_content_type') is not None:
            self.baggage_sub_content_type = m.get('baggage_sub_content_type')
        if m.get('description') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription()
            self.description = temp_model.from_map(m['description'])
        if m.get('image_d_o') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO()
            self.image_do = temp_model.from_map(m['image_d_o'])
        if m.get('is_highlight') is not None:
            self.is_highlight = m.get('is_highlight')
        if m.get('sub_title') is not None:
            self.sub_title = m.get('sub_title')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems(TeaModel):
    def __init__(
        self,
        baggage_sub_content_visualizes: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes] = None,
        extra_content_visualizes: List[Any] = None,
        is_struct: bool = None,
        ptc: str = None,
        title: str = None,
    ):
        self.baggage_sub_content_visualizes = baggage_sub_content_visualizes
        self.extra_content_visualizes = extra_content_visualizes
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.title = title

    def validate(self):
        if self.baggage_sub_content_visualizes:
            for k in self.baggage_sub_content_visualizes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_content_visualizes'] = []
        if self.baggage_sub_content_visualizes is not None:
            for k in self.baggage_sub_content_visualizes:
                result['baggage_sub_content_visualizes'].append(k.to_map() if k else None)
        if self.extra_content_visualizes is not None:
            result['extra_content_visualizes'] = self.extra_content_visualizes
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_content_visualizes = []
        if m.get('baggage_sub_content_visualizes') is not None:
            for k in m.get('baggage_sub_content_visualizes'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes()
                self.baggage_sub_content_visualizes.append(temp_model.from_map(k))
        if m.get('extra_content_visualizes') is not None:
            self.extra_content_visualizes = m.get('extra_content_visualizes')
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemTips(TeaModel):
    def __init__(
        self,
        logo: str = None,
        tips_desc: str = None,
        tips_image: str = None,
    ):
        self.logo = logo
        self.tips_desc = tips_desc
        self.tips_image = tips_image

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['logo'] = self.logo
        if self.tips_desc is not None:
            result['tips_desc'] = self.tips_desc
        if self.tips_image is not None:
            result['tips_image'] = self.tips_image
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('logo') is not None:
            self.logo = m.get('logo')
        if m.get('tips_desc') is not None:
            self.tips_desc = m.get('tips_desc')
        if m.get('tips_image') is not None:
            self.tips_image = m.get('tips_image')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItem(TeaModel):
    def __init__(
        self,
        baggage_sub_items: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems] = None,
        index: int = None,
        table_head: str = None,
        tips: FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemTips = None,
        title: str = None,
        type: int = None,
    ):
        self.baggage_sub_items = baggage_sub_items
        self.index = index
        self.table_head = table_head
        self.tips = tips
        self.title = title
        self.type = type

    def validate(self):
        if self.baggage_sub_items:
            for k in self.baggage_sub_items:
                if k:
                    k.validate()
        if self.tips:
            self.tips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_items'] = []
        if self.baggage_sub_items is not None:
            for k in self.baggage_sub_items:
                result['baggage_sub_items'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.tips is not None:
            result['tips'] = self.tips.to_map()
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_items = []
        if m.get('baggage_sub_items') is not None:
            for k in m.get('baggage_sub_items'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems()
                self.baggage_sub_items.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('tips') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItemTips()
            self.tips = temp_model.from_map(m['tips'])
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        title: str = None,
    ):
        self.content = content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(
        self,
        fee_desc: str = None,
        fee_range: str = None,
        style: int = None,
    ):
        self.fee_desc = fee_desc
        self.fee_range = fee_range
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems(TeaModel):
    def __init__(
        self,
        is_struct: bool = None,
        ptc: str = None,
        refund_sub_contents: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents] = None,
        title: str = None,
    ):
        # isStruct : true
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.refund_sub_contents = refund_sub_contents
        self.title = title

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItem(TeaModel):
    def __init__(
        self,
        extra_contents: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents] = None,
        index: int = None,
        refund_sub_items: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems] = None,
        sub_table_head: List[str] = None,
        table_head: str = None,
        title: str = None,
        type: int = None,
    ):
        self.extra_contents = extra_contents
        self.index = index
        self.refund_sub_items = refund_sub_items
        self.sub_table_head = sub_table_head
        self.table_head = table_head
        self.title = title
        self.type = type

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        title: str = None,
    ):
        self.content = content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(
        self,
        fee_desc: str = None,
        fee_range: str = None,
        style: int = None,
    ):
        self.fee_desc = fee_desc
        self.fee_range = fee_range
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems(TeaModel):
    def __init__(
        self,
        is_struct: bool = None,
        ptc: str = None,
        refund_sub_contents: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents] = None,
        title: str = None,
    ):
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.refund_sub_contents = refund_sub_contents
        self.title = title

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItem(TeaModel):
    def __init__(
        self,
        extra_contents: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents] = None,
        index: int = None,
        refund_sub_items: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems] = None,
        sub_table_head: List[str] = None,
        table_head: str = None,
        title: str = None,
        type: int = None,
    ):
        self.extra_contents = extra_contents
        self.index = index
        self.refund_sub_items = refund_sub_items
        self.sub_table_head = sub_table_head
        self.table_head = table_head
        self.title = title
        self.type = type

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListSignRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListSignRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListSignRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListSignRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleListUpgradeRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightListingSearchResponseBodyModuleFlightListFlightRuleList(TeaModel):
    def __init__(
        self,
        baggage_info: str = None,
        baggage_item: FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItem = None,
        change_rule: FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRule = None,
        change_rule_item: FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItem = None,
        extra: str = None,
        refund_rule: FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRule = None,
        refund_rule_item: FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItem = None,
        sign_rule: FlightListingSearchResponseBodyModuleFlightListFlightRuleListSignRule = None,
        tuigaiqian_info: str = None,
        upgrade_rule: FlightListingSearchResponseBodyModuleFlightListFlightRuleListUpgradeRule = None,
    ):
        self.baggage_info = baggage_info
        self.baggage_item = baggage_item
        self.change_rule = change_rule
        self.change_rule_item = change_rule_item
        self.extra = extra
        self.refund_rule = refund_rule
        self.refund_rule_item = refund_rule_item
        self.sign_rule = sign_rule
        self.tuigaiqian_info = tuigaiqian_info
        self.upgrade_rule = upgrade_rule

    def validate(self):
        if self.baggage_item:
            self.baggage_item.validate()
        if self.change_rule:
            self.change_rule.validate()
        if self.change_rule_item:
            self.change_rule_item.validate()
        if self.refund_rule:
            self.refund_rule.validate()
        if self.refund_rule_item:
            self.refund_rule_item.validate()
        if self.sign_rule:
            self.sign_rule.validate()
        if self.upgrade_rule:
            self.upgrade_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_info is not None:
            result['baggage_info'] = self.baggage_info
        if self.baggage_item is not None:
            result['baggage_item'] = self.baggage_item.to_map()
        if self.change_rule is not None:
            result['change_rule'] = self.change_rule.to_map()
        if self.change_rule_item is not None:
            result['change_rule_item'] = self.change_rule_item.to_map()
        if self.extra is not None:
            result['extra'] = self.extra
        if self.refund_rule is not None:
            result['refund_rule'] = self.refund_rule.to_map()
        if self.refund_rule_item is not None:
            result['refund_rule_item'] = self.refund_rule_item.to_map()
        if self.sign_rule is not None:
            result['sign_rule'] = self.sign_rule.to_map()
        if self.tuigaiqian_info is not None:
            result['tuigaiqian_info'] = self.tuigaiqian_info
        if self.upgrade_rule is not None:
            result['upgrade_rule'] = self.upgrade_rule.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('baggage_info') is not None:
            self.baggage_info = m.get('baggage_info')
        if m.get('baggage_item') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListBaggageItem()
            self.baggage_item = temp_model.from_map(m['baggage_item'])
        if m.get('change_rule') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRule()
            self.change_rule = temp_model.from_map(m['change_rule'])
        if m.get('change_rule_item') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItem()
            self.change_rule_item = temp_model.from_map(m['change_rule_item'])
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('refund_rule') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRule()
            self.refund_rule = temp_model.from_map(m['refund_rule'])
        if m.get('refund_rule_item') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItem()
            self.refund_rule_item = temp_model.from_map(m['refund_rule_item'])
        if m.get('sign_rule') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListSignRule()
            self.sign_rule = temp_model.from_map(m['sign_rule'])
        if m.get('tuigaiqian_info') is not None:
            self.tuigaiqian_info = m.get('tuigaiqian_info')
        if m.get('upgrade_rule') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleListUpgradeRule()
            self.upgrade_rule = temp_model.from_map(m['upgrade_rule'])
        return self


class FlightListingSearchResponseBodyModuleFlightList(TeaModel):
    def __init__(
        self,
        airline_info: FlightListingSearchResponseBodyModuleFlightListAirlineInfo = None,
        arr_airport_info: FlightListingSearchResponseBodyModuleFlightListArrAirportInfo = None,
        arr_date: str = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        cabin: str = None,
        cabin_class: str = None,
        carrier_airline: str = None,
        carrier_no: str = None,
        dep_airport_info: FlightListingSearchResponseBodyModuleFlightListDepAirportInfo = None,
        dep_city_code: str = None,
        dep_date: str = None,
        discount: int = None,
        flight_no: str = None,
        flight_rule_list: List[FlightListingSearchResponseBodyModuleFlightListFlightRuleList] = None,
        flight_rule_list_str: str = None,
        flight_size: str = None,
        flight_type: str = None,
        invoice_type: int = None,
        is_protocol: bool = None,
        is_share: bool = None,
        is_stop: bool = None,
        is_transfer: bool = None,
        meal_desc: str = None,
        oil_price: int = None,
        ota_item_id: str = None,
        price: int = None,
        product_type: int = None,
        product_type_desc: str = None,
        promotion_price: str = None,
        remained_seat_count: str = None,
        secret_params: str = None,
        segment_number: str = None,
        stop_arr_time: str = None,
        stop_city: str = None,
        stop_dep_time: str = None,
        ticket_price: int = None,
        total_price: str = None,
        trip_type: int = None,
    ):
        self.airline_info = airline_info
        self.arr_airport_info = arr_airport_info
        self.arr_date = arr_date
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.carrier_airline = carrier_airline
        self.carrier_no = carrier_no
        self.dep_airport_info = dep_airport_info
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date
        self.discount = discount
        self.flight_no = flight_no
        self.flight_rule_list = flight_rule_list
        self.flight_rule_list_str = flight_rule_list_str
        self.flight_size = flight_size
        self.flight_type = flight_type
        self.invoice_type = invoice_type
        self.is_protocol = is_protocol
        self.is_share = is_share
        self.is_stop = is_stop
        self.is_transfer = is_transfer
        self.meal_desc = meal_desc
        self.oil_price = oil_price
        self.ota_item_id = ota_item_id
        self.price = price
        self.product_type = product_type
        self.product_type_desc = product_type_desc
        self.promotion_price = promotion_price
        self.remained_seat_count = remained_seat_count
        self.secret_params = secret_params
        self.segment_number = segment_number
        self.stop_arr_time = stop_arr_time
        self.stop_city = stop_city
        self.stop_dep_time = stop_dep_time
        self.ticket_price = ticket_price
        self.total_price = total_price
        self.trip_type = trip_type

    def validate(self):
        if self.airline_info:
            self.airline_info.validate()
        if self.arr_airport_info:
            self.arr_airport_info.validate()
        if self.dep_airport_info:
            self.dep_airport_info.validate()
        if self.flight_rule_list:
            for k in self.flight_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_info is not None:
            result['airline_info'] = self.airline_info.to_map()
        if self.arr_airport_info is not None:
            result['arr_airport_info'] = self.arr_airport_info.to_map()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.carrier_airline is not None:
            result['carrier_airline'] = self.carrier_airline
        if self.carrier_no is not None:
            result['carrier_no'] = self.carrier_no
        if self.dep_airport_info is not None:
            result['dep_airport_info'] = self.dep_airport_info.to_map()
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.discount is not None:
            result['discount'] = self.discount
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        result['flight_rule_list'] = []
        if self.flight_rule_list is not None:
            for k in self.flight_rule_list:
                result['flight_rule_list'].append(k.to_map() if k else None)
        if self.flight_rule_list_str is not None:
            result['flight_rule_list_str'] = self.flight_rule_list_str
        if self.flight_size is not None:
            result['flight_size'] = self.flight_size
        if self.flight_type is not None:
            result['flight_type'] = self.flight_type
        if self.invoice_type is not None:
            result['invoice_type'] = self.invoice_type
        if self.is_protocol is not None:
            result['is_protocol'] = self.is_protocol
        if self.is_share is not None:
            result['is_share'] = self.is_share
        if self.is_stop is not None:
            result['is_stop'] = self.is_stop
        if self.is_transfer is not None:
            result['is_transfer'] = self.is_transfer
        if self.meal_desc is not None:
            result['meal_desc'] = self.meal_desc
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.ota_item_id is not None:
            result['ota_item_id'] = self.ota_item_id
        if self.price is not None:
            result['price'] = self.price
        if self.product_type is not None:
            result['product_type'] = self.product_type
        if self.product_type_desc is not None:
            result['product_type_desc'] = self.product_type_desc
        if self.promotion_price is not None:
            result['promotion_price'] = self.promotion_price
        if self.remained_seat_count is not None:
            result['remained_seat_count'] = self.remained_seat_count
        if self.secret_params is not None:
            result['secret_params'] = self.secret_params
        if self.segment_number is not None:
            result['segment_number'] = self.segment_number
        if self.stop_arr_time is not None:
            result['stop_arr_time'] = self.stop_arr_time
        if self.stop_city is not None:
            result['stop_city'] = self.stop_city
        if self.stop_dep_time is not None:
            result['stop_dep_time'] = self.stop_dep_time
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.total_price is not None:
            result['total_price'] = self.total_price
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airline_info') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListAirlineInfo()
            self.airline_info = temp_model.from_map(m['airline_info'])
        if m.get('arr_airport_info') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListArrAirportInfo()
            self.arr_airport_info = temp_model.from_map(m['arr_airport_info'])
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('carrier_airline') is not None:
            self.carrier_airline = m.get('carrier_airline')
        if m.get('carrier_no') is not None:
            self.carrier_no = m.get('carrier_no')
        if m.get('dep_airport_info') is not None:
            temp_model = FlightListingSearchResponseBodyModuleFlightListDepAirportInfo()
            self.dep_airport_info = temp_model.from_map(m['dep_airport_info'])
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        self.flight_rule_list = []
        if m.get('flight_rule_list') is not None:
            for k in m.get('flight_rule_list'):
                temp_model = FlightListingSearchResponseBodyModuleFlightListFlightRuleList()
                self.flight_rule_list.append(temp_model.from_map(k))
        if m.get('flight_rule_list_str') is not None:
            self.flight_rule_list_str = m.get('flight_rule_list_str')
        if m.get('flight_size') is not None:
            self.flight_size = m.get('flight_size')
        if m.get('flight_type') is not None:
            self.flight_type = m.get('flight_type')
        if m.get('invoice_type') is not None:
            self.invoice_type = m.get('invoice_type')
        if m.get('is_protocol') is not None:
            self.is_protocol = m.get('is_protocol')
        if m.get('is_share') is not None:
            self.is_share = m.get('is_share')
        if m.get('is_stop') is not None:
            self.is_stop = m.get('is_stop')
        if m.get('is_transfer') is not None:
            self.is_transfer = m.get('is_transfer')
        if m.get('meal_desc') is not None:
            self.meal_desc = m.get('meal_desc')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('ota_item_id') is not None:
            self.ota_item_id = m.get('ota_item_id')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('product_type') is not None:
            self.product_type = m.get('product_type')
        if m.get('product_type_desc') is not None:
            self.product_type_desc = m.get('product_type_desc')
        if m.get('promotion_price') is not None:
            self.promotion_price = m.get('promotion_price')
        if m.get('remained_seat_count') is not None:
            self.remained_seat_count = m.get('remained_seat_count')
        if m.get('secret_params') is not None:
            self.secret_params = m.get('secret_params')
        if m.get('segment_number') is not None:
            self.segment_number = m.get('segment_number')
        if m.get('stop_arr_time') is not None:
            self.stop_arr_time = m.get('stop_arr_time')
        if m.get('stop_city') is not None:
            self.stop_city = m.get('stop_city')
        if m.get('stop_dep_time') is not None:
            self.stop_dep_time = m.get('stop_dep_time')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('total_price') is not None:
            self.total_price = m.get('total_price')
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        return self


class FlightListingSearchResponseBodyModule(TeaModel):
    def __init__(
        self,
        flight_list: List[FlightListingSearchResponseBodyModuleFlightList] = None,
    ):
        self.flight_list = flight_list

    def validate(self):
        if self.flight_list:
            for k in self.flight_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['flight_list'] = []
        if self.flight_list is not None:
            for k in self.flight_list:
                result['flight_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.flight_list = []
        if m.get('flight_list') is not None:
            for k in m.get('flight_list'):
                temp_model = FlightListingSearchResponseBodyModuleFlightList()
                self.flight_list.append(temp_model.from_map(k))
        return self


class FlightListingSearchResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightListingSearchResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        # module
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightListingSearchResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightListingSearchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightListingSearchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightListingSearchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightOrderDetailInfoHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightOrderDetailInfoRequest(TeaModel):
    def __init__(
        self,
        dis_order_id: str = None,
    ):
        self.dis_order_id = dis_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        return self


class FlightOrderDetailInfoResponseBodyModuleFlightInfoList(TeaModel):
    def __init__(
        self,
        airline_code: str = None,
        airline_name: str = None,
        airline_simple_name: str = None,
        arr_airport: str = None,
        arr_airport_code: str = None,
        arr_airport_code_name: str = None,
        arr_city: str = None,
        arr_city_code: str = None,
        arr_terminal: str = None,
        arr_time: str = None,
        baggage: str = None,
        build_price: int = None,
        cabin: str = None,
        cabin_class: str = None,
        carrier: str = None,
        dep_airport: str = None,
        dep_airport_code: str = None,
        dep_airport_code_name: str = None,
        dep_city: str = None,
        dep_city_code: str = None,
        dep_terminal: str = None,
        dep_time: str = None,
        flight_no: str = None,
        last_cabin: str = None,
        last_flight_no: str = None,
        meal: str = None,
        oil_price: int = None,
        segment_type: int = None,
        stop_arr_time: str = None,
        stop_city: str = None,
        stop_dep_time: str = None,
        ticket_price: int = None,
        tuigaiqian_info: str = None,
    ):
        self.airline_code = airline_code
        self.airline_name = airline_name
        self.airline_simple_name = airline_simple_name
        self.arr_airport = arr_airport
        self.arr_airport_code = arr_airport_code
        self.arr_airport_code_name = arr_airport_code_name
        self.arr_city = arr_city
        self.arr_city_code = arr_city_code
        self.arr_terminal = arr_terminal
        self.arr_time = arr_time
        self.baggage = baggage
        self.build_price = build_price
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.carrier = carrier
        self.dep_airport = dep_airport
        self.dep_airport_code = dep_airport_code
        self.dep_airport_code_name = dep_airport_code_name
        self.dep_city = dep_city
        self.dep_city_code = dep_city_code
        self.dep_terminal = dep_terminal
        self.dep_time = dep_time
        self.flight_no = flight_no
        self.last_cabin = last_cabin
        self.last_flight_no = last_flight_no
        self.meal = meal
        self.oil_price = oil_price
        self.segment_type = segment_type
        self.stop_arr_time = stop_arr_time
        self.stop_city = stop_city
        self.stop_dep_time = stop_dep_time
        self.ticket_price = ticket_price
        self.tuigaiqian_info = tuigaiqian_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.airline_name is not None:
            result['airline_name'] = self.airline_name
        if self.airline_simple_name is not None:
            result['airline_simple_name'] = self.airline_simple_name
        if self.arr_airport is not None:
            result['arr_airport'] = self.arr_airport
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_airport_code_name is not None:
            result['arr_airport_code_name'] = self.arr_airport_code_name
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_terminal is not None:
            result['arr_terminal'] = self.arr_terminal
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.baggage is not None:
            result['baggage'] = self.baggage
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.carrier is not None:
            result['carrier'] = self.carrier
        if self.dep_airport is not None:
            result['dep_airport'] = self.dep_airport
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.dep_airport_code_name is not None:
            result['dep_airport_code_name'] = self.dep_airport_code_name
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_terminal is not None:
            result['dep_terminal'] = self.dep_terminal
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.last_cabin is not None:
            result['last_cabin'] = self.last_cabin
        if self.last_flight_no is not None:
            result['last_flight_no'] = self.last_flight_no
        if self.meal is not None:
            result['meal'] = self.meal
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.segment_type is not None:
            result['segment_type'] = self.segment_type
        if self.stop_arr_time is not None:
            result['stop_arr_time'] = self.stop_arr_time
        if self.stop_city is not None:
            result['stop_city'] = self.stop_city
        if self.stop_dep_time is not None:
            result['stop_dep_time'] = self.stop_dep_time
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.tuigaiqian_info is not None:
            result['tuigaiqian_info'] = self.tuigaiqian_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('airline_name') is not None:
            self.airline_name = m.get('airline_name')
        if m.get('airline_simple_name') is not None:
            self.airline_simple_name = m.get('airline_simple_name')
        if m.get('arr_airport') is not None:
            self.arr_airport = m.get('arr_airport')
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_airport_code_name') is not None:
            self.arr_airport_code_name = m.get('arr_airport_code_name')
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_terminal') is not None:
            self.arr_terminal = m.get('arr_terminal')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('baggage') is not None:
            self.baggage = m.get('baggage')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('carrier') is not None:
            self.carrier = m.get('carrier')
        if m.get('dep_airport') is not None:
            self.dep_airport = m.get('dep_airport')
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('dep_airport_code_name') is not None:
            self.dep_airport_code_name = m.get('dep_airport_code_name')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_terminal') is not None:
            self.dep_terminal = m.get('dep_terminal')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('last_cabin') is not None:
            self.last_cabin = m.get('last_cabin')
        if m.get('last_flight_no') is not None:
            self.last_flight_no = m.get('last_flight_no')
        if m.get('meal') is not None:
            self.meal = m.get('meal')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('segment_type') is not None:
            self.segment_type = m.get('segment_type')
        if m.get('stop_arr_time') is not None:
            self.stop_arr_time = m.get('stop_arr_time')
        if m.get('stop_city') is not None:
            self.stop_city = m.get('stop_city')
        if m.get('stop_dep_time') is not None:
            self.stop_dep_time = m.get('stop_dep_time')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('tuigaiqian_info') is not None:
            self.tuigaiqian_info = m.get('tuigaiqian_info')
        return self


class FlightOrderDetailInfoResponseBodyModuleTicketInfoList(TeaModel):
    def __init__(
        self,
        open_ticket_status: str = None,
        pnr_code: str = None,
        ticket_no: str = None,
        ticket_status: str = None,
    ):
        self.open_ticket_status = open_ticket_status
        self.pnr_code = pnr_code
        self.ticket_no = ticket_no
        self.ticket_status = ticket_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.open_ticket_status is not None:
            result['open_ticket_status'] = self.open_ticket_status
        if self.pnr_code is not None:
            result['pnr_code'] = self.pnr_code
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.ticket_status is not None:
            result['ticket_status'] = self.ticket_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('open_ticket_status') is not None:
            self.open_ticket_status = m.get('open_ticket_status')
        if m.get('pnr_code') is not None:
            self.pnr_code = m.get('pnr_code')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('ticket_status') is not None:
            self.ticket_status = m.get('ticket_status')
        return self


class FlightOrderDetailInfoResponseBodyModuleTravelerInfoList(TeaModel):
    def __init__(
        self,
        birth_date: str = None,
        cert_no: str = None,
        cert_type: str = None,
        open_ticket_status: int = None,
        passenger_name: str = None,
        passenger_type: str = None,
        phone: str = None,
        ticket_no: str = None,
        user_id: str = None,
    ):
        self.birth_date = birth_date
        self.cert_no = cert_no
        self.cert_type = cert_type
        self.open_ticket_status = open_ticket_status
        self.passenger_name = passenger_name
        self.passenger_type = passenger_type
        self.phone = phone
        self.ticket_no = ticket_no
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.birth_date is not None:
            result['birth_date'] = self.birth_date
        if self.cert_no is not None:
            result['cert_no'] = self.cert_no
        if self.cert_type is not None:
            result['cert_type'] = self.cert_type
        if self.open_ticket_status is not None:
            result['open_ticket_status'] = self.open_ticket_status
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.passenger_type is not None:
            result['passenger_type'] = self.passenger_type
        if self.phone is not None:
            result['phone'] = self.phone
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('birth_date') is not None:
            self.birth_date = m.get('birth_date')
        if m.get('cert_no') is not None:
            self.cert_no = m.get('cert_no')
        if m.get('cert_type') is not None:
            self.cert_type = m.get('cert_type')
        if m.get('open_ticket_status') is not None:
            self.open_ticket_status = m.get('open_ticket_status')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('passenger_type') is not None:
            self.passenger_type = m.get('passenger_type')
        if m.get('phone') is not None:
            self.phone = m.get('phone')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightOrderDetailInfoResponseBodyModule(TeaModel):
    def __init__(
        self,
        alipay_trade_no: str = None,
        book_user_id: str = None,
        btrip_order_id: int = None,
        contact_name: str = None,
        contact_phone: str = None,
        dis_order_id: str = None,
        extra: str = None,
        flight_info_list: List[FlightOrderDetailInfoResponseBodyModuleFlightInfoList] = None,
        last_pay_time: str = None,
        pay_status: int = None,
        pay_time: str = None,
        promotion_price: int = None,
        settle_amount: int = None,
        settle_type: int = None,
        status: int = None,
        ticket_info_list: List[FlightOrderDetailInfoResponseBodyModuleTicketInfoList] = None,
        total_build_price: int = None,
        total_oil_price: int = None,
        total_order_price: int = None,
        traveler_info_list: List[FlightOrderDetailInfoResponseBodyModuleTravelerInfoList] = None,
    ):
        self.alipay_trade_no = alipay_trade_no
        self.book_user_id = book_user_id
        self.btrip_order_id = btrip_order_id
        self.contact_name = contact_name
        self.contact_phone = contact_phone
        self.dis_order_id = dis_order_id
        self.extra = extra
        self.flight_info_list = flight_info_list
        self.last_pay_time = last_pay_time
        self.pay_status = pay_status
        self.pay_time = pay_time
        self.promotion_price = promotion_price
        self.settle_amount = settle_amount
        self.settle_type = settle_type
        self.status = status
        self.ticket_info_list = ticket_info_list
        self.total_build_price = total_build_price
        self.total_oil_price = total_oil_price
        self.total_order_price = total_order_price
        self.traveler_info_list = traveler_info_list

    def validate(self):
        if self.flight_info_list:
            for k in self.flight_info_list:
                if k:
                    k.validate()
        if self.ticket_info_list:
            for k in self.ticket_info_list:
                if k:
                    k.validate()
        if self.traveler_info_list:
            for k in self.traveler_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.book_user_id is not None:
            result['book_user_id'] = self.book_user_id
        if self.btrip_order_id is not None:
            result['btrip_order_id'] = self.btrip_order_id
        if self.contact_name is not None:
            result['contact_name'] = self.contact_name
        if self.contact_phone is not None:
            result['contact_phone'] = self.contact_phone
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.extra is not None:
            result['extra'] = self.extra
        result['flight_info_list'] = []
        if self.flight_info_list is not None:
            for k in self.flight_info_list:
                result['flight_info_list'].append(k.to_map() if k else None)
        if self.last_pay_time is not None:
            result['last_pay_time'] = self.last_pay_time
        if self.pay_status is not None:
            result['pay_status'] = self.pay_status
        if self.pay_time is not None:
            result['pay_time'] = self.pay_time
        if self.promotion_price is not None:
            result['promotion_price'] = self.promotion_price
        if self.settle_amount is not None:
            result['settle_amount'] = self.settle_amount
        if self.settle_type is not None:
            result['settle_type'] = self.settle_type
        if self.status is not None:
            result['status'] = self.status
        result['ticket_info_list'] = []
        if self.ticket_info_list is not None:
            for k in self.ticket_info_list:
                result['ticket_info_list'].append(k.to_map() if k else None)
        if self.total_build_price is not None:
            result['total_build_price'] = self.total_build_price
        if self.total_oil_price is not None:
            result['total_oil_price'] = self.total_oil_price
        if self.total_order_price is not None:
            result['total_order_price'] = self.total_order_price
        result['traveler_info_list'] = []
        if self.traveler_info_list is not None:
            for k in self.traveler_info_list:
                result['traveler_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('book_user_id') is not None:
            self.book_user_id = m.get('book_user_id')
        if m.get('btrip_order_id') is not None:
            self.btrip_order_id = m.get('btrip_order_id')
        if m.get('contact_name') is not None:
            self.contact_name = m.get('contact_name')
        if m.get('contact_phone') is not None:
            self.contact_phone = m.get('contact_phone')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        self.flight_info_list = []
        if m.get('flight_info_list') is not None:
            for k in m.get('flight_info_list'):
                temp_model = FlightOrderDetailInfoResponseBodyModuleFlightInfoList()
                self.flight_info_list.append(temp_model.from_map(k))
        if m.get('last_pay_time') is not None:
            self.last_pay_time = m.get('last_pay_time')
        if m.get('pay_status') is not None:
            self.pay_status = m.get('pay_status')
        if m.get('pay_time') is not None:
            self.pay_time = m.get('pay_time')
        if m.get('promotion_price') is not None:
            self.promotion_price = m.get('promotion_price')
        if m.get('settle_amount') is not None:
            self.settle_amount = m.get('settle_amount')
        if m.get('settle_type') is not None:
            self.settle_type = m.get('settle_type')
        if m.get('status') is not None:
            self.status = m.get('status')
        self.ticket_info_list = []
        if m.get('ticket_info_list') is not None:
            for k in m.get('ticket_info_list'):
                temp_model = FlightOrderDetailInfoResponseBodyModuleTicketInfoList()
                self.ticket_info_list.append(temp_model.from_map(k))
        if m.get('total_build_price') is not None:
            self.total_build_price = m.get('total_build_price')
        if m.get('total_oil_price') is not None:
            self.total_oil_price = m.get('total_oil_price')
        if m.get('total_order_price') is not None:
            self.total_order_price = m.get('total_order_price')
        self.traveler_info_list = []
        if m.get('traveler_info_list') is not None:
            for k in m.get('traveler_info_list'):
                temp_model = FlightOrderDetailInfoResponseBodyModuleTravelerInfoList()
                self.traveler_info_list.append(temp_model.from_map(k))
        return self


class FlightOrderDetailInfoResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightOrderDetailInfoResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightOrderDetailInfoResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightOrderDetailInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightOrderDetailInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightOrderDetailInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightOrderListQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class FlightOrderListQueryRequest(TeaModel):
    def __init__(
        self,
        all_apply: bool = None,
        apply_id: int = None,
        depart_id: str = None,
        end_time: str = None,
        page: int = None,
        page_size: int = None,
        start_time: str = None,
        thirdpart_apply_id: str = None,
        update_end_time: str = None,
        update_start_time: str = None,
        user_id: str = None,
    ):
        self.all_apply = all_apply
        self.apply_id = apply_id
        self.depart_id = depart_id
        self.end_time = end_time
        self.page = page
        self.page_size = page_size
        self.start_time = start_time
        self.thirdpart_apply_id = thirdpart_apply_id
        self.update_end_time = update_end_time
        self.update_start_time = update_start_time
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_apply is not None:
            result['all_apply'] = self.all_apply
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.update_end_time is not None:
            result['update_end_time'] = self.update_end_time
        if self.update_start_time is not None:
            result['update_start_time'] = self.update_start_time
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('all_apply') is not None:
            self.all_apply = m.get('all_apply')
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('update_end_time') is not None:
            self.update_end_time = m.get('update_end_time')
        if m.get('update_start_time') is not None:
            self.update_start_time = m.get('update_start_time')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightOrderListQueryResponseBodyModuleCostCenter(TeaModel):
    def __init__(
        self,
        corp_id: str = None,
        id: int = None,
        name: str = None,
        number: str = None,
    ):
        self.corp_id = corp_id
        self.id = id
        self.name = name
        self.number = number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.number is not None:
            result['number'] = self.number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('number') is not None:
            self.number = m.get('number')
        return self


class FlightOrderListQueryResponseBodyModuleInsureInfoList(TeaModel):
    def __init__(
        self,
        insure_no: str = None,
        name: str = None,
        status: int = None,
    ):
        self.insure_no = insure_no
        self.name = name
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.insure_no is not None:
            result['insure_no'] = self.insure_no
        if self.name is not None:
            result['name'] = self.name
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('insure_no') is not None:
            self.insure_no = m.get('insure_no')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class FlightOrderListQueryResponseBodyModuleInvoice(TeaModel):
    def __init__(
        self,
        id: int = None,
        title: str = None,
    ):
        self.id = id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOrderListQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(
        self,
        category_code: int = None,
        category_type: int = None,
        change_flight_no: str = None,
        discount: str = None,
        end_time: str = None,
        gmt_create: str = None,
        original_ticket_no: str = None,
        passenger_name: str = None,
        pay_type: int = None,
        price: float = None,
        start_time: str = None,
        ticket_no: str = None,
        trade_id: str = None,
        type: int = None,
    ):
        self.category_code = category_code
        self.category_type = category_type
        self.change_flight_no = change_flight_no
        self.discount = discount
        self.end_time = end_time
        self.gmt_create = gmt_create
        self.original_ticket_no = original_ticket_no
        self.passenger_name = passenger_name
        self.pay_type = pay_type
        self.price = price
        self.start_time = start_time
        self.ticket_no = ticket_no
        self.trade_id = trade_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.category_type is not None:
            result['category_type'] = self.category_type
        if self.change_flight_no is not None:
            result['change_flight_no'] = self.change_flight_no
        if self.discount is not None:
            result['discount'] = self.discount
        if self.end_time is not None:
            result['end_time'] = self.end_time
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.original_ticket_no is not None:
            result['original_ticket_no'] = self.original_ticket_no
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.price is not None:
            result['price'] = self.price
        if self.start_time is not None:
            result['start_time'] = self.start_time
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('category_type') is not None:
            self.category_type = m.get('category_type')
        if m.get('change_flight_no') is not None:
            self.change_flight_no = m.get('change_flight_no')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('end_time') is not None:
            self.end_time = m.get('end_time')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('original_ticket_no') is not None:
            self.original_ticket_no = m.get('original_ticket_no')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('start_time') is not None:
            self.start_time = m.get('start_time')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOrderListQueryResponseBodyModuleUserAffiliateList(TeaModel):
    def __init__(
        self,
        user_id: str = None,
        user_name: str = None,
    ):
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class FlightOrderListQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        apply_id: int = None,
        arr_airport: str = None,
        arr_city: str = None,
        btrip_title: str = None,
        cabin_class: str = None,
        contact_name: str = None,
        corp_id: str = None,
        corp_name: str = None,
        cost_center: FlightOrderListQueryResponseBodyModuleCostCenter = None,
        dep_airport: str = None,
        dep_city: str = None,
        dep_date: str = None,
        depart_id: str = None,
        depart_name: str = None,
        discount: str = None,
        flight_no: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        insure_info_list: List[FlightOrderListQueryResponseBodyModuleInsureInfoList] = None,
        invoice: FlightOrderListQueryResponseBodyModuleInvoice = None,
        passenger_count: int = None,
        passenger_name: str = None,
        price_info_list: List[FlightOrderListQueryResponseBodyModulePriceInfoList] = None,
        project_code: str = None,
        project_id: int = None,
        project_title: str = None,
        ret_date: str = None,
        status: int = None,
        third_part_project_id: str = None,
        thirdpart_apply_id: str = None,
        thirdpart_itinerary_id: str = None,
        trip_type: int = None,
        user_affiliate_list: List[FlightOrderListQueryResponseBodyModuleUserAffiliateList] = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.apply_id = apply_id
        self.arr_airport = arr_airport
        self.arr_city = arr_city
        self.btrip_title = btrip_title
        self.cabin_class = cabin_class
        self.contact_name = contact_name
        self.corp_id = corp_id
        self.corp_name = corp_name
        self.cost_center = cost_center
        self.dep_airport = dep_airport
        self.dep_city = dep_city
        self.dep_date = dep_date
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.discount = discount
        self.flight_no = flight_no
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.insure_info_list = insure_info_list
        self.invoice = invoice
        self.passenger_count = passenger_count
        self.passenger_name = passenger_name
        self.price_info_list = price_info_list
        self.project_code = project_code
        self.project_id = project_id
        self.project_title = project_title
        self.ret_date = ret_date
        self.status = status
        self.third_part_project_id = third_part_project_id
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_itinerary_id = thirdpart_itinerary_id
        self.trip_type = trip_type
        self.user_affiliate_list = user_affiliate_list
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        if self.cost_center:
            self.cost_center.validate()
        if self.insure_info_list:
            for k in self.insure_info_list:
                if k:
                    k.validate()
        if self.invoice:
            self.invoice.validate()
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()
        if self.user_affiliate_list:
            for k in self.user_affiliate_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.arr_airport is not None:
            result['arr_airport'] = self.arr_airport
        if self.arr_city is not None:
            result['arr_city'] = self.arr_city
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.contact_name is not None:
            result['contact_name'] = self.contact_name
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.cost_center is not None:
            result['cost_center'] = self.cost_center.to_map()
        if self.dep_airport is not None:
            result['dep_airport'] = self.dep_airport
        if self.dep_city is not None:
            result['dep_city'] = self.dep_city
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.discount is not None:
            result['discount'] = self.discount
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modified is not None:
            result['gmt_modified'] = self.gmt_modified
        if self.id is not None:
            result['id'] = self.id
        result['insure_info_list'] = []
        if self.insure_info_list is not None:
            for k in self.insure_info_list:
                result['insure_info_list'].append(k.to_map() if k else None)
        if self.invoice is not None:
            result['invoice'] = self.invoice.to_map()
        if self.passenger_count is not None:
            result['passenger_count'] = self.passenger_count
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.ret_date is not None:
            result['ret_date'] = self.ret_date
        if self.status is not None:
            result['status'] = self.status
        if self.third_part_project_id is not None:
            result['third_part_project_id'] = self.third_part_project_id
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        result['user_affiliate_list'] = []
        if self.user_affiliate_list is not None:
            for k in self.user_affiliate_list:
                result['user_affiliate_list'].append(k.to_map() if k else None)
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('arr_airport') is not None:
            self.arr_airport = m.get('arr_airport')
        if m.get('arr_city') is not None:
            self.arr_city = m.get('arr_city')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('contact_name') is not None:
            self.contact_name = m.get('contact_name')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('cost_center') is not None:
            temp_model = FlightOrderListQueryResponseBodyModuleCostCenter()
            self.cost_center = temp_model.from_map(m['cost_center'])
        if m.get('dep_airport') is not None:
            self.dep_airport = m.get('dep_airport')
        if m.get('dep_city') is not None:
            self.dep_city = m.get('dep_city')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modified') is not None:
            self.gmt_modified = m.get('gmt_modified')
        if m.get('id') is not None:
            self.id = m.get('id')
        self.insure_info_list = []
        if m.get('insure_info_list') is not None:
            for k in m.get('insure_info_list'):
                temp_model = FlightOrderListQueryResponseBodyModuleInsureInfoList()
                self.insure_info_list.append(temp_model.from_map(k))
        if m.get('invoice') is not None:
            temp_model = FlightOrderListQueryResponseBodyModuleInvoice()
            self.invoice = temp_model.from_map(m['invoice'])
        if m.get('passenger_count') is not None:
            self.passenger_count = m.get('passenger_count')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = FlightOrderListQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('ret_date') is not None:
            self.ret_date = m.get('ret_date')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('third_part_project_id') is not None:
            self.third_part_project_id = m.get('third_part_project_id')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        self.user_affiliate_list = []
        if m.get('user_affiliate_list') is not None:
            for k in m.get('user_affiliate_list'):
                temp_model = FlightOrderListQueryResponseBodyModuleUserAffiliateList()
                self.user_affiliate_list.append(temp_model.from_map(k))
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        return self


class FlightOrderListQueryResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        page: int = None,
        page_size: int = None,
        total_number: int = None,
    ):
        self.page = page
        self.page_size = page_size
        self.total_number = total_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page is not None:
            result['page'] = self.page
        if self.page_size is not None:
            result['page_size'] = self.page_size
        if self.total_number is not None:
            result['total_number'] = self.total_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('page') is not None:
            self.page = m.get('page')
        if m.get('page_size') is not None:
            self.page_size = m.get('page_size')
        if m.get('total_number') is not None:
            self.total_number = m.get('total_number')
        return self


class FlightOrderListQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: List[FlightOrderListQueryResponseBodyModule] = None,
        page_info: FlightOrderListQueryResponseBodyPageInfo = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.page_info = page_info
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        result['module'] = []
        if self.module is not None:
            for k in self.module:
                result['module'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['page_info'] = self.page_info.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        self.module = []
        if m.get('module') is not None:
            for k in m.get('module'):
                temp_model = FlightOrderListQueryResponseBodyModule()
                self.module.append(temp_model.from_map(k))
        if m.get('page_info') is not None:
            temp_model = FlightOrderListQueryResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['page_info'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightOrderListQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightOrderListQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightOrderListQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightOrderQueryHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_so_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_so_corp_token = x_acs_btrip_so_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_so_corp_token is not None:
            result['x-acs-btrip-so-corp-token'] = self.x_acs_btrip_so_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-so-corp-token') is not None:
            self.x_acs_btrip_so_corp_token = m.get('x-acs-btrip-so-corp-token')
        return self


class FlightOrderQueryRequest(TeaModel):
    def __init__(
        self,
        order_id: int = None,
        user_id: str = None,
    ):
        self.order_id = order_id
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightOrderQueryResponseBodyModuleFlightChangeTicketInfoList(TeaModel):
    def __init__(
        self,
        arr_time: str = None,
        change_cabin: str = None,
        change_cabin_level: str = None,
        change_fee: float = None,
        change_flight_no: str = None,
        change_order_id: int = None,
        change_reason: str = None,
        change_type: int = None,
        dep_time: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        origin_ticket_no: str = None,
        ticket_no: str = None,
        upgrade_fee: float = None,
    ):
        self.arr_time = arr_time
        self.change_cabin = change_cabin
        self.change_cabin_level = change_cabin_level
        self.change_fee = change_fee
        self.change_flight_no = change_flight_no
        self.change_order_id = change_order_id
        self.change_reason = change_reason
        self.change_type = change_type
        self.dep_time = dep_time
        self.gmt_create = gmt_create
        self.gmt_modify = gmt_modify
        self.origin_ticket_no = origin_ticket_no
        self.ticket_no = ticket_no
        self.upgrade_fee = upgrade_fee

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.change_cabin is not None:
            result['change_cabin'] = self.change_cabin
        if self.change_cabin_level is not None:
            result['change_cabin_level'] = self.change_cabin_level
        if self.change_fee is not None:
            result['change_fee'] = self.change_fee
        if self.change_flight_no is not None:
            result['change_flight_no'] = self.change_flight_no
        if self.change_order_id is not None:
            result['change_order_id'] = self.change_order_id
        if self.change_reason is not None:
            result['change_reason'] = self.change_reason
        if self.change_type is not None:
            result['change_type'] = self.change_type
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modify is not None:
            result['gmt_modify'] = self.gmt_modify
        if self.origin_ticket_no is not None:
            result['origin_ticket_no'] = self.origin_ticket_no
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.upgrade_fee is not None:
            result['upgrade_fee'] = self.upgrade_fee
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('change_cabin') is not None:
            self.change_cabin = m.get('change_cabin')
        if m.get('change_cabin_level') is not None:
            self.change_cabin_level = m.get('change_cabin_level')
        if m.get('change_fee') is not None:
            self.change_fee = m.get('change_fee')
        if m.get('change_flight_no') is not None:
            self.change_flight_no = m.get('change_flight_no')
        if m.get('change_order_id') is not None:
            self.change_order_id = m.get('change_order_id')
        if m.get('change_reason') is not None:
            self.change_reason = m.get('change_reason')
        if m.get('change_type') is not None:
            self.change_type = m.get('change_type')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modify') is not None:
            self.gmt_modify = m.get('gmt_modify')
        if m.get('origin_ticket_no') is not None:
            self.origin_ticket_no = m.get('origin_ticket_no')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('upgrade_fee') is not None:
            self.upgrade_fee = m.get('upgrade_fee')
        return self


class FlightOrderQueryResponseBodyModuleFlightInfoList(TeaModel):
    def __init__(
        self,
        airline_code: str = None,
        airline_name: str = None,
        arr_airport_code: str = None,
        arr_airport_name: str = None,
        arr_city_code: str = None,
        arr_city_name: str = None,
        arr_time: str = None,
        cabin: str = None,
        cabin_level: str = None,
        dep_airport_code: str = None,
        dep_airport_name: str = None,
        dep_city_code: str = None,
        dep_city_name: str = None,
        dep_time: str = None,
        flight_mile: int = None,
        flight_no: str = None,
    ):
        self.airline_code = airline_code
        self.airline_name = airline_name
        self.arr_airport_code = arr_airport_code
        self.arr_airport_name = arr_airport_name
        self.arr_city_code = arr_city_code
        self.arr_city_name = arr_city_name
        self.arr_time = arr_time
        self.cabin = cabin
        self.cabin_level = cabin_level
        self.dep_airport_code = dep_airport_code
        self.dep_airport_name = dep_airport_name
        self.dep_city_code = dep_city_code
        self.dep_city_name = dep_city_name
        self.dep_time = dep_time
        self.flight_mile = flight_mile
        self.flight_no = flight_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.airline_name is not None:
            result['airline_name'] = self.airline_name
        if self.arr_airport_code is not None:
            result['arr_airport_code'] = self.arr_airport_code
        if self.arr_airport_name is not None:
            result['arr_airport_name'] = self.arr_airport_name
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_city_name is not None:
            result['arr_city_name'] = self.arr_city_name
        if self.arr_time is not None:
            result['arr_time'] = self.arr_time
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_level is not None:
            result['cabin_level'] = self.cabin_level
        if self.dep_airport_code is not None:
            result['dep_airport_code'] = self.dep_airport_code
        if self.dep_airport_name is not None:
            result['dep_airport_name'] = self.dep_airport_name
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_city_name is not None:
            result['dep_city_name'] = self.dep_city_name
        if self.dep_time is not None:
            result['dep_time'] = self.dep_time
        if self.flight_mile is not None:
            result['flight_mile'] = self.flight_mile
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('airline_name') is not None:
            self.airline_name = m.get('airline_name')
        if m.get('arr_airport_code') is not None:
            self.arr_airport_code = m.get('arr_airport_code')
        if m.get('arr_airport_name') is not None:
            self.arr_airport_name = m.get('arr_airport_name')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_city_name') is not None:
            self.arr_city_name = m.get('arr_city_name')
        if m.get('arr_time') is not None:
            self.arr_time = m.get('arr_time')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_level') is not None:
            self.cabin_level = m.get('cabin_level')
        if m.get('dep_airport_code') is not None:
            self.dep_airport_code = m.get('dep_airport_code')
        if m.get('dep_airport_name') is not None:
            self.dep_airport_name = m.get('dep_airport_name')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_city_name') is not None:
            self.dep_city_name = m.get('dep_city_name')
        if m.get('dep_time') is not None:
            self.dep_time = m.get('dep_time')
        if m.get('flight_mile') is not None:
            self.flight_mile = m.get('flight_mile')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        return self


class FlightOrderQueryResponseBodyModuleFlightRefundTicketInfoList(TeaModel):
    def __init__(
        self,
        gmt_create: str = None,
        gmt_modify: str = None,
        refund_order_id: int = None,
        refund_reason: str = None,
        refund_ticket_fee: float = None,
        refund_type: int = None,
        ticket_no: str = None,
    ):
        self.gmt_create = gmt_create
        self.gmt_modify = gmt_modify
        self.refund_order_id = refund_order_id
        self.refund_reason = refund_reason
        self.refund_ticket_fee = refund_ticket_fee
        self.refund_type = refund_type
        self.ticket_no = ticket_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modify is not None:
            result['gmt_modify'] = self.gmt_modify
        if self.refund_order_id is not None:
            result['refund_order_id'] = self.refund_order_id
        if self.refund_reason is not None:
            result['refund_reason'] = self.refund_reason
        if self.refund_ticket_fee is not None:
            result['refund_ticket_fee'] = self.refund_ticket_fee
        if self.refund_type is not None:
            result['refund_type'] = self.refund_type
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modify') is not None:
            self.gmt_modify = m.get('gmt_modify')
        if m.get('refund_order_id') is not None:
            self.refund_order_id = m.get('refund_order_id')
        if m.get('refund_reason') is not None:
            self.refund_reason = m.get('refund_reason')
        if m.get('refund_ticket_fee') is not None:
            self.refund_ticket_fee = m.get('refund_ticket_fee')
        if m.get('refund_type') is not None:
            self.refund_type = m.get('refund_type')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        return self


class FlightOrderQueryResponseBodyModuleFlightTicketInfoList(TeaModel):
    def __init__(
        self,
        build_price: float = None,
        changed: bool = None,
        discount: int = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        oil_price: float = None,
        pay_type: int = None,
        settle_price: float = None,
        ticket_no: str = None,
        ticket_price: float = None,
        ticket_status: str = None,
        ticket_status_code: int = None,
        user_id: str = None,
    ):
        self.build_price = build_price
        self.changed = changed
        self.discount = discount
        self.gmt_create = gmt_create
        self.gmt_modify = gmt_modify
        self.oil_price = oil_price
        self.pay_type = pay_type
        self.settle_price = settle_price
        self.ticket_no = ticket_no
        self.ticket_price = ticket_price
        self.ticket_status = ticket_status
        self.ticket_status_code = ticket_status_code
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.changed is not None:
            result['changed'] = self.changed
        if self.discount is not None:
            result['discount'] = self.discount
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modify is not None:
            result['gmt_modify'] = self.gmt_modify
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.settle_price is not None:
            result['settle_price'] = self.settle_price
        if self.ticket_no is not None:
            result['ticket_no'] = self.ticket_no
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.ticket_status is not None:
            result['ticket_status'] = self.ticket_status
        if self.ticket_status_code is not None:
            result['ticket_status_code'] = self.ticket_status_code
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('changed') is not None:
            self.changed = m.get('changed')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modify') is not None:
            self.gmt_modify = m.get('gmt_modify')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('settle_price') is not None:
            self.settle_price = m.get('settle_price')
        if m.get('ticket_no') is not None:
            self.ticket_no = m.get('ticket_no')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('ticket_status') is not None:
            self.ticket_status = m.get('ticket_status')
        if m.get('ticket_status_code') is not None:
            self.ticket_status_code = m.get('ticket_status_code')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightOrderQueryResponseBodyModuleInsuranceInfoList(TeaModel):
    def __init__(
        self,
        amount: float = None,
        insurance_no: str = None,
        status: int = None,
        type: str = None,
    ):
        self.amount = amount
        self.insurance_no = insurance_no
        self.status = status
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['amount'] = self.amount
        if self.insurance_no is not None:
            result['insurance_no'] = self.insurance_no
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('amount') is not None:
            self.amount = m.get('amount')
        if m.get('insurance_no') is not None:
            self.insurance_no = m.get('insurance_no')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOrderQueryResponseBodyModuleInvoiceInfo(TeaModel):
    def __init__(
        self,
        id: int = None,
        title: str = None,
    ):
        self.id = id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['id'] = self.id
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOrderQueryResponseBodyModuleOrderBaseInfo(TeaModel):
    def __init__(
        self,
        apply_id: str = None,
        btrip_title: str = None,
        contact_name: str = None,
        corp_id: str = None,
        corp_name: str = None,
        depart_id: str = None,
        depart_name: str = None,
        gmt_create: str = None,
        gmt_modify: str = None,
        itinerary_id: str = None,
        order_id: int = None,
        order_status: int = None,
        thirdpart_apply_id: str = None,
        thirdpart_corp_id: str = None,
        thirdpart_itinerary_id: str = None,
        trip_type: int = None,
        user_id: str = None,
    ):
        self.apply_id = apply_id
        self.btrip_title = btrip_title
        self.contact_name = contact_name
        self.corp_id = corp_id
        self.corp_name = corp_name
        self.depart_id = depart_id
        self.depart_name = depart_name
        self.gmt_create = gmt_create
        self.gmt_modify = gmt_modify
        self.itinerary_id = itinerary_id
        self.order_id = order_id
        self.order_status = order_status
        self.thirdpart_apply_id = thirdpart_apply_id
        self.thirdpart_corp_id = thirdpart_corp_id
        self.thirdpart_itinerary_id = thirdpart_itinerary_id
        self.trip_type = trip_type
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apply_id is not None:
            result['apply_id'] = self.apply_id
        if self.btrip_title is not None:
            result['btrip_title'] = self.btrip_title
        if self.contact_name is not None:
            result['contact_name'] = self.contact_name
        if self.corp_id is not None:
            result['corp_id'] = self.corp_id
        if self.corp_name is not None:
            result['corp_name'] = self.corp_name
        if self.depart_id is not None:
            result['depart_id'] = self.depart_id
        if self.depart_name is not None:
            result['depart_name'] = self.depart_name
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.gmt_modify is not None:
            result['gmt_modify'] = self.gmt_modify
        if self.itinerary_id is not None:
            result['itinerary_id'] = self.itinerary_id
        if self.order_id is not None:
            result['order_id'] = self.order_id
        if self.order_status is not None:
            result['order_status'] = self.order_status
        if self.thirdpart_apply_id is not None:
            result['thirdpart_apply_id'] = self.thirdpart_apply_id
        if self.thirdpart_corp_id is not None:
            result['thirdpart_corp_id'] = self.thirdpart_corp_id
        if self.thirdpart_itinerary_id is not None:
            result['thirdpart_itinerary_id'] = self.thirdpart_itinerary_id
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apply_id') is not None:
            self.apply_id = m.get('apply_id')
        if m.get('btrip_title') is not None:
            self.btrip_title = m.get('btrip_title')
        if m.get('contact_name') is not None:
            self.contact_name = m.get('contact_name')
        if m.get('corp_id') is not None:
            self.corp_id = m.get('corp_id')
        if m.get('corp_name') is not None:
            self.corp_name = m.get('corp_name')
        if m.get('depart_id') is not None:
            self.depart_id = m.get('depart_id')
        if m.get('depart_name') is not None:
            self.depart_name = m.get('depart_name')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('gmt_modify') is not None:
            self.gmt_modify = m.get('gmt_modify')
        if m.get('itinerary_id') is not None:
            self.itinerary_id = m.get('itinerary_id')
        if m.get('order_id') is not None:
            self.order_id = m.get('order_id')
        if m.get('order_status') is not None:
            self.order_status = m.get('order_status')
        if m.get('thirdpart_apply_id') is not None:
            self.thirdpart_apply_id = m.get('thirdpart_apply_id')
        if m.get('thirdpart_corp_id') is not None:
            self.thirdpart_corp_id = m.get('thirdpart_corp_id')
        if m.get('thirdpart_itinerary_id') is not None:
            self.thirdpart_itinerary_id = m.get('thirdpart_itinerary_id')
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightOrderQueryResponseBodyModulePassengerInfoList(TeaModel):
    def __init__(
        self,
        cost_center_id: int = None,
        cost_center_name: str = None,
        cost_center_number: str = None,
        project_code: str = None,
        project_id: int = None,
        project_title: str = None,
        thirdpart_project_id: str = None,
        user_id: str = None,
        user_name: str = None,
        user_type: int = None,
    ):
        self.cost_center_id = cost_center_id
        self.cost_center_name = cost_center_name
        self.cost_center_number = cost_center_number
        self.project_code = project_code
        self.project_id = project_id
        self.project_title = project_title
        self.thirdpart_project_id = thirdpart_project_id
        self.user_id = user_id
        self.user_name = user_name
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cost_center_id is not None:
            result['cost_center_id'] = self.cost_center_id
        if self.cost_center_name is not None:
            result['cost_center_name'] = self.cost_center_name
        if self.cost_center_number is not None:
            result['cost_center_number'] = self.cost_center_number
        if self.project_code is not None:
            result['project_code'] = self.project_code
        if self.project_id is not None:
            result['project_id'] = self.project_id
        if self.project_title is not None:
            result['project_title'] = self.project_title
        if self.thirdpart_project_id is not None:
            result['thirdpart_project_id'] = self.thirdpart_project_id
        if self.user_id is not None:
            result['user_id'] = self.user_id
        if self.user_name is not None:
            result['user_name'] = self.user_name
        if self.user_type is not None:
            result['user_type'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cost_center_id') is not None:
            self.cost_center_id = m.get('cost_center_id')
        if m.get('cost_center_name') is not None:
            self.cost_center_name = m.get('cost_center_name')
        if m.get('cost_center_number') is not None:
            self.cost_center_number = m.get('cost_center_number')
        if m.get('project_code') is not None:
            self.project_code = m.get('project_code')
        if m.get('project_id') is not None:
            self.project_id = m.get('project_id')
        if m.get('project_title') is not None:
            self.project_title = m.get('project_title')
        if m.get('thirdpart_project_id') is not None:
            self.thirdpart_project_id = m.get('thirdpart_project_id')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        if m.get('user_name') is not None:
            self.user_name = m.get('user_name')
        if m.get('user_type') is not None:
            self.user_type = m.get('user_type')
        return self


class FlightOrderQueryResponseBodyModulePriceInfoList(TeaModel):
    def __init__(
        self,
        category_code: int = None,
        gmt_create: str = None,
        passenger_name: str = None,
        pay_type: int = None,
        price: float = None,
        trade_id: str = None,
        type: int = None,
    ):
        self.category_code = category_code
        self.gmt_create = gmt_create
        self.passenger_name = passenger_name
        self.pay_type = pay_type
        self.price = price
        self.trade_id = trade_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_code is not None:
            result['category_code'] = self.category_code
        if self.gmt_create is not None:
            result['gmt_create'] = self.gmt_create
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.pay_type is not None:
            result['pay_type'] = self.pay_type
        if self.price is not None:
            result['price'] = self.price
        if self.trade_id is not None:
            result['trade_id'] = self.trade_id
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('category_code') is not None:
            self.category_code = m.get('category_code')
        if m.get('gmt_create') is not None:
            self.gmt_create = m.get('gmt_create')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('pay_type') is not None:
            self.pay_type = m.get('pay_type')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('trade_id') is not None:
            self.trade_id = m.get('trade_id')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOrderQueryResponseBodyModule(TeaModel):
    def __init__(
        self,
        flight_change_ticket_info_list: List[FlightOrderQueryResponseBodyModuleFlightChangeTicketInfoList] = None,
        flight_info_list: List[FlightOrderQueryResponseBodyModuleFlightInfoList] = None,
        flight_refund_ticket_info_list: List[FlightOrderQueryResponseBodyModuleFlightRefundTicketInfoList] = None,
        flight_ticket_info_list: List[FlightOrderQueryResponseBodyModuleFlightTicketInfoList] = None,
        insurance_info_list: List[FlightOrderQueryResponseBodyModuleInsuranceInfoList] = None,
        invoice_info: FlightOrderQueryResponseBodyModuleInvoiceInfo = None,
        order_base_info: FlightOrderQueryResponseBodyModuleOrderBaseInfo = None,
        passenger_info_list: List[FlightOrderQueryResponseBodyModulePassengerInfoList] = None,
        price_info_list: List[FlightOrderQueryResponseBodyModulePriceInfoList] = None,
    ):
        self.flight_change_ticket_info_list = flight_change_ticket_info_list
        self.flight_info_list = flight_info_list
        self.flight_refund_ticket_info_list = flight_refund_ticket_info_list
        self.flight_ticket_info_list = flight_ticket_info_list
        self.insurance_info_list = insurance_info_list
        self.invoice_info = invoice_info
        self.order_base_info = order_base_info
        self.passenger_info_list = passenger_info_list
        self.price_info_list = price_info_list

    def validate(self):
        if self.flight_change_ticket_info_list:
            for k in self.flight_change_ticket_info_list:
                if k:
                    k.validate()
        if self.flight_info_list:
            for k in self.flight_info_list:
                if k:
                    k.validate()
        if self.flight_refund_ticket_info_list:
            for k in self.flight_refund_ticket_info_list:
                if k:
                    k.validate()
        if self.flight_ticket_info_list:
            for k in self.flight_ticket_info_list:
                if k:
                    k.validate()
        if self.insurance_info_list:
            for k in self.insurance_info_list:
                if k:
                    k.validate()
        if self.invoice_info:
            self.invoice_info.validate()
        if self.order_base_info:
            self.order_base_info.validate()
        if self.passenger_info_list:
            for k in self.passenger_info_list:
                if k:
                    k.validate()
        if self.price_info_list:
            for k in self.price_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['flight_change_ticket_info_list'] = []
        if self.flight_change_ticket_info_list is not None:
            for k in self.flight_change_ticket_info_list:
                result['flight_change_ticket_info_list'].append(k.to_map() if k else None)
        result['flight_info_list'] = []
        if self.flight_info_list is not None:
            for k in self.flight_info_list:
                result['flight_info_list'].append(k.to_map() if k else None)
        result['flight_refund_ticket_info_list'] = []
        if self.flight_refund_ticket_info_list is not None:
            for k in self.flight_refund_ticket_info_list:
                result['flight_refund_ticket_info_list'].append(k.to_map() if k else None)
        result['flight_ticket_info_list'] = []
        if self.flight_ticket_info_list is not None:
            for k in self.flight_ticket_info_list:
                result['flight_ticket_info_list'].append(k.to_map() if k else None)
        result['insurance_info_list'] = []
        if self.insurance_info_list is not None:
            for k in self.insurance_info_list:
                result['insurance_info_list'].append(k.to_map() if k else None)
        if self.invoice_info is not None:
            result['invoice_info'] = self.invoice_info.to_map()
        if self.order_base_info is not None:
            result['order_base_info'] = self.order_base_info.to_map()
        result['passenger_info_list'] = []
        if self.passenger_info_list is not None:
            for k in self.passenger_info_list:
                result['passenger_info_list'].append(k.to_map() if k else None)
        result['price_info_list'] = []
        if self.price_info_list is not None:
            for k in self.price_info_list:
                result['price_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.flight_change_ticket_info_list = []
        if m.get('flight_change_ticket_info_list') is not None:
            for k in m.get('flight_change_ticket_info_list'):
                temp_model = FlightOrderQueryResponseBodyModuleFlightChangeTicketInfoList()
                self.flight_change_ticket_info_list.append(temp_model.from_map(k))
        self.flight_info_list = []
        if m.get('flight_info_list') is not None:
            for k in m.get('flight_info_list'):
                temp_model = FlightOrderQueryResponseBodyModuleFlightInfoList()
                self.flight_info_list.append(temp_model.from_map(k))
        self.flight_refund_ticket_info_list = []
        if m.get('flight_refund_ticket_info_list') is not None:
            for k in m.get('flight_refund_ticket_info_list'):
                temp_model = FlightOrderQueryResponseBodyModuleFlightRefundTicketInfoList()
                self.flight_refund_ticket_info_list.append(temp_model.from_map(k))
        self.flight_ticket_info_list = []
        if m.get('flight_ticket_info_list') is not None:
            for k in m.get('flight_ticket_info_list'):
                temp_model = FlightOrderQueryResponseBodyModuleFlightTicketInfoList()
                self.flight_ticket_info_list.append(temp_model.from_map(k))
        self.insurance_info_list = []
        if m.get('insurance_info_list') is not None:
            for k in m.get('insurance_info_list'):
                temp_model = FlightOrderQueryResponseBodyModuleInsuranceInfoList()
                self.insurance_info_list.append(temp_model.from_map(k))
        if m.get('invoice_info') is not None:
            temp_model = FlightOrderQueryResponseBodyModuleInvoiceInfo()
            self.invoice_info = temp_model.from_map(m['invoice_info'])
        if m.get('order_base_info') is not None:
            temp_model = FlightOrderQueryResponseBodyModuleOrderBaseInfo()
            self.order_base_info = temp_model.from_map(m['order_base_info'])
        self.passenger_info_list = []
        if m.get('passenger_info_list') is not None:
            for k in m.get('passenger_info_list'):
                temp_model = FlightOrderQueryResponseBodyModulePassengerInfoList()
                self.passenger_info_list.append(temp_model.from_map(k))
        self.price_info_list = []
        if m.get('price_info_list') is not None:
            for k in m.get('price_info_list'):
                temp_model = FlightOrderQueryResponseBodyModulePriceInfoList()
                self.price_info_list.append(temp_model.from_map(k))
        return self


class FlightOrderQueryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightOrderQueryResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightOrderQueryResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightOrderQueryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightOrderQueryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightOrderQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightOtaSearchHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightOtaSearchRequest(TeaModel):
    def __init__(
        self,
        airline_code: str = None,
        arr_city_code: str = None,
        cabin_class: str = None,
        carrier_flight_no: str = None,
        dep_city_code: str = None,
        dep_date: str = None,
        flight_no: str = None,
    ):
        self.airline_code = airline_code
        self.arr_city_code = arr_city_code
        self.cabin_class = cabin_class
        self.carrier_flight_no = carrier_flight_no
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date
        self.flight_no = flight_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.carrier_flight_no is not None:
            result['carrier_flight_no'] = self.carrier_flight_no
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('carrier_flight_no') is not None:
            self.carrier_flight_no = m.get('carrier_flight_no')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        return self


class FlightOtaSearchResponseBodyModuleFlightListAirlineInfo(TeaModel):
    def __init__(
        self,
        airline_code: str = None,
        airline_name: str = None,
        airline_simple_name: str = None,
    ):
        self.airline_code = airline_code
        self.airline_name = airline_name
        self.airline_simple_name = airline_simple_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.airline_name is not None:
            result['airline_name'] = self.airline_name
        if self.airline_simple_name is not None:
            result['airline_simple_name'] = self.airline_simple_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('airline_name') is not None:
            self.airline_name = m.get('airline_name')
        if m.get('airline_simple_name') is not None:
            self.airline_simple_name = m.get('airline_simple_name')
        return self


class FlightOtaSearchResponseBodyModuleFlightListArrAirportInfo(TeaModel):
    def __init__(
        self,
        airport_code: str = None,
        airport_name: str = None,
        city_code: str = None,
        city_name: str = None,
        terminal: str = None,
    ):
        self.airport_code = airport_code
        self.airport_name = airport_name
        self.city_code = city_code
        self.city_name = city_name
        self.terminal = terminal

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription(TeaModel):
    def __init__(
        self,
        desc: str = None,
        icon: str = None,
        image: str = None,
        title: str = None,
    ):
        self.desc = desc
        self.icon = icon
        self.image = image
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['desc'] = self.desc
        if self.icon is not None:
            result['icon'] = self.icon
        if self.image is not None:
            result['image'] = self.image
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO(TeaModel):
    def __init__(
        self,
        image: str = None,
        largest: str = None,
        middle: str = None,
        smallest: str = None,
    ):
        self.image = image
        self.largest = largest
        self.middle = middle
        self.smallest = smallest

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image is not None:
            result['image'] = self.image
        if self.largest is not None:
            result['largest'] = self.largest
        if self.middle is not None:
            result['middle'] = self.middle
        if self.smallest is not None:
            result['smallest'] = self.smallest
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('largest') is not None:
            self.largest = m.get('largest')
        if m.get('middle') is not None:
            self.middle = m.get('middle')
        if m.get('smallest') is not None:
            self.smallest = m.get('smallest')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes(TeaModel):
    def __init__(
        self,
        baggage_desc: List[str] = None,
        baggage_sub_content_type: int = None,
        description: FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription = None,
        image_do: FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO = None,
        is_highlight: bool = None,
        sub_title: str = None,
    ):
        self.baggage_desc = baggage_desc
        self.baggage_sub_content_type = baggage_sub_content_type
        self.description = description
        self.image_do = image_do
        self.is_highlight = is_highlight
        self.sub_title = sub_title

    def validate(self):
        if self.description:
            self.description.validate()
        if self.image_do:
            self.image_do.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        if self.baggage_sub_content_type is not None:
            result['baggage_sub_content_type'] = self.baggage_sub_content_type
        if self.description is not None:
            result['description'] = self.description.to_map()
        if self.image_do is not None:
            result['image_d_o'] = self.image_do.to_map()
        if self.is_highlight is not None:
            result['is_highlight'] = self.is_highlight
        if self.sub_title is not None:
            result['sub_title'] = self.sub_title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        if m.get('baggage_sub_content_type') is not None:
            self.baggage_sub_content_type = m.get('baggage_sub_content_type')
        if m.get('description') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription()
            self.description = temp_model.from_map(m['description'])
        if m.get('image_d_o') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO()
            self.image_do = temp_model.from_map(m['image_d_o'])
        if m.get('is_highlight') is not None:
            self.is_highlight = m.get('is_highlight')
        if m.get('sub_title') is not None:
            self.sub_title = m.get('sub_title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItems(TeaModel):
    def __init__(
        self,
        baggage_sub_content_visualizes: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes] = None,
        extra_content_visualizes: List[Any] = None,
        is_struct: bool = None,
        ptc: str = None,
        title: str = None,
    ):
        self.baggage_sub_content_visualizes = baggage_sub_content_visualizes
        self.extra_content_visualizes = extra_content_visualizes
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.title = title

    def validate(self):
        if self.baggage_sub_content_visualizes:
            for k in self.baggage_sub_content_visualizes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_content_visualizes'] = []
        if self.baggage_sub_content_visualizes is not None:
            for k in self.baggage_sub_content_visualizes:
                result['baggage_sub_content_visualizes'].append(k.to_map() if k else None)
        if self.extra_content_visualizes is not None:
            result['extra_content_visualizes'] = self.extra_content_visualizes
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_content_visualizes = []
        if m.get('baggage_sub_content_visualizes') is not None:
            for k in m.get('baggage_sub_content_visualizes'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes()
                self.baggage_sub_content_visualizes.append(temp_model.from_map(k))
        if m.get('extra_content_visualizes') is not None:
            self.extra_content_visualizes = m.get('extra_content_visualizes')
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemTips(TeaModel):
    def __init__(
        self,
        logo: str = None,
        tips_desc: str = None,
        tips_image: str = None,
    ):
        self.logo = logo
        self.tips_desc = tips_desc
        self.tips_image = tips_image

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['logo'] = self.logo
        if self.tips_desc is not None:
            result['tips_desc'] = self.tips_desc
        if self.tips_image is not None:
            result['tips_image'] = self.tips_image
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('logo') is not None:
            self.logo = m.get('logo')
        if m.get('tips_desc') is not None:
            self.tips_desc = m.get('tips_desc')
        if m.get('tips_image') is not None:
            self.tips_image = m.get('tips_image')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItem(TeaModel):
    def __init__(
        self,
        baggage_sub_items: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItems] = None,
        index: int = None,
        table_head: str = None,
        tips: FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemTips = None,
        title: str = None,
        type: int = None,
    ):
        self.baggage_sub_items = baggage_sub_items
        self.index = index
        self.table_head = table_head
        self.tips = tips
        self.title = title
        self.type = type

    def validate(self):
        if self.baggage_sub_items:
            for k in self.baggage_sub_items:
                if k:
                    k.validate()
        if self.tips:
            self.tips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_items'] = []
        if self.baggage_sub_items is not None:
            for k in self.baggage_sub_items:
                result['baggage_sub_items'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.tips is not None:
            result['tips'] = self.tips.to_map()
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_items = []
        if m.get('baggage_sub_items') is not None:
            for k in m.get('baggage_sub_items'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItems()
                self.baggage_sub_items.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('tips') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemTips()
            self.tips = temp_model.from_map(m['tips'])
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemExtraContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        title: str = None,
    ):
        self.content = content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(
        self,
        fee_desc: str = None,
        fee_range: str = None,
        style: int = None,
    ):
        self.fee_desc = fee_desc
        self.fee_range = fee_range
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItems(TeaModel):
    def __init__(
        self,
        is_struct: bool = None,
        ptc: str = None,
        refund_sub_contents: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents] = None,
        title: str = None,
    ):
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.refund_sub_contents = refund_sub_contents
        self.title = title

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItem(TeaModel):
    def __init__(
        self,
        extra_contents: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemExtraContents] = None,
        index: int = None,
        refund_sub_items: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItems] = None,
        sub_table_head: List[str] = None,
        table_head: str = None,
        title: str = None,
        type: int = None,
    ):
        self.extra_contents = extra_contents
        self.index = index
        self.refund_sub_items = refund_sub_items
        self.sub_table_head = sub_table_head
        self.table_head = table_head
        self.title = title
        self.type = type

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemExtraContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        title: str = None,
    ):
        self.content = content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(
        self,
        fee_desc: str = None,
        fee_range: str = None,
        style: int = None,
    ):
        self.fee_desc = fee_desc
        self.fee_range = fee_range
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItems(TeaModel):
    def __init__(
        self,
        is_struct: bool = None,
        ptc: str = None,
        refund_sub_contents: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents] = None,
        title: str = None,
    ):
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.refund_sub_contents = refund_sub_contents
        self.title = title

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItem(TeaModel):
    def __init__(
        self,
        extra_contents: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemExtraContents] = None,
        index: int = None,
        refund_sub_items: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItems] = None,
        sub_table_head: List[str] = None,
        table_head: str = None,
        title: str = None,
        type: int = None,
    ):
        self.extra_contents = extra_contents
        self.index = index
        self.refund_sub_items = refund_sub_items
        self.sub_table_head = sub_table_head
        self.table_head = table_head
        self.title = title
        self.type = type

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleList(TeaModel):
    def __init__(
        self,
        baggage_info: str = None,
        baggage_item: FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItem = None,
        change_rule: FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRule = None,
        change_rule_item: FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItem = None,
        extra: str = None,
        refund_rule: FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRule = None,
        refund_rule_item: FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItem = None,
        sign_rule: FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRule = None,
        tuigaiqian_info: str = None,
        upgrade_rule: FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRule = None,
    ):
        self.baggage_info = baggage_info
        self.baggage_item = baggage_item
        self.change_rule = change_rule
        self.change_rule_item = change_rule_item
        self.extra = extra
        self.refund_rule = refund_rule
        self.refund_rule_item = refund_rule_item
        self.sign_rule = sign_rule
        self.tuigaiqian_info = tuigaiqian_info
        self.upgrade_rule = upgrade_rule

    def validate(self):
        if self.baggage_item:
            self.baggage_item.validate()
        if self.change_rule:
            self.change_rule.validate()
        if self.change_rule_item:
            self.change_rule_item.validate()
        if self.refund_rule:
            self.refund_rule.validate()
        if self.refund_rule_item:
            self.refund_rule_item.validate()
        if self.sign_rule:
            self.sign_rule.validate()
        if self.upgrade_rule:
            self.upgrade_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_info is not None:
            result['baggage_info'] = self.baggage_info
        if self.baggage_item is not None:
            result['baggage_item'] = self.baggage_item.to_map()
        if self.change_rule is not None:
            result['change_rule'] = self.change_rule.to_map()
        if self.change_rule_item is not None:
            result['change_rule_item'] = self.change_rule_item.to_map()
        if self.extra is not None:
            result['extra'] = self.extra
        if self.refund_rule is not None:
            result['refund_rule'] = self.refund_rule.to_map()
        if self.refund_rule_item is not None:
            result['refund_rule_item'] = self.refund_rule_item.to_map()
        if self.sign_rule is not None:
            result['sign_rule'] = self.sign_rule.to_map()
        if self.tuigaiqian_info is not None:
            result['tuigaiqian_info'] = self.tuigaiqian_info
        if self.upgrade_rule is not None:
            result['upgrade_rule'] = self.upgrade_rule.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('baggage_info') is not None:
            self.baggage_info = m.get('baggage_info')
        if m.get('baggage_item') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItem()
            self.baggage_item = temp_model.from_map(m['baggage_item'])
        if m.get('change_rule') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRule()
            self.change_rule = temp_model.from_map(m['change_rule'])
        if m.get('change_rule_item') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItem()
            self.change_rule_item = temp_model.from_map(m['change_rule_item'])
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('refund_rule') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRule()
            self.refund_rule = temp_model.from_map(m['refund_rule'])
        if m.get('refund_rule_item') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItem()
            self.refund_rule_item = temp_model.from_map(m['refund_rule_item'])
        if m.get('sign_rule') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRule()
            self.sign_rule = temp_model.from_map(m['sign_rule'])
        if m.get('tuigaiqian_info') is not None:
            self.tuigaiqian_info = m.get('tuigaiqian_info')
        if m.get('upgrade_rule') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRule()
            self.upgrade_rule = temp_model.from_map(m['upgrade_rule'])
        return self


class FlightOtaSearchResponseBodyModuleFlightListCabinInfoList(TeaModel):
    def __init__(
        self,
        agent_id: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        child_cabin: str = None,
        class_name: str = None,
        class_rule: str = None,
        discount: str = None,
        flight_rule_list: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleList] = None,
        flight_rule_list_str: str = None,
        invoice_type: int = None,
        is_protocol: bool = None,
        oil_price: int = None,
        order_params: str = None,
        ota_item_id: str = None,
        price: int = None,
        product_type: int = None,
        product_type_desc: str = None,
        promotion_price: str = None,
        remained_seat_count: str = None,
        ticket_price: int = None,
        total_price: int = None,
    ):
        self.agent_id = agent_id
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.child_cabin = child_cabin
        self.class_name = class_name
        self.class_rule = class_rule
        self.discount = discount
        self.flight_rule_list = flight_rule_list
        self.flight_rule_list_str = flight_rule_list_str
        self.invoice_type = invoice_type
        self.is_protocol = is_protocol
        self.oil_price = oil_price
        self.order_params = order_params
        self.ota_item_id = ota_item_id
        self.price = price
        self.product_type = product_type
        self.product_type_desc = product_type_desc
        self.promotion_price = promotion_price
        self.remained_seat_count = remained_seat_count
        self.ticket_price = ticket_price
        self.total_price = total_price

    def validate(self):
        if self.flight_rule_list:
            for k in self.flight_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['agent_id'] = self.agent_id
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.child_cabin is not None:
            result['child_cabin'] = self.child_cabin
        if self.class_name is not None:
            result['class_name'] = self.class_name
        if self.class_rule is not None:
            result['class_rule'] = self.class_rule
        if self.discount is not None:
            result['discount'] = self.discount
        result['flight_rule_list'] = []
        if self.flight_rule_list is not None:
            for k in self.flight_rule_list:
                result['flight_rule_list'].append(k.to_map() if k else None)
        if self.flight_rule_list_str is not None:
            result['flight_rule_list_str'] = self.flight_rule_list_str
        if self.invoice_type is not None:
            result['invoice_type'] = self.invoice_type
        if self.is_protocol is not None:
            result['is_protocol'] = self.is_protocol
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.order_params is not None:
            result['order_params'] = self.order_params
        if self.ota_item_id is not None:
            result['ota_item_id'] = self.ota_item_id
        if self.price is not None:
            result['price'] = self.price
        if self.product_type is not None:
            result['product_type'] = self.product_type
        if self.product_type_desc is not None:
            result['product_type_desc'] = self.product_type_desc
        if self.promotion_price is not None:
            result['promotion_price'] = self.promotion_price
        if self.remained_seat_count is not None:
            result['remained_seat_count'] = self.remained_seat_count
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.total_price is not None:
            result['total_price'] = self.total_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('agent_id') is not None:
            self.agent_id = m.get('agent_id')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('child_cabin') is not None:
            self.child_cabin = m.get('child_cabin')
        if m.get('class_name') is not None:
            self.class_name = m.get('class_name')
        if m.get('class_rule') is not None:
            self.class_rule = m.get('class_rule')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        self.flight_rule_list = []
        if m.get('flight_rule_list') is not None:
            for k in m.get('flight_rule_list'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoListFlightRuleList()
                self.flight_rule_list.append(temp_model.from_map(k))
        if m.get('flight_rule_list_str') is not None:
            self.flight_rule_list_str = m.get('flight_rule_list_str')
        if m.get('invoice_type') is not None:
            self.invoice_type = m.get('invoice_type')
        if m.get('is_protocol') is not None:
            self.is_protocol = m.get('is_protocol')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('order_params') is not None:
            self.order_params = m.get('order_params')
        if m.get('ota_item_id') is not None:
            self.ota_item_id = m.get('ota_item_id')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('product_type') is not None:
            self.product_type = m.get('product_type')
        if m.get('product_type_desc') is not None:
            self.product_type_desc = m.get('product_type_desc')
        if m.get('promotion_price') is not None:
            self.promotion_price = m.get('promotion_price')
        if m.get('remained_seat_count') is not None:
            self.remained_seat_count = m.get('remained_seat_count')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('total_price') is not None:
            self.total_price = m.get('total_price')
        return self


class FlightOtaSearchResponseBodyModuleFlightListDepAirportInfo(TeaModel):
    def __init__(
        self,
        airport_code: str = None,
        airport_name: str = None,
        city_code: str = None,
        city_name: str = None,
        terminal: str = None,
    ):
        self.airport_code = airport_code
        self.airport_name = airport_name
        self.city_code = city_code
        self.city_name = city_name
        self.terminal = terminal

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription(TeaModel):
    def __init__(
        self,
        desc: str = None,
        icon: str = None,
        image: str = None,
        title: str = None,
    ):
        self.desc = desc
        self.icon = icon
        self.image = image
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['desc'] = self.desc
        if self.icon is not None:
            result['icon'] = self.icon
        if self.image is not None:
            result['image'] = self.image
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO(TeaModel):
    def __init__(
        self,
        image: str = None,
        largest: str = None,
        middle: str = None,
        smallest: str = None,
    ):
        self.image = image
        self.largest = largest
        self.middle = middle
        self.smallest = smallest

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image is not None:
            result['image'] = self.image
        if self.largest is not None:
            result['largest'] = self.largest
        if self.middle is not None:
            result['middle'] = self.middle
        if self.smallest is not None:
            result['smallest'] = self.smallest
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('largest') is not None:
            self.largest = m.get('largest')
        if m.get('middle') is not None:
            self.middle = m.get('middle')
        if m.get('smallest') is not None:
            self.smallest = m.get('smallest')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes(TeaModel):
    def __init__(
        self,
        baggage_desc: List[str] = None,
        baggage_sub_content_type: int = None,
        description: FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription = None,
        image_do: FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO = None,
        is_highlight: bool = None,
        sub_title: str = None,
    ):
        self.baggage_desc = baggage_desc
        self.baggage_sub_content_type = baggage_sub_content_type
        self.description = description
        self.image_do = image_do
        self.is_highlight = is_highlight
        self.sub_title = sub_title

    def validate(self):
        if self.description:
            self.description.validate()
        if self.image_do:
            self.image_do.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        if self.baggage_sub_content_type is not None:
            result['baggage_sub_content_type'] = self.baggage_sub_content_type
        if self.description is not None:
            result['description'] = self.description.to_map()
        if self.image_do is not None:
            result['image_d_o'] = self.image_do.to_map()
        if self.is_highlight is not None:
            result['is_highlight'] = self.is_highlight
        if self.sub_title is not None:
            result['sub_title'] = self.sub_title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        if m.get('baggage_sub_content_type') is not None:
            self.baggage_sub_content_type = m.get('baggage_sub_content_type')
        if m.get('description') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription()
            self.description = temp_model.from_map(m['description'])
        if m.get('image_d_o') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO()
            self.image_do = temp_model.from_map(m['image_d_o'])
        if m.get('is_highlight') is not None:
            self.is_highlight = m.get('is_highlight')
        if m.get('sub_title') is not None:
            self.sub_title = m.get('sub_title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems(TeaModel):
    def __init__(
        self,
        baggage_sub_content_visualizes: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes] = None,
        extra_content_visualizes: List[Any] = None,
        is_struct: bool = None,
        ptc: str = None,
        title: str = None,
    ):
        self.baggage_sub_content_visualizes = baggage_sub_content_visualizes
        self.extra_content_visualizes = extra_content_visualizes
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.title = title

    def validate(self):
        if self.baggage_sub_content_visualizes:
            for k in self.baggage_sub_content_visualizes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_content_visualizes'] = []
        if self.baggage_sub_content_visualizes is not None:
            for k in self.baggage_sub_content_visualizes:
                result['baggage_sub_content_visualizes'].append(k.to_map() if k else None)
        if self.extra_content_visualizes is not None:
            result['extra_content_visualizes'] = self.extra_content_visualizes
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_content_visualizes = []
        if m.get('baggage_sub_content_visualizes') is not None:
            for k in m.get('baggage_sub_content_visualizes'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes()
                self.baggage_sub_content_visualizes.append(temp_model.from_map(k))
        if m.get('extra_content_visualizes') is not None:
            self.extra_content_visualizes = m.get('extra_content_visualizes')
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemTips(TeaModel):
    def __init__(
        self,
        logo: str = None,
        tips_desc: str = None,
        tips_image: str = None,
    ):
        self.logo = logo
        self.tips_desc = tips_desc
        self.tips_image = tips_image

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['logo'] = self.logo
        if self.tips_desc is not None:
            result['tips_desc'] = self.tips_desc
        if self.tips_image is not None:
            result['tips_image'] = self.tips_image
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('logo') is not None:
            self.logo = m.get('logo')
        if m.get('tips_desc') is not None:
            self.tips_desc = m.get('tips_desc')
        if m.get('tips_image') is not None:
            self.tips_image = m.get('tips_image')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItem(TeaModel):
    def __init__(
        self,
        baggage_sub_items: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems] = None,
        index: int = None,
        table_head: str = None,
        tips: FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemTips = None,
        title: str = None,
        type: int = None,
    ):
        self.baggage_sub_items = baggage_sub_items
        self.index = index
        self.table_head = table_head
        self.tips = tips
        self.title = title
        self.type = type

    def validate(self):
        if self.baggage_sub_items:
            for k in self.baggage_sub_items:
                if k:
                    k.validate()
        if self.tips:
            self.tips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_items'] = []
        if self.baggage_sub_items is not None:
            for k in self.baggage_sub_items:
                result['baggage_sub_items'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.tips is not None:
            result['tips'] = self.tips.to_map()
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_items = []
        if m.get('baggage_sub_items') is not None:
            for k in m.get('baggage_sub_items'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems()
                self.baggage_sub_items.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('tips') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItemTips()
            self.tips = temp_model.from_map(m['tips'])
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        title: str = None,
    ):
        self.content = content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(
        self,
        fee_desc: str = None,
        fee_range: str = None,
        style: int = None,
    ):
        self.fee_desc = fee_desc
        self.fee_range = fee_range
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems(TeaModel):
    def __init__(
        self,
        is_struct: bool = None,
        ptc: str = None,
        refund_sub_contents: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents] = None,
        title: str = None,
    ):
        # isStruct : true
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.refund_sub_contents = refund_sub_contents
        self.title = title

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItem(TeaModel):
    def __init__(
        self,
        extra_contents: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents] = None,
        index: int = None,
        refund_sub_items: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems] = None,
        sub_table_head: List[str] = None,
        table_head: str = None,
        title: str = None,
        type: int = None,
    ):
        self.extra_contents = extra_contents
        self.index = index
        self.refund_sub_items = refund_sub_items
        self.sub_table_head = sub_table_head
        self.table_head = table_head
        self.title = title
        self.type = type

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        title: str = None,
    ):
        self.content = content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(
        self,
        fee_desc: str = None,
        fee_range: str = None,
        style: int = None,
    ):
        self.fee_desc = fee_desc
        self.fee_range = fee_range
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems(TeaModel):
    def __init__(
        self,
        is_struct: bool = None,
        ptc: str = None,
        refund_sub_contents: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents] = None,
        title: str = None,
    ):
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.refund_sub_contents = refund_sub_contents
        self.title = title

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItem(TeaModel):
    def __init__(
        self,
        extra_contents: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents] = None,
        index: int = None,
        refund_sub_items: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems] = None,
        sub_table_head: List[str] = None,
        table_head: str = None,
        title: str = None,
        type: int = None,
    ):
        self.extra_contents = extra_contents
        self.index = index
        self.refund_sub_items = refund_sub_items
        self.sub_table_head = sub_table_head
        self.table_head = table_head
        self.title = title
        self.type = type

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListSignRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListSignRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListSignRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListSignRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleListUpgradeRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightOtaSearchResponseBodyModuleFlightListFlightRuleList(TeaModel):
    def __init__(
        self,
        baggage_info: str = None,
        baggage_item: FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItem = None,
        change_rule: FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRule = None,
        change_rule_item: FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItem = None,
        extra: str = None,
        refund_rule: FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRule = None,
        refund_rule_item: FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItem = None,
        sign_rule: FlightOtaSearchResponseBodyModuleFlightListFlightRuleListSignRule = None,
        tuigaiqian_info: str = None,
        upgrade_rule: FlightOtaSearchResponseBodyModuleFlightListFlightRuleListUpgradeRule = None,
    ):
        self.baggage_info = baggage_info
        self.baggage_item = baggage_item
        self.change_rule = change_rule
        self.change_rule_item = change_rule_item
        self.extra = extra
        self.refund_rule = refund_rule
        self.refund_rule_item = refund_rule_item
        self.sign_rule = sign_rule
        self.tuigaiqian_info = tuigaiqian_info
        self.upgrade_rule = upgrade_rule

    def validate(self):
        if self.baggage_item:
            self.baggage_item.validate()
        if self.change_rule:
            self.change_rule.validate()
        if self.change_rule_item:
            self.change_rule_item.validate()
        if self.refund_rule:
            self.refund_rule.validate()
        if self.refund_rule_item:
            self.refund_rule_item.validate()
        if self.sign_rule:
            self.sign_rule.validate()
        if self.upgrade_rule:
            self.upgrade_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_info is not None:
            result['baggage_info'] = self.baggage_info
        if self.baggage_item is not None:
            result['baggage_item'] = self.baggage_item.to_map()
        if self.change_rule is not None:
            result['change_rule'] = self.change_rule.to_map()
        if self.change_rule_item is not None:
            result['change_rule_item'] = self.change_rule_item.to_map()
        if self.extra is not None:
            result['extra'] = self.extra
        if self.refund_rule is not None:
            result['refund_rule'] = self.refund_rule.to_map()
        if self.refund_rule_item is not None:
            result['refund_rule_item'] = self.refund_rule_item.to_map()
        if self.sign_rule is not None:
            result['sign_rule'] = self.sign_rule.to_map()
        if self.tuigaiqian_info is not None:
            result['tuigaiqian_info'] = self.tuigaiqian_info
        if self.upgrade_rule is not None:
            result['upgrade_rule'] = self.upgrade_rule.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('baggage_info') is not None:
            self.baggage_info = m.get('baggage_info')
        if m.get('baggage_item') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListBaggageItem()
            self.baggage_item = temp_model.from_map(m['baggage_item'])
        if m.get('change_rule') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRule()
            self.change_rule = temp_model.from_map(m['change_rule'])
        if m.get('change_rule_item') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListChangeRuleItem()
            self.change_rule_item = temp_model.from_map(m['change_rule_item'])
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('refund_rule') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRule()
            self.refund_rule = temp_model.from_map(m['refund_rule'])
        if m.get('refund_rule_item') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListRefundRuleItem()
            self.refund_rule_item = temp_model.from_map(m['refund_rule_item'])
        if m.get('sign_rule') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListSignRule()
            self.sign_rule = temp_model.from_map(m['sign_rule'])
        if m.get('tuigaiqian_info') is not None:
            self.tuigaiqian_info = m.get('tuigaiqian_info')
        if m.get('upgrade_rule') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleListUpgradeRule()
            self.upgrade_rule = temp_model.from_map(m['upgrade_rule'])
        return self


class FlightOtaSearchResponseBodyModuleFlightList(TeaModel):
    def __init__(
        self,
        airline_info: FlightOtaSearchResponseBodyModuleFlightListAirlineInfo = None,
        arr_airport_info: FlightOtaSearchResponseBodyModuleFlightListArrAirportInfo = None,
        arr_date: str = None,
        build_price: int = None,
        cabin: str = None,
        cabin_class: str = None,
        cabin_info_list: List[FlightOtaSearchResponseBodyModuleFlightListCabinInfoList] = None,
        carrier_airline: str = None,
        carrier_no: str = None,
        dep_airport_info: FlightOtaSearchResponseBodyModuleFlightListDepAirportInfo = None,
        dep_city_code: str = None,
        dep_date: str = None,
        discount: int = None,
        flight_no: str = None,
        flight_rule_list: List[FlightOtaSearchResponseBodyModuleFlightListFlightRuleList] = None,
        flight_rule_list_str: str = None,
        flight_size: str = None,
        flight_type: str = None,
        invoice_type: int = None,
        is_protocol: bool = None,
        is_share: bool = None,
        is_stop: bool = None,
        is_transfer: bool = None,
        meal_desc: str = None,
        oil_price: int = None,
        ota_item_id: str = None,
        price: int = None,
        product_type: int = None,
        product_type_desc: str = None,
        promotion_price: str = None,
        remained_seat_count: str = None,
        secret_params: str = None,
        segment_number: str = None,
        stop_arr_time: str = None,
        stop_city: str = None,
        stop_dep_time: str = None,
        ticket_price: int = None,
        total_price: str = None,
        trip_type: int = None,
    ):
        self.airline_info = airline_info
        self.arr_airport_info = arr_airport_info
        self.arr_date = arr_date
        self.build_price = build_price
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_info_list = cabin_info_list
        self.carrier_airline = carrier_airline
        self.carrier_no = carrier_no
        self.dep_airport_info = dep_airport_info
        self.dep_city_code = dep_city_code
        self.dep_date = dep_date
        self.discount = discount
        self.flight_no = flight_no
        self.flight_rule_list = flight_rule_list
        self.flight_rule_list_str = flight_rule_list_str
        self.flight_size = flight_size
        self.flight_type = flight_type
        self.invoice_type = invoice_type
        self.is_protocol = is_protocol
        self.is_share = is_share
        self.is_stop = is_stop
        self.is_transfer = is_transfer
        self.meal_desc = meal_desc
        self.oil_price = oil_price
        self.ota_item_id = ota_item_id
        self.price = price
        self.product_type = product_type
        self.product_type_desc = product_type_desc
        self.promotion_price = promotion_price
        self.remained_seat_count = remained_seat_count
        self.secret_params = secret_params
        self.segment_number = segment_number
        self.stop_arr_time = stop_arr_time
        self.stop_city = stop_city
        self.stop_dep_time = stop_dep_time
        self.ticket_price = ticket_price
        self.total_price = total_price
        self.trip_type = trip_type

    def validate(self):
        if self.airline_info:
            self.airline_info.validate()
        if self.arr_airport_info:
            self.arr_airport_info.validate()
        if self.cabin_info_list:
            for k in self.cabin_info_list:
                if k:
                    k.validate()
        if self.dep_airport_info:
            self.dep_airport_info.validate()
        if self.flight_rule_list:
            for k in self.flight_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_info is not None:
            result['airline_info'] = self.airline_info.to_map()
        if self.arr_airport_info is not None:
            result['arr_airport_info'] = self.arr_airport_info.to_map()
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        result['cabin_info_list'] = []
        if self.cabin_info_list is not None:
            for k in self.cabin_info_list:
                result['cabin_info_list'].append(k.to_map() if k else None)
        if self.carrier_airline is not None:
            result['carrier_airline'] = self.carrier_airline
        if self.carrier_no is not None:
            result['carrier_no'] = self.carrier_no
        if self.dep_airport_info is not None:
            result['dep_airport_info'] = self.dep_airport_info.to_map()
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.discount is not None:
            result['discount'] = self.discount
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        result['flight_rule_list'] = []
        if self.flight_rule_list is not None:
            for k in self.flight_rule_list:
                result['flight_rule_list'].append(k.to_map() if k else None)
        if self.flight_rule_list_str is not None:
            result['flight_rule_list_str'] = self.flight_rule_list_str
        if self.flight_size is not None:
            result['flight_size'] = self.flight_size
        if self.flight_type is not None:
            result['flight_type'] = self.flight_type
        if self.invoice_type is not None:
            result['invoice_type'] = self.invoice_type
        if self.is_protocol is not None:
            result['is_protocol'] = self.is_protocol
        if self.is_share is not None:
            result['is_share'] = self.is_share
        if self.is_stop is not None:
            result['is_stop'] = self.is_stop
        if self.is_transfer is not None:
            result['is_transfer'] = self.is_transfer
        if self.meal_desc is not None:
            result['meal_desc'] = self.meal_desc
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.ota_item_id is not None:
            result['ota_item_id'] = self.ota_item_id
        if self.price is not None:
            result['price'] = self.price
        if self.product_type is not None:
            result['product_type'] = self.product_type
        if self.product_type_desc is not None:
            result['product_type_desc'] = self.product_type_desc
        if self.promotion_price is not None:
            result['promotion_price'] = self.promotion_price
        if self.remained_seat_count is not None:
            result['remained_seat_count'] = self.remained_seat_count
        if self.secret_params is not None:
            result['secret_params'] = self.secret_params
        if self.segment_number is not None:
            result['segment_number'] = self.segment_number
        if self.stop_arr_time is not None:
            result['stop_arr_time'] = self.stop_arr_time
        if self.stop_city is not None:
            result['stop_city'] = self.stop_city
        if self.stop_dep_time is not None:
            result['stop_dep_time'] = self.stop_dep_time
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.total_price is not None:
            result['total_price'] = self.total_price
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airline_info') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListAirlineInfo()
            self.airline_info = temp_model.from_map(m['airline_info'])
        if m.get('arr_airport_info') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListArrAirportInfo()
            self.arr_airport_info = temp_model.from_map(m['arr_airport_info'])
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        self.cabin_info_list = []
        if m.get('cabin_info_list') is not None:
            for k in m.get('cabin_info_list'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListCabinInfoList()
                self.cabin_info_list.append(temp_model.from_map(k))
        if m.get('carrier_airline') is not None:
            self.carrier_airline = m.get('carrier_airline')
        if m.get('carrier_no') is not None:
            self.carrier_no = m.get('carrier_no')
        if m.get('dep_airport_info') is not None:
            temp_model = FlightOtaSearchResponseBodyModuleFlightListDepAirportInfo()
            self.dep_airport_info = temp_model.from_map(m['dep_airport_info'])
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        self.flight_rule_list = []
        if m.get('flight_rule_list') is not None:
            for k in m.get('flight_rule_list'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightListFlightRuleList()
                self.flight_rule_list.append(temp_model.from_map(k))
        if m.get('flight_rule_list_str') is not None:
            self.flight_rule_list_str = m.get('flight_rule_list_str')
        if m.get('flight_size') is not None:
            self.flight_size = m.get('flight_size')
        if m.get('flight_type') is not None:
            self.flight_type = m.get('flight_type')
        if m.get('invoice_type') is not None:
            self.invoice_type = m.get('invoice_type')
        if m.get('is_protocol') is not None:
            self.is_protocol = m.get('is_protocol')
        if m.get('is_share') is not None:
            self.is_share = m.get('is_share')
        if m.get('is_stop') is not None:
            self.is_stop = m.get('is_stop')
        if m.get('is_transfer') is not None:
            self.is_transfer = m.get('is_transfer')
        if m.get('meal_desc') is not None:
            self.meal_desc = m.get('meal_desc')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('ota_item_id') is not None:
            self.ota_item_id = m.get('ota_item_id')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('product_type') is not None:
            self.product_type = m.get('product_type')
        if m.get('product_type_desc') is not None:
            self.product_type_desc = m.get('product_type_desc')
        if m.get('promotion_price') is not None:
            self.promotion_price = m.get('promotion_price')
        if m.get('remained_seat_count') is not None:
            self.remained_seat_count = m.get('remained_seat_count')
        if m.get('secret_params') is not None:
            self.secret_params = m.get('secret_params')
        if m.get('segment_number') is not None:
            self.segment_number = m.get('segment_number')
        if m.get('stop_arr_time') is not None:
            self.stop_arr_time = m.get('stop_arr_time')
        if m.get('stop_city') is not None:
            self.stop_city = m.get('stop_city')
        if m.get('stop_dep_time') is not None:
            self.stop_dep_time = m.get('stop_dep_time')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('total_price') is not None:
            self.total_price = m.get('total_price')
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        return self


class FlightOtaSearchResponseBodyModule(TeaModel):
    def __init__(
        self,
        flight_list: List[FlightOtaSearchResponseBodyModuleFlightList] = None,
    ):
        self.flight_list = flight_list

    def validate(self):
        if self.flight_list:
            for k in self.flight_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['flight_list'] = []
        if self.flight_list is not None:
            for k in self.flight_list:
                result['flight_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.flight_list = []
        if m.get('flight_list') is not None:
            for k in m.get('flight_list'):
                temp_model = FlightOtaSearchResponseBodyModuleFlightList()
                self.flight_list.append(temp_model.from_map(k))
        return self


class FlightOtaSearchResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightOtaSearchResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightOtaSearchResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightOtaSearchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightOtaSearchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightOtaSearchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightPayOrderHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightPayOrderRequest(TeaModel):
    def __init__(
        self,
        corp_pay_price: int = None,
        dis_order_id: str = None,
        extra: Dict[str, str] = None,
        personal_pay_price: int = None,
        total_pay_price: int = None,
    ):
        self.corp_pay_price = corp_pay_price
        self.dis_order_id = dis_order_id
        self.extra = extra
        self.personal_pay_price = personal_pay_price
        self.total_pay_price = total_pay_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_pay_price is not None:
            result['corp_pay_price'] = self.corp_pay_price
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.extra is not None:
            result['extra'] = self.extra
        if self.personal_pay_price is not None:
            result['personal_pay_price'] = self.personal_pay_price
        if self.total_pay_price is not None:
            result['total_pay_price'] = self.total_pay_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corp_pay_price') is not None:
            self.corp_pay_price = m.get('corp_pay_price')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('personal_pay_price') is not None:
            self.personal_pay_price = m.get('personal_pay_price')
        if m.get('total_pay_price') is not None:
            self.total_pay_price = m.get('total_pay_price')
        return self


class FlightPayOrderShrinkRequest(TeaModel):
    def __init__(
        self,
        corp_pay_price: int = None,
        dis_order_id: str = None,
        extra_shrink: str = None,
        personal_pay_price: int = None,
        total_pay_price: int = None,
    ):
        self.corp_pay_price = corp_pay_price
        self.dis_order_id = dis_order_id
        self.extra_shrink = extra_shrink
        self.personal_pay_price = personal_pay_price
        self.total_pay_price = total_pay_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_pay_price is not None:
            result['corp_pay_price'] = self.corp_pay_price
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.extra_shrink is not None:
            result['extra'] = self.extra_shrink
        if self.personal_pay_price is not None:
            result['personal_pay_price'] = self.personal_pay_price
        if self.total_pay_price is not None:
            result['total_pay_price'] = self.total_pay_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corp_pay_price') is not None:
            self.corp_pay_price = m.get('corp_pay_price')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('extra') is not None:
            self.extra_shrink = m.get('extra')
        if m.get('personal_pay_price') is not None:
            self.personal_pay_price = m.get('personal_pay_price')
        if m.get('total_pay_price') is not None:
            self.total_pay_price = m.get('total_pay_price')
        return self


class FlightPayOrderResponseBodyModule(TeaModel):
    def __init__(
        self,
        actual_pay_price: int = None,
        alipay_trade_no: str = None,
        last_pay_time: str = None,
        pay_status: int = None,
    ):
        self.actual_pay_price = actual_pay_price
        self.alipay_trade_no = alipay_trade_no
        self.last_pay_time = last_pay_time
        self.pay_status = pay_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_pay_price is not None:
            result['actual_pay_price'] = self.actual_pay_price
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.last_pay_time is not None:
            result['last_pay_time'] = self.last_pay_time
        if self.pay_status is not None:
            result['pay_status'] = self.pay_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('actual_pay_price') is not None:
            self.actual_pay_price = m.get('actual_pay_price')
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('last_pay_time') is not None:
            self.last_pay_time = m.get('last_pay_time')
        if m.get('pay_status') is not None:
            self.pay_status = m.get('pay_status')
        return self


class FlightPayOrderResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightPayOrderResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightPayOrderResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightPayOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightPayOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightPayOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightRefundApplyHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightRefundApplyRequestPassengerSegmentInfoList(TeaModel):
    def __init__(
        self,
        flight_no: str = None,
        passenger_name: str = None,
        user_id: str = None,
    ):
        self.flight_no = flight_no
        self.passenger_name = passenger_name
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightRefundApplyRequest(TeaModel):
    def __init__(
        self,
        corp_refund_price: int = None,
        dis_order_id: str = None,
        dis_sub_order_id: str = None,
        display_refund_money: str = None,
        extra: Dict[str, str] = None,
        is_voluntary: int = None,
        item_unit_ids: str = None,
        passenger_segment_info_list: List[FlightRefundApplyRequestPassengerSegmentInfoList] = None,
        personal_refund_price: int = None,
        reason_detail: str = None,
        reason_type: int = None,
        refund_voucher_info: List[str] = None,
        session_id: str = None,
        total_refund_price: int = None,
    ):
        self.corp_refund_price = corp_refund_price
        self.dis_order_id = dis_order_id
        self.dis_sub_order_id = dis_sub_order_id
        self.display_refund_money = display_refund_money
        self.extra = extra
        self.is_voluntary = is_voluntary
        self.item_unit_ids = item_unit_ids
        self.passenger_segment_info_list = passenger_segment_info_list
        self.personal_refund_price = personal_refund_price
        self.reason_detail = reason_detail
        self.reason_type = reason_type
        self.refund_voucher_info = refund_voucher_info
        self.session_id = session_id
        self.total_refund_price = total_refund_price

    def validate(self):
        if self.passenger_segment_info_list:
            for k in self.passenger_segment_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_refund_price is not None:
            result['corp_refund_price'] = self.corp_refund_price
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.dis_sub_order_id is not None:
            result['dis_sub_order_id'] = self.dis_sub_order_id
        if self.display_refund_money is not None:
            result['display_refund_money'] = self.display_refund_money
        if self.extra is not None:
            result['extra'] = self.extra
        if self.is_voluntary is not None:
            result['is_voluntary'] = self.is_voluntary
        if self.item_unit_ids is not None:
            result['item_unit_ids'] = self.item_unit_ids
        result['passenger_segment_info_list'] = []
        if self.passenger_segment_info_list is not None:
            for k in self.passenger_segment_info_list:
                result['passenger_segment_info_list'].append(k.to_map() if k else None)
        if self.personal_refund_price is not None:
            result['personal_refund_price'] = self.personal_refund_price
        if self.reason_detail is not None:
            result['reason_detail'] = self.reason_detail
        if self.reason_type is not None:
            result['reason_type'] = self.reason_type
        if self.refund_voucher_info is not None:
            result['refund_voucher_info'] = self.refund_voucher_info
        if self.session_id is not None:
            result['session_id'] = self.session_id
        if self.total_refund_price is not None:
            result['total_refund_price'] = self.total_refund_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corp_refund_price') is not None:
            self.corp_refund_price = m.get('corp_refund_price')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('dis_sub_order_id') is not None:
            self.dis_sub_order_id = m.get('dis_sub_order_id')
        if m.get('display_refund_money') is not None:
            self.display_refund_money = m.get('display_refund_money')
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('is_voluntary') is not None:
            self.is_voluntary = m.get('is_voluntary')
        if m.get('item_unit_ids') is not None:
            self.item_unit_ids = m.get('item_unit_ids')
        self.passenger_segment_info_list = []
        if m.get('passenger_segment_info_list') is not None:
            for k in m.get('passenger_segment_info_list'):
                temp_model = FlightRefundApplyRequestPassengerSegmentInfoList()
                self.passenger_segment_info_list.append(temp_model.from_map(k))
        if m.get('personal_refund_price') is not None:
            self.personal_refund_price = m.get('personal_refund_price')
        if m.get('reason_detail') is not None:
            self.reason_detail = m.get('reason_detail')
        if m.get('reason_type') is not None:
            self.reason_type = m.get('reason_type')
        if m.get('refund_voucher_info') is not None:
            self.refund_voucher_info = m.get('refund_voucher_info')
        if m.get('session_id') is not None:
            self.session_id = m.get('session_id')
        if m.get('total_refund_price') is not None:
            self.total_refund_price = m.get('total_refund_price')
        return self


class FlightRefundApplyShrinkRequest(TeaModel):
    def __init__(
        self,
        corp_refund_price: int = None,
        dis_order_id: str = None,
        dis_sub_order_id: str = None,
        display_refund_money: str = None,
        extra_shrink: str = None,
        is_voluntary: int = None,
        item_unit_ids: str = None,
        passenger_segment_info_list_shrink: str = None,
        personal_refund_price: int = None,
        reason_detail: str = None,
        reason_type: int = None,
        refund_voucher_info_shrink: str = None,
        session_id: str = None,
        total_refund_price: int = None,
    ):
        self.corp_refund_price = corp_refund_price
        self.dis_order_id = dis_order_id
        self.dis_sub_order_id = dis_sub_order_id
        self.display_refund_money = display_refund_money
        self.extra_shrink = extra_shrink
        self.is_voluntary = is_voluntary
        self.item_unit_ids = item_unit_ids
        self.passenger_segment_info_list_shrink = passenger_segment_info_list_shrink
        self.personal_refund_price = personal_refund_price
        self.reason_detail = reason_detail
        self.reason_type = reason_type
        self.refund_voucher_info_shrink = refund_voucher_info_shrink
        self.session_id = session_id
        self.total_refund_price = total_refund_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.corp_refund_price is not None:
            result['corp_refund_price'] = self.corp_refund_price
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.dis_sub_order_id is not None:
            result['dis_sub_order_id'] = self.dis_sub_order_id
        if self.display_refund_money is not None:
            result['display_refund_money'] = self.display_refund_money
        if self.extra_shrink is not None:
            result['extra'] = self.extra_shrink
        if self.is_voluntary is not None:
            result['is_voluntary'] = self.is_voluntary
        if self.item_unit_ids is not None:
            result['item_unit_ids'] = self.item_unit_ids
        if self.passenger_segment_info_list_shrink is not None:
            result['passenger_segment_info_list'] = self.passenger_segment_info_list_shrink
        if self.personal_refund_price is not None:
            result['personal_refund_price'] = self.personal_refund_price
        if self.reason_detail is not None:
            result['reason_detail'] = self.reason_detail
        if self.reason_type is not None:
            result['reason_type'] = self.reason_type
        if self.refund_voucher_info_shrink is not None:
            result['refund_voucher_info'] = self.refund_voucher_info_shrink
        if self.session_id is not None:
            result['session_id'] = self.session_id
        if self.total_refund_price is not None:
            result['total_refund_price'] = self.total_refund_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('corp_refund_price') is not None:
            self.corp_refund_price = m.get('corp_refund_price')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('dis_sub_order_id') is not None:
            self.dis_sub_order_id = m.get('dis_sub_order_id')
        if m.get('display_refund_money') is not None:
            self.display_refund_money = m.get('display_refund_money')
        if m.get('extra') is not None:
            self.extra_shrink = m.get('extra')
        if m.get('is_voluntary') is not None:
            self.is_voluntary = m.get('is_voluntary')
        if m.get('item_unit_ids') is not None:
            self.item_unit_ids = m.get('item_unit_ids')
        if m.get('passenger_segment_info_list') is not None:
            self.passenger_segment_info_list_shrink = m.get('passenger_segment_info_list')
        if m.get('personal_refund_price') is not None:
            self.personal_refund_price = m.get('personal_refund_price')
        if m.get('reason_detail') is not None:
            self.reason_detail = m.get('reason_detail')
        if m.get('reason_type') is not None:
            self.reason_type = m.get('reason_type')
        if m.get('refund_voucher_info') is not None:
            self.refund_voucher_info_shrink = m.get('refund_voucher_info')
        if m.get('session_id') is not None:
            self.session_id = m.get('session_id')
        if m.get('total_refund_price') is not None:
            self.total_refund_price = m.get('total_refund_price')
        return self


class FlightRefundApplyResponseBodyModule(TeaModel):
    def __init__(
        self,
        dis_order_id: str = None,
        dis_sub_order_id: str = None,
        refund_apply_id: int = None,
        refund_fee: int = None,
        refund_money: int = None,
    ):
        self.dis_order_id = dis_order_id
        self.dis_sub_order_id = dis_sub_order_id
        self.refund_apply_id = refund_apply_id
        self.refund_fee = refund_fee
        self.refund_money = refund_money

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.dis_sub_order_id is not None:
            result['dis_sub_order_id'] = self.dis_sub_order_id
        if self.refund_apply_id is not None:
            result['refund_apply_id'] = self.refund_apply_id
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        if self.refund_money is not None:
            result['refund_money'] = self.refund_money
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('dis_sub_order_id') is not None:
            self.dis_sub_order_id = m.get('dis_sub_order_id')
        if m.get('refund_apply_id') is not None:
            self.refund_apply_id = m.get('refund_apply_id')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        if m.get('refund_money') is not None:
            self.refund_money = m.get('refund_money')
        return self


class FlightRefundApplyResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightRefundApplyResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightRefundApplyResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightRefundApplyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightRefundApplyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightRefundApplyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightRefundDetailHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightRefundDetailRequest(TeaModel):
    def __init__(
        self,
        dis_order_id: str = None,
        dis_sub_order_id: str = None,
    ):
        self.dis_order_id = dis_order_id
        self.dis_sub_order_id = dis_sub_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.dis_sub_order_id is not None:
            result['dis_sub_order_id'] = self.dis_sub_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('dis_sub_order_id') is not None:
            self.dis_sub_order_id = m.get('dis_sub_order_id')
        return self


class FlightRefundDetailResponseBodyModuleRefundFeeList(TeaModel):
    def __init__(
        self,
        alipay_trade_no: str = None,
        refund_fee: int = None,
        refund_price: int = None,
        status: str = None,
    ):
        self.alipay_trade_no = alipay_trade_no
        self.refund_fee = refund_fee
        self.refund_price = refund_price
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alipay_trade_no is not None:
            result['alipay_trade_no'] = self.alipay_trade_no
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        if self.refund_price is not None:
            result['refund_price'] = self.refund_price
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alipay_trade_no') is not None:
            self.alipay_trade_no = m.get('alipay_trade_no')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        if m.get('refund_price') is not None:
            self.refund_price = m.get('refund_price')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class FlightRefundDetailResponseBodyModule(TeaModel):
    def __init__(
        self,
        btrip_order_id: int = None,
        btrip_sub_order_id: int = None,
        dis_order_id: str = None,
        dis_sub_order_id: str = None,
        is_voluntary: int = None,
        reason: str = None,
        refund_fee: int = None,
        refund_fee_list: List[FlightRefundDetailResponseBodyModuleRefundFeeList] = None,
        refund_price: int = None,
        status: str = None,
    ):
        self.btrip_order_id = btrip_order_id
        self.btrip_sub_order_id = btrip_sub_order_id
        self.dis_order_id = dis_order_id
        self.dis_sub_order_id = dis_sub_order_id
        self.is_voluntary = is_voluntary
        self.reason = reason
        self.refund_fee = refund_fee
        self.refund_fee_list = refund_fee_list
        self.refund_price = refund_price
        self.status = status

    def validate(self):
        if self.refund_fee_list:
            for k in self.refund_fee_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.btrip_order_id is not None:
            result['btrip_order_id'] = self.btrip_order_id
        if self.btrip_sub_order_id is not None:
            result['btrip_sub_order_id'] = self.btrip_sub_order_id
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.dis_sub_order_id is not None:
            result['dis_sub_order_id'] = self.dis_sub_order_id
        if self.is_voluntary is not None:
            result['is_voluntary'] = self.is_voluntary
        if self.reason is not None:
            result['reason'] = self.reason
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        result['refund_fee_list'] = []
        if self.refund_fee_list is not None:
            for k in self.refund_fee_list:
                result['refund_fee_list'].append(k.to_map() if k else None)
        if self.refund_price is not None:
            result['refund_price'] = self.refund_price
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('btrip_order_id') is not None:
            self.btrip_order_id = m.get('btrip_order_id')
        if m.get('btrip_sub_order_id') is not None:
            self.btrip_sub_order_id = m.get('btrip_sub_order_id')
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('dis_sub_order_id') is not None:
            self.dis_sub_order_id = m.get('dis_sub_order_id')
        if m.get('is_voluntary') is not None:
            self.is_voluntary = m.get('is_voluntary')
        if m.get('reason') is not None:
            self.reason = m.get('reason')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        self.refund_fee_list = []
        if m.get('refund_fee_list') is not None:
            for k in m.get('refund_fee_list'):
                temp_model = FlightRefundDetailResponseBodyModuleRefundFeeList()
                self.refund_fee_list.append(temp_model.from_map(k))
        if m.get('refund_price') is not None:
            self.refund_price = m.get('refund_price')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class FlightRefundDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightRefundDetailResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightRefundDetailResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightRefundDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightRefundDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightRefundDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightRefundPreCalHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightRefundPreCalRequestPassengerSegmentInfoList(TeaModel):
    def __init__(
        self,
        flight_no: str = None,
        passenger_name: str = None,
        user_id: str = None,
    ):
        self.flight_no = flight_no
        self.passenger_name = passenger_name
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.passenger_name is not None:
            result['passenger_name'] = self.passenger_name
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('passenger_name') is not None:
            self.passenger_name = m.get('passenger_name')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightRefundPreCalRequest(TeaModel):
    def __init__(
        self,
        dis_order_id: str = None,
        is_voluntary: str = None,
        passenger_segment_info_list: List[FlightRefundPreCalRequestPassengerSegmentInfoList] = None,
    ):
        self.dis_order_id = dis_order_id
        self.is_voluntary = is_voluntary
        self.passenger_segment_info_list = passenger_segment_info_list

    def validate(self):
        if self.passenger_segment_info_list:
            for k in self.passenger_segment_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.is_voluntary is not None:
            result['is_voluntary'] = self.is_voluntary
        result['passenger_segment_info_list'] = []
        if self.passenger_segment_info_list is not None:
            for k in self.passenger_segment_info_list:
                result['passenger_segment_info_list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('is_voluntary') is not None:
            self.is_voluntary = m.get('is_voluntary')
        self.passenger_segment_info_list = []
        if m.get('passenger_segment_info_list') is not None:
            for k in m.get('passenger_segment_info_list'):
                temp_model = FlightRefundPreCalRequestPassengerSegmentInfoList()
                self.passenger_segment_info_list.append(temp_model.from_map(k))
        return self


class FlightRefundPreCalShrinkRequest(TeaModel):
    def __init__(
        self,
        dis_order_id: str = None,
        is_voluntary: str = None,
        passenger_segment_info_list_shrink: str = None,
    ):
        self.dis_order_id = dis_order_id
        self.is_voluntary = is_voluntary
        self.passenger_segment_info_list_shrink = passenger_segment_info_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dis_order_id is not None:
            result['dis_order_id'] = self.dis_order_id
        if self.is_voluntary is not None:
            result['is_voluntary'] = self.is_voluntary
        if self.passenger_segment_info_list_shrink is not None:
            result['passenger_segment_info_list'] = self.passenger_segment_info_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dis_order_id') is not None:
            self.dis_order_id = m.get('dis_order_id')
        if m.get('is_voluntary') is not None:
            self.is_voluntary = m.get('is_voluntary')
        if m.get('passenger_segment_info_list') is not None:
            self.passenger_segment_info_list_shrink = m.get('passenger_segment_info_list')
        return self


class FlightRefundPreCalResponseBodyModuleMultiRefundCalList(TeaModel):
    def __init__(
        self,
        can_apply_refund: bool = None,
        name: str = None,
        pre_refund_money: int = None,
        refund_fee: int = None,
        user_id: str = None,
    ):
        self.can_apply_refund = can_apply_refund
        self.name = name
        self.pre_refund_money = pre_refund_money
        self.refund_fee = refund_fee
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_apply_refund is not None:
            result['can_apply_refund'] = self.can_apply_refund
        if self.name is not None:
            result['name'] = self.name
        if self.pre_refund_money is not None:
            result['pre_refund_money'] = self.pre_refund_money
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        if self.user_id is not None:
            result['user_id'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('can_apply_refund') is not None:
            self.can_apply_refund = m.get('can_apply_refund')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('pre_refund_money') is not None:
            self.pre_refund_money = m.get('pre_refund_money')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        if m.get('user_id') is not None:
            self.user_id = m.get('user_id')
        return self


class FlightRefundPreCalResponseBodyModuleReturnReason(TeaModel):
    def __init__(
        self,
        extend_desc: str = None,
        person: int = None,
        reason_code: int = None,
        reason_show: str = None,
        reason_type: int = None,
        volunteer: int = None,
    ):
        self.extend_desc = extend_desc
        self.person = person
        self.reason_code = reason_code
        self.reason_show = reason_show
        self.reason_type = reason_type
        self.volunteer = volunteer

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.extend_desc is not None:
            result['extend_desc'] = self.extend_desc
        if self.person is not None:
            result['person'] = self.person
        if self.reason_code is not None:
            result['reason_code'] = self.reason_code
        if self.reason_show is not None:
            result['reason_show'] = self.reason_show
        if self.reason_type is not None:
            result['reason_type'] = self.reason_type
        if self.volunteer is not None:
            result['volunteer'] = self.volunteer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('extend_desc') is not None:
            self.extend_desc = m.get('extend_desc')
        if m.get('person') is not None:
            self.person = m.get('person')
        if m.get('reason_code') is not None:
            self.reason_code = m.get('reason_code')
        if m.get('reason_show') is not None:
            self.reason_show = m.get('reason_show')
        if m.get('reason_type') is not None:
            self.reason_type = m.get('reason_type')
        if m.get('volunteer') is not None:
            self.volunteer = m.get('volunteer')
        return self


class FlightRefundPreCalResponseBodyModule(TeaModel):
    def __init__(
        self,
        flight_change: bool = None,
        item_unit_id: str = None,
        multi_refund_cal_list: List[FlightRefundPreCalResponseBodyModuleMultiRefundCalList] = None,
        pre_refund_money: int = None,
        refund_fee: int = None,
        return_reason: List[FlightRefundPreCalResponseBodyModuleReturnReason] = None,
        session_id: str = None,
        tips: str = None,
    ):
        self.flight_change = flight_change
        self.item_unit_id = item_unit_id
        self.multi_refund_cal_list = multi_refund_cal_list
        self.pre_refund_money = pre_refund_money
        self.refund_fee = refund_fee
        self.return_reason = return_reason
        self.session_id = session_id
        self.tips = tips

    def validate(self):
        if self.multi_refund_cal_list:
            for k in self.multi_refund_cal_list:
                if k:
                    k.validate()
        if self.return_reason:
            for k in self.return_reason:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flight_change is not None:
            result['flight_change'] = self.flight_change
        if self.item_unit_id is not None:
            result['item_unit_id'] = self.item_unit_id
        result['multi_refund_cal_list'] = []
        if self.multi_refund_cal_list is not None:
            for k in self.multi_refund_cal_list:
                result['multi_refund_cal_list'].append(k.to_map() if k else None)
        if self.pre_refund_money is not None:
            result['pre_refund_money'] = self.pre_refund_money
        if self.refund_fee is not None:
            result['refund_fee'] = self.refund_fee
        result['return_reason'] = []
        if self.return_reason is not None:
            for k in self.return_reason:
                result['return_reason'].append(k.to_map() if k else None)
        if self.session_id is not None:
            result['session_id'] = self.session_id
        if self.tips is not None:
            result['tips'] = self.tips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('flight_change') is not None:
            self.flight_change = m.get('flight_change')
        if m.get('item_unit_id') is not None:
            self.item_unit_id = m.get('item_unit_id')
        self.multi_refund_cal_list = []
        if m.get('multi_refund_cal_list') is not None:
            for k in m.get('multi_refund_cal_list'):
                temp_model = FlightRefundPreCalResponseBodyModuleMultiRefundCalList()
                self.multi_refund_cal_list.append(temp_model.from_map(k))
        if m.get('pre_refund_money') is not None:
            self.pre_refund_money = m.get('pre_refund_money')
        if m.get('refund_fee') is not None:
            self.refund_fee = m.get('refund_fee')
        self.return_reason = []
        if m.get('return_reason') is not None:
            for k in m.get('return_reason'):
                temp_model = FlightRefundPreCalResponseBodyModuleReturnReason()
                self.return_reason.append(temp_model.from_map(k))
        if m.get('session_id') is not None:
            self.session_id = m.get('session_id')
        if m.get('tips') is not None:
            self.tips = m.get('tips')
        return self


class FlightRefundPreCalResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        module: FlightRefundPreCalResponseBodyModule = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.message = message
        self.module = module
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.module:
            self.module.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.module is not None:
            result['module'] = self.module.to_map()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        if self.trace_id is not None:
            result['traceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('module') is not None:
            temp_model = FlightRefundPreCalResponseBodyModule()
            self.module = temp_model.from_map(m['module'])
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        if m.get('traceId') is not None:
            self.trace_id = m.get('traceId')
        return self


class FlightRefundPreCalResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: FlightRefundPreCalResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FlightRefundPreCalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlightSearchListHeaders(TeaModel):
    def __init__(
        self,
        common_headers: Dict[str, str] = None,
        x_acs_btrip_corp_token: str = None,
    ):
        self.common_headers = common_headers
        self.x_acs_btrip_corp_token = x_acs_btrip_corp_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.common_headers is not None:
            result['commonHeaders'] = self.common_headers
        if self.x_acs_btrip_corp_token is not None:
            result['x-acs-btrip-corp-token'] = self.x_acs_btrip_corp_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('commonHeaders') is not None:
            self.common_headers = m.get('commonHeaders')
        if m.get('x-acs-btrip-corp-token') is not None:
            self.x_acs_btrip_corp_token = m.get('x-acs-btrip-corp-token')
        return self


class FlightSearchListRequest(TeaModel):
    def __init__(
        self,
        airline_code: str = None,
        arr_city_code: str = None,
        arr_city_name: str = None,
        arr_date: str = None,
        cabin_class: str = None,
        dep_city_code: str = None,
        dep_city_name: str = None,
        dep_date: str = None,
        flight_no: str = None,
        need_multi_class_price: bool = None,
        transfer_city_code: str = None,
        transfer_flight_no: str = None,
        transfer_leave_date: str = None,
        trip_type: str = None,
    ):
        self.airline_code = airline_code
        self.arr_city_code = arr_city_code
        self.arr_city_name = arr_city_name
        self.arr_date = arr_date
        self.cabin_class = cabin_class
        self.dep_city_code = dep_city_code
        self.dep_city_name = dep_city_name
        self.dep_date = dep_date
        self.flight_no = flight_no
        self.need_multi_class_price = need_multi_class_price
        self.transfer_city_code = transfer_city_code
        self.transfer_flight_no = transfer_flight_no
        self.transfer_leave_date = transfer_leave_date
        self.trip_type = trip_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.arr_city_code is not None:
            result['arr_city_code'] = self.arr_city_code
        if self.arr_city_name is not None:
            result['arr_city_name'] = self.arr_city_name
        if self.arr_date is not None:
            result['arr_date'] = self.arr_date
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.dep_city_code is not None:
            result['dep_city_code'] = self.dep_city_code
        if self.dep_city_name is not None:
            result['dep_city_name'] = self.dep_city_name
        if self.dep_date is not None:
            result['dep_date'] = self.dep_date
        if self.flight_no is not None:
            result['flight_no'] = self.flight_no
        if self.need_multi_class_price is not None:
            result['need_multi_class_price'] = self.need_multi_class_price
        if self.transfer_city_code is not None:
            result['transfer_city_code'] = self.transfer_city_code
        if self.transfer_flight_no is not None:
            result['transfer_flight_no'] = self.transfer_flight_no
        if self.transfer_leave_date is not None:
            result['transfer_leave_date'] = self.transfer_leave_date
        if self.trip_type is not None:
            result['trip_type'] = self.trip_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('arr_city_code') is not None:
            self.arr_city_code = m.get('arr_city_code')
        if m.get('arr_city_name') is not None:
            self.arr_city_name = m.get('arr_city_name')
        if m.get('arr_date') is not None:
            self.arr_date = m.get('arr_date')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('dep_city_code') is not None:
            self.dep_city_code = m.get('dep_city_code')
        if m.get('dep_city_name') is not None:
            self.dep_city_name = m.get('dep_city_name')
        if m.get('dep_date') is not None:
            self.dep_date = m.get('dep_date')
        if m.get('flight_no') is not None:
            self.flight_no = m.get('flight_no')
        if m.get('need_multi_class_price') is not None:
            self.need_multi_class_price = m.get('need_multi_class_price')
        if m.get('transfer_city_code') is not None:
            self.transfer_city_code = m.get('transfer_city_code')
        if m.get('transfer_flight_no') is not None:
            self.transfer_flight_no = m.get('transfer_flight_no')
        if m.get('transfer_leave_date') is not None:
            self.transfer_leave_date = m.get('transfer_leave_date')
        if m.get('trip_type') is not None:
            self.trip_type = m.get('trip_type')
        return self


class FlightSearchListResponseBodyModuleFlightListAirlineInfo(TeaModel):
    def __init__(
        self,
        airline_code: str = None,
        airline_name: str = None,
        airline_simple_name: str = None,
    ):
        self.airline_code = airline_code
        self.airline_name = airline_name
        self.airline_simple_name = airline_simple_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.airline_name is not None:
            result['airline_name'] = self.airline_name
        if self.airline_simple_name is not None:
            result['airline_simple_name'] = self.airline_simple_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('airline_name') is not None:
            self.airline_name = m.get('airline_name')
        if m.get('airline_simple_name') is not None:
            self.airline_simple_name = m.get('airline_simple_name')
        return self


class FlightSearchListResponseBodyModuleFlightListArrAirportInfo(TeaModel):
    def __init__(
        self,
        airport_code: str = None,
        airport_name: str = None,
        city_code: str = None,
        city_name: str = None,
        terminal: str = None,
    ):
        self.airport_code = airport_code
        self.airport_name = airport_name
        self.city_code = city_code
        self.city_name = city_name
        self.terminal = terminal

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription(TeaModel):
    def __init__(
        self,
        desc: str = None,
        icon: str = None,
        image: str = None,
        title: str = None,
    ):
        self.desc = desc
        self.icon = icon
        self.image = image
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['desc'] = self.desc
        if self.icon is not None:
            result['icon'] = self.icon
        if self.image is not None:
            result['image'] = self.image
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO(TeaModel):
    def __init__(
        self,
        image: str = None,
        largest: str = None,
        middle: str = None,
        smallest: str = None,
    ):
        self.image = image
        self.largest = largest
        self.middle = middle
        self.smallest = smallest

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image is not None:
            result['image'] = self.image
        if self.largest is not None:
            result['largest'] = self.largest
        if self.middle is not None:
            result['middle'] = self.middle
        if self.smallest is not None:
            result['smallest'] = self.smallest
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('largest') is not None:
            self.largest = m.get('largest')
        if m.get('middle') is not None:
            self.middle = m.get('middle')
        if m.get('smallest') is not None:
            self.smallest = m.get('smallest')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes(TeaModel):
    def __init__(
        self,
        baggage_desc: List[str] = None,
        baggage_sub_content_type: int = None,
        description: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription = None,
        image_do: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO = None,
        is_highlight: bool = None,
        sub_title: str = None,
    ):
        self.baggage_desc = baggage_desc
        self.baggage_sub_content_type = baggage_sub_content_type
        self.description = description
        self.image_do = image_do
        self.is_highlight = is_highlight
        self.sub_title = sub_title

    def validate(self):
        if self.description:
            self.description.validate()
        if self.image_do:
            self.image_do.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        if self.baggage_sub_content_type is not None:
            result['baggage_sub_content_type'] = self.baggage_sub_content_type
        if self.description is not None:
            result['description'] = self.description.to_map()
        if self.image_do is not None:
            result['image_d_o'] = self.image_do.to_map()
        if self.is_highlight is not None:
            result['is_highlight'] = self.is_highlight
        if self.sub_title is not None:
            result['sub_title'] = self.sub_title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        if m.get('baggage_sub_content_type') is not None:
            self.baggage_sub_content_type = m.get('baggage_sub_content_type')
        if m.get('description') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription()
            self.description = temp_model.from_map(m['description'])
        if m.get('image_d_o') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO()
            self.image_do = temp_model.from_map(m['image_d_o'])
        if m.get('is_highlight') is not None:
            self.is_highlight = m.get('is_highlight')
        if m.get('sub_title') is not None:
            self.sub_title = m.get('sub_title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItems(TeaModel):
    def __init__(
        self,
        baggage_sub_content_visualizes: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes] = None,
        extra_content_visualizes: List[Any] = None,
        is_struct: bool = None,
        ptc: str = None,
        title: str = None,
    ):
        self.baggage_sub_content_visualizes = baggage_sub_content_visualizes
        self.extra_content_visualizes = extra_content_visualizes
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.title = title

    def validate(self):
        if self.baggage_sub_content_visualizes:
            for k in self.baggage_sub_content_visualizes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_content_visualizes'] = []
        if self.baggage_sub_content_visualizes is not None:
            for k in self.baggage_sub_content_visualizes:
                result['baggage_sub_content_visualizes'].append(k.to_map() if k else None)
        if self.extra_content_visualizes is not None:
            result['extra_content_visualizes'] = self.extra_content_visualizes
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_content_visualizes = []
        if m.get('baggage_sub_content_visualizes') is not None:
            for k in m.get('baggage_sub_content_visualizes'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes()
                self.baggage_sub_content_visualizes.append(temp_model.from_map(k))
        if m.get('extra_content_visualizes') is not None:
            self.extra_content_visualizes = m.get('extra_content_visualizes')
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemTips(TeaModel):
    def __init__(
        self,
        logo: str = None,
        tips_desc: str = None,
        tips_image: str = None,
    ):
        self.logo = logo
        self.tips_desc = tips_desc
        self.tips_image = tips_image

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['logo'] = self.logo
        if self.tips_desc is not None:
            result['tips_desc'] = self.tips_desc
        if self.tips_image is not None:
            result['tips_image'] = self.tips_image
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('logo') is not None:
            self.logo = m.get('logo')
        if m.get('tips_desc') is not None:
            self.tips_desc = m.get('tips_desc')
        if m.get('tips_image') is not None:
            self.tips_image = m.get('tips_image')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItem(TeaModel):
    def __init__(
        self,
        baggage_sub_items: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItems] = None,
        index: int = None,
        table_head: str = None,
        tips: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemTips = None,
        title: str = None,
        type: int = None,
    ):
        self.baggage_sub_items = baggage_sub_items
        self.index = index
        self.table_head = table_head
        self.tips = tips
        self.title = title
        self.type = type

    def validate(self):
        if self.baggage_sub_items:
            for k in self.baggage_sub_items:
                if k:
                    k.validate()
        if self.tips:
            self.tips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_items'] = []
        if self.baggage_sub_items is not None:
            for k in self.baggage_sub_items:
                result['baggage_sub_items'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.tips is not None:
            result['tips'] = self.tips.to_map()
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_items = []
        if m.get('baggage_sub_items') is not None:
            for k in m.get('baggage_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemBaggageSubItems()
                self.baggage_sub_items.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('tips') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItemTips()
            self.tips = temp_model.from_map(m['tips'])
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemExtraContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        title: str = None,
    ):
        self.content = content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(
        self,
        fee_desc: str = None,
        fee_range: str = None,
        style: int = None,
    ):
        self.fee_desc = fee_desc
        self.fee_range = fee_range
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItems(TeaModel):
    def __init__(
        self,
        is_struct: bool = None,
        ptc: str = None,
        refund_sub_contents: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents] = None,
        title: str = None,
    ):
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.refund_sub_contents = refund_sub_contents
        self.title = title

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItem(TeaModel):
    def __init__(
        self,
        extra_contents: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemExtraContents] = None,
        index: int = None,
        refund_sub_items: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItems] = None,
        sub_table_head: List[str] = None,
        table_head: str = None,
        title: str = None,
        type: int = None,
    ):
        self.extra_contents = extra_contents
        self.index = index
        self.refund_sub_items = refund_sub_items
        self.sub_table_head = sub_table_head
        self.table_head = table_head
        self.title = title
        self.type = type

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemExtraContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        title: str = None,
    ):
        self.content = content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(
        self,
        fee_desc: str = None,
        fee_range: str = None,
        style: int = None,
    ):
        self.fee_desc = fee_desc
        self.fee_range = fee_range
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItems(TeaModel):
    def __init__(
        self,
        is_struct: bool = None,
        ptc: str = None,
        refund_sub_contents: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents] = None,
        title: str = None,
    ):
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.refund_sub_contents = refund_sub_contents
        self.title = title

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItem(TeaModel):
    def __init__(
        self,
        extra_contents: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemExtraContents] = None,
        index: int = None,
        refund_sub_items: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItems] = None,
        sub_table_head: List[str] = None,
        table_head: str = None,
        title: str = None,
        type: int = None,
    ):
        self.extra_contents = extra_contents
        self.index = index
        self.refund_sub_items = refund_sub_items
        self.sub_table_head = sub_table_head
        self.table_head = table_head
        self.title = title
        self.type = type

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleList(TeaModel):
    def __init__(
        self,
        baggage_info: str = None,
        baggage_item: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItem = None,
        change_rule: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRule = None,
        change_rule_item: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItem = None,
        extra: str = None,
        refund_rule: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRule = None,
        refund_rule_item: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItem = None,
        sign_rule: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRule = None,
        tuigaiqian_info: str = None,
        upgrade_rule: FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRule = None,
    ):
        self.baggage_info = baggage_info
        self.baggage_item = baggage_item
        self.change_rule = change_rule
        self.change_rule_item = change_rule_item
        self.extra = extra
        self.refund_rule = refund_rule
        self.refund_rule_item = refund_rule_item
        self.sign_rule = sign_rule
        self.tuigaiqian_info = tuigaiqian_info
        self.upgrade_rule = upgrade_rule

    def validate(self):
        if self.baggage_item:
            self.baggage_item.validate()
        if self.change_rule:
            self.change_rule.validate()
        if self.change_rule_item:
            self.change_rule_item.validate()
        if self.refund_rule:
            self.refund_rule.validate()
        if self.refund_rule_item:
            self.refund_rule_item.validate()
        if self.sign_rule:
            self.sign_rule.validate()
        if self.upgrade_rule:
            self.upgrade_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_info is not None:
            result['baggage_info'] = self.baggage_info
        if self.baggage_item is not None:
            result['baggage_item'] = self.baggage_item.to_map()
        if self.change_rule is not None:
            result['change_rule'] = self.change_rule.to_map()
        if self.change_rule_item is not None:
            result['change_rule_item'] = self.change_rule_item.to_map()
        if self.extra is not None:
            result['extra'] = self.extra
        if self.refund_rule is not None:
            result['refund_rule'] = self.refund_rule.to_map()
        if self.refund_rule_item is not None:
            result['refund_rule_item'] = self.refund_rule_item.to_map()
        if self.sign_rule is not None:
            result['sign_rule'] = self.sign_rule.to_map()
        if self.tuigaiqian_info is not None:
            result['tuigaiqian_info'] = self.tuigaiqian_info
        if self.upgrade_rule is not None:
            result['upgrade_rule'] = self.upgrade_rule.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('baggage_info') is not None:
            self.baggage_info = m.get('baggage_info')
        if m.get('baggage_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListBaggageItem()
            self.baggage_item = temp_model.from_map(m['baggage_item'])
        if m.get('change_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRule()
            self.change_rule = temp_model.from_map(m['change_rule'])
        if m.get('change_rule_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListChangeRuleItem()
            self.change_rule_item = temp_model.from_map(m['change_rule_item'])
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('refund_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRule()
            self.refund_rule = temp_model.from_map(m['refund_rule'])
        if m.get('refund_rule_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListRefundRuleItem()
            self.refund_rule_item = temp_model.from_map(m['refund_rule_item'])
        if m.get('sign_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListSignRule()
            self.sign_rule = temp_model.from_map(m['sign_rule'])
        if m.get('tuigaiqian_info') is not None:
            self.tuigaiqian_info = m.get('tuigaiqian_info')
        if m.get('upgrade_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleListUpgradeRule()
            self.upgrade_rule = temp_model.from_map(m['upgrade_rule'])
        return self


class FlightSearchListResponseBodyModuleFlightListCabinInfoList(TeaModel):
    def __init__(
        self,
        agent_id: int = None,
        basic_cabin_price: int = None,
        build_price: int = None,
        cabin: str = None,
        cabin_class: str = None,
        cabin_class_name: str = None,
        child_cabin: str = None,
        class_name: str = None,
        class_rule: str = None,
        discount: str = None,
        flight_rule_list: List[FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleList] = None,
        flight_rule_list_str: str = None,
        invoice_type: int = None,
        is_protocol: bool = None,
        memo: str = None,
        oil_price: int = None,
        order_params: str = None,
        ota_item_id: str = None,
        price: int = None,
        product_type: int = None,
        product_type_desc: str = None,
        promotion_price: str = None,
        remained_seat_count: str = None,
        ticket_price: int = None,
        total_price: int = None,
    ):
        self.agent_id = agent_id
        self.basic_cabin_price = basic_cabin_price
        self.build_price = build_price
        self.cabin = cabin
        self.cabin_class = cabin_class
        self.cabin_class_name = cabin_class_name
        self.child_cabin = child_cabin
        self.class_name = class_name
        self.class_rule = class_rule
        self.discount = discount
        self.flight_rule_list = flight_rule_list
        self.flight_rule_list_str = flight_rule_list_str
        self.invoice_type = invoice_type
        self.is_protocol = is_protocol
        self.memo = memo
        self.oil_price = oil_price
        self.order_params = order_params
        self.ota_item_id = ota_item_id
        self.price = price
        self.product_type = product_type
        self.product_type_desc = product_type_desc
        self.promotion_price = promotion_price
        self.remained_seat_count = remained_seat_count
        self.ticket_price = ticket_price
        self.total_price = total_price

    def validate(self):
        if self.flight_rule_list:
            for k in self.flight_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['agent_id'] = self.agent_id
        if self.basic_cabin_price is not None:
            result['basic_cabin_price'] = self.basic_cabin_price
        if self.build_price is not None:
            result['build_price'] = self.build_price
        if self.cabin is not None:
            result['cabin'] = self.cabin
        if self.cabin_class is not None:
            result['cabin_class'] = self.cabin_class
        if self.cabin_class_name is not None:
            result['cabin_class_name'] = self.cabin_class_name
        if self.child_cabin is not None:
            result['child_cabin'] = self.child_cabin
        if self.class_name is not None:
            result['class_name'] = self.class_name
        if self.class_rule is not None:
            result['class_rule'] = self.class_rule
        if self.discount is not None:
            result['discount'] = self.discount
        result['flight_rule_list'] = []
        if self.flight_rule_list is not None:
            for k in self.flight_rule_list:
                result['flight_rule_list'].append(k.to_map() if k else None)
        if self.flight_rule_list_str is not None:
            result['flight_rule_list_str'] = self.flight_rule_list_str
        if self.invoice_type is not None:
            result['invoice_type'] = self.invoice_type
        if self.is_protocol is not None:
            result['is_protocol'] = self.is_protocol
        if self.memo is not None:
            result['memo'] = self.memo
        if self.oil_price is not None:
            result['oil_price'] = self.oil_price
        if self.order_params is not None:
            result['order_params'] = self.order_params
        if self.ota_item_id is not None:
            result['ota_item_id'] = self.ota_item_id
        if self.price is not None:
            result['price'] = self.price
        if self.product_type is not None:
            result['product_type'] = self.product_type
        if self.product_type_desc is not None:
            result['product_type_desc'] = self.product_type_desc
        if self.promotion_price is not None:
            result['promotion_price'] = self.promotion_price
        if self.remained_seat_count is not None:
            result['remained_seat_count'] = self.remained_seat_count
        if self.ticket_price is not None:
            result['ticket_price'] = self.ticket_price
        if self.total_price is not None:
            result['total_price'] = self.total_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('agent_id') is not None:
            self.agent_id = m.get('agent_id')
        if m.get('basic_cabin_price') is not None:
            self.basic_cabin_price = m.get('basic_cabin_price')
        if m.get('build_price') is not None:
            self.build_price = m.get('build_price')
        if m.get('cabin') is not None:
            self.cabin = m.get('cabin')
        if m.get('cabin_class') is not None:
            self.cabin_class = m.get('cabin_class')
        if m.get('cabin_class_name') is not None:
            self.cabin_class_name = m.get('cabin_class_name')
        if m.get('child_cabin') is not None:
            self.child_cabin = m.get('child_cabin')
        if m.get('class_name') is not None:
            self.class_name = m.get('class_name')
        if m.get('class_rule') is not None:
            self.class_rule = m.get('class_rule')
        if m.get('discount') is not None:
            self.discount = m.get('discount')
        self.flight_rule_list = []
        if m.get('flight_rule_list') is not None:
            for k in m.get('flight_rule_list'):
                temp_model = FlightSearchListResponseBodyModuleFlightListCabinInfoListFlightRuleList()
                self.flight_rule_list.append(temp_model.from_map(k))
        if m.get('flight_rule_list_str') is not None:
            self.flight_rule_list_str = m.get('flight_rule_list_str')
        if m.get('invoice_type') is not None:
            self.invoice_type = m.get('invoice_type')
        if m.get('is_protocol') is not None:
            self.is_protocol = m.get('is_protocol')
        if m.get('memo') is not None:
            self.memo = m.get('memo')
        if m.get('oil_price') is not None:
            self.oil_price = m.get('oil_price')
        if m.get('order_params') is not None:
            self.order_params = m.get('order_params')
        if m.get('ota_item_id') is not None:
            self.ota_item_id = m.get('ota_item_id')
        if m.get('price') is not None:
            self.price = m.get('price')
        if m.get('product_type') is not None:
            self.product_type = m.get('product_type')
        if m.get('product_type_desc') is not None:
            self.product_type_desc = m.get('product_type_desc')
        if m.get('promotion_price') is not None:
            self.promotion_price = m.get('promotion_price')
        if m.get('remained_seat_count') is not None:
            self.remained_seat_count = m.get('remained_seat_count')
        if m.get('ticket_price') is not None:
            self.ticket_price = m.get('ticket_price')
        if m.get('total_price') is not None:
            self.total_price = m.get('total_price')
        return self


class FlightSearchListResponseBodyModuleFlightListDepAirportInfo(TeaModel):
    def __init__(
        self,
        airport_code: str = None,
        airport_name: str = None,
        city_code: str = None,
        city_name: str = None,
        terminal: str = None,
    ):
        self.airport_code = airport_code
        self.airport_name = airport_name
        self.city_code = city_code
        self.city_name = city_name
        self.terminal = terminal

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription(TeaModel):
    def __init__(
        self,
        desc: str = None,
        icon: str = None,
        image: str = None,
        title: str = None,
    ):
        self.desc = desc
        self.icon = icon
        self.image = image
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['desc'] = self.desc
        if self.icon is not None:
            result['icon'] = self.icon
        if self.image is not None:
            result['image'] = self.image
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO(TeaModel):
    def __init__(
        self,
        image: str = None,
        largest: str = None,
        middle: str = None,
        smallest: str = None,
    ):
        self.image = image
        self.largest = largest
        self.middle = middle
        self.smallest = smallest

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image is not None:
            result['image'] = self.image
        if self.largest is not None:
            result['largest'] = self.largest
        if self.middle is not None:
            result['middle'] = self.middle
        if self.smallest is not None:
            result['smallest'] = self.smallest
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('largest') is not None:
            self.largest = m.get('largest')
        if m.get('middle') is not None:
            self.middle = m.get('middle')
        if m.get('smallest') is not None:
            self.smallest = m.get('smallest')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes(TeaModel):
    def __init__(
        self,
        baggage_desc: List[str] = None,
        baggage_sub_content_type: int = None,
        description: FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription = None,
        image_do: FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO = None,
        is_highlight: bool = None,
        sub_title: str = None,
    ):
        self.baggage_desc = baggage_desc
        self.baggage_sub_content_type = baggage_sub_content_type
        self.description = description
        self.image_do = image_do
        self.is_highlight = is_highlight
        self.sub_title = sub_title

    def validate(self):
        if self.description:
            self.description.validate()
        if self.image_do:
            self.image_do.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        if self.baggage_sub_content_type is not None:
            result['baggage_sub_content_type'] = self.baggage_sub_content_type
        if self.description is not None:
            result['description'] = self.description.to_map()
        if self.image_do is not None:
            result['image_d_o'] = self.image_do.to_map()
        if self.is_highlight is not None:
            result['is_highlight'] = self.is_highlight
        if self.sub_title is not None:
            result['sub_title'] = self.sub_title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        if m.get('baggage_sub_content_type') is not None:
            self.baggage_sub_content_type = m.get('baggage_sub_content_type')
        if m.get('description') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription()
            self.description = temp_model.from_map(m['description'])
        if m.get('image_d_o') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO()
            self.image_do = temp_model.from_map(m['image_d_o'])
        if m.get('is_highlight') is not None:
            self.is_highlight = m.get('is_highlight')
        if m.get('sub_title') is not None:
            self.sub_title = m.get('sub_title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems(TeaModel):
    def __init__(
        self,
        baggage_sub_content_visualizes: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes] = None,
        extra_content_visualizes: List[Any] = None,
        is_struct: bool = None,
        ptc: str = None,
        title: str = None,
    ):
        self.baggage_sub_content_visualizes = baggage_sub_content_visualizes
        self.extra_content_visualizes = extra_content_visualizes
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.title = title

    def validate(self):
        if self.baggage_sub_content_visualizes:
            for k in self.baggage_sub_content_visualizes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_content_visualizes'] = []
        if self.baggage_sub_content_visualizes is not None:
            for k in self.baggage_sub_content_visualizes:
                result['baggage_sub_content_visualizes'].append(k.to_map() if k else None)
        if self.extra_content_visualizes is not None:
            result['extra_content_visualizes'] = self.extra_content_visualizes
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_content_visualizes = []
        if m.get('baggage_sub_content_visualizes') is not None:
            for k in m.get('baggage_sub_content_visualizes'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes()
                self.baggage_sub_content_visualizes.append(temp_model.from_map(k))
        if m.get('extra_content_visualizes') is not None:
            self.extra_content_visualizes = m.get('extra_content_visualizes')
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemTips(TeaModel):
    def __init__(
        self,
        logo: str = None,
        tips_desc: str = None,
        tips_image: str = None,
    ):
        self.logo = logo
        self.tips_desc = tips_desc
        self.tips_image = tips_image

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['logo'] = self.logo
        if self.tips_desc is not None:
            result['tips_desc'] = self.tips_desc
        if self.tips_image is not None:
            result['tips_image'] = self.tips_image
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('logo') is not None:
            self.logo = m.get('logo')
        if m.get('tips_desc') is not None:
            self.tips_desc = m.get('tips_desc')
        if m.get('tips_image') is not None:
            self.tips_image = m.get('tips_image')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItem(TeaModel):
    def __init__(
        self,
        baggage_sub_items: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems] = None,
        index: int = None,
        table_head: str = None,
        tips: FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemTips = None,
        title: str = None,
        type: int = None,
    ):
        self.baggage_sub_items = baggage_sub_items
        self.index = index
        self.table_head = table_head
        self.tips = tips
        self.title = title
        self.type = type

    def validate(self):
        if self.baggage_sub_items:
            for k in self.baggage_sub_items:
                if k:
                    k.validate()
        if self.tips:
            self.tips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_items'] = []
        if self.baggage_sub_items is not None:
            for k in self.baggage_sub_items:
                result['baggage_sub_items'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.tips is not None:
            result['tips'] = self.tips.to_map()
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_items = []
        if m.get('baggage_sub_items') is not None:
            for k in m.get('baggage_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemBaggageSubItems()
                self.baggage_sub_items.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('tips') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItemTips()
            self.tips = temp_model.from_map(m['tips'])
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        title: str = None,
    ):
        self.content = content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(
        self,
        fee_desc: str = None,
        fee_range: str = None,
        style: int = None,
    ):
        self.fee_desc = fee_desc
        self.fee_range = fee_range
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems(TeaModel):
    def __init__(
        self,
        is_struct: bool = None,
        ptc: str = None,
        refund_sub_contents: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents] = None,
        title: str = None,
    ):
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.refund_sub_contents = refund_sub_contents
        self.title = title

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItem(TeaModel):
    def __init__(
        self,
        extra_contents: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents] = None,
        index: int = None,
        refund_sub_items: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems] = None,
        sub_table_head: List[str] = None,
        table_head: str = None,
        title: str = None,
        type: int = None,
    ):
        self.extra_contents = extra_contents
        self.index = index
        self.refund_sub_items = refund_sub_items
        self.sub_table_head = sub_table_head
        self.table_head = table_head
        self.title = title
        self.type = type

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        title: str = None,
    ):
        self.content = content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(
        self,
        fee_desc: str = None,
        fee_range: str = None,
        style: int = None,
    ):
        self.fee_desc = fee_desc
        self.fee_range = fee_range
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems(TeaModel):
    def __init__(
        self,
        is_struct: bool = None,
        ptc: str = None,
        refund_sub_contents: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents] = None,
        title: str = None,
    ):
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.refund_sub_contents = refund_sub_contents
        self.title = title

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        result['refund_sub_contents'] = []
        if self.refund_sub_contents is not None:
            for k in self.refund_sub_contents:
                result['refund_sub_contents'].append(k.to_map() if k else None)
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        self.refund_sub_contents = []
        if m.get('refund_sub_contents') is not None:
            for k in m.get('refund_sub_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItemsRefundSubContents()
                self.refund_sub_contents.append(temp_model.from_map(k))
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItem(TeaModel):
    def __init__(
        self,
        extra_contents: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents] = None,
        index: int = None,
        refund_sub_items: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems] = None,
        sub_table_head: List[str] = None,
        table_head: str = None,
        title: str = None,
        type: int = None,
    ):
        self.extra_contents = extra_contents
        self.index = index
        self.refund_sub_items = refund_sub_items
        self.sub_table_head = sub_table_head
        self.table_head = table_head
        self.title = title
        self.type = type

    def validate(self):
        if self.extra_contents:
            for k in self.extra_contents:
                if k:
                    k.validate()
        if self.refund_sub_items:
            for k in self.refund_sub_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['extra_contents'] = []
        if self.extra_contents is not None:
            for k in self.extra_contents:
                result['extra_contents'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        result['refund_sub_items'] = []
        if self.refund_sub_items is not None:
            for k in self.refund_sub_items:
                result['refund_sub_items'].append(k.to_map() if k else None)
        if self.sub_table_head is not None:
            result['sub_table_head'] = self.sub_table_head
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.extra_contents = []
        if m.get('extra_contents') is not None:
            for k in m.get('extra_contents'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemExtraContents()
                self.extra_contents.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        self.refund_sub_items = []
        if m.get('refund_sub_items') is not None:
            for k in m.get('refund_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItemRefundSubItems()
                self.refund_sub_items.append(temp_model.from_map(k))
        if m.get('sub_table_head') is not None:
            self.sub_table_head = m.get('sub_table_head')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListFlightRuleList(TeaModel):
    def __init__(
        self,
        baggage_info: str = None,
        baggage_item: FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItem = None,
        change_rule: FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRule = None,
        change_rule_item: FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItem = None,
        extra: str = None,
        refund_rule: FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRule = None,
        refund_rule_item: FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItem = None,
        sign_rule: FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRule = None,
        tuigaiqian_info: str = None,
        upgrade_rule: FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRule = None,
    ):
        self.baggage_info = baggage_info
        self.baggage_item = baggage_item
        self.change_rule = change_rule
        self.change_rule_item = change_rule_item
        self.extra = extra
        self.refund_rule = refund_rule
        self.refund_rule_item = refund_rule_item
        self.sign_rule = sign_rule
        self.tuigaiqian_info = tuigaiqian_info
        self.upgrade_rule = upgrade_rule

    def validate(self):
        if self.baggage_item:
            self.baggage_item.validate()
        if self.change_rule:
            self.change_rule.validate()
        if self.change_rule_item:
            self.change_rule_item.validate()
        if self.refund_rule:
            self.refund_rule.validate()
        if self.refund_rule_item:
            self.refund_rule_item.validate()
        if self.sign_rule:
            self.sign_rule.validate()
        if self.upgrade_rule:
            self.upgrade_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_info is not None:
            result['baggage_info'] = self.baggage_info
        if self.baggage_item is not None:
            result['baggage_item'] = self.baggage_item.to_map()
        if self.change_rule is not None:
            result['change_rule'] = self.change_rule.to_map()
        if self.change_rule_item is not None:
            result['change_rule_item'] = self.change_rule_item.to_map()
        if self.extra is not None:
            result['extra'] = self.extra
        if self.refund_rule is not None:
            result['refund_rule'] = self.refund_rule.to_map()
        if self.refund_rule_item is not None:
            result['refund_rule_item'] = self.refund_rule_item.to_map()
        if self.sign_rule is not None:
            result['sign_rule'] = self.sign_rule.to_map()
        if self.tuigaiqian_info is not None:
            result['tuigaiqian_info'] = self.tuigaiqian_info
        if self.upgrade_rule is not None:
            result['upgrade_rule'] = self.upgrade_rule.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('baggage_info') is not None:
            self.baggage_info = m.get('baggage_info')
        if m.get('baggage_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListBaggageItem()
            self.baggage_item = temp_model.from_map(m['baggage_item'])
        if m.get('change_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRule()
            self.change_rule = temp_model.from_map(m['change_rule'])
        if m.get('change_rule_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListChangeRuleItem()
            self.change_rule_item = temp_model.from_map(m['change_rule_item'])
        if m.get('extra') is not None:
            self.extra = m.get('extra')
        if m.get('refund_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRule()
            self.refund_rule = temp_model.from_map(m['refund_rule'])
        if m.get('refund_rule_item') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListRefundRuleItem()
            self.refund_rule_item = temp_model.from_map(m['refund_rule_item'])
        if m.get('sign_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListSignRule()
            self.sign_rule = temp_model.from_map(m['sign_rule'])
        if m.get('tuigaiqian_info') is not None:
            self.tuigaiqian_info = m.get('tuigaiqian_info')
        if m.get('upgrade_rule') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListFlightRuleListUpgradeRule()
            self.upgrade_rule = temp_model.from_map(m['upgrade_rule'])
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferAirlineInfo(TeaModel):
    def __init__(
        self,
        airline_code: str = None,
        airline_name: str = None,
        airline_simple_name: str = None,
    ):
        self.airline_code = airline_code
        self.airline_name = airline_name
        self.airline_simple_name = airline_simple_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airline_code is not None:
            result['airline_code'] = self.airline_code
        if self.airline_name is not None:
            result['airline_name'] = self.airline_name
        if self.airline_simple_name is not None:
            result['airline_simple_name'] = self.airline_simple_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airline_code') is not None:
            self.airline_code = m.get('airline_code')
        if m.get('airline_name') is not None:
            self.airline_name = m.get('airline_name')
        if m.get('airline_simple_name') is not None:
            self.airline_simple_name = m.get('airline_simple_name')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferArrAirportInfo(TeaModel):
    def __init__(
        self,
        airport_code: str = None,
        airport_name: str = None,
        city_code: str = None,
        city_name: str = None,
        terminal: str = None,
    ):
        self.airport_code = airport_code
        self.airport_name = airport_name
        self.city_code = city_code
        self.city_name = city_name
        self.terminal = terminal

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferDepAirportInfo(TeaModel):
    def __init__(
        self,
        airport_code: str = None,
        airport_name: str = None,
        city_code: str = None,
        city_name: str = None,
        terminal: str = None,
    ):
        self.airport_code = airport_code
        self.airport_name = airport_name
        self.city_code = city_code
        self.city_name = city_name
        self.terminal = terminal

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.airport_code is not None:
            result['airport_code'] = self.airport_code
        if self.airport_name is not None:
            result['airport_name'] = self.airport_name
        if self.city_code is not None:
            result['city_code'] = self.city_code
        if self.city_name is not None:
            result['city_name'] = self.city_name
        if self.terminal is not None:
            result['terminal'] = self.terminal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('airport_code') is not None:
            self.airport_code = m.get('airport_code')
        if m.get('airport_name') is not None:
            self.airport_name = m.get('airport_name')
        if m.get('city_code') is not None:
            self.city_code = m.get('city_code')
        if m.get('city_name') is not None:
            self.city_name = m.get('city_name')
        if m.get('terminal') is not None:
            self.terminal = m.get('terminal')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription(TeaModel):
    def __init__(
        self,
        desc: str = None,
        icon: str = None,
        image: str = None,
        title: str = None,
    ):
        self.desc = desc
        self.icon = icon
        self.image = image
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.desc is not None:
            result['desc'] = self.desc
        if self.icon is not None:
            result['icon'] = self.icon
        if self.image is not None:
            result['image'] = self.image
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('icon') is not None:
            self.icon = m.get('icon')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO(TeaModel):
    def __init__(
        self,
        image: str = None,
        largest: str = None,
        middle: str = None,
        smallest: str = None,
    ):
        self.image = image
        self.largest = largest
        self.middle = middle
        self.smallest = smallest

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image is not None:
            result['image'] = self.image
        if self.largest is not None:
            result['largest'] = self.largest
        if self.middle is not None:
            result['middle'] = self.middle
        if self.smallest is not None:
            result['smallest'] = self.smallest
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('largest') is not None:
            self.largest = m.get('largest')
        if m.get('middle') is not None:
            self.middle = m.get('middle')
        if m.get('smallest') is not None:
            self.smallest = m.get('smallest')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes(TeaModel):
    def __init__(
        self,
        baggage_desc: List[str] = None,
        baggage_sub_content_type: int = None,
        description: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription = None,
        image_do: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO = None,
        is_highlight: bool = None,
        sub_title: str = None,
    ):
        self.baggage_desc = baggage_desc
        self.baggage_sub_content_type = baggage_sub_content_type
        self.description = description
        self.image_do = image_do
        self.is_highlight = is_highlight
        self.sub_title = sub_title

    def validate(self):
        if self.description:
            self.description.validate()
        if self.image_do:
            self.image_do.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baggage_desc is not None:
            result['baggage_desc'] = self.baggage_desc
        if self.baggage_sub_content_type is not None:
            result['baggage_sub_content_type'] = self.baggage_sub_content_type
        if self.description is not None:
            result['description'] = self.description.to_map()
        if self.image_do is not None:
            result['image_d_o'] = self.image_do.to_map()
        if self.is_highlight is not None:
            result['is_highlight'] = self.is_highlight
        if self.sub_title is not None:
            result['sub_title'] = self.sub_title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('baggage_desc') is not None:
            self.baggage_desc = m.get('baggage_desc')
        if m.get('baggage_sub_content_type') is not None:
            self.baggage_sub_content_type = m.get('baggage_sub_content_type')
        if m.get('description') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesDescription()
            self.description = temp_model.from_map(m['description'])
        if m.get('image_d_o') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizesImageDO()
            self.image_do = temp_model.from_map(m['image_d_o'])
        if m.get('is_highlight') is not None:
            self.is_highlight = m.get('is_highlight')
        if m.get('sub_title') is not None:
            self.sub_title = m.get('sub_title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItems(TeaModel):
    def __init__(
        self,
        baggage_sub_content_visualizes: List[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes] = None,
        extra_content_visualizes: List[Any] = None,
        is_struct: bool = None,
        ptc: str = None,
        title: str = None,
    ):
        self.baggage_sub_content_visualizes = baggage_sub_content_visualizes
        self.extra_content_visualizes = extra_content_visualizes
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.title = title

    def validate(self):
        if self.baggage_sub_content_visualizes:
            for k in self.baggage_sub_content_visualizes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_content_visualizes'] = []
        if self.baggage_sub_content_visualizes is not None:
            for k in self.baggage_sub_content_visualizes:
                result['baggage_sub_content_visualizes'].append(k.to_map() if k else None)
        if self.extra_content_visualizes is not None:
            result['extra_content_visualizes'] = self.extra_content_visualizes
        if self.is_struct is not None:
            result['is_struct'] = self.is_struct
        if self.ptc is not None:
            result['ptc'] = self.ptc
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_content_visualizes = []
        if m.get('baggage_sub_content_visualizes') is not None:
            for k in m.get('baggage_sub_content_visualizes'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItemsBaggageSubContentVisualizes()
                self.baggage_sub_content_visualizes.append(temp_model.from_map(k))
        if m.get('extra_content_visualizes') is not None:
            self.extra_content_visualizes = m.get('extra_content_visualizes')
        if m.get('is_struct') is not None:
            self.is_struct = m.get('is_struct')
        if m.get('ptc') is not None:
            self.ptc = m.get('ptc')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemTips(TeaModel):
    def __init__(
        self,
        logo: str = None,
        tips_desc: str = None,
        tips_image: str = None,
    ):
        self.logo = logo
        self.tips_desc = tips_desc
        self.tips_image = tips_image

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logo is not None:
            result['logo'] = self.logo
        if self.tips_desc is not None:
            result['tips_desc'] = self.tips_desc
        if self.tips_image is not None:
            result['tips_image'] = self.tips_image
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('logo') is not None:
            self.logo = m.get('logo')
        if m.get('tips_desc') is not None:
            self.tips_desc = m.get('tips_desc')
        if m.get('tips_image') is not None:
            self.tips_image = m.get('tips_image')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItem(TeaModel):
    def __init__(
        self,
        baggage_sub_items: List[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItems] = None,
        index: int = None,
        table_head: str = None,
        tips: FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemTips = None,
        title: str = None,
        type: int = None,
    ):
        self.baggage_sub_items = baggage_sub_items
        self.index = index
        self.table_head = table_head
        self.tips = tips
        self.title = title
        self.type = type

    def validate(self):
        if self.baggage_sub_items:
            for k in self.baggage_sub_items:
                if k:
                    k.validate()
        if self.tips:
            self.tips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['baggage_sub_items'] = []
        if self.baggage_sub_items is not None:
            for k in self.baggage_sub_items:
                result['baggage_sub_items'].append(k.to_map() if k else None)
        if self.index is not None:
            result['index'] = self.index
        if self.table_head is not None:
            result['table_head'] = self.table_head
        if self.tips is not None:
            result['tips'] = self.tips.to_map()
        if self.title is not None:
            result['title'] = self.title
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baggage_sub_items = []
        if m.get('baggage_sub_items') is not None:
            for k in m.get('baggage_sub_items'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemBaggageSubItems()
                self.baggage_sub_items.append(temp_model.from_map(k))
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('table_head') is not None:
            self.table_head = m.get('table_head')
        if m.get('tips') is not None:
            temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListBaggageItemTips()
            self.tips = temp_model.from_map(m['tips'])
        if m.get('title') is not None:
            self.title = m.get('title')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        cost: int = None,
        cost_percent: int = None,
        time_stamp: int = None,
        time_type: str = None,
        title: str = None,
    ):
        self.content = content
        self.cost = cost
        self.cost_percent = cost_percent
        self.time_stamp = time_stamp
        self.time_type = time_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.cost is not None:
            result['cost'] = self.cost
        if self.cost_percent is not None:
            result['cost_percent'] = self.cost_percent
        if self.time_stamp is not None:
            result['time_stamp'] = self.time_stamp
        if self.time_type is not None:
            result['time_type'] = self.time_type
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('cost_percent') is not None:
            self.cost_percent = m.get('cost_percent')
        if m.get('time_stamp') is not None:
            self.time_stamp = m.get('time_stamp')
        if m.get('time_type') is not None:
            self.time_type = m.get('time_type')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRule(TeaModel):
    def __init__(
        self,
        able: bool = None,
        info: List[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleInfo] = None,
    ):
        self.able = able
        self.info = info

    def validate(self):
        if self.info:
            for k in self.info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.able is not None:
            result['able'] = self.able
        result['info'] = []
        if self.info is not None:
            for k in self.info:
                result['info'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('able') is not None:
            self.able = m.get('able')
        self.info = []
        if m.get('info') is not None:
            for k in m.get('info'):
                temp_model = FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleInfo()
                self.info.append(temp_model.from_map(k))
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemExtraContents(TeaModel):
    def __init__(
        self,
        content: str = None,
        title: str = None,
    ):
        self.content = content
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['content'] = self.content
        if self.title is not None:
            result['title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('content') is not None:
            self.content = m.get('content')
        if m.get('title') is not None:
            self.title = m.get('title')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents(TeaModel):
    def __init__(
        self,
        fee_desc: str = None,
        fee_range: str = None,
        style: int = None,
    ):
        self.fee_desc = fee_desc
        self.fee_range = fee_range
        self.style = style

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fee_desc is not None:
            result['fee_desc'] = self.fee_desc
        if self.fee_range is not None:
            result['fee_range'] = self.fee_range
        if self.style is not None:
            result['style'] = self.style
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fee_desc') is not None:
            self.fee_desc = m.get('fee_desc')
        if m.get('fee_range') is not None:
            self.fee_range = m.get('fee_range')
        if m.get('style') is not None:
            self.style = m.get('style')
        return self


class FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemRefundSubItems(TeaModel):
    def __init__(
        self,
        is_struct: bool = None,
        ptc: str = None,
        refund_sub_contents: List[FlightSearchListResponseBodyModuleFlightListTransferInfoTransferFlightRuleListChangeRuleItemRefundSubItemsRefundSubContents] = None,
        title: str = None,
    ):
        self.is_struct = is_struct
        # PTC
        self.ptc = ptc
        self.refund_sub_contents = refund_sub_contents
        self.title = title

    def validate(self):
        if self.refund_sub_contents:
            for k in self.refund_sub_contents:
                if k:
                    k.validate()

    def to_map