# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import os
import typing

import httpx
from .types.project_environment import ProjectEnvironment
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.oauth_token_provider import OAuthTokenProvider
from .environment import PipedreamEnvironment

if typing.TYPE_CHECKING:
    from .accounts.client import AccountsClient, AsyncAccountsClient
    from .actions.client import ActionsClient, AsyncActionsClient
    from .app_categories.client import AppCategoriesClient, AsyncAppCategoriesClient
    from .apps.client import AppsClient, AsyncAppsClient
    from .components.client import AsyncComponentsClient, ComponentsClient
    from .deployed_triggers.client import AsyncDeployedTriggersClient, DeployedTriggersClient
    from .file_stash.client import AsyncFileStashClient, FileStashClient
    from .oauth_tokens.client import AsyncOauthTokensClient, OauthTokensClient
    from .projects.client import AsyncProjectsClient, ProjectsClient
    from .proxy.client import AsyncProxyClient, ProxyClient
    from .tokens.client import AsyncTokensClient, TokensClient
    from .triggers.client import AsyncTriggersClient, TriggersClient
    from .users.client import AsyncUsersClient, UsersClient


class Client:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PipedreamEnvironment
        The environment to use for requests from the client. from .environment import PipedreamEnvironment



        Defaults to PipedreamEnvironment.PROD



    project_id : str
    project_environment : typing.Optional[ProjectEnvironment]
    client_id : typing.Optional[str]
    client_secret : typing.Optional[str]
    _token_getter_override : typing.Optional[typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from pipedream import Pipedream

    client = Pipedream(
        project_id="YOUR_PROJECT_ID",
        project_environment="YOUR_PROJECT_ENVIRONMENT",
        client_id="YOUR_CLIENT_ID",
        client_secret="YOUR_CLIENT_SECRET",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PipedreamEnvironment = PipedreamEnvironment.PROD,
        project_id: str,
        project_environment: typing.Optional[ProjectEnvironment] = os.getenv("PIPEDREAM_PROJECT_ENVIRONMENT"),
        client_id: typing.Optional[str] = os.getenv("PIPEDREAM_CLIENT_ID"),
        client_secret: typing.Optional[str] = os.getenv("PIPEDREAM_CLIENT_SECRET"),
        _token_getter_override: typing.Optional[typing.Callable[[], str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if client_id is None:
            raise ApiError(
                body="The client must be instantiated be either passing in client_id or setting PIPEDREAM_CLIENT_ID"
            )
        if client_secret is None:
            raise ApiError(
                body="The client must be instantiated be either passing in client_secret or setting PIPEDREAM_CLIENT_SECRET"
            )
        oauth_token_provider = OAuthTokenProvider(
            client_id=client_id,
            client_secret=client_secret,
            client_wrapper=SyncClientWrapper(
                base_url=_get_base_url(base_url=base_url, environment=environment),
                project_id=project_id,
                project_environment=project_environment,
                httpx_client=httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
                if follow_redirects is not None
                else httpx.Client(timeout=_defaulted_timeout),
                timeout=_defaulted_timeout,
            ),
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            project_id=project_id,
            project_environment=project_environment,
            token=_token_getter_override if _token_getter_override is not None else oauth_token_provider.get_token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._app_categories: typing.Optional[AppCategoriesClient] = None
        self._apps: typing.Optional[AppsClient] = None
        self._accounts: typing.Optional[AccountsClient] = None
        self._users: typing.Optional[UsersClient] = None
        self._components: typing.Optional[ComponentsClient] = None
        self._actions: typing.Optional[ActionsClient] = None
        self._triggers: typing.Optional[TriggersClient] = None
        self._deployed_triggers: typing.Optional[DeployedTriggersClient] = None
        self._projects: typing.Optional[ProjectsClient] = None
        self._file_stash: typing.Optional[FileStashClient] = None
        self._proxy: typing.Optional[ProxyClient] = None
        self._tokens: typing.Optional[TokensClient] = None
        self._oauth_tokens: typing.Optional[OauthTokensClient] = None

    @property
    def app_categories(self):
        if self._app_categories is None:
            from .app_categories.client import AppCategoriesClient  # noqa: E402

            self._app_categories = AppCategoriesClient(client_wrapper=self._client_wrapper)
        return self._app_categories

    @property
    def apps(self):
        if self._apps is None:
            from .apps.client import AppsClient  # noqa: E402

            self._apps = AppsClient(client_wrapper=self._client_wrapper)
        return self._apps

    @property
    def accounts(self):
        if self._accounts is None:
            from .accounts.client import AccountsClient  # noqa: E402

            self._accounts = AccountsClient(client_wrapper=self._client_wrapper)
        return self._accounts

    @property
    def users(self):
        if self._users is None:
            from .users.client import UsersClient  # noqa: E402

            self._users = UsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def components(self):
        if self._components is None:
            from .components.client import ComponentsClient  # noqa: E402

            self._components = ComponentsClient(client_wrapper=self._client_wrapper)
        return self._components

    @property
    def actions(self):
        if self._actions is None:
            from .actions.client import ActionsClient  # noqa: E402

            self._actions = ActionsClient(client_wrapper=self._client_wrapper)
        return self._actions

    @property
    def triggers(self):
        if self._triggers is None:
            from .triggers.client import TriggersClient  # noqa: E402

            self._triggers = TriggersClient(client_wrapper=self._client_wrapper)
        return self._triggers

    @property
    def deployed_triggers(self):
        if self._deployed_triggers is None:
            from .deployed_triggers.client import DeployedTriggersClient  # noqa: E402

            self._deployed_triggers = DeployedTriggersClient(client_wrapper=self._client_wrapper)
        return self._deployed_triggers

    @property
    def projects(self):
        if self._projects is None:
            from .projects.client import ProjectsClient  # noqa: E402

            self._projects = ProjectsClient(client_wrapper=self._client_wrapper)
        return self._projects

    @property
    def file_stash(self):
        if self._file_stash is None:
            from .file_stash.client import FileStashClient  # noqa: E402

            self._file_stash = FileStashClient(client_wrapper=self._client_wrapper)
        return self._file_stash

    @property
    def proxy(self):
        if self._proxy is None:
            from .proxy.client import ProxyClient  # noqa: E402

            self._proxy = ProxyClient(client_wrapper=self._client_wrapper)
        return self._proxy

    @property
    def tokens(self):
        if self._tokens is None:
            from .tokens.client import TokensClient  # noqa: E402

            self._tokens = TokensClient(client_wrapper=self._client_wrapper)
        return self._tokens

    @property
    def oauth_tokens(self):
        if self._oauth_tokens is None:
            from .oauth_tokens.client import OauthTokensClient  # noqa: E402

            self._oauth_tokens = OauthTokensClient(client_wrapper=self._client_wrapper)
        return self._oauth_tokens


class AsyncClient:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : PipedreamEnvironment
        The environment to use for requests from the client. from .environment import PipedreamEnvironment



        Defaults to PipedreamEnvironment.PROD



    project_id : str
    project_environment : typing.Optional[ProjectEnvironment]
    client_id : typing.Optional[str]
    client_secret : typing.Optional[str]
    _token_getter_override : typing.Optional[typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from pipedream import AsyncPipedream

    client = AsyncPipedream(
        project_id="YOUR_PROJECT_ID",
        project_environment="YOUR_PROJECT_ENVIRONMENT",
        client_id="YOUR_CLIENT_ID",
        client_secret="YOUR_CLIENT_SECRET",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: PipedreamEnvironment = PipedreamEnvironment.PROD,
        project_id: str,
        project_environment: typing.Optional[ProjectEnvironment] = os.getenv("PIPEDREAM_PROJECT_ENVIRONMENT"),
        client_id: typing.Optional[str] = os.getenv("PIPEDREAM_CLIENT_ID"),
        client_secret: typing.Optional[str] = os.getenv("PIPEDREAM_CLIENT_SECRET"),
        _token_getter_override: typing.Optional[typing.Callable[[], str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if client_id is None:
            raise ApiError(
                body="The client must be instantiated be either passing in client_id or setting PIPEDREAM_CLIENT_ID"
            )
        if client_secret is None:
            raise ApiError(
                body="The client must be instantiated be either passing in client_secret or setting PIPEDREAM_CLIENT_SECRET"
            )
        oauth_token_provider = OAuthTokenProvider(
            client_id=client_id,
            client_secret=client_secret,
            client_wrapper=SyncClientWrapper(
                base_url=_get_base_url(base_url=base_url, environment=environment),
                project_id=project_id,
                project_environment=project_environment,
                httpx_client=httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
                if follow_redirects is not None
                else httpx.Client(timeout=_defaulted_timeout),
                timeout=_defaulted_timeout,
            ),
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            project_id=project_id,
            project_environment=project_environment,
            token=_token_getter_override if _token_getter_override is not None else oauth_token_provider.get_token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._app_categories: typing.Optional[AsyncAppCategoriesClient] = None
        self._apps: typing.Optional[AsyncAppsClient] = None
        self._accounts: typing.Optional[AsyncAccountsClient] = None
        self._users: typing.Optional[AsyncUsersClient] = None
        self._components: typing.Optional[AsyncComponentsClient] = None
        self._actions: typing.Optional[AsyncActionsClient] = None
        self._triggers: typing.Optional[AsyncTriggersClient] = None
        self._deployed_triggers: typing.Optional[AsyncDeployedTriggersClient] = None
        self._projects: typing.Optional[AsyncProjectsClient] = None
        self._file_stash: typing.Optional[AsyncFileStashClient] = None
        self._proxy: typing.Optional[AsyncProxyClient] = None
        self._tokens: typing.Optional[AsyncTokensClient] = None
        self._oauth_tokens: typing.Optional[AsyncOauthTokensClient] = None

    @property
    def app_categories(self):
        if self._app_categories is None:
            from .app_categories.client import AsyncAppCategoriesClient  # noqa: E402

            self._app_categories = AsyncAppCategoriesClient(client_wrapper=self._client_wrapper)
        return self._app_categories

    @property
    def apps(self):
        if self._apps is None:
            from .apps.client import AsyncAppsClient  # noqa: E402

            self._apps = AsyncAppsClient(client_wrapper=self._client_wrapper)
        return self._apps

    @property
    def accounts(self):
        if self._accounts is None:
            from .accounts.client import AsyncAccountsClient  # noqa: E402

            self._accounts = AsyncAccountsClient(client_wrapper=self._client_wrapper)
        return self._accounts

    @property
    def users(self):
        if self._users is None:
            from .users.client import AsyncUsersClient  # noqa: E402

            self._users = AsyncUsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def components(self):
        if self._components is None:
            from .components.client import AsyncComponentsClient  # noqa: E402

            self._components = AsyncComponentsClient(client_wrapper=self._client_wrapper)
        return self._components

    @property
    def actions(self):
        if self._actions is None:
            from .actions.client import AsyncActionsClient  # noqa: E402

            self._actions = AsyncActionsClient(client_wrapper=self._client_wrapper)
        return self._actions

    @property
    def triggers(self):
        if self._triggers is None:
            from .triggers.client import AsyncTriggersClient  # noqa: E402

            self._triggers = AsyncTriggersClient(client_wrapper=self._client_wrapper)
        return self._triggers

    @property
    def deployed_triggers(self):
        if self._deployed_triggers is None:
            from .deployed_triggers.client import AsyncDeployedTriggersClient  # noqa: E402

            self._deployed_triggers = AsyncDeployedTriggersClient(client_wrapper=self._client_wrapper)
        return self._deployed_triggers

    @property
    def projects(self):
        if self._projects is None:
            from .projects.client import AsyncProjectsClient  # noqa: E402

            self._projects = AsyncProjectsClient(client_wrapper=self._client_wrapper)
        return self._projects

    @property
    def file_stash(self):
        if self._file_stash is None:
            from .file_stash.client import AsyncFileStashClient  # noqa: E402

            self._file_stash = AsyncFileStashClient(client_wrapper=self._client_wrapper)
        return self._file_stash

    @property
    def proxy(self):
        if self._proxy is None:
            from .proxy.client import AsyncProxyClient  # noqa: E402

            self._proxy = AsyncProxyClient(client_wrapper=self._client_wrapper)
        return self._proxy

    @property
    def tokens(self):
        if self._tokens is None:
            from .tokens.client import AsyncTokensClient  # noqa: E402

            self._tokens = AsyncTokensClient(client_wrapper=self._client_wrapper)
        return self._tokens

    @property
    def oauth_tokens(self):
        if self._oauth_tokens is None:
            from .oauth_tokens.client import AsyncOauthTokensClient  # noqa: E402

            self._oauth_tokens = AsyncOauthTokensClient(client_wrapper=self._client_wrapper)
        return self._oauth_tokens


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: PipedreamEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
