# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.too_many_requests_error import TooManyRequestsError
from ..types.component import Component
from ..types.component_type import ComponentType
from ..types.configure_prop_response import ConfigurePropResponse
from ..types.configured_props import ConfiguredProps
from ..types.get_component_response import GetComponentResponse
from ..types.get_components_response import GetComponentsResponse
from ..types.reload_props_response import ReloadPropsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawComponentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        q: typing.Optional[str] = None,
        app: typing.Optional[str] = None,
        component_type: typing.Optional[ComponentType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Component]:
        """
        Retrieve available components with optional search and app filtering

        Parameters
        ----------
        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        q : typing.Optional[str]
            A search query to filter the components

        app : typing.Optional[str]
            The ID or name slug of the app to filter the components

        component_type : typing.Optional[ComponentType]
            The type of the component to filter the components

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Component]
            components listed
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/components",
            method="GET",
            params={
                "after": after,
                "before": before,
                "limit": limit,
                "q": q,
                "app": app,
                "component_type": component_type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetComponentsResponse,
                    parse_obj_as(
                        type_=GetComponentsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = False
                _get_next = None
                if _parsed_response.page_info is not None:
                    _parsed_next = _parsed_response.page_info.end_cursor
                    _has_next = _parsed_next is not None and _parsed_next != ""
                    _get_next = lambda: self.list(
                        after=_parsed_next,
                        before=before,
                        limit=limit,
                        q=q,
                        app=app,
                        component_type=component_type,
                        request_options=request_options,
                    )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(
        self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Component]:
        """
        Get detailed configuration for a specific component by its key

        Parameters
        ----------
        component_id : str
            The key that uniquely identifies the component (e.g., 'slack-send-message')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Component]
            component retrieved
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/components/{jsonable_encoder(component_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetComponentResponse,
                    parse_obj_as(
                        type_=GetComponentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _data = _parsed_response.data
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def configure_prop(
        self,
        *,
        id: str,
        external_user_id: str,
        prop_name: str,
        blocking: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[ConfiguredProps] = OMIT,
        dynamic_props_id: typing.Optional[str] = OMIT,
        page: typing.Optional[float] = OMIT,
        prev_context: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        query: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ConfigurePropResponse]:
        """
        Retrieve remote options for a given prop for a component

        Parameters
        ----------
        id : str
            The component ID

        external_user_id : str
            The external user ID

        prop_name : str
            The name of the prop to configure

        blocking : typing.Optional[bool]
            Whether this operation should block until completion

        configured_props : typing.Optional[ConfiguredProps]

        dynamic_props_id : typing.Optional[str]
            The ID for dynamic props

        page : typing.Optional[float]
            Page number for paginated results

        prev_context : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Previous context for pagination

        query : typing.Optional[str]
            Search query for filtering options

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ConfigurePropResponse]
            component configuration started
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/components/configure",
            method="POST",
            json={
                "id": id,
                "external_user_id": external_user_id,
                "prop_name": prop_name,
                "blocking": blocking,
                "configured_props": convert_and_respect_annotation_metadata(
                    object_=configured_props, annotation=ConfiguredProps, direction="write"
                ),
                "dynamic_props_id": dynamic_props_id,
                "page": page,
                "prev_context": prev_context,
                "query": query,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ConfigurePropResponse,
                    parse_obj_as(
                        type_=ConfigurePropResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def reload_props(
        self,
        *,
        id: str,
        external_user_id: str,
        blocking: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[ConfiguredProps] = OMIT,
        dynamic_props_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ReloadPropsResponse]:
        """
        Reload the prop definition based on the currently configured props

        Parameters
        ----------
        id : str
            The component ID

        external_user_id : str
            The external user ID

        blocking : typing.Optional[bool]
            Whether this operation should block until completion

        configured_props : typing.Optional[ConfiguredProps]

        dynamic_props_id : typing.Optional[str]
            The ID for dynamic props

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ReloadPropsResponse]
            component props reloaded
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/components/props",
            method="POST",
            json={
                "id": id,
                "external_user_id": external_user_id,
                "blocking": blocking,
                "configured_props": convert_and_respect_annotation_metadata(
                    object_=configured_props, annotation=ConfiguredProps, direction="write"
                ),
                "dynamic_props_id": dynamic_props_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReloadPropsResponse,
                    parse_obj_as(
                        type_=ReloadPropsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawComponentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        q: typing.Optional[str] = None,
        app: typing.Optional[str] = None,
        component_type: typing.Optional[ComponentType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Component]:
        """
        Retrieve available components with optional search and app filtering

        Parameters
        ----------
        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        q : typing.Optional[str]
            A search query to filter the components

        app : typing.Optional[str]
            The ID or name slug of the app to filter the components

        component_type : typing.Optional[ComponentType]
            The type of the component to filter the components

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Component]
            components listed
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/components",
            method="GET",
            params={
                "after": after,
                "before": before,
                "limit": limit,
                "q": q,
                "app": app,
                "component_type": component_type,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetComponentsResponse,
                    parse_obj_as(
                        type_=GetComponentsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = False
                _get_next = None
                if _parsed_response.page_info is not None:
                    _parsed_next = _parsed_response.page_info.end_cursor
                    _has_next = _parsed_next is not None and _parsed_next != ""

                    async def _get_next():
                        return await self.list(
                            after=_parsed_next,
                            before=before,
                            limit=limit,
                            q=q,
                            app=app,
                            component_type=component_type,
                            request_options=request_options,
                        )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Component]:
        """
        Get detailed configuration for a specific component by its key

        Parameters
        ----------
        component_id : str
            The key that uniquely identifies the component (e.g., 'slack-send-message')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Component]
            component retrieved
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/components/{jsonable_encoder(component_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    GetComponentResponse,
                    parse_obj_as(
                        type_=GetComponentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _data = _parsed_response.data
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def configure_prop(
        self,
        *,
        id: str,
        external_user_id: str,
        prop_name: str,
        blocking: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[ConfiguredProps] = OMIT,
        dynamic_props_id: typing.Optional[str] = OMIT,
        page: typing.Optional[float] = OMIT,
        prev_context: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        query: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ConfigurePropResponse]:
        """
        Retrieve remote options for a given prop for a component

        Parameters
        ----------
        id : str
            The component ID

        external_user_id : str
            The external user ID

        prop_name : str
            The name of the prop to configure

        blocking : typing.Optional[bool]
            Whether this operation should block until completion

        configured_props : typing.Optional[ConfiguredProps]

        dynamic_props_id : typing.Optional[str]
            The ID for dynamic props

        page : typing.Optional[float]
            Page number for paginated results

        prev_context : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Previous context for pagination

        query : typing.Optional[str]
            Search query for filtering options

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ConfigurePropResponse]
            component configuration started
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/components/configure",
            method="POST",
            json={
                "id": id,
                "external_user_id": external_user_id,
                "prop_name": prop_name,
                "blocking": blocking,
                "configured_props": convert_and_respect_annotation_metadata(
                    object_=configured_props, annotation=ConfiguredProps, direction="write"
                ),
                "dynamic_props_id": dynamic_props_id,
                "page": page,
                "prev_context": prev_context,
                "query": query,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ConfigurePropResponse,
                    parse_obj_as(
                        type_=ConfigurePropResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def reload_props(
        self,
        *,
        id: str,
        external_user_id: str,
        blocking: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[ConfiguredProps] = OMIT,
        dynamic_props_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ReloadPropsResponse]:
        """
        Reload the prop definition based on the currently configured props

        Parameters
        ----------
        id : str
            The component ID

        external_user_id : str
            The external user ID

        blocking : typing.Optional[bool]
            Whether this operation should block until completion

        configured_props : typing.Optional[ConfiguredProps]

        dynamic_props_id : typing.Optional[str]
            The ID for dynamic props

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ReloadPropsResponse]
            component props reloaded
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/connect/{jsonable_encoder(self._client_wrapper._project_id)}/components/props",
            method="POST",
            json={
                "id": id,
                "external_user_id": external_user_id,
                "blocking": blocking,
                "configured_props": convert_and_respect_annotation_metadata(
                    object_=configured_props, annotation=ConfiguredProps, direction="write"
                ),
                "dynamic_props_id": dynamic_props_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ReloadPropsResponse,
                    parse_obj_as(
                        type_=ReloadPropsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
