# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawFileStashClient, RawFileStashClient


class FileStashClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFileStashClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFileStashClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFileStashClient
        """
        return self._raw_client

    def download_file(self, *, s_3_key: str, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Download a file from File Stash

        Parameters
        ----------
        s_3_key : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.file_stash.download_file(
            s_3_key="s3_key",
        )
        """
        _response = self._raw_client.download_file(s_3_key=s_3_key, request_options=request_options)
        return _response.data


class AsyncFileStashClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFileStashClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFileStashClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFileStashClient
        """
        return self._raw_client

    async def download_file(self, *, s_3_key: str, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Download a file from File Stash

        Parameters
        ----------
        s_3_key : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.file_stash.download_file(
                s_3_key="s3_key",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.download_file(s_3_key=s_3_key, request_options=request_options)
        return _response.data
