# This file was auto-generated by Fern from our API Definition.

import base64
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.proxy_response import ProxyResponse
from .raw_client import AsyncRawProxyClient, RawProxyClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProxyClient:

    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProxyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProxyClient:
        """
        Retrieves a raw implementation of this client that returns raw
        responses.

        Returns
        -------
        RawProxyClient
        """
        return self._raw_client

    def get(
        self,
        url: str,
        *,
        external_user_id: str,
        account_id: str,
        headers: typing.Optional[typing.Dict[str, typing.Any]] = None,
        params: typing.Optional[typing.Dict[str, typing.Any]] = None,
    ) -> ProxyResponse:
        """
        Parameters
        ----------
        url : str
            Target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        headers : typing.Optional[typing.Dict[str, typing.Any]]
            Additional headers to include in the request

        params : typing.Optional[typing.Dict[str, typing.Any]]
            Query parameters to include in the request

        Returns
        -------
        ProxyResponse
            proxy request successful

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.proxy.get(
            url="https://example.com/api/endpoint",
            external_user_id="external_user_id",
            account_id="account_id",
            headers={"Extra-Downstream-Header": "some value"}
            params={"limit": 10},
        )
        """
        url_64 = base64.urlsafe_b64encode(url.encode()).decode()
        downstream_headers = {
            f"x-pd-proxy-{header}": value
            for header, value in (headers or {}).items()
        }
        request_options = RequestOptions(
            additional_headers=downstream_headers,
            additional_query_parameters=params,
        )
        _response = self._raw_client.get(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request_options=request_options,
        )
        return _response.data

    def post(
        self,
        url: str,
        *,
        external_user_id: str,
        account_id: str,
        headers: typing.Optional[typing.Dict[str, typing.Any]] = None,
        body: typing.Optional[typing.Dict[
            str,
            typing.Optional[typing.Any],
        ]] = None,
        params: typing.Optional[typing.Dict[str, typing.Any]] = None,
    ) -> ProxyResponse:
        """
        Parameters
        ----------
        url : str
            Target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        headers : typing.Optional[typing.Dict[str, typing.Any]]
            Additional headers to include in the request

        body : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Request body data

        params : typing.Optional[typing.Dict[str, typing.Any]]
            Query parameters to include in the request

        Returns
        -------
        ProxyResponse
            proxy request successful

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.proxy.post(
            url="https://example.com/api/endpoint",
            external_user_id="external_user_id",
            account_id="account_id",
            headers={"Content-Type": "application/json"},
            body={"key": "value"},
        )
        """
        url_64 = base64.urlsafe_b64encode(url.encode()).decode()
        downstream_headers = {
            f"x-pd-proxy-{header}": value
            for header, value in (headers or {}).items()
        }
        request_options = RequestOptions(
            additional_headers=downstream_headers,
            additional_query_parameters=params,
        )
        _response = self._raw_client.post(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=body or {},
            request_options=request_options,
        )
        return _response.data

    def put(
        self,
        url: str,
        *,
        external_user_id: str,
        account_id: str,
        headers: typing.Optional[typing.Dict[str, typing.Any]] = None,
        body: typing.Optional[typing.Dict[
            str,
            typing.Optional[typing.Any],
        ]] = None,
        params: typing.Optional[typing.Dict[str, typing.Any]] = None,
    ) -> ProxyResponse:
        """
        Parameters
        ----------
        url : str
            Target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        headers : typing.Optional[typing.Dict[str, typing.Any]]
            Additional headers to include in the request

        body : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Request body data

        params : typing.Optional[typing.Dict[str, typing.Any]]
            Query parameters to include in the request

        Returns
        -------
        ProxyResponse
            proxy request successful

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.proxy.put(
            url="https://example.com/api/endpoint",
            external_user_id="external_user_id",
            account_id="account_id",
            headers={"Content-Type": "application/json"},
            body={"key": "value"},
        )
        """
        url_64 = base64.urlsafe_b64encode(url.encode()).decode()
        downstream_headers = {
            f"x-pd-proxy-{header}": value
            for header, value in (headers or {}).items()
        }
        request_options = RequestOptions(
            additional_headers=downstream_headers,
            additional_query_parameters=params,
        )
        _response = self._raw_client.put(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=body or {},
            request_options=request_options,
        )
        return _response.data

    def delete(
        self,
        url: str,
        *,
        external_user_id: str,
        account_id: str,
        headers: typing.Optional[typing.Dict[str, typing.Any]] = None,
        params: typing.Optional[typing.Dict[str, typing.Any]] = None,
    ) -> ProxyResponse:
        """
        Parameters
        ----------
        url : str
            Target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        headers : typing.Optional[typing.Dict[str, typing.Any]]
            Additional headers to include in the request

        params : typing.Optional[typing.Dict[str, typing.Any]]
            Query parameters to include in the request

        Returns
        -------
        ProxyResponse
            proxy request successful

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.proxy.delete(
            url="https://example.com/api/endpoint",
            external_user_id="external_user_id",
            account_id="account_id",
            headers={"Extra-Downstream-Header": "some value"}
        )
        """
        url_64 = base64.urlsafe_b64encode(url.encode()).decode()
        downstream_headers = {
            f"x-pd-proxy-{header}": value
            for header, value in (headers or {}).items()
        }
        request_options = RequestOptions(
            additional_headers=downstream_headers,
            additional_query_parameters=params,
        )
        _response = self._raw_client.delete(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request_options=request_options,
        )
        return _response.data

    def patch(
        self,
        url: str,
        *,
        external_user_id: str,
        account_id: str,
        headers: typing.Optional[typing.Dict[str, typing.Any]] = None,
        body: typing.Optional[typing.Dict[
            str,
            typing.Optional[typing.Any],
        ]] = None,
        params: typing.Optional[typing.Dict[str, typing.Any]] = None,
    ) -> ProxyResponse:
        """
        Parameters
        ----------
        url : str
            Target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        headers : typing.Optional[typing.Dict[str, typing.Any]]
            Additional headers to include in the request

        body : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Request body data

        params : typing.Optional[typing.Dict[str, typing.Any]]
            Query parameters to include in the request

        Returns
        -------
        ProxyResponse
            proxy request successful

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.proxy.patch(
            url="https://example.com/api/endpoint",
            external_user_id="external_user_id",
            account_id="account_id",
            headers={"Content-Type": "application/json"},
            body={"key": "value"},
        )
        """
        url_64 = base64.urlsafe_b64encode(url.encode()).decode()
        downstream_headers = {
            f"x-pd-proxy-{header}": value
            for header, value in (headers or {}).items()
        }
        request_options = RequestOptions(
            additional_headers=downstream_headers,
            additional_query_parameters=params,
        )
        _response = self._raw_client.patch(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=body or {},
            request_options=request_options,
        )
        return _response.data


class AsyncProxyClient:

    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProxyClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProxyClient:
        """
        Retrieves a raw implementation of this client that returns raw
        responses.

        Returns
        -------
        AsyncRawProxyClient
        """
        return self._raw_client

    async def get(
        self,
        url: str,
        *,
        external_user_id: str,
        account_id: str,
        headers: typing.Optional[typing.Dict[str, typing.Any]] = None,
        params: typing.Optional[typing.Dict[str, typing.Any]] = None,
    ) -> ProxyResponse:
        """
        Parameters
        ----------
        url : str
            Target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        headers : typing.Optional[typing.Dict[str, typing.Any]]
            Additional headers to include in the request

        params : typing.Optional[typing.Dict[str, typing.Any]]
            Query parameters to include in the request

        Returns
        -------
        ProxyResponse
            proxy request successful

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.proxy.get(
                url="https://example.com/api/endpoint",
                external_user_id="external_user_id",
                account_id="account_id",
                headers={"Extra-Downstream-Header": "some value"}
                params={"limit": 10},
            )


        asyncio.run(main())
        """
        url_64 = base64.urlsafe_b64encode(url.encode()).decode()
        downstream_headers = {
            f"x-pd-proxy-{header}": value
            for header, value in (headers or {}).items()
        }
        request_options = RequestOptions(
            additional_headers=downstream_headers,
            additional_query_parameters=params,
        )
        _response = await self._raw_client.get(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request_options=request_options)
        return _response.data

    async def post(
        self,
        url: str,
        *,
        external_user_id: str,
        account_id: str,
        headers: typing.Optional[typing.Dict[str, typing.Any]] = None,
        body: typing.Optional[typing.Dict[
            str,
            typing.Optional[typing.Any],
        ]] = None,
        params: typing.Optional[typing.Dict[str, typing.Any]] = None,
    ) -> ProxyResponse:
        """
        Parameters
        ----------
        url : str
            Target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        headers : typing.Optional[typing.Dict[str, typing.Any]]
            Additional headers to include in the request

        body : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Request body data

        params : typing.Optional[typing.Dict[str, typing.Any]]
            Query parameters to include in the request

        Returns
        -------
        ProxyResponse
            proxy request successful

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.proxy.post(
                url="https://example.com/api/endpoint",
                external_user_id="external_user_id",
                account_id="account_id",
                headers={"Content-Type": "application/json"},
                body={"key": "value"},
            )


        asyncio.run(main())
        """
        url_64 = base64.urlsafe_b64encode(url.encode()).decode()
        downstream_headers = {
            f"x-pd-proxy-{header}": value
            for header, value in (headers or {}).items()
        }
        request_options = RequestOptions(
            additional_headers=downstream_headers,
            additional_query_parameters=params,
        )
        _response = await self._raw_client.post(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=body or {},
            request_options=request_options,
        )
        return _response.data

    async def put(
        self,
        url: str,
        *,
        external_user_id: str,
        account_id: str,
        headers: typing.Optional[typing.Dict[str, typing.Any]] = None,
        body: typing.Optional[typing.Dict[
            str,
            typing.Optional[typing.Any],
        ]] = None,
        params: typing.Optional[typing.Dict[str, typing.Any]] = None,
    ) -> ProxyResponse:
        """
        Parameters
        ----------
        url : str
            Target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        headers : typing.Optional[typing.Dict[str, typing.Any]]
            Additional headers to include in the request

        body : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Request body data

        params : typing.Optional[typing.Dict[str, typing.Any]]
            Query parameters to include in the request

        Returns
        -------
        ProxyResponse
            proxy request successful

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.proxy.put(
                url="https://example.com/api/endpoint",
                external_user_id="external_user_id",
                account_id="account_id",
                headers={"Content-Type": "application/json"},
                body={"key": "value"},
            )


        asyncio.run(main())
        """
        url_64 = base64.urlsafe_b64encode(url.encode()).decode()
        downstream_headers = {
            f"x-pd-proxy-{header}": value
            for header, value in (headers or {}).items()
        }
        request_options = RequestOptions(
            additional_headers=downstream_headers,
            additional_query_parameters=params,
        )
        _response = await self._raw_client.put(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=body or {},
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self,
        url: str,
        *,
        external_user_id: str,
        account_id: str,
        headers: typing.Optional[typing.Dict[str, typing.Any]] = None,
        params: typing.Optional[typing.Dict[str, typing.Any]] = None,
    ) -> ProxyResponse:
        """
        Parameters
        ----------
        url : str
            Target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        headers : typing.Optional[typing.Dict[str, typing.Any]]
            Additional headers to include in the request

        params : typing.Optional[typing.Dict[str, typing.Any]]
            Query parameters to include in the request

        Returns
        -------
        ProxyResponse
            proxy request successful

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.proxy.delete(
                url="https://example.com/api/endpoint",
                external_user_id="external_user_id",
                account_id="account_id",
                headers={"Extra-Downstream-Header": "some value"}
            )


        asyncio.run(main())
        """
        url_64 = base64.urlsafe_b64encode(url.encode()).decode()
        downstream_headers = {
            f"x-pd-proxy-{header}": value
            for header, value in (headers or {}).items()
        }
        request_options = RequestOptions(
            additional_headers=downstream_headers,
            additional_query_parameters=params,
        )
        _response = await self._raw_client.delete(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request_options=request_options)
        return _response.data

    async def patch(
        self,
        url: str,
        *,
        external_user_id: str,
        account_id: str,
        headers: typing.Optional[typing.Dict[str, typing.Any]] = None,
        body: typing.Optional[typing.Dict[
            str,
            typing.Optional[typing.Any],
        ]] = None,
        params: typing.Optional[typing.Dict[str, typing.Any]] = None,
    ) -> ProxyResponse:
        """
        Parameters
        ----------
        url : str
            Target URL

        external_user_id : str
            The external user ID for the proxy request

        account_id : str
            The account ID to use for authentication

        headers : typing.Optional[typing.Dict[str, typing.Any]]
            Additional headers to include in the request

        body : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Request body data

        params : typing.Optional[typing.Dict[str, typing.Any]]
            Query parameters to include in the request

        Returns
        -------
        ProxyResponse
            proxy request successful

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.proxy.patch(
                url="https://example.com/api/endpoint",
                external_user_id="external_user_id",
                account_id="account_id",
                headers={"Content-Type": "application/json"},
                body={"key": "value"},
            )


        asyncio.run(main())
        """
        url_64 = base64.urlsafe_b64encode(url.encode()).decode()
        downstream_headers = {
            f"x-pd-proxy-{header}": value
            for header, value in (headers or {}).items()
        }
        request_options = RequestOptions(
            additional_headers=downstream_headers,
            additional_query_parameters=params,
        )
        _response = await self._raw_client.patch(
            url_64,
            external_user_id=external_user_id,
            account_id=account_id,
            request=body or {},
            request_options=request_options,
        )
        return _response.data
