# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.component import Component
from ..types.configure_prop_response import ConfigurePropResponse
from ..types.configured_props import ConfiguredProps
from ..types.deployed_component import DeployedComponent
from ..types.reload_props_response import ReloadPropsResponse
from .raw_client import AsyncRawTriggersClient, RawTriggersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TriggersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTriggersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTriggersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTriggersClient
        """
        return self._raw_client

    def list(
        self,
        *,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        q: typing.Optional[str] = None,
        app: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Component]:
        """
        Retrieve available triggers with optional search and app filtering

        Parameters
        ----------
        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        q : typing.Optional[str]
            A search query to filter the triggers

        app : typing.Optional[str]
            The ID or name slug of the app to filter the triggers

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Component]
            triggers listed

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        response = client.triggers.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            after=after, before=before, limit=limit, q=q, app=app, request_options=request_options
        )

    def retrieve(self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Component:
        """
        Get detailed configuration for a specific trigger by its key

        Parameters
        ----------
        component_id : str
            The key that uniquely identifies the component (e.g., 'slack-send-message')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Component
            trigger retrieved

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.triggers.retrieve(
            component_id="component_id",
        )
        """
        _response = self._raw_client.retrieve(component_id, request_options=request_options)
        return _response.data

    def configure_prop(
        self,
        *,
        id: str,
        external_user_id: str,
        prop_name: str,
        blocking: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[ConfiguredProps] = OMIT,
        dynamic_props_id: typing.Optional[str] = OMIT,
        page: typing.Optional[float] = OMIT,
        prev_context: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        query: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigurePropResponse:
        """
        Retrieve remote options for a given prop for a trigger

        Parameters
        ----------
        id : str
            The component ID

        external_user_id : str
            The external user ID

        prop_name : str
            The name of the prop to configure

        blocking : typing.Optional[bool]
            Whether this operation should block until completion

        configured_props : typing.Optional[ConfiguredProps]

        dynamic_props_id : typing.Optional[str]
            The ID for dynamic props

        page : typing.Optional[float]
            Page number for paginated results

        prev_context : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Previous context for pagination

        query : typing.Optional[str]
            Search query for filtering options

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigurePropResponse
            trigger configuration started

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.triggers.configure_prop(
            id="id",
            external_user_id="external_user_id",
            prop_name="prop_name",
        )
        """
        _response = self._raw_client.configure_prop(
            id=id,
            external_user_id=external_user_id,
            prop_name=prop_name,
            blocking=blocking,
            configured_props=configured_props,
            dynamic_props_id=dynamic_props_id,
            page=page,
            prev_context=prev_context,
            query=query,
            request_options=request_options,
        )
        return _response.data

    def reload_props(
        self,
        *,
        id: str,
        external_user_id: str,
        blocking: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[ConfiguredProps] = OMIT,
        dynamic_props_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReloadPropsResponse:
        """
        Reload the prop definition based on the currently configured props

        Parameters
        ----------
        id : str
            The component ID

        external_user_id : str
            The external user ID

        blocking : typing.Optional[bool]
            Whether this operation should block until completion

        configured_props : typing.Optional[ConfiguredProps]

        dynamic_props_id : typing.Optional[str]
            The ID for dynamic props

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReloadPropsResponse
            trigger props reloaded

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.triggers.reload_props(
            id="id",
            external_user_id="external_user_id",
        )
        """
        _response = self._raw_client.reload_props(
            id=id,
            external_user_id=external_user_id,
            blocking=blocking,
            configured_props=configured_props,
            dynamic_props_id=dynamic_props_id,
            request_options=request_options,
        )
        return _response.data

    def deploy(
        self,
        *,
        id: str,
        external_user_id: str,
        configured_props: typing.Optional[ConfiguredProps] = OMIT,
        dynamic_props_id: typing.Optional[str] = OMIT,
        webhook_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeployedComponent:
        """
        Deploy a trigger to listen for and emit events

        Parameters
        ----------
        id : str
            The trigger component ID

        external_user_id : str
            The external user ID

        configured_props : typing.Optional[ConfiguredProps]

        dynamic_props_id : typing.Optional[str]
            The ID for dynamic props

        webhook_url : typing.Optional[str]
            Optional webhook URL to receive trigger events

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeployedComponent
            trigger deployed

        Examples
        --------
        from pipedream import Pipedream

        client = Pipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.triggers.deploy(
            id="id",
            external_user_id="external_user_id",
        )
        """
        _response = self._raw_client.deploy(
            id=id,
            external_user_id=external_user_id,
            configured_props=configured_props,
            dynamic_props_id=dynamic_props_id,
            webhook_url=webhook_url,
            request_options=request_options,
        )
        return _response.data


class AsyncTriggersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTriggersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTriggersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTriggersClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        q: typing.Optional[str] = None,
        app: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Component]:
        """
        Retrieve available triggers with optional search and app filtering

        Parameters
        ----------
        after : typing.Optional[str]
            The cursor to start from for pagination

        before : typing.Optional[str]
            The cursor to end before for pagination

        limit : typing.Optional[int]
            The maximum number of results to return

        q : typing.Optional[str]
            A search query to filter the triggers

        app : typing.Optional[str]
            The ID or name slug of the app to filter the triggers

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Component]
            triggers listed

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            response = await client.triggers.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            after=after, before=before, limit=limit, q=q, app=app, request_options=request_options
        )

    async def retrieve(
        self, component_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Component:
        """
        Get detailed configuration for a specific trigger by its key

        Parameters
        ----------
        component_id : str
            The key that uniquely identifies the component (e.g., 'slack-send-message')

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Component
            trigger retrieved

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.triggers.retrieve(
                component_id="component_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(component_id, request_options=request_options)
        return _response.data

    async def configure_prop(
        self,
        *,
        id: str,
        external_user_id: str,
        prop_name: str,
        blocking: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[ConfiguredProps] = OMIT,
        dynamic_props_id: typing.Optional[str] = OMIT,
        page: typing.Optional[float] = OMIT,
        prev_context: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        query: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConfigurePropResponse:
        """
        Retrieve remote options for a given prop for a trigger

        Parameters
        ----------
        id : str
            The component ID

        external_user_id : str
            The external user ID

        prop_name : str
            The name of the prop to configure

        blocking : typing.Optional[bool]
            Whether this operation should block until completion

        configured_props : typing.Optional[ConfiguredProps]

        dynamic_props_id : typing.Optional[str]
            The ID for dynamic props

        page : typing.Optional[float]
            Page number for paginated results

        prev_context : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Previous context for pagination

        query : typing.Optional[str]
            Search query for filtering options

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConfigurePropResponse
            trigger configuration started

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.triggers.configure_prop(
                id="id",
                external_user_id="external_user_id",
                prop_name="prop_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.configure_prop(
            id=id,
            external_user_id=external_user_id,
            prop_name=prop_name,
            blocking=blocking,
            configured_props=configured_props,
            dynamic_props_id=dynamic_props_id,
            page=page,
            prev_context=prev_context,
            query=query,
            request_options=request_options,
        )
        return _response.data

    async def reload_props(
        self,
        *,
        id: str,
        external_user_id: str,
        blocking: typing.Optional[bool] = OMIT,
        configured_props: typing.Optional[ConfiguredProps] = OMIT,
        dynamic_props_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReloadPropsResponse:
        """
        Reload the prop definition based on the currently configured props

        Parameters
        ----------
        id : str
            The component ID

        external_user_id : str
            The external user ID

        blocking : typing.Optional[bool]
            Whether this operation should block until completion

        configured_props : typing.Optional[ConfiguredProps]

        dynamic_props_id : typing.Optional[str]
            The ID for dynamic props

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReloadPropsResponse
            trigger props reloaded

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.triggers.reload_props(
                id="id",
                external_user_id="external_user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.reload_props(
            id=id,
            external_user_id=external_user_id,
            blocking=blocking,
            configured_props=configured_props,
            dynamic_props_id=dynamic_props_id,
            request_options=request_options,
        )
        return _response.data

    async def deploy(
        self,
        *,
        id: str,
        external_user_id: str,
        configured_props: typing.Optional[ConfiguredProps] = OMIT,
        dynamic_props_id: typing.Optional[str] = OMIT,
        webhook_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeployedComponent:
        """
        Deploy a trigger to listen for and emit events

        Parameters
        ----------
        id : str
            The trigger component ID

        external_user_id : str
            The external user ID

        configured_props : typing.Optional[ConfiguredProps]

        dynamic_props_id : typing.Optional[str]
            The ID for dynamic props

        webhook_url : typing.Optional[str]
            Optional webhook URL to receive trigger events

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeployedComponent
            trigger deployed

        Examples
        --------
        import asyncio

        from pipedream import AsyncPipedream

        client = AsyncPipedream(
            project_id="YOUR_PROJECT_ID",
            project_environment="YOUR_PROJECT_ENVIRONMENT",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.triggers.deploy(
                id="id",
                external_user_id="external_user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deploy(
            id=id,
            external_user_id=external_user_id,
            configured_props=configured_props,
            dynamic_props_id=dynamic_props_id,
            webhook_url=webhook_url,
            request_options=request_options,
        )
        return _response.data
