# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .configured_props import ConfiguredProps


class ConfigurePropOpts(UniversalBaseModel):
    """
    Request options for configuring a component's prop
    """

    id: str = pydantic.Field()
    """
    The component ID
    """

    external_user_id: str = pydantic.Field()
    """
    The external user ID
    """

    prop_name: str = pydantic.Field()
    """
    The name of the prop to configure
    """

    blocking: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this operation should block until completion
    """

    configured_props: typing.Optional[ConfiguredProps] = None
    dynamic_props_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID for dynamic props
    """

    page: typing.Optional[float] = pydantic.Field(default=None)
    """
    Page number for paginated results
    """

    prev_context: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Previous context for pagination
    """

    query: typing.Optional[str] = pydantic.Field(default=None)
    """
    Search query for filtering options
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
