# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .configure_prop_options import ConfigurePropOptions
from .observation import Observation


class ConfigurePropResponse(UniversalBaseModel):
    """
    Response received after configuring a component's prop
    """

    options: typing.Optional[ConfigurePropOptions] = None
    string_options: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Available options for the configured prop
    """

    observations: typing.Optional[typing.List[Observation]] = None
    context: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    New context after configuring the prop
    """

    errors: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Any errors that occurred during configuration
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
