# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class ConfiguredPropValueSql(UniversalBaseModel):
    value: str = pydantic.Field()
    """
    The raw SQL query, as provided by the user
    """

    query: str = pydantic.Field()
    """
    The SQL query to execute
    """

    params: typing.List[str] = pydantic.Field()
    """
    The list of parameters for the prepared statement
    """

    use_prepared_statements: typing_extensions.Annotated[bool, FieldMetadata(alias="usePreparedStatements")] = (
        pydantic.Field()
    )
    """
    Whether to use prepared statements for the query or not
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
