# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .configurable_prop import ConfigurableProp


class DynamicProps(UniversalBaseModel):
    """
    Dynamic properties of a saved component
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique ID of the dynamic prop
    """

    configurable_props: typing_extensions.Annotated[
        typing.Optional[typing.List[ConfigurableProp]], FieldMetadata(alias="configurableProps")
    ] = pydantic.Field(default=None)
    """
    The updated configurable properties
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
