# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .observation_error import ObservationError


class Observation(UniversalBaseModel):
    """
    Any logs produced during the configuration of the prop
    """

    err: typing.Optional[ObservationError] = None
    k: str = pydantic.Field()
    """
    The source of the log (e.g. `console.log`)
    """

    msg: typing.Optional[str] = pydantic.Field(default=None)
    """
    The log message
    """

    ts: float = pydantic.Field()
    """
    The time at which the log was produced, as milliseconds since the epoch
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
