# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .configured_props import ConfiguredProps


class ReloadPropsOpts(UniversalBaseModel):
    """
    Request options for reloading a component's props when dealing with dynamic props
    """

    id: str = pydantic.Field()
    """
    The component ID
    """

    external_user_id: str = pydantic.Field()
    """
    The external user ID
    """

    blocking: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this operation should block until completion
    """

    configured_props: typing.Optional[ConfiguredProps] = None
    dynamic_props_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID for dynamic props
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
