# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-eks. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._enums import *
from .vpc_cni_addon import VpcCniAddon
import pulumi_aws
import pulumi_kubernetes

__all__ = [
    'AccessEntryArgs',
    'AccessEntryArgsDict',
    'AccessPolicyAssociationArgs',
    'AccessPolicyAssociationArgsDict',
    'AutoModeOptionsArgs',
    'AutoModeOptionsArgsDict',
    'ClusterComputeConfigArgs',
    'ClusterComputeConfigArgsDict',
    'ClusterNodeGroupOptionsArgs',
    'ClusterNodeGroupOptionsArgsDict',
    'CoreDataArgs',
    'CoreDataArgsDict',
    'CoreDnsAddonOptionsArgs',
    'CoreDnsAddonOptionsArgsDict',
    'CreationRoleProviderArgs',
    'CreationRoleProviderArgsDict',
    'FargateProfileArgs',
    'FargateProfileArgsDict',
    'KubeProxyAddonOptionsArgs',
    'KubeProxyAddonOptionsArgsDict',
    'KubeconfigOptionsArgs',
    'KubeconfigOptionsArgsDict',
    'NodeadmOptionsArgs',
    'NodeadmOptionsArgsDict',
    'RoleMappingArgs',
    'RoleMappingArgsDict',
    'StorageClassArgs',
    'StorageClassArgsDict',
    'TaintArgs',
    'TaintArgsDict',
    'UserMappingArgs',
    'UserMappingArgsDict',
    'VpcCniOptionsArgs',
    'VpcCniOptionsArgsDict',
]

MYPY = False

if not MYPY:
    class AccessEntryArgsDict(TypedDict):
        """
        Access entries allow an IAM principal to access your cluster.

        You have the following options for authorizing an IAM principal to access Kubernetes objects on your cluster: Kubernetes role-based access control (RBAC), Amazon EKS, or both.
        Kubernetes RBAC authorization requires you to create and manage Kubernetes Role , ClusterRole , RoleBinding , and ClusterRoleBinding objects, in addition to managing access entries. If you use Amazon EKS authorization exclusively, you don't need to create and manage Kubernetes Role , ClusterRole , RoleBinding , and ClusterRoleBinding objects.
        """
        principal_arn: pulumi.Input[str]
        """
        The IAM Principal ARN which requires Authentication access to the EKS cluster.
        """
        access_policies: NotRequired[Mapping[str, pulumi.Input['AccessPolicyAssociationArgsDict']]]
        """
        The access policies to associate to the access entry.
        """
        kubernetes_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of groups within Kubernetes to which the IAM principal is mapped to.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        The tags to apply to the AccessEntry.
        """
        type: NotRequired[pulumi.Input['AccessEntryType']]
        """
        The type of the new access entry. Valid values are STANDARD, FARGATE_LINUX, EC2_LINUX, and EC2_WINDOWS.
        Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or kubernetesGroup, and prevent associating access policies.
        """
        username: NotRequired[pulumi.Input[str]]
        """
        Defaults to the principalArn if the principal is a user, else defaults to assume-role/session-name.
        """
elif False:
    AccessEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessEntryArgs:
    def __init__(__self__, *,
                 principal_arn: pulumi.Input[str],
                 access_policies: Optional[Mapping[str, pulumi.Input['AccessPolicyAssociationArgs']]] = None,
                 kubernetes_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input['AccessEntryType']] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Access entries allow an IAM principal to access your cluster.

        You have the following options for authorizing an IAM principal to access Kubernetes objects on your cluster: Kubernetes role-based access control (RBAC), Amazon EKS, or both.
        Kubernetes RBAC authorization requires you to create and manage Kubernetes Role , ClusterRole , RoleBinding , and ClusterRoleBinding objects, in addition to managing access entries. If you use Amazon EKS authorization exclusively, you don't need to create and manage Kubernetes Role , ClusterRole , RoleBinding , and ClusterRoleBinding objects.
        :param pulumi.Input[str] principal_arn: The IAM Principal ARN which requires Authentication access to the EKS cluster.
        :param Mapping[str, pulumi.Input['AccessPolicyAssociationArgs']] access_policies: The access policies to associate to the access entry.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kubernetes_groups: A list of groups within Kubernetes to which the IAM principal is mapped to.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags to apply to the AccessEntry.
        :param pulumi.Input['AccessEntryType'] type: The type of the new access entry. Valid values are STANDARD, FARGATE_LINUX, EC2_LINUX, and EC2_WINDOWS.
               Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or kubernetesGroup, and prevent associating access policies.
        :param pulumi.Input[str] username: Defaults to the principalArn if the principal is a user, else defaults to assume-role/session-name.
        """
        pulumi.set(__self__, "principal_arn", principal_arn)
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)
        if kubernetes_groups is not None:
            pulumi.set(__self__, "kubernetes_groups", kubernetes_groups)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> pulumi.Input[str]:
        """
        The IAM Principal ARN which requires Authentication access to the EKS cluster.
        """
        return pulumi.get(self, "principal_arn")

    @principal_arn.setter
    def principal_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "principal_arn", value)

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[Mapping[str, pulumi.Input['AccessPolicyAssociationArgs']]]:
        """
        The access policies to associate to the access entry.
        """
        return pulumi.get(self, "access_policies")

    @access_policies.setter
    def access_policies(self, value: Optional[Mapping[str, pulumi.Input['AccessPolicyAssociationArgs']]]):
        pulumi.set(self, "access_policies", value)

    @property
    @pulumi.getter(name="kubernetesGroups")
    def kubernetes_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of groups within Kubernetes to which the IAM principal is mapped to.
        """
        return pulumi.get(self, "kubernetes_groups")

    @kubernetes_groups.setter
    def kubernetes_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kubernetes_groups", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to apply to the AccessEntry.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['AccessEntryType']]:
        """
        The type of the new access entry. Valid values are STANDARD, FARGATE_LINUX, EC2_LINUX, and EC2_WINDOWS.
        Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or kubernetesGroup, and prevent associating access policies.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['AccessEntryType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Defaults to the principalArn if the principal is a user, else defaults to assume-role/session-name.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class AccessPolicyAssociationArgsDict(TypedDict):
        """
        Associates an access policy and its scope to an IAM principal.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html
        """
        access_scope: pulumi.Input['pulumi_aws.eks.AccessPolicyAssociationAccessScopeArgsDict']
        """
        The scope of the access policy association. This controls whether the access policy is scoped to the cluster or to a particular namespace.
        """
        policy_arn: pulumi.Input[str]
        """
        The ARN of the access policy to associate with the principal
        """
elif False:
    AccessPolicyAssociationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessPolicyAssociationArgs:
    def __init__(__self__, *,
                 access_scope: pulumi.Input['pulumi_aws.eks.AccessPolicyAssociationAccessScopeArgs'],
                 policy_arn: pulumi.Input[str]):
        """
        Associates an access policy and its scope to an IAM principal.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html
        :param pulumi.Input['pulumi_aws.eks.AccessPolicyAssociationAccessScopeArgs'] access_scope: The scope of the access policy association. This controls whether the access policy is scoped to the cluster or to a particular namespace.
        :param pulumi.Input[str] policy_arn: The ARN of the access policy to associate with the principal
        """
        pulumi.set(__self__, "access_scope", access_scope)
        pulumi.set(__self__, "policy_arn", policy_arn)

    @property
    @pulumi.getter(name="accessScope")
    def access_scope(self) -> pulumi.Input['pulumi_aws.eks.AccessPolicyAssociationAccessScopeArgs']:
        """
        The scope of the access policy association. This controls whether the access policy is scoped to the cluster or to a particular namespace.
        """
        return pulumi.get(self, "access_scope")

    @access_scope.setter
    def access_scope(self, value: pulumi.Input['pulumi_aws.eks.AccessPolicyAssociationAccessScopeArgs']):
        pulumi.set(self, "access_scope", value)

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the access policy to associate with the principal
        """
        return pulumi.get(self, "policy_arn")

    @policy_arn.setter
    def policy_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_arn", value)


if not MYPY:
    class AutoModeOptionsArgsDict(TypedDict):
        """
        Configuration Options for EKS Auto Mode. If EKS Auto Mode is enabled, AWS will manage cluster infrastructure on your behalf.

        For more information, see: https://docs.aws.amazon.com/eks/latest/userguide/automode.html
        """
        enabled: bool
        """
        Whether to enable EKS Auto Mode. If enabled, EKS will manage node pools, EBS volumes and Load Balancers for you.
        When enabled, the vpc-cni and kube-proxy will not be enabled by default because EKS Auto Mode includes pod networking capabilities.
        """
        compute_config: NotRequired[pulumi.Input['ClusterComputeConfigArgsDict']]
        """
        Compute configuration for EKS Auto Mode.
        """
        create_node_role: NotRequired[bool]
        """
        Whether to create an IAM role for the EKS Auto Mode node group if none is provided in `computeConfig`.
        """
elif False:
    AutoModeOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AutoModeOptionsArgs:
    def __init__(__self__, *,
                 enabled: bool,
                 compute_config: Optional[pulumi.Input['ClusterComputeConfigArgs']] = None,
                 create_node_role: Optional[bool] = None):
        """
        Configuration Options for EKS Auto Mode. If EKS Auto Mode is enabled, AWS will manage cluster infrastructure on your behalf.

        For more information, see: https://docs.aws.amazon.com/eks/latest/userguide/automode.html
        :param bool enabled: Whether to enable EKS Auto Mode. If enabled, EKS will manage node pools, EBS volumes and Load Balancers for you.
               When enabled, the vpc-cni and kube-proxy will not be enabled by default because EKS Auto Mode includes pod networking capabilities.
        :param pulumi.Input['ClusterComputeConfigArgs'] compute_config: Compute configuration for EKS Auto Mode.
        :param bool create_node_role: Whether to create an IAM role for the EKS Auto Mode node group if none is provided in `computeConfig`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if compute_config is not None:
            pulumi.set(__self__, "compute_config", compute_config)
        if create_node_role is None:
            create_node_role = True
        if create_node_role is not None:
            pulumi.set(__self__, "create_node_role", create_node_role)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to enable EKS Auto Mode. If enabled, EKS will manage node pools, EBS volumes and Load Balancers for you.
        When enabled, the vpc-cni and kube-proxy will not be enabled by default because EKS Auto Mode includes pod networking capabilities.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: bool):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="computeConfig")
    def compute_config(self) -> Optional[pulumi.Input['ClusterComputeConfigArgs']]:
        """
        Compute configuration for EKS Auto Mode.
        """
        return pulumi.get(self, "compute_config")

    @compute_config.setter
    def compute_config(self, value: Optional[pulumi.Input['ClusterComputeConfigArgs']]):
        pulumi.set(self, "compute_config", value)

    @property
    @pulumi.getter(name="createNodeRole")
    def create_node_role(self) -> Optional[bool]:
        """
        Whether to create an IAM role for the EKS Auto Mode node group if none is provided in `computeConfig`.
        """
        return pulumi.get(self, "create_node_role")

    @create_node_role.setter
    def create_node_role(self, value: Optional[bool]):
        pulumi.set(self, "create_node_role", value)


if not MYPY:
    class ClusterComputeConfigArgsDict(TypedDict):
        """
        Configuration for the compute capability of your EKS Auto Mode cluster.
        """
        node_pools: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Configuration for node pools that defines the compute resources for your EKS Auto Mode cluster. Valid options are `general-purpose` and `system`.

        By default, the built-in `system` and `general-purpose` nodepools are enabled.
        """
        node_role_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster. This value cannot be changed after the compute capability of EKS Auto Mode is enabled.
        """
elif False:
    ClusterComputeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterComputeConfigArgs:
    def __init__(__self__, *,
                 node_pools: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_role_arn: Optional[pulumi.Input[str]] = None):
        """
        Configuration for the compute capability of your EKS Auto Mode cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_pools: Configuration for node pools that defines the compute resources for your EKS Auto Mode cluster. Valid options are `general-purpose` and `system`.
               
               By default, the built-in `system` and `general-purpose` nodepools are enabled.
        :param pulumi.Input[str] node_role_arn: The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster. This value cannot be changed after the compute capability of EKS Auto Mode is enabled.
        """
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if node_role_arn is not None:
            pulumi.set(__self__, "node_role_arn", node_role_arn)

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Configuration for node pools that defines the compute resources for your EKS Auto Mode cluster. Valid options are `general-purpose` and `system`.

        By default, the built-in `system` and `general-purpose` nodepools are enabled.
        """
        return pulumi.get(self, "node_pools")

    @node_pools.setter
    def node_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_pools", value)

    @property
    @pulumi.getter(name="nodeRoleArn")
    def node_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM Role EKS will assign to EC2 Managed Instances in your EKS Auto Mode cluster. This value cannot be changed after the compute capability of EKS Auto Mode is enabled.
        """
        return pulumi.get(self, "node_role_arn")

    @node_role_arn.setter
    def node_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_role_arn", value)


if not MYPY:
    class ClusterNodeGroupOptionsArgsDict(TypedDict):
        """
        Describes the configuration options accepted by a cluster to create its own node groups.
        """
        ami_id: NotRequired[pulumi.Input[str]]
        """
        The AMI ID to use for the worker nodes.

        Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.

        Note: `amiId` and `gpu` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        """
        ami_type: NotRequired[pulumi.Input[str]]
        """
        The AMI Type to use for the worker nodes. 

        Only applicable when setting an AMI ID that is of type `arm64`. 

        Note: `amiType` and `gpu` are mutually exclusive.
        """
        auto_scaling_group_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.

        Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        bootstrap_extra_args: NotRequired[pulumi.Input[str]]
        """
        Additional args to pass directly to `/etc/eks/bootstrap.sh`. For details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        """
        bottlerocket_settings: NotRequired[pulumi.Input[Mapping[str, Any]]]
        """
        The configuration settings for Bottlerocket OS.
        The settings will get merged with the base settings the provider uses to configure Bottlerocket.

        This includes:
          - settings.kubernetes.api-server
          - settings.kubernetes.cluster-certificate
          - settings.kubernetes.cluster-name
          - settings.kubernetes.cluster-dns-ip

        For an overview of the available settings, see https://bottlerocket.dev/en/os/1.20.x/api/settings/.
        """
        cloud_formation_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        The tags to apply to the CloudFormation Stack of the Worker NodeGroup.

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        cluster_ingress_rule: NotRequired[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']]
        """
        The ingress rule that gives node group access.
        """
        cluster_ingress_rule_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the ingress rule that gives node group access.
        """
        desired_capacity: NotRequired[pulumi.Input[int]]
        """
        The number of worker nodes that should be running in the cluster. Defaults to 2.
        """
        enable_detailed_monitoring: NotRequired[pulumi.Input[bool]]
        """
        Enables/disables detailed monitoring of the EC2 instances.

        With detailed monitoring, all metrics, including status check metrics, are available in 1-minute intervals.
        When enabled, you can also get aggregated data across groups of similar instances.

        Note: You are charged per metric that is sent to CloudWatch. You are not charged for data storage.
        For more information, see "Paid tier" and "Example 1 - EC2 Detailed Monitoring" here https://aws.amazon.com/cloudwatch/pricing/.
        """
        encrypt_root_block_device: NotRequired[pulumi.Input[bool]]
        """
        Encrypt the root block device of the nodes in the node group.
        """
        extra_node_security_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]]
        """
        Extra security groups to attach on all nodes in this worker node group.

        This additional set of security groups captures any user application rules that will be needed for the nodes.
        """
        gpu: NotRequired[pulumi.Input[bool]]
        """
        Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.

        Defaults to false.

        Note: `gpu` and `amiId` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
        - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        """
        ignore_scaling_changes: NotRequired[bool]
        """
        Whether to ignore changes to the desired size of the Auto Scaling Group. This is useful when using Cluster Autoscaler.

        See [EKS best practices](https://aws.github.io/aws-eks-best-practices/cluster-autoscaling/) for more details.
        """
        instance_profile: NotRequired['pulumi_aws.iam.InstanceProfile']
        """
        The IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        """
        instance_profile_name: NotRequired[pulumi.Input[str]]
        """
        The name of the IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        """
        instance_type: NotRequired[pulumi.Input[str]]
        """
        The instance type to use for the cluster's nodes. Defaults to "t3.medium".
        """
        key_name: NotRequired[pulumi.Input[str]]
        """
        Name of the key pair to use for SSH access to worker nodes.
        """
        kubelet_extra_args: NotRequired[pulumi.Input[str]]
        """
        Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the explicit `kubeletExtraArgs`.
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Custom k8s node labels to be attached to each worker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        """
        launch_template_tag_specifications: NotRequired[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgsDict']]]]
        """
        The tag specifications to apply to the launch template.
        """
        max_size: NotRequired[pulumi.Input[int]]
        """
        The maximum number of worker nodes running in the cluster. Defaults to 2.
        """
        min_refresh_percentage: NotRequired[pulumi.Input[int]]
        """
        The minimum amount of instances that should remain available during an instance refresh, expressed as a percentage. Defaults to 50.
        """
        min_size: NotRequired[pulumi.Input[int]]
        """
        The minimum number of worker nodes running in the cluster. Defaults to 1.
        """
        node_associate_public_ip_address: NotRequired[pulumi.Input[bool]]
        """
        Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        """
        node_public_key: NotRequired[pulumi.Input[str]]
        """
        Public key material for SSH access to worker nodes. See allowed formats at:
        https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
        If not provided, no SSH access is enabled on VMs.
        """
        node_root_volume_delete_on_termination: NotRequired[pulumi.Input[bool]]
        """
        Whether the root block device should be deleted on termination of the instance. Defaults to true.
        """
        node_root_volume_encrypted: NotRequired[pulumi.Input[bool]]
        """
        Whether to encrypt a cluster node's root volume. Defaults to false.
        """
        node_root_volume_iops: NotRequired[pulumi.Input[int]]
        """
        The amount of provisioned IOPS. This is only valid with a volumeType of 'io1'.
        """
        node_root_volume_size: NotRequired[pulumi.Input[int]]
        """
        The size in GiB of a cluster node's root volume. Defaults to 20.
        """
        node_root_volume_throughput: NotRequired[pulumi.Input[int]]
        """
        Provisioned throughput performance in integer MiB/s for a cluster node's root volume. This is only valid with a volumeType of 'gp3'.
        """
        node_root_volume_type: NotRequired[pulumi.Input[str]]
        """
        Configured EBS type for a cluster node's root volume. Default is 'gp2'. Supported values are 'standard', 'gp2', 'gp3', 'st1', 'sc1', 'io1'.
        """
        node_security_group: NotRequired[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]
        """
        The security group for the worker node group to communicate with the cluster.

        This security group requires specific inbound and outbound rules.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html

        Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        """
        node_security_group_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the security group for the worker node group to communicate with the cluster.

        This security group requires specific inbound and outbound rules.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html

        Note: The `nodeSecurityGroupId` option and the cluster option `nodeSecurityGroupTags` are mutually exclusive.
        """
        node_subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The set of subnets to override and use for the worker node group.

        Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        """
        node_user_data: NotRequired[pulumi.Input[str]]
        """
        Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        """
        node_user_data_override: NotRequired[pulumi.Input[str]]
        """
        User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        """
        nodeadm_extra_options: NotRequired[pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgsDict']]]]
        """
        Extra nodeadm configuration sections to be added to the nodeadm user data. This can be shell scripts, nodeadm NodeConfig or any other user data compatible script. When configuring additional nodeadm NodeConfig sections, they'll be merged with the base settings the provider sets. You can overwrite base settings or provide additional settings this way.
        The base settings the provider sets are:
          - cluster.name
          - cluster.apiServerEndpoint
          - cluster.certificateAuthority
          - cluster.cidr

        Note: This is only applicable when using AL2023.
        See for more details:
          - https://awslabs.github.io/amazon-eks-ami/nodeadm/
          - https://awslabs.github.io/amazon-eks-ami/nodeadm/doc/api/
        """
        operating_system: NotRequired[pulumi.Input['OperatingSystem']]
        """
        The type of OS to use for the node group. Will be used to determine the right EKS optimized AMI to use based on the instance types and gpu configuration.
        Valid values are `RECOMMENDED`, `AL2`, `AL2023` and `Bottlerocket`.

        Defaults to the current recommended OS.
        """
        spot_price: NotRequired[pulumi.Input[str]]
        """
        Bidding price for spot instance. If set, only spot instances will be added as worker node.
        """
        taints: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['TaintArgsDict']]]]
        """
        Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        """
        version: NotRequired[pulumi.Input[str]]
        """
        Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
elif False:
    ClusterNodeGroupOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterNodeGroupOptionsArgs:
    def __init__(__self__, *,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 ami_type: Optional[pulumi.Input[str]] = None,
                 auto_scaling_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 bootstrap_extra_args: Optional[pulumi.Input[str]] = None,
                 bottlerocket_settings: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 cloud_formation_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cluster_ingress_rule: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']] = None,
                 cluster_ingress_rule_id: Optional[pulumi.Input[str]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 enable_detailed_monitoring: Optional[pulumi.Input[bool]] = None,
                 encrypt_root_block_device: Optional[pulumi.Input[bool]] = None,
                 extra_node_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]] = None,
                 gpu: Optional[pulumi.Input[bool]] = None,
                 ignore_scaling_changes: Optional[bool] = None,
                 instance_profile: Optional['pulumi_aws.iam.InstanceProfile'] = None,
                 instance_profile_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kubelet_extra_args: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 launch_template_tag_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs']]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_refresh_percentage: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 node_associate_public_ip_address: Optional[pulumi.Input[bool]] = None,
                 node_public_key: Optional[pulumi.Input[str]] = None,
                 node_root_volume_delete_on_termination: Optional[pulumi.Input[bool]] = None,
                 node_root_volume_encrypted: Optional[pulumi.Input[bool]] = None,
                 node_root_volume_iops: Optional[pulumi.Input[int]] = None,
                 node_root_volume_size: Optional[pulumi.Input[int]] = None,
                 node_root_volume_throughput: Optional[pulumi.Input[int]] = None,
                 node_root_volume_type: Optional[pulumi.Input[str]] = None,
                 node_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 node_security_group_id: Optional[pulumi.Input[str]] = None,
                 node_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_user_data: Optional[pulumi.Input[str]] = None,
                 node_user_data_override: Optional[pulumi.Input[str]] = None,
                 nodeadm_extra_options: Optional[pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]]] = None,
                 operating_system: Optional[pulumi.Input['OperatingSystem']] = None,
                 spot_price: Optional[pulumi.Input[str]] = None,
                 taints: Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Describes the configuration options accepted by a cluster to create its own node groups.
        :param pulumi.Input[str] ami_id: The AMI ID to use for the worker nodes.
               
               Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.
               
               Note: `amiId` and `gpu` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        :param pulumi.Input[str] ami_type: The AMI Type to use for the worker nodes. 
               
               Only applicable when setting an AMI ID that is of type `arm64`. 
               
               Note: `amiType` and `gpu` are mutually exclusive.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] auto_scaling_group_tags: The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.
               
               Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input[str] bootstrap_extra_args: Additional args to pass directly to `/etc/eks/bootstrap.sh`. For details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        :param pulumi.Input[Mapping[str, Any]] bottlerocket_settings: The configuration settings for Bottlerocket OS.
               The settings will get merged with the base settings the provider uses to configure Bottlerocket.
               
               This includes:
                 - settings.kubernetes.api-server
                 - settings.kubernetes.cluster-certificate
                 - settings.kubernetes.cluster-name
                 - settings.kubernetes.cluster-dns-ip
               
               For an overview of the available settings, see https://bottlerocket.dev/en/os/1.20.x/api/settings/.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] cloud_formation_tags: The tags to apply to the CloudFormation Stack of the Worker NodeGroup.
               
               Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroupRule'] cluster_ingress_rule: The ingress rule that gives node group access.
        :param pulumi.Input[str] cluster_ingress_rule_id: The ID of the ingress rule that gives node group access.
        :param pulumi.Input[int] desired_capacity: The number of worker nodes that should be running in the cluster. Defaults to 2.
        :param pulumi.Input[bool] enable_detailed_monitoring: Enables/disables detailed monitoring of the EC2 instances.
               
               With detailed monitoring, all metrics, including status check metrics, are available in 1-minute intervals.
               When enabled, you can also get aggregated data across groups of similar instances.
               
               Note: You are charged per metric that is sent to CloudWatch. You are not charged for data storage.
               For more information, see "Paid tier" and "Example 1 - EC2 Detailed Monitoring" here https://aws.amazon.com/cloudwatch/pricing/.
        :param pulumi.Input[bool] encrypt_root_block_device: Encrypt the root block device of the nodes in the node group.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]] extra_node_security_groups: Extra security groups to attach on all nodes in this worker node group.
               
               This additional set of security groups captures any user application rules that will be needed for the nodes.
        :param pulumi.Input[bool] gpu: Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.
               
               Defaults to false.
               
               Note: `gpu` and `amiId` are mutually exclusive.
               
               See for more details:
               - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
               - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        :param bool ignore_scaling_changes: Whether to ignore changes to the desired size of the Auto Scaling Group. This is useful when using Cluster Autoscaler.
               
               See [EKS best practices](https://aws.github.io/aws-eks-best-practices/cluster-autoscaling/) for more details.
        :param 'pulumi_aws.iam.InstanceProfile' instance_profile: The IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        :param pulumi.Input[str] instance_profile_name: The name of the IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        :param pulumi.Input[str] instance_type: The instance type to use for the cluster's nodes. Defaults to "t3.medium".
        :param pulumi.Input[str] key_name: Name of the key pair to use for SSH access to worker nodes.
        :param pulumi.Input[str] kubelet_extra_args: Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the explicit `kubeletExtraArgs`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Custom k8s node labels to be attached to each worker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs']]] launch_template_tag_specifications: The tag specifications to apply to the launch template.
        :param pulumi.Input[int] max_size: The maximum number of worker nodes running in the cluster. Defaults to 2.
        :param pulumi.Input[int] min_refresh_percentage: The minimum amount of instances that should remain available during an instance refresh, expressed as a percentage. Defaults to 50.
        :param pulumi.Input[int] min_size: The minimum number of worker nodes running in the cluster. Defaults to 1.
        :param pulumi.Input[bool] node_associate_public_ip_address: Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        :param pulumi.Input[str] node_public_key: Public key material for SSH access to worker nodes. See allowed formats at:
               https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
               If not provided, no SSH access is enabled on VMs.
        :param pulumi.Input[bool] node_root_volume_delete_on_termination: Whether the root block device should be deleted on termination of the instance. Defaults to true.
        :param pulumi.Input[bool] node_root_volume_encrypted: Whether to encrypt a cluster node's root volume. Defaults to false.
        :param pulumi.Input[int] node_root_volume_iops: The amount of provisioned IOPS. This is only valid with a volumeType of 'io1'.
        :param pulumi.Input[int] node_root_volume_size: The size in GiB of a cluster node's root volume. Defaults to 20.
        :param pulumi.Input[int] node_root_volume_throughput: Provisioned throughput performance in integer MiB/s for a cluster node's root volume. This is only valid with a volumeType of 'gp3'.
        :param pulumi.Input[str] node_root_volume_type: Configured EBS type for a cluster node's root volume. Default is 'gp2'. Supported values are 'standard', 'gp2', 'gp3', 'st1', 'sc1', 'io1'.
        :param pulumi.Input['pulumi_aws.ec2.SecurityGroup'] node_security_group: The security group for the worker node group to communicate with the cluster.
               
               This security group requires specific inbound and outbound rules.
               
               See for more details:
               https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
               
               Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        :param pulumi.Input[str] node_security_group_id: The ID of the security group for the worker node group to communicate with the cluster.
               
               This security group requires specific inbound and outbound rules.
               
               See for more details:
               https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html
               
               Note: The `nodeSecurityGroupId` option and the cluster option `nodeSecurityGroupTags` are mutually exclusive.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_subnet_ids: The set of subnets to override and use for the worker node group.
               
               Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        :param pulumi.Input[str] node_user_data: Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        :param pulumi.Input[str] node_user_data_override: User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        :param pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]] nodeadm_extra_options: Extra nodeadm configuration sections to be added to the nodeadm user data. This can be shell scripts, nodeadm NodeConfig or any other user data compatible script. When configuring additional nodeadm NodeConfig sections, they'll be merged with the base settings the provider sets. You can overwrite base settings or provide additional settings this way.
               The base settings the provider sets are:
                 - cluster.name
                 - cluster.apiServerEndpoint
                 - cluster.certificateAuthority
                 - cluster.cidr
               
               Note: This is only applicable when using AL2023.
               See for more details:
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/doc/api/
        :param pulumi.Input['OperatingSystem'] operating_system: The type of OS to use for the node group. Will be used to determine the right EKS optimized AMI to use based on the instance types and gpu configuration.
               Valid values are `RECOMMENDED`, `AL2`, `AL2023` and `Bottlerocket`.
               
               Defaults to the current recommended OS.
        :param pulumi.Input[str] spot_price: Bidding price for spot instance. If set, only spot instances will be added as worker node.
        :param pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]] taints: Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        :param pulumi.Input[str] version: Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        if ami_id is not None:
            pulumi.set(__self__, "ami_id", ami_id)
        if ami_type is not None:
            pulumi.set(__self__, "ami_type", ami_type)
        if auto_scaling_group_tags is not None:
            pulumi.set(__self__, "auto_scaling_group_tags", auto_scaling_group_tags)
        if bootstrap_extra_args is not None:
            pulumi.set(__self__, "bootstrap_extra_args", bootstrap_extra_args)
        if bottlerocket_settings is not None:
            pulumi.set(__self__, "bottlerocket_settings", bottlerocket_settings)
        if cloud_formation_tags is not None:
            pulumi.set(__self__, "cloud_formation_tags", cloud_formation_tags)
        if cluster_ingress_rule is not None:
            pulumi.set(__self__, "cluster_ingress_rule", cluster_ingress_rule)
        if cluster_ingress_rule_id is not None:
            pulumi.set(__self__, "cluster_ingress_rule_id", cluster_ingress_rule_id)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if enable_detailed_monitoring is not None:
            pulumi.set(__self__, "enable_detailed_monitoring", enable_detailed_monitoring)
        if encrypt_root_block_device is not None:
            pulumi.set(__self__, "encrypt_root_block_device", encrypt_root_block_device)
        if extra_node_security_groups is not None:
            pulumi.set(__self__, "extra_node_security_groups", extra_node_security_groups)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if ignore_scaling_changes is not None:
            pulumi.set(__self__, "ignore_scaling_changes", ignore_scaling_changes)
        if instance_profile is not None:
            pulumi.set(__self__, "instance_profile", instance_profile)
        if instance_profile_name is not None:
            pulumi.set(__self__, "instance_profile_name", instance_profile_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kubelet_extra_args is not None:
            pulumi.set(__self__, "kubelet_extra_args", kubelet_extra_args)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_template_tag_specifications is not None:
            pulumi.set(__self__, "launch_template_tag_specifications", launch_template_tag_specifications)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_refresh_percentage is not None:
            pulumi.set(__self__, "min_refresh_percentage", min_refresh_percentage)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if node_associate_public_ip_address is not None:
            pulumi.set(__self__, "node_associate_public_ip_address", node_associate_public_ip_address)
        if node_public_key is not None:
            pulumi.set(__self__, "node_public_key", node_public_key)
        if node_root_volume_delete_on_termination is not None:
            pulumi.set(__self__, "node_root_volume_delete_on_termination", node_root_volume_delete_on_termination)
        if node_root_volume_encrypted is not None:
            pulumi.set(__self__, "node_root_volume_encrypted", node_root_volume_encrypted)
        if node_root_volume_iops is not None:
            pulumi.set(__self__, "node_root_volume_iops", node_root_volume_iops)
        if node_root_volume_size is not None:
            pulumi.set(__self__, "node_root_volume_size", node_root_volume_size)
        if node_root_volume_throughput is not None:
            pulumi.set(__self__, "node_root_volume_throughput", node_root_volume_throughput)
        if node_root_volume_type is not None:
            pulumi.set(__self__, "node_root_volume_type", node_root_volume_type)
        if node_security_group is not None:
            pulumi.set(__self__, "node_security_group", node_security_group)
        if node_security_group_id is not None:
            pulumi.set(__self__, "node_security_group_id", node_security_group_id)
        if node_subnet_ids is not None:
            pulumi.set(__self__, "node_subnet_ids", node_subnet_ids)
        if node_user_data is not None:
            pulumi.set(__self__, "node_user_data", node_user_data)
        if node_user_data_override is not None:
            pulumi.set(__self__, "node_user_data_override", node_user_data_override)
        if nodeadm_extra_options is not None:
            pulumi.set(__self__, "nodeadm_extra_options", nodeadm_extra_options)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if spot_price is not None:
            pulumi.set(__self__, "spot_price", spot_price)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI ID to use for the worker nodes.

        Defaults to the latest recommended EKS Optimized Linux AMI from the AWS Systems Manager Parameter Store.

        Note: `amiId` and `gpu` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        """
        return pulumi.get(self, "ami_id")

    @ami_id.setter
    def ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami_id", value)

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI Type to use for the worker nodes. 

        Only applicable when setting an AMI ID that is of type `arm64`. 

        Note: `amiType` and `gpu` are mutually exclusive.
        """
        return pulumi.get(self, "ami_type")

    @ami_type.setter
    def ami_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami_type", value)

    @property
    @pulumi.getter(name="autoScalingGroupTags")
    def auto_scaling_group_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to apply to the NodeGroup's AutoScalingGroup in the CloudFormation Stack.

        Per AWS, all stack-level tags, including automatically created tags, and the `cloudFormationTags` option are propagated to resources that AWS CloudFormation supports, including the AutoScalingGroup. See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        return pulumi.get(self, "auto_scaling_group_tags")

    @auto_scaling_group_tags.setter
    def auto_scaling_group_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "auto_scaling_group_tags", value)

    @property
    @pulumi.getter(name="bootstrapExtraArgs")
    def bootstrap_extra_args(self) -> Optional[pulumi.Input[str]]:
        """
        Additional args to pass directly to `/etc/eks/bootstrap.sh`. For details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
        """
        return pulumi.get(self, "bootstrap_extra_args")

    @bootstrap_extra_args.setter
    def bootstrap_extra_args(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_extra_args", value)

    @property
    @pulumi.getter(name="bottlerocketSettings")
    def bottlerocket_settings(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The configuration settings for Bottlerocket OS.
        The settings will get merged with the base settings the provider uses to configure Bottlerocket.

        This includes:
          - settings.kubernetes.api-server
          - settings.kubernetes.cluster-certificate
          - settings.kubernetes.cluster-name
          - settings.kubernetes.cluster-dns-ip

        For an overview of the available settings, see https://bottlerocket.dev/en/os/1.20.x/api/settings/.
        """
        return pulumi.get(self, "bottlerocket_settings")

    @bottlerocket_settings.setter
    def bottlerocket_settings(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "bottlerocket_settings", value)

    @property
    @pulumi.getter(name="cloudFormationTags")
    def cloud_formation_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags to apply to the CloudFormation Stack of the Worker NodeGroup.

        Note: Given the inheritance of auto-generated CF tags and `cloudFormationTags`, you should either supply the tag in `autoScalingGroupTags` or `cloudFormationTags`, but not both.
        """
        return pulumi.get(self, "cloud_formation_tags")

    @cloud_formation_tags.setter
    def cloud_formation_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "cloud_formation_tags", value)

    @property
    @pulumi.getter(name="clusterIngressRule")
    def cluster_ingress_rule(self) -> Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']]:
        """
        The ingress rule that gives node group access.
        """
        return pulumi.get(self, "cluster_ingress_rule")

    @cluster_ingress_rule.setter
    def cluster_ingress_rule(self, value: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroupRule']]):
        pulumi.set(self, "cluster_ingress_rule", value)

    @property
    @pulumi.getter(name="clusterIngressRuleId")
    def cluster_ingress_rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the ingress rule that gives node group access.
        """
        return pulumi.get(self, "cluster_ingress_rule_id")

    @cluster_ingress_rule_id.setter
    def cluster_ingress_rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ingress_rule_id", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The number of worker nodes that should be running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="enableDetailedMonitoring")
    def enable_detailed_monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables/disables detailed monitoring of the EC2 instances.

        With detailed monitoring, all metrics, including status check metrics, are available in 1-minute intervals.
        When enabled, you can also get aggregated data across groups of similar instances.

        Note: You are charged per metric that is sent to CloudWatch. You are not charged for data storage.
        For more information, see "Paid tier" and "Example 1 - EC2 Detailed Monitoring" here https://aws.amazon.com/cloudwatch/pricing/.
        """
        return pulumi.get(self, "enable_detailed_monitoring")

    @enable_detailed_monitoring.setter
    def enable_detailed_monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_detailed_monitoring", value)

    @property
    @pulumi.getter(name="encryptRootBlockDevice")
    def encrypt_root_block_device(self) -> Optional[pulumi.Input[bool]]:
        """
        Encrypt the root block device of the nodes in the node group.
        """
        return pulumi.get(self, "encrypt_root_block_device")

    @encrypt_root_block_device.setter
    def encrypt_root_block_device(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypt_root_block_device", value)

    @property
    @pulumi.getter(name="extraNodeSecurityGroups")
    def extra_node_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]]:
        """
        Extra security groups to attach on all nodes in this worker node group.

        This additional set of security groups captures any user application rules that will be needed for the nodes.
        """
        return pulumi.get(self, "extra_node_security_groups")

    @extra_node_security_groups.setter
    def extra_node_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]]]):
        pulumi.set(self, "extra_node_security_groups", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the latest recommended EKS Optimized Linux AMI with GPU support for the worker nodes from the AWS Systems Manager Parameter Store.

        Defaults to false.

        Note: `gpu` and `amiId` are mutually exclusive.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html
        - https://docs.aws.amazon.com/eks/latest/userguide/retrieve-ami-id.html
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter(name="ignoreScalingChanges")
    def ignore_scaling_changes(self) -> Optional[bool]:
        """
        Whether to ignore changes to the desired size of the Auto Scaling Group. This is useful when using Cluster Autoscaler.

        See [EKS best practices](https://aws.github.io/aws-eks-best-practices/cluster-autoscaling/) for more details.
        """
        return pulumi.get(self, "ignore_scaling_changes")

    @ignore_scaling_changes.setter
    def ignore_scaling_changes(self, value: Optional[bool]):
        pulumi.set(self, "ignore_scaling_changes", value)

    @property
    @pulumi.getter(name="instanceProfile")
    def instance_profile(self) -> Optional['pulumi_aws.iam.InstanceProfile']:
        """
        The IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        """
        return pulumi.get(self, "instance_profile")

    @instance_profile.setter
    def instance_profile(self, value: Optional['pulumi_aws.iam.InstanceProfile']):
        pulumi.set(self, "instance_profile", value)

    @property
    @pulumi.getter(name="instanceProfileName")
    def instance_profile_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the IAM InstanceProfile to use on the NodeGroup. Properties instanceProfile and instanceProfileName are mutually exclusive.
        """
        return pulumi.get(self, "instance_profile_name")

    @instance_profile_name.setter
    def instance_profile_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_profile_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type to use for the cluster's nodes. Defaults to "t3.medium".
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the key pair to use for SSH access to worker nodes.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kubeletExtraArgs")
    def kubelet_extra_args(self) -> Optional[pulumi.Input[str]]:
        """
        Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. Note that the `labels` and `taints` properties will be applied to this list (using `--node-labels` and `--register-with-taints` respectively) after to the explicit `kubeletExtraArgs`.
        """
        return pulumi.get(self, "kubelet_extra_args")

    @kubelet_extra_args.setter
    def kubelet_extra_args(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubelet_extra_args", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Custom k8s node labels to be attached to each worker node. Adds the given key/value pairs to the `--node-labels` kubelet argument.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchTemplateTagSpecifications")
    def launch_template_tag_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs']]]]:
        """
        The tag specifications to apply to the launch template.
        """
        return pulumi.get(self, "launch_template_tag_specifications")

    @launch_template_tag_specifications.setter
    def launch_template_tag_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.LaunchTemplateTagSpecificationArgs']]]]):
        pulumi.set(self, "launch_template_tag_specifications", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of worker nodes running in the cluster. Defaults to 2.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minRefreshPercentage")
    def min_refresh_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum amount of instances that should remain available during an instance refresh, expressed as a percentage. Defaults to 50.
        """
        return pulumi.get(self, "min_refresh_percentage")

    @min_refresh_percentage.setter
    def min_refresh_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_refresh_percentage", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of worker nodes running in the cluster. Defaults to 1.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="nodeAssociatePublicIpAddress")
    def node_associate_public_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to auto-assign public IP addresses on the EKS worker nodes. If this toggle is set to true, the EKS workers will be auto-assigned public IPs. If false, they will not be auto-assigned public IPs.
        """
        return pulumi.get(self, "node_associate_public_ip_address")

    @node_associate_public_ip_address.setter
    def node_associate_public_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_associate_public_ip_address", value)

    @property
    @pulumi.getter(name="nodePublicKey")
    def node_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Public key material for SSH access to worker nodes. See allowed formats at:
        https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
        If not provided, no SSH access is enabled on VMs.
        """
        return pulumi.get(self, "node_public_key")

    @node_public_key.setter
    def node_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_public_key", value)

    @property
    @pulumi.getter(name="nodeRootVolumeDeleteOnTermination")
    def node_root_volume_delete_on_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the root block device should be deleted on termination of the instance. Defaults to true.
        """
        return pulumi.get(self, "node_root_volume_delete_on_termination")

    @node_root_volume_delete_on_termination.setter
    def node_root_volume_delete_on_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_root_volume_delete_on_termination", value)

    @property
    @pulumi.getter(name="nodeRootVolumeEncrypted")
    def node_root_volume_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to encrypt a cluster node's root volume. Defaults to false.
        """
        return pulumi.get(self, "node_root_volume_encrypted")

    @node_root_volume_encrypted.setter
    def node_root_volume_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_root_volume_encrypted", value)

    @property
    @pulumi.getter(name="nodeRootVolumeIops")
    def node_root_volume_iops(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of provisioned IOPS. This is only valid with a volumeType of 'io1'.
        """
        return pulumi.get(self, "node_root_volume_iops")

    @node_root_volume_iops.setter
    def node_root_volume_iops(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_root_volume_iops", value)

    @property
    @pulumi.getter(name="nodeRootVolumeSize")
    def node_root_volume_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size in GiB of a cluster node's root volume. Defaults to 20.
        """
        return pulumi.get(self, "node_root_volume_size")

    @node_root_volume_size.setter
    def node_root_volume_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_root_volume_size", value)

    @property
    @pulumi.getter(name="nodeRootVolumeThroughput")
    def node_root_volume_throughput(self) -> Optional[pulumi.Input[int]]:
        """
        Provisioned throughput performance in integer MiB/s for a cluster node's root volume. This is only valid with a volumeType of 'gp3'.
        """
        return pulumi.get(self, "node_root_volume_throughput")

    @node_root_volume_throughput.setter
    def node_root_volume_throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_root_volume_throughput", value)

    @property
    @pulumi.getter(name="nodeRootVolumeType")
    def node_root_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        Configured EBS type for a cluster node's root volume. Default is 'gp2'. Supported values are 'standard', 'gp2', 'gp3', 'st1', 'sc1', 'io1'.
        """
        return pulumi.get(self, "node_root_volume_type")

    @node_root_volume_type.setter
    def node_root_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_root_volume_type", value)

    @property
    @pulumi.getter(name="nodeSecurityGroup")
    def node_security_group(self) -> Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]:
        """
        The security group for the worker node group to communicate with the cluster.

        This security group requires specific inbound and outbound rules.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html

        Note: The `nodeSecurityGroup` option and the cluster option`nodeSecurityGroupTags` are mutually exclusive.
        """
        return pulumi.get(self, "node_security_group")

    @node_security_group.setter
    def node_security_group(self, value: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]):
        pulumi.set(self, "node_security_group", value)

    @property
    @pulumi.getter(name="nodeSecurityGroupId")
    def node_security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security group for the worker node group to communicate with the cluster.

        This security group requires specific inbound and outbound rules.

        See for more details:
        https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html

        Note: The `nodeSecurityGroupId` option and the cluster option `nodeSecurityGroupTags` are mutually exclusive.
        """
        return pulumi.get(self, "node_security_group_id")

    @node_security_group_id.setter
    def node_security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_security_group_id", value)

    @property
    @pulumi.getter(name="nodeSubnetIds")
    def node_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The set of subnets to override and use for the worker node group.

        Setting this option overrides which subnets to use for the worker node group, regardless if the cluster's `subnetIds` is set, or if `publicSubnetIds` and/or `privateSubnetIds` were set.
        """
        return pulumi.get(self, "node_subnet_ids")

    @node_subnet_ids.setter
    def node_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_subnet_ids", value)

    @property
    @pulumi.getter(name="nodeUserData")
    def node_user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Extra code to run on node startup. This code will run after the AWS EKS bootstrapping code and before the node signals its readiness to the managing CloudFormation stack. This code must be a typical user data script: critically it must begin with an interpreter directive (i.e. a `#!`).
        """
        return pulumi.get(self, "node_user_data")

    @node_user_data.setter
    def node_user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_user_data", value)

    @property
    @pulumi.getter(name="nodeUserDataOverride")
    def node_user_data_override(self) -> Optional[pulumi.Input[str]]:
        """
        User specified code to run on node startup. This code is expected to handle the full AWS EKS bootstrapping code and signal node readiness to the managing CloudFormation stack. This code must be a complete and executable user data script in bash (Linux) or powershell (Windows).

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/worker.html
        """
        return pulumi.get(self, "node_user_data_override")

    @node_user_data_override.setter
    def node_user_data_override(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_user_data_override", value)

    @property
    @pulumi.getter(name="nodeadmExtraOptions")
    def nodeadm_extra_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]]]:
        """
        Extra nodeadm configuration sections to be added to the nodeadm user data. This can be shell scripts, nodeadm NodeConfig or any other user data compatible script. When configuring additional nodeadm NodeConfig sections, they'll be merged with the base settings the provider sets. You can overwrite base settings or provide additional settings this way.
        The base settings the provider sets are:
          - cluster.name
          - cluster.apiServerEndpoint
          - cluster.certificateAuthority
          - cluster.cidr

        Note: This is only applicable when using AL2023.
        See for more details:
          - https://awslabs.github.io/amazon-eks-ami/nodeadm/
          - https://awslabs.github.io/amazon-eks-ami/nodeadm/doc/api/
        """
        return pulumi.get(self, "nodeadm_extra_options")

    @nodeadm_extra_options.setter
    def nodeadm_extra_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]]]):
        pulumi.set(self, "nodeadm_extra_options", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input['OperatingSystem']]:
        """
        The type of OS to use for the node group. Will be used to determine the right EKS optimized AMI to use based on the instance types and gpu configuration.
        Valid values are `RECOMMENDED`, `AL2`, `AL2023` and `Bottlerocket`.

        Defaults to the current recommended OS.
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input['OperatingSystem']]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="spotPrice")
    def spot_price(self) -> Optional[pulumi.Input[str]]:
        """
        Bidding price for spot instance. If set, only spot instances will be added as worker node.
        """
        return pulumi.get(self, "spot_price")

    @spot_price.setter
    def spot_price(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_price", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]]:
        """
        Custom k8s node taints to be attached to each worker node. Adds the given taints to the `--register-with-taints` kubelet argument
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['TaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Desired Kubernetes master / control plane version. If you do not specify a value, the latest available version is used.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class CoreDataArgsDict(TypedDict):
        """
        Defines the core set of data associated with an EKS cluster, including the network in which it runs.
        """
        cluster: pulumi.Input['pulumi_aws.eks.Cluster']
        cluster_iam_role: pulumi.Input['pulumi_aws.iam.Role']
        """
        The IAM Role attached to the EKS Cluster
        """
        endpoint: pulumi.Input[str]
        """
        The EKS cluster's Kubernetes API server endpoint.
        """
        instance_roles: pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]]
        """
        The IAM instance roles for the cluster's nodes.
        """
        node_group_options: pulumi.Input['ClusterNodeGroupOptionsArgsDict']
        """
        The cluster's node group options.
        """
        provider: pulumi.Input['pulumi_kubernetes.Provider']
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        List of subnet IDs for the EKS cluster.
        """
        vpc_id: pulumi.Input[str]
        """
        ID of the cluster's VPC.
        """
        access_entries: NotRequired[pulumi.Input[Sequence[pulumi.Input['AccessEntryArgsDict']]]]
        """
        The access entries added to the cluster.
        """
        aws_provider: NotRequired[pulumi.Input['pulumi_aws.Provider']]
        cluster_security_group: NotRequired[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]
        eks_node_access: NotRequired[pulumi.Input['pulumi_kubernetes.core.v1.ConfigMap']]
        encryption_config: NotRequired[pulumi.Input['pulumi_aws.eks.ClusterEncryptionConfigArgsDict']]
        fargate_profile: NotRequired[pulumi.Input['pulumi_aws.eks.FargateProfile']]
        """
        The Fargate profile used to manage which pods run on Fargate.
        """
        kubeconfig: NotRequired[Any]
        """
        The kubeconfig file for the cluster.
        """
        node_security_group_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Tags attached to the security groups associated with the cluster's worker nodes.
        """
        oidc_provider: NotRequired[pulumi.Input['pulumi_aws.iam.OpenIdConnectProvider']]
        private_subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        List of subnet IDs for the private subnets.
        """
        public_subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        List of subnet IDs for the public subnets.
        """
        storage_classes: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['pulumi_kubernetes.storage.v1.StorageClass']]]]
        """
        The storage class used for persistent storage by the cluster.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        A map of tags assigned to the EKS cluster.
        """
        vpc_cni: NotRequired[pulumi.Input['VpcCniAddon']]
        """
        The VPC CNI for the cluster.
        """
elif False:
    CoreDataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDataArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input['pulumi_aws.eks.Cluster'],
                 cluster_iam_role: pulumi.Input['pulumi_aws.iam.Role'],
                 endpoint: pulumi.Input[str],
                 instance_roles: pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]],
                 node_group_options: pulumi.Input['ClusterNodeGroupOptionsArgs'],
                 provider: pulumi.Input['pulumi_kubernetes.Provider'],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 vpc_id: pulumi.Input[str],
                 access_entries: Optional[pulumi.Input[Sequence[pulumi.Input['AccessEntryArgs']]]] = None,
                 aws_provider: Optional[pulumi.Input['pulumi_aws.Provider']] = None,
                 cluster_security_group: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']] = None,
                 eks_node_access: Optional[pulumi.Input['pulumi_kubernetes.core.v1.ConfigMap']] = None,
                 encryption_config: Optional[pulumi.Input['pulumi_aws.eks.ClusterEncryptionConfigArgs']] = None,
                 fargate_profile: Optional[pulumi.Input['pulumi_aws.eks.FargateProfile']] = None,
                 kubeconfig: Optional[Any] = None,
                 node_security_group_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 oidc_provider: Optional[pulumi.Input['pulumi_aws.iam.OpenIdConnectProvider']] = None,
                 private_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storage_classes: Optional[pulumi.Input[Mapping[str, pulumi.Input['pulumi_kubernetes.storage.v1.StorageClass']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_cni: Optional[pulumi.Input['VpcCniAddon']] = None):
        """
        Defines the core set of data associated with an EKS cluster, including the network in which it runs.
        :param pulumi.Input['pulumi_aws.iam.Role'] cluster_iam_role: The IAM Role attached to the EKS Cluster
        :param pulumi.Input[str] endpoint: The EKS cluster's Kubernetes API server endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]] instance_roles: The IAM instance roles for the cluster's nodes.
        :param pulumi.Input['ClusterNodeGroupOptionsArgs'] node_group_options: The cluster's node group options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet IDs for the EKS cluster.
        :param pulumi.Input[str] vpc_id: ID of the cluster's VPC.
        :param pulumi.Input[Sequence[pulumi.Input['AccessEntryArgs']]] access_entries: The access entries added to the cluster.
        :param pulumi.Input['pulumi_aws.eks.FargateProfile'] fargate_profile: The Fargate profile used to manage which pods run on Fargate.
        :param Any kubeconfig: The kubeconfig file for the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_security_group_tags: Tags attached to the security groups associated with the cluster's worker nodes.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_subnet_ids: List of subnet IDs for the private subnets.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_subnet_ids: List of subnet IDs for the public subnets.
        :param pulumi.Input[Mapping[str, pulumi.Input['pulumi_kubernetes.storage.v1.StorageClass']]] storage_classes: The storage class used for persistent storage by the cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A map of tags assigned to the EKS cluster.
        :param pulumi.Input['VpcCniAddon'] vpc_cni: The VPC CNI for the cluster.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "cluster_iam_role", cluster_iam_role)
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "instance_roles", instance_roles)
        pulumi.set(__self__, "node_group_options", node_group_options)
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if access_entries is not None:
            pulumi.set(__self__, "access_entries", access_entries)
        if aws_provider is not None:
            pulumi.set(__self__, "aws_provider", aws_provider)
        if cluster_security_group is not None:
            pulumi.set(__self__, "cluster_security_group", cluster_security_group)
        if eks_node_access is not None:
            pulumi.set(__self__, "eks_node_access", eks_node_access)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if fargate_profile is not None:
            pulumi.set(__self__, "fargate_profile", fargate_profile)
        if kubeconfig is not None:
            pulumi.set(__self__, "kubeconfig", kubeconfig)
        if node_security_group_tags is not None:
            pulumi.set(__self__, "node_security_group_tags", node_security_group_tags)
        if oidc_provider is not None:
            pulumi.set(__self__, "oidc_provider", oidc_provider)
        if private_subnet_ids is not None:
            pulumi.set(__self__, "private_subnet_ids", private_subnet_ids)
        if public_subnet_ids is not None:
            pulumi.set(__self__, "public_subnet_ids", public_subnet_ids)
        if storage_classes is not None:
            pulumi.set(__self__, "storage_classes", storage_classes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_cni is not None:
            pulumi.set(__self__, "vpc_cni", vpc_cni)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input['pulumi_aws.eks.Cluster']:
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input['pulumi_aws.eks.Cluster']):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="clusterIamRole")
    def cluster_iam_role(self) -> pulumi.Input['pulumi_aws.iam.Role']:
        """
        The IAM Role attached to the EKS Cluster
        """
        return pulumi.get(self, "cluster_iam_role")

    @cluster_iam_role.setter
    def cluster_iam_role(self, value: pulumi.Input['pulumi_aws.iam.Role']):
        pulumi.set(self, "cluster_iam_role", value)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        The EKS cluster's Kubernetes API server endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="instanceRoles")
    def instance_roles(self) -> pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]]:
        """
        The IAM instance roles for the cluster's nodes.
        """
        return pulumi.get(self, "instance_roles")

    @instance_roles.setter
    def instance_roles(self, value: pulumi.Input[Sequence[pulumi.Input['pulumi_aws.iam.Role']]]):
        pulumi.set(self, "instance_roles", value)

    @property
    @pulumi.getter(name="nodeGroupOptions")
    def node_group_options(self) -> pulumi.Input['ClusterNodeGroupOptionsArgs']:
        """
        The cluster's node group options.
        """
        return pulumi.get(self, "node_group_options")

    @node_group_options.setter
    def node_group_options(self, value: pulumi.Input['ClusterNodeGroupOptionsArgs']):
        pulumi.set(self, "node_group_options", value)

    @property
    @pulumi.getter
    def provider(self) -> pulumi.Input['pulumi_kubernetes.Provider']:
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: pulumi.Input['pulumi_kubernetes.Provider']):
        pulumi.set(self, "provider", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of subnet IDs for the EKS cluster.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        ID of the cluster's VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="accessEntries")
    def access_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessEntryArgs']]]]:
        """
        The access entries added to the cluster.
        """
        return pulumi.get(self, "access_entries")

    @access_entries.setter
    def access_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessEntryArgs']]]]):
        pulumi.set(self, "access_entries", value)

    @property
    @pulumi.getter(name="awsProvider")
    def aws_provider(self) -> Optional[pulumi.Input['pulumi_aws.Provider']]:
        return pulumi.get(self, "aws_provider")

    @aws_provider.setter
    def aws_provider(self, value: Optional[pulumi.Input['pulumi_aws.Provider']]):
        pulumi.set(self, "aws_provider", value)

    @property
    @pulumi.getter(name="clusterSecurityGroup")
    def cluster_security_group(self) -> Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]:
        return pulumi.get(self, "cluster_security_group")

    @cluster_security_group.setter
    def cluster_security_group(self, value: Optional[pulumi.Input['pulumi_aws.ec2.SecurityGroup']]):
        pulumi.set(self, "cluster_security_group", value)

    @property
    @pulumi.getter(name="eksNodeAccess")
    def eks_node_access(self) -> Optional[pulumi.Input['pulumi_kubernetes.core.v1.ConfigMap']]:
        return pulumi.get(self, "eks_node_access")

    @eks_node_access.setter
    def eks_node_access(self, value: Optional[pulumi.Input['pulumi_kubernetes.core.v1.ConfigMap']]):
        pulumi.set(self, "eks_node_access", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['pulumi_aws.eks.ClusterEncryptionConfigArgs']]:
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['pulumi_aws.eks.ClusterEncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="fargateProfile")
    def fargate_profile(self) -> Optional[pulumi.Input['pulumi_aws.eks.FargateProfile']]:
        """
        The Fargate profile used to manage which pods run on Fargate.
        """
        return pulumi.get(self, "fargate_profile")

    @fargate_profile.setter
    def fargate_profile(self, value: Optional[pulumi.Input['pulumi_aws.eks.FargateProfile']]):
        pulumi.set(self, "fargate_profile", value)

    @property
    @pulumi.getter
    def kubeconfig(self) -> Optional[Any]:
        """
        The kubeconfig file for the cluster.
        """
        return pulumi.get(self, "kubeconfig")

    @kubeconfig.setter
    def kubeconfig(self, value: Optional[Any]):
        pulumi.set(self, "kubeconfig", value)

    @property
    @pulumi.getter(name="nodeSecurityGroupTags")
    def node_security_group_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tags attached to the security groups associated with the cluster's worker nodes.
        """
        return pulumi.get(self, "node_security_group_tags")

    @node_security_group_tags.setter
    def node_security_group_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_security_group_tags", value)

    @property
    @pulumi.getter(name="oidcProvider")
    def oidc_provider(self) -> Optional[pulumi.Input['pulumi_aws.iam.OpenIdConnectProvider']]:
        return pulumi.get(self, "oidc_provider")

    @oidc_provider.setter
    def oidc_provider(self, value: Optional[pulumi.Input['pulumi_aws.iam.OpenIdConnectProvider']]):
        pulumi.set(self, "oidc_provider", value)

    @property
    @pulumi.getter(name="privateSubnetIds")
    def private_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subnet IDs for the private subnets.
        """
        return pulumi.get(self, "private_subnet_ids")

    @private_subnet_ids.setter
    def private_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_subnet_ids", value)

    @property
    @pulumi.getter(name="publicSubnetIds")
    def public_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subnet IDs for the public subnets.
        """
        return pulumi.get(self, "public_subnet_ids")

    @public_subnet_ids.setter
    def public_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_subnet_ids", value)

    @property
    @pulumi.getter(name="storageClasses")
    def storage_classes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['pulumi_kubernetes.storage.v1.StorageClass']]]]:
        """
        The storage class used for persistent storage by the cluster.
        """
        return pulumi.get(self, "storage_classes")

    @storage_classes.setter
    def storage_classes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['pulumi_kubernetes.storage.v1.StorageClass']]]]):
        pulumi.set(self, "storage_classes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of tags assigned to the EKS cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcCni")
    def vpc_cni(self) -> Optional[pulumi.Input['VpcCniAddon']]:
        """
        The VPC CNI for the cluster.
        """
        return pulumi.get(self, "vpc_cni")

    @vpc_cni.setter
    def vpc_cni(self, value: Optional[pulumi.Input['VpcCniAddon']]):
        pulumi.set(self, "vpc_cni", value)


if not MYPY:
    class CoreDnsAddonOptionsArgsDict(TypedDict):
        configuration_values: NotRequired[pulumi.Input[Mapping[str, Any]]]
        """
        Custom configuration values for the coredns addon. This object must match the schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        enabled: NotRequired[bool]
        """
        Whether or not to create the `coredns` Addon in the cluster

        The managed addon can only be enabled if the cluster is a Fargate cluster or if the cluster
        uses the default node group, otherwise the self-managed addon is used.
        """
        resolve_conflicts_on_create: NotRequired['ResolveConflictsOnCreate']
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        """
        resolve_conflicts_on_update: NotRequired['ResolveConflictsOnUpdate']
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        version: NotRequired[pulumi.Input[str]]
        """
        The version of the EKS add-on. The version must match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
elif False:
    CoreDnsAddonOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CoreDnsAddonOptionsArgs:
    def __init__(__self__, *,
                 configuration_values: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 enabled: Optional[bool] = None,
                 resolve_conflicts_on_create: Optional['ResolveConflictsOnCreate'] = None,
                 resolve_conflicts_on_update: Optional['ResolveConflictsOnUpdate'] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] configuration_values: Custom configuration values for the coredns addon. This object must match the schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        :param bool enabled: Whether or not to create the `coredns` Addon in the cluster
               
               The managed addon can only be enabled if the cluster is a Fargate cluster or if the cluster
               uses the default node group, otherwise the self-managed addon is used.
        :param 'ResolveConflictsOnCreate' resolve_conflicts_on_create: How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        :param 'ResolveConflictsOnUpdate' resolve_conflicts_on_update: How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        :param pulumi.Input[str] version: The version of the EKS add-on. The version must match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        if configuration_values is not None:
            pulumi.set(__self__, "configuration_values", configuration_values)
        if enabled is None:
            enabled = True
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if resolve_conflicts_on_create is None:
            resolve_conflicts_on_create = 'OVERWRITE'
        if resolve_conflicts_on_create is not None:
            pulumi.set(__self__, "resolve_conflicts_on_create", resolve_conflicts_on_create)
        if resolve_conflicts_on_update is None:
            resolve_conflicts_on_update = 'OVERWRITE'
        if resolve_conflicts_on_update is not None:
            pulumi.set(__self__, "resolve_conflicts_on_update", resolve_conflicts_on_update)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="configurationValues")
    def configuration_values(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Custom configuration values for the coredns addon. This object must match the schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        return pulumi.get(self, "configuration_values")

    @configuration_values.setter
    def configuration_values(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "configuration_values", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether or not to create the `coredns` Addon in the cluster

        The managed addon can only be enabled if the cluster is a Fargate cluster or if the cluster
        uses the default node group, otherwise the self-managed addon is used.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="resolveConflictsOnCreate")
    def resolve_conflicts_on_create(self) -> Optional['ResolveConflictsOnCreate']:
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_create")

    @resolve_conflicts_on_create.setter
    def resolve_conflicts_on_create(self, value: Optional['ResolveConflictsOnCreate']):
        pulumi.set(self, "resolve_conflicts_on_create", value)

    @property
    @pulumi.getter(name="resolveConflictsOnUpdate")
    def resolve_conflicts_on_update(self) -> Optional['ResolveConflictsOnUpdate']:
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_update")

    @resolve_conflicts_on_update.setter
    def resolve_conflicts_on_update(self, value: Optional['ResolveConflictsOnUpdate']):
        pulumi.set(self, "resolve_conflicts_on_update", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the EKS add-on. The version must match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class CreationRoleProviderArgsDict(TypedDict):
        """
        Contains the AWS Role and Provider necessary to override the `[system:master]` entity ARN. This is an optional argument used when creating `Cluster`. Read more: https://docs.aws.amazon.com/eks/latest/userguide/add-user-role.html

        Note: This option is only supported with Pulumi nodejs programs. Please use `ProviderCredentialOpts` as an alternative instead.
        """
        provider: 'pulumi_aws.Provider'
        role: 'pulumi_aws.iam.Role'
elif False:
    CreationRoleProviderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CreationRoleProviderArgs:
    def __init__(__self__, *,
                 provider: 'pulumi_aws.Provider',
                 role: 'pulumi_aws.iam.Role'):
        """
        Contains the AWS Role and Provider necessary to override the `[system:master]` entity ARN. This is an optional argument used when creating `Cluster`. Read more: https://docs.aws.amazon.com/eks/latest/userguide/add-user-role.html

        Note: This option is only supported with Pulumi nodejs programs. Please use `ProviderCredentialOpts` as an alternative instead.
        """
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def provider(self) -> 'pulumi_aws.Provider':
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: 'pulumi_aws.Provider'):
        pulumi.set(self, "provider", value)

    @property
    @pulumi.getter
    def role(self) -> 'pulumi_aws.iam.Role':
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: 'pulumi_aws.iam.Role'):
        pulumi.set(self, "role", value)


if not MYPY:
    class FargateProfileArgsDict(TypedDict):
        """
        Defines how Kubernetes pods are executed in Fargate. See aws.eks.FargateProfileArgs for reference.
        """
        pod_execution_role_arn: NotRequired[pulumi.Input[str]]
        """
        Specify a custom role to use for executing pods in Fargate. Defaults to creating a new role with the `arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy` policy attached.
        """
        selectors: NotRequired[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.FargateProfileSelectorArgsDict']]]]
        """
        Specify the namespace and label selectors to use for launching pods into Fargate.
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Specify the subnets in which to execute Fargate tasks for pods. Defaults to the private subnets associated with the cluster.
        """
elif False:
    FargateProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FargateProfileArgs:
    def __init__(__self__, *,
                 pod_execution_role_arn: Optional[pulumi.Input[str]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.FargateProfileSelectorArgs']]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Defines how Kubernetes pods are executed in Fargate. See aws.eks.FargateProfileArgs for reference.
        :param pulumi.Input[str] pod_execution_role_arn: Specify a custom role to use for executing pods in Fargate. Defaults to creating a new role with the `arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy` policy attached.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.FargateProfileSelectorArgs']]] selectors: Specify the namespace and label selectors to use for launching pods into Fargate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Specify the subnets in which to execute Fargate tasks for pods. Defaults to the private subnets associated with the cluster.
        """
        if pod_execution_role_arn is not None:
            pulumi.set(__self__, "pod_execution_role_arn", pod_execution_role_arn)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="podExecutionRoleArn")
    def pod_execution_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a custom role to use for executing pods in Fargate. Defaults to creating a new role with the `arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy` policy attached.
        """
        return pulumi.get(self, "pod_execution_role_arn")

    @pod_execution_role_arn.setter
    def pod_execution_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_execution_role_arn", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.FargateProfileSelectorArgs']]]]:
        """
        Specify the namespace and label selectors to use for launching pods into Fargate.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.FargateProfileSelectorArgs']]]]):
        pulumi.set(self, "selectors", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify the subnets in which to execute Fargate tasks for pods. Defaults to the private subnets associated with the cluster.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)


if not MYPY:
    class KubeProxyAddonOptionsArgsDict(TypedDict):
        configuration_values: NotRequired[pulumi.Input[Mapping[str, Any]]]
        """
        Custom configuration values for the kube-proxy addon. This object must match the schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        enabled: NotRequired[bool]
        """
        Whether or not to create the `kube-proxy` Addon in the cluster. Defaults to true, unless `autoMode` is enabled.
        """
        resolve_conflicts_on_create: NotRequired['ResolveConflictsOnCreate']
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        """
        resolve_conflicts_on_update: NotRequired['ResolveConflictsOnUpdate']
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        version: NotRequired[pulumi.Input[str]]
        """
        The version of the EKS add-on. The version must match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
elif False:
    KubeProxyAddonOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KubeProxyAddonOptionsArgs:
    def __init__(__self__, *,
                 configuration_values: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 enabled: Optional[bool] = None,
                 resolve_conflicts_on_create: Optional['ResolveConflictsOnCreate'] = None,
                 resolve_conflicts_on_update: Optional['ResolveConflictsOnUpdate'] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] configuration_values: Custom configuration values for the kube-proxy addon. This object must match the schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        :param bool enabled: Whether or not to create the `kube-proxy` Addon in the cluster. Defaults to true, unless `autoMode` is enabled.
        :param 'ResolveConflictsOnCreate' resolve_conflicts_on_create: How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        :param 'ResolveConflictsOnUpdate' resolve_conflicts_on_update: How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        :param pulumi.Input[str] version: The version of the EKS add-on. The version must match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        if configuration_values is not None:
            pulumi.set(__self__, "configuration_values", configuration_values)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if resolve_conflicts_on_create is None:
            resolve_conflicts_on_create = 'OVERWRITE'
        if resolve_conflicts_on_create is not None:
            pulumi.set(__self__, "resolve_conflicts_on_create", resolve_conflicts_on_create)
        if resolve_conflicts_on_update is None:
            resolve_conflicts_on_update = 'OVERWRITE'
        if resolve_conflicts_on_update is not None:
            pulumi.set(__self__, "resolve_conflicts_on_update", resolve_conflicts_on_update)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="configurationValues")
    def configuration_values(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Custom configuration values for the kube-proxy addon. This object must match the schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        return pulumi.get(self, "configuration_values")

    @configuration_values.setter
    def configuration_values(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "configuration_values", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Whether or not to create the `kube-proxy` Addon in the cluster. Defaults to true, unless `autoMode` is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="resolveConflictsOnCreate")
    def resolve_conflicts_on_create(self) -> Optional['ResolveConflictsOnCreate']:
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_create")

    @resolve_conflicts_on_create.setter
    def resolve_conflicts_on_create(self, value: Optional['ResolveConflictsOnCreate']):
        pulumi.set(self, "resolve_conflicts_on_create", value)

    @property
    @pulumi.getter(name="resolveConflictsOnUpdate")
    def resolve_conflicts_on_update(self) -> Optional['ResolveConflictsOnUpdate']:
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value. Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_update")

    @resolve_conflicts_on_update.setter
    def resolve_conflicts_on_update(self, value: Optional['ResolveConflictsOnUpdate']):
        pulumi.set(self, "resolve_conflicts_on_update", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the EKS add-on. The version must match one of the versions returned by [describe-addon-versions](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-versions.html).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class KubeconfigOptionsArgsDict(TypedDict):
        """
        Represents the AWS credentials to scope a given kubeconfig when using a non-default credential chain.

        The options can be used independently, or additively.

        A scoped kubeconfig is necessary for certain auth scenarios. For example:
          1. Assume a role on the default account caller,
          2. Use an AWS creds profile instead of the default account caller,
          3. Use an AWS creds creds profile instead of the default account caller,
             and then assume a given role on the profile. This scenario is also
             possible by only using a profile, iff the profile includes a role to
             assume in its settings.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html
        - https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-role.html
        - https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html
        """
        profile_name: NotRequired[pulumi.Input[str]]
        """
        AWS credential profile name to always use instead of the default AWS credential provider chain.

        The profile is passed to kubeconfig as an authentication environment setting.
        """
        role_arn: NotRequired[pulumi.Input[str]]
        """
        Role ARN to assume instead of the default AWS credential provider chain.

        The role is passed to kubeconfig as an authentication exec argument.
        """
elif False:
    KubeconfigOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KubeconfigOptionsArgs:
    def __init__(__self__, *,
                 profile_name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None):
        """
        Represents the AWS credentials to scope a given kubeconfig when using a non-default credential chain.

        The options can be used independently, or additively.

        A scoped kubeconfig is necessary for certain auth scenarios. For example:
          1. Assume a role on the default account caller,
          2. Use an AWS creds profile instead of the default account caller,
          3. Use an AWS creds creds profile instead of the default account caller,
             and then assume a given role on the profile. This scenario is also
             possible by only using a profile, iff the profile includes a role to
             assume in its settings.

        See for more details:
        - https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html
        - https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-role.html
        - https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html
        :param pulumi.Input[str] profile_name: AWS credential profile name to always use instead of the default AWS credential provider chain.
               
               The profile is passed to kubeconfig as an authentication environment setting.
        :param pulumi.Input[str] role_arn: Role ARN to assume instead of the default AWS credential provider chain.
               
               The role is passed to kubeconfig as an authentication exec argument.
        """
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[str]]:
        """
        AWS credential profile name to always use instead of the default AWS credential provider chain.

        The profile is passed to kubeconfig as an authentication environment setting.
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Role ARN to assume instead of the default AWS credential provider chain.

        The role is passed to kubeconfig as an authentication exec argument.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)


if not MYPY:
    class NodeadmOptionsArgsDict(TypedDict):
        """
        MIME document parts for nodeadm configuration. This can be shell scripts, nodeadm configuration or any other user data compatible script.

        See for more details: https://awslabs.github.io/amazon-eks-ami/nodeadm/.
        """
        content: pulumi.Input[str]
        """
        The actual content of the MIME document part, such as shell script code or nodeadm configuration. Must be compatible with the specified contentType.
        """
        content_type: pulumi.Input[str]
        """
        The MIME type of the content. Examples are `text/x-shellscript; charset="us-ascii"` for shell scripts, and `application/node.eks.aws` nodeadm configuration.
        """
elif False:
    NodeadmOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodeadmOptionsArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[str],
                 content_type: pulumi.Input[str]):
        """
        MIME document parts for nodeadm configuration. This can be shell scripts, nodeadm configuration or any other user data compatible script.

        See for more details: https://awslabs.github.io/amazon-eks-ami/nodeadm/.
        :param pulumi.Input[str] content: The actual content of the MIME document part, such as shell script code or nodeadm configuration. Must be compatible with the specified contentType.
        :param pulumi.Input[str] content_type: The MIME type of the content. Examples are `text/x-shellscript; charset="us-ascii"` for shell scripts, and `application/node.eks.aws` nodeadm configuration.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[str]:
        """
        The actual content of the MIME document part, such as shell script code or nodeadm configuration. Must be compatible with the specified contentType.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[str]:
        """
        The MIME type of the content. Examples are `text/x-shellscript; charset="us-ascii"` for shell scripts, and `application/node.eks.aws` nodeadm configuration.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_type", value)


if not MYPY:
    class RoleMappingArgsDict(TypedDict):
        """
        Describes a mapping from an AWS IAM role to a Kubernetes user and groups.
        """
        groups: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        A list of groups within Kubernetes to which the role is mapped.
        """
        role_arn: pulumi.Input[str]
        """
        The ARN of the IAM role to add.
        """
        username: pulumi.Input[str]
        """
        The user name within Kubernetes to map to the IAM role. By default, the user name is the ARN of the IAM role.
        """
elif False:
    RoleMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RoleMappingArgs:
    def __init__(__self__, *,
                 groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 role_arn: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        Describes a mapping from an AWS IAM role to a Kubernetes user and groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: A list of groups within Kubernetes to which the role is mapped.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role to add.
        :param pulumi.Input[str] username: The user name within Kubernetes to map to the IAM role. By default, the user name is the ARN of the IAM role.
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of groups within Kubernetes to which the role is mapped.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM role to add.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name within Kubernetes to map to the IAM role. By default, the user name is the ARN of the IAM role.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


if not MYPY:
    class StorageClassArgsDict(TypedDict):
        """
        StorageClass describes the inputs to a single Kubernetes StorageClass provisioned by AWS. Any number of storage classes can be added to a cluster at creation time. One of these storage classes may be configured the default storage class for the cluster.
        """
        type: pulumi.Input[str]
        """
        The EBS volume type.
        """
        allow_volume_expansion: NotRequired[pulumi.Input[bool]]
        """
        AllowVolumeExpansion shows whether the storage class allow volume expand.
        """
        default: NotRequired[pulumi.Input[bool]]
        """
        True if this storage class should be a default storage class for the cluster.

        Note: As of Kubernetes v1.11+ on EKS, a default `gp2` storage class will always be created automatically for the cluster by the EKS service. See https://docs.aws.amazon.com/eks/latest/userguide/storage-classes.html

        Please note that at most one storage class can be marked as default. If two or more of them are marked as default, a PersistentVolumeClaim without `storageClassName` explicitly specified cannot be created. See: https://kubernetes.io/docs/tasks/administer-cluster/change-default-storage-class/#changing-the-default-storageclass
        """
        encrypted: NotRequired[pulumi.Input[bool]]
        """
        Denotes whether the EBS volume should be encrypted.
        """
        iops_per_gb: NotRequired[pulumi.Input[int]]
        """
        I/O operations per second per GiB for "io1" volumes. The AWS volume plugin multiplies this with the size of a requested volume to compute IOPS of the volume and caps the result at 20,000 IOPS.
        """
        kms_key_id: NotRequired[pulumi.Input[str]]
        """
        The full Amazon Resource Name of the key to use when encrypting the volume. If none is supplied but encrypted is true, a key is generated by AWS.
        """
        metadata: NotRequired[pulumi.Input['pulumi_kubernetes.meta.v1.ObjectMetaArgsDict']]
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        """
        mount_options: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
        """
        reclaim_policy: NotRequired[pulumi.Input[str]]
        """
        Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. Defaults to Delete.
        """
        volume_binding_mode: NotRequired[pulumi.Input[str]]
        """
        VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound. When unset, VolumeBindingImmediate is used. This field is alpha-level and is only honored by servers that enable the VolumeScheduling feature.
        """
        zones: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The AWS zone or zones for the EBS volume. If zones is not specified, volumes are generally round-robin-ed across all active zones where Kubernetes cluster has a node. zone and zones parameters must not be used at the same time.
        """
elif False:
    StorageClassArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StorageClassArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 allow_volume_expansion: Optional[pulumi.Input[bool]] = None,
                 default: Optional[pulumi.Input[bool]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 iops_per_gb: Optional[pulumi.Input[int]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['pulumi_kubernetes.meta.v1.ObjectMetaArgs']] = None,
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reclaim_policy: Optional[pulumi.Input[str]] = None,
                 volume_binding_mode: Optional[pulumi.Input[str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        StorageClass describes the inputs to a single Kubernetes StorageClass provisioned by AWS. Any number of storage classes can be added to a cluster at creation time. One of these storage classes may be configured the default storage class for the cluster.
        :param pulumi.Input[str] type: The EBS volume type.
        :param pulumi.Input[bool] allow_volume_expansion: AllowVolumeExpansion shows whether the storage class allow volume expand.
        :param pulumi.Input[bool] default: True if this storage class should be a default storage class for the cluster.
               
               Note: As of Kubernetes v1.11+ on EKS, a default `gp2` storage class will always be created automatically for the cluster by the EKS service. See https://docs.aws.amazon.com/eks/latest/userguide/storage-classes.html
               
               Please note that at most one storage class can be marked as default. If two or more of them are marked as default, a PersistentVolumeClaim without `storageClassName` explicitly specified cannot be created. See: https://kubernetes.io/docs/tasks/administer-cluster/change-default-storage-class/#changing-the-default-storageclass
        :param pulumi.Input[bool] encrypted: Denotes whether the EBS volume should be encrypted.
        :param pulumi.Input[int] iops_per_gb: I/O operations per second per GiB for "io1" volumes. The AWS volume plugin multiplies this with the size of a requested volume to compute IOPS of the volume and caps the result at 20,000 IOPS.
        :param pulumi.Input[str] kms_key_id: The full Amazon Resource Name of the key to use when encrypting the volume. If none is supplied but encrypted is true, a key is generated by AWS.
        :param pulumi.Input['pulumi_kubernetes.meta.v1.ObjectMetaArgs'] metadata: Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mount_options: Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
        :param pulumi.Input[str] reclaim_policy: Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. Defaults to Delete.
        :param pulumi.Input[str] volume_binding_mode: VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound. When unset, VolumeBindingImmediate is used. This field is alpha-level and is only honored by servers that enable the VolumeScheduling feature.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zones: The AWS zone or zones for the EBS volume. If zones is not specified, volumes are generally round-robin-ed across all active zones where Kubernetes cluster has a node. zone and zones parameters must not be used at the same time.
        """
        pulumi.set(__self__, "type", type)
        if allow_volume_expansion is not None:
            pulumi.set(__self__, "allow_volume_expansion", allow_volume_expansion)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops_per_gb is not None:
            pulumi.set(__self__, "iops_per_gb", iops_per_gb)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if reclaim_policy is not None:
            pulumi.set(__self__, "reclaim_policy", reclaim_policy)
        if volume_binding_mode is not None:
            pulumi.set(__self__, "volume_binding_mode", volume_binding_mode)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The EBS volume type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="allowVolumeExpansion")
    def allow_volume_expansion(self) -> Optional[pulumi.Input[bool]]:
        """
        AllowVolumeExpansion shows whether the storage class allow volume expand.
        """
        return pulumi.get(self, "allow_volume_expansion")

    @allow_volume_expansion.setter
    def allow_volume_expansion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_volume_expansion", value)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[bool]]:
        """
        True if this storage class should be a default storage class for the cluster.

        Note: As of Kubernetes v1.11+ on EKS, a default `gp2` storage class will always be created automatically for the cluster by the EKS service. See https://docs.aws.amazon.com/eks/latest/userguide/storage-classes.html

        Please note that at most one storage class can be marked as default. If two or more of them are marked as default, a PersistentVolumeClaim without `storageClassName` explicitly specified cannot be created. See: https://kubernetes.io/docs/tasks/administer-cluster/change-default-storage-class/#changing-the-default-storageclass
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Denotes whether the EBS volume should be encrypted.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="iopsPerGb")
    def iops_per_gb(self) -> Optional[pulumi.Input[int]]:
        """
        I/O operations per second per GiB for "io1" volumes. The AWS volume plugin multiplies this with the size of a requested volume to compute IOPS of the volume and caps the result at 20,000 IOPS.
        """
        return pulumi.get(self, "iops_per_gb")

    @iops_per_gb.setter
    def iops_per_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iops_per_gb", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The full Amazon Resource Name of the key to use when encrypting the volume. If none is supplied but encrypted is true, a key is generated by AWS.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['pulumi_kubernetes.meta.v1.ObjectMetaArgs']]:
        """
        Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['pulumi_kubernetes.meta.v1.ObjectMetaArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. ["ro", "soft"]. Not validated - mount of the PVs will simply fail if one is invalid.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. Defaults to Delete.
        """
        return pulumi.get(self, "reclaim_policy")

    @reclaim_policy.setter
    def reclaim_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reclaim_policy", value)

    @property
    @pulumi.getter(name="volumeBindingMode")
    def volume_binding_mode(self) -> Optional[pulumi.Input[str]]:
        """
        VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound. When unset, VolumeBindingImmediate is used. This field is alpha-level and is only honored by servers that enable the VolumeScheduling feature.
        """
        return pulumi.get(self, "volume_binding_mode")

    @volume_binding_mode.setter
    def volume_binding_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_binding_mode", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The AWS zone or zones for the EBS volume. If zones is not specified, volumes are generally round-robin-ed across all active zones where Kubernetes cluster has a node. zone and zones parameters must not be used at the same time.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zones", value)


if not MYPY:
    class TaintArgsDict(TypedDict):
        """
        Represents a Kubernetes `taint` to apply to all Nodes in a NodeGroup. See https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/.
        """
        effect: pulumi.Input[str]
        """
        The effect of the taint.
        """
        value: pulumi.Input[str]
        """
        The value of the taint.
        """
elif False:
    TaintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TaintArgs:
    def __init__(__self__, *,
                 effect: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Represents a Kubernetes `taint` to apply to all Nodes in a NodeGroup. See https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/.
        :param pulumi.Input[str] effect: The effect of the taint.
        :param pulumi.Input[str] value: The value of the taint.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Input[str]:
        """
        The effect of the taint.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[str]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the taint.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class UserMappingArgsDict(TypedDict):
        """
        Describes a mapping from an AWS IAM user to a Kubernetes user and groups.
        """
        groups: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        A list of groups within Kubernetes to which the user is mapped to.
        """
        user_arn: pulumi.Input[str]
        """
        The ARN of the IAM user to add.
        """
        username: pulumi.Input[str]
        """
        The user name within Kubernetes to map to the IAM user. By default, the user name is the ARN of the IAM user.
        """
elif False:
    UserMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserMappingArgs:
    def __init__(__self__, *,
                 groups: pulumi.Input[Sequence[pulumi.Input[str]]],
                 user_arn: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        Describes a mapping from an AWS IAM user to a Kubernetes user and groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: A list of groups within Kubernetes to which the user is mapped to.
        :param pulumi.Input[str] user_arn: The ARN of the IAM user to add.
        :param pulumi.Input[str] username: The user name within Kubernetes to map to the IAM user. By default, the user name is the ARN of the IAM user.
        """
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "user_arn", user_arn)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of groups within Kubernetes to which the user is mapped to.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="userArn")
    def user_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the IAM user to add.
        """
        return pulumi.get(self, "user_arn")

    @user_arn.setter
    def user_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_arn", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name within Kubernetes to map to the IAM user. By default, the user name is the ARN of the IAM user.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


if not MYPY:
    class VpcCniOptionsArgsDict(TypedDict):
        """
        Describes the configuration options available for the Amazon VPC CNI plugin for Kubernetes.
        """
        addon_version: NotRequired[pulumi.Input[str]]
        """
        The version of the addon to use. If not specified, the latest version of the addon for the cluster's Kubernetes version will be used.
        """
        cni_configure_rpfilter: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether ipamd should configure rp filter for primary interface. Default is `false`.
        """
        cni_custom_network_cfg: NotRequired[pulumi.Input[bool]]
        """
        Specifies that your pods may use subnets and security groups that are independent of your worker node's VPC configuration. By default, pods share the same subnet and security groups as the worker node's primary interface. Setting this variable to true causes ipamd to use the security groups and VPC subnet in a worker node's ENIConfig for elastic network interface allocation. You must create an ENIConfig custom resource for each subnet that your pods will reside in, and then annotate or label each worker node to use a specific ENIConfig (multiple worker nodes can be annotated or labelled with the same ENIConfig). Worker nodes can only be annotated with a single ENIConfig at a time, and the subnet in the ENIConfig must belong to the same Availability Zone that the worker node resides in. For more information, see CNI Custom Networking in the Amazon EKS User Guide. Default is `false`
        """
        cni_external_snat: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether an external NAT gateway should be used to provide SNAT of secondary ENI IP addresses. If set to true, the SNAT iptables rule and off-VPC IP rule are not applied, and these rules are removed if they have already been applied. Disable SNAT if you need to allow inbound communication to your pods from external VPNs, direct connections, and external VPCs, and your pods do not need to access the Internet directly via an Internet Gateway. However, your nodes must be running in a private subnet and connected to the internet through an AWS NAT Gateway or another external NAT device. Default is `false`
        """
        configuration_values: NotRequired[pulumi.Input[Mapping[str, Any]]]
        """
        Custom configuration values for the vpc-cni addon. This object must match the schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        custom_network_config: NotRequired[pulumi.Input[bool]]
        """
        Specifies that your pods may use subnets and security groups (within the same VPC as your control plane resources) that are independent of your cluster's `resourcesVpcConfig`.

        Defaults to false.
        """
        disable_tcp_early_demux: NotRequired[pulumi.Input[bool]]
        """
        Allows the kubelet's liveness and readiness probes to connect via TCP when pod ENI is enabled. This will slightly increase local TCP connection latency.
        """
        enable_network_policy: NotRequired[pulumi.Input[bool]]
        """
        Enables using Kubernetes network policies. In Kubernetes, by default, all pod-to-pod communication is allowed. Communication can be restricted with Kubernetes NetworkPolicy objects.

        See for more information: [Kubernetes Network Policies](https://kubernetes.io/docs/concepts/services-networking/network-policies/).
        """
        enable_pod_eni: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether to allow IPAMD to add the `vpc.amazonaws.com/has-trunk-attached` label to the node if the instance has capacity to attach an additional ENI. Default is `false`. If using liveness and readiness probes, you will also need to disable TCP early demux.
        """
        enable_prefix_delegation: NotRequired[pulumi.Input[bool]]
        """
        IPAMD will start allocating (/28) prefixes to the ENIs with ENABLE_PREFIX_DELEGATION set to true.
        """
        eni_config_label_def: NotRequired[pulumi.Input[str]]
        """
        Specifies the ENI_CONFIG_LABEL_DEF environment variable value for worker nodes. This is used to tell Kubernetes to automatically apply the ENIConfig for each Availability Zone
        Ref: https://docs.aws.amazon.com/eks/latest/userguide/cni-custom-network.html (step 5(c))

        Defaults to the official AWS CNI image in ECR.
        """
        eni_mtu: NotRequired[pulumi.Input[int]]
        """
        Used to configure the MTU size for attached ENIs. The valid range is from 576 to 9001.

        Defaults to 9001.
        """
        external_snat: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether an external NAT gateway should be used to provide SNAT of secondary ENI IP addresses. If set to true, the SNAT iptables rule and off-VPC IP rule are not applied, and these rules are removed if they have already been applied.

        Defaults to false.
        """
        log_file: NotRequired[pulumi.Input[str]]
        """
        Specifies the file path used for logs.

        Defaults to "stdout" to emit Pod logs for `kubectl logs`.
        """
        log_level: NotRequired[pulumi.Input[str]]
        """
        Specifies the log level used for logs.

        Defaults to "DEBUG"
        Valid values: "DEBUG", "INFO", "WARN", "ERROR", or "FATAL".
        """
        node_port_support: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether NodePort services are enabled on a worker node's primary network interface. This requires additional iptables rules and that the kernel's reverse path filter on the primary interface is set to loose.

        Defaults to true.
        """
        resolve_conflicts_on_create: NotRequired['ResolveConflictsOnCreate']
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        """
        resolve_conflicts_on_update: NotRequired['ResolveConflictsOnUpdate']
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value.  Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        security_context_privileged: NotRequired[pulumi.Input[bool]]
        """
        Pass privilege to containers securityContext. This is required when SELinux is enabled. This value will not be passed to the CNI config by default
        """
        service_account_role_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role.

        For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the Amazon EKS User Guide.

        Note: To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see [Enabling IAM roles for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html) in the Amazon EKS User Guide.
        """
        veth_prefix: NotRequired[pulumi.Input[str]]
        """
        Specifies the veth prefix used to generate the host-side veth device name for the CNI.

        The prefix can be at most 4 characters long.

        Defaults to "eni".
        """
        warm_eni_target: NotRequired[pulumi.Input[int]]
        """
        Specifies the number of free elastic network interfaces (and all of their available IP addresses) that the ipamD daemon should attempt to keep available for pod assignment on the node.

        Defaults to 1.
        """
        warm_ip_target: NotRequired[pulumi.Input[int]]
        """
        Specifies the number of free IP addresses that the ipamD daemon should attempt to keep available for pod assignment on the node.
        """
        warm_prefix_target: NotRequired[pulumi.Input[int]]
        """
        WARM_PREFIX_TARGET will allocate one full (/28) prefix even if a single IP  is consumed with the existing prefix. Ref: https://github.com/aws/amazon-vpc-cni-k8s/blob/master/docs/prefix-and-ip-target.md
        """
elif False:
    VpcCniOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpcCniOptionsArgs:
    def __init__(__self__, *,
                 addon_version: Optional[pulumi.Input[str]] = None,
                 cni_configure_rpfilter: Optional[pulumi.Input[bool]] = None,
                 cni_custom_network_cfg: Optional[pulumi.Input[bool]] = None,
                 cni_external_snat: Optional[pulumi.Input[bool]] = None,
                 configuration_values: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 custom_network_config: Optional[pulumi.Input[bool]] = None,
                 disable_tcp_early_demux: Optional[pulumi.Input[bool]] = None,
                 enable_network_policy: Optional[pulumi.Input[bool]] = None,
                 enable_pod_eni: Optional[pulumi.Input[bool]] = None,
                 enable_prefix_delegation: Optional[pulumi.Input[bool]] = None,
                 eni_config_label_def: Optional[pulumi.Input[str]] = None,
                 eni_mtu: Optional[pulumi.Input[int]] = None,
                 external_snat: Optional[pulumi.Input[bool]] = None,
                 log_file: Optional[pulumi.Input[str]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 node_port_support: Optional[pulumi.Input[bool]] = None,
                 resolve_conflicts_on_create: Optional['ResolveConflictsOnCreate'] = None,
                 resolve_conflicts_on_update: Optional['ResolveConflictsOnUpdate'] = None,
                 security_context_privileged: Optional[pulumi.Input[bool]] = None,
                 service_account_role_arn: Optional[pulumi.Input[str]] = None,
                 veth_prefix: Optional[pulumi.Input[str]] = None,
                 warm_eni_target: Optional[pulumi.Input[int]] = None,
                 warm_ip_target: Optional[pulumi.Input[int]] = None,
                 warm_prefix_target: Optional[pulumi.Input[int]] = None):
        """
        Describes the configuration options available for the Amazon VPC CNI plugin for Kubernetes.
        :param pulumi.Input[str] addon_version: The version of the addon to use. If not specified, the latest version of the addon for the cluster's Kubernetes version will be used.
        :param pulumi.Input[bool] cni_configure_rpfilter: Specifies whether ipamd should configure rp filter for primary interface. Default is `false`.
        :param pulumi.Input[bool] cni_custom_network_cfg: Specifies that your pods may use subnets and security groups that are independent of your worker node's VPC configuration. By default, pods share the same subnet and security groups as the worker node's primary interface. Setting this variable to true causes ipamd to use the security groups and VPC subnet in a worker node's ENIConfig for elastic network interface allocation. You must create an ENIConfig custom resource for each subnet that your pods will reside in, and then annotate or label each worker node to use a specific ENIConfig (multiple worker nodes can be annotated or labelled with the same ENIConfig). Worker nodes can only be annotated with a single ENIConfig at a time, and the subnet in the ENIConfig must belong to the same Availability Zone that the worker node resides in. For more information, see CNI Custom Networking in the Amazon EKS User Guide. Default is `false`
        :param pulumi.Input[bool] cni_external_snat: Specifies whether an external NAT gateway should be used to provide SNAT of secondary ENI IP addresses. If set to true, the SNAT iptables rule and off-VPC IP rule are not applied, and these rules are removed if they have already been applied. Disable SNAT if you need to allow inbound communication to your pods from external VPNs, direct connections, and external VPCs, and your pods do not need to access the Internet directly via an Internet Gateway. However, your nodes must be running in a private subnet and connected to the internet through an AWS NAT Gateway or another external NAT device. Default is `false`
        :param pulumi.Input[Mapping[str, Any]] configuration_values: Custom configuration values for the vpc-cni addon. This object must match the schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        :param pulumi.Input[bool] custom_network_config: Specifies that your pods may use subnets and security groups (within the same VPC as your control plane resources) that are independent of your cluster's `resourcesVpcConfig`.
               
               Defaults to false.
        :param pulumi.Input[bool] disable_tcp_early_demux: Allows the kubelet's liveness and readiness probes to connect via TCP when pod ENI is enabled. This will slightly increase local TCP connection latency.
        :param pulumi.Input[bool] enable_network_policy: Enables using Kubernetes network policies. In Kubernetes, by default, all pod-to-pod communication is allowed. Communication can be restricted with Kubernetes NetworkPolicy objects.
               
               See for more information: [Kubernetes Network Policies](https://kubernetes.io/docs/concepts/services-networking/network-policies/).
        :param pulumi.Input[bool] enable_pod_eni: Specifies whether to allow IPAMD to add the `vpc.amazonaws.com/has-trunk-attached` label to the node if the instance has capacity to attach an additional ENI. Default is `false`. If using liveness and readiness probes, you will also need to disable TCP early demux.
        :param pulumi.Input[bool] enable_prefix_delegation: IPAMD will start allocating (/28) prefixes to the ENIs with ENABLE_PREFIX_DELEGATION set to true.
        :param pulumi.Input[str] eni_config_label_def: Specifies the ENI_CONFIG_LABEL_DEF environment variable value for worker nodes. This is used to tell Kubernetes to automatically apply the ENIConfig for each Availability Zone
               Ref: https://docs.aws.amazon.com/eks/latest/userguide/cni-custom-network.html (step 5(c))
               
               Defaults to the official AWS CNI image in ECR.
        :param pulumi.Input[int] eni_mtu: Used to configure the MTU size for attached ENIs. The valid range is from 576 to 9001.
               
               Defaults to 9001.
        :param pulumi.Input[bool] external_snat: Specifies whether an external NAT gateway should be used to provide SNAT of secondary ENI IP addresses. If set to true, the SNAT iptables rule and off-VPC IP rule are not applied, and these rules are removed if they have already been applied.
               
               Defaults to false.
        :param pulumi.Input[str] log_file: Specifies the file path used for logs.
               
               Defaults to "stdout" to emit Pod logs for `kubectl logs`.
        :param pulumi.Input[str] log_level: Specifies the log level used for logs.
               
               Defaults to "DEBUG"
               Valid values: "DEBUG", "INFO", "WARN", "ERROR", or "FATAL".
        :param pulumi.Input[bool] node_port_support: Specifies whether NodePort services are enabled on a worker node's primary network interface. This requires additional iptables rules and that the kernel's reverse path filter on the primary interface is set to loose.
               
               Defaults to true.
        :param 'ResolveConflictsOnCreate' resolve_conflicts_on_create: How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        :param 'ResolveConflictsOnUpdate' resolve_conflicts_on_update: How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value.  Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        :param pulumi.Input[bool] security_context_privileged: Pass privilege to containers securityContext. This is required when SELinux is enabled. This value will not be passed to the CNI config by default
        :param pulumi.Input[str] service_account_role_arn: The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role.
               
               For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the Amazon EKS User Guide.
               
               Note: To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see [Enabling IAM roles for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html) in the Amazon EKS User Guide.
        :param pulumi.Input[str] veth_prefix: Specifies the veth prefix used to generate the host-side veth device name for the CNI.
               
               The prefix can be at most 4 characters long.
               
               Defaults to "eni".
        :param pulumi.Input[int] warm_eni_target: Specifies the number of free elastic network interfaces (and all of their available IP addresses) that the ipamD daemon should attempt to keep available for pod assignment on the node.
               
               Defaults to 1.
        :param pulumi.Input[int] warm_ip_target: Specifies the number of free IP addresses that the ipamD daemon should attempt to keep available for pod assignment on the node.
        :param pulumi.Input[int] warm_prefix_target: WARM_PREFIX_TARGET will allocate one full (/28) prefix even if a single IP  is consumed with the existing prefix. Ref: https://github.com/aws/amazon-vpc-cni-k8s/blob/master/docs/prefix-and-ip-target.md
        """
        if addon_version is not None:
            pulumi.set(__self__, "addon_version", addon_version)
        if cni_configure_rpfilter is not None:
            pulumi.set(__self__, "cni_configure_rpfilter", cni_configure_rpfilter)
        if cni_custom_network_cfg is not None:
            pulumi.set(__self__, "cni_custom_network_cfg", cni_custom_network_cfg)
        if cni_external_snat is not None:
            pulumi.set(__self__, "cni_external_snat", cni_external_snat)
        if configuration_values is not None:
            pulumi.set(__self__, "configuration_values", configuration_values)
        if custom_network_config is not None:
            pulumi.set(__self__, "custom_network_config", custom_network_config)
        if disable_tcp_early_demux is not None:
            pulumi.set(__self__, "disable_tcp_early_demux", disable_tcp_early_demux)
        if enable_network_policy is not None:
            pulumi.set(__self__, "enable_network_policy", enable_network_policy)
        if enable_pod_eni is not None:
            pulumi.set(__self__, "enable_pod_eni", enable_pod_eni)
        if enable_prefix_delegation is not None:
            pulumi.set(__self__, "enable_prefix_delegation", enable_prefix_delegation)
        if eni_config_label_def is not None:
            pulumi.set(__self__, "eni_config_label_def", eni_config_label_def)
        if eni_mtu is not None:
            pulumi.set(__self__, "eni_mtu", eni_mtu)
        if external_snat is not None:
            pulumi.set(__self__, "external_snat", external_snat)
        if log_file is not None:
            pulumi.set(__self__, "log_file", log_file)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if node_port_support is not None:
            pulumi.set(__self__, "node_port_support", node_port_support)
        if resolve_conflicts_on_create is None:
            resolve_conflicts_on_create = 'OVERWRITE'
        if resolve_conflicts_on_create is not None:
            pulumi.set(__self__, "resolve_conflicts_on_create", resolve_conflicts_on_create)
        if resolve_conflicts_on_update is None:
            resolve_conflicts_on_update = 'OVERWRITE'
        if resolve_conflicts_on_update is not None:
            pulumi.set(__self__, "resolve_conflicts_on_update", resolve_conflicts_on_update)
        if security_context_privileged is not None:
            pulumi.set(__self__, "security_context_privileged", security_context_privileged)
        if service_account_role_arn is not None:
            pulumi.set(__self__, "service_account_role_arn", service_account_role_arn)
        if veth_prefix is not None:
            pulumi.set(__self__, "veth_prefix", veth_prefix)
        if warm_eni_target is not None:
            pulumi.set(__self__, "warm_eni_target", warm_eni_target)
        if warm_ip_target is not None:
            pulumi.set(__self__, "warm_ip_target", warm_ip_target)
        if warm_prefix_target is not None:
            pulumi.set(__self__, "warm_prefix_target", warm_prefix_target)

    @property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the addon to use. If not specified, the latest version of the addon for the cluster's Kubernetes version will be used.
        """
        return pulumi.get(self, "addon_version")

    @addon_version.setter
    def addon_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "addon_version", value)

    @property
    @pulumi.getter(name="cniConfigureRpfilter")
    def cni_configure_rpfilter(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether ipamd should configure rp filter for primary interface. Default is `false`.
        """
        return pulumi.get(self, "cni_configure_rpfilter")

    @cni_configure_rpfilter.setter
    def cni_configure_rpfilter(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cni_configure_rpfilter", value)

    @property
    @pulumi.getter(name="cniCustomNetworkCfg")
    def cni_custom_network_cfg(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that your pods may use subnets and security groups that are independent of your worker node's VPC configuration. By default, pods share the same subnet and security groups as the worker node's primary interface. Setting this variable to true causes ipamd to use the security groups and VPC subnet in a worker node's ENIConfig for elastic network interface allocation. You must create an ENIConfig custom resource for each subnet that your pods will reside in, and then annotate or label each worker node to use a specific ENIConfig (multiple worker nodes can be annotated or labelled with the same ENIConfig). Worker nodes can only be annotated with a single ENIConfig at a time, and the subnet in the ENIConfig must belong to the same Availability Zone that the worker node resides in. For more information, see CNI Custom Networking in the Amazon EKS User Guide. Default is `false`
        """
        return pulumi.get(self, "cni_custom_network_cfg")

    @cni_custom_network_cfg.setter
    def cni_custom_network_cfg(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cni_custom_network_cfg", value)

    @property
    @pulumi.getter(name="cniExternalSnat")
    def cni_external_snat(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether an external NAT gateway should be used to provide SNAT of secondary ENI IP addresses. If set to true, the SNAT iptables rule and off-VPC IP rule are not applied, and these rules are removed if they have already been applied. Disable SNAT if you need to allow inbound communication to your pods from external VPNs, direct connections, and external VPCs, and your pods do not need to access the Internet directly via an Internet Gateway. However, your nodes must be running in a private subnet and connected to the internet through an AWS NAT Gateway or another external NAT device. Default is `false`
        """
        return pulumi.get(self, "cni_external_snat")

    @cni_external_snat.setter
    def cni_external_snat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cni_external_snat", value)

    @property
    @pulumi.getter(name="configurationValues")
    def configuration_values(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Custom configuration values for the vpc-cni addon. This object must match the schema derived from [describe-addon-configuration](https://docs.aws.amazon.com/cli/latest/reference/eks/describe-addon-configuration.html).
        """
        return pulumi.get(self, "configuration_values")

    @configuration_values.setter
    def configuration_values(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "configuration_values", value)

    @property
    @pulumi.getter(name="customNetworkConfig")
    def custom_network_config(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies that your pods may use subnets and security groups (within the same VPC as your control plane resources) that are independent of your cluster's `resourcesVpcConfig`.

        Defaults to false.
        """
        return pulumi.get(self, "custom_network_config")

    @custom_network_config.setter
    def custom_network_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_network_config", value)

    @property
    @pulumi.getter(name="disableTcpEarlyDemux")
    def disable_tcp_early_demux(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows the kubelet's liveness and readiness probes to connect via TCP when pod ENI is enabled. This will slightly increase local TCP connection latency.
        """
        return pulumi.get(self, "disable_tcp_early_demux")

    @disable_tcp_early_demux.setter
    def disable_tcp_early_demux(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_tcp_early_demux", value)

    @property
    @pulumi.getter(name="enableNetworkPolicy")
    def enable_network_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables using Kubernetes network policies. In Kubernetes, by default, all pod-to-pod communication is allowed. Communication can be restricted with Kubernetes NetworkPolicy objects.

        See for more information: [Kubernetes Network Policies](https://kubernetes.io/docs/concepts/services-networking/network-policies/).
        """
        return pulumi.get(self, "enable_network_policy")

    @enable_network_policy.setter
    def enable_network_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_network_policy", value)

    @property
    @pulumi.getter(name="enablePodEni")
    def enable_pod_eni(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to allow IPAMD to add the `vpc.amazonaws.com/has-trunk-attached` label to the node if the instance has capacity to attach an additional ENI. Default is `false`. If using liveness and readiness probes, you will also need to disable TCP early demux.
        """
        return pulumi.get(self, "enable_pod_eni")

    @enable_pod_eni.setter
    def enable_pod_eni(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_pod_eni", value)

    @property
    @pulumi.getter(name="enablePrefixDelegation")
    def enable_prefix_delegation(self) -> Optional[pulumi.Input[bool]]:
        """
        IPAMD will start allocating (/28) prefixes to the ENIs with ENABLE_PREFIX_DELEGATION set to true.
        """
        return pulumi.get(self, "enable_prefix_delegation")

    @enable_prefix_delegation.setter
    def enable_prefix_delegation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_prefix_delegation", value)

    @property
    @pulumi.getter(name="eniConfigLabelDef")
    def eni_config_label_def(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ENI_CONFIG_LABEL_DEF environment variable value for worker nodes. This is used to tell Kubernetes to automatically apply the ENIConfig for each Availability Zone
        Ref: https://docs.aws.amazon.com/eks/latest/userguide/cni-custom-network.html (step 5(c))

        Defaults to the official AWS CNI image in ECR.
        """
        return pulumi.get(self, "eni_config_label_def")

    @eni_config_label_def.setter
    def eni_config_label_def(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_config_label_def", value)

    @property
    @pulumi.getter(name="eniMtu")
    def eni_mtu(self) -> Optional[pulumi.Input[int]]:
        """
        Used to configure the MTU size for attached ENIs. The valid range is from 576 to 9001.

        Defaults to 9001.
        """
        return pulumi.get(self, "eni_mtu")

    @eni_mtu.setter
    def eni_mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eni_mtu", value)

    @property
    @pulumi.getter(name="externalSnat")
    def external_snat(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether an external NAT gateway should be used to provide SNAT of secondary ENI IP addresses. If set to true, the SNAT iptables rule and off-VPC IP rule are not applied, and these rules are removed if they have already been applied.

        Defaults to false.
        """
        return pulumi.get(self, "external_snat")

    @external_snat.setter
    def external_snat(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "external_snat", value)

    @property
    @pulumi.getter(name="logFile")
    def log_file(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the file path used for logs.

        Defaults to "stdout" to emit Pod logs for `kubectl logs`.
        """
        return pulumi.get(self, "log_file")

    @log_file.setter
    def log_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_file", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the log level used for logs.

        Defaults to "DEBUG"
        Valid values: "DEBUG", "INFO", "WARN", "ERROR", or "FATAL".
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_level", value)

    @property
    @pulumi.getter(name="nodePortSupport")
    def node_port_support(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether NodePort services are enabled on a worker node's primary network interface. This requires additional iptables rules and that the kernel's reverse path filter on the primary interface is set to loose.

        Defaults to true.
        """
        return pulumi.get(self, "node_port_support")

    @node_port_support.setter
    def node_port_support(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_port_support", value)

    @property
    @pulumi.getter(name="resolveConflictsOnCreate")
    def resolve_conflicts_on_create(self) -> Optional['ResolveConflictsOnCreate']:
        """
        How to resolve field value conflicts when migrating a self-managed add-on to an Amazon EKS add-on. Valid values are `NONE` and `OVERWRITE`. For more details see the [CreateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_CreateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_create")

    @resolve_conflicts_on_create.setter
    def resolve_conflicts_on_create(self, value: Optional['ResolveConflictsOnCreate']):
        pulumi.set(self, "resolve_conflicts_on_create", value)

    @property
    @pulumi.getter(name="resolveConflictsOnUpdate")
    def resolve_conflicts_on_update(self) -> Optional['ResolveConflictsOnUpdate']:
        """
        How to resolve field value conflicts for an Amazon EKS add-on if you've changed a value from the Amazon EKS default value.  Valid values are `NONE`, `OVERWRITE`, and `PRESERVE`. For more details see the [UpdateAddon](https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html) API Docs.
        """
        return pulumi.get(self, "resolve_conflicts_on_update")

    @resolve_conflicts_on_update.setter
    def resolve_conflicts_on_update(self, value: Optional['ResolveConflictsOnUpdate']):
        pulumi.set(self, "resolve_conflicts_on_update", value)

    @property
    @pulumi.getter(name="securityContextPrivileged")
    def security_context_privileged(self) -> Optional[pulumi.Input[bool]]:
        """
        Pass privilege to containers securityContext. This is required when SELinux is enabled. This value will not be passed to the CNI config by default
        """
        return pulumi.get(self, "security_context_privileged")

    @security_context_privileged.setter
    def security_context_privileged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "security_context_privileged", value)

    @property
    @pulumi.getter(name="serviceAccountRoleArn")
    def service_account_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's service account. The role must be assigned the IAM permissions required by the add-on. If you don't specify an existing IAM role, then the add-on uses the permissions assigned to the node IAM role.

        For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the Amazon EKS User Guide.

        Note: To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC) provider created for your cluster. For more information, see [Enabling IAM roles for service accounts on your cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html) in the Amazon EKS User Guide.
        """
        return pulumi.get(self, "service_account_role_arn")

    @service_account_role_arn.setter
    def service_account_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_role_arn", value)

    @property
    @pulumi.getter(name="vethPrefix")
    def veth_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the veth prefix used to generate the host-side veth device name for the CNI.

        The prefix can be at most 4 characters long.

        Defaults to "eni".
        """
        return pulumi.get(self, "veth_prefix")

    @veth_prefix.setter
    def veth_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "veth_prefix", value)

    @property
    @pulumi.getter(name="warmEniTarget")
    def warm_eni_target(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of free elastic network interfaces (and all of their available IP addresses) that the ipamD daemon should attempt to keep available for pod assignment on the node.

        Defaults to 1.
        """
        return pulumi.get(self, "warm_eni_target")

    @warm_eni_target.setter
    def warm_eni_target(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warm_eni_target", value)

    @property
    @pulumi.getter(name="warmIpTarget")
    def warm_ip_target(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the number of free IP addresses that the ipamD daemon should attempt to keep available for pod assignment on the node.
        """
        return pulumi.get(self, "warm_ip_target")

    @warm_ip_target.setter
    def warm_ip_target(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warm_ip_target", value)

    @property
    @pulumi.getter(name="warmPrefixTarget")
    def warm_prefix_target(self) -> Optional[pulumi.Input[int]]:
        """
        WARM_PREFIX_TARGET will allocate one full (/28) prefix even if a single IP  is consumed with the existing prefix. Ref: https://github.com/aws/amazon-vpc-cni-k8s/blob/master/docs/prefix-and-ip-target.md
        """
        return pulumi.get(self, "warm_prefix_target")

    @warm_prefix_target.setter
    def warm_prefix_target(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warm_prefix_target", value)


