# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-eks. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from ._enums import *
from ._inputs import *
from .cluster import Cluster
from .vpc_cni_addon import VpcCniAddon
import pulumi_aws
import pulumi_kubernetes

__all__ = ['ManagedNodeGroupArgs', 'ManagedNodeGroup']

@pulumi.input_type
class ManagedNodeGroupArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[Union['Cluster', 'CoreDataArgs']],
                 ami_id: Optional[pulumi.Input[str]] = None,
                 ami_type: Optional[pulumi.Input[str]] = None,
                 bootstrap_extra_args: Optional[str] = None,
                 bottlerocket_settings: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 capacity_type: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 enable_efa_support: Optional[bool] = None,
                 enable_imd_sv2: Optional[bool] = None,
                 force_update_version: Optional[pulumi.Input[bool]] = None,
                 gpu: Optional[pulumi.Input[bool]] = None,
                 ignore_scaling_changes: Optional[bool] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kubelet_extra_args: Optional[str] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 launch_template: Optional[pulumi.Input['pulumi_aws.eks.NodeGroupLaunchTemplateArgs']] = None,
                 node_group_name: Optional[pulumi.Input[str]] = None,
                 node_group_name_prefix: Optional[pulumi.Input[str]] = None,
                 node_role: Optional[pulumi.Input['pulumi_aws.iam.Role']] = None,
                 node_role_arn: Optional[pulumi.Input[str]] = None,
                 nodeadm_extra_options: Optional[pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]]] = None,
                 operating_system: Optional[pulumi.Input['OperatingSystem']] = None,
                 placement_group_availability_zone: Optional[pulumi.Input[str]] = None,
                 release_version: Optional[pulumi.Input[str]] = None,
                 remote_access: Optional[pulumi.Input['pulumi_aws.eks.NodeGroupRemoteAccessArgs']] = None,
                 scaling_config: Optional[pulumi.Input['pulumi_aws.eks.NodeGroupScalingConfigArgs']] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.NodeGroupTaintArgs']]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ManagedNodeGroup resource.
        :param pulumi.Input[Union['Cluster', 'CoreDataArgs']] cluster: The target EKS cluster.
        :param pulumi.Input[str] ami_id: The AMI ID to use for the worker nodes.
               Defaults to the latest recommended EKS Optimized AMI from the AWS Systems Manager Parameter Store.
               
               Note: `amiId` is mutually exclusive with `gpu` and `amiType`.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        :param pulumi.Input[str] ami_type: Type of Amazon Machine Image (AMI) associated with the EKS Node Group. Defaults to `AL2_x86_64`.
               Note: `amiType` and `amiId` are mutually exclusive.
               
               See the AWS documentation (https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid AMI Types. This provider will only perform drift detection if a configuration value is provided.
        :param str bootstrap_extra_args: Additional args to pass directly to `/etc/eks/bootstrap.sh`. For details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
               
               Note that this field conflicts with `launchTemplate`.
        :param pulumi.Input[Mapping[str, Any]] bottlerocket_settings: The configuration settings for Bottlerocket OS.
               The settings will get merged with the base settings the provider uses to configure Bottlerocket.
               
               This includes:
                 - settings.kubernetes.api-server
                 - settings.kubernetes.cluster-certificate
                 - settings.kubernetes.cluster-name
                 - settings.kubernetes.cluster-dns-ip
               
               For an overview of the available settings, see https://bottlerocket.dev/en/os/1.20.x/api/settings/.
        :param pulumi.Input[str] capacity_type: Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[int] disk_size: Disk size in GiB for worker nodes. Defaults to `20`. This provider will only perform drift detection if a configuration value is provided.
        :param bool enable_efa_support: Determines whether to enable Elastic Fabric Adapter (EFA) support for the node group. If multiple different instance types are configured for the node group, the first one will be used to determine the network interfaces to use. Requires `placementGroupAvailabilityZone` to be set.
        :param bool enable_imd_sv2: Enables the ability to use EC2 Instance Metadata Service v2, which provides a more secure way to access instance metadata. For more information, see: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-service.html.
               Defaults to `false`.
               
               Note that this field conflicts with `launchTemplate`. If you are providing a custom `launchTemplate`, you should enable this feature within the `launchTemplateMetadataOptions` of the supplied `launchTemplate`.
        :param pulumi.Input[bool] force_update_version: Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
        :param pulumi.Input[bool] gpu: Use the latest recommended EKS Optimized AMI with GPU support for the worker nodes.
               Defaults to false.
               
               Note: `gpu` and `amiId` are mutually exclusive.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-amis.html.
        :param bool ignore_scaling_changes: Whether to ignore changes to the desired size of the Auto Scaling Group. This is useful when using Cluster Autoscaler.
               
               See [EKS best practices](https://aws.github.io/aws-eks-best-practices/cluster-autoscaling/) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: Set of instance types associated with the EKS Node Group. Defaults to `["t3.medium"]`. This provider will only perform drift detection if a configuration value is provided. Currently, the EKS API only accepts a single value in the set.
        :param str kubelet_extra_args: Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. To escape characters in the extra argsvalue, wrap the value in quotes. For example, `kubeletExtraArgs = '--allowed-unsafe-sysctls "net.core.somaxconn"'`.
               Note that this field conflicts with `launchTemplate`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        :param pulumi.Input['pulumi_aws.eks.NodeGroupLaunchTemplateArgs'] launch_template: Launch Template settings.
               
               Note: This field is mutually exclusive with `kubeletExtraArgs` and `bootstrapExtraArgs`.
        :param pulumi.Input[str] node_group_name: Name of the EKS Node Group. If omitted, this provider will assign a random, unique name. Conflicts with `nodeGroupNamePrefix`.
        :param pulumi.Input[str] node_group_name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `nodeGroupName`.
        :param pulumi.Input['pulumi_aws.iam.Role'] node_role: The IAM Role that provides permissions for the EKS Node Group.
               
               Note, `nodeRole` and `nodeRoleArn` are mutually exclusive, and a single option must be used.
        :param pulumi.Input[str] node_role_arn: Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
               
               Note, `nodeRoleArn` and `nodeRole` are mutually exclusive, and a single option must be used.
        :param pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]] nodeadm_extra_options: Extra nodeadm configuration sections to be added to the nodeadm user data. This can be shell scripts, nodeadm NodeConfig or any other user data compatible script. When configuring additional nodeadm NodeConfig sections, they'll be merged with the base settings the provider sets. You can overwrite base settings or provide additional settings this way.
               The base settings the provider sets are:
                 - cluster.name
                 - cluster.apiServerEndpoint
                 - cluster.certificateAuthority
                 - cluster.cidr
               
               Note: This is only applicable when using AL2023.
               See for more details:
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/doc/api/
        :param pulumi.Input['OperatingSystem'] operating_system: The type of OS to use for the node group. Will be used to determine the right EKS optimized AMI to use based on the instance types and gpu configuration.
               Valid values are `RECOMMENDED`, `AL2`, `AL2023` and `Bottlerocket`.
               
               Defaults to the current recommended OS.
        :param pulumi.Input[str] placement_group_availability_zone: The availability zone of the placement group for EFA support. Required if `enableEfaSupport` is true.
        :param pulumi.Input[str] release_version: AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
        :param pulumi.Input['pulumi_aws.eks.NodeGroupRemoteAccessArgs'] remote_access: Remote access settings.
        :param pulumi.Input['pulumi_aws.eks.NodeGroupScalingConfigArgs'] scaling_config: Scaling settings.
               
               Default scaling amounts of the node group autoscaling group are:
                 - desiredSize: 2
                 - minSize: 1
                 - maxSize: 2
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Identifiers of EC2 Subnets to associate with the EKS Node Group. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
               
               Default subnetIds is chosen from the following list, in order, if subnetIds arg is not set:
                 - core.subnetIds
                 - core.privateIds
                 - core.publicSubnetIds
               
               This default logic is based on the existing subnet IDs logic of this package: https://git.io/JeM11
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.NodeGroupTaintArgs']]] taints: The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group.
        :param pulumi.Input[str] user_data: User specified code to run on node startup. This is expected to handle the full AWS EKS node bootstrapping. If omitted, the provider will configure the user data.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html#launch-template-user-data.
        """
        pulumi.set(__self__, "cluster", cluster)
        if ami_id is not None:
            pulumi.set(__self__, "ami_id", ami_id)
        if ami_type is not None:
            pulumi.set(__self__, "ami_type", ami_type)
        if bootstrap_extra_args is not None:
            pulumi.set(__self__, "bootstrap_extra_args", bootstrap_extra_args)
        if bottlerocket_settings is not None:
            pulumi.set(__self__, "bottlerocket_settings", bottlerocket_settings)
        if capacity_type is not None:
            pulumi.set(__self__, "capacity_type", capacity_type)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if enable_efa_support is not None:
            pulumi.set(__self__, "enable_efa_support", enable_efa_support)
        if enable_imd_sv2 is not None:
            pulumi.set(__self__, "enable_imd_sv2", enable_imd_sv2)
        if force_update_version is not None:
            pulumi.set(__self__, "force_update_version", force_update_version)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if ignore_scaling_changes is not None:
            pulumi.set(__self__, "ignore_scaling_changes", ignore_scaling_changes)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if kubelet_extra_args is not None:
            pulumi.set(__self__, "kubelet_extra_args", kubelet_extra_args)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)
        if node_group_name_prefix is not None:
            pulumi.set(__self__, "node_group_name_prefix", node_group_name_prefix)
        if node_role is not None:
            pulumi.set(__self__, "node_role", node_role)
        if node_role_arn is not None:
            pulumi.set(__self__, "node_role_arn", node_role_arn)
        if nodeadm_extra_options is not None:
            pulumi.set(__self__, "nodeadm_extra_options", nodeadm_extra_options)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if placement_group_availability_zone is not None:
            pulumi.set(__self__, "placement_group_availability_zone", placement_group_availability_zone)
        if release_version is not None:
            pulumi.set(__self__, "release_version", release_version)
        if remote_access is not None:
            pulumi.set(__self__, "remote_access", remote_access)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[Union['Cluster', 'CoreDataArgs']]:
        """
        The target EKS cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[Union['Cluster', 'CoreDataArgs']]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="amiId")
    def ami_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI ID to use for the worker nodes.
        Defaults to the latest recommended EKS Optimized AMI from the AWS Systems Manager Parameter Store.

        Note: `amiId` is mutually exclusive with `gpu` and `amiType`.

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        """
        return pulumi.get(self, "ami_id")

    @ami_id.setter
    def ami_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami_id", value)

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of Amazon Machine Image (AMI) associated with the EKS Node Group. Defaults to `AL2_x86_64`.
        Note: `amiType` and `amiId` are mutually exclusive.

        See the AWS documentation (https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid AMI Types. This provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "ami_type")

    @ami_type.setter
    def ami_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami_type", value)

    @property
    @pulumi.getter(name="bootstrapExtraArgs")
    def bootstrap_extra_args(self) -> Optional[str]:
        """
        Additional args to pass directly to `/etc/eks/bootstrap.sh`. For details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.

        Note that this field conflicts with `launchTemplate`.
        """
        return pulumi.get(self, "bootstrap_extra_args")

    @bootstrap_extra_args.setter
    def bootstrap_extra_args(self, value: Optional[str]):
        pulumi.set(self, "bootstrap_extra_args", value)

    @property
    @pulumi.getter(name="bottlerocketSettings")
    def bottlerocket_settings(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The configuration settings for Bottlerocket OS.
        The settings will get merged with the base settings the provider uses to configure Bottlerocket.

        This includes:
          - settings.kubernetes.api-server
          - settings.kubernetes.cluster-certificate
          - settings.kubernetes.cluster-name
          - settings.kubernetes.cluster-dns-ip

        For an overview of the available settings, see https://bottlerocket.dev/en/os/1.20.x/api/settings/.
        """
        return pulumi.get(self, "bottlerocket_settings")

    @bottlerocket_settings.setter
    def bottlerocket_settings(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "bottlerocket_settings", value)

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "capacity_type")

    @capacity_type.setter
    def capacity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_type", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the EKS Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Disk size in GiB for worker nodes. Defaults to `20`. This provider will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="enableEfaSupport")
    def enable_efa_support(self) -> Optional[bool]:
        """
        Determines whether to enable Elastic Fabric Adapter (EFA) support for the node group. If multiple different instance types are configured for the node group, the first one will be used to determine the network interfaces to use. Requires `placementGroupAvailabilityZone` to be set.
        """
        return pulumi.get(self, "enable_efa_support")

    @enable_efa_support.setter
    def enable_efa_support(self, value: Optional[bool]):
        pulumi.set(self, "enable_efa_support", value)

    @property
    @pulumi.getter(name="enableIMDSv2")
    def enable_imd_sv2(self) -> Optional[bool]:
        """
        Enables the ability to use EC2 Instance Metadata Service v2, which provides a more secure way to access instance metadata. For more information, see: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-service.html.
        Defaults to `false`.

        Note that this field conflicts with `launchTemplate`. If you are providing a custom `launchTemplate`, you should enable this feature within the `launchTemplateMetadataOptions` of the supplied `launchTemplate`.
        """
        return pulumi.get(self, "enable_imd_sv2")

    @enable_imd_sv2.setter
    def enable_imd_sv2(self, value: Optional[bool]):
        pulumi.set(self, "enable_imd_sv2", value)

    @property
    @pulumi.getter(name="forceUpdateVersion")
    def force_update_version(self) -> Optional[pulumi.Input[bool]]:
        """
        Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
        """
        return pulumi.get(self, "force_update_version")

    @force_update_version.setter
    def force_update_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_update_version", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the latest recommended EKS Optimized AMI with GPU support for the worker nodes.
        Defaults to false.

        Note: `gpu` and `amiId` are mutually exclusive.

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-amis.html.
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter(name="ignoreScalingChanges")
    def ignore_scaling_changes(self) -> Optional[bool]:
        """
        Whether to ignore changes to the desired size of the Auto Scaling Group. This is useful when using Cluster Autoscaler.

        See [EKS best practices](https://aws.github.io/aws-eks-best-practices/cluster-autoscaling/) for more details.
        """
        return pulumi.get(self, "ignore_scaling_changes")

    @ignore_scaling_changes.setter
    def ignore_scaling_changes(self, value: Optional[bool]):
        pulumi.set(self, "ignore_scaling_changes", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of instance types associated with the EKS Node Group. Defaults to `["t3.medium"]`. This provider will only perform drift detection if a configuration value is provided. Currently, the EKS API only accepts a single value in the set.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="kubeletExtraArgs")
    def kubelet_extra_args(self) -> Optional[str]:
        """
        Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. To escape characters in the extra argsvalue, wrap the value in quotes. For example, `kubeletExtraArgs = '--allowed-unsafe-sysctls "net.core.somaxconn"'`.
        Note that this field conflicts with `launchTemplate`.
        """
        return pulumi.get(self, "kubelet_extra_args")

    @kubelet_extra_args.setter
    def kubelet_extra_args(self, value: Optional[str]):
        pulumi.set(self, "kubelet_extra_args", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['pulumi_aws.eks.NodeGroupLaunchTemplateArgs']]:
        """
        Launch Template settings.

        Note: This field is mutually exclusive with `kubeletExtraArgs` and `bootstrapExtraArgs`.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['pulumi_aws.eks.NodeGroupLaunchTemplateArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the EKS Node Group. If omitted, this provider will assign a random, unique name. Conflicts with `nodeGroupNamePrefix`.
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_group_name", value)

    @property
    @pulumi.getter(name="nodeGroupNamePrefix")
    def node_group_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `nodeGroupName`.
        """
        return pulumi.get(self, "node_group_name_prefix")

    @node_group_name_prefix.setter
    def node_group_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_group_name_prefix", value)

    @property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> Optional[pulumi.Input['pulumi_aws.iam.Role']]:
        """
        The IAM Role that provides permissions for the EKS Node Group.

        Note, `nodeRole` and `nodeRoleArn` are mutually exclusive, and a single option must be used.
        """
        return pulumi.get(self, "node_role")

    @node_role.setter
    def node_role(self, value: Optional[pulumi.Input['pulumi_aws.iam.Role']]):
        pulumi.set(self, "node_role", value)

    @property
    @pulumi.getter(name="nodeRoleArn")
    def node_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.

        Note, `nodeRoleArn` and `nodeRole` are mutually exclusive, and a single option must be used.
        """
        return pulumi.get(self, "node_role_arn")

    @node_role_arn.setter
    def node_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_role_arn", value)

    @property
    @pulumi.getter(name="nodeadmExtraOptions")
    def nodeadm_extra_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]]]:
        """
        Extra nodeadm configuration sections to be added to the nodeadm user data. This can be shell scripts, nodeadm NodeConfig or any other user data compatible script. When configuring additional nodeadm NodeConfig sections, they'll be merged with the base settings the provider sets. You can overwrite base settings or provide additional settings this way.
        The base settings the provider sets are:
          - cluster.name
          - cluster.apiServerEndpoint
          - cluster.certificateAuthority
          - cluster.cidr

        Note: This is only applicable when using AL2023.
        See for more details:
          - https://awslabs.github.io/amazon-eks-ami/nodeadm/
          - https://awslabs.github.io/amazon-eks-ami/nodeadm/doc/api/
        """
        return pulumi.get(self, "nodeadm_extra_options")

    @nodeadm_extra_options.setter
    def nodeadm_extra_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeadmOptionsArgs']]]]):
        pulumi.set(self, "nodeadm_extra_options", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input['OperatingSystem']]:
        """
        The type of OS to use for the node group. Will be used to determine the right EKS optimized AMI to use based on the instance types and gpu configuration.
        Valid values are `RECOMMENDED`, `AL2`, `AL2023` and `Bottlerocket`.

        Defaults to the current recommended OS.
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input['OperatingSystem']]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="placementGroupAvailabilityZone")
    def placement_group_availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The availability zone of the placement group for EFA support. Required if `enableEfaSupport` is true.
        """
        return pulumi.get(self, "placement_group_availability_zone")

    @placement_group_availability_zone.setter
    def placement_group_availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group_availability_zone", value)

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> Optional[pulumi.Input[str]]:
        """
        AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
        """
        return pulumi.get(self, "release_version")

    @release_version.setter
    def release_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_version", value)

    @property
    @pulumi.getter(name="remoteAccess")
    def remote_access(self) -> Optional[pulumi.Input['pulumi_aws.eks.NodeGroupRemoteAccessArgs']]:
        """
        Remote access settings.
        """
        return pulumi.get(self, "remote_access")

    @remote_access.setter
    def remote_access(self, value: Optional[pulumi.Input['pulumi_aws.eks.NodeGroupRemoteAccessArgs']]):
        pulumi.set(self, "remote_access", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['pulumi_aws.eks.NodeGroupScalingConfigArgs']]:
        """
        Scaling settings.

        Default scaling amounts of the node group autoscaling group are:
          - desiredSize: 2
          - minSize: 1
          - maxSize: 2
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['pulumi_aws.eks.NodeGroupScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Identifiers of EC2 Subnets to associate with the EKS Node Group. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).

        Default subnetIds is chosen from the following list, in order, if subnetIds arg is not set:
          - core.subnetIds
          - core.privateIds
          - core.publicSubnetIds

        This default logic is based on the existing subnet IDs logic of this package: https://git.io/JeM11
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Key-value mapping of resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.NodeGroupTaintArgs']]]]:
        """
        The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.eks.NodeGroupTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        User specified code to run on node startup. This is expected to handle the full AWS EKS node bootstrapping. If omitted, the provider will configure the user data.

        See for more details: https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html#launch-template-user-data.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class ManagedNodeGroup(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 ami_type: Optional[pulumi.Input[str]] = None,
                 bootstrap_extra_args: Optional[str] = None,
                 bottlerocket_settings: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 capacity_type: Optional[pulumi.Input[str]] = None,
                 cluster: Optional[pulumi.Input[Union['Cluster', Union['CoreDataArgs', 'CoreDataArgsDict']]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 enable_efa_support: Optional[bool] = None,
                 enable_imd_sv2: Optional[bool] = None,
                 force_update_version: Optional[pulumi.Input[bool]] = None,
                 gpu: Optional[pulumi.Input[bool]] = None,
                 ignore_scaling_changes: Optional[bool] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kubelet_extra_args: Optional[str] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 launch_template: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupLaunchTemplateArgs']]] = None,
                 node_group_name: Optional[pulumi.Input[str]] = None,
                 node_group_name_prefix: Optional[pulumi.Input[str]] = None,
                 node_role: Optional[pulumi.Input['pulumi_aws.iam.Role']] = None,
                 node_role_arn: Optional[pulumi.Input[str]] = None,
                 nodeadm_extra_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeadmOptionsArgs', 'NodeadmOptionsArgsDict']]]]] = None,
                 operating_system: Optional[pulumi.Input['OperatingSystem']] = None,
                 placement_group_availability_zone: Optional[pulumi.Input[str]] = None,
                 release_version: Optional[pulumi.Input[str]] = None,
                 remote_access: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupRemoteAccessArgs']]] = None,
                 scaling_config: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupScalingConfigArgs']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupTaintArgs']]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an EKS Node Group, which can provision and optionally update an Auto Scaling Group of Kubernetes worker nodes compatible with EKS. Additional documentation about this functionality can be found in the [EKS User Guide](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html).

        ## Example Usage
        ### Basic Managed Node Group
        This example demonstrates creating a managed node group with typical defaults. The node group uses the latest EKS-optimized Amazon Linux AMI, creates 2 nodes, and runs on t3.medium instances. Instance security groups are automatically configured.

        ```python
        import pulumi
        import json
        import pulumi_aws as aws
        import pulumi_awsx as awsx
        import pulumi_eks as eks

        eks_vpc = awsx.ec2.Vpc("eks-vpc",
            enable_dns_hostnames=True,
            cidr_block="10.0.0.0/16")
        eks_cluster = eks.Cluster("eks-cluster",
            vpc_id=eks_vpc.vpc_id,
            authentication_mode=eks.AuthenticationMode.API,
            public_subnet_ids=eks_vpc.public_subnet_ids,
            private_subnet_ids=eks_vpc.private_subnet_ids,
            skip_default_node_group=True)
        node_role = aws.iam.Role("node-role", assume_role_policy=json.dumps({
            "Version": "2012-10-17",
            "Statement": [{
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Sid": "",
                "Principal": {
                    "Service": "ec2.amazonaws.com",
                },
            }],
        }))
        worker_node_policy = aws.iam.RolePolicyAttachment("worker-node-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSWorkerNodePolicy")
        cni_policy = aws.iam.RolePolicyAttachment("cni-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy")
        registry_policy = aws.iam.RolePolicyAttachment("registry-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryReadOnly")
        node_group = eks.ManagedNodeGroup("node-group",
            cluster=eks_cluster,
            node_role=node_role)

        ```
        ### Enabling EFA Support

        Enabling EFA support for a node group will do the following:
        - All EFA interfaces supported by the instance will be exposed on the launch template used by the node group
        - A `clustered` placement group will be created and passed to the launch template
        - Checks will be performed to ensure that the instance type supports EFA and that the specified AZ is supported by the chosen instance type

        The GPU optimized AMIs include all necessary drivers and libraries to support EFA. If you're choosing an instance type without GPU acceleration you will need to install the drivers and libraries manually and bake a custom AMI.

        You can use the [aws-efa-k8s-device-plugin](https://github.com/aws/eks-charts/tree/master/stable/aws-efa-k8s-device-plugin) Helm chart to expose the EFA interfaces on the nodes as an extended resource, and allow pods to request these interfaces to be mounted to their containers.
        Your application container will need to have the necessary libraries and runtimes in order to leverage the EFA interfaces (e.g. libfabric).

        ```python
        import pulumi
        import json
        import pulumi_aws as aws
        import pulumi_awsx as awsx
        import pulumi_eks as eks
        import pulumi_kubernetes as kubernetes

        eks_vpc = awsx.ec2.Vpc("eks-vpc",
            enable_dns_hostnames=True,
            cidr_block="10.0.0.0/16")
        eks_cluster = eks.Cluster("eks-cluster",
            vpc_id=eks_vpc.vpc_id,
            authentication_mode=eks.AuthenticationMode.API,
            public_subnet_ids=eks_vpc.public_subnet_ids,
            private_subnet_ids=eks_vpc.private_subnet_ids,
            skip_default_node_group=True)
        k8_s_provider = kubernetes.Provider("k8sProvider", kubeconfig=eks_cluster.kubeconfig)
        node_role = aws.iam.Role("node-role", assume_role_policy=json.dumps({
            "Version": "2012-10-17",
            "Statement": [{
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Sid": "",
                "Principal": {
                    "Service": "ec2.amazonaws.com",
                },
            }],
        }))
        worker_node_policy = aws.iam.RolePolicyAttachment("worker-node-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSWorkerNodePolicy")
        cni_policy = aws.iam.RolePolicyAttachment("cni-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy")
        registry_policy = aws.iam.RolePolicyAttachment("registry-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryReadOnly")

        # The node group for running system pods (e.g. coredns, etc.)
        system_node_group = eks.ManagedNodeGroup("system-node-group",
            cluster=eks_cluster,
            node_role=node_role)

        # The EFA device plugin for exposing EFA interfaces as extended resources
        device_plugin = kubernetes.helm.v3.Release("device-plugin",
            version="0.5.7",
            repository_opts={
                "repo": "https://aws.github.io/eks-charts",
            },
            chart="aws-efa-k8s-device-plugin",
            namespace="kube-system",
            atomic=True,
            values={
                "tolerations": [{
                    "key": "efa-enabled",
                    "operator": "Exists",
                    "effect": "NoExecute",
                }],
            },
            opts = pulumi.ResourceOptions(provider=k8_s_provider))

        # The node group for running EFA enabled workloads
        efa_node_group = eks.ManagedNodeGroup("efa-node-group",
            cluster=eks_cluster,
            node_role=node_role,
            instance_types=["g6.8xlarge"],
            gpu=True,
            scaling_config={
                "min_size": 2,
                "desired_size": 2,
                "max_size": 4,
            },
            enable_efa_support=True,
            placement_group_availability_zone="us-west-2b",

            # Taint the nodes so that only pods with the efa-enabled label can be scheduled on them
            taints=[{
                "key": "efa-enabled",
                "value": "true",
                "effect": "NO_EXECUTE",
            }],

            # Instances with GPUs usually have nvme instance store volumes, so we can mount them in RAID-0 for kubelet and containerd
            # These are faster than the regular EBS volumes
            nodeadm_extra_options=[{
                "content_type": "application/node.eks.aws",
                "content": \"\"\"apiVersion: node.eks.aws/v1alpha1
        kind: NodeConfig
        spec:
          instance:
            localStorage:
              strategy: RAID0
        \"\"\",
            }])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ami_id: The AMI ID to use for the worker nodes.
               Defaults to the latest recommended EKS Optimized AMI from the AWS Systems Manager Parameter Store.
               
               Note: `amiId` is mutually exclusive with `gpu` and `amiType`.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-ami.html.
        :param pulumi.Input[str] ami_type: Type of Amazon Machine Image (AMI) associated with the EKS Node Group. Defaults to `AL2_x86_64`.
               Note: `amiType` and `amiId` are mutually exclusive.
               
               See the AWS documentation (https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid AMI Types. This provider will only perform drift detection if a configuration value is provided.
        :param str bootstrap_extra_args: Additional args to pass directly to `/etc/eks/bootstrap.sh`. For details on available options, see: https://github.com/awslabs/amazon-eks-ami/blob/master/files/bootstrap.sh. Note that the `--apiserver-endpoint`, `--b64-cluster-ca` and `--kubelet-extra-args` flags are included automatically based on other configuration parameters.
               
               Note that this field conflicts with `launchTemplate`.
        :param pulumi.Input[Mapping[str, Any]] bottlerocket_settings: The configuration settings for Bottlerocket OS.
               The settings will get merged with the base settings the provider uses to configure Bottlerocket.
               
               This includes:
                 - settings.kubernetes.api-server
                 - settings.kubernetes.cluster-certificate
                 - settings.kubernetes.cluster-name
                 - settings.kubernetes.cluster-dns-ip
               
               For an overview of the available settings, see https://bottlerocket.dev/en/os/1.20.x/api/settings/.
        :param pulumi.Input[str] capacity_type: Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
        :param pulumi.Input[Union['Cluster', Union['CoreDataArgs', 'CoreDataArgsDict']]] cluster: The target EKS cluster.
        :param pulumi.Input[str] cluster_name: Name of the EKS Cluster.
        :param pulumi.Input[int] disk_size: Disk size in GiB for worker nodes. Defaults to `20`. This provider will only perform drift detection if a configuration value is provided.
        :param bool enable_efa_support: Determines whether to enable Elastic Fabric Adapter (EFA) support for the node group. If multiple different instance types are configured for the node group, the first one will be used to determine the network interfaces to use. Requires `placementGroupAvailabilityZone` to be set.
        :param bool enable_imd_sv2: Enables the ability to use EC2 Instance Metadata Service v2, which provides a more secure way to access instance metadata. For more information, see: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-service.html.
               Defaults to `false`.
               
               Note that this field conflicts with `launchTemplate`. If you are providing a custom `launchTemplate`, you should enable this feature within the `launchTemplateMetadataOptions` of the supplied `launchTemplate`.
        :param pulumi.Input[bool] force_update_version: Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
        :param pulumi.Input[bool] gpu: Use the latest recommended EKS Optimized AMI with GPU support for the worker nodes.
               Defaults to false.
               
               Note: `gpu` and `amiId` are mutually exclusive.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/eks-optimized-amis.html.
        :param bool ignore_scaling_changes: Whether to ignore changes to the desired size of the Auto Scaling Group. This is useful when using Cluster Autoscaler.
               
               See [EKS best practices](https://aws.github.io/aws-eks-best-practices/cluster-autoscaling/) for more details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: Set of instance types associated with the EKS Node Group. Defaults to `["t3.medium"]`. This provider will only perform drift detection if a configuration value is provided. Currently, the EKS API only accepts a single value in the set.
        :param str kubelet_extra_args: Extra args to pass to the Kubelet. Corresponds to the options passed in the `--kubeletExtraArgs` flag to `/etc/eks/bootstrap.sh`. For example, '--port=10251 --address=0.0.0.0'. To escape characters in the extra argsvalue, wrap the value in quotes. For example, `kubeletExtraArgs = '--allowed-unsafe-sysctls "net.core.somaxconn"'`.
               Note that this field conflicts with `launchTemplate`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
        :param pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupLaunchTemplateArgs']] launch_template: Launch Template settings.
               
               Note: This field is mutually exclusive with `kubeletExtraArgs` and `bootstrapExtraArgs`.
        :param pulumi.Input[str] node_group_name: Name of the EKS Node Group. If omitted, this provider will assign a random, unique name. Conflicts with `nodeGroupNamePrefix`.
        :param pulumi.Input[str] node_group_name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `nodeGroupName`.
        :param pulumi.Input['pulumi_aws.iam.Role'] node_role: The IAM Role that provides permissions for the EKS Node Group.
               
               Note, `nodeRole` and `nodeRoleArn` are mutually exclusive, and a single option must be used.
        :param pulumi.Input[str] node_role_arn: Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
               
               Note, `nodeRoleArn` and `nodeRole` are mutually exclusive, and a single option must be used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeadmOptionsArgs', 'NodeadmOptionsArgsDict']]]] nodeadm_extra_options: Extra nodeadm configuration sections to be added to the nodeadm user data. This can be shell scripts, nodeadm NodeConfig or any other user data compatible script. When configuring additional nodeadm NodeConfig sections, they'll be merged with the base settings the provider sets. You can overwrite base settings or provide additional settings this way.
               The base settings the provider sets are:
                 - cluster.name
                 - cluster.apiServerEndpoint
                 - cluster.certificateAuthority
                 - cluster.cidr
               
               Note: This is only applicable when using AL2023.
               See for more details:
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/
                 - https://awslabs.github.io/amazon-eks-ami/nodeadm/doc/api/
        :param pulumi.Input['OperatingSystem'] operating_system: The type of OS to use for the node group. Will be used to determine the right EKS optimized AMI to use based on the instance types and gpu configuration.
               Valid values are `RECOMMENDED`, `AL2`, `AL2023` and `Bottlerocket`.
               
               Defaults to the current recommended OS.
        :param pulumi.Input[str] placement_group_availability_zone: The availability zone of the placement group for EFA support. Required if `enableEfaSupport` is true.
        :param pulumi.Input[str] release_version: AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
        :param pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupRemoteAccessArgs']] remote_access: Remote access settings.
        :param pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupScalingConfigArgs']] scaling_config: Scaling settings.
               
               Default scaling amounts of the node group autoscaling group are:
                 - desiredSize: 2
                 - minSize: 1
                 - maxSize: 2
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Identifiers of EC2 Subnets to associate with the EKS Node Group. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
               
               Default subnetIds is chosen from the following list, in order, if subnetIds arg is not set:
                 - core.subnetIds
                 - core.privateIds
                 - core.publicSubnetIds
               
               This default logic is based on the existing subnet IDs logic of this package: https://git.io/JeM11
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Key-value mapping of resource tags.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupTaintArgs']]]] taints: The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group.
        :param pulumi.Input[str] user_data: User specified code to run on node startup. This is expected to handle the full AWS EKS node bootstrapping. If omitted, the provider will configure the user data.
               
               See for more details: https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html#launch-template-user-data.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedNodeGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EKS Node Group, which can provision and optionally update an Auto Scaling Group of Kubernetes worker nodes compatible with EKS. Additional documentation about this functionality can be found in the [EKS User Guide](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html).

        ## Example Usage
        ### Basic Managed Node Group
        This example demonstrates creating a managed node group with typical defaults. The node group uses the latest EKS-optimized Amazon Linux AMI, creates 2 nodes, and runs on t3.medium instances. Instance security groups are automatically configured.

        ```python
        import pulumi
        import json
        import pulumi_aws as aws
        import pulumi_awsx as awsx
        import pulumi_eks as eks

        eks_vpc = awsx.ec2.Vpc("eks-vpc",
            enable_dns_hostnames=True,
            cidr_block="10.0.0.0/16")
        eks_cluster = eks.Cluster("eks-cluster",
            vpc_id=eks_vpc.vpc_id,
            authentication_mode=eks.AuthenticationMode.API,
            public_subnet_ids=eks_vpc.public_subnet_ids,
            private_subnet_ids=eks_vpc.private_subnet_ids,
            skip_default_node_group=True)
        node_role = aws.iam.Role("node-role", assume_role_policy=json.dumps({
            "Version": "2012-10-17",
            "Statement": [{
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Sid": "",
                "Principal": {
                    "Service": "ec2.amazonaws.com",
                },
            }],
        }))
        worker_node_policy = aws.iam.RolePolicyAttachment("worker-node-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSWorkerNodePolicy")
        cni_policy = aws.iam.RolePolicyAttachment("cni-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy")
        registry_policy = aws.iam.RolePolicyAttachment("registry-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryReadOnly")
        node_group = eks.ManagedNodeGroup("node-group",
            cluster=eks_cluster,
            node_role=node_role)

        ```
        ### Enabling EFA Support

        Enabling EFA support for a node group will do the following:
        - All EFA interfaces supported by the instance will be exposed on the launch template used by the node group
        - A `clustered` placement group will be created and passed to the launch template
        - Checks will be performed to ensure that the instance type supports EFA and that the specified AZ is supported by the chosen instance type

        The GPU optimized AMIs include all necessary drivers and libraries to support EFA. If you're choosing an instance type without GPU acceleration you will need to install the drivers and libraries manually and bake a custom AMI.

        You can use the [aws-efa-k8s-device-plugin](https://github.com/aws/eks-charts/tree/master/stable/aws-efa-k8s-device-plugin) Helm chart to expose the EFA interfaces on the nodes as an extended resource, and allow pods to request these interfaces to be mounted to their containers.
        Your application container will need to have the necessary libraries and runtimes in order to leverage the EFA interfaces (e.g. libfabric).

        ```python
        import pulumi
        import json
        import pulumi_aws as aws
        import pulumi_awsx as awsx
        import pulumi_eks as eks
        import pulumi_kubernetes as kubernetes

        eks_vpc = awsx.ec2.Vpc("eks-vpc",
            enable_dns_hostnames=True,
            cidr_block="10.0.0.0/16")
        eks_cluster = eks.Cluster("eks-cluster",
            vpc_id=eks_vpc.vpc_id,
            authentication_mode=eks.AuthenticationMode.API,
            public_subnet_ids=eks_vpc.public_subnet_ids,
            private_subnet_ids=eks_vpc.private_subnet_ids,
            skip_default_node_group=True)
        k8_s_provider = kubernetes.Provider("k8sProvider", kubeconfig=eks_cluster.kubeconfig)
        node_role = aws.iam.Role("node-role", assume_role_policy=json.dumps({
            "Version": "2012-10-17",
            "Statement": [{
                "Action": "sts:AssumeRole",
                "Effect": "Allow",
                "Sid": "",
                "Principal": {
                    "Service": "ec2.amazonaws.com",
                },
            }],
        }))
        worker_node_policy = aws.iam.RolePolicyAttachment("worker-node-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEKSWorkerNodePolicy")
        cni_policy = aws.iam.RolePolicyAttachment("cni-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy")
        registry_policy = aws.iam.RolePolicyAttachment("registry-policy",
            role=node_role.name,
            policy_arn="arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryReadOnly")

        # The node group for running system pods (e.g. coredns, etc.)
        system_node_group = eks.ManagedNodeGroup("system-node-group",
            cluster=eks_cluster,
            node_role=node_role)

        # The EFA device plugin for exposing EFA interfaces as extended resources
        device_plugin = kubernetes.helm.v3.Release("device-plugin",
            version="0.5.7",
            repository_opts={
                "repo": "https://aws.github.io/eks-charts",
            },
            chart="aws-efa-k8s-device-plugin",
            namespace="kube-system",
            atomic=True,
            values={
                "tolerations": [{
                    "key": "efa-enabled",
                    "operator": "Exists",
                    "effect": "NoExecute",
                }],
            },
            opts = pulumi.ResourceOptions(provider=k8_s_provider))

        # The node group for running EFA enabled workloads
        efa_node_group = eks.ManagedNodeGroup("efa-node-group",
            cluster=eks_cluster,
            node_role=node_role,
            instance_types=["g6.8xlarge"],
            gpu=True,
            scaling_config={
                "min_size": 2,
                "desired_size": 2,
                "max_size": 4,
            },
            enable_efa_support=True,
            placement_group_availability_zone="us-west-2b",

            # Taint the nodes so that only pods with the efa-enabled label can be scheduled on them
            taints=[{
                "key": "efa-enabled",
                "value": "true",
                "effect": "NO_EXECUTE",
            }],

            # Instances with GPUs usually have nvme instance store volumes, so we can mount them in RAID-0 for kubelet and containerd
            # These are faster than the regular EBS volumes
            nodeadm_extra_options=[{
                "content_type": "application/node.eks.aws",
                "content": \"\"\"apiVersion: node.eks.aws/v1alpha1
        kind: NodeConfig
        spec:
          instance:
            localStorage:
              strategy: RAID0
        \"\"\",
            }])

        ```

        :param str resource_name: The name of the resource.
        :param ManagedNodeGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedNodeGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_id: Optional[pulumi.Input[str]] = None,
                 ami_type: Optional[pulumi.Input[str]] = None,
                 bootstrap_extra_args: Optional[str] = None,
                 bottlerocket_settings: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 capacity_type: Optional[pulumi.Input[str]] = None,
                 cluster: Optional[pulumi.Input[Union['Cluster', Union['CoreDataArgs', 'CoreDataArgsDict']]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 enable_efa_support: Optional[bool] = None,
                 enable_imd_sv2: Optional[bool] = None,
                 force_update_version: Optional[pulumi.Input[bool]] = None,
                 gpu: Optional[pulumi.Input[bool]] = None,
                 ignore_scaling_changes: Optional[bool] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kubelet_extra_args: Optional[str] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 launch_template: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupLaunchTemplateArgs']]] = None,
                 node_group_name: Optional[pulumi.Input[str]] = None,
                 node_group_name_prefix: Optional[pulumi.Input[str]] = None,
                 node_role: Optional[pulumi.Input['pulumi_aws.iam.Role']] = None,
                 node_role_arn: Optional[pulumi.Input[str]] = None,
                 nodeadm_extra_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeadmOptionsArgs', 'NodeadmOptionsArgsDict']]]]] = None,
                 operating_system: Optional[pulumi.Input['OperatingSystem']] = None,
                 placement_group_availability_zone: Optional[pulumi.Input[str]] = None,
                 release_version: Optional[pulumi.Input[str]] = None,
                 remote_access: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupRemoteAccessArgs']]] = None,
                 scaling_config: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupScalingConfigArgs']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_aws.eks.NodeGroupTaintArgs']]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedNodeGroupArgs.__new__(ManagedNodeGroupArgs)

            __props__.__dict__["ami_id"] = ami_id
            __props__.__dict__["ami_type"] = ami_type
            __props__.__dict__["bootstrap_extra_args"] = bootstrap_extra_args
            __props__.__dict__["bottlerocket_settings"] = bottlerocket_settings
            __props__.__dict__["capacity_type"] = capacity_type
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["disk_size"] = disk_size
            __props__.__dict__["enable_efa_support"] = enable_efa_support
            __props__.__dict__["enable_imd_sv2"] = enable_imd_sv2
            __props__.__dict__["force_update_version"] = force_update_version
            __props__.__dict__["gpu"] = gpu
            __props__.__dict__["ignore_scaling_changes"] = ignore_scaling_changes
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["kubelet_extra_args"] = kubelet_extra_args
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launch_template"] = launch_template
            __props__.__dict__["node_group_name"] = node_group_name
            __props__.__dict__["node_group_name_prefix"] = node_group_name_prefix
            __props__.__dict__["node_role"] = node_role
            __props__.__dict__["node_role_arn"] = node_role_arn
            __props__.__dict__["nodeadm_extra_options"] = nodeadm_extra_options
            __props__.__dict__["operating_system"] = operating_system
            __props__.__dict__["placement_group_availability_zone"] = placement_group_availability_zone
            __props__.__dict__["release_version"] = release_version
            __props__.__dict__["remote_access"] = remote_access
            __props__.__dict__["scaling_config"] = scaling_config
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["version"] = version
            __props__.__dict__["node_group"] = None
            __props__.__dict__["placement_group_name"] = None
        super(ManagedNodeGroup, __self__).__init__(
            'eks:index:ManagedNodeGroup',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter(name="nodeGroup")
    def node_group(self) -> pulumi.Output['pulumi_aws.eks.NodeGroup']:
        """
        The AWS managed node group.
        """
        return pulumi.get(self, "node_group")

    @property
    @pulumi.getter(name="placementGroupName")
    def placement_group_name(self) -> pulumi.Output[str]:
        """
        The name of the placement group created for the managed node group.
        """
        return pulumi.get(self, "placement_group_name")

