"""Setup script for InfraMind CLI"""

from setuptools import setup, find_packages
from pathlib import Path

# Read the contents of README file
this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text(encoding='utf-8')

# Read version from VERSION file or default
version_file = this_directory.parent / "VERSION"
if version_file.exists():
    version = version_file.read_text().strip()
else:
    version = "0.1.0"

setup(
    name="InfraMind",
    version=version,
    author="InfraMind Team",
    author_email="hello@inframind.dev",
    description="CLI tool for InfraMind CI/CD optimization engine",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/IdanG7/InfraMind",
    project_urls={
        "Bug Tracker": "https://github.com/IdanG7/InfraMind/issues",
        "Documentation": "https://github.com/IdanG7/InfraMind/blob/main/docs/",
        "Source Code": "https://github.com/IdanG7/InfraMind",
        "Changelog": "https://github.com/IdanG7/InfraMind/releases",
    },
    py_modules=["inframind"],
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Build Tools",
        "Topic :: System :: Monitoring",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Operating System :: OS Independent",
        "Environment :: Console",
    ],
    python_requires=">=3.8",
    install_requires=[
        "requests>=2.28.0",
    ],
    extras_require={
        "dev": [
            "pytest>=7.0.0",
            "pytest-cov>=4.0.0",
            "black>=22.0.0",
            "ruff>=0.1.0",
        ],
    },
    entry_points={
        "console_scripts": [
            "inframind=inframind:main",
        ],
    },
    keywords=[
        "ci-cd",
        "optimization",
        "machine-learning",
        "devops",
        "jenkins",
        "github-actions",
        "gitlab-ci",
        "build-optimization",
    ],
    license="MIT",
    platforms=["any"],
    zip_safe=False,
)
