"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Platform = exports.CustomRule = exports.RedirectStatus = exports.App = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
const branch_1 = require("./branch");
const domain_1 = require("./domain");
const utils_1 = require("./utils");
/**
 * An Amplify Console application
 */
class App extends core_1.Resource {
    /**
     * Import an existing application
     */
    static fromAppId(scope, id, appId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.appId = appId;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_AppProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, App);
            }
            throw error;
        }
        this.customRules = props.customRules || [];
        this.environmentVariables = props.environmentVariables || {};
        this.autoBranchEnvironmentVariables = props.autoBranchCreation && props.autoBranchCreation.environmentVariables || {};
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('amplify.amazonaws.com'),
        });
        this.grantPrincipal = role;
        const sourceCodeProviderOptions = props.sourceCodeProvider?.bind(this);
        const app = new aws_amplify_1.CfnApp(this, 'Resource', {
            accessToken: sourceCodeProviderOptions?.accessToken?.unsafeUnwrap(), // Safe usage
            autoBranchCreationConfig: props.autoBranchCreation && {
                autoBranchCreationPatterns: props.autoBranchCreation.patterns,
                basicAuthConfig: props.autoBranchCreation.basicAuth
                    ? props.autoBranchCreation.basicAuth.bind(this, 'BranchBasicAuth')
                    : { enableBasicAuth: false },
                buildSpec: props.autoBranchCreation.buildSpec && props.autoBranchCreation.buildSpec.toBuildSpec(),
                enableAutoBranchCreation: true,
                enableAutoBuild: props.autoBranchCreation.autoBuild ?? true,
                environmentVariables: core_1.Lazy.any({ produce: () => (0, utils_1.renderEnvironmentVariables)(this.autoBranchEnvironmentVariables) }, { omitEmptyArray: true }), // eslint-disable-line max-len
                enablePullRequestPreview: props.autoBranchCreation.pullRequestPreview ?? true,
                pullRequestEnvironmentName: props.autoBranchCreation.pullRequestEnvironmentName,
                stage: props.autoBranchCreation.stage,
            },
            enableBranchAutoDeletion: props.autoBranchDeletion,
            basicAuthConfig: props.basicAuth
                ? props.basicAuth.bind(this, 'AppBasicAuth')
                : { enableBasicAuth: false },
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            customRules: core_1.Lazy.any({ produce: () => this.customRules }, { omitEmptyArray: true }),
            description: props.description,
            environmentVariables: core_1.Lazy.any({ produce: () => (0, utils_1.renderEnvironmentVariables)(this.environmentVariables) }, { omitEmptyArray: true }),
            iamServiceRole: role.roleArn,
            name: props.appName || this.node.id,
            oauthToken: sourceCodeProviderOptions?.oauthToken?.unsafeUnwrap(), // Safe usage
            repository: sourceCodeProviderOptions?.repository,
            customHeaders: props.customResponseHeaders ? renderCustomResponseHeaders(props.customResponseHeaders) : undefined,
            platform: props.platform || Platform.WEB,
        });
        this.appId = app.attrAppId;
        this.appName = app.attrAppName;
        this.arn = app.attrArn;
        this.defaultDomain = app.attrDefaultDomain;
    }
    /**
     * Adds a custom rewrite/redirect rule to this application
     */
    addCustomRule(rule) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_CustomRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addCustomRule);
            }
            throw error;
        }
        this.customRules.push(rule);
        return this;
    }
    /**
     * Adds an environment variable to this application.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
    /**
     * Adds an environment variable to the auto created branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addAutoBranchEnvironment(name, value) {
        this.autoBranchEnvironmentVariables[name] = value;
        return this;
    }
    /**
     * Adds a branch to this application
     */
    addBranch(id, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_BranchOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addBranch);
            }
            throw error;
        }
        return new branch_1.Branch(this, id, {
            ...options,
            app: this,
        });
    }
    /**
     * Adds a domain to this application
     */
    addDomain(id, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_DomainOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addDomain);
            }
            throw error;
        }
        return new domain_1.Domain(this, id, {
            ...options,
            app: this,
            autoSubDomainIamRole: this.grantPrincipal,
        });
    }
}
exports.App = App;
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.App", version: "2.142.0-alpha.0" };
/**
 * The status code for a URL rewrite or redirect rule.
 */
var RedirectStatus;
(function (RedirectStatus) {
    /**
     * Rewrite (200)
     */
    RedirectStatus["REWRITE"] = "200";
    /**
     * Permanent redirect (301)
     */
    RedirectStatus["PERMANENT_REDIRECT"] = "301";
    /**
     * Temporary redirect (302)
     */
    RedirectStatus["TEMPORARY_REDIRECT"] = "302";
    /**
     * Not found (404)
     */
    RedirectStatus["NOT_FOUND"] = "404";
    /**
     * Not found rewrite (404)
     */
    RedirectStatus["NOT_FOUND_REWRITE"] = "404-200";
})(RedirectStatus || (exports.RedirectStatus = RedirectStatus = {}));
/**
 * Custom rewrite/redirect rule for an Amplify App.
 *
 * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
 */
class CustomRule {
    constructor(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_CustomRuleOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CustomRule);
            }
            throw error;
        }
        this.source = options.source;
        this.target = options.target;
        this.status = options.status;
        this.condition = options.condition;
    }
}
exports.CustomRule = CustomRule;
_b = JSII_RTTI_SYMBOL_1;
CustomRule[_b] = { fqn: "@aws-cdk/aws-amplify-alpha.CustomRule", version: "2.142.0-alpha.0" };
/**
 * Sets up a 200 rewrite for all paths to `index.html` except for path
 * containing a file extension.
 */
CustomRule.SINGLE_PAGE_APPLICATION_REDIRECT = new CustomRule({
    source: '</^[^.]+$/>',
    target: '/index.html',
    status: RedirectStatus.REWRITE,
});
function renderCustomResponseHeaders(customHeaders) {
    const yaml = [
        'customHeaders:',
    ];
    for (const customHeader of customHeaders) {
        yaml.push(`  - pattern: "${customHeader.pattern}"`);
        yaml.push('    headers:');
        for (const [key, value] of Object.entries(customHeader.headers)) {
            yaml.push(`      - key: "${key}"`);
            yaml.push(`        value: "${value}"`);
        }
    }
    return `${yaml.join('\n')}\n`;
}
/**
 * Available hosting platforms to use on the App.
 */
var Platform;
(function (Platform) {
    /**
     * WEB - Used to indicate that the app is hosted using only static assets.
     */
    Platform["WEB"] = "WEB";
    /**
     * WEB_COMPUTE - Used to indicate the app is hosted using a combination of
     * server side rendered and static assets.
     */
    Platform["WEB_COMPUTE"] = "WEB_COMPUTE";
})(Platform || (exports.Platform = Platform = {}));
//# sourceMappingURL=data:application/json;base64,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