"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Branch = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("aws-cdk-lib/aws-iam");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const core_1 = require("aws-cdk-lib/core");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
const utils_1 = require("./utils");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
/**
 * An Amplify Console branch
 */
class Branch extends core_1.Resource {
    /**
     * Import an existing branch
     */
    static fromBranchName(scope, id, branchName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.branchName = branchName;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_BranchProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Branch);
            }
            throw error;
        }
        this.environmentVariables = props.environmentVariables || {};
        const branchName = props.branchName || id;
        const branch = new aws_amplify_1.CfnBranch(this, 'Resource', {
            appId: props.app.appId,
            basicAuthConfig: props.basicAuth && props.basicAuth.bind(this, `${branchName}BasicAuth`),
            branchName,
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            description: props.description,
            enableAutoBuild: props.autoBuild ?? true,
            enablePullRequestPreview: props.pullRequestPreview ?? true,
            environmentVariables: core_1.Lazy.any({ produce: () => (0, utils_1.renderEnvironmentVariables)(this.environmentVariables) }, { omitEmptyArray: true }),
            pullRequestEnvironmentName: props.pullRequestEnvironmentName,
            stage: props.stage,
            enablePerformanceMode: props.performanceMode,
        });
        this.arn = branch.attrArn;
        this.branchName = branch.attrBranchName;
        if (props.asset) {
            new core_1.CustomResource(this, 'DeploymentResource', {
                serviceToken: AmplifyAssetDeploymentProvider.getOrCreate(this),
                resourceType: 'Custom::AmplifyAssetDeployment',
                properties: {
                    AppId: props.app.appId,
                    BranchName: branchName,
                    S3ObjectKey: props.asset.s3ObjectKey,
                    S3BucketName: props.asset.s3BucketName,
                },
            });
        }
    }
    /**
     * Adds an environment variable to this branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
}
exports.Branch = Branch;
_a = JSII_RTTI_SYMBOL_1;
Branch[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.Branch", version: "2.142.0-alpha.0" };
class AmplifyAssetDeploymentProvider extends core_1.NestedStack {
    /**
     * Returns the singleton provider.
     */
    static getOrCreate(scope) {
        const providerId = 'com.amazonaws.cdk.custom-resources.amplify-asset-deployment-provider';
        const stack = core_1.Stack.of(scope);
        const group = stack.node.tryFindChild(providerId) ?? new AmplifyAssetDeploymentProvider(stack, providerId);
        return group.provider.serviceToken;
    }
    constructor(scope, id) {
        super(scope, id);
        const onEvent = new aws_lambda_nodejs_1.NodejsFunction(this, 'amplify-asset-deployment-on-event', {
            entry: path.join(__dirname, '..', 'custom-resource-handlers', 'dist', 'aws-amplify-alpha', 'asset-deployment-handler', 'index.js'),
            handler: 'onEvent',
            initialPolicy: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: [
                        's3:GetObject',
                        's3:GetSignedUrl',
                        'amplify:ListJobs',
                        'amplify:StartDeployment',
                    ],
                }),
            ],
            runtime: aws_lambda_1.Runtime.NODEJS_18_X,
        });
        const isComplete = new aws_lambda_nodejs_1.NodejsFunction(this, 'amplify-asset-deployment-is-complete', {
            entry: path.join(__dirname, '..', 'custom-resource-handlers', 'dist', 'aws-amplify-alpha', 'asset-deployment-handler', 'index.js'),
            handler: 'isComplete',
            initialPolicy: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: ['amplify:GetJob*'],
                }),
            ],
            runtime: aws_lambda_1.Runtime.NODEJS_18_X,
        });
        this.provider = new custom_resources_1.Provider(this, 'amplify-asset-deployment-handler-provider', {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            totalTimeout: core_1.Duration.minutes(5),
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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