# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAgentEnvVarArgs']]]] = None,
                 aks_config_v2: Optional[pulumi.Input['ClusterAksConfigV2Args']] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterAgentDeploymentCustomizationArgs']]]] = None,
                 cluster_auth_endpoint: Optional[pulumi.Input['ClusterClusterAuthEndpointArgs']] = None,
                 cluster_template_answers: Optional[pulumi.Input['ClusterClusterTemplateAnswersArgs']] = None,
                 cluster_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_template_questions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterTemplateQuestionArgs']]]] = None,
                 cluster_template_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_pod_security_admission_configuration_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_agent_image: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_auth_image: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_root_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 driver: Optional[pulumi.Input[_builtins.str]] = None,
                 eks_config_v2: Optional[pulumi.Input['ClusterEksConfigV2Args']] = None,
                 enable_network_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFleetAgentDeploymentCustomizationArgs']]]] = None,
                 fleet_workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gke_config_v2: Optional[pulumi.Input['ClusterGkeConfigV2Args']] = None,
                 imported_config: Optional[pulumi.Input['ClusterImportedConfigArgs']] = None,
                 k3s_config: Optional[pulumi.Input['ClusterK3sConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oke_config: Optional[pulumi.Input['ClusterOkeConfigArgs']] = None,
                 rke2_config: Optional[pulumi.Input['ClusterRke2ConfigArgs']] = None,
                 rke_config: Optional[pulumi.Input['ClusterRkeConfigArgs']] = None,
                 windows_prefered_cluster: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAgentEnvVarArgs']]] agent_env_vars: Optional Agent Env Vars for Rancher agent. For Rancher v2.5.6 and above (list)
        :param pulumi.Input['ClusterAksConfigV2Args'] aks_config_v2: The Azure AKS v2 configuration for creating/import `aks` Clusters. Conflicts with `eks_config_v2`, `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the Cluster (map)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClusterAgentDeploymentCustomizationArgs']]] cluster_agent_deployment_customizations: Optional customization for cluster agent. For Rancher v2.7.5 and above (list)
        :param pulumi.Input['ClusterClusterAuthEndpointArgs'] cluster_auth_endpoint: Enabling the [local cluster authorized endpoint](https://rancher.com/docs/rancher/v2.x/en/cluster-provisioning/rke-clusters/options/#local-cluster-auth-endpoint) allows direct communication with the cluster, bypassing the Rancher API proxy. (list maxitems:1)
        :param pulumi.Input['ClusterClusterTemplateAnswersArgs'] cluster_template_answers: Cluster template answers. For Rancher v2.3.x and above (list maxitems:1)
        :param pulumi.Input[_builtins.str] cluster_template_id: Cluster template ID. For Rancher v2.3.x and above (string)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClusterTemplateQuestionArgs']]] cluster_template_questions: Cluster template questions. For Rancher v2.3.x and above (list)
        :param pulumi.Input[_builtins.str] cluster_template_revision_id: Cluster template revision ID. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] default_pod_security_admission_configuration_template_name: The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above (string)
        :param pulumi.Input[_builtins.str] description: The description for Cluster (string)
        :param pulumi.Input[_builtins.str] desired_agent_image: Desired agent image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] desired_auth_image: Desired auth image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] docker_root_dir: Desired auth image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] driver: (Computed) The driver used for the Cluster. `imported`, `azurekubernetesservice`, `amazonelasticcontainerservice`, `googlekubernetesengine` and `rancherKubernetesEngine` are supported (string)
        :param pulumi.Input['ClusterEksConfigV2Args'] eks_config_v2: The Amazon EKS V2 configuration to create or import `eks` Clusters. Conflicts with `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.x and above (list maxitems:1)
        :param pulumi.Input[_builtins.bool] enable_network_policy: Enable project network isolation (bool)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterFleetAgentDeploymentCustomizationArgs']]] fleet_agent_deployment_customizations: Optional customization for fleet agent. For Rancher v2.7.5 and above (list)
        :param pulumi.Input[_builtins.str] fleet_workspace_name: Fleet workspace name (string)
        :param pulumi.Input['ClusterGkeConfigV2Args'] gke_config_v2: The Google GKE V2 configuration for `gke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.8 and above (list maxitems:1)
        :param pulumi.Input['ClusterImportedConfigArgs'] imported_config: The imported configuration for generic imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `rke_config`, `rke2_config` and `k3s_config` (list maxitems:1)
        :param pulumi.Input['ClusterK3sConfigArgs'] k3s_config: The K3S configuration for `k3s` imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the Cluster (map)
        :param pulumi.Input[_builtins.str] name: The name of the Cluster (string)
        :param pulumi.Input['ClusterOkeConfigArgs'] oke_config: The Oracle OKE configuration for `oke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `k3s_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input['ClusterRke2ConfigArgs'] rke2_config: The RKE2 configuration for `rke2` Clusters. Conflicts with `aks_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input['ClusterRkeConfigArgs'] rke_config: The RKE configuration for `rke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `k3s_config` (list maxitems:1)
        :param pulumi.Input[_builtins.bool] windows_prefered_cluster: Windows preferred cluster. Default: `false` (bool)
        """
        if agent_env_vars is not None:
            pulumi.set(__self__, "agent_env_vars", agent_env_vars)
        if aks_config_v2 is not None:
            pulumi.set(__self__, "aks_config_v2", aks_config_v2)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if cluster_agent_deployment_customizations is not None:
            pulumi.set(__self__, "cluster_agent_deployment_customizations", cluster_agent_deployment_customizations)
        if cluster_auth_endpoint is not None:
            pulumi.set(__self__, "cluster_auth_endpoint", cluster_auth_endpoint)
        if cluster_template_answers is not None:
            pulumi.set(__self__, "cluster_template_answers", cluster_template_answers)
        if cluster_template_id is not None:
            pulumi.set(__self__, "cluster_template_id", cluster_template_id)
        if cluster_template_questions is not None:
            pulumi.set(__self__, "cluster_template_questions", cluster_template_questions)
        if cluster_template_revision_id is not None:
            pulumi.set(__self__, "cluster_template_revision_id", cluster_template_revision_id)
        if default_pod_security_admission_configuration_template_name is not None:
            pulumi.set(__self__, "default_pod_security_admission_configuration_template_name", default_pod_security_admission_configuration_template_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_agent_image is not None:
            pulumi.set(__self__, "desired_agent_image", desired_agent_image)
        if desired_auth_image is not None:
            pulumi.set(__self__, "desired_auth_image", desired_auth_image)
        if docker_root_dir is not None:
            pulumi.set(__self__, "docker_root_dir", docker_root_dir)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if eks_config_v2 is not None:
            pulumi.set(__self__, "eks_config_v2", eks_config_v2)
        if enable_network_policy is not None:
            pulumi.set(__self__, "enable_network_policy", enable_network_policy)
        if fleet_agent_deployment_customizations is not None:
            pulumi.set(__self__, "fleet_agent_deployment_customizations", fleet_agent_deployment_customizations)
        if fleet_workspace_name is not None:
            pulumi.set(__self__, "fleet_workspace_name", fleet_workspace_name)
        if gke_config_v2 is not None:
            pulumi.set(__self__, "gke_config_v2", gke_config_v2)
        if imported_config is not None:
            pulumi.set(__self__, "imported_config", imported_config)
        if k3s_config is not None:
            pulumi.set(__self__, "k3s_config", k3s_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oke_config is not None:
            pulumi.set(__self__, "oke_config", oke_config)
        if rke2_config is not None:
            pulumi.set(__self__, "rke2_config", rke2_config)
        if rke_config is not None:
            pulumi.set(__self__, "rke_config", rke_config)
        if windows_prefered_cluster is not None:
            pulumi.set(__self__, "windows_prefered_cluster", windows_prefered_cluster)

    @_builtins.property
    @pulumi.getter(name="agentEnvVars")
    def agent_env_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAgentEnvVarArgs']]]]:
        """
        Optional Agent Env Vars for Rancher agent. For Rancher v2.5.6 and above (list)
        """
        return pulumi.get(self, "agent_env_vars")

    @agent_env_vars.setter
    def agent_env_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAgentEnvVarArgs']]]]):
        pulumi.set(self, "agent_env_vars", value)

    @_builtins.property
    @pulumi.getter(name="aksConfigV2")
    def aks_config_v2(self) -> Optional[pulumi.Input['ClusterAksConfigV2Args']]:
        """
        The Azure AKS v2 configuration for creating/import `aks` Clusters. Conflicts with `eks_config_v2`, `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "aks_config_v2")

    @aks_config_v2.setter
    def aks_config_v2(self, value: Optional[pulumi.Input['ClusterAksConfigV2Args']]):
        pulumi.set(self, "aks_config_v2", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for the Cluster (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="clusterAgentDeploymentCustomizations")
    def cluster_agent_deployment_customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterAgentDeploymentCustomizationArgs']]]]:
        """
        Optional customization for cluster agent. For Rancher v2.7.5 and above (list)
        """
        return pulumi.get(self, "cluster_agent_deployment_customizations")

    @cluster_agent_deployment_customizations.setter
    def cluster_agent_deployment_customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterAgentDeploymentCustomizationArgs']]]]):
        pulumi.set(self, "cluster_agent_deployment_customizations", value)

    @_builtins.property
    @pulumi.getter(name="clusterAuthEndpoint")
    def cluster_auth_endpoint(self) -> Optional[pulumi.Input['ClusterClusterAuthEndpointArgs']]:
        """
        Enabling the [local cluster authorized endpoint](https://rancher.com/docs/rancher/v2.x/en/cluster-provisioning/rke-clusters/options/#local-cluster-auth-endpoint) allows direct communication with the cluster, bypassing the Rancher API proxy. (list maxitems:1)
        """
        return pulumi.get(self, "cluster_auth_endpoint")

    @cluster_auth_endpoint.setter
    def cluster_auth_endpoint(self, value: Optional[pulumi.Input['ClusterClusterAuthEndpointArgs']]):
        pulumi.set(self, "cluster_auth_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="clusterTemplateAnswers")
    def cluster_template_answers(self) -> Optional[pulumi.Input['ClusterClusterTemplateAnswersArgs']]:
        """
        Cluster template answers. For Rancher v2.3.x and above (list maxitems:1)
        """
        return pulumi.get(self, "cluster_template_answers")

    @cluster_template_answers.setter
    def cluster_template_answers(self, value: Optional[pulumi.Input['ClusterClusterTemplateAnswersArgs']]):
        pulumi.set(self, "cluster_template_answers", value)

    @_builtins.property
    @pulumi.getter(name="clusterTemplateId")
    def cluster_template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster template ID. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "cluster_template_id")

    @cluster_template_id.setter
    def cluster_template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_template_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterTemplateQuestions")
    def cluster_template_questions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterTemplateQuestionArgs']]]]:
        """
        Cluster template questions. For Rancher v2.3.x and above (list)
        """
        return pulumi.get(self, "cluster_template_questions")

    @cluster_template_questions.setter
    def cluster_template_questions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterTemplateQuestionArgs']]]]):
        pulumi.set(self, "cluster_template_questions", value)

    @_builtins.property
    @pulumi.getter(name="clusterTemplateRevisionId")
    def cluster_template_revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster template revision ID. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "cluster_template_revision_id")

    @cluster_template_revision_id.setter
    def cluster_template_revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_template_revision_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultPodSecurityAdmissionConfigurationTemplateName")
    def default_pod_security_admission_configuration_template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above (string)
        """
        return pulumi.get(self, "default_pod_security_admission_configuration_template_name")

    @default_pod_security_admission_configuration_template_name.setter
    def default_pod_security_admission_configuration_template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_pod_security_admission_configuration_template_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for Cluster (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="desiredAgentImage")
    def desired_agent_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired agent image. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "desired_agent_image")

    @desired_agent_image.setter
    def desired_agent_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_agent_image", value)

    @_builtins.property
    @pulumi.getter(name="desiredAuthImage")
    def desired_auth_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired auth image. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "desired_auth_image")

    @desired_auth_image.setter
    def desired_auth_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_auth_image", value)

    @_builtins.property
    @pulumi.getter(name="dockerRootDir")
    def docker_root_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired auth image. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "docker_root_dir")

    @docker_root_dir.setter
    def docker_root_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "docker_root_dir", value)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The driver used for the Cluster. `imported`, `azurekubernetesservice`, `amazonelasticcontainerservice`, `googlekubernetesengine` and `rancherKubernetesEngine` are supported (string)
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "driver", value)

    @_builtins.property
    @pulumi.getter(name="eksConfigV2")
    def eks_config_v2(self) -> Optional[pulumi.Input['ClusterEksConfigV2Args']]:
        """
        The Amazon EKS V2 configuration to create or import `eks` Clusters. Conflicts with `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.x and above (list maxitems:1)
        """
        return pulumi.get(self, "eks_config_v2")

    @eks_config_v2.setter
    def eks_config_v2(self, value: Optional[pulumi.Input['ClusterEksConfigV2Args']]):
        pulumi.set(self, "eks_config_v2", value)

    @_builtins.property
    @pulumi.getter(name="enableNetworkPolicy")
    def enable_network_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable project network isolation (bool)
        """
        return pulumi.get(self, "enable_network_policy")

    @enable_network_policy.setter
    def enable_network_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_network_policy", value)

    @_builtins.property
    @pulumi.getter(name="fleetAgentDeploymentCustomizations")
    def fleet_agent_deployment_customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFleetAgentDeploymentCustomizationArgs']]]]:
        """
        Optional customization for fleet agent. For Rancher v2.7.5 and above (list)
        """
        return pulumi.get(self, "fleet_agent_deployment_customizations")

    @fleet_agent_deployment_customizations.setter
    def fleet_agent_deployment_customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFleetAgentDeploymentCustomizationArgs']]]]):
        pulumi.set(self, "fleet_agent_deployment_customizations", value)

    @_builtins.property
    @pulumi.getter(name="fleetWorkspaceName")
    def fleet_workspace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fleet workspace name (string)
        """
        return pulumi.get(self, "fleet_workspace_name")

    @fleet_workspace_name.setter
    def fleet_workspace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_workspace_name", value)

    @_builtins.property
    @pulumi.getter(name="gkeConfigV2")
    def gke_config_v2(self) -> Optional[pulumi.Input['ClusterGkeConfigV2Args']]:
        """
        The Google GKE V2 configuration for `gke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.8 and above (list maxitems:1)
        """
        return pulumi.get(self, "gke_config_v2")

    @gke_config_v2.setter
    def gke_config_v2(self, value: Optional[pulumi.Input['ClusterGkeConfigV2Args']]):
        pulumi.set(self, "gke_config_v2", value)

    @_builtins.property
    @pulumi.getter(name="importedConfig")
    def imported_config(self) -> Optional[pulumi.Input['ClusterImportedConfigArgs']]:
        """
        The imported configuration for generic imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `rke_config`, `rke2_config` and `k3s_config` (list maxitems:1)
        """
        return pulumi.get(self, "imported_config")

    @imported_config.setter
    def imported_config(self, value: Optional[pulumi.Input['ClusterImportedConfigArgs']]):
        pulumi.set(self, "imported_config", value)

    @_builtins.property
    @pulumi.getter(name="k3sConfig")
    def k3s_config(self) -> Optional[pulumi.Input['ClusterK3sConfigArgs']]:
        """
        The K3S configuration for `k3s` imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "k3s_config")

    @k3s_config.setter
    def k3s_config(self, value: Optional[pulumi.Input['ClusterK3sConfigArgs']]):
        pulumi.set(self, "k3s_config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for the Cluster (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cluster (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="okeConfig")
    def oke_config(self) -> Optional[pulumi.Input['ClusterOkeConfigArgs']]:
        """
        The Oracle OKE configuration for `oke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `k3s_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "oke_config")

    @oke_config.setter
    def oke_config(self, value: Optional[pulumi.Input['ClusterOkeConfigArgs']]):
        pulumi.set(self, "oke_config", value)

    @_builtins.property
    @pulumi.getter(name="rke2Config")
    def rke2_config(self) -> Optional[pulumi.Input['ClusterRke2ConfigArgs']]:
        """
        The RKE2 configuration for `rke2` Clusters. Conflicts with `aks_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "rke2_config")

    @rke2_config.setter
    def rke2_config(self, value: Optional[pulumi.Input['ClusterRke2ConfigArgs']]):
        pulumi.set(self, "rke2_config", value)

    @_builtins.property
    @pulumi.getter(name="rkeConfig")
    def rke_config(self) -> Optional[pulumi.Input['ClusterRkeConfigArgs']]:
        """
        The RKE configuration for `rke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `k3s_config` (list maxitems:1)
        """
        return pulumi.get(self, "rke_config")

    @rke_config.setter
    def rke_config(self, value: Optional[pulumi.Input['ClusterRkeConfigArgs']]):
        pulumi.set(self, "rke_config", value)

    @_builtins.property
    @pulumi.getter(name="windowsPreferedCluster")
    def windows_prefered_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Windows preferred cluster. Default: `false` (bool)
        """
        return pulumi.get(self, "windows_prefered_cluster")

    @windows_prefered_cluster.setter
    def windows_prefered_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "windows_prefered_cluster", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAgentEnvVarArgs']]]] = None,
                 aks_config_v2: Optional[pulumi.Input['ClusterAksConfigV2Args']] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterAgentDeploymentCustomizationArgs']]]] = None,
                 cluster_auth_endpoint: Optional[pulumi.Input['ClusterClusterAuthEndpointArgs']] = None,
                 cluster_registration_token: Optional[pulumi.Input['ClusterClusterRegistrationTokenArgs']] = None,
                 cluster_template_answers: Optional[pulumi.Input['ClusterClusterTemplateAnswersArgs']] = None,
                 cluster_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_template_questions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterTemplateQuestionArgs']]]] = None,
                 cluster_template_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_pod_security_admission_configuration_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_agent_image: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_auth_image: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_root_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 driver: Optional[pulumi.Input[_builtins.str]] = None,
                 eks_config_v2: Optional[pulumi.Input['ClusterEksConfigV2Args']] = None,
                 enable_cluster_istio: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_network_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFleetAgentDeploymentCustomizationArgs']]]] = None,
                 fleet_workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gke_config_v2: Optional[pulumi.Input['ClusterGkeConfigV2Args']] = None,
                 imported_config: Optional[pulumi.Input['ClusterImportedConfigArgs']] = None,
                 istio_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 k3s_config: Optional[pulumi.Input['ClusterK3sConfigArgs']] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oke_config: Optional[pulumi.Input['ClusterOkeConfigArgs']] = None,
                 rke2_config: Optional[pulumi.Input['ClusterRke2ConfigArgs']] = None,
                 rke_config: Optional[pulumi.Input['ClusterRkeConfigArgs']] = None,
                 system_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 windows_prefered_cluster: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterAgentEnvVarArgs']]] agent_env_vars: Optional Agent Env Vars for Rancher agent. For Rancher v2.5.6 and above (list)
        :param pulumi.Input['ClusterAksConfigV2Args'] aks_config_v2: The Azure AKS v2 configuration for creating/import `aks` Clusters. Conflicts with `eks_config_v2`, `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the Cluster (map)
        :param pulumi.Input[_builtins.str] ca_cert: (Computed/Sensitive) K8s cluster ca cert (string)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClusterAgentDeploymentCustomizationArgs']]] cluster_agent_deployment_customizations: Optional customization for cluster agent. For Rancher v2.7.5 and above (list)
        :param pulumi.Input['ClusterClusterAuthEndpointArgs'] cluster_auth_endpoint: Enabling the [local cluster authorized endpoint](https://rancher.com/docs/rancher/v2.x/en/cluster-provisioning/rke-clusters/options/#local-cluster-auth-endpoint) allows direct communication with the cluster, bypassing the Rancher API proxy. (list maxitems:1)
        :param pulumi.Input['ClusterClusterRegistrationTokenArgs'] cluster_registration_token: (Computed) Cluster Registration Token generated for the cluster (list maxitems:1)
        :param pulumi.Input['ClusterClusterTemplateAnswersArgs'] cluster_template_answers: Cluster template answers. For Rancher v2.3.x and above (list maxitems:1)
        :param pulumi.Input[_builtins.str] cluster_template_id: Cluster template ID. For Rancher v2.3.x and above (string)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClusterTemplateQuestionArgs']]] cluster_template_questions: Cluster template questions. For Rancher v2.3.x and above (list)
        :param pulumi.Input[_builtins.str] cluster_template_revision_id: Cluster template revision ID. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] default_pod_security_admission_configuration_template_name: The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above (string)
        :param pulumi.Input[_builtins.str] default_project_id: (Computed) Default project ID for the cluster (string)
        :param pulumi.Input[_builtins.str] description: The description for Cluster (string)
        :param pulumi.Input[_builtins.str] desired_agent_image: Desired agent image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] desired_auth_image: Desired auth image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] docker_root_dir: Desired auth image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] driver: (Computed) The driver used for the Cluster. `imported`, `azurekubernetesservice`, `amazonelasticcontainerservice`, `googlekubernetesengine` and `rancherKubernetesEngine` are supported (string)
        :param pulumi.Input['ClusterEksConfigV2Args'] eks_config_v2: The Amazon EKS V2 configuration to create or import `eks` Clusters. Conflicts with `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.x and above (list maxitems:1)
        :param pulumi.Input[_builtins.bool] enable_cluster_istio: Deploy istio on `system` project and `istio-system` namespace, using rancher2_app resource instead. See above example.
        :param pulumi.Input[_builtins.bool] enable_network_policy: Enable project network isolation (bool)
        :param pulumi.Input[Sequence[pulumi.Input['ClusterFleetAgentDeploymentCustomizationArgs']]] fleet_agent_deployment_customizations: Optional customization for fleet agent. For Rancher v2.7.5 and above (list)
        :param pulumi.Input[_builtins.str] fleet_workspace_name: Fleet workspace name (string)
        :param pulumi.Input['ClusterGkeConfigV2Args'] gke_config_v2: The Google GKE V2 configuration for `gke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.8 and above (list maxitems:1)
        :param pulumi.Input['ClusterImportedConfigArgs'] imported_config: The imported configuration for generic imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `rke_config`, `rke2_config` and `k3s_config` (list maxitems:1)
        :param pulumi.Input[_builtins.bool] istio_enabled: (Computed) Is istio enabled at cluster? For Rancher v2.3.x and above (bool)
        :param pulumi.Input['ClusterK3sConfigArgs'] k3s_config: The K3S configuration for `k3s` imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[_builtins.str] kube_config: (Computed/Sensitive) Kube Config generated for the cluster. Note: For Rancher 2.6.0 and above, when the cluster has `cluster_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected` (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the Cluster (map)
        :param pulumi.Input[_builtins.str] name: The name of the Cluster (string)
        :param pulumi.Input['ClusterOkeConfigArgs'] oke_config: The Oracle OKE configuration for `oke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `k3s_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input['ClusterRke2ConfigArgs'] rke2_config: The RKE2 configuration for `rke2` Clusters. Conflicts with `aks_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input['ClusterRkeConfigArgs'] rke_config: The RKE configuration for `rke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `k3s_config` (list maxitems:1)
        :param pulumi.Input[_builtins.str] system_project_id: (Computed) System project ID for the cluster (string)
        :param pulumi.Input[_builtins.bool] windows_prefered_cluster: Windows preferred cluster. Default: `false` (bool)
        """
        if agent_env_vars is not None:
            pulumi.set(__self__, "agent_env_vars", agent_env_vars)
        if aks_config_v2 is not None:
            pulumi.set(__self__, "aks_config_v2", aks_config_v2)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if cluster_agent_deployment_customizations is not None:
            pulumi.set(__self__, "cluster_agent_deployment_customizations", cluster_agent_deployment_customizations)
        if cluster_auth_endpoint is not None:
            pulumi.set(__self__, "cluster_auth_endpoint", cluster_auth_endpoint)
        if cluster_registration_token is not None:
            pulumi.set(__self__, "cluster_registration_token", cluster_registration_token)
        if cluster_template_answers is not None:
            pulumi.set(__self__, "cluster_template_answers", cluster_template_answers)
        if cluster_template_id is not None:
            pulumi.set(__self__, "cluster_template_id", cluster_template_id)
        if cluster_template_questions is not None:
            pulumi.set(__self__, "cluster_template_questions", cluster_template_questions)
        if cluster_template_revision_id is not None:
            pulumi.set(__self__, "cluster_template_revision_id", cluster_template_revision_id)
        if default_pod_security_admission_configuration_template_name is not None:
            pulumi.set(__self__, "default_pod_security_admission_configuration_template_name", default_pod_security_admission_configuration_template_name)
        if default_project_id is not None:
            pulumi.set(__self__, "default_project_id", default_project_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_agent_image is not None:
            pulumi.set(__self__, "desired_agent_image", desired_agent_image)
        if desired_auth_image is not None:
            pulumi.set(__self__, "desired_auth_image", desired_auth_image)
        if docker_root_dir is not None:
            pulumi.set(__self__, "docker_root_dir", docker_root_dir)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if eks_config_v2 is not None:
            pulumi.set(__self__, "eks_config_v2", eks_config_v2)
        if enable_cluster_istio is not None:
            warnings.warn("""Deploy istio using rancher2_app resource instead""", DeprecationWarning)
            pulumi.log.warn("""enable_cluster_istio is deprecated: Deploy istio using rancher2_app resource instead""")
        if enable_cluster_istio is not None:
            pulumi.set(__self__, "enable_cluster_istio", enable_cluster_istio)
        if enable_network_policy is not None:
            pulumi.set(__self__, "enable_network_policy", enable_network_policy)
        if fleet_agent_deployment_customizations is not None:
            pulumi.set(__self__, "fleet_agent_deployment_customizations", fleet_agent_deployment_customizations)
        if fleet_workspace_name is not None:
            pulumi.set(__self__, "fleet_workspace_name", fleet_workspace_name)
        if gke_config_v2 is not None:
            pulumi.set(__self__, "gke_config_v2", gke_config_v2)
        if imported_config is not None:
            pulumi.set(__self__, "imported_config", imported_config)
        if istio_enabled is not None:
            pulumi.set(__self__, "istio_enabled", istio_enabled)
        if k3s_config is not None:
            pulumi.set(__self__, "k3s_config", k3s_config)
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oke_config is not None:
            pulumi.set(__self__, "oke_config", oke_config)
        if rke2_config is not None:
            pulumi.set(__self__, "rke2_config", rke2_config)
        if rke_config is not None:
            pulumi.set(__self__, "rke_config", rke_config)
        if system_project_id is not None:
            pulumi.set(__self__, "system_project_id", system_project_id)
        if windows_prefered_cluster is not None:
            pulumi.set(__self__, "windows_prefered_cluster", windows_prefered_cluster)

    @_builtins.property
    @pulumi.getter(name="agentEnvVars")
    def agent_env_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAgentEnvVarArgs']]]]:
        """
        Optional Agent Env Vars for Rancher agent. For Rancher v2.5.6 and above (list)
        """
        return pulumi.get(self, "agent_env_vars")

    @agent_env_vars.setter
    def agent_env_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterAgentEnvVarArgs']]]]):
        pulumi.set(self, "agent_env_vars", value)

    @_builtins.property
    @pulumi.getter(name="aksConfigV2")
    def aks_config_v2(self) -> Optional[pulumi.Input['ClusterAksConfigV2Args']]:
        """
        The Azure AKS v2 configuration for creating/import `aks` Clusters. Conflicts with `eks_config_v2`, `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "aks_config_v2")

    @aks_config_v2.setter
    def aks_config_v2(self, value: Optional[pulumi.Input['ClusterAksConfigV2Args']]):
        pulumi.set(self, "aks_config_v2", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Annotations for the Cluster (map)
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed/Sensitive) K8s cluster ca cert (string)
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clusterAgentDeploymentCustomizations")
    def cluster_agent_deployment_customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterAgentDeploymentCustomizationArgs']]]]:
        """
        Optional customization for cluster agent. For Rancher v2.7.5 and above (list)
        """
        return pulumi.get(self, "cluster_agent_deployment_customizations")

    @cluster_agent_deployment_customizations.setter
    def cluster_agent_deployment_customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterAgentDeploymentCustomizationArgs']]]]):
        pulumi.set(self, "cluster_agent_deployment_customizations", value)

    @_builtins.property
    @pulumi.getter(name="clusterAuthEndpoint")
    def cluster_auth_endpoint(self) -> Optional[pulumi.Input['ClusterClusterAuthEndpointArgs']]:
        """
        Enabling the [local cluster authorized endpoint](https://rancher.com/docs/rancher/v2.x/en/cluster-provisioning/rke-clusters/options/#local-cluster-auth-endpoint) allows direct communication with the cluster, bypassing the Rancher API proxy. (list maxitems:1)
        """
        return pulumi.get(self, "cluster_auth_endpoint")

    @cluster_auth_endpoint.setter
    def cluster_auth_endpoint(self, value: Optional[pulumi.Input['ClusterClusterAuthEndpointArgs']]):
        pulumi.set(self, "cluster_auth_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="clusterRegistrationToken")
    def cluster_registration_token(self) -> Optional[pulumi.Input['ClusterClusterRegistrationTokenArgs']]:
        """
        (Computed) Cluster Registration Token generated for the cluster (list maxitems:1)
        """
        return pulumi.get(self, "cluster_registration_token")

    @cluster_registration_token.setter
    def cluster_registration_token(self, value: Optional[pulumi.Input['ClusterClusterRegistrationTokenArgs']]):
        pulumi.set(self, "cluster_registration_token", value)

    @_builtins.property
    @pulumi.getter(name="clusterTemplateAnswers")
    def cluster_template_answers(self) -> Optional[pulumi.Input['ClusterClusterTemplateAnswersArgs']]:
        """
        Cluster template answers. For Rancher v2.3.x and above (list maxitems:1)
        """
        return pulumi.get(self, "cluster_template_answers")

    @cluster_template_answers.setter
    def cluster_template_answers(self, value: Optional[pulumi.Input['ClusterClusterTemplateAnswersArgs']]):
        pulumi.set(self, "cluster_template_answers", value)

    @_builtins.property
    @pulumi.getter(name="clusterTemplateId")
    def cluster_template_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster template ID. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "cluster_template_id")

    @cluster_template_id.setter
    def cluster_template_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_template_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterTemplateQuestions")
    def cluster_template_questions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterTemplateQuestionArgs']]]]:
        """
        Cluster template questions. For Rancher v2.3.x and above (list)
        """
        return pulumi.get(self, "cluster_template_questions")

    @cluster_template_questions.setter
    def cluster_template_questions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClusterTemplateQuestionArgs']]]]):
        pulumi.set(self, "cluster_template_questions", value)

    @_builtins.property
    @pulumi.getter(name="clusterTemplateRevisionId")
    def cluster_template_revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster template revision ID. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "cluster_template_revision_id")

    @cluster_template_revision_id.setter
    def cluster_template_revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_template_revision_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultPodSecurityAdmissionConfigurationTemplateName")
    def default_pod_security_admission_configuration_template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above (string)
        """
        return pulumi.get(self, "default_pod_security_admission_configuration_template_name")

    @default_pod_security_admission_configuration_template_name.setter
    def default_pod_security_admission_configuration_template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_pod_security_admission_configuration_template_name", value)

    @_builtins.property
    @pulumi.getter(name="defaultProjectId")
    def default_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) Default project ID for the cluster (string)
        """
        return pulumi.get(self, "default_project_id")

    @default_project_id.setter
    def default_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_project_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for Cluster (string)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="desiredAgentImage")
    def desired_agent_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired agent image. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "desired_agent_image")

    @desired_agent_image.setter
    def desired_agent_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_agent_image", value)

    @_builtins.property
    @pulumi.getter(name="desiredAuthImage")
    def desired_auth_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired auth image. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "desired_auth_image")

    @desired_auth_image.setter
    def desired_auth_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_auth_image", value)

    @_builtins.property
    @pulumi.getter(name="dockerRootDir")
    def docker_root_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired auth image. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "docker_root_dir")

    @docker_root_dir.setter
    def docker_root_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "docker_root_dir", value)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) The driver used for the Cluster. `imported`, `azurekubernetesservice`, `amazonelasticcontainerservice`, `googlekubernetesengine` and `rancherKubernetesEngine` are supported (string)
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "driver", value)

    @_builtins.property
    @pulumi.getter(name="eksConfigV2")
    def eks_config_v2(self) -> Optional[pulumi.Input['ClusterEksConfigV2Args']]:
        """
        The Amazon EKS V2 configuration to create or import `eks` Clusters. Conflicts with `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.x and above (list maxitems:1)
        """
        return pulumi.get(self, "eks_config_v2")

    @eks_config_v2.setter
    def eks_config_v2(self, value: Optional[pulumi.Input['ClusterEksConfigV2Args']]):
        pulumi.set(self, "eks_config_v2", value)

    @_builtins.property
    @pulumi.getter(name="enableClusterIstio")
    @_utilities.deprecated("""Deploy istio using rancher2_app resource instead""")
    def enable_cluster_istio(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Deploy istio on `system` project and `istio-system` namespace, using rancher2_app resource instead. See above example.
        """
        return pulumi.get(self, "enable_cluster_istio")

    @enable_cluster_istio.setter
    def enable_cluster_istio(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_cluster_istio", value)

    @_builtins.property
    @pulumi.getter(name="enableNetworkPolicy")
    def enable_network_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable project network isolation (bool)
        """
        return pulumi.get(self, "enable_network_policy")

    @enable_network_policy.setter
    def enable_network_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_network_policy", value)

    @_builtins.property
    @pulumi.getter(name="fleetAgentDeploymentCustomizations")
    def fleet_agent_deployment_customizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFleetAgentDeploymentCustomizationArgs']]]]:
        """
        Optional customization for fleet agent. For Rancher v2.7.5 and above (list)
        """
        return pulumi.get(self, "fleet_agent_deployment_customizations")

    @fleet_agent_deployment_customizations.setter
    def fleet_agent_deployment_customizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFleetAgentDeploymentCustomizationArgs']]]]):
        pulumi.set(self, "fleet_agent_deployment_customizations", value)

    @_builtins.property
    @pulumi.getter(name="fleetWorkspaceName")
    def fleet_workspace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fleet workspace name (string)
        """
        return pulumi.get(self, "fleet_workspace_name")

    @fleet_workspace_name.setter
    def fleet_workspace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_workspace_name", value)

    @_builtins.property
    @pulumi.getter(name="gkeConfigV2")
    def gke_config_v2(self) -> Optional[pulumi.Input['ClusterGkeConfigV2Args']]:
        """
        The Google GKE V2 configuration for `gke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.8 and above (list maxitems:1)
        """
        return pulumi.get(self, "gke_config_v2")

    @gke_config_v2.setter
    def gke_config_v2(self, value: Optional[pulumi.Input['ClusterGkeConfigV2Args']]):
        pulumi.set(self, "gke_config_v2", value)

    @_builtins.property
    @pulumi.getter(name="importedConfig")
    def imported_config(self) -> Optional[pulumi.Input['ClusterImportedConfigArgs']]:
        """
        The imported configuration for generic imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `rke_config`, `rke2_config` and `k3s_config` (list maxitems:1)
        """
        return pulumi.get(self, "imported_config")

    @imported_config.setter
    def imported_config(self, value: Optional[pulumi.Input['ClusterImportedConfigArgs']]):
        pulumi.set(self, "imported_config", value)

    @_builtins.property
    @pulumi.getter(name="istioEnabled")
    def istio_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Computed) Is istio enabled at cluster? For Rancher v2.3.x and above (bool)
        """
        return pulumi.get(self, "istio_enabled")

    @istio_enabled.setter
    def istio_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "istio_enabled", value)

    @_builtins.property
    @pulumi.getter(name="k3sConfig")
    def k3s_config(self) -> Optional[pulumi.Input['ClusterK3sConfigArgs']]:
        """
        The K3S configuration for `k3s` imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "k3s_config")

    @k3s_config.setter
    def k3s_config(self, value: Optional[pulumi.Input['ClusterK3sConfigArgs']]):
        pulumi.set(self, "k3s_config", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed/Sensitive) Kube Config generated for the cluster. Note: For Rancher 2.6.0 and above, when the cluster has `cluster_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected` (string)
        """
        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for the Cluster (map)
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cluster (string)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="okeConfig")
    def oke_config(self) -> Optional[pulumi.Input['ClusterOkeConfigArgs']]:
        """
        The Oracle OKE configuration for `oke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `k3s_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "oke_config")

    @oke_config.setter
    def oke_config(self, value: Optional[pulumi.Input['ClusterOkeConfigArgs']]):
        pulumi.set(self, "oke_config", value)

    @_builtins.property
    @pulumi.getter(name="rke2Config")
    def rke2_config(self) -> Optional[pulumi.Input['ClusterRke2ConfigArgs']]:
        """
        The RKE2 configuration for `rke2` Clusters. Conflicts with `aks_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "rke2_config")

    @rke2_config.setter
    def rke2_config(self, value: Optional[pulumi.Input['ClusterRke2ConfigArgs']]):
        pulumi.set(self, "rke2_config", value)

    @_builtins.property
    @pulumi.getter(name="rkeConfig")
    def rke_config(self) -> Optional[pulumi.Input['ClusterRkeConfigArgs']]:
        """
        The RKE configuration for `rke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `k3s_config` (list maxitems:1)
        """
        return pulumi.get(self, "rke_config")

    @rke_config.setter
    def rke_config(self, value: Optional[pulumi.Input['ClusterRkeConfigArgs']]):
        pulumi.set(self, "rke_config", value)

    @_builtins.property
    @pulumi.getter(name="systemProjectId")
    def system_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Computed) System project ID for the cluster (string)
        """
        return pulumi.get(self, "system_project_id")

    @system_project_id.setter
    def system_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_project_id", value)

    @_builtins.property
    @pulumi.getter(name="windowsPreferedCluster")
    def windows_prefered_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Windows preferred cluster. Default: `false` (bool)
        """
        return pulumi.get(self, "windows_prefered_cluster")

    @windows_prefered_cluster.setter
    def windows_prefered_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "windows_prefered_cluster", value)


@pulumi.type_token("rancher2:index/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAgentEnvVarArgs', 'ClusterAgentEnvVarArgsDict']]]]] = None,
                 aks_config_v2: Optional[pulumi.Input[Union['ClusterAksConfigV2Args', 'ClusterAksConfigV2ArgsDict']]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClusterAgentDeploymentCustomizationArgs', 'ClusterClusterAgentDeploymentCustomizationArgsDict']]]]] = None,
                 cluster_auth_endpoint: Optional[pulumi.Input[Union['ClusterClusterAuthEndpointArgs', 'ClusterClusterAuthEndpointArgsDict']]] = None,
                 cluster_template_answers: Optional[pulumi.Input[Union['ClusterClusterTemplateAnswersArgs', 'ClusterClusterTemplateAnswersArgsDict']]] = None,
                 cluster_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_template_questions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClusterTemplateQuestionArgs', 'ClusterClusterTemplateQuestionArgsDict']]]]] = None,
                 cluster_template_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_pod_security_admission_configuration_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_agent_image: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_auth_image: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_root_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 driver: Optional[pulumi.Input[_builtins.str]] = None,
                 eks_config_v2: Optional[pulumi.Input[Union['ClusterEksConfigV2Args', 'ClusterEksConfigV2ArgsDict']]] = None,
                 enable_network_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterFleetAgentDeploymentCustomizationArgs', 'ClusterFleetAgentDeploymentCustomizationArgsDict']]]]] = None,
                 fleet_workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gke_config_v2: Optional[pulumi.Input[Union['ClusterGkeConfigV2Args', 'ClusterGkeConfigV2ArgsDict']]] = None,
                 imported_config: Optional[pulumi.Input[Union['ClusterImportedConfigArgs', 'ClusterImportedConfigArgsDict']]] = None,
                 k3s_config: Optional[pulumi.Input[Union['ClusterK3sConfigArgs', 'ClusterK3sConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oke_config: Optional[pulumi.Input[Union['ClusterOkeConfigArgs', 'ClusterOkeConfigArgsDict']]] = None,
                 rke2_config: Optional[pulumi.Input[Union['ClusterRke2ConfigArgs', 'ClusterRke2ConfigArgsDict']]] = None,
                 rke_config: Optional[pulumi.Input[Union['ClusterRkeConfigArgs', 'ClusterRkeConfigArgsDict']]] = None,
                 windows_prefered_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides a Rancher v2 Cluster resource. This can be used to create Clusters for Rancher v2 environments and retrieve their information.

        ## Example Usage

        **Note optional/computed arguments** If any `optional/computed` argument of this resource is defined by the user, removing it from tf file will NOT reset its value. To reset it, let its definition at tf file as empty/false object. Ex: `cloud_provider {}`, `name = ""`

        ### Creating Rancher v2 imported cluster

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 imported Cluster
        foo_imported = rancher2.Cluster("foo-imported",
            name="foo-imported",
            description="Foo rancher2 imported cluster")
        ```

        ### Creating Rancher v2 imported cluster with custom configuration. For Rancher v2.11.x and above.

        This configuration can be used to indicate that system images (such as the rancher-agent) should be pulled from an unauthenticated private registry. This can be used for all imported cluster types, including imported hosted clusters (AKS, EKS, GKE).

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 imported Cluster with custom configuration 
        foo_imported = rancher2.Cluster("foo-imported",
            name="foo-imported",
            imported_config={
                "private_registry_url": "test.io",
            })
        ```

        ### Creating Rancher v2 RKE cluster enabling

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 RKE Cluster
        foo_custom = rancher2.Cluster("foo-custom",
            name="foo-custom",
            description="Foo rancher2 custom cluster",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            })
        ```

        ### Creating Rancher v2 RKE cluster enabling/customizing istio

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 RKE Cluster
        foo_custom = rancher2.Cluster("foo-custom",
            name="foo-custom",
            description="Foo rancher2 custom cluster",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            })
        # Create a new rancher2 Cluster Sync for foo-custom cluster
        foo_custom_cluster_sync = rancher2.ClusterSync("foo-custom", cluster_id=foo_custom.id)
        # Create a new rancher2 Namespace
        foo_istio = rancher2.Namespace("foo-istio",
            name="istio-system",
            project_id=foo_custom_cluster_sync.system_project_id,
            description="istio namespace")
        # Create a new rancher2 App deploying istio
        istio = rancher2.index.App("istio",
            catalog_name=system-library,
            name=cluster-istio,
            description=Terraform app acceptance test,
            project_id=foo_istio.project_id,
            template_name=rancher-istio,
            template_version=0.1.1,
            target_namespace=foo_istio.id,
            answers={
                enabled: False,
                enableCRDs: True,
                enabled: True,
                enabled: False,
                cpu: 2000m,
                memory: 1024Mi,
                cpu: 100m,
                memory: 128Mi,
                type: NodePort,
                clusterId: foo_custom_cluster_sync.cluster_id,
                enabled: false,
                enabled: false,
                enabled: true,
                enabled: true,
                enabled: true,
                cpu: 4800m,
                memory: 4096Mi,
                cpu: 1000m,
                memory: 1024Mi,
                cpu: 4800m,
                memory: 4096Mi,
                cpu: 1000m,
                memory: 1024Mi,
                enabled: False,
                enabled: False,
                enabled: True,
                cpu: 1000m,
                memory: 4096Mi,
                cpu: 500m,
                memory: 2048Mi,
                traceSampling: 1,
                enabled: True,
                enabled: True,
                enabled: True,
                cpu: 500m,
                memory: 1024Mi,
                cpu: 100m,
                memory: 100Mi,
            })
        ```

        ### Creating Rancher v2 RKE cluster assigning a node pool (overlapped planes)

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 RKE Cluster
        foo_custom = rancher2.Cluster("foo-custom",
            name="foo-custom",
            description="Foo rancher2 custom cluster",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            })
        # Create a new rancher2 Node Template
        foo = rancher2.NodeTemplate("foo",
            name="foo",
            description="foo test",
            amazonec2_config={
                "access_key": "<AWS_ACCESS_KEY>",
                "secret_key": "<AWS_SECRET_KEY>",
                "ami": "<AMI_ID>",
                "region": "<REGION>",
                "security_groups": ["<AWS_SECURITY_GROUP>"],
                "subnet_id": "<SUBNET_ID>",
                "vpc_id": "<VPC_ID>",
                "zone": "<ZONE>",
            })
        # Create a new rancher2 Node Pool
        foo_node_pool = rancher2.NodePool("foo",
            cluster_id=foo_custom.id,
            name="foo",
            hostname_prefix="foo-cluster-0",
            node_template_id=foo.id,
            quantity=3,
            control_plane=True,
            etcd=True,
            worker=True)
        ```

        ### Creating Rancher v2 RKE cluster from template. For Rancher v2.3.x and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 cluster template
        foo = rancher2.ClusterTemplate("foo",
            name="foo",
            members=[{
                "access_type": "owner",
                "user_principal_id": "local://user-XXXXX",
            }],
            template_revisions=[{
                "name": "V1",
                "cluster_config": {
                    "rke_config": {
                        "network": {
                            "plugin": "canal",
                        },
                        "services": {
                            "etcd": {
                                "creation": "6h",
                                "retention": "24h",
                            },
                        },
                    },
                },
                "default": True,
            }],
            description="Test cluster template v2")
        # Create a new rancher2 RKE Cluster from template
        foo_cluster = rancher2.Cluster("foo",
            name="foo",
            cluster_template_id=foo.id,
            cluster_template_revision_id=foo.template_revisions[0].id)
        ```

        ### Creating Rancher v2 RKE cluster with upgrade strategy. For Rancher v2.4.x and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.Cluster("foo",
            name="foo",
            description="Terraform custom cluster",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
                "services": {
                    "etcd": {
                        "creation": "6h",
                        "retention": "24h",
                    },
                    "kube_api": {
                        "audit_log": {
                            "enabled": True,
                            "configuration": {
                                "max_age": 5,
                                "max_backup": 5,
                                "max_size": 100,
                                "path": "-",
                                "format": "json",
                                "policy": \"\"\"apiVersion: audit.k8s.io/v1
        kind: Policy
        metadata:
          creationTimestamp: null
        omitStages:
        - RequestReceived
        rules:
        - level: RequestResponse
          resources:
          - resources:
            - pods
        \"\"\",
                            },
                        },
                    },
                },
                "upgrade_strategy": {
                    "drain": True,
                    "max_unavailable_worker": "20%",
                },
            })
        ```

        ### Creating Rancher v2 RKE cluster with cluster agent customization. For Rancher v2.7.5 and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.Cluster("foo",
            name="foo",
            description="Terraform cluster with agent customization",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            },
            cluster_agent_deployment_customizations=[{
                "append_tolerations": [{
                    "effect": "NoSchedule",
                    "key": "tolerate/control-plane",
                    "value": "true",
                }],
                "override_affinity": \"\"\"{
          "nodeAffinity": {
            "requiredDuringSchedulingIgnoredDuringExecution": {
              "nodeSelectorTerms": [{
                "matchExpressions": [{
                  "key": "not.this/nodepool",
                  "operator": "In",
                  "values": [
                    "true"
                  ]
                }]
              }]
            }
          }
        }
        \"\"\",
                "override_resource_requirements": [{
                    "cpu_limit": "800",
                    "cpu_request": "500",
                    "memory_limit": "800",
                    "memory_request": "500",
                }],
            }])
        ```

        ### Creating Rancher v2 RKE cluster with cluster agent scheduling customization. For Custom and Imported clusters provisioned by Rancher v2.11.0 and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.Cluster("foo",
            name="foo",
            description="Terraform cluster with agent customization",
            rke_config={},
            cluster_agent_deployment_customizations=[{
                "scheduling_customizations": [{
                    "priority_classes": [{
                        "preemption_policy": "PreemptLowerPriority",
                        "value": 1000000000,
                    }],
                    "pod_disruption_budgets": [{
                        "min_available": "1",
                    }],
                }],
            }])
        ```

        ### Creating Rancher v2 RKE cluster with Pod Security Admission Configuration Template (PSACT). For Rancher v2.7.2 and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Custom PSACT (if you wish to use your own)
        foo = rancher2.PodSecurityAdmissionConfigurationTemplate("foo",
            name="custom-psact",
            description="This is my custom Pod Security Admission Configuration Template",
            defaults={
                "audit": "restricted",
                "audit_version": "latest",
                "enforce": "restricted",
                "enforce_version": "latest",
                "warn": "restricted",
                "warn_version": "latest",
            },
            exemptions={
                "usernames": ["testuser"],
                "runtime_classes": ["testclass"],
                "namespaces": [
                    "ingress-nginx",
                    "kube-system",
                ],
            })
        foo_cluster = rancher2.Cluster("foo",
            name="foo",
            description="Terraform cluster with PSACT",
            default_pod_security_admission_configuration_template_name="<name>",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            })
        ```

        ### Importing EKS cluster to Rancher v2, using `eks_config_v2`. For Rancher v2.5.x and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.CloudCredential("foo",
            name="foo",
            description="foo test",
            amazonec2_credential_config={
                "access_key": "<aws-access-key>",
                "secret_key": "<aws-secret-key>",
            })
        foo_cluster = rancher2.Cluster("foo",
            name="foo",
            description="Terraform EKS cluster",
            eks_config_v2={
                "cloud_credential_id": foo.id,
                "name": "<cluster-name>",
                "region": "<eks-region>",
                "imported": True,
            })
        ```

        ### Creating EKS cluster from Rancher v2, using `eks_config_v2`. For Rancher v2.5.x and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.CloudCredential("foo",
            name="foo",
            description="foo test",
            amazonec2_credential_config={
                "access_key": "<aws-access-key>",
                "secret_key": "<aws-secret-key>",
            })
        foo_cluster = rancher2.Cluster("foo",
            name="foo",
            description="Terraform EKS cluster",
            eks_config_v2={
                "cloud_credential_id": foo.id,
                "region": "<EKS_REGION>",
                "kubernetes_version": "1.24",
                "logging_types": [
                    "audit",
                    "api",
                ],
                "node_groups": [
                    {
                        "name": "node_group1",
                        "instance_type": "t3.medium",
                        "desired_size": 3,
                        "max_size": 5,
                    },
                    {
                        "name": "node_group2",
                        "instance_type": "m5.xlarge",
                        "desired_size": 2,
                        "max_size": 3,
                        "node_role": "arn:aws:iam::role/test-NodeInstanceRole",
                    },
                ],
                "private_access": True,
                "public_access": False,
            })
        ```

        ### Creating EKS cluster from Rancher v2, using `eks_config_v2` and launch template. For Rancher v2.5.6 and above.

        Note: To use `launch_template` you must provide the ID (seen as `<EC2_LAUNCH_TEMPLATE_ID>`) to the template either as a static value. Or fetched via AWS data-source using one of: aws_ami, aws_ami_ids, or similar data-sources. You can also create a custom `launch_template` first and provide the ID to that.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.CloudCredential("foo",
            name="foo",
            description="foo test",
            amazonec2_credential_config={
                "access_key": "<aws-access-key>",
                "secret_key": "<aws-secret-key>",
            })
        foo_cluster = rancher2.Cluster("foo",
            name="foo",
            description="Terraform EKS cluster",
            eks_config_v2={
                "cloud_credential_id": foo.id,
                "region": "<EKS_REGION>",
                "kubernetes_version": "1.24",
                "logging_types": [
                    "audit",
                    "api",
                ],
                "node_groups": [{
                    "desired_size": 3,
                    "max_size": 5,
                    "name": "node_group1",
                    "launch_templates": [{
                        "id": "<ec2-launch-template-id>",
                        "version": 1,
                    }],
                }],
                "private_access": True,
                "public_access": True,
            })
        ```

        ### Creating AKS cluster from Rancher v2, using `aks_config_v2`. For Rancher v2.6.0 and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo_aks = rancher2.CloudCredential("foo-aks",
            name="foo-aks",
            azure_credential_config={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "subscription_id": "<subscription-id>",
            })
        foo = rancher2.Cluster("foo",
            name="foo",
            description="Terraform AKS cluster",
            aks_config_v2={
                "cloud_credential_id": foo_aks.id,
                "resource_group": "<resource-group>",
                "resource_location": "<resource-location>",
                "dns_prefix": "<dns-prefix>",
                "kubernetes_version": "1.24.6",
                "network_plugin": "<network-plugin>",
                "virtual_network": "<virtual-network>",
                "virtual_network_resource_group": "<virtual-network-resource-group>",
                "subnet": "<subnet>",
                "node_resource_group": "<node-resource-group>",
                "outbound_type": "loadBalancer",
                "node_pools": [
                    {
                        "availability_zones": [
                            "1",
                            "2",
                            "3",
                        ],
                        "name": "<nodepool-name-1>",
                        "mode": "System",
                        "count": 1,
                        "orchestrator_version": "1.21.2",
                        "os_disk_size_gb": 128,
                        "vm_size": "Standard_DS2_v2",
                    },
                    {
                        "availability_zones": [
                            "1",
                            "2",
                            "3",
                        ],
                        "name": "<nodepool-name-2>",
                        "count": 1,
                        "mode": "User",
                        "orchestrator_version": "1.21.2",
                        "os_disk_size_gb": 128,
                        "vm_size": "Standard_DS2_v2",
                        "max_surge": "25%",
                        "labels": {
                            "test1": "data1",
                            "test2": "data2",
                        },
                        "taints": ["none:PreferNoSchedule"],
                    },
                ],
            })
        ```

        ## Import

        Clusters can be imported using the Rancher Cluster ID

        ```sh
        $ pulumi import rancher2:index/cluster:Cluster foo &lt;CLUSTER_ID&gt;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAgentEnvVarArgs', 'ClusterAgentEnvVarArgsDict']]]] agent_env_vars: Optional Agent Env Vars for Rancher agent. For Rancher v2.5.6 and above (list)
        :param pulumi.Input[Union['ClusterAksConfigV2Args', 'ClusterAksConfigV2ArgsDict']] aks_config_v2: The Azure AKS v2 configuration for creating/import `aks` Clusters. Conflicts with `eks_config_v2`, `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the Cluster (map)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterClusterAgentDeploymentCustomizationArgs', 'ClusterClusterAgentDeploymentCustomizationArgsDict']]]] cluster_agent_deployment_customizations: Optional customization for cluster agent. For Rancher v2.7.5 and above (list)
        :param pulumi.Input[Union['ClusterClusterAuthEndpointArgs', 'ClusterClusterAuthEndpointArgsDict']] cluster_auth_endpoint: Enabling the [local cluster authorized endpoint](https://rancher.com/docs/rancher/v2.x/en/cluster-provisioning/rke-clusters/options/#local-cluster-auth-endpoint) allows direct communication with the cluster, bypassing the Rancher API proxy. (list maxitems:1)
        :param pulumi.Input[Union['ClusterClusterTemplateAnswersArgs', 'ClusterClusterTemplateAnswersArgsDict']] cluster_template_answers: Cluster template answers. For Rancher v2.3.x and above (list maxitems:1)
        :param pulumi.Input[_builtins.str] cluster_template_id: Cluster template ID. For Rancher v2.3.x and above (string)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterClusterTemplateQuestionArgs', 'ClusterClusterTemplateQuestionArgsDict']]]] cluster_template_questions: Cluster template questions. For Rancher v2.3.x and above (list)
        :param pulumi.Input[_builtins.str] cluster_template_revision_id: Cluster template revision ID. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] default_pod_security_admission_configuration_template_name: The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above (string)
        :param pulumi.Input[_builtins.str] description: The description for Cluster (string)
        :param pulumi.Input[_builtins.str] desired_agent_image: Desired agent image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] desired_auth_image: Desired auth image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] docker_root_dir: Desired auth image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] driver: (Computed) The driver used for the Cluster. `imported`, `azurekubernetesservice`, `amazonelasticcontainerservice`, `googlekubernetesengine` and `rancherKubernetesEngine` are supported (string)
        :param pulumi.Input[Union['ClusterEksConfigV2Args', 'ClusterEksConfigV2ArgsDict']] eks_config_v2: The Amazon EKS V2 configuration to create or import `eks` Clusters. Conflicts with `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.x and above (list maxitems:1)
        :param pulumi.Input[_builtins.bool] enable_network_policy: Enable project network isolation (bool)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterFleetAgentDeploymentCustomizationArgs', 'ClusterFleetAgentDeploymentCustomizationArgsDict']]]] fleet_agent_deployment_customizations: Optional customization for fleet agent. For Rancher v2.7.5 and above (list)
        :param pulumi.Input[_builtins.str] fleet_workspace_name: Fleet workspace name (string)
        :param pulumi.Input[Union['ClusterGkeConfigV2Args', 'ClusterGkeConfigV2ArgsDict']] gke_config_v2: The Google GKE V2 configuration for `gke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.8 and above (list maxitems:1)
        :param pulumi.Input[Union['ClusterImportedConfigArgs', 'ClusterImportedConfigArgsDict']] imported_config: The imported configuration for generic imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `rke_config`, `rke2_config` and `k3s_config` (list maxitems:1)
        :param pulumi.Input[Union['ClusterK3sConfigArgs', 'ClusterK3sConfigArgsDict']] k3s_config: The K3S configuration for `k3s` imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the Cluster (map)
        :param pulumi.Input[_builtins.str] name: The name of the Cluster (string)
        :param pulumi.Input[Union['ClusterOkeConfigArgs', 'ClusterOkeConfigArgsDict']] oke_config: The Oracle OKE configuration for `oke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `k3s_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[Union['ClusterRke2ConfigArgs', 'ClusterRke2ConfigArgsDict']] rke2_config: The RKE2 configuration for `rke2` Clusters. Conflicts with `aks_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[Union['ClusterRkeConfigArgs', 'ClusterRkeConfigArgsDict']] rke_config: The RKE configuration for `rke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `k3s_config` (list maxitems:1)
        :param pulumi.Input[_builtins.bool] windows_prefered_cluster: Windows preferred cluster. Default: `false` (bool)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Rancher v2 Cluster resource. This can be used to create Clusters for Rancher v2 environments and retrieve their information.

        ## Example Usage

        **Note optional/computed arguments** If any `optional/computed` argument of this resource is defined by the user, removing it from tf file will NOT reset its value. To reset it, let its definition at tf file as empty/false object. Ex: `cloud_provider {}`, `name = ""`

        ### Creating Rancher v2 imported cluster

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 imported Cluster
        foo_imported = rancher2.Cluster("foo-imported",
            name="foo-imported",
            description="Foo rancher2 imported cluster")
        ```

        ### Creating Rancher v2 imported cluster with custom configuration. For Rancher v2.11.x and above.

        This configuration can be used to indicate that system images (such as the rancher-agent) should be pulled from an unauthenticated private registry. This can be used for all imported cluster types, including imported hosted clusters (AKS, EKS, GKE).

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 imported Cluster with custom configuration 
        foo_imported = rancher2.Cluster("foo-imported",
            name="foo-imported",
            imported_config={
                "private_registry_url": "test.io",
            })
        ```

        ### Creating Rancher v2 RKE cluster enabling

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 RKE Cluster
        foo_custom = rancher2.Cluster("foo-custom",
            name="foo-custom",
            description="Foo rancher2 custom cluster",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            })
        ```

        ### Creating Rancher v2 RKE cluster enabling/customizing istio

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 RKE Cluster
        foo_custom = rancher2.Cluster("foo-custom",
            name="foo-custom",
            description="Foo rancher2 custom cluster",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            })
        # Create a new rancher2 Cluster Sync for foo-custom cluster
        foo_custom_cluster_sync = rancher2.ClusterSync("foo-custom", cluster_id=foo_custom.id)
        # Create a new rancher2 Namespace
        foo_istio = rancher2.Namespace("foo-istio",
            name="istio-system",
            project_id=foo_custom_cluster_sync.system_project_id,
            description="istio namespace")
        # Create a new rancher2 App deploying istio
        istio = rancher2.index.App("istio",
            catalog_name=system-library,
            name=cluster-istio,
            description=Terraform app acceptance test,
            project_id=foo_istio.project_id,
            template_name=rancher-istio,
            template_version=0.1.1,
            target_namespace=foo_istio.id,
            answers={
                enabled: False,
                enableCRDs: True,
                enabled: True,
                enabled: False,
                cpu: 2000m,
                memory: 1024Mi,
                cpu: 100m,
                memory: 128Mi,
                type: NodePort,
                clusterId: foo_custom_cluster_sync.cluster_id,
                enabled: false,
                enabled: false,
                enabled: true,
                enabled: true,
                enabled: true,
                cpu: 4800m,
                memory: 4096Mi,
                cpu: 1000m,
                memory: 1024Mi,
                cpu: 4800m,
                memory: 4096Mi,
                cpu: 1000m,
                memory: 1024Mi,
                enabled: False,
                enabled: False,
                enabled: True,
                cpu: 1000m,
                memory: 4096Mi,
                cpu: 500m,
                memory: 2048Mi,
                traceSampling: 1,
                enabled: True,
                enabled: True,
                enabled: True,
                cpu: 500m,
                memory: 1024Mi,
                cpu: 100m,
                memory: 100Mi,
            })
        ```

        ### Creating Rancher v2 RKE cluster assigning a node pool (overlapped planes)

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 RKE Cluster
        foo_custom = rancher2.Cluster("foo-custom",
            name="foo-custom",
            description="Foo rancher2 custom cluster",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            })
        # Create a new rancher2 Node Template
        foo = rancher2.NodeTemplate("foo",
            name="foo",
            description="foo test",
            amazonec2_config={
                "access_key": "<AWS_ACCESS_KEY>",
                "secret_key": "<AWS_SECRET_KEY>",
                "ami": "<AMI_ID>",
                "region": "<REGION>",
                "security_groups": ["<AWS_SECURITY_GROUP>"],
                "subnet_id": "<SUBNET_ID>",
                "vpc_id": "<VPC_ID>",
                "zone": "<ZONE>",
            })
        # Create a new rancher2 Node Pool
        foo_node_pool = rancher2.NodePool("foo",
            cluster_id=foo_custom.id,
            name="foo",
            hostname_prefix="foo-cluster-0",
            node_template_id=foo.id,
            quantity=3,
            control_plane=True,
            etcd=True,
            worker=True)
        ```

        ### Creating Rancher v2 RKE cluster from template. For Rancher v2.3.x and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Create a new rancher2 cluster template
        foo = rancher2.ClusterTemplate("foo",
            name="foo",
            members=[{
                "access_type": "owner",
                "user_principal_id": "local://user-XXXXX",
            }],
            template_revisions=[{
                "name": "V1",
                "cluster_config": {
                    "rke_config": {
                        "network": {
                            "plugin": "canal",
                        },
                        "services": {
                            "etcd": {
                                "creation": "6h",
                                "retention": "24h",
                            },
                        },
                    },
                },
                "default": True,
            }],
            description="Test cluster template v2")
        # Create a new rancher2 RKE Cluster from template
        foo_cluster = rancher2.Cluster("foo",
            name="foo",
            cluster_template_id=foo.id,
            cluster_template_revision_id=foo.template_revisions[0].id)
        ```

        ### Creating Rancher v2 RKE cluster with upgrade strategy. For Rancher v2.4.x and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.Cluster("foo",
            name="foo",
            description="Terraform custom cluster",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
                "services": {
                    "etcd": {
                        "creation": "6h",
                        "retention": "24h",
                    },
                    "kube_api": {
                        "audit_log": {
                            "enabled": True,
                            "configuration": {
                                "max_age": 5,
                                "max_backup": 5,
                                "max_size": 100,
                                "path": "-",
                                "format": "json",
                                "policy": \"\"\"apiVersion: audit.k8s.io/v1
        kind: Policy
        metadata:
          creationTimestamp: null
        omitStages:
        - RequestReceived
        rules:
        - level: RequestResponse
          resources:
          - resources:
            - pods
        \"\"\",
                            },
                        },
                    },
                },
                "upgrade_strategy": {
                    "drain": True,
                    "max_unavailable_worker": "20%",
                },
            })
        ```

        ### Creating Rancher v2 RKE cluster with cluster agent customization. For Rancher v2.7.5 and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.Cluster("foo",
            name="foo",
            description="Terraform cluster with agent customization",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            },
            cluster_agent_deployment_customizations=[{
                "append_tolerations": [{
                    "effect": "NoSchedule",
                    "key": "tolerate/control-plane",
                    "value": "true",
                }],
                "override_affinity": \"\"\"{
          "nodeAffinity": {
            "requiredDuringSchedulingIgnoredDuringExecution": {
              "nodeSelectorTerms": [{
                "matchExpressions": [{
                  "key": "not.this/nodepool",
                  "operator": "In",
                  "values": [
                    "true"
                  ]
                }]
              }]
            }
          }
        }
        \"\"\",
                "override_resource_requirements": [{
                    "cpu_limit": "800",
                    "cpu_request": "500",
                    "memory_limit": "800",
                    "memory_request": "500",
                }],
            }])
        ```

        ### Creating Rancher v2 RKE cluster with cluster agent scheduling customization. For Custom and Imported clusters provisioned by Rancher v2.11.0 and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.Cluster("foo",
            name="foo",
            description="Terraform cluster with agent customization",
            rke_config={},
            cluster_agent_deployment_customizations=[{
                "scheduling_customizations": [{
                    "priority_classes": [{
                        "preemption_policy": "PreemptLowerPriority",
                        "value": 1000000000,
                    }],
                    "pod_disruption_budgets": [{
                        "min_available": "1",
                    }],
                }],
            }])
        ```

        ### Creating Rancher v2 RKE cluster with Pod Security Admission Configuration Template (PSACT). For Rancher v2.7.2 and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        # Custom PSACT (if you wish to use your own)
        foo = rancher2.PodSecurityAdmissionConfigurationTemplate("foo",
            name="custom-psact",
            description="This is my custom Pod Security Admission Configuration Template",
            defaults={
                "audit": "restricted",
                "audit_version": "latest",
                "enforce": "restricted",
                "enforce_version": "latest",
                "warn": "restricted",
                "warn_version": "latest",
            },
            exemptions={
                "usernames": ["testuser"],
                "runtime_classes": ["testclass"],
                "namespaces": [
                    "ingress-nginx",
                    "kube-system",
                ],
            })
        foo_cluster = rancher2.Cluster("foo",
            name="foo",
            description="Terraform cluster with PSACT",
            default_pod_security_admission_configuration_template_name="<name>",
            rke_config={
                "network": {
                    "plugin": "canal",
                },
            })
        ```

        ### Importing EKS cluster to Rancher v2, using `eks_config_v2`. For Rancher v2.5.x and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.CloudCredential("foo",
            name="foo",
            description="foo test",
            amazonec2_credential_config={
                "access_key": "<aws-access-key>",
                "secret_key": "<aws-secret-key>",
            })
        foo_cluster = rancher2.Cluster("foo",
            name="foo",
            description="Terraform EKS cluster",
            eks_config_v2={
                "cloud_credential_id": foo.id,
                "name": "<cluster-name>",
                "region": "<eks-region>",
                "imported": True,
            })
        ```

        ### Creating EKS cluster from Rancher v2, using `eks_config_v2`. For Rancher v2.5.x and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.CloudCredential("foo",
            name="foo",
            description="foo test",
            amazonec2_credential_config={
                "access_key": "<aws-access-key>",
                "secret_key": "<aws-secret-key>",
            })
        foo_cluster = rancher2.Cluster("foo",
            name="foo",
            description="Terraform EKS cluster",
            eks_config_v2={
                "cloud_credential_id": foo.id,
                "region": "<EKS_REGION>",
                "kubernetes_version": "1.24",
                "logging_types": [
                    "audit",
                    "api",
                ],
                "node_groups": [
                    {
                        "name": "node_group1",
                        "instance_type": "t3.medium",
                        "desired_size": 3,
                        "max_size": 5,
                    },
                    {
                        "name": "node_group2",
                        "instance_type": "m5.xlarge",
                        "desired_size": 2,
                        "max_size": 3,
                        "node_role": "arn:aws:iam::role/test-NodeInstanceRole",
                    },
                ],
                "private_access": True,
                "public_access": False,
            })
        ```

        ### Creating EKS cluster from Rancher v2, using `eks_config_v2` and launch template. For Rancher v2.5.6 and above.

        Note: To use `launch_template` you must provide the ID (seen as `<EC2_LAUNCH_TEMPLATE_ID>`) to the template either as a static value. Or fetched via AWS data-source using one of: aws_ami, aws_ami_ids, or similar data-sources. You can also create a custom `launch_template` first and provide the ID to that.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo = rancher2.CloudCredential("foo",
            name="foo",
            description="foo test",
            amazonec2_credential_config={
                "access_key": "<aws-access-key>",
                "secret_key": "<aws-secret-key>",
            })
        foo_cluster = rancher2.Cluster("foo",
            name="foo",
            description="Terraform EKS cluster",
            eks_config_v2={
                "cloud_credential_id": foo.id,
                "region": "<EKS_REGION>",
                "kubernetes_version": "1.24",
                "logging_types": [
                    "audit",
                    "api",
                ],
                "node_groups": [{
                    "desired_size": 3,
                    "max_size": 5,
                    "name": "node_group1",
                    "launch_templates": [{
                        "id": "<ec2-launch-template-id>",
                        "version": 1,
                    }],
                }],
                "private_access": True,
                "public_access": True,
            })
        ```

        ### Creating AKS cluster from Rancher v2, using `aks_config_v2`. For Rancher v2.6.0 and above.

        ```python
        import pulumi
        import pulumi_rancher2 as rancher2

        foo_aks = rancher2.CloudCredential("foo-aks",
            name="foo-aks",
            azure_credential_config={
                "client_id": "<client-id>",
                "client_secret": "<client-secret>",
                "subscription_id": "<subscription-id>",
            })
        foo = rancher2.Cluster("foo",
            name="foo",
            description="Terraform AKS cluster",
            aks_config_v2={
                "cloud_credential_id": foo_aks.id,
                "resource_group": "<resource-group>",
                "resource_location": "<resource-location>",
                "dns_prefix": "<dns-prefix>",
                "kubernetes_version": "1.24.6",
                "network_plugin": "<network-plugin>",
                "virtual_network": "<virtual-network>",
                "virtual_network_resource_group": "<virtual-network-resource-group>",
                "subnet": "<subnet>",
                "node_resource_group": "<node-resource-group>",
                "outbound_type": "loadBalancer",
                "node_pools": [
                    {
                        "availability_zones": [
                            "1",
                            "2",
                            "3",
                        ],
                        "name": "<nodepool-name-1>",
                        "mode": "System",
                        "count": 1,
                        "orchestrator_version": "1.21.2",
                        "os_disk_size_gb": 128,
                        "vm_size": "Standard_DS2_v2",
                    },
                    {
                        "availability_zones": [
                            "1",
                            "2",
                            "3",
                        ],
                        "name": "<nodepool-name-2>",
                        "count": 1,
                        "mode": "User",
                        "orchestrator_version": "1.21.2",
                        "os_disk_size_gb": 128,
                        "vm_size": "Standard_DS2_v2",
                        "max_surge": "25%",
                        "labels": {
                            "test1": "data1",
                            "test2": "data2",
                        },
                        "taints": ["none:PreferNoSchedule"],
                    },
                ],
            })
        ```

        ## Import

        Clusters can be imported using the Rancher Cluster ID

        ```sh
        $ pulumi import rancher2:index/cluster:Cluster foo &lt;CLUSTER_ID&gt;
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAgentEnvVarArgs', 'ClusterAgentEnvVarArgsDict']]]]] = None,
                 aks_config_v2: Optional[pulumi.Input[Union['ClusterAksConfigV2Args', 'ClusterAksConfigV2ArgsDict']]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 cluster_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClusterAgentDeploymentCustomizationArgs', 'ClusterClusterAgentDeploymentCustomizationArgsDict']]]]] = None,
                 cluster_auth_endpoint: Optional[pulumi.Input[Union['ClusterClusterAuthEndpointArgs', 'ClusterClusterAuthEndpointArgsDict']]] = None,
                 cluster_template_answers: Optional[pulumi.Input[Union['ClusterClusterTemplateAnswersArgs', 'ClusterClusterTemplateAnswersArgsDict']]] = None,
                 cluster_template_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_template_questions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClusterTemplateQuestionArgs', 'ClusterClusterTemplateQuestionArgsDict']]]]] = None,
                 cluster_template_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_pod_security_admission_configuration_template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_agent_image: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_auth_image: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_root_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 driver: Optional[pulumi.Input[_builtins.str]] = None,
                 eks_config_v2: Optional[pulumi.Input[Union['ClusterEksConfigV2Args', 'ClusterEksConfigV2ArgsDict']]] = None,
                 enable_network_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterFleetAgentDeploymentCustomizationArgs', 'ClusterFleetAgentDeploymentCustomizationArgsDict']]]]] = None,
                 fleet_workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gke_config_v2: Optional[pulumi.Input[Union['ClusterGkeConfigV2Args', 'ClusterGkeConfigV2ArgsDict']]] = None,
                 imported_config: Optional[pulumi.Input[Union['ClusterImportedConfigArgs', 'ClusterImportedConfigArgsDict']]] = None,
                 k3s_config: Optional[pulumi.Input[Union['ClusterK3sConfigArgs', 'ClusterK3sConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oke_config: Optional[pulumi.Input[Union['ClusterOkeConfigArgs', 'ClusterOkeConfigArgsDict']]] = None,
                 rke2_config: Optional[pulumi.Input[Union['ClusterRke2ConfigArgs', 'ClusterRke2ConfigArgsDict']]] = None,
                 rke_config: Optional[pulumi.Input[Union['ClusterRkeConfigArgs', 'ClusterRkeConfigArgsDict']]] = None,
                 windows_prefered_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["agent_env_vars"] = agent_env_vars
            __props__.__dict__["aks_config_v2"] = aks_config_v2
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["cluster_agent_deployment_customizations"] = cluster_agent_deployment_customizations
            __props__.__dict__["cluster_auth_endpoint"] = cluster_auth_endpoint
            __props__.__dict__["cluster_template_answers"] = cluster_template_answers
            __props__.__dict__["cluster_template_id"] = cluster_template_id
            __props__.__dict__["cluster_template_questions"] = cluster_template_questions
            __props__.__dict__["cluster_template_revision_id"] = cluster_template_revision_id
            __props__.__dict__["default_pod_security_admission_configuration_template_name"] = default_pod_security_admission_configuration_template_name
            __props__.__dict__["description"] = description
            __props__.__dict__["desired_agent_image"] = desired_agent_image
            __props__.__dict__["desired_auth_image"] = desired_auth_image
            __props__.__dict__["docker_root_dir"] = docker_root_dir
            __props__.__dict__["driver"] = driver
            __props__.__dict__["eks_config_v2"] = eks_config_v2
            __props__.__dict__["enable_network_policy"] = enable_network_policy
            __props__.__dict__["fleet_agent_deployment_customizations"] = fleet_agent_deployment_customizations
            __props__.__dict__["fleet_workspace_name"] = fleet_workspace_name
            __props__.__dict__["gke_config_v2"] = gke_config_v2
            __props__.__dict__["imported_config"] = imported_config
            __props__.__dict__["k3s_config"] = k3s_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["oke_config"] = oke_config
            __props__.__dict__["rke2_config"] = rke2_config
            __props__.__dict__["rke_config"] = rke_config
            __props__.__dict__["windows_prefered_cluster"] = windows_prefered_cluster
            __props__.__dict__["ca_cert"] = None
            __props__.__dict__["cluster_registration_token"] = None
            __props__.__dict__["default_project_id"] = None
            __props__.__dict__["enable_cluster_istio"] = None
            __props__.__dict__["istio_enabled"] = None
            __props__.__dict__["kube_config"] = None
            __props__.__dict__["system_project_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["caCert", "kubeConfig"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'rancher2:index/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_env_vars: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterAgentEnvVarArgs', 'ClusterAgentEnvVarArgsDict']]]]] = None,
            aks_config_v2: Optional[pulumi.Input[Union['ClusterAksConfigV2Args', 'ClusterAksConfigV2ArgsDict']]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClusterAgentDeploymentCustomizationArgs', 'ClusterClusterAgentDeploymentCustomizationArgsDict']]]]] = None,
            cluster_auth_endpoint: Optional[pulumi.Input[Union['ClusterClusterAuthEndpointArgs', 'ClusterClusterAuthEndpointArgsDict']]] = None,
            cluster_registration_token: Optional[pulumi.Input[Union['ClusterClusterRegistrationTokenArgs', 'ClusterClusterRegistrationTokenArgsDict']]] = None,
            cluster_template_answers: Optional[pulumi.Input[Union['ClusterClusterTemplateAnswersArgs', 'ClusterClusterTemplateAnswersArgsDict']]] = None,
            cluster_template_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_template_questions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClusterTemplateQuestionArgs', 'ClusterClusterTemplateQuestionArgsDict']]]]] = None,
            cluster_template_revision_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_pod_security_admission_configuration_template_name: Optional[pulumi.Input[_builtins.str]] = None,
            default_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            desired_agent_image: Optional[pulumi.Input[_builtins.str]] = None,
            desired_auth_image: Optional[pulumi.Input[_builtins.str]] = None,
            docker_root_dir: Optional[pulumi.Input[_builtins.str]] = None,
            driver: Optional[pulumi.Input[_builtins.str]] = None,
            eks_config_v2: Optional[pulumi.Input[Union['ClusterEksConfigV2Args', 'ClusterEksConfigV2ArgsDict']]] = None,
            enable_cluster_istio: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_network_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            fleet_agent_deployment_customizations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterFleetAgentDeploymentCustomizationArgs', 'ClusterFleetAgentDeploymentCustomizationArgsDict']]]]] = None,
            fleet_workspace_name: Optional[pulumi.Input[_builtins.str]] = None,
            gke_config_v2: Optional[pulumi.Input[Union['ClusterGkeConfigV2Args', 'ClusterGkeConfigV2ArgsDict']]] = None,
            imported_config: Optional[pulumi.Input[Union['ClusterImportedConfigArgs', 'ClusterImportedConfigArgsDict']]] = None,
            istio_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            k3s_config: Optional[pulumi.Input[Union['ClusterK3sConfigArgs', 'ClusterK3sConfigArgsDict']]] = None,
            kube_config: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oke_config: Optional[pulumi.Input[Union['ClusterOkeConfigArgs', 'ClusterOkeConfigArgsDict']]] = None,
            rke2_config: Optional[pulumi.Input[Union['ClusterRke2ConfigArgs', 'ClusterRke2ConfigArgsDict']]] = None,
            rke_config: Optional[pulumi.Input[Union['ClusterRkeConfigArgs', 'ClusterRkeConfigArgsDict']]] = None,
            system_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            windows_prefered_cluster: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterAgentEnvVarArgs', 'ClusterAgentEnvVarArgsDict']]]] agent_env_vars: Optional Agent Env Vars for Rancher agent. For Rancher v2.5.6 and above (list)
        :param pulumi.Input[Union['ClusterAksConfigV2Args', 'ClusterAksConfigV2ArgsDict']] aks_config_v2: The Azure AKS v2 configuration for creating/import `aks` Clusters. Conflicts with `eks_config_v2`, `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Annotations for the Cluster (map)
        :param pulumi.Input[_builtins.str] ca_cert: (Computed/Sensitive) K8s cluster ca cert (string)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterClusterAgentDeploymentCustomizationArgs', 'ClusterClusterAgentDeploymentCustomizationArgsDict']]]] cluster_agent_deployment_customizations: Optional customization for cluster agent. For Rancher v2.7.5 and above (list)
        :param pulumi.Input[Union['ClusterClusterAuthEndpointArgs', 'ClusterClusterAuthEndpointArgsDict']] cluster_auth_endpoint: Enabling the [local cluster authorized endpoint](https://rancher.com/docs/rancher/v2.x/en/cluster-provisioning/rke-clusters/options/#local-cluster-auth-endpoint) allows direct communication with the cluster, bypassing the Rancher API proxy. (list maxitems:1)
        :param pulumi.Input[Union['ClusterClusterRegistrationTokenArgs', 'ClusterClusterRegistrationTokenArgsDict']] cluster_registration_token: (Computed) Cluster Registration Token generated for the cluster (list maxitems:1)
        :param pulumi.Input[Union['ClusterClusterTemplateAnswersArgs', 'ClusterClusterTemplateAnswersArgsDict']] cluster_template_answers: Cluster template answers. For Rancher v2.3.x and above (list maxitems:1)
        :param pulumi.Input[_builtins.str] cluster_template_id: Cluster template ID. For Rancher v2.3.x and above (string)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterClusterTemplateQuestionArgs', 'ClusterClusterTemplateQuestionArgsDict']]]] cluster_template_questions: Cluster template questions. For Rancher v2.3.x and above (list)
        :param pulumi.Input[_builtins.str] cluster_template_revision_id: Cluster template revision ID. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] default_pod_security_admission_configuration_template_name: The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above (string)
        :param pulumi.Input[_builtins.str] default_project_id: (Computed) Default project ID for the cluster (string)
        :param pulumi.Input[_builtins.str] description: The description for Cluster (string)
        :param pulumi.Input[_builtins.str] desired_agent_image: Desired agent image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] desired_auth_image: Desired auth image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] docker_root_dir: Desired auth image. For Rancher v2.3.x and above (string)
        :param pulumi.Input[_builtins.str] driver: (Computed) The driver used for the Cluster. `imported`, `azurekubernetesservice`, `amazonelasticcontainerservice`, `googlekubernetesengine` and `rancherKubernetesEngine` are supported (string)
        :param pulumi.Input[Union['ClusterEksConfigV2Args', 'ClusterEksConfigV2ArgsDict']] eks_config_v2: The Amazon EKS V2 configuration to create or import `eks` Clusters. Conflicts with `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.x and above (list maxitems:1)
        :param pulumi.Input[_builtins.bool] enable_cluster_istio: Deploy istio on `system` project and `istio-system` namespace, using rancher2_app resource instead. See above example.
        :param pulumi.Input[_builtins.bool] enable_network_policy: Enable project network isolation (bool)
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterFleetAgentDeploymentCustomizationArgs', 'ClusterFleetAgentDeploymentCustomizationArgsDict']]]] fleet_agent_deployment_customizations: Optional customization for fleet agent. For Rancher v2.7.5 and above (list)
        :param pulumi.Input[_builtins.str] fleet_workspace_name: Fleet workspace name (string)
        :param pulumi.Input[Union['ClusterGkeConfigV2Args', 'ClusterGkeConfigV2ArgsDict']] gke_config_v2: The Google GKE V2 configuration for `gke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.8 and above (list maxitems:1)
        :param pulumi.Input[Union['ClusterImportedConfigArgs', 'ClusterImportedConfigArgsDict']] imported_config: The imported configuration for generic imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `rke_config`, `rke2_config` and `k3s_config` (list maxitems:1)
        :param pulumi.Input[_builtins.bool] istio_enabled: (Computed) Is istio enabled at cluster? For Rancher v2.3.x and above (bool)
        :param pulumi.Input[Union['ClusterK3sConfigArgs', 'ClusterK3sConfigArgsDict']] k3s_config: The K3S configuration for `k3s` imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[_builtins.str] kube_config: (Computed/Sensitive) Kube Config generated for the cluster. Note: For Rancher 2.6.0 and above, when the cluster has `cluster_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected` (string)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for the Cluster (map)
        :param pulumi.Input[_builtins.str] name: The name of the Cluster (string)
        :param pulumi.Input[Union['ClusterOkeConfigArgs', 'ClusterOkeConfigArgsDict']] oke_config: The Oracle OKE configuration for `oke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `k3s_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[Union['ClusterRke2ConfigArgs', 'ClusterRke2ConfigArgsDict']] rke2_config: The RKE2 configuration for `rke2` Clusters. Conflicts with `aks_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        :param pulumi.Input[Union['ClusterRkeConfigArgs', 'ClusterRkeConfigArgsDict']] rke_config: The RKE configuration for `rke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `k3s_config` (list maxitems:1)
        :param pulumi.Input[_builtins.str] system_project_id: (Computed) System project ID for the cluster (string)
        :param pulumi.Input[_builtins.bool] windows_prefered_cluster: Windows preferred cluster. Default: `false` (bool)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["agent_env_vars"] = agent_env_vars
        __props__.__dict__["aks_config_v2"] = aks_config_v2
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["ca_cert"] = ca_cert
        __props__.__dict__["cluster_agent_deployment_customizations"] = cluster_agent_deployment_customizations
        __props__.__dict__["cluster_auth_endpoint"] = cluster_auth_endpoint
        __props__.__dict__["cluster_registration_token"] = cluster_registration_token
        __props__.__dict__["cluster_template_answers"] = cluster_template_answers
        __props__.__dict__["cluster_template_id"] = cluster_template_id
        __props__.__dict__["cluster_template_questions"] = cluster_template_questions
        __props__.__dict__["cluster_template_revision_id"] = cluster_template_revision_id
        __props__.__dict__["default_pod_security_admission_configuration_template_name"] = default_pod_security_admission_configuration_template_name
        __props__.__dict__["default_project_id"] = default_project_id
        __props__.__dict__["description"] = description
        __props__.__dict__["desired_agent_image"] = desired_agent_image
        __props__.__dict__["desired_auth_image"] = desired_auth_image
        __props__.__dict__["docker_root_dir"] = docker_root_dir
        __props__.__dict__["driver"] = driver
        __props__.__dict__["eks_config_v2"] = eks_config_v2
        __props__.__dict__["enable_cluster_istio"] = enable_cluster_istio
        __props__.__dict__["enable_network_policy"] = enable_network_policy
        __props__.__dict__["fleet_agent_deployment_customizations"] = fleet_agent_deployment_customizations
        __props__.__dict__["fleet_workspace_name"] = fleet_workspace_name
        __props__.__dict__["gke_config_v2"] = gke_config_v2
        __props__.__dict__["imported_config"] = imported_config
        __props__.__dict__["istio_enabled"] = istio_enabled
        __props__.__dict__["k3s_config"] = k3s_config
        __props__.__dict__["kube_config"] = kube_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["oke_config"] = oke_config
        __props__.__dict__["rke2_config"] = rke2_config
        __props__.__dict__["rke_config"] = rke_config
        __props__.__dict__["system_project_id"] = system_project_id
        __props__.__dict__["windows_prefered_cluster"] = windows_prefered_cluster
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentEnvVars")
    def agent_env_vars(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterAgentEnvVar']]]:
        """
        Optional Agent Env Vars for Rancher agent. For Rancher v2.5.6 and above (list)
        """
        return pulumi.get(self, "agent_env_vars")

    @_builtins.property
    @pulumi.getter(name="aksConfigV2")
    def aks_config_v2(self) -> pulumi.Output[Optional['outputs.ClusterAksConfigV2']]:
        """
        The Azure AKS v2 configuration for creating/import `aks` Clusters. Conflicts with `eks_config_v2`, `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "aks_config_v2")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Annotations for the Cluster (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed/Sensitive) K8s cluster ca cert (string)
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter(name="clusterAgentDeploymentCustomizations")
    def cluster_agent_deployment_customizations(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterClusterAgentDeploymentCustomization']]]:
        """
        Optional customization for cluster agent. For Rancher v2.7.5 and above (list)
        """
        return pulumi.get(self, "cluster_agent_deployment_customizations")

    @_builtins.property
    @pulumi.getter(name="clusterAuthEndpoint")
    def cluster_auth_endpoint(self) -> pulumi.Output['outputs.ClusterClusterAuthEndpoint']:
        """
        Enabling the [local cluster authorized endpoint](https://rancher.com/docs/rancher/v2.x/en/cluster-provisioning/rke-clusters/options/#local-cluster-auth-endpoint) allows direct communication with the cluster, bypassing the Rancher API proxy. (list maxitems:1)
        """
        return pulumi.get(self, "cluster_auth_endpoint")

    @_builtins.property
    @pulumi.getter(name="clusterRegistrationToken")
    def cluster_registration_token(self) -> pulumi.Output['outputs.ClusterClusterRegistrationToken']:
        """
        (Computed) Cluster Registration Token generated for the cluster (list maxitems:1)
        """
        return pulumi.get(self, "cluster_registration_token")

    @_builtins.property
    @pulumi.getter(name="clusterTemplateAnswers")
    def cluster_template_answers(self) -> pulumi.Output['outputs.ClusterClusterTemplateAnswers']:
        """
        Cluster template answers. For Rancher v2.3.x and above (list maxitems:1)
        """
        return pulumi.get(self, "cluster_template_answers")

    @_builtins.property
    @pulumi.getter(name="clusterTemplateId")
    def cluster_template_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cluster template ID. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "cluster_template_id")

    @_builtins.property
    @pulumi.getter(name="clusterTemplateQuestions")
    def cluster_template_questions(self) -> pulumi.Output[Sequence['outputs.ClusterClusterTemplateQuestion']]:
        """
        Cluster template questions. For Rancher v2.3.x and above (list)
        """
        return pulumi.get(self, "cluster_template_questions")

    @_builtins.property
    @pulumi.getter(name="clusterTemplateRevisionId")
    def cluster_template_revision_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cluster template revision ID. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "cluster_template_revision_id")

    @_builtins.property
    @pulumi.getter(name="defaultPodSecurityAdmissionConfigurationTemplateName")
    def default_pod_security_admission_configuration_template_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the pre-defined pod security admission configuration template to be applied to the cluster. Rancher admins (or those with the right permissions) can create, manage, and edit those templates. For more information, please refer to [Rancher Documentation](https://ranchermanager.docs.rancher.com/how-to-guides/new-user-guides/authentication-permissions-and-global-configuration/psa-config-templates). The argument is available in Rancher v2.7.2 and above (string)
        """
        return pulumi.get(self, "default_pod_security_admission_configuration_template_name")

    @_builtins.property
    @pulumi.getter(name="defaultProjectId")
    def default_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) Default project ID for the cluster (string)
        """
        return pulumi.get(self, "default_project_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for Cluster (string)
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="desiredAgentImage")
    def desired_agent_image(self) -> pulumi.Output[_builtins.str]:
        """
        Desired agent image. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "desired_agent_image")

    @_builtins.property
    @pulumi.getter(name="desiredAuthImage")
    def desired_auth_image(self) -> pulumi.Output[_builtins.str]:
        """
        Desired auth image. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "desired_auth_image")

    @_builtins.property
    @pulumi.getter(name="dockerRootDir")
    def docker_root_dir(self) -> pulumi.Output[_builtins.str]:
        """
        Desired auth image. For Rancher v2.3.x and above (string)
        """
        return pulumi.get(self, "docker_root_dir")

    @_builtins.property
    @pulumi.getter
    def driver(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) The driver used for the Cluster. `imported`, `azurekubernetesservice`, `amazonelasticcontainerservice`, `googlekubernetesengine` and `rancherKubernetesEngine` are supported (string)
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="eksConfigV2")
    def eks_config_v2(self) -> pulumi.Output['outputs.ClusterEksConfigV2']:
        """
        The Amazon EKS V2 configuration to create or import `eks` Clusters. Conflicts with `gke_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.x and above (list maxitems:1)
        """
        return pulumi.get(self, "eks_config_v2")

    @_builtins.property
    @pulumi.getter(name="enableClusterIstio")
    @_utilities.deprecated("""Deploy istio using rancher2_app resource instead""")
    def enable_cluster_istio(self) -> pulumi.Output[_builtins.bool]:
        """
        Deploy istio on `system` project and `istio-system` namespace, using rancher2_app resource instead. See above example.
        """
        return pulumi.get(self, "enable_cluster_istio")

    @_builtins.property
    @pulumi.getter(name="enableNetworkPolicy")
    def enable_network_policy(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable project network isolation (bool)
        """
        return pulumi.get(self, "enable_network_policy")

    @_builtins.property
    @pulumi.getter(name="fleetAgentDeploymentCustomizations")
    def fleet_agent_deployment_customizations(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterFleetAgentDeploymentCustomization']]]:
        """
        Optional customization for fleet agent. For Rancher v2.7.5 and above (list)
        """
        return pulumi.get(self, "fleet_agent_deployment_customizations")

    @_builtins.property
    @pulumi.getter(name="fleetWorkspaceName")
    def fleet_workspace_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fleet workspace name (string)
        """
        return pulumi.get(self, "fleet_workspace_name")

    @_builtins.property
    @pulumi.getter(name="gkeConfigV2")
    def gke_config_v2(self) -> pulumi.Output[Optional['outputs.ClusterGkeConfigV2']]:
        """
        The Google GKE V2 configuration for `gke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `k3s_config`, `oke_config` and `rke_config`. For Rancher v2.5.8 and above (list maxitems:1)
        """
        return pulumi.get(self, "gke_config_v2")

    @_builtins.property
    @pulumi.getter(name="importedConfig")
    def imported_config(self) -> pulumi.Output[Optional['outputs.ClusterImportedConfig']]:
        """
        The imported configuration for generic imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `rke_config`, `rke2_config` and `k3s_config` (list maxitems:1)
        """
        return pulumi.get(self, "imported_config")

    @_builtins.property
    @pulumi.getter(name="istioEnabled")
    def istio_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Computed) Is istio enabled at cluster? For Rancher v2.3.x and above (bool)
        """
        return pulumi.get(self, "istio_enabled")

    @_builtins.property
    @pulumi.getter(name="k3sConfig")
    def k3s_config(self) -> pulumi.Output['outputs.ClusterK3sConfig']:
        """
        The K3S configuration for `k3s` imported Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "k3s_config")

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed/Sensitive) Kube Config generated for the cluster. Note: For Rancher 2.6.0 and above, when the cluster has `cluster_auth_endpoint` enabled, the kube_config will not be available until the cluster is `connected` (string)
        """
        return pulumi.get(self, "kube_config")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Labels for the Cluster (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cluster (string)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="okeConfig")
    def oke_config(self) -> pulumi.Output[Optional['outputs.ClusterOkeConfig']]:
        """
        The Oracle OKE configuration for `oke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `k3s_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "oke_config")

    @_builtins.property
    @pulumi.getter(name="rke2Config")
    def rke2_config(self) -> pulumi.Output['outputs.ClusterRke2Config']:
        """
        The RKE2 configuration for `rke2` Clusters. Conflicts with `aks_config_v2`, `k3s_config`, `oke_config` and `rke_config` (list maxitems:1)
        """
        return pulumi.get(self, "rke2_config")

    @_builtins.property
    @pulumi.getter(name="rkeConfig")
    def rke_config(self) -> pulumi.Output['outputs.ClusterRkeConfig']:
        """
        The RKE configuration for `rke` Clusters. Conflicts with `aks_config_v2`, `eks_config_v2`, `gke_config_v2`, `oke_config` and `k3s_config` (list maxitems:1)
        """
        return pulumi.get(self, "rke_config")

    @_builtins.property
    @pulumi.getter(name="systemProjectId")
    def system_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Computed) System project ID for the cluster (string)
        """
        return pulumi.get(self, "system_project_id")

    @_builtins.property
    @pulumi.getter(name="windowsPreferedCluster")
    def windows_prefered_cluster(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Windows preferred cluster. Default: `false` (bool)
        """
        return pulumi.get(self, "windows_prefered_cluster")

