# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, annotations=None, enabled=None, id=None, is_external=None, labels=None, must_change_password=None, name=None, principal_ids=None, username=None):
        if annotations and not isinstance(annotations, dict):
            raise TypeError("Expected argument 'annotations' to be a dict")
        pulumi.set(__self__, "annotations", annotations)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_external and not isinstance(is_external, bool):
            raise TypeError("Expected argument 'is_external' to be a bool")
        pulumi.set(__self__, "is_external", is_external)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if must_change_password and not isinstance(must_change_password, bool):
            raise TypeError("Expected argument 'must_change_password' to be a bool")
        pulumi.set(__self__, "must_change_password", must_change_password)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if principal_ids and not isinstance(principal_ids, list):
            raise TypeError("Expected argument 'principal_ids' to be a list")
        pulumi.set(__self__, "principal_ids", principal_ids)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        (Computed) Annotations of the resource (map)
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        (Computed) The user is enabled (bool)
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isExternal")
    def is_external(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "is_external")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        (Computed) Labels of the resource (map)
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="mustChangePassword")
    def must_change_password(self) -> _builtins.bool:
        """
        (Computed) The user must change password at first login (bool)
        """
        return pulumi.get(self, "must_change_password")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (Computed) The user common name (string)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="principalIds")
    def principal_ids(self) -> Sequence[_builtins.str]:
        """
        (Computed) The user principal IDs (list)
        """
        return pulumi.get(self, "principal_ids")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        return pulumi.get(self, "username")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            annotations=self.annotations,
            enabled=self.enabled,
            id=self.id,
            is_external=self.is_external,
            labels=self.labels,
            must_change_password=self.must_change_password,
            name=self.name,
            principal_ids=self.principal_ids,
            username=self.username)


def get_user(is_external: Optional[_builtins.bool] = None,
             name: Optional[_builtins.str] = None,
             username: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Use this data source to retrieve information about a Rancher v2 user

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    foo = rancher2.get_user(username="foo")
    ```


    :param _builtins.bool is_external: Set is the user if the user is external. Default: `false` (bool)
    :param _builtins.str name: The name of the user (string)
    :param _builtins.str username: The username of the user (string)
    """
    __args__ = dict()
    __args__['isExternal'] = is_external
    __args__['name'] = name
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('rancher2:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        annotations=pulumi.get(__ret__, 'annotations'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        is_external=pulumi.get(__ret__, 'is_external'),
        labels=pulumi.get(__ret__, 'labels'),
        must_change_password=pulumi.get(__ret__, 'must_change_password'),
        name=pulumi.get(__ret__, 'name'),
        principal_ids=pulumi.get(__ret__, 'principal_ids'),
        username=pulumi.get(__ret__, 'username'))
def get_user_output(is_external: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    username: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserResult]:
    """
    Use this data source to retrieve information about a Rancher v2 user

    ## Example Usage

    ```python
    import pulumi
    import pulumi_rancher2 as rancher2

    foo = rancher2.get_user(username="foo")
    ```


    :param _builtins.bool is_external: Set is the user if the user is external. Default: `false` (bool)
    :param _builtins.str name: The name of the user (string)
    :param _builtins.str username: The username of the user (string)
    """
    __args__ = dict()
    __args__['isExternal'] = is_external
    __args__['name'] = name
    __args__['username'] = username
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('rancher2:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult)
    return __ret__.apply(lambda __response__: GetUserResult(
        annotations=pulumi.get(__response__, 'annotations'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        is_external=pulumi.get(__response__, 'is_external'),
        labels=pulumi.get(__response__, 'labels'),
        must_change_password=pulumi.get(__response__, 'must_change_password'),
        name=pulumi.get(__response__, 'name'),
        principal_ids=pulumi.get(__response__, 'principal_ids'),
        username=pulumi.get(__response__, 'username')))
