# This file was auto-generated by Fern from our API Definition.

import typing
from .environment import VellumEnvironment
from .types.api_version_enum import ApiVersionEnum
import os
import httpx
from .core.client_wrapper import SyncClientWrapper
from .resources.ad_hoc.client import AdHocClient
from .resources.container_images.client import ContainerImagesClient
from .resources.deployments.client import DeploymentsClient
from .resources.document_indexes.client import DocumentIndexesClient
from .resources.documents.client import DocumentsClient
from .resources.folder_entities.client import FolderEntitiesClient
from .resources.metric_definitions.client import MetricDefinitionsClient
from .resources.ml_models.client import MlModelsClient
from .resources.organizations.client import OrganizationsClient
from .resources.prompts.client import PromptsClient
from .resources.sandboxes.client import SandboxesClient
from .resources.test_suite_runs.client import TestSuiteRunsClient
from .resources.test_suites.client import TestSuitesClient
from .resources.workflow_deployments.client import WorkflowDeploymentsClient
from .resources.release_reviews.client import ReleaseReviewsClient
from .resources.workflow_executions.client import WorkflowExecutionsClient
from .resources.workflow_sandboxes.client import WorkflowSandboxesClient
from .resources.workflows.client import WorkflowsClient
from .resources.workspace_secrets.client import WorkspaceSecretsClient
from .resources.workspaces.client import WorkspacesClient
from .types.method_enum import MethodEnum
from .types.execute_api_request_body import ExecuteApiRequestBody
from .types.execute_api_request_headers_value import ExecuteApiRequestHeadersValue
from .types.execute_api_request_bearer_token import ExecuteApiRequestBearerToken
from .core.request_options import RequestOptions
from .types.execute_api_response import ExecuteApiResponse
from .core.serialization import convert_and_respect_annotation_metadata
from .core.pydantic_utilities import parse_obj_as
from json.decoder import JSONDecodeError
from .core.api_error import ApiError
from .types.code_execution_runtime import CodeExecutionRuntime
from .types.code_executor_input import CodeExecutorInput
from .types.code_execution_package import CodeExecutionPackage
from .types.vellum_variable_type import VellumVariableType
from .types.code_executor_response import CodeExecutorResponse
from .errors.bad_request_error import BadRequestError
from .types.prompt_deployment_input_request import PromptDeploymentInputRequest
from .types.prompt_deployment_expand_meta_request import PromptDeploymentExpandMetaRequest
from .types.raw_prompt_execution_overrides_request import RawPromptExecutionOverridesRequest
from .types.execute_prompt_response import ExecutePromptResponse
from .errors.forbidden_error import ForbiddenError
from .errors.not_found_error import NotFoundError
from .errors.internal_server_error import InternalServerError
from .types.execute_prompt_event import ExecutePromptEvent
import json
from .types.workflow_request_input_request import WorkflowRequestInputRequest
from .types.workflow_expand_meta_request import WorkflowExpandMetaRequest
from .types.execute_workflow_response import ExecuteWorkflowResponse
from .types.workflow_execution_event_type import WorkflowExecutionEventType
from .types.workflow_stream_event import WorkflowStreamEvent
from .types.generate_request import GenerateRequest
from .types.generate_options_request import GenerateOptionsRequest
from .types.generate_response import GenerateResponse
from .types.generate_stream_response import GenerateStreamResponse
from .types.search_request_options_request import SearchRequestOptionsRequest
from .types.search_response import SearchResponse
from .types.submit_completion_actual_request import SubmitCompletionActualRequest
from .types.submit_workflow_execution_actual_request import SubmitWorkflowExecutionActualRequest
from .core.client_wrapper import AsyncClientWrapper
from .resources.ad_hoc.client import AsyncAdHocClient
from .resources.container_images.client import AsyncContainerImagesClient
from .resources.deployments.client import AsyncDeploymentsClient
from .resources.document_indexes.client import AsyncDocumentIndexesClient
from .resources.documents.client import AsyncDocumentsClient
from .resources.folder_entities.client import AsyncFolderEntitiesClient
from .resources.metric_definitions.client import AsyncMetricDefinitionsClient
from .resources.ml_models.client import AsyncMlModelsClient
from .resources.organizations.client import AsyncOrganizationsClient
from .resources.prompts.client import AsyncPromptsClient
from .resources.sandboxes.client import AsyncSandboxesClient
from .resources.test_suite_runs.client import AsyncTestSuiteRunsClient
from .resources.test_suites.client import AsyncTestSuitesClient
from .resources.workflow_deployments.client import AsyncWorkflowDeploymentsClient
from .resources.release_reviews.client import AsyncReleaseReviewsClient
from .resources.workflow_executions.client import AsyncWorkflowExecutionsClient
from .resources.workflow_sandboxes.client import AsyncWorkflowSandboxesClient
from .resources.workflows.client import AsyncWorkflowsClient
from .resources.workspace_secrets.client import AsyncWorkspaceSecretsClient
from .resources.workspaces.client import AsyncWorkspacesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class Vellum:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : VellumEnvironment
        The environment to use for requests from the client. from .environment import VellumEnvironment



        Defaults to VellumEnvironment.PRODUCTION



    api_version : typing.Optional[ApiVersionEnum]
    api_key : str
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default there is no timeout set, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from vellum import Vellum

    client = Vellum(
        api_version="YOUR_API_VERSION",
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: VellumEnvironment = VellumEnvironment.PRODUCTION,
        api_version: typing.Optional[ApiVersionEnum] = os.getenv("VELLUM_API_VERSION", "2025-07-30"),
        api_key: str,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else None if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            environment=environment,
            api_version=api_version,
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.ad_hoc = AdHocClient(client_wrapper=self._client_wrapper)
        self.container_images = ContainerImagesClient(client_wrapper=self._client_wrapper)
        self.deployments = DeploymentsClient(client_wrapper=self._client_wrapper)
        self.document_indexes = DocumentIndexesClient(client_wrapper=self._client_wrapper)
        self.documents = DocumentsClient(client_wrapper=self._client_wrapper)
        self.folder_entities = FolderEntitiesClient(client_wrapper=self._client_wrapper)
        self.metric_definitions = MetricDefinitionsClient(client_wrapper=self._client_wrapper)
        self.ml_models = MlModelsClient(client_wrapper=self._client_wrapper)
        self.organizations = OrganizationsClient(client_wrapper=self._client_wrapper)
        self.prompts = PromptsClient(client_wrapper=self._client_wrapper)
        self.sandboxes = SandboxesClient(client_wrapper=self._client_wrapper)
        self.test_suite_runs = TestSuiteRunsClient(client_wrapper=self._client_wrapper)
        self.test_suites = TestSuitesClient(client_wrapper=self._client_wrapper)
        self.workflow_deployments = WorkflowDeploymentsClient(client_wrapper=self._client_wrapper)
        self.release_reviews = ReleaseReviewsClient(client_wrapper=self._client_wrapper)
        self.workflow_executions = WorkflowExecutionsClient(client_wrapper=self._client_wrapper)
        self.workflow_sandboxes = WorkflowSandboxesClient(client_wrapper=self._client_wrapper)
        self.workflows = WorkflowsClient(client_wrapper=self._client_wrapper)
        self.workspace_secrets = WorkspaceSecretsClient(client_wrapper=self._client_wrapper)
        self.workspaces = WorkspacesClient(client_wrapper=self._client_wrapper)

    def execute_api(
        self,
        *,
        url: str,
        method: typing.Optional[MethodEnum] = OMIT,
        body: typing.Optional[ExecuteApiRequestBody] = OMIT,
        headers: typing.Optional[typing.Dict[str, ExecuteApiRequestHeadersValue]] = OMIT,
        bearer_token: typing.Optional[ExecuteApiRequestBearerToken] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecuteApiResponse:
        """
        Parameters
        ----------
        url : str

        method : typing.Optional[MethodEnum]

        body : typing.Optional[ExecuteApiRequestBody]

        headers : typing.Optional[typing.Dict[str, ExecuteApiRequestHeadersValue]]

        bearer_token : typing.Optional[ExecuteApiRequestBearerToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecuteApiResponse


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.execute_api(
            url="x",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/execute-api",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "url": url,
                "method": method,
                "body": convert_and_respect_annotation_metadata(
                    object_=body, annotation=typing.Optional[ExecuteApiRequestBody], direction="write"
                ),
                "headers": convert_and_respect_annotation_metadata(
                    object_=headers, annotation=typing.Dict[str, ExecuteApiRequestHeadersValue], direction="write"
                ),
                "bearer_token": convert_and_respect_annotation_metadata(
                    object_=bearer_token, annotation=typing.Optional[ExecuteApiRequestBearerToken], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ExecuteApiResponse,
                    parse_obj_as(
                        type_=ExecuteApiResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def execute_code(
        self,
        *,
        code: str,
        runtime: CodeExecutionRuntime,
        input_values: typing.Sequence[CodeExecutorInput],
        packages: typing.Sequence[CodeExecutionPackage],
        output_type: VellumVariableType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CodeExecutorResponse:
        """
        Parameters
        ----------
        code : str

        runtime : CodeExecutionRuntime

        input_values : typing.Sequence[CodeExecutorInput]

        packages : typing.Sequence[CodeExecutionPackage]

        output_type : VellumVariableType

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeExecutorResponse


        Examples
        --------
        from vellum import CodeExecutionPackage, StringInput, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.execute_code(
            code="x",
            runtime="PYTHON_3_11_6",
            input_values=[
                StringInput(
                    name="x",
                    value="value",
                ),
                StringInput(
                    name="x",
                    value="value",
                ),
            ],
            packages=[
                CodeExecutionPackage(
                    version="version",
                    name="name",
                ),
                CodeExecutionPackage(
                    version="version",
                    name="name",
                ),
            ],
            output_type="STRING",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/execute-code",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "code": code,
                "runtime": runtime,
                "input_values": convert_and_respect_annotation_metadata(
                    object_=input_values, annotation=typing.Sequence[CodeExecutorInput], direction="write"
                ),
                "packages": convert_and_respect_annotation_metadata(
                    object_=packages, annotation=typing.Sequence[CodeExecutionPackage], direction="write"
                ),
                "output_type": output_type,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CodeExecutorResponse,
                    parse_obj_as(
                        type_=CodeExecutorResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def execute_prompt(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        prompt_deployment_id: typing.Optional[str] = OMIT,
        prompt_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[PromptDeploymentExpandMetaRequest] = OMIT,
        raw_overrides: typing.Optional[RawPromptExecutionOverridesRequest] = OMIT,
        expand_raw: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecutePromptResponse:
        """
        Executes a deployed Prompt and returns the result.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            A list consisting of the Prompt Deployment's input variables and their values.

        prompt_deployment_id : typing.Optional[str]
            The ID of the Prompt Deployment. Must provide either this or prompt_deployment_name.

        prompt_deployment_name : typing.Optional[str]
            The unique name of the Prompt Deployment. Must provide either this or prompt_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Prompt Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        expand_meta : typing.Optional[PromptDeploymentExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this prompt execution in the API response. Corresponding values will be returned under the `meta` key of the API response.

        raw_overrides : typing.Optional[RawPromptExecutionOverridesRequest]
            Overrides for the raw API request sent to the model host. Combined with `expand_raw`, it can be used to access new features from models.

        expand_raw : typing.Optional[typing.Sequence[str]]
            A list of keys whose values you'd like to directly return from the JSON response of the model provider. Useful if you need lower-level info returned by model providers that Vellum would otherwise omit. Corresponding key/value pairs will be returned under the `raw` key of the API response.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecutePromptResponse


        Examples
        --------
        from vellum import StringInputRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.execute_prompt(
            inputs=[
                StringInputRequest(
                    name="x",
                    value="value",
                ),
                StringInputRequest(
                    name="x",
                    value="value",
                ),
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/execute-prompt",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[PromptDeploymentInputRequest], direction="write"
                ),
                "prompt_deployment_id": prompt_deployment_id,
                "prompt_deployment_name": prompt_deployment_name,
                "release_tag": release_tag,
                "external_id": external_id,
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta,
                    annotation=typing.Optional[PromptDeploymentExpandMetaRequest],
                    direction="write",
                ),
                "raw_overrides": convert_and_respect_annotation_metadata(
                    object_=raw_overrides,
                    annotation=typing.Optional[RawPromptExecutionOverridesRequest],
                    direction="write",
                ),
                "expand_raw": expand_raw,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ExecutePromptResponse,
                    parse_obj_as(
                        type_=ExecutePromptResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def execute_prompt_stream(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        prompt_deployment_id: typing.Optional[str] = OMIT,
        prompt_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[PromptDeploymentExpandMetaRequest] = OMIT,
        raw_overrides: typing.Optional[RawPromptExecutionOverridesRequest] = OMIT,
        expand_raw: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[ExecutePromptEvent]:
        """
        Executes a deployed Prompt and streams back the results.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            A list consisting of the Prompt Deployment's input variables and their values.

        prompt_deployment_id : typing.Optional[str]
            The ID of the Prompt Deployment. Must provide either this or prompt_deployment_name.

        prompt_deployment_name : typing.Optional[str]
            The unique name of the Prompt Deployment. Must provide either this or prompt_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Prompt Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        expand_meta : typing.Optional[PromptDeploymentExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this prompt execution in the API response. Corresponding values will be returned under the `meta` key of the API response.

        raw_overrides : typing.Optional[RawPromptExecutionOverridesRequest]
            Overrides for the raw API request sent to the model host. Combined with `expand_raw`, it can be used to access new features from models.

        expand_raw : typing.Optional[typing.Sequence[str]]
            A list of keys whose values you'd like to directly return from the JSON response of the model provider. Useful if you need lower-level info returned by model providers that Vellum would otherwise omit. Corresponding key/value pairs will be returned under the `raw` key of the API response.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[ExecutePromptEvent]


        Examples
        --------
        from vellum import StringInputRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        response = client.execute_prompt_stream(
            inputs=[
                StringInputRequest(
                    name="x",
                    value="value",
                ),
                StringInputRequest(
                    name="x",
                    value="value",
                ),
            ],
        )
        for chunk in response:
            yield chunk
        """
        with self._client_wrapper.httpx_client.stream(
            "v1/execute-prompt-stream",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[PromptDeploymentInputRequest], direction="write"
                ),
                "prompt_deployment_id": prompt_deployment_id,
                "prompt_deployment_name": prompt_deployment_name,
                "release_tag": release_tag,
                "external_id": external_id,
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta,
                    annotation=typing.Optional[PromptDeploymentExpandMetaRequest],
                    direction="write",
                ),
                "raw_overrides": convert_and_respect_annotation_metadata(
                    object_=raw_overrides,
                    annotation=typing.Optional[RawPromptExecutionOverridesRequest],
                    direction="write",
                ),
                "expand_raw": expand_raw,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    for _text in _response.iter_lines():
                        try:
                            if len(_text) == 0:
                                continue
                            yield typing.cast(
                                ExecutePromptEvent,
                                parse_obj_as(
                                    type_=ExecutePromptEvent,  # type: ignore
                                    object_=json.loads(_text),
                                ),
                            )
                        except Exception:
                            pass
                    return
                _response.read()
                if _response.status_code == 400:
                    raise BadRequestError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 403:
                    raise ForbiddenError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 404:
                    raise NotFoundError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 500:
                    raise InternalServerError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    def execute_workflow(
        self,
        *,
        inputs: typing.Sequence[WorkflowRequestInputRequest],
        expand_meta: typing.Optional[WorkflowExpandMetaRequest] = OMIT,
        workflow_deployment_id: typing.Optional[str] = OMIT,
        workflow_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecuteWorkflowResponse:
        """
        Executes a deployed Workflow and returns its outputs.

        Parameters
        ----------
        inputs : typing.Sequence[WorkflowRequestInputRequest]
            The list of inputs defined in the Workflow's Deployment with their corresponding values.

        expand_meta : typing.Optional[WorkflowExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this workflow execution in the API response. Corresponding values will be returned under the `execution_meta` key within NODE events in the response stream.

        workflow_deployment_id : typing.Optional[str]
            The ID of the Workflow Deployment. Must provide either this or workflow_deployment_name.

        workflow_deployment_name : typing.Optional[str]
            The name of the Workflow Deployment. Must provide either this or workflow_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecuteWorkflowResponse


        Examples
        --------
        from vellum import Vellum, WorkflowRequestStringInputRequest

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.execute_workflow(
            inputs=[
                WorkflowRequestStringInputRequest(
                    name="x",
                    value="value",
                ),
                WorkflowRequestStringInputRequest(
                    name="x",
                    value="value",
                ),
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/execute-workflow",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[WorkflowRequestInputRequest], direction="write"
                ),
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta, annotation=typing.Optional[WorkflowExpandMetaRequest], direction="write"
                ),
                "workflow_deployment_id": workflow_deployment_id,
                "workflow_deployment_name": workflow_deployment_name,
                "release_tag": release_tag,
                "external_id": external_id,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ExecuteWorkflowResponse,
                    parse_obj_as(
                        type_=ExecuteWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def execute_workflow_stream(
        self,
        *,
        inputs: typing.Sequence[WorkflowRequestInputRequest],
        expand_meta: typing.Optional[WorkflowExpandMetaRequest] = OMIT,
        workflow_deployment_id: typing.Optional[str] = OMIT,
        workflow_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        event_types: typing.Optional[typing.Sequence[WorkflowExecutionEventType]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[WorkflowStreamEvent]:
        """
        Executes a deployed Workflow and streams back its results.

        Parameters
        ----------
        inputs : typing.Sequence[WorkflowRequestInputRequest]
            The list of inputs defined in the Workflow's Deployment with their corresponding values.

        expand_meta : typing.Optional[WorkflowExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this workflow execution in the API response. Corresponding values will be returned under the `execution_meta` key within NODE events in the response stream.

        workflow_deployment_id : typing.Optional[str]
            The ID of the Workflow Deployment. Must provide either this or workflow_deployment_name.

        workflow_deployment_name : typing.Optional[str]
            The name of the Workflow Deployment. Must provide either this or workflow_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        event_types : typing.Optional[typing.Sequence[WorkflowExecutionEventType]]
            Optionally specify which events you want to receive. Defaults to only WORKFLOW events. Note that the schema of non-WORKFLOW events is unstable and should be used with caution.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[WorkflowStreamEvent]


        Examples
        --------
        from vellum import Vellum, WorkflowRequestStringInputRequest

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        response = client.execute_workflow_stream(
            inputs=[
                WorkflowRequestStringInputRequest(
                    name="x",
                    value="value",
                ),
                WorkflowRequestStringInputRequest(
                    name="x",
                    value="value",
                ),
            ],
        )
        for chunk in response:
            yield chunk
        """
        with self._client_wrapper.httpx_client.stream(
            "v1/execute-workflow-stream",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[WorkflowRequestInputRequest], direction="write"
                ),
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta, annotation=typing.Optional[WorkflowExpandMetaRequest], direction="write"
                ),
                "workflow_deployment_id": workflow_deployment_id,
                "workflow_deployment_name": workflow_deployment_name,
                "release_tag": release_tag,
                "external_id": external_id,
                "event_types": event_types,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    for _text in _response.iter_lines():
                        try:
                            if len(_text) == 0:
                                continue
                            yield typing.cast(
                                WorkflowStreamEvent,
                                parse_obj_as(
                                    type_=WorkflowStreamEvent,  # type: ignore
                                    object_=json.loads(_text),
                                ),
                            )
                        except Exception:
                            pass
                    return
                _response.read()
                if _response.status_code == 400:
                    raise BadRequestError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 404:
                    raise NotFoundError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 500:
                    raise InternalServerError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    def generate(
        self,
        *,
        requests: typing.Sequence[GenerateRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        options: typing.Optional[GenerateOptionsRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateResponse:
        """
        Generate a completion using a previously defined deployment.

        Important: This endpoint is DEPRECATED and has been superseded by
        [execute-prompt](/api-reference/api-reference/execute-prompt).

        Parameters
        ----------
        requests : typing.Sequence[GenerateRequest]
            The generation request to make. Bulk requests are no longer supported, this field must be an array of length 1.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        options : typing.Optional[GenerateOptionsRequest]
            Additional configuration that can be used to control what's included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateResponse


        Examples
        --------
        from vellum import GenerateRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.generate(
            requests=[
                GenerateRequest(
                    input_values={"input_values": {"key": "value"}},
                ),
                GenerateRequest(
                    input_values={"input_values": {"key": "value"}},
                ),
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/generate",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "deployment_id": deployment_id,
                "deployment_name": deployment_name,
                "requests": convert_and_respect_annotation_metadata(
                    object_=requests, annotation=typing.Sequence[GenerateRequest], direction="write"
                ),
                "options": convert_and_respect_annotation_metadata(
                    object_=options, annotation=typing.Optional[GenerateOptionsRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GenerateResponse,
                    parse_obj_as(
                        type_=GenerateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def generate_stream(
        self,
        *,
        requests: typing.Sequence[GenerateRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        options: typing.Optional[GenerateOptionsRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[GenerateStreamResponse]:
        """
        Generate a stream of completions using a previously defined deployment.

        Important: This endpoint is DEPRECATED and has been superseded by
        [execute-prompt-stream](/api-reference/api-reference/execute-prompt-stream).

        Parameters
        ----------
        requests : typing.Sequence[GenerateRequest]
            The generation request to make. Bulk requests are no longer supported, this field must be an array of length 1.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        options : typing.Optional[GenerateOptionsRequest]
            Additional configuration that can be used to control what's included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[GenerateStreamResponse]


        Examples
        --------
        from vellum import GenerateRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        response = client.generate_stream(
            requests=[
                GenerateRequest(
                    input_values={"input_values": {"key": "value"}},
                ),
                GenerateRequest(
                    input_values={"input_values": {"key": "value"}},
                ),
            ],
        )
        for chunk in response:
            yield chunk
        """
        with self._client_wrapper.httpx_client.stream(
            "v1/generate-stream",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "deployment_id": deployment_id,
                "deployment_name": deployment_name,
                "requests": convert_and_respect_annotation_metadata(
                    object_=requests, annotation=typing.Sequence[GenerateRequest], direction="write"
                ),
                "options": convert_and_respect_annotation_metadata(
                    object_=options, annotation=typing.Optional[GenerateOptionsRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    for _text in _response.iter_lines():
                        try:
                            if len(_text) == 0:
                                continue
                            yield typing.cast(
                                GenerateStreamResponse,
                                parse_obj_as(
                                    type_=GenerateStreamResponse,  # type: ignore
                                    object_=json.loads(_text),
                                ),
                            )
                        except Exception:
                            pass
                    return
                _response.read()
                if _response.status_code == 400:
                    raise BadRequestError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 403:
                    raise ForbiddenError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 404:
                    raise NotFoundError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 500:
                    raise InternalServerError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    def search(
        self,
        *,
        query: str,
        index_id: typing.Optional[str] = OMIT,
        index_name: typing.Optional[str] = OMIT,
        options: typing.Optional[SearchRequestOptionsRequest] = OMIT,
        document_index: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Perform a search against a document index.

        Parameters
        ----------
        query : str
            The query to search for.

        index_id : typing.Optional[str]
            The ID of the index to search against. Must provide either this, index_name or document_index.

        index_name : typing.Optional[str]
            The name of the index to search against. Must provide either this, index_id or document_index.

        options : typing.Optional[SearchRequestOptionsRequest]
            Configuration options for the search.

        document_index : typing.Optional[str]
            Either the index name or index ID to search against. Must provide either this, index_id or index_name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.search(
            query="x",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/search",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "index_id": index_id,
                "index_name": index_name,
                "query": query,
                "options": convert_and_respect_annotation_metadata(
                    object_=options, annotation=typing.Optional[SearchRequestOptionsRequest], direction="write"
                ),
                "document_index": document_index,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SearchResponse,
                    parse_obj_as(
                        type_=SearchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def submit_completion_actuals(
        self,
        *,
        actuals: typing.Sequence[SubmitCompletionActualRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Used to submit feedback regarding the quality of previously generated completions.

        Parameters
        ----------
        actuals : typing.Sequence[SubmitCompletionActualRequest]
            Feedback regarding the quality of previously generated completions

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from vellum import SubmitCompletionActualRequest, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.submit_completion_actuals(
            actuals=[SubmitCompletionActualRequest(), SubmitCompletionActualRequest()],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/submit-completion-actuals",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "deployment_id": deployment_id,
                "deployment_name": deployment_name,
                "actuals": convert_and_respect_annotation_metadata(
                    object_=actuals, annotation=typing.Sequence[SubmitCompletionActualRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def submit_workflow_execution_actuals(
        self,
        *,
        actuals: typing.Sequence[SubmitWorkflowExecutionActualRequest],
        execution_id: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
            Used to submit feedback regarding the quality of previous workflow execution and its outputs.

            **Note:** Uses a base url of `https://predict.vellum.ai`.

        Parameters
        ----------
        actuals : typing.Sequence[SubmitWorkflowExecutionActualRequest]
            Feedback regarding the quality of an output on a previously executed workflow.

        execution_id : typing.Optional[str]
            The Vellum-generated ID of a previously executed workflow. Must provide either this or external_id.

        external_id : typing.Optional[str]
            The external ID that was originally provided by when executing the workflow, if applicable, that you'd now like to submit actuals for. Must provide either this or execution_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from vellum import Vellum, WorkflowExecutionActualStringRequest

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.submit_workflow_execution_actuals(
            actuals=[
                WorkflowExecutionActualStringRequest(),
                WorkflowExecutionActualStringRequest(),
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/submit-workflow-execution-actuals",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "actuals": convert_and_respect_annotation_metadata(
                    object_=actuals, annotation=typing.Sequence[SubmitWorkflowExecutionActualRequest], direction="write"
                ),
                "execution_id": execution_id,
                "external_id": external_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncVellum:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : VellumEnvironment
        The environment to use for requests from the client. from .environment import VellumEnvironment



        Defaults to VellumEnvironment.PRODUCTION



    api_version : typing.Optional[ApiVersionEnum]
    api_key : str
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default there is no timeout set, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from vellum import AsyncVellum

    client = AsyncVellum(
        api_version="YOUR_API_VERSION",
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: VellumEnvironment = VellumEnvironment.PRODUCTION,
        api_version: typing.Optional[ApiVersionEnum] = os.getenv("VELLUM_API_VERSION", "2025-07-30"),
        api_key: str,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else None if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            environment=environment,
            api_version=api_version,
            api_key=api_key,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.ad_hoc = AsyncAdHocClient(client_wrapper=self._client_wrapper)
        self.container_images = AsyncContainerImagesClient(client_wrapper=self._client_wrapper)
        self.deployments = AsyncDeploymentsClient(client_wrapper=self._client_wrapper)
        self.document_indexes = AsyncDocumentIndexesClient(client_wrapper=self._client_wrapper)
        self.documents = AsyncDocumentsClient(client_wrapper=self._client_wrapper)
        self.folder_entities = AsyncFolderEntitiesClient(client_wrapper=self._client_wrapper)
        self.metric_definitions = AsyncMetricDefinitionsClient(client_wrapper=self._client_wrapper)
        self.ml_models = AsyncMlModelsClient(client_wrapper=self._client_wrapper)
        self.organizations = AsyncOrganizationsClient(client_wrapper=self._client_wrapper)
        self.prompts = AsyncPromptsClient(client_wrapper=self._client_wrapper)
        self.sandboxes = AsyncSandboxesClient(client_wrapper=self._client_wrapper)
        self.test_suite_runs = AsyncTestSuiteRunsClient(client_wrapper=self._client_wrapper)
        self.test_suites = AsyncTestSuitesClient(client_wrapper=self._client_wrapper)
        self.workflow_deployments = AsyncWorkflowDeploymentsClient(client_wrapper=self._client_wrapper)
        self.release_reviews = AsyncReleaseReviewsClient(client_wrapper=self._client_wrapper)
        self.workflow_executions = AsyncWorkflowExecutionsClient(client_wrapper=self._client_wrapper)
        self.workflow_sandboxes = AsyncWorkflowSandboxesClient(client_wrapper=self._client_wrapper)
        self.workflows = AsyncWorkflowsClient(client_wrapper=self._client_wrapper)
        self.workspace_secrets = AsyncWorkspaceSecretsClient(client_wrapper=self._client_wrapper)
        self.workspaces = AsyncWorkspacesClient(client_wrapper=self._client_wrapper)

    async def execute_api(
        self,
        *,
        url: str,
        method: typing.Optional[MethodEnum] = OMIT,
        body: typing.Optional[ExecuteApiRequestBody] = OMIT,
        headers: typing.Optional[typing.Dict[str, ExecuteApiRequestHeadersValue]] = OMIT,
        bearer_token: typing.Optional[ExecuteApiRequestBearerToken] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecuteApiResponse:
        """
        Parameters
        ----------
        url : str

        method : typing.Optional[MethodEnum]

        body : typing.Optional[ExecuteApiRequestBody]

        headers : typing.Optional[typing.Dict[str, ExecuteApiRequestHeadersValue]]

        bearer_token : typing.Optional[ExecuteApiRequestBearerToken]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecuteApiResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.execute_api(
                url="x",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/execute-api",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "url": url,
                "method": method,
                "body": convert_and_respect_annotation_metadata(
                    object_=body, annotation=typing.Optional[ExecuteApiRequestBody], direction="write"
                ),
                "headers": convert_and_respect_annotation_metadata(
                    object_=headers, annotation=typing.Dict[str, ExecuteApiRequestHeadersValue], direction="write"
                ),
                "bearer_token": convert_and_respect_annotation_metadata(
                    object_=bearer_token, annotation=typing.Optional[ExecuteApiRequestBearerToken], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ExecuteApiResponse,
                    parse_obj_as(
                        type_=ExecuteApiResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def execute_code(
        self,
        *,
        code: str,
        runtime: CodeExecutionRuntime,
        input_values: typing.Sequence[CodeExecutorInput],
        packages: typing.Sequence[CodeExecutionPackage],
        output_type: VellumVariableType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CodeExecutorResponse:
        """
        Parameters
        ----------
        code : str

        runtime : CodeExecutionRuntime

        input_values : typing.Sequence[CodeExecutorInput]

        packages : typing.Sequence[CodeExecutionPackage]

        output_type : VellumVariableType

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CodeExecutorResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, CodeExecutionPackage, StringInput

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.execute_code(
                code="x",
                runtime="PYTHON_3_11_6",
                input_values=[
                    StringInput(
                        name="x",
                        value="value",
                    ),
                    StringInput(
                        name="x",
                        value="value",
                    ),
                ],
                packages=[
                    CodeExecutionPackage(
                        version="version",
                        name="name",
                    ),
                    CodeExecutionPackage(
                        version="version",
                        name="name",
                    ),
                ],
                output_type="STRING",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/execute-code",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "code": code,
                "runtime": runtime,
                "input_values": convert_and_respect_annotation_metadata(
                    object_=input_values, annotation=typing.Sequence[CodeExecutorInput], direction="write"
                ),
                "packages": convert_and_respect_annotation_metadata(
                    object_=packages, annotation=typing.Sequence[CodeExecutionPackage], direction="write"
                ),
                "output_type": output_type,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CodeExecutorResponse,
                    parse_obj_as(
                        type_=CodeExecutorResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def execute_prompt(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        prompt_deployment_id: typing.Optional[str] = OMIT,
        prompt_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[PromptDeploymentExpandMetaRequest] = OMIT,
        raw_overrides: typing.Optional[RawPromptExecutionOverridesRequest] = OMIT,
        expand_raw: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecutePromptResponse:
        """
        Executes a deployed Prompt and returns the result.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            A list consisting of the Prompt Deployment's input variables and their values.

        prompt_deployment_id : typing.Optional[str]
            The ID of the Prompt Deployment. Must provide either this or prompt_deployment_name.

        prompt_deployment_name : typing.Optional[str]
            The unique name of the Prompt Deployment. Must provide either this or prompt_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Prompt Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        expand_meta : typing.Optional[PromptDeploymentExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this prompt execution in the API response. Corresponding values will be returned under the `meta` key of the API response.

        raw_overrides : typing.Optional[RawPromptExecutionOverridesRequest]
            Overrides for the raw API request sent to the model host. Combined with `expand_raw`, it can be used to access new features from models.

        expand_raw : typing.Optional[typing.Sequence[str]]
            A list of keys whose values you'd like to directly return from the JSON response of the model provider. Useful if you need lower-level info returned by model providers that Vellum would otherwise omit. Corresponding key/value pairs will be returned under the `raw` key of the API response.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecutePromptResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, StringInputRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.execute_prompt(
                inputs=[
                    StringInputRequest(
                        name="x",
                        value="value",
                    ),
                    StringInputRequest(
                        name="x",
                        value="value",
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/execute-prompt",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[PromptDeploymentInputRequest], direction="write"
                ),
                "prompt_deployment_id": prompt_deployment_id,
                "prompt_deployment_name": prompt_deployment_name,
                "release_tag": release_tag,
                "external_id": external_id,
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta,
                    annotation=typing.Optional[PromptDeploymentExpandMetaRequest],
                    direction="write",
                ),
                "raw_overrides": convert_and_respect_annotation_metadata(
                    object_=raw_overrides,
                    annotation=typing.Optional[RawPromptExecutionOverridesRequest],
                    direction="write",
                ),
                "expand_raw": expand_raw,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ExecutePromptResponse,
                    parse_obj_as(
                        type_=ExecutePromptResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def execute_prompt_stream(
        self,
        *,
        inputs: typing.Sequence[PromptDeploymentInputRequest],
        prompt_deployment_id: typing.Optional[str] = OMIT,
        prompt_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        expand_meta: typing.Optional[PromptDeploymentExpandMetaRequest] = OMIT,
        raw_overrides: typing.Optional[RawPromptExecutionOverridesRequest] = OMIT,
        expand_raw: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[ExecutePromptEvent]:
        """
        Executes a deployed Prompt and streams back the results.

        Parameters
        ----------
        inputs : typing.Sequence[PromptDeploymentInputRequest]
            A list consisting of the Prompt Deployment's input variables and their values.

        prompt_deployment_id : typing.Optional[str]
            The ID of the Prompt Deployment. Must provide either this or prompt_deployment_name.

        prompt_deployment_name : typing.Optional[str]
            The unique name of the Prompt Deployment. Must provide either this or prompt_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Prompt Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        expand_meta : typing.Optional[PromptDeploymentExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this prompt execution in the API response. Corresponding values will be returned under the `meta` key of the API response.

        raw_overrides : typing.Optional[RawPromptExecutionOverridesRequest]
            Overrides for the raw API request sent to the model host. Combined with `expand_raw`, it can be used to access new features from models.

        expand_raw : typing.Optional[typing.Sequence[str]]
            A list of keys whose values you'd like to directly return from the JSON response of the model provider. Useful if you need lower-level info returned by model providers that Vellum would otherwise omit. Corresponding key/value pairs will be returned under the `raw` key of the API response.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[ExecutePromptEvent]


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, StringInputRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.execute_prompt_stream(
                inputs=[
                    StringInputRequest(
                        name="x",
                        value="value",
                    ),
                    StringInputRequest(
                        name="x",
                        value="value",
                    ),
                ],
            )
            async for chunk in response:
                yield chunk


        asyncio.run(main())
        """
        async with self._client_wrapper.httpx_client.stream(
            "v1/execute-prompt-stream",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[PromptDeploymentInputRequest], direction="write"
                ),
                "prompt_deployment_id": prompt_deployment_id,
                "prompt_deployment_name": prompt_deployment_name,
                "release_tag": release_tag,
                "external_id": external_id,
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta,
                    annotation=typing.Optional[PromptDeploymentExpandMetaRequest],
                    direction="write",
                ),
                "raw_overrides": convert_and_respect_annotation_metadata(
                    object_=raw_overrides,
                    annotation=typing.Optional[RawPromptExecutionOverridesRequest],
                    direction="write",
                ),
                "expand_raw": expand_raw,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    async for _text in _response.aiter_lines():
                        try:
                            if len(_text) == 0:
                                continue
                            yield typing.cast(
                                ExecutePromptEvent,
                                parse_obj_as(
                                    type_=ExecutePromptEvent,  # type: ignore
                                    object_=json.loads(_text),
                                ),
                            )
                        except Exception:
                            pass
                    return
                await _response.aread()
                if _response.status_code == 400:
                    raise BadRequestError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 403:
                    raise ForbiddenError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 404:
                    raise NotFoundError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 500:
                    raise InternalServerError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    async def execute_workflow(
        self,
        *,
        inputs: typing.Sequence[WorkflowRequestInputRequest],
        expand_meta: typing.Optional[WorkflowExpandMetaRequest] = OMIT,
        workflow_deployment_id: typing.Optional[str] = OMIT,
        workflow_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExecuteWorkflowResponse:
        """
        Executes a deployed Workflow and returns its outputs.

        Parameters
        ----------
        inputs : typing.Sequence[WorkflowRequestInputRequest]
            The list of inputs defined in the Workflow's Deployment with their corresponding values.

        expand_meta : typing.Optional[WorkflowExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this workflow execution in the API response. Corresponding values will be returned under the `execution_meta` key within NODE events in the response stream.

        workflow_deployment_id : typing.Optional[str]
            The ID of the Workflow Deployment. Must provide either this or workflow_deployment_name.

        workflow_deployment_name : typing.Optional[str]
            The name of the Workflow Deployment. Must provide either this or workflow_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExecuteWorkflowResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, WorkflowRequestStringInputRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.execute_workflow(
                inputs=[
                    WorkflowRequestStringInputRequest(
                        name="x",
                        value="value",
                    ),
                    WorkflowRequestStringInputRequest(
                        name="x",
                        value="value",
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/execute-workflow",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[WorkflowRequestInputRequest], direction="write"
                ),
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta, annotation=typing.Optional[WorkflowExpandMetaRequest], direction="write"
                ),
                "workflow_deployment_id": workflow_deployment_id,
                "workflow_deployment_name": workflow_deployment_name,
                "release_tag": release_tag,
                "external_id": external_id,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ExecuteWorkflowResponse,
                    parse_obj_as(
                        type_=ExecuteWorkflowResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def execute_workflow_stream(
        self,
        *,
        inputs: typing.Sequence[WorkflowRequestInputRequest],
        expand_meta: typing.Optional[WorkflowExpandMetaRequest] = OMIT,
        workflow_deployment_id: typing.Optional[str] = OMIT,
        workflow_deployment_name: typing.Optional[str] = OMIT,
        release_tag: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        event_types: typing.Optional[typing.Sequence[WorkflowExecutionEventType]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[WorkflowStreamEvent]:
        """
        Executes a deployed Workflow and streams back its results.

        Parameters
        ----------
        inputs : typing.Sequence[WorkflowRequestInputRequest]
            The list of inputs defined in the Workflow's Deployment with their corresponding values.

        expand_meta : typing.Optional[WorkflowExpandMetaRequest]
            An optionally specified configuration used to opt in to including additional metadata about this workflow execution in the API response. Corresponding values will be returned under the `execution_meta` key within NODE events in the response stream.

        workflow_deployment_id : typing.Optional[str]
            The ID of the Workflow Deployment. Must provide either this or workflow_deployment_name.

        workflow_deployment_name : typing.Optional[str]
            The name of the Workflow Deployment. Must provide either this or workflow_deployment_id.

        release_tag : typing.Optional[str]
            Optionally specify a release tag if you want to pin to a specific release of the Workflow Deployment

        external_id : typing.Optional[str]
            Optionally include a unique identifier for tracking purposes. Must be unique within a given Workspace.

        event_types : typing.Optional[typing.Sequence[WorkflowExecutionEventType]]
            Optionally specify which events you want to receive. Defaults to only WORKFLOW events. Note that the schema of non-WORKFLOW events is unstable and should be used with caution.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Arbitrary JSON metadata associated with this request. Can be used to capture additional monitoring data such as user id, session id, etc. for future analysis.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[WorkflowStreamEvent]


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, WorkflowRequestStringInputRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.execute_workflow_stream(
                inputs=[
                    WorkflowRequestStringInputRequest(
                        name="x",
                        value="value",
                    ),
                    WorkflowRequestStringInputRequest(
                        name="x",
                        value="value",
                    ),
                ],
            )
            async for chunk in response:
                yield chunk


        asyncio.run(main())
        """
        async with self._client_wrapper.httpx_client.stream(
            "v1/execute-workflow-stream",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[WorkflowRequestInputRequest], direction="write"
                ),
                "expand_meta": convert_and_respect_annotation_metadata(
                    object_=expand_meta, annotation=typing.Optional[WorkflowExpandMetaRequest], direction="write"
                ),
                "workflow_deployment_id": workflow_deployment_id,
                "workflow_deployment_name": workflow_deployment_name,
                "release_tag": release_tag,
                "external_id": external_id,
                "event_types": event_types,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    async for _text in _response.aiter_lines():
                        try:
                            if len(_text) == 0:
                                continue
                            yield typing.cast(
                                WorkflowStreamEvent,
                                parse_obj_as(
                                    type_=WorkflowStreamEvent,  # type: ignore
                                    object_=json.loads(_text),
                                ),
                            )
                        except Exception:
                            pass
                    return
                await _response.aread()
                if _response.status_code == 400:
                    raise BadRequestError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 404:
                    raise NotFoundError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 500:
                    raise InternalServerError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    async def generate(
        self,
        *,
        requests: typing.Sequence[GenerateRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        options: typing.Optional[GenerateOptionsRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateResponse:
        """
        Generate a completion using a previously defined deployment.

        Important: This endpoint is DEPRECATED and has been superseded by
        [execute-prompt](/api-reference/api-reference/execute-prompt).

        Parameters
        ----------
        requests : typing.Sequence[GenerateRequest]
            The generation request to make. Bulk requests are no longer supported, this field must be an array of length 1.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        options : typing.Optional[GenerateOptionsRequest]
            Additional configuration that can be used to control what's included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, GenerateRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.generate(
                requests=[
                    GenerateRequest(
                        input_values={"input_values": {"key": "value"}},
                    ),
                    GenerateRequest(
                        input_values={"input_values": {"key": "value"}},
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/generate",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "deployment_id": deployment_id,
                "deployment_name": deployment_name,
                "requests": convert_and_respect_annotation_metadata(
                    object_=requests, annotation=typing.Sequence[GenerateRequest], direction="write"
                ),
                "options": convert_and_respect_annotation_metadata(
                    object_=options, annotation=typing.Optional[GenerateOptionsRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GenerateResponse,
                    parse_obj_as(
                        type_=GenerateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def generate_stream(
        self,
        *,
        requests: typing.Sequence[GenerateRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        options: typing.Optional[GenerateOptionsRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[GenerateStreamResponse]:
        """
        Generate a stream of completions using a previously defined deployment.

        Important: This endpoint is DEPRECATED and has been superseded by
        [execute-prompt-stream](/api-reference/api-reference/execute-prompt-stream).

        Parameters
        ----------
        requests : typing.Sequence[GenerateRequest]
            The generation request to make. Bulk requests are no longer supported, this field must be an array of length 1.

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        options : typing.Optional[GenerateOptionsRequest]
            Additional configuration that can be used to control what's included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[GenerateStreamResponse]


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, GenerateRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.generate_stream(
                requests=[
                    GenerateRequest(
                        input_values={"input_values": {"key": "value"}},
                    ),
                    GenerateRequest(
                        input_values={"input_values": {"key": "value"}},
                    ),
                ],
            )
            async for chunk in response:
                yield chunk


        asyncio.run(main())
        """
        async with self._client_wrapper.httpx_client.stream(
            "v1/generate-stream",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "deployment_id": deployment_id,
                "deployment_name": deployment_name,
                "requests": convert_and_respect_annotation_metadata(
                    object_=requests, annotation=typing.Sequence[GenerateRequest], direction="write"
                ),
                "options": convert_and_respect_annotation_metadata(
                    object_=options, annotation=typing.Optional[GenerateOptionsRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        ) as _response:
            try:
                if 200 <= _response.status_code < 300:
                    async for _text in _response.aiter_lines():
                        try:
                            if len(_text) == 0:
                                continue
                            yield typing.cast(
                                GenerateStreamResponse,
                                parse_obj_as(
                                    type_=GenerateStreamResponse,  # type: ignore
                                    object_=json.loads(_text),
                                ),
                            )
                        except Exception:
                            pass
                    return
                await _response.aread()
                if _response.status_code == 400:
                    raise BadRequestError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 403:
                    raise ForbiddenError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 404:
                    raise NotFoundError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                if _response.status_code == 500:
                    raise InternalServerError(
                        typing.cast(
                            typing.Optional[typing.Any],
                            parse_obj_as(
                                type_=typing.Optional[typing.Any],  # type: ignore
                                object_=_response.json(),
                            ),
                        )
                    )
                _response_json = _response.json()
            except JSONDecodeError:
                raise ApiError(status_code=_response.status_code, body=_response.text)
            raise ApiError(status_code=_response.status_code, body=_response_json)

    async def search(
        self,
        *,
        query: str,
        index_id: typing.Optional[str] = OMIT,
        index_name: typing.Optional[str] = OMIT,
        options: typing.Optional[SearchRequestOptionsRequest] = OMIT,
        document_index: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SearchResponse:
        """
        Perform a search against a document index.

        Parameters
        ----------
        query : str
            The query to search for.

        index_id : typing.Optional[str]
            The ID of the index to search against. Must provide either this, index_name or document_index.

        index_name : typing.Optional[str]
            The name of the index to search against. Must provide either this, index_id or document_index.

        options : typing.Optional[SearchRequestOptionsRequest]
            Configuration options for the search.

        document_index : typing.Optional[str]
            Either the index name or index ID to search against. Must provide either this, index_id or index_name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.search(
                query="x",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/search",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "index_id": index_id,
                "index_name": index_name,
                "query": query,
                "options": convert_and_respect_annotation_metadata(
                    object_=options, annotation=typing.Optional[SearchRequestOptionsRequest], direction="write"
                ),
                "document_index": document_index,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    SearchResponse,
                    parse_obj_as(
                        type_=SearchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def submit_completion_actuals(
        self,
        *,
        actuals: typing.Sequence[SubmitCompletionActualRequest],
        deployment_id: typing.Optional[str] = OMIT,
        deployment_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Used to submit feedback regarding the quality of previously generated completions.

        Parameters
        ----------
        actuals : typing.Sequence[SubmitCompletionActualRequest]
            Feedback regarding the quality of previously generated completions

        deployment_id : typing.Optional[str]
            The ID of the deployment. Must provide either this or deployment_name.

        deployment_name : typing.Optional[str]
            The name of the deployment. Must provide either this or deployment_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, SubmitCompletionActualRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.submit_completion_actuals(
                actuals=[
                    SubmitCompletionActualRequest(),
                    SubmitCompletionActualRequest(),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/submit-completion-actuals",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "deployment_id": deployment_id,
                "deployment_name": deployment_name,
                "actuals": convert_and_respect_annotation_metadata(
                    object_=actuals, annotation=typing.Sequence[SubmitCompletionActualRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def submit_workflow_execution_actuals(
        self,
        *,
        actuals: typing.Sequence[SubmitWorkflowExecutionActualRequest],
        execution_id: typing.Optional[str] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
            Used to submit feedback regarding the quality of previous workflow execution and its outputs.

            **Note:** Uses a base url of `https://predict.vellum.ai`.

        Parameters
        ----------
        actuals : typing.Sequence[SubmitWorkflowExecutionActualRequest]
            Feedback regarding the quality of an output on a previously executed workflow.

        execution_id : typing.Optional[str]
            The Vellum-generated ID of a previously executed workflow. Must provide either this or external_id.

        external_id : typing.Optional[str]
            The external ID that was originally provided by when executing the workflow, if applicable, that you'd now like to submit actuals for. Must provide either this or execution_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, WorkflowExecutionActualStringRequest

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.submit_workflow_execution_actuals(
                actuals=[
                    WorkflowExecutionActualStringRequest(),
                    WorkflowExecutionActualStringRequest(),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/submit-workflow-execution-actuals",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "actuals": convert_and_respect_annotation_metadata(
                    object_=actuals, annotation=typing.Sequence[SubmitWorkflowExecutionActualRequest], direction="write"
                ),
                "execution_id": execution_id,
                "external_id": external_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
