# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from ...types.metric_definition_input import MetricDefinitionInput
from ...core.request_options import RequestOptions
from ...types.metric_definition_execution import MetricDefinitionExecution
from ...core.jsonable_encoder import jsonable_encoder
from ...core.serialization import convert_and_respect_annotation_metadata
from ...core.pydantic_utilities import parse_obj_as
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from ...types.metric_definition_history_item import MetricDefinitionHistoryItem
from ...core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MetricDefinitionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def execute_metric_definition(
        self,
        id: str,
        *,
        inputs: typing.Sequence[MetricDefinitionInput],
        release_tag: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MetricDefinitionExecution:
        """
        Parameters
        ----------
        id : str
            Either the Metric Definition's ID or its unique name

        inputs : typing.Sequence[MetricDefinitionInput]

        release_tag : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricDefinitionExecution


        Examples
        --------
        from vellum import StringInput, Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.metric_definitions.execute_metric_definition(
            id="id",
            inputs=[
                StringInput(
                    name="x",
                    value="value",
                ),
                StringInput(
                    name="x",
                    value="value",
                ),
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/metric-definitions/{jsonable_encoder(id)}/execute",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[MetricDefinitionInput], direction="write"
                ),
                "release_tag": release_tag,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    MetricDefinitionExecution,
                    parse_obj_as(
                        type_=MetricDefinitionExecution,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def metric_definition_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MetricDefinitionHistoryItem:
        """
        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Metric Definition History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Metric Definition History Item you'd like to retrieve.

        id : str
            A UUID string identifying this metric definition.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricDefinitionHistoryItem


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.metric_definitions.metric_definition_history_item_retrieve(
            history_id_or_release_tag="history_id_or_release_tag",
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/metric-definitions/{jsonable_encoder(id)}/history/{jsonable_encoder(history_id_or_release_tag)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    MetricDefinitionHistoryItem,
                    parse_obj_as(
                        type_=MetricDefinitionHistoryItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncMetricDefinitionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def execute_metric_definition(
        self,
        id: str,
        *,
        inputs: typing.Sequence[MetricDefinitionInput],
        release_tag: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> MetricDefinitionExecution:
        """
        Parameters
        ----------
        id : str
            Either the Metric Definition's ID or its unique name

        inputs : typing.Sequence[MetricDefinitionInput]

        release_tag : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricDefinitionExecution


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum, StringInput

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.metric_definitions.execute_metric_definition(
                id="id",
                inputs=[
                    StringInput(
                        name="x",
                        value="value",
                    ),
                    StringInput(
                        name="x",
                        value="value",
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/metric-definitions/{jsonable_encoder(id)}/execute",
            base_url=self._client_wrapper.get_environment().predict,
            method="POST",
            json={
                "inputs": convert_and_respect_annotation_metadata(
                    object_=inputs, annotation=typing.Sequence[MetricDefinitionInput], direction="write"
                ),
                "release_tag": release_tag,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    MetricDefinitionExecution,
                    parse_obj_as(
                        type_=MetricDefinitionExecution,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def metric_definition_history_item_retrieve(
        self, history_id_or_release_tag: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MetricDefinitionHistoryItem:
        """
        Parameters
        ----------
        history_id_or_release_tag : str
            Either the UUID of Metric Definition History Item you'd like to retrieve, or the name of a Release Tag that's pointing to the Metric Definition History Item you'd like to retrieve.

        id : str
            A UUID string identifying this metric definition.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricDefinitionHistoryItem


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.metric_definitions.metric_definition_history_item_retrieve(
                history_id_or_release_tag="history_id_or_release_tag",
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/metric-definitions/{jsonable_encoder(id)}/history/{jsonable_encoder(history_id_or_release_tag)}",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    MetricDefinitionHistoryItem,
                    parse_obj_as(
                        type_=MetricDefinitionHistoryItem,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
