# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.prompt_exec_config import PromptExecConfig
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...errors.bad_request_error import BadRequestError
from ...errors.not_found_error import NotFoundError
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from ...types.prompt_push_response import PromptPushResponse
from ...core.serialization import convert_and_respect_annotation_metadata
from ...core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PromptsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def pull(
        self,
        id: str,
        *,
        prompt_variant_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptExecConfig:
        """
        Used to pull the definition of a Prompt from Vellum.

        Parameters
        ----------
        id : str
            The ID of the Prompt to pull from. Prompt Sandbox IDs are currently supported.

        prompt_variant_id : typing.Optional[str]
            The ID of the Prompt Variant within a Prompt Sandbox to pull. Must be included if providing the ID of a Prompt Sandbox.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptExecConfig


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.prompts.pull(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/prompts/{jsonable_encoder(id)}/pull",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "prompt_variant_id": prompt_variant_id,
            },
            headers={
                "Accept": "application/json",
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PromptExecConfig,
                    parse_obj_as(
                        type_=PromptExecConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def push(
        self,
        *,
        exec_config: PromptExecConfig,
        prompt_variant_id: typing.Optional[str] = OMIT,
        prompt_variant_label: typing.Optional[str] = OMIT,
        prompt_sandbox_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptPushResponse:
        """
        Used to push updates to a Prompt in Vellum.

        Parameters
        ----------
        exec_config : PromptExecConfig

        prompt_variant_id : typing.Optional[str]
            If specified, an existing Prompt Variant by the provided ID will be updated. Otherwise, a new Prompt Variant will be created and an ID generated.

        prompt_variant_label : typing.Optional[str]
            If provided, then the created/updated Prompt Variant will have this label.

        prompt_sandbox_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptPushResponse


        Examples
        --------
        from vellum import (
            JinjaPromptBlock,
            PromptExecConfig,
            PromptParameters,
            Vellum,
            VellumVariable,
        )

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.prompts.push(
            exec_config=PromptExecConfig(
                ml_model="ml_model",
                input_variables=[
                    VellumVariable(
                        id="x",
                        key="key",
                        type="STRING",
                    ),
                    VellumVariable(
                        id="x",
                        key="key",
                        type="STRING",
                    ),
                ],
                parameters=PromptParameters(),
                blocks=[
                    JinjaPromptBlock(
                        template="template",
                    ),
                    JinjaPromptBlock(
                        template="template",
                    ),
                ],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/prompts/push",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "prompt_variant_id": prompt_variant_id,
                "prompt_variant_label": prompt_variant_label,
                "prompt_sandbox_id": prompt_sandbox_id,
                "exec_config": convert_and_respect_annotation_metadata(
                    object_=exec_config, annotation=PromptExecConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PromptPushResponse,
                    parse_obj_as(
                        type_=PromptPushResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncPromptsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def pull(
        self,
        id: str,
        *,
        prompt_variant_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptExecConfig:
        """
        Used to pull the definition of a Prompt from Vellum.

        Parameters
        ----------
        id : str
            The ID of the Prompt to pull from. Prompt Sandbox IDs are currently supported.

        prompt_variant_id : typing.Optional[str]
            The ID of the Prompt Variant within a Prompt Sandbox to pull. Must be included if providing the ID of a Prompt Sandbox.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptExecConfig


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.prompts.pull(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/prompts/{jsonable_encoder(id)}/pull",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            params={
                "prompt_variant_id": prompt_variant_id,
            },
            headers={
                "Accept": "application/json",
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PromptExecConfig,
                    parse_obj_as(
                        type_=PromptExecConfig,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def push(
        self,
        *,
        exec_config: PromptExecConfig,
        prompt_variant_id: typing.Optional[str] = OMIT,
        prompt_variant_label: typing.Optional[str] = OMIT,
        prompt_sandbox_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PromptPushResponse:
        """
        Used to push updates to a Prompt in Vellum.

        Parameters
        ----------
        exec_config : PromptExecConfig

        prompt_variant_id : typing.Optional[str]
            If specified, an existing Prompt Variant by the provided ID will be updated. Otherwise, a new Prompt Variant will be created and an ID generated.

        prompt_variant_label : typing.Optional[str]
            If provided, then the created/updated Prompt Variant will have this label.

        prompt_sandbox_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptPushResponse


        Examples
        --------
        import asyncio

        from vellum import (
            AsyncVellum,
            JinjaPromptBlock,
            PromptExecConfig,
            PromptParameters,
            VellumVariable,
        )

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.prompts.push(
                exec_config=PromptExecConfig(
                    ml_model="ml_model",
                    input_variables=[
                        VellumVariable(
                            id="x",
                            key="key",
                            type="STRING",
                        ),
                        VellumVariable(
                            id="x",
                            key="key",
                            type="STRING",
                        ),
                    ],
                    parameters=PromptParameters(),
                    blocks=[
                        JinjaPromptBlock(
                            template="template",
                        ),
                        JinjaPromptBlock(
                            template="template",
                        ),
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/prompts/push",
            base_url=self._client_wrapper.get_environment().default,
            method="POST",
            json={
                "prompt_variant_id": prompt_variant_id,
                "prompt_variant_label": prompt_variant_label,
                "prompt_sandbox_id": prompt_sandbox_id,
                "exec_config": convert_and_respect_annotation_metadata(
                    object_=exec_config, annotation=PromptExecConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    PromptPushResponse,
                    parse_obj_as(
                        type_=PromptPushResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
