# This file was auto-generated by Fern from our API Definition.

from ...core.client_wrapper import SyncClientWrapper
import typing
from ...core.request_options import RequestOptions
from ...types.workflow_execution_detail import WorkflowExecutionDetail
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper


class WorkflowExecutionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def retrieve_workflow_execution_detail(
        self, execution_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowExecutionDetail:
        """
        Parameters
        ----------
        execution_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowExecutionDetail


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.workflow_executions.retrieve_workflow_execution_detail(
            execution_id="execution_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/workflow-executions/{jsonable_encoder(execution_id)}/detail",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    WorkflowExecutionDetail,
                    parse_obj_as(
                        type_=WorkflowExecutionDetail,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncWorkflowExecutionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def retrieve_workflow_execution_detail(
        self, execution_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowExecutionDetail:
        """
        Parameters
        ----------
        execution_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowExecutionDetail


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.workflow_executions.retrieve_workflow_execution_detail(
                execution_id="execution_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/workflow-executions/{jsonable_encoder(execution_id)}/detail",
            base_url=self._client_wrapper.get_environment().default,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    WorkflowExecutionDetail,
                    parse_obj_as(
                        type_=WorkflowExecutionDetail,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
