# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ..core.pydantic_utilities import UniversalBaseModel
import typing
from .prompt_block_state import PromptBlockState
from .ephemeral_prompt_cache_config import EphemeralPromptCacheConfig
from .chat_message_role import ChatMessageRole
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic
from ..core.pydantic_utilities import update_forward_refs


class ChatMessagePromptBlock(UniversalBaseModel):
    """
    A block that represents a chat message in a prompt template.
    """

    block_type: typing.Literal["CHAT_MESSAGE"] = "CHAT_MESSAGE"
    state: typing.Optional[PromptBlockState] = None
    cache_config: typing.Optional[EphemeralPromptCacheConfig] = None
    chat_role: ChatMessageRole
    chat_source: typing.Optional[str] = None
    chat_message_unterminated: typing.Optional[bool] = None
    blocks: typing.List["PromptBlock"]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .prompt_block import PromptBlock  # noqa: E402

update_forward_refs(ChatMessagePromptBlock)
