# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class CodeResourceDefinition(UniversalBaseModel):
    """
    The definition of a resource defined in code.
    """

    name: str = pydantic.Field()
    """
    The name of the resource, typically a class name.
    """

    module: typing.List[str] = pydantic.Field()
    """
    The module that this resource is defined in.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
