# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
import datetime as dt
from .document_processing_state import DocumentProcessingState
from .processing_failure_reason_enum import ProcessingFailureReasonEnum
from .document_status import DocumentStatus
from .slim_document_document_to_document_index import SlimDocumentDocumentToDocumentIndex
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class SlimDocument(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Vellum-generated ID that uniquely identifies this document.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The external ID that was originally provided when uploading the document.
    """

    last_uploaded_at: dt.datetime = pydantic.Field()
    """
    A timestamp representing when this document was most recently uploaded.
    """

    label: str = pydantic.Field()
    """
    Human-friendly name for this document.
    """

    processing_state: DocumentProcessingState
    processing_failure_reason: typing.Optional[ProcessingFailureReasonEnum] = pydantic.Field(default=None)
    """
    An enum value representing why the document could not be processed. Is null unless processing_state is FAILED.
    
    * `EXCEEDED_CHARACTER_LIMIT` - Exceeded Character Limit
    * `INVALID_FILE` - Invalid File
    """

    status: typing.Optional[DocumentStatus] = pydantic.Field(default=None)
    """
    The document's current status.
    
    * `ACTIVE` - Active
    """

    keywords: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of keywords associated with this document. Originally provided when uploading the document.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    A previously supplied JSON object containing metadata that can be filtered on when searching.
    """

    document_to_document_indexes: typing.List[SlimDocumentDocumentToDocumentIndex]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
