# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
import datetime as dt
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class SubmitCompletionActualRequest(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Vellum-generated ID of a previously generated completion. Must provide either this or external_id.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The external ID that was originally provided when generating the completion that you'd now like to submit actuals for. Must provide either this or id.
    """

    text: typing.Optional[str] = pydantic.Field(default=None)
    """
    Text representing what the completion _should_ have been.
    """

    quality: typing.Optional[float] = pydantic.Field(default=None)
    """
    A number between 0 and 1 representing the quality of the completion. 0 is the worst, 1 is the best.
    """

    timestamp: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Optionally provide the timestamp representing when this feedback was collected. Used for reporting purposes.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Optionally provide additional metadata about the feedback submission.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
