# Code generated by protoc-gen-meshpy. DO NOT EDIT.
# source: meshtrade/compliance/client/v1/service.proto

"""
ClientService gRPC service wrapper with authentication, timeouts, and resource management.

This module provides a high-level gRPC service for the ClientService service that combines
the service interface with resource management capabilities, providing authentication,
timeouts, and proper connection handling.
"""

from datetime import timedelta
from typing import Optional

from meshtrade.common import BaseGRPCClient
from meshtrade.iam.api_user.v1.api_credentials import find_credentials

from .client_pb2 import Client
from meshtrade.common.service_options import ServiceOptions
from .service_pb2 import (
CreateClientRequest,
GetClientRequest,
ListClientsRequest,
ListClientsResponse,
)
from .service_pb2_grpc import ClientServiceStub


def _create_clientservice_stub(channel):
    """Factory function to create ClientServiceStub from gRPC channel."""
    return ClientServiceStub(channel)


class ClientService(BaseGRPCClient):
    """ClientService gRPC service with authentication, timeouts, and resource management.

    This service provides a complete implementation of the ClientService with proper authentication, timeout handling, and automatic resource cleanup.

    Full Service documentation: https://meshtrade.github.io/api/docs/api-reference/compliance/client/v1

    Basic service usage with default SDK Configuration:
    ```python
    service = ClientService()

    with service:   # `with` ensures proper clean up of underlying connection after use
        response = service.get_api_user(request)
    ```
        
    With default configuration API credentials are searched for using the standard discovery hierarchy:
    
    1. MESH_API_CREDENTIALS environment variable
    
    2. Default credential file location:
    
    - Linux:   `$XDG_CONFIG_HOME/mesh/credentials.json` or fallback to `$HOME/.config/mesh/credentials.json`
    - macOS:   `$HOME/Library/Application Support/mesh/credentials.json`
    - Windows: `C:\\Users\\<user>\\AppData\\Roaming\\mesh\\credentials.json`
    
    For more information on authentication: https://meshtrade.github.io/api/docs/architecture/authentication

    The service may also be configured with custom options:
    ```python
    from .service_options_meshpy import ServiceOptions
    from datetime import timedelta

    options = ServiceOptions(
        url="api.staging.example.com",
        port=443,
        api_key="your-api-key",
        group="groups/your-group-id",
        timeout=timedelta(seconds=60)
    )

    service = ClientService(options)

    with service: # `with` ensures proper clean up of underlying connection after use
        response = service.get_api_user(request)
    ```

    For more information on service configuration: https://meshtrade.github.io/api/docs/architecture/sdk-configuration
    """

    def __init__(self, options: Optional[ServiceOptions] = None):
        """Construct and initialize the ClientService service.

        Full Service documentation: https://meshtrade.github.io/api/docs/api-reference/compliance/client/v1

        Args:
            options: Optional ServiceOptions for configuring the service.
                    If None, service is constructed with default configuration.
                    With default configuration API credentials are searched for using the standard discovery hierarchy:
                    
                    1. MESH_API_CREDENTIALS environment variable
                    
                    2. Default credential file location:
                    
                    - Linux:   `$XDG_CONFIG_HOME/mesh/credentials.json` or fallback to `$HOME/.config/mesh/credentials.json`
                    - macOS:   `$HOME/Library/Application Support/mesh/credentials.json`
                    - Windows: `C:\\Users\\<user>\\AppData\\Roaming\\mesh\\credentials.json`      

                    For more information on authentication: https://meshtrade.github.io/api/docs/architecture/authentication

                    For more information on service configuration: https://meshtrade.github.io/api/docs/architecture/sdk-configuration            

        Example:
        ```python
        # construct with default configuration
        service = ClientService()

        # construct with custom configuration
        options = ServiceOptions(
            url="api.example.com",
            api_key="your-key",
            group="groups/your-group"
        )
        service = ClientService(options)
        ```
        """
        if options is None:
            options = ServiceOptions()

        # Initialize the base client with all common functionality
        super().__init__(
            service_name="ClientService",
            stub_factory=_create_clientservice_stub,
            find_credentials_func=find_credentials,
            url=options.url,
            port=options.port,
            api_key=options.api_key,
            group=options.group,
            timeout=options.timeout,
            tls=options.tls,
        )

    def create_client(self, request: CreateClientRequest, timeout: Optional[timedelta] = None) -> Client:
        """CreateClient method.

        Args:
            request: The CreateClient request message
            timeout: Optional timeout override for this call

        Returns:
            The CreateClient response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("CreateClient", request, timeout)

    def get_client(self, request: GetClientRequest, timeout: Optional[timedelta] = None) -> Client:
        """GetClient method.

        Args:
            request: The GetClient request message
            timeout: Optional timeout override for this call

        Returns:
            The GetClient response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("GetClient", request, timeout)

    def list_clients(self, request: ListClientsRequest, timeout: Optional[timedelta] = None) -> ListClientsResponse:
        """ListClients method.

        Args:
            request: The ListClients request message
            timeout: Optional timeout override for this call

        Returns:
            The ListClients response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("ListClients", request, timeout)


# Create aliases to match expected exports
ClientServiceGRPCClient = ClientService
ClientServiceGRPCClientInterface = ClientService
