# Code generated by protoc-gen-meshpy. DO NOT EDIT.
# source: meshtrade/iam/api_user/v1/service.proto

"""
ApiUserService gRPC service wrapper with authentication, timeouts, and resource management.

This module provides a high-level gRPC service for the ApiUserService service that combines
the service interface with resource management capabilities, providing authentication,
timeouts, and proper connection handling.
"""

from datetime import timedelta
from typing import Optional

from meshtrade.common import BaseGRPCClient
from .api_credentials import find_credentials

from .api_user_pb2 import APIUser
from meshtrade.common.service_options import ServiceOptions
from .service_pb2 import (
ActivateApiUserRequest,
AssignRoleToAPIUserRequest,
CreateApiUserRequest,
DeactivateApiUserRequest,
GetApiUserByKeyHashRequest,
GetApiUserRequest,
ListApiUsersRequest,
ListApiUsersResponse,
RevokeRoleFromAPIUserRequest,
SearchApiUsersRequest,
SearchApiUsersResponse,
)
from .service_pb2_grpc import ApiUserServiceStub


def _create_apiuserservice_stub(channel):
    """Factory function to create ApiUserServiceStub from gRPC channel."""
    return ApiUserServiceStub(channel)


class ApiUserService(BaseGRPCClient):
    """ApiUserService gRPC service with authentication, timeouts, and resource management.

    This service provides a complete implementation of the ApiUserService with proper authentication, timeout handling, and automatic resource cleanup.

    Full Service documentation: https://meshtrade.github.io/api/docs/api-reference/iam/api_user/v1

    Basic service usage with default SDK Configuration:
    ```python
    service = ApiUserService()

    with service:   # `with` ensures proper clean up of underlying connection after use
        response = service.get_api_user(request)
    ```
        
    With default configuration API credentials are searched for using the standard discovery hierarchy:
    
    1. MESH_API_CREDENTIALS environment variable
    
    2. Default credential file location:
    
    - Linux:   `$XDG_CONFIG_HOME/mesh/credentials.json` or fallback to `$HOME/.config/mesh/credentials.json`
    - macOS:   `$HOME/Library/Application Support/mesh/credentials.json`
    - Windows: `C:\\Users\\<user>\\AppData\\Roaming\\mesh\\credentials.json`
    
    For more information on authentication: https://meshtrade.github.io/api/docs/architecture/authentication

    The service may also be configured with custom options:
    ```python
    from .service_options_meshpy import ServiceOptions
    from datetime import timedelta

    options = ServiceOptions(
        url="api.staging.example.com",
        port=443,
        api_key="your-api-key",
        group="groups/your-group-id",
        timeout=timedelta(seconds=60)
    )

    service = ApiUserService(options)

    with service: # `with` ensures proper clean up of underlying connection after use
        response = service.get_api_user(request)
    ```

    For more information on service configuration: https://meshtrade.github.io/api/docs/architecture/sdk-configuration
    """

    def __init__(self, options: Optional[ServiceOptions] = None):
        """Construct and initialize the ApiUserService service.

        Full Service documentation: https://meshtrade.github.io/api/docs/api-reference/iam/api_user/v1

        Args:
            options: Optional ServiceOptions for configuring the service.
                    If None, service is constructed with default configuration.
                    With default configuration API credentials are searched for using the standard discovery hierarchy:
                    
                    1. MESH_API_CREDENTIALS environment variable
                    
                    2. Default credential file location:
                    
                    - Linux:   `$XDG_CONFIG_HOME/mesh/credentials.json` or fallback to `$HOME/.config/mesh/credentials.json`
                    - macOS:   `$HOME/Library/Application Support/mesh/credentials.json`
                    - Windows: `C:\\Users\\<user>\\AppData\\Roaming\\mesh\\credentials.json`      

                    For more information on authentication: https://meshtrade.github.io/api/docs/architecture/authentication

                    For more information on service configuration: https://meshtrade.github.io/api/docs/architecture/sdk-configuration            

        Example:
        ```python
        # construct with default configuration
        service = ApiUserService()

        # construct with custom configuration
        options = ServiceOptions(
            url="api.example.com",
            api_key="your-key",
            group="groups/your-group"
        )
        service = ApiUserService(options)
        ```
        """
        if options is None:
            options = ServiceOptions()

        # Initialize the base client with all common functionality
        super().__init__(
            service_name="ApiUserService",
            stub_factory=_create_apiuserservice_stub,
            find_credentials_func=find_credentials,
            url=options.url,
            port=options.port,
            api_key=options.api_key,
            group=options.group,
            timeout=options.timeout,
            tls=options.tls,
        )

    def get_api_user(self, request: GetApiUserRequest, timeout: Optional[timedelta] = None) -> APIUser:
        """GetApiUser method.

        Args:
            request: The GetApiUser request message
            timeout: Optional timeout override for this call

        Returns:
            The GetApiUser response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("GetApiUser", request, timeout)

    def create_api_user(self, request: CreateApiUserRequest, timeout: Optional[timedelta] = None) -> APIUser:
        """CreateApiUser method.

        Args:
            request: The CreateApiUser request message
            timeout: Optional timeout override for this call

        Returns:
            The CreateApiUser response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("CreateApiUser", request, timeout)

    def assign_role_to_apiuser(self, request: AssignRoleToAPIUserRequest, timeout: Optional[timedelta] = None) -> APIUser:
        """AssignRoleToAPIUser method.

        Args:
            request: The AssignRoleToAPIUser request message
            timeout: Optional timeout override for this call

        Returns:
            The AssignRoleToAPIUser response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("AssignRoleToAPIUser", request, timeout)

    def revoke_role_from_apiuser(self, request: RevokeRoleFromAPIUserRequest, timeout: Optional[timedelta] = None) -> APIUser:
        """RevokeRoleFromAPIUser method.

        Args:
            request: The RevokeRoleFromAPIUser request message
            timeout: Optional timeout override for this call

        Returns:
            The RevokeRoleFromAPIUser response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("RevokeRoleFromAPIUser", request, timeout)

    def list_api_users(self, request: ListApiUsersRequest, timeout: Optional[timedelta] = None) -> ListApiUsersResponse:
        """ListApiUsers method.

        Args:
            request: The ListApiUsers request message
            timeout: Optional timeout override for this call

        Returns:
            The ListApiUsers response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("ListApiUsers", request, timeout)

    def search_api_users(self, request: SearchApiUsersRequest, timeout: Optional[timedelta] = None) -> SearchApiUsersResponse:
        """SearchApiUsers method.

        Args:
            request: The SearchApiUsers request message
            timeout: Optional timeout override for this call

        Returns:
            The SearchApiUsers response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("SearchApiUsers", request, timeout)

    def activate_api_user(self, request: ActivateApiUserRequest, timeout: Optional[timedelta] = None) -> APIUser:
        """ActivateApiUser method.

        Args:
            request: The ActivateApiUser request message
            timeout: Optional timeout override for this call

        Returns:
            The ActivateApiUser response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("ActivateApiUser", request, timeout)

    def deactivate_api_user(self, request: DeactivateApiUserRequest, timeout: Optional[timedelta] = None) -> APIUser:
        """DeactivateApiUser method.

        Args:
            request: The DeactivateApiUser request message
            timeout: Optional timeout override for this call

        Returns:
            The DeactivateApiUser response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("DeactivateApiUser", request, timeout)

    def get_api_user_by_key_hash(self, request: GetApiUserByKeyHashRequest, timeout: Optional[timedelta] = None) -> APIUser:
        """GetApiUserByKeyHash method.

        Args:
            request: The GetApiUserByKeyHash request message
            timeout: Optional timeout override for this call

        Returns:
            The GetApiUserByKeyHash response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("GetApiUserByKeyHash", request, timeout)


# Create aliases to match expected exports
ApiUserServiceGRPCClient = ApiUserService
ApiUserServiceGRPCClientInterface = ApiUserService
