# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from meshtrade.iam.api_user.v1 import api_user_pb2 as meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2
from meshtrade.iam.api_user.v1 import service_pb2 as meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2


class ApiUserServiceStub(object):
    """
    ApiUserService manages API user lifecycle and authentication credentials.

    API users represent automated clients that can authenticate with API keys
    and perform operations within a specific group context. Each API user has:
    - A unique identifier and display name
    - Group ownership for resource isolation
    - Role-based permissions for authorization
    - Active/inactive state for access control

    All operations require IAM domain permissions and operate within
    the authenticated group context.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetApiUser = channel.unary_unary(
                '/meshtrade.iam.api_user.v1.ApiUserService/GetApiUser',
                request_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.GetApiUserRequest.SerializeToString,
                response_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
                _registered_method=True)
        self.CreateApiUser = channel.unary_unary(
                '/meshtrade.iam.api_user.v1.ApiUserService/CreateApiUser',
                request_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.CreateApiUserRequest.SerializeToString,
                response_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
                _registered_method=True)
        self.AssignRoleToAPIUser = channel.unary_unary(
                '/meshtrade.iam.api_user.v1.ApiUserService/AssignRoleToAPIUser',
                request_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.AssignRoleToAPIUserRequest.SerializeToString,
                response_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
                _registered_method=True)
        self.RevokeRoleFromAPIUser = channel.unary_unary(
                '/meshtrade.iam.api_user.v1.ApiUserService/RevokeRoleFromAPIUser',
                request_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.RevokeRoleFromAPIUserRequest.SerializeToString,
                response_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
                _registered_method=True)
        self.ListApiUsers = channel.unary_unary(
                '/meshtrade.iam.api_user.v1.ApiUserService/ListApiUsers',
                request_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.ListApiUsersRequest.SerializeToString,
                response_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.ListApiUsersResponse.FromString,
                _registered_method=True)
        self.SearchApiUsers = channel.unary_unary(
                '/meshtrade.iam.api_user.v1.ApiUserService/SearchApiUsers',
                request_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.SearchApiUsersRequest.SerializeToString,
                response_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.SearchApiUsersResponse.FromString,
                _registered_method=True)
        self.ActivateApiUser = channel.unary_unary(
                '/meshtrade.iam.api_user.v1.ApiUserService/ActivateApiUser',
                request_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.ActivateApiUserRequest.SerializeToString,
                response_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
                _registered_method=True)
        self.DeactivateApiUser = channel.unary_unary(
                '/meshtrade.iam.api_user.v1.ApiUserService/DeactivateApiUser',
                request_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.DeactivateApiUserRequest.SerializeToString,
                response_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
                _registered_method=True)
        self.GetApiUserByKeyHash = channel.unary_unary(
                '/meshtrade.iam.api_user.v1.ApiUserService/GetApiUserByKeyHash',
                request_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.GetApiUserByKeyHashRequest.SerializeToString,
                response_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
                _registered_method=True)


class ApiUserServiceServicer(object):
    """
    ApiUserService manages API user lifecycle and authentication credentials.

    API users represent automated clients that can authenticate with API keys
    and perform operations within a specific group context. Each API user has:
    - A unique identifier and display name
    - Group ownership for resource isolation
    - Role-based permissions for authorization
    - Active/inactive state for access control

    All operations require IAM domain permissions and operate within
    the authenticated group context.
    """

    def GetApiUser(self, request, context):
        """
        Retrieves a single API user by its unique identifier.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateApiUser(self, request, context):
        """
        Creates a new API user with the specified configuration.

        The API user will be created in the authenticated group context
        and assigned the provided roles. The system generates a unique
        identifier and API key for authentication.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def AssignRoleToAPIUser(self, request, context):
        """
        Assigns a role to an existing api user within the authenticated group context.

        The role assignment enables the api user to perform operations according
        to the permissions associated with that role within the group hierarchy.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RevokeRoleFromAPIUser(self, request, context):
        """
        Revokes a role from an existing API user within the authenticated group context.

        The role revocation removes the permissions associated with that role from
        the API user within the group hierarchy. The API user will no longer be able
        to perform operations that require the revoked role.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListApiUsers(self, request, context):
        """
        Lists all API users in the authenticated group context.

        Returns all API users that belong to the current group,
        regardless of their active/inactive state.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def SearchApiUsers(self, request, context):
        """
        Searches API users using display name filtering.

        Performs substring matching on API user display names
        within the authenticated group context.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ActivateApiUser(self, request, context):
        """
        Activates an API user, enabling API key authentication.

        Changes the API user state to active, allowing the associated
        API key to be used for authentication and authorization.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeactivateApiUser(self, request, context):
        """
        Deactivates an API user, disabling API key authentication.

        Changes the API user state to inactive, preventing the associated
        API key from being used for authentication.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetApiUserByKeyHash(self, request, context):
        """
        Retrieves an API user using its API key hash.

        This method is used for authentication flows to lookup
        an API user based on the hash of their API key.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ApiUserServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetApiUser': grpc.unary_unary_rpc_method_handler(
                    servicer.GetApiUser,
                    request_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.GetApiUserRequest.FromString,
                    response_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.SerializeToString,
            ),
            'CreateApiUser': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateApiUser,
                    request_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.CreateApiUserRequest.FromString,
                    response_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.SerializeToString,
            ),
            'AssignRoleToAPIUser': grpc.unary_unary_rpc_method_handler(
                    servicer.AssignRoleToAPIUser,
                    request_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.AssignRoleToAPIUserRequest.FromString,
                    response_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.SerializeToString,
            ),
            'RevokeRoleFromAPIUser': grpc.unary_unary_rpc_method_handler(
                    servicer.RevokeRoleFromAPIUser,
                    request_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.RevokeRoleFromAPIUserRequest.FromString,
                    response_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.SerializeToString,
            ),
            'ListApiUsers': grpc.unary_unary_rpc_method_handler(
                    servicer.ListApiUsers,
                    request_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.ListApiUsersRequest.FromString,
                    response_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.ListApiUsersResponse.SerializeToString,
            ),
            'SearchApiUsers': grpc.unary_unary_rpc_method_handler(
                    servicer.SearchApiUsers,
                    request_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.SearchApiUsersRequest.FromString,
                    response_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.SearchApiUsersResponse.SerializeToString,
            ),
            'ActivateApiUser': grpc.unary_unary_rpc_method_handler(
                    servicer.ActivateApiUser,
                    request_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.ActivateApiUserRequest.FromString,
                    response_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.SerializeToString,
            ),
            'DeactivateApiUser': grpc.unary_unary_rpc_method_handler(
                    servicer.DeactivateApiUser,
                    request_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.DeactivateApiUserRequest.FromString,
                    response_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.SerializeToString,
            ),
            'GetApiUserByKeyHash': grpc.unary_unary_rpc_method_handler(
                    servicer.GetApiUserByKeyHash,
                    request_deserializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.GetApiUserByKeyHashRequest.FromString,
                    response_serializer=meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'meshtrade.iam.api_user.v1.ApiUserService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('meshtrade.iam.api_user.v1.ApiUserService', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class ApiUserService(object):
    """
    ApiUserService manages API user lifecycle and authentication credentials.

    API users represent automated clients that can authenticate with API keys
    and perform operations within a specific group context. Each API user has:
    - A unique identifier and display name
    - Group ownership for resource isolation
    - Role-based permissions for authorization
    - Active/inactive state for access control

    All operations require IAM domain permissions and operate within
    the authenticated group context.
    """

    @staticmethod
    def GetApiUser(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.iam.api_user.v1.ApiUserService/GetApiUser',
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.GetApiUserRequest.SerializeToString,
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CreateApiUser(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.iam.api_user.v1.ApiUserService/CreateApiUser',
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.CreateApiUserRequest.SerializeToString,
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def AssignRoleToAPIUser(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.iam.api_user.v1.ApiUserService/AssignRoleToAPIUser',
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.AssignRoleToAPIUserRequest.SerializeToString,
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RevokeRoleFromAPIUser(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.iam.api_user.v1.ApiUserService/RevokeRoleFromAPIUser',
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.RevokeRoleFromAPIUserRequest.SerializeToString,
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListApiUsers(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.iam.api_user.v1.ApiUserService/ListApiUsers',
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.ListApiUsersRequest.SerializeToString,
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.ListApiUsersResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def SearchApiUsers(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.iam.api_user.v1.ApiUserService/SearchApiUsers',
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.SearchApiUsersRequest.SerializeToString,
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.SearchApiUsersResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ActivateApiUser(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.iam.api_user.v1.ApiUserService/ActivateApiUser',
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.ActivateApiUserRequest.SerializeToString,
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def DeactivateApiUser(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.iam.api_user.v1.ApiUserService/DeactivateApiUser',
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.DeactivateApiUserRequest.SerializeToString,
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetApiUserByKeyHash(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/meshtrade.iam.api_user.v1.ApiUserService/GetApiUserByKeyHash',
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_service__pb2.GetApiUserByKeyHashRequest.SerializeToString,
            meshtrade_dot_iam_dot_api__user_dot_v1_dot_api__user__pb2.APIUser.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
