# Code generated by protoc-gen-meshpy. DO NOT EDIT.
# source: meshtrade/iam/group/v1/service.proto

"""
GroupService gRPC service wrapper with authentication, timeouts, and resource management.

This module provides a high-level gRPC service for the GroupService service that combines
the service interface with resource management capabilities, providing authentication,
timeouts, and proper connection handling.
"""

from datetime import timedelta
from typing import Optional

from meshtrade.common import BaseGRPCClient
from meshtrade.iam.api_user.v1.api_credentials import find_credentials

from .group_pb2 import Group
from meshtrade.common.service_options import ServiceOptions
from .service_pb2 import (
CreateGroupRequest,
GetGroupRequest,
ListGroupsRequest,
ListGroupsResponse,
SearchGroupsRequest,
SearchGroupsResponse,
UpdateGroupRequest,
)
from .service_pb2_grpc import GroupServiceStub


def _create_groupservice_stub(channel):
    """Factory function to create GroupServiceStub from gRPC channel."""
    return GroupServiceStub(channel)


class GroupService(BaseGRPCClient):
    """GroupService gRPC service with authentication, timeouts, and resource management.

    This service provides a complete implementation of the GroupService with proper authentication, timeout handling, and automatic resource cleanup.

    Full Service documentation: https://meshtrade.github.io/api/docs/api-reference/iam/group/v1

    Basic service usage with default SDK Configuration:
    ```python
    service = GroupService()

    with service:   # `with` ensures proper clean up of underlying connection after use
        response = service.get_api_user(request)
    ```
        
    With default configuration API credentials are searched for using the standard discovery hierarchy:
    
    1. MESH_API_CREDENTIALS environment variable
    
    2. Default credential file location:
    
    - Linux:   `$XDG_CONFIG_HOME/mesh/credentials.json` or fallback to `$HOME/.config/mesh/credentials.json`
    - macOS:   `$HOME/Library/Application Support/mesh/credentials.json`
    - Windows: `C:\\Users\\<user>\\AppData\\Roaming\\mesh\\credentials.json`
    
    For more information on authentication: https://meshtrade.github.io/api/docs/architecture/authentication

    The service may also be configured with custom options:
    ```python
    from .service_options_meshpy import ServiceOptions
    from datetime import timedelta

    options = ServiceOptions(
        url="api.staging.example.com",
        port=443,
        api_key="your-api-key",
        group="groups/your-group-id",
        timeout=timedelta(seconds=60)
    )

    service = GroupService(options)

    with service: # `with` ensures proper clean up of underlying connection after use
        response = service.get_api_user(request)
    ```

    For more information on service configuration: https://meshtrade.github.io/api/docs/architecture/sdk-configuration
    """

    def __init__(self, options: Optional[ServiceOptions] = None):
        """Construct and initialize the GroupService service.

        Full Service documentation: https://meshtrade.github.io/api/docs/api-reference/iam/group/v1

        Args:
            options: Optional ServiceOptions for configuring the service.
                    If None, service is constructed with default configuration.
                    With default configuration API credentials are searched for using the standard discovery hierarchy:
                    
                    1. MESH_API_CREDENTIALS environment variable
                    
                    2. Default credential file location:
                    
                    - Linux:   `$XDG_CONFIG_HOME/mesh/credentials.json` or fallback to `$HOME/.config/mesh/credentials.json`
                    - macOS:   `$HOME/Library/Application Support/mesh/credentials.json`
                    - Windows: `C:\\Users\\<user>\\AppData\\Roaming\\mesh\\credentials.json`      

                    For more information on authentication: https://meshtrade.github.io/api/docs/architecture/authentication

                    For more information on service configuration: https://meshtrade.github.io/api/docs/architecture/sdk-configuration            

        Example:
        ```python
        # construct with default configuration
        service = GroupService()

        # construct with custom configuration
        options = ServiceOptions(
            url="api.example.com",
            api_key="your-key",
            group="groups/your-group"
        )
        service = GroupService(options)
        ```
        """
        if options is None:
            options = ServiceOptions()

        # Initialize the base client with all common functionality
        super().__init__(
            service_name="GroupService",
            stub_factory=_create_groupservice_stub,
            find_credentials_func=find_credentials,
            url=options.url,
            port=options.port,
            api_key=options.api_key,
            group=options.group,
            timeout=options.timeout,
            tls=options.tls,
        )

    def create_group(self, request: CreateGroupRequest, timeout: Optional[timedelta] = None) -> Group:
        """CreateGroup method.

        Args:
            request: The CreateGroup request message
            timeout: Optional timeout override for this call

        Returns:
            The CreateGroup response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("CreateGroup", request, timeout)

    def update_group(self, request: UpdateGroupRequest, timeout: Optional[timedelta] = None) -> Group:
        """UpdateGroup method.

        Args:
            request: The UpdateGroup request message
            timeout: Optional timeout override for this call

        Returns:
            The UpdateGroup response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("UpdateGroup", request, timeout)

    def list_groups(self, request: ListGroupsRequest, timeout: Optional[timedelta] = None) -> ListGroupsResponse:
        """ListGroups method.

        Args:
            request: The ListGroups request message
            timeout: Optional timeout override for this call

        Returns:
            The ListGroups response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("ListGroups", request, timeout)

    def search_groups(self, request: SearchGroupsRequest, timeout: Optional[timedelta] = None) -> SearchGroupsResponse:
        """SearchGroups method.

        Args:
            request: The SearchGroups request message
            timeout: Optional timeout override for this call

        Returns:
            The SearchGroups response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("SearchGroups", request, timeout)

    def get_group(self, request: GetGroupRequest, timeout: Optional[timedelta] = None) -> Group:
        """GetGroup method.

        Args:
            request: The GetGroup request message
            timeout: Optional timeout override for this call

        Returns:
            The GetGroup response message

        Raises:
            grpc.RpcError: If the gRPC call fails
            ValueError: If authentication credentials are missing
        """
        return self._execute_method("GetGroup", request, timeout)


# Create aliases to match expected exports
GroupServiceGRPCClient = GroupService
GroupServiceGRPCClientInterface = GroupService
